# Frontend Roadmap

## Introduction

### What is front end developer

- [What is a frontend developer? - frontendmasters.com](https://frontendmasters.com/guides/front-end-handbook/2018/what-is-a-FD.html)
- [Frontend web developer - Mozilla Developer docs](https://developer.mozilla.org/en-US/docs/Learn/Front-end_web_developer)
- [What is frontend development - Freecodecamp](https://www.freecodecamp.org/news/front-end-developer-what-is-front-end-development-explained-in-plain-english/)

### What is frontend web development

- [Frontend Development explained - Mayuko(Youtube)](https://www.youtube.com/watch?v=qyHyFsT7Hig)
- [Frontend web development - Wikipedia](https://en.wikipedia.org/wiki/Front-end_web_development)

## Understanding Internet

### How does internet work

- [Computer Networking course - Kunal Kushwaha(Youtube)](https://www.youtube.com/watch?v=IPvYjXCsTg8)
- [How the Internet Travel Across Oceans? - TechVision(Youtube)](https://www.youtube.com/watch?v=yd1JhZzoS6A)
- [How does the Internet Work? - Vox(Youtube)](https://www.youtube.com/watch?v=TNQsmPf24go)
- [How does the Internet Work? - Mozilla web docs](https://developer.mozilla.org/en-US/docs/Learn/Common_questions/How_does_the_Internet_work)
- [How Does the Internet Work? - Stanford.edu](https://web.stanford.edu/class/msande91si/www-spr04/readings/week1/InternetWhitepaper.htm)
- [How Does the Internet Work? - cloudflare](https://www.cloudflare.com/en-in/learning/network-layer/how-does-the-internet-work/)
- [How Does the Internet Work? - Lesics(Youtube)](https://www.youtube.com/watch?v=x3c1ih2NJEg)
- [What is DNS? | How DNS works](https://www.cloudflare.com/en-gb/learning/dns/what-is-dns/)

### Internet-CS50's understanding technology

- [Resource](https://www.youtube.com/watch?v=n_KghQP86Sw)

## Learning HTML

### HTML Tutorial

- [Learn HTML - FreeCodeCamp(Youtube)](https://www.youtube.com/watch?v=kUMe1FH4CHE)
- [Learn HTML - Codecademy](https://www.codecademy.com/learn/learn-html)
- [Learn HTML](https://web.dev/learn/html/)
- [HTML Tutorial - W3schools](https://www.w3schools.com/html/)
- [HTML Tutorial - TutorialsPoint](https://www.tutorialspoint.com/html/index.htm)
- [HTML course, build a website - FreeCodeCamp(Youtube)](https://www.youtube.com/watch?v=pQN-pnXPaVg)
- [HTML crash course - Traversy Media(Youtube)](https://www.youtube.com/watch?v=UB1O30fR-EE)
- [HTML Tutorial, making a Website - FreeCodeCamp(Youtube)](https://www.youtube.com/watch?v=PlxWf493en4)
- [Semantics - MDN Web Docs Glossary: Definitions of Web-related terms | MDN](https://developer.mozilla.org/en-US/docs/Glossary/Semantics)
- [Basics of SEO](https://github.com/seo/guide)
- [HTML best practices ](https://github.com/hail2u/html-best-practices)
- [Learn HTML from Google ](https://web.dev/learn/html/)

### Frontend Projects

- [frontendeval.com](https://www.frontendeval.com)
- [frontendmentor.io](https://www.frontendmentor.io/)
- [frontendpractice.com](https://www.frontendpractice.com/)
- [iCodeThis.com](https://www.icodethis.com/)

## Learning CSS

### CSS Tutorials

- [Learn CSS - web.dev](https://web.dev/learn/css/)
- [Learn CSS - codecademy](https://www.codecademy.com/learn/learn-css)
- [CSS tutorial -w3schools](https://www.w3schools.com/css/)
- [CSS zero to hero - FreeCodeCamp(Youtube)](https://www.youtube.com/watch?v=1Rs2ND1ryYc)
- [Kevin Powell(Youtube)](https://www.youtube.com/kepowob)
- [Introduction to CSS - Web Dev Simplified](https://www.youtube.com/playlist?list=PLZlA0Gpn_vH9D0J0Mtp6lIiD_8046k3si)
- [The guide to responsive web design](https://webflow.com/blog/responsive-web-design)
- [Learn flexbox by gaming](https://flexboxfroggy.com/)
- [Learn Grid by gaming](https://cssgridgarden.com/)
- [Learn Hex Code by gaming](http://www.hexinvaders.com/)
- [CSS Diner](https://flukeout.github.io/)
- [A complete guide to Flexbox](https://css-tricks.com/snippets/css/a-guide-to-flexbox/)
- [A complete guide to CSS Grid](https://css-tricks.com/snippets/css/complete-guide-grid/)
- [A complete guide to CSS from Mozilla](https://developer.mozilla.org/en-US/docs/Learn/Getting_started_with_the_web/CSS_basics)
- [Learn CSS from Google](https://web.dev/learn/css/)

### Frontend Projects

- [frontendmentor.io](https://www.frontendmentor.io/)
- [frontendpractice.com](https://www.frontendpractice.com/)
- [iCodeThis.com](https://www.icodethis.com/)

## Learning Javascript

### JS Tutorials

- [Learn JavaScript - FreeCodeCamp(Youtube)](https://www.youtube.com/watch?v=PkZNo7MFNFg)
- [JavaScript Tutorial - Programming with Mosh(Youtube)](https://www.youtube.com/watch?v=W6NZfCO5SIk)
- [JavaScript Programming - FreeCodeCamp(Youtube)](https://www.youtube.com/watch?v=jS4aFq5-91M)
- [JavaScript Tutorial - w3schools](https://www.w3schools.com/js/)
- [Learn JavaScript - Codecademy](https://www.codecademy.com/learn/introduction-to-javascript)
- [Learn DOM manipulation](https://www.youtube.com/watch?v=5fb2aPlgoys)
- [Free JS Courses for Beginners - FreeCodeCamp](https://www.freecodecamp.org/news/learn-javascript-free-js-courses-for-beginners/)
- [Free JS Practice website to master JS - exercism](https://exercism.org/)
- [Free JS repository to practice JS - 30-Days-Of-JavaScript](https://github.com/Asabeneh/30-Days-Of-JavaScript)
- [Learn JavaScript - JavaScriptInfo](https://javascript.info/)
- [Elevator Saga Game](http://play.elevatorsaga.com/)
- [Codingame](https://www.codingame.com/start)
- [Geonsanddeveloper](http://www.dungeonsanddevelopers.com/)
- [Namaste Javascript - Youtube](https://www.youtube.com/watch?v=pN6jk0uUrD8&list=PLlasXeu85E9cQ32gLCvAvr9vNaUccPVNP)
- [Learn By reading blogs](https://nikk.hashnode.dev/series/javascript-series)

### Understanding JavaScript

- [NamasteJS/How JS works - Akshay Saini](https://www.youtube.com/playlist?list=PLlasXeu85E9cQ32gLCvAvr9vNaUccPVNP)

### Frontend Projects

- [frontendmentor.io](https://www.frontendmentor.io/)
- [frontendpractice.com](https://www.frontendpractice.com/)
- [iCodeThis.com](https://www.icodethis.com/)

## Learning Version Control

- [Git Documentation](https://git-scm.com/docs/gittutorial)
- [Git Tutorial](https://www.youtube.com/watch?v=apGV9Kg7ics)

## Understanding Package Managers

- [What is NPM & why do we need it?](https://www.youtube.com/watch?v=P3aKRdUyr0s)
- [NPM crash course](https://www.youtube.com/watch?v=jHDhaSSKmB0)
- [Yarn package manager crash course](https://www.youtube.com/watch?v=g9_6KmiBISk)
- [Learn Package Manager](https://frontendmasters.com/guides/front-end-handbook/2018/learning/package-manager.html)
- [Javascript Package manager](https://www.freecodecamp.org/news/javascript-package-manager-npm-and-yarn/)
- [Learn Node.JS](https://www.youtube.com/watch?v=RLtyhwFtXQA)
- [Package management basics](https://developer.mozilla.org/en-US/docs/Learn/Tools_and_testing/Understanding_client-side_tools/Package_management)

## Learn Build Tools

- [What are build tools?](https://www.youtube.com/watch?v=V5qvWl-O-zE)
- [6 best build tools](https://www.developerdrive.com/best-build-tools-frontend-development/)
- [Learn build tools?](https://www.codecademy.com/learn/learn-build-tools)
- [Freecodecamp](https://www.freecodecamp.org/news/making-sense-of-front-end-build-tools-3a1b3a87043b/)

## Let's pick a framework/library for you

- [Frameworks-Web Development](https://www.youtube.com/watch?v=W6KCPXl6Zuc)

### React

- [React Tutorial-Freecodecamp(Youtube)](https://www.youtube.com/watch?v=bMknfKXIFA8)
- [React Tutorial-JavaScript Mastery(Youtube)](https://youtu.be/dyFVwXROzZk)
- [React Tutorial-Tapas Adhikary(Youtube)](https://www.youtube.com/playlist?list=PLIJrr73KDmRyrDnDFy-hHvQ24rRjz6e_J)
- [React Official Docs](https://react.dev/)
- [React Router Tutorial](https://www.youtube.com/playlist?list=PLC3y8-rFHvwjkxt8TOteFdT_YmzwpBlrG)
- [React Redux Tutorials](https://www.youtube.com/playlist?list=PLC3y8-rFHvwheJHvseC3I0HuYI2f46oAK)
- [Free React repository 30-Days-Of-React](https://github.com/Asabeneh/30-Days-Of-React)

### Vue JS

- [Tutorial](https://www.youtube.com/watch?v=FXpIoQ_rT_c)
- [Docs](https://vuejs.org/tutorial/#step-1)

### Angular

- [Angular Tutorial - Programming with Mosh(Youtube)](https://www.youtube.com/watch?v=k5E2AVpwsko)
- [Learn Angular - FreeCodeCamp(Youtube)](https://www.youtube.com/watch?v=2OHbjep_WjQ)
- [Docs](https://angular.io/docs)

### Frontend Projects

- [frontendmentor.io](https://www.frontendmentor.io/)
- [frontendpractice.com](https://www.frontendpractice.com/)

## Meta Frameworks

- [What is meta frameworks](https://www.ombulabs.com/blog/javascript/what-is-a-javascript-meta-framework.html)

### React Meta Frameworks

### Next Js

- [Next Js Tutorial - Codevolution(Youtube)](https://www.youtube.com/watch?v=9P8mASSREYM&list=PLC3y8-rFHvwgC9mj0qv972IO5DmD-H0ZH)
- [Next Js Tutorial - Traversy Media(Youtube)](https://www.youtube.com/watch?v=Y6KDk5iyrYE)
- [Docs](https://nextjs.org/docs)

### Gatsby

- [Gatsby Tutorial - The Net Ninja(Youtube)](https://www.youtube.com/watch?v=Qms4k6y7OgI&list=PL4cUxeGkcC9hw1g77I35ZivVLe8k2nvjB)
- [Docs](https://www.gatsbyjs.com/docs/)

### Remix

- [Remix Tutorial](https://www.youtube.com/watch?v=d_BhzHVV4aQ)
- [Docs](https://remix.run/)

## CSS Frameworks

- [Top CSS Frameworks](https://www.browserstack.com/guide/top-css-frameworks)
- [Tailwind vs MUI vs Bootstrap vs Chakra vs...](https://www.youtube.com/watch?v=CQuTF-bkOgc)

### Bootstrap

- [Tutorial](https://www.youtube.com/watch?v=-qfEOE4vtxE)
- [Docs](https://getbootstrap.com/docs/5.2/getting-started/introduction/)

### Chakra UI

- [Tutorial 1 - Chakra UI for beginners](https://www.chakrauiforbeginners.com/play)
- [Tutorial 2 - Build check out page with chakra UI](https://egghead.io/lessons/react-install-and-setup-chakra-ui-in-a-react-project)
- [Docs](https://chakra-ui.com/getting-started)

### Tailwind CSS

- [Tailwind css crash course - Traversy Media(Youtube)](https://www.youtube.com/watch?v=UBOj6rqRUME)
- [Tailwind crash course - Traversy Media(Youtube)](https://www.youtube.com/watch?v=dFgzHOX84xQ)
- [Docs](https://tailwindcss.com/docs/installation)

## What is PWA(Progressive Web Apps)

- [PWA tutorial - The Net Ninja(Youtube)](https://www.youtube.com/playlist?list=PL4cUxeGkcC9gTxqJBcDmoi5Q2pzDusSL7)
- [Progressive web apps - Mozilla developer docs](https://developer.mozilla.org/en-US/docs/Web/Progressive_web_apps)
- [What are progressive web apps? - Freecodecamp](https://www.freecodecamp.org/news/what-are-progressive-web-apps/)
- [Progressive Web Apps](https://web.dev/progressive-web-apps/)

## Sample projects for practice

- [frontendmentor.io](https://www.frontendmentor.io/)
- [frontendpractice.com](https://www.frontendpractice.com/)

## Level Up Your Web Development

- [Learn Privacy](https://web.dev/learn/privacy/)
- [Learn Accessility](https://web.dev/learn/accessibility/)
