## Flutter Development

## Introduction
- [Introduction to Cross-Platform App Development](https://kotlinlang.org/docs/cross-platform-mobile-development.html#the-most-popular-cross-platform-solutions)
- [Setting up your Development Environment](https://rohitlogs.com/from-zero-to-flutter-setting-up-your-development-environment-and-first-app)

## Introduction to Dart
- [Official dart Documentation](https://dart.dev/overview)
- [Getting started with Dart](https://rohitlogs.com/diving-into-dart-the-foundation-of-flutter-1#heading-creating-your-first-dart-project)
- [Introduction to Dart](https://www.javatpoint.com/flutter-dart-programming)

## Basics of programming with Dart
- [Variables](https://dart.dev/guides/language/language-tour#variables)
- [Built-in types](https://dart.dev/guides/language/coming-from/js-to-dart#built-in-types)
- [Functions](https://www.geeksforgeeks.org/dart-programming-functions/)
- [Operators](https://www.geeksforgeeks.org/operators-in-dart/)
- [Control flow statements](https://dart.dev/guides/language/language-tour#control-flow-statements)


## Object Oriented Programming
- [Understanding Object Oriented Programming](https://rohitlogs.com/discover-the-magic-of-object-oriented-programming-a-beginners-guide-to-oop-mastery)
- [Constructors in Dart](https://www.freecodecamp.org/news/constructors-in-dart/)
- [Playlist to learn Object Oriented Programming](https://www.youtube.com/playlist?list=PL9gnSGHSqcno1G3XjUbwzXHL8_EttOuKk)

## Advanced concepts of Dart
- [Extension Methods](https://dart.dev/guides/language/extension-methods)
- [Asynchronous Programming](https://medium.flutterdevs.com/exploring-asynchronous-programming-in-dart-flutter-25f341af32f)
- [Future, Async and Await](https://dart.dev/codelabs/async-await)
- [Generics](https://dart.academy/generics-in-dart-and-flutter/)

## Widgets
- [Intro to Widgets](https://docs.flutter.dev/development/ui/widgets-intro)
- [Widget Overview](https://www.youtube.com/watch?v=FU2Eeizo95o)
- [Explore the Wide range of Widgets available in Flutter (Just explore and have fun for now)](https://docs.flutter.dev/development/ui/widgets) 
- [Stateless Widgets](https://api.flutter.dev/flutter/widgets/StatelessWidget-class.html)
- [Stateful Widgets](https://api.flutter.dev/flutter/widgets/StatefulWidget-class.html)
- [Tutorial on Stateful widgets](https://www.youtube.com/watch?v=p5dkB3Mrxdo)
- [Inherited Widgets](https://api.flutter.dev/flutter/widgets/InheritedWidget-class.html)
- [Stateless VS Stateful Widgets](https://www.geeksforgeeks.org/flutter-stateful-vs-stateless-widgets/)
- [Flutter Widget Binding](https://api.flutter.dev/flutter/widgets/WidgetsFlutterBinding-class.html)

## State Management
- [Flutter State Management Techniques](https://docs.flutter.dev/data-and-backend/state-mgmt/options)
- [Flutter Riverpod 2.0](https://codewithandrea.com/articles/flutter-state-management-riverpod/)
- [Flutter Bloc Architecture](https://bloclibrary.dev/#/?id=documentation)
- [Flutter State Management Tutorials](https://www.youtube.com/playlist?list=PL6yRaaP0WPkUf-ff1OX99DVSL1cynLHxO)
  
## Design System
- [Material Design System Guidelines By Google](https://m2.material.io/design/guidelines-overview)
- [Material Component Widgets in Flutter](https://docs.flutter.dev/development/ui/widgets/material#Buttons)
- [Cupertino Widgets in Flutter](https://docs.flutter.dev/development/ui/widgets/cupertino)
- [Cupertino Design System for IOS Style](https://blog.logrocket.com/flutter-cupertino-tutorial-build-ios-apps-native/) 
- [Flutter Navigation and Routing - go_router](https://medium.com/@antonio.tioypedro1234/flutter-go-router-the-essential-guide-349ef39ec5b3)
  
## Debugging 
- [Official Flutter Debugging](https://docs.flutter.dev/testing/debugging)
- [Dart DevTools](https://docs.flutter.dev/development/tools/devtools/overview)

## Flutter Essentials
- [Working with assets](https://docs.flutter.dev/development/ui/assets-and-images)
- [Tutorial for Working with assets](https://www.youtube.com/watch?v=Hxh6nNHSUjo)
- [Keys- Why, How and Where?](https://youtu.be/kn0EOS-ZiIc)

## Complete Flutter Course 
- [Flutter Course for Beginners](https://www.youtube.com/watch?v=VPvVD8t02U8)
