# Blockchain

## Introduction
- [What is Web3](https://www.freecodecamp.org/news/what-is-web3/)

## Blockchain Fundamentals
- [What is Blockchain](https://www.geeksforgeeks.org/blockchain-technology-introduction)
- [Distributed Ledger](https://www.geeksforgeeks.org/what-is-blockchain-distributed-ledger)
- [Crypto Basics](https://www.oswego.edu/cts/basics-about-cryptocurrency)
- [Difference between Web1,Web2,Web3](https://www.simplilearn.com/what-is-web-1-0-web-2-0-and-web-3-0-with-their-difference-article)
- [Smart Contracts](https://ethereum.org/en/developers/docs/smart-contracts/)
- [Crypto wallet](https://www.businessinsider.com/personal-finance/crypto-wallet)
- [Block Explorers](https://www.gemini.com/cryptopedia/what-is-a-block-explorer-btc-bch-eth-ltc)
- [Blockchain Layer 1 vs.Layer 2 Scaling Solutions](https://www.gemini.com/cryptopedia/blockchain-layer-2-network-layer-1-network)
- [Oracles](https://chain.link/education/blockchain-oracles)
- [What Are NFTs](https://www.forbes.com/advisor/investing/cryptocurrency/nft-non-fungible-token/)
- [What iS A DAO](https://www.forbes.com/sites/cathyhackl/2021/06/01/what-are-daos-and-why-you-should-pay-attention/?sh=343b04067305)
- [Intro To DAPPS](https://ethereum.org/en/developers/docs/dapps/)
- [EVM and Non-EVM Chains](https://ethereum.org/en/developers/docs/dapps/)
- [Overview of technologies include in Web3](https://remote3.co/blog-post/complete-web3-developer-roadmap-2022)
- [Road to Web3](https://www.web3.university/tracks/road-to-web3)
- [One of the best Web3 Roadmap](https://vitto.cc/web3-and-solidity-smart-contracts-development-roadmap/)

### Additional resources for Blockchain Fundamentals
- [Metaschool: Free cources](https://metaschool.so/courses)
- [Lumos Academy: Learning Platform](https://academy.lumoslabs.co/courses)
- [DeFi Infrastructure(Youtube)](https://www.youtube.com/playlist?list=PLE1Vu6ctbqa61FqJmPDnoPzDqrnyILHRm)

### Choose A Blockchain
- [Ethereum](https://ethereum.org/)
- [Solana](https://solana.com/)

### Ethereum Concepts
- [Accounts](https://ethereum.org/en/developers/docs/accounts/)
- [Transactions](https://ethereum.org/en/developers/docs/transactions)
- Consensus :
  - [1) Proof Of Work](https://www.investopedia.com/terms/p/proof-work.asp)
  - [2) Proof Of Stake](https://www.investopedia.com/terms/p/proof-stake-pos.asp)
  - [3) Proof Of History](https://medium.com/solana-labs/proof-of-history-a-clock-for-blockchain-cf47a61a9274)
- [Ethereum Virtual Machine](https://ethereum.org/en/developers/docs/evm/)
- [Gas](https://ethereum.org/en/developers/docs/gas/)
- Advanced Concepts (Optional):
  - [1)Ethereum Whitepaper](https://ethereum.org/en/whitepaper/)
  - [2) Blockchain Trilemma](https://www.gemini.com/cryptopedia/blockchain-trilemma-decentralization-scalability-definition)
  - [3) Ethereum Trilemma](https://ethereum.org/en/upgrades/vision)
  - [4) Endgame](https://vitalik.ca/general/2021/12/06/endgame.html)
- [Nodes And Clients](https://ethereum.org/en/developers/docs/nodes-and-clients/)
- [Networks, Nodes as a Service](https://ethereum.org/en/developers/docs/networks)
  - [1)Alchemy](https://www.alchemy.com/)
  - [2)Infura](https://infura.io/)
  - [3)Quicknode](https://www.quicknode.com/)

## Layer 2 Solutions
- [Polygon](https://wiki.polygon.technology/)
- [Lightning Network](http://lightning.network/docs/)

## Choose A Language
- [Solidity](https://docs.soliditylang.org/)
- [Vyper](https://vyper.readthedocs.io/en/stable/)
- [Rust(Solana)](https://docs.solana.com/developing/on-chain-programs/developing-rust)

## Solidity
- [Remix IDE](https://remix-project.org/)
- Solidity Tutorials :

- [1)Solidity With Javascript 31 hours Course](https://youtu.be/gyMwXuJrbJQ)
- [2)Solidity With Javascript 10 hours Course](https://youtu.be/cGQHXmCS94M) 
- [3)Solidity Tutorial](https://youtu.be/3g2WT2jms_k)
- [4)Solidity Docs](https://docs.soliditylang.org/en/v0.8.16/)
- [5)Solidity Cheatsheet](https://intellipaat.com/mediaFiles/2019/03/Solidity-Cheat-Sheet.jpg)
- [6)CryptoZombies](https://cryptozombies.io/)


## Use A FrameWork
- [Metamask](https://docs.metamask.io/guide/)
- [VS Code Solidity Extension](https://marketplace.visualstudio.com/items?itemName=JuanBlanco.solidity)
- [Truffle](https://trufflesuite.com/)
- [Hardhat](https://hardhat.org/docs)
- [Foundry](https://getfoundry.sh/)
- [Web3.py](https://web3py.readthedocs.io/)

## Connect Dapp to Frontend
- [Web3.js](https://web3js.readthedocs.io/en/v1.7.5/)
- [Ether.js](https://docs.ethers.io/v5/)
-  Decentralised Storage
   - [1) IPFS](https://docs.ipfs.tech/install/)
   - [2) Arweave](https://docs.arweave.org/info/) 
   - [3) Filecoin](https://docs.filecoin.io/)

## Mid-Level Tools
- Testing Tools
  - [1) Waffle](https://ethereum-waffle.readthedocs.io/en/latest/)   
  - [2) Ganache](https://trufflesuite.com/docs/ganache/) 
-  [Open Zeppelin](https://docs.openzeppelin.com/)
-  [Wallet Connect](https://docs.walletconnect.com/2.0/)
-  [Chain Link](https://docs.chain.link/)
-  [Ceramic Network](https://developers.ceramic.network/learn/welcome/)
-  [The Graph](https://thegraph.com/docs/en/)
-  [Scaffold-Ethereum](https://docs.scaffoldeth.io/scaffold-eth/)
-  [Alchemy Dapp Store](https://www.alchemy.com/dapps)
 
 ### SDKs
- [Third Web](https://portal.thirdweb.com/)
- [Moralis](https://docs.moralis.io/moralis-dapp/getting-started)

## Project Ideas
- Article Format
  - [The Complete Guide to Full Stack Web3 Development](https://dev.to/edge-and-node/the-complete-guide-to-full-stack-web3-development-4g74)
  - [The Complete Guide to Full Stack Ethereum and EVM Development](https://dev.to/dabit3/the-complete-guide-to-full-stack-ethereum-development-3j13) 
  - [Blocktrain.info](https://www.blocktrain.info/project)
  - [Buildspace- Modern Web3 projects](https://buildspace.so/builds)
  - [Build this Apps & EARN](https://www.pointer.gg/tutorials)
  - [80+ Web3 Dapps](https://www.theinsaneapp.com/2022/05/best-web3-projects.html)
- Video Format
  - [Moralis Web3 (Youtube)](https://www.youtube.com/c/MoralisWeb3)
  - [Alchemy (Youtube)](https://www.youtube.com/c/AlchemyPlatform) 
  - [Dapp University (Youtube)](https://www.youtube.com/channel/UCY0xL8V6NzzFcwzHCgB8orQ)
  - [Patrick Collins (Youtube)](https://www.youtube.com/c/patrickcollins)
  - [EatTheBlocks (Youtube)](https://www.youtube.com/@EatTheBlocks)[(Defi Tutorial)](https://youtu.be/z9FgWvUai28)
  - [Austin Griffith](https://www.youtube.com/channel/UC_HI2i2peo1A-STdG22GFsA)
  - [Nader Dabit](https://www.youtube.com/user/boyindasouth)
  - [Harkirat Singh (Youtube)](https://www.youtube.com/playlist?list=PLVKLWop9wWA82pZoyylZD2VF2c7MR8_5I)
  - [Daulat Hussain (Youtube)](https://www.youtube.com/@daulathussain/featured)
