# Backend Roadmap

## Introduction to Backend Development

- [What is Backend Development](https://www.youtube.com/watch?v=cbSrsYiRamo) `Recommended`
- [Introduction to Backend Development](https://dev.to/kaperskyguru/introduction-to-backend-development-506a)
- [Back-end Developer Career Path](https://boot.dev/tracks/backend)
- [How Backend works](https://www.youtube.com/watch?v=4r6WdaY3SOA)
- [Guide to Backend Development](https://www.upwork.com/resources/beginners-guide-back-end-development)

## Basics of Frontend

- [Frontend Developer crash course](https://www.youtube.com/watch?v=QA0XpGhiz5w)
- [CSS](https://www.youtube.com/watch?v=1Rs2ND1ryYc)
- [HTML](https://www.youtube.com/watch?v=kUMe1FH4CHE)

### Build a project

- [frontendpractice.com](https://www.frontendpractice.com/)
- [frontendmentor.io](https://www.frontendmentor.io/)

## Understanding Internet

### How does the internet work

- [Computer Networking course - Kunal Kushwaha(Youtube)](https://www.youtube.com/watch?v=IPvYjXCsTg8)
- How does the Internet Work?
    - [Vox(Youtube)](https://www.youtube.com/watch?v=TNQsmPf24go) `Recommended`
    - [Mozilla web docs](https://developer.mozilla.org/en-US/docs/Learn/Common_questions/How_does_the_Internet_work)
    - [Stanford.edu](https://web.stanford.edu/class/msande91si/www-spr04/readings/week1/InternetWhitepaper.htm)
    - [Cloudflare](https://www.cloudflare.com/en-in/learning/network-layer/how-does-the-internet-work/)
    - [Lesics(Youtube)](https://www.youtube.com/watch?v=x3c1ih2NJEg)
    - [Internet - CS50's understanding technology](https://www.youtube.com/watch?v=n_KghQP86Sw)
- HTTP - HyperText Transfer Protocol
    - [Full HTTP Networking Course - Boot.dev](https://www.youtube.com/watch?v=2JYT5f2isg4) `Recommended`
    - [An overview of HTTP](https://developer.mozilla.org/en-US/docs/Web/HTTP/Overview)
- [How Web Browsers work](https://web.dev/howbrowserswork/)

## Operating System Basics

- [Introduction to operating systems - Jenny's Lectures(Youtube)](https://www.youtube.com/watch?v=RozoeWzT7IM) `Recommended`
- [Operating system basics - Geek's Lesson(Youtube)](https://www.youtube.com/watch?v=6-mdtMKfEYM)
- [How do operating systems work? - ClickView(Youtube)](https://www.youtube.com/watch?v=GjNp0bBrjmU)
- [What is an operating system - Techquickie(Youtube)](https://www.youtube.com/watch?v=pVzRTmdd9j0)
- [Operating system tutorial - Tutorialspoint](<https://www.tutorialspoint.com/operating_system/index.htm#:~:text=An%20Operating%20System%20(OS)%20is%20an%20interface%20between%20a%20computer,as%20disk%20drives%20and%20printers.>)
- [Operating System Tutorial - Lawrence Williams](https://www.guru99.com/os-tutorial.html)

## Linux Terminal Basics

- Complete Course
    - [Complete Linux Course](https://www.youtube.com/watch?v=iwolPf6kN-k) `Recommended`
    - [Introduction to Linux – Full Course for Beginners By FreeCodeCamp](https://youtu.be/sWbUDq4S6Y8)
    - [Linux Masterclass Course - Apoorv Goyal(YouTube)](https://www.youtube.com/playlist?list=PL2kSRH_DmWVZp_cu6MMPWkgYh7GZVFS6i)
    - [Linux Tutorial](https://www.youtube.com/watch?v=cBokz0LTizk)
- Linux Commands
    - [Basic Linux Commands](https://www.youtube.com/watch?v=J2zquYPJbWY) `Recommended`
    - [Linux Command Cheatsheet](https://www.guru99.com/linux-commands-cheat-sheet.html)

## Javascript

### JS Tutorials

- Node.js
    - [Node.js Crash Course - Traversy Media(Youtube)](https://www.youtube.com/watch?v=fBNz5xF-Kx4) `Recommended`
    - [Node.js Documentation](https://nodejs.org/en/docs/)
    - [Node.js tutorial-Programming with Mosh(Youtube)](https://www.youtube.com/watch?v=TlB_eWDSMt4)
    - [Node.js crash course playlist - The Net Ninja(Youtube)](https://www.youtube.com/playlist?list=PL4cUxeGkcC9jsz4LDYc6kv3ymONOKxwBU)
    - [Node.js and express.js course - freecodecamp(Youtube)](https://www.youtube.com/watch?v=Oe421EPjeBE)
- [Express js Getting started](https://expressjs.com/en/starter/installing.html)

## Version Control

- [Git documentation](https://git-scm.com/docs/gittutorial)
- [Git Tutorial](https://www.youtube.com/watch?v=apGV9Kg7ics&t=1964s)

## Relational Databases

- [Learn SQL and Relational Databases](https://boot.dev/learn/learn-sql)
- [What is Relational Databases](https://www.youtube.com/watch?v=OqjJjpjDRLc)

### Postgre SQL

- Tutorials
    - [PostgreSQL Tutorial - freecodecamp(Youtube)](https://www.youtube.com/watch?v=qw--VYLpxG4) `Recommended`
    - [PosgresSQL Course - Amigoscode(Youtube)](https://www.youtube.com/playlist?list=PLwvrYc43l1MxAEOI_KwGe8l42uJxMoKeS)
    - [PosgresSQL Course - DataZ(Youtube)](https://www.youtube.com/watch?v=Ir7nScz_Vs4)
    - [postgresqltutorial.com](https://www.postgresqltutorial.com/)
- Projects
    - [Nodejs and PostgreSQL Project](https://www.youtube.com/playlist?list=PLillGF-RfqbaEmlPcX5e_ejaK7Y5MydkW)

## NoSQL Databases

- [What is NoSQL Databases?](https://www.youtube.com/watch?v=uD3p_rZPBUQ)
- [SQL vs NoSQL](https://www.youtube.com/watch?v=Q5aTUc7c4jg)

### MongoDB

- Tutorials
    - [MongoDB Tutorial - Amigoscode(Youtube)](https://www.youtube.com/watch?v=Www6cTUymCY) `Recommended`
    - [Complete MongoDB Tutorial - The Net Ninja(Youtube)](https://www.youtube.com/playlist?list=PL4cUxeGkcC9h77dJ-QJlwGlZlTd4ecZOA)
    - [Complete MongoDB Tutorial - DataZ(Youtube)](https://www.youtube.com/watch?v=GFaKsrfQkAc&t=9298s)
    - [Introduction & getting started with MongoDB - MongoDB University M001](https://learn.mongodb.com/learning-paths/introduction-to-mongodb)
- Projects
    - [Build a Markdown Blog with Node.js, Express and MongoDB](https://www.youtube.com/watch?v=1NrHkjlWVhM)

## APIs

### Learn and Build APIs

- [REST API with Node js & Express - Programming with Mosh(Youtube)](https://www.youtube.com/watch?v=pKd0Rpw7O48)
- [Back End Development and APIs - FreeCodeCamp](https://www.freecodecamp.org/learn/back-end-development-and-apis/)
- [Learn API Servers in Go - Boot.dev](https://boot.dev/learn/learn-web-servers)
- [REST API With Node.js, Express, & MongoDB - Web Dev Simplified(Youtube)](https://www.youtube.com/watch?v=fgTGADljAeg)
- [Build a Node.js API - FreeCodeCamp(Youtube)](https://www.youtube.com/watch?v=fsCjFHuMXj0)
- [JSON APIs](https://www.youtube.com/watch?v=N-4prIh7t38)
- [APIs for Beginners 2023 - How to use an API (Full Course )](https://youtu.be/WXsD0ZgxjRw)

### Caching

- [Client Side Caching](https://youtu.be/HiBDZgTNpXY)
- [Server side Caching](https://www.starwindsoftware.com/resource-library/server-side-caching/)
- [CDN (Content Delivery Network)](https://www.cloudflare.com/en-ca/learning/cdn/what-is-a-cdn/)

### MVC

- [MVC explained - Web Dev Simplified(Youtube)](https://www.youtube.com/watch?v=DUg2SWWK18I)
- [Express Router & MVC - The Net Ninja(Youtube)](https://www.youtube.com/watch?v=zW_tZR0Ir3Q)

### Deployment

- [Node.js & Express,Deploying an app- Traversy Media(Youtube)](https://www.youtube.com/watch?v=_GSOnHRYSS0)
- [Full Node.js Deployment - Traversy Media(Youtube)](https://www.youtube.com/watch?v=oykl1Ih9pMg)
- [Express Tutorial, Deploying to production - Mozilla web docs](https://developer.mozilla.org/en-US/docs/Learn/Server-side/Express_Nodejs/deployment)

## Microservices

- [What are Microservices?](https://www.youtube.com/watch?v=j3XufmvEMiM)
- [NodeJs Microservices](https://www.youtube.com/playlist?list=PLrwNNiB6YOA0KmfliJoSuZzEN6tjSdEXc)
- [Backend Development and API projects](https://www.freecodecamp.org/learn/back-end-development-and-apis/#mongodb-and-mongoose)
- [What is a microservices architecture and it's advantages?](https://www.youtube.com/watch?v=qYhRvH9tJKw)

## Web Security

- [HTTPS and Web Security](https://www.youtube.com/watch?v=kBzbKUirOFk)
- [How Hackers use DevTools](https://www.youtube.com/watch?v=5mUUBkxayQ4)
- [Secure ExpressJS application with Helment](https://www.youtube.com/watch?v=tGMPWVl_l9Y)
- [NodeJS Security Best Practices](https://blog.sqreen.com/nodejs-security-best-practices/)

## Testing

- [Testing a Rest API](https://www.youtube.com/watch?v=I4BZQr-5mBY)
- [Jest Tutorial](https://www.youtube.com/watch?v=8gHEv5iNRKk)
- [Testing Node.js with Mocha](https://www.youtube.com/watch?v=Bs68k6xfR3E)
- [Test Driven Development](https://www.youtube.com/watch?v=ISAjES_Gklc)

### Documentations

- [Mocha](https://mochajs.org/)
- [Chai](https://www.chaijs.com/guide/)
- [Jest](https://jestjs.io/docs/getting-started)
- [Cucumber](https://cucumber.io/docs/guides/)
- [Pactum](https://pactumjs.github.io/guides/api-testing.html)

## Containerization

- [Containers Explained](https://www.youtube.com/watch?v=0qotVMX-J5s)

### Docker

- Tutorials
    - [Docker Tutorial - Kunal Kushwaha(Youtube)](https://www.youtube.com/watch?v=17Bl31rlnRM) `Recommended`
    - [Docker Tutorial - TechWorld With Nana(Youtube)](https://www.youtube.com/watch?v=3c-iBn73dDE)
    - [Learn Docker - Boot.dev](https://boot.dev/learn/learn-docker)
    - [Learn Docker - freecodecamp(Youtube)](https://www.youtube.com/watch?v=9zUHg7xjIqQ)
    - [Docs](https://docs.docker.com/) 
- Projects
    - [Build a NodeJS application with Docker](https://www.youtube.com/watch?v=PsWeSg38XFY)

## Web Servers

- [Web servers and their working - Hussein Nasser(Youtube)](https://www.youtube.com/watch?v=JhpUch6lWMw)
- [What is a web server - Mozilla web docs](https://developer.mozilla.org/en-US/docs/Learn/Common_questions/What_is_a_web_server)
- [Web Server - Tutorialspoint](https://www.tutorialspoint.com/internet_technologies/web_servers.htm)
- [What is a web server? - NGINX](https://www.nginx.com/resources/glossary/web-server/)

## Build Projects

- [4 projects with Node.js/Express](https://www.youtube.com/watch?v=qwfE7fSVaZM)
- [Project Ideas](https://gist.github.com/MWins/41c6fec2122dd47fdfaca31924647499)
- [50 Node.js/Express Project with tutorial](https://www.youtube.com/playlist?list=PL9iaMyazOxXsIl-WQV9hoVmnHYy49DuVl)
