## WeCMDB 术语表

### 系统术语表

#### 配置管理数据库（CMDB - Confirmation Management Database）
一个用于存储IT配置信息的数据库，包括各种配置项及其它们之间的关联关系。

#### 配置项类型 (CIT - Configuraiton Item Type)
一类配置项的抽象，用于存储该类型的配置项信息，如主机类型，用于存储不同规格的主机信息，应用类型，用于存储各种各样不同类型的应用信息。如关系数据库里的一张表或现实世界里的一类事物。

#### 配置项类型属性 (CITA - Configuration Item Type Attribute)
一个配置项类型的属性，用于表示该配置项类型的某一特性，如数据库表里的一列，或是现实世界里的某类事物的一个特征。如主机的CPU, 用于表示主机的计算速度。

#### 配置项 (CI - Configuration Item)
一类配置项的某个具体的配置实例，可以是物理上看得见的事物，也可以是逻辑上，概念上的某个设计或系统之间的摸个调用。如一台主机，一个数据中心节点，一个系统或系统之间的一个调用等。

#### 配置项类型关联关系 (CITR - Configuraiton Item Type Relationship)
一种配置项类型之间的关联关系，即引用关系，如主机类引用了IP地址类，具体表现为一台主机的内网IP,应用了IP地址类里的某个IP地址。

#### 输入数据类型 (IDT - Input Data Type)
一种数据类型，用于规范用户数据的录入，统一的数据格式便于系统高效处理。

#### 综合查询 (IntQ - Integrated Query)
一种把几种类型的配置项关联在一起的查询方式，如查询一台主机上运行多少个应用系统的实例，这就需要把主机和运行实例关联起来，用主机的某个属性作为条件（如IP地址）, 查询出来这台主机上运行的所有实例（如实例的名称）。

#### 枚举类别
枚举类别分为3类:  
系统枚举类别:一类在系统初始化的时候就预先固定下来的枚举类别，可用于所有配置项，如ci_state，表示状态机这种类别。这种类别不能客制化新增，修改和删除。  

公共枚举类别:一类在系统初始化后可以根据需要添加的枚举类别，可用于所有配置项，如business_group，表示业务群组。这种类别可以客制化新增，修改，但不能删除，因为它是公共的，可能用于其它配置项。  

私有枚举类别:一类在配置项类型创建时，专门为这个配置项新增的专属枚举类别，只能用于该配置项，如ip_type，IP地址的类型，只用于IP地址这个配置项。这种类别可以客制化新增，修改和删除。  

#### 枚举类型
一类枚举值的总称，如ci_state_design，这个类型表示设计类的状态机所有状态的总称。

#### 枚举键/值
一个具体的枚举值，如created/已创建，属于ci_state_design。

### 模型术语表(最佳实践)
TO DO ...
