<%@ page language="java" pageEncoding="utf-8"%>
<%@page import="com.farm.web.constant.FarmConstant"%>
<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/view/conf/farmtag.tld" prefix="PF"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/functions" prefix="fn"%>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
<base href="<PF:basePath/>" />
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
<title>课程标签- <PF:ParameterValue key="config.sys.title" /></title>
<meta name="description"
	content='<PF:ParameterValue key="config.sys.mate.description"/>'>
<meta name="keywords"
	content='<PF:ParameterValue key="config.sys.mate.keywords"/>'>
<meta name="author"
	content='<PF:ParameterValue key="config.sys.mate.author"/>'>
<meta name="robots" content="index,follow">
<meta name="viewport"
	content="width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no">
<jsp:include page="../atext/include-web.jsp"></jsp:include>
<script charset="utf-8"
	src="<PF:basePath/>text/lib/super-validate/validate.js"></script>
<style>
</style>
</head>
<style>
.wlp-userspace-h1 {
	font-size: 36px;
	text-align: center;
}

.picLUp {
	background: url(text/img/demo/webfullstack-bg.jpg) no-repeat;
	width: 100%;
	background-size: 100% 100%;
	color: white;
	background-color: #000000;
}

.wpl-class-tab .nav  li a {
	color: #ffffff;
}

.wpl-class-tab .nav  li a:HOVER {
	color: #666666;
}

.wpl-class-tab .nav .active a {
	color: #666666;
}

.list-group {
	border-radius: 4px;
	-webkit-box-shadow: 0 0px 0px rgba(0, 0, 0, 0);
	box-shadow: 0 0px 0px rgba(0, 0, 0, 0);
}

.wlp-typeline-ul {
	margin-left: -20px;
}

.wlp-typeline-ul li {
	float: left;
	list-style-type: none;
	font-size: 16px;
	padding: 8px;
	margin-right: 20px;
	cursor: pointer;
	color: #666666;
}

.wlp-typeline-ul li:HOVER {
	color: #f20d0d;
}

.wlp-typeline-ul li.active {
	color: #f20d0d;
	font-weight: 700;
	background-color: #fef1f1;
	border-radius: 4px 4px 4px 4px;
}

.wlp-praiseback-box {
	background-color: #f2f2f2;
	padding: 13px;
	border-radius: 6px 6px 6px 6px;
	border: 1px solid #f2f2f2;
	margin: 8px;
	cursor: pointer;
	margin: 8px;
}

.wlp-praiseback-box:HOVER {
	background-color: #fafafa;
	padding: 13px;
	border-radius: 15px 15px 15px 15px;
	border: 1px dashed #dddddd;
	cursor: pointer;
}
</style>
<body>
	<div class="container-fluid">
		<div class="row">
			<!-- 导航 -->
			<jsp:include page="../commons/head.jsp"></jsp:include>
		</div>
	</div>
	<div class="container-fluid"
		style="padding-top: 20px; padding-bottom: 20px;">
		<div class="container" style="margin-top: 50px;">
			<div class="row">
				<div class="col-xs-3">
					<jsp:include page="commons/classLeftInfo.jsp">
						<jsp:param value="tags" name="type" />
					</jsp:include>
				</div>
				<div class="col-xs-9">
					<div style="margin-top: 20px;">
						<div class="wlp-userspace-h2">
							课程标签 <span style="font-size: 12px; color: #f20d0d;">通过点击下面标签，为课程选中标签</span>
						</div>
						<hr style="margin-bottom: 20px;" class="wlp-userspace-hr">
						<div
							style="border: 1px dashed #cccccc; background-color: #eceef1; padding: 20px;">
							<c:forEach items="${tags }" var="node" varStatus="status">
								<c:if test="${status.index>0 }">
									<hr style="margin-top: 20px; border: 1px dashed #ffffff;"
										class="wlp-userspace-hr">
								</c:if>
								<div class="media">
									<div class="media-left">
										<div class="wlp-userspace-h2"
											style="width: 90px; text-align: right; margin-left: -20px; margin-top: 10px; color: #666666;">${node.name}:</div>
									</div>
									<div class="media-body">
										<ul class="wlp-typeline-ul">
											<c:forEach items="${node.tags}" var="tag">
												<c:if test="${!tag.check}">
													<li
														onclick="clickTag(this,'${classview.classt.id}','${tag.id}')">${tag.name}</li>
												</c:if>
												<c:if test="${tag.check}">
													<li
														onclick="clickTag(this,'${classview.classt.id}','${tag.id}')"
														class="active">${tag.name}</li>
												</c:if>
											</c:forEach>
										</ul>
									</div>
								</div>
							</c:forEach>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="container-fluid" style="padding: 0px;">
		<!-- 页脚 -->
		<jsp:include page="../commons/foot.jsp"></jsp:include>
	</div>
</body>
<script>
	//提交表单
	function clickTag(cdom, classid, tagid) {
		var url = "<PF:basePath/>/classweb/";
		if ($(cdom).hasClass("active")) {
			url = url + "removeTag.do";
		} else {
			url = url + "addTag.do";
		}
		$.post(url, {
			'classid' : classid,
			'tagid' : tagid
		}, function(flag) {
			if (flag.STATE == 0) {
				if ($(cdom).hasClass("active")) {
					$(cdom).removeClass("active");
				} else {
					$(cdom).addClass("active");
				}
			} else {
				alert(flag.MESSAGE);
			}
		}, 'json');
	}
</script>
</html>