package com.farm.sfile.utils;

import java.util.HashMap;
import java.util.Map;

public class HttpContentType {
	private Map<String, String> map = new HashMap<>();

	public HttpContentType() {
		map.put("dcd", "text/xml");
		map.put("ws", "application/x-ws");
		map.put("class", "java/*");
		map.put("spc", "application/x-pkcs7-certificates");
		map.put("awf", "application/vnd.adobe.workflow");
		map.put("hta", "application/hta");
		map.put("aifc", "audio/aiff");
		map.put("mpa", "video/x-mpg");
		map.put("mps", "video/x-mpeg");
		map.put("edn", "application/vnd.adobe.edn");
		map.put("fdf", "application/vnd.fdf");
		map.put("p7c", "application/pkcs7-mime");
		map.put("cml", "text/xml");
		map.put("ent", "text/xml");
		map.put("epi", "application/x-epi");
		map.put("tga", "application/x-tga");
		map.put("rjs", "application/vnd.rn-realsystem-rjs");
		map.put("math", "text/xml");
		map.put("vtx", "application/vnd.visio");
		map.put("wml", "text/vnd.wap.wml");
		map.put("pps", "application/vnd.ms-powerpoint");
		map.put("rmx", "application/vnd.rn-realsystem-rmx");
		map.put("exe", "application/x-msdownload");
		map.put("asf", "video/x-ms-asf");
		map.put("cat", "application/vnd.ms-pki.seccat");
		map.put("xwd", "application/x-xwd");
		map.put("latex", "application/x-latex");
		map.put("ltr", "application/x-ltr");
		map.put("pls", "audio/scpls");
		map.put("xls", "application/x-xls");
		map.put("jpe", "application/x-jpe");
		map.put("ssm", "application/streamingmedia");
		map.put("dtd", "text/xml");
		//map.put("jpg", "application/x-jpg");
		map.put("jpg", "image/jpeg");
		map.put("hmr", "application/x-hmr");
		map.put("vst", "application/x-vst");
		map.put("mpw", "application/vnd.ms-project");
		map.put("sit", "application/x-stuffit");
		map.put("pcx", "application/x-pcx");
		map.put("movie", "video/x-sgi-movie");
		map.put("xpl", "audio/scpls");
		map.put("jpeg", "image/jpeg");
		map.put("png", "image/png");
		map.put("001", "application/x-001");
		map.put("mpga", "audio/rn-mpeg");
		map.put("pci", "application/x-pci");
		map.put("rtf", "application/x-rtf");
		map.put("hrf", "application/x-hrf");
		map.put("mdb", "application/x-mdb");
		map.put("iff", "application/x-iff");
		map.put("rm", "application/vnd.rn-realmedia");
		map.put("mil", "application/x-mil");
		map.put("ico", "application/x-ico");
		map.put("pcl", "application/x-pcl");
		map.put("cmp", "application/x-cmp");
		map.put("vda", "application/x-vda");
		map.put("p12", "application/x-pkcs12");
		map.put("css", "text/css");
		map.put("sat", "application/x-sat");
		map.put("html", "text/html");
		map.put("c4t", "application/x-c4t");
		map.put("ptn", "application/x-ptn");
		map.put("rmf", "application/vnd.adobe.rmf");
		map.put("ins", "application/x-internet-signup");
		map.put("907", "drawing/907");
		map.put("wm", "video/x-ms-wm");
		map.put("cmx", "application/x-cmx");
		map.put("rt", "text/vnd.rn-realtext");
		map.put("IVF", "video/x-ivf");
		map.put("torrent", "application/x-bittorrent");
		map.put("rv", "video/vnd.rn-realvideo");
		map.put("bmp", "application/x-bmp");
		map.put("cut", "application/x-cut");
		map.put("301", "application/x-301");
		map.put("nws", "message/rfc822");
		map.put("hgl", "application/x-hgl");
		map.put("img", "application/x-img");
		map.put("out", "application/x-out");
		map.put("rat", "application/rat-file");
		map.put("wb3", "application/x-wb3");
		map.put("rjt", "application/vnd.rn-realsystem-rjt");
		map.put("hqx", "application/mac-binhex40");
		map.put("pko", "application/vnd.ms-pki.pko");
		map.put("smi", "application/smil");
		map.put("prt", "application/x-prt");
		map.put("vxml", "text/xml");
		map.put("lavs", "audio/x-liquid-secure");
		map.put("a11", "application/x-a11");
		map.put("cel", "application/x-cel");
		map.put("mpt", "application/vnd.ms-project");
		map.put("cgm", "application/x-cgm");
		map.put("wb2", "application/x-wb2");
		map.put("rmp", "application/vnd.rn-rn_music_package");
		map.put("cal", "application/x-cals");
		map.put("rmvb", "application/vnd.rn-realmedia-vbr");
		map.put("rp", "image/vnd.rn-realpix");
		map.put("cdf", "application/x-netcdf");
		map.put("dxf", "application/x-dxf");
		map.put("wb1", "application/x-wb1");
		map.put("lbm", "application/x-lbm");
		map.put("xq", "text/xml");
		map.put("mpx", "application/vnd.ms-project");
		map.put("hpl", "application/x-hpl");
		map.put("uin", "application/x-icq");
		map.put("mpv", "video/mpg");
		map.put("spl", "application/futuresplash");
		map.put("dcx", "application/x-dcx");
		map.put("pdf", "application/pdf");
		map.put("plt", "application/x-plt");
		map.put("wsdl", "text/xml");
		map.put("isp", "application/x-internet-signup");
		map.put("rsml", "application/vnd.rn-rsml");
		map.put("xlw", "application/x-xlw");
		map.put("rmm", "audio/x-pn-realaudio");
		map.put("drw", "application/x-drw");
		map.put("sisx", "application/vnd.symbian.install");
		map.put("htm", "text/html");
		map.put("mht", "message/rfc822");
		map.put("pc5", "application/x-pc5");
		map.put("stl", "application/vnd.ms-pki.stl");
		map.put("sty", "application/x-sty");
		map.put("cot", "application/x-cot");
		map.put("js", "application/x-javascript");
		map.put("wks", "application/x-wks");
		map.put("sdp", "application/sdp");
		map.put("xquery", "text/xml");
		map.put("svg", "text/xml");
		map.put("gl2", "application/x-gl2");
		map.put("mpe", "video/x-mpeg");
		map.put("eml", "message/rfc822");
		map.put("mpd", "application/vnd.ms-project");
		map.put("r3t", "text/vnd.rn-realtext3d");
		map.put("lmsff", "audio/x-la-lms");
		map.put("sst", "application/vnd.ms-pki.certstore");
		map.put("vpg", "application/x-vpeg005");
		map.put("aif", "audio/aiff");
		map.put("rdf", "text/xml");
		map.put("pfx", "application/x-pkcs12");
		map.put("323", "text/h323");
		map.put("sld", "application/x-sld");
		map.put("m3u", "audio/mpegurl");
		map.put("mpv2", "video/mpeg");
		map.put("906", "application/x-906");
		map.put("dbx", "application/x-dbx");
		map.put("ai", "application/postscript");
		map.put("jfif", "image/jpeg");
		map.put("rec", "application/vnd.rn-recording");
		map.put("emf", "application/x-emf");
		map.put("wkq", "application/x-wkq");
		map.put("dxb", "application/x-dxb");
		map.put("wq1", "application/x-wq1");
		map.put("vsd", "application/x-vsd");
		map.put("wp6", "application/x-wp6");
		map.put("wmf", "application/x-wmf");
		map.put("c90", "application/x-c90");
		map.put("wax", "audio/x-ms-wax");
		map.put("x_b", "application/x-x_b");
		map.put("wri", "application/x-wri");
		map.put("mnd", "audio/x-musicnet-download");
		map.put("ram", "audio/x-pn-realaudio");
		map.put("mid", "audio/mid");
		map.put("jsp", "text/html");
		map.put("lar", "application/x-laplayer-reg");
		map.put("xslt", "text/xml");
		map.put("mac", "application/x-mac");
		map.put("crl", "application/pkix-crl");
		map.put("xdp", "application/vnd.adobe.xdp");
		map.put("tdf", "application/x-tdf");
		map.put("stm", "text/html");
		map.put("txt", "text/plain");
		map.put("vcf", "text/x-vcard");
		map.put("wav", "audio/wav");
		map.put("wrk", "application/x-wrk");
		map.put("sor", "text/plain");
		map.put("dwf", "application/x-dwf");
		map.put("net", "image/pnetvue");
		map.put("dib", "application/x-dib");
		map.put("gp4", "application/x-gp4");
		map.put("cdr", "application/x-cdr");
		map.put("gbr", "application/x-gbr");
		map.put("pgl", "application/x-pgl");
		map.put("uls", "text/iuls");
		map.put("prf", "application/pics-rules");
		map.put("htt", "text/webviewhtml");
		map.put("xql", "text/xml");
		map.put("top", "drawing/x-top");
		map.put("pr", "application/x-pr");
		map.put("wpd", "application/x-wpd");
		map.put("etd", "application/x-ebx");
		map.put("mocha", "application/x-javascript");
		map.put("xhtml", "text/html");
		map.put("htx", "text/html");
		map.put("ipa", "application/vnd.iphone");
		map.put("swf", "application/x-shockwave-flash");
		map.put("slk", "drawing/x-slk");
		map.put("mpeg", "video/mpg");
		map.put("fo", "text/xml");
		map.put("doc", "application/msword");
		map.put("wbmp", "image/vnd.wap.wbmp");
		map.put("der", "application/x-x509-ca-cert");
		map.put("m1v", "video/x-mpeg");
		map.put("crt", "application/x-x509-ca-cert");
		map.put("iii", "application/x-iphone");
		map.put("p7s", "application/pkcs7-signature");
		map.put("xfdf", "application/vnd.adobe.xfdf");
		map.put("tsd", "text/xml");
		map.put("xdr", "text/xml");
		map.put("rnx", "application/vnd.rn-realplayer");
		map.put("tiff", "image/tiff");
		map.put("apk", "application/vnd.android.package-archive");
		map.put("m2v", "video/x-mpeg");
		map.put("eps", "application/postscript");
		map.put("mml", "text/xml");
		map.put("rpm", "audio/x-pn-realaudio-plugin");
		map.put("bot", "application/x-bot");
		map.put("au", "audio/basic");
		map.put("anv", "application/x-anv");
		map.put("xsd", "text/xml");
		map.put("wpg", "application/x-wpg");
		map.put("prn", "application/x-prn");
		map.put("vss", "application/vnd.visio");
		map.put("sam", "application/x-sam");
		map.put("pdx", "application/vnd.adobe.pdx");
		map.put("wk3", "application/x-wk3");
		map.put("p10", "application/pkcs10");
		map.put("mxp", "application/x-mmxp");
		map.put("dgn", "application/x-dgn");
		map.put("mi", "application/x-mi");
		map.put("frm", "application/x-frm");
		map.put("rle", "application/x-rle");
		map.put("avi", "video/avi");
		map.put("mpp", "application/vnd.ms-project");
		map.put("m4e", "video/mpeg4");
		map.put("wsc", "text/scriptlet");
		map.put("rmi", "audio/mid");
		map.put("htc", "text/x-component");
		map.put("tg4", "application/x-tg4");
		map.put("hpg", "application/x-hpgl");
		map.put("sol", "text/plain");
		map.put("asx", "video/x-ms-asf");
		map.put("xfd", "application/vnd.adobe.xfd");
		map.put("ras", "application/x-ras");
		map.put("acp", "audio/x-mei-aac");
		map.put("nrf", "application/x-nrf");
		map.put("p7m", "application/pkcs7-mime");
		map.put("ws2", "application/x-ws");
		map.put("rlc", "application/x-rlc");
		map.put("java", "java/*");
		map.put("odc", "text/x-ms-odc");
		map.put("gif", "image/gif");
		map.put("dbf", "application/x-dbf");
		map.put("spp", "text/xml");
		map.put("aiff", "audio/aiff");
		map.put("p7b", "application/x-pkcs7-certificates");
		map.put("dll", "application/x-msdownload");
		map.put("sis", "application/vnd.symbian.install");
		map.put("igs", "application/x-igs");
		map.put("xap", "application/x-silverlight-app");
		map.put("man", "application/x-troff-man");
		map.put("mhtml", "message/rfc822");
		map.put("dwg", "application/x-dwg");
		map.put("ppt", "application/x-ppt");
		map.put("rmj", "application/vnd.rn-realsystem-rmj");
		map.put("midi", "audio/mid");
		map.put("sdw", "application/x-sdw");
		map.put("mp2v", "video/mpeg");
		map.put("dot", "application/msword");
		map.put("ig4", "application/x-g4");
		map.put("ps", "application/postscript");
		map.put("mns", "audio/x-musicnet-stream");
		map.put("cer", "application/x-x509-ca-cert");
		map.put("cg4", "application/x-g4");
		map.put("asa", "text/asa");
		map.put("pl", "application/x-perl");
		map.put("wmx", "video/x-ms-wmx");
		map.put("xml", "text/xml");
		map.put("mtx", "text/xml");
		map.put("xsl", "text/xml");
		map.put("smk", "application/x-smk");
		map.put("p7r", "application/x-pkcs7-certreqresp");
		map.put("wma", "audio/x-ms-wma");
		map.put("biz", "text/xml");
		map.put("tld", "text/xml");
		map.put("wmv", "video/x-ms-wmv");
		map.put("g4", "application/x-g4");
		map.put("wiz", "application/msword");
		map.put("csi", "application/x-csi");
		map.put("pic", "application/x-pic");
		map.put("pot", "application/vnd.ms-powerpoint");
		map.put("fif", "application/fractals");
		map.put("mpg", "video/mpg");
		map.put("mfp", "application/x-shockwave-flash");
		map.put("vsw", "application/vnd.visio");
		map.put("wk4", "application/x-wk4");
		map.put("slb", "application/x-slb");
		map.put("plg", "text/html");
		map.put("wvx", "video/x-ms-wvx");
		map.put("vsx", "application/vnd.visio");
		map.put("rgb", "application/x-rgb");
		map.put("ra", "audio/vnd.rn-realaudio");
		map.put("wr1", "application/x-wr1");
		map.put("asp", "text/asp");
		map.put("wmz", "application/x-ms-wmz");
		map.put("wmd", "application/x-ms-wmd");
		map.put("ppa", "application/vnd.ms-powerpoint");
		map.put("rms", "application/vnd.rn-realmedia-secure");
		map.put("red", "application/x-red");
		map.put("mp1", "audio/mp1 	.mp2 	audio/mp2");
		map.put("smil", "application/smil");
		map.put("icb", "application/x-icb");
		map.put("ppm", "application/x-ppm");
		map.put("la1", "audio/x-liquid-file");
		map.put("vdx", "application/vnd.visio");
		map.put("ls", "application/x-javascript");
		map.put("tif", "application/x-tif");
		map.put("cit", "application/x-cit");
		map.put("mp3", "audio/mp3");
		map.put("pwz", "application/vnd.ms-powerpoint");
		map.put("x_t", "application/x-x_t");
		map.put("wpl", "application/vnd.ms-wpl");
		map.put("vml", "text/xml");
		map.put("fax", "image/fax");
		map.put("snd", "audio/basic");
		map.put("dbm", "application/x-dbm");
		//map.put("mp4", "video/mpeg4");
		map.put("mp4", "video/mp4");
	}

	public String getContentType(String exname) {
		String type = map.get(exname.toLowerCase());
		return type != null ? type : "application/octet-stream";
	}

}
