use std::error::Error;

use crate::utils::shell::{run_command, spawn_command};

pub fn is_git_repo_up_to_date() -> Result<bool, Box<dyn Error>> {
    run_command("git fetch", "")?;

    let current_branch_raw =
        run_command(&"git rev-parse --abbrev-ref HEAD", "Get current git branch")?;
    let current_branch = current_branch_raw.trim();

    let remote_command = format!("git rev-parse origin/{}", current_branch);
    let remote_commit_raw = run_command(&remote_command, "Parse remote commit hash")?;
    let remote_commit = remote_commit_raw.trim();

    let local_commit_raw = run_command("git rev-parse HEAD", "Parse local commit hash")?;
    let local_commit = local_commit_raw.trim();

    Ok(remote_commit == local_commit)
}

pub fn update_git_repo() -> Result<String, Box<dyn Error>> {
    let output = spawn_command("git pull", "Update git repo")?;
    Ok(output)
}

pub fn get_branches() -> Result<Vec<String>, Box<dyn Error>> {
    let output = run_command("git branch -l", "Get all git branches")?;
    let branches = output
        .replace("*", "")
        .split("\n")
        .collect::<Vec<&str>>()
        .iter()
        .map(|s| s.trim())
        .filter(|s| !s.is_empty())
        .map(|s| s.to_owned())
        .collect();
    Ok(branches)
}
