from collections import namedtuple

"""
    Info for this module for where each version of wdf start and ends where taken from
    https://github.com/microsoft/Windows-Driver-Frameworks
"""

MinorRevision = namedtuple("MinorRevision", ['revision', 'count'])

class WdfStruct():
    def __init__(self, names_list, minors):
        self.names_list = names_list
        self.minors = minors

kmdf1_major = [
    "WdfChildListCreate",
    "WdfChildListGetDevice",
    "WdfChildListRetrievePdo",
    "WdfChildListRetrieveAddressDescription",
    "WdfChildListBeginScan",
    "WdfChildListEndScan",
    "WdfChildListBeginIteration",
    "WdfChildListRetrieveNextDevice",
    "WdfChildListEndIteration",
    "WdfChildListAddOrUpdateChildDescriptionAsPresent",
    "WdfChildListUpdateChildDescriptionAsMissing",
    "WdfChildListUpdateAllChildDescriptionsAsPresent",
    "WdfChildListRequestChildEject",
    "WdfCollectionCreate",
    "WdfCollectionGetCount",
    "WdfCollectionAdd",
    "WdfCollectionRemove",
    "WdfCollectionRemoveItem",
    "WdfCollectionGetItem",
    "WdfCollectionGetFirstItem",
    "WdfCollectionGetLastItem",
    "WdfCommonBufferCreate",
    "WdfCommonBufferGetAlignedVirtualAddress",
    "WdfCommonBufferGetAlignedLogicalAddress",
    "WdfCommonBufferGetLength",
    "WdfControlDeviceInitAllocate",
    "WdfControlDeviceInitSetShutdownNotification",
    "WdfControlFinishInitializing",
    "WdfDeviceGetDeviceState",
    "WdfDeviceSetDeviceState",
    "WdfWdmDeviceGetWdfDeviceHandle",
    "WdfDeviceWdmGetDeviceObject",
    "WdfDeviceWdmGetAttachedDevice",
    "WdfDeviceWdmGetPhysicalDevice",
    "WdfDeviceWdmDispatchPreprocessedIrp",
    "WdfDeviceAddDependentUsageDeviceObject",
    "WdfDeviceAddRemovalRelationsPhysicalDevice",
    "WdfDeviceRemoveRemovalRelationsPhysicalDevice",
    "WdfDeviceClearRemovalRelationsDevices",
    "WdfDeviceGetDriver",
    "WdfDeviceRetrieveDeviceName",
    "WdfDeviceAssignMofResourceName",
    "WdfDeviceGetIoTarget",
    "WdfDeviceGetDevicePnpState",
    "WdfDeviceGetDevicePowerState",
    "WdfDeviceGetDevicePowerPolicyState",
    "WdfDeviceAssignS0IdleSettings",
    "WdfDeviceAssignSxWakeSettings",
    "WdfDeviceOpenRegistryKey",
    "WdfDeviceSetSpecialFileSupport",
    "WdfDeviceSetCharacteristics",
    "WdfDeviceGetCharacteristics",
    "WdfDeviceGetAlignmentRequirement",
    "WdfDeviceSetAlignmentRequirement",
    "WdfDeviceInitFree",
    "WdfDeviceInitSetPnpPowerEventCallbacks",
    "WdfDeviceInitSetPowerPolicyEventCallbacks",
    "WdfDeviceInitSetPowerPolicyOwnership",
    "WdfDeviceInitRegisterPnpStateChangeCallback",
    "WdfDeviceInitRegisterPowerStateChangeCallback",
    "WdfDeviceInitRegisterPowerPolicyStateChangeCallback",
    "WdfDeviceInitSetIoType",
    "WdfDeviceInitSetExclusive",
    "WdfDeviceInitSetPowerNotPageable",
    "WdfDeviceInitSetPowerPageable",
    "WdfDeviceInitSetPowerInrush",
    "WdfDeviceInitSetDeviceType",
    "WdfDeviceInitAssignName",
    "WdfDeviceInitAssignSDDLString",
    "WdfDeviceInitSetDeviceClass",
    "WdfDeviceInitSetCharacteristics",
    "WdfDeviceInitSetFileObjectConfig",
    "WdfDeviceInitSetRequestAttributes",
    "WdfDeviceInitAssignWdmIrpPreprocessCallback",
    "WdfDeviceInitSetIoInCallerContextCallback",
    "WdfDeviceCreate",
    "WdfDeviceSetStaticStopRemove",
    "WdfDeviceCreateDeviceInterface",
    "WdfDeviceSetDeviceInterfaceState",
    "WdfDeviceRetrieveDeviceInterfaceString",
    "WdfDeviceCreateSymbolicLink",
    "WdfDeviceQueryProperty",
    "WdfDeviceAllocAndQueryProperty",
    "WdfDeviceSetPnpCapabilities",
    "WdfDeviceSetPowerCapabilities",
    "WdfDeviceSetBusInformationForChildren",
    "WdfDeviceIndicateWakeStatus",
    "WdfDeviceSetFailed",
    "WdfDeviceStopIdleNoTrack",
    "WdfDeviceResumeIdleNoTrack",
    "WdfDeviceGetFileObject",
    "WdfDeviceEnqueueRequest",
    "WdfDeviceGetDefaultQueue",
    "WdfDeviceConfigureRequestDispatching",
    "WdfDmaEnablerCreate",
    "WdfDmaEnablerGetMaximumLength",
    "WdfDmaEnablerGetMaximumScatterGatherElements",
    "WdfDmaEnablerSetMaximumScatterGatherElements",
    "WdfDmaTransactionCreate",
    "WdfDmaTransactionInitialize",
    "WdfDmaTransactionInitializeUsingRequest",
    "WdfDmaTransactionExecute",
    "WdfDmaTransactionRelease",
    "WdfDmaTransactionDmaCompleted",
    "WdfDmaTransactionDmaCompletedWithLength",
    "WdfDmaTransactionDmaCompletedFinal",
    "WdfDmaTransactionGetBytesTransferred",
    "WdfDmaTransactionSetMaximumLength",
    "WdfDmaTransactionGetRequest",
    "WdfDmaTransactionGetCurrentDmaTransferLength",
    "WdfDmaTransactionGetDevice",
    "WdfDpcCreate",
    "WdfDpcEnqueue",
    "WdfDpcCancel",
    "WdfDpcGetParentObject",
    "WdfDpcWdmGetDpc",
    "WdfDriverCreate",
    "WdfDriverGetRegistryPath",
    "WdfDriverWdmGetDriverObject",
    "WdfDriverOpenParametersRegistryKey",
    "WdfWdmDriverGetWdfDriverHandle",
    "WdfDriverRegisterTraceInfo",
    "WdfDriverRetrieveVersionString",
    "WdfDriverIsVersionAvailable",
    "WdfFdoInitWdmGetPhysicalDevice",
    "WdfFdoInitOpenRegistryKey",
    "WdfFdoInitQueryProperty",
    "WdfFdoInitAllocAndQueryProperty",
    "WdfFdoInitSetEventCallbacks",
    "WdfFdoInitSetFilter",
    "WdfFdoInitSetDefaultChildListConfig",
    "WdfFdoQueryForInterface",
    "WdfFdoGetDefaultChildList",
    "WdfFdoAddStaticChild",
    "WdfFdoLockStaticChildListForIteration",
    "WdfFdoRetrieveNextStaticChild",
    "WdfFdoUnlockStaticChildListFromIteration",
    "WdfFileObjectGetFileName",
    "WdfFileObjectGetFlags",
    "WdfFileObjectGetDevice",
    "WdfFileObjectWdmGetFileObject",
    "WdfInterruptCreate",
    "WdfInterruptQueueDpcForIsr",
    "WdfInterruptSynchronize",
    "WdfInterruptAcquireLock",
    "WdfInterruptReleaseLock",
    "WdfInterruptEnable",
    "WdfInterruptDisable",
    "WdfInterruptWdmGetInterrupt",
    "WdfInterruptGetInfo",
    "WdfInterruptSetPolicy",
    "WdfInterruptGetDevice",
    "WdfIoQueueCreate",
    "WdfIoQueueGetState",
    "WdfIoQueueStart",
    "WdfIoQueueStop",
    "WdfIoQueueStopSynchronously",
    "WdfIoQueueGetDevice",
    "WdfIoQueueRetrieveNextRequest",
    "WdfIoQueueRetrieveRequestByFileObject",
    "WdfIoQueueFindRequest",
    "WdfIoQueueRetrieveFoundRequest",
    "WdfIoQueueDrainSynchronously",
    "WdfIoQueueDrain",
    "WdfIoQueuePurgeSynchronously",
    "WdfIoQueuePurge",
    "WdfIoQueueReadyNotify",
    "WdfIoTargetCreate",
    "WdfIoTargetOpen",
    "WdfIoTargetCloseForQueryRemove",
    "WdfIoTargetClose",
    "WdfIoTargetStart",
    "WdfIoTargetStop",
    "WdfIoTargetGetState",
    "WdfIoTargetGetDevice",
    "WdfIoTargetQueryTargetProperty",
    "WdfIoTargetAllocAndQueryTargetProperty",
    "WdfIoTargetQueryForInterface",
    "WdfIoTargetWdmGetTargetDeviceObject",
    "WdfIoTargetWdmGetTargetPhysicalDevice",
    "WdfIoTargetWdmGetTargetFileObject",
    "WdfIoTargetWdmGetTargetFileHandle",
    "WdfIoTargetSendReadSynchronously",
    "WdfIoTargetFormatRequestForRead",
    "WdfIoTargetSendWriteSynchronously",
    "WdfIoTargetFormatRequestForWrite",
    "WdfIoTargetSendIoctlSynchronously",
    "WdfIoTargetFormatRequestForIoctl",
    "WdfIoTargetSendInternalIoctlSynchronously",
    "WdfIoTargetFormatRequestForInternalIoctl",
    "WdfIoTargetSendInternalIoctlOthersSynchronously",
    "WdfIoTargetFormatRequestForInternalIoctlOthers",
    "WdfMemoryCreate",
    "WdfMemoryCreatePreallocated",
    "WdfMemoryGetBuffer",
    "WdfMemoryAssignBuffer",
    "WdfMemoryCopyToBuffer",
    "WdfMemoryCopyFromBuffer",
    "WdfLookasideListCreate",
    "WdfMemoryCreateFromLookaside",
    "WdfDeviceMiniportCreate",
    "WdfDriverMiniportUnload",
    "WdfObjectGetTypedContextWorker",
    "WdfObjectAllocateContext",
    "WdfObjectContextGetObject",
    "WdfObjectReferenceActual",
    "WdfObjectDereferenceActual",
    "WdfObjectCreate",
    "WdfObjectDelete",
    "WdfObjectQuery",
    "WdfPdoInitAllocate",
    "WdfPdoInitSetEventCallbacks",
    "WdfPdoInitAssignDeviceID",
    "WdfPdoInitAssignInstanceID",
    "WdfPdoInitAddHardwareID",
    "WdfPdoInitAddCompatibleID",
    "WdfPdoInitAddDeviceText",
    "WdfPdoInitSetDefaultLocale",
    "WdfPdoInitAssignRawDevice",
    "WdfPdoMarkMissing",
    "WdfPdoRequestEject",
    "WdfPdoGetParent",
    "WdfPdoRetrieveIdentificationDescription",
    "WdfPdoRetrieveAddressDescription",
    "WdfPdoUpdateAddressDescription",
    "WdfPdoAddEjectionRelationsPhysicalDevice",
    "WdfPdoRemoveEjectionRelationsPhysicalDevice",
    "WdfPdoClearEjectionRelationsDevices",
    "WdfDeviceAddQueryInterface",
    "WdfRegistryOpenKey",
    "WdfRegistryCreateKey",
    "WdfRegistryClose",
    "WdfRegistryWdmGetHandle",
    "WdfRegistryRemoveKey",
    "WdfRegistryRemoveValue",
    "WdfRegistryQueryValue",
    "WdfRegistryQueryMemory",
    "WdfRegistryQueryMultiString",
    "WdfRegistryQueryUnicodeString",
    "WdfRegistryQueryString",
    "WdfRegistryQueryULong",
    "WdfRegistryAssignValue",
    "WdfRegistryAssignMemory",
    "WdfRegistryAssignMultiString",
    "WdfRegistryAssignUnicodeString",
    "WdfRegistryAssignString",
    "WdfRegistryAssignULong",
    "WdfRequestCreate",
    "WdfRequestCreateFromIrp",
    "WdfRequestReuse",
    "WdfRequestChangeTarget",
    "WdfRequestFormatRequestUsingCurrentType",
    "WdfRequestWdmFormatUsingStackLocation",
    "WdfRequestSend",
    "WdfRequestGetStatus",
    "WdfRequestMarkCancelable",
    "WdfRequestUnmarkCancelable",
    "WdfRequestIsCanceled",
    "WdfRequestCancelSentRequest",
    "WdfRequestIsFrom32BitProcess",
    "WdfRequestSetCompletionRoutine",
    "WdfRequestGetCompletionParams",
    "WdfRequestAllocateTimer",
    "WdfRequestComplete",
    "WdfRequestCompleteWithPriorityBoost",
    "WdfRequestCompleteWithInformation",
    "WdfRequestGetParameters",
    "WdfRequestRetrieveInputMemory",
    "WdfRequestRetrieveOutputMemory",
    "WdfRequestRetrieveInputBuffer",
    "WdfRequestRetrieveOutputBuffer",
    "WdfRequestRetrieveInputWdmMdl",
    "WdfRequestRetrieveOutputWdmMdl",
    "WdfRequestRetrieveUnsafeUserInputBuffer",
    "WdfRequestRetrieveUnsafeUserOutputBuffer",
    "WdfRequestSetInformation",
    "WdfRequestGetInformation",
    "WdfRequestGetFileObject",
    "WdfRequestProbeAndLockUserBufferForRead",
    "WdfRequestProbeAndLockUserBufferForWrite",
    "WdfRequestGetRequestorMode",
    "WdfRequestForwardToIoQueue",
    "WdfRequestGetIoQueue",
    "WdfRequestRequeue",
    "WdfRequestStopAcknowledge",
    "WdfRequestWdmGetIrp",
    "WdfIoResourceRequirementsListSetSlotNumber",
    "WdfIoResourceRequirementsListSetInterfaceType",
    "WdfIoResourceRequirementsListAppendIoResList",
    "WdfIoResourceRequirementsListInsertIoResList",
    "WdfIoResourceRequirementsListGetCount",
    "WdfIoResourceRequirementsListGetIoResList",
    "WdfIoResourceRequirementsListRemove",
    "WdfIoResourceRequirementsListRemoveByIoResList",
    "WdfIoResourceListCreate",
    "WdfIoResourceListAppendDescriptor",
    "WdfIoResourceListInsertDescriptor",
    "WdfIoResourceListUpdateDescriptor",
    "WdfIoResourceListGetCount",
    "WdfIoResourceListGetDescriptor",
    "WdfIoResourceListRemove",
    "WdfIoResourceListRemoveByDescriptor",
    "WdfCmResourceListAppendDescriptor",
    "WdfCmResourceListInsertDescriptor",
    "WdfCmResourceListGetCount",
    "WdfCmResourceListGetDescriptor",
    "WdfCmResourceListRemove",
    "WdfCmResourceListRemoveByDescriptor",
    "WdfStringCreate",
    "WdfStringGetUnicodeString",
    "WdfObjectAcquireLock",
    "WdfObjectReleaseLock",
    "WdfWaitLockCreate",
    "WdfWaitLockAcquire",
    "WdfWaitLockRelease",
    "WdfSpinLockCreate",
    "WdfSpinLockAcquire",
    "WdfSpinLockRelease",
    "WdfTimerCreate",
    "WdfTimerStart",
    "WdfTimerStop",
    "WdfTimerGetParentObject",
    "WdfUsbTargetDeviceCreate",
    "WdfUsbTargetDeviceRetrieveInformation",
    "WdfUsbTargetDeviceGetDeviceDescriptor",
    "WdfUsbTargetDeviceRetrieveConfigDescriptor",
    "WdfUsbTargetDeviceQueryString",
    "WdfUsbTargetDeviceAllocAndQueryString",
    "WdfUsbTargetDeviceFormatRequestForString",
    "WdfUsbTargetDeviceGetNumInterfaces",
    "WdfUsbTargetDeviceSelectConfig",
    "WdfUsbTargetDeviceWdmGetConfigurationHandle",
    "WdfUsbTargetDeviceRetrieveCurrentFrameNumber",
    "WdfUsbTargetDeviceSendControlTransferSynchronously",
    "WdfUsbTargetDeviceFormatRequestForControlTransfer",
    "WdfUsbTargetDeviceIsConnectedSynchronous",
    "WdfUsbTargetDeviceResetPortSynchronously",
    "WdfUsbTargetDeviceCyclePortSynchronously",
    "WdfUsbTargetDeviceFormatRequestForCyclePort",
    "WdfUsbTargetDeviceSendUrbSynchronously",
    "WdfUsbTargetDeviceFormatRequestForUrb",
    "WdfUsbTargetPipeGetInformation",
    "WdfUsbTargetPipeIsInEndpoint",
    "WdfUsbTargetPipeIsOutEndpoint",
    "WdfUsbTargetPipeGetType",
    "WdfUsbTargetPipeSetNoMaximumPacketSizeCheck",
    "WdfUsbTargetPipeWriteSynchronously",
    "WdfUsbTargetPipeFormatRequestForWrite",
    "WdfUsbTargetPipeReadSynchronously",
    "WdfUsbTargetPipeFormatRequestForRead",
    "WdfUsbTargetPipeConfigContinuousReader",
    "WdfUsbTargetPipeAbortSynchronously",
    "WdfUsbTargetPipeFormatRequestForAbort",
    "WdfUsbTargetPipeResetSynchronously",
    "WdfUsbTargetPipeFormatRequestForReset",
    "WdfUsbTargetPipeSendUrbSynchronously",
    "WdfUsbTargetPipeFormatRequestForUrb",
    "WdfUsbInterfaceGetInterfaceNumber",
    "WdfUsbInterfaceGetNumEndpoints",
    "WdfUsbInterfaceGetDescriptor",
    "WdfUsbInterfaceSelectSetting",
    "WdfUsbInterfaceGetEndpointInformation",
    "WdfUsbTargetDeviceGetInterface",
    "WdfUsbInterfaceGetConfiguredSettingIndex",
    "WdfUsbInterfaceGetNumConfiguredPipes",
    "WdfUsbInterfaceGetConfiguredPipe",
    "WdfUsbTargetPipeWdmGetPipeHandle",
    "WdfVerifierDbgBreakPoint",
    "WdfVerifierKeBugCheck",
    "WdfWmiProviderCreate",
    "WdfWmiProviderGetDevice",
    "WdfWmiProviderIsEnabled",
    "WdfWmiProviderGetTracingHandle",
    "WdfWmiInstanceCreate",
    "WdfWmiInstanceRegister",
    "WdfWmiInstanceDeregister",
    "WdfWmiInstanceGetDevice",
    "WdfWmiInstanceGetProvider",
    "WdfWmiInstanceFireEvent",
    "WdfWorkItemCreate",
    "WdfWorkItemEnqueue",
    "WdfWorkItemGetParentObject",
    "WdfWorkItemFlush",
    "WdfCommonBufferCreateWithConfig",
    "WdfDmaEnablerGetFragmentLength",
    "WdfDmaEnablerWdmGetDmaAdapter",
    "WdfUsbInterfaceGetNumSettings", # here ends version 1.1
    "WdfDeviceRemoveDependentUsageDeviceObject",
    "WdfDeviceGetSystemPowerAction",
    "WdfInterruptSetExtendedPolicy",
    "WdfIoQueueAssignForwardProgressPolicy",
    "WdfPdoInitAssignContainerID",
    "WdfPdoInitAllowForwardingRequestToParent",
    "WdfRequestMarkCancelableEx",
    "WdfRequestIsReserved",
    "WdfRequestForwardToParentDeviceIoQueue", # here ends version 1.5 and 1.7
    "WdfCxDeviceInitAllocate",
    "WdfCxDeviceInitAssignWdmIrpPreprocessCallback",
    "WdfCxDeviceInitSetIoInCallerContextCallback",
    "WdfCxDeviceInitSetRequestAttributes",
    "WdfCxDeviceInitSetFileObjectConfig",
    "WdfDeviceWdmDispatchIrp",
    "WdfDeviceWdmDispatchIrpToIoQueue",
    "WdfDeviceInitSetRemoveLockOptions",
    "WdfDeviceConfigureWdmIrpDispatchCallback",
    "WdfDmaEnablerConfigureSystemProfile",
    "WdfDmaTransactionInitializeUsingOffset",
    "WdfDmaTransactionGetTransferInfo",
    "WdfDmaTransactionSetChannelConfigurationCallback",
    "WdfDmaTransactionSetTransferCompleteCallback",
    "WdfDmaTransactionSetImmediateExecution",
    "WdfDmaTransactionAllocateResources",
    "WdfDmaTransactionSetDeviceAddressOffset",
    "WdfDmaTransactionFreeResources",
    "WdfDmaTransactionCancel",
    "WdfDmaTransactionWdmGetTransferContext",
    "WdfInterruptQueueWorkItemForIsr",
    "WdfInterruptTryToAcquireLock",
    "WdfIoQueueStopAndPurge",
    "WdfIoQueueStopAndPurgeSynchronously",
    "WdfIoTargetPurge",
    "WdfUsbTargetDeviceCreateWithParameters",
    "WdfUsbTargetDeviceQueryUsbCapability",
    "WdfUsbTargetDeviceCreateUrb",
    "WdfUsbTargetDeviceCreateIsochUrb",
    "WdfDeviceWdmAssignPowerFrameworkSettings",
    "WdfDmaTransactionStopSystemTransfer",
    "WdfCxVerifierKeBugCheck",
    "WdfInterruptReportActive",
    "WdfInterruptReportInactive",
    "WdfDeviceInitSetReleaseHardwareOrderOnFailure",
    "WdfGetTriageInfo", # here ends version 1.9
    "WdfDeviceInitSetIoTypeEx",
    "WdfDeviceQueryPropertyEx",
    "WdfDeviceAllocAndQueryPropertyEx",
    "WdfDeviceAssignProperty",
    "WdfFdoInitQueryPropertyEx",
    "WdfFdoInitAllocAndQueryPropertyEx", # here ends version 1.11
    "WdfDeviceStopIdleActual",
    "WdfDeviceResumeIdleActual", # here ends version 1.13
    "WdfDeviceGetSelfIoTarget",
    "WdfDeviceInitAllowSelfIoTarget",
    "WdfIoTargetSelfAssignDefaultIoQueue",
    "WdfDeviceOpenDevicemapKey", # here ends version 1.15 and 1.17
    "WdfDmaTransactionSetSingleTransferRequirement",
    "WdfCxDeviceInitSetPnpPowerEventCallbacks", # here ends version 1.19
    "WdfFileObjectGetInitiatorProcessId",
    "WdfRequestGetRequestorProcessId", # here ends version 1.21
    "WdfDeviceRetrieveCompanionTarget",
    "WdfCompanionTargetSendTaskSynchronously",
    "WdfCompanionTargetWdmGetCompanionProcess", # here ends version 1.23
    "WdfDriverOpenPersistentStateRegistryKey",
    "WdfDriverErrorReportApiMissing", # here ends version 1.25 and 1.27
    "WdfPdoInitRemovePowerDependencyOnParent",
    "WdfCxDeviceInitAllocateContext",
    "WdfCxDeviceInitGetTypedContextWorker",
    "WdfCxDeviceInitSetPowerPolicyEventCallbacks",
    "WdfDeviceSetDeviceInterfaceStateEx" # here ends version 1.31 and 1.33
    ]

kmdf_minor_revision = [
    MinorRevision(1, 387),
    MinorRevision(5, 396),
    MinorRevision(7, 396),
    MinorRevision(9, 432),
    MinorRevision(11, 438),
    MinorRevision(13, 440),
    MinorRevision(15, 444),
    MinorRevision(17, 444),
    MinorRevision(19, 446),
    MinorRevision(21, 448),
    MinorRevision(23, 451),
    MinorRevision(25, 453),
    MinorRevision(27, 453),
    MinorRevision(31, 458),
    MinorRevision(33, 458),
]

umdf2_major = [
    "WdfCollectionCreate",
    "WdfCollectionGetCount",
    "WdfCollectionAdd",
    "WdfCollectionRemove",
    "WdfCollectionRemoveItem",
    "WdfCollectionGetItem",
    "WdfCollectionGetFirstItem",
    "WdfCollectionGetLastItem",
    "WdfCxDeviceInitAllocate",
    "WdfCxDeviceInitSetRequestAttributes",
    "WdfCxDeviceInitSetFileObjectConfig",
    "WdfCxVerifierKeBugCheck",
    "WdfDeviceGetDeviceState",
    "WdfDeviceSetDeviceState",
    "WdfDeviceGetDriver",
    "WdfDeviceGetIoTarget",
    "WdfDeviceAssignS0IdleSettings",
    "WdfDeviceAssignSxWakeSettings",
    "WdfDeviceOpenRegistryKey",
    "WdfDeviceInitSetPnpPowerEventCallbacks",
    "WdfDeviceInitSetPowerPolicyEventCallbacks",
    "WdfDeviceInitSetPowerPolicyOwnership",
    "WdfDeviceInitSetIoType",
    "WdfDeviceInitSetFileObjectConfig",
    "WdfDeviceInitSetRequestAttributes",
    "WdfDeviceCreate",
    "WdfDeviceSetStaticStopRemove",
    "WdfDeviceCreateDeviceInterface",
    "WdfDeviceSetDeviceInterfaceState",
    "WdfDeviceRetrieveDeviceInterfaceString",
    "WdfDeviceCreateSymbolicLink",
    "WdfDeviceQueryProperty",
    "WdfDeviceAllocAndQueryProperty",
    "WdfDeviceSetPnpCapabilities",
    "WdfDeviceSetPowerCapabilities",
    "WdfDeviceSetFailed",
    "WdfDeviceStopIdleNoTrack",
    "WdfDeviceResumeIdleNoTrack",
    "WdfDeviceGetFileObject",
    "WdfDeviceGetDefaultQueue",
    "WdfDeviceConfigureRequestDispatching",
    "WdfDeviceGetSystemPowerAction",
    "WdfDeviceInitSetReleaseHardwareOrderOnFailure",
    "WdfDeviceInitSetIoTypeEx",
    "WdfDevicePostEvent",
    "WdfDeviceMapIoSpace",
    "WdfDeviceUnmapIoSpace",
    "WdfDeviceGetHardwareRegisterMappedAddress",
    "WdfDeviceReadFromHardware",
    "WdfDeviceWriteToHardware",
    "WdfDeviceAssignInterfaceProperty",
    "WdfDeviceAllocAndQueryInterfaceProperty",
    "WdfDeviceQueryInterfaceProperty",
    "WdfDeviceGetDeviceStackIoType",
    "WdfDeviceQueryPropertyEx",
    "WdfDeviceAllocAndQueryPropertyEx",
    "WdfDeviceAssignProperty",
    "WdfDriverCreate",
    "WdfDriverGetRegistryPath",
    "WdfDriverOpenParametersRegistryKey",
    "WdfDriverRetrieveVersionString",
    "WdfDriverIsVersionAvailable",
    "WdfFdoInitOpenRegistryKey",
    "WdfFdoInitQueryProperty",
    "WdfFdoInitAllocAndQueryProperty",
    "WdfFdoInitQueryPropertyEx",
    "WdfFdoInitAllocAndQueryPropertyEx",
    "WdfFdoInitSetFilter",
    "WdfFileObjectGetFileName",
    "WdfFileObjectGetDevice",
    "WdfFileObjectGetInitiatorProcessId",
    "WdfFileObjectGetRelatedFileObject",
    "WdfInterruptCreate",
    "WdfInterruptQueueDpcForIsr",
    "WdfInterruptQueueWorkItemForIsr",
    "WdfInterruptSynchronize",
    "WdfInterruptAcquireLock",
    "WdfInterruptReleaseLock",
    "WdfInterruptEnable",
    "WdfInterruptDisable",
    "WdfInterruptGetInfo",
    "WdfInterruptSetPolicy",
    "WdfInterruptSetExtendedPolicy",
    "WdfInterruptGetDevice",
    "WdfInterruptTryToAcquireLock",
    "WdfIoQueueCreate",
    "WdfIoQueueGetState",
    "WdfIoQueueStart",
    "WdfIoQueueStop",
    "WdfIoQueueStopSynchronously",
    "WdfIoQueueGetDevice",
    "WdfIoQueueRetrieveNextRequest",
    "WdfIoQueueRetrieveRequestByFileObject",
    "WdfIoQueueFindRequest",
    "WdfIoQueueRetrieveFoundRequest",
    "WdfIoQueueDrainSynchronously",
    "WdfIoQueueDrain",
    "WdfIoQueuePurgeSynchronously",
    "WdfIoQueuePurge",
    "WdfIoQueueReadyNotify",
    "WdfIoQueueStopAndPurge",
    "WdfIoQueueStopAndPurgeSynchronously",
    "WdfIoTargetCreate",
    "WdfIoTargetOpen",
    "WdfIoTargetCloseForQueryRemove",
    "WdfIoTargetClose",
    "WdfIoTargetStart",
    "WdfIoTargetStop",
    "WdfIoTargetPurge",
    "WdfIoTargetGetState",
    "WdfIoTargetGetDevice",
    "WdfIoTargetSendReadSynchronously",
    "WdfIoTargetFormatRequestForRead",
    "WdfIoTargetSendWriteSynchronously",
    "WdfIoTargetFormatRequestForWrite",
    "WdfIoTargetSendIoctlSynchronously",
    "WdfIoTargetFormatRequestForIoctl",
    "WdfMemoryCreate",
    "WdfMemoryCreatePreallocated",
    "WdfMemoryGetBuffer",
    "WdfMemoryAssignBuffer",
    "WdfMemoryCopyToBuffer",
    "WdfMemoryCopyFromBuffer",
    "WdfObjectGetTypedContextWorker",
    "WdfObjectAllocateContext",
    "WdfObjectContextGetObject",
    "WdfObjectReferenceActual",
    "WdfObjectDereferenceActual",
    "WdfObjectCreate",
    "WdfObjectDelete",
    "WdfObjectQuery",
    "WdfRegistryOpenKey",
    "WdfRegistryCreateKey",
    "WdfRegistryClose",
    "WdfRegistryRemoveKey",
    "WdfRegistryRemoveValue",
    "WdfRegistryQueryValue",
    "WdfRegistryQueryMemory",
    "WdfRegistryQueryMultiString",
    "WdfRegistryQueryUnicodeString",
    "WdfRegistryQueryString",
    "WdfRegistryQueryULong",
    "WdfRegistryAssignValue",
    "WdfRegistryAssignMemory",
    "WdfRegistryAssignMultiString",
    "WdfRegistryAssignUnicodeString",
    "WdfRegistryAssignString",
    "WdfRegistryAssignULong",
    "WdfRequestCreate",
    "WdfRequestReuse",
    "WdfRequestChangeTarget",
    "WdfRequestFormatRequestUsingCurrentType",
    "WdfRequestSend",
    "WdfRequestGetStatus",
    "WdfRequestMarkCancelable",
    "WdfRequestMarkCancelableEx",
    "WdfRequestUnmarkCancelable",
    "WdfRequestIsCanceled",
    "WdfRequestCancelSentRequest",
    "WdfRequestIsFrom32BitProcess",
    "WdfRequestSetCompletionRoutine",
    "WdfRequestGetCompletionParams",
    "WdfRequestAllocateTimer",
    "WdfRequestComplete",
    "WdfRequestCompleteWithInformation",
    "WdfRequestGetParameters",
    "WdfRequestRetrieveInputMemory",
    "WdfRequestRetrieveOutputMemory",
    "WdfRequestRetrieveInputBuffer",
    "WdfRequestRetrieveOutputBuffer",
    "WdfRequestSetInformation",
    "WdfRequestGetInformation",
    "WdfRequestGetFileObject",
    "WdfRequestGetRequestorMode",
    "WdfRequestForwardToIoQueue",
    "WdfRequestGetIoQueue",
    "WdfRequestRequeue",
    "WdfRequestStopAcknowledge",
    "WdfRequestImpersonate",
    "WdfRequestGetRequestorProcessId",
    "WdfRequestIsFromUserModeDriver",
    "WdfRequestSetUserModeDriverInitiatedIo",
    "WdfRequestGetUserModeDriverInitiatedIo",
    "WdfRequestSetActivityId",
    "WdfRequestRetrieveActivityId",
    "WdfRequestGetEffectiveIoType",
    "WdfCmResourceListGetCount",
    "WdfCmResourceListGetDescriptor",
    "WdfStringCreate",
    "WdfStringGetUnicodeString",
    "WdfObjectAcquireLock",
    "WdfObjectReleaseLock",
    "WdfWaitLockCreate",
    "WdfWaitLockAcquire",
    "WdfWaitLockRelease",
    "WdfSpinLockCreate",
    "WdfSpinLockAcquire",
    "WdfSpinLockRelease",
    "WdfTimerCreate",
    "WdfTimerStart",
    "WdfTimerStop",
    "WdfTimerGetParentObject",
    "WdfUsbTargetDeviceCreate",
    "WdfUsbTargetDeviceCreateWithParameters",
    "WdfUsbTargetDeviceRetrieveInformation",
    "WdfUsbTargetDeviceGetDeviceDescriptor",
    "WdfUsbTargetDeviceRetrieveConfigDescriptor",
    "WdfUsbTargetDeviceQueryString",
    "WdfUsbTargetDeviceAllocAndQueryString",
    "WdfUsbTargetDeviceFormatRequestForString",
    "WdfUsbTargetDeviceGetNumInterfaces",
    "WdfUsbTargetDeviceSelectConfig",
    "WdfUsbTargetDeviceSendControlTransferSynchronously",
    "WdfUsbTargetDeviceFormatRequestForControlTransfer",
    "WdfUsbTargetDeviceResetPortSynchronously",
    "WdfUsbTargetDeviceQueryUsbCapability",
    "WdfUsbTargetPipeGetInformation",
    "WdfUsbTargetPipeIsInEndpoint",
    "WdfUsbTargetPipeIsOutEndpoint",
    "WdfUsbTargetPipeGetType",
    "WdfUsbTargetPipeSetNoMaximumPacketSizeCheck",
    "WdfUsbTargetPipeWriteSynchronously",
    "WdfUsbTargetPipeFormatRequestForWrite",
    "WdfUsbTargetPipeReadSynchronously",
    "WdfUsbTargetPipeFormatRequestForRead",
    "WdfUsbTargetPipeConfigContinuousReader",
    "WdfUsbTargetPipeAbortSynchronously",
    "WdfUsbTargetPipeFormatRequestForAbort",
    "WdfUsbTargetPipeResetSynchronously",
    "WdfUsbTargetPipeFormatRequestForReset",
    "WdfUsbInterfaceGetInterfaceNumber",
    "WdfUsbInterfaceGetNumEndpoints",
    "WdfUsbInterfaceGetDescriptor",
    "WdfUsbInterfaceGetNumSettings",
    "WdfUsbInterfaceSelectSetting",
    "WdfUsbInterfaceGetEndpointInformation",
    "WdfUsbTargetDeviceGetInterface",
    "WdfUsbInterfaceGetConfiguredSettingIndex",
    "WdfUsbInterfaceGetNumConfiguredPipes",
    "WdfUsbInterfaceGetConfiguredPipe",
    "WdfVerifierDbgBreakPoint",
    "WdfVerifierKeBugCheck",
    "WdfGetTriageInfo",
    "WdfWorkItemCreate",
    "WdfWorkItemEnqueue",
    "WdfWorkItemGetParentObject",
    "WdfWorkItemFlush",
    "WdfRegistryWdmGetHandle",
    "WdfDeviceStopIdleActual",
    "WdfDeviceResumeIdleActual",
    "WdfDeviceInitEnableHidInterface",
    "WdfDeviceHidNotifyPresence",
    "WdfDeviceGetSelfIoTarget",
    "WdfDeviceInitAllowSelfIoTarget",
    "WdfIoTargetSelfAssignDefaultIoQueue",
    "WdfDeviceOpenDevicemapKey",
    "WdfIoTargetWdmGetTargetFileHandle", # here ends version 2.15
    "WdfDeviceWdmDispatchIrp",
    "WdfDeviceWdmDispatchIrpToIoQueue",
    "WdfDeviceConfigureWdmIrpDispatchCallback", # here ends version 2.17
    "WdfCxDeviceInitSetPnpPowerEventCallbacks", # here ends version 2.19 and 2.21
    "WdfCompanionCreate",
    "WdfCompanionWdmGetSecureDeviceHandle",
    "WdfCompanionCreateTaskQueue",
    "WdfDeviceInitSetCompanionEventCallbacks", # here ends version 2.23
    "WdfDriverOpenPersistentStateRegistryKey",
    "WdfDriverErrorReportApiMissing",
    "WdfDeviceRetrieveDeviceDirectoryString", # here ends version 2.25
    "WdfDriverRetrieveDriverDataDirectoryString", # here ends version 2.27
    "WdfCxDeviceInitAllocateContext",
    "WdfCxDeviceInitGetTypedContextWorker",
    "WdfCxDeviceInitSetPowerPolicyEventCallbacks",
    "WdfDeviceSetDeviceInterfaceStateEx", # here ends version 2.31
    "WdfDeviceWdmAssignPowerFrameworkSettings" # here ends version 2.33
    ]

umdf2_minor_revision = [
    MinorRevision(15, 257),
    MinorRevision(17, 260),
    MinorRevision(19, 261),
    MinorRevision(21, 261),
    MinorRevision(23, 265),
    MinorRevision(25, 268),
    MinorRevision(27, 269),
    MinorRevision(31, 273),
    MinorRevision(33, 274),
]

Wdfs = {
    "KmdfLibrary" : {
        1: WdfStruct(kmdf1_major, kmdf_minor_revision)
    },
    "UmdfLibrary" : {
       2: WdfStruct(umdf2_major, umdf2_minor_revision)
    }
}
