<?php

namespace Test\Ease;

use Ease\WebPage;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2016-01-17 at 23:58:34.
 */
class WebPageTest extends PageTest
{
    /**
     * @var WebPage
     */
    protected $object;

    public $rendered = '<!DOCTYPE html><html lang="cs-CZ"><head><meta http-equiv="Content-Type" content="text/html; charset=utf-8" /><title></title><link href="test.css" rel="stylesheet" type="text/css" media="screen" /><style>border: 1px solid red</style>
<script>
// <![CDATA[
window.location = "login.php"
// ]]>
</script>

<script>
// <![CDATA[
window.location = "http://v.s.cz/"
// ]]>
</script>

<script src="test.js"></script>
<script>
// <![CDATA[
$(document).ready(function () { alert("test") });
// ]]>
</script>
</head><body></body></html>';


    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new WebPage();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
    }

    /**
     * @covers Ease\WebPage::setTagID
     */
    public function testSetTagID()
    {
        $this->object->setTagID('test');
        $this->assertEquals('test', $this->object->getTagID() );
    }

    /**
     * @covers Ease\WebPage::addItem
     */
    public function testAddItem()
    {
        $this->object->emptyContents();
        $tester = new \Ease\Html\SpanTag();
        $this->object->addItem( $tester );
        $this->assertEquals($this->object->getFirstPart(),$tester);
    }

    /**
     * @covers Ease\WebPage::includeJavaScript
     */
    public function testIncludeJavaScript()
    {
        $this->object->includeJavaScript('test.js');
        $this->assertEquals( ['#test.js'], \Ease\Shared::instanced()->javaScripts );
    }

    /**
     * @covers Ease\WebPage::addJavaScript
     */
    public function testAddJavaScript()
    {
        $this->object->addJavaScript('alert("test")');
    }

    /**
     * @covers Ease\WebPage::addToScriptsStack
     */
    public function testAddToScriptsStack()
    {
        $this->object->addToScriptsStack('var test = 1;');
    }

    /**
     * @covers Ease\WebPage::addCSS
     */
    public function testAddCSS()
    {
        $this->object->addCSS('border: 1px solid red');
    }

    /**
     * @covers Ease\WebPage::includeCss
     */
    public function testIncludeCss()
    {
        $this->object->includeCss('test.css');
    }

    /**
     * @covers Ease\WebPage::getStatusMessagesAsHtml
     */
    public function testGetStatusMessagesAsHtml()
    {
        $this->object->getStatusMessagesAsHtml();
    }

    /**
     * @covers Ease\WebPage::draw
     *
     * @todo   Implement testDraw().
     */
    public function testDraw($whatWant = null)
    {
        // Remove the following lines when you implement this test.
        $this->markTestIncomplete(
            'This test has not been implemented yet.'
        );
    }

    /**
     * @covers Ease\WebPage::finalizeRegistred
     *
     * @todo   Implement testFinalizeRegistred().
     */
    public function testFinalizeRegistred()
    {
        // Remove the following lines when you implement this test.
        $this->markTestIncomplete(
            'This test has not been implemented yet.'
        );
    }

    /**
     * @covers Ease\WebPage::setPageTitle
     *
     * @todo   Implement testSetPageTitle().
     */
    public function testSetPageTitle()
    {
        // Remove the following lines when you implement this test.
        $this->markTestIncomplete(
            'This test has not been implemented yet.'
        );
    }
}
