<?php

namespace Test\Ease;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2016-10-23 at 14:10:35.
 */
class MailerTest extends PageTest
{
    /**
     * @var Mailer
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new \Ease\Mailer('info@vitexsoftware.cz', 'Unit Test');
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
        
    }

    public function testConstructor()
    {
        $classname = get_class($this->object);

        // Get mock, without the constructor being called
        $mock = $this->getMockBuilder($classname)
            ->disableOriginalConstructor()
            ->getMockForAbstractClass();
        $mock->__construct('info@vitexsoftware.cz', 'Unit Test');

        $mock->__construct('vitex@hippy.cz', 'Hallo', 'PHPUnit works well!');
    }

    /**
     * @covers Ease\Mailer::setMailHeaders
     */
    public function testSetMailHeaders()
    {
        $this->object->mailHeaders['From'] = 'ease@framework.cz';
        $this->object->setMailHeaders(['x-mail' => 'test']);
        $this->assertEquals('test', $this->object->getMailHeader('x-mail'));
        $this->assertEquals('ease@framework.cz',
            $this->object->getMailHeader('From'));
    }

    /**
     * @covers Ease\Mailer::getMailHeader
     */
    public function testGetMailHeader()
    {
        $this->assertEquals('info@vitexsoftware.cz',
            $this->object->getMailHeader('To'));
    }

    /**
     * @covers Ease\Mailer::addItem
     */
    public function testAddItem()
    {
        $this->object->addItem(new \Ease\Html\H1Tag());
    }

    /**
     * @covers Ease\Mailer::addFile
     */
    public function testAddFile()
    {
        $this->object->addFile('README.md', 'text/markdown');
    }

    /**
     * @covers Ease\Mailer::finalize
     */
    public function testFinalize()
    {
        $this->object->finalize();
    }

    /**
     * @covers Ease\Mailer::getRendered
     */
    public function testGetRendered()
    {
        $this->assertEmpty($this->object->getRendered());
    }

    /**
     * @covers Ease\Mailer::draw
     */
    public function testDraw($whatWant = NULL)
    {
        $this->assertEmpty($this->object->draw());
    }

    /**
     * @covers Ease\Mailer::send
     */
    public function testSend()
    {
        $this->object->send();
    }

    /**
     * @covers Ease\Mailer::setUserNotification
     */
    public function testSetUserNotification()
    {
        $this->object->setUserNotification('true');
    }

    /**
     * @covers Ease\Mailer::getItemsCount
     */
    public function testGetItemsCount()
    {
        $this->object->emptyContents();
        $this->assertEquals(0, $this->object->getItemsCount());
        $this->object->addItem('@');
        $this->assertEquals(0, $this->object->getItemsCount());
        $this->assertEquals(2,
            $this->object->getItemsCount(new \Ease\Html\DivTag(['a', 'b'])));
    }

    /**
     * @covers Ease\Mailer::isEmpty
     */
    public function testIsEmpty()
    {
        $this->object->emptyContents();
        $this->assertTrue($this->object->isEmpty());
        $this->object->addItem('@');
        $this->assertTrue($this->object->isEmpty($this->object));
    }

    /**
     * @covers Ease\Mailer::addItemCustom
     */
    public function testAddItemCustom()
    {
        $context = new \Ease\Html\DivTag();
        \Ease\Container::addItemCustom('*', $context);
        $this->assertEquals("\n<div>*</div>", $context->getRendered());

        $context = new \Ease\Html\DivTag();
        \Ease\Container::addItemCustom(new \Ease\Html\ImgTag(null), $context);
        $this->object->addItem([new \Ease\Html\ATag('#', 'TEST'), new \Ease\Html\ATag('#',
                'TEST')]);
    }

    /**
     * @covers Ease\Mailer::getFirstPart
     */
    public function testGetFirstPart()
    {
        $this->object->emptyContents();
        $this->object->addItem(new \Ease\Html\DivTag());
        $this->object->addItem(new \Ease\Html\ATag('', ''));
        $this->object->addItem(new \Ease\Html\PTag());
        $controlDiv               = new \Ease\Html\DivTag();
        $controlDiv->parentObject = $this->object;
    }
    
    /**
     * @covers Ease\Mailer::addAsFirst
     *
     * @todo   Implement testAddAsFirst().
     */
    public function testAddAsFirst()
    {
        $this->object->emptyContents();
        $this->object->addItem(new \Ease\Html\DivTag());
        $this->object->addAsFirst(new \Ease\Html\SpanTag());
    }
   
    
    
}
