<?php

namespace Test\Ease;

use Ease\Brick;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2016-01-17 at 23:23:11.
 */
class BrickTest extends SandTest
{
    /**
     * @var Brick
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new Local\BrickTester();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {
        
    }

    /**
     * @covers Ease\Brick::getstatusMessages
     */
    public function testgetStatusMessages()
    {
        $this->object->cleanMessages();
        $this->object->addStatusMessage('Message', 'mail');
        $this->object->addStatusMessage('Message', 'warning');
        $this->object->addStatusMessage('Message', 'debug');
        $this->object->addStatusMessage('Message', 'error');
        $messages = $this->object->getStatusMessages();
        $this->assertEquals(4, count($messages));
    }

    /**
     * @covers Ease\Brick::setObjectName
     */
    public function testSetObjectName()
    {
//        parent::testSetObjectName();
        $this->object->setMyKey(123);
        $this->object->setObjectName();
        $this->assertEquals(get_class($this->object).'@123',
            $this->object->getObjectName());
    }

    /**
     * @covers Ease\Brick::addStatusMessage
     */
    public function testaddStatusMessage()
    {
        $this->object->addStatusMessage('Testing');
        $this->object->addStatusMessage('email Message', 'email');
        $this->object->addStatusMessage('warning Message', 'warning');
        $this->object->addStatusMessage('debug Message', 'debug');
        $this->object->addStatusMessage('error Message', 'error');
        $this->object->addStatusMessage('success Message', 'success');
        $messages = $this->object->getStatusMessages();
        $this->assertEquals($messages, $messages);
    }

    /**
     * @expectedException \Ease\Exception
     * @expectedExceptionMessage getColumnsFromSQL: Missing ColumnList
     * @covers Ease\Brick::getColumnsFromSQL
     */
    public function testGetColumnsFromSQL()
    {
        if (\Ease\Shared::db()->isConnected()) {
            $this->object->takemyTable('test');
            $this->assertEquals([0 => ['id' => '3']],
                $this->object->getColumnsFromSQL('id', 3));

            $ids   = $this->object->getColumnsFromSQL(array('id'));
            $this->assertEquals([0 => ['id' => 3], 1 => ['id' => 2]], $ids);
            $names = $this->object->getColumnsFromSQL(array('name'));
            $this->assertEquals($names,
                [0 => ['name' => 'alpha'], 1 => ['name' => 'beta']]);
            $all   = $this->object->getColumnsFromSQL('*', null, 'name', 'id');
            $this->assertEquals([2 => ['id' => 2, 'name' => 'beta', 'datim' => '2015-11-18 00:00:00'],
                3 => ['id' => '3', 'name' => 'alpha', 'datim' => '2015-11-17 00:00:00'],],
                $all);
            $some  = $this->object->getColumnsFromSQL(['name', 'id'],
                "test.datim = '2015-11-18 00:00:00'");
            $this->assertEquals([0 => ['name' => 'beta', 'id' => 2]], $some);
            $this->object->getColumnsFromSQL(null);
        } else {
            $this->markTestSkipped('Database not used');
        }
    }

    /**
     * @covers Ease\Brick::getDataFromSQL
     */
    public function testGetDataFromSQL()
    {
        if (\Ease\Shared::db()->isConnected()) {
            $this->object->takemyTable('test');
            $this->assertNotEmpty($this->object->getDataFromSQL(3),
                 'Error Reading data from SQL');
        } else {
            $this->markTestSkipped(
                'Object do not use SQL'
            );
        }
    }

    /**
     * @covers Ease\Brick::loadFromSQL
     */
    public function testLoadFromSQL()
    {
        if (\Ease\Shared::db()->isConnected()) {
            $this->object->takemyTable('test');
            $this->object->loadFromSQL(2);
            $this->assertEquals(2, $this->object->getMyKey());
        } else {
            $this->markTestSkipped('Object do not use SQL');
        }
    }

    /**
     * @covers Ease\Brick::getAllFromSQL
     */
    public function testGetAllFromSQL()
    {
        if(is_object($this->object->dblink)){
        $all = $this->object->getAllFromSQL('test', ['name', 'datim'], 1,
            'datim', 'name');
        $this->assertEquals(1, count($all));
    }
    }

    /**
     * @covers Ease\Brick::updateToSQL
     */
    public function testUpdateToSQL()
    {
        $this->object->updateToSQL(['id' => 3, 'name' => 'updateTested', 'datim' => 'NOW()']);
    }

    /**
     * @covers Ease\Brick::saveToSQL
     */
    public function testSaveToSQL()
    {
        $this->object->updateToSQL(['id' => 2, 'name' => 'SaveUpdateTested', 'datim' => 'NOW()']);
        $this->object->updateToSQL(['name' => 'SaveInsertTested', 'datim' => 'NOW()']);
    }

    /**
     * @covers Ease\Brick::insertToSQL
     */
    public function testInsertToSQL()
    {
        $this->object->updateToSQL(['name' => 'insertTested', 'datim' => 'NOW()']);
    }

    /**
     * @covers Ease\Brick::deleteFromSQL
     * @after testInsertToSQL
     */
    public function testDeleteFromSQL()
    {
        $idsRaw = $this->object->getColumnsFromSQL('id');
        if ($idsRaw) {
            $lastid = end($idsRaw)['id'];
        } else {
            $lastid = 1;
        }
        $this->object->deleteFromSQL($lastid);
    }

    /**
     * @covers Ease\Brick::takeToData
     */
    public function testTakeToData()
    {
        $this->object->takeToData(['a' => 1, 'b' => 2],'b', false, 'name');
        $this->object->takeToData(['c' => 3, 'd' => null],'b', true, 'code');
    }

    /**
     * @covers Ease\Brick::getSQLList
     */
    public function testGetSQLList()
    {
        $this->object->getSQLList();
    }

    /**
     * @covers Ease\Brick::takemyTable
     */
    public function testTakemyTable()
    {
        $this->object->takemyTable($this->object->getMyTable());
    }

    /**
     * @covers Ease\Brick::getMyTable
     */
    public function testGetMyTable()
    {
        $this->object->setmyTable('testing');
        $this->assertEquals('testing', $this->object->getMyTable());
    }

    /**
     * @covers Ease\Brick::setmyTable
     */
    public function testSetmyTable()
    {
        $this->object->setmyTable('test');
        $this->assertEquals('test', $this->object->getMyTable());
    }

    /**
     * @covers Ease\Brick::getSQLItemsCount
     */
    public function testGetSQLItemsCount()
    {
        $this->object->getSQLItemsCount();
    }

    /**
     * @covers Ease\Brick::lettersOnly
     */
    public function testLettersOnly()
    {
        $this->assertEquals('1a2b3', $this->object->lettersOnly('1a2b_3'));
    }

    /**
     * @covers Ease\Brick::searchColumns
     */
    public function testSearchColumns()
    {
        $this->object->searchColumns('test', ['name']);
    }
}
