<?php

namespace Test\Ease;

use Ease\Anonym;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2016-01-17 at 23:58:38.
 */
class AnonymTest extends BrickTest
{
    /**
     * @var Anonym
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp(): void
    {
        $this->object = new Anonym();
        $this->object->takemyTable('test');
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown(): void
    {

    }

    /**
     * @covers Ease\Anonym::setObjectName
     */
    public function testSetObjectName()
    {
        $this->assertEquals(get_class($this->object),
            $this->object->setObjectName());
        $this->assertEquals('Test', $this->object->setObjectName('Test'));
        $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
        $this->assertEquals('Ease\Anonym@127.0.0.1',
            $this->object->setObjectName());
        $_SERVER['REMOTE_USER'] = 'tester';
        $this->assertEquals('Ease\Anonym@127.0.0.1 [tester]',
            $this->object->setObjectName());
    }

    /**
     * @covers Ease\Anonym::remoteToIdentity
     */
    public function testRemoteToIdentity()
    {
        $_SERVER['REMOTE_ADDR'] = '127.0.0.1';
        $this->assertEquals('127.0.0.1', $this->object->remoteToIdentity());
        $_SERVER['REMOTE_USER'] = 'tester';
        $this->assertEquals('127.0.0.1 [tester]',
            $this->object->remoteToIdentity());
    }

    /**
     * @covers Ease\Anonym::getUserLevel
     */
    public function testGetUserLevel()
    {
        $this->assertEquals(-1, $this->object->getUserLevel());
    }

    /**
     * @covers Ease\Anonym::getUserID
     */
    public function testGetUserID()
    {
        $this->assertNull($this->object->getUserID());
    }

    /**
     * @covers Ease\Anonym::getUserLogin
     */
    public function testGetUserLogin()
    {
        $this->assertNull($this->object->getUserLogin());
    }

    /**
     * @covers Ease\Anonym::isLogged
     */
    public function testIsLogged()
    {
        $this->assertFalse($this->object->isLogged());
    }

    /**
     * @covers Ease\Anonym::getSettingValue
     */
    public function testGetSettingValue()
    {
        $this->assertNull($this->object->getSettingValue('test'));
    }

    /**
     * @covers Ease\Anonym::getUserEmail
     */
    public function testGetUserEmail()
    {
        $this->assertNull($this->object->getUserEmail());
    }

    /**
     * @covers Ease\Anonym::getPermission
     */
    public function testGetPermission()
    {
        $this->assertNull($this->object->getPermission());
    }

    /**
     * @covers Ease\Anonym::logout
     */
    public function testLogout()
    {
        $this->assertTrue($this->object->logout());
    }
}
