// Code generated by github.com/Khan/genqlient, DO NOT EDIT.

package cloudproviders

import (
	"context"
	"encoding/json"
	"fmt"

	"github.com/Khan/genqlient/graphql"
)

type CertificateProvisioningAWSOptionsInput struct {
	// Amazon Resource Name (ARN) uniquely identifying AWS certificate resource
	Arn  *string                                  `json:"arn"`
	Tags []*CertificateProvisioningTagOptionInput `json:"tags,omitempty"`
}

// GetArn returns CertificateProvisioningAWSOptionsInput.Arn, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningAWSOptionsInput) GetArn() *string { return v.Arn }

// GetTags returns CertificateProvisioningAWSOptionsInput.Tags, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningAWSOptionsInput) GetTags() []*CertificateProvisioningTagOptionInput {
	return v.Tags
}

type CertificateProvisioningAzureOptionsInput struct {
	// An Azure object-name is a user provided name for and must be unique within a key vault. The name must be a 1-127 character string, starting with a letter and containing only 0-9, a-z, A-Z, and -.
	Name       *string                                  `json:"name"`
	Enabled    *bool                                    `json:"enabled"`
	Exportable *bool                                    `json:"exportable"`
	ReuseKey   *bool                                    `json:"reuseKey"`
	Tags       []*CertificateProvisioningTagOptionInput `json:"tags,omitempty"`
}

// GetName returns CertificateProvisioningAzureOptionsInput.Name, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningAzureOptionsInput) GetName() *string { return v.Name }

// GetEnabled returns CertificateProvisioningAzureOptionsInput.Enabled, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningAzureOptionsInput) GetEnabled() *bool { return v.Enabled }

// GetExportable returns CertificateProvisioningAzureOptionsInput.Exportable, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningAzureOptionsInput) GetExportable() *bool { return v.Exportable }

// GetReuseKey returns CertificateProvisioningAzureOptionsInput.ReuseKey, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningAzureOptionsInput) GetReuseKey() *bool { return v.ReuseKey }

// GetTags returns CertificateProvisioningAzureOptionsInput.Tags, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningAzureOptionsInput) GetTags() []*CertificateProvisioningTagOptionInput {
	return v.Tags
}

type CertificateProvisioningGCPOptionsInput struct {
	// A GCM certificate id is a user provider name and must be unique within a region. The id must be a 1-63 character string, start with a letter and only contain lower case letters, digits and hyphens.
	Id          *string                                  `json:"id"`
	Description *string                                  `json:"description"`
	Scope       *GCMCertificateScope                     `json:"scope"`
	Labels      []*CertificateProvisioningTagOptionInput `json:"labels,omitempty"`
}

// GetId returns CertificateProvisioningGCPOptionsInput.Id, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningGCPOptionsInput) GetId() *string { return v.Id }

// GetDescription returns CertificateProvisioningGCPOptionsInput.Description, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningGCPOptionsInput) GetDescription() *string { return v.Description }

// GetScope returns CertificateProvisioningGCPOptionsInput.Scope, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningGCPOptionsInput) GetScope() *GCMCertificateScope { return v.Scope }

// GetLabels returns CertificateProvisioningGCPOptionsInput.Labels, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningGCPOptionsInput) GetLabels() []*CertificateProvisioningTagOptionInput {
	return v.Labels
}

type CertificateProvisioningOptionsInput struct {
	AwsOptions   *CertificateProvisioningAWSOptionsInput   `json:"awsOptions,omitempty"`
	AzureOptions *CertificateProvisioningAzureOptionsInput `json:"azureOptions,omitempty"`
	GcpOptions   *CertificateProvisioningGCPOptionsInput   `json:"gcpOptions,omitempty"`
}

// GetAwsOptions returns CertificateProvisioningOptionsInput.AwsOptions, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningOptionsInput) GetAwsOptions() *CertificateProvisioningAWSOptionsInput {
	return v.AwsOptions
}

// GetAzureOptions returns CertificateProvisioningOptionsInput.AzureOptions, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningOptionsInput) GetAzureOptions() *CertificateProvisioningAzureOptionsInput {
	return v.AzureOptions
}

// GetGcpOptions returns CertificateProvisioningOptionsInput.GcpOptions, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningOptionsInput) GetGcpOptions() *CertificateProvisioningGCPOptionsInput {
	return v.GcpOptions
}

type CertificateProvisioningTagOptionInput struct {
	Name  string `json:"name"`
	Value string `json:"value"`
}

// GetName returns CertificateProvisioningTagOptionInput.Name, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningTagOptionInput) GetName() string { return v.Name }

// GetValue returns CertificateProvisioningTagOptionInput.Value, and is useful for accessing the field via an interface.
func (v *CertificateProvisioningTagOptionInput) GetValue() string { return v.Value }

// Indicates the type of a Cloud Keystore
type CloudKeystoreType string

const (
	// AWS Certificate Manager
	CloudKeystoreTypeAcm CloudKeystoreType = "ACM"
	// Azure Key Vault
	CloudKeystoreTypeAkv CloudKeystoreType = "AKV"
	// Google Certificate Manager
	CloudKeystoreTypeGcm CloudKeystoreType = "GCM"
)

// Indicates the status of a cloud provider
type CloudProviderStatus string

const (
	// The cloud provider is successfully validated
	CloudProviderStatusValidated CloudProviderStatus = "VALIDATED"
	// The cloud provider is not validated or the validation fails for some reason
	CloudProviderStatusNotValidated CloudProviderStatus = "NOT_VALIDATED"
)

// Indicates the type of a Cloud Provider
type CloudProviderType string

const (
	// AWS cloud provider type
	CloudProviderTypeAws CloudProviderType = "AWS"
	// Azure cloud provider type
	CloudProviderTypeAzure CloudProviderType = "AZURE"
	// Google cloud provider type
	CloudProviderTypeGcp CloudProviderType = "GCP"
)

// DeleteMachineIdentitiesResponse is returned by DeleteMachineIdentities on success.
type DeleteMachineIdentitiesResponse struct {
	// Deletes a list of Cloud machine identities
	DeleteCloudMachineIdentities bool `json:"deleteCloudMachineIdentities"`
}

// GetDeleteCloudMachineIdentities returns DeleteMachineIdentitiesResponse.DeleteCloudMachineIdentities, and is useful for accessing the field via an interface.
func (v *DeleteMachineIdentitiesResponse) GetDeleteCloudMachineIdentities() bool {
	return v.DeleteCloudMachineIdentities
}

// Indicates the Scope for a certificate provisioned to GCP Certificate Manager
type GCMCertificateScope string

const (
	// Certificates with default scope are served from core Google data centers. If unsure, choose this option.
	GCMCertificateScopeDefault GCMCertificateScope = "DEFAULT"
	// Certificates with scope EDGE_CACHE are special-purposed certificates, served from Edge Points of Presence.
	// See https://cloud.google.com/vpc/docs/edge-locations.
	GCMCertificateScopeEdgeCache GCMCertificateScope = "EDGE_CACHE"
)

// GetCloudKeystoresCloudKeystoresCloudKeystoreConnection includes the requested fields of the GraphQL type CloudKeystoreConnection.
// The GraphQL type's documentation follows.
//
// A page of CloudKeystore results
type GetCloudKeystoresCloudKeystoresCloudKeystoreConnection struct {
	// CloudKeystores in the current page, without cursor
	Nodes []*GetCloudKeystoresCloudKeystoresCloudKeystoreConnectionNodesCloudKeystore `json:"nodes"`
}

// GetNodes returns GetCloudKeystoresCloudKeystoresCloudKeystoreConnection.Nodes, and is useful for accessing the field via an interface.
func (v *GetCloudKeystoresCloudKeystoresCloudKeystoreConnection) GetNodes() []*GetCloudKeystoresCloudKeystoresCloudKeystoreConnectionNodesCloudKeystore {
	return v.Nodes
}

// GetCloudKeystoresCloudKeystoresCloudKeystoreConnectionNodesCloudKeystore includes the requested fields of the GraphQL type CloudKeystore.
type GetCloudKeystoresCloudKeystoresCloudKeystoreConnectionNodesCloudKeystore struct {
	Id string `json:"id"`
	// Cloud Keystore name
	//
	// A string between 3 and 250 characters
	Name                   string            `json:"name"`
	Type                   CloudKeystoreType `json:"type"`
	MachineIdentitiesCount int               `json:"machineIdentitiesCount"`
}

// GetId returns GetCloudKeystoresCloudKeystoresCloudKeystoreConnectionNodesCloudKeystore.Id, and is useful for accessing the field via an interface.
func (v *GetCloudKeystoresCloudKeystoresCloudKeystoreConnectionNodesCloudKeystore) GetId() string {
	return v.Id
}

// GetName returns GetCloudKeystoresCloudKeystoresCloudKeystoreConnectionNodesCloudKeystore.Name, and is useful for accessing the field via an interface.
func (v *GetCloudKeystoresCloudKeystoresCloudKeystoreConnectionNodesCloudKeystore) GetName() string {
	return v.Name
}

// GetType returns GetCloudKeystoresCloudKeystoresCloudKeystoreConnectionNodesCloudKeystore.Type, and is useful for accessing the field via an interface.
func (v *GetCloudKeystoresCloudKeystoresCloudKeystoreConnectionNodesCloudKeystore) GetType() CloudKeystoreType {
	return v.Type
}

// GetMachineIdentitiesCount returns GetCloudKeystoresCloudKeystoresCloudKeystoreConnectionNodesCloudKeystore.MachineIdentitiesCount, and is useful for accessing the field via an interface.
func (v *GetCloudKeystoresCloudKeystoresCloudKeystoreConnectionNodesCloudKeystore) GetMachineIdentitiesCount() int {
	return v.MachineIdentitiesCount
}

// GetCloudKeystoresResponse is returned by GetCloudKeystores on success.
type GetCloudKeystoresResponse struct {
	// Retrieves Cloud Keystores.
	// The pagination can be either forward or backward. To enable forward pagination, two arguments
	// are used: `after` and `first`. To enable backward pagination, two arguments are used: `before` and `last`.
	// If arguments for both forward and backward pagination are supplied, forward pagination wil be used. If no arguments
	// are supplied, it returns the first page of 10 cloud keystores (i.e. defaults `first` to 10). The result is sorted by
	// the added on date in ascending order.
	// - after: returns the elements in the list that come after the specified cursor. Defaults to empty string, meaning
	// that we return the first page of cloud providers, if `first` value is supplied
	// - first: non-negative integer, denoting the first `n` number of records to return after the `after` cursor value.
	// Max value is 100
	// - before: returns the elements in the list that come before the specified cursor. By default is the empty string,
	// meaning that the results will be the last page, if `last` value is supplied
	// - last: non-negative integer, denoting the last `n` number of records to return before the `before` cursor value.
	// Max value is 100
	CloudKeystores *GetCloudKeystoresCloudKeystoresCloudKeystoreConnection `json:"cloudKeystores"`
}

// GetCloudKeystores returns GetCloudKeystoresResponse.CloudKeystores, and is useful for accessing the field via an interface.
func (v *GetCloudKeystoresResponse) GetCloudKeystores() *GetCloudKeystoresCloudKeystoresCloudKeystoreConnection {
	return v.CloudKeystores
}

// GetCloudProvidersCloudProvidersCloudProviderConnection includes the requested fields of the GraphQL type CloudProviderConnection.
// The GraphQL type's documentation follows.
//
// A page of CloudProvider results
type GetCloudProvidersCloudProvidersCloudProviderConnection struct {
	// CloudProviders in the current page, without cursor
	Nodes []*GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider `json:"nodes"`
}

// GetNodes returns GetCloudProvidersCloudProvidersCloudProviderConnection.Nodes, and is useful for accessing the field via an interface.
func (v *GetCloudProvidersCloudProvidersCloudProviderConnection) GetNodes() []*GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider {
	return v.Nodes
}

// GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider includes the requested fields of the GraphQL type CloudProvider.
type GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider struct {
	Id             string              `json:"id"`
	Name           string              `json:"name"`
	Type           CloudProviderType   `json:"type"`
	Status         CloudProviderStatus `json:"status"`
	StatusDetails  *string             `json:"statusDetails"`
	KeystoresCount int                 `json:"keystoresCount"`
}

// GetId returns GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider.Id, and is useful for accessing the field via an interface.
func (v *GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider) GetId() string {
	return v.Id
}

// GetName returns GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider.Name, and is useful for accessing the field via an interface.
func (v *GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider) GetName() string {
	return v.Name
}

// GetType returns GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider.Type, and is useful for accessing the field via an interface.
func (v *GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider) GetType() CloudProviderType {
	return v.Type
}

// GetStatus returns GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider.Status, and is useful for accessing the field via an interface.
func (v *GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider) GetStatus() CloudProviderStatus {
	return v.Status
}

// GetStatusDetails returns GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider.StatusDetails, and is useful for accessing the field via an interface.
func (v *GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider) GetStatusDetails() *string {
	return v.StatusDetails
}

// GetKeystoresCount returns GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider.KeystoresCount, and is useful for accessing the field via an interface.
func (v *GetCloudProvidersCloudProvidersCloudProviderConnectionNodesCloudProvider) GetKeystoresCount() int {
	return v.KeystoresCount
}

// GetCloudProvidersResponse is returned by GetCloudProviders on success.
type GetCloudProvidersResponse struct {
	// Retrieves Cloud Providers.
	// The pagination can be either forward or backward. To enable forward pagination, two arguments
	// are used: `after` and `first`. To enable backward pagination, two arguments are used: `before` and `last`.
	// If arguments for both forward and backward pagination are supplied, forward pagination wil be used. If no arguments
	// are supplied, it returns the first page of 10 cloud providers (i.e. defaults `first` to 10). The result is sorted by
	// the added on date in ascending order.
	// - after: returns the elements in the list that come after the specified cursor. Defaults to empty string, meaning
	// that we return the first page of cloud providers, if `first` value is supplied
	// - first: non-negative integer, denoting the first `n` number of records to return after the `after` cursor value.
	// Max value is 100
	// - before: returns the elements in the list that come before the specified cursor. By default is the empty string,
	// meaning that the results will be the last page, if `last` value is supplied
	// - last: non-negative integer, denoting the last `n` number of records to return before the `before` cursor value.
	// Max value is 100
	CloudProviders *GetCloudProvidersCloudProvidersCloudProviderConnection `json:"cloudProviders"`
}

// GetCloudProviders returns GetCloudProvidersResponse.CloudProviders, and is useful for accessing the field via an interface.
func (v *GetCloudProvidersResponse) GetCloudProviders() *GetCloudProvidersCloudProvidersCloudProviderConnection {
	return v.CloudProviders
}

// GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnection includes the requested fields of the GraphQL type MachineIdentityConnection.
// The GraphQL type's documentation follows.
//
// A page of MachineIdentity results
type GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnection struct {
	// MachineIdentity in the current page, without cursor
	Nodes []*GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity `json:"nodes"`
}

// GetNodes returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnection.Nodes, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnection) GetNodes() []*GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity {
	return v.Nodes
}

// GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity includes the requested fields of the GraphQL type MachineIdentity.
type GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity struct {
	Id                string                                                                                                                   `json:"id"`
	CloudKeystoreId   string                                                                                                                   `json:"cloudKeystoreId"`
	CloudKeystoreName *string                                                                                                                  `json:"cloudKeystoreName"`
	CloudProviderId   *string                                                                                                                  `json:"cloudProviderId"`
	CloudProviderName *string                                                                                                                  `json:"cloudProviderName"`
	Metadata          *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata `json:"-"`
	Status            MachineIdentityStatus                                                                                                    `json:"status"`
	StatusDetails     *string                                                                                                                  `json:"statusDetails"`
	CertificateId     string                                                                                                                   `json:"certificateId"`
}

// GetId returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity.Id, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity) GetId() string {
	return v.Id
}

// GetCloudKeystoreId returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity.CloudKeystoreId, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity) GetCloudKeystoreId() string {
	return v.CloudKeystoreId
}

// GetCloudKeystoreName returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity.CloudKeystoreName, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity) GetCloudKeystoreName() *string {
	return v.CloudKeystoreName
}

// GetCloudProviderId returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity.CloudProviderId, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity) GetCloudProviderId() *string {
	return v.CloudProviderId
}

// GetCloudProviderName returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity.CloudProviderName, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity) GetCloudProviderName() *string {
	return v.CloudProviderName
}

// GetMetadata returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity.Metadata, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity) GetMetadata() *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata {
	return v.Metadata
}

// GetStatus returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity.Status, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity) GetStatus() MachineIdentityStatus {
	return v.Status
}

// GetStatusDetails returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity.StatusDetails, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity) GetStatusDetails() *string {
	return v.StatusDetails
}

// GetCertificateId returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity.CertificateId, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity) GetCertificateId() string {
	return v.CertificateId
}

func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity) UnmarshalJSON(b []byte) error {

	if string(b) == "null" {
		return nil
	}

	var firstPass struct {
		*GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity
		Metadata json.RawMessage `json:"metadata"`
		graphql.NoUnmarshalJSON
	}
	firstPass.GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity = v

	err := json.Unmarshal(b, &firstPass)
	if err != nil {
		return err
	}

	{
		dst := &v.Metadata
		src := firstPass.Metadata
		if len(src) != 0 && string(src) != "null" {
			*dst = new(GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata)
			err = __unmarshalGetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata(
				src, *dst)
			if err != nil {
				return fmt.Errorf(
					"unable to unmarshal GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity.Metadata: %w", err)
			}
		}
	}
	return nil
}

type __premarshalGetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity struct {
	Id string `json:"id"`

	CloudKeystoreId string `json:"cloudKeystoreId"`

	CloudKeystoreName *string `json:"cloudKeystoreName"`

	CloudProviderId *string `json:"cloudProviderId"`

	CloudProviderName *string `json:"cloudProviderName"`

	Metadata json.RawMessage `json:"metadata"`

	Status MachineIdentityStatus `json:"status"`

	StatusDetails *string `json:"statusDetails"`

	CertificateId string `json:"certificateId"`
}

func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity) MarshalJSON() ([]byte, error) {
	premarshaled, err := v.__premarshalJSON()
	if err != nil {
		return nil, err
	}
	return json.Marshal(premarshaled)
}

func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity) __premarshalJSON() (*__premarshalGetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity, error) {
	var retval __premarshalGetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity

	retval.Id = v.Id
	retval.CloudKeystoreId = v.CloudKeystoreId
	retval.CloudKeystoreName = v.CloudKeystoreName
	retval.CloudProviderId = v.CloudProviderId
	retval.CloudProviderName = v.CloudProviderName
	{

		dst := &retval.Metadata
		src := v.Metadata
		if src != nil {
			var err error
			*dst, err = __marshalGetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata(
				src)
			if err != nil {
				return nil, fmt.Errorf(
					"unable to marshal GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentity.Metadata: %w", err)
			}
		}
	}
	retval.Status = v.Status
	retval.StatusDetails = v.StatusDetails
	retval.CertificateId = v.CertificateId
	return &retval, nil
}

// GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAWSCertificateMetadata includes the requested fields of the GraphQL type AWSCertificateMetadata.
type GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAWSCertificateMetadata struct {
	Typename *string `json:"__typename"`
	Arn      string  `json:"arn"`
}

// GetTypename returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAWSCertificateMetadata.Typename, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAWSCertificateMetadata) GetTypename() *string {
	return v.Typename
}

// GetArn returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAWSCertificateMetadata.Arn, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAWSCertificateMetadata) GetArn() string {
	return v.Arn
}

// GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata includes the requested fields of the GraphQL type AzureCertificateMetadata.
type GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata struct {
	Typename *string `json:"__typename"`
	AzureId  string  `json:"azureId"`
	Name     string  `json:"name"`
	Version  string  `json:"version"`
}

// GetTypename returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata.Typename, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata) GetTypename() *string {
	return v.Typename
}

// GetAzureId returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata.AzureId, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata) GetAzureId() string {
	return v.AzureId
}

// GetName returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata.Name, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata) GetName() string {
	return v.Name
}

// GetVersion returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata.Version, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata) GetVersion() string {
	return v.Version
}

// GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata includes the requested fields of the GraphQL interface CertificateCloudMetadata.
//
// GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata is implemented by the following types:
// GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAWSCertificateMetadata
// GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata
// GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata
type GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata interface {
	implementsGraphQLInterfaceGetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata()
	// GetTypename returns the receiver's concrete GraphQL type-name (see interface doc for possible values).
	GetTypename() *string
}

func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAWSCertificateMetadata) implementsGraphQLInterfaceGetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata() {
}
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata) implementsGraphQLInterfaceGetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata() {
}
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata) implementsGraphQLInterfaceGetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata() {
}

func __unmarshalGetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata(b []byte, v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata) error {
	if string(b) == "null" {
		return nil
	}

	var tn struct {
		TypeName string `json:"__typename"`
	}
	err := json.Unmarshal(b, &tn)
	if err != nil {
		return err
	}

	switch tn.TypeName {
	case "AWSCertificateMetadata":
		*v = new(GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAWSCertificateMetadata)
		return json.Unmarshal(b, *v)
	case "AzureCertificateMetadata":
		*v = new(GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata)
		return json.Unmarshal(b, *v)
	case "GCPCertificateMetadata":
		*v = new(GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata)
		return json.Unmarshal(b, *v)
	case "":
		return fmt.Errorf(
			"response was missing CertificateCloudMetadata.__typename")
	default:
		return fmt.Errorf(
			`unexpected concrete type for GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata: "%v"`, tn.TypeName)
	}
}

func __marshalGetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata(v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata) ([]byte, error) {

	var typename string
	switch v := (*v).(type) {
	case *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAWSCertificateMetadata:
		typename = "AWSCertificateMetadata"

		result := struct {
			TypeName string `json:"__typename"`
			*GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAWSCertificateMetadata
		}{typename, v}
		return json.Marshal(result)
	case *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata:
		typename = "AzureCertificateMetadata"

		result := struct {
			TypeName string `json:"__typename"`
			*GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataAzureCertificateMetadata
		}{typename, v}
		return json.Marshal(result)
	case *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata:
		typename = "GCPCertificateMetadata"

		result := struct {
			TypeName string `json:"__typename"`
			*GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata
		}{typename, v}
		return json.Marshal(result)
	case nil:
		return []byte("null"), nil
	default:
		return nil, fmt.Errorf(
			`unexpected concrete type for GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataCertificateCloudMetadata: "%T"`, v)
	}
}

// GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata includes the requested fields of the GraphQL type GCPCertificateMetadata.
type GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata struct {
	Typename *string `json:"__typename"`
	GcpId    string  `json:"gcpId"`
	Name     string  `json:"name"`
}

// GetTypename returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata.Typename, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata) GetTypename() *string {
	return v.Typename
}

// GetGcpId returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata.GcpId, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata) GetGcpId() string {
	return v.GcpId
}

// GetName returns GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata.Name, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnectionNodesMachineIdentityMetadataGCPCertificateMetadata) GetName() string {
	return v.Name
}

// GetMachineIdentitiesResponse is returned by GetMachineIdentities on success.
type GetMachineIdentitiesResponse struct {
	// Retrieves machine identities for a Cloud Keystore.
	// The pagination can be either forward or backward. To enable forward pagination, two arguments
	// are used: `after` and `first`. To enable backward pagination, two arguments are used: `before` and `last`.
	// If arguments for both forward and backward pagination are supplied, forward pagination wil be used. If no arguments
	// are supplied, it returns the first page of 10 machine identities (i.e. defaults `first` to 10). The result is sorted by
	// the added on date in descending order.
	// - after: returns the elements in the list that come after the specified cursor. Defaults to empty string, meaning
	// that we return the first page of certificates, if `first` value is supplied
	// - first: non-negative integer, denoting the first `n` number of records to return after the `after` cursor value.
	// Max value is 1000
	// - before: returns the elements in the list that come before the specified cursor. By default is the empty string,
	// meaning that the results will be the last page, if `last` value is supplied
	// - last: non-negative integer, denoting the last `n` number of records to return before the `before` cursor value.
	// Max value is 1000
	CloudMachineIdentities *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnection `json:"cloudMachineIdentities"`
}

// GetCloudMachineIdentities returns GetMachineIdentitiesResponse.CloudMachineIdentities, and is useful for accessing the field via an interface.
func (v *GetMachineIdentitiesResponse) GetCloudMachineIdentities() *GetMachineIdentitiesCloudMachineIdentitiesMachineIdentityConnection {
	return v.CloudMachineIdentities
}

type MachineIdentityStatus string

const (
	MachineIdentityStatusNew        MachineIdentityStatus = "NEW"
	MachineIdentityStatusPending    MachineIdentityStatus = "PENDING"
	MachineIdentityStatusInstalled  MachineIdentityStatus = "INSTALLED"
	MachineIdentityStatusDiscovered MachineIdentityStatus = "DISCOVERED"
	MachineIdentityStatusValidated  MachineIdentityStatus = "VALIDATED"
	MachineIdentityStatusMissing    MachineIdentityStatus = "MISSING"
	MachineIdentityStatusFailed     MachineIdentityStatus = "FAILED"
)

// ProvisionCertificateProvisionToCloudKeystoreWorkflowResult includes the requested fields of the GraphQL type WorkflowResult.
type ProvisionCertificateProvisionToCloudKeystoreWorkflowResult struct {
	WorkflowId   string `json:"workflowId"`
	WorkflowName string `json:"workflowName"`
}

// GetWorkflowId returns ProvisionCertificateProvisionToCloudKeystoreWorkflowResult.WorkflowId, and is useful for accessing the field via an interface.
func (v *ProvisionCertificateProvisionToCloudKeystoreWorkflowResult) GetWorkflowId() string {
	return v.WorkflowId
}

// GetWorkflowName returns ProvisionCertificateProvisionToCloudKeystoreWorkflowResult.WorkflowName, and is useful for accessing the field via an interface.
func (v *ProvisionCertificateProvisionToCloudKeystoreWorkflowResult) GetWorkflowName() string {
	return v.WorkflowName
}

// ProvisionCertificateResponse is returned by ProvisionCertificate on success.
type ProvisionCertificateResponse struct {
	// Provision a certificate to a Cloud Keystore
	ProvisionToCloudKeystore *ProvisionCertificateProvisionToCloudKeystoreWorkflowResult `json:"provisionToCloudKeystore"`
}

// GetProvisionToCloudKeystore returns ProvisionCertificateResponse.ProvisionToCloudKeystore, and is useful for accessing the field via an interface.
func (v *ProvisionCertificateResponse) GetProvisionToCloudKeystore() *ProvisionCertificateProvisionToCloudKeystoreWorkflowResult {
	return v.ProvisionToCloudKeystore
}

// ProvisionCertificateToMachineIdentityProvisionToCloudMachineIdentityWorkflowResult includes the requested fields of the GraphQL type WorkflowResult.
type ProvisionCertificateToMachineIdentityProvisionToCloudMachineIdentityWorkflowResult struct {
	WorkflowId   string `json:"workflowId"`
	WorkflowName string `json:"workflowName"`
}

// GetWorkflowId returns ProvisionCertificateToMachineIdentityProvisionToCloudMachineIdentityWorkflowResult.WorkflowId, and is useful for accessing the field via an interface.
func (v *ProvisionCertificateToMachineIdentityProvisionToCloudMachineIdentityWorkflowResult) GetWorkflowId() string {
	return v.WorkflowId
}

// GetWorkflowName returns ProvisionCertificateToMachineIdentityProvisionToCloudMachineIdentityWorkflowResult.WorkflowName, and is useful for accessing the field via an interface.
func (v *ProvisionCertificateToMachineIdentityProvisionToCloudMachineIdentityWorkflowResult) GetWorkflowName() string {
	return v.WorkflowName
}

// ProvisionCertificateToMachineIdentityResponse is returned by ProvisionCertificateToMachineIdentity on success.
type ProvisionCertificateToMachineIdentityResponse struct {
	// Provision to existing Cloud Machine Identity. If `certificateId` is not provided a re-provisioning of the existing certificate would be triggered
	ProvisionToCloudMachineIdentity *ProvisionCertificateToMachineIdentityProvisionToCloudMachineIdentityWorkflowResult `json:"provisionToCloudMachineIdentity"`
}

// GetProvisionToCloudMachineIdentity returns ProvisionCertificateToMachineIdentityResponse.ProvisionToCloudMachineIdentity, and is useful for accessing the field via an interface.
func (v *ProvisionCertificateToMachineIdentityResponse) GetProvisionToCloudMachineIdentity() *ProvisionCertificateToMachineIdentityProvisionToCloudMachineIdentityWorkflowResult {
	return v.ProvisionToCloudMachineIdentity
}

// __DeleteMachineIdentitiesInput is used internally by genqlient
type __DeleteMachineIdentitiesInput struct {
	MachineIdentityIds []string `json:"machineIdentityIds"`
}

// GetMachineIdentityIds returns __DeleteMachineIdentitiesInput.MachineIdentityIds, and is useful for accessing the field via an interface.
func (v *__DeleteMachineIdentitiesInput) GetMachineIdentityIds() []string {
	return v.MachineIdentityIds
}

// __GetCloudKeystoresInput is used internally by genqlient
type __GetCloudKeystoresInput struct {
	CloudKeystoreId   *string `json:"cloudKeystoreId"`
	CloudKeystoreName *string `json:"cloudKeystoreName"`
	CloudProviderId   *string `json:"cloudProviderId"`
	CloudProviderName *string `json:"cloudProviderName"`
}

// GetCloudKeystoreId returns __GetCloudKeystoresInput.CloudKeystoreId, and is useful for accessing the field via an interface.
func (v *__GetCloudKeystoresInput) GetCloudKeystoreId() *string { return v.CloudKeystoreId }

// GetCloudKeystoreName returns __GetCloudKeystoresInput.CloudKeystoreName, and is useful for accessing the field via an interface.
func (v *__GetCloudKeystoresInput) GetCloudKeystoreName() *string { return v.CloudKeystoreName }

// GetCloudProviderId returns __GetCloudKeystoresInput.CloudProviderId, and is useful for accessing the field via an interface.
func (v *__GetCloudKeystoresInput) GetCloudProviderId() *string { return v.CloudProviderId }

// GetCloudProviderName returns __GetCloudKeystoresInput.CloudProviderName, and is useful for accessing the field via an interface.
func (v *__GetCloudKeystoresInput) GetCloudProviderName() *string { return v.CloudProviderName }

// __GetCloudProvidersInput is used internally by genqlient
type __GetCloudProvidersInput struct {
	Status       *CloudProviderStatus `json:"status"`
	ProviderType *CloudProviderType   `json:"providerType"`
	Name         string               `json:"name"`
}

// GetStatus returns __GetCloudProvidersInput.Status, and is useful for accessing the field via an interface.
func (v *__GetCloudProvidersInput) GetStatus() *CloudProviderStatus { return v.Status }

// GetProviderType returns __GetCloudProvidersInput.ProviderType, and is useful for accessing the field via an interface.
func (v *__GetCloudProvidersInput) GetProviderType() *CloudProviderType { return v.ProviderType }

// GetName returns __GetCloudProvidersInput.Name, and is useful for accessing the field via an interface.
func (v *__GetCloudProvidersInput) GetName() string { return v.Name }

// __GetMachineIdentitiesInput is used internally by genqlient
type __GetMachineIdentitiesInput struct {
	CloudKeystoreId   *string  `json:"cloudKeystoreId"`
	MachineIdentityId *string  `json:"machineIdentityId"`
	Fingerprints      []string `json:"fingerprints"`
	NewlyDiscovered   *bool    `json:"newlyDiscovered"`
	Metadata          *string  `json:"metadata"`
}

// GetCloudKeystoreId returns __GetMachineIdentitiesInput.CloudKeystoreId, and is useful for accessing the field via an interface.
func (v *__GetMachineIdentitiesInput) GetCloudKeystoreId() *string { return v.CloudKeystoreId }

// GetMachineIdentityId returns __GetMachineIdentitiesInput.MachineIdentityId, and is useful for accessing the field via an interface.
func (v *__GetMachineIdentitiesInput) GetMachineIdentityId() *string { return v.MachineIdentityId }

// GetFingerprints returns __GetMachineIdentitiesInput.Fingerprints, and is useful for accessing the field via an interface.
func (v *__GetMachineIdentitiesInput) GetFingerprints() []string { return v.Fingerprints }

// GetNewlyDiscovered returns __GetMachineIdentitiesInput.NewlyDiscovered, and is useful for accessing the field via an interface.
func (v *__GetMachineIdentitiesInput) GetNewlyDiscovered() *bool { return v.NewlyDiscovered }

// GetMetadata returns __GetMachineIdentitiesInput.Metadata, and is useful for accessing the field via an interface.
func (v *__GetMachineIdentitiesInput) GetMetadata() *string { return v.Metadata }

// __ProvisionCertificateInput is used internally by genqlient
type __ProvisionCertificateInput struct {
	CertificateId   string                               `json:"certificateId"`
	CloudKeystoreId string                               `json:"cloudKeystoreId"`
	WsClientId      string                               `json:"wsClientId"`
	Options         *CertificateProvisioningOptionsInput `json:"options,omitempty"`
}

// GetCertificateId returns __ProvisionCertificateInput.CertificateId, and is useful for accessing the field via an interface.
func (v *__ProvisionCertificateInput) GetCertificateId() string { return v.CertificateId }

// GetCloudKeystoreId returns __ProvisionCertificateInput.CloudKeystoreId, and is useful for accessing the field via an interface.
func (v *__ProvisionCertificateInput) GetCloudKeystoreId() string { return v.CloudKeystoreId }

// GetWsClientId returns __ProvisionCertificateInput.WsClientId, and is useful for accessing the field via an interface.
func (v *__ProvisionCertificateInput) GetWsClientId() string { return v.WsClientId }

// GetOptions returns __ProvisionCertificateInput.Options, and is useful for accessing the field via an interface.
func (v *__ProvisionCertificateInput) GetOptions() *CertificateProvisioningOptionsInput {
	return v.Options
}

// __ProvisionCertificateToMachineIdentityInput is used internally by genqlient
type __ProvisionCertificateToMachineIdentityInput struct {
	MachineIdentityId string  `json:"machineIdentityId"`
	WsClientId        string  `json:"wsClientId"`
	CertificateId     *string `json:"certificateId"`
}

// GetMachineIdentityId returns __ProvisionCertificateToMachineIdentityInput.MachineIdentityId, and is useful for accessing the field via an interface.
func (v *__ProvisionCertificateToMachineIdentityInput) GetMachineIdentityId() string {
	return v.MachineIdentityId
}

// GetWsClientId returns __ProvisionCertificateToMachineIdentityInput.WsClientId, and is useful for accessing the field via an interface.
func (v *__ProvisionCertificateToMachineIdentityInput) GetWsClientId() string { return v.WsClientId }

// GetCertificateId returns __ProvisionCertificateToMachineIdentityInput.CertificateId, and is useful for accessing the field via an interface.
func (v *__ProvisionCertificateToMachineIdentityInput) GetCertificateId() *string {
	return v.CertificateId
}

// The query or mutation executed by DeleteMachineIdentities.
const DeleteMachineIdentities_Operation = `
mutation DeleteMachineIdentities ($machineIdentityIds: [UUID!]!) {
	deleteCloudMachineIdentities(machineIdentityIds: $machineIdentityIds)
}
`

func DeleteMachineIdentities(
	ctx_ context.Context,
	client_ graphql.Client,
	machineIdentityIds []string,
) (*DeleteMachineIdentitiesResponse, error) {
	req_ := &graphql.Request{
		OpName: "DeleteMachineIdentities",
		Query:  DeleteMachineIdentities_Operation,
		Variables: &__DeleteMachineIdentitiesInput{
			MachineIdentityIds: machineIdentityIds,
		},
	}
	var err_ error

	var data_ DeleteMachineIdentitiesResponse
	resp_ := &graphql.Response{Data: &data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return &data_, err_
}

// The query or mutation executed by GetCloudKeystores.
const GetCloudKeystores_Operation = `
query GetCloudKeystores ($cloudKeystoreId: UUID, $cloudKeystoreName: String, $cloudProviderId: UUID, $cloudProviderName: String) {
	cloudKeystores(filter: {cloudKeystoreId:$cloudKeystoreId,cloudKeystoreName:$cloudKeystoreName,cloudProviderId:$cloudProviderId,cloudProviderName:$cloudProviderName}) {
		nodes {
			id
			name
			type
			machineIdentitiesCount
		}
	}
}
`

func GetCloudKeystores(
	ctx_ context.Context,
	client_ graphql.Client,
	cloudKeystoreId *string,
	cloudKeystoreName *string,
	cloudProviderId *string,
	cloudProviderName *string,
) (*GetCloudKeystoresResponse, error) {
	req_ := &graphql.Request{
		OpName: "GetCloudKeystores",
		Query:  GetCloudKeystores_Operation,
		Variables: &__GetCloudKeystoresInput{
			CloudKeystoreId:   cloudKeystoreId,
			CloudKeystoreName: cloudKeystoreName,
			CloudProviderId:   cloudProviderId,
			CloudProviderName: cloudProviderName,
		},
	}
	var err_ error

	var data_ GetCloudKeystoresResponse
	resp_ := &graphql.Response{Data: &data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return &data_, err_
}

// The query or mutation executed by GetCloudProviders.
const GetCloudProviders_Operation = `
query GetCloudProviders ($status: CloudProviderStatus, $providerType: CloudProviderType, $name: String!) {
	cloudProviders(filter: {status:$status,type:$providerType,name:$name}) {
		nodes {
			id
			name
			type
			status
			statusDetails
			keystoresCount
		}
	}
}
`

func GetCloudProviders(
	ctx_ context.Context,
	client_ graphql.Client,
	status *CloudProviderStatus,
	providerType *CloudProviderType,
	name string,
) (*GetCloudProvidersResponse, error) {
	req_ := &graphql.Request{
		OpName: "GetCloudProviders",
		Query:  GetCloudProviders_Operation,
		Variables: &__GetCloudProvidersInput{
			Status:       status,
			ProviderType: providerType,
			Name:         name,
		},
	}
	var err_ error

	var data_ GetCloudProvidersResponse
	resp_ := &graphql.Response{Data: &data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return &data_, err_
}

// The query or mutation executed by GetMachineIdentities.
const GetMachineIdentities_Operation = `
query GetMachineIdentities ($cloudKeystoreId: UUID, $machineIdentityId: UUID, $fingerprints: [String!], $newlyDiscovered: Boolean, $metadata: String) {
	cloudMachineIdentities(filter: {cloudKeystoreId:$cloudKeystoreId,machineIdentityId:$machineIdentityId,fingerprints:$fingerprints,newlyDiscovered:$newlyDiscovered,metadata:$metadata}) {
		nodes {
			id
			cloudKeystoreId
			cloudKeystoreName
			cloudProviderId
			cloudProviderName
			metadata {
				__typename
				... on AWSCertificateMetadata {
					arn
				}
				... on AzureCertificateMetadata {
					azureId
					name
					version
				}
				... on GCPCertificateMetadata {
					gcpId
					name
				}
			}
			status
			statusDetails
			certificateId
		}
	}
}
`

func GetMachineIdentities(
	ctx_ context.Context,
	client_ graphql.Client,
	cloudKeystoreId *string,
	machineIdentityId *string,
	fingerprints []string,
	newlyDiscovered *bool,
	metadata *string,
) (*GetMachineIdentitiesResponse, error) {
	req_ := &graphql.Request{
		OpName: "GetMachineIdentities",
		Query:  GetMachineIdentities_Operation,
		Variables: &__GetMachineIdentitiesInput{
			CloudKeystoreId:   cloudKeystoreId,
			MachineIdentityId: machineIdentityId,
			Fingerprints:      fingerprints,
			NewlyDiscovered:   newlyDiscovered,
			Metadata:          metadata,
		},
	}
	var err_ error

	var data_ GetMachineIdentitiesResponse
	resp_ := &graphql.Response{Data: &data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return &data_, err_
}

// The query or mutation executed by ProvisionCertificate.
const ProvisionCertificate_Operation = `
mutation ProvisionCertificate ($certificateId: UUID!, $cloudKeystoreId: UUID!, $wsClientId: UUID!, $options: CertificateProvisioningOptionsInput) {
	provisionToCloudKeystore(certificateId: $certificateId, cloudKeystoreId: $cloudKeystoreId, wsClientId: $wsClientId, options: $options) {
		workflowId
		workflowName
	}
}
`

func ProvisionCertificate(
	ctx_ context.Context,
	client_ graphql.Client,
	certificateId string,
	cloudKeystoreId string,
	wsClientId string,
	options *CertificateProvisioningOptionsInput,
) (*ProvisionCertificateResponse, error) {
	req_ := &graphql.Request{
		OpName: "ProvisionCertificate",
		Query:  ProvisionCertificate_Operation,
		Variables: &__ProvisionCertificateInput{
			CertificateId:   certificateId,
			CloudKeystoreId: cloudKeystoreId,
			WsClientId:      wsClientId,
			Options:         options,
		},
	}
	var err_ error

	var data_ ProvisionCertificateResponse
	resp_ := &graphql.Response{Data: &data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return &data_, err_
}

// The query or mutation executed by ProvisionCertificateToMachineIdentity.
const ProvisionCertificateToMachineIdentity_Operation = `
mutation ProvisionCertificateToMachineIdentity ($machineIdentityId: UUID!, $wsClientId: UUID!, $certificateId: UUID) {
	provisionToCloudMachineIdentity(machineIdentityId: $machineIdentityId, wsClientId: $wsClientId, certificateId: $certificateId) {
		workflowId
		workflowName
	}
}
`

func ProvisionCertificateToMachineIdentity(
	ctx_ context.Context,
	client_ graphql.Client,
	machineIdentityId string,
	wsClientId string,
	certificateId *string,
) (*ProvisionCertificateToMachineIdentityResponse, error) {
	req_ := &graphql.Request{
		OpName: "ProvisionCertificateToMachineIdentity",
		Query:  ProvisionCertificateToMachineIdentity_Operation,
		Variables: &__ProvisionCertificateToMachineIdentityInput{
			MachineIdentityId: machineIdentityId,
			WsClientId:        wsClientId,
			CertificateId:     certificateId,
		},
	}
	var err_ error

	var data_ ProvisionCertificateToMachineIdentityResponse
	resp_ := &graphql.Response{Data: &data_}

	err_ = client_.MakeRequest(
		ctx_,
		req_,
		resp_,
	)

	return &data_, err_
}
