# Copyright (c) 2015-2024 Vector 35 Inc
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to
# deal in the Software without restriction, including without limitation the
# rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
# sell copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS
# IN THE SOFTWARE.

import copy
from typing import Any


class _AssociatedDataStore(dict):
	_defaults = {}

	@classmethod
	def set_default(cls, name: str, value: Any):
		cls._defaults[name] = value

	def __getattr__(self, name: str) -> Any:
		if name in self.__dict__:
			return self.__dict__[name]
		if name not in self:
			if name in self.__class__._defaults:
				result = copy.copy(self.__class__._defaults[name])
				self[name] = result
				return result
		return self.__getitem__(name)

	def __setattr__(self, name: str, value: Any):
		self.__setitem__(name, value)

	def __delattr__(self, name: str):
		self.__delitem__(name)
