# Migrating from IDA

## Starting Binary Ninja

Binary Ninja starts with the [New Tab Page](../index.md#new-tab) open. From here, you can optionally [start a project](../projects.md#creating-a-project) to work with multiple files, [create new files](../index.md#new-files) to paste in data, or just [open existing files](../index.md#loading-files) (including drag-and-drop!).

## Decompiler Settings

Binary Ninja likes to stay out of your way as much as possible, but sometimes you need to dig into the settings and change how a file is analyzed. If you have a file that can be opened with default settings, you won't get prompted for any additional input. Binary Ninja will automatically analyze the entire file — including running [linear sweep](https://binary.ninja/2017/11/06/architecture-agnostic-function-detection-in-binaries.html) — and provide you with linear decompilation for the whole file (like IDA's linear disassembly, but as decomp by default).

If you're opening a [Universal Mach-O](https://en.wikipedia.org/wiki/Universal_binary), the Open with Options dialogue will appear so that you can choose which architecture to open (in the top right). If you have a default architecture you want to open whenever you open a universal binary, you can set your preference in a setting called [Universal Mach-O Architecture Preference](../settings.md#all-settings). You'll also see the Open with Options dialogue when Binary Ninja is unable to recognize the file type or otherwise needs user input to analyze the file (can't find the entry point, needs you to provide some memory mappings, etc).

It's worth digging into Binary Ninja's [settings](../settings.md) and seeing what's available to tune, but if you ever want to change a setting for a single binary, you can Open (it) with Options. Go to File -> Open with Options, and any settings you change will apply to only that file.

<!-- TODO : Can you analyze a file while IDA is running its analysis?
## Analyzing While Analyzing -->

## Importing Data

Importing IDA IDB (`.idb`) and TIL (`.til`) files into Binary Ninja allows you to automatically transfer analysis data, saving you from manually moving over information.

There are two ways through the UI to import IDB and TIL files:

1. Prior to opening the binary, selecting _Open with Options_, allows you to set the IDB file you want to import with the  _External Debug Info File_ setting (`analysis.debugInfo.external`).
2. After opening a binary, selecting _Import Debug Info from External File_ (`Analysis\\Import Debug Info from External File...`) allows you to apply IDB/TIL files after analysis has already started.

The following data will be imported:

- Function information (name, comments, function type)
- Type information

## Keybindings

Most of the keybindings you're used to are the same. Any "actions" (renaming, setting types, opening cross-references, etc) you might want to perform can be found in the [command palette](../index.md#command-palette), which will save you from digging through unfamiliar right-click menus and help you learn any new keybindings. You can even [add your own actions](https://binary.ninja/2024/02/15/command-palette.html#how-do-i-register-actions-with-the-command-palette-myself) with ease. All actions can have their keybinding set, changed, or removed in the [keybindings menu](../index.md#default-hotkeys).

Some major exceptions are:

- Save is `[CTRL/⌘-S]`.
- All our find options are under `[CTRL/⌘-F]`.
- The "subviews" keybindings are:
    - `T` for Types
    - `H` to toggle to/from Hex View
    - `[TAB]` to toggle to/from disassembly

## Cross-References

![xref icon >](../../img/xref-icon.png "Xref Icon")

If you prefer the pop-up style cross-references from IDA or Ghidra, you can enable that behavior by right-clicking on the xref-icon and selecting "Window". Whenever you navigate from the window by double-clicking or pressing enter the main window will be focused. ESC can also be used to close the xref window.

## Theme

We like our dark themes, but understand they're not for everyone. We have an expansive list of [community themes](https://github.com/Vector35/community-themes), and [a guide](../../dev/themes.md) and a [blog post](https://binary.ninja/2021/07/08/creating-great-themes.html) on how to make your own. The built-in "Classic" theme should feel nostalgic, but if you're looking for a light theme that's slightly easier on the eyes, try out Summer or Solarized Light.

## Layout

Binary Ninja's layout is very similar to what you're used to in IDA, but there's one setting you might want to change and a handful of improvements to look out for as well.

### Feature Map

If you want the [feature map](../index.md#feature-map) back to where you're used to, right-click it, find "Feature Map Location" and change it to the top. That said, take notice that Binary Ninja's feature map is 2d: both directions you move your cursor changes the address in Binary Ninja. The exact number of bytes that fit across the width of the feature map scales to the size of the binary. You can disable this in the right-click menu by selecting "Linear Feature Map."

We also have an entropy map, if you need it, but it's tucked away in [triage view](https://binary.ninja/2019/04/01/hackathon-2019-summary.html#triage-mode-rusty).

### Sidebars

Our sidebars have a whole host of customization options, so make sure to check out [their dedicated docs](../index.md#the-sidebar) to maximize your workflow.

#### Main Area

Binary Ninja shows you linear decompilation by default for the whole binary. However, some people strongly prefer the "single function at a time" workflow, so we made an option for that too. Find the small hamburger menu (the three line pop-out menu) in the top right of your view and select “Single Function View.”

Check out the [tiling panes](../index.md#tiling-panes) docs for more information.

## What You'll Love

...about switching to Binary Ninja! We know leaving your old tool behind can be hard, and there will be things you miss, but we think there are a lot of features packed into Binary Ninja that you'll love. Here are a couple we think you'll appreciate:

 - Decompilation for every architecture, including [ones you bring yourself](https://binary.ninja/2020/01/08/guide-to-architecture-plugins-part1.html)
 - [Updates every day](../index.md#updates) on the dev branch (nearly)
 - [Our awesome native Python API](../../dev/cookbook.md) (and [C++](https://api.binary.ninja/cpp/), and [Rust](https://dev-rust.binary.ninja/))
 - [**So** much open source](https://github.com/Vector35/binaryninja-api?tab=readme-ov-file#related-repositories) (that includes our architecture modules!)

---

Don't forget to check out our [additional resources](index.md#additional-resources)!
