# Migrating from Other Tools

Thank you for trying Binary Ninja! We know that it can be a bit different from what you're used to, so this page dedicated to getting you oriented in your new favorite decompiler!

If you haven't already installed Binary Ninja, you can follow our [installation guide](../../getting-started.md#installing-binary-ninja).

And be sure to check out some of our additional resource below before you click away!

We have quick start guides for the following:

- [New Users](../../getting-started.md)
- [IDA Pro Users](migrationguideida.md)
- [Ghidra Users](migrationguideghidra.md)

## Additional Resources

We love our community! Feel free to hang with us and chat in our [Public Slack Server](https://slack.binary.ninja). Our community is great about answering questions for each other, but one of our engineers will often get to your question first as well. We have a lot of different channels for different levels of engineers, different interests, topics, and so on.

Our community has also generated a tremendous number of [community plugins](https://github.com/Vector35/community-plugins) that provide support for new architectures, automate different types of analysis, and even some that provide new and advanced visualizations for your programs. That repo also contains instructions for how to get your own plugin into our [plugin manager](../plugins.md#plugin-manager).

If you think you've found a bug or have a suggestion for us, tell us over on [GitHub](https://github.com/Vector35/binaryninja-api). There are [discussions](https://github.com/Vector35/binaryninja-api/discussions) over there if you'd prefer to ask us something on GitHub instead of Slack. GitHub also hosts the vast majority of our [API and scripting examples](../../dev/cookbook.md) to help you start automating tasks! If you're really passionate about getting something fixed, we have [a _ton_ of open source repos](https://github.com/Vector35/binaryninja-api?tab=readme-ov-file#related-repositories) to contribute to, including every single one of our core architecture plugins.
