Starting in Binary Ninja 4.0, we have unified all of our icons under one, consistent style. This involved taking a bunch of existing icons from open sources, modifying them to suit our needs, and then drawing some additional icons that matched the same style.

The primary sources/inspirations for our icons were:

* [Majesticons](https://github.com/halfmage/majesticons)
* [Hero Icons](https://heroicons.com/)
* [Icons for Visual Studio Code](https://github.com/microsoft/vscode-icons)

In the tables below, we describe all the icons we ship with, where they came from, what their license is, and what modifications (if any) were made.

## Binary Ninja

| File | Source | License | Notes |
|----|----|----|----|
| `adjustments.svg` | Hero Icons | MIT | Increased stroke width, changed slider positions. |
| `alert.svg` | Hero Icons | MIT | Increased stroke width, lengthened exclamation point. |
| `archive.svg` | Hero Icons | MIT | Increased stroke width. |
| `arrow-both.svg` | Hero Icons | MIT | Merged two icons together. |
| `arrow-from.svg` | Hero Icons | MIT | Increased stroke width, modified. |
| `arrow-left.svg` | Majesticons | MIT | Made slightly larger, kept stroke width the same. |
| `arrow-pull.svg` | Hero Icons | MIT | Increased stroke width, modified. |
| `arrow-push.svg` | Hero Icons | MIT | Increased stroke width, modified. |
| `arrow-to.svg` | Hero Icons | MIT | Increased stroke width, modified. |
| `case-sensitive.svg` | Icons for Visual Studio Code | CC-BY 4.0 | Redrawn entirely. |
| `chat.svg` | Majesticons | MIT | No changes. |
| `chevron-down.svg` | Hero Icons | MIT | Increased stroke width. |
| `chevron-left.svg` | Hero Icons | MIT | Increased stroke width. |
| `console.svg` | Hero Icons | MIT | Increased stroke width, modified inside lines. |
| `cross.svg` | Majesticons | MIT | No changes. |
| `download.svg` | Hero Icons | MIT | Increased stroke width. |
| `download-complete.svg` | Hero Icons | MIT | Removed down arrow, copied in checkmark. |
| `edit.svg` | Hero Icons | MIT | Increased stroke width. |
| `error.svg` | Hero Icons | MIT | Increased stroke width, lengthened cross. |
| `external-links.svg` | Vector 35 | MIT | Hand-drawn. |
| `file-add.svg` | Hero Icons | MIT | Increased stroke width. |
| `file-data.svg` | Hero Icons | MIT | Swapped out plus sign for hand-drawn numbers. |
| `file.svg` | Hero Icons | MIT | Increased stroke width. |
| `find.svg` | Majesticons | MIT | No changes. |
| `folder-add.svg` | Hero Icons | MIT | Increased stroke width. |
| `folder-open.svg` | Hero Icons | MIT | Increased stroke width. |
| `folder.svg` | Hero Icons | MIT | Increased stroke width. |
| `graph.svg` | Vector 35 | MIT | Hand-drawn. |
| `link.svg` | Hero Icons | MIT | Increased stroke width. |
| `lock-closed.svg` | Hero Icons | MIT | Increased stroke width. |
| `lock-open.svg` | Hero Icons | MIT | Increased stroke width. |
| `log.svg` | Majesticons | MIT | No changes. |
| `map-marker.svg` | Majesticons | MIT | No changes. |
| `menu.svg` | Majesticons | MIT | Changed spacing and line length. |
| `more.svg` | Hero Icons | MIT | Increased stroke width. |
| `pin.svg` | Majesticons | MIT | No changes. |
| `plus.svg` | Majesticons | MIT | No changes. |
| `question.svg` | Hero Icons | MIT | Increased stroke width, changed location of question mark. |
| `refresh.svg` | Hero Icons | MIT | Increased stroke width. |
| `reset.svg` | Vector 35 | MIT | Hand-drawn. |
| `settings.svg` | Hero Icons | MIT | Increased stroke width. |
| `snippets.svg` | Hero Icons | MIT | Increased stroke width. |
| `split-horizontal.svg` | Vector 35 | MIT | Hand-drawn. |
| `split-vertical.svg` | Vector 35 | MIT | Hand-drawn. |
| `squares-bug.svg` | Majesticons + Hero Icons | MIT | Increased stroke width, removed bottom-right square, inserted bug tipped on angle, removed markings on bug. |
| `stack-trace.svg` | Vector 35 | MIT | Hand-drawn. |
| `stack.svg` | Hero Icons | MIT | Increased stroke width. |
| `strings.svg` | Vector 35 | MIT | Hand-drawn. |
| `symbols.svg` | Vector 35 | MIT | Hand-drawn. |
| `tags.svg` | Majesticons | MIT | No changes. |
| `types.svg` | Majesticons | MIT | Moved curly braces apart and added a hand-drawn "T". |
| `users.svg` | Majesticons | MIT | No changes. |
| `variables.svg` | Hero Icons | MIT | Increased stroke width. |
| `warning.svg` | Hero Icons | MIT | Increased stroke width, lengthened exclamation point. |
| `window-new.svg` | Hero Icons | MIT | Increased stroke width, change positions of all nodes. |
| `xrefs.svg` | Vector 35 | MIT | Hand-drawn. |


## Debugger Plugin

| File | Source | License | Notes |
|----|----|----|----|
| `stop.svg` | Vector 35 | MIT | Hand-drawn. | 
| `add.svg` | Majesticons | MIT | No changes. Same as `plus.svg`. |
| `breakpoint.svg` | Vector 35 | MIT | Hand-drawn. | 
| `cancel.svg` | Majesticons | MIT | No changes. Same as `cross.svg`. |
| `connect.svg` | Vector 35 | MIT | Hand-drawn. |
| `debugger.svg` | Majesticons | MIT | Removed little dots inside bug. |
| `disconnect.svg` | Vector 35 | MIT | Hand-drawn. |
| `menu.svg` | Majesticons | MIT | Changed spacing and line length. |
| `pause.svg` | Vector 35 | MIT | Hand-drawn. |
| `remove.svg` | Majesticons | MIT | No changes. Same as `minus.svg`. |
| `restart.svg` | Vector 35 | MIT | Hand-drawn. Flipped and rotated copy of `reset.svg`. |
| `resume.svg` | Hero Icons | MIT | Added a line to the left of `start.svg` below. |
| `settings.svg` | Hero Icons | MIT | Increased stroke width. |
| `start.svg` | Hero Icons | MIT | Increased stroke width. |
| `step-back.svg` | Icons for Visual Studio Code | CC-BY 4.0 | Redrawn entirely. |
| `step-into.svg` | Icons for Visual Studio Code | CC-BY 4.0 | Redrawn entirely. |
| `step-out.svg` | Icons for Visual Studio Code | CC-BY 4.0 | Redrawn entirely. |
| `step-over.svg` | Icons for Visual Studio Code | CC-BY 4.0 | Redrawn entirely. |

