#define _CRT_SECURE_NO_WARNINGS
#include <inttypes.h>
#include <stdio.h>
#include <string.h>
#include <sstream>
#include "binaryninjaapi.h"
#include "il.h"
extern "C" {
    #include "xed-interface.h"
}
#include "arch_x86_common_architecture.h"

using namespace BinaryNinja;
using namespace std;

BNIntrinsicClass X86CommonArchitecture::GetIntrinsicClass(uint32_t intrinsic)
{
    switch (intrinsic)
    {
    case INTRINSIC_XED_IFORM_REP_MOVSB:
    case INTRINSIC_XED_IFORM_REP_MOVSW:
    case INTRINSIC_XED_IFORM_REP_MOVSD:
    case INTRINSIC_XED_IFORM_REP_MOVSQ:
    case INTRINSIC_XED_IFORM_REP_STOSB:
    case INTRINSIC_XED_IFORM_REP_STOSW:
    case INTRINSIC_XED_IFORM_REP_STOSD:
    case INTRINSIC_XED_IFORM_REP_STOSQ:
        return MemoryIntrinsicClass;
    default:
        return GeneralIntrinsicClass;
    }
}

string X86CommonArchitecture::GetIntrinsicName(uint32_t intrinsic)
{
    switch (intrinsic)
    {
    case INTRINSIC_F2XM1:
        return "__f2xm1";
    case INTRINSIC_FBLD:
        return "__fbld";
    case INTRINSIC_FBST:
        return "__fbst";
    case INTRINSIC_FSIN:
        return "__fsin";
    case INTRINSIC_FCOS:
        return "__fcos";
    case INTRINSIC_FSINCOS:
        return "__fsincos";
    case INTRINSIC_FPATAN:
        return "__fpatan";
    case INTRINSIC_FPREM:
        return "__fprem";
    case INTRINSIC_FPREM1:
        return "__fprem1";
    case INTRINSIC_FPTAN:
        return "__fptan";
    case INTRINSIC_FSCALE:
        return "__fscale";
    case INTRINSIC_FXAM:
        return "__fxam";
    case INTRINSIC_FXTRACT:
        return "__fxtract";
    case INTRINSIC_FYL2X:
        return "__fyl2x";
    case INTRINSIC_FYL2XP1:
        return "__fyl2xp1";
    case INTRINSIC_XED_IFORM_ADCX_GPR32d_GPR32d:
    	return "_addcarryx_u32";
    case INTRINSIC_XED_IFORM_ADOX_GPR32d_GPR32d:
    	return "_addcarryx_u32";
    case INTRINSIC_XED_IFORM_ADCX_GPR64q_GPR64q:
    	return "_addcarryx_u64";
    case INTRINSIC_XED_IFORM_ADOX_GPR64q_GPR64q:
    	return "_addcarryx_u64";
    case INTRINSIC_XED_IFORM_AESENC_XMMdq_XMMdq:
    	return "_mm_aesenc_si128";
    case INTRINSIC_XED_IFORM_AESENCLAST_XMMdq_XMMdq:
    	return "_mm_aesenclast_si128";
    case INTRINSIC_XED_IFORM_AESDEC_XMMdq_XMMdq:
    	return "_mm_aesdec_si128";
    case INTRINSIC_XED_IFORM_AESDECLAST_XMMdq_XMMdq:
    	return "_mm_aesdeclast_si128";
    case INTRINSIC_XED_IFORM_AESIMC_XMMdq_XMMdq:
    	return "_mm_aesimc_si128";
    case INTRINSIC_XED_IFORM_AESKEYGENASSIST_XMMdq_XMMdq_IMMb:
    	return "_mm_aeskeygenassist_si128";
    // case INTRINSIC_XED_IFORM_TDPBF16PS_TMMf32_TMMu32_TMMu32:
    // 	return "_tile_dpbf16ps";
    // case INTRINSIC_XED_IFORM_TDPBSUD_TMMi32_TMMu32_TMMu32:
    // 	return "_tile_dpbsud";
    // case INTRINSIC_XED_IFORM_TDPBUSD_TMMi32_TMMu32_TMMu32:
    // 	return "_tile_dpbusd";
    // case INTRINSIC_XED_IFORM_TDPBUUD_TMMu32_TMMu32_TMMu32:
    // 	return "_tile_dpbuud";
    // case INTRINSIC_XED_IFORM_TDPBSSD_TMMi32_TMMu32_TMMu32:
    // 	return "_tile_dpbssd";
    // case INTRINSIC_XED_IFORM_LDTILECFG_MEM:
    // 	return "_tile_loadconfig";
    // case INTRINSIC_XED_IFORM_STTILECFG_MEM:
    // 	return "_tile_storeconfig";
    // case INTRINSIC_XED_IFORM_TILELOADD_TMMu32_MEMu32:
    // 	return "_tile_loadd";
    // case INTRINSIC_XED_IFORM_TILELOADDT1_TMMu32_MEMu32:
    // 	return "_tile_stream_loadd";
    // case INTRINSIC_XED_IFORM_TILERELEASE:
    // 	return "_tile_release";
    // case INTRINSIC_XED_IFORM_TILESTORED_MEMu32_TMMu32:
    // 	return "_tile_stored";
    // case INTRINSIC_XED_IFORM_TILEZERO_TMMu32:
    // 	return "_tile_zero";
    case INTRINSIC_XED_IFORM_VADDPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_add_pd";
    case INTRINSIC_XED_IFORM_VADDPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_add_ps";
    case INTRINSIC_XED_IFORM_VADDSUBPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_addsub_pd";
    case INTRINSIC_XED_IFORM_VADDSUBPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_addsub_ps";
    case INTRINSIC_XED_IFORM_VANDPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_and_pd";
    case INTRINSIC_XED_IFORM_VANDPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_and_ps";
    case INTRINSIC_XED_IFORM_VANDNPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_andnot_pd";
    case INTRINSIC_XED_IFORM_VANDNPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_andnot_ps";
    case INTRINSIC_XED_IFORM_VBLENDPD_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_blend_pd";
    case INTRINSIC_XED_IFORM_VBLENDPS_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_blend_ps";
    case INTRINSIC_XED_IFORM_VBLENDVPD_YMMqq_YMMqq_YMMqq_YMMqq:
    	return "_mm256_blendv_pd";
    case INTRINSIC_XED_IFORM_VBLENDVPS_YMMqq_YMMqq_YMMqq_YMMqq:
    	return "_mm256_blendv_ps";
    case INTRINSIC_XED_IFORM_VDIVPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_div_pd";
    case INTRINSIC_XED_IFORM_VDIVPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_div_ps";
    case INTRINSIC_XED_IFORM_VDPPS_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_dp_ps";
    case INTRINSIC_XED_IFORM_VHADDPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_hadd_pd";
    case INTRINSIC_XED_IFORM_VHADDPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_hadd_ps";
    case INTRINSIC_XED_IFORM_VHSUBPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_hsub_pd";
    case INTRINSIC_XED_IFORM_VHSUBPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_hsub_ps";
    case INTRINSIC_XED_IFORM_VMAXPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_max_pd";
    case INTRINSIC_XED_IFORM_VMAXPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_max_ps";
    case INTRINSIC_XED_IFORM_VMINPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_min_pd";
    case INTRINSIC_XED_IFORM_VMINPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_min_ps";
    case INTRINSIC_XED_IFORM_VMULPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_mul_pd";
    case INTRINSIC_XED_IFORM_VMULPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_mul_ps";
    case INTRINSIC_XED_IFORM_VORPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_or_pd";
    case INTRINSIC_XED_IFORM_VORPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_or_ps";
    case INTRINSIC_XED_IFORM_VSHUFPD_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_shuffle_pd";
    case INTRINSIC_XED_IFORM_VSHUFPS_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_shuffle_ps";
    case INTRINSIC_XED_IFORM_VSUBPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_sub_pd";
    case INTRINSIC_XED_IFORM_VSUBPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_sub_ps";
    case INTRINSIC_XED_IFORM_VXORPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_xor_pd";
    case INTRINSIC_XED_IFORM_VXORPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_xor_ps";
    case INTRINSIC_XED_IFORM_VCMPPD_XMMdq_XMMdq_XMMdq_IMMb:
    	return "_mm_cmp_pd";
    case INTRINSIC_XED_IFORM_VCMPPD_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_cmp_pd";
    case INTRINSIC_XED_IFORM_VCMPPS_XMMdq_XMMdq_XMMdq_IMMb:
    	return "_mm_cmp_ps";
    case INTRINSIC_XED_IFORM_VCMPPS_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_cmp_ps";
    case INTRINSIC_XED_IFORM_VCMPSD_XMMdq_XMMdq_XMMq_IMMb:
    	return "_mm_cmp_sd";
    case INTRINSIC_XED_IFORM_VCMPSS_XMMdq_XMMdq_XMMd_IMMb:
    	return "_mm_cmp_ss";
    case INTRINSIC_XED_IFORM_VCVTDQ2PD_YMMqq_XMMdq:
    	return "_mm256_cvtepi32_pd";
    case INTRINSIC_XED_IFORM_VCVTDQ2PS_YMMqq_YMMqq:
    	return "_mm256_cvtepi32_ps";
    case INTRINSIC_XED_IFORM_VCVTPD2PS_XMMdq_YMMqq:
    	return "_mm256_cvtpd_ps";
    case INTRINSIC_XED_IFORM_VCVTPS2DQ_YMMqq_YMMqq:
    	return "_mm256_cvtps_epi32";
    case INTRINSIC_XED_IFORM_VCVTPS2PD_YMMqq_XMMdq:
    	return "_mm256_cvtps_pd";
    case INTRINSIC_XED_IFORM_VCVTTPD2DQ_XMMdq_YMMqq:
    	return "_mm256_cvttpd_epi32";
    case INTRINSIC_XED_IFORM_VCVTPD2DQ_XMMdq_YMMqq:
    	return "_mm256_cvtpd_epi32";
    case INTRINSIC_XED_IFORM_VCVTTPS2DQ_YMMqq_YMMqq:
    	return "_mm256_cvttps_epi32";
    case INTRINSIC_XED_IFORM_VEXTRACTF128_XMMdq_YMMdq_IMMb:
    	return "_mm256_extractf128_ps";
    case INTRINSIC_XED_IFORM_VZEROALL:
    	return "_mm256_zeroall";
    case INTRINSIC_XED_IFORM_VZEROUPPER:
    	return "_mm256_zeroupper";
    case INTRINSIC_XED_IFORM_VPERMILPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_permutevar_ps";
    case INTRINSIC_XED_IFORM_VPERMILPS_XMMdq_XMMdq_XMMdq:
    	return "_mm_permutevar_ps";
    case INTRINSIC_XED_IFORM_VPERMILPS_YMMqq_YMMqq_IMMb:
    	return "_mm256_permute_ps";
    case INTRINSIC_XED_IFORM_VPERMILPS_XMMdq_XMMdq_IMMb:
    	return "_mm_permute_ps";
    case INTRINSIC_XED_IFORM_VPERMILPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_permutevar_pd";
    case INTRINSIC_XED_IFORM_VPERMILPD_XMMdq_XMMdq_XMMdq:
    	return "_mm_permutevar_pd";
    case INTRINSIC_XED_IFORM_VPERMILPD_YMMqq_YMMqq_IMMb:
    	return "_mm256_permute_pd";
    case INTRINSIC_XED_IFORM_VPERMILPD_XMMdq_XMMdq_IMMb:
    	return "_mm_permute_pd";
    case INTRINSIC_XED_IFORM_VPERM2F128_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_permute2f128_ps";
    case INTRINSIC_XED_IFORM_VBROADCASTSS_YMMqq_MEMd:
    	return "_mm256_broadcast_ss";
    case INTRINSIC_XED_IFORM_VBROADCASTSS_XMMdq_MEMd:
    	return "_mm_broadcast_ss";
    case INTRINSIC_XED_IFORM_VBROADCASTSD_YMMqq_MEMq:
    	return "_mm256_broadcast_sd";
    case INTRINSIC_XED_IFORM_VBROADCASTF128_YMMqq_MEMdq:
    	return "_mm256_broadcast_ps";
    case INTRINSIC_XED_IFORM_VINSERTF128_YMMqq_YMMqq_XMMdq_IMMb:
    	return "_mm256_insertf128_ps";
    case INTRINSIC_XED_IFORM_VMOVAPD_YMMqq_MEMqq:
    	return "_mm256_load_pd";
    case INTRINSIC_XED_IFORM_VMOVAPD_MEMqq_YMMqq:
    	return "_mm256_store_pd";
    case INTRINSIC_XED_IFORM_VMOVAPS_YMMqq_MEMqq:
    	return "_mm256_load_ps";
    case INTRINSIC_XED_IFORM_VMOVAPS_MEMqq_YMMqq:
    	return "_mm256_store_ps";
    case INTRINSIC_XED_IFORM_VMOVUPD_YMMqq_MEMqq:
    	return "_mm256_loadu_pd";
    case INTRINSIC_XED_IFORM_VMOVUPD_MEMqq_YMMqq:
    	return "_mm256_storeu_pd";
    case INTRINSIC_XED_IFORM_VMOVUPS_YMMqq_MEMqq:
    	return "_mm256_loadu_ps";
    case INTRINSIC_XED_IFORM_VMOVUPS_MEMqq_YMMqq:
    	return "_mm256_storeu_ps";
    case INTRINSIC_XED_IFORM_VMOVDQA_YMMqq_MEMqq:
    	return "_mm256_load_si256";
    case INTRINSIC_XED_IFORM_VMOVDQA_MEMqq_YMMqq:
    	return "_mm256_store_si256";
    case INTRINSIC_XED_IFORM_VMOVDQU_YMMqq_MEMqq:
    	return "_mm256_loadu_si256";
    case INTRINSIC_XED_IFORM_VMOVDQU_MEMqq_YMMqq:
    	return "_mm256_storeu_si256";
    case INTRINSIC_XED_IFORM_VMASKMOVPD_YMMqq_YMMqq_MEMqq:
    	return "_mm256_maskload_pd";
    case INTRINSIC_XED_IFORM_VMASKMOVPD_MEMqq_YMMqq_YMMqq:
    	return "_mm256_maskstore_pd";
    case INTRINSIC_XED_IFORM_VMASKMOVPD_XMMdq_XMMdq_MEMdq:
    	return "_mm_maskload_pd";
    case INTRINSIC_XED_IFORM_VMASKMOVPD_MEMdq_XMMdq_XMMdq:
    	return "_mm_maskstore_pd";
    case INTRINSIC_XED_IFORM_VMASKMOVPS_YMMqq_YMMqq_MEMqq:
    	return "_mm256_maskload_ps";
    case INTRINSIC_XED_IFORM_VMASKMOVPS_MEMqq_YMMqq_YMMqq:
    	return "_mm256_maskstore_ps";
    case INTRINSIC_XED_IFORM_VMASKMOVPS_XMMdq_XMMdq_MEMdq:
    	return "_mm_maskload_ps";
    case INTRINSIC_XED_IFORM_VMASKMOVPS_MEMdq_XMMdq_XMMdq:
    	return "_mm_maskstore_ps";
    case INTRINSIC_XED_IFORM_VMOVSHDUP_YMMqq_YMMqq:
    	return "_mm256_movehdup_ps";
    case INTRINSIC_XED_IFORM_VMOVSLDUP_YMMqq_YMMqq:
    	return "_mm256_moveldup_ps";
    case INTRINSIC_XED_IFORM_VMOVDDUP_YMMqq_YMMqq:
    	return "_mm256_movedup_pd";
    case INTRINSIC_XED_IFORM_VLDDQU_YMMqq_MEMqq:
    	return "_mm256_lddqu_si256";
    case INTRINSIC_XED_IFORM_VMOVNTDQ_MEMqq_YMMqq:
    	return "_mm256_stream_si256";
    case INTRINSIC_XED_IFORM_VMOVNTPD_MEMqq_YMMqq:
    	return "_mm256_stream_pd";
    case INTRINSIC_XED_IFORM_VMOVNTPS_MEMqq_YMMqq:
    	return "_mm256_stream_ps";
    case INTRINSIC_XED_IFORM_VRCPPS_YMMqq_YMMqq:
    	return "_mm256_rcp_ps";
    case INTRINSIC_XED_IFORM_VRSQRTPS_YMMqq_YMMqq:
    	return "_mm256_rsqrt_ps";
    case INTRINSIC_XED_IFORM_VSQRTPD_YMMqq_YMMqq:
    	return "_mm256_sqrt_pd";
    case INTRINSIC_XED_IFORM_VSQRTPS_YMMqq_YMMqq:
    	return "_mm256_sqrt_ps";
    case INTRINSIC_XED_IFORM_VROUNDPD_YMMqq_YMMqq_IMMb:
    	return "_mm256_round_pd";
    case INTRINSIC_XED_IFORM_VROUNDPS_YMMqq_YMMqq_IMMb:
    	return "_mm256_round_ps";
    case INTRINSIC_XED_IFORM_VUNPCKHPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_unpackhi_pd";
    case INTRINSIC_XED_IFORM_VUNPCKHPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_unpackhi_ps";
    case INTRINSIC_XED_IFORM_VUNPCKLPD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_unpacklo_pd";
    case INTRINSIC_XED_IFORM_VUNPCKLPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_unpacklo_ps";
    case INTRINSIC_XED_IFORM_VPTEST_YMMqq_YMMqq:
    	return "_mm256_testz_si256";
    case INTRINSIC_XED_IFORM_VTESTPD_YMMqq_YMMqq:
    	return "_mm256_testz_pd";
    case INTRINSIC_XED_IFORM_VTESTPD_XMMdq_XMMdq:
    	return "_mm_testz_pd";
    case INTRINSIC_XED_IFORM_VTESTPS_YMMqq_YMMqq:
    	return "_mm256_testz_ps";
    case INTRINSIC_XED_IFORM_VTESTPS_XMMdq_XMMdq:
    	return "_mm_testz_ps";
    case INTRINSIC_XED_IFORM_VMOVMSKPD_GPR32d_YMMqq:
    	return "_mm256_movemask_pd";
    case INTRINSIC_XED_IFORM_VMOVMSKPS_GPR32d_YMMqq:
    	return "_mm256_movemask_ps";
    case INTRINSIC_XED_IFORM_VPXOR_YMMqq_YMMqq_YMMqq:
    	return "_mm256_setzero_si256";
    case INTRINSIC_XED_IFORM_VMOVSS_MEMd_XMMd:
    	return "_mm256_cvtss_f32";
    case INTRINSIC_XED_IFORM_VMOVSD_MEMq_XMMq:
    	return "_mm256_cvtsd_f64";
    case INTRINSIC_XED_IFORM_VMOVD_GPR32d_XMMd:
    	return "_mm256_cvtsi256_si32";
    case INTRINSIC_XED_IFORM_VPABSB_YMMqq_YMMqq:
    	return "_mm256_abs_epi8";
    case INTRINSIC_XED_IFORM_VPABSW_YMMqq_YMMqq:
    	return "_mm256_abs_epi16";
    case INTRINSIC_XED_IFORM_VPABSD_YMMqq_YMMqq:
    	return "_mm256_abs_epi32";
    case INTRINSIC_XED_IFORM_VPADDB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_add_epi8";
    case INTRINSIC_XED_IFORM_VPADDW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_add_epi16";
    case INTRINSIC_XED_IFORM_VPADDD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_add_epi32";
    case INTRINSIC_XED_IFORM_VPADDQ_YMMqq_YMMqq_YMMqq:
    	return "_mm256_add_epi64";
    case INTRINSIC_XED_IFORM_VPADDSB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_adds_epi8";
    case INTRINSIC_XED_IFORM_VPADDSW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_adds_epi16";
    case INTRINSIC_XED_IFORM_VPADDUSB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_adds_epu8";
    case INTRINSIC_XED_IFORM_VPADDUSW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_adds_epu16";
    case INTRINSIC_XED_IFORM_VPALIGNR_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_alignr_epi8";
    case INTRINSIC_XED_IFORM_VPAND_YMMqq_YMMqq_YMMqq:
    	return "_mm256_and_si256";
    case INTRINSIC_XED_IFORM_VPANDN_YMMqq_YMMqq_YMMqq:
    	return "_mm256_andnot_si256";
    case INTRINSIC_XED_IFORM_VPAVGB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_avg_epu8";
    case INTRINSIC_XED_IFORM_VPAVGW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_avg_epu16";
    case INTRINSIC_XED_IFORM_VPBLENDW_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_blend_epi16";
    case INTRINSIC_XED_IFORM_VPBLENDD_XMMdq_XMMdq_XMMdq_IMMb:
    	return "_mm_blend_epi32";
    case INTRINSIC_XED_IFORM_VPBLENDD_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_blend_epi32";
    case INTRINSIC_XED_IFORM_VPBLENDVB_YMMqq_YMMqq_YMMqq_YMMqq:
    	return "_mm256_blendv_epi8";
    case INTRINSIC_XED_IFORM_VPBROADCASTB_XMMdq_XMMb:
    	return "_mm_broadcastb_epi8";
    case INTRINSIC_XED_IFORM_VPBROADCASTB_YMMqq_XMMb:
    	return "_mm256_broadcastb_epi8";
    case INTRINSIC_XED_IFORM_VPBROADCASTD_XMMdq_XMMd:
    	return "_mm_broadcastd_epi32";
    case INTRINSIC_XED_IFORM_VPBROADCASTD_YMMqq_XMMd:
    	return "_mm256_broadcastd_epi32";
    case INTRINSIC_XED_IFORM_VPBROADCASTQ_XMMdq_XMMq:
    	return "_mm_broadcastq_epi64";
    case INTRINSIC_XED_IFORM_VPBROADCASTQ_YMMqq_XMMq:
    	return "_mm256_broadcastq_epi64";
    case INTRINSIC_XED_IFORM_MOVDDUP_XMMdq_XMMq:
    	return "_mm_broadcastsd_pd";
    case INTRINSIC_XED_IFORM_VBROADCASTSD_YMMqq_XMMdq:
    	return "_mm256_broadcastsd_pd";
    case INTRINSIC_XED_IFORM_VBROADCASTI128_YMMqq_MEMdq:
    	return "_mm_broadcastsi128_si256";
    case INTRINSIC_XED_IFORM_VBROADCASTSS_XMMdq_XMMdq:
    	return "_mm_broadcastss_ps";
    case INTRINSIC_XED_IFORM_VBROADCASTSS_YMMqq_XMMdq:
    	return "_mm256_broadcastss_ps";
    case INTRINSIC_XED_IFORM_VPBROADCASTW_XMMdq_XMMw:
    	return "_mm_broadcastw_epi16";
    case INTRINSIC_XED_IFORM_VPBROADCASTW_YMMqq_XMMw:
    	return "_mm256_broadcastw_epi16";
    case INTRINSIC_XED_IFORM_VPCMPEQB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_cmpeq_epi8";
    case INTRINSIC_XED_IFORM_VPCMPEQW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_cmpeq_epi16";
    case INTRINSIC_XED_IFORM_VPCMPEQD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_cmpeq_epi32";
    case INTRINSIC_XED_IFORM_VPCMPEQQ_YMMqq_YMMqq_YMMqq:
    	return "_mm256_cmpeq_epi64";
    case INTRINSIC_XED_IFORM_VPCMPGTB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_cmpgt_epi8";
    case INTRINSIC_XED_IFORM_VPCMPGTW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_cmpgt_epi16";
    case INTRINSIC_XED_IFORM_VPCMPGTD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_cmpgt_epi32";
    case INTRINSIC_XED_IFORM_VPCMPGTQ_YMMqq_YMMqq_YMMqq:
    	return "_mm256_cmpgt_epi64";
    case INTRINSIC_XED_IFORM_VPMOVSXWD_YMMqq_XMMdq:
    	return "_mm256_cvtepi16_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSXWQ_YMMqq_XMMq:
    	return "_mm256_cvtepi16_epi64";
    case INTRINSIC_XED_IFORM_VPMOVSXDQ_YMMqq_XMMdq:
    	return "_mm256_cvtepi32_epi64";
    case INTRINSIC_XED_IFORM_VPMOVSXBW_YMMqq_XMMdq:
    	return "_mm256_cvtepi8_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSXBD_YMMqq_XMMq:
    	return "_mm256_cvtepi8_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSXBQ_YMMqq_XMMd:
    	return "_mm256_cvtepi8_epi64";
    case INTRINSIC_XED_IFORM_VPMOVZXWD_YMMqq_XMMdq:
    	return "_mm256_cvtepu16_epi32";
    case INTRINSIC_XED_IFORM_VPMOVZXWQ_YMMqq_XMMq:
    	return "_mm256_cvtepu16_epi64";
    case INTRINSIC_XED_IFORM_VPMOVZXDQ_YMMqq_XMMdq:
    	return "_mm256_cvtepu32_epi64";
    case INTRINSIC_XED_IFORM_VPMOVZXBW_YMMqq_XMMdq:
    	return "_mm256_cvtepu8_epi16";
    case INTRINSIC_XED_IFORM_VPMOVZXBD_YMMqq_XMMq:
    	return "_mm256_cvtepu8_epi32";
    case INTRINSIC_XED_IFORM_VPMOVZXBQ_YMMqq_XMMd:
    	return "_mm256_cvtepu8_epi64";
    case INTRINSIC_XED_IFORM_VEXTRACTI128_XMMdq_YMMqq_IMMb:
    	return "_mm256_extracti128_si256";
    case INTRINSIC_XED_IFORM_VPHADDW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_hadd_epi16";
    case INTRINSIC_XED_IFORM_VPHADDD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_hadd_epi32";
    case INTRINSIC_XED_IFORM_VPHADDSW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_hadds_epi16";
    case INTRINSIC_XED_IFORM_VPHSUBW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_hsub_epi16";
    case INTRINSIC_XED_IFORM_VPHSUBD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_hsub_epi32";
    case INTRINSIC_XED_IFORM_VPHSUBSW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_hsubs_epi16";
    case INTRINSIC_XED_IFORM_VGATHERDPD_XMMf64_MEMf64_XMMi64_VL128:
    	return "_mm_i32gather_pd";
    case INTRINSIC_XED_IFORM_VGATHERDPD_YMMf64_MEMf64_YMMi64_VL256:
    	return "_mm256_i32gather_pd";
    case INTRINSIC_XED_IFORM_VGATHERDPS_XMMf32_MEMf32_XMMi32_VL128:
    	return "_mm_i32gather_ps";
    case INTRINSIC_XED_IFORM_VGATHERDPS_YMMf32_MEMf32_YMMi32_VL256:
    	return "_mm256_i32gather_ps";
    case INTRINSIC_XED_IFORM_VPGATHERDD_XMMu32_MEMd_XMMi32_VL128:
    	return "_mm_i32gather_epi32";
    case INTRINSIC_XED_IFORM_VPGATHERDD_YMMu32_MEMd_YMMi32_VL256:
    	return "_mm256_i32gather_epi32";
    case INTRINSIC_XED_IFORM_VPGATHERDQ_XMMu64_MEMq_XMMi64_VL128:
    	return "_mm_i32gather_epi64";
    case INTRINSIC_XED_IFORM_VPGATHERDQ_YMMu64_MEMq_YMMi64_VL256:
    	return "_mm256_i32gather_epi64";
    case INTRINSIC_XED_IFORM_VGATHERQPD_XMMf64_MEMf64_XMMi64_VL128:
    	return "_mm_i64gather_pd";
    case INTRINSIC_XED_IFORM_VGATHERQPD_YMMf64_MEMf64_YMMi64_VL256:
    	return "_mm256_i64gather_pd";
    case INTRINSIC_XED_IFORM_VGATHERQPS_XMMf32_MEMf32_XMMi32_VL128:
    	return "_mm_i64gather_ps";
    case INTRINSIC_XED_IFORM_VGATHERQPS_XMMf32_MEMf32_XMMi32_VL256:
    	return "_mm256_i64gather_ps";
    case INTRINSIC_XED_IFORM_VPGATHERQD_XMMu32_MEMd_XMMi32_VL128:
    	return "_mm_i64gather_epi32";
    case INTRINSIC_XED_IFORM_VPGATHERQD_XMMu32_MEMd_XMMi32_VL256:
    	return "_mm256_i64gather_epi32";
    case INTRINSIC_XED_IFORM_VPGATHERQQ_XMMu64_MEMq_XMMi64_VL128:
    	return "_mm_i64gather_epi64";
    case INTRINSIC_XED_IFORM_VPGATHERQQ_YMMu64_MEMq_YMMi64_VL256:
    	return "_mm256_i64gather_epi64";
    case INTRINSIC_XED_IFORM_VINSERTI128_YMMqq_YMMqq_XMMdq_IMMb:
    	return "_mm256_inserti128_si256";
    case INTRINSIC_XED_IFORM_VPMADDWD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_madd_epi16";
    case INTRINSIC_XED_IFORM_VPMADDUBSW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_maddubs_epi16";
    case INTRINSIC_XED_IFORM_VPMASKMOVD_XMMdq_XMMdq_MEMdq:
    	return "_mm_maskload_epi32";
    case INTRINSIC_XED_IFORM_VPMASKMOVD_YMMqq_YMMqq_MEMqq:
    	return "_mm256_maskload_epi32";
    case INTRINSIC_XED_IFORM_VPMASKMOVQ_XMMdq_XMMdq_MEMdq:
    	return "_mm_maskload_epi64";
    case INTRINSIC_XED_IFORM_VPMASKMOVQ_YMMqq_YMMqq_MEMqq:
    	return "_mm256_maskload_epi64";
    case INTRINSIC_XED_IFORM_VPMASKMOVD_MEMdq_XMMdq_XMMdq:
    	return "_mm_maskstore_epi32";
    case INTRINSIC_XED_IFORM_VPMASKMOVD_MEMqq_YMMqq_YMMqq:
    	return "_mm256_maskstore_epi32";
    case INTRINSIC_XED_IFORM_VPMASKMOVQ_MEMdq_XMMdq_XMMdq:
    	return "_mm_maskstore_epi64";
    case INTRINSIC_XED_IFORM_VPMASKMOVQ_MEMqq_YMMqq_YMMqq:
    	return "_mm256_maskstore_epi64";
    case INTRINSIC_XED_IFORM_VPMAXSB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_max_epi8";
    case INTRINSIC_XED_IFORM_VPMAXSW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_max_epi16";
    case INTRINSIC_XED_IFORM_VPMAXSD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_max_epi32";
    case INTRINSIC_XED_IFORM_VPMAXUB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_max_epu8";
    case INTRINSIC_XED_IFORM_VPMAXUW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_max_epu16";
    case INTRINSIC_XED_IFORM_VPMAXUD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_max_epu32";
    case INTRINSIC_XED_IFORM_VPMINSB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_min_epi8";
    case INTRINSIC_XED_IFORM_VPMINSW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_min_epi16";
    case INTRINSIC_XED_IFORM_VPMINSD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_min_epi32";
    case INTRINSIC_XED_IFORM_VPMINUB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_min_epu8";
    case INTRINSIC_XED_IFORM_VPMINUW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_min_epu16";
    case INTRINSIC_XED_IFORM_VPMINUD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_min_epu32";
    case INTRINSIC_XED_IFORM_VPMOVMSKB_GPR32d_YMMqq:
    	return "_mm256_movemask_epi8";
    case INTRINSIC_XED_IFORM_VMPSADBW_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_mpsadbw_epu8";
    case INTRINSIC_XED_IFORM_VPMULDQ_YMMqq_YMMqq_YMMqq:
    	return "_mm256_mul_epi32";
    case INTRINSIC_XED_IFORM_VPMULUDQ_YMMqq_YMMqq_YMMqq:
    	return "_mm256_mul_epu32";
    case INTRINSIC_XED_IFORM_VPMULHW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_mulhi_epi16";
    case INTRINSIC_XED_IFORM_VPMULHUW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_mulhi_epu16";
    case INTRINSIC_XED_IFORM_VPMULHRSW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_mulhrs_epi16";
    case INTRINSIC_XED_IFORM_VPMULLW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_mullo_epi16";
    case INTRINSIC_XED_IFORM_VPMULLD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_mullo_epi32";
    case INTRINSIC_XED_IFORM_VPOR_YMMqq_YMMqq_YMMqq:
    	return "_mm256_or_si256";
    case INTRINSIC_XED_IFORM_VPACKSSWB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_packs_epi16";
    case INTRINSIC_XED_IFORM_VPACKSSDW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_packs_epi32";
    case INTRINSIC_XED_IFORM_VPACKUSWB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_packus_epi16";
    case INTRINSIC_XED_IFORM_VPACKUSDW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_packus_epi32";
    case INTRINSIC_XED_IFORM_VPERM2I128_YMMqq_YMMqq_YMMqq_IMMb:
    	return "_mm256_permute2x128_si256";
    case INTRINSIC_XED_IFORM_VPERMQ_YMMqq_YMMqq_IMMb:
    	return "_mm256_permute4x64_epi64";
    case INTRINSIC_XED_IFORM_VPERMPD_YMMqq_YMMqq_IMMb:
    	return "_mm256_permute4x64_pd";
    case INTRINSIC_XED_IFORM_VPERMD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_permutevar8x32_epi32";
    case INTRINSIC_XED_IFORM_VPERMPS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_permutevar8x32_ps";
    case INTRINSIC_XED_IFORM_VPSADBW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_sad_epu8";
    case INTRINSIC_XED_IFORM_VPSHUFD_YMMqq_YMMqq_IMMb:
    	return "_mm256_shuffle_epi32";
    case INTRINSIC_XED_IFORM_VPSHUFB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_shuffle_epi8";
    case INTRINSIC_XED_IFORM_VPSHUFHW_YMMqq_YMMqq_IMMb:
    	return "_mm256_shufflehi_epi16";
    case INTRINSIC_XED_IFORM_VPSHUFLW_YMMqq_YMMqq_IMMb:
    	return "_mm256_shufflelo_epi16";
    case INTRINSIC_XED_IFORM_VPSIGNB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_sign_epi8";
    case INTRINSIC_XED_IFORM_VPSIGNW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_sign_epi16";
    case INTRINSIC_XED_IFORM_VPSIGND_YMMqq_YMMqq_YMMqq:
    	return "_mm256_sign_epi32";
    case INTRINSIC_XED_IFORM_VPSLLDQ_YMMqq_YMMqq_IMMb:
    	return "_mm256_slli_si256";
    case INTRINSIC_XED_IFORM_VPSLLW_YMMqq_YMMqq_XMMq:
    	return "_mm256_sll_epi16";
    case INTRINSIC_XED_IFORM_VPSLLW_YMMqq_YMMqq_IMMb:
    	return "_mm256_slli_epi16";
    case INTRINSIC_XED_IFORM_VPSLLD_YMMqq_YMMqq_XMMq:
    	return "_mm256_sll_epi32";
    case INTRINSIC_XED_IFORM_VPSLLD_YMMqq_YMMqq_IMMb:
    	return "_mm256_slli_epi32";
    case INTRINSIC_XED_IFORM_VPSLLQ_YMMqq_YMMqq_XMMq:
    	return "_mm256_sll_epi64";
    case INTRINSIC_XED_IFORM_VPSLLQ_YMMqq_YMMqq_IMMb:
    	return "_mm256_slli_epi64";
    case INTRINSIC_XED_IFORM_VPSLLVD_XMMdq_XMMdq_XMMdq:
    	return "_mm_sllv_epi32";
    case INTRINSIC_XED_IFORM_VPSLLVD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_sllv_epi32";
    case INTRINSIC_XED_IFORM_VPSLLVQ_XMMdq_XMMdq_XMMdq:
    	return "_mm_sllv_epi64";
    case INTRINSIC_XED_IFORM_VPSLLVQ_YMMqq_YMMqq_YMMqq:
    	return "_mm256_sllv_epi64";
    case INTRINSIC_XED_IFORM_VPSRAW_YMMqq_YMMqq_XMMq:
    	return "_mm256_sra_epi16";
    case INTRINSIC_XED_IFORM_VPSRAW_YMMqq_YMMqq_IMMb:
    	return "_mm256_srai_epi16";
    case INTRINSIC_XED_IFORM_VPSRAD_YMMqq_YMMqq_XMMq:
    	return "_mm256_sra_epi32";
    case INTRINSIC_XED_IFORM_VPSRAD_YMMqq_YMMqq_IMMb:
    	return "_mm256_srai_epi32";
    case INTRINSIC_XED_IFORM_VPSRAVD_XMMdq_XMMdq_XMMdq:
    	return "_mm_srav_epi32";
    case INTRINSIC_XED_IFORM_VPSRAVD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_srav_epi32";
    case INTRINSIC_XED_IFORM_VPSRLDQ_YMMqq_YMMqq_IMMb:
    	return "_mm256_srli_si256";
    case INTRINSIC_XED_IFORM_VPSRLW_YMMqq_YMMqq_XMMq:
    	return "_mm256_srl_epi16";
    case INTRINSIC_XED_IFORM_VPSRLW_YMMqq_YMMqq_IMMb:
    	return "_mm256_srli_epi16";
    case INTRINSIC_XED_IFORM_VPSRLD_YMMqq_YMMqq_XMMq:
    	return "_mm256_srl_epi32";
    case INTRINSIC_XED_IFORM_VPSRLD_YMMqq_YMMqq_IMMb:
    	return "_mm256_srli_epi32";
    case INTRINSIC_XED_IFORM_VPSRLQ_YMMqq_YMMqq_XMMq:
    	return "_mm256_srl_epi64";
    case INTRINSIC_XED_IFORM_VPSRLQ_YMMqq_YMMqq_IMMb:
    	return "_mm256_srli_epi64";
    case INTRINSIC_XED_IFORM_VPSRLVD_XMMdq_XMMdq_XMMdq:
    	return "_mm_srlv_epi32";
    case INTRINSIC_XED_IFORM_VPSRLVD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_srlv_epi32";
    case INTRINSIC_XED_IFORM_VPSRLVQ_XMMdq_XMMdq_XMMdq:
    	return "_mm_srlv_epi64";
    case INTRINSIC_XED_IFORM_VPSRLVQ_YMMqq_YMMqq_YMMqq:
    	return "_mm256_srlv_epi64";
    case INTRINSIC_XED_IFORM_VMOVNTDQA_YMMqq_MEMqq:
    	return "_mm256_stream_load_si256";
    case INTRINSIC_XED_IFORM_VPSUBB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_sub_epi8";
    case INTRINSIC_XED_IFORM_VPSUBW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_sub_epi16";
    case INTRINSIC_XED_IFORM_VPSUBD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_sub_epi32";
    case INTRINSIC_XED_IFORM_VPSUBQ_YMMqq_YMMqq_YMMqq:
    	return "_mm256_sub_epi64";
    case INTRINSIC_XED_IFORM_VPSUBSB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_subs_epi8";
    case INTRINSIC_XED_IFORM_VPSUBSW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_subs_epi16";
    case INTRINSIC_XED_IFORM_VPSUBUSB_YMMqq_YMMqq_YMMqq:
    	return "_mm256_subs_epu8";
    case INTRINSIC_XED_IFORM_VPSUBUSW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_subs_epu16";
    case INTRINSIC_XED_IFORM_VPUNPCKHBW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_unpackhi_epi8";
    case INTRINSIC_XED_IFORM_VPUNPCKHWD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_unpackhi_epi16";
    case INTRINSIC_XED_IFORM_VPUNPCKHDQ_YMMqq_YMMqq_YMMqq:
    	return "_mm256_unpackhi_epi32";
    case INTRINSIC_XED_IFORM_VPUNPCKHQDQ_YMMqq_YMMqq_YMMqq:
    	return "_mm256_unpackhi_epi64";
    case INTRINSIC_XED_IFORM_VPUNPCKLBW_YMMqq_YMMqq_YMMqq:
    	return "_mm256_unpacklo_epi8";
    case INTRINSIC_XED_IFORM_VPUNPCKLWD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_unpacklo_epi16";
    case INTRINSIC_XED_IFORM_VPUNPCKLDQ_YMMqq_YMMqq_YMMqq:
    	return "_mm256_unpacklo_epi32";
    case INTRINSIC_XED_IFORM_VPUNPCKLQDQ_YMMqq_YMMqq_YMMqq:
    	return "_mm256_unpacklo_epi64";
    case INTRINSIC_XED_IFORM_KUNPCKDQ_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_mm512_kunpackd";
    case INTRINSIC_XED_IFORM_KUNPCKWD_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_mm512_kunpackw";
    case INTRINSIC_XED_IFORM_VDBPSADBW_YMMu16_MASKmskw_YMMu8_YMMu8_IMM8_AVX512:
    	return "_mm256_dbsad_epu8";
    case INTRINSIC_XED_IFORM_VDBPSADBW_ZMMu16_MASKmskw_ZMMu8_ZMMu8_IMM8_AVX512:
    	return "_mm512_dbsad_epu8";
    case INTRINSIC_XED_IFORM_VDBPSADBW_XMMu16_MASKmskw_XMMu8_XMMu8_IMM8_AVX512:
    	return "_mm_dbsad_epu8";
    case INTRINSIC_XED_IFORM_VMOVDQU16_YMMu16_MASKmskw_MEMu16_AVX512:
    	return "_mm256_mask_loadu_epi16";
    case INTRINSIC_XED_IFORM_VMOVDQU16_YMMu16_MASKmskw_YMMu16_AVX512:
    	return "_mm256_mask_mov_epi16";
    case INTRINSIC_XED_IFORM_VMOVDQU16_MEMu16_MASKmskw_YMMu16_AVX512:
    	return "_mm256_mask_storeu_epi16";
    case INTRINSIC_XED_IFORM_VMOVDQU16_ZMMu16_MASKmskw_MEMu16_AVX512:
    	return "_mm512_mask_loadu_epi16";
    case INTRINSIC_XED_IFORM_VMOVDQU16_ZMMu16_MASKmskw_ZMMu16_AVX512:
    	return "_mm512_mask_mov_epi16";
    case INTRINSIC_XED_IFORM_VMOVDQU16_MEMu16_MASKmskw_ZMMu16_AVX512:
    	return "_mm512_mask_storeu_epi16";
    case INTRINSIC_XED_IFORM_VMOVDQU16_XMMu16_MASKmskw_MEMu16_AVX512:
    	return "_mm_mask_loadu_epi16";
    case INTRINSIC_XED_IFORM_VMOVDQU16_XMMu16_MASKmskw_XMMu16_AVX512:
    	return "_mm_mask_mov_epi16";
    case INTRINSIC_XED_IFORM_VMOVDQU16_MEMu16_MASKmskw_XMMu16_AVX512:
    	return "_mm_mask_storeu_epi16";
    case INTRINSIC_XED_IFORM_VMOVDQU8_YMMu8_MASKmskw_MEMu8_AVX512:
    	return "_mm256_mask_loadu_epi8";
    case INTRINSIC_XED_IFORM_VMOVDQU8_YMMu8_MASKmskw_YMMu8_AVX512:
    	return "_mm256_mask_mov_epi8";
    case INTRINSIC_XED_IFORM_VMOVDQU8_MEMu8_MASKmskw_YMMu8_AVX512:
    	return "_mm256_mask_storeu_epi8";
    case INTRINSIC_XED_IFORM_VMOVDQU8_ZMMu8_MASKmskw_MEMu8_AVX512:
    	return "_mm512_mask_loadu_epi8";
    case INTRINSIC_XED_IFORM_VMOVDQU8_ZMMu8_MASKmskw_ZMMu8_AVX512:
    	return "_mm512_mask_mov_epi8";
    case INTRINSIC_XED_IFORM_VMOVDQU8_MEMu8_MASKmskw_ZMMu8_AVX512:
    	return "_mm512_mask_storeu_epi8";
    case INTRINSIC_XED_IFORM_VMOVDQU8_XMMu8_MASKmskw_MEMu8_AVX512:
    	return "_mm_mask_loadu_epi8";
    case INTRINSIC_XED_IFORM_VMOVDQU8_XMMu8_MASKmskw_XMMu8_AVX512:
    	return "_mm_mask_mov_epi8";
    case INTRINSIC_XED_IFORM_VMOVDQU8_MEMu8_MASKmskw_XMMu8_AVX512:
    	return "_mm_mask_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPABSB_YMMi8_MASKmskw_YMMi8_AVX512:
    	return "_mm256_mask_abs_epi8";
    case INTRINSIC_XED_IFORM_VPABSB_ZMMi8_MASKmskw_ZMMi8_AVX512:
    	return "_mm512_abs_epi8";
    case INTRINSIC_XED_IFORM_VPABSB_XMMi8_MASKmskw_XMMi8_AVX512:
    	return "_mm_mask_abs_epi8";
    case INTRINSIC_XED_IFORM_VPABSW_YMMi16_MASKmskw_YMMi16_AVX512:
    	return "_mm256_mask_abs_epi16";
    case INTRINSIC_XED_IFORM_VPABSW_ZMMi16_MASKmskw_ZMMi16_AVX512:
    	return "_mm512_abs_epi16";
    case INTRINSIC_XED_IFORM_VPABSW_XMMi16_MASKmskw_XMMi16_AVX512:
    	return "_mm_mask_abs_epi16";
    case INTRINSIC_XED_IFORM_VPACKSSDW_YMMi16_MASKmskw_YMMi32_YMMi32_AVX512:
    	return "_mm256_mask_packs_epi32";
    case INTRINSIC_XED_IFORM_VPACKSSDW_ZMMi16_MASKmskw_ZMMi32_ZMMi32_AVX512:
    	return "_mm512_mask_packs_epi32";
    case INTRINSIC_XED_IFORM_VPACKSSDW_XMMi16_MASKmskw_XMMi32_XMMi32_AVX512:
    	return "_mm_mask_packs_epi32";
    case INTRINSIC_XED_IFORM_VPACKSSWB_YMMi8_MASKmskw_YMMi16_YMMi16_AVX512:
    	return "_mm256_mask_packs_epi16";
    case INTRINSIC_XED_IFORM_VPACKSSWB_ZMMi8_MASKmskw_ZMMi16_ZMMi16_AVX512:
    	return "_mm512_mask_packs_epi16";
    case INTRINSIC_XED_IFORM_VPACKSSWB_XMMi8_MASKmskw_XMMi16_XMMi16_AVX512:
    	return "_mm_mask_packs_epi16";
    case INTRINSIC_XED_IFORM_VPACKUSDW_YMMu16_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_packus_epi32";
    case INTRINSIC_XED_IFORM_VPACKUSDW_ZMMu16_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_packus_epi32";
    case INTRINSIC_XED_IFORM_VPACKUSDW_XMMu16_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_packus_epi32";
    case INTRINSIC_XED_IFORM_VPACKUSWB_YMMu8_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_packus_epi16";
    case INTRINSIC_XED_IFORM_VPACKUSWB_ZMMu8_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_packus_epi16";
    case INTRINSIC_XED_IFORM_VPACKUSWB_XMMu8_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_packus_epi16";
    case INTRINSIC_XED_IFORM_VPADDB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_add_epi8";
    case INTRINSIC_XED_IFORM_VPADDB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_add_epi8";
    case INTRINSIC_XED_IFORM_VPADDB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_add_epi8";
    case INTRINSIC_XED_IFORM_VPADDSB_YMMi8_MASKmskw_YMMi8_YMMi8_AVX512:
    	return "_mm256_mask_adds_epi8";
    case INTRINSIC_XED_IFORM_VPADDSB_ZMMi8_MASKmskw_ZMMi8_ZMMi8_AVX512:
    	return "_mm512_adds_epi8";
    case INTRINSIC_XED_IFORM_VPADDSB_XMMi8_MASKmskw_XMMi8_XMMi8_AVX512:
    	return "_mm_mask_adds_epi8";
    case INTRINSIC_XED_IFORM_VPADDSW_YMMi16_MASKmskw_YMMi16_YMMi16_AVX512:
    	return "_mm256_mask_adds_epi16";
    case INTRINSIC_XED_IFORM_VPADDSW_ZMMi16_MASKmskw_ZMMi16_ZMMi16_AVX512:
    	return "_mm512_adds_epi16";
    case INTRINSIC_XED_IFORM_VPADDSW_XMMi16_MASKmskw_XMMi16_XMMi16_AVX512:
    	return "_mm_mask_adds_epi16";
    case INTRINSIC_XED_IFORM_VPADDUSB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_adds_epu8";
    case INTRINSIC_XED_IFORM_VPADDUSB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_adds_epu8";
    case INTRINSIC_XED_IFORM_VPADDUSB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_adds_epu8";
    case INTRINSIC_XED_IFORM_VPADDUSW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_adds_epu16";
    case INTRINSIC_XED_IFORM_VPADDUSW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_adds_epu16";
    case INTRINSIC_XED_IFORM_VPADDUSW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_adds_epu16";
    case INTRINSIC_XED_IFORM_VPADDW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_add_epi16";
    case INTRINSIC_XED_IFORM_VPADDW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_add_epi16";
    case INTRINSIC_XED_IFORM_VPADDW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_add_epi16";
    case INTRINSIC_XED_IFORM_VPALIGNR_YMMu8_MASKmskw_YMMu8_YMMu8_IMM8_AVX512:
    	return "_mm256_mask_alignr_epi8";
    case INTRINSIC_XED_IFORM_VPALIGNR_ZMMu8_MASKmskw_ZMMu8_ZMMu8_IMM8_AVX512:
    	return "_mm512_alignr_epi8";
    case INTRINSIC_XED_IFORM_VPALIGNR_XMMu8_MASKmskw_XMMu8_XMMu8_IMM8_AVX512:
    	return "_mm_mask_alignr_epi8";
    case INTRINSIC_XED_IFORM_VPAVGB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_avg_epu8";
    case INTRINSIC_XED_IFORM_VPAVGB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_avg_epu8";
    case INTRINSIC_XED_IFORM_VPAVGB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_avg_epu8";
    case INTRINSIC_XED_IFORM_VPAVGW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_avg_epu16";
    case INTRINSIC_XED_IFORM_VPAVGW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_avg_epu16";
    case INTRINSIC_XED_IFORM_VPAVGW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_avg_epu16";
    case INTRINSIC_XED_IFORM_VPBLENDMB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_blend_epi8";
    case INTRINSIC_XED_IFORM_VPBLENDMB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_mask_blend_epi8";
    case INTRINSIC_XED_IFORM_VPBLENDMB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_blend_epi8";
    case INTRINSIC_XED_IFORM_VPBLENDMW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_blend_epi16";
    case INTRINSIC_XED_IFORM_VPBLENDMW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_blend_epi16";
    case INTRINSIC_XED_IFORM_VPBLENDMW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_blend_epi16";
    case INTRINSIC_XED_IFORM_VPBROADCASTB_YMMu8_MASKmskw_XMMu8_AVX512:
    	return "_mm256_mask_broadcastb_epi8";
    case INTRINSIC_XED_IFORM_VPBROADCASTB_YMMu8_MASKmskw_GPR32u8_AVX512:
    	return "_mm256_mask_set1_epi8";
    case INTRINSIC_XED_IFORM_VPBROADCASTB_ZMMu8_MASKmskw_XMMu8_AVX512:
    	return "_mm512_broadcastb_epi8";
    case INTRINSIC_XED_IFORM_VPBROADCASTB_ZMMu8_MASKmskw_GPR32u8_AVX512:
    	return "_mm512_mask_set1_epi8";
    case INTRINSIC_XED_IFORM_VPBROADCASTB_XMMu8_MASKmskw_XMMu8_AVX512:
    	return "_mm_mask_broadcastb_epi8";
    case INTRINSIC_XED_IFORM_VPBROADCASTB_XMMu8_MASKmskw_GPR32u8_AVX512:
    	return "_mm_mask_set1_epi8";
    case INTRINSIC_XED_IFORM_VPBROADCASTW_YMMu16_MASKmskw_XMMu16_AVX512:
    	return "_mm256_mask_broadcastw_epi16";
    case INTRINSIC_XED_IFORM_VPBROADCASTW_YMMu16_MASKmskw_GPR32u16_AVX512:
    	return "_mm256_mask_set1_epi16";
    case INTRINSIC_XED_IFORM_VPBROADCASTW_ZMMu16_MASKmskw_XMMu16_AVX512:
    	return "_mm512_broadcastw_epi16";
    case INTRINSIC_XED_IFORM_VPBROADCASTW_ZMMu16_MASKmskw_GPR32u16_AVX512:
    	return "_mm512_mask_set1_epi16";
    case INTRINSIC_XED_IFORM_VPBROADCASTW_XMMu16_MASKmskw_XMMu16_AVX512:
    	return "_mm_mask_broadcastw_epi16";
    case INTRINSIC_XED_IFORM_VPBROADCASTW_XMMu16_MASKmskw_GPR32u16_AVX512:
    	return "_mm_mask_set1_epi16";
    case INTRINSIC_XED_IFORM_VPCMPB_MASKmskw_MASKmskw_YMMi8_YMMi8_IMM8_AVX512:
    	return "_mm256_cmp_epi8_mask";
    case INTRINSIC_XED_IFORM_VPCMPB_MASKmskw_MASKmskw_ZMMi8_ZMMi8_IMM8_AVX512:
    	return "_mm512_cmp_epi8_mask";
    case INTRINSIC_XED_IFORM_VPCMPB_MASKmskw_MASKmskw_XMMi8_XMMi8_IMM8_AVX512:
    	return "_mm_cmp_epi8_mask";
    case INTRINSIC_XED_IFORM_VPCMPUB_MASKmskw_MASKmskw_YMMu8_YMMu8_IMM8_AVX512:
    	return "_mm256_cmp_epu8_mask";
    case INTRINSIC_XED_IFORM_VPCMPUB_MASKmskw_MASKmskw_ZMMu8_ZMMu8_IMM8_AVX512:
    	return "_mm512_cmp_epu8_mask";
    case INTRINSIC_XED_IFORM_VPCMPUB_MASKmskw_MASKmskw_XMMu8_XMMu8_IMM8_AVX512:
    	return "_mm_cmp_epu8_mask";
    case INTRINSIC_XED_IFORM_VPCMPUW_MASKmskw_MASKmskw_YMMu16_YMMu16_IMM8_AVX512:
    	return "_mm256_cmp_epu16_mask";
    case INTRINSIC_XED_IFORM_VPCMPUW_MASKmskw_MASKmskw_ZMMu16_ZMMu16_IMM8_AVX512:
    	return "_mm512_cmp_epu16_mask";
    case INTRINSIC_XED_IFORM_VPCMPUW_MASKmskw_MASKmskw_XMMu16_XMMu16_IMM8_AVX512:
    	return "_mm_cmp_epu16_mask";
    case INTRINSIC_XED_IFORM_VPCMPW_MASKmskw_MASKmskw_YMMi16_YMMi16_IMM8_AVX512:
    	return "_mm256_cmp_epi16_mask";
    case INTRINSIC_XED_IFORM_VPCMPW_MASKmskw_MASKmskw_ZMMi16_ZMMi16_IMM8_AVX512:
    	return "_mm512_cmp_epi16_mask";
    case INTRINSIC_XED_IFORM_VPCMPW_MASKmskw_MASKmskw_XMMi16_XMMi16_IMM8_AVX512:
    	return "_mm_cmp_epi16_mask";
    case INTRINSIC_XED_IFORM_VPERMI2W_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask2_permutex2var_epi16";
    case INTRINSIC_XED_IFORM_VPERMT2W_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_permutex2var_epi16";
    case INTRINSIC_XED_IFORM_VPERMI2W_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask2_permutex2var_epi16";
    case INTRINSIC_XED_IFORM_VPERMT2W_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_permutex2var_epi16";
    case INTRINSIC_XED_IFORM_VPERMI2W_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask2_permutex2var_epi16";
    case INTRINSIC_XED_IFORM_VPERMT2W_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_permutex2var_epi16";
    case INTRINSIC_XED_IFORM_VPERMW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_permutexvar_epi16";
    case INTRINSIC_XED_IFORM_VPERMW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_permutexvar_epi16";
    case INTRINSIC_XED_IFORM_VPERMW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_permutexvar_epi16";
    case INTRINSIC_XED_IFORM_VPMADDUBSW_YMMi16_MASKmskw_YMMi16_YMMi16_AVX512:
    	return "_mm256_mask_maddubs_epi16";
    case INTRINSIC_XED_IFORM_VPMADDUBSW_ZMMi16_MASKmskw_ZMMi16_ZMMi16_AVX512:
    	return "_mm512_maddubs_epi16";
    case INTRINSIC_XED_IFORM_VPMADDUBSW_XMMi16_MASKmskw_XMMi16_XMMi16_AVX512:
    	return "_mm_mask_maddubs_epi16";
    case INTRINSIC_XED_IFORM_VPMADDWD_YMMi32_MASKmskw_YMMi16_YMMi16_AVX512:
    	return "_mm256_mask_madd_epi16";
    case INTRINSIC_XED_IFORM_VPMADDWD_ZMMi32_MASKmskw_ZMMi16_ZMMi16_AVX512:
    	return "_mm512_madd_epi16";
    case INTRINSIC_XED_IFORM_VPMADDWD_XMMi32_MASKmskw_XMMi16_XMMi16_AVX512:
    	return "_mm_mask_madd_epi16";
    case INTRINSIC_XED_IFORM_VPMAXSB_YMMi8_MASKmskw_YMMi8_YMMi8_AVX512:
    	return "_mm256_mask_max_epi8";
    case INTRINSIC_XED_IFORM_VPMAXSB_ZMMi8_MASKmskw_ZMMi8_ZMMi8_AVX512:
    	return "_mm512_mask_max_epi8";
    case INTRINSIC_XED_IFORM_VPMAXSB_XMMi8_MASKmskw_XMMi8_XMMi8_AVX512:
    	return "_mm_mask_max_epi8";
    case INTRINSIC_XED_IFORM_VPMAXSW_YMMi16_MASKmskw_YMMi16_YMMi16_AVX512:
    	return "_mm256_mask_max_epi16";
    case INTRINSIC_XED_IFORM_VPMAXSW_ZMMi16_MASKmskw_ZMMi16_ZMMi16_AVX512:
    	return "_mm512_mask_max_epi16";
    case INTRINSIC_XED_IFORM_VPMAXSW_XMMi16_MASKmskw_XMMi16_XMMi16_AVX512:
    	return "_mm_mask_max_epi16";
    case INTRINSIC_XED_IFORM_VPMAXUB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_max_epu8";
    case INTRINSIC_XED_IFORM_VPMAXUB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_mask_max_epu8";
    case INTRINSIC_XED_IFORM_VPMAXUB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_max_epu8";
    case INTRINSIC_XED_IFORM_VPMAXUW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_max_epu16";
    case INTRINSIC_XED_IFORM_VPMAXUW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_max_epu16";
    case INTRINSIC_XED_IFORM_VPMAXUW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_max_epu16";
    case INTRINSIC_XED_IFORM_VPMINSB_YMMi8_MASKmskw_YMMi8_YMMi8_AVX512:
    	return "_mm256_mask_min_epi8";
    case INTRINSIC_XED_IFORM_VPMINSB_ZMMi8_MASKmskw_ZMMi8_ZMMi8_AVX512:
    	return "_mm512_mask_min_epi8";
    case INTRINSIC_XED_IFORM_VPMINSB_XMMi8_MASKmskw_XMMi8_XMMi8_AVX512:
    	return "_mm_mask_min_epi8";
    case INTRINSIC_XED_IFORM_VPMINSW_YMMi16_MASKmskw_YMMi16_YMMi16_AVX512:
    	return "_mm256_mask_min_epi16";
    case INTRINSIC_XED_IFORM_VPMINSW_ZMMi16_MASKmskw_ZMMi16_ZMMi16_AVX512:
    	return "_mm512_mask_min_epi16";
    case INTRINSIC_XED_IFORM_VPMINSW_XMMi16_MASKmskw_XMMi16_XMMi16_AVX512:
    	return "_mm_mask_min_epi16";
    case INTRINSIC_XED_IFORM_VPMINUB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_min_epu8";
    case INTRINSIC_XED_IFORM_VPMINUB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_mask_min_epu8";
    case INTRINSIC_XED_IFORM_VPMINUB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_min_epu8";
    case INTRINSIC_XED_IFORM_VPMINUW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_min_epu16";
    case INTRINSIC_XED_IFORM_VPMINUW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_min_epu16";
    case INTRINSIC_XED_IFORM_VPMINUW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_min_epu16";
    case INTRINSIC_XED_IFORM_VPMOVB2M_MASKmskw_YMMu8_AVX512:
    	return "_mm256_movepi8_mask";
    case INTRINSIC_XED_IFORM_VPMOVB2M_MASKmskw_ZMMu8_AVX512:
    	return "_mm512_movepi8_mask";
    case INTRINSIC_XED_IFORM_VPMOVB2M_MASKmskw_XMMu8_AVX512:
    	return "_mm_movepi8_mask";
    case INTRINSIC_XED_IFORM_VPMOVM2B_YMMu8_MASKmskw_AVX512:
    	return "_mm256_movm_epi8";
    case INTRINSIC_XED_IFORM_VPMOVM2B_ZMMu8_MASKmskw_AVX512:
    	return "_mm512_movm_epi8";
    case INTRINSIC_XED_IFORM_VPMOVM2B_XMMu8_MASKmskw_AVX512:
    	return "_mm_movm_epi8";
    case INTRINSIC_XED_IFORM_VPMOVM2W_YMMu16_MASKmskw_AVX512:
    	return "_mm256_movm_epi16";
    case INTRINSIC_XED_IFORM_VPMOVM2W_ZMMu16_MASKmskw_AVX512:
    	return "_mm512_movm_epi16";
    case INTRINSIC_XED_IFORM_VPMOVM2W_XMMu16_MASKmskw_AVX512:
    	return "_mm_movm_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSWB_XMMi8_MASKmskw_YMMi16_AVX512:
    	return "_mm256_cvtsepi16_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSWB_MEMi8_MASKmskw_YMMi16_AVX512:
    	return "_mm256_mask_cvtsepi16_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSWB_YMMi8_MASKmskw_ZMMi16_AVX512:
    	return "_mm512_cvtsepi16_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSWB_MEMi8_MASKmskw_ZMMi16_AVX512:
    	return "_mm512_mask_cvtsepi16_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSWB_XMMi8_MASKmskw_XMMi16_AVX512:
    	return "_mm_cvtsepi16_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSWB_MEMi8_MASKmskw_XMMi16_AVX512:
    	return "_mm_mask_cvtsepi16_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSXBW_YMMi16_MASKmskw_XMMi8_AVX512:
    	return "_mm256_mask_cvtepi8_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSXBW_ZMMi16_MASKmskw_YMMi8_AVX512:
    	return "_mm512_cvtepi8_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSXBW_XMMi16_MASKmskw_XMMi8_AVX512:
    	return "_mm_mask_cvtepi8_epi16";
    case INTRINSIC_XED_IFORM_VPMOVUSWB_XMMu8_MASKmskw_YMMu16_AVX512:
    	return "_mm256_cvtusepi16_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSWB_MEMu8_MASKmskw_YMMu16_AVX512:
    	return "_mm256_mask_cvtusepi16_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSWB_YMMu8_MASKmskw_ZMMu16_AVX512:
    	return "_mm512_cvtusepi16_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSWB_MEMu8_MASKmskw_ZMMu16_AVX512:
    	return "_mm512_mask_cvtusepi16_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSWB_XMMu8_MASKmskw_XMMu16_AVX512:
    	return "_mm_cvtusepi16_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSWB_MEMu8_MASKmskw_XMMu16_AVX512:
    	return "_mm_mask_cvtusepi16_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVW2M_MASKmskw_YMMu16_AVX512:
    	return "_mm256_movepi16_mask";
    case INTRINSIC_XED_IFORM_VPMOVW2M_MASKmskw_ZMMu16_AVX512:
    	return "_mm512_movepi16_mask";
    case INTRINSIC_XED_IFORM_VPMOVW2M_MASKmskw_XMMu16_AVX512:
    	return "_mm_movepi16_mask";
    case INTRINSIC_XED_IFORM_VPMOVWB_XMMu8_MASKmskw_YMMu16_AVX512:
    	return "_mm256_cvtepi16_epi8";
    case INTRINSIC_XED_IFORM_VPMOVWB_MEMu8_MASKmskw_YMMu16_AVX512:
    	return "_mm256_mask_cvtepi16_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVWB_YMMu8_MASKmskw_ZMMu16_AVX512:
    	return "_mm512_cvtepi16_epi8";
    case INTRINSIC_XED_IFORM_VPMOVWB_MEMu8_MASKmskw_ZMMu16_AVX512:
    	return "_mm512_mask_cvtepi16_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVWB_XMMu8_MASKmskw_XMMu16_AVX512:
    	return "_mm_cvtepi16_epi8";
    case INTRINSIC_XED_IFORM_VPMOVWB_MEMu8_MASKmskw_XMMu16_AVX512:
    	return "_mm_mask_cvtepi16_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVZXBW_YMMi16_MASKmskw_XMMi8_AVX512:
    	return "_mm256_mask_cvtepu8_epi16";
    case INTRINSIC_XED_IFORM_VPMOVZXBW_ZMMi16_MASKmskw_YMMi8_AVX512:
    	return "_mm512_cvtepu8_epi16";
    case INTRINSIC_XED_IFORM_VPMOVZXBW_XMMi16_MASKmskw_XMMi8_AVX512:
    	return "_mm_mask_cvtepu8_epi16";
    case INTRINSIC_XED_IFORM_VPMULHRSW_YMMi16_MASKmskw_YMMi16_YMMi16_AVX512:
    	return "_mm256_mask_mulhrs_epi16";
    case INTRINSIC_XED_IFORM_VPMULHRSW_ZMMi16_MASKmskw_ZMMi16_ZMMi16_AVX512:
    	return "_mm512_mask_mulhrs_epi16";
    case INTRINSIC_XED_IFORM_VPMULHRSW_XMMi16_MASKmskw_XMMi16_XMMi16_AVX512:
    	return "_mm_mask_mulhrs_epi16";
    case INTRINSIC_XED_IFORM_VPMULHUW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_mulhi_epu16";
    case INTRINSIC_XED_IFORM_VPMULHUW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_mulhi_epu16";
    case INTRINSIC_XED_IFORM_VPMULHUW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_mulhi_epu16";
    case INTRINSIC_XED_IFORM_VPMULHW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_mulhi_epi16";
    case INTRINSIC_XED_IFORM_VPMULHW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_mulhi_epi16";
    case INTRINSIC_XED_IFORM_VPMULHW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_mulhi_epi16";
    case INTRINSIC_XED_IFORM_VPMULLW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_mullo_epi16";
    case INTRINSIC_XED_IFORM_VPMULLW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_mullo_epi16";
    case INTRINSIC_XED_IFORM_VPMULLW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_mullo_epi16";
    case INTRINSIC_XED_IFORM_VPSADBW_ZMMu16_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_sad_epu8";
    case INTRINSIC_XED_IFORM_VPSHUFB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_shuffle_epi8";
    case INTRINSIC_XED_IFORM_VPSHUFB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_mask_shuffle_epi8";
    case INTRINSIC_XED_IFORM_VPSHUFB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_shuffle_epi8";
    case INTRINSIC_XED_IFORM_VPSHUFHW_YMMu16_MASKmskw_YMMu16_IMM8_AVX512:
    	return "_mm256_mask_shufflehi_epi16";
    case INTRINSIC_XED_IFORM_VPSHUFHW_ZMMu16_MASKmskw_ZMMu16_IMM8_AVX512:
    	return "_mm512_mask_shufflehi_epi16";
    case INTRINSIC_XED_IFORM_VPSHUFHW_XMMu16_MASKmskw_XMMu16_IMM8_AVX512:
    	return "_mm_mask_shufflehi_epi16";
    case INTRINSIC_XED_IFORM_VPSHUFLW_YMMu16_MASKmskw_YMMu16_IMM8_AVX512:
    	return "_mm256_mask_shufflelo_epi16";
    case INTRINSIC_XED_IFORM_VPSHUFLW_ZMMu16_MASKmskw_ZMMu16_IMM8_AVX512:
    	return "_mm512_mask_shufflelo_epi16";
    case INTRINSIC_XED_IFORM_VPSHUFLW_XMMu16_MASKmskw_XMMu16_IMM8_AVX512:
    	return "_mm_mask_shufflelo_epi16";
    case INTRINSIC_XED_IFORM_VPSLLDQ_ZMMu8_ZMMu8_IMM8_AVX512:
    	return "_mm512_bslli_epi128";
    case INTRINSIC_XED_IFORM_VPSLLVW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_sllv_epi16";
    case INTRINSIC_XED_IFORM_VPSLLVW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_sllv_epi16";
    case INTRINSIC_XED_IFORM_VPSLLVW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_sllv_epi16";
    case INTRINSIC_XED_IFORM_VPSLLW_YMMu16_MASKmskw_YMMu16_XMMu16_AVX512:
    	return "_mm256_mask_sll_epi16";
    case INTRINSIC_XED_IFORM_VPSLLW_YMMu16_MASKmskw_YMMu16_IMM8_AVX512:
    	return "_mm256_mask_slli_epi16";
    case INTRINSIC_XED_IFORM_VPSLLW_ZMMu16_MASKmskw_ZMMu16_XMMu16_AVX512:
    	return "_mm512_mask_sll_epi16";
    case INTRINSIC_XED_IFORM_VPSLLW_ZMMu16_MASKmskw_ZMMu16_IMM8_AVX512:
    	return "_mm512_mask_slli_epi16";
    case INTRINSIC_XED_IFORM_VPSLLW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_sll_epi16";
    case INTRINSIC_XED_IFORM_VPSLLW_XMMu16_MASKmskw_XMMu16_IMM8_AVX512:
    	return "_mm_mask_slli_epi16";
    case INTRINSIC_XED_IFORM_VPSRAVW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_srav_epi16";
    case INTRINSIC_XED_IFORM_VPSRAVW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_srav_epi16";
    case INTRINSIC_XED_IFORM_VPSRAVW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_srav_epi16";
    case INTRINSIC_XED_IFORM_VPSRAW_YMMu16_MASKmskw_YMMu16_XMMu16_AVX512:
    	return "_mm256_mask_sra_epi16";
    case INTRINSIC_XED_IFORM_VPSRAW_YMMu16_MASKmskw_YMMu16_IMM8_AVX512:
    	return "_mm256_mask_srai_epi16";
    case INTRINSIC_XED_IFORM_VPSRAW_ZMMu16_MASKmskw_ZMMu16_XMMu16_AVX512:
    	return "_mm512_mask_sra_epi16";
    case INTRINSIC_XED_IFORM_VPSRAW_ZMMu16_MASKmskw_ZMMu16_IMM8_AVX512:
    	return "_mm512_mask_srai_epi16";
    case INTRINSIC_XED_IFORM_VPSRAW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_sra_epi16";
    case INTRINSIC_XED_IFORM_VPSRAW_XMMu16_MASKmskw_XMMu16_IMM8_AVX512:
    	return "_mm_mask_srai_epi16";
    case INTRINSIC_XED_IFORM_VPSRLDQ_ZMMu8_ZMMu8_IMM8_AVX512:
    	return "_mm512_bsrli_epi128";
    case INTRINSIC_XED_IFORM_VPSRLVW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_srlv_epi16";
    case INTRINSIC_XED_IFORM_VPSRLVW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_srlv_epi16";
    case INTRINSIC_XED_IFORM_VPSRLVW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_srlv_epi16";
    case INTRINSIC_XED_IFORM_VPSRLW_YMMu16_MASKmskw_YMMu16_XMMu16_AVX512:
    	return "_mm256_mask_srl_epi16";
    case INTRINSIC_XED_IFORM_VPSRLW_YMMu16_MASKmskw_YMMu16_IMM8_AVX512:
    	return "_mm256_mask_srli_epi16";
    case INTRINSIC_XED_IFORM_VPSRLW_ZMMu16_MASKmskw_ZMMu16_XMMu16_AVX512:
    	return "_mm512_mask_srl_epi16";
    case INTRINSIC_XED_IFORM_VPSRLW_ZMMu16_MASKmskw_ZMMu16_IMM8_AVX512:
    	return "_mm512_mask_srli_epi16";
    case INTRINSIC_XED_IFORM_VPSRLW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_srl_epi16";
    case INTRINSIC_XED_IFORM_VPSRLW_XMMu16_MASKmskw_XMMu16_IMM8_AVX512:
    	return "_mm_mask_srli_epi16";
    case INTRINSIC_XED_IFORM_VPSUBB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_sub_epi8";
    case INTRINSIC_XED_IFORM_VPSUBB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_mask_sub_epi8";
    case INTRINSIC_XED_IFORM_VPSUBB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_sub_epi8";
    case INTRINSIC_XED_IFORM_VPSUBSB_YMMi8_MASKmskw_YMMi8_YMMi8_AVX512:
    	return "_mm256_mask_subs_epi8";
    case INTRINSIC_XED_IFORM_VPSUBSB_ZMMi8_MASKmskw_ZMMi8_ZMMi8_AVX512:
    	return "_mm512_mask_subs_epi8";
    case INTRINSIC_XED_IFORM_VPSUBSB_XMMi8_MASKmskw_XMMi8_XMMi8_AVX512:
    	return "_mm_mask_subs_epi8";
    case INTRINSIC_XED_IFORM_VPSUBSW_YMMi16_MASKmskw_YMMi16_YMMi16_AVX512:
    	return "_mm256_mask_subs_epi16";
    case INTRINSIC_XED_IFORM_VPSUBSW_ZMMi16_MASKmskw_ZMMi16_ZMMi16_AVX512:
    	return "_mm512_mask_subs_epi16";
    case INTRINSIC_XED_IFORM_VPSUBSW_XMMi16_MASKmskw_XMMi16_XMMi16_AVX512:
    	return "_mm_mask_subs_epi16";
    case INTRINSIC_XED_IFORM_VPSUBUSB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_subs_epu8";
    case INTRINSIC_XED_IFORM_VPSUBUSB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_mask_subs_epu8";
    case INTRINSIC_XED_IFORM_VPSUBUSB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_subs_epu8";
    case INTRINSIC_XED_IFORM_VPSUBUSW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_subs_epu16";
    case INTRINSIC_XED_IFORM_VPSUBUSW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_subs_epu16";
    case INTRINSIC_XED_IFORM_VPSUBUSW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_subs_epu16";
    case INTRINSIC_XED_IFORM_VPSUBW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_sub_epi16";
    case INTRINSIC_XED_IFORM_VPSUBW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_sub_epi16";
    case INTRINSIC_XED_IFORM_VPSUBW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_sub_epi16";
    case INTRINSIC_XED_IFORM_VPTESTMB_MASKmskw_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_test_epi8_mask";
    case INTRINSIC_XED_IFORM_VPTESTMB_MASKmskw_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_mask_test_epi8_mask";
    case INTRINSIC_XED_IFORM_VPTESTMB_MASKmskw_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_test_epi8_mask";
    case INTRINSIC_XED_IFORM_VPTESTMW_MASKmskw_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_test_epi16_mask";
    case INTRINSIC_XED_IFORM_VPTESTMW_MASKmskw_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_test_epi16_mask";
    case INTRINSIC_XED_IFORM_VPTESTMW_MASKmskw_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_test_epi16_mask";
    case INTRINSIC_XED_IFORM_VPTESTNMB_MASKmskw_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_testn_epi8_mask";
    case INTRINSIC_XED_IFORM_VPTESTNMB_MASKmskw_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_mask_testn_epi8_mask";
    case INTRINSIC_XED_IFORM_VPTESTNMB_MASKmskw_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_testn_epi8_mask";
    case INTRINSIC_XED_IFORM_VPTESTNMW_MASKmskw_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_testn_epi16_mask";
    case INTRINSIC_XED_IFORM_VPTESTNMW_MASKmskw_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_testn_epi16_mask";
    case INTRINSIC_XED_IFORM_VPTESTNMW_MASKmskw_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_testn_epi16_mask";
    case INTRINSIC_XED_IFORM_VPUNPCKHBW_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_unpackhi_epi8";
    case INTRINSIC_XED_IFORM_VPUNPCKHBW_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_mask_unpackhi_epi8";
    case INTRINSIC_XED_IFORM_VPUNPCKHBW_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_unpackhi_epi8";
    case INTRINSIC_XED_IFORM_VPUNPCKHWD_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_unpackhi_epi16";
    case INTRINSIC_XED_IFORM_VPUNPCKHWD_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_unpackhi_epi16";
    case INTRINSIC_XED_IFORM_VPUNPCKHWD_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_unpackhi_epi16";
    case INTRINSIC_XED_IFORM_VPUNPCKLBW_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_unpacklo_epi8";
    case INTRINSIC_XED_IFORM_VPUNPCKLBW_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_mask_unpacklo_epi8";
    case INTRINSIC_XED_IFORM_VPUNPCKLBW_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_unpacklo_epi8";
    case INTRINSIC_XED_IFORM_VPUNPCKLWD_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_mask_unpacklo_epi16";
    case INTRINSIC_XED_IFORM_VPUNPCKLWD_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_mask_unpacklo_epi16";
    case INTRINSIC_XED_IFORM_VPUNPCKLWD_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_mask_unpacklo_epi16";
    case INTRINSIC_XED_IFORM_KADDD_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kadd_mask32";
    case INTRINSIC_XED_IFORM_KADDQ_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kadd_mask64";
    case INTRINSIC_XED_IFORM_KANDD_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kand_mask32";
    case INTRINSIC_XED_IFORM_KANDQ_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kand_mask64";
    case INTRINSIC_XED_IFORM_KANDND_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kandn_mask32";
    case INTRINSIC_XED_IFORM_KANDNQ_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kandn_mask64";
    case INTRINSIC_XED_IFORM_KNOTD_MASKmskw_MASKmskw_AVX512:
    	return "_knot_mask32";
    case INTRINSIC_XED_IFORM_KNOTQ_MASKmskw_MASKmskw_AVX512:
    	return "_knot_mask64";
    case INTRINSIC_XED_IFORM_KORD_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kor_mask32";
    case INTRINSIC_XED_IFORM_KORQ_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kor_mask64";
    case INTRINSIC_XED_IFORM_KXNORD_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kxnor_mask32";
    case INTRINSIC_XED_IFORM_KXNORQ_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kxnor_mask64";
    case INTRINSIC_XED_IFORM_KXORD_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kxor_mask32";
    case INTRINSIC_XED_IFORM_KXORQ_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kxor_mask64";
    case INTRINSIC_XED_IFORM_KSHIFTLD_MASKmskw_MASKmskw_IMM8_AVX512:
    	return "_kshiftli_mask32";
    case INTRINSIC_XED_IFORM_KSHIFTLQ_MASKmskw_MASKmskw_IMM8_AVX512:
    	return "_kshiftli_mask64";
    case INTRINSIC_XED_IFORM_KSHIFTRD_MASKmskw_MASKmskw_IMM8_AVX512:
    	return "_kshiftri_mask32";
    case INTRINSIC_XED_IFORM_KSHIFTRQ_MASKmskw_MASKmskw_IMM8_AVX512:
    	return "_kshiftri_mask64";
    case INTRINSIC_XED_IFORM_KMOVD_MASKmskw_MEMu32_AVX512:
    	return "_load_mask32";
    case INTRINSIC_XED_IFORM_KMOVQ_MASKmskw_MEMu64_AVX512:
    	return "_load_mask64";
    case INTRINSIC_XED_IFORM_KMOVD_MEMu32_MASKmskw_AVX512:
    	return "_store_mask32";
    case INTRINSIC_XED_IFORM_KMOVQ_MEMu64_MASKmskw_AVX512:
    	return "_store_mask64";
    case INTRINSIC_XED_IFORM_KORTESTD_MASKmskw_MASKmskw_AVX512:
    	return "_kortest_mask32_u8";
    case INTRINSIC_XED_IFORM_KORTESTQ_MASKmskw_MASKmskw_AVX512:
    	return "_kortest_mask64_u8";
    case INTRINSIC_XED_IFORM_KTESTD_MASKmskw_MASKmskw_AVX512:
    	return "_ktest_mask32_u8";
    case INTRINSIC_XED_IFORM_KTESTQ_MASKmskw_MASKmskw_AVX512:
    	return "_ktest_mask64_u8";
    case INTRINSIC_XED_IFORM_KMOVD_GPR32u32_MASKmskw_AVX512:
    	return "_cvtmask32_u32";
    case INTRINSIC_XED_IFORM_KMOVQ_GPR64u64_MASKmskw_AVX512:
    	return "_cvtmask64_u64";
    case INTRINSIC_XED_IFORM_KMOVD_MASKmskw_GPR32u32_AVX512:
    	return "_cvtu32_mask32";
    case INTRINSIC_XED_IFORM_KMOVQ_MASKmskw_GPR64u64_AVX512:
    	return "_cvtu64_mask64";
    case INTRINSIC_XED_IFORM_VPBROADCASTMB2Q_YMMu64_MASKu64_AVX512:
    	return "_mm256_broadcastmb_epi64";
    case INTRINSIC_XED_IFORM_VPBROADCASTMB2Q_XMMu64_MASKu64_AVX512:
    	return "_mm_broadcastmb_epi64";
    case INTRINSIC_XED_IFORM_VPBROADCASTMW2D_YMMu32_MASKu32_AVX512:
    	return "_mm256_broadcastmw_epi32";
    case INTRINSIC_XED_IFORM_VPBROADCASTMW2D_XMMu32_MASKu32_AVX512:
    	return "_mm_broadcastmw_epi32";
    case INTRINSIC_XED_IFORM_VPCONFLICTD_YMMu32_MASKmskw_YMMu32_AVX512:
    	return "_mm256_conflict_epi32";
    case INTRINSIC_XED_IFORM_VPCONFLICTD_XMMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm_conflict_epi32";
    case INTRINSIC_XED_IFORM_VPCONFLICTQ_YMMu64_MASKmskw_YMMu64_AVX512:
    	return "_mm256_conflict_epi64";
    case INTRINSIC_XED_IFORM_VPCONFLICTQ_XMMu64_MASKmskw_XMMu64_AVX512:
    	return "_mm_conflict_epi64";
    case INTRINSIC_XED_IFORM_VPLZCNTD_YMMu32_MASKmskw_YMMu32_AVX512:
    	return "_mm256_lzcnt_epi32";
    case INTRINSIC_XED_IFORM_VPLZCNTD_XMMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm_lzcnt_epi32";
    case INTRINSIC_XED_IFORM_VPLZCNTQ_YMMu64_MASKmskw_YMMu64_AVX512:
    	return "_mm256_lzcnt_epi64";
    case INTRINSIC_XED_IFORM_VPLZCNTQ_XMMu64_MASKmskw_XMMu64_AVX512:
    	return "_mm_lzcnt_epi64";
    case INTRINSIC_XED_IFORM_VPBROADCASTMB2Q_ZMMu64_MASKu64_AVX512CD:
    	return "_mm512_broadcastmb_epi64";
    case INTRINSIC_XED_IFORM_VPBROADCASTMW2D_ZMMu32_MASKu32_AVX512CD:
    	return "_mm512_broadcastmw_epi32";
    case INTRINSIC_XED_IFORM_VPCONFLICTD_ZMMu32_MASKmskw_ZMMu32_AVX512CD:
    	return "_mm512_conflict_epi32";
    case INTRINSIC_XED_IFORM_VPCONFLICTQ_ZMMu64_MASKmskw_ZMMu64_AVX512CD:
    	return "_mm512_conflict_epi64";
    case INTRINSIC_XED_IFORM_VPLZCNTD_ZMMu32_MASKmskw_ZMMu32_AVX512CD:
    	return "_mm512_lzcnt_epi32";
    case INTRINSIC_XED_IFORM_VPLZCNTQ_ZMMu64_MASKmskw_ZMMu64_AVX512CD:
    	return "_mm512_lzcnt_epi64";
    case INTRINSIC_XED_IFORM_VANDNPD_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_andnot_pd";
    case INTRINSIC_XED_IFORM_VANDNPD_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_andnot_pd";
    case INTRINSIC_XED_IFORM_VANDNPD_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_andnot_pd";
    case INTRINSIC_XED_IFORM_VANDNPS_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_andnot_ps";
    case INTRINSIC_XED_IFORM_VANDNPS_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_andnot_ps";
    case INTRINSIC_XED_IFORM_VANDNPS_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_andnot_ps";
    case INTRINSIC_XED_IFORM_VANDPD_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_and_pd";
    case INTRINSIC_XED_IFORM_VANDPD_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_and_pd";
    case INTRINSIC_XED_IFORM_VANDPD_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_and_pd";
    case INTRINSIC_XED_IFORM_VANDPS_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_and_ps";
    case INTRINSIC_XED_IFORM_VANDPS_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_and_ps";
    case INTRINSIC_XED_IFORM_VANDPS_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_and_ps";
    case INTRINSIC_XED_IFORM_VBROADCASTF32X2_YMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm256_broadcast_f32x2";
    case INTRINSIC_XED_IFORM_VBROADCASTF32X2_ZMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm512_broadcast_f32x2";
    case INTRINSIC_XED_IFORM_VBROADCASTF32X8_ZMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm512_broadcast_f32x8";
    case INTRINSIC_XED_IFORM_VBROADCASTF64X2_YMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm256_broadcast_f64x2";
    case INTRINSIC_XED_IFORM_VBROADCASTF64X2_ZMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm512_broadcast_f64x2";
    case INTRINSIC_XED_IFORM_VBROADCASTI32X2_YMMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm256_broadcast_i32x2";
    case INTRINSIC_XED_IFORM_VBROADCASTI32X2_ZMMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm512_broadcast_i32x2";
    case INTRINSIC_XED_IFORM_VBROADCASTI32X2_XMMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm_broadcast_i32x2";
    case INTRINSIC_XED_IFORM_VBROADCASTI32X8_ZMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm512_broadcast_i32x8";
    case INTRINSIC_XED_IFORM_VBROADCASTI64X2_YMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm256_broadcast_i64x2";
    case INTRINSIC_XED_IFORM_VBROADCASTI64X2_ZMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm512_broadcast_i64x2";
    case INTRINSIC_XED_IFORM_VCVTPD2QQ_YMMi64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_cvtpd_epi64";
    case INTRINSIC_XED_IFORM_VCVTPD2QQ_ZMMi64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_cvt_roundpd_epi64";
    case INTRINSIC_XED_IFORM_VCVTPD2QQ_XMMi64_MASKmskw_XMMf64_AVX512:
    	return "_mm_cvtpd_epi64";
    case INTRINSIC_XED_IFORM_VCVTPD2UQQ_YMMu64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_cvtpd_epu64";
    case INTRINSIC_XED_IFORM_VCVTPD2UQQ_ZMMu64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_cvt_roundpd_epu64";
    case INTRINSIC_XED_IFORM_VCVTPD2UQQ_XMMu64_MASKmskw_XMMf64_AVX512:
    	return "_mm_cvtpd_epu64";
    case INTRINSIC_XED_IFORM_VCVTPS2QQ_YMMi64_MASKmskw_XMMf32_AVX512:
    	return "_mm256_cvtps_epi64";
    case INTRINSIC_XED_IFORM_VCVTPS2QQ_ZMMi64_MASKmskw_YMMf32_AVX512:
    	return "_mm512_cvt_roundps_epi64";
    case INTRINSIC_XED_IFORM_VCVTPS2QQ_XMMi64_MASKmskw_XMMf32_AVX512:
    	return "_mm_cvtps_epi64";
    case INTRINSIC_XED_IFORM_VCVTPS2UQQ_YMMu64_MASKmskw_XMMf32_AVX512:
    	return "_mm256_cvtps_epu64";
    case INTRINSIC_XED_IFORM_VCVTPS2UQQ_ZMMu64_MASKmskw_YMMf32_AVX512:
    	return "_mm512_cvt_roundps_epu64";
    case INTRINSIC_XED_IFORM_VCVTPS2UQQ_XMMu64_MASKmskw_XMMf32_AVX512:
    	return "_mm_cvtps_epu64";
    case INTRINSIC_XED_IFORM_VCVTQQ2PD_YMMi64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_cvtepi64_pd";
    case INTRINSIC_XED_IFORM_VCVTQQ2PD_ZMMi64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_cvt_roundepi64_pd";
    case INTRINSIC_XED_IFORM_VCVTQQ2PD_XMMi64_MASKmskw_XMMf64_AVX512:
    	return "_mm_cvtepi64_pd";
    case INTRINSIC_XED_IFORM_VCVTQQ2PS_XMMf32_MASKmskw_YMMu64_AVX512_VL256:
    	return "_mm256_cvtepi64_ps";
    case INTRINSIC_XED_IFORM_VCVTQQ2PS_YMMf32_MASKmskw_ZMMu64_AVX512_VL512:
    	return "_mm512_cvt_roundepi64_ps";
    case INTRINSIC_XED_IFORM_VCVTQQ2PS_XMMf32_MASKmskw_XMMu64_AVX512_VL128:
    	return "_mm_cvtepi64_ps";
    case INTRINSIC_XED_IFORM_VCVTTPD2QQ_YMMi64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_cvttpd_epi64";
    case INTRINSIC_XED_IFORM_VCVTTPD2QQ_ZMMi64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_cvtt_roundpd_epi64";
    case INTRINSIC_XED_IFORM_VCVTTPD2QQ_XMMi64_MASKmskw_XMMf64_AVX512:
    	return "_mm_cvttpd_epi64";
    case INTRINSIC_XED_IFORM_VCVTTPD2UQQ_YMMu64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_cvttpd_epu64";
    case INTRINSIC_XED_IFORM_VCVTTPD2UQQ_ZMMu64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_cvtt_roundpd_epu64";
    case INTRINSIC_XED_IFORM_VCVTTPD2UQQ_XMMu64_MASKmskw_XMMf64_AVX512:
    	return "_mm_cvttpd_epu64";
    case INTRINSIC_XED_IFORM_VCVTTPS2QQ_YMMi64_MASKmskw_XMMf32_AVX512:
    	return "_mm256_cvttps_epi64";
    case INTRINSIC_XED_IFORM_VCVTTPS2QQ_ZMMi64_MASKmskw_YMMf32_AVX512:
    	return "_mm512_cvtt_roundps_epi64";
    case INTRINSIC_XED_IFORM_VCVTTPS2QQ_XMMi64_MASKmskw_XMMf32_AVX512:
    	return "_mm_cvttps_epi64";
    case INTRINSIC_XED_IFORM_VCVTTPS2UQQ_YMMu64_MASKmskw_XMMf32_AVX512:
    	return "_mm256_cvttps_epu64";
    case INTRINSIC_XED_IFORM_VCVTTPS2UQQ_ZMMu64_MASKmskw_YMMf32_AVX512:
    	return "_mm512_cvtt_roundps_epu64";
    case INTRINSIC_XED_IFORM_VCVTTPS2UQQ_XMMu64_MASKmskw_XMMf32_AVX512:
    	return "_mm_cvttps_epu64";
    case INTRINSIC_XED_IFORM_VCVTUQQ2PD_YMMf64_MASKmskw_YMMu64_AVX512:
    	return "_mm256_cvtepu64_pd";
    case INTRINSIC_XED_IFORM_VCVTUQQ2PD_ZMMf64_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_cvt_roundepu64_pd";
    case INTRINSIC_XED_IFORM_VCVTUQQ2PD_XMMf64_MASKmskw_XMMu64_AVX512:
    	return "_mm_cvtepu64_pd";
    case INTRINSIC_XED_IFORM_VCVTUQQ2PS_XMMf32_MASKmskw_YMMu64_AVX512_VL256:
    	return "_mm256_cvtepu64_ps";
    case INTRINSIC_XED_IFORM_VCVTUQQ2PS_YMMf32_MASKmskw_ZMMu64_AVX512_VL512:
    	return "_mm512_cvt_roundepu64_ps";
    case INTRINSIC_XED_IFORM_VCVTUQQ2PS_XMMf32_MASKmskw_XMMu64_AVX512_VL128:
    	return "_mm_cvtepu64_ps";
    case INTRINSIC_XED_IFORM_VEXTRACTF32X8_YMMf32_MASKmskw_ZMMf32_IMM8_AVX512:
    	return "_mm512_extractf32x8_ps";
    case INTRINSIC_XED_IFORM_VEXTRACTF64X2_XMMf64_MASKmskw_YMMf64_IMM8_AVX512:
    	return "_mm256_extractf64x2_pd";
    case INTRINSIC_XED_IFORM_VEXTRACTF64X2_XMMf64_MASKmskw_ZMMf64_IMM8_AVX512:
    	return "_mm512_extractf64x2_pd";
    case INTRINSIC_XED_IFORM_VEXTRACTI32X8_YMMu32_MASKmskw_ZMMu32_IMM8_AVX512:
    	return "_mm512_extracti32x8_epi32";
    case INTRINSIC_XED_IFORM_VEXTRACTI64X2_XMMu64_MASKmskw_YMMu64_IMM8_AVX512:
    	return "_mm256_extracti64x2_epi64";
    case INTRINSIC_XED_IFORM_VEXTRACTI64X2_XMMu64_MASKmskw_ZMMu64_IMM8_AVX512:
    	return "_mm512_extracti64x2_epi64";
    case INTRINSIC_XED_IFORM_VFPCLASSPD_MASKmskw_MASKmskw_YMMf64_IMM8_AVX512:
    	return "_mm256_fpclass_pd_mask";
    case INTRINSIC_XED_IFORM_VFPCLASSPD_MASKmskw_MASKmskw_ZMMf64_IMM8_AVX512:
    	return "_mm512_fpclass_pd_mask";
    case INTRINSIC_XED_IFORM_VFPCLASSPD_MASKmskw_MASKmskw_XMMf64_IMM8_AVX512:
    	return "_mm_fpclass_pd_mask";
    case INTRINSIC_XED_IFORM_VFPCLASSPS_MASKmskw_MASKmskw_YMMf32_IMM8_AVX512:
    	return "_mm256_fpclass_ps_mask";
    case INTRINSIC_XED_IFORM_VFPCLASSPS_MASKmskw_MASKmskw_ZMMf32_IMM8_AVX512:
    	return "_mm512_fpclass_ps_mask";
    case INTRINSIC_XED_IFORM_VFPCLASSPS_MASKmskw_MASKmskw_XMMf32_IMM8_AVX512:
    	return "_mm_fpclass_ps_mask";
    case INTRINSIC_XED_IFORM_VFPCLASSSD_MASKmskw_MASKmskw_XMMf64_IMM8_AVX512:
    	return "_mm_fpclass_sd_mask";
    case INTRINSIC_XED_IFORM_VFPCLASSSS_MASKmskw_MASKmskw_XMMf32_IMM8_AVX512:
    	return "_mm_fpclass_ss_mask";
    case INTRINSIC_XED_IFORM_VINSERTF32X8_ZMMf32_MASKmskw_ZMMf32_YMMf32_IMM8_AVX512:
    	return "_mm512_insertf32x8";
    case INTRINSIC_XED_IFORM_VINSERTF64X2_YMMf64_MASKmskw_YMMf64_XMMf64_IMM8_AVX512:
    	return "_mm256_insertf64x2";
    case INTRINSIC_XED_IFORM_VINSERTF64X2_ZMMf64_MASKmskw_ZMMf64_XMMf64_IMM8_AVX512:
    	return "_mm512_insertf64x2";
    case INTRINSIC_XED_IFORM_VINSERTI32X8_ZMMu32_MASKmskw_ZMMu32_YMMu32_IMM8_AVX512:
    	return "_mm512_inserti32x8";
    case INTRINSIC_XED_IFORM_VINSERTI64X2_YMMu64_MASKmskw_YMMu64_XMMu64_IMM8_AVX512:
    	return "_mm256_inserti64x2";
    case INTRINSIC_XED_IFORM_VINSERTI64X2_ZMMu64_MASKmskw_ZMMu64_XMMu64_IMM8_AVX512:
    	return "_mm512_inserti64x2";
    case INTRINSIC_XED_IFORM_VORPD_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_or_pd";
    case INTRINSIC_XED_IFORM_VORPD_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_or_pd";
    case INTRINSIC_XED_IFORM_VORPD_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_or_pd";
    case INTRINSIC_XED_IFORM_VORPS_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_or_ps";
    case INTRINSIC_XED_IFORM_VORPS_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_or_ps";
    case INTRINSIC_XED_IFORM_VORPS_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_or_ps";
    case INTRINSIC_XED_IFORM_VPMOVD2M_MASKmskw_YMMu32_AVX512:
    	return "_mm256_movepi32_mask";
    case INTRINSIC_XED_IFORM_VPMOVD2M_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_movepi32_mask";
    case INTRINSIC_XED_IFORM_VPMOVD2M_MASKmskw_XMMu32_AVX512:
    	return "_mm_movepi32_mask";
    case INTRINSIC_XED_IFORM_VPMOVM2D_YMMu32_MASKmskw_AVX512:
    	return "_mm256_movm_epi32";
    case INTRINSIC_XED_IFORM_VPMOVM2D_ZMMu32_MASKmskw_AVX512:
    	return "_mm512_movm_epi32";
    case INTRINSIC_XED_IFORM_VPMOVM2D_XMMu32_MASKmskw_AVX512:
    	return "_mm_movm_epi32";
    case INTRINSIC_XED_IFORM_VPMOVM2Q_YMMu64_MASKmskw_AVX512:
    	return "_mm256_movm_epi64";
    case INTRINSIC_XED_IFORM_VPMOVM2Q_ZMMu64_MASKmskw_AVX512:
    	return "_mm512_movm_epi64";
    case INTRINSIC_XED_IFORM_VPMOVM2Q_XMMu64_MASKmskw_AVX512:
    	return "_mm_movm_epi64";
    case INTRINSIC_XED_IFORM_VPMOVQ2M_MASKmskw_YMMu64_AVX512:
    	return "_mm256_movepi64_mask";
    case INTRINSIC_XED_IFORM_VPMOVQ2M_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_movepi64_mask";
    case INTRINSIC_XED_IFORM_VPMOVQ2M_MASKmskw_XMMu64_AVX512:
    	return "_mm_movepi64_mask";
    case INTRINSIC_XED_IFORM_VPMULLQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_mullo_epi64";
    case INTRINSIC_XED_IFORM_VPMULLQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_mullo_epi64";
    case INTRINSIC_XED_IFORM_VPMULLQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_mullo_epi64";
    case INTRINSIC_XED_IFORM_VRANGEPD_YMMf64_MASKmskw_YMMf64_YMMf64_IMM8_AVX512:
    	return "_mm256_mask_range_pd";
    case INTRINSIC_XED_IFORM_VRANGEPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_IMM8_AVX512:
    	return "_mm512_mask_range_pd";
    case INTRINSIC_XED_IFORM_VRANGEPD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512:
    	return "_mm_mask_range_pd";
    case INTRINSIC_XED_IFORM_VRANGEPS_YMMf32_MASKmskw_YMMf32_YMMf32_IMM8_AVX512:
    	return "_mm256_mask_range_ps";
    case INTRINSIC_XED_IFORM_VRANGEPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_IMM8_AVX512:
    	return "_mm512_mask_range_ps";
    case INTRINSIC_XED_IFORM_VRANGEPS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512:
    	return "_mm_mask_range_ps";
    case INTRINSIC_XED_IFORM_VRANGESD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512:
    	return "_mm_mask_range_round_sd";
    case INTRINSIC_XED_IFORM_VRANGESS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512:
    	return "_mm_mask_range_round_ss";
    case INTRINSIC_XED_IFORM_VREDUCEPD_YMMf64_MASKmskw_YMMf64_IMM8_AVX512:
    	return "_mm256_mask_reduce_pd";
    case INTRINSIC_XED_IFORM_VREDUCEPD_ZMMf64_MASKmskw_ZMMf64_IMM8_AVX512:
    	return "_mm512_mask_reduce_pd";
    case INTRINSIC_XED_IFORM_VREDUCEPD_XMMf64_MASKmskw_XMMf64_IMM8_AVX512:
    	return "_mm_mask_reduce_pd";
    case INTRINSIC_XED_IFORM_VREDUCEPS_YMMf32_MASKmskw_YMMf32_IMM8_AVX512:
    	return "_mm256_mask_reduce_ps";
    case INTRINSIC_XED_IFORM_VREDUCEPS_ZMMf32_MASKmskw_ZMMf32_IMM8_AVX512:
    	return "_mm512_mask_reduce_ps";
    case INTRINSIC_XED_IFORM_VREDUCEPS_XMMf32_MASKmskw_XMMf32_IMM8_AVX512:
    	return "_mm_mask_reduce_ps";
    case INTRINSIC_XED_IFORM_VREDUCESD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512:
    	return "_mm_mask_reduce_sd";
    case INTRINSIC_XED_IFORM_VREDUCESS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512:
    	return "_mm_mask_reduce_ss";
    case INTRINSIC_XED_IFORM_VXORPD_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_xor_pd";
    case INTRINSIC_XED_IFORM_VXORPD_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_xor_pd";
    case INTRINSIC_XED_IFORM_VXORPD_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_xor_pd";
    case INTRINSIC_XED_IFORM_VXORPS_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_xor_ps";
    case INTRINSIC_XED_IFORM_VXORPS_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_xor_ps";
    case INTRINSIC_XED_IFORM_VXORPS_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_xor_ps";
    case INTRINSIC_XED_IFORM_KADDB_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kadd_mask8";
    case INTRINSIC_XED_IFORM_KADDW_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kadd_mask16";
    case INTRINSIC_XED_IFORM_KANDB_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kand_mask8";
    case INTRINSIC_XED_IFORM_KANDNB_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kandn_mask8";
    case INTRINSIC_XED_IFORM_KNOTB_MASKmskw_MASKmskw_AVX512:
    	return "_knot_mask8";
    case INTRINSIC_XED_IFORM_KORB_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kor_mask8";
    case INTRINSIC_XED_IFORM_KXNORB_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kxnor_mask8";
    case INTRINSIC_XED_IFORM_KXORB_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kxor_mask8";
    case INTRINSIC_XED_IFORM_KSHIFTLB_MASKmskw_MASKmskw_IMM8_AVX512:
    	return "_kshiftli_mask8";
    case INTRINSIC_XED_IFORM_KSHIFTRB_MASKmskw_MASKmskw_IMM8_AVX512:
    	return "_kshiftri_mask8";
    case INTRINSIC_XED_IFORM_KMOVB_MASKmskw_MEMu8_AVX512:
    	return "_load_mask8";
    case INTRINSIC_XED_IFORM_KMOVB_MEMu8_MASKmskw_AVX512:
    	return "_store_mask8";
    case INTRINSIC_XED_IFORM_KORTESTB_MASKmskw_MASKmskw_AVX512:
    	return "_kortest_mask8_u8";
    case INTRINSIC_XED_IFORM_KTESTB_MASKmskw_MASKmskw_AVX512:
    	return "_ktest_mask8_u8";
    case INTRINSIC_XED_IFORM_KTESTW_MASKmskw_MASKmskw_AVX512:
    	return "_ktest_mask16_u8";
    case INTRINSIC_XED_IFORM_KMOVB_GPR32u32_MASKmskw_AVX512:
    	return "_cvtmask8_u32";
    case INTRINSIC_XED_IFORM_KMOVB_MASKmskw_GPR32u32_AVX512:
    	return "_cvtu32_mask8";
    case INTRINSIC_XED_IFORM_VEXP2PS_ZMMf32_MASKmskw_ZMMf32_AVX512ER:
    	return "_mm512_exp2a23_round_ps";
    case INTRINSIC_XED_IFORM_VEXP2PD_ZMMf64_MASKmskw_ZMMf64_AVX512ER:
    	return "_mm512_exp2a23_round_pd";
    case INTRINSIC_XED_IFORM_VRCP28SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512ER:
    	return "_mm_rcp28_round_sd";
    case INTRINSIC_XED_IFORM_VRCP28SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512ER:
    	return "_mm_rcp28_round_ss";
    case INTRINSIC_XED_IFORM_VRCP28PS_ZMMf32_MASKmskw_ZMMf32_AVX512ER:
    	return "_mm512_rcp28_round_ps";
    case INTRINSIC_XED_IFORM_VRCP28PD_ZMMf64_MASKmskw_ZMMf64_AVX512ER:
    	return "_mm512_rcp28_round_pd";
    case INTRINSIC_XED_IFORM_VRSQRT28SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512ER:
    	return "_mm_rsqrt28_round_sd";
    case INTRINSIC_XED_IFORM_VRSQRT28SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512ER:
    	return "_mm_rsqrt28_round_ss";
    case INTRINSIC_XED_IFORM_VRSQRT28PS_ZMMf32_MASKmskw_ZMMf32_AVX512ER:
    	return "_mm512_rsqrt28_round_ps";
    case INTRINSIC_XED_IFORM_VRSQRT28PD_ZMMf64_MASKmskw_ZMMf64_AVX512ER:
    	return "_mm512_rsqrt28_round_pd";
    case INTRINSIC_XED_IFORM_VADDPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_add_pd";
    case INTRINSIC_XED_IFORM_VADDPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_add_pd";
    case INTRINSIC_XED_IFORM_VADDPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_add_ps";
    case INTRINSIC_XED_IFORM_VADDPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_add_ps";
    case INTRINSIC_XED_IFORM_VALIGND_YMMu32_MASKmskw_YMMu32_YMMu32_IMM8_AVX512:
    	return "_mm256_alignr_epi32";
    case INTRINSIC_XED_IFORM_VALIGND_XMMu32_MASKmskw_XMMu32_XMMu32_IMM8_AVX512:
    	return "_mm_alignr_epi32";
    case INTRINSIC_XED_IFORM_VALIGNQ_YMMu64_MASKmskw_YMMu64_YMMu64_IMM8_AVX512:
    	return "_mm256_alignr_epi64";
    case INTRINSIC_XED_IFORM_VALIGNQ_XMMu64_MASKmskw_XMMu64_XMMu64_IMM8_AVX512:
    	return "_mm_alignr_epi64";
    case INTRINSIC_XED_IFORM_VBLENDMPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_blend_pd";
    case INTRINSIC_XED_IFORM_VBLENDMPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_blend_pd";
    case INTRINSIC_XED_IFORM_VBLENDMPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_blend_ps";
    case INTRINSIC_XED_IFORM_VBLENDMPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_blend_ps";
    case INTRINSIC_XED_IFORM_VBROADCASTF32X4_YMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm256_broadcast_f32x4";
    case INTRINSIC_XED_IFORM_VBROADCASTI32X4_YMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm256_broadcast_i32x4";
    case INTRINSIC_XED_IFORM_VBROADCASTSD_YMMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm256_mask_broadcastsd_pd";
    case INTRINSIC_XED_IFORM_VBROADCASTSS_YMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm256_mask_broadcastss_ps";
    case INTRINSIC_XED_IFORM_VBROADCASTSS_XMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_broadcastss_ps";
    case INTRINSIC_XED_IFORM_VCMPPD_MASKmskw_MASKmskw_YMMf64_YMMf64_IMM8_AVX512:
    	return "_mm256_cmp_pd_mask";
    case INTRINSIC_XED_IFORM_VCMPPD_MASKmskw_MASKmskw_XMMf64_XMMf64_IMM8_AVX512:
    	return "_mm_cmp_pd_mask";
    case INTRINSIC_XED_IFORM_VCMPPS_MASKmskw_MASKmskw_YMMf32_YMMf32_IMM8_AVX512:
    	return "_mm256_cmp_ps_mask";
    case INTRINSIC_XED_IFORM_VCMPPS_MASKmskw_MASKmskw_XMMf32_XMMf32_IMM8_AVX512:
    	return "_mm_cmp_ps_mask";
    case INTRINSIC_XED_IFORM_VCOMPRESSPD_YMMf64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_mask_compress_pd";
    case INTRINSIC_XED_IFORM_VCOMPRESSPD_MEMf64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_mask_compressstoreu_pd";
    case INTRINSIC_XED_IFORM_VCOMPRESSPD_XMMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm_mask_compress_pd";
    case INTRINSIC_XED_IFORM_VCOMPRESSPD_MEMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm_mask_compressstoreu_pd";
    case INTRINSIC_XED_IFORM_VCOMPRESSPS_YMMf32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_compress_ps";
    case INTRINSIC_XED_IFORM_VCOMPRESSPS_MEMf32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_compressstoreu_ps";
    case INTRINSIC_XED_IFORM_VCOMPRESSPS_XMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_compress_ps";
    case INTRINSIC_XED_IFORM_VCOMPRESSPS_MEMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_compressstoreu_ps";
    case INTRINSIC_XED_IFORM_VCVTDQ2PD_YMMf64_MASKmskw_XMMi32_AVX512:
    	return "_mm256_mask_cvtepi32_pd";
    case INTRINSIC_XED_IFORM_VCVTDQ2PD_XMMf64_MASKmskw_XMMi32_AVX512:
    	return "_mm_mask_cvtepi32_pd";
    case INTRINSIC_XED_IFORM_VCVTDQ2PS_YMMf32_MASKmskw_YMMi32_AVX512:
    	return "_mm256_mask_cvtepi32_ps";
    case INTRINSIC_XED_IFORM_VCVTDQ2PS_XMMf32_MASKmskw_XMMi32_AVX512:
    	return "_mm_mask_cvtepi32_ps";
    case INTRINSIC_XED_IFORM_VCVTPD2DQ_XMMi32_MASKmskw_YMMf64_AVX512_VL256:
    	return "_mm256_mask_cvtpd_epi32";
    case INTRINSIC_XED_IFORM_VCVTPD2DQ_XMMi32_MASKmskw_XMMf64_AVX512_VL128:
    	return "_mm_mask_cvtpd_epi32";
    case INTRINSIC_XED_IFORM_VCVTPD2PS_XMMf32_MASKmskw_YMMf64_AVX512_VL256:
    	return "_mm256_mask_cvtpd_ps";
    case INTRINSIC_XED_IFORM_VCVTPD2PS_XMMf32_MASKmskw_XMMf64_AVX512_VL128:
    	return "_mm_mask_cvtpd_ps";
    case INTRINSIC_XED_IFORM_VCVTPD2UDQ_XMMu32_MASKmskw_YMMf64_AVX512_VL256:
    	return "_mm256_cvtpd_epu32";
    case INTRINSIC_XED_IFORM_VCVTPD2UDQ_XMMu32_MASKmskw_XMMf64_AVX512_VL128:
    	return "_mm_cvtpd_epu32";
    case INTRINSIC_XED_IFORM_VCVTPH2PS_YMMf32_MASKmskw_XMMf16_AVX512:
    	return "_mm256_mask_cvtph_ps";
    case INTRINSIC_XED_IFORM_VCVTPH2PS_XMMf32_MASKmskw_XMMf16_AVX512:
    	return "_mm_mask_cvtph_ps";
    case INTRINSIC_XED_IFORM_VCVTPS2DQ_YMMi32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_cvtps_epi32";
    case INTRINSIC_XED_IFORM_VCVTPS2DQ_XMMi32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_cvtps_epi32";
    case INTRINSIC_XED_IFORM_VCVTPS2PH_XMMf16_MASKmskw_YMMf32_IMM8_AVX512:
    	return "_mm256_mask_cvt_roundps_ph";
    case INTRINSIC_XED_IFORM_VCVTPS2PH_XMMf16_MASKmskw_XMMf32_IMM8_AVX512:
    	return "_mm_mask_cvt_roundps_ph";
    case INTRINSIC_XED_IFORM_VCVTPS2UDQ_YMMu32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_cvtps_epu32";
    case INTRINSIC_XED_IFORM_VCVTPS2UDQ_XMMu32_MASKmskw_XMMf32_AVX512:
    	return "_mm_cvtps_epu32";
    case INTRINSIC_XED_IFORM_VCVTTPD2DQ_XMMi32_MASKmskw_YMMf64_AVX512_VL256:
    	return "_mm256_mask_cvttpd_epi32";
    case INTRINSIC_XED_IFORM_VCVTTPD2DQ_XMMi32_MASKmskw_XMMf64_AVX512_VL128:
    	return "_mm_mask_cvttpd_epi32";
    case INTRINSIC_XED_IFORM_VCVTTPD2UDQ_XMMu32_MASKmskw_YMMf64_AVX512_VL256:
    	return "_mm256_cvttpd_epu32";
    case INTRINSIC_XED_IFORM_VCVTTPD2UDQ_XMMu32_MASKmskw_XMMf64_AVX512_VL128:
    	return "_mm_cvttpd_epu32";
    case INTRINSIC_XED_IFORM_VCVTTPS2DQ_YMMi32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_cvttps_epi32";
    case INTRINSIC_XED_IFORM_VCVTTPS2DQ_XMMi32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_cvttps_epi32";
    case INTRINSIC_XED_IFORM_VCVTTPS2UDQ_YMMu32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_cvttps_epu32";
    case INTRINSIC_XED_IFORM_VCVTTPS2UDQ_XMMu32_MASKmskw_XMMf32_AVX512:
    	return "_mm_cvttps_epu32";
    case INTRINSIC_XED_IFORM_VCVTUDQ2PD_YMMf64_MASKmskw_XMMu32_AVX512:
    	return "_mm256_cvtepu32_pd";
    case INTRINSIC_XED_IFORM_VCVTUDQ2PD_XMMf64_MASKmskw_XMMu32_AVX512:
    	return "_mm_cvtepu32_pd";
    case INTRINSIC_XED_IFORM_VDIVPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_div_pd";
    case INTRINSIC_XED_IFORM_VDIVPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_div_pd";
    case INTRINSIC_XED_IFORM_VDIVPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_div_ps";
    case INTRINSIC_XED_IFORM_VDIVPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_div_ps";
    case INTRINSIC_XED_IFORM_VEXPANDPD_YMMf64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_mask_expand_pd";
    case INTRINSIC_XED_IFORM_VEXPANDPD_YMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm256_mask_expandloadu_pd";
    case INTRINSIC_XED_IFORM_VEXPANDPD_XMMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm_mask_expand_pd";
    case INTRINSIC_XED_IFORM_VEXPANDPD_XMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm_mask_expandloadu_pd";
    case INTRINSIC_XED_IFORM_VEXPANDPS_YMMf32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_expand_ps";
    case INTRINSIC_XED_IFORM_VEXPANDPS_YMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm256_mask_expandloadu_ps";
    case INTRINSIC_XED_IFORM_VEXPANDPS_XMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_expand_ps";
    case INTRINSIC_XED_IFORM_VEXPANDPS_XMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm_mask_expandloadu_ps";
    case INTRINSIC_XED_IFORM_VEXTRACTF32X4_XMMf32_MASKmskw_YMMf32_IMM8_AVX512:
    	return "_mm256_extractf32x4_ps";
    case INTRINSIC_XED_IFORM_VEXTRACTI32X4_XMMu32_MASKmskw_YMMu32_IMM8_AVX512:
    	return "_mm256_extracti32x4_epi32";
    case INTRINSIC_XED_IFORM_VFIXUPIMMPD_YMMf64_MASKmskw_YMMf64_YMMf64_IMM8_AVX512:
    	return "_mm256_fixupimm_pd";
    case INTRINSIC_XED_IFORM_VFIXUPIMMPD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512:
    	return "_mm_fixupimm_pd";
    case INTRINSIC_XED_IFORM_VFIXUPIMMPS_YMMf32_MASKmskw_YMMf32_YMMf32_IMM8_AVX512:
    	return "_mm256_fixupimm_ps";
    case INTRINSIC_XED_IFORM_VFIXUPIMMPS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512:
    	return "_mm_fixupimm_ps";
    case INTRINSIC_XED_IFORM_VFMADD132PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD213PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD231PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD132PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD213PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD231PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD132PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD213PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD231PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD132PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD213PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD231PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB132PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB213PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB231PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB132PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB213PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB231PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB132PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB213PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB231PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB132PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB213PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB231PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB132PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB213PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB231PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB132PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB213PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB231PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB132PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB213PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB231PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB132PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB213PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB231PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD132PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD213PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD231PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD132PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD213PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD231PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD132PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD213PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD231PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD132PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD213PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD231PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD132PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD213PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD231PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD132PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD213PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD231PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD132PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD213PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD231PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD132PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD213PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD231PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB132PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB213PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB231PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask3_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB132PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB213PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB231PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask3_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB132PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB213PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB231PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask3_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB132PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB213PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB231PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VGATHERDPD_YMMf64_MASKmskw_MEMf64_AVX512_VL256:
    	return "_mm256_mmask_i32gather_pd";
    case INTRINSIC_XED_IFORM_VGATHERDPD_XMMf64_MASKmskw_MEMf64_AVX512_VL128:
    	return "_mm_mmask_i32gather_pd";
    case INTRINSIC_XED_IFORM_VGATHERDPS_YMMf32_MASKmskw_MEMf32_AVX512_VL256:
    	return "_mm256_mmask_i32gather_ps";
    case INTRINSIC_XED_IFORM_VGATHERDPS_XMMf32_MASKmskw_MEMf32_AVX512_VL128:
    	return "_mm_mmask_i32gather_ps";
    case INTRINSIC_XED_IFORM_VGATHERQPD_YMMf64_MASKmskw_MEMf64_AVX512_VL256:
    	return "_mm256_mmask_i64gather_pd";
    case INTRINSIC_XED_IFORM_VGATHERQPD_XMMf64_MASKmskw_MEMf64_AVX512_VL128:
    	return "_mm_mmask_i64gather_pd";
    case INTRINSIC_XED_IFORM_VGATHERQPS_YMMf32_MASKmskw_MEMf32_AVX512_VL512:
    	return "_mm256_mmask_i64gather_ps";
    case INTRINSIC_XED_IFORM_VGATHERQPS_XMMf32_MASKmskw_MEMf32_AVX512_VL128:
    	return "_mm_mmask_i64gather_ps";
    case INTRINSIC_XED_IFORM_VGETEXPPD_YMMf64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_getexp_pd";
    case INTRINSIC_XED_IFORM_VGETEXPPD_XMMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm_getexp_pd";
    case INTRINSIC_XED_IFORM_VGETEXPPS_YMMf32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_getexp_ps";
    case INTRINSIC_XED_IFORM_VGETEXPPS_XMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_getexp_ps";
    case INTRINSIC_XED_IFORM_VGETMANTPD_YMMf64_MASKmskw_YMMf64_IMM8_AVX512:
    	return "_mm256_getmant_pd";
    case INTRINSIC_XED_IFORM_VGETMANTPD_XMMf64_MASKmskw_XMMf64_IMM8_AVX512:
    	return "_mm_getmant_pd";
    case INTRINSIC_XED_IFORM_VGETMANTPS_YMMf32_MASKmskw_YMMf32_IMM8_AVX512:
    	return "_mm256_getmant_ps";
    case INTRINSIC_XED_IFORM_VGETMANTPS_XMMf32_MASKmskw_XMMf32_IMM8_AVX512:
    	return "_mm_getmant_ps";
    case INTRINSIC_XED_IFORM_VINSERTF32X4_YMMf32_MASKmskw_YMMf32_XMMf32_IMM8_AVX512:
    	return "_mm256_insertf32x4";
    case INTRINSIC_XED_IFORM_VINSERTI32X4_YMMu32_MASKmskw_YMMu32_XMMu32_IMM8_AVX512:
    	return "_mm256_inserti32x4";
    case INTRINSIC_XED_IFORM_VMAXPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_max_pd";
    case INTRINSIC_XED_IFORM_VMAXPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_max_pd";
    case INTRINSIC_XED_IFORM_VMAXPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_max_ps";
    case INTRINSIC_XED_IFORM_VMAXPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_max_ps";
    case INTRINSIC_XED_IFORM_VMINPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_min_pd";
    case INTRINSIC_XED_IFORM_VMINPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_min_pd";
    case INTRINSIC_XED_IFORM_VMINPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_min_ps";
    case INTRINSIC_XED_IFORM_VMINPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_min_ps";
    case INTRINSIC_XED_IFORM_VMOVAPD_YMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm256_mask_load_pd";
    case INTRINSIC_XED_IFORM_VMOVAPD_YMMf64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_mask_mov_pd";
    case INTRINSIC_XED_IFORM_VMOVAPD_MEMf64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_mask_store_pd";
    case INTRINSIC_XED_IFORM_VMOVAPD_XMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm_mask_load_pd";
    case INTRINSIC_XED_IFORM_VMOVAPD_XMMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm_mask_mov_pd";
    case INTRINSIC_XED_IFORM_VMOVAPD_MEMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm_mask_store_pd";
    case INTRINSIC_XED_IFORM_VMOVAPS_YMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm256_mask_load_ps";
    case INTRINSIC_XED_IFORM_VMOVAPS_YMMf32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_mov_ps";
    case INTRINSIC_XED_IFORM_VMOVAPS_MEMf32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_store_ps";
    case INTRINSIC_XED_IFORM_VMOVAPS_XMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm_mask_load_ps";
    case INTRINSIC_XED_IFORM_VMOVAPS_XMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_mov_ps";
    case INTRINSIC_XED_IFORM_VMOVAPS_MEMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_store_ps";
    case INTRINSIC_XED_IFORM_VMOVDDUP_YMMf64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_mask_movedup_pd";
    case INTRINSIC_XED_IFORM_VMOVDDUP_XMMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm_mask_movedup_pd";
    case INTRINSIC_XED_IFORM_VMOVDQA32_YMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm256_mask_load_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQA32_YMMu32_MASKmskw_YMMu32_AVX512:
    	return "_mm256_mask_mov_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQA32_MEMu32_MASKmskw_YMMu32_AVX512:
    	return "_mm256_mask_store_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQA32_XMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm_mask_load_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQA32_XMMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm_mask_mov_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQA32_MEMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm_mask_store_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQA64_YMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm256_mask_load_epi64";
    case INTRINSIC_XED_IFORM_VMOVDQA64_YMMu64_MASKmskw_YMMu64_AVX512:
    	return "_mm256_mask_mov_epi64";
    case INTRINSIC_XED_IFORM_VMOVDQA64_MEMu64_MASKmskw_YMMu64_AVX512:
    	return "_mm256_mask_store_epi64";
    case INTRINSIC_XED_IFORM_VMOVDQA64_XMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm_mask_load_epi64";
    case INTRINSIC_XED_IFORM_VMOVDQA64_XMMu64_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_mov_epi64";
    case INTRINSIC_XED_IFORM_VMOVDQA64_MEMu64_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_store_epi64";
    case INTRINSIC_XED_IFORM_VMOVDQU32_YMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm256_mask_loadu_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQU32_MEMu32_MASKmskw_YMMu32_AVX512:
    	return "_mm256_mask_storeu_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQU32_XMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm_mask_loadu_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQU32_MEMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm_mask_storeu_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQU64_YMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm256_mask_loadu_epi64";
    case INTRINSIC_XED_IFORM_VMOVDQU64_MEMu64_MASKmskw_YMMu64_AVX512:
    	return "_mm256_mask_storeu_epi64";
    case INTRINSIC_XED_IFORM_VMOVDQU64_XMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm_mask_loadu_epi64";
    case INTRINSIC_XED_IFORM_VMOVDQU64_MEMu64_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_storeu_epi64";
    case INTRINSIC_XED_IFORM_VMOVSHDUP_YMMf32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_movehdup_ps";
    case INTRINSIC_XED_IFORM_VMOVSHDUP_XMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_movehdup_ps";
    case INTRINSIC_XED_IFORM_VMOVSLDUP_YMMf32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_moveldup_ps";
    case INTRINSIC_XED_IFORM_VMOVSLDUP_XMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_moveldup_ps";
    case INTRINSIC_XED_IFORM_VMOVUPD_YMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm256_mask_loadu_pd";
    case INTRINSIC_XED_IFORM_VMOVUPD_MEMf64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_mask_storeu_pd";
    case INTRINSIC_XED_IFORM_VMOVUPD_XMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm_mask_loadu_pd";
    case INTRINSIC_XED_IFORM_VMOVUPD_MEMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm_mask_storeu_pd";
    case INTRINSIC_XED_IFORM_VMOVUPS_YMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm256_mask_loadu_ps";
    case INTRINSIC_XED_IFORM_VMOVUPS_MEMf32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_storeu_ps";
    case INTRINSIC_XED_IFORM_VMOVUPS_XMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm_mask_loadu_ps";
    case INTRINSIC_XED_IFORM_VMOVUPS_MEMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_storeu_ps";
    case INTRINSIC_XED_IFORM_VMULPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_mul_pd";
    case INTRINSIC_XED_IFORM_VMULPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_mul_pd";
    case INTRINSIC_XED_IFORM_VMULPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_mul_ps";
    case INTRINSIC_XED_IFORM_VMULPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_mul_ps";
    case INTRINSIC_XED_IFORM_VPABSD_YMMi32_MASKmskw_YMMi32_AVX512:
    	return "_mm256_mask_abs_epi32";
    case INTRINSIC_XED_IFORM_VPABSD_XMMi32_MASKmskw_XMMi32_AVX512:
    	return "_mm_mask_abs_epi32";
    case INTRINSIC_XED_IFORM_VPABSQ_YMMi64_MASKmskw_YMMi64_AVX512:
    	return "_mm256_abs_epi64";
    case INTRINSIC_XED_IFORM_VPABSQ_XMMi64_MASKmskw_XMMi64_AVX512:
    	return "_mm_abs_epi64";
    case INTRINSIC_XED_IFORM_VPADDD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_add_epi32";
    case INTRINSIC_XED_IFORM_VPADDD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_add_epi32";
    case INTRINSIC_XED_IFORM_VPADDQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_add_epi64";
    case INTRINSIC_XED_IFORM_VPADDQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_add_epi64";
    case INTRINSIC_XED_IFORM_VPANDD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_and_epi32";
    case INTRINSIC_XED_IFORM_VPANDD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_and_epi32";
    case INTRINSIC_XED_IFORM_VPANDND_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_andnot_epi32";
    case INTRINSIC_XED_IFORM_VPANDND_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_andnot_epi32";
    case INTRINSIC_XED_IFORM_VPANDNQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_andnot_epi64";
    case INTRINSIC_XED_IFORM_VPANDNQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_andnot_epi64";
    case INTRINSIC_XED_IFORM_VPANDQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_and_epi64";
    case INTRINSIC_XED_IFORM_VPANDQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_and_epi64";
    case INTRINSIC_XED_IFORM_VPBLENDMD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_blend_epi32";
    case INTRINSIC_XED_IFORM_VPBLENDMD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_blend_epi32";
    case INTRINSIC_XED_IFORM_VPBLENDMQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_blend_epi64";
    case INTRINSIC_XED_IFORM_VPBLENDMQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_blend_epi64";
    case INTRINSIC_XED_IFORM_VPBROADCASTD_YMMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm256_mask_broadcastd_epi32";
    case INTRINSIC_XED_IFORM_VPBROADCASTD_YMMu32_MASKmskw_GPR32u32_AVX512:
    	return "_mm256_mask_set1_epi32";
    case INTRINSIC_XED_IFORM_VPBROADCASTD_XMMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm_mask_broadcastd_epi32";
    case INTRINSIC_XED_IFORM_VPBROADCASTD_XMMu32_MASKmskw_GPR32u32_AVX512:
    	return "_mm_mask_set1_epi32";
    case INTRINSIC_XED_IFORM_VPBROADCASTQ_YMMu64_MASKmskw_XMMu64_AVX512:
    	return "_mm256_mask_broadcastq_epi64";
    case INTRINSIC_XED_IFORM_VPBROADCASTQ_YMMu64_MASKmskw_GPR64u64_AVX512:
    	return "_mm256_mask_set1_epi64";
    case INTRINSIC_XED_IFORM_VPBROADCASTQ_XMMu64_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_broadcastq_epi64";
    case INTRINSIC_XED_IFORM_VPBROADCASTQ_XMMu64_MASKmskw_GPR64u64_AVX512:
    	return "_mm_mask_set1_epi64";
    case INTRINSIC_XED_IFORM_VPCMPD_MASKmskw_MASKmskw_YMMi32_YMMi32_IMM8_AVX512:
    	return "_mm256_cmp_epi32_mask";
    case INTRINSIC_XED_IFORM_VPCMPD_MASKmskw_MASKmskw_XMMi32_XMMi32_IMM8_AVX512:
    	return "_mm_cmp_epi32_mask";
    case INTRINSIC_XED_IFORM_VPCMPQ_MASKmskw_MASKmskw_YMMi64_YMMi64_IMM8_AVX512:
    	return "_mm256_cmp_epi64_mask";
    case INTRINSIC_XED_IFORM_VPCMPQ_MASKmskw_MASKmskw_XMMi64_XMMi64_IMM8_AVX512:
    	return "_mm_cmp_epi64_mask";
    case INTRINSIC_XED_IFORM_VPCMPUD_MASKmskw_MASKmskw_YMMu32_YMMu32_IMM8_AVX512:
    	return "_mm256_cmp_epu32_mask";
    case INTRINSIC_XED_IFORM_VPCMPUD_MASKmskw_MASKmskw_XMMu32_XMMu32_IMM8_AVX512:
    	return "_mm_cmp_epu32_mask";
    case INTRINSIC_XED_IFORM_VPCMPUQ_MASKmskw_MASKmskw_YMMu64_YMMu64_IMM8_AVX512:
    	return "_mm256_cmp_epu64_mask";
    case INTRINSIC_XED_IFORM_VPCMPUQ_MASKmskw_MASKmskw_XMMu64_XMMu64_IMM8_AVX512:
    	return "_mm_cmp_epu64_mask";
    case INTRINSIC_XED_IFORM_VPCOMPRESSD_YMMu32_MASKmskw_YMMu32_AVX512:
    	return "_mm256_mask_compress_epi32";
    case INTRINSIC_XED_IFORM_VPCOMPRESSD_MEMu32_MASKmskw_YMMu32_AVX512:
    	return "_mm256_mask_compressstoreu_epi32";
    case INTRINSIC_XED_IFORM_VPCOMPRESSD_XMMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm_mask_compress_epi32";
    case INTRINSIC_XED_IFORM_VPCOMPRESSD_MEMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm_mask_compressstoreu_epi32";
    case INTRINSIC_XED_IFORM_VPCOMPRESSQ_YMMu64_MASKmskw_YMMu64_AVX512:
    	return "_mm256_mask_compress_epi64";
    case INTRINSIC_XED_IFORM_VPCOMPRESSQ_MEMu64_MASKmskw_YMMu64_AVX512:
    	return "_mm256_mask_compressstoreu_epi64";
    case INTRINSIC_XED_IFORM_VPCOMPRESSQ_XMMu64_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_compress_epi64";
    case INTRINSIC_XED_IFORM_VPCOMPRESSQ_MEMu64_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_compressstoreu_epi64";
    case INTRINSIC_XED_IFORM_VPERMD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_permutexvar_epi32";
    case INTRINSIC_XED_IFORM_VPERMI2D_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask2_permutex2var_epi32";
    case INTRINSIC_XED_IFORM_VPERMT2D_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_permutex2var_epi32";
    case INTRINSIC_XED_IFORM_VPERMI2D_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask2_permutex2var_epi32";
    case INTRINSIC_XED_IFORM_VPERMT2D_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_permutex2var_epi32";
    case INTRINSIC_XED_IFORM_VPERMI2PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask2_permutex2var_pd";
    case INTRINSIC_XED_IFORM_VPERMT2PD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_permutex2var_pd";
    case INTRINSIC_XED_IFORM_VPERMI2PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask2_permutex2var_pd";
    case INTRINSIC_XED_IFORM_VPERMT2PD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_permutex2var_pd";
    case INTRINSIC_XED_IFORM_VPERMI2PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask2_permutex2var_ps";
    case INTRINSIC_XED_IFORM_VPERMT2PS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_permutex2var_ps";
    case INTRINSIC_XED_IFORM_VPERMI2PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask2_permutex2var_ps";
    case INTRINSIC_XED_IFORM_VPERMT2PS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_permutex2var_ps";
    case INTRINSIC_XED_IFORM_VPERMI2Q_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask2_permutex2var_epi64";
    case INTRINSIC_XED_IFORM_VPERMT2Q_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_permutex2var_epi64";
    case INTRINSIC_XED_IFORM_VPERMI2Q_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask2_permutex2var_epi64";
    case INTRINSIC_XED_IFORM_VPERMT2Q_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_permutex2var_epi64";
    case INTRINSIC_XED_IFORM_VPERMILPD_YMMf64_MASKmskw_YMMf64_IMM8_AVX512:
    	return "_mm256_mask_permute_pd";
    case INTRINSIC_XED_IFORM_VPERMILPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_permutevar_pd";
    case INTRINSIC_XED_IFORM_VPERMILPD_XMMf64_MASKmskw_XMMf64_IMM8_AVX512:
    	return "_mm_mask_permute_pd";
    case INTRINSIC_XED_IFORM_VPERMILPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_permutevar_pd";
    case INTRINSIC_XED_IFORM_VPERMILPS_YMMf32_MASKmskw_YMMf32_IMM8_AVX512:
    	return "_mm256_mask_permute_ps";
    case INTRINSIC_XED_IFORM_VPERMILPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_permutevar_ps";
    case INTRINSIC_XED_IFORM_VPERMILPS_XMMf32_MASKmskw_XMMf32_IMM8_AVX512:
    	return "_mm_mask_permute_ps";
    case INTRINSIC_XED_IFORM_VPERMILPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_permutevar_ps";
    case INTRINSIC_XED_IFORM_VPERMPD_YMMf64_MASKmskw_YMMf64_IMM8_AVX512:
    	return "_mm256_mask_permutex_pd";
    case INTRINSIC_XED_IFORM_VPERMPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_permutexvar_pd";
    case INTRINSIC_XED_IFORM_VPERMPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_permutexvar_ps";
    case INTRINSIC_XED_IFORM_VPERMQ_YMMu64_MASKmskw_YMMu64_IMM8_AVX512:
    	return "_mm256_mask_permutex_epi64";
    case INTRINSIC_XED_IFORM_VPERMQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_permutexvar_epi64";
    case INTRINSIC_XED_IFORM_VPEXPANDD_YMMu32_MASKmskw_YMMu32_AVX512:
    	return "_mm256_mask_expand_epi32";
    case INTRINSIC_XED_IFORM_VPEXPANDD_YMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm256_mask_expandloadu_epi32";
    case INTRINSIC_XED_IFORM_VPEXPANDD_XMMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm_mask_expand_epi32";
    case INTRINSIC_XED_IFORM_VPEXPANDD_XMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm_mask_expandloadu_epi32";
    case INTRINSIC_XED_IFORM_VPEXPANDQ_YMMu64_MASKmskw_YMMu64_AVX512:
    	return "_mm256_mask_expand_epi64";
    case INTRINSIC_XED_IFORM_VPEXPANDQ_YMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm256_mask_expandloadu_epi64";
    case INTRINSIC_XED_IFORM_VPEXPANDQ_XMMu64_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_expand_epi64";
    case INTRINSIC_XED_IFORM_VPEXPANDQ_XMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm_mask_expandloadu_epi64";
    case INTRINSIC_XED_IFORM_VPGATHERDD_YMMu32_MASKmskw_MEMu32_AVX512_VL256:
    	return "_mm256_mmask_i32gather_epi32";
    case INTRINSIC_XED_IFORM_VPGATHERDD_XMMu32_MASKmskw_MEMu32_AVX512_VL128:
    	return "_mm_mmask_i32gather_epi32";
    case INTRINSIC_XED_IFORM_VPGATHERDQ_YMMu64_MASKmskw_MEMu64_AVX512_VL256:
    	return "_mm256_mmask_i32gather_epi64";
    case INTRINSIC_XED_IFORM_VPGATHERDQ_XMMu64_MASKmskw_MEMu64_AVX512_VL128:
    	return "_mm_mmask_i32gather_epi64";
    case INTRINSIC_XED_IFORM_VPGATHERQD_XMMu32_MASKmskw_MEMu32_AVX512_VL128:
    	return "_mm256_mmask_i64gather_epi32";
    case INTRINSIC_XED_IFORM_VPGATHERQQ_YMMu64_MASKmskw_MEMu64_AVX512_VL256:
    	return "_mm256_mmask_i64gather_epi64";
    case INTRINSIC_XED_IFORM_VPGATHERQQ_XMMu64_MASKmskw_MEMu64_AVX512_VL128:
    	return "_mm_mmask_i64gather_epi64";
    case INTRINSIC_XED_IFORM_VPMAXSD_YMMi32_MASKmskw_YMMi32_YMMi32_AVX512:
    	return "_mm256_mask_max_epi32";
    case INTRINSIC_XED_IFORM_VPMAXSD_XMMi32_MASKmskw_XMMi32_XMMi32_AVX512:
    	return "_mm_mask_max_epi32";
    case INTRINSIC_XED_IFORM_VPMAXSQ_YMMi64_MASKmskw_YMMi64_YMMi64_AVX512:
    	return "_mm256_mask_max_epi64";
    case INTRINSIC_XED_IFORM_VPMAXSQ_XMMi64_MASKmskw_XMMi64_XMMi64_AVX512:
    	return "_mm_mask_max_epi64";
    case INTRINSIC_XED_IFORM_VPMAXUD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_max_epu32";
    case INTRINSIC_XED_IFORM_VPMAXUD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_max_epu32";
    case INTRINSIC_XED_IFORM_VPMAXUQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_max_epu64";
    case INTRINSIC_XED_IFORM_VPMAXUQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_max_epu64";
    case INTRINSIC_XED_IFORM_VPMINSD_YMMi32_MASKmskw_YMMi32_YMMi32_AVX512:
    	return "_mm256_mask_min_epi32";
    case INTRINSIC_XED_IFORM_VPMINSD_XMMi32_MASKmskw_XMMi32_XMMi32_AVX512:
    	return "_mm_mask_min_epi32";
    case INTRINSIC_XED_IFORM_VPMINSQ_YMMi64_MASKmskw_YMMi64_YMMi64_AVX512:
    	return "_mm256_mask_min_epi64";
    case INTRINSIC_XED_IFORM_VPMINSQ_XMMi64_MASKmskw_XMMi64_XMMi64_AVX512:
    	return "_mm_mask_min_epi64";
    case INTRINSIC_XED_IFORM_VPMINUD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_min_epu32";
    case INTRINSIC_XED_IFORM_VPMINUD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_min_epu32";
    case INTRINSIC_XED_IFORM_VPMINUQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_min_epu64";
    case INTRINSIC_XED_IFORM_VPMINUQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_min_epu64";
    case INTRINSIC_XED_IFORM_VPMOVDB_XMMu8_MASKmskw_YMMu32_AVX512:
    	return "_mm256_cvtepi32_epi8";
    case INTRINSIC_XED_IFORM_VPMOVDB_MEMu8_MASKmskw_YMMu32_AVX512:
    	return "_mm256_mask_cvtepi32_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVDB_XMMu8_MASKmskw_XMMu32_AVX512:
    	return "_mm_cvtepi32_epi8";
    case INTRINSIC_XED_IFORM_VPMOVDB_MEMu8_MASKmskw_XMMu32_AVX512:
    	return "_mm_mask_cvtepi32_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVDW_XMMu16_MASKmskw_YMMu32_AVX512:
    	return "_mm256_cvtepi32_epi16";
    case INTRINSIC_XED_IFORM_VPMOVDW_MEMu16_MASKmskw_YMMu32_AVX512:
    	return "_mm256_mask_cvtepi32_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVDW_XMMu16_MASKmskw_XMMu32_AVX512:
    	return "_mm_cvtepi32_epi16";
    case INTRINSIC_XED_IFORM_VPMOVDW_MEMu16_MASKmskw_XMMu32_AVX512:
    	return "_mm_mask_cvtepi32_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVQB_XMMu8_MASKmskw_YMMu64_AVX512:
    	return "_mm256_cvtepi64_epi8";
    case INTRINSIC_XED_IFORM_VPMOVQB_MEMu8_MASKmskw_YMMu64_AVX512:
    	return "_mm256_mask_cvtepi64_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVQB_XMMu8_MASKmskw_XMMu64_AVX512:
    	return "_mm_cvtepi64_epi8";
    case INTRINSIC_XED_IFORM_VPMOVQB_MEMu8_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_cvtepi64_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVQD_XMMu32_MASKmskw_YMMu64_AVX512:
    	return "_mm256_cvtepi64_epi32";
    case INTRINSIC_XED_IFORM_VPMOVQD_MEMu32_MASKmskw_YMMu64_AVX512:
    	return "_mm256_mask_cvtepi64_storeu_epi32";
    case INTRINSIC_XED_IFORM_VPMOVQD_XMMu32_MASKmskw_XMMu64_AVX512:
    	return "_mm_cvtepi64_epi32";
    case INTRINSIC_XED_IFORM_VPMOVQD_MEMu32_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_cvtepi64_storeu_epi32";
    case INTRINSIC_XED_IFORM_VPMOVQW_XMMu16_MASKmskw_YMMu64_AVX512:
    	return "_mm256_cvtepi64_epi16";
    case INTRINSIC_XED_IFORM_VPMOVQW_MEMu16_MASKmskw_YMMu64_AVX512:
    	return "_mm256_mask_cvtepi64_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVQW_XMMu16_MASKmskw_XMMu64_AVX512:
    	return "_mm_cvtepi64_epi16";
    case INTRINSIC_XED_IFORM_VPMOVQW_MEMu16_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_cvtepi64_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSDB_XMMi8_MASKmskw_YMMi32_AVX512:
    	return "_mm256_cvtsepi32_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSDB_MEMi8_MASKmskw_YMMi32_AVX512:
    	return "_mm256_mask_cvtsepi32_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSDB_XMMi8_MASKmskw_XMMi32_AVX512:
    	return "_mm_cvtsepi32_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSDB_MEMi8_MASKmskw_XMMi32_AVX512:
    	return "_mm_mask_cvtsepi32_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSDW_XMMi16_MASKmskw_YMMi32_AVX512:
    	return "_mm256_cvtsepi32_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSDW_MEMi16_MASKmskw_YMMi32_AVX512:
    	return "_mm256_mask_cvtsepi32_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSDW_XMMi16_MASKmskw_XMMi32_AVX512:
    	return "_mm_cvtsepi32_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSDW_MEMi16_MASKmskw_XMMi32_AVX512:
    	return "_mm_mask_cvtsepi32_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSQB_XMMi8_MASKmskw_YMMi64_AVX512:
    	return "_mm256_cvtsepi64_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSQB_MEMi8_MASKmskw_YMMi64_AVX512:
    	return "_mm256_mask_cvtsepi64_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSQB_XMMi8_MASKmskw_XMMi64_AVX512:
    	return "_mm_cvtsepi64_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSQB_MEMi8_MASKmskw_XMMi64_AVX512:
    	return "_mm_mask_cvtsepi64_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSQD_XMMi32_MASKmskw_YMMi64_AVX512:
    	return "_mm256_cvtsepi64_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSQD_MEMi32_MASKmskw_YMMi64_AVX512:
    	return "_mm256_mask_cvtsepi64_storeu_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSQD_XMMi32_MASKmskw_XMMi64_AVX512:
    	return "_mm_cvtsepi64_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSQD_MEMi32_MASKmskw_XMMi64_AVX512:
    	return "_mm_mask_cvtsepi64_storeu_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSQW_XMMi16_MASKmskw_YMMi64_AVX512:
    	return "_mm256_cvtsepi64_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSQW_MEMi16_MASKmskw_YMMi64_AVX512:
    	return "_mm256_mask_cvtsepi64_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSQW_XMMi16_MASKmskw_XMMi64_AVX512:
    	return "_mm_cvtsepi64_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSQW_MEMi16_MASKmskw_XMMi64_AVX512:
    	return "_mm_mask_cvtsepi64_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSXBD_YMMi32_MASKmskw_XMMi8_AVX512:
    	return "_mm256_mask_cvtepi8_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSXBD_XMMi32_MASKmskw_XMMi8_AVX512:
    	return "_mm_mask_cvtepi8_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSXBQ_YMMi64_MASKmskw_XMMi8_AVX512:
    	return "_mm256_mask_cvtepi8_epi64";
    case INTRINSIC_XED_IFORM_VPMOVSXBQ_XMMi64_MASKmskw_XMMi8_AVX512:
    	return "_mm_mask_cvtepi8_epi64";
    case INTRINSIC_XED_IFORM_VPMOVSXDQ_YMMi64_MASKmskw_XMMi32_AVX512:
    	return "_mm256_mask_cvtepi32_epi64";
    case INTRINSIC_XED_IFORM_VPMOVSXDQ_XMMi64_MASKmskw_XMMi32_AVX512:
    	return "_mm_mask_cvtepi32_epi64";
    case INTRINSIC_XED_IFORM_VPMOVSXWD_YMMi32_MASKmskw_XMMi16_AVX512:
    	return "_mm256_mask_cvtepi16_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSXWD_XMMi32_MASKmskw_XMMi16_AVX512:
    	return "_mm_mask_cvtepi16_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSXWQ_YMMi64_MASKmskw_XMMi16_AVX512:
    	return "_mm256_mask_cvtepi16_epi64";
    case INTRINSIC_XED_IFORM_VPMOVSXWQ_XMMi64_MASKmskw_XMMi16_AVX512:
    	return "_mm_mask_cvtepi16_epi64";
    case INTRINSIC_XED_IFORM_VPMOVUSDB_XMMu8_MASKmskw_YMMu32_AVX512:
    	return "_mm256_cvtusepi32_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSDB_MEMu8_MASKmskw_YMMu32_AVX512:
    	return "_mm256_mask_cvtusepi32_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSDB_XMMu8_MASKmskw_XMMu32_AVX512:
    	return "_mm_cvtusepi32_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSDB_MEMu8_MASKmskw_XMMu32_AVX512:
    	return "_mm_mask_cvtusepi32_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSDW_XMMu16_MASKmskw_YMMu32_AVX512:
    	return "_mm256_cvtusepi32_epi16";
    case INTRINSIC_XED_IFORM_VPMOVUSDW_MEMu16_MASKmskw_YMMu32_AVX512:
    	return "_mm256_mask_cvtusepi32_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVUSDW_XMMu16_MASKmskw_XMMu32_AVX512:
    	return "_mm_cvtusepi32_epi16";
    case INTRINSIC_XED_IFORM_VPMOVUSDW_MEMu16_MASKmskw_XMMu32_AVX512:
    	return "_mm_mask_cvtusepi32_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVUSQB_XMMu8_MASKmskw_YMMu64_AVX512:
    	return "_mm256_cvtusepi64_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSQB_MEMu8_MASKmskw_YMMu64_AVX512:
    	return "_mm256_mask_cvtusepi64_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSQB_XMMu8_MASKmskw_XMMu64_AVX512:
    	return "_mm_cvtusepi64_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSQB_MEMu8_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_cvtusepi64_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSQD_XMMu32_MASKmskw_YMMu64_AVX512:
    	return "_mm256_cvtusepi64_epi32";
    case INTRINSIC_XED_IFORM_VPMOVUSQD_MEMu32_MASKmskw_YMMu64_AVX512:
    	return "_mm256_mask_cvtusepi64_storeu_epi32";
    case INTRINSIC_XED_IFORM_VPMOVUSQD_XMMu32_MASKmskw_XMMu64_AVX512:
    	return "_mm_cvtusepi64_epi32";
    case INTRINSIC_XED_IFORM_VPMOVUSQD_MEMu32_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_cvtusepi64_storeu_epi32";
    case INTRINSIC_XED_IFORM_VPMOVUSQW_XMMu16_MASKmskw_YMMu64_AVX512:
    	return "_mm256_cvtusepi64_epi16";
    case INTRINSIC_XED_IFORM_VPMOVUSQW_MEMu16_MASKmskw_YMMu64_AVX512:
    	return "_mm256_mask_cvtusepi64_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVUSQW_XMMu16_MASKmskw_XMMu64_AVX512:
    	return "_mm_cvtusepi64_epi16";
    case INTRINSIC_XED_IFORM_VPMOVUSQW_MEMu16_MASKmskw_XMMu64_AVX512:
    	return "_mm_mask_cvtusepi64_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVZXBD_YMMi32_MASKmskw_XMMi8_AVX512:
    	return "_mm256_mask_cvtepu8_epi32";
    case INTRINSIC_XED_IFORM_VPMOVZXBD_XMMi32_MASKmskw_XMMi8_AVX512:
    	return "_mm_mask_cvtepu8_epi32";
    case INTRINSIC_XED_IFORM_VPMOVZXBQ_YMMi64_MASKmskw_XMMi8_AVX512:
    	return "_mm256_mask_cvtepu8_epi64";
    case INTRINSIC_XED_IFORM_VPMOVZXBQ_XMMi64_MASKmskw_XMMi8_AVX512:
    	return "_mm_mask_cvtepu8_epi64";
    case INTRINSIC_XED_IFORM_VPMOVZXDQ_YMMi64_MASKmskw_XMMi32_AVX512:
    	return "_mm256_mask_cvtepu32_epi64";
    case INTRINSIC_XED_IFORM_VPMOVZXDQ_XMMi64_MASKmskw_XMMi32_AVX512:
    	return "_mm_mask_cvtepu32_epi64";
    case INTRINSIC_XED_IFORM_VPMOVZXWD_YMMi32_MASKmskw_XMMi16_AVX512:
    	return "_mm256_mask_cvtepu16_epi32";
    case INTRINSIC_XED_IFORM_VPMOVZXWD_XMMi32_MASKmskw_XMMi16_AVX512:
    	return "_mm_mask_cvtepu16_epi32";
    case INTRINSIC_XED_IFORM_VPMOVZXWQ_YMMi64_MASKmskw_XMMi16_AVX512:
    	return "_mm256_mask_cvtepu16_epi64";
    case INTRINSIC_XED_IFORM_VPMOVZXWQ_XMMi64_MASKmskw_XMMi16_AVX512:
    	return "_mm_mask_cvtepu16_epi64";
    case INTRINSIC_XED_IFORM_VPMULDQ_YMMi64_MASKmskw_YMMi32_YMMi32_AVX512:
    	return "_mm256_mask_mul_epi32";
    case INTRINSIC_XED_IFORM_VPMULDQ_XMMi64_MASKmskw_XMMi32_XMMi32_AVX512:
    	return "_mm_mask_mul_epi32";
    case INTRINSIC_XED_IFORM_VPMULLD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_mullo_epi32";
    case INTRINSIC_XED_IFORM_VPMULLD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_mullo_epi32";
    case INTRINSIC_XED_IFORM_VPMULLD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_mullo_epi32";
    case INTRINSIC_XED_IFORM_VPMULUDQ_YMMu64_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_mul_epu32";
    case INTRINSIC_XED_IFORM_VPMULUDQ_XMMu64_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_mul_epu32";
    case INTRINSIC_XED_IFORM_VPORD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_or_epi32";
    case INTRINSIC_XED_IFORM_VPORD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_or_epi32";
    case INTRINSIC_XED_IFORM_VPORQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_or_epi64";
    case INTRINSIC_XED_IFORM_VPORQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_or_epi64";
    case INTRINSIC_XED_IFORM_VPROLD_YMMu32_MASKmskw_YMMu32_IMM8_AVX512:
    	return "_mm256_mask_rol_epi32";
    case INTRINSIC_XED_IFORM_VPROLD_XMMu32_MASKmskw_XMMu32_IMM8_AVX512:
    	return "_mm_mask_rol_epi32";
    case INTRINSIC_XED_IFORM_VPROLQ_YMMu64_MASKmskw_YMMu64_IMM8_AVX512:
    	return "_mm256_mask_rol_epi64";
    case INTRINSIC_XED_IFORM_VPROLQ_XMMu64_MASKmskw_XMMu64_IMM8_AVX512:
    	return "_mm_mask_rol_epi64";
    case INTRINSIC_XED_IFORM_VPROLVD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_rolv_epi32";
    case INTRINSIC_XED_IFORM_VPROLVD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_rolv_epi32";
    case INTRINSIC_XED_IFORM_VPROLVQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_rolv_epi64";
    case INTRINSIC_XED_IFORM_VPROLVQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_rolv_epi64";
    case INTRINSIC_XED_IFORM_VPRORD_YMMu32_MASKmskw_YMMu32_IMM8_AVX512:
    	return "_mm256_mask_ror_epi32";
    case INTRINSIC_XED_IFORM_VPRORD_XMMu32_MASKmskw_XMMu32_IMM8_AVX512:
    	return "_mm_mask_ror_epi32";
    case INTRINSIC_XED_IFORM_VPRORQ_YMMu64_MASKmskw_YMMu64_IMM8_AVX512:
    	return "_mm256_mask_ror_epi64";
    case INTRINSIC_XED_IFORM_VPRORQ_XMMu64_MASKmskw_XMMu64_IMM8_AVX512:
    	return "_mm_mask_ror_epi64";
    case INTRINSIC_XED_IFORM_VPRORVD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_rorv_epi32";
    case INTRINSIC_XED_IFORM_VPRORVD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_rorv_epi32";
    case INTRINSIC_XED_IFORM_VPRORVQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_rorv_epi64";
    case INTRINSIC_XED_IFORM_VPRORVQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_rorv_epi64";
    case INTRINSIC_XED_IFORM_VPSCATTERDD_MEMu32_MASKmskw_YMMu32_AVX512_VL256:
    	return "_mm256_i32scatter_epi32";
    case INTRINSIC_XED_IFORM_VPSCATTERDD_MEMu32_MASKmskw_XMMu32_AVX512_VL128:
    	return "_mm_i32scatter_epi32";
    case INTRINSIC_XED_IFORM_VPSCATTERDQ_MEMu64_MASKmskw_YMMu64_AVX512_VL256:
    	return "_mm256_i32scatter_epi64";
    case INTRINSIC_XED_IFORM_VPSCATTERDQ_MEMu64_MASKmskw_XMMu64_AVX512_VL128:
    	return "_mm_i32scatter_epi64";
    case INTRINSIC_XED_IFORM_VPSCATTERQD_MEMu32_MASKmskw_XMMu32_AVX512_VL128:
    	return "_mm256_i64scatter_epi32";
    case INTRINSIC_XED_IFORM_VPSCATTERQQ_MEMu64_MASKmskw_YMMu64_AVX512_VL256:
    	return "_mm256_i64scatter_epi64";
    case INTRINSIC_XED_IFORM_VPSCATTERQQ_MEMu64_MASKmskw_XMMu64_AVX512_VL128:
    	return "_mm_i64scatter_epi64";
    case INTRINSIC_XED_IFORM_VPSHUFD_YMMu32_MASKmskw_YMMu32_IMM8_AVX512:
    	return "_mm256_mask_shuffle_epi32";
    case INTRINSIC_XED_IFORM_VPSHUFD_XMMu32_MASKmskw_XMMu32_IMM8_AVX512:
    	return "_mm_mask_shuffle_epi32";
    case INTRINSIC_XED_IFORM_VPSLLD_YMMu32_MASKmskw_YMMu32_XMMu32_AVX512:
    	return "_mm256_mask_sll_epi32";
    case INTRINSIC_XED_IFORM_VPSLLD_YMMu32_MASKmskw_YMMu32_IMM8_AVX512:
    	return "_mm256_mask_slli_epi32";
    case INTRINSIC_XED_IFORM_VPSLLD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_sll_epi32";
    case INTRINSIC_XED_IFORM_VPSLLD_XMMu32_MASKmskw_XMMu32_IMM8_AVX512:
    	return "_mm_mask_slli_epi32";
    case INTRINSIC_XED_IFORM_VPSLLQ_YMMu64_MASKmskw_YMMu64_XMMu64_AVX512:
    	return "_mm256_mask_sll_epi64";
    case INTRINSIC_XED_IFORM_VPSLLQ_YMMu64_MASKmskw_YMMu64_IMM8_AVX512:
    	return "_mm256_mask_slli_epi64";
    case INTRINSIC_XED_IFORM_VPSLLQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_sll_epi64";
    case INTRINSIC_XED_IFORM_VPSLLQ_XMMu64_MASKmskw_XMMu64_IMM8_AVX512:
    	return "_mm_mask_slli_epi64";
    case INTRINSIC_XED_IFORM_VPSLLVD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_sllv_epi32";
    case INTRINSIC_XED_IFORM_VPSLLVD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_sllv_epi32";
    case INTRINSIC_XED_IFORM_VPSLLVQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_sllv_epi64";
    case INTRINSIC_XED_IFORM_VPSLLVQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_sllv_epi64";
    case INTRINSIC_XED_IFORM_VPSRAD_YMMu32_MASKmskw_YMMu32_XMMu32_AVX512:
    	return "_mm256_mask_sra_epi32";
    case INTRINSIC_XED_IFORM_VPSRAD_YMMu32_MASKmskw_YMMu32_IMM8_AVX512:
    	return "_mm256_mask_srai_epi32";
    case INTRINSIC_XED_IFORM_VPSRAD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_sra_epi32";
    case INTRINSIC_XED_IFORM_VPSRAD_XMMu32_MASKmskw_XMMu32_IMM8_AVX512:
    	return "_mm_mask_srai_epi32";
    case INTRINSIC_XED_IFORM_VPSRAQ_YMMu64_MASKmskw_YMMu64_XMMu64_AVX512:
    	return "_mm256_mask_sra_epi64";
    case INTRINSIC_XED_IFORM_VPSRAQ_YMMu64_MASKmskw_YMMu64_IMM8_AVX512:
    	return "_mm256_mask_srai_epi64";
    case INTRINSIC_XED_IFORM_VPSRAQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_sra_epi64";
    case INTRINSIC_XED_IFORM_VPSRAQ_XMMu64_MASKmskw_XMMu64_IMM8_AVX512:
    	return "_mm_mask_srai_epi64";
    case INTRINSIC_XED_IFORM_VPSRAVD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_srav_epi32";
    case INTRINSIC_XED_IFORM_VPSRAVD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_srav_epi32";
    case INTRINSIC_XED_IFORM_VPSRAVQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_srav_epi64";
    case INTRINSIC_XED_IFORM_VPSRAVQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_srav_epi64";
    case INTRINSIC_XED_IFORM_VPSRLD_YMMu32_MASKmskw_YMMu32_XMMu32_AVX512:
    	return "_mm256_mask_srl_epi32";
    case INTRINSIC_XED_IFORM_VPSRLD_YMMu32_MASKmskw_YMMu32_IMM8_AVX512:
    	return "_mm256_mask_srli_epi32";
    case INTRINSIC_XED_IFORM_VPSRLD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_srl_epi32";
    case INTRINSIC_XED_IFORM_VPSRLD_XMMu32_MASKmskw_XMMu32_IMM8_AVX512:
    	return "_mm_mask_srli_epi32";
    case INTRINSIC_XED_IFORM_VPSRLQ_YMMu64_MASKmskw_YMMu64_XMMu64_AVX512:
    	return "_mm256_mask_srl_epi64";
    case INTRINSIC_XED_IFORM_VPSRLQ_YMMu64_MASKmskw_YMMu64_IMM8_AVX512:
    	return "_mm256_mask_srli_epi64";
    case INTRINSIC_XED_IFORM_VPSRLQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_srl_epi64";
    case INTRINSIC_XED_IFORM_VPSRLQ_XMMu64_MASKmskw_XMMu64_IMM8_AVX512:
    	return "_mm_mask_srli_epi64";
    case INTRINSIC_XED_IFORM_VPSRLVD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_srlv_epi32";
    case INTRINSIC_XED_IFORM_VPSRLVD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_srlv_epi32";
    case INTRINSIC_XED_IFORM_VPSRLVQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_srlv_epi64";
    case INTRINSIC_XED_IFORM_VPSRLVQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_srlv_epi64";
    case INTRINSIC_XED_IFORM_VPSUBD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_sub_epi32";
    case INTRINSIC_XED_IFORM_VPSUBD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_sub_epi32";
    case INTRINSIC_XED_IFORM_VPSUBQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_sub_epi64";
    case INTRINSIC_XED_IFORM_VPSUBQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_sub_epi64";
    case INTRINSIC_XED_IFORM_VPTERNLOGD_YMMu32_MASKmskw_YMMu32_YMMu32_IMM8_AVX512:
    	return "_mm256_mask_ternarylogic_epi32";
    case INTRINSIC_XED_IFORM_VPTERNLOGD_XMMu32_MASKmskw_XMMu32_XMMu32_IMM8_AVX512:
    	return "_mm_mask_ternarylogic_epi32";
    case INTRINSIC_XED_IFORM_VPTERNLOGQ_YMMu64_MASKmskw_YMMu64_YMMu64_IMM8_AVX512:
    	return "_mm256_mask_ternarylogic_epi64";
    case INTRINSIC_XED_IFORM_VPTERNLOGQ_XMMu64_MASKmskw_XMMu64_XMMu64_IMM8_AVX512:
    	return "_mm_mask_ternarylogic_epi64";
    case INTRINSIC_XED_IFORM_VPTESTMD_MASKmskw_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_test_epi32_mask";
    case INTRINSIC_XED_IFORM_VPTESTMD_MASKmskw_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_test_epi32_mask";
    case INTRINSIC_XED_IFORM_VPTESTMQ_MASKmskw_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_test_epi64_mask";
    case INTRINSIC_XED_IFORM_VPTESTMQ_MASKmskw_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_test_epi64_mask";
    case INTRINSIC_XED_IFORM_VPTESTNMD_MASKmskw_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_testn_epi32_mask";
    case INTRINSIC_XED_IFORM_VPTESTNMD_MASKmskw_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_testn_epi32_mask";
    case INTRINSIC_XED_IFORM_VPTESTNMQ_MASKmskw_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_testn_epi64_mask";
    case INTRINSIC_XED_IFORM_VPTESTNMQ_MASKmskw_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_testn_epi64_mask";
    case INTRINSIC_XED_IFORM_VPUNPCKHDQ_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_unpackhi_epi32";
    case INTRINSIC_XED_IFORM_VPUNPCKHDQ_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_unpackhi_epi32";
    case INTRINSIC_XED_IFORM_VPUNPCKHQDQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_unpackhi_epi64";
    case INTRINSIC_XED_IFORM_VPUNPCKHQDQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_unpackhi_epi64";
    case INTRINSIC_XED_IFORM_VPUNPCKLDQ_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_unpacklo_epi32";
    case INTRINSIC_XED_IFORM_VPUNPCKLDQ_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_unpacklo_epi32";
    case INTRINSIC_XED_IFORM_VPUNPCKLQDQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_unpacklo_epi64";
    case INTRINSIC_XED_IFORM_VPUNPCKLQDQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_unpacklo_epi64";
    case INTRINSIC_XED_IFORM_VPXORD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_mask_xor_epi32";
    case INTRINSIC_XED_IFORM_VPXORD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_mask_xor_epi32";
    case INTRINSIC_XED_IFORM_VPXORQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_mask_xor_epi64";
    case INTRINSIC_XED_IFORM_VPXORQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_mask_xor_epi64";
    case INTRINSIC_XED_IFORM_VRCP14PD_YMMf64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_mask_rcp14_pd";
    case INTRINSIC_XED_IFORM_VRCP14PD_XMMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm_mask_rcp14_pd";
    case INTRINSIC_XED_IFORM_VRCP14PS_YMMf32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_rcp14_ps";
    case INTRINSIC_XED_IFORM_VRCP14PS_XMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_rcp14_ps";
    case INTRINSIC_XED_IFORM_VRNDSCALEPD_YMMf64_MASKmskw_YMMf64_IMM8_AVX512:
    	return "_mm256_mask_roundscale_pd";
    case INTRINSIC_XED_IFORM_VRNDSCALEPD_XMMf64_MASKmskw_XMMf64_IMM8_AVX512:
    	return "_mm_mask_roundscale_pd";
    case INTRINSIC_XED_IFORM_VRNDSCALEPS_YMMf32_MASKmskw_YMMf32_IMM8_AVX512:
    	return "_mm256_mask_roundscale_ps";
    case INTRINSIC_XED_IFORM_VRNDSCALEPS_XMMf32_MASKmskw_XMMf32_IMM8_AVX512:
    	return "_mm_mask_roundscale_ps";
    case INTRINSIC_XED_IFORM_VRSQRT14PD_YMMf64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_mask_rsqrt14_pd";
    case INTRINSIC_XED_IFORM_VRSQRT14PD_XMMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm_mask_rsqrt14_pd";
    case INTRINSIC_XED_IFORM_VRSQRT14PS_YMMf32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_rsqrt14_ps";
    case INTRINSIC_XED_IFORM_VRSQRT14PS_XMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_rsqrt14_ps";
    case INTRINSIC_XED_IFORM_VSCALEFPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_scalef_pd";
    case INTRINSIC_XED_IFORM_VSCALEFPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_scalef_pd";
    case INTRINSIC_XED_IFORM_VSCALEFPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_scalef_ps";
    case INTRINSIC_XED_IFORM_VSCALEFPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_scalef_ps";
    case INTRINSIC_XED_IFORM_VSCATTERDPD_MEMf64_MASKmskw_YMMf64_AVX512_VL256:
    	return "_mm256_i32scatter_pd";
    case INTRINSIC_XED_IFORM_VSCATTERDPD_MEMf64_MASKmskw_XMMf64_AVX512_VL128:
    	return "_mm_i32scatter_pd";
    case INTRINSIC_XED_IFORM_VSCATTERDPS_MEMf32_MASKmskw_YMMf32_AVX512_VL256:
    	return "_mm256_i32scatter_ps";
    case INTRINSIC_XED_IFORM_VSCATTERDPS_MEMf32_MASKmskw_XMMf32_AVX512_VL128:
    	return "_mm_i32scatter_ps";
    case INTRINSIC_XED_IFORM_VSCATTERQPD_MEMf64_MASKmskw_YMMf64_AVX512_VL256:
    	return "_mm256_i64scatter_pd";
    case INTRINSIC_XED_IFORM_VSCATTERQPD_MEMf64_MASKmskw_XMMf64_AVX512_VL128:
    	return "_mm_i64scatter_pd";
    case INTRINSIC_XED_IFORM_VSCATTERQPS_MEMf32_MASKmskw_XMMf32_AVX512_VL128:
    	return "_mm256_i64scatter_ps";
    case INTRINSIC_XED_IFORM_VSHUFF32X4_YMMf32_MASKmskw_YMMf32_YMMf32_IMM8_AVX512:
    	return "_mm256_mask_shuffle_f32x4";
    case INTRINSIC_XED_IFORM_VSHUFF64X2_YMMf64_MASKmskw_YMMf64_YMMf64_IMM8_AVX512:
    	return "_mm256_mask_shuffle_f64x2";
    case INTRINSIC_XED_IFORM_VSHUFI32X4_YMMu32_MASKmskw_YMMu32_YMMu32_IMM8_AVX512:
    	return "_mm256_mask_shuffle_i32x4";
    case INTRINSIC_XED_IFORM_VSHUFI64X2_YMMu64_MASKmskw_YMMu64_YMMu64_IMM8_AVX512:
    	return "_mm256_mask_shuffle_i64x2";
    case INTRINSIC_XED_IFORM_VSHUFPD_YMMf64_MASKmskw_YMMf64_YMMf64_IMM8_AVX512:
    	return "_mm256_mask_shuffle_pd";
    case INTRINSIC_XED_IFORM_VSHUFPD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512:
    	return "_mm_mask_shuffle_pd";
    case INTRINSIC_XED_IFORM_VSHUFPS_YMMf32_MASKmskw_YMMf32_YMMf32_IMM8_AVX512:
    	return "_mm256_mask_shuffle_ps";
    case INTRINSIC_XED_IFORM_VSHUFPS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512:
    	return "_mm_mask_shuffle_ps";
    case INTRINSIC_XED_IFORM_VSQRTPD_YMMf64_MASKmskw_YMMf64_AVX512:
    	return "_mm256_mask_sqrt_pd";
    case INTRINSIC_XED_IFORM_VSQRTPD_XMMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm_mask_sqrt_pd";
    case INTRINSIC_XED_IFORM_VSQRTPS_YMMf32_MASKmskw_YMMf32_AVX512:
    	return "_mm256_mask_sqrt_ps";
    case INTRINSIC_XED_IFORM_VSQRTPS_XMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_sqrt_ps";
    case INTRINSIC_XED_IFORM_VSUBPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_sub_pd";
    case INTRINSIC_XED_IFORM_VSUBPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_sub_pd";
    case INTRINSIC_XED_IFORM_VSUBPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_sub_ps";
    case INTRINSIC_XED_IFORM_VSUBPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_sub_ps";
    case INTRINSIC_XED_IFORM_VUNPCKHPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_unpackhi_pd";
    case INTRINSIC_XED_IFORM_VUNPCKHPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_unpackhi_pd";
    case INTRINSIC_XED_IFORM_VUNPCKHPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_unpackhi_ps";
    case INTRINSIC_XED_IFORM_VUNPCKHPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_unpackhi_ps";
    case INTRINSIC_XED_IFORM_VUNPCKLPD_YMMf64_MASKmskw_YMMf64_YMMf64_AVX512:
    	return "_mm256_mask_unpacklo_pd";
    case INTRINSIC_XED_IFORM_VUNPCKLPD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_unpacklo_pd";
    case INTRINSIC_XED_IFORM_VUNPCKLPS_YMMf32_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_mask_unpacklo_ps";
    case INTRINSIC_XED_IFORM_VUNPCKLPS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_unpacklo_ps";
    case INTRINSIC_XED_IFORM_VMOVDQU64_MEMu64_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_storeu_epi64";
    case INTRINSIC_XED_IFORM_VMOVDQU32_MEMu32_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_storeu_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQU64_ZMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm512_loadu_epi64";
    case INTRINSIC_XED_IFORM_VMOVDQU32_ZMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm512_loadu_epi32";
    case INTRINSIC_XED_IFORM_VAESENCLAST_ZMMu128_ZMMu128_ZMMu128_AVX512:
    	return "_mm512_aesenclast_epi128";
    case INTRINSIC_XED_IFORM_VAESENC_ZMMu128_ZMMu128_ZMMu128_AVX512:
    	return "_mm512_aesenc_epi128";
    case INTRINSIC_XED_IFORM_VAESDECLAST_ZMMu128_ZMMu128_ZMMu128_AVX512:
    	return "_mm512_aesdeclast_epi128";
    case INTRINSIC_XED_IFORM_VAESDEC_ZMMu128_ZMMu128_ZMMu128_AVX512:
    	return "_mm512_aesdec_epi128";
    case INTRINSIC_XED_IFORM_KANDW_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kand_mask16";
    case INTRINSIC_XED_IFORM_KANDNW_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kandn_mask16";
    case INTRINSIC_XED_IFORM_KNOTW_MASKmskw_MASKmskw_AVX512:
    	return "_knot_mask16";
    case INTRINSIC_XED_IFORM_KORW_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kor_mask16";
    case INTRINSIC_XED_IFORM_KXNORW_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kxnor_mask16";
    case INTRINSIC_XED_IFORM_KXORW_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_kxor_mask16";
    case INTRINSIC_XED_IFORM_KSHIFTLW_MASKmskw_MASKmskw_IMM8_AVX512:
    	return "_kshiftli_mask16";
    case INTRINSIC_XED_IFORM_KSHIFTRW_MASKmskw_MASKmskw_IMM8_AVX512:
    	return "_kshiftri_mask16";
    case INTRINSIC_XED_IFORM_KMOVW_MASKmskw_MEMu16_AVX512:
    	return "_load_mask16";
    case INTRINSIC_XED_IFORM_KMOVW_MEMu16_MASKmskw_AVX512:
    	return "_store_mask16";
    case INTRINSIC_XED_IFORM_KORTESTW_MASKmskw_MASKmskw_AVX512:
    	return "_kortest_mask16_u8";
    case INTRINSIC_XED_IFORM_KMOVW_GPR32u32_MASKmskw_AVX512:
    	return "_cvtmask16_u32";
    case INTRINSIC_XED_IFORM_KMOVW_MASKmskw_GPR32u32_AVX512:
    	return "_cvtu32_mask16";
    case INTRINSIC_XED_IFORM_KMOVW_MASKmskw_MASKu16_AVX512:
    	return "_mm512_kmov";
    case INTRINSIC_XED_IFORM_KUNPCKBW_MASKmskw_MASKmskw_MASKmskw_AVX512:
    	return "_mm512_kunpackb";
    case INTRINSIC_XED_IFORM_VADDPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_add_pd";
    case INTRINSIC_XED_IFORM_VADDPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_add_ps";
    case INTRINSIC_XED_IFORM_VADDSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_add_round_sd";
    case INTRINSIC_XED_IFORM_VADDSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_add_round_ss";
    case INTRINSIC_XED_IFORM_VALIGND_ZMMu32_MASKmskw_ZMMu32_ZMMu32_IMM8_AVX512:
    	return "_mm512_maskz_alignr_epi32";
    case INTRINSIC_XED_IFORM_VALIGNQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_IMM8_AVX512:
    	return "_mm512_alignr_epi64";
    case INTRINSIC_XED_IFORM_VBROADCASTF32X4_ZMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm512_broadcast_f32x4";
    case INTRINSIC_XED_IFORM_VBROADCASTF64X4_ZMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm512_broadcast_f64x4";
    case INTRINSIC_XED_IFORM_VBROADCASTI32X4_ZMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm512_broadcast_i32x4";
    case INTRINSIC_XED_IFORM_VBROADCASTI64X4_ZMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm512_broadcast_i64x4";
    case INTRINSIC_XED_IFORM_VBROADCASTSD_ZMMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm512_broadcastsd_pd";
    case INTRINSIC_XED_IFORM_VBROADCASTSS_ZMMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm512_broadcastss_ps";
    case INTRINSIC_XED_IFORM_VCMPSD_MASKmskw_MASKmskw_XMMf64_XMMf64_IMM8_AVX512:
    	return "_mm_cmp_round_sd_mask";
    case INTRINSIC_XED_IFORM_VCMPSS_MASKmskw_MASKmskw_XMMf32_XMMf32_IMM8_AVX512:
    	return "_mm_cmp_round_ss_mask";
    case INTRINSIC_XED_IFORM_VCOMISD_XMMf64_XMMf64_AVX512:
    	return "_mm_comi_round_sd";
    case INTRINSIC_XED_IFORM_VCOMISS_XMMf32_XMMf32_AVX512:
    	return "_mm_comi_round_ss";
    case INTRINSIC_XED_IFORM_VUCOMISS_XMMf32_XMMf32_AVX512:
    	return "_mm_comi_round_ss";
    case INTRINSIC_XED_IFORM_VCOMPRESSPD_ZMMf64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_mask_compress_pd";
    case INTRINSIC_XED_IFORM_VCOMPRESSPD_MEMf64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_mask_compressstoreu_pd";
    case INTRINSIC_XED_IFORM_VCOMPRESSPS_ZMMf32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_mask_compress_ps";
    case INTRINSIC_XED_IFORM_VCOMPRESSPS_MEMf32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_mask_compressstoreu_ps";
    case INTRINSIC_XED_IFORM_VCVTDQ2PD_ZMMf64_MASKmskw_YMMi32_AVX512:
    	return "_mm512_cvtepi32_pd";
    case INTRINSIC_XED_IFORM_VCVTDQ2PS_ZMMf32_MASKmskw_ZMMi32_AVX512:
    	return "_mm512_cvt_roundepi32_ps";
    case INTRINSIC_XED_IFORM_VCVTPD2DQ_YMMi32_MASKmskw_ZMMf64_AVX512_VL512:
    	return "_mm512_cvt_roundpd_epi32";
    case INTRINSIC_XED_IFORM_VCVTPD2PS_YMMf32_MASKmskw_ZMMf64_AVX512_VL512:
    	return "_mm512_cvt_roundpd_ps";
    case INTRINSIC_XED_IFORM_VCVTPD2UDQ_YMMu32_MASKmskw_ZMMf64_AVX512_VL512:
    	return "_mm512_cvt_roundpd_epu32";
    case INTRINSIC_XED_IFORM_VCVTPH2PS_ZMMf32_MASKmskw_YMMf16_AVX512:
    	return "_mm512_cvt_roundph_ps";
    case INTRINSIC_XED_IFORM_VCVTPS2DQ_ZMMi32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_cvt_roundps_epi32";
    case INTRINSIC_XED_IFORM_VCVTPS2PD_ZMMf64_MASKmskw_YMMf32_AVX512:
    	return "_mm512_cvt_roundps_pd";
    case INTRINSIC_XED_IFORM_VCVTPS2PH_YMMf16_MASKmskw_ZMMf32_IMM8_AVX512:
    	return "_mm512_cvt_roundps_ph";
    case INTRINSIC_XED_IFORM_VCVTPS2UDQ_ZMMu32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_cvt_roundps_epu32";
    case INTRINSIC_XED_IFORM_VCVTSD2SI_GPR32i32_XMMf64_AVX512:
    	return "_mm_cvt_roundsd_i32";
    case INTRINSIC_XED_IFORM_VCVTSD2SI_GPR64i64_XMMf64_AVX512:
    	return "_mm_cvt_roundsd_i64";
    case INTRINSIC_XED_IFORM_VCVTSD2SS_XMMf32_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_cvt_roundsd_ss";
    case INTRINSIC_XED_IFORM_VCVTSD2USI_GPR32u32_XMMf64_AVX512:
    	return "_mm_cvt_roundsd_u32";
    case INTRINSIC_XED_IFORM_VCVTSD2USI_GPR64u64_XMMf64_AVX512:
    	return "_mm_cvt_roundsd_u64";
    case INTRINSIC_XED_IFORM_VCVTSI2SD_XMMf64_XMMf64_GPR64i64_AVX512:
    	return "_mm_cvt_roundi64_sd";
    case INTRINSIC_XED_IFORM_VCVTSI2SD_XMMf64_XMMf64_GPR32i32_AVX512:
    	return "_mm_cvti32_sd";
    case INTRINSIC_XED_IFORM_VCVTSI2SS_XMMf32_XMMf32_GPR32i32_AVX512:
    	return "_mm_cvt_roundi32_ss";
    case INTRINSIC_XED_IFORM_VCVTSI2SS_XMMf32_XMMf32_GPR64i64_AVX512:
    	return "_mm_cvt_roundi64_ss";
    case INTRINSIC_XED_IFORM_VCVTSS2SD_XMMf64_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_cvt_roundss_sd";
    case INTRINSIC_XED_IFORM_VCVTSS2SI_GPR32i32_XMMf32_AVX512:
    	return "_mm_cvt_roundss_i32";
    case INTRINSIC_XED_IFORM_VCVTSS2SI_GPR64i64_XMMf32_AVX512:
    	return "_mm_cvt_roundss_i64";
    case INTRINSIC_XED_IFORM_VCVTSS2USI_GPR32u32_XMMf32_AVX512:
    	return "_mm_cvt_roundss_u32";
    case INTRINSIC_XED_IFORM_VCVTSS2USI_GPR64u64_XMMf32_AVX512:
    	return "_mm_cvt_roundss_u64";
    case INTRINSIC_XED_IFORM_VCVTTPD2DQ_YMMi32_MASKmskw_ZMMf64_AVX512_VL512:
    	return "_mm512_cvtt_roundpd_epi32";
    case INTRINSIC_XED_IFORM_VCVTTPD2UDQ_YMMu32_MASKmskw_ZMMf64_AVX512_VL512:
    	return "_mm512_cvtt_roundpd_epu32";
    case INTRINSIC_XED_IFORM_VCVTTPS2DQ_ZMMi32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_cvtt_roundps_epi32";
    case INTRINSIC_XED_IFORM_VCVTTPS2UDQ_ZMMu32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_cvtt_roundps_epu32";
    case INTRINSIC_XED_IFORM_VCVTTSD2SI_GPR32i32_XMMf64_AVX512:
    	return "_mm_cvtt_roundsd_i32";
    case INTRINSIC_XED_IFORM_VCVTTSD2SI_GPR64i64_XMMf64_AVX512:
    	return "_mm_cvtt_roundsd_i64";
    case INTRINSIC_XED_IFORM_VCVTTSD2USI_GPR32u32_XMMf64_AVX512:
    	return "_mm_cvtt_roundsd_u32";
    case INTRINSIC_XED_IFORM_VCVTTSD2USI_GPR64u64_XMMf64_AVX512:
    	return "_mm_cvtt_roundsd_u64";
    case INTRINSIC_XED_IFORM_VCVTTSS2SI_GPR32i32_XMMf32_AVX512:
    	return "_mm_cvtt_roundss_i32";
    case INTRINSIC_XED_IFORM_VCVTTSS2SI_GPR64i64_XMMf32_AVX512:
    	return "_mm_cvtt_roundss_i64";
    case INTRINSIC_XED_IFORM_VCVTTSS2USI_GPR32u32_XMMf32_AVX512:
    	return "_mm_cvtt_roundss_u32";
    case INTRINSIC_XED_IFORM_VCVTTSS2USI_GPR64u64_XMMf32_AVX512:
    	return "_mm_cvtt_roundss_u64";
    case INTRINSIC_XED_IFORM_VCVTUDQ2PD_ZMMf64_MASKmskw_YMMu32_AVX512:
    	return "_mm512_cvtepu32_pd";
    case INTRINSIC_XED_IFORM_VCVTUDQ2PS_ZMMf32_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_cvt_roundepu32_ps";
    case INTRINSIC_XED_IFORM_VCVTUSI2SD_XMMf64_XMMf64_GPR64u64_AVX512:
    	return "_mm_cvt_roundu64_sd";
    case INTRINSIC_XED_IFORM_VCVTUSI2SD_XMMf64_XMMf64_GPR32u32_AVX512:
    	return "_mm_cvtu32_sd";
    case INTRINSIC_XED_IFORM_VCVTUSI2SS_XMMf32_XMMf32_GPR32u32_AVX512:
    	return "_mm_cvt_roundu32_ss";
    case INTRINSIC_XED_IFORM_VCVTUSI2SS_XMMf32_XMMf32_GPR64u64_AVX512:
    	return "_mm_cvt_roundu64_ss";
    case INTRINSIC_XED_IFORM_VDIVPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_div_pd";
    case INTRINSIC_XED_IFORM_VDIVPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_div_ps";
    case INTRINSIC_XED_IFORM_VDIVSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_div_round_sd";
    case INTRINSIC_XED_IFORM_VDIVSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_div_round_ss";
    case INTRINSIC_XED_IFORM_VEXPANDPD_ZMMf64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_mask_expand_pd";
    case INTRINSIC_XED_IFORM_VEXPANDPD_ZMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm512_mask_expandloadu_pd";
    case INTRINSIC_XED_IFORM_VEXPANDPS_ZMMf32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_mask_expand_ps";
    case INTRINSIC_XED_IFORM_VEXPANDPS_ZMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm512_mask_expandloadu_ps";
    case INTRINSIC_XED_IFORM_VEXTRACTF32X4_XMMf32_MASKmskw_ZMMf32_IMM8_AVX512:
    	return "_mm512_extractf32x4_ps";
    case INTRINSIC_XED_IFORM_VEXTRACTF64X4_YMMf64_MASKmskw_ZMMf64_IMM8_AVX512:
    	return "_mm512_extractf64x4_pd";
    case INTRINSIC_XED_IFORM_VEXTRACTI32X4_XMMu32_MASKmskw_ZMMu32_IMM8_AVX512:
    	return "_mm512_extracti32x4_epi32";
    case INTRINSIC_XED_IFORM_VEXTRACTI64X4_YMMu64_MASKmskw_ZMMu64_IMM8_AVX512:
    	return "_mm512_extracti64x4_epi64";
    case INTRINSIC_XED_IFORM_VFIXUPIMMPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_IMM8_AVX512:
    	return "_mm512_fixupimm_pd";
    case INTRINSIC_XED_IFORM_VFIXUPIMMPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_IMM8_AVX512:
    	return "_mm512_fixupimm_ps";
    case INTRINSIC_XED_IFORM_VFIXUPIMMSD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512:
    	return "_mm_fixupimm_round_sd";
    case INTRINSIC_XED_IFORM_VFIXUPIMMSS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512:
    	return "_mm_fixupimm_round_ss";
    case INTRINSIC_XED_IFORM_VFMADD132PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD213PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD132PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD132SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_fmadd_round_sd";
    case INTRINSIC_XED_IFORM_VFMADD213SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_fmadd_round_sd";
    case INTRINSIC_XED_IFORM_VFMADD231SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_fmadd_round_sd";
    case INTRINSIC_XED_IFORM_VFMADD132SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmadd_round_ss";
    case INTRINSIC_XED_IFORM_VFMADD213SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmadd_round_ss";
    case INTRINSIC_XED_IFORM_VFMADD231SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask3_fmadd_round_ss";
    case INTRINSIC_XED_IFORM_VFMADDSUB132PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB213PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB132PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB132PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB213PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB132PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB132SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_fmsub_round_sd";
    case INTRINSIC_XED_IFORM_VFMSUB213SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_fmsub_round_sd";
    case INTRINSIC_XED_IFORM_VFMSUB231SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_fmsub_round_sd";
    case INTRINSIC_XED_IFORM_VFMSUB132SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_fmsub_round_ss";
    case INTRINSIC_XED_IFORM_VFMSUB213SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_fmsub_round_ss";
    case INTRINSIC_XED_IFORM_VFMSUB231SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_fmsub_round_ss";
    case INTRINSIC_XED_IFORM_VFMSUBADD132PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD213PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD132PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD132PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD213PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD132PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD132SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_fnmadd_round_sd";
    case INTRINSIC_XED_IFORM_VFNMADD213SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_fnmadd_round_sd";
    case INTRINSIC_XED_IFORM_VFNMADD231SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_fnmadd_round_sd";
    case INTRINSIC_XED_IFORM_VFNMADD132SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_fnmadd_round_ss";
    case INTRINSIC_XED_IFORM_VFNMADD213SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_fnmadd_round_ss";
    case INTRINSIC_XED_IFORM_VFNMADD231SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_fnmadd_round_ss";
    case INTRINSIC_XED_IFORM_VFNMSUB132PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB213PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB231PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB132PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB213PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB231PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB132SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_fnmsub_round_sd";
    case INTRINSIC_XED_IFORM_VFNMSUB213SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_fnmsub_round_sd";
    case INTRINSIC_XED_IFORM_VFNMSUB231SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_fnmsub_round_sd";
    case INTRINSIC_XED_IFORM_VFNMSUB132SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_fnmsub_round_ss";
    case INTRINSIC_XED_IFORM_VFNMSUB213SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_fnmsub_round_ss";
    case INTRINSIC_XED_IFORM_VFNMSUB231SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_fnmsub_round_ss";
    case INTRINSIC_XED_IFORM_VGATHERDPD_ZMMf64_MASKmskw_MEMf64_AVX512_VL512:
    	return "_mm512_i32gather_pd";
    case INTRINSIC_XED_IFORM_VGATHERQPD_ZMMf64_MASKmskw_MEMf64_AVX512_VL512:
    	return "_mm512_i64gather_pd";
    case INTRINSIC_XED_IFORM_VGETEXPPD_ZMMf64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_maskz_getexp_pd";
    case INTRINSIC_XED_IFORM_VGETEXPPS_ZMMf32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_maskz_getexp_ps";
    case INTRINSIC_XED_IFORM_VGETEXPSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_getexp_round_sd";
    case INTRINSIC_XED_IFORM_VGETEXPSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_getexp_round_ss";
    case INTRINSIC_XED_IFORM_VGETMANTPD_ZMMf64_MASKmskw_ZMMf64_IMM8_AVX512:
    	return "_mm512_maskz_getmant_pd";
    case INTRINSIC_XED_IFORM_VGETMANTPS_ZMMf32_MASKmskw_ZMMf32_IMM8_AVX512:
    	return "_mm512_maskz_getmant_ps";
    case INTRINSIC_XED_IFORM_VGETMANTSD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512:
    	return "_mm_getmant_round_sd";
    case INTRINSIC_XED_IFORM_VGETMANTSS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512:
    	return "_mm_getmant_round_ss";
    case INTRINSIC_XED_IFORM_VINSERTF32X4_ZMMf32_MASKmskw_ZMMf32_XMMf32_IMM8_AVX512:
    	return "_mm512_insertf32x4";
    case INTRINSIC_XED_IFORM_VINSERTF64X4_ZMMf64_MASKmskw_ZMMf64_YMMf64_IMM8_AVX512:
    	return "_mm512_insertf64x4";
    case INTRINSIC_XED_IFORM_VINSERTI32X4_ZMMu32_MASKmskw_ZMMu32_XMMu32_IMM8_AVX512:
    	return "_mm512_inserti32x4";
    case INTRINSIC_XED_IFORM_VINSERTI64X4_ZMMu64_MASKmskw_ZMMu64_YMMu64_IMM8_AVX512:
    	return "_mm512_inserti64x4";
    case INTRINSIC_XED_IFORM_VMAXPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_mask_max_pd";
    case INTRINSIC_XED_IFORM_VMAXPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_mask_max_ps";
    case INTRINSIC_XED_IFORM_VMAXSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_max_round_sd";
    case INTRINSIC_XED_IFORM_VMAXSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_max_round_ss";
    case INTRINSIC_XED_IFORM_VMINPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_mask_min_pd";
    case INTRINSIC_XED_IFORM_VMINPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_mask_min_ps";
    case INTRINSIC_XED_IFORM_VMINSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_min_round_sd";
    case INTRINSIC_XED_IFORM_VMINSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_min_round_ss";
    case INTRINSIC_XED_IFORM_VMOVAPD_ZMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm512_maskz_load_pd";
    case INTRINSIC_XED_IFORM_VMOVAPD_ZMMf64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_maskz_mov_pd";
    case INTRINSIC_XED_IFORM_VMOVAPS_ZMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm512_maskz_load_ps";
    case INTRINSIC_XED_IFORM_VMOVAPS_ZMMf32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_maskz_mov_ps";
    case INTRINSIC_XED_IFORM_VMOVDDUP_ZMMf64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_mask_movedup_pd";
    case INTRINSIC_XED_IFORM_VMOVDQA32_ZMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm512_maskz_load_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQA32_ZMMu32_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_maskz_mov_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQA64_ZMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm512_maskz_load_epi64";
    case INTRINSIC_XED_IFORM_VMOVDQA64_ZMMu64_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_maskz_mov_epi64";
    case INTRINSIC_XED_IFORM_VMOVNTDQA_ZMMu32_MEMu32_AVX512:
    	return "_mm512_stream_load_si512";
    case INTRINSIC_XED_IFORM_VMOVNTDQ_MEMu32_ZMMu32_AVX512:
    	return "_mm512_stream_si512";
    case INTRINSIC_XED_IFORM_VMOVNTPD_MEMf64_ZMMf64_AVX512:
    	return "_mm512_stream_pd";
    case INTRINSIC_XED_IFORM_VMOVNTPS_MEMf32_ZMMf32_AVX512:
    	return "_mm512_stream_ps";
    case INTRINSIC_XED_IFORM_VMOVSD_XMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm_mask_load_sd";
    case INTRINSIC_XED_IFORM_VMOVSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_move_sd";
    case INTRINSIC_XED_IFORM_VMOVSD_MEMf64_MASKmskw_XMMf64_AVX512:
    	return "_mm_mask_store_sd";
    case INTRINSIC_XED_IFORM_VMOVSHDUP_ZMMf32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_mask_movehdup_ps";
    case INTRINSIC_XED_IFORM_VMOVSLDUP_ZMMf32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_mask_moveldup_ps";
    case INTRINSIC_XED_IFORM_VMOVSS_XMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm_mask_load_ss";
    case INTRINSIC_XED_IFORM_VMOVSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_move_ss";
    case INTRINSIC_XED_IFORM_VMOVSS_MEMf32_MASKmskw_XMMf32_AVX512:
    	return "_mm_mask_store_ss";
    case INTRINSIC_XED_IFORM_VMOVUPD_ZMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm512_loadu_pd";
    case INTRINSIC_XED_IFORM_VMOVUPD_MEMf64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_mask_storeu_pd";
    case INTRINSIC_XED_IFORM_VMOVUPS_ZMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm512_loadu_ps";
    case INTRINSIC_XED_IFORM_VMOVUPS_MEMf32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_mask_storeu_ps";
    case INTRINSIC_XED_IFORM_VMULPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_mul_pd";
    case INTRINSIC_XED_IFORM_VMULPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_mul_ps";
    case INTRINSIC_XED_IFORM_VMULSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_mul_round_sd";
    case INTRINSIC_XED_IFORM_VMULSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_mul_round_ss";
    case INTRINSIC_XED_IFORM_VPABSD_ZMMi32_MASKmskw_ZMMi32_AVX512:
    	return "_mm512_abs_epi32";
    case INTRINSIC_XED_IFORM_VPABSQ_ZMMi64_MASKmskw_ZMMi64_AVX512:
    	return "_mm512_abs_epi64";
    case INTRINSIC_XED_IFORM_VPADDD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_add_epi32";
    case INTRINSIC_XED_IFORM_VPADDQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_add_epi64";
    case INTRINSIC_XED_IFORM_VPANDD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_and_epi32";
    case INTRINSIC_XED_IFORM_VPANDND_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_andnot_epi32";
    case INTRINSIC_XED_IFORM_VPANDNQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_maskz_andnot_epi64";
    case INTRINSIC_XED_IFORM_VPANDQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_maskz_and_epi64";
    case INTRINSIC_XED_IFORM_VPBROADCASTD_ZMMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm512_broadcastd_epi32";
    case INTRINSIC_XED_IFORM_VPBROADCASTD_ZMMu32_MASKmskw_GPR32u32_AVX512:
    	return "_mm512_mask_set1_epi32";
    case INTRINSIC_XED_IFORM_VPBROADCASTQ_ZMMu64_MASKmskw_XMMu64_AVX512:
    	return "_mm512_broadcastq_epi64";
    case INTRINSIC_XED_IFORM_VPBROADCASTQ_ZMMu64_MASKmskw_GPR64u64_AVX512:
    	return "_mm512_mask_set1_epi64";
    case INTRINSIC_XED_IFORM_VPCMPD_MASKmskw_MASKmskw_ZMMi32_ZMMi32_IMM8_AVX512:
    	return "_mm512_cmplt_epi32_mask";
    case INTRINSIC_XED_IFORM_VPCMPQ_MASKmskw_MASKmskw_ZMMi64_ZMMi64_IMM8_AVX512:
    	return "_mm512_cmp_epi64_mask";
    case INTRINSIC_XED_IFORM_VPCMPEQQ_MASKmskw_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_cmpeq_epi64_mask";
    case INTRINSIC_XED_IFORM_VPCMPGTQ_MASKmskw_MASKmskw_ZMMi64_ZMMi64_AVX512:
    	return "_mm512_cmpgt_epi64_mask";
    case INTRINSIC_XED_IFORM_VPCMPUQ_MASKmskw_MASKmskw_ZMMu64_ZMMu64_IMM8_AVX512:
    	return "_mm512_cmp_epu64_mask";
    case INTRINSIC_XED_IFORM_VPCOMPRESSD_ZMMu32_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_mask_compress_epi32";
    case INTRINSIC_XED_IFORM_VPCOMPRESSD_MEMu32_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_mask_compressstoreu_epi32";
    case INTRINSIC_XED_IFORM_VPCOMPRESSQ_ZMMu64_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_mask_compress_epi64";
    case INTRINSIC_XED_IFORM_VPCOMPRESSQ_MEMu64_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_mask_compressstoreu_epi64";
    case INTRINSIC_XED_IFORM_VPERMD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_permutexvar_epi32";
    case INTRINSIC_XED_IFORM_VPERMI2D_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask2_permutex2var_epi32";
    case INTRINSIC_XED_IFORM_VPERMT2D_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_permutex2var_epi32";
    case INTRINSIC_XED_IFORM_VPERMI2PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_mask2_permutex2var_pd";
    case INTRINSIC_XED_IFORM_VPERMT2PD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_mask_permutex2var_pd";
    case INTRINSIC_XED_IFORM_VPERMI2PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_mask2_permutex2var_ps";
    case INTRINSIC_XED_IFORM_VPERMT2PS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_mask_permutex2var_ps";
    case INTRINSIC_XED_IFORM_VPERMI2Q_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask2_permutex2var_epi64";
    case INTRINSIC_XED_IFORM_VPERMT2Q_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_permutex2var_epi64";
    case INTRINSIC_XED_IFORM_VPERMILPD_ZMMf64_MASKmskw_ZMMf64_IMM8_AVX512:
    	return "_mm512_mask_permute_pd";
    case INTRINSIC_XED_IFORM_VPERMILPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_mask_permutevar_pd";
    case INTRINSIC_XED_IFORM_VPERMILPS_ZMMf32_MASKmskw_ZMMf32_IMM8_AVX512:
    	return "_mm512_mask_permute_ps";
    case INTRINSIC_XED_IFORM_VPERMILPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_mask_permutevar_ps";
    case INTRINSIC_XED_IFORM_VPERMPD_ZMMf64_MASKmskw_ZMMf64_IMM8_AVX512:
    	return "_mm512_mask_permutex_pd";
    case INTRINSIC_XED_IFORM_VPERMPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_mask_permutexvar_pd";
    case INTRINSIC_XED_IFORM_VPERMPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_mask_permutexvar_ps";
    case INTRINSIC_XED_IFORM_VPERMQ_ZMMu64_MASKmskw_ZMMu64_IMM8_AVX512:
    	return "_mm512_mask_permutex_epi64";
    case INTRINSIC_XED_IFORM_VPERMQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_permutexvar_epi64";
    case INTRINSIC_XED_IFORM_VPEXPANDD_ZMMu32_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_mask_expand_epi32";
    case INTRINSIC_XED_IFORM_VPEXPANDD_ZMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm512_mask_expandloadu_epi32";
    case INTRINSIC_XED_IFORM_VPEXPANDQ_ZMMu64_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_mask_expand_epi64";
    case INTRINSIC_XED_IFORM_VPEXPANDQ_ZMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm512_mask_expandloadu_epi64";
    case INTRINSIC_XED_IFORM_VPGATHERDQ_ZMMu64_MASKmskw_MEMu64_AVX512_VL512:
    	return "_mm512_i32gather_epi64";
    case INTRINSIC_XED_IFORM_VPGATHERQD_YMMu32_MASKmskw_MEMu32_AVX512_VL512:
    	return "_mm512_i64gather_epi32";
    case INTRINSIC_XED_IFORM_VPGATHERQQ_ZMMu64_MASKmskw_MEMu64_AVX512_VL512:
    	return "_mm512_i64gather_epi64";
    case INTRINSIC_XED_IFORM_VPMAXSD_ZMMi32_MASKmskw_ZMMi32_ZMMi32_AVX512:
    	return "_mm512_maskz_max_epi32";
    case INTRINSIC_XED_IFORM_VPMAXSQ_ZMMi64_MASKmskw_ZMMi64_ZMMi64_AVX512:
    	return "_mm512_mask_max_epi64";
    case INTRINSIC_XED_IFORM_VPMAXUD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_max_epu32";
    case INTRINSIC_XED_IFORM_VPMAXUQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_max_epu64";
    case INTRINSIC_XED_IFORM_VPMINSD_ZMMi32_MASKmskw_ZMMi32_ZMMi32_AVX512:
    	return "_mm512_maskz_min_epi32";
    case INTRINSIC_XED_IFORM_VPMINSQ_ZMMi64_MASKmskw_ZMMi64_ZMMi64_AVX512:
    	return "_mm512_mask_min_epi64";
    case INTRINSIC_XED_IFORM_VPMINUD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_min_epu32";
    case INTRINSIC_XED_IFORM_VPMINUQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_min_epu64";
    case INTRINSIC_XED_IFORM_VPMOVDB_XMMu8_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_cvtepi32_epi8";
    case INTRINSIC_XED_IFORM_VPMOVDB_MEMu8_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_mask_cvtepi32_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVDW_YMMu16_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_cvtepi32_epi16";
    case INTRINSIC_XED_IFORM_VPMOVDW_MEMu16_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_mask_cvtepi32_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVQB_XMMu8_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_cvtepi64_epi8";
    case INTRINSIC_XED_IFORM_VPMOVQB_MEMu8_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_mask_cvtepi64_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVQD_YMMu32_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_cvtepi64_epi32";
    case INTRINSIC_XED_IFORM_VPMOVQD_MEMu32_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_mask_cvtepi64_storeu_epi32";
    case INTRINSIC_XED_IFORM_VPMOVQW_XMMu16_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_cvtepi64_epi16";
    case INTRINSIC_XED_IFORM_VPMOVQW_MEMu16_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_mask_cvtepi64_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSDB_XMMi8_MASKmskw_ZMMi32_AVX512:
    	return "_mm512_cvtsepi32_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSDB_MEMi8_MASKmskw_ZMMi32_AVX512:
    	return "_mm512_mask_cvtsepi32_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSDW_YMMi16_MASKmskw_ZMMi32_AVX512:
    	return "_mm512_cvtsepi32_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSDW_MEMi16_MASKmskw_ZMMi32_AVX512:
    	return "_mm512_mask_cvtsepi32_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSQB_XMMi8_MASKmskw_ZMMi64_AVX512:
    	return "_mm512_cvtsepi64_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSQB_MEMi8_MASKmskw_ZMMi64_AVX512:
    	return "_mm512_mask_cvtsepi64_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVSQD_YMMi32_MASKmskw_ZMMi64_AVX512:
    	return "_mm512_cvtsepi64_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSQD_MEMi32_MASKmskw_ZMMi64_AVX512:
    	return "_mm512_mask_cvtsepi64_storeu_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSQW_XMMi16_MASKmskw_ZMMi64_AVX512:
    	return "_mm512_cvtsepi64_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSQW_MEMi16_MASKmskw_ZMMi64_AVX512:
    	return "_mm512_mask_cvtsepi64_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVSXBD_ZMMi32_MASKmskw_XMMi8_AVX512:
    	return "_mm512_cvtepi8_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSXBQ_ZMMi64_MASKmskw_XMMi8_AVX512:
    	return "_mm512_cvtepi8_epi64";
    case INTRINSIC_XED_IFORM_VPMOVSXDQ_ZMMi64_MASKmskw_YMMi32_AVX512:
    	return "_mm512_cvtepi32_epi64";
    case INTRINSIC_XED_IFORM_VPMOVSXWD_ZMMi32_MASKmskw_YMMi16_AVX512:
    	return "_mm512_cvtepi16_epi32";
    case INTRINSIC_XED_IFORM_VPMOVSXWQ_ZMMi64_MASKmskw_XMMi16_AVX512:
    	return "_mm512_cvtepi16_epi64";
    case INTRINSIC_XED_IFORM_VPMOVUSDB_XMMu8_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_cvtusepi32_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSDB_MEMu8_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_mask_cvtusepi32_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSDW_YMMu16_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_cvtusepi32_epi16";
    case INTRINSIC_XED_IFORM_VPMOVUSDW_MEMu16_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_mask_cvtusepi32_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVUSQB_XMMu8_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_cvtusepi64_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSQB_MEMu8_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_mask_cvtusepi64_storeu_epi8";
    case INTRINSIC_XED_IFORM_VPMOVUSQD_YMMu32_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_cvtusepi64_epi32";
    case INTRINSIC_XED_IFORM_VPMOVUSQD_MEMu32_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_mask_cvtusepi64_storeu_epi32";
    case INTRINSIC_XED_IFORM_VPMOVUSQW_XMMu16_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_cvtusepi64_epi16";
    case INTRINSIC_XED_IFORM_VPMOVUSQW_MEMu16_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_mask_cvtusepi64_storeu_epi16";
    case INTRINSIC_XED_IFORM_VPMOVZXBD_ZMMi32_MASKmskw_XMMi8_AVX512:
    	return "_mm512_cvtepu8_epi32";
    case INTRINSIC_XED_IFORM_VPMOVZXBQ_ZMMi64_MASKmskw_XMMi8_AVX512:
    	return "_mm512_cvtepu8_epi64";
    case INTRINSIC_XED_IFORM_VPMOVZXDQ_ZMMi64_MASKmskw_YMMi32_AVX512:
    	return "_mm512_cvtepu32_epi64";
    case INTRINSIC_XED_IFORM_VPMOVZXWD_ZMMi32_MASKmskw_YMMi16_AVX512:
    	return "_mm512_cvtepu16_epi32";
    case INTRINSIC_XED_IFORM_VPMOVZXWQ_ZMMi64_MASKmskw_XMMi16_AVX512:
    	return "_mm512_cvtepu16_epi64";
    case INTRINSIC_XED_IFORM_VPMULDQ_ZMMi64_MASKmskw_ZMMi32_ZMMi32_AVX512:
    	return "_mm512_mask_mul_epi32";
    case INTRINSIC_XED_IFORM_VPMULUDQ_ZMMu64_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_mul_epu32";
    case INTRINSIC_XED_IFORM_VPORD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_or_epi32";
    case INTRINSIC_XED_IFORM_VPORQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_maskz_or_epi64";
    case INTRINSIC_XED_IFORM_VPROLD_ZMMu32_MASKmskw_ZMMu32_IMM8_AVX512:
    	return "_mm512_mask_rol_epi32";
    case INTRINSIC_XED_IFORM_VPROLQ_ZMMu64_MASKmskw_ZMMu64_IMM8_AVX512:
    	return "_mm512_mask_rol_epi64";
    case INTRINSIC_XED_IFORM_VPROLVD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_rolv_epi32";
    case INTRINSIC_XED_IFORM_VPROLVQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_rolv_epi64";
    case INTRINSIC_XED_IFORM_VPRORD_ZMMu32_MASKmskw_ZMMu32_IMM8_AVX512:
    	return "_mm512_mask_ror_epi32";
    case INTRINSIC_XED_IFORM_VPRORQ_ZMMu64_MASKmskw_ZMMu64_IMM8_AVX512:
    	return "_mm512_mask_ror_epi64";
    case INTRINSIC_XED_IFORM_VPRORVD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_rorv_epi32";
    case INTRINSIC_XED_IFORM_VPRORVQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_rorv_epi64";
    case INTRINSIC_XED_IFORM_VPSCATTERDQ_MEMu64_MASKmskw_ZMMu64_AVX512_VL512:
    	return "_mm512_i32scatter_epi64";
    case INTRINSIC_XED_IFORM_VPSCATTERQD_MEMu32_MASKmskw_YMMu32_AVX512_VL512:
    	return "_mm512_i64scatter_epi32";
    case INTRINSIC_XED_IFORM_VPSCATTERQQ_MEMu64_MASKmskw_ZMMu64_AVX512_VL512:
    	return "_mm512_i64scatter_epi64";
    case INTRINSIC_XED_IFORM_VPSHUFD_ZMMu32_MASKmskw_ZMMu32_IMM8_AVX512:
    	return "_mm512_maskz_shuffle_epi32";
    case INTRINSIC_XED_IFORM_VPSLLD_ZMMu32_MASKmskw_ZMMu32_XMMu32_AVX512:
    	return "_mm512_mask_sll_epi32";
    case INTRINSIC_XED_IFORM_VPSLLD_ZMMu32_MASKmskw_ZMMu32_IMM8_AVX512:
    	return "_mm512_maskz_slli_epi32";
    case INTRINSIC_XED_IFORM_VPSLLQ_ZMMu64_MASKmskw_ZMMu64_XMMu64_AVX512:
    	return "_mm512_mask_sll_epi64";
    case INTRINSIC_XED_IFORM_VPSLLQ_ZMMu64_MASKmskw_ZMMu64_IMM8_AVX512:
    	return "_mm512_mask_slli_epi64";
    case INTRINSIC_XED_IFORM_VPSLLVD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_sllv_epi32";
    case INTRINSIC_XED_IFORM_VPSLLVQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_sllv_epi64";
    case INTRINSIC_XED_IFORM_VPSRAD_ZMMu32_MASKmskw_ZMMu32_XMMu32_AVX512:
    	return "_mm512_mask_sra_epi32";
    case INTRINSIC_XED_IFORM_VPSRAD_ZMMu32_MASKmskw_ZMMu32_IMM8_AVX512:
    	return "_mm512_maskz_srai_epi32";
    case INTRINSIC_XED_IFORM_VPSRAQ_ZMMu64_MASKmskw_ZMMu64_XMMu64_AVX512:
    	return "_mm512_mask_sra_epi64";
    case INTRINSIC_XED_IFORM_VPSRAQ_ZMMu64_MASKmskw_ZMMu64_IMM8_AVX512:
    	return "_mm512_mask_srai_epi64";
    case INTRINSIC_XED_IFORM_VPSRAVD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_srav_epi32";
    case INTRINSIC_XED_IFORM_VPSRAVQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_srav_epi64";
    case INTRINSIC_XED_IFORM_VPSRLD_ZMMu32_MASKmskw_ZMMu32_XMMu32_AVX512:
    	return "_mm512_mask_srl_epi32";
    case INTRINSIC_XED_IFORM_VPSRLD_ZMMu32_MASKmskw_ZMMu32_IMM8_AVX512:
    	return "_mm512_maskz_srli_epi32";
    case INTRINSIC_XED_IFORM_VPSRLQ_ZMMu64_MASKmskw_ZMMu64_XMMu64_AVX512:
    	return "_mm512_mask_srl_epi64";
    case INTRINSIC_XED_IFORM_VPSRLQ_ZMMu64_MASKmskw_ZMMu64_IMM8_AVX512:
    	return "_mm512_mask_srli_epi64";
    case INTRINSIC_XED_IFORM_VPSRLVD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_srlv_epi32";
    case INTRINSIC_XED_IFORM_VPSRLVQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_srlv_epi64";
    case INTRINSIC_XED_IFORM_VPSUBD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_sub_epi32";
    case INTRINSIC_XED_IFORM_VPSUBQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_sub_epi64";
    case INTRINSIC_XED_IFORM_VPTERNLOGD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_IMM8_AVX512:
    	return "_mm512_mask_ternarylogic_epi32";
    case INTRINSIC_XED_IFORM_VPTERNLOGQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_IMM8_AVX512:
    	return "_mm512_mask_ternarylogic_epi64";
    case INTRINSIC_XED_IFORM_VPTESTMQ_MASKmskw_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_test_epi64_mask";
    case INTRINSIC_XED_IFORM_VPTESTNMD_MASKmskw_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_testn_epi32_mask";
    case INTRINSIC_XED_IFORM_VPTESTNMQ_MASKmskw_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_testn_epi64_mask";
    case INTRINSIC_XED_IFORM_VPUNPCKHDQ_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_unpackhi_epi32";
    case INTRINSIC_XED_IFORM_VPUNPCKHQDQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_unpackhi_epi64";
    case INTRINSIC_XED_IFORM_VPUNPCKLDQ_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_unpacklo_epi32";
    case INTRINSIC_XED_IFORM_VPUNPCKLQDQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_unpacklo_epi64";
    case INTRINSIC_XED_IFORM_VPXORD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_xor_epi32";
    case INTRINSIC_XED_IFORM_VPXORQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_maskz_xor_epi64";
    case INTRINSIC_XED_IFORM_VRCP14PD_ZMMf64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_mask_rcp14_pd";
    case INTRINSIC_XED_IFORM_VRCP14PS_ZMMf32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_mask_rcp14_ps";
    case INTRINSIC_XED_IFORM_VRCP14SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_rcp14_sd";
    case INTRINSIC_XED_IFORM_VRCP14SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_rcp14_ss";
    case INTRINSIC_XED_IFORM_VRNDSCALEPD_ZMMf64_MASKmskw_ZMMf64_IMM8_AVX512:
    	return "_mm512_mask_roundscale_pd";
    case INTRINSIC_XED_IFORM_VRNDSCALEPS_ZMMf32_MASKmskw_ZMMf32_IMM8_AVX512:
    	return "_mm512_mask_roundscale_ps";
    case INTRINSIC_XED_IFORM_VRNDSCALESD_XMMf64_MASKmskw_XMMf64_XMMf64_IMM8_AVX512:
    	return "_mm_mask_roundscale_round_sd";
    case INTRINSIC_XED_IFORM_VRNDSCALESS_XMMf32_MASKmskw_XMMf32_XMMf32_IMM8_AVX512:
    	return "_mm_mask_roundscale_round_ss";
    case INTRINSIC_XED_IFORM_VRSQRT14PD_ZMMf64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_mask_rsqrt14_pd";
    case INTRINSIC_XED_IFORM_VRSQRT14PS_ZMMf32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_mask_rsqrt14_ps";
    case INTRINSIC_XED_IFORM_VRSQRT14SD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_rsqrt14_sd";
    case INTRINSIC_XED_IFORM_VRSQRT14SS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_rsqrt14_ss";
    case INTRINSIC_XED_IFORM_VSCALEFPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_mask_scalef_pd";
    case INTRINSIC_XED_IFORM_VSCALEFPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_mask_scalef_ps";
    case INTRINSIC_XED_IFORM_VSCALEFSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_scalef_round_sd";
    case INTRINSIC_XED_IFORM_VSCALEFSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_scalef_round_ss";
    case INTRINSIC_XED_IFORM_VSCATTERDPD_MEMf64_MASKmskw_ZMMf64_AVX512_VL512:
    	return "_mm512_i32scatter_pd";
    case INTRINSIC_XED_IFORM_VSCATTERQPD_MEMf64_MASKmskw_ZMMf64_AVX512_VL512:
    	return "_mm512_i64scatter_pd";
    case INTRINSIC_XED_IFORM_VSCATTERQPS_MEMf32_MASKmskw_YMMf32_AVX512_VL512:
    	return "_mm512_i64scatter_ps";
    case INTRINSIC_XED_IFORM_VSHUFF32X4_ZMMf32_MASKmskw_ZMMf32_ZMMf32_IMM8_AVX512:
    	return "_mm512_mask_shuffle_f32x4";
    case INTRINSIC_XED_IFORM_VSHUFF64X2_ZMMf64_MASKmskw_ZMMf64_ZMMf64_IMM8_AVX512:
    	return "_mm512_mask_shuffle_f64x2";
    case INTRINSIC_XED_IFORM_VSHUFI32X4_ZMMu32_MASKmskw_ZMMu32_ZMMu32_IMM8_AVX512:
    	return "_mm512_mask_shuffle_i32x4";
    case INTRINSIC_XED_IFORM_VSHUFI64X2_ZMMu64_MASKmskw_ZMMu64_ZMMu64_IMM8_AVX512:
    	return "_mm512_mask_shuffle_i64x2";
    case INTRINSIC_XED_IFORM_VSHUFPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_IMM8_AVX512:
    	return "_mm512_mask_shuffle_pd";
    case INTRINSIC_XED_IFORM_VSHUFPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_IMM8_AVX512:
    	return "_mm512_mask_shuffle_ps";
    case INTRINSIC_XED_IFORM_VSQRTPD_ZMMf64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_mask_sqrt_pd";
    case INTRINSIC_XED_IFORM_VSQRTPS_ZMMf32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_mask_sqrt_ps";
    case INTRINSIC_XED_IFORM_VSQRTSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_sqrt_round_sd";
    case INTRINSIC_XED_IFORM_VSQRTSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_sqrt_round_ss";
    case INTRINSIC_XED_IFORM_VSUBPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_maskz_sub_pd";
    case INTRINSIC_XED_IFORM_VSUBPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_maskz_sub_ps";
    case INTRINSIC_XED_IFORM_VSUBSD_XMMf64_MASKmskw_XMMf64_XMMf64_AVX512:
    	return "_mm_mask_sub_round_sd";
    case INTRINSIC_XED_IFORM_VSUBSS_XMMf32_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_mask_sub_round_ss";
    case INTRINSIC_XED_IFORM_VUNPCKHPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_mask_unpackhi_pd";
    case INTRINSIC_XED_IFORM_VUNPCKHPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_mask_unpackhi_ps";
    case INTRINSIC_XED_IFORM_VUNPCKLPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_mask_unpacklo_pd";
    case INTRINSIC_XED_IFORM_VUNPCKLPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_mask_unpacklo_ps";
    case INTRINSIC_XED_IFORM_VMOVD_GPR32u32_XMMu32_AVX512:
    	return "_mm512_cvtsi512_si32";
    case INTRINSIC_XED_IFORM_VBLENDMPD_ZMMf64_MASKmskw_ZMMf64_ZMMf64_AVX512:
    	return "_mm512_mask_blend_pd";
    case INTRINSIC_XED_IFORM_VBLENDMPS_ZMMf32_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_mask_blend_ps";
    case INTRINSIC_XED_IFORM_VCMPPD_MASKmskw_MASKmskw_ZMMf64_ZMMf64_IMM8_AVX512:
    	return "_mm512_cmp_pd_mask";
    case INTRINSIC_XED_IFORM_VCMPPS_MASKmskw_MASKmskw_ZMMf32_ZMMf32_IMM8_AVX512:
    	return "_mm512_cmp_ps_mask";
    case INTRINSIC_XED_IFORM_VGATHERDPS_ZMMf32_MASKmskw_MEMf32_AVX512_VL512:
    	return "_mm512_i32gather_ps";
    case INTRINSIC_XED_IFORM_VMOVAPD_MEMf64_MASKmskw_ZMMf64_AVX512:
    	return "_mm512_mask_store_pd";
    case INTRINSIC_XED_IFORM_VMOVAPS_MEMf32_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_mask_store_ps";
    case INTRINSIC_XED_IFORM_VMOVDQA32_MEMu32_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_mask_store_epi32";
    case INTRINSIC_XED_IFORM_VMOVDQA64_MEMu64_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_mask_store_epi64";
    case INTRINSIC_XED_IFORM_VPBLENDMD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_blend_epi32";
    case INTRINSIC_XED_IFORM_VPBLENDMQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_mask_blend_epi64";
    case INTRINSIC_XED_IFORM_VPCMPEQD_MASKmskw_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_cmpeq_epi32_mask";
    case INTRINSIC_XED_IFORM_VPCMPGTD_MASKmskw_MASKmskw_ZMMi32_ZMMi32_AVX512:
    	return "_mm512_cmpgt_epi32_mask";
    case INTRINSIC_XED_IFORM_VPCMPUD_MASKmskw_MASKmskw_ZMMu32_ZMMu32_IMM8_AVX512:
    	return "_mm512_cmp_epu32_mask";
    case INTRINSIC_XED_IFORM_VPGATHERDD_ZMMu32_MASKmskw_MEMu32_AVX512_VL512:
    	return "_mm512_i32gather_epi32";
    case INTRINSIC_XED_IFORM_VPSCATTERDD_MEMu32_MASKmskw_ZMMu32_AVX512_VL512:
    	return "_mm512_i32scatter_epi32";
    case INTRINSIC_XED_IFORM_VPTESTMD_MASKmskw_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_mask_test_epi32_mask";
    case INTRINSIC_XED_IFORM_VSCATTERDPS_MEMf32_MASKmskw_ZMMf32_AVX512_VL512:
    	return "_mm512_i32scatter_ps";
    case INTRINSIC_XED_IFORM_VPANDD_ZMMu32_MASKmskw_ZMMu32_MEMu32_AVX512:
    	return "_mm512_abs_ps";
    case INTRINSIC_XED_IFORM_VPANDQ_ZMMu64_MASKmskw_ZMMu64_MEMu64_AVX512:
    	return "_mm512_abs_pd";
    case INTRINSIC_XED_IFORM_VPMADD52LUQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_madd52lo_epu64";
    case INTRINSIC_XED_IFORM_VPMADD52LUQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_madd52lo_epu64";
    case INTRINSIC_XED_IFORM_VPMADD52LUQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_madd52lo_epu64";
    case INTRINSIC_XED_IFORM_VPMADD52HUQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_madd52hi_epu64";
    case INTRINSIC_XED_IFORM_VPMADD52HUQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_madd52hi_epu64";
    case INTRINSIC_XED_IFORM_VPMADD52HUQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_madd52hi_epu64";
    case INTRINSIC_XED_IFORM_VGATHERPF0QPS_MEMf32_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i64gather_ps";
    case INTRINSIC_XED_IFORM_VGATHERPF1QPS_MEMf32_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i64gather_ps";
    case INTRINSIC_XED_IFORM_VSCATTERPF0QPS_MEMf32_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i64scatter_ps";
    case INTRINSIC_XED_IFORM_VSCATTERPF1QPS_MEMf32_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i64scatter_ps";
    case INTRINSIC_XED_IFORM_VGATHERPF0DPD_MEMf64_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i32gather_pd";
    case INTRINSIC_XED_IFORM_VGATHERPF1DPD_MEMf64_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i32gather_pd";
    case INTRINSIC_XED_IFORM_VSCATTERPF0DPD_MEMf64_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i32scatter_pd";
    case INTRINSIC_XED_IFORM_VSCATTERPF1DPD_MEMf64_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i32scatter_pd";
    case INTRINSIC_XED_IFORM_VGATHERPF0QPD_MEMf64_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i64gather_pd";
    case INTRINSIC_XED_IFORM_VGATHERPF1QPD_MEMf64_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i64gather_pd";
    case INTRINSIC_XED_IFORM_VSCATTERPF0QPD_MEMf64_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i64scatter_pd";
    case INTRINSIC_XED_IFORM_VSCATTERPF1QPD_MEMf64_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i64scatter_pd";
    case INTRINSIC_XED_IFORM_VGATHERPF0DPS_MEMf32_MASKmskw_AVX512PF_VL512:
    	return "_mm512_mask_prefetch_i32gather_ps";
    case INTRINSIC_XED_IFORM_VGATHERPF1DPS_MEMf32_MASKmskw_AVX512PF_VL512:
    	return "_mm512_mask_prefetch_i32gather_ps";
    case INTRINSIC_XED_IFORM_VSCATTERPF0DPS_MEMf32_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i32extscatter_ps";
    case INTRINSIC_XED_IFORM_VSCATTERPF1DPS_MEMf32_MASKmskw_AVX512PF_VL512:
    	return "_mm512_prefetch_i32extscatter_ps";
    case INTRINSIC_XED_IFORM_VPOPCNTQ_YMMu64_MASKmskw_YMMu64_AVX512:
    	return "_mm256_maskz_popcnt_epi64";
    case INTRINSIC_XED_IFORM_VPOPCNTQ_XMMu64_MASKmskw_XMMu64_AVX512:
    	return "_mm_maskz_popcnt_epi64";
    case INTRINSIC_XED_IFORM_VPOPCNTD_YMMu32_MASKmskw_YMMu32_AVX512:
    	return "_mm256_popcnt_epi32";
    case INTRINSIC_XED_IFORM_VPOPCNTD_XMMu32_MASKmskw_XMMu32_AVX512:
    	return "_mm_popcnt_epi32";
    case INTRINSIC_XED_IFORM_VPOPCNTD_ZMMu32_MASKmskw_ZMMu32_AVX512:
    	return "_mm512_popcnt_epi32";
    case INTRINSIC_XED_IFORM_VPOPCNTQ_ZMMu64_MASKmskw_ZMMu64_AVX512:
    	return "_mm512_popcnt_epi64";
    case INTRINSIC_XED_IFORM_V4FMADDPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512:
    	return "_mm512_4fmadd_ps";
    case INTRINSIC_XED_IFORM_V4FNMADDPS_ZMMf32_MASKmskw_ZMMf32_MEMf32_AVX512:
    	return "_mm512_4fnmadd_ps";
    case INTRINSIC_XED_IFORM_V4FMADDSS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512:
    	return "_mm_4fmadd_ss";
    case INTRINSIC_XED_IFORM_V4FNMADDSS_XMMf32_MASKmskw_XMMf32_MEMf32_AVX512:
    	return "_mm_4fnmadd_ss";
    case INTRINSIC_XED_IFORM_VP4DPWSSD_ZMMi32_MASKmskw_ZMMi16_MEMu32_AVX512:
    	return "_mm512_4dpwssd_epi32";
    case INTRINSIC_XED_IFORM_VP4DPWSSDS_ZMMi32_MASKmskw_ZMMi16_MEMu32_AVX512:
    	return "_mm512_4dpwssds_epi32";
    case INTRINSIC_XED_IFORM_VCVTNE2PS2BF16_XMMbf16_MASKmskw_XMMf32_XMMf32_AVX512:
    	return "_mm_cvtne2ps_pbh";
    case INTRINSIC_XED_IFORM_VCVTNE2PS2BF16_YMMbf16_MASKmskw_YMMf32_YMMf32_AVX512:
    	return "_mm256_cvtne2ps_pbh";
    case INTRINSIC_XED_IFORM_VCVTNE2PS2BF16_ZMMbf16_MASKmskw_ZMMf32_ZMMf32_AVX512:
    	return "_mm512_cvtne2ps_pbh";
    case INTRINSIC_XED_IFORM_VCVTNEPS2BF16_XMMbf16_MASKmskw_XMMf32_AVX512:
    	return "_mm_cvtneps_pbh";
    case INTRINSIC_XED_IFORM_VCVTNEPS2BF16_XMMbf16_MASKmskw_YMMf32_AVX512:
    	return "_mm256_cvtneps_pbh";
    case INTRINSIC_XED_IFORM_VCVTNEPS2BF16_YMMbf16_MASKmskw_ZMMf32_AVX512:
    	return "_mm512_cvtneps_pbh";
    case INTRINSIC_XED_IFORM_VDPBF16PS_XMMf32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_dpbf16_ps";
    case INTRINSIC_XED_IFORM_VDPBF16PS_YMMf32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_dpbf16_ps";
    case INTRINSIC_XED_IFORM_VDPBF16PS_ZMMf32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_dpbf16_ps";
    case INTRINSIC_XED_IFORM_VPSHUFBITQMB_MASKmskw_MASKmskw_ZMMu64_ZMMu8_AVX512:
    	return "_mm512_mask_bitshuffle_epi64_mask";
    case INTRINSIC_XED_IFORM_VPSHUFBITQMB_MASKmskw_MASKmskw_YMMu64_YMMu8_AVX512:
    	return "_mm256_mask_bitshuffle_epi64_mask";
    case INTRINSIC_XED_IFORM_VPSHUFBITQMB_MASKmskw_MASKmskw_XMMu64_XMMu8_AVX512:
    	return "_mm_mask_bitshuffle_epi64_mask";
    case INTRINSIC_XED_IFORM_VPOPCNTW_ZMMu16_MASKmskw_ZMMu16_AVX512:
    	return "_mm512_popcnt_epi16";
    case INTRINSIC_XED_IFORM_VPOPCNTW_YMMu16_MASKmskw_YMMu16_AVX512:
    	return "_mm256_popcnt_epi16";
    case INTRINSIC_XED_IFORM_VPOPCNTW_XMMu16_MASKmskw_XMMu16_AVX512:
    	return "_mm_popcnt_epi16";
    case INTRINSIC_XED_IFORM_VPOPCNTB_ZMMu8_MASKmskw_ZMMu8_AVX512:
    	return "_mm512_popcnt_epi8";
    case INTRINSIC_XED_IFORM_VPOPCNTB_YMMu8_MASKmskw_YMMu8_AVX512:
    	return "_mm256_popcnt_epi8";
    case INTRINSIC_XED_IFORM_VPOPCNTB_XMMu8_MASKmskw_XMMu8_AVX512:
    	return "_mm_popcnt_epi8";
    case INTRINSIC_XED_IFORM_VPMULTISHIFTQB_ZMMu8_MASKmskw_ZMMu8_ZMMu64_AVX512:
    	return "_mm512_multishift_epi64_epi8";
    case INTRINSIC_XED_IFORM_VPMULTISHIFTQB_YMMu8_MASKmskw_YMMu8_YMMu64_AVX512:
    	return "_mm256_multishift_epi64_epi8";
    case INTRINSIC_XED_IFORM_VPMULTISHIFTQB_XMMu8_MASKmskw_XMMu8_XMMu64_AVX512:
    	return "_mm_multishift_epi64_epi8";
    case INTRINSIC_XED_IFORM_VPERMB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_permutexvar_epi8";
    case INTRINSIC_XED_IFORM_VPERMB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_permutexvar_epi8";
    case INTRINSIC_XED_IFORM_VPERMB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_permutexvar_epi8";
    case INTRINSIC_XED_IFORM_VPERMI2B_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_permutex2var_epi8";
    case INTRINSIC_XED_IFORM_VPERMT2B_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_mask_permutex2var_epi8";
    case INTRINSIC_XED_IFORM_VPERMI2B_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_permutex2var_epi8";
    case INTRINSIC_XED_IFORM_VPERMT2B_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_mask_permutex2var_epi8";
    case INTRINSIC_XED_IFORM_VPERMI2B_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_permutex2var_epi8";
    case INTRINSIC_XED_IFORM_VPERMT2B_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_mask_permutex2var_epi8";
    case INTRINSIC_XED_IFORM_VPSHRDVQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_maskz_shrdv_epi64";
    case INTRINSIC_XED_IFORM_VPSHRDVQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_maskz_shrdv_epi64";
    case INTRINSIC_XED_IFORM_VPSHRDVQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_maskz_shrdv_epi64";
    case INTRINSIC_XED_IFORM_VPSHRDVD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_shrdv_epi32";
    case INTRINSIC_XED_IFORM_VPSHRDVD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_maskz_shrdv_epi32";
    case INTRINSIC_XED_IFORM_VPSHRDVD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_maskz_shrdv_epi32";
    case INTRINSIC_XED_IFORM_VPSHRDVW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_maskz_shrdv_epi16";
    case INTRINSIC_XED_IFORM_VPSHRDVW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_maskz_shrdv_epi16";
    case INTRINSIC_XED_IFORM_VPSHRDVW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_maskz_shrdv_epi16";
    case INTRINSIC_XED_IFORM_VPSHRDQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_IMM8_AVX512:
    	return "_mm512_maskz_shrdi_epi64";
    case INTRINSIC_XED_IFORM_VPSHRDQ_YMMu64_MASKmskw_YMMu64_YMMu64_IMM8_AVX512:
    	return "_mm256_maskz_shrdi_epi64";
    case INTRINSIC_XED_IFORM_VPSHRDQ_XMMu64_MASKmskw_XMMu64_XMMu64_IMM8_AVX512:
    	return "_mm_maskz_shrdi_epi64";
    case INTRINSIC_XED_IFORM_VPSHRDD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_IMM8_AVX512:
    	return "_mm512_maskz_shrdi_epi32";
    case INTRINSIC_XED_IFORM_VPSHRDD_YMMu32_MASKmskw_YMMu32_YMMu32_IMM8_AVX512:
    	return "_mm256_maskz_shrdi_epi32";
    case INTRINSIC_XED_IFORM_VPSHRDD_XMMu32_MASKmskw_XMMu32_XMMu32_IMM8_AVX512:
    	return "_mm_maskz_shrdi_epi32";
    case INTRINSIC_XED_IFORM_VPSHRDW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_IMM8_AVX512:
    	return "_mm512_maskz_shrdi_epi16";
    case INTRINSIC_XED_IFORM_VPSHRDW_YMMu16_MASKmskw_YMMu16_YMMu16_IMM8_AVX512:
    	return "_mm256_maskz_shrdi_epi16";
    case INTRINSIC_XED_IFORM_VPSHRDW_XMMu16_MASKmskw_XMMu16_XMMu16_IMM8_AVX512:
    	return "_mm_maskz_shrdi_epi16";
    case INTRINSIC_XED_IFORM_VPSHLDVQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_maskz_shldv_epi64";
    case INTRINSIC_XED_IFORM_VPSHLDVQ_YMMu64_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_maskz_shldv_epi64";
    case INTRINSIC_XED_IFORM_VPSHLDVQ_XMMu64_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_maskz_shldv_epi64";
    case INTRINSIC_XED_IFORM_VPSHLDVD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_maskz_shldv_epi32";
    case INTRINSIC_XED_IFORM_VPSHLDVD_YMMu32_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_maskz_shldv_epi32";
    case INTRINSIC_XED_IFORM_VPSHLDVD_XMMu32_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_maskz_shldv_epi32";
    case INTRINSIC_XED_IFORM_VPSHLDVW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_AVX512:
    	return "_mm512_maskz_shldv_epi16";
    case INTRINSIC_XED_IFORM_VPSHLDVW_YMMu16_MASKmskw_YMMu16_YMMu16_AVX512:
    	return "_mm256_maskz_shldv_epi16";
    case INTRINSIC_XED_IFORM_VPSHLDVW_XMMu16_MASKmskw_XMMu16_XMMu16_AVX512:
    	return "_mm_maskz_shldv_epi16";
    case INTRINSIC_XED_IFORM_VPSHLDQ_ZMMu64_MASKmskw_ZMMu64_ZMMu64_IMM8_AVX512:
    	return "_mm512_maskz_shldi_epi64";
    case INTRINSIC_XED_IFORM_VPSHLDQ_YMMu64_MASKmskw_YMMu64_YMMu64_IMM8_AVX512:
    	return "_mm256_maskz_shldi_epi64";
    case INTRINSIC_XED_IFORM_VPSHLDQ_XMMu64_MASKmskw_XMMu64_XMMu64_IMM8_AVX512:
    	return "_mm_maskz_shldi_epi64";
    case INTRINSIC_XED_IFORM_VPSHLDD_ZMMu32_MASKmskw_ZMMu32_ZMMu32_IMM8_AVX512:
    	return "_mm512_maskz_shldi_epi32";
    case INTRINSIC_XED_IFORM_VPSHLDD_YMMu32_MASKmskw_YMMu32_YMMu32_IMM8_AVX512:
    	return "_mm256_maskz_shldi_epi32";
    case INTRINSIC_XED_IFORM_VPSHLDD_XMMu32_MASKmskw_XMMu32_XMMu32_IMM8_AVX512:
    	return "_mm_maskz_shldi_epi32";
    case INTRINSIC_XED_IFORM_VPSHLDW_ZMMu16_MASKmskw_ZMMu16_ZMMu16_IMM8_AVX512:
    	return "_mm512_maskz_shldi_epi16";
    case INTRINSIC_XED_IFORM_VPSHLDW_YMMu16_MASKmskw_YMMu16_YMMu16_IMM8_AVX512:
    	return "_mm256_maskz_shldi_epi16";
    case INTRINSIC_XED_IFORM_VPSHLDW_XMMu16_MASKmskw_XMMu16_XMMu16_IMM8_AVX512:
    	return "_mm_maskz_shldi_epi16";
    case INTRINSIC_XED_IFORM_VPEXPANDW_ZMMu16_MASKmskw_MEMu16_AVX512:
    	return "_mm512_maskz_expandloadu_epi16";
    case INTRINSIC_XED_IFORM_VPEXPANDW_ZMMu16_MASKmskw_ZMMu16_AVX512:
    	return "_mm512_maskz_expand_epi16";
    case INTRINSIC_XED_IFORM_VPEXPANDW_YMMu16_MASKmskw_MEMu16_AVX512:
    	return "_mm256_maskz_expandloadu_epi16";
    case INTRINSIC_XED_IFORM_VPEXPANDW_YMMu16_MASKmskw_YMMu16_AVX512:
    	return "_mm256_maskz_expand_epi16";
    case INTRINSIC_XED_IFORM_VPEXPANDW_XMMu16_MASKmskw_MEMu16_AVX512:
    	return "_mm_maskz_expandloadu_epi16";
    case INTRINSIC_XED_IFORM_VPEXPANDW_XMMu16_MASKmskw_XMMu16_AVX512:
    	return "_mm_maskz_expand_epi16";
    case INTRINSIC_XED_IFORM_VPEXPANDB_ZMMu8_MASKmskw_MEMu8_AVX512:
    	return "_mm512_maskz_expandloadu_epi8";
    case INTRINSIC_XED_IFORM_VPEXPANDB_YMMu8_MASKmskw_MEMu8_AVX512:
    	return "_mm256_maskz_expandloadu_epi8";
    case INTRINSIC_XED_IFORM_VPEXPANDB_XMMu8_MASKmskw_MEMu8_AVX512:
    	return "_mm_maskz_expandloadu_epi8";
    case INTRINSIC_XED_IFORM_VPEXPANDB_ZMMu8_MASKmskw_ZMMu8_AVX512:
    	return "_mm512_maskz_expand_epi8";
    case INTRINSIC_XED_IFORM_VPEXPANDB_YMMu8_MASKmskw_YMMu8_AVX512:
    	return "_mm256_maskz_expand_epi8";
    case INTRINSIC_XED_IFORM_VPEXPANDB_XMMu8_MASKmskw_XMMu8_AVX512:
    	return "_mm_maskz_expand_epi8";
    case INTRINSIC_XED_IFORM_VPCOMPRESSW_MEMu16_MASKmskw_ZMMu16_AVX512:
    	return "_mm512_mask_compressstoreu_epi16";
    case INTRINSIC_XED_IFORM_VPCOMPRESSW_MEMu16_MASKmskw_YMMu16_AVX512:
    	return "_mm256_mask_compressstoreu_epi16";
    case INTRINSIC_XED_IFORM_VPCOMPRESSW_MEMu16_MASKmskw_XMMu16_AVX512:
    	return "_mm_mask_compressstoreu_epi16";
    case INTRINSIC_XED_IFORM_VPCOMPRESSW_ZMMu16_MASKmskw_ZMMu16_AVX512:
    	return "_mm512_maskz_compress_epi16";
    case INTRINSIC_XED_IFORM_VPCOMPRESSW_YMMu16_MASKmskw_YMMu16_AVX512:
    	return "_mm256_maskz_compress_epi16";
    case INTRINSIC_XED_IFORM_VPCOMPRESSW_XMMu16_MASKmskw_XMMu16_AVX512:
    	return "_mm_maskz_compress_epi16";
    case INTRINSIC_XED_IFORM_VPCOMPRESSB_MEMu8_MASKmskw_ZMMu8_AVX512:
    	return "_mm512_mask_compressstoreu_epi8";
    case INTRINSIC_XED_IFORM_VPCOMPRESSB_MEMu8_MASKmskw_YMMu8_AVX512:
    	return "_mm256_mask_compressstoreu_epi8";
    case INTRINSIC_XED_IFORM_VPCOMPRESSB_MEMu8_MASKmskw_XMMu8_AVX512:
    	return "_mm_mask_compressstoreu_epi8";
    case INTRINSIC_XED_IFORM_VPCOMPRESSB_ZMMu8_MASKmskw_ZMMu8_AVX512:
    	return "_mm512_maskz_compress_epi8";
    case INTRINSIC_XED_IFORM_VPCOMPRESSB_YMMu8_MASKmskw_YMMu8_AVX512:
    	return "_mm256_maskz_compress_epi8";
    case INTRINSIC_XED_IFORM_VPCOMPRESSB_XMMu8_MASKmskw_XMMu8_AVX512:
    	return "_mm_maskz_compress_epi8";
    case INTRINSIC_XED_IFORM_VPDPWSSDS_ZMMi32_MASKmskw_ZMMi16_ZMMu32_AVX512:
    	return "_mm512_maskz_dpwssds_epi32";
    case INTRINSIC_XED_IFORM_VPDPWSSDS_YMMi32_MASKmskw_YMMi16_YMMu32_AVX512:
    	return "_mm256_maskz_dpwssds_epi32";
    case INTRINSIC_XED_IFORM_VPDPWSSDS_XMMi32_MASKmskw_XMMi16_XMMu32_AVX512:
    	return "_mm_maskz_dpwssds_epi32";
    case INTRINSIC_XED_IFORM_VPDPWSSD_ZMMi32_MASKmskw_ZMMi16_ZMMu32_AVX512:
    	return "_mm512_maskz_dpwssd_epi32";
    case INTRINSIC_XED_IFORM_VPDPWSSD_YMMi32_MASKmskw_YMMi16_YMMu32_AVX512:
    	return "_mm256_maskz_dpwssd_epi32";
    case INTRINSIC_XED_IFORM_VPDPWSSD_XMMi32_MASKmskw_XMMi16_XMMu32_AVX512:
    	return "_mm_maskz_dpwssd_epi32";
    case INTRINSIC_XED_IFORM_VPDPBUSDS_ZMMi32_MASKmskw_ZMMu8_ZMMu32_AVX512:
    	return "_mm512_maskz_dpbusds_epi32";
    case INTRINSIC_XED_IFORM_VPDPBUSDS_YMMi32_MASKmskw_YMMu8_YMMu32_AVX512:
    	return "_mm256_maskz_dpbusds_epi32";
    case INTRINSIC_XED_IFORM_VPDPBUSDS_XMMi32_MASKmskw_XMMu8_XMMu32_AVX512:
    	return "_mm_maskz_dpbusds_epi32";
    case INTRINSIC_XED_IFORM_VPDPBUSD_ZMMi32_MASKmskw_ZMMu8_ZMMu32_AVX512:
    	return "_mm512_maskz_dpbusd_epi32";
    case INTRINSIC_XED_IFORM_VPDPBUSD_YMMi32_MASKmskw_YMMu8_YMMu32_AVX512:
    	return "_mm256_maskz_dpbusd_epi32";
    case INTRINSIC_XED_IFORM_VPDPBUSD_XMMi32_MASKmskw_XMMu8_XMMu32_AVX512:
    	return "_mm_maskz_dpbusd_epi32";
    case INTRINSIC_XED_IFORM_VP2INTERSECTD_MASKmskw_XMMu32_XMMu32_AVX512:
    	return "_mm_2intersect_epi32";
    case INTRINSIC_XED_IFORM_VP2INTERSECTD_MASKmskw_YMMu32_YMMu32_AVX512:
    	return "_mm256_2intersect_epi32";
    case INTRINSIC_XED_IFORM_VP2INTERSECTD_MASKmskw_ZMMu32_ZMMu32_AVX512:
    	return "_mm512_2intersect_epi32";
    case INTRINSIC_XED_IFORM_VP2INTERSECTQ_MASKmskw_XMMu64_XMMu64_AVX512:
    	return "_mm_2intersect_epi64";
    case INTRINSIC_XED_IFORM_VP2INTERSECTQ_MASKmskw_YMMu64_YMMu64_AVX512:
    	return "_mm256_2intersect_epi64";
    case INTRINSIC_XED_IFORM_VP2INTERSECTQ_MASKmskw_ZMMu64_ZMMu64_AVX512:
    	return "_mm512_2intersect_epi64";
    case INTRINSIC_XED_IFORM_BLSI_GPR32d_GPR32d:
    	return "_bextr_u32";
    case INTRINSIC_XED_IFORM_BEXTR_GPR64q_GPR64q_GPR64q:
    	return "_bextr_u64";
    case INTRINSIC_XED_IFORM_BLSI_GPR64q_GPR64q:
    	return "_blsi_u32";
//    case INTRINSIC_XED_IFORM_BLSI_GPR64q_GPR64q:
//    	return "_blsi_u64";
    case INTRINSIC_XED_IFORM_BLSMSK_GPR32d_GPR32d:
    	return "_blsmsk_u32";
    case INTRINSIC_XED_IFORM_BLSMSK_GPR64q_GPR64q:
    	return "_blsmsk_u64";
    case INTRINSIC_XED_IFORM_BLSR_GPR32d_GPR32d:
    	return "_blsr_u32";
    case INTRINSIC_XED_IFORM_BLSR_GPR64q_GPR64q:
    	return "_blsr_u64";
    case INTRINSIC_XED_IFORM_ANDN_GPR32d_GPR32d_GPR32d:
    	return "_andn_u32";
    case INTRINSIC_XED_IFORM_ANDN_GPR64q_GPR64q_GPR64q:
    	return "_andn_u64";
    case INTRINSIC_XED_IFORM_TZCNT_GPRv_GPRv:
    	return "_tzcnt_u32";
    case INTRINSIC_XED_IFORM_BZHI_GPR32d_GPR32d_GPR32d:
    	return "_bzhi_u32";
    case INTRINSIC_XED_IFORM_BZHI_GPR64q_GPR64q_GPR64q:
    	return "_bzhi_u64";
    case INTRINSIC_XED_IFORM_PDEP_GPR32d_GPR32d_GPR32d:
    	return "_pdep_u32";
    case INTRINSIC_XED_IFORM_PDEP_GPR64q_GPR64q_GPR64q:
    	return "_pdep_u64";
    case INTRINSIC_XED_IFORM_PEXT_GPR32d_GPR32d_GPR32d:
    	return "_pext_u32";
    case INTRINSIC_XED_IFORM_PEXT_GPR64q_GPR64q_GPR64q:
    	return "_pext_u64";
    case INTRINSIC_XED_IFORM_MULX_GPR32d_GPR32d_MEMd:
    	return "_mulx_u32";
    case INTRINSIC_XED_IFORM_MULX_GPR64q_GPR64q_MEMq:
    	return "_mulx_u64";
    case INTRINSIC_XED_IFORM_INCSSPD_GPR32u8:
    	return "_incsspd";
    case INTRINSIC_XED_IFORM_INCSSPQ_GPR64u8:
    	return "_incsspq";
    case INTRINSIC_XED_IFORM_RDSSPD_GPR32u32:
    	return "_rdsspd_i32";
    case INTRINSIC_XED_IFORM_RDSSPQ_GPR64u64:
    	return "_rdsspq_i64";
    case INTRINSIC_XED_IFORM_SAVEPREVSSP:
    	return "_saveprevssp";
    case INTRINSIC_XED_IFORM_RSTORSSP_MEMu64:
    	return "_rstorssp";
    case INTRINSIC_XED_IFORM_WRSSD_MEMu32_GPR32u32:
    	return "_wrssd";
    case INTRINSIC_XED_IFORM_WRSSQ_MEMu64_GPR64u64:
    	return "_wrssq";
    case INTRINSIC_XED_IFORM_WRUSSD_MEMu32_GPR32u32:
    	return "_wrussd";
    case INTRINSIC_XED_IFORM_WRUSSQ_MEMu64_GPR64u64:
    	return "_wrussq";
    case INTRINSIC_XED_IFORM_SETSSBSY:
    	return "_setssbsy";
    case INTRINSIC_XED_IFORM_CLRSSBSY_MEMu64:
    	return "_clrssbsy";
    case INTRINSIC_XED_IFORM_CLDEMOTE_MEMu8:
    	return "_mm_cldemote";
    case INTRINSIC_XED_IFORM_CLFLUSHOPT_MEMmprefetch:
    	return "_mm_clflushopt";
    case INTRINSIC_XED_IFORM_CLWB_MEMmprefetch:
    	return "_mm_clwb";
    case INTRINSIC_XED_IFORM_VFMADD132PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD213PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD231PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD132PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD213PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD231PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmadd_pd";
    case INTRINSIC_XED_IFORM_VFMADD132PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD213PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD231PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD132PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD213PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD231PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmadd_ps";
    case INTRINSIC_XED_IFORM_VFMADD132SD_XMMdq_XMMq_XMMq:
    	return "_mm_fmadd_sd";
    case INTRINSIC_XED_IFORM_VFMADD213SD_XMMdq_XMMq_XMMq:
    	return "_mm_fmadd_sd";
    case INTRINSIC_XED_IFORM_VFMADD231SD_XMMdq_XMMq_XMMq:
    	return "_mm_fmadd_sd";
    case INTRINSIC_XED_IFORM_VFMADD132SS_XMMdq_XMMd_XMMd:
    	return "_mm_fmadd_ss";
    case INTRINSIC_XED_IFORM_VFMADD213SS_XMMdq_XMMd_XMMd:
    	return "_mm_fmadd_ss";
    case INTRINSIC_XED_IFORM_VFMADD231SS_XMMdq_XMMd_XMMd:
    	return "_mm_fmadd_ss";
    case INTRINSIC_XED_IFORM_VFMADDSUB132PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB213PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB231PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB132PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB213PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB231PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmaddsub_pd";
    case INTRINSIC_XED_IFORM_VFMADDSUB132PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB213PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB231PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB132PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB213PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMADDSUB231PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmaddsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB132PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB213PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB231PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB132PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB213PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB231PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmsub_pd";
    case INTRINSIC_XED_IFORM_VFMSUB132PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB213PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB231PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB132PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB213PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB231PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmsub_ps";
    case INTRINSIC_XED_IFORM_VFMSUB132SD_XMMdq_XMMq_XMMq:
    	return "_mm_fmsub_sd";
    case INTRINSIC_XED_IFORM_VFMSUB213SD_XMMdq_XMMq_XMMq:
    	return "_mm_fmsub_sd";
    case INTRINSIC_XED_IFORM_VFMSUB231SD_XMMdq_XMMq_XMMq:
    	return "_mm_fmsub_sd";
    case INTRINSIC_XED_IFORM_VFMSUB132SS_XMMdq_XMMd_XMMd:
    	return "_mm_fmsub_ss";
    case INTRINSIC_XED_IFORM_VFMSUB213SS_XMMdq_XMMd_XMMd:
    	return "_mm_fmsub_ss";
    case INTRINSIC_XED_IFORM_VFMSUB231SS_XMMdq_XMMd_XMMd:
    	return "_mm_fmsub_ss";
    case INTRINSIC_XED_IFORM_VFMSUBADD132PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD213PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD231PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD132PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD213PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD231PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmsubadd_pd";
    case INTRINSIC_XED_IFORM_VFMSUBADD132PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD213PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD231PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD132PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD213PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFMSUBADD231PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fmsubadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD132PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD213PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD231PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD132PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD213PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD231PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fnmadd_pd";
    case INTRINSIC_XED_IFORM_VFNMADD132PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD213PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD231PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD132PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD213PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD231PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fnmadd_ps";
    case INTRINSIC_XED_IFORM_VFNMADD132SD_XMMdq_XMMq_XMMq:
    	return "_mm_fnmadd_sd";
    case INTRINSIC_XED_IFORM_VFNMADD213SD_XMMdq_XMMq_XMMq:
    	return "_mm_fnmadd_sd";
    case INTRINSIC_XED_IFORM_VFNMADD231SD_XMMdq_XMMq_XMMq:
    	return "_mm_fnmadd_sd";
    case INTRINSIC_XED_IFORM_VFNMADD132SS_XMMdq_XMMd_XMMd:
    	return "_mm_fnmadd_ss";
    case INTRINSIC_XED_IFORM_VFNMADD213SS_XMMdq_XMMd_XMMd:
    	return "_mm_fnmadd_ss";
    case INTRINSIC_XED_IFORM_VFNMADD231SS_XMMdq_XMMd_XMMd:
    	return "_mm_fnmadd_ss";
    case INTRINSIC_XED_IFORM_VFNMSUB132PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB213PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB231PD_XMMdq_XMMdq_XMMdq:
    	return "_mm_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB132PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB213PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB231PD_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fnmsub_pd";
    case INTRINSIC_XED_IFORM_VFNMSUB132PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB213PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB231PS_XMMdq_XMMdq_XMMdq:
    	return "_mm_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB132PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB213PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB231PS_YMMqq_YMMqq_YMMqq:
    	return "_mm256_fnmsub_ps";
    case INTRINSIC_XED_IFORM_VFNMSUB132SD_XMMdq_XMMq_XMMq:
    	return "_mm_fnmsub_sd";
    case INTRINSIC_XED_IFORM_VFNMSUB213SD_XMMdq_XMMq_XMMq:
    	return "_mm_fnmsub_sd";
    case INTRINSIC_XED_IFORM_VFNMSUB231SD_XMMdq_XMMq_XMMq:
    	return "_mm_fnmsub_sd";
    case INTRINSIC_XED_IFORM_VFNMSUB132SS_XMMdq_XMMd_XMMd:
    	return "_mm_fnmsub_ss";
    case INTRINSIC_XED_IFORM_VFNMSUB213SS_XMMdq_XMMd_XMMd:
    	return "_mm_fnmsub_ss";
    case INTRINSIC_XED_IFORM_VFNMSUB231SS_XMMdq_XMMd_XMMd:
    	return "_mm_fnmsub_ss";
    case INTRINSIC_XED_IFORM_VCVTPH2PS_YMMqq_XMMdq:
    	return "_mm256_cvtph_ps";
    case INTRINSIC_XED_IFORM_VCVTPS2PH_XMMdq_YMMqq_IMMb:
    	return "_mm256_cvtps_ph";
    case INTRINSIC_XED_IFORM_VCVTPH2PS_XMMdq_XMMq:
    	return "_mm_cvtph_ps";
    case INTRINSIC_XED_IFORM_VCVTPS2PH_XMMq_XMMdq_IMMb:
    	return "_mm_cvtps_ph";
    case INTRINSIC_XED_IFORM_RDFSBASE_GPRy:
    	return "_readfsbase_u32";
    case INTRINSIC_XED_IFORM_RDGSBASE_GPRy:
    	return "_readgsbase_u32";
    case INTRINSIC_XED_IFORM_WRFSBASE_GPRy:
    	return "_writefsbase_u32";
    case INTRINSIC_XED_IFORM_WRGSBASE_GPRy:
    	return "_writegsbase_u32";
    case INTRINSIC_XED_IFORM_FXRSTOR_MEMmfpxenv:
    	return "_fxrstor";
    case INTRINSIC_XED_IFORM_FXRSTOR64_MEMmfpxenv:
    	return "_fxrstor64";
    case INTRINSIC_XED_IFORM_FXSAVE_MEMmfpxenv:
    	return "_fxsave";
    case INTRINSIC_XED_IFORM_FXSAVE64_MEMmfpxenv:
    	return "_fxsave64";
    case INTRINSIC_XED_IFORM_VGF2P8MULB_ZMMu8_MASKmskw_ZMMu8_ZMMu8_AVX512:
    	return "_mm512_maskz_gf2p8mul_epi8";
    case INTRINSIC_XED_IFORM_VGF2P8MULB_YMMu8_MASKmskw_YMMu8_YMMu8_AVX512:
    	return "_mm256_maskz_gf2p8mul_epi8";
    case INTRINSIC_XED_IFORM_VGF2P8MULB_XMMu8_MASKmskw_XMMu8_XMMu8_AVX512:
    	return "_mm_maskz_gf2p8mul_epi8";
    case INTRINSIC_XED_IFORM_VGF2P8AFFINEQB_ZMMu8_MASKmskw_ZMMu8_ZMMu64_IMM8_AVX512:
    	return "_mm512_maskz_gf2p8affine_epi64_epi8";
    case INTRINSIC_XED_IFORM_VGF2P8AFFINEQB_YMMu8_MASKmskw_YMMu8_YMMu64_IMM8_AVX512:
    	return "_mm256_maskz_gf2p8affine_epi64_epi8";
    case INTRINSIC_XED_IFORM_VGF2P8AFFINEQB_XMMu8_MASKmskw_XMMu8_XMMu64_IMM8_AVX512:
    	return "_mm_maskz_gf2p8affine_epi64_epi8";
    case INTRINSIC_XED_IFORM_VGF2P8AFFINEINVQB_ZMMu8_MASKmskw_ZMMu8_ZMMu64_IMM8_AVX512:
    	return "_mm512_maskz_gf2p8affineinv_epi64_epi8";
    case INTRINSIC_XED_IFORM_VGF2P8AFFINEINVQB_YMMu8_MASKmskw_YMMu8_YMMu64_IMM8_AVX512:
    	return "_mm256_maskz_gf2p8affineinv_epi64_epi8";
    case INTRINSIC_XED_IFORM_VGF2P8AFFINEINVQB_XMMu8_MASKmskw_XMMu8_XMMu64_IMM8_AVX512:
    	return "_mm_maskz_gf2p8affineinv_epi64_epi8";
    case INTRINSIC_XED_IFORM_INVPCID_GPR32_MEMdq:
    	return "_invpcid";
    case INTRINSIC_XED_IFORM_VBROADCASTSS_ZMMf32_MASKmskw_MEMf32_AVX512:
    	return "_mm512_extload_ps";
    case INTRINSIC_XED_IFORM_VPBROADCASTD_ZMMu32_MASKmskw_MEMu32_AVX512:
    	return "_mm512_extload_epi32";
    case INTRINSIC_XED_IFORM_VBROADCASTSD_ZMMf64_MASKmskw_MEMf64_AVX512:
    	return "_mm512_extload_pd";
    case INTRINSIC_XED_IFORM_VPBROADCASTQ_ZMMu64_MASKmskw_MEMu64_AVX512:
    	return "_mm512_extload_epi64";
    case INTRINSIC_XED_IFORM_POPCNT_GPRv_GPRv:
    	return "_mm_countbits_32";
    case INTRINSIC_XED_IFORM_LZCNT_GPRv_GPRv:
    	return "_lzcnt_u32";
    case INTRINSIC_XED_IFORM_MOVQ_MMXq_GPR64:
    	return "_m_from_int64";
    case INTRINSIC_XED_IFORM_MOVQ_GPR64_MMXq:
    	return "_m_to_int64";
    case INTRINSIC_XED_IFORM_EMMS:
    	return "_m_empty";
    case INTRINSIC_XED_IFORM_MOVD_MMXq_GPR32:
    	return "_m_from_int";
    case INTRINSIC_XED_IFORM_MOVD_GPR32_MMXd:
    	return "_m_to_int";
    case INTRINSIC_XED_IFORM_PACKSSWB_MMXq_MMXq:
    	return "_m_packsswb";
    case INTRINSIC_XED_IFORM_PACKSSDW_MMXq_MMXq:
    	return "_m_packssdw";
    case INTRINSIC_XED_IFORM_PACKUSWB_MMXq_MMXq:
    	return "_m_packuswb";
    case INTRINSIC_XED_IFORM_PUNPCKHBW_MMXq_MMXd:
    	return "_m_punpckhbw";
    case INTRINSIC_XED_IFORM_PUNPCKLBW_MMXq_MMXd:
    	return "_m_punpckhwd";
    case INTRINSIC_XED_IFORM_PUNPCKHDQ_MMXq_MMXd:
    	return "_m_punpckhdq";
    case INTRINSIC_XED_IFORM_PUNPCKLWD_MMXq_MMXd:
    	return "_m_punpcklwd";
    case INTRINSIC_XED_IFORM_PUNPCKLDQ_MMXq_MMXd:
    	return "_m_punpckldq";
    case INTRINSIC_XED_IFORM_PADDB_MMXq_MMXq:
    	return "_m_paddb";
    case INTRINSIC_XED_IFORM_PADDW_MMXq_MMXq:
    	return "_m_paddw";
    case INTRINSIC_XED_IFORM_PADDD_MMXq_MMXq:
    	return "_m_paddd";
    case INTRINSIC_XED_IFORM_PADDSB_MMXq_MMXq:
    	return "_m_paddsb";
    case INTRINSIC_XED_IFORM_PADDSW_MMXq_MMXq:
    	return "_m_paddsw";
    case INTRINSIC_XED_IFORM_PADDUSB_MMXq_MMXq:
    	return "_m_paddusb";
    case INTRINSIC_XED_IFORM_PADDUSW_MMXq_MMXq:
    	return "_m_paddusw";
    case INTRINSIC_XED_IFORM_PSUBB_MMXq_MMXq:
    	return "_m_psubb";
    case INTRINSIC_XED_IFORM_PSUBW_MMXq_MMXq:
    	return "_m_psubw";
    case INTRINSIC_XED_IFORM_PSUBD_MMXq_MMXq:
    	return "_m_psubd";
    case INTRINSIC_XED_IFORM_PSUBSB_MMXq_MMXq:
    	return "_m_psubsb";
    case INTRINSIC_XED_IFORM_PSUBSW_MMXq_MMXq:
    	return "_m_psubsw";
    case INTRINSIC_XED_IFORM_PSUBUSB_MMXq_MMXq:
    	return "_m_psubusb";
    case INTRINSIC_XED_IFORM_PSUBUSW_MMXq_MMXq:
    	return "_m_psubusw";
    case INTRINSIC_XED_IFORM_PMADDWD_MMXq_MMXq:
    	return "_m_pmaddwd";
    case INTRINSIC_XED_IFORM_PMULHW_MMXq_MMXq:
    	return "_m_pmulhw";
    case INTRINSIC_XED_IFORM_PMULLW_MMXq_MMXq:
    	return "_m_pmullw";
    case INTRINSIC_XED_IFORM_PSLLW_MMXq_MMXq:
    	return "_m_psllw";
    case INTRINSIC_XED_IFORM_PSLLW_MMXq_IMMb:
    	return "_m_psllwi";
    case INTRINSIC_XED_IFORM_PSLLD_MMXq_MMXq:
    	return "_m_pslld";
    case INTRINSIC_XED_IFORM_PSLLD_MMXq_IMMb:
    	return "_m_pslldi";
    case INTRINSIC_XED_IFORM_PSLLQ_MMXq_MMXq:
    	return "_m_psllq";
    case INTRINSIC_XED_IFORM_PSLLQ_MMXq_IMMb:
    	return "_m_psllqi";
    case INTRINSIC_XED_IFORM_PSRAW_MMXq_MMXq:
    	return "_m_psraw";
    case INTRINSIC_XED_IFORM_PSRAW_MMXq_IMMb:
    	return "_m_psrawi";
    case INTRINSIC_XED_IFORM_PSRAD_MMXq_MMXq:
    	return "_m_psrad";
    case INTRINSIC_XED_IFORM_PSRAD_MMXq_IMMb:
    	return "_m_psradi";
    case INTRINSIC_XED_IFORM_PSRLW_MMXq_MMXq:
    	return "_m_psrlw";
    case INTRINSIC_XED_IFORM_PSRLW_MMXq_IMMb:
    	return "_m_psrlwi";
    case INTRINSIC_XED_IFORM_PSRLD_MMXq_MMXq:
    	return "_m_psrld";
    case INTRINSIC_XED_IFORM_PSRLD_MMXq_IMMb:
    	return "_m_psrldi";
    case INTRINSIC_XED_IFORM_PSRLQ_MMXq_MMXq:
    	return "_m_psrlq";
    case INTRINSIC_XED_IFORM_PSRLQ_MMXq_IMMb:
    	return "_m_psrlqi";
    case INTRINSIC_XED_IFORM_PAND_MMXq_MMXq:
    	return "_m_pand";
    case INTRINSIC_XED_IFORM_PANDN_MMXq_MMXq:
    	return "_m_pandn";
    case INTRINSIC_XED_IFORM_POR_MMXq_MMXq:
    	return "_m_por";
    case INTRINSIC_XED_IFORM_PXOR_MMXq_MMXq:
    	return "_m_pxor";
    case INTRINSIC_XED_IFORM_PCMPEQB_MMXq_MMXq:
    	return "_m_pcmpeqb";
    case INTRINSIC_XED_IFORM_PCMPEQW_MMXq_MMXq:
    	return "_m_pcmpeqw";
    case INTRINSIC_XED_IFORM_PCMPEQD_MMXq_MMXq:
    	return "_m_pcmpeqd";
    case INTRINSIC_XED_IFORM_PCMPGTB_MMXq_MMXq:
    	return "_m_pcmpgtb";
    case INTRINSIC_XED_IFORM_PCMPGTW_MMXq_MMXq:
    	return "_m_pcmpgtw";
    case INTRINSIC_XED_IFORM_PCMPGTD_MMXq_MMXq:
    	return "_m_pcmpgtd";
    case INTRINSIC_XED_IFORM_MONITOR:
    	return "_mm_monitor";
    case INTRINSIC_XED_IFORM_MWAIT:
    	return "_mm_mwait";
    case INTRINSIC_XED_IFORM_MOVBE_GPRv_MEMv:
    	return "_loadbe_i16";
    case INTRINSIC_XED_IFORM_MOVBE_MEMv_GPRv:
    	return "_storebe_i16";
    case INTRINSIC_XED_IFORM_MOVDIR64B_GPRa_MEM:
    	return "_movdir64b";
    case INTRINSIC_XED_IFORM_MOVDIRI_MEMu64_GPR64u64:
    	return "_directstoreu_u64";
    case INTRINSIC_XED_IFORM_MOVDIRI_MEMu32_GPR32u32:
    	return "_directstoreu_u32";
    case INTRINSIC_XED_IFORM_BNDMK_BND_AGEN:
    	return "_bnd_set_ptr_bounds";
    case INTRINSIC_XED_IFORM_BNDSTX_MEMbnd64_BND:
    	return "_bnd_store_ptr_bounds";
    case INTRINSIC_XED_IFORM_BNDCL_BND_AGEN:
    	return "_bnd_chk_ptr_lbounds";
    case INTRINSIC_XED_IFORM_BNDCU_BND_AGEN:
    	return "_bnd_chk_ptr_ubounds";
    case INTRINSIC_XED_IFORM_BNDCN_BND_AGEN:
    	return "_bnd_chk_ptr_ubounds";
    case INTRINSIC_XED_IFORM_BSF_GPRv_GPRv:
    	return "_bit_scan_forward";
    case INTRINSIC_XED_IFORM_BSR_GPRv_GPRv:
    	return "_bit_scan_reverse";
    case INTRINSIC_XED_IFORM_BT_MEMv_GPRv:
    	return "_bittest";
    case INTRINSIC_XED_IFORM_BTC_MEMv_GPRv:
    	return "_bittestandcomplement";
    case INTRINSIC_XED_IFORM_BTR_MEMv_GPRv:
    	return "_bittestandreset";
    case INTRINSIC_XED_IFORM_BTS_MEMv_GPRv:
    	return "_bittestandset";
    case INTRINSIC_XED_IFORM_BT_GPRv_GPRv:
    	return "_bittest64";
    case INTRINSIC_XED_IFORM_BTC_GPRv_GPRv:
    	return "_bittestandcomplement64";
    case INTRINSIC_XED_IFORM_BTR_GPRv_GPRv:
    	return "_bittestandreset64";
    case INTRINSIC_XED_IFORM_BTS_GPRv_GPRv:
    	return "_bittestandset64";
    case INTRINSIC_XED_IFORM_BSWAP_GPRv:
    	return "_bswap";
    case INTRINSIC_XED_IFORM_ROL_GPRv_IMMb:
    	return "_lrotl";
    case INTRINSIC_XED_IFORM_ROR_GPRv_IMMb:
    	return "_lrotr";
    case INTRINSIC_XED_IFORM_RDPMC:
    	return "_rdpmc";
    case INTRINSIC_XED_IFORM_ADC_GPRv_GPRv_11:
    	return "_addcarry_u32";
    case INTRINSIC_XED_IFORM_SBB_GPRv_GPRv_19:
    	return "_subborrow_u32";
    case INTRINSIC_XED_IFORM_PTWRITE_GPRy:
    	return "_ptwrite32";
    case INTRINSIC_XED_IFORM_ENCLU:
    	return "_enclu_u32";
    case INTRINSIC_XED_IFORM_ENCLS:
    	return "_encls_u32";
    case INTRINSIC_XED_IFORM_ENCLV:
    	return "_enclv_u32";
    case INTRINSIC_XED_IFORM_WBINVD:
    	return "_wbinvd";
    case INTRINSIC_XED_IFORM_PCLMULQDQ_XMMdq_XMMdq_IMMb:
    	return "_mm_clmulepi64_si128";
    case INTRINSIC_XED_IFORM_PCONFIG:
    	return "_pconfig_u32";
    case INTRINSIC_XED_IFORM_PREFETCHWT1_MEMu8:
    	return "_mm_prefetch";
    case INTRINSIC_XED_IFORM_RDPID_GPR32u32:
    	return "_rdpid_u32";
    case INTRINSIC_XED_IFORM_RDRAND_GPRv:
    	return "_rdrand16_step";
    case INTRINSIC_XED_IFORM_RDSEED_GPRv:
    	return "_rdseed16_step";
    case INTRINSIC_XED_IFORM_RDTSCP:
    	return "__rdtscp";
    case INTRINSIC_XED_IFORM_XABORT_IMMb:
    	return "_xabort";
    case INTRINSIC_XED_IFORM_XBEGIN_RELBRz:
    	return "_xbegin";
    case INTRINSIC_XED_IFORM_XEND:
    	return "_xend";
    case INTRINSIC_XED_IFORM_XTEST:
    	return "_xtest";
    case INTRINSIC_XED_IFORM_SERIALIZE:
    	return "_serialize";
    case INTRINSIC_XED_IFORM_SHA1MSG1_XMMi32_XMMi32_SHA:
    	return "_mm_sha1msg1_epu32";
    case INTRINSIC_XED_IFORM_SHA1MSG2_XMMi32_XMMi32_SHA:
    	return "_mm_sha1msg2_epu32";
    case INTRINSIC_XED_IFORM_SHA1NEXTE_XMMi32_XMMi32_SHA:
    	return "_mm_sha1nexte_epu32";
    case INTRINSIC_XED_IFORM_SHA1RNDS4_XMMi32_XMMi32_IMM8_SHA:
    	return "_mm_sha1rnds4_epu32";
    case INTRINSIC_XED_IFORM_SHA256MSG1_XMMi32_XMMi32_SHA:
    	return "_mm_sha256msg1_epu32";
    case INTRINSIC_XED_IFORM_SHA256MSG2_XMMi32_XMMi32_SHA:
    	return "_mm_sha256msg2_epu32";
    case INTRINSIC_XED_IFORM_SHA256RNDS2_XMMi32_XMMi32_SHA:
    	return "_mm_sha256rnds2_epu32";
    case INTRINSIC_XED_IFORM_STMXCSR_MEMd:
    	return "_mm_getcsr";
    case INTRINSIC_XED_IFORM_LDMXCSR_MEMd:
    	return "_mm_setcsr";
    case INTRINSIC_XED_IFORM_PREFETCHNTA_MEMmprefetch:
    	return "_mm_prefetch";
    case INTRINSIC_XED_IFORM_PREFETCHT0_MEMmprefetch:
    	return "_mm_prefetch";
    case INTRINSIC_XED_IFORM_PREFETCHT1_MEMmprefetch:
    	return "_mm_prefetch";
    case INTRINSIC_XED_IFORM_PREFETCHT2_MEMmprefetch:
    	return "_mm_prefetch";
    case INTRINSIC_XED_IFORM_SFENCE:
    	return "_mm_sfence";
    case INTRINSIC_XED_IFORM_PMAXSW_MMXq_MMXq:
    	return "_mm_max_pi16";
    case INTRINSIC_XED_IFORM_PMAXUB_MMXq_MMXq:
    	return "_mm_max_pu8";
    case INTRINSIC_XED_IFORM_PMINSW_MMXq_MMXq:
    	return "_mm_min_pi16";
    case INTRINSIC_XED_IFORM_PMINUB_MMXq_MMXq:
    	return "_mm_min_pu8";
    case INTRINSIC_XED_IFORM_PMULHUW_MMXq_MMXq:
    	return "_mm_mulhi_pu16";
    case INTRINSIC_XED_IFORM_PAVGB_MMXq_MMXq:
    	return "_mm_avg_pu8";
    case INTRINSIC_XED_IFORM_PAVGW_MMXq_MMXq:
    	return "_mm_avg_pu16";
    case INTRINSIC_XED_IFORM_PSADBW_MMXq_MMXq:
    	return "_mm_sad_pu8";
    case INTRINSIC_XED_IFORM_CVTSI2SS_XMMss_GPR32d:
    	return "_mm_cvtsi32_ss";
    case INTRINSIC_XED_IFORM_CVTSI2SS_XMMss_GPR64q:
    	return "_mm_cvtsi64_ss";
    case INTRINSIC_XED_IFORM_CVTPI2PS_XMMq_MMXq:
    	return "_mm_cvtpi32_ps";
    case INTRINSIC_XED_IFORM_MOVNTQ_MEMq_MMXq:
    	return "_mm_stream_pi";
    case INTRINSIC_XED_IFORM_MASKMOVQ_MMXq_MMXq:
    	return "_mm_maskmove_si64";
    case INTRINSIC_XED_IFORM_PEXTRW_GPR32_MMXq_IMMb:
    	return "_mm_extract_pi16";
    case INTRINSIC_XED_IFORM_PINSRW_MMXq_GPR32_IMMb:
    	return "_mm_insert_pi16";
    case INTRINSIC_XED_IFORM_PMOVMSKB_GPR32_MMXq:
    	return "_mm_movemask_pi8";
    case INTRINSIC_XED_IFORM_PSHUFW_MMXq_MMXq_IMMb:
    	return "_mm_shuffle_pi16";
    case INTRINSIC_XED_IFORM_ADDSS_XMMss_XMMss:
    	return "_mm_add_ss";
    case INTRINSIC_XED_IFORM_ADDPS_XMMps_XMMps:
    	return "_mm_add_ps";
    case INTRINSIC_XED_IFORM_SUBSS_XMMss_XMMss:
    	return "_mm_sub_ss";
    case INTRINSIC_XED_IFORM_SUBPS_XMMps_XMMps:
    	return "_mm_sub_ps";
    case INTRINSIC_XED_IFORM_MULSS_XMMss_XMMss:
    	return "_mm_mul_ss";
    case INTRINSIC_XED_IFORM_MULPS_XMMps_XMMps:
    	return "_mm_mul_ps";
    case INTRINSIC_XED_IFORM_DIVSS_XMMss_XMMss:
    	return "_mm_div_ss";
    case INTRINSIC_XED_IFORM_DIVPS_XMMps_XMMps:
    	return "_mm_div_ps";
    case INTRINSIC_XED_IFORM_SQRTSS_XMMss_XMMss:
    	return "_mm_sqrt_ss";
    case INTRINSIC_XED_IFORM_SQRTPS_XMMps_XMMps:
    	return "_mm_sqrt_ps";
    case INTRINSIC_XED_IFORM_RCPSS_XMMss_XMMss:
    	return "_mm_rcp_ss";
    case INTRINSIC_XED_IFORM_RCPPS_XMMps_XMMps:
    	return "_mm_rcp_ps";
    case INTRINSIC_XED_IFORM_RSQRTSS_XMMss_XMMss:
    	return "_mm_rsqrt_ss";
    case INTRINSIC_XED_IFORM_RSQRTPS_XMMps_XMMps:
    	return "_mm_rsqrt_ps";
    case INTRINSIC_XED_IFORM_MINSS_XMMss_XMMss:
    	return "_mm_min_ss";
    case INTRINSIC_XED_IFORM_MINPS_XMMps_XMMps:
    	return "_mm_min_ps";
    case INTRINSIC_XED_IFORM_MAXSS_XMMss_XMMss:
    	return "_mm_max_ss";
    case INTRINSIC_XED_IFORM_MAXPS_XMMps_XMMps:
    	return "_mm_max_ps";
    case INTRINSIC_XED_IFORM_ANDPS_XMMxud_XMMxud:
    	return "_mm_and_ps";
    case INTRINSIC_XED_IFORM_ANDNPS_XMMxud_XMMxud:
    	return "_mm_andnot_ps";
    case INTRINSIC_XED_IFORM_ORPS_XMMxud_XMMxud:
    	return "_mm_or_ps";
    case INTRINSIC_XED_IFORM_XORPS_XMMxud_XMMxud:
    	return "_mm_xor_ps";
    case INTRINSIC_XED_IFORM_CMPSS_XMMss_XMMss_IMMb:
    	return "_mm_cmpeq_ss";
    case INTRINSIC_XED_IFORM_CMPPS_XMMps_XMMps_IMMb:
    	return "_mm_cmpeq_ps";
    case INTRINSIC_XED_IFORM_COMISS_XMMss_XMMss:
    	return "_mm_comieq_ss";
    case INTRINSIC_XED_IFORM_UCOMISS_XMMss_XMMss:
    	return "_mm_ucomieq_ss";
    case INTRINSIC_XED_IFORM_CVTSS2SI_GPR32d_XMMss:
    	return "_mm_cvtss_si32";
    case INTRINSIC_XED_IFORM_CVTSS2SI_GPR64q_XMMss:
    	return "_mm_cvtss_si64";
    case INTRINSIC_XED_IFORM_MOVSS_MEMss_XMMss:
    	return "_mm_cvtss_f32";
    case INTRINSIC_XED_IFORM_CVTPS2PI_MMXq_XMMq:
    	return "_mm_cvtps_pi32";
    case INTRINSIC_XED_IFORM_CVTTSS2SI_GPR32d_XMMss:
    	return "_mm_cvttss_si32";
    case INTRINSIC_XED_IFORM_CVTTSS2SI_GPR64q_XMMss:
    	return "_mm_cvttss_si64";
    case INTRINSIC_XED_IFORM_CVTTPS2PI_MMXq_XMMq:
    	return "_mm_cvttps_pi32";
    case INTRINSIC_XED_IFORM_MOVHPS_XMMq_MEMq:
    	return "_mm_loadh_pi";
    case INTRINSIC_XED_IFORM_MOVLPS_XMMq_MEMq:
    	return "_mm_loadl_pi";
    case INTRINSIC_XED_IFORM_MOVSS_XMMdq_MEMss:
    	return "_mm_load_ss";
    case INTRINSIC_XED_IFORM_MOVAPS_XMMps_MEMps:
    	return "_mm_load_ps";
    case INTRINSIC_XED_IFORM_MOVUPS_XMMps_MEMps:
    	return "_mm_loadu_ps";
    case INTRINSIC_XED_IFORM_MOVNTPS_MEMdq_XMMps:
    	return "_mm_stream_ps";
    case INTRINSIC_XED_IFORM_MOVHPS_MEMq_XMMps:
    	return "_mm_storeh_pi";
//    case INTRINSIC_XED_IFORM_MOVLPS_MEMq_XMMps:
//    	return "_mm_storel_pi";
    case INTRINSIC_XED_IFORM_MOVAPS_MEMps_XMMps:
    	return "_mm_store_ps";
    case INTRINSIC_XED_IFORM_MOVUPS_MEMps_XMMps:
    	return "_mm_storeu_ps";
    case INTRINSIC_XED_IFORM_MOVSS_XMMss_XMMss_0F10:
    	return "_mm_move_ss";
    case INTRINSIC_XED_IFORM_SHUFPS_XMMps_XMMps_IMMb:
    	return "_mm_shuffle_ps";
    case INTRINSIC_XED_IFORM_UNPCKHPS_XMMps_XMMdq:
    	return "_mm_unpackhi_ps";
    case INTRINSIC_XED_IFORM_UNPCKLPS_XMMps_XMMq:
    	return "_mm_unpacklo_ps";
    case INTRINSIC_XED_IFORM_MOVHLPS_XMMq_XMMq:
    	return "_mm_movehl_ps";
    case INTRINSIC_XED_IFORM_MOVLHPS_XMMq_XMMq:
    	return "_mm_movelh_ps";
    case INTRINSIC_XED_IFORM_MOVMSKPS_GPR32_XMMps:
    	return "_mm_movemask_ps";
    case INTRINSIC_XED_IFORM_MOVQ_XMMdq_MEMq_0F6E:
    	return "_mm_loadu_si64";
    case INTRINSIC_XED_IFORM_MOVQ_MEMq_XMMq_0F7E:
    	return "_mm_storeu_si64";
    case INTRINSIC_XED_IFORM_MOVD_XMMdq_MEMd:
    	return "_mm_loadu_si32";
    case INTRINSIC_XED_IFORM_MOVD_MEMd_XMMd:
    	return "_mm_storeu_si32";
    case INTRINSIC_XED_IFORM_PAUSE:
    	return "_mm_pause";
    case INTRINSIC_XED_IFORM_CLFLUSH_MEMmprefetch:
    	return "_mm_clflush";
    case INTRINSIC_XED_IFORM_LFENCE:
    	return "_mm_lfence";
    case INTRINSIC_XED_IFORM_MFENCE:
    	return "_mm_mfence";
    case INTRINSIC_XED_IFORM_PADDB_XMMdq_XMMdq:
    	return "_mm_add_epi8";
    case INTRINSIC_XED_IFORM_PADDW_XMMdq_XMMdq:
    	return "_mm_add_epi16";
    case INTRINSIC_XED_IFORM_PADDD_XMMdq_XMMdq:
    	return "_mm_add_epi32";
    case INTRINSIC_XED_IFORM_PADDQ_MMXq_MMXq:
    	return "_mm_add_si64";
    case INTRINSIC_XED_IFORM_PADDQ_XMMdq_XMMdq:
    	return "_mm_add_epi64";
    case INTRINSIC_XED_IFORM_PADDSB_XMMdq_XMMdq:
    	return "_mm_adds_epi8";
    case INTRINSIC_XED_IFORM_PADDSW_XMMdq_XMMdq:
    	return "_mm_adds_epi16";
    case INTRINSIC_XED_IFORM_PADDUSB_XMMdq_XMMdq:
    	return "_mm_adds_epu8";
    case INTRINSIC_XED_IFORM_PADDUSW_XMMdq_XMMdq:
    	return "_mm_adds_epu16";
    case INTRINSIC_XED_IFORM_PAVGB_XMMdq_XMMdq:
    	return "_mm_avg_epu8";
    case INTRINSIC_XED_IFORM_PAVGW_XMMdq_XMMdq:
    	return "_mm_avg_epu16";
    case INTRINSIC_XED_IFORM_PMADDWD_XMMdq_XMMdq:
    	return "_mm_madd_epi16";
    case INTRINSIC_XED_IFORM_PMAXSW_XMMdq_XMMdq:
    	return "_mm_max_epi16";
    case INTRINSIC_XED_IFORM_PMAXUB_XMMdq_XMMdq:
    	return "_mm_max_epu8";
    case INTRINSIC_XED_IFORM_PMINSW_XMMdq_XMMdq:
    	return "_mm_min_epi16";
    case INTRINSIC_XED_IFORM_PMINUB_XMMdq_XMMdq:
    	return "_mm_min_epu8";
    case INTRINSIC_XED_IFORM_PMULHW_XMMdq_XMMdq:
    	return "_mm_mulhi_epi16";
    case INTRINSIC_XED_IFORM_PMULHUW_XMMdq_XMMdq:
    	return "_mm_mulhi_epu16";
    case INTRINSIC_XED_IFORM_PMULLW_XMMdq_XMMdq:
    	return "_mm_mullo_epi16";
    case INTRINSIC_XED_IFORM_PMULUDQ_MMXq_MMXq:
    	return "_mm_mul_su32";
    case INTRINSIC_XED_IFORM_PMULUDQ_XMMdq_XMMdq:
    	return "_mm_mul_epu32";
    case INTRINSIC_XED_IFORM_PSADBW_XMMdq_XMMdq:
    	return "_mm_sad_epu8";
    case INTRINSIC_XED_IFORM_PSUBB_XMMdq_XMMdq:
    	return "_mm_sub_epi8";
    case INTRINSIC_XED_IFORM_PSUBW_XMMdq_XMMdq:
    	return "_mm_sub_epi16";
    case INTRINSIC_XED_IFORM_PSUBD_XMMdq_XMMdq:
    	return "_mm_sub_epi32";
    case INTRINSIC_XED_IFORM_PSUBQ_MMXq_MMXq:
    	return "_mm_sub_si64";
    case INTRINSIC_XED_IFORM_PSUBQ_XMMdq_XMMdq:
    	return "_mm_sub_epi64";
    case INTRINSIC_XED_IFORM_PSUBSB_XMMdq_XMMdq:
    	return "_mm_subs_epi8";
    case INTRINSIC_XED_IFORM_PSUBSW_XMMdq_XMMdq:
    	return "_mm_subs_epi16";
    case INTRINSIC_XED_IFORM_PSUBUSB_XMMdq_XMMdq:
    	return "_mm_subs_epu8";
    case INTRINSIC_XED_IFORM_PSUBUSW_XMMdq_XMMdq:
    	return "_mm_subs_epu16";
    case INTRINSIC_XED_IFORM_PSLLDQ_XMMdq_IMMb:
    	return "_mm_slli_si128";
    case INTRINSIC_XED_IFORM_PSRLDQ_XMMdq_IMMb:
    	return "_mm_bsrli_si128";
    case INTRINSIC_XED_IFORM_PSLLW_XMMdq_IMMb:
    	return "_mm_slli_epi16";
    case INTRINSIC_XED_IFORM_PSLLW_XMMdq_XMMdq:
    	return "_mm_sll_epi16";
    case INTRINSIC_XED_IFORM_PSLLD_XMMdq_IMMb:
    	return "_mm_slli_epi32";
    case INTRINSIC_XED_IFORM_PSLLD_XMMdq_XMMdq:
    	return "_mm_sll_epi32";
    case INTRINSIC_XED_IFORM_PSLLQ_XMMdq_IMMb:
    	return "_mm_slli_epi64";
    case INTRINSIC_XED_IFORM_PSLLQ_XMMdq_XMMdq:
    	return "_mm_sll_epi64";
    case INTRINSIC_XED_IFORM_PSRAW_XMMdq_IMMb:
    	return "_mm_srai_epi16";
    case INTRINSIC_XED_IFORM_PSRAW_XMMdq_XMMdq:
    	return "_mm_sra_epi16";
    case INTRINSIC_XED_IFORM_PSRAD_XMMdq_IMMb:
    	return "_mm_srai_epi32";
    case INTRINSIC_XED_IFORM_PSRAD_XMMdq_XMMdq:
    	return "_mm_sra_epi32";
    case INTRINSIC_XED_IFORM_PSRLW_XMMdq_IMMb:
    	return "_mm_srli_epi16";
    case INTRINSIC_XED_IFORM_PSRLW_XMMdq_XMMdq:
    	return "_mm_srl_epi16";
    case INTRINSIC_XED_IFORM_PSRLD_XMMdq_IMMb:
    	return "_mm_srli_epi32";
    case INTRINSIC_XED_IFORM_PSRLD_XMMdq_XMMdq:
    	return "_mm_srl_epi32";
    case INTRINSIC_XED_IFORM_PSRLQ_XMMdq_IMMb:
    	return "_mm_srli_epi64";
    case INTRINSIC_XED_IFORM_PSRLQ_XMMdq_XMMdq:
    	return "_mm_srl_epi64";
    case INTRINSIC_XED_IFORM_PAND_XMMdq_XMMdq:
    	return "_mm_and_si128";
    case INTRINSIC_XED_IFORM_PANDN_XMMdq_XMMdq:
    	return "_mm_andnot_si128";
    case INTRINSIC_XED_IFORM_POR_XMMdq_XMMdq:
    	return "_mm_or_si128";
    case INTRINSIC_XED_IFORM_PXOR_XMMdq_XMMdq:
    	return "_mm_xor_si128";
    case INTRINSIC_XED_IFORM_PCMPEQB_XMMdq_XMMdq:
    	return "_mm_cmpeq_epi8";
    case INTRINSIC_XED_IFORM_PCMPEQW_XMMdq_XMMdq:
    	return "_mm_cmpeq_epi16";
    case INTRINSIC_XED_IFORM_PCMPEQD_XMMdq_XMMdq:
    	return "_mm_cmpeq_epi32";
    case INTRINSIC_XED_IFORM_PCMPGTB_XMMdq_XMMdq:
    	return "_mm_cmpgt_epi8";
    case INTRINSIC_XED_IFORM_PCMPGTW_XMMdq_XMMdq:
    	return "_mm_cmpgt_epi16";
    case INTRINSIC_XED_IFORM_PCMPGTD_XMMdq_XMMdq:
    	return "_mm_cmpgt_epi32";
    case INTRINSIC_XED_IFORM_CVTDQ2PD_XMMpd_XMMq:
    	return "_mm_cvtepi32_pd";
    case INTRINSIC_XED_IFORM_CVTSI2SD_XMMsd_GPR32d:
    	return "_mm_cvtsi32_sd";
    case INTRINSIC_XED_IFORM_CVTSI2SD_XMMsd_GPR64q:
    	return "_mm_cvtsi64_sd";
    case INTRINSIC_XED_IFORM_CVTDQ2PS_XMMps_XMMdq:
    	return "_mm_cvtepi32_ps";
    case INTRINSIC_XED_IFORM_CVTPI2PD_XMMpd_MMXq:
    	return "_mm_cvtpi32_pd";
    case INTRINSIC_XED_IFORM_MOVD_XMMdq_GPR32:
    	return "_mm_cvtsi32_si128";
    case INTRINSIC_XED_IFORM_MOVQ_XMMdq_GPR64:
    	return "_mm_cvtsi64_si128";
    case INTRINSIC_XED_IFORM_MOVD_GPR32_XMMd:
    	return "_mm_cvtsi128_si32";
    case INTRINSIC_XED_IFORM_MOVQ_GPR64_XMMq:
    	return "_mm_cvtsi128_si64";
    case INTRINSIC_XED_IFORM_MOVQ_XMMdq_MEMq_0F7E:
    	return "_mm_loadl_epi64";
    case INTRINSIC_XED_IFORM_MOVDQA_XMMdq_MEMdq:
    	return "_mm_load_si128";
    case INTRINSIC_XED_IFORM_MOVDQU_XMMdq_MEMdq:
    	return "_mm_loadu_si128";
//    case INTRINSIC_XED_IFORM_MASKMOVDQU_XMMdq_XMMdq:
//    	return "_mm_maskmoveu_si128";
    case INTRINSIC_XED_IFORM_MOVDQA_MEMdq_XMMdq:
    	return "_mm_store_si128";
    case INTRINSIC_XED_IFORM_MOVDQU_MEMdq_XMMdq:
    	return "_mm_storeu_si128";
    case INTRINSIC_XED_IFORM_MOVNTDQ_MEMdq_XMMdq:
    	return "_mm_stream_si128";
    case INTRINSIC_XED_IFORM_MOVNTI_MEMd_GPR32:
    	return "_mm_stream_si32";
    case INTRINSIC_XED_IFORM_MOVNTI_MEMq_GPR64:
    	return "_mm_stream_si64";
    case INTRINSIC_XED_IFORM_MOVDQ2Q_MMXq_XMMq:
    	return "_mm_movepi64_pi64";
    case INTRINSIC_XED_IFORM_MOVQ2DQ_XMMdq_MMXq:
    	return "_mm_movpi64_epi64";
    case INTRINSIC_XED_IFORM_MOVQ_XMMdq_XMMq_0F7E:
    	return "_mm_move_epi64";
    case INTRINSIC_XED_IFORM_PACKSSWB_XMMdq_XMMdq:
    	return "_mm_packs_epi16";
    case INTRINSIC_XED_IFORM_PACKSSDW_XMMdq_XMMdq:
    	return "_mm_packs_epi32";
    case INTRINSIC_XED_IFORM_PACKUSWB_XMMdq_XMMdq:
    	return "_mm_packus_epi16";
    case INTRINSIC_XED_IFORM_PEXTRW_GPR32_XMMdq_IMMb:
    	return "_mm_extract_epi16";
    case INTRINSIC_XED_IFORM_PINSRW_XMMdq_GPR32_IMMb:
    	return "_mm_insert_epi16";
    case INTRINSIC_XED_IFORM_PMOVMSKB_GPR32_XMMdq:
    	return "_mm_movemask_epi8";
    case INTRINSIC_XED_IFORM_PSHUFD_XMMdq_XMMdq_IMMb:
    	return "_mm_shuffle_epi32";
    case INTRINSIC_XED_IFORM_PSHUFHW_XMMdq_XMMdq_IMMb:
    	return "_mm_shufflehi_epi16";
    case INTRINSIC_XED_IFORM_PSHUFLW_XMMdq_XMMdq_IMMb:
    	return "_mm_shufflelo_epi16";
    case INTRINSIC_XED_IFORM_PUNPCKHBW_XMMdq_XMMq:
    	return "_mm_unpackhi_epi8";
    case INTRINSIC_XED_IFORM_PUNPCKHWD_XMMdq_XMMq:
    	return "_mm_unpackhi_epi16";
    case INTRINSIC_XED_IFORM_PUNPCKHDQ_XMMdq_XMMq:
    	return "_mm_unpackhi_epi32";
    case INTRINSIC_XED_IFORM_PUNPCKHQDQ_XMMdq_XMMq:
    	return "_mm_unpackhi_epi64";
    case INTRINSIC_XED_IFORM_PUNPCKLBW_XMMdq_XMMq:
    	return "_mm_unpacklo_epi8";
    case INTRINSIC_XED_IFORM_PUNPCKLWD_XMMdq_XMMq:
    	return "_mm_unpacklo_epi16";
    case INTRINSIC_XED_IFORM_PUNPCKLDQ_XMMdq_XMMq:
    	return "_mm_unpacklo_epi32";
    case INTRINSIC_XED_IFORM_PUNPCKLQDQ_XMMdq_XMMq:
    	return "_mm_unpacklo_epi64";
    case INTRINSIC_XED_IFORM_ADDSD_XMMsd_XMMsd:
    	return "_mm_add_sd";
    case INTRINSIC_XED_IFORM_ADDPD_XMMpd_XMMpd:
    	return "_mm_add_pd";
    case INTRINSIC_XED_IFORM_DIVSD_XMMsd_XMMsd:
    	return "_mm_div_sd";
    case INTRINSIC_XED_IFORM_DIVPD_XMMpd_XMMpd:
    	return "_mm_div_pd";
    case INTRINSIC_XED_IFORM_MAXSD_XMMsd_XMMsd:
    	return "_mm_max_sd";
    case INTRINSIC_XED_IFORM_MAXPD_XMMpd_XMMpd:
    	return "_mm_max_pd";
    case INTRINSIC_XED_IFORM_MINSD_XMMsd_XMMsd:
    	return "_mm_min_sd";
    case INTRINSIC_XED_IFORM_MINPD_XMMpd_XMMpd:
    	return "_mm_min_pd";
    case INTRINSIC_XED_IFORM_MULSD_XMMsd_XMMsd:
    	return "_mm_mul_sd";
    case INTRINSIC_XED_IFORM_MULPD_XMMpd_XMMpd:
    	return "_mm_mul_pd";
    case INTRINSIC_XED_IFORM_SQRTSD_XMMsd_XMMsd:
    	return "_mm_sqrt_sd";
    case INTRINSIC_XED_IFORM_SQRTPD_XMMpd_XMMpd:
    	return "_mm_sqrt_pd";
    case INTRINSIC_XED_IFORM_SUBSD_XMMsd_XMMsd:
    	return "_mm_sub_sd";
    case INTRINSIC_XED_IFORM_SUBPD_XMMpd_XMMpd:
    	return "_mm_sub_pd";
    case INTRINSIC_XED_IFORM_ANDPD_XMMxuq_XMMxuq:
    	return "_mm_and_pd";
    case INTRINSIC_XED_IFORM_ANDNPD_XMMxuq_XMMxuq:
    	return "_mm_andnot_pd";
    case INTRINSIC_XED_IFORM_ORPD_XMMxuq_XMMxuq:
    	return "_mm_or_pd";
    case INTRINSIC_XED_IFORM_XORPD_XMMxuq_XMMxuq:
    	return "_mm_xor_pd";
    case INTRINSIC_XED_IFORM_CMPSD_XMM_XMMsd_XMMsd_IMMb:
    	return "_mm_cmpeq_sd";
    case INTRINSIC_XED_IFORM_CMPPD_XMMpd_XMMpd_IMMb:
    	return "_mm_cmpeq_pd";
    case INTRINSIC_XED_IFORM_COMISD_XMMsd_XMMsd:
    	return "_mm_comieq_sd";
    case INTRINSIC_XED_IFORM_UCOMISD_XMMsd_XMMsd:
    	return "_mm_ucomieq_sd";
    case INTRINSIC_XED_IFORM_CVTPD2PS_XMMps_XMMpd:
    	return "_mm_cvtpd_ps";
    case INTRINSIC_XED_IFORM_CVTPS2PD_XMMpd_XMMq:
    	return "_mm_cvtps_pd";
    case INTRINSIC_XED_IFORM_CVTPD2DQ_XMMdq_XMMpd:
    	return "_mm_cvtpd_epi32";
    case INTRINSIC_XED_IFORM_CVTSD2SI_GPR32d_XMMsd:
    	return "_mm_cvtsd_si32";
    case INTRINSIC_XED_IFORM_CVTSD2SI_GPR64q_XMMsd:
    	return "_mm_cvtsd_si64";
    case INTRINSIC_XED_IFORM_CVTSD2SS_XMMss_XMMsd:
    	return "_mm_cvtsd_ss";
    case INTRINSIC_XED_IFORM_MOVSD_XMM_MEMsd_XMMsd:
    	return "_mm_cvtsd_f64";
    case INTRINSIC_XED_IFORM_CVTSS2SD_XMMsd_XMMss:
    	return "_mm_cvtss_sd";
    case INTRINSIC_XED_IFORM_CVTTPD2DQ_XMMdq_XMMpd:
    	return "_mm_cvttpd_epi32";
    case INTRINSIC_XED_IFORM_CVTTSD2SI_GPR32d_XMMsd:
    	return "_mm_cvttsd_si32";
    case INTRINSIC_XED_IFORM_CVTTSD2SI_GPR64q_XMMsd:
    	return "_mm_cvttsd_si64";
    case INTRINSIC_XED_IFORM_CVTPS2DQ_XMMdq_XMMps:
    	return "_mm_cvtps_epi32";
    case INTRINSIC_XED_IFORM_CVTTPS2DQ_XMMdq_XMMps:
    	return "_mm_cvttps_epi32";
    case INTRINSIC_XED_IFORM_CVTPD2PI_MMXq_XMMpd:
    	return "_mm_cvtpd_pi32";
    case INTRINSIC_XED_IFORM_CVTTPD2PI_MMXq_XMMpd:
    	return "_mm_cvttpd_pi32";
    case INTRINSIC_XED_IFORM_MOVAPD_XMMpd_MEMpd:
    	return "_mm_load_pd";
    case INTRINSIC_XED_IFORM_MOVUPD_XMMpd_MEMpd:
    	return "_mm_loadu_pd";
    case INTRINSIC_XED_IFORM_MOVSD_XMM_XMMdq_MEMsd:
    	return "_mm_load_sd";
    case INTRINSIC_XED_IFORM_MOVHPD_XMMsd_MEMq:
    	return "_mm_loadh_pd";
    case INTRINSIC_XED_IFORM_MOVLPD_XMMsd_MEMq:
    	return "_mm_loadl_pd";
    case INTRINSIC_XED_IFORM_MOVNTPD_MEMdq_XMMpd:
    	return "_mm_stream_pd";
    case INTRINSIC_XED_IFORM_MOVAPD_MEMpd_XMMpd:
    	return "_mm_store_pd";
    case INTRINSIC_XED_IFORM_MOVUPD_MEMpd_XMMpd:
    	return "_mm_storeu_pd";
    case INTRINSIC_XED_IFORM_MOVHPD_MEMq_XMMsd:
    	return "_mm_storeh_pd";
    case INTRINSIC_XED_IFORM_MOVLPD_MEMq_XMMsd:
    	return "_mm_storel_pd";
    case INTRINSIC_XED_IFORM_UNPCKHPD_XMMpd_XMMq:
    	return "_mm_unpackhi_pd";
    case INTRINSIC_XED_IFORM_UNPCKLPD_XMMpd_XMMq:
    	return "_mm_unpacklo_pd";
    case INTRINSIC_XED_IFORM_MOVMSKPD_GPR32_XMMpd:
    	return "_mm_movemask_pd";
    case INTRINSIC_XED_IFORM_SHUFPD_XMMpd_XMMpd_IMMb:
    	return "_mm_shuffle_pd";
    case INTRINSIC_XED_IFORM_MOVSD_XMM_XMMsd_XMMsd_0F10:
    	return "_mm_move_sd";
    case INTRINSIC_XED_IFORM_ADDSUBPS_XMMps_XMMps:
    	return "_mm_addsub_ps";
    case INTRINSIC_XED_IFORM_ADDSUBPD_XMMpd_XMMpd:
    	return "_mm_addsub_pd";
    case INTRINSIC_XED_IFORM_HADDPD_XMMpd_XMMpd:
    	return "_mm_hadd_pd";
    case INTRINSIC_XED_IFORM_HADDPS_XMMps_XMMps:
    	return "_mm_hadd_ps";
    case INTRINSIC_XED_IFORM_HSUBPD_XMMpd_XMMpd:
    	return "_mm_hsub_pd";
    case INTRINSIC_XED_IFORM_HSUBPS_XMMps_XMMps:
    	return "_mm_hsub_ps";
    case INTRINSIC_XED_IFORM_LDDQU_XMMpd_MEMdq:
    	return "_mm_lddqu_si128";
    case INTRINSIC_XED_IFORM_MOVDDUP_XMMdq_MEMq:
    	return "_mm_loaddup_pd";
    case INTRINSIC_XED_IFORM_MOVSHDUP_XMMps_XMMps:
    	return "_mm_movehdup_ps";
    case INTRINSIC_XED_IFORM_MOVSLDUP_XMMps_XMMps:
    	return "_mm_moveldup_ps";
    case INTRINSIC_XED_IFORM_BLENDPD_XMMdq_XMMdq_IMMb:
    	return "_mm_blend_pd";
    case INTRINSIC_XED_IFORM_BLENDPS_XMMdq_XMMdq_IMMb:
    	return "_mm_blend_ps";
    case INTRINSIC_XED_IFORM_BLENDVPD_XMMdq_XMMdq:
    	return "_mm_blendv_pd";
    case INTRINSIC_XED_IFORM_BLENDVPS_XMMdq_XMMdq:
    	return "_mm_blendv_ps";
    case INTRINSIC_XED_IFORM_PBLENDVB_XMMdq_XMMdq:
    	return "_mm_blendv_epi8";
    case INTRINSIC_XED_IFORM_PBLENDW_XMMdq_XMMdq_IMMb:
    	return "_mm_blend_epi16";
    case INTRINSIC_XED_IFORM_DPPD_XMMdq_XMMdq_IMMb:
    	return "_mm_dp_pd";
    case INTRINSIC_XED_IFORM_DPPS_XMMdq_XMMdq_IMMb:
    	return "_mm_dp_ps";
    case INTRINSIC_XED_IFORM_EXTRACTPS_GPR32d_XMMdq_IMMb:
    	return "_mm_extract_ps";
    case INTRINSIC_XED_IFORM_PEXTRB_GPR32d_XMMdq_IMMb:
    	return "_mm_extract_epi8";
    case INTRINSIC_XED_IFORM_PEXTRD_GPR32d_XMMdq_IMMb:
    	return "_mm_extract_epi32";
    case INTRINSIC_XED_IFORM_PEXTRQ_GPR64q_XMMdq_IMMb:
    	return "_mm_extract_epi64";
    case INTRINSIC_XED_IFORM_INSERTPS_XMMps_XMMps_IMMb:
    	return "_mm_insert_ps";
    case INTRINSIC_XED_IFORM_PINSRB_XMMdq_GPR32d_IMMb:
    	return "_mm_insert_epi8";
    case INTRINSIC_XED_IFORM_PINSRD_XMMdq_GPR32d_IMMb:
    	return "_mm_insert_epi32";
    case INTRINSIC_XED_IFORM_PINSRQ_XMMdq_GPR64q_IMMb:
    	return "_mm_insert_epi64";
    case INTRINSIC_XED_IFORM_PMAXSB_XMMdq_XMMdq:
    	return "_mm_max_epi8";
    case INTRINSIC_XED_IFORM_PMAXSD_XMMdq_XMMdq:
    	return "_mm_max_epi32";
    case INTRINSIC_XED_IFORM_PMAXUD_XMMdq_XMMdq:
    	return "_mm_max_epu32";
    case INTRINSIC_XED_IFORM_PMAXUW_XMMdq_XMMdq:
    	return "_mm_max_epu16";
    case INTRINSIC_XED_IFORM_PMINSB_XMMdq_XMMdq:
    	return "_mm_min_epi8";
    case INTRINSIC_XED_IFORM_PMINSD_XMMdq_XMMdq:
    	return "_mm_min_epi32";
    case INTRINSIC_XED_IFORM_PMINUD_XMMdq_XMMdq:
    	return "_mm_min_epu32";
    case INTRINSIC_XED_IFORM_PMINUW_XMMdq_XMMdq:
    	return "_mm_min_epu16";
    case INTRINSIC_XED_IFORM_PACKUSDW_XMMdq_XMMdq:
    	return "_mm_packus_epi32";
    case INTRINSIC_XED_IFORM_PCMPEQQ_XMMdq_XMMdq:
    	return "_mm_cmpeq_epi64";
    case INTRINSIC_XED_IFORM_PMOVSXBW_XMMdq_XMMq:
    	return "_mm_cvtepi8_epi16";
    case INTRINSIC_XED_IFORM_PMOVSXBD_XMMdq_XMMd:
    	return "_mm_cvtepi8_epi32";
    case INTRINSIC_XED_IFORM_PMOVSXBQ_XMMdq_XMMw:
    	return "_mm_cvtepi8_epi64";
    case INTRINSIC_XED_IFORM_PMOVSXWD_XMMdq_XMMq:
    	return "_mm_cvtepi16_epi32";
    case INTRINSIC_XED_IFORM_PMOVSXWQ_XMMdq_XMMd:
    	return "_mm_cvtepi16_epi64";
    case INTRINSIC_XED_IFORM_PMOVSXDQ_XMMdq_XMMq:
    	return "_mm_cvtepi32_epi64";
    case INTRINSIC_XED_IFORM_PMOVZXBW_XMMdq_XMMq:
    	return "_mm_cvtepu8_epi16";
    case INTRINSIC_XED_IFORM_PMOVZXBD_XMMdq_XMMd:
    	return "_mm_cvtepu8_epi32";
    case INTRINSIC_XED_IFORM_PMOVZXBQ_XMMdq_XMMw:
    	return "_mm_cvtepu8_epi64";
    case INTRINSIC_XED_IFORM_PMOVZXWD_XMMdq_XMMq:
    	return "_mm_cvtepu16_epi32";
    case INTRINSIC_XED_IFORM_PMOVZXWQ_XMMdq_XMMd:
    	return "_mm_cvtepu16_epi64";
    case INTRINSIC_XED_IFORM_PMOVZXDQ_XMMdq_XMMq:
    	return "_mm_cvtepu32_epi64";
    case INTRINSIC_XED_IFORM_PMULDQ_XMMdq_XMMdq:
    	return "_mm_mul_epi32";
    case INTRINSIC_XED_IFORM_PMULLD_XMMdq_XMMdq:
    	return "_mm_mullo_epi32";
    case INTRINSIC_XED_IFORM_PTEST_XMMdq_XMMdq:
    	return "_mm_testz_si128";
    case INTRINSIC_XED_IFORM_ROUNDPD_XMMpd_XMMpd_IMMb:
    	return "_mm_round_pd";
    case INTRINSIC_XED_IFORM_ROUNDPS_XMMps_XMMps_IMMb:
    	return "_mm_round_ps";
    case INTRINSIC_XED_IFORM_ROUNDSD_XMMq_XMMq_IMMb:
    	return "_mm_round_sd";
    case INTRINSIC_XED_IFORM_ROUNDSS_XMMd_XMMd_IMMb:
    	return "_mm_round_ss";
    case INTRINSIC_XED_IFORM_PHMINPOSUW_XMMdq_XMMdq:
    	return "_mm_minpos_epu16";
    case INTRINSIC_XED_IFORM_MPSADBW_XMMdq_XMMdq_IMMb:
    	return "_mm_mpsadbw_epu8";
    case INTRINSIC_XED_IFORM_MOVNTDQA_XMMdq_MEMdq:
    	return "_mm_stream_load_si128";
    case INTRINSIC_XED_IFORM_PCMPISTRM_XMMdq_XMMdq_IMMb:
    	return "_mm_cmpistrm";
    case INTRINSIC_XED_IFORM_PCMPISTRI_XMMdq_XMMdq_IMMb:
    	return "_mm_cmpistri";
    case INTRINSIC_XED_IFORM_PCMPESTRM_XMMdq_XMMdq_IMMb:
    	return "_mm_cmpestrm";
    case INTRINSIC_XED_IFORM_PCMPESTRI_XMMdq_XMMdq_IMMb:
    	return "_mm_cmpestri";
    case INTRINSIC_XED_IFORM_PCMPGTQ_XMMdq_XMMdq:
    	return "_mm_cmpgt_epi64";
    case INTRINSIC_XED_IFORM_CRC32_GPRyy_GPR8b:
    	return "_mm_crc32_u8";
    case INTRINSIC_XED_IFORM_CRC32_GPRyy_GPRv:
    	return "_mm_crc32_u16";
    case INTRINSIC_XED_IFORM_PABSB_MMXq_MMXq:
    	return "_mm_abs_pi8";
    case INTRINSIC_XED_IFORM_PABSB_XMMdq_XMMdq:
    	return "_mm_abs_epi8";
    case INTRINSIC_XED_IFORM_PABSW_MMXq_MMXq:
    	return "_mm_abs_pi16";
    case INTRINSIC_XED_IFORM_PABSW_XMMdq_XMMdq:
    	return "_mm_abs_epi16";
    case INTRINSIC_XED_IFORM_PABSD_MMXq_MMXq:
    	return "_mm_abs_pi32";
    case INTRINSIC_XED_IFORM_PABSD_XMMdq_XMMdq:
    	return "_mm_abs_epi32";
    case INTRINSIC_XED_IFORM_PSHUFB_XMMdq_XMMdq:
    	return "_mm_shuffle_epi8";
    case INTRINSIC_XED_IFORM_PSHUFB_MMXq_MMXq:
    	return "_mm_shuffle_pi8";
    case INTRINSIC_XED_IFORM_PALIGNR_XMMdq_XMMdq_IMMb:
    	return "_mm_alignr_epi8";
    case INTRINSIC_XED_IFORM_PALIGNR_MMXq_MMXq_IMMb:
    	return "_mm_alignr_pi8";
    case INTRINSIC_XED_IFORM_PHADDW_XMMdq_XMMdq:
    	return "_mm_hadd_epi16";
    case INTRINSIC_XED_IFORM_PHADDSW_XMMdq_XMMdq:
    	return "_mm_hadds_epi16";
    case INTRINSIC_XED_IFORM_PHADDD_XMMdq_XMMdq:
    	return "_mm_hadd_epi32";
    case INTRINSIC_XED_IFORM_PHADDW_MMXq_MMXq:
    	return "_mm_hadd_pi16";
    case INTRINSIC_XED_IFORM_PHADDSW_MMXq_MMXq:
    	return "_mm_hadds_pi16";
    case INTRINSIC_XED_IFORM_PHSUBW_XMMdq_XMMdq:
    	return "_mm_hsub_epi16";
    case INTRINSIC_XED_IFORM_PHSUBSW_XMMdq_XMMdq:
    	return "_mm_hsubs_epi16";
    case INTRINSIC_XED_IFORM_PHSUBD_XMMdq_XMMdq:
    	return "_mm_hsub_epi32";
    case INTRINSIC_XED_IFORM_PHSUBW_MMXq_MMXq:
    	return "_mm_hsub_pi16";
    case INTRINSIC_XED_IFORM_PHSUBD_MMXq_MMXq:
    	return "_mm_hsub_pi32";
    case INTRINSIC_XED_IFORM_PHSUBSW_MMXq_MMXq:
    	return "_mm_hsubs_pi16";
    case INTRINSIC_XED_IFORM_PMADDUBSW_XMMdq_XMMdq:
    	return "_mm_maddubs_epi16";
    case INTRINSIC_XED_IFORM_PMADDUBSW_MMXq_MMXq:
    	return "_mm_maddubs_pi16";
    case INTRINSIC_XED_IFORM_PMULHRSW_XMMdq_XMMdq:
    	return "_mm_mulhrs_epi16";
    case INTRINSIC_XED_IFORM_PMULHRSW_MMXq_MMXq:
    	return "_mm_mulhrs_pi16";
    case INTRINSIC_XED_IFORM_PSIGNB_XMMdq_XMMdq:
    	return "_mm_sign_epi8";
    case INTRINSIC_XED_IFORM_PSIGNW_XMMdq_XMMdq:
    	return "_mm_sign_epi16";
    case INTRINSIC_XED_IFORM_PSIGND_XMMdq_XMMdq:
    	return "_mm_sign_epi32";
    case INTRINSIC_XED_IFORM_PSIGNB_MMXq_MMXq:
    	return "_mm_sign_pi8";
    case INTRINSIC_XED_IFORM_PSIGNW_MMXq_MMXq:
    	return "_mm_sign_pi16";
    case INTRINSIC_XED_IFORM_PSIGND_MMXq_MMXq:
    	return "_mm_sign_pi32";
    case INTRINSIC_XED_IFORM_RDTSC:
    	return "_rdtsc";
    case INTRINSIC_XED_IFORM_XSUSLDTRK:
    	return "_xsusldtrk";
    case INTRINSIC_XED_IFORM_XRESLDTRK:
    	return "_xresldtrk";
    case INTRINSIC_XED_IFORM_VAESENCLAST_YMMu128_YMMu128_YMMu128:
    	return "_mm256_aesenclast_epi128";
    case INTRINSIC_XED_IFORM_VAESENC_YMMu128_YMMu128_YMMu128:
    	return "_mm256_aesenc_epi128";
    case INTRINSIC_XED_IFORM_VAESDECLAST_YMMu128_YMMu128_YMMu128:
    	return "_mm256_aesdeclast_epi128";
    case INTRINSIC_XED_IFORM_VAESDEC_YMMu128_YMMu128_YMMu128:
    	return "_mm256_aesdec_epi128";
    case INTRINSIC_XED_IFORM_VPCLMULQDQ_ZMMu128_ZMMu64_ZMMu64_IMM8_AVX512:
    	return "_mm512_clmulepi64_epi128";
    case INTRINSIC_XED_IFORM_VPCLMULQDQ_YMMu128_YMMu64_YMMu64_IMM8_AVX512:
    	return "_mm256_clmulepi64_epi128";
    case INTRINSIC_XED_IFORM_TPAUSE_GPR32u32:
    	return "_tpause";
    case INTRINSIC_XED_IFORM_UMWAIT_GPR32:
    	return "_umwait";
    case INTRINSIC_XED_IFORM_UMONITOR_GPRa:
    	return "_umonitor";
    case INTRINSIC_XED_IFORM_WBNOINVD:
    	return "_wbnoinvd";
    case INTRINSIC_XED_IFORM_XGETBV:
    	return "_xgetbv";
    case INTRINSIC_XED_IFORM_XRSTOR_MEMmxsave:
    	return "_xrstor";
    case INTRINSIC_XED_IFORM_XRSTOR64_MEMmxsave:
    	return "_xrstor64";
    case INTRINSIC_XED_IFORM_XSAVE_MEMmxsave:
    	return "_xsave";
    case INTRINSIC_XED_IFORM_XSAVE64_MEMmxsave:
    	return "_xsave64";
    case INTRINSIC_XED_IFORM_XSAVEOPT_MEMmxsave:
    	return "_xsaveopt";
    case INTRINSIC_XED_IFORM_XSAVEOPT64_MEMmxsave:
    	return "_xsaveopt64";
    case INTRINSIC_XED_IFORM_XSETBV:
    	return "_xsetbv";
    case INTRINSIC_XED_IFORM_XSAVEC_MEMmxsave:
    	return "_xsavec";
    case INTRINSIC_XED_IFORM_XSAVES_MEMmxsave:
    	return "_xsaves";
    case INTRINSIC_XED_IFORM_XSAVEC64_MEMmxsave:
    	return "_xsavec64";
    case INTRINSIC_XED_IFORM_XRSTORS_MEMmxsave:
    	return "_xrstors";
    case INTRINSIC_XED_IFORM_XRSTORS64_MEMmxsave:
    	return "_xrstors64";

    // below are modified iforms
    case INTRINSIC_XED_IFORM_TZCNT_GPR16_GPRMEM16:
        return "_tzcnt_u16";
    case INTRINSIC_XED_IFORM_TZCNT_GPR32_GPRMEM32:
        return "_tzcnt_u32";
    case INTRINSIC_XED_IFORM_TZCNT_GPR64_GPRMEM64:
        return "_tzcnt_u64";

    case INTRINSIC_XED_IFORM_LZCNT_GPR16_GPRMEM16:
        return "_lzcnt_u16";
    case INTRINSIC_XED_IFORM_LZCNT_GPR32_GPRMEM32:
        return "_lzcnt_u32";
    case INTRINSIC_XED_IFORM_LZCNT_GPR64_GPRMEM64:
        return "_lzcnt_u64";

    case INTRINSIC_XED_IFORM_POPCNT_GPR16_GPRMEM16:
        return "_popcnt_u16";
    case INTRINSIC_XED_IFORM_POPCNT_GPR32_GPRMEM32:
        return "_popcnt_u32";
    case INTRINSIC_XED_IFORM_POPCNT_GPR64_GPRMEM64:
        return "_popcnt_u64";

    case INTRINSIC_XED_IFORM_REP_MOVSB:
        return "__memcpy_u8";
    case INTRINSIC_XED_IFORM_REP_MOVSW:
        return "__memcpy_u16";
    case INTRINSIC_XED_IFORM_REP_MOVSD:
        return "__memcpy_u32";
    case INTRINSIC_XED_IFORM_REP_MOVSQ:
        return "__memcpy_u64";

    case INTRINSIC_XED_IFORM_REP_STOSB:
        return "__memfill_u8";
    case INTRINSIC_XED_IFORM_REP_STOSW:
        return "__memfill_u16";
    case INTRINSIC_XED_IFORM_REP_STOSD:
        return "__memfill_u32";
    case INTRINSIC_XED_IFORM_REP_STOSQ:
        return "__memfill_u64";

    default:
        // for iform without a corresponding intrisic, use the iform string
        string iformString = xed_iform_enum_t2str((xed_iform_enum_t(intrinsic - 1000)));
        for(char& c : iformString)
            c = tolower(c);
        return string("__") + iformString;
    }
}

vector<uint32_t> X86CommonArchitecture::GetAllIntrinsics()
{
    vector<uint32_t> allIntrinsics = { INTRINSIC_F2XM1, INTRINSIC_FBLD, INTRINSIC_FBST , INTRINSIC_FSIN,
        INTRINSIC_FCOS, INTRINSIC_FSINCOS, INTRINSIC_FPATAN, INTRINSIC_FPREM, INTRINSIC_FPREM1,
        INTRINSIC_FPTAN, INTRINSIC_FSCALE, INTRINSIC_FXAM, INTRINSIC_FXTRACT, INTRINSIC_FYL2X,
        INTRINSIC_FYL2XP1};

    allIntrinsics.reserve(allIntrinsics.size() + INTRINSIC_LAST - INTRINSIC_XED_IFORM_INVALID + 1);
    for (uint32_t value = INTRINSIC_XED_IFORM_INVALID;
            value <= INTRINSIC_LAST; value++)
        allIntrinsics.emplace_back(value);

    return allIntrinsics;
}

vector<NameAndType> X86CommonArchitecture::GetIntrinsicInputs(uint32_t intrinsic)
{
    switch (intrinsic)
    {
    case INTRINSIC_F2XM1:
    case INTRINSIC_FBST:
    case INTRINSIC_FSIN:
    case INTRINSIC_FCOS:
    case INTRINSIC_FSINCOS:
    case INTRINSIC_FPTAN:
    case INTRINSIC_FXAM:
    case INTRINSIC_FXTRACT:
        return vector<NameAndType> { NameAndType(Type::FloatType(10)) };
    case INTRINSIC_FBLD:
        return vector<NameAndType> { NameAndType(Type::IntegerType(10, false)) };
    case INTRINSIC_FPATAN:
    case INTRINSIC_FYL2X:
    case INTRINSIC_FYL2XP1:
        return vector<NameAndType> { NameAndType("x", Type::FloatType(10)), NameAndType("y", Type::FloatType(10)) };
    case INTRINSIC_FPREM:
    case INTRINSIC_FPREM1:
    case INTRINSIC_FSCALE:
        return vector<NameAndType> { NameAndType(Type::FloatType(10)), NameAndType(Type::FloatType(10)) };
    case INTRINSIC_XED_IFORM_TZCNT_GPR64_GPRMEM64:
        return vector<NameAndType> { NameAndType(Type::IntegerType(8, false)) };
    case INTRINSIC_XED_IFORM_TZCNT_GPR32_GPRMEM32:
        return vector<NameAndType> { NameAndType(Type::IntegerType(4, false)) };
    case INTRINSIC_XED_IFORM_TZCNT_GPR16_GPRMEM16:
        return vector<NameAndType> { NameAndType(Type::IntegerType(2, false)) };

    case INTRINSIC_XED_IFORM_LZCNT_GPR64_GPRMEM64:
        return vector<NameAndType> { NameAndType(Type::IntegerType(8, false)) };
    case INTRINSIC_XED_IFORM_LZCNT_GPR32_GPRMEM32:
        return vector<NameAndType> { NameAndType(Type::IntegerType(4, false)) };
    case INTRINSIC_XED_IFORM_LZCNT_GPR16_GPRMEM16:
        return vector<NameAndType> { NameAndType(Type::IntegerType(2, false)) };

    case INTRINSIC_XED_IFORM_POPCNT_GPR64_GPRMEM64:
        return vector<NameAndType> { NameAndType(Type::IntegerType(8, false)) };
    case INTRINSIC_XED_IFORM_POPCNT_GPR32_GPRMEM32:
        return vector<NameAndType> { NameAndType(Type::IntegerType(4, false)) };
    case INTRINSIC_XED_IFORM_POPCNT_GPR16_GPRMEM16:
        return vector<NameAndType> { NameAndType(Type::IntegerType(2, false)) };

    #include "x86_intrinsic_input_type.include"

    default:
        return vector<NameAndType>();
    }
}

vector<Confidence<Ref<Type>>> X86CommonArchitecture::GetIntrinsicOutputs(uint32_t intrinsic)
{
    switch (intrinsic)
    {
    case INTRINSIC_F2XM1:
    case INTRINSIC_FBLD:
    case INTRINSIC_FPATAN:
    case INTRINSIC_FSCALE:
    case INTRINSIC_FYL2X:
    case INTRINSIC_FYL2XP1:
        return vector<Confidence<Ref<Type>>> { Type::FloatType(10) };
    case INTRINSIC_FBST:
        return vector<Confidence<Ref<Type>>> { Type::IntegerType(10, false) };
    case INTRINSIC_FSIN:
    case INTRINSIC_FCOS:
    case INTRINSIC_FPTAN:
        return vector<Confidence<Ref<Type>>> { Type::FloatType(10), Type::BoolType() };
    case INTRINSIC_FSINCOS:
        return vector<Confidence<Ref<Type>>> { Type::FloatType(10), Type::FloatType(10), Type::BoolType() };
    case INTRINSIC_FPREM:
    case INTRINSIC_FPREM1:
        return vector<Confidence<Ref<Type>>> { Type::FloatType(10), Type::BoolType(), Type::IntegerType(1, false) };
    case INTRINSIC_FXAM:
        return vector<Confidence<Ref<Type>>> { Type::BoolType(), Type::BoolType(), Type::BoolType(), Type::BoolType() };
    case INTRINSIC_FXTRACT:
        return vector<Confidence<Ref<Type>>> { Type::FloatType(10), Type::FloatType(10) };

    case INTRINSIC_XED_IFORM_TZCNT_GPR64_GPRMEM64:
        return vector<Confidence<Ref<Type>>> { Type::IntegerType(8, false)};
    case INTRINSIC_XED_IFORM_TZCNT_GPR32_GPRMEM32:
        return vector<Confidence<Ref<Type>>> { Type::IntegerType(4, false)};
    case INTRINSIC_XED_IFORM_TZCNT_GPR16_GPRMEM16:
        return vector<Confidence<Ref<Type>>> { Type::IntegerType(2, false)};

    case INTRINSIC_XED_IFORM_LZCNT_GPR64_GPRMEM64:
        return vector<Confidence<Ref<Type>>> { Type::IntegerType(8, false)};
    case INTRINSIC_XED_IFORM_LZCNT_GPR32_GPRMEM32:
        return vector<Confidence<Ref<Type>>> { Type::IntegerType(4, false)};
    case INTRINSIC_XED_IFORM_LZCNT_GPR16_GPRMEM16:
        return vector<Confidence<Ref<Type>>> { Type::IntegerType(2, false)};

    case INTRINSIC_XED_IFORM_POPCNT_GPR64_GPRMEM64:
        return vector<Confidence<Ref<Type>>> { Type::IntegerType(8, false)};
    case INTRINSIC_XED_IFORM_POPCNT_GPR32_GPRMEM32:
        return vector<Confidence<Ref<Type>>> { Type::IntegerType(4, false)};
    case INTRINSIC_XED_IFORM_POPCNT_GPR16_GPRMEM16:
        return vector<Confidence<Ref<Type>>> { Type::IntegerType(2, false)};

    #include "x86_intrinsic_output_type.include"

    default:
        return vector<Confidence<Ref<Type>>>();
    }
}


#ifdef __clang__
// clang is very slow at optimizing this function. Optimizations have nearly zero
// impact on initialization time, so just turn them off.
void X86CommonArchitecture::InitializeCachedInputTypes() __attribute__((optnone))
#else
void X86CommonArchitecture::InitializeCachedInputTypes()
#endif
{
#include "x86_intrinsic_cached_input_types.include"
}


#ifdef __clang__
// clang is very slow at optimizing this function. Optimizations have nearly zero
// impact on initialization time, so just turn them off.
void X86CommonArchitecture::InitializeCachedOutputTypes() __attribute__((optnone))
#else
void X86CommonArchitecture::InitializeCachedOutputTypes()
#endif
{
#include "x86_intrinsic_cached_output_types.include"
}


void X86CommonArchitecture::InitializeCachedTypes()
{
    X86CommonArchitecture::InitializeCachedInputTypes();
    X86CommonArchitecture::InitializeCachedOutputTypes();
}
