#!/usr/bin/env python

# compile disassembler to ctypes-able shared object:
# MAC: gcc armv7.c -shared -o disasm.dylib

# (bytes, expected_disassembly, options)
test_cases = (
	# msr, mrs
	(b'\x00\x80\x0f\xe1', 'mrs r8, apsr', {}),
	(b'\x00\x80\x0f\xe1', 'mrs r8, apsr', {}),
	(b'\x00\x80\x4f\xe1', 'mrs r8, spsr', {}),
	(b'\x05\xf0\x28\xe3', 'msr apsr_nzcvq, #0x5', {}),
	(b'\x05\xf0\x24\xe3', 'msr apsr_g, #0x5', {}),
	(b'\x05\xf0\x28\xe3', 'msr apsr_nzcvq, #0x5', {}),
	(b'\x05\xf0\x28\xe3', 'msr apsr_nzcvq, #0x5', {}),
	(b'\x05\xf0\x2c\xe3', 'msr apsr_nzcvqg, #0x5', {}),
	(b'\x05\xf0\x29\xe3', 'msr cpsr_fc, #0x5', {}),
	(b'\x05\xf0\x21\xe3', 'msr cpsr_c, #0x5', {}),
	(b'\x05\xf0\x22\xe3', 'msr cpsr_x, #0x5', {}),
	(b'\x05\xf0\x29\xe3', 'msr cpsr_fc, #0x5', {}),
	(b'\x05\xf0\x29\xe3', 'msr cpsr_fc, #0x5', {}),
	(b'\x05\xf0\x2e\xe3', 'msr cpsr_fsx, #0x5', {}),
	(b'\x05\xf0\x69\xe3', 'msr spsr_fc, #0x5', {}),
	(b'\x05\xf0\x6f\xe3', 'msr spsr_fsxc, #0x5', {}),
	(b'\x05\xf0\x2f\xe3', 'msr cpsr_fsxc, #0x5', {}),
	(b'\x00\xf0\x28\xe1', 'msr apsr_nzcvq, r0', {}),
	(b'\x00\xf0\x24\xe1', 'msr apsr_g, r0', {}),
	(b'\x00\xf0\x28\xe1', 'msr apsr_nzcvq, r0', {}),
	(b'\x00\xf0\x28\xe1', 'msr apsr_nzcvq, r0', {}),
	(b'\x00\xf0\x2c\xe1', 'msr apsr_nzcvqg, r0', {}),
	(b'\x00\xf0\x29\xe1', 'msr cpsr_fc, r0', {}),
	(b'\x00\xf0\x21\xe1', 'msr cpsr_c, r0', {}),
	(b'\x00\xf0\x22\xe1', 'msr cpsr_x, r0', {}),
	(b'\x00\xf0\x29\xe1', 'msr cpsr_fc, r0', {}),
	(b'\x00\xf0\x29\xe1', 'msr cpsr_fc, r0', {}),
	(b'\x00\xf0\x2e\xe1', 'msr cpsr_fsx, r0', {}),
	(b'\x00\xf0\x69\xe1', 'msr spsr_fc, r0', {}),
	(b'\x00\xf0\x6f\xe1', 'msr spsr_fsxc, r0', {}),
	(b'\x00\xf0\x2f\xe1', 'msr cpsr_fsxc, r0', {}),

        # supervisor calls
	(b'\x10\x00\x00\xef', 'svc #0x10', {}),
	(b'\x00\x00\x00\xef', 'svc #0', {}),
	(b'\xff\xff\xff\xef', 'svc #0xffffff', {}),
	(b'\x01\x00\x00\xef', 'svc #0x1', {}),
	(b'\x02\x00\x00\xef', 'svc #0x2', {}),
	(b'\x56\x34\x12\xef', 'svc #0x123456', {}),
        #
	(b'\x93\xfc\x80\xe1', 'stl r3, [r0]', {}), # NOT 'strex pc, r3, [r0]'
	(b'\x94\xfc\x81\xe1', 'stl r4, [r1]', {}),
	(b'\x95\xfc\x82\xe1', 'stl r5, [r2]', {}),
	(b'\x96\xfc\x83\xe1', 'stl r6, [r3]', {}),
	# store register exclusive should be A32 stlex, stlexb, stlexh, stlexd when b11...b8 == 1110
	(b'\x9f\x1e\x87\xe1', 'stlex r1, pc, [r7]', {}),
	(b'\x9f\x2e\xe5\xe1', 'stlexh r2, pc, [r5]', {}),
	(b'\x9f\x3e\xc4\xe1', 'stlexb r3, pc, [r4]', {}),
	(b'\x9f\x5e\x86\xe1', 'stlex r5, pc, [r6]', {}),
	(b'\x9f\x5e\xc6\xe1', 'stlexb r5, pc, [r6]', {}),
	(b'\x94\x2e\xa6\xe1', 'stlexd r2, r4, r5, [r6]', {}),
	(b'\x9f\xce\xe9\xe1', 'stlexh r12, pc, [r9]', {}),
	# load register exclusive should be A32 ldaex, ldaexb, ldaexh, ldaexd when b11...b8 == 1110
	(b'\x9f\x1e\x97\xe1', 'ldaex r1, [r7]', {}),
	(b'\x9f\x2e\xf5\xe1', 'ldaexh r2, [r5]', {}),
	(b'\x9f\x3e\xd4\xe1', 'ldaexb r3, [r4]', {}),
	(b'\x9f\x5e\x96\xe1', 'ldaex r5, [r6]', {}),
	(b'\x9f\x5e\xd6\xe1', 'ldaexb r5, [r6]', {}),
	(b'\x9f\x6e\xb8\xe1', 'ldaexd r6, r7, [r8]', {}),
	(b'\x9f\xce\xf9\xe1', 'ldaexh r12, [r9]', {}),
	# load register exclusive should SUCCEED when b11...b8 == 1111
	(b'\x9f\x1f\x97\xe1', 'ldrex r1, [r7]', {}),
	(b'\x9f\x2f\xf5\xe1', 'ldrexh r2, [r5]', {}),
	(b'\x9f\x3f\xd4\xe1', 'ldrexb r3, [r4]', {}),
	(b'\x9f\x5f\x96\xe1', 'ldrex r5, [r6]', {}),
	(b'\x9f\x5f\xd6\xe1', 'ldrexb r5, [r6]', {}),
	(b'\x9f\x6f\xb8\xe1', 'ldrexd r6, r7, [r8]', {}),
	(b'\x9f\xcf\xf9\xe1', 'ldrexh r12, [r9]', {}),
	# load register exclusive should FAIL when b11...b8 != 1111 ...DEBATABLE!
	#(b'\x9f\x1d\x97\xe1', 'decomposer failed', {}),
	#(b'\x9f\x2c\xf5\xe1', 'decomposer failed', {}),
	#(b'\x9f\x3b\xd4\xe1', 'decomposer failed', {}),
	#(b'\x9f\x6a\xb8\xe1', 'decomposer failed', {}),
	# adr
	(b'\x7b\x00\x8f\xe2', 'adr r0, 0x83', {}),
	# ENCODING A1: cond.4|00|1|0100|0|1111|Rd.4|imm12.12
	# when ADR aliases "add pc, something"
	(b'\x00\x00\x8f\xe2', 'adr r0, 0x8', {'addr':0}),
	(b'\x00\x00\x8f\xe2', 'adr r0, 0xc', {'addr':4}),
	(b'\x00\x00\x8f\xe2', 'adr r0, 0xa0000008', {'addr':0xa0000000}),
	(b'\x00\x00\x8f\xe2', 'adr r0, 0xa000000c', {'addr':0xa0000004}),
	(b'\x24\x00\x8f\xe2', 'adr r0, 0x2c', {'addr':0}), # 0 + 8 + 0x24 == 0x2C
	(b'\x24\x00\x8f\xe2', 'adr r0, 0x30', {'addr':4}), # 4 + 8 + 0x24 == 0x30
	(b'\x24\x00\x8f\xe2', 'adr r0, 0xa000002c', {'addr':0xa0000000}), # a0000020 + 8 + 0x24 = 0xa000002c
	(b'\x24\x00\x8f\xe2', 'adr r0, 0xa0000030', {'addr':0xa0000004}), # a0000030 + 8 + 0x24 = 0xa0000030
	# ENCODING A2: cond.4|00|1|0010|0|1111|Rd.4|imm12.12
	# when ADR aliases "sub pc, something"
	(b'\x00\x00\x4f\xe2', 'adr r0, 0x8', {'addr':0}),
	(b'\x00\x00\x4f\xe2', 'adr r0, 0xc', {'addr':4}),
	(b'\x00\x00\x4f\xe2', 'adr r0, 0xa0000008', {'addr':0xa0000000}),
	(b'\x00\x00\x4f\xe2', 'adr r0, 0xa000000c', {'addr':0xa0000004}),
	(b'\x24\x00\x4f\xe2', 'adr r0, 0xffffffe4', {'addr':0}), # 0 + 8 - 0x24 = 0xffffffe4
	(b'\x24\x00\x4f\xe2', 'adr r0, 0xffffffe8', {'addr':4}), # 4 + 8 - 0x24 = 0xffffffe8
	(b'\x24\x00\x4f\xe2', 'adr r0, 0x9fffffe4', {'addr':0xa0000000}), # 0xa00000000 + 8 - 0x24 = 0x9fffffe4
	(b'\x24\x00\x4f\xe2', 'adr r0, 0x9fffffe8', {'addr':0xa0000004}), # 0xa00000004 + 8 - 0x24 = 0x9fffffe8
	#
	(b'\x03\x10\x02\xe0', 'and r1, r2, r3', {}),
	(b'\x03\x10\x22\xe0', 'eor r1, r2, r3', {}),
	(b'\x03\x10\x42\xe0', 'sub r1, r2, r3', {}),
	(b'\x03\x10\x82\xe0', 'add r1, r2, r3', {}),
	(b'\x03\x10\x82\xe1', 'orr r1, r2, r3', {}),
	(b'\x03\x10\xc2\xe1', 'bic r1, r2, r3', {}),
	(b'\x03\x20\x02\xe0', 'and r2, r2, r3', {}),
	(b'\x03\x20\x12\x00', 'and.seq r2, r2, r3', {}),
	(b'\x03\x20\x22\xe0', 'eor r2, r2, r3', {}),
	(b'\x03\x20\x32\x00', 'eor.seq r2, r2, r3', {}),
	(b'\x03\x20\x42\xe0', 'sub r2, r2, r3', {}),
	(b'\x03\x20\x52\x00', 'sub.seq r2, r2, r3', {}),
	(b'\x03\x20\x82\xe0', 'add r2, r2, r3', {}),
	(b'\x03\x20\x82\xe1', 'orr r2, r2, r3', {}),
	(b'\x03\x20\x92\x00', 'add.seq r2, r2, r3', {}),
	(b'\x03\x20\x92\x01', 'orr.seq r2, r2, r3', {}),
	(b'\x03\x20\xc2\xe1', 'bic r2, r2, r3', {}),
	(b'\x03\x20\xd2\x01', 'bic.seq r2, r2, r3', {}),
	(b'\x06\x20\x02\xe2', 'and r2, r2, #0x6', {}),
	(b'\x06\x20\x12\x02', 'and.seq r2, r2, #0x6', {}),
	(b'\x06\x20\x22\xe2', 'eor r2, r2, #0x6', {}),
	(b'\x06\x20\x32\x02', 'eor.seq r2, r2, #0x6', {}),
	(b'\x06\x20\x42\xe2', 'sub r2, r2, #0x6', {}),
	(b'\x06\x20\x52\x02', 'sub.seq r2, r2, #0x6', {}),
	(b'\x06\x20\x82\xe2', 'add r2, r2, #0x6', {}),
	(b'\x06\x20\x82\xe3', 'orr r2, r2, #0x6', {}),
	(b'\x06\x20\x92\x02', 'add.seq r2, r2, #0x6', {}),
	(b'\x06\x20\x92\x03', 'orr.seq r2, r2, #0x6', {}),
	(b'\x06\x20\xc2\xe3', 'bic r2, r2, #0x6', {}),
	(b'\x06\x20\xd2\x03', 'bic.seq r2, r2, #0x6', {}),
	(b'\x03\x20\xa0\x01', 'moveq r2, r3', {}),
	(b'\x00\x50\x97\xe5', 'ldr r5, [r7]', {}),
	(b'\x3f\x60\x93\xe5', 'ldr r6, [r3, #0x3f]', {}),
	(b'\xff\x2f\xb4\xe5', 'ldr r2, [r4, #0xfff]!', {}),
	(b'\x1e\x10\x92\xe4', 'ldr r1, [r2], #0x1e', {}),
	(b'\x1e\x30\x11\xe4', 'ldr r3, [r1], #-0x1e', {}),
	(b'\x00\x90\x12\xe4', 'ldr r9, [r2], #-0', {}),
	(b'\x01\x30\x98\xe7', 'ldr r3, [r8, r1]', {}),
	(b'\x03\x20\x15\xe7', 'ldr r2, [r5, -r3]', {}),
	(b'\x09\x10\xb5\xe7', 'ldr r1, [r5, r9]!', {}),
	(b'\x08\x60\x37\xe7', 'ldr r6, [r7, -r8]!', {}),
	(b'\xa2\x11\xb0\xe7', 'ldr r1, [r0, r2, lsr #0x3]!', {}),
	(b'\x02\x50\x99\xe6', 'ldr r5, [r9], r2', {}),
	(b'\x06\x40\x13\xe6', 'ldr r4, [r3], -r6', {}),
	(b'\x82\x37\x18\xe7', 'ldr r3, [r8, -r2, lsl #0xf]', {}),
	(b'\xc3\x17\x95\xe6', 'ldr r1, [r5], r3, asr #0xf', {}),
	(b'\x00\x30\xd8\xe5', 'ldrb r3, [r8]', {}),
	(b'\x3f\x10\xdd\xe5', 'ldrb r1, [sp, #0x3f]', {}),
	(b'\xff\x9f\xf3\xe5', 'ldrb r9, [r3, #0xfff]!', {}),
	(b'\x16\x80\xd1\xe4', 'ldrb r8, [r1], #0x16', {}),
	(b'\x13\x20\x57\xe4', 'ldrb r2, [r7], #-0x13', {}),
	(b'\x05\x90\xd8\xe7', 'ldrb r9, [r8, r5]', {}),
	(b'\x01\x10\x55\xe7', 'ldrb r1, [r5, -r1]', {}),
	(b'\x02\x30\xf5\xe7', 'ldrb r3, [r5, r2]!', {}),
	(b'\x03\x60\x79\xe7', 'ldrb r6, [r9, -r3]!', {}),
	(b'\x04\x20\xd1\xe6', 'ldrb r2, [r1], r4', {}),
	(b'\x05\x80\x54\xe6', 'ldrb r8, [r4], -r5', {}),
	(b'\x81\x77\x5c\xe7', 'ldrb r7, [r12, -r1, lsl #0xf]', {}),
	(b'\xc9\x57\xd2\xe6', 'ldrb r5, [r2], r9, asr #0xf', {}),
	(b'\x04\x30\xf1\xe4', 'ldrbt r3, [r1], #0x4', {}),
	(b'\x08\x20\x78\xe4', 'ldrbt r2, [r8], #-0x8', {}),
	(b'\x06\x80\xf7\xe6', 'ldrbt r8, [r7], r6', {}),
	(b'\x06\x16\x72\xe6', 'ldrbt r1, [r2], -r6, lsl #0xc', {}),
	(b'\xd0\x20\xc5\xe1', 'ldrd r2, r3, [r5]', {}),
	(b'\xdf\x60\xc2\xe1', 'ldrd r6, r7, [r2, #0xf]', {}),
	(b'\xd0\x02\xe9\xe1', 'ldrd r0, r1, [r9, #0x20]!', {}),
	(b'\xd8\x60\xc1\xe0', 'ldrd r6, r7, [r1], #0x8', {}),
	(b'\xd0\x00\xc8\xe0', 'ldrd r0, r1, [r8], #0', {}),
	(b'\xd0\x00\xc8\xe0', 'ldrd r0, r1, [r8], #0', {}),
	(b'\xd0\x00\x48\xe0', 'ldrd r0, r1, [r8], #-0', {}),
	(b'\xd3\x40\x81\xe1', 'ldrd r4, r5, [r1, r3]', {}),
	(b'\xd2\x40\xa7\xe1', 'ldrd r4, r5, [r7, r2]!', {}),
	(b'\xdc\x00\x88\xe0', 'ldrd r0, r1, [r8], r12', {}),
	(b'\xdc\x00\x08\xe0', 'ldrd r0, r1, [r8], -r12', {}),
	(b'\xb0\x30\xd4\xe1', 'ldrh r3, [r4]', {}),
	(b'\xb4\x20\xd7\xe1', 'ldrh r2, [r7, #0x4]', {}),
	(b'\xb0\x14\xf8\xe1', 'ldrh r1, [r8, #0x40]!', {}),
	(b'\xb4\xc0\xdd\xe0', 'ldrh r12, [sp], #0x4', {}),
	(b'\xb4\x60\x95\xe1', 'ldrh r6, [r5, r4]', {}),
	(b'\xbb\x30\xb8\xe1', 'ldrh r3, [r8, r11]!', {}),
	(b'\xb1\x10\x32\xe1', 'ldrh r1, [r2, -r1]!', {}),
	(b'\xb2\x90\x97\xe0', 'ldrh r9, [r7], r2', {}),
	(b'\xb2\x40\x13\xe0', 'ldrh r4, [r3], -r2', {}),
	(b'\xb0\x98\xf7\xe0', 'ldrht r9, [r7], #0x80', {}),
	(b'\xbb\x44\x73\xe0', 'ldrht r4, [r3], #-0x4b', {}),
	(b'\xb2\x90\xb7\xe0', 'ldrht r9, [r7], r2', {}),
	(b'\xb2\x40\x33\xe0', 'ldrht r4, [r3], -r2', {}),
	(b'\xd0\x30\xd4\xe1', 'ldrsb r3, [r4]', {}),
	(b'\xd1\x21\xd7\xe1', 'ldrsb r2, [r7, #0x11]', {}),
	(b'\xdf\x1f\xf8\xe1', 'ldrsb r1, [r8, #0xff]!', {}),
	(b'\xd9\xc0\xdd\xe0', 'ldrsb r12, [sp], #0x9', {}),
	(b'\xd4\x60\x95\xe1', 'ldrsb r6, [r5, r4]', {}),
	(b'\xdb\x30\xb8\xe1', 'ldrsb r3, [r8, r11]!', {}),
	(b'\xd1\x10\x32\xe1', 'ldrsb r1, [r2, -r1]!', {}),
	(b'\xd2\x90\x97\xe0', 'ldrsb r9, [r7], r2', {}),
	(b'\xd2\x40\x13\xe0', 'ldrsb r4, [r3], -r2', {}),
	(b'\xd1\x50\xf6\xe0', 'ldrsbt r5, [r6], #0x1', {}),
	(b'\xdc\x30\x78\xe0', 'ldrsbt r3, [r8], #-0xc', {}),
	(b'\xd5\x80\xb9\xe0', 'ldrsbt r8, [r9], r5', {}),
	(b'\xd4\x20\x31\xe0', 'ldrsbt r2, [r1], -r4', {}),
	(b'\xf0\x50\xd9\xe1', 'ldrsh r5, [r9]', {}),
	(b'\xf7\x40\xd5\xe1', 'ldrsh r4, [r5, #0x7]', {}),
	(b'\xf7\x33\xf6\xe1', 'ldrsh r3, [r6, #0x37]!', {}),
	(b'\xf9\x20\x57\xe0', 'ldrsh r2, [r7], #-0x9', {}),
	(b'\xf5\x30\x91\xe1', 'ldrsh r3, [r1, r5]', {}),
	(b'\xf1\x40\xb6\xe1', 'ldrsh r4, [r6, r1]!', {}),
	(b'\xf6\x50\x33\xe1', 'ldrsh r5, [r3, -r6]!', {}),
	(b'\xf8\x60\x99\xe0', 'ldrsh r6, [r9], r8', {}),
	(b'\xf3\x70\x18\xe0', 'ldrsh r7, [r8], -r3', {}),
	(b'\xf1\x50\xf6\xe0', 'ldrsht r5, [r6], #0x1', {}),
	(b'\xfc\x30\x78\xe0', 'ldrsht r3, [r8], #-0xc', {}),
	(b'\xf5\x80\xb9\xe0', 'ldrsht r8, [r9], r5', {}),
	(b'\xf4\x20\x31\xe0', 'ldrsht r2, [r1], -r4', {}),
	(b'\x00\x80\x8c\xe5', 'str r8, [r12]', {}),
	(b'\x0c\x70\x81\xe5', 'str r7, [r1, #0xc]', {}),
	(b'\x28\x30\xa5\xe5', 'str r3, [r5, #0x28]!', {}),
	(b'\xff\x9f\x8d\xe4', 'str r9, [sp], #0xfff', {}),
	(b'\x80\x10\x07\xe4', 'str r1, [r7], #-0x80', {}),
	(b'\x00\x10\x00\xe4', 'str r1, [r0], #-0', {}),
	(b'\x03\x90\x86\xe7', 'str r9, [r6, r3]', {}),
	(b'\x02\x80\x00\xe7', 'str r8, [r0, -r2]', {}),
	(b'\x06\x70\xa1\xe7', 'str r7, [r1, r6]!', {}),
	(b'\x01\x60\x2d\xe7', 'str r6, [sp, -r1]!', {}),
	(b'\x09\x50\x83\xe6', 'str r5, [r3], r9', {}),
	(b'\x05\x40\x02\xe6', 'str r4, [r2], -r5', {}),
	(b'\x02\x31\x04\xe7', 'str r3, [r4, -r2, lsl #0x2]', {}),
	(b'\x43\x2c\x87\xe6', 'str r2, [r7], r3, asr #0x18', {}),
	(b'\x00\x90\xc2\xe5', 'strb r9, [r2]', {}),
	(b'\x03\x70\xc1\xe5', 'strb r7, [r1, #0x3]', {}),
	(b'\x95\x61\xe4\xe5', 'strb r6, [r4, #0x195]!', {}),
	(b'\x48\x50\xc7\xe4', 'strb r5, [r7], #0x48', {}),
	(b'\x01\x10\x4d\xe4', 'strb r1, [sp], #-0x1', {}),
	(b'\x09\x10\xc2\xe7', 'strb r1, [r2, r9]', {}),
	(b'\x08\x20\x43\xe7', 'strb r2, [r3, -r8]', {}),
	(b'\x07\x30\xe4\xe7', 'strb r3, [r4, r7]!', {}),
	(b'\x06\x40\x65\xe7', 'strb r4, [r5, -r6]!', {}),
	(b'\x05\x50\xc6\xe6', 'strb r5, [r6], r5', {}),
	(b'\x04\x60\x42\xe6', 'strb r6, [r2], -r4', {}),
	(b'\x83\x72\x4c\xe7', 'strb r7, [r12, -r3, lsl #0x5]', {}),
	(b'\x42\xd6\xc7\xe6', 'strb sp, [r7], r2, asr #0xc', {}),
	(b'\x0c\x60\xe2\xe4', 'strbt r6, [r2], #0xc', {}),
	(b'\x0d\x50\x66\xe4', 'strbt r5, [r6], #-0xd', {}),
	(b'\x05\x40\xe9\xe6', 'strbt r4, [r9], r5', {}),
	(b'\x82\x31\x68\xe6', 'strbt r3, [r8], -r2, lsl #0x3', {}),
	(b'\xf0\x10\xc4\xe1', 'strd r1, r2, [r4]', {}),
	(b'\xf1\x20\xc6\xe1', 'strd r2, r3, [r6, #0x1]', {}),
	(b'\xf6\x31\xe7\xe1', 'strd r3, r4, [r7, #0x16]!', {}),
	(b'\xf7\x40\xc8\xe0', 'strd r4, r5, [r8], #0x7', {}),
	(b'\xf0\x50\xcd\xe0', 'strd r5, r6, [sp], #0', {}),
	(b'\xf0\x60\xce\xe0', 'strd r6, r7, [lr], #0', {}),
	(b'\xf0\x70\x49\xe0', 'strd r7, r8, [r9], #-0', {}),
	(b'\xf1\x80\x84\xe1', 'strd r8, r9, [r4, r1]', {}),
	(b'\xf9\x70\xa3\xe1', 'strd r7, r8, [r3, r9]!', {}),
	(b'\xf8\x60\x85\xe0', 'strd r6, r7, [r5], r8', {}),
	(b'\xfa\x50\x0c\xe0', 'strd r5, r6, [r12], -r10', {}),
	(b'\xb0\x30\xc4\xe1', 'strh r3, [r4]', {}),
	(b'\xb4\x20\xc7\xe1', 'strh r2, [r7, #0x4]', {}),
	(b'\xb0\x14\xe8\xe1', 'strh r1, [r8, #0x40]!', {}),
	(b'\xb4\xc0\xcd\xe0', 'strh r12, [sp], #0x4', {}),
	(b'\xb4\x60\x85\xe1', 'strh r6, [r5, r4]', {}),
	(b'\xbb\x30\xa8\xe1', 'strh r3, [r8, r11]!', {}),
	(b'\xb1\x10\x22\xe1', 'strh r1, [r2, -r1]!', {}),
	(b'\xb2\x90\x87\xe0', 'strh r9, [r7], r2', {}),
	(b'\xb2\x40\x03\xe0', 'strh r4, [r3], -r2', {}),
	(b'\xbc\x24\xe5\xe0', 'strht r2, [r5], #0x4c', {}),
	(b'\xb9\x81\x61\xe0', 'strht r8, [r1], #-0x19', {}),
	(b'\xb4\x50\xa3\xe0', 'strht r5, [r3], r4', {}),
	(b'\xb0\x60\x28\xe0', 'strht r6, [r8], -r0', {}),
	(b'\x00\x00\x90\xe7', 'ldr r0, [r0, r0]', {}),
	(b'\x20\x00\x90\xe7', 'ldr r0, [r0, r0, lsr #0x20]', {}),
	(b'\x20\x08\x90\xe7', 'ldr r0, [r0, r0, lsr #0x10]', {}),
	(b'\x00\x00\x90\xe7', 'ldr r0, [r0, r0]', {}),
	(b'\x00\x08\x90\xe7', 'ldr r0, [r0, r0, lsl #0x10]', {}),
	(b'\x40\x00\x90\xe7', 'ldr r0, [r0, r0, asr #0x20]', {}),
	(b'\x40\x08\x90\xe7', 'ldr r0, [r0, r0, asr #0x10]', {}),
	(b'\x60\x00\x90\xe7', 'ldr r0, [r0, r0, rrx]', {}),
	(b'\x60\x08\x90\xe7', 'ldr r0, [r0, r0, ror #0x10]', {}),
	(b'\x00\xf0\xd0\xf7', 'pld [r0, r0]', {}),
	(b'\x20\xf0\xd0\xf7', 'pld [r0, r0, lsr #0x20]', {}),
	(b'\x20\xf8\xd0\xf7', 'pld [r0, r0, lsr #0x10]', {}),
	(b'\x00\xf0\xd0\xf7', 'pld [r0, r0]', {}),
	(b'\x00\xf8\xd0\xf7', 'pld [r0, r0, lsl #0x10]', {}),
	(b'\x40\xf0\xd0\xf7', 'pld [r0, r0, asr #0x20]', {}),
	(b'\x40\xf8\xd0\xf7', 'pld [r0, r0, asr #0x10]', {}),
	(b'\x60\xf0\xd0\xf7', 'pld [r0, r0, rrx]', {}),
	(b'\x60\xf8\xd0\xf7', 'pld [r0, r0, ror #0x10]', {}),
	(b'\x00\x00\x80\xe7', 'str r0, [r0, r0]', {}),
	(b'\x20\x00\x80\xe7', 'str r0, [r0, r0, lsr #0x20]', {}),
	(b'\x20\x08\x80\xe7', 'str r0, [r0, r0, lsr #0x10]', {}),
	(b'\x00\x00\x80\xe7', 'str r0, [r0, r0]', {}),
	(b'\x00\x08\x80\xe7', 'str r0, [r0, r0, lsl #0x10]', {}),
	(b'\x40\x00\x80\xe7', 'str r0, [r0, r0, asr #0x20]', {}),
	(b'\x40\x08\x80\xe7', 'str r0, [r0, r0, asr #0x10]', {}),
	(b'\x60\x00\x80\xe7', 'str r0, [r0, r0, rrx]', {}),
	(b'\x60\x08\x80\xe7', 'str r0, [r0, r0, ror #0x10]', {}),
	(b'\x62\x00\x91\xe6', 'ldr r0, [r1], r2, rrx', {}),
	(b'\x05\x30\x94\xe6', 'ldr r3, [r4], r5', {}),
	(b'\x08\x60\x87\xe6', 'str r6, [r7], r8', {}),
	(b'\x0b\x90\x8a\xe6', 'str r9, [r10], r11', {}),
	(b'\x0f\xd0\xae\xe0', 'adc sp, lr, pc', {}),
	(b'\x29\x10\xa8\xe0', 'adc r1, r8, r9, lsr #0x20', {}),
	(b'\x2f\x28\xa7\xe0', 'adc r2, r7, pc, lsr #0x10', {}),
	(b'\x0a\x30\xa6\xe0', 'adc r3, r6, r10', {}),
	(b'\x0e\x48\xa5\xe0', 'adc r4, r5, lr, lsl #0x10', {}),
	(b'\x4b\x50\xa4\xe0', 'adc r5, r4, r11, asr #0x20', {}),
	(b'\x4d\x68\xa3\xe0', 'adc r6, r3, sp, asr #0x10', {}),
	(b'\x6c\x70\xa2\xe0', 'adc r7, r2, r12, rrx', {}),
	(b'\x60\x88\xa1\xe0', 'adc r8, r1, r0, ror #0x10', {}),
	(b'\x0e\x00\x5d\xe1', 'cmp sp, lr', {}),
	(b'\x28\x00\x51\xe1', 'cmp r1, r8, lsr #0x20', {}),
	(b'\x27\x08\x52\xe1', 'cmp r2, r7, lsr #0x10', {}),
	(b'\x06\x00\x53\xe1', 'cmp r3, r6', {}),
	(b'\x05\x08\x54\xe1', 'cmp r4, r5, lsl #0x10', {}),
	(b'\x44\x00\x55\xe1', 'cmp r5, r4, asr #0x20', {}),
	(b'\x43\x08\x56\xe1', 'cmp r6, r3, asr #0x10', {}),
	(b'\x62\x00\x57\xe1', 'cmp r7, r2, rrx', {}),
	(b'\x61\x08\x58\xe1', 'cmp r8, r1, ror #0x10', {}),
	(b'\x7f\x00\x60\xe1', 'smc #0xf', {}),
	(b'\x70\x00\x60\x01', 'smceq #0', {}),
	(b'\x02\x10\xb0\xe6', 'ldrt r1, [r0], r2', {}),
	(b'\xa2\x11\xb0\xe6', 'ldrt r1, [r0], r2, lsr #0x3', {}),
	(b'\x04\x10\xb0\xe4', 'ldrt r1, [r0], #0x4', {}),
	(b'\x02\x10\xf0\xe6', 'ldrbt r1, [r0], r2', {}),
	(b'\xa2\x11\xf0\xe6', 'ldrbt r1, [r0], r2, lsr #0x3', {}),
	(b'\x04\x10\xf0\xe4', 'ldrbt r1, [r0], #0x4', {}),
	(b'\x02\x10\xa0\xe6', 'strt r1, [r0], r2', {}),
	(b'\xa2\x11\xa0\xe6', 'strt r1, [r0], r2, lsr #0x3', {}),
	(b'\x04\x10\xa0\xe4', 'strt r1, [r0], #0x4', {}),
	(b'\x02\x10\xe0\xe6', 'strbt r1, [r0], r2', {}),
	(b'\xa2\x11\xe0\xe6', 'strbt r1, [r0], r2, lsr #0x3', {}),
	(b'\x04\x10\xe0\xe4', 'strbt r1, [r0], #0x4', {}),
	(b'\xa2\x11\xb0\xe7', 'ldr r1, [r0, r2, lsr #0x3]!', {}),
	(b'\xa2\x11\xf0\xe7', 'ldrb r1, [r0, r2, lsr #0x3]!', {}),
	(b'\xd2\x10\xb0\xe0', 'ldrsbt r1, [r0], r2', {}),
	(b'\xd4\x10\xf0\xe0', 'ldrsbt r1, [r0], #0x4', {}),
	(b'\xf2\x10\xb0\xe0', 'ldrsht r1, [r0], r2', {}),
	(b'\xf4\x10\xf0\xe0', 'ldrsht r1, [r0], #0x4', {}),
	(b'\xb2\x10\xb0\xe0', 'ldrht r1, [r0], r2', {}),
	(b'\xb4\x10\xf0\xe0', 'ldrht r1, [r0], #0x4', {}),
	(b'\xb2\x10\xa0\xe0', 'strht r1, [r0], r2', {}),
	(b'\xb4\x10\xe0\xe0', 'strht r1, [r0], #0x4', {}),
	(b'\x1e\xff\x2f\xe1', 'bx lr', {}),
	(b'\xa0\x0d\xe1\xf2', 'vqdmull.s32 q8, d17, d16', {}),
	(b'\x03\x10\x02\xe0', 'and r1, r2, r3', {}),
	(b'\x03\x10\x12\xe0', 'and.s r1, r2, r3', {}),
	(b'\x03\x10\x22\xe0', 'eor r1, r2, r3', {}),
	(b'\x03\x10\x32\xe0', 'eor.s r1, r2, r3', {}),
	(b'\x03\x10\x42\xe0', 'sub r1, r2, r3', {}),
	(b'\x03\x10\x52\xe0', 'sub.s r1, r2, r3', {}),
	(b'\x03\x10\x82\xe0', 'add r1, r2, r3', {}),
	(b'\x03\x10\x92\xe0', 'add.s r1, r2, r3', {}),
	(b'\x03\x10\xa2\xe0', 'adc r1, r2, r3', {}),
	(b'\x03\x10\xc2\xe1', 'bic r1, r2, r3', {}),
	(b'\x03\x10\xd2\xe1', 'bic.s r1, r2, r3', {}),
	(b'\x02\x10\xa0\xe1', 'mov r1, r2', {}),
	(b'\x02\x10\xe0\xe1', 'mvn r1, r2', {}),
	(b'\x02\x10\xf0\xe1', 'mvn.s r1, r2', {}),
	(b'\x90\x02\xcb\xe7', 'bfi r0, r0, #0x5, #0x7', {}),
	(b'\x7a\x00\x20\xe1', 'bkpt #0xa', {}),
	(b'\x81\x17\x11\xee', 'cdp p7, #0x1, c1, c1, c1, #0x4', {}),
	(b'\x81\x17\x11\xfe', 'cdp2 p7, #0x1, c1, c1, c1, #0x4', {}),
	(b'\x13\x14\x82\xe0', 'add r1, r2, r3, lsl r4', {}),
	(b'\x30\x0f\xa6\xe6', 'ssat16 r0, #0x7, r0', {}),
	#(b'\x00\x00\x0a\xf1', 'cpsie none, #0', {}),
	(b'\xb0\x30\x42\xe1', 'strh r3, [r2]', {}),
	(b'\x59\xf0\x7f\xf5', 'dmb ishld', {}),
	(b'\x51\xf0\x7f\xf5', 'dmb oshld', {}),
	(b'\x55\xf0\x7f\xf5', 'dmb nshld', {}),
	(b'\x5d\xf0\x7f\xf5', 'dmb ld', {}),
	(b'\x49\xf0\x7f\xf5', 'dsb ishld', {}),
	(b'\x41\xf0\x7f\xf5', 'dsb oshld', {}),
	(b'\x45\xf0\x7f\xf5', 'dsb nshld', {}),
	(b'\x4d\xf0\x7f\xf5', 'dsb ld', {}),
	(b'\x05\xf0\x20\xe3', 'hint #0x5', {}),
	(b'\x0f\x10\xa2\xe2', 'adc r1, r2, #0xf', {}),
	(b'\xf0\x10\xa2\xe2', 'adc r1, r2, #0xf0', {}),
	(b'\x0f\x1c\xa2\xe2', 'adc r1, r2, #0xf00', {}),
	(b'\x0f\x1a\xa2\xe2', 'adc r1, r2, #0xf000', {}),
	(b'\x0f\x18\xa2\xe2', 'adc r1, r2, #0xf0000', {}),
	(b'\x0f\x16\xa2\xe2', 'adc r1, r2, #0xf00000', {}),
	(b'\x0f\x14\xa2\xe2', 'adc r1, r2, #0xf000000', {}),
	(b'\x0f\x12\xa2\xe2', 'adc r1, r2, #0xf0000000', {}),
	(b'\xff\x12\xa2\xe2', 'adc r1, r2, #0xf000000f', {}),
	(b'\x0f\x1c\xb2\xe2', 'adc.s r1, r2, #0xf00', {}),
	(b'\x0f\x1c\xb2\x02', 'adc.seq r1, r2, #0xf00', {}),
	(b'\x0f\x1c\xa2\x02', 'adceq r1, r2, #0xf00', {}),
	(b'\x06\x40\xa5\xe0', 'adc r4, r5, r6', {}),
	(b'\x86\x40\xa5\xe0', 'adc r4, r5, r6, lsl #0x1', {}),
	(b'\x86\x4f\xa5\xe0', 'adc r4, r5, r6, lsl #0x1f', {}),
	(b'\xa6\x40\xa5\xe0', 'adc r4, r5, r6, lsr #0x1', {}),
	(b'\xa6\x4f\xa5\xe0', 'adc r4, r5, r6, lsr #0x1f', {}),
	(b'\x26\x40\xa5\xe0', 'adc r4, r5, r6, lsr #0x20', {}),
	(b'\xc6\x40\xa5\xe0', 'adc r4, r5, r6, asr #0x1', {}),
	(b'\xc6\x4f\xa5\xe0', 'adc r4, r5, r6, asr #0x1f', {}),
	(b'\x46\x40\xa5\xe0', 'adc r4, r5, r6, asr #0x20', {}),
	(b'\xe6\x40\xa5\xe0', 'adc r4, r5, r6, ror #0x1', {}),
	(b'\xe6\x4f\xa5\xe0', 'adc r4, r5, r6, ror #0x1f', {}),
	(b'\x18\x69\xa7\xe0', 'adc r6, r7, r8, lsl r9', {}),
	(b'\x38\x69\xa7\xe0', 'adc r6, r7, r8, lsr r9', {}),
	(b'\x58\x69\xa7\xe0', 'adc r6, r7, r8, asr r9', {}),
	(b'\x78\x69\xa7\xe0', 'adc r6, r7, r8, ror r9', {}),
	(b'\x66\x40\xa5\xe0', 'adc r4, r5, r6, rrx', {}),
	(b'\x06\x50\xa5\xe0', 'adc r5, r5, r6', {}),
	(b'\x85\x40\xa4\xe0', 'adc r4, r4, r5, lsl #0x1', {}),
	(b'\x85\x4f\xa4\xe0', 'adc r4, r4, r5, lsl #0x1f', {}),
	(b'\xa5\x40\xa4\xe0', 'adc r4, r4, r5, lsr #0x1', {}),
	(b'\xa5\x4f\xa4\xe0', 'adc r4, r4, r5, lsr #0x1f', {}),
	(b'\x25\x40\xa4\xe0', 'adc r4, r4, r5, lsr #0x20', {}),
	(b'\xc5\x40\xa4\xe0', 'adc r4, r4, r5, asr #0x1', {}),
	(b'\xc5\x4f\xa4\xe0', 'adc r4, r4, r5, asr #0x1f', {}),
	(b'\x45\x40\xa4\xe0', 'adc r4, r4, r5, asr #0x20', {}),
	(b'\xe5\x40\xa4\xe0', 'adc r4, r4, r5, ror #0x1', {}),
	(b'\xe5\x4f\xa4\xe0', 'adc r4, r4, r5, ror #0x1f', {}),
	(b'\x65\x40\xa4\xe0', 'adc r4, r4, r5, rrx', {}),
	(b'\x17\x69\xa6\xe0', 'adc r6, r6, r7, lsl r9', {}),
	(b'\x37\x69\xa6\xe0', 'adc r6, r6, r7, lsr r9', {}),
	(b'\x57\x69\xa6\xe0', 'adc r6, r6, r7, asr r9', {}),
	(b'\x77\x69\xa6\xe0', 'adc r6, r6, r7, ror r9', {}),
	(b'\x65\x40\xa4\xe0', 'adc r4, r4, r5, rrx', {}),
	(b'\x0f\x4a\x85\xe2', 'add r4, r5, #0xf000', {}),
	(b'\x06\x40\x85\xe0', 'add r4, r5, r6', {}),
	(b'\x86\x42\x85\xe0', 'add r4, r5, r6, lsl #0x5', {}),
	(b'\xa6\x42\x85\xe0', 'add r4, r5, r6, lsr #0x5', {}),
	(b'\xa6\x42\x85\xe0', 'add r4, r5, r6, lsr #0x5', {}),
	(b'\xc6\x42\x85\xe0', 'add r4, r5, r6, asr #0x5', {}),
	(b'\xe6\x42\x85\xe0', 'add r4, r5, r6, ror #0x5', {}),
	(b'\x18\x69\x87\xe0', 'add r6, r7, r8, lsl r9', {}),
	(b'\x13\x49\x84\xe0', 'add r4, r4, r3, lsl r9', {}),
	(b'\x38\x69\x87\xe0', 'add r6, r7, r8, lsr r9', {}),
	(b'\x58\x69\x87\xe0', 'add r6, r7, r8, asr r9', {}),
	(b'\x78\x69\x87\xe0', 'add r6, r7, r8, ror r9', {}),
	(b'\x66\x40\x85\xe0', 'add r4, r5, r6, rrx', {}),
	(b'\x0f\x5a\x85\xe2', 'add r5, r5, #0xf000', {}),
	(b'\x05\x40\x84\xe0', 'add r4, r4, r5', {}),
	(b'\x85\x42\x84\xe0', 'add r4, r4, r5, lsl #0x5', {}),
	(b'\xa5\x42\x84\xe0', 'add r4, r4, r5, lsr #0x5', {}),
	(b'\xa5\x42\x84\xe0', 'add r4, r4, r5, lsr #0x5', {}),
	(b'\xc5\x42\x84\xe0', 'add r4, r4, r5, asr #0x5', {}),
	(b'\xe5\x42\x84\xe0', 'add r4, r4, r5, ror #0x5', {}),
	(b'\x17\x69\x86\xe0', 'add r6, r6, r7, lsl r9', {}),
	(b'\x37\x69\x86\xe0', 'add r6, r6, r7, lsr r9', {}),
	(b'\x57\x69\x86\xe0', 'add r6, r6, r7, asr r9', {}),
	(b'\x77\x69\x86\xe0', 'add r6, r6, r7, ror r9', {}),
	(b'\x65\x40\x84\xe0', 'add r4, r4, r5, rrx', {}),
	(b'\x04\x00\x40\xe2', 'sub r0, r0, #0x4', {}),
	(b'\x15\x40\x45\xe2', 'sub r4, r5, #0x15', {}),
	(b'\x22\x30\x81\xe0', 'add r3, r1, r2, lsr #0x20', {}),
	(b'\x42\x30\x81\xe0', 'add r3, r1, r2, asr #0x20', {}),
	(b'\x0f\xa0\x01\xe2', 'and r10, r1, #0xf', {}),
	(b'\x06\xa0\x01\xe0', 'and r10, r1, r6', {}),
	(b'\x06\xa5\x01\xe0', 'and r10, r1, r6, lsl #0xa', {}),
	(b'\x26\xa5\x01\xe0', 'and r10, r1, r6, lsr #0xa', {}),
	(b'\x26\xa5\x01\xe0', 'and r10, r1, r6, lsr #0xa', {}),
	(b'\x46\xa5\x01\xe0', 'and r10, r1, r6, asr #0xa', {}),
	(b'\x66\xa5\x01\xe0', 'and r10, r1, r6, ror #0xa', {}),
	(b'\x18\x62\x07\xe0', 'and r6, r7, r8, lsl r2', {}),
	(b'\x38\x62\x07\xe0', 'and r6, r7, r8, lsr r2', {}),
	(b'\x58\x62\x07\xe0', 'and r6, r7, r8, asr r2', {}),
	(b'\x78\x62\x07\xe0', 'and r6, r7, r8, ror r2', {}),
	(b'\x66\xa0\x01\xe0', 'and r10, r1, r6, rrx', {}),
	(b'\x02\x21\xc3\xe3', 'bic r2, r3, #0x80000000', {}),
	(b'\x0f\x10\x01\xe2', 'and r1, r1, #0xf', {}),
	(b'\x01\xa0\x0a\xe0', 'and r10, r10, r1', {}),
	(b'\x01\xa5\x0a\xe0', 'and r10, r10, r1, lsl #0xa', {}),
	(b'\x21\xa5\x0a\xe0', 'and r10, r10, r1, lsr #0xa', {}),
	(b'\x21\xa5\x0a\xe0', 'and r10, r10, r1, lsr #0xa', {}),
	(b'\x41\xa5\x0a\xe0', 'and r10, r10, r1, asr #0xa', {}),
	(b'\x61\xa5\x0a\xe0', 'and r10, r10, r1, ror #0xa', {}),
	(b'\x17\x62\x06\xe0', 'and r6, r6, r7, lsl r2', {}),
	(b'\x37\x62\x06\xe0', 'and r6, r6, r7, lsr r2', {}),
	(b'\x57\x62\x06\xe0', 'and r6, r6, r7, asr r2', {}),
	(b'\x77\x62\x06\xe0', 'and r6, r6, r7, ror r2', {}),
	(b'\x61\xa0\x0a\xe0', 'and r10, r10, r1, rrx', {}),
	(b'\x22\x30\x01\xe0', 'and r3, r1, r2, lsr #0x20', {}),
	(b'\x42\x30\x01\xe0', 'and r3, r1, r2, asr #0x20', {}),
	(b'\x44\x20\xa0\xe1', 'asr r2, r4, #0x20', {}),
	(b'\x44\x21\xa0\xe1', 'asr r2, r4, #0x2', {}),
	(b'\x04\x20\xa0\xe1', 'mov r2, r4', {}),
	(b'\x44\x41\xa0\xe1', 'asr r4, r4, #0x2', {}),
	(b'\x9f\x51\xd3\xe7', 'bfc r5, #0x3, #0x11', {}),
	(b'\x9f\x51\xd3\x37', 'bfclo r5, #0x3, #0x11', {}),
	(b'\x92\x51\xd3\xe7', 'bfi r5, r2, #0x3, #0x11', {}),
	(b'\x92\x51\xd3\x17', 'bfine r5, r2, #0x3, #0x11', {}),
	(b'\x0f\xa0\xc1\xe3', 'bic r10, r1, #0xf', {}),
	(b'\x06\xa0\xc1\xe1', 'bic r10, r1, r6', {}),
	(b'\x06\xa5\xc1\xe1', 'bic r10, r1, r6, lsl #0xa', {}),
	(b'\x26\xa5\xc1\xe1', 'bic r10, r1, r6, lsr #0xa', {}),
	(b'\x26\xa5\xc1\xe1', 'bic r10, r1, r6, lsr #0xa', {}),
	(b'\x46\xa5\xc1\xe1', 'bic r10, r1, r6, asr #0xa', {}),
	(b'\x66\xa5\xc1\xe1', 'bic r10, r1, r6, ror #0xa', {}),
	(b'\x18\x62\xc7\xe1', 'bic r6, r7, r8, lsl r2', {}),
	(b'\x38\x62\xc7\xe1', 'bic r6, r7, r8, lsr r2', {}),
	(b'\x58\x62\xc7\xe1', 'bic r6, r7, r8, asr r2', {}),
	(b'\x78\x62\xc7\xe1', 'bic r6, r7, r8, ror r2', {}),
	(b'\x66\xa0\xc1\xe1', 'bic r10, r1, r6, rrx', {}),
	(b'\x0f\x10\xc1\xe3', 'bic r1, r1, #0xf', {}),
	(b'\x01\xa0\xca\xe1', 'bic r10, r10, r1', {}),
	(b'\x01\xa5\xca\xe1', 'bic r10, r10, r1, lsl #0xa', {}),
	(b'\x21\xa5\xca\xe1', 'bic r10, r10, r1, lsr #0xa', {}),
	(b'\x21\xa5\xca\xe1', 'bic r10, r10, r1, lsr #0xa', {}),
	(b'\x41\xa5\xca\xe1', 'bic r10, r10, r1, asr #0xa', {}),
	(b'\x61\xa5\xca\xe1', 'bic r10, r10, r1, ror #0xa', {}),
	(b'\x17\x62\xc6\xe1', 'bic r6, r6, r7, lsl r2', {}),
	(b'\x37\x62\xc6\xe1', 'bic r6, r6, r7, lsr r2', {}),
	(b'\x57\x62\xc6\xe1', 'bic r6, r6, r7, asr r2', {}),
	(b'\x77\x62\xc6\xe1', 'bic r6, r6, r7, ror r2', {}),
	(b'\x61\xa0\xca\xe1', 'bic r10, r10, r1, rrx', {}),
	(b'\x22\x30\xc1\xe1', 'bic r3, r1, r2, lsr #0x20', {}),
	(b'\x42\x30\xc1\xe1', 'bic r3, r1, r2, asr #0x20', {}),
	(b'\x7a\x00\x20\xe1', 'bkpt #0xa', {}),
	(b'\x7f\xff\x2f\xe1', 'bkpt #0xffff', {}),
	(b'\x27\x3b\x6d\x9b', 'blls #0x1b4ec9c', {}),
	(b'\xa0\xb0\x7b\xfa', 'blx #0x1eec280', {}),
	(b'\x50\xd8\x3d\xfa', 'blx #0xf76140', {}),
	(b'\x32\xff\x2f\xe1', 'blx r2', {}),
	(b'\x32\xff\x2f\x11', 'blxne r2', {}),
	(b'\x12\xff\x2f\xe1', 'bx r2', {}),
	(b'\x12\xff\x2f\x11', 'bxne r2', {}),
	(b'\x22\xff\x2f\xe1', 'bxj r2', {}),
	(b'\x22\xff\x2f\x11', 'bxjne r2', {}),
	(b'\x81\x17\x11\xee', 'cdp p7, #0x1, c1, c1, c1, #0x4', {}),
	(b'\x81\x17\x11\xfe', 'cdp2 p7, #0x1, c1, c1, c1, #0x4', {}),
	(b'\xe0\x6c\x0c\xfe', 'cdp2 p12, #0, c6, c12, c0, #0x7', {}),
	(b'\x81\x17\x11\x1e', 'cdpne p7, #0x1, c1, c1, c1, #0x4', {}),
	(b'\x1f\xf0\x7f\xf5', 'clrex ', {}),
	(b'\x12\x1f\x6f\xe1', 'clz r1, r2', {}),
	(b'\x12\x1f\x6f\x01', 'clzeq r1, r2', {}),
	(b'\x0f\x00\x71\xe3', 'cmn r1, #0xf', {}),
	(b'\x06\x00\x71\xe1', 'cmn r1, r6', {}),
	(b'\x06\x05\x71\xe1', 'cmn r1, r6, lsl #0xa', {}),
	(b'\x26\x05\x71\xe1', 'cmn r1, r6, lsr #0xa', {}),
	(b'\x26\x05\x7d\xe1', 'cmn sp, r6, lsr #0xa', {}),
	(b'\x46\x05\x71\xe1', 'cmn r1, r6, asr #0xa', {}),
	(b'\x66\x05\x71\xe1', 'cmn r1, r6, ror #0xa', {}),
	(b'\x18\x02\x77\xe1', 'cmn r7, r8, lsl r2', {}),
	(b'\x38\x02\x7d\xe1', 'cmn sp, r8, lsr r2', {}),
	(b'\x58\x02\x77\xe1', 'cmn r7, r8, asr r2', {}),
	(b'\x78\x02\x77\xe1', 'cmn r7, r8, ror r2', {}),
	(b'\x66\x00\x71\xe1', 'cmn r1, r6, rrx', {}),
	(b'\x0f\x00\x51\xe3', 'cmp r1, #0xf', {}),
	(b'\x06\x00\x51\xe1', 'cmp r1, r6', {}),
	(b'\x06\x05\x51\xe1', 'cmp r1, r6, lsl #0xa', {}),
	(b'\x26\x05\x51\xe1', 'cmp r1, r6, lsr #0xa', {}),
	(b'\x26\x05\x5d\xe1', 'cmp sp, r6, lsr #0xa', {}),
	(b'\x46\x05\x51\xe1', 'cmp r1, r6, asr #0xa', {}),
	(b'\x66\x05\x51\xe1', 'cmp r1, r6, ror #0xa', {}),
	(b'\x18\x02\x57\xe1', 'cmp r7, r8, lsl r2', {}),
	(b'\x38\x02\x5d\xe1', 'cmp sp, r8, lsr r2', {}),
	(b'\x58\x02\x57\xe1', 'cmp r7, r8, asr r2', {}),
	(b'\x78\x02\x57\xe1', 'cmp r7, r8, ror r2', {}),
	(b'\x66\x00\x51\xe1', 'cmp r1, r6, rrx', {}),
	(b'\x02\x00\x70\xe3', 'cmn r0, #0x2', {}),
	(b'\x00\x00\x5e\xe3', 'cmp lr, #0', {}),
	(b'\xc0\x01\x08\xf1', 'cpsie aif', {}),
	(b'\x0f\x00\x02\xf1', 'cps #0xf', {}),
	(b'\xca\x00\x0e\xf1', 'cpsid if, #0xa', {}),
	(b'\xf0\xf0\x20\xe3', 'dbg #0', {}),
	(b'\xf5\xf0\x20\xe3', 'dbg #0x5', {}),
	(b'\xff\xf0\x20\xe3', 'dbg #0xf', {}),
	(b'\x5f\xf0\x7f\xf5', 'dmb sy', {}),
	(b'\x5e\xf0\x7f\xf5', 'dmb st', {}),
	(b'\x5d\xf0\x7f\xf5', 'dmb #0xd', {}),
	(b'\x5c\xf0\x7f\xf5', 'dmb #0xc', {}),
	(b'\x5b\xf0\x7f\xf5', 'dmb ish', {}),
	(b'\x5a\xf0\x7f\xf5', 'dmb ishst', {}),
	(b'\x59\xf0\x7f\xf5', 'dmb #0x9', {}),
	(b'\x58\xf0\x7f\xf5', 'dmb #0x8', {}),
	(b'\x57\xf0\x7f\xf5', 'dmb nsh', {}),
	(b'\x56\xf0\x7f\xf5', 'dmb nshst', {}),
	(b'\x55\xf0\x7f\xf5', 'dmb #0x5', {}),
	(b'\x54\xf0\x7f\xf5', 'dmb #0x4', {}),
	(b'\x53\xf0\x7f\xf5', 'dmb osh', {}),
	(b'\x52\xf0\x7f\xf5', 'dmb oshst', {}),
	(b'\x51\xf0\x7f\xf5', 'dmb #0x1', {}),
	(b'\x50\xf0\x7f\xf5', 'dmb #0', {}),
	(b'\x5f\xf0\x7f\xf5', 'dmb sy', {}),
	(b'\x5e\xf0\x7f\xf5', 'dmb st', {}),
	(b'\x5b\xf0\x7f\xf5', 'dmb ish', {}),
	(b'\x5b\xf0\x7f\xf5', 'dmb ish', {}),
	(b'\x5a\xf0\x7f\xf5', 'dmb ishst', {}),
	(b'\x5a\xf0\x7f\xf5', 'dmb ishst', {}),
	(b'\x57\xf0\x7f\xf5', 'dmb nsh', {}),
	(b'\x57\xf0\x7f\xf5', 'dmb nsh', {}),
	(b'\x56\xf0\x7f\xf5', 'dmb nshst', {}),
	(b'\x56\xf0\x7f\xf5', 'dmb nshst', {}),
	(b'\x53\xf0\x7f\xf5', 'dmb osh', {}),
	(b'\x52\xf0\x7f\xf5', 'dmb oshst', {}),
	(b'\x5f\xf0\x7f\xf5', 'dmb sy', {}),
	(b'\x4f\xf0\x7f\xf5', 'dsb sy', {}),
	(b'\x4e\xf0\x7f\xf5', 'dsb st', {}),
	(b'\x4d\xf0\x7f\xf5', 'dsb #0xd', {}),
	(b'\x4c\xf0\x7f\xf5', 'dsb #0xc', {}),
	(b'\x4b\xf0\x7f\xf5', 'dsb ish', {}),
	(b'\x4a\xf0\x7f\xf5', 'dsb ishst', {}),
	(b'\x49\xf0\x7f\xf5', 'dsb #0x9', {}),
	(b'\x48\xf0\x7f\xf5', 'dsb #0x8', {}),
	(b'\x47\xf0\x7f\xf5', 'dsb nsh', {}),
	(b'\x46\xf0\x7f\xf5', 'dsb nshst', {}),
	(b'\x45\xf0\x7f\xf5', 'dsb #0x5', {}),
	(b'\x44\xf0\x7f\xf5', 'dsb #0x4', {}),
	(b'\x43\xf0\x7f\xf5', 'dsb osh', {}),
	(b'\x42\xf0\x7f\xf5', 'dsb oshst', {}),
	(b'\x41\xf0\x7f\xf5', 'dsb #0x1', {}),
	(b'\x40\xf0\x7f\xf5', 'dsb #0', {}),
	(b'\x48\xf0\x7f\xf5', 'dsb #0x8', {}),
	(b'\x47\xf0\x7f\xf5', 'dsb nsh', {}),
	(b'\x4f\xf0\x7f\xf5', 'dsb sy', {}),
	(b'\x4e\xf0\x7f\xf5', 'dsb st', {}),
	(b'\x4b\xf0\x7f\xf5', 'dsb ish', {}),
	(b'\x4b\xf0\x7f\xf5', 'dsb ish', {}),
	(b'\x4a\xf0\x7f\xf5', 'dsb ishst', {}),
	(b'\x4a\xf0\x7f\xf5', 'dsb ishst', {}),
	(b'\x47\xf0\x7f\xf5', 'dsb nsh', {}),
	(b'\x47\xf0\x7f\xf5', 'dsb nsh', {}),
	(b'\x46\xf0\x7f\xf5', 'dsb nshst', {}),
	(b'\x46\xf0\x7f\xf5', 'dsb nshst', {}),
	(b'\x43\xf0\x7f\xf5', 'dsb osh', {}),
	(b'\x42\xf0\x7f\xf5', 'dsb oshst', {}),
	(b'\x4f\xf0\x7f\xf5', 'dsb sy', {}),
	(b'\x4f\xf0\x7f\xf5', 'dsb sy', {}),
	(b'\x42\xf0\x7f\xf5', 'dsb oshst', {}),
	(b'\x0f\x4a\x25\xe2', 'eor r4, r5, #0xf000', {}),
	(b'\x06\x40\x25\xe0', 'eor r4, r5, r6', {}),
	(b'\x86\x42\x25\xe0', 'eor r4, r5, r6, lsl #0x5', {}),
	(b'\xa6\x42\x25\xe0', 'eor r4, r5, r6, lsr #0x5', {}),
	(b'\xa6\x42\x25\xe0', 'eor r4, r5, r6, lsr #0x5', {}),
	(b'\xc6\x42\x25\xe0', 'eor r4, r5, r6, asr #0x5', {}),
	(b'\xe6\x42\x25\xe0', 'eor r4, r5, r6, ror #0x5', {}),
	(b'\x18\x69\x27\xe0', 'eor r6, r7, r8, lsl r9', {}),
	(b'\x38\x69\x27\xe0', 'eor r6, r7, r8, lsr r9', {}),
	(b'\x58\x69\x27\xe0', 'eor r6, r7, r8, asr r9', {}),
	(b'\x78\x69\x27\xe0', 'eor r6, r7, r8, ror r9', {}),
	(b'\x66\x40\x25\xe0', 'eor r4, r5, r6, rrx', {}),
	(b'\x0f\x5a\x25\xe2', 'eor r5, r5, #0xf000', {}),
	(b'\x05\x40\x24\xe0', 'eor r4, r4, r5', {}),
	(b'\x85\x42\x24\xe0', 'eor r4, r4, r5, lsl #0x5', {}),
	(b'\xa5\x42\x24\xe0', 'eor r4, r4, r5, lsr #0x5', {}),
	(b'\xa5\x42\x24\xe0', 'eor r4, r4, r5, lsr #0x5', {}),
	(b'\xc5\x42\x24\xe0', 'eor r4, r4, r5, asr #0x5', {}),
	(b'\xe5\x42\x24\xe0', 'eor r4, r4, r5, ror #0x5', {}),
	(b'\x17\x69\x26\xe0', 'eor r6, r6, r7, lsl r9', {}),
	(b'\x37\x69\x26\xe0', 'eor r6, r6, r7, lsr r9', {}),
	(b'\x57\x69\x26\xe0', 'eor r6, r6, r7, asr r9', {}),
	(b'\x77\x69\x26\xe0', 'eor r6, r6, r7, ror r9', {}),
	(b'\x65\x40\x24\xe0', 'eor r4, r4, r5, rrx', {}),
	(b'\x22\x30\x21\xe0', 'eor r3, r1, r2, lsr #0x20', {}),
	(b'\x42\x30\x21\xe0', 'eor r3, r1, r2, asr #0x20', {}),
	(b'\x6f\xf0\x7f\xf5', 'isb sy', {}),
	(b'\x6f\xf0\x7f\xf5', 'isb sy', {}),
	(b'\x6f\xf0\x7f\xf5', 'isb sy', {}),
	(b'\x61\xf0\x7f\xf5', 'isb #0x1', {}),
	(b'\x01\x80\x91\xfd', 'ldc2 p0, c8, [r1, #0x4]', {}),
	(b'\x00\x71\x92\xfd', 'ldc2 p1, c7, [r2]', {}),
	(b'\x38\x62\x13\xfd', 'ldc2 p2, c6, [r3, ', {}),
	(b'\x1e\x53\x34\xfd', 'ldc2 p3, c5, [r4, !', {}),
	(b'\x04\x44\xb5\xfc', 'ldc2 p4, c4, [r5], #0x10', {}),
	(b'\x12\x35\x36\xfc', 'ldc2 p5, c3, [r6], #-0x48', {}),
	(b'\x01\x26\xd7\xfd', 'ldc2l p6, c2, [r7, #0x4]', {}),
	(b'\x00\x17\xd8\xfd', 'ldc2l p7, c1, [r8]', {}),
	(b'\x38\x08\x59\xfd', 'ldc2l p8, c0, [r9, ', {}),
	(b'\x1e\x19\x7a\xfd', 'ldc2l p9, c1, [r10, !', {}),
	(b'\x04\x20\xfb\xfc', 'ldc2l p0, c2, [r11], #0x10', {}),
	(b'\x12\x31\x7c\xfc', 'ldc2l p1, c3, [r12], #-0x48', {}),
	(b'\x01\x4c\x90\xed', 'ldc p12, c4, [r0, #0x4]', {}),
	(b'\x00\x5d\x91\xed', 'ldc p13, c5, [r1]', {}),
	(b'\x38\x6e\x12\xed', 'ldc p14, c6, [r2, ', {}),
	(b'\x1e\x7f\x33\xed', 'ldc p15, c7, [r3, !', {}),
	(b'\x04\x85\xb4\xec', 'ldc p5, c8, [r4], #0x10', {}),
	(b'\x12\x94\x35\xec', 'ldc p4, c9, [r5], #-0x48', {}),
	(b'\x01\xa3\xd6\xed', 'ldcl p3, c10, [r6, #0x4]', {}),
	(b'\x00\xb2\xd7\xed', 'ldcl p2, c11, [r7]', {}),
	(b'\x38\xc1\x58\xed', 'ldcl p1, c12, [r8, ', {}),
	(b'\x1e\xd0\x79\xed', 'ldcl p0, c13, [r9, !', {}),
	(b'\x04\xe6\xfa\xec', 'ldcl p6, c14, [r10], #0x10', {}),
	(b'\x12\xf7\x7b\xec', 'ldcl p7, c15, [r11], #-0x48', {}),
	(b'\x01\x4c\x90\x3d', 'ldclo p12, c4, [r0, #0x4]', {}),
	(b'\x00\x5d\x91\x8d', 'ldchi p13, c5, [r1]', {}),
	(b'\x38\x6e\x12\x2d', 'ldchs p14, c6, [r2, ', {}),
	(b'\x1e\x7f\x33\x3d', 'ldclo p15, c7, [r3, !', {}),
	(b'\x04\x85\xb4\x0c', 'ldceq p5, c8, [r4], #0x10', {}),
	(b'\x12\x94\x35\xcc', 'ldcgt p4, c9, [r5], #-0x48', {}),
	(b'\x01\xa3\xd6\xbd', 'ldcllt p3, c10, [r6, #0x4]', {}),
	(b'\x00\xb2\xd7\xad', 'ldclge p2, c11, [r7]', {}),
	(b'\x38\xc1\x58\xdd', 'ldclle p1, c12, [r8, ', {}),
	(b'\x1e\xd0\x79\x1d', 'ldclne p0, c13, [r9, !', {}),
	(b'\x04\xe6\xfa\x0c', 'ldcleq p6, c14, [r10], #0x10', {}),
	(b'\x12\xf7\x7b\x8c', 'ldclhi p7, c15, [r11], #-0x48', {}),
	(b'\x19\x82\x91\xfc', 'ldc2 p2, c8, [r1], {25}', {}),
	(b'\x7a\x20\x92\xe8', 'ldm r2, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x20\x92\xe8', 'ldm r2, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x20\x92\xe9', 'ldmib r2, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x20\x12\xe8', 'ldmda r2, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x20\x12\xe9', 'ldmdb r2, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x20\x92\xe8', 'ldm r2, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x20\xb2\xe8', 'ldm r2!, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x20\xb2\xe9', 'ldmib r2!, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x20\x32\xe8', 'ldmda r2!, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x20\x32\xe9', 'ldmdb r2!, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x05\x40\xd0\xe8', 'ldm r0, {r0, r2, lr} ^', {}),
	(b'\x0f\x80\xfd\xe8', 'ldm sp!, {r0, r1, r2, r3, pc} ^', {}),
	(b'\xb0\x80\x7b\x80', 'ldrhthi r8, [r11], #-0', {}),
	(b'\xb0\x80\xfb\x80', 'ldrhthi r8, [r11], #0', {}),
	(b'\x84\x2f\xa0\xe1', 'lsl r2, r4, #0x1f', {}),
	(b'\x84\x20\xa0\xe1', 'lsl r2, r4, #0x1', {}),
	(b'\x04\x20\xa0\xe1', 'mov r2, r4', {}),
	(b'\x84\x40\xa0\xe1', 'lsl r4, r4, #0x1', {}),
	(b'\x24\x20\xa0\xe1', 'lsr r2, r4, #0x20', {}),
	(b'\x24\x21\xa0\xe1', 'lsr r2, r4, #0x2', {}),
	(b'\x04\x20\xa0\xe1', 'mov r2, r4', {}),
	(b'\x24\x41\xa0\xe1', 'lsr r4, r4, #0x2', {}),
	(b'\x91\x57\x21\xee', 'mcr p7, #0x1, r5, c1, c1, #0x4', {}),
	(b'\x91\x57\x21\xfe', 'mcr2 p7, #0x1, r5, c1, c1, #0x4', {}),
	(b'\x91\x57\x21\x9e', 'mcrls p7, #0x1, r5, c1, c1, #0x4', {}),
	(b'\xf1\x57\x44\xec', 'mcrr p7, #0x15, r5, r4, c1', {}),
	(b'\xf1\x57\x44\xfc', 'mcrr2 p7, #0x15, r5, r4, c1', {}),
	(b'\xf1\x57\x44\xcc', 'mcrrgt p7, #0x15, r5, r4, c1', {}),
	(b'\x92\x43\x21\xe0', 'mla r1, r2, r3, r4', {}),
	(b'\x92\x43\x31\xe0', 'mlas r1, r2, r3, r4', {}),
	(b'\x92\x43\x21\x10', 'mlane r1, r2, r3, r4', {}),
	(b'\x92\x43\x31\x10', 'mlasne r1, r2, r3, r4', {}),
	(b'\x95\x36\x62\xe0', 'mls r2, r5, r6, r3', {}),
	(b'\x95\x36\x62\x10', 'mlsne r2, r5, r6, r3', {}),
	(b'\x07\x30\xa0\xe3', 'mov r3, #0x7', {}),
	(b'\xff\x4e\xa0\xe3', 'mov r4, #0xff0', {}),
	(b'\xff\x58\xa0\xe3', 'mov r5, #0xff0000', {}),
	(b'\xff\x6f\x0f\xe3', 'movw r6, #0xffff', {}),
	(b'\xff\x9f\x0f\xe3', 'movw r9, #0xffff', {}),
	(b'\x07\x30\xb0\xe3', 'movs r3, #0x7', {}),
	(b'\xff\x4e\xa0\x03', 'moveq r4, #0xff0', {}),
	(b'\xff\x58\xb0\x03', 'mov.seq r5, #0xff0000', {}),
	(b'\x03\x20\xa0\xe1', 'mov r2, r3', {}),
	(b'\x03\x20\xb0\xe1', 'movs r2, r3', {}),
	(b'\x03\x20\xa0\x01', 'moveq r2, r3', {}),
	(b'\x03\x20\xb0\x01', 'mov.seq r2, r3', {}),
	(b'\x08\xc0\xa0\xe1', 'mov r12, r8', {}),
	(b'\x03\x20\xa0\xe1', 'mov r2, r3', {}),
	(b'\x08\xc0\xa0\xe1', 'mov r12, r8', {}),
	(b'\x03\x20\xa0\xe1', 'mov r2, r3', {}),
	(b'\x08\xc0\xa0\xe1', 'mov r12, r8', {}),
	(b'\x03\x20\xa0\xe1', 'mov r2, r3', {}),
	(b'\x08\xc0\xa0\xe1', 'mov r12, r8', {}),
	(b'\x03\x20\xa0\xe1', 'mov r2, r3', {}),
	(b'\x07\x30\x40\xe3', 'movt r3, #0x7', {}),
	(b'\xff\x6f\x4f\xe3', 'movt r6, #0xffff', {}),
	(b'\xf0\x4f\x40\x03', 'movteq r4, #0xff0', {}),
	(b'\x92\x1e\x11\xee', 'mrc p14, #0, r1, c1, c2, #0x4', {}),
	(b'\xd6\xff\xff\xee', 'mrc p15, #0x7, apsr_nzcv, c15, c6, #0x6', {}),
	(b'\x92\x1e\x11\xfe', 'mrc2 p14, #0, r1, c1, c2, #0x4', {}),
	(b'\x30\xf9\xff\xfe', 'mrc2 p9, #0x7, apsr_nzcv, c15, c0, #0x1', {}),
	(b'\xd6\xff\xff\x0e', 'mrceq p15, #0x7, apsr_nzcv, c15, c6, #0x6', {}),
	(b'\x11\x57\x54\xec', 'mrrc p7, #0x1, r5, r4, c1', {}),
	(b'\x11\x57\x54\xfc', 'mrrc2 p7, #0x1, r5, r4, c1', {}),
	(b'\x11\x57\x54\x3c', 'mrrclo p7, #0x1, r5, r4, c1', {}),
	(b'\x96\x07\x05\xe0', 'mul r5, r6, r7', {}),
	(b'\x96\x07\x15\xe0', 'muls r5, r6, r7', {}),
	(b'\x96\x07\x05\xc0', 'mulgt r5, r6, r7', {}),
	(b'\x96\x07\x15\xd0', 'mulsle r5, r6, r7', {}),
	(b'\x07\x30\xe0\xe3', 'mvn r3, #0x7', {}),
	(b'\xff\x4e\xe0\xe3', 'mvn r4, #0xff0', {}),
	(b'\xff\x58\xe0\xe3', 'mvn r5, #0xff0000', {}),
	(b'\x07\x30\xf0\xe3', 'mvns r3, #0x7', {}),
	(b'\xff\x4e\xe0\x03', 'mvneq r4, #0xff0', {}),
	(b'\xff\x58\xf0\x03', 'mvn.seq r5, #0xff0000', {}),
	(b'\x03\x20\xe0\xe1', 'mvn r2, r3', {}),
	(b'\x03\x20\xf0\xe1', 'mvns r2, r3', {}),
	(b'\x86\x59\xe0\xe1', 'mvn r5, r6, lsl #0x13', {}),
	(b'\xa6\x54\xe0\xe1', 'mvn r5, r6, lsr #0x9', {}),
	(b'\x46\x52\xe0\xe1', 'mvn r5, r6, asr #0x4', {}),
	(b'\x66\x53\xe0\xe1', 'mvn r5, r6, ror #0x6', {}),
	(b'\x66\x50\xe0\xe1', 'mvn r5, r6, rrx', {}),
	(b'\x03\x20\xe0\x01', 'mvneq r2, r3', {}),
	(b'\x03\x25\xf0\x01', 'mvn.seq r2, r3, lsl #0xa', {}),
	(b'\x16\x57\xe0\xe1', 'mvn r5, r6, lsl r7', {}),
	(b'\x36\x57\xf0\xe1', 'mvns r5, r6, lsr r7', {}),
	(b'\x56\x57\xe0\xc1', 'mvngt r5, r6, asr r7', {}),
	(b'\x76\x57\xf0\xb1', 'mvnslt r5, r6, ror r7', {}),
	(b'\x00\x50\x68\xe2', 'rsb r5, r8, #0', {}),
	(b'\x00\xf0\x20\xe3', 'nop ', {}),
	(b'\x00\xf0\x20\xe3', 'nop ', {}),
	(b'\x00\xf0\x20\xc3', 'nopgt ', {}),
	(b'\x0f\x4a\x85\xe3', 'orr r4, r5, #0xf000', {}),
	(b'\x06\x40\x85\xe1', 'orr r4, r5, r6', {}),
	(b'\x86\x42\x85\xe1', 'orr r4, r5, r6, lsl #0x5', {}),
	(b'\xa6\x42\x85\xe1', 'orr r4, r5, r6, lsr #0x5', {}),
	(b'\xa6\x42\x85\xe1', 'orr r4, r5, r6, lsr #0x5', {}),
	(b'\xc6\x42\x85\xe1', 'orr r4, r5, r6, asr #0x5', {}),
	(b'\xe6\x42\x85\xe1', 'orr r4, r5, r6, ror #0x5', {}),
	(b'\x18\x69\x87\xe1', 'orr r6, r7, r8, lsl r9', {}),
	(b'\x38\x69\x87\xe1', 'orr r6, r7, r8, lsr r9', {}),
	(b'\x58\x69\x87\xe1', 'orr r6, r7, r8, asr r9', {}),
	(b'\x78\x69\x87\xe1', 'orr r6, r7, r8, ror r9', {}),
	(b'\x66\x40\x85\xe1', 'orr r4, r5, r6, rrx', {}),
	(b'\x0f\x5a\x85\xe3', 'orr r5, r5, #0xf000', {}),
	(b'\x05\x40\x84\xe1', 'orr r4, r4, r5', {}),
	(b'\x85\x42\x84\xe1', 'orr r4, r4, r5, lsl #0x5', {}),
	(b'\xa5\x42\x84\xe1', 'orr r4, r4, r5, lsr #0x5', {}),
	(b'\xa5\x42\x84\xe1', 'orr r4, r4, r5, lsr #0x5', {}),
	(b'\xc5\x42\x84\xe1', 'orr r4, r4, r5, asr #0x5', {}),
	(b'\xe5\x42\x84\xe1', 'orr r4, r4, r5, ror #0x5', {}),
	(b'\x17\x69\x86\xe1', 'orr r6, r6, r7, lsl r9', {}),
	(b'\x37\x69\x86\xe1', 'orr r6, r6, r7, lsr r9', {}),
	(b'\x57\x69\x86\xe1', 'orr r6, r6, r7, asr r9', {}),
	(b'\x77\x69\x86\xe1', 'orr r6, r6, r7, ror r9', {}),
	(b'\x65\x40\x84\xe1', 'orr r4, r4, r5, rrx', {}),
	(b'\x0f\x4a\x95\x03', 'orr.seq r4, r5, #0xf000', {}),
	(b'\x06\x40\x85\x11', 'orrne r4, r5, r6', {}),
	(b'\x86\x42\x95\x01', 'orr.seq r4, r5, r6, lsl #0x5', {}),
	(b'\x78\x69\x87\x31', 'orrlo r6, r7, r8, ror r9', {}),
	(b'\x66\x40\x95\x81', 'orrshi r4, r5, r6, rrx', {}),
	(b'\x0f\x5a\x85\x23', 'orrhs r5, r5, #0xf000', {}),
	(b'\x05\x40\x94\x01', 'orr.seq r4, r4, r5', {}),
	(b'\x57\x69\x86\x11', 'orrne r6, r6, r7, asr r9', {}),
	(b'\x77\x69\x96\xb1', 'orrslt r6, r6, r7, ror r9', {}),
	(b'\x65\x40\x94\xc1', 'orrsgt r4, r4, r5, rrx', {}),
	(b'\x22\x30\x81\xe1', 'orr r3, r1, r2, lsr #0x20', {}),
	(b'\x42\x30\x81\xe1', 'orr r3, r1, r2, asr #0x20', {}),
	(b'\x13\x20\x82\xe6', 'pkhbt r2, r2, r3', {}),
	(b'\x93\x2f\x82\xe6', 'pkhbt r2, r2, r3, lsl #0x1f', {}),
	(b'\x13\x20\x82\xe6', 'pkhbt r2, r2, r3', {}),
	(b'\x93\x27\x82\xe6', 'pkhbt r2, r2, r3, lsl #0xf', {}),
	(b'\x13\x20\x82\xe6', 'pkhbt r2, r2, r3', {}),
	(b'\xd3\x2f\x82\xe6', 'pkhtb r2, r2, r3, asr #0x1f', {}),
	(b'\xd3\x27\x82\xe6', 'pkhtb r2, r2, r3, asr #0xf', {}),
	(b'\x04\x70\x9d\xe4', 'pop {r7}', {}),
	(b'\x80\x07\xbd\xe8', 'pop {r7, r8, r9, r10}', {}),
	(b'\x04\x70\x2d\xe5', 'str r7, [sp, #-0x4]!', {}),
	(b'\x80\x07\x2d\xe9', 'push {r7, r8, r9, r10}', {}),
	(b'\x52\x10\x03\xe1', 'qadd r1, r2, r3', {}),
	(b'\x52\x10\x03\x11', 'qaddne r1, r2, r3', {}),
	(b'\x13\x1f\x22\xe6', 'qadd16 r1, r2, r3', {}),
	(b'\x13\x1f\x22\xc6', 'qadd16gt r1, r2, r3', {}),
	(b'\x93\x1f\x22\xe6', 'qadd8 r1, r2, r3', {}),
	(b'\x93\x1f\x22\xd6', 'qadd8le r1, r2, r3', {}),
	(b'\x57\x60\x48\xe1', 'qdadd r6, r7, r8', {}),
	(b'\x57\x60\x48\x81', 'qdaddhi r6, r7, r8', {}),
	(b'\x57\x60\x68\xe1', 'qdsub r6, r7, r8', {}),
	(b'\x57\x60\x68\x81', 'qdsubhi r6, r7, r8', {}),
	(b'\x50\x9f\x2c\xe6', 'qsax r9, r12, r0', {}),
	(b'\x50\x9f\x2c\x06', 'qsaxeq r9, r12, r0', {}),
	(b'\x52\x10\x23\xe1', 'qsub r1, r2, r3', {}),
	(b'\x52\x10\x23\x11', 'qsubne r1, r2, r3', {}),
	(b'\x73\x1f\x22\xe6', 'qsub16 r1, r2, r3', {}),
	(b'\x73\x1f\x22\xc6', 'qsub16gt r1, r2, r3', {}),
	(b'\xf3\x1f\x22\xe6', 'qsub8 r1, r2, r3', {}),
	(b'\xf3\x1f\x22\xd6', 'qsub8le r1, r2, r3', {}),
	(b'\x32\x1f\xff\xe6', 'rbit r1, r2', {}),
	(b'\x32\x1f\xff\x16', 'rbitne r1, r2', {}),
	(b'\x39\x1f\xbf\xe6', 'rev r1, r9', {}),
	(b'\x35\x1f\xbf\x16', 'revne r1, r5', {}),
	(b'\xb3\x8f\xbf\xe6', 'rev16 r8, r3', {}),
	(b'\xb4\xcf\xbf\x16', 'rev16ne r12, r4', {}),
	(b'\xb9\x4f\xff\xe6', 'revsh r4, r9', {}),
	(b'\xb1\x9f\xff\x16', 'revshne r9, r1', {}),
	(b'\x00\x0a\x12\xf8', 'rfeda r2', {}),
	(b'\x00\x0a\x13\xf9', 'rfedb r3', {}),
	(b'\x00\x0a\x95\xf8', 'rfeia r5', {}),
	(b'\x00\x0a\x96\xf9', 'rfeib r6', {}),
	(b'\x00\x0a\x34\xf8', 'rfeda r4!', {}),
	(b'\x00\x0a\x37\xf9', 'rfedb r7!', {}),
	(b'\x00\x0a\xb9\xf8', 'rfeia r9!', {}),
	(b'\x00\x0a\xb8\xf9', 'rfeib r8!', {}),
	(b'\x00\x0a\x12\xf8', 'rfeda r2', {}),
	(b'\x00\x0a\x13\xf9', 'rfedb r3', {}),
	(b'\x00\x0a\x95\xf8', 'rfeia r5', {}),
	(b'\x00\x0a\x96\xf9', 'rfeib r6', {}),
	(b'\x00\x0a\x34\xf8', 'rfeda r4!', {}),
	(b'\x00\x0a\x37\xf9', 'rfedb r7!', {}),
	(b'\x00\x0a\xb9\xf8', 'rfeia r9!', {}),
	(b'\x00\x0a\xb8\xf9', 'rfeib r8!', {}),
	(b'\x00\x0a\x91\xf8', 'rfeia r1', {}),
	(b'\x00\x0a\xb1\xf8', 'rfeia r1!', {}),
	(b'\xe4\x2f\xa0\xe1', 'ror r2, r4, #0x1f', {}),
	(b'\xe4\x20\xa0\xe1', 'ror r2, r4, #0x1', {}),
	(b'\x04\x20\xa0\xe1', 'mov r2, r4', {}),
	(b'\xe4\x40\xa0\xe1', 'ror r4, r4, #0x1', {}),
	(b'\x0f\x4a\x65\xe2', 'rsb r4, r5, #0xf000', {}),
	(b'\x06\x40\x65\xe0', 'rsb r4, r5, r6', {}),
	(b'\x86\x42\x65\xe0', 'rsb r4, r5, r6, lsl #0x5', {}),
	(b'\xa6\x42\x65\x30', 'rsblo r4, r5, r6, lsr #0x5', {}),
	(b'\xa6\x42\x65\xe0', 'rsb r4, r5, r6, lsr #0x5', {}),
	(b'\xc6\x42\x65\xe0', 'rsb r4, r5, r6, asr #0x5', {}),
	(b'\xe6\x42\x65\xe0', 'rsb r4, r5, r6, ror #0x5', {}),
	(b'\x18\x69\x67\xe0', 'rsb r6, r7, r8, lsl r9', {}),
	(b'\x38\x69\x67\xe0', 'rsb r6, r7, r8, lsr r9', {}),
	(b'\x58\x69\x67\xe0', 'rsb r6, r7, r8, asr r9', {}),
	(b'\x78\x69\x67\xd0', 'rsble r6, r7, r8, ror r9', {}),
	(b'\x66\x40\x65\xe0', 'rsb r4, r5, r6, rrx', {}),
	(b'\x0f\x5a\x65\xe2', 'rsb r5, r5, #0xf000', {}),
	(b'\x05\x40\x64\xe0', 'rsb r4, r4, r5', {}),
	(b'\x85\x42\x64\xe0', 'rsb r4, r4, r5, lsl #0x5', {}),
	(b'\xa5\x42\x64\xe0', 'rsb r4, r4, r5, lsr #0x5', {}),
	(b'\xa5\x42\x64\x10', 'rsbne r4, r4, r5, lsr #0x5', {}),
	(b'\xc5\x42\x64\xe0', 'rsb r4, r4, r5, asr #0x5', {}),
	(b'\xe5\x42\x64\xe0', 'rsb r4, r4, r5, ror #0x5', {}),
	(b'\x17\x69\x66\xc0', 'rsbgt r6, r6, r7, lsl r9', {}),
	(b'\x37\x69\x66\xe0', 'rsb r6, r6, r7, lsr r9', {}),
	(b'\x57\x69\x66\xe0', 'rsb r6, r6, r7, asr r9', {}),
	(b'\x77\x69\x66\xe0', 'rsb r6, r6, r7, ror r9', {}),
	(b'\x65\x40\x64\xe0', 'rsb r4, r4, r5, rrx', {}),
	(b'\x0f\x4a\xe5\xe2', 'rsc r4, r5, #0xf000', {}),
	(b'\x06\x40\xe5\xe0', 'rsc r4, r5, r6', {}),
	(b'\x86\x42\xe5\xe0', 'rsc r4, r5, r6, lsl #0x5', {}),
	(b'\xa6\x42\xe5\x30', 'rsclo r4, r5, r6, lsr #0x5', {}),
	(b'\xa6\x42\xe5\xe0', 'rsc r4, r5, r6, lsr #0x5', {}),
	(b'\xc6\x42\xe5\xe0', 'rsc r4, r5, r6, asr #0x5', {}),
	(b'\xe6\x42\xe5\xe0', 'rsc r4, r5, r6, ror #0x5', {}),
	(b'\x18\x69\xe7\xe0', 'rsc r6, r7, r8, lsl r9', {}),
	(b'\x38\x69\xe7\xe0', 'rsc r6, r7, r8, lsr r9', {}),
	(b'\x58\x69\xe7\xe0', 'rsc r6, r7, r8, asr r9', {}),
	(b'\x78\x69\xe7\xd0', 'rscle r6, r7, r8, ror r9', {}),
	(b'\xfe\x1e\xf8\xe2', 'rscs r1, r8, #0xfe0', {}),
	(b'\x0f\x5a\xe5\xe2', 'rsc r5, r5, #0xf000', {}),
	(b'\x05\x40\xe4\xe0', 'rsc r4, r4, r5', {}),
	(b'\x85\x42\xe4\xe0', 'rsc r4, r4, r5, lsl #0x5', {}),
	(b'\xa5\x42\xe4\xe0', 'rsc r4, r4, r5, lsr #0x5', {}),
	(b'\xa5\x42\xe4\x10', 'rscne r4, r4, r5, lsr #0x5', {}),
	(b'\xc5\x42\xe4\xe0', 'rsc r4, r4, r5, asr #0x5', {}),
	(b'\xe5\x42\xe4\xe0', 'rsc r4, r4, r5, ror #0x5', {}),
	(b'\x17\x69\xe6\xc0', 'rscgt r6, r6, r7, lsl r9', {}),
	(b'\x37\x69\xe6\xe0', 'rsc r6, r6, r7, lsr r9', {}),
	(b'\x57\x69\xe6\xe0', 'rsc r6, r6, r7, asr r9', {}),
	(b'\x77\x69\xe6\xe0', 'rsc r6, r6, r7, ror r9', {}),
	(b'\x61\x00\xa0\xe1', 'rrx r0, r1', {}),
	(b'\x6f\xd0\xa0\xe1', 'rrx sp, pc', {}),
	(b'\x6e\xf0\xa0\xe1', 'rrx pc, lr', {}),
	(b'\x6d\xe0\xa0\xe1', 'rrx lr, sp', {}),
	(b'\x61\x00\xb0\xe1', 'rrxs r0, r1', {}),
	(b'\x6f\xd0\xb0\xe1', 'rrxs sp, pc', {}),
	(b'\x6e\xf0\xb0\xe1', 'rrxs pc, lr', {}),
	(b'\x6d\xe0\xb0\xe1', 'rrxs lr, sp', {}),
	(b'\x13\x1f\x12\xe6', 'sadd16 r1, r2, r3', {}),
	(b'\x13\x1f\x12\xc6', 'sadd16gt r1, r2, r3', {}),
	(b'\x93\x1f\x12\xe6', 'sadd8 r1, r2, r3', {}),
	(b'\x93\x1f\x12\xd6', 'sadd8le r1, r2, r3', {}),
	(b'\x30\x9f\x1c\xe6', 'sasx r9, r12, r0', {}),
	(b'\x30\x9f\x1c\x06', 'sasxeq r9, r12, r0', {}),
	(b'\x0f\x4a\xc5\xe2', 'sbc r4, r5, #0xf000', {}),
	(b'\x06\x40\xc5\xe0', 'sbc r4, r5, r6', {}),
	(b'\x86\x42\xc5\xe0', 'sbc r4, r5, r6, lsl #0x5', {}),
	(b'\xa6\x42\xc5\xe0', 'sbc r4, r5, r6, lsr #0x5', {}),
	(b'\xa6\x42\xc5\xe0', 'sbc r4, r5, r6, lsr #0x5', {}),
	(b'\xc6\x42\xc5\xe0', 'sbc r4, r5, r6, asr #0x5', {}),
	(b'\xe6\x42\xc5\xe0', 'sbc r4, r5, r6, ror #0x5', {}),
	(b'\x18\x69\xc7\xe0', 'sbc r6, r7, r8, lsl r9', {}),
	(b'\x38\x69\xc7\xe0', 'sbc r6, r7, r8, lsr r9', {}),
	(b'\x58\x69\xc7\xe0', 'sbc r6, r7, r8, asr r9', {}),
	(b'\x78\x69\xc7\xe0', 'sbc r6, r7, r8, ror r9', {}),
	(b'\x0f\x5a\xc5\xe2', 'sbc r5, r5, #0xf000', {}),
	(b'\x05\x40\xc4\xe0', 'sbc r4, r4, r5', {}),
	(b'\x85\x42\xc4\xe0', 'sbc r4, r4, r5, lsl #0x5', {}),
	(b'\xa5\x42\xc4\xe0', 'sbc r4, r4, r5, lsr #0x5', {}),
	(b'\xa5\x42\xc4\xe0', 'sbc r4, r4, r5, lsr #0x5', {}),
	(b'\xc5\x42\xc4\xe0', 'sbc r4, r4, r5, asr #0x5', {}),
	(b'\xe5\x42\xc4\xe0', 'sbc r4, r4, r5, ror #0x5', {}),
	(b'\x17\x69\xc6\xe0', 'sbc r6, r6, r7, lsl r9', {}),
	(b'\x37\x69\xc6\xe0', 'sbc r6, r6, r7, lsr r9', {}),
	(b'\x57\x69\xc6\xe0', 'sbc r6, r6, r7, asr r9', {}),
	(b'\x77\x69\xc6\xe0', 'sbc r6, r6, r7, ror r9', {}),
	(b'\x55\x48\xa0\xe7', 'sbfx r4, r5, #0x16, #0x1', {}),
	(b'\x55\x48\xaf\xc7', 'sbfxgt r4, r5, #0x16, #0x10', {}),
	(b'\xb1\x9f\x82\xe6', 'sel r9, r2, r1', {}),
	(b'\xb1\x9f\x82\x16', 'selne r9, r2, r1', {}),
	(b'\x00\x02\x01\xf1', 'setend be', {}),
	(b'\x00\x02\x01\xf1', 'setend be', {}),
	(b'\x00\x00\x01\xf1', 'setend le', {}),
	(b'\x00\x00\x01\xf1', 'setend le', {}),
	(b'\x04\xf0\x20\xe3', 'sev ', {}),
	(b'\x04\xf0\x20\x03', 'seveq ', {}),
	(b'\x12\x4f\x38\xe6', 'shadd16 r4, r8, r2', {}),
	(b'\x12\x4f\x38\xc6', 'shadd16gt r4, r8, r2', {}),
	(b'\x92\x4f\x38\xe6', 'shadd8 r4, r8, r2', {}),
	(b'\x92\x4f\x38\xc6', 'shadd8gt r4, r8, r2', {}),
	(b'\x32\x4f\x38\xe6', 'shasx r4, r8, r2', {}),
	(b'\x32\x4f\x38\xc6', 'shasxgt r4, r8, r2', {}),
	(b'\x72\x4f\x38\xe6', 'shsub16 r4, r8, r2', {}),
	(b'\x72\x4f\x38\xc6', 'shsub16gt r4, r8, r2', {}),
	(b'\xf2\x4f\x38\xe6', 'shsub8 r4, r8, r2', {}),
	(b'\xf2\x4f\x38\xc6', 'shsub8gt r4, r8, r2', {}),
	(b'\x81\x09\x03\xe1', 'smlabb r3, r1, r9, r0', {}),
	(b'\xc6\x14\x05\xe1', 'smlabt r5, r6, r4, r1', {}),
	(b'\xa2\x23\x04\xe1', 'smlatb r4, r2, r3, r2', {}),
	(b'\xe3\x48\x08\xe1', 'smlatt r8, r3, r8, r4', {}),
	(b'\x81\x09\x03\xa1', 'smlabbge r3, r1, r9, r0', {}),
	(b'\xc6\x14\x05\xd1', 'smlabtle r5, r6, r4, r1', {}),
	(b'\xa2\x23\x04\x11', 'smlatbne r4, r2, r3, r2', {}),
	(b'\xe3\x48\x08\x01', 'smlatteq r8, r3, r8, r4', {}),
	(b'\x13\x85\x02\xe7', 'smlad r2, r3, r5, r8', {}),
	(b'\x33\x85\x02\xe7', 'smladx r2, r3, r5, r8', {}),
	(b'\x13\x85\x02\x07', 'smladeq r2, r3, r5, r8', {}),
	(b'\x33\x85\x02\x87', 'smladxhi r2, r3, r5, r8', {}),
	(b'\x95\x28\xe3\xe0', 'smlal r2, r3, r5, r8', {}),
	(b'\x95\x28\xf3\xe0', 'smlals r2, r3, r5, r8', {}),
	(b'\x95\x28\xe3\x00', 'smlaleq r2, r3, r5, r8', {}),
	(b'\x95\x28\xf3\x80', 'smlalshi r2, r3, r5, r8', {}),
	(b'\x89\x30\x41\xe1', 'smlalbb r3, r1, r9, r0', {}),
	(b'\xc4\x51\x46\xe1', 'smlalbt r5, r6, r4, r1', {}),
	(b'\xa3\x42\x42\xe1', 'smlaltb r4, r2, r3, r2', {}),
	(b'\xe8\x84\x43\xe1', 'smlaltt r8, r3, r8, r4', {}),
	(b'\x89\x30\x41\xa1', 'smlalbbge r3, r1, r9, r0', {}),
	(b'\xc4\x51\x46\xd1', 'smlalbtle r5, r6, r4, r1', {}),
	(b'\xa3\x42\x42\x11', 'smlaltbne r4, r2, r3, r2', {}),
	(b'\xe8\x84\x43\x01', 'smlaltteq r8, r3, r8, r4', {}),
	(b'\x15\x28\x43\xe7', 'smlald r2, r3, r5, r8', {}),
	(b'\x35\x28\x43\xe7', 'smlaldx r2, r3, r5, r8', {}),
	(b'\x15\x28\x43\x07', 'smlaldeq r2, r3, r5, r8', {}),
	(b'\x35\x28\x43\x87', 'smlaldxhi r2, r3, r5, r8', {}),
	(b'\x83\x8a\x22\xe1', 'smlawb r2, r3, r10, r8', {}),
	(b'\xc3\x95\x28\xe1', 'smlawt r8, r3, r5, r9', {}),
	(b'\x87\x85\x22\x01', 'smlawbeq r2, r7, r5, r8', {}),
	(b'\xc3\x80\x21\x81', 'smlawthi r1, r3, r0, r8', {}),
	(b'\x53\x85\x02\xe7', 'smlsd r2, r3, r5, r8', {}),
	(b'\x73\x85\x02\xe7', 'smlsdx r2, r3, r5, r8', {}),
	(b'\x53\x85\x02\x07', 'smlsdeq r2, r3, r5, r8', {}),
	(b'\x73\x85\x02\x87', 'smlsdxhi r2, r3, r5, r8', {}),
	(b'\x55\x21\x49\xe7', 'smlsld r2, r9, r5, r1', {}),
	(b'\x72\x48\x4b\xe7', 'smlsldx r4, r11, r2, r8', {}),
	(b'\x55\x86\x42\x07', 'smlsldeq r8, r2, r5, r6', {}),
	(b'\x73\x18\x40\x87', 'smlsldxhi r1, r0, r3, r8', {}),
	(b'\x12\x43\x51\xe7', 'smmla r1, r2, r3, r4', {}),
	(b'\x33\x12\x54\xe7', 'smmlar r4, r3, r2, r1', {}),
	(b'\x12\x43\x51\x37', 'smmlalo r1, r2, r3, r4', {}),
	(b'\x33\x12\x54\x27', 'smmlarhs r4, r3, r2, r1', {}),
	(b'\xd2\x43\x51\xe7', 'smmls r1, r2, r3, r4', {}),
	(b'\xf3\x12\x54\xe7', 'smmlsr r4, r3, r2, r1', {}),
	(b'\xd2\x43\x51\x37', 'smmlslo r1, r2, r3, r4', {}),
	(b'\xf3\x12\x54\x27', 'smmlsrhs r4, r3, r2, r1', {}),
	(b'\x13\xf4\x52\xe7', 'smmul r2, r3, r4', {}),
	(b'\x32\xf1\x53\xe7', 'smmulr r3, r2, r1', {}),
	(b'\x13\xf4\x52\x37', 'smmullo r2, r3, r4', {}),
	(b'\x32\xf1\x53\x27', 'smmulrhs r3, r2, r1', {}),
	(b'\x13\xf4\x02\xe7', 'smuad r2, r3, r4', {}),
	(b'\x32\xf1\x03\xe7', 'smuadx r3, r2, r1', {}),
	(b'\x13\xf4\x02\xb7', 'smuadlt r2, r3, r4', {}),
	(b'\x32\xf1\x03\xa7', 'smuadxge r3, r2, r1', {}),
	(b'\x89\x00\x63\xe1', 'smulbb r3, r9, r0', {}),
	(b'\xc4\x01\x65\xe1', 'smulbt r5, r4, r1', {}),
	(b'\xa2\x02\x64\xe1', 'smultb r4, r2, r2', {}),
	(b'\xe3\x04\x68\xe1', 'smultt r8, r3, r4', {}),
	(b'\x89\x00\x61\xa1', 'smulbbge r1, r9, r0', {}),
	(b'\xc6\x04\x65\xd1', 'smulbtle r5, r6, r4', {}),
	(b'\xa3\x02\x62\x11', 'smultbne r2, r3, r2', {}),
	(b'\xe3\x04\x68\x01', 'smultteq r8, r3, r4', {}),
	(b'\x90\x31\xc9\xe0', 'smull r3, r9, r0, r1', {}),
	(b'\x90\x32\xd9\xe0', 'smulls r3, r9, r0, r2', {}),
	(b'\x94\x85\xc3\x00', 'smulleq r8, r3, r4, r5', {}),
	(b'\x94\x83\xd3\x00', 'smull.seq r8, r3, r4, r3', {}),
	(b'\xa9\x00\x23\xe1', 'smulwb r3, r9, r0', {}),
	(b'\xe9\x02\x23\xe1', 'smulwt r3, r9, r2', {}),
	(b'\x50\xf1\x03\xe7', 'smusd r3, r0, r1', {}),
	(b'\x79\xf2\x03\xe7', 'smusdx r3, r9, r2', {}),
	(b'\x53\xf2\x08\x07', 'smusdeq r8, r3, r2', {}),
	(b'\x74\xf3\x07\x17', 'smusdxne r7, r4, r3', {}),
	(b'\x05\x05\x4d\xf8', 'srsda sp, #0x5', {}),
	(b'\x01\x05\x4d\xf9', 'srsdb sp, #0x1', {}),
	(b'\x00\x05\xcd\xf8', 'srsia sp, #0', {}),
	(b'\x0f\x05\xcd\xf9', 'srsib sp, #0xf', {}),
	(b'\x1f\x05\x6d\xf8', 'srsda sp!, #0x1f', {}),
	(b'\x13\x05\x6d\xf9', 'srsdb sp!, #0x13', {}),
	(b'\x02\x05\xed\xf8', 'srsia sp!, #0x2', {}),
	(b'\x0e\x05\xed\xf9', 'srsib sp!, #0xe', {}),
	(b'\x0b\x05\xcd\xf9', 'srsib sp, #0xb', {}),
	(b'\x0a\x05\xcd\xf8', 'srsia sp, #0xa', {}),
	(b'\x09\x05\x4d\xf9', 'srsdb sp, #0x9', {}),
	(b'\x05\x05\x4d\xf8', 'srsda sp, #0x5', {}),
	(b'\x05\x05\xed\xf9', 'srsib sp!, #0x5', {}),
	(b'\x05\x05\xed\xf8', 'srsia sp!, #0x5', {}),
	(b'\x05\x05\x6d\xf9', 'srsdb sp!, #0x5', {}),
	(b'\x05\x05\x6d\xf8', 'srsda sp!, #0x5', {}),
	(b'\x05\x05\xcd\xf8', 'srsia sp, #0x5', {}),
	(b'\x05\x05\xed\xf8', 'srsia sp!, #0x5', {}),
	(b'\x05\x05\x4d\xf8', 'srsda sp, #0x5', {}),
	(b'\x01\x05\x4d\xf9', 'srsdb sp, #0x1', {}),
	(b'\x00\x05\xcd\xf8', 'srsia sp, #0', {}),
	(b'\x0f\x05\xcd\xf9', 'srsib sp, #0xf', {}),
	(b'\x1f\x05\x6d\xf8', 'srsda sp!, #0x1f', {}),
	(b'\x13\x05\x6d\xf9', 'srsdb sp!, #0x13', {}),
	(b'\x02\x05\xed\xf8', 'srsia sp!, #0x2', {}),
	(b'\x0e\x05\xed\xf9', 'srsib sp!, #0xe', {}),
	(b'\x0b\x05\xcd\xf9', 'srsib sp, #0xb', {}),
	(b'\x0a\x05\xcd\xf8', 'srsia sp, #0xa', {}),
	(b'\x09\x05\x4d\xf9', 'srsdb sp, #0x9', {}),
	(b'\x05\x05\x4d\xf8', 'srsda sp, #0x5', {}),
	(b'\x05\x05\xed\xf9', 'srsib sp!, #0x5', {}),
	(b'\x05\x05\xed\xf8', 'srsia sp!, #0x5', {}),
	(b'\x05\x05\x6d\xf9', 'srsdb sp!, #0x5', {}),
	(b'\x05\x05\x6d\xf8', 'srsda sp!, #0x5', {}),
	(b'\x05\x05\xcd\xf8', 'srsia sp, #0x5', {}),
	(b'\x05\x05\xed\xf8', 'srsia sp!, #0x5', {}),
	(b'\x1a\x80\xa0\xe6', 'ssat r8, #0x1, r10', {}),
	(b'\x1a\x80\xa0\xe6', 'ssat r8, #0x1, r10', {}),
	(b'\x9a\x8f\xa0\xe6', 'ssat r8, #0x1, r10, lsl #0x1f', {}),
	(b'\x5a\x80\xa0\xe6', 'ssat r8, #0x1, r10, asr #0x20', {}),
	(b'\xda\x80\xa0\xe6', 'ssat r8, #0x1, r10, asr #0x1', {}),
	(b'\x37\x2f\xa0\xe6', 'ssat16 r2, #0x1, r7', {}),
	(b'\x35\x3f\xaf\xe6', 'ssat16 r3, #0x16, r5', {}),
	(b'\x54\x2f\x13\xe6', 'ssax r2, r3, r4', {}),
	(b'\x54\x2f\x13\xb6', 'ssaxlt r2, r3, r4', {}),
	(b'\x76\x1f\x10\xe6', 'ssub16 r1, r0, r6', {}),
	(b'\x72\x5f\x13\x16', 'ssub16ne r5, r3, r2', {}),
	(b'\xf4\x9f\x12\xe6', 'ssub8 r9, r2, r4', {}),
	(b'\xf2\x5f\x11\x06', 'ssub8eq r5, r1, r2', {}),
	(b'\x01\x80\x81\xfd', 'stc2 p0, c8, [r1, #0x4]', {}),
	(b'\x00\x71\x82\xfd', 'stc2 p1, c7, [r2]', {}),
	(b'\x38\x62\x03\xfd', 'stc2 p2, c6, [r3, ', {}),
	(b'\x1e\x53\x24\xfd', 'stc2 p3, c5, [r4, !', {}),
	(b'\x04\x44\xa5\xfc', 'stc2 p4, c4, [r5], #0x10', {}),
	(b'\x12\x35\x26\xfc', 'stc2 p5, c3, [r6], #-0x48', {}),
	(b'\x01\x26\xc7\xfd', 'stc2l p6, c2, [r7, #0x4]', {}),
	(b'\x00\x17\xc8\xfd', 'stc2l p7, c1, [r8]', {}),
	(b'\x38\x08\x49\xfd', 'stc2l p8, c0, [r9, ', {}),
	(b'\x1e\x19\x6a\xfd', 'stc2l p9, c1, [r10, !', {}),
	(b'\x04\x20\xeb\xfc', 'stc2l p0, c2, [r11], #0x10', {}),
	(b'\x12\x31\x6c\xfc', 'stc2l p1, c3, [r12], #-0x48', {}),
	(b'\x01\x4c\x80\xed', 'stc p12, c4, [r0, #0x4]', {}),
	(b'\x00\x5d\x81\xed', 'stc p13, c5, [r1]', {}),
	(b'\x38\x6e\x02\xed', 'stc p14, c6, [r2, ', {}),
	(b'\x1e\x7f\x23\xed', 'stc p15, c7, [r3, !', {}),
	(b'\x04\x85\xa4\xec', 'stc p5, c8, [r4], #0x10', {}),
	(b'\x12\x94\x25\xec', 'stc p4, c9, [r5], #-0x48', {}),
	(b'\x01\xa3\xc6\xed', 'stcl p3, c10, [r6, #0x4]', {}),
	(b'\x00\xb2\xc7\xed', 'stcl p2, c11, [r7]', {}),
	(b'\x38\xc1\x48\xed', 'stcl p1, c12, [r8, ', {}),
	(b'\x1e\xd0\x69\xed', 'stcl p0, c13, [r9, !', {}),
	(b'\x04\xe6\xea\xec', 'stcl p6, c14, [r10], #0x10', {}),
	(b'\x12\xf7\x6b\xec', 'stcl p7, c15, [r11], #-0x48', {}),
	(b'\x01\x4c\x80\x3d', 'stclo p12, c4, [r0, #0x4]', {}),
	(b'\x00\x5d\x81\x8d', 'stchi p13, c5, [r1]', {}),
	(b'\x38\x6e\x02\x2d', 'stchs p14, c6, [r2, ', {}),
	(b'\x1e\x7f\x23\x3d', 'stclo p15, c7, [r3, !', {}),
	(b'\x04\x85\xa4\x0c', 'stceq p5, c8, [r4], #0x10', {}),
	(b'\x12\x94\x25\xcc', 'stcgt p4, c9, [r5], #-0x48', {}),
	(b'\x01\xa3\xc6\xbd', 'stcllt p3, c10, [r6, #0x4]', {}),
	(b'\x00\xb2\xc7\xad', 'stclge p2, c11, [r7]', {}),
	(b'\x38\xc1\x48\xdd', 'stclle p1, c12, [r8, ', {}),
	(b'\x1e\xd0\x69\x1d', 'stclne p0, c13, [r9, !', {}),
	(b'\x04\xe6\xea\x0c', 'stcleq p6, c14, [r10], #0x10', {}),
	(b'\x12\xf7\x6b\x8c', 'stclhi p7, c15, [r11], #-0x48', {}),
	(b'\x19\x82\x81\xfc', 'stc2 p2, c8, [r1], {25}', {}),
	(b'\x7a\x20\x82\xe8', 'stm r2, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x40\x83\xe8', 'stm r3, {r1, r3, r4, r5, r6, lr}', {}),
	(b'\x7a\x20\x84\xe9', 'stmib r4, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x20\x05\xe8', 'stmda r5, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x01\x06\xe9', 'stmdb r6, {r1, r3, r4, r5, r6, r8}', {}),
	(b'\x7a\x20\x0d\xe9', 'stmdb sp, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x20\xa8\xe8', 'stm r8!, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x20\xa9\xe9', 'stmib r9!, {r1, r3, r4, r5, r6, sp}', {}),
	(b'\x7a\x00\x2d\xe8', 'stmda sp!, {r1, r3, r4, r5, r6}', {}),
	(b'\xa2\x20\x20\xe9', 'stmdb r0!, {r1, r5, r7, sp}', {}),
	(b'\x93\x1f\xc4\xe1', 'strexb r1, r3, [r4]', {}),
	(b'\x92\x4f\xe5\xe1', 'strexh r4, r2, [r5]', {}),
	(b'\x91\x2f\x87\xe1', 'strex r2, r1, [r7]', {}),
	(b'\x92\x6f\xa8\xe1', 'strexd r6, r2, r3, [r8]', {}),
	(b'\x00\x30\x2a\x55', 'strpl r3, [r10, #-0]!', {}),
	(b'\x00\x30\xaa\x55', 'strpl r3, [r10, #0]!', {}),
	(b'\x0f\x4a\x45\xe2', 'sub r4, r5, #0xf000', {}),
	(b'\x06\x40\x45\xe0', 'sub r4, r5, r6', {}),
	(b'\x86\x42\x45\xe0', 'sub r4, r5, r6, lsl #0x5', {}),
	(b'\xa6\x42\x45\xe0', 'sub r4, r5, r6, lsr #0x5', {}),
	(b'\xa6\x42\x45\xe0', 'sub r4, r5, r6, lsr #0x5', {}),
	(b'\xc6\x42\x45\xe0', 'sub r4, r5, r6, asr #0x5', {}),
	(b'\xe6\x42\x45\xe0', 'sub r4, r5, r6, ror #0x5', {}),
	(b'\x18\x69\x47\xe0', 'sub r6, r7, r8, lsl r9', {}),
	(b'\x38\x69\x47\xe0', 'sub r6, r7, r8, lsr r9', {}),
	(b'\x58\x69\x47\xe0', 'sub r6, r7, r8, asr r9', {}),
	(b'\x78\x69\x47\xe0', 'sub r6, r7, r8, ror r9', {}),
	(b'\x0f\x5a\x45\xe2', 'sub r5, r5, #0xf000', {}),
	(b'\x05\x40\x44\xe0', 'sub r4, r4, r5', {}),
	(b'\x85\x42\x44\xe0', 'sub r4, r4, r5, lsl #0x5', {}),
	(b'\xa5\x42\x44\xe0', 'sub r4, r4, r5, lsr #0x5', {}),
	(b'\xa5\x42\x44\xe0', 'sub r4, r4, r5, lsr #0x5', {}),
	(b'\xc5\x42\x44\xe0', 'sub r4, r4, r5, asr #0x5', {}),
	(b'\xe5\x42\x44\xe0', 'sub r4, r4, r5, ror #0x5', {}),
	(b'\x17\x69\x46\xe0', 'sub r6, r6, r7, lsl r9', {}),
	(b'\x37\x69\x46\xe0', 'sub r6, r6, r7, lsr r9', {}),
	(b'\x57\x69\x46\xe0', 'sub r6, r6, r7, asr r9', {}),
	(b'\x77\x69\x46\xe0', 'sub r6, r6, r7, ror r9', {}),
	(b'\x22\x30\x41\xe0', 'sub r3, r1, r2, lsr #0x20', {}),
	(b'\x42\x30\x41\xe0', 'sub r3, r1, r2, asr #0x20', {}),
	(b'\x92\x10\x03\xe1', 'swp r1, r2, [r3]', {}),
	(b'\x94\x40\x06\xe1', 'swp r4, r4, [r6]', {}),
	(b'\x91\x50\x49\xe1', 'swpb r5, r1, [r9]', {}),
	(b'\x74\x20\xa3\xe6', 'sxtab r2, r3, r4', {}),
	(b'\x76\x40\xa5\xe6', 'sxtab r4, r5, r6', {}),
	(b'\x79\x64\xa2\xb6', 'sxtablt r6, r2, r9, ror #0x8', {}),
	(b'\x74\x58\xa1\xe6', 'sxtab r5, r1, r4, ror #0x10', {}),
	(b'\x73\x7c\xa8\xe6', 'sxtab r7, r8, r3, ror #0x18', {}),
	(b'\x74\x00\x81\xa6', 'sxtab16ge r0, r1, r4', {}),
	(b'\x77\x60\x82\xe6', 'sxtab16 r6, r2, r7', {}),
	(b'\x78\x34\x85\xe6', 'sxtab16 r3, r5, r8, ror #0x8', {}),
	(b'\x71\x38\x82\xe6', 'sxtab16 r3, r2, r1, ror #0x10', {}),
	(b'\x73\x1c\x82\x06', 'sxtab16eq r1, r2, r3, ror #0x18', {}),
	(b'\x79\x10\xb3\xe6', 'sxtah r1, r3, r9', {}),
	(b'\x76\x60\xb1\x86', 'sxtahhi r6, r1, r6', {}),
	(b'\x73\x34\xb8\xe6', 'sxtah r3, r8, r3, ror #0x8', {}),
	(b'\x74\x28\xb2\x36', 'sxtahlo r2, r2, r4, ror #0x10', {}),
	(b'\x73\x9c\xb3\xe6', 'sxtah r9, r3, r3, ror #0x18', {}),
	(b'\x74\x20\xaf\xa6', 'sxtbge r2, r4', {}),
	(b'\x76\x50\xaf\xe6', 'sxtb r5, r6', {}),
	(b'\x79\x64\xaf\xe6', 'sxtb r6, r9, ror #0x8', {}),
	(b'\x71\x58\xaf\x36', 'sxtblo r5, r1, ror #0x10', {}),
	(b'\x73\x8c\xaf\xe6', 'sxtb r8, r3, ror #0x18', {}),
	(b'\x74\x10\x8f\xe6', 'sxtb16 r1, r4', {}),
	(b'\x77\x60\x8f\xe6', 'sxtb16 r6, r7', {}),
	(b'\x75\x34\x8f\x26', 'sxtb16hs r3, r5, ror #0x8', {}),
	(b'\x71\x38\x8f\xe6', 'sxtb16 r3, r1, ror #0x10', {}),
	(b'\x73\x2c\x8f\xa6', 'sxtb16ge r2, r3, ror #0x18', {}),
	(b'\x79\x30\xbf\x16', 'sxthne r3, r9', {}),
	(b'\x76\x10\xbf\xe6', 'sxth r1, r6', {}),
	(b'\x78\x34\xbf\xe6', 'sxth r3, r8, ror #0x8', {}),
	(b'\x72\x28\xbf\xd6', 'sxthle r2, r2, ror #0x10', {}),
	(b'\x73\x9c\xbf\xe6', 'sxth r9, r3, ror #0x18', {}),
	(b'\x0f\x0a\x35\xe3', 'teq r5, #0xf000', {}),
	(b'\x05\x00\x34\xe1', 'teq r4, r5', {}),
	(b'\x85\x02\x34\xe1', 'teq r4, r5, lsl #0x5', {}),
	(b'\xa5\x02\x34\xe1', 'teq r4, r5, lsr #0x5', {}),
	(b'\xa5\x02\x34\xe1', 'teq r4, r5, lsr #0x5', {}),
	(b'\xc5\x02\x34\xe1', 'teq r4, r5, asr #0x5', {}),
	(b'\xe5\x02\x34\xe1', 'teq r4, r5, ror #0x5', {}),
	(b'\x17\x09\x36\xe1', 'teq r6, r7, lsl r9', {}),
	(b'\x37\x09\x36\xe1', 'teq r6, r7, lsr r9', {}),
	(b'\x57\x09\x36\xe1', 'teq r6, r7, asr r9', {}),
	(b'\x77\x09\x36\xe1', 'teq r6, r7, ror r9', {}),
	(b'\x0f\x0a\x15\xe3', 'tst r5, #0xf000', {}),
	(b'\x05\x00\x14\xe1', 'tst r4, r5', {}),
	(b'\x85\x02\x14\xe1', 'tst r4, r5, lsl #0x5', {}),
	(b'\xa5\x02\x14\xe1', 'tst r4, r5, lsr #0x5', {}),
	(b'\xa5\x02\x14\xe1', 'tst r4, r5, lsr #0x5', {}),
	(b'\xc5\x02\x14\xe1', 'tst r4, r5, asr #0x5', {}),
	(b'\xe5\x02\x14\xe1', 'tst r4, r5, ror #0x5', {}),
	(b'\x17\x09\x16\xe1', 'tst r6, r7, lsl r9', {}),
	(b'\x37\x09\x16\xe1', 'tst r6, r7, lsr r9', {}),
	(b'\x57\x09\x16\xe1', 'tst r6, r7, asr r9', {}),
	(b'\x77\x09\x16\xe1', 'tst r6, r7, ror r9', {}),
	(b'\x13\x1f\x52\xe6', 'uadd16 r1, r2, r3', {}),
	(b'\x13\x1f\x52\xc6', 'uadd16gt r1, r2, r3', {}),
	(b'\x93\x1f\x52\xe6', 'uadd8 r1, r2, r3', {}),
	(b'\x93\x1f\x52\xd6', 'uadd8le r1, r2, r3', {}),
	(b'\x30\x9f\x5c\xe6', 'uasx r9, r12, r0', {}),
	(b'\x30\x9f\x5c\x06', 'uasxeq r9, r12, r0', {}),
	(b'\x55\x48\xe0\xe7', 'ubfx r4, r5, #0x16, #0x1', {}),
	(b'\x55\x48\xef\xc7', 'ubfxgt r4, r5, #0x16, #0x10', {}),
	(b'\x12\x4f\x78\xe6', 'uhadd16 r4, r8, r2', {}),
	(b'\x12\x4f\x78\xc6', 'uhadd16gt r4, r8, r2', {}),
	(b'\x92\x4f\x78\xe6', 'uhadd8 r4, r8, r2', {}),
	(b'\x92\x4f\x78\xc6', 'uhadd8gt r4, r8, r2', {}),
	(b'\x32\x4f\x78\xe6', 'uhasx r4, r8, r2', {}),
	(b'\x32\x4f\x78\xc6', 'uhasxgt r4, r8, r2', {}),
	(b'\x72\x4f\x78\xe6', 'uhsub16 r4, r8, r2', {}),
	(b'\x72\x4f\x78\xc6', 'uhsub16gt r4, r8, r2', {}),
	(b'\xf2\x4f\x78\xe6', 'uhsub8 r4, r8, r2', {}),
	(b'\xf2\x4f\x78\xc6', 'uhsub8gt r4, r8, r2', {}),
	(b'\x95\x36\x44\xe0', 'umaal r3, r4, r5, r6', {}),
	(b'\x95\x36\x44\xb0', 'umaallt r3, r4, r5, r6', {}),
	(b'\x96\x28\xa4\xe0', 'umlal r2, r4, r6, r8', {}),
	(b'\x92\x66\xa1\xc0', 'umlalgt r6, r1, r2, r6', {}),
	(b'\x92\x23\xb9\xe0', 'umlals r2, r9, r2, r3', {}),
	(b'\x91\x32\xb5\x00', 'umlal.seq r3, r5, r1, r2', {}),
	(b'\x96\x28\x84\xe0', 'umull r2, r4, r6, r8', {}),
	(b'\x92\x66\x81\xc0', 'umullgt r6, r1, r2, r6', {}),
	(b'\x92\x23\x99\xe0', 'umulls r2, r9, r2, r3', {}),
	(b'\x91\x32\x95\x00', 'umull.seq r3, r5, r1, r2', {}),
	(b'\x13\x1f\x62\xe6', 'uqadd16 r1, r2, r3', {}),
	(b'\x19\x4f\x67\xc6', 'uqadd16gt r4, r7, r9', {}),
	(b'\x98\x3f\x64\xe6', 'uqadd8 r3, r4, r8', {}),
	(b'\x92\x8f\x61\xd6', 'uqadd8le r8, r1, r2', {}),
	(b'\x31\x2f\x64\xe6', 'uqasx r2, r4, r1', {}),
	(b'\x39\x5f\x62\x86', 'uqasxhi r5, r2, r9', {}),
	(b'\x57\x1f\x63\xe6', 'uqsax r1, r3, r7', {}),
	(b'\x52\x3f\x66\xe6', 'uqsax r3, r6, r2', {}),
	(b'\x73\x1f\x65\xe6', 'uqsub16 r1, r5, r3', {}),
	(b'\x75\x3f\x62\xc6', 'uqsub16gt r3, r2, r5', {}),
	(b'\xf4\x2f\x61\xe6', 'uqsub8 r2, r1, r4', {}),
	(b'\xf9\x4f\x66\xd6', 'uqsub8le r4, r6, r9', {}),
	(b'\x11\xf4\x82\xe7', 'usad8 r2, r1, r4', {}),
	(b'\x16\xf9\x84\xd7', 'usad8le r4, r6, r9', {}),
	(b'\x15\x73\x81\xe7', 'usada8 r1, r5, r3, r7', {}),
	(b'\x12\x15\x83\xc7', 'usada8gt r3, r2, r5, r1', {}),
	(b'\x1a\x80\xe1\xe6', 'usat r8, #0x1, r10', {}),
	(b'\x1a\x80\xe4\xe6', 'usat r8, #0x4, r10', {}),
	(b'\x9a\x8f\xe5\xe6', 'usat r8, #0x5, r10, lsl #0x1f', {}),
	(b'\x5a\x80\xff\xe6', 'usat r8, #0x31, r10, asr #0x20', {}),
	(b'\xda\x80\xf0\xe6', 'usat r8, #0x16, r10, asr #0x1', {}),
	(b'\x37\x2f\xe2\xe6', 'usat16 r2, #0x2, r7', {}),
	(b'\x35\x3f\xef\xe6', 'usat16 r3, #0x15, r5', {}),
	(b'\x54\x2f\x53\xe6', 'usax r2, r3, r4', {}),
	(b'\x54\x2f\x53\x16', 'usaxne r2, r3, r4', {}),
	(b'\x77\x4f\x52\xe6', 'usub16 r4, r2, r7', {}),
	(b'\x73\x1f\x51\x86', 'usub16hi r1, r1, r3', {}),
	(b'\xf5\x1f\x58\xe6', 'usub8 r1, r8, r5', {}),
	(b'\xf3\x9f\x52\xd6', 'usub8le r9, r2, r3', {}),
	(b'\x74\x20\xe3\xe6', 'uxtab r2, r3, r4', {}),
	(b'\x76\x40\xe5\xe6', 'uxtab r4, r5, r6', {}),
	(b'\x79\x64\xe2\xb6', 'uxtablt r6, r2, r9, ror #0x8', {}),
	(b'\x74\x58\xe1\xe6', 'uxtab r5, r1, r4, ror #0x10', {}),
	(b'\x73\x7c\xe8\xe6', 'uxtab r7, r8, r3, ror #0x18', {}),
	(b'\x74\x00\xc1\xa6', 'uxtab16ge r0, r1, r4', {}),
	(b'\x77\x60\xc2\xe6', 'uxtab16 r6, r2, r7', {}),
	(b'\x78\x34\xc5\xe6', 'uxtab16 r3, r5, r8, ror #0x8', {}),
	(b'\x71\x38\xc2\xe6', 'uxtab16 r3, r2, r1, ror #0x10', {}),
	(b'\x73\x1c\xc2\x06', 'uxtab16eq r1, r2, r3, ror #0x18', {}),
	(b'\x79\x10\xf3\xe6', 'uxtah r1, r3, r9', {}),
	(b'\x76\x60\xf1\x86', 'uxtahhi r6, r1, r6', {}),
	(b'\x73\x34\xf8\xe6', 'uxtah r3, r8, r3, ror #0x8', {}),
	(b'\x74\x28\xf2\x36', 'uxtahlo r2, r2, r4, ror #0x10', {}),
	(b'\x73\x9c\xf3\xe6', 'uxtah r9, r3, r3, ror #0x18', {}),
	(b'\x74\x20\xef\xa6', 'uxtbge r2, r4', {}),
	(b'\x76\x50\xef\xe6', 'uxtb r5, r6', {}),
	(b'\x79\x64\xef\xe6', 'uxtb r6, r9, ror #0x8', {}),
	(b'\x71\x58\xef\x36', 'uxtblo r5, r1, ror #0x10', {}),
	(b'\x73\x8c\xef\xe6', 'uxtb r8, r3, ror #0x18', {}),
	(b'\x74\x10\xcf\xe6', 'uxtb16 r1, r4', {}),
	(b'\x77\x60\xcf\xe6', 'uxtb16 r6, r7', {}),
	(b'\x75\x34\xcf\x26', 'uxtb16hs r3, r5, ror #0x8', {}),
	(b'\x71\x38\xcf\xe6', 'uxtb16 r3, r1, ror #0x10', {}),
	(b'\x73\x2c\xcf\xa6', 'uxtb16ge r2, r3, ror #0x18', {}),
	(b'\x79\x30\xff\x16', 'uxthne r3, r9', {}),
	(b'\x76\x10\xff\xe6', 'uxth r1, r6', {}),
	(b'\x78\x34\xff\xe6', 'uxth r3, r8, ror #0x8', {}),
	(b'\x72\x28\xff\xd6', 'uxthle r2, r2, ror #0x10', {}),
	(b'\x73\x9c\xff\xe6', 'uxth r9, r3, ror #0x18', {}),
	(b'\x02\xf0\x20\xe3', 'wfe ', {}),
	(b'\x02\xf0\x20\x83', 'wfehi ', {}),
	(b'\x03\xf0\x20\xe3', 'wfi ', {}),
	(b'\x03\xf0\x20\xb3', 'wfilt ', {}),
	(b'\x01\xf0\x20\xe3', 'yield ', {}),
	(b'\x01\xf0\x20\x13', 'yieldne ', {}),
	(b'\x04\xf0\x20\xe3', 'sev ', {}),
	(b'\x03\xf0\x20\xe3', 'wfi ', {}),
	(b'\x02\xf0\x20\xe3', 'wfe ', {}),
	(b'\x01\xf0\x20\xe3', 'yield ', {}),
	(b'\x00\xf0\x20\xe3', 'nop ', {}),
	(b'\xef\xf0\x20\xc3', 'hintgt #0xef', {}),
	(b'\x42\x00\x01\xe1', 'crc32b r0, r1, r2', {}),
	(b'\x42\x00\x21\xe1', 'crc32h r0, r1, r2', {}),
	(b'\x42\x00\x41\xe1', 'crc32w r0, r1, r2', {}),
	(b'\x42\x02\x01\xe1', 'crc32cb r0, r1, r2', {}),
	(b'\x42\x02\x21\xe1', 'crc32ch r0, r1, r2', {}),
	(b'\x42\x02\x41\xe1', 'crc32cw r0, r1, r2', {}),
	(b'\x05\xb0\xa0\xe1', 'mov r11, r5', {}),
	(b'\x06\x10\xa0\xe1', 'mov r1, r6', {}),
	(b'\xe0\x3b\xb2\xee', 'vcvtt.f64.f16 d3, s1', {}),
	(b'\xcc\x2b\xf3\xee', 'vcvtt.f16.f64 s5, d12', {}),
	(b'\x60\x3b\xb2\xee', 'vcvtb.f64.f16 d3, s1', {}),
	(b'\x41\x2b\xb3\xee', 'vcvtb.f16.f64 s4, d1', {}),
	(b'\xe0\x3b\xb2\xae', 'vcvttge.f64.f16 d3, s1', {}),
	(b'\xcc\x2b\xf3\xce', 'vcvttgt.f16.f64 s5, d12', {}),
	(b'\x60\x3b\xb2\x0e', 'vcvtbeq.f64.f16 d3, s1', {}),
	(b'\x41\x2b\xb3\xbe', 'vcvtblt.f16.f64 s4, d1', {}),
	(b'\xe1\x1a\xbc\xfe', 'vcvta.s32.f32 s2, s3', {}),
	(b'\xc3\x1b\xbc\xfe', 'vcvta.s32.f64 s2, d3', {}),
	(b'\xeb\x3a\xbd\xfe', 'vcvtn.s32.f32 s6, s23', {}),
	(b'\xe7\x3b\xbd\xfe', 'vcvtn.s32.f64 s6, d23', {}),
	(b'\xc2\x0a\xbe\xfe', 'vcvtp.s32.f32 s0, s4', {}),
	(b'\xc4\x0b\xbe\xfe', 'vcvtp.s32.f64 s0, d4', {}),
	(b'\xc4\x8a\xff\xfe', 'vcvtm.s32.f32 s17, s8', {}),
	(b'\xc8\x8b\xff\xfe', 'vcvtm.s32.f64 s17, d8', {}),
	(b'\x61\x1a\xbc\xfe', 'vcvta.u32.f32 s2, s3', {}),
	(b'\x43\x1b\xbc\xfe', 'vcvta.u32.f64 s2, d3', {}),
	(b'\x6b\x3a\xbd\xfe', 'vcvtn.u32.f32 s6, s23', {}),
	(b'\x67\x3b\xbd\xfe', 'vcvtn.u32.f64 s6, d23', {}),
	(b'\x42\x0a\xbe\xfe', 'vcvtp.u32.f32 s0, s4', {}),
	(b'\x44\x0b\xbe\xfe', 'vcvtp.u32.f64 s0, d4', {}),
	(b'\x44\x8a\xff\xfe', 'vcvtm.u32.f32 s17, s8', {}),
	(b'\x48\x8b\xff\xfe', 'vcvtm.u32.f64 s17, d8', {}),
	(b'\xab\x2a\x20\xfe', 'vselge.f32 s4, s1, s23', {}),
	(b'\xa7\xeb\x6f\xfe', 'vselge.f64 d30, d31, d23', {}),
	(b'\x80\x0a\x30\xfe', 'vselgt.f32 s0, s1, s0', {}),
	(b'\x24\x5b\x3a\xfe', 'vselgt.f64 d5, d10, d20', {}),
	(b'\x2b\xfa\x0e\xfe', 'vseleq.f32 s30, s28, s23', {}),
	(b'\x08\x2b\x04\xfe', 'vseleq.f64 d2, d4, d8', {}),
	(b'\x07\xaa\x58\xfe', 'vselvs.f32 s21, s16, s14', {}),
	(b'\x2f\x0b\x11\xfe', 'vselvs.f64 d0, d1, d31', {}),
	(b'\x00\x2a\xc6\xfe', 'vmaxnm.f32 s5, s12, s0', {}),
	(b'\xae\x5b\x86\xfe', 'vmaxnm.f64 d5, d22, d30', {}),
	(b'\x46\x0a\x80\xfe', 'vminnm.f32 s0, s0, s12', {}),
	(b'\x49\x4b\x86\xfe', 'vminnm.f64 d4, d6, d9', {}),
	(b'\xcc\x3b\xb6\xae', 'vrintzge.f64 d3, d12', {}),
	(b'\xcc\x1a\xf6\xee', 'vrintz.f32 s3, s24', {}),
	(b'\x40\x5b\xb6\xbe', 'vrintrlt.f64 d5, d0', {}),
	(b'\x64\x0a\xb6\xee', 'vrintr.f32 s0, s9', {}),
	(b'\x6e\xcb\xf7\x0e', 'vrintxeq.f64 d28, d30', {}),
	(b'\x47\x5a\xb7\x6e', 'vrintxvs.f32 s10, s14', {}),
	(b'\x44\x3b\xb8\xfe', 'vrinta.f64 d3, d4', {}),
	(b'\x60\x6a\xb8\xfe', 'vrinta.f32 s12, s1', {}),
	(b'\x44\x3b\xb9\xfe', 'vrintn.f64 d3, d4', {}),
	(b'\x60\x6a\xb9\xfe', 'vrintn.f32 s12, s1', {}),
	(b'\x44\x3b\xba\xfe', 'vrintp.f64 d3, d4', {}),
	(b'\x60\x6a\xba\xfe', 'vrintp.f32 s12, s1', {}),
	(b'\x44\x3b\xbb\xfe', 'vrintm.f64 d3, d4', {}),
	(b'\x60\x6a\xbb\xfe', 'vrintm.f32 s12, s1', {}),
	(b'\x10\xda\xf5\xee', 'vmrs sp, mvfr2', {}),
	(b'\x12\xf3\x11\xe7', 'sdiv r1, r2, r3', {}),
	(b'\x14\xf5\x33\xe7', 'udiv r3, r4, r5', {}),
	(b'\x93\x1e\xc4\xe1', 'strexb r1, r3, [r4]', {}),
	(b'\x92\x4e\xe5\xe1', 'strexh r4, r2, [r5]', {}),
	(b'\x91\x2e\x87\xe1', 'strex r2, r1, [r7]', {}),
	(b'\x92\x6e\xa8\xe1', 'strexd r6, r2, r3, [r8]', {}),
	(b'\x93\xfc\x80\xe1', 'strex pc, r3, [r0]', {}),
	(b'\x92\xfc\xc1\xe1', 'strexb pc, r2, [r1]', {}),
	(b'\x92\xfc\xe3\xe1', 'strexh pc, r2, [r3]', {}),
	(b'\x00\xeb\x01\x00', 'andeq lr, r1, r0, lsl #0x16', {}),
	(b'\x01\x00\x80\xe0', 'add r0, r0, r1', {}),
	(b'\x40\x18\x00\x00', 'andeq r1, r0, r0, asr #0x10', {}),
	(b'\x01\x00\x80\xe0', 'add r0, r0, r1', {}),
	(b'\xa0\x0b\x71\xee', 'vadd.f64 d16, d17, d16', {}),
	(b'\x80\x0a\x30\xee', 'vadd.f32 s0, s1, s0', {}),
	(b'\xe0\x0b\x71\xee', 'vsub.f64 d16, d17, d16', {}),
	(b'\xc0\x0a\x30\xee', 'vsub.f32 s0, s1, s0', {}),
	(b'\xa0\x0b\xc1\xee', 'vdiv.f64 d16, d17, d16', {}),
	(b'\x80\x0a\x80\xee', 'vdiv.f32 s0, s1, s0', {}),
	(b'\xa3\x2a\xc2\xee', 'vdiv.f32 s5, s5, s7', {}),
	(b'\x07\x5b\x85\xee', 'vdiv.f64 d5, d5, d7', {}),
	(b'\xa0\x0b\x61\xee', 'vmul.f64 d16, d17, d16', {}),
	(b'\xa1\x4b\x64\xee', 'vmul.f64 d20, d20, d17', {}),
	(b'\x80\x0a\x20\xee', 'vmul.f32 s0, s1, s0', {}),
	(b'\xaa\x5a\x65\xee', 'vmul.f32 s11, s11, s21', {}),
	(b'\xe0\x0b\x61\xee', 'vnmul.f64 d16, d17, d16', {}),
	(b'\xc0\x0a\x20\xee', 'vnmul.f32 s0, s1, s0', {}),
	(b'\xe0\x1b\xf4\xee', 'vcmpe.f64 d17, d16', {}),
	(b'\xc0\x0a\xf4\xee', 'vcmpe.f32 s1, s0', {}),
	(b'\xc0\x0b\xf5\xee', 'vcmpe.f64 d16, #0', {}),
	(b'\xc0\x0a\xb5\xee', 'vcmpe.f32 s0, #0', {}),
	(b'\xe0\x0b\xf0\xee', 'vabs.f64 d16, d16', {}),
	(b'\xc0\x0a\xb0\xee', 'vabs.f32 s0, s0', {}),
	(b'\xe0\x0b\xb7\xee', 'vcvt.f32.f64 s0, d16', {}),
	(b'\xc0\x0a\xf7\xee', 'vcvt.f64.f32 d16, s0', {}),
	(b'\x60\x0b\xf1\xee', 'vneg.f64 d16, d16', {}),
	(b'\x40\x0a\xb1\xee', 'vneg.f32 s0, s0', {}),
	(b'\xe0\x0b\xf1\xee', 'vsqrt.f64 d16, d16', {}),
	(b'\xc0\x0a\xb1\xee', 'vsqrt.f32 s0, s0', {}),
	(b'\xc0\x0b\xf8\xee', 'vcvt.f64.s32 d16, s0', {}),
	(b'\xc0\x0a\xb8\xee', 'vcvt.f32.s32 s0, s0', {}),
	(b'\x40\x0b\xf8\xee', 'vcvt.f64.u32 d16, s0', {}),
	(b'\x40\x0a\xb8\xee', 'vcvt.f32.u32 s0, s0', {}),
	(b'\xe0\x0b\xbd\xee', 'vcvt.s32.f64 s0, d16', {}),
	(b'\xc0\x0a\xbd\xee', 'vcvt.s32.f32 s0, s0', {}),
	(b'\xe0\x0b\xbc\xee', 'vcvt.u32.f64 s0, d16', {}),
	(b'\xc0\x0a\xbc\xee', 'vcvt.u32.f32 s0, s0', {}),
	(b'\xa1\x0b\x42\xee', 'vmla.f64 d16, d18, d17', {}),
	(b'\x00\x0a\x41\xee', 'vmla.f32 s1, s2, s0', {}),
	(b'\xe1\x0b\x42\xee', 'vmls.f64 d16, d18, d17', {}),
	(b'\x40\x0a\x41\xee', 'vmls.f32 s1, s2, s0', {}),
	(b'\xe1\x0b\x52\xee', 'vnmla.f64 d16, d18, d17', {}),
	(b'\x40\x0a\x51\xee', 'vnmla.f32 s1, s2, s0', {}),
	(b'\xa1\x0b\x52\xee', 'vnmls.f64 d16, d18, d17', {}),
	(b'\x00\x0a\x51\xee', 'vnmls.f32 s1, s2, s0', {}),
	(b'\x10\xfa\xf1\xee', 'vmrs APSR_nzcv, fpscr', {}),
	(b'\x10\xfa\xf1\xee', 'vmrs APSR_nzcv, fpscr', {}),
	(b'\x10\xfa\xf1\xee', 'vmrs APSR_nzcv, fpscr', {}),
	(b'\x10\x2a\xf0\xee', 'vmrs r2, fpsid', {}),
	(b'\x10\x3a\xf0\xee', 'vmrs r3, fpsid', {}),
	(b'\x10\x4a\xf7\xee', 'vmrs r4, mvfr0', {}),
	(b'\x10\x5a\xf6\xee', 'vmrs r5, mvfr1', {}),
	(b'\x60\x0b\xf1\x1e', 'vnegne.f64 d16, d16', {}),
	(b'\x10\x0a\x00\x1e', 'vmovne s0, r0', {}),
	(b'\x10\x1a\x00\x0e', 'vmoveq s0, r1', {}),
	(b'\x10\x1a\x11\xee', 'vmov r1, s2', {}),
	(b'\x10\x3a\x02\xee', 'vmov s4, r3', {}),
	(b'\x12\x1b\x55\xec', 'vmov r1, r5, d2', {}),
	(b'\x14\x3b\x49\xec', 'vmov d4, r3, r9', {}),
	(b'\x10\x0a\xf1\xee', 'vmrs r0, fpscr', {}),
	(b'\x10\x0a\xf8\xee', 'vmrs r0, fpexc', {}),
	(b'\x10\x0a\xf0\xee', 'vmrs r0, fpsid', {}),
	(b'\x10\x1a\xf9\xee', 'vmrs r1, fpinst', {}),
	(b'\x10\x8a\xfa\xee', 'vmrs r8, fpinst2', {}),
	(b'\x10\x0a\xe1\xee', 'vmsr fpscr, r0', {}),
	(b'\x10\x0a\xe8\xee', 'vmsr fpexc, r0', {}),
	(b'\x10\x0a\xe0\xee', 'vmsr fpsid, r0', {}),
	(b'\x10\x3a\xe9\xee', 'vmsr fpinst, r3', {}),
	(b'\x10\x4a\xea\xee', 'vmsr fpinst2, r4', {}),
	(b'\x08\x0b\xf0\xee', 'vmov.f64 d16, #0x3.000000e+00', {}),
	(b'\x08\x0a\xb0\xee', 'vmov.f32 s0, #0x3.000000e+00', {}),
	(b'\x08\x0b\xf8\xee', 'vmov.f64 d16, #-3.000000e+00', {}),
	(b'\x08\x0a\xb8\xee', 'vmov.f32 s0, #-3.000000e+00', {}),
	(b'\x10\x0a\x00\xee', 'vmov s0, r0', {}),
	(b'\x90\x1a\x00\xee', 'vmov s1, r1', {}),
	(b'\x10\x2a\x01\xee', 'vmov s2, r2', {}),
	(b'\x90\x3a\x01\xee', 'vmov s3, r3', {}),
	(b'\x10\x0a\x10\xee', 'vmov r0, s0', {}),
	(b'\x90\x1a\x10\xee', 'vmov r1, s1', {}),
	(b'\x10\x2a\x11\xee', 'vmov r2, s2', {}),
	(b'\x90\x3a\x11\xee', 'vmov r3, s3', {}),
	(b'\x30\x0b\x51\xec', 'vmov r0, r1, d16', {}),
	(b'\x31\x1a\x42\xec', 'vmov s3, s4, r1, r2', {}),
	(b'\x11\x1a\x42\xec', 'vmov s2, s3, r1, r2', {}),
	(b'\x31\x1a\x52\xec', 'vmov r1, r2, s3, s4', {}),
	(b'\x11\x1a\x52\xec', 'vmov r1, r2, s2, s3', {}),
	(b'\x1f\x1b\x42\xec', 'vmov d15, r1, r2', {}),
	(b'\x30\x1b\x42\xec', 'vmov d16, r1, r2', {}),
	(b'\x1f\x1b\x52\xec', 'vmov r1, r2, d15', {}),
	(b'\x30\x1b\x52\xec', 'vmov r1, r2, d16', {}),
	(b'\x00\x1b\xd0\xed', 'vldr d17, [r0]', {}),
	(b'\x00\x0a\x9e\xed', 'vldr s0, [lr]', {}),
	(b'\x00\x0b\x9e\xed', 'vldr d0, [lr]', {}),
	(b'\x08\x1b\x92\xed', 'vldr d1, [r2, #0x20]', {}),
	(b'\x08\x1b\x12\xed', 'vldr d1, [r2, ', {}),
	(b'\x00\x2b\x93\xed', 'vldr d2, [r3]', {}),
	(b'\x00\x3b\x9f\xed', 'vldr d3, [pc]', {}),
	(b'\x00\x3b\x9f\xed', 'vldr d3, [pc]', {}),
	(b'\x00\x3b\x1f\xed', 'vldr d3, [pc, #-0]', {}),
	(b'\x00\x6a\xd0\xed', 'vldr s13, [r0]', {}),
	(b'\x08\x0a\xd2\xed', 'vldr s1, [r2, #0x20]', {}),
	(b'\x08\x0a\x52\xed', 'vldr s1, [r2, ', {}),
	(b'\x00\x1a\x93\xed', 'vldr s2, [r3]', {}),
	(b'\x00\x2a\xdf\xed', 'vldr s5, [pc]', {}),
	(b'\x00\x2a\xdf\xed', 'vldr s5, [pc]', {}),
	(b'\x00\x2a\x5f\xed', 'vldr s5, [pc, #-0]', {}),
	(b'\x00\x4b\x81\xed', 'vstr d4, [r1]', {}),
	(b'\x06\x4b\x81\xed', 'vstr d4, [r1, #0x18]', {}),
	(b'\x06\x4b\x01\xed', 'vstr d4, [r1, ', {}),
	(b'\x00\x0a\x8e\xed', 'vstr s0, [lr]', {}),
	(b'\x00\x0b\x8e\xed', 'vstr d0, [lr]', {}),
	(b'\x00\x2a\x81\xed', 'vstr s4, [r1]', {}),
	(b'\x06\x2a\x81\xed', 'vstr s4, [r1, #0x18]', {}),
	(b'\x06\x2a\x01\xed', 'vstr s4, [r1, ', {}),
	(b'\x0c\x2b\x91\xec', 'vldmia r1, {d2, d3, d4, d5, d6, d7}', {}),
	(b'\x06\x1a\x91\xec', 'vldmia r1, {s2, s3, s4, s5, s6, s7}', {}),
	(b'\x0c\x2b\x81\xec', 'vstmia r1, {d2, d3, d4, d5, d6, d7}', {}),
	(b'\x06\x1a\x81\xec', 'vstmia r1, {s2, s3, s4, s5, s6, s7}', {}),
	(b'\x10\x8b\x2d\xed', 'vpush {d8, d9, d10, d11, d12, d13, d14, d15}', {}),
	(b'\x07\x0b\xb5\xec', 'fldmiax r5!, {d0, d1, d2}', {}),
	(b'\x05\x4b\x90\x0c', 'fldmiaxeq r0, {d4, d5}', {}),
	(b'\x07\x4b\x35\x1d', 'fldmdbxne r5!, {d4, d5, d6}', {}),
	(b'\x11\x0b\xa5\xec', 'fstmiax r5!, {d0, d1, d2, d3, d4, d5, d6, d7}', {}),
	(b'\x05\x8b\x84\x0c', 'fstmiaxeq r4, {d8, d9}', {}),
	(b'\x07\x2b\x27\x1d', 'fstmdbxne r7!, {d2, d3, d4}', {}),
	(b'\x40\x0b\xbd\xee', 'vcvtr.s32.f64 s0, d0', {}),
	(b'\x60\x0a\xbd\xee', 'vcvtr.s32.f32 s0, s1', {}),
	(b'\x40\x0b\xbc\xee', 'vcvtr.u32.f64 s0, d0', {}),
	(b'\x60\x0a\xbc\xee', 'vcvtr.u32.f32 s0, s1', {}),
	(b'\x90\x8a\x00\xee', 'vmov s1, r8', {}),
	(b'\x10\x4a\x01\xee', 'vmov s2, r4', {}),
	(b'\x90\x6a\x01\xee', 'vmov s3, r6', {}),
	(b'\x10\x1a\x02\xee', 'vmov s4, r1', {}),
	(b'\x90\x2a\x02\xee', 'vmov s5, r2', {}),
	(b'\x10\x3a\x03\xee', 'vmov s6, r3', {}),
	(b'\x10\x1a\x14\xee', 'vmov r1, s8', {}),
	(b'\x10\x2a\x12\xee', 'vmov r2, s4', {}),
	(b'\x10\x3a\x13\xee', 'vmov r3, s6', {}),
	(b'\x90\x4a\x10\xee', 'vmov r4, s1', {}),
	(b'\x10\x5a\x11\xee', 'vmov r5, s2', {}),
	(b'\x90\x6a\x11\xee', 'vmov r6, s3', {}),
	(b'\xc6\x0a\xbb\xee', 'vcvt.f32.u32 s0, s0, #0x14', {}),
	(b'\xc0\x0b\xba\xee', 'vcvt.f64.s32 d0, d0, #0x20', {}),
	(b'\x67\x0a\xbb\xee', 'vcvt.f32.u16 s0, s0, #0x1', {}),
	(b'\x40\x0b\xba\xee', 'vcvt.f64.s16 d0, d0, #0x10', {}),
	(b'\xc6\x0a\xfa\xee', 'vcvt.f32.s32 s1, s1, #0x14', {}),
	(b'\xc0\x4b\xfb\xee', 'vcvt.f64.u32 d20, d20, #0x20', {}),
	(b'\x67\x8a\xfa\xee', 'vcvt.f32.s16 s17, s17, #0x1', {}),
	(b'\x40\x7b\xfb\xee', 'vcvt.f64.u16 d23, d23, #0x10', {}),
	(b'\xc6\x6a\xbf\xee', 'vcvt.u32.f32 s12, s12, #0x14', {}),
	(b'\xc0\x2b\xbe\xee', 'vcvt.s32.f64 d2, d2, #0x20', {}),
	(b'\x67\xea\xbf\xee', 'vcvt.u16.f32 s28, s28, #0x1', {}),
	(b'\x40\xfb\xbe\xee', 'vcvt.s16.f64 d15, d15, #0x10', {}),
	(b'\xc6\x0a\xfe\xee', 'vcvt.s32.f32 s1, s1, #0x14', {}),
	(b'\xc0\x4b\xff\xee', 'vcvt.u32.f64 d20, d20, #0x20', {}),
	(b'\x67\x8a\xfe\xee', 'vcvt.s16.f32 s17, s17, #0x1', {}),
	(b'\x40\x7b\xff\xee', 'vcvt.u16.f64 d23, d23, #0x10', {}),
	(b'\x10\x40\x80\xf2', 'vmov.i32 d4, #0', {}),
	(b'\x12\x46\x84\xf2', 'vmov.i32 d4, #0x42000000', {}),
	(b'\xa1\x0b\xe2\xee', 'vfma.f64 d16, d18, d17', {}),
	(b'\x00\x1a\xa2\xee', 'vfma.f32 s2, s4, s0', {}),
	(b'\xb1\x0c\x42\xf2', 'vfma.f32 d16, d18, d17', {}),
	(b'\x50\x4c\x08\xf2', 'vfma.f32 q2, q4, q0', {}),
	(b'\xe1\x0b\xd2\xee', 'vfnma.f64 d16, d18, d17', {}),
	(b'\x40\x1a\x92\xee', 'vfnma.f32 s2, s4, s0', {}),
	(b'\xe1\x0b\xe2\xee', 'vfms.f64 d16, d18, d17', {}),
	(b'\x40\x1a\xa2\xee', 'vfms.f32 s2, s4, s0', {}),
	(b'\xb1\x0c\x62\xf2', 'vfms.f32 d16, d18, d17', {}),
	(b'\x50\x4c\x28\xf2', 'vfms.f32 q2, q4, q0', {}),
	(b'\xa1\x0b\xd2\xee', 'vfnms.f64 d16, d18, d17', {}),
	(b'\x00\x1a\x92\xee', 'vfnms.f32 s2, s4, s0', {}),
	(b'\x0a\x8b\x2d\xed', 'vpush {d8, d9, d10, d11, d12}', {}),
	(b'\x05\x4a\x2d\xed', 'vpush {s8, s9, s10, s11, s12}', {}),
	(b'\x0a\x8b\xbd\xec', 'vpop {d8, d9, d10, d11, d12}', {}),
	(b'\x05\x4a\xbd\xec', 'vpop {s8, s9, s10, s11, s12}', {}),
	(b'\x0a\x8b\x2d\xed', 'vpush {d8, d9, d10, d11, d12}', {}),
	(b'\x05\x4a\x2d\xed', 'vpush {s8, s9, s10, s11, s12}', {}),
	(b'\x0a\x8b\xbd\xec', 'vpop {d8, d9, d10, d11, d12}', {}),
	(b'\x05\x4a\xbd\xec', 'vpop {s8, s9, s10, s11, s12}', {}),
)

import os, sys, struct, platform, re
from ctypes import *

module = None
disasm_buf = create_string_buffer(2048)
inst_buf = create_string_buffer(2048)

def disassemble_binja(insvalue, addr):
	global module, disasm_buf, inst_buf
	for a in range(len(disasm_buf)):
		disasm_buf[a] = b'\0'
	for a in range(len(inst_buf)):
		inst_buf[a] = b'\0'
	err = module.armv7_decompose(insvalue, inst_buf, addr, False)
	if err == 1: return "decomposer failed"
	elif err == 2: return "group decomposition failed"
	elif err == 3: return "unimplemented"
	elif err == 4: return "disassembler failed"
	if module.armv7_disassemble(inst_buf, disasm_buf, 2048) == 0:
		return disasm_buf.value.decode('utf-8')
	return "disassembly failed"

def distill(instxt):
	instxt = re.sub(r'\s+', ' ', instxt)
	return instxt

if __name__ == '__main__':
	if platform.system() == 'Linux': module = CDLL('disasm.so')
	elif platform.system() == 'Windows': module = CDLL('disasm.dll')
	# gcc -shared armv7.c -o disasm.dylib
	elif platform.system() == "Darwin": module = CDLL('disasm.dylib')

	for (test_i, (data, expected, options)) in enumerate(test_cases):
		addr = options.get('addr', 0)
		insvalue = struct.unpack('<I', data)[0]
		actual = disassemble_binja(insvalue, addr)
		actual = distill(actual)
		if actual != expected:
			print('MISMATCH AT TEST %d!' % test_i)
			print('\t    data: %s' % repr(data))
			print('\t address: %08X' % addr)
			print('\tinsvalue: 0x%08X' % insvalue)
			print('\texpected: %s' % expected)
			print('\t  actual: %s' % actual)
			sys.exit(-1)

	print('success!')
	sys.exit(0)

