#include <inttypes.h>

#include <string>
#include <vector>
#include <array>

// from api
#include "il.h" /* for ARM64_INTRIN_NORMAL_END, ExtractRegister() */
#include "lowlevelilinstruction.h"

using namespace std;
using namespace BinaryNinja;

enum NeonIntrinsic : uint32_t
{
	ARM64_INTRIN_VADD_S8 = ARM64_INTRIN_NORMAL_END,
	ARM64_INTRIN_VADDQ_S8,
	ARM64_INTRIN_VADD_S16,
	ARM64_INTRIN_VADDQ_S16,
	ARM64_INTRIN_VADD_S32,
	ARM64_INTRIN_VADDQ_S32,
	ARM64_INTRIN_VADD_S64,
	ARM64_INTRIN_VADDQ_S64,
	ARM64_INTRIN_VADD_U8,
	ARM64_INTRIN_VADDQ_U8,
	ARM64_INTRIN_VADD_U16,
	ARM64_INTRIN_VADDQ_U16,
	ARM64_INTRIN_VADD_U32,
	ARM64_INTRIN_VADDQ_U32,
	ARM64_INTRIN_VADD_U64,
	ARM64_INTRIN_VADDQ_U64,
	ARM64_INTRIN_VADD_F32,
	ARM64_INTRIN_VADDQ_F32,
	ARM64_INTRIN_VADD_F64,
	ARM64_INTRIN_VADDQ_F64,
	ARM64_INTRIN_VADDD_S64,
	ARM64_INTRIN_VADDD_U64,
	ARM64_INTRIN_VADDL_S8,
	ARM64_INTRIN_VADDL_S16,
	ARM64_INTRIN_VADDL_S32,
	ARM64_INTRIN_VADDL_U8,
	ARM64_INTRIN_VADDL_U16,
	ARM64_INTRIN_VADDL_U32,
	ARM64_INTRIN_VADDL_HIGH_S8,
	ARM64_INTRIN_VADDL_HIGH_S16,
	ARM64_INTRIN_VADDL_HIGH_S32,
	ARM64_INTRIN_VADDL_HIGH_U8,
	ARM64_INTRIN_VADDL_HIGH_U16,
	ARM64_INTRIN_VADDL_HIGH_U32,
	ARM64_INTRIN_VADDW_S8,
	ARM64_INTRIN_VADDW_S16,
	ARM64_INTRIN_VADDW_S32,
	ARM64_INTRIN_VADDW_U8,
	ARM64_INTRIN_VADDW_U16,
	ARM64_INTRIN_VADDW_U32,
	ARM64_INTRIN_VADDW_HIGH_S8,
	ARM64_INTRIN_VADDW_HIGH_S16,
	ARM64_INTRIN_VADDW_HIGH_S32,
	ARM64_INTRIN_VADDW_HIGH_U8,
	ARM64_INTRIN_VADDW_HIGH_U16,
	ARM64_INTRIN_VADDW_HIGH_U32,
	ARM64_INTRIN_VHADD_S8,
	ARM64_INTRIN_VHADDQ_S8,
	ARM64_INTRIN_VHADD_S16,
	ARM64_INTRIN_VHADDQ_S16,
	ARM64_INTRIN_VHADD_S32,
	ARM64_INTRIN_VHADDQ_S32,
	ARM64_INTRIN_VHADD_U8,
	ARM64_INTRIN_VHADDQ_U8,
	ARM64_INTRIN_VHADD_U16,
	ARM64_INTRIN_VHADDQ_U16,
	ARM64_INTRIN_VHADD_U32,
	ARM64_INTRIN_VHADDQ_U32,
	ARM64_INTRIN_VRHADD_S8,
	ARM64_INTRIN_VRHADDQ_S8,
	ARM64_INTRIN_VRHADD_S16,
	ARM64_INTRIN_VRHADDQ_S16,
	ARM64_INTRIN_VRHADD_S32,
	ARM64_INTRIN_VRHADDQ_S32,
	ARM64_INTRIN_VRHADD_U8,
	ARM64_INTRIN_VRHADDQ_U8,
	ARM64_INTRIN_VRHADD_U16,
	ARM64_INTRIN_VRHADDQ_U16,
	ARM64_INTRIN_VRHADD_U32,
	ARM64_INTRIN_VRHADDQ_U32,
	ARM64_INTRIN_VQADD_S8,
	ARM64_INTRIN_VQADDQ_S8,
	ARM64_INTRIN_VQADD_S16,
	ARM64_INTRIN_VQADDQ_S16,
	ARM64_INTRIN_VQADD_S32,
	ARM64_INTRIN_VQADDQ_S32,
	ARM64_INTRIN_VQADD_S64,
	ARM64_INTRIN_VQADDQ_S64,
	ARM64_INTRIN_VQADD_U8,
	ARM64_INTRIN_VQADDQ_U8,
	ARM64_INTRIN_VQADD_U16,
	ARM64_INTRIN_VQADDQ_U16,
	ARM64_INTRIN_VQADD_U32,
	ARM64_INTRIN_VQADDQ_U32,
	ARM64_INTRIN_VQADD_U64,
	ARM64_INTRIN_VQADDQ_U64,
	ARM64_INTRIN_VQADDB_S8,
	ARM64_INTRIN_VQADDH_S16,
	ARM64_INTRIN_VQADDS_S32,
	ARM64_INTRIN_VQADDD_S64,
	ARM64_INTRIN_VQADDB_U8,
	ARM64_INTRIN_VQADDH_U16,
	ARM64_INTRIN_VQADDS_U32,
	ARM64_INTRIN_VQADDD_U64,
	ARM64_INTRIN_VUQADD_S8,
	ARM64_INTRIN_VUQADDQ_S8,
	ARM64_INTRIN_VUQADD_S16,
	ARM64_INTRIN_VUQADDQ_S16,
	ARM64_INTRIN_VUQADD_S32,
	ARM64_INTRIN_VUQADDQ_S32,
	ARM64_INTRIN_VUQADD_S64,
	ARM64_INTRIN_VUQADDQ_S64,
	ARM64_INTRIN_VUQADDB_S8,
	ARM64_INTRIN_VUQADDH_S16,
	ARM64_INTRIN_VUQADDS_S32,
	ARM64_INTRIN_VUQADDD_S64,
	ARM64_INTRIN_VSQADD_U8,
	ARM64_INTRIN_VSQADDQ_U8,
	ARM64_INTRIN_VSQADD_U16,
	ARM64_INTRIN_VSQADDQ_U16,
	ARM64_INTRIN_VSQADD_U32,
	ARM64_INTRIN_VSQADDQ_U32,
	ARM64_INTRIN_VSQADD_U64,
	ARM64_INTRIN_VSQADDQ_U64,
	ARM64_INTRIN_VSQADDB_U8,
	ARM64_INTRIN_VSQADDH_U16,
	ARM64_INTRIN_VSQADDS_U32,
	ARM64_INTRIN_VSQADDD_U64,
	ARM64_INTRIN_VADDHN_S16,
	ARM64_INTRIN_VADDHN_S32,
	ARM64_INTRIN_VADDHN_S64,
	ARM64_INTRIN_VADDHN_U16,
	ARM64_INTRIN_VADDHN_U32,
	ARM64_INTRIN_VADDHN_U64,
	ARM64_INTRIN_VADDHN_HIGH_S16,
	ARM64_INTRIN_VADDHN_HIGH_S32,
	ARM64_INTRIN_VADDHN_HIGH_S64,
	ARM64_INTRIN_VADDHN_HIGH_U16,
	ARM64_INTRIN_VADDHN_HIGH_U32,
	ARM64_INTRIN_VADDHN_HIGH_U64,
	ARM64_INTRIN_VRADDHN_S16,
	ARM64_INTRIN_VRADDHN_S32,
	ARM64_INTRIN_VRADDHN_S64,
	ARM64_INTRIN_VRADDHN_U16,
	ARM64_INTRIN_VRADDHN_U32,
	ARM64_INTRIN_VRADDHN_U64,
	ARM64_INTRIN_VRADDHN_HIGH_S16,
	ARM64_INTRIN_VRADDHN_HIGH_S32,
	ARM64_INTRIN_VRADDHN_HIGH_S64,
	ARM64_INTRIN_VRADDHN_HIGH_U16,
	ARM64_INTRIN_VRADDHN_HIGH_U32,
	ARM64_INTRIN_VRADDHN_HIGH_U64,
	ARM64_INTRIN_VMUL_S8,
	ARM64_INTRIN_VMULQ_S8,
	ARM64_INTRIN_VMUL_S16,
	ARM64_INTRIN_VMULQ_S16,
	ARM64_INTRIN_VMUL_S32,
	ARM64_INTRIN_VMULQ_S32,
	ARM64_INTRIN_VMUL_U8,
	ARM64_INTRIN_VMULQ_U8,
	ARM64_INTRIN_VMUL_U16,
	ARM64_INTRIN_VMULQ_U16,
	ARM64_INTRIN_VMUL_U32,
	ARM64_INTRIN_VMULQ_U32,
	ARM64_INTRIN_VMUL_F32,
	ARM64_INTRIN_VMULQ_F32,
	ARM64_INTRIN_VMUL_P8,
	ARM64_INTRIN_VMULQ_P8,
	ARM64_INTRIN_VMUL_F64,
	ARM64_INTRIN_VMULQ_F64,
	ARM64_INTRIN_VMULX_F32,
	ARM64_INTRIN_VMULXQ_F32,
	ARM64_INTRIN_VMULX_F64,
	ARM64_INTRIN_VMULXQ_F64,
	ARM64_INTRIN_VMULXS_F32,
	ARM64_INTRIN_VMULXD_F64,
	ARM64_INTRIN_VMULX_LANE_F32,
	ARM64_INTRIN_VMULXQ_LANE_F32,
	ARM64_INTRIN_VMULX_LANE_F64,
	ARM64_INTRIN_VMULXQ_LANE_F64,
	ARM64_INTRIN_VMULXS_LANE_F32,
	ARM64_INTRIN_VMULXD_LANE_F64,
	ARM64_INTRIN_VMULX_LANEQ_F32,
	ARM64_INTRIN_VMULXQ_LANEQ_F32,
	ARM64_INTRIN_VMULX_LANEQ_F64,
	ARM64_INTRIN_VMULXQ_LANEQ_F64,
	ARM64_INTRIN_VMULXS_LANEQ_F32,
	ARM64_INTRIN_VMULXD_LANEQ_F64,
	ARM64_INTRIN_VDIV_F32,
	ARM64_INTRIN_VDIVQ_F32,
	ARM64_INTRIN_VDIV_F64,
	ARM64_INTRIN_VDIVQ_F64,
	ARM64_INTRIN_VMLA_S8,
	ARM64_INTRIN_VMLAQ_S8,
	ARM64_INTRIN_VMLA_S16,
	ARM64_INTRIN_VMLAQ_S16,
	ARM64_INTRIN_VMLA_S32,
	ARM64_INTRIN_VMLAQ_S32,
	ARM64_INTRIN_VMLA_U8,
	ARM64_INTRIN_VMLAQ_U8,
	ARM64_INTRIN_VMLA_U16,
	ARM64_INTRIN_VMLAQ_U16,
	ARM64_INTRIN_VMLA_U32,
	ARM64_INTRIN_VMLAQ_U32,
	ARM64_INTRIN_VMLA_F32,
	ARM64_INTRIN_VMLAQ_F32,
	ARM64_INTRIN_VMLA_F64,
	ARM64_INTRIN_VMLAQ_F64,
	ARM64_INTRIN_VMLAL_S8,
	ARM64_INTRIN_VMLAL_S16,
	ARM64_INTRIN_VMLAL_S32,
	ARM64_INTRIN_VMLAL_U8,
	ARM64_INTRIN_VMLAL_U16,
	ARM64_INTRIN_VMLAL_U32,
	ARM64_INTRIN_VMLAL_HIGH_S8,
	ARM64_INTRIN_VMLAL_HIGH_S16,
	ARM64_INTRIN_VMLAL_HIGH_S32,
	ARM64_INTRIN_VMLAL_HIGH_U8,
	ARM64_INTRIN_VMLAL_HIGH_U16,
	ARM64_INTRIN_VMLAL_HIGH_U32,
	ARM64_INTRIN_VMLS_S8,
	ARM64_INTRIN_VMLSQ_S8,
	ARM64_INTRIN_VMLS_S16,
	ARM64_INTRIN_VMLSQ_S16,
	ARM64_INTRIN_VMLS_S32,
	ARM64_INTRIN_VMLSQ_S32,
	ARM64_INTRIN_VMLS_U8,
	ARM64_INTRIN_VMLSQ_U8,
	ARM64_INTRIN_VMLS_U16,
	ARM64_INTRIN_VMLSQ_U16,
	ARM64_INTRIN_VMLS_U32,
	ARM64_INTRIN_VMLSQ_U32,
	ARM64_INTRIN_VMLS_F32,
	ARM64_INTRIN_VMLSQ_F32,
	ARM64_INTRIN_VMLS_F64,
	ARM64_INTRIN_VMLSQ_F64,
	ARM64_INTRIN_VMLSL_S8,
	ARM64_INTRIN_VMLSL_S16,
	ARM64_INTRIN_VMLSL_S32,
	ARM64_INTRIN_VMLSL_U8,
	ARM64_INTRIN_VMLSL_U16,
	ARM64_INTRIN_VMLSL_U32,
	ARM64_INTRIN_VMLSL_HIGH_S8,
	ARM64_INTRIN_VMLSL_HIGH_S16,
	ARM64_INTRIN_VMLSL_HIGH_S32,
	ARM64_INTRIN_VMLSL_HIGH_U8,
	ARM64_INTRIN_VMLSL_HIGH_U16,
	ARM64_INTRIN_VMLSL_HIGH_U32,
	ARM64_INTRIN_VFMA_F32,
	ARM64_INTRIN_VFMAQ_F32,
	ARM64_INTRIN_VFMA_F64,
	ARM64_INTRIN_VFMAQ_F64,
	ARM64_INTRIN_VFMA_LANE_F32,
	ARM64_INTRIN_VFMAQ_LANE_F32,
	ARM64_INTRIN_VFMA_LANE_F64,
	ARM64_INTRIN_VFMAQ_LANE_F64,
	ARM64_INTRIN_VFMAS_LANE_F32,
	ARM64_INTRIN_VFMAD_LANE_F64,
	ARM64_INTRIN_VFMA_LANEQ_F32,
	ARM64_INTRIN_VFMAQ_LANEQ_F32,
	ARM64_INTRIN_VFMA_LANEQ_F64,
	ARM64_INTRIN_VFMAQ_LANEQ_F64,
	ARM64_INTRIN_VFMAS_LANEQ_F32,
	ARM64_INTRIN_VFMAD_LANEQ_F64,
	ARM64_INTRIN_VFMS_F32,
	ARM64_INTRIN_VFMSQ_F32,
	ARM64_INTRIN_VFMS_F64,
	ARM64_INTRIN_VFMSQ_F64,
	ARM64_INTRIN_VFMS_LANE_F32,
	ARM64_INTRIN_VFMSQ_LANE_F32,
	ARM64_INTRIN_VFMS_LANE_F64,
	ARM64_INTRIN_VFMSQ_LANE_F64,
	ARM64_INTRIN_VFMSS_LANE_F32,
	ARM64_INTRIN_VFMSD_LANE_F64,
	ARM64_INTRIN_VFMS_LANEQ_F32,
	ARM64_INTRIN_VFMSQ_LANEQ_F32,
	ARM64_INTRIN_VFMS_LANEQ_F64,
	ARM64_INTRIN_VFMSQ_LANEQ_F64,
	ARM64_INTRIN_VFMSS_LANEQ_F32,
	ARM64_INTRIN_VFMSD_LANEQ_F64,
	ARM64_INTRIN_VQDMULH_S16,
	ARM64_INTRIN_VQDMULHQ_S16,
	ARM64_INTRIN_VQDMULH_S32,
	ARM64_INTRIN_VQDMULHQ_S32,
	ARM64_INTRIN_VQDMULHH_S16,
	ARM64_INTRIN_VQDMULHS_S32,
	ARM64_INTRIN_VQRDMULH_S16,
	ARM64_INTRIN_VQRDMULHQ_S16,
	ARM64_INTRIN_VQRDMULH_S32,
	ARM64_INTRIN_VQRDMULHQ_S32,
	ARM64_INTRIN_VQRDMULHH_S16,
	ARM64_INTRIN_VQRDMULHS_S32,
	ARM64_INTRIN_VQDMLAL_S16,
	ARM64_INTRIN_VQDMLAL_S32,
	ARM64_INTRIN_VQDMLALH_S16,
	ARM64_INTRIN_VQDMLALS_S32,
	ARM64_INTRIN_VQDMLAL_HIGH_S16,
	ARM64_INTRIN_VQDMLAL_HIGH_S32,
	ARM64_INTRIN_VQDMLSL_S16,
	ARM64_INTRIN_VQDMLSL_S32,
	ARM64_INTRIN_VQDMLSLH_S16,
	ARM64_INTRIN_VQDMLSLS_S32,
	ARM64_INTRIN_VQDMLSL_HIGH_S16,
	ARM64_INTRIN_VQDMLSL_HIGH_S32,
	ARM64_INTRIN_VMULL_S8,
	ARM64_INTRIN_VMULL_S16,
	ARM64_INTRIN_VMULL_S32,
	ARM64_INTRIN_VMULL_U8,
	ARM64_INTRIN_VMULL_U16,
	ARM64_INTRIN_VMULL_U32,
	ARM64_INTRIN_VMULL_P8,
	ARM64_INTRIN_VMULL_HIGH_S8,
	ARM64_INTRIN_VMULL_HIGH_S16,
	ARM64_INTRIN_VMULL_HIGH_S32,
	ARM64_INTRIN_VMULL_HIGH_U8,
	ARM64_INTRIN_VMULL_HIGH_U16,
	ARM64_INTRIN_VMULL_HIGH_U32,
	ARM64_INTRIN_VMULL_HIGH_P8,
	ARM64_INTRIN_VQDMULL_S16,
	ARM64_INTRIN_VQDMULL_S32,
	ARM64_INTRIN_VQDMULLH_S16,
	ARM64_INTRIN_VQDMULLS_S32,
	ARM64_INTRIN_VQDMULL_HIGH_S16,
	ARM64_INTRIN_VQDMULL_HIGH_S32,
	ARM64_INTRIN_VSUB_S8,
	ARM64_INTRIN_VSUBQ_S8,
	ARM64_INTRIN_VSUB_S16,
	ARM64_INTRIN_VSUBQ_S16,
	ARM64_INTRIN_VSUB_S32,
	ARM64_INTRIN_VSUBQ_S32,
	ARM64_INTRIN_VSUB_S64,
	ARM64_INTRIN_VSUBQ_S64,
	ARM64_INTRIN_VSUB_U8,
	ARM64_INTRIN_VSUBQ_U8,
	ARM64_INTRIN_VSUB_U16,
	ARM64_INTRIN_VSUBQ_U16,
	ARM64_INTRIN_VSUB_U32,
	ARM64_INTRIN_VSUBQ_U32,
	ARM64_INTRIN_VSUB_U64,
	ARM64_INTRIN_VSUBQ_U64,
	ARM64_INTRIN_VSUB_F32,
	ARM64_INTRIN_VSUBQ_F32,
	ARM64_INTRIN_VSUB_F64,
	ARM64_INTRIN_VSUBQ_F64,
	ARM64_INTRIN_VSUBD_S64,
	ARM64_INTRIN_VSUBD_U64,
	ARM64_INTRIN_VSUBL_S8,
	ARM64_INTRIN_VSUBL_S16,
	ARM64_INTRIN_VSUBL_S32,
	ARM64_INTRIN_VSUBL_U8,
	ARM64_INTRIN_VSUBL_U16,
	ARM64_INTRIN_VSUBL_U32,
	ARM64_INTRIN_VSUBL_HIGH_S8,
	ARM64_INTRIN_VSUBL_HIGH_S16,
	ARM64_INTRIN_VSUBL_HIGH_S32,
	ARM64_INTRIN_VSUBL_HIGH_U8,
	ARM64_INTRIN_VSUBL_HIGH_U16,
	ARM64_INTRIN_VSUBL_HIGH_U32,
	ARM64_INTRIN_VSUBW_S8,
	ARM64_INTRIN_VSUBW_S16,
	ARM64_INTRIN_VSUBW_S32,
	ARM64_INTRIN_VSUBW_U8,
	ARM64_INTRIN_VSUBW_U16,
	ARM64_INTRIN_VSUBW_U32,
	ARM64_INTRIN_VSUBW_HIGH_S8,
	ARM64_INTRIN_VSUBW_HIGH_S16,
	ARM64_INTRIN_VSUBW_HIGH_S32,
	ARM64_INTRIN_VSUBW_HIGH_U8,
	ARM64_INTRIN_VSUBW_HIGH_U16,
	ARM64_INTRIN_VSUBW_HIGH_U32,
	ARM64_INTRIN_VHSUB_S8,
	ARM64_INTRIN_VHSUBQ_S8,
	ARM64_INTRIN_VHSUB_S16,
	ARM64_INTRIN_VHSUBQ_S16,
	ARM64_INTRIN_VHSUB_S32,
	ARM64_INTRIN_VHSUBQ_S32,
	ARM64_INTRIN_VHSUB_U8,
	ARM64_INTRIN_VHSUBQ_U8,
	ARM64_INTRIN_VHSUB_U16,
	ARM64_INTRIN_VHSUBQ_U16,
	ARM64_INTRIN_VHSUB_U32,
	ARM64_INTRIN_VHSUBQ_U32,
	ARM64_INTRIN_VQSUB_S8,
	ARM64_INTRIN_VQSUBQ_S8,
	ARM64_INTRIN_VQSUB_S16,
	ARM64_INTRIN_VQSUBQ_S16,
	ARM64_INTRIN_VQSUB_S32,
	ARM64_INTRIN_VQSUBQ_S32,
	ARM64_INTRIN_VQSUB_S64,
	ARM64_INTRIN_VQSUBQ_S64,
	ARM64_INTRIN_VQSUB_U8,
	ARM64_INTRIN_VQSUBQ_U8,
	ARM64_INTRIN_VQSUB_U16,
	ARM64_INTRIN_VQSUBQ_U16,
	ARM64_INTRIN_VQSUB_U32,
	ARM64_INTRIN_VQSUBQ_U32,
	ARM64_INTRIN_VQSUB_U64,
	ARM64_INTRIN_VQSUBQ_U64,
	ARM64_INTRIN_VQSUBB_S8,
	ARM64_INTRIN_VQSUBH_S16,
	ARM64_INTRIN_VQSUBS_S32,
	ARM64_INTRIN_VQSUBD_S64,
	ARM64_INTRIN_VQSUBB_U8,
	ARM64_INTRIN_VQSUBH_U16,
	ARM64_INTRIN_VQSUBS_U32,
	ARM64_INTRIN_VQSUBD_U64,
	ARM64_INTRIN_VSUBHN_S16,
	ARM64_INTRIN_VSUBHN_S32,
	ARM64_INTRIN_VSUBHN_S64,
	ARM64_INTRIN_VSUBHN_U16,
	ARM64_INTRIN_VSUBHN_U32,
	ARM64_INTRIN_VSUBHN_U64,
	ARM64_INTRIN_VSUBHN_HIGH_S16,
	ARM64_INTRIN_VSUBHN_HIGH_S32,
	ARM64_INTRIN_VSUBHN_HIGH_S64,
	ARM64_INTRIN_VSUBHN_HIGH_U16,
	ARM64_INTRIN_VSUBHN_HIGH_U32,
	ARM64_INTRIN_VSUBHN_HIGH_U64,
	ARM64_INTRIN_VRSUBHN_S16,
	ARM64_INTRIN_VRSUBHN_S32,
	ARM64_INTRIN_VRSUBHN_S64,
	ARM64_INTRIN_VRSUBHN_U16,
	ARM64_INTRIN_VRSUBHN_U32,
	ARM64_INTRIN_VRSUBHN_U64,
	ARM64_INTRIN_VRSUBHN_HIGH_S16,
	ARM64_INTRIN_VRSUBHN_HIGH_S32,
	ARM64_INTRIN_VRSUBHN_HIGH_S64,
	ARM64_INTRIN_VRSUBHN_HIGH_U16,
	ARM64_INTRIN_VRSUBHN_HIGH_U32,
	ARM64_INTRIN_VRSUBHN_HIGH_U64,
	ARM64_INTRIN_VCEQ_S8,
	ARM64_INTRIN_VCEQQ_S8,
	ARM64_INTRIN_VCEQ_S16,
	ARM64_INTRIN_VCEQQ_S16,
	ARM64_INTRIN_VCEQ_S32,
	ARM64_INTRIN_VCEQQ_S32,
	ARM64_INTRIN_VCEQ_U8,
	ARM64_INTRIN_VCEQQ_U8,
	ARM64_INTRIN_VCEQ_U16,
	ARM64_INTRIN_VCEQQ_U16,
	ARM64_INTRIN_VCEQ_U32,
	ARM64_INTRIN_VCEQQ_U32,
	ARM64_INTRIN_VCEQ_F32,
	ARM64_INTRIN_VCEQQ_F32,
	ARM64_INTRIN_VCEQ_P8,
	ARM64_INTRIN_VCEQQ_P8,
	ARM64_INTRIN_VCEQ_S64,
	ARM64_INTRIN_VCEQQ_S64,
	ARM64_INTRIN_VCEQ_U64,
	ARM64_INTRIN_VCEQQ_U64,
	ARM64_INTRIN_VCEQ_P64,
	ARM64_INTRIN_VCEQQ_P64,
	ARM64_INTRIN_VCEQ_F64,
	ARM64_INTRIN_VCEQQ_F64,
	ARM64_INTRIN_VCEQD_S64,
	ARM64_INTRIN_VCEQD_U64,
	ARM64_INTRIN_VCEQS_F32,
	ARM64_INTRIN_VCEQD_F64,
	ARM64_INTRIN_VCEQZ_S8,
	ARM64_INTRIN_VCEQZQ_S8,
	ARM64_INTRIN_VCEQZ_S16,
	ARM64_INTRIN_VCEQZQ_S16,
	ARM64_INTRIN_VCEQZ_S32,
	ARM64_INTRIN_VCEQZQ_S32,
	ARM64_INTRIN_VCEQZ_U8,
	ARM64_INTRIN_VCEQZQ_U8,
	ARM64_INTRIN_VCEQZ_U16,
	ARM64_INTRIN_VCEQZQ_U16,
	ARM64_INTRIN_VCEQZ_U32,
	ARM64_INTRIN_VCEQZQ_U32,
	ARM64_INTRIN_VCEQZ_F32,
	ARM64_INTRIN_VCEQZQ_F32,
	ARM64_INTRIN_VCEQZ_P8,
	ARM64_INTRIN_VCEQZQ_P8,
	ARM64_INTRIN_VCEQZ_S64,
	ARM64_INTRIN_VCEQZQ_S64,
	ARM64_INTRIN_VCEQZ_U64,
	ARM64_INTRIN_VCEQZQ_U64,
	ARM64_INTRIN_VCEQZ_P64,
	ARM64_INTRIN_VCEQZQ_P64,
	ARM64_INTRIN_VCEQZ_F64,
	ARM64_INTRIN_VCEQZQ_F64,
	ARM64_INTRIN_VCEQZD_S64,
	ARM64_INTRIN_VCEQZD_U64,
	ARM64_INTRIN_VCEQZS_F32,
	ARM64_INTRIN_VCEQZD_F64,
	ARM64_INTRIN_VCGE_S8,
	ARM64_INTRIN_VCGEQ_S8,
	ARM64_INTRIN_VCGE_S16,
	ARM64_INTRIN_VCGEQ_S16,
	ARM64_INTRIN_VCGE_S32,
	ARM64_INTRIN_VCGEQ_S32,
	ARM64_INTRIN_VCGE_U8,
	ARM64_INTRIN_VCGEQ_U8,
	ARM64_INTRIN_VCGE_U16,
	ARM64_INTRIN_VCGEQ_U16,
	ARM64_INTRIN_VCGE_U32,
	ARM64_INTRIN_VCGEQ_U32,
	ARM64_INTRIN_VCGE_F32,
	ARM64_INTRIN_VCGEQ_F32,
	ARM64_INTRIN_VCGE_S64,
	ARM64_INTRIN_VCGEQ_S64,
	ARM64_INTRIN_VCGE_U64,
	ARM64_INTRIN_VCGEQ_U64,
	ARM64_INTRIN_VCGE_F64,
	ARM64_INTRIN_VCGEQ_F64,
	ARM64_INTRIN_VCGED_S64,
	ARM64_INTRIN_VCGED_U64,
	ARM64_INTRIN_VCGES_F32,
	ARM64_INTRIN_VCGED_F64,
	ARM64_INTRIN_VCGEZ_S8,
	ARM64_INTRIN_VCGEZQ_S8,
	ARM64_INTRIN_VCGEZ_S16,
	ARM64_INTRIN_VCGEZQ_S16,
	ARM64_INTRIN_VCGEZ_S32,
	ARM64_INTRIN_VCGEZQ_S32,
	ARM64_INTRIN_VCGEZ_S64,
	ARM64_INTRIN_VCGEZQ_S64,
	ARM64_INTRIN_VCGEZ_F32,
	ARM64_INTRIN_VCGEZQ_F32,
	ARM64_INTRIN_VCGEZ_F64,
	ARM64_INTRIN_VCGEZQ_F64,
	ARM64_INTRIN_VCGEZD_S64,
	ARM64_INTRIN_VCGEZS_F32,
	ARM64_INTRIN_VCGEZD_F64,
	ARM64_INTRIN_VCLE_S8,
	ARM64_INTRIN_VCLEQ_S8,
	ARM64_INTRIN_VCLE_S16,
	ARM64_INTRIN_VCLEQ_S16,
	ARM64_INTRIN_VCLE_S32,
	ARM64_INTRIN_VCLEQ_S32,
	ARM64_INTRIN_VCLE_U8,
	ARM64_INTRIN_VCLEQ_U8,
	ARM64_INTRIN_VCLE_U16,
	ARM64_INTRIN_VCLEQ_U16,
	ARM64_INTRIN_VCLE_U32,
	ARM64_INTRIN_VCLEQ_U32,
	ARM64_INTRIN_VCLE_F32,
	ARM64_INTRIN_VCLEQ_F32,
	ARM64_INTRIN_VCLE_S64,
	ARM64_INTRIN_VCLEQ_S64,
	ARM64_INTRIN_VCLE_U64,
	ARM64_INTRIN_VCLEQ_U64,
	ARM64_INTRIN_VCLE_F64,
	ARM64_INTRIN_VCLEQ_F64,
	ARM64_INTRIN_VCLED_S64,
	ARM64_INTRIN_VCLED_U64,
	ARM64_INTRIN_VCLES_F32,
	ARM64_INTRIN_VCLED_F64,
	ARM64_INTRIN_VCLEZ_S8,
	ARM64_INTRIN_VCLEZQ_S8,
	ARM64_INTRIN_VCLEZ_S16,
	ARM64_INTRIN_VCLEZQ_S16,
	ARM64_INTRIN_VCLEZ_S32,
	ARM64_INTRIN_VCLEZQ_S32,
	ARM64_INTRIN_VCLEZ_S64,
	ARM64_INTRIN_VCLEZQ_S64,
	ARM64_INTRIN_VCLEZ_F32,
	ARM64_INTRIN_VCLEZQ_F32,
	ARM64_INTRIN_VCLEZ_F64,
	ARM64_INTRIN_VCLEZQ_F64,
	ARM64_INTRIN_VCLEZD_S64,
	ARM64_INTRIN_VCLEZS_F32,
	ARM64_INTRIN_VCLEZD_F64,
	ARM64_INTRIN_VCGT_S8,
	ARM64_INTRIN_VCGTQ_S8,
	ARM64_INTRIN_VCGT_S16,
	ARM64_INTRIN_VCGTQ_S16,
	ARM64_INTRIN_VCGT_S32,
	ARM64_INTRIN_VCGTQ_S32,
	ARM64_INTRIN_VCGT_U8,
	ARM64_INTRIN_VCGTQ_U8,
	ARM64_INTRIN_VCGT_U16,
	ARM64_INTRIN_VCGTQ_U16,
	ARM64_INTRIN_VCGT_U32,
	ARM64_INTRIN_VCGTQ_U32,
	ARM64_INTRIN_VCGT_F32,
	ARM64_INTRIN_VCGTQ_F32,
	ARM64_INTRIN_VCGT_S64,
	ARM64_INTRIN_VCGTQ_S64,
	ARM64_INTRIN_VCGT_U64,
	ARM64_INTRIN_VCGTQ_U64,
	ARM64_INTRIN_VCGT_F64,
	ARM64_INTRIN_VCGTQ_F64,
	ARM64_INTRIN_VCGTD_S64,
	ARM64_INTRIN_VCGTD_U64,
	ARM64_INTRIN_VCGTS_F32,
	ARM64_INTRIN_VCGTD_F64,
	ARM64_INTRIN_VCGTZ_S8,
	ARM64_INTRIN_VCGTZQ_S8,
	ARM64_INTRIN_VCGTZ_S16,
	ARM64_INTRIN_VCGTZQ_S16,
	ARM64_INTRIN_VCGTZ_S32,
	ARM64_INTRIN_VCGTZQ_S32,
	ARM64_INTRIN_VCGTZ_S64,
	ARM64_INTRIN_VCGTZQ_S64,
	ARM64_INTRIN_VCGTZ_F32,
	ARM64_INTRIN_VCGTZQ_F32,
	ARM64_INTRIN_VCGTZ_F64,
	ARM64_INTRIN_VCGTZQ_F64,
	ARM64_INTRIN_VCGTZD_S64,
	ARM64_INTRIN_VCGTZS_F32,
	ARM64_INTRIN_VCGTZD_F64,
	ARM64_INTRIN_VCLT_S8,
	ARM64_INTRIN_VCLTQ_S8,
	ARM64_INTRIN_VCLT_S16,
	ARM64_INTRIN_VCLTQ_S16,
	ARM64_INTRIN_VCLT_S32,
	ARM64_INTRIN_VCLTQ_S32,
	ARM64_INTRIN_VCLT_U8,
	ARM64_INTRIN_VCLTQ_U8,
	ARM64_INTRIN_VCLT_U16,
	ARM64_INTRIN_VCLTQ_U16,
	ARM64_INTRIN_VCLT_U32,
	ARM64_INTRIN_VCLTQ_U32,
	ARM64_INTRIN_VCLT_F32,
	ARM64_INTRIN_VCLTQ_F32,
	ARM64_INTRIN_VCLT_S64,
	ARM64_INTRIN_VCLTQ_S64,
	ARM64_INTRIN_VCLT_U64,
	ARM64_INTRIN_VCLTQ_U64,
	ARM64_INTRIN_VCLT_F64,
	ARM64_INTRIN_VCLTQ_F64,
	ARM64_INTRIN_VCLTD_S64,
	ARM64_INTRIN_VCLTD_U64,
	ARM64_INTRIN_VCLTS_F32,
	ARM64_INTRIN_VCLTD_F64,
	ARM64_INTRIN_VCLTZ_S8,
	ARM64_INTRIN_VCLTZQ_S8,
	ARM64_INTRIN_VCLTZ_S16,
	ARM64_INTRIN_VCLTZQ_S16,
	ARM64_INTRIN_VCLTZ_S32,
	ARM64_INTRIN_VCLTZQ_S32,
	ARM64_INTRIN_VCLTZ_S64,
	ARM64_INTRIN_VCLTZQ_S64,
	ARM64_INTRIN_VCLTZ_F32,
	ARM64_INTRIN_VCLTZQ_F32,
	ARM64_INTRIN_VCLTZ_F64,
	ARM64_INTRIN_VCLTZQ_F64,
	ARM64_INTRIN_VCLTZD_S64,
	ARM64_INTRIN_VCLTZS_F32,
	ARM64_INTRIN_VCLTZD_F64,
	ARM64_INTRIN_VCAGE_F32,
	ARM64_INTRIN_VCAGEQ_F32,
	ARM64_INTRIN_VCAGE_F64,
	ARM64_INTRIN_VCAGEQ_F64,
	ARM64_INTRIN_VCAGES_F32,
	ARM64_INTRIN_VCAGED_F64,
	ARM64_INTRIN_VCALE_F32,
	ARM64_INTRIN_VCALEQ_F32,
	ARM64_INTRIN_VCALE_F64,
	ARM64_INTRIN_VCALEQ_F64,
	ARM64_INTRIN_VCALES_F32,
	ARM64_INTRIN_VCALED_F64,
	ARM64_INTRIN_VCAGT_F32,
	ARM64_INTRIN_VCAGTQ_F32,
	ARM64_INTRIN_VCAGT_F64,
	ARM64_INTRIN_VCAGTQ_F64,
	ARM64_INTRIN_VCAGTS_F32,
	ARM64_INTRIN_VCAGTD_F64,
	ARM64_INTRIN_VCALT_F32,
	ARM64_INTRIN_VCALTQ_F32,
	ARM64_INTRIN_VCALT_F64,
	ARM64_INTRIN_VCALTQ_F64,
	ARM64_INTRIN_VCALTS_F32,
	ARM64_INTRIN_VCALTD_F64,
	ARM64_INTRIN_VTST_S8,
	ARM64_INTRIN_VTSTQ_S8,
	ARM64_INTRIN_VTST_S16,
	ARM64_INTRIN_VTSTQ_S16,
	ARM64_INTRIN_VTST_S32,
	ARM64_INTRIN_VTSTQ_S32,
	ARM64_INTRIN_VTST_U8,
	ARM64_INTRIN_VTSTQ_U8,
	ARM64_INTRIN_VTST_U16,
	ARM64_INTRIN_VTSTQ_U16,
	ARM64_INTRIN_VTST_U32,
	ARM64_INTRIN_VTSTQ_U32,
	ARM64_INTRIN_VTST_P8,
	ARM64_INTRIN_VTSTQ_P8,
	ARM64_INTRIN_VTST_S64,
	ARM64_INTRIN_VTSTQ_S64,
	ARM64_INTRIN_VTST_U64,
	ARM64_INTRIN_VTSTQ_U64,
	ARM64_INTRIN_VTST_P64,
	ARM64_INTRIN_VTSTQ_P64,
	ARM64_INTRIN_VTSTD_S64,
	ARM64_INTRIN_VTSTD_U64,
	ARM64_INTRIN_VABD_S8,
	ARM64_INTRIN_VABDQ_S8,
	ARM64_INTRIN_VABD_S16,
	ARM64_INTRIN_VABDQ_S16,
	ARM64_INTRIN_VABD_S32,
	ARM64_INTRIN_VABDQ_S32,
	ARM64_INTRIN_VABD_U8,
	ARM64_INTRIN_VABDQ_U8,
	ARM64_INTRIN_VABD_U16,
	ARM64_INTRIN_VABDQ_U16,
	ARM64_INTRIN_VABD_U32,
	ARM64_INTRIN_VABDQ_U32,
	ARM64_INTRIN_VABD_F32,
	ARM64_INTRIN_VABDQ_F32,
	ARM64_INTRIN_VABD_F64,
	ARM64_INTRIN_VABDQ_F64,
	ARM64_INTRIN_VABDS_F32,
	ARM64_INTRIN_VABDD_F64,
	ARM64_INTRIN_VABDL_S8,
	ARM64_INTRIN_VABDL_S16,
	ARM64_INTRIN_VABDL_S32,
	ARM64_INTRIN_VABDL_U8,
	ARM64_INTRIN_VABDL_U16,
	ARM64_INTRIN_VABDL_U32,
	ARM64_INTRIN_VABDL_HIGH_S8,
	ARM64_INTRIN_VABDL_HIGH_S16,
	ARM64_INTRIN_VABDL_HIGH_S32,
	ARM64_INTRIN_VABDL_HIGH_U8,
	ARM64_INTRIN_VABDL_HIGH_U16,
	ARM64_INTRIN_VABDL_HIGH_U32,
	ARM64_INTRIN_VABA_S8,
	ARM64_INTRIN_VABAQ_S8,
	ARM64_INTRIN_VABA_S16,
	ARM64_INTRIN_VABAQ_S16,
	ARM64_INTRIN_VABA_S32,
	ARM64_INTRIN_VABAQ_S32,
	ARM64_INTRIN_VABA_U8,
	ARM64_INTRIN_VABAQ_U8,
	ARM64_INTRIN_VABA_U16,
	ARM64_INTRIN_VABAQ_U16,
	ARM64_INTRIN_VABA_U32,
	ARM64_INTRIN_VABAQ_U32,
	ARM64_INTRIN_VABAL_S8,
	ARM64_INTRIN_VABAL_S16,
	ARM64_INTRIN_VABAL_S32,
	ARM64_INTRIN_VABAL_U8,
	ARM64_INTRIN_VABAL_U16,
	ARM64_INTRIN_VABAL_U32,
	ARM64_INTRIN_VABAL_HIGH_S8,
	ARM64_INTRIN_VABAL_HIGH_S16,
	ARM64_INTRIN_VABAL_HIGH_S32,
	ARM64_INTRIN_VABAL_HIGH_U8,
	ARM64_INTRIN_VABAL_HIGH_U16,
	ARM64_INTRIN_VABAL_HIGH_U32,
	ARM64_INTRIN_VMAX_S8,
	ARM64_INTRIN_VMAXQ_S8,
	ARM64_INTRIN_VMAX_S16,
	ARM64_INTRIN_VMAXQ_S16,
	ARM64_INTRIN_VMAX_S32,
	ARM64_INTRIN_VMAXQ_S32,
	ARM64_INTRIN_VMAX_U8,
	ARM64_INTRIN_VMAXQ_U8,
	ARM64_INTRIN_VMAX_U16,
	ARM64_INTRIN_VMAXQ_U16,
	ARM64_INTRIN_VMAX_U32,
	ARM64_INTRIN_VMAXQ_U32,
	ARM64_INTRIN_VMAX_F32,
	ARM64_INTRIN_VMAXQ_F32,
	ARM64_INTRIN_VMAX_F64,
	ARM64_INTRIN_VMAXQ_F64,
	ARM64_INTRIN_VMIN_S8,
	ARM64_INTRIN_VMINQ_S8,
	ARM64_INTRIN_VMIN_S16,
	ARM64_INTRIN_VMINQ_S16,
	ARM64_INTRIN_VMIN_S32,
	ARM64_INTRIN_VMINQ_S32,
	ARM64_INTRIN_VMIN_U8,
	ARM64_INTRIN_VMINQ_U8,
	ARM64_INTRIN_VMIN_U16,
	ARM64_INTRIN_VMINQ_U16,
	ARM64_INTRIN_VMIN_U32,
	ARM64_INTRIN_VMINQ_U32,
	ARM64_INTRIN_VMIN_F32,
	ARM64_INTRIN_VMINQ_F32,
	ARM64_INTRIN_VMIN_F64,
	ARM64_INTRIN_VMINQ_F64,
	ARM64_INTRIN_VMAXNM_F32,
	ARM64_INTRIN_VMAXNMQ_F32,
	ARM64_INTRIN_VMAXNM_F64,
	ARM64_INTRIN_VMAXNMQ_F64,
	ARM64_INTRIN_VMINNM_F32,
	ARM64_INTRIN_VMINNMQ_F32,
	ARM64_INTRIN_VMINNM_F64,
	ARM64_INTRIN_VMINNMQ_F64,
	ARM64_INTRIN_VSHL_S8,
	ARM64_INTRIN_VSHLQ_S8,
	ARM64_INTRIN_VSHL_S16,
	ARM64_INTRIN_VSHLQ_S16,
	ARM64_INTRIN_VSHL_S32,
	ARM64_INTRIN_VSHLQ_S32,
	ARM64_INTRIN_VSHL_S64,
	ARM64_INTRIN_VSHLQ_S64,
	ARM64_INTRIN_VSHL_U8,
	ARM64_INTRIN_VSHLQ_U8,
	ARM64_INTRIN_VSHL_U16,
	ARM64_INTRIN_VSHLQ_U16,
	ARM64_INTRIN_VSHL_U32,
	ARM64_INTRIN_VSHLQ_U32,
	ARM64_INTRIN_VSHL_U64,
	ARM64_INTRIN_VSHLQ_U64,
	ARM64_INTRIN_VSHLD_S64,
	ARM64_INTRIN_VSHLD_U64,
	ARM64_INTRIN_VQSHL_S8,
	ARM64_INTRIN_VQSHLQ_S8,
	ARM64_INTRIN_VQSHL_S16,
	ARM64_INTRIN_VQSHLQ_S16,
	ARM64_INTRIN_VQSHL_S32,
	ARM64_INTRIN_VQSHLQ_S32,
	ARM64_INTRIN_VQSHL_S64,
	ARM64_INTRIN_VQSHLQ_S64,
	ARM64_INTRIN_VQSHL_U8,
	ARM64_INTRIN_VQSHLQ_U8,
	ARM64_INTRIN_VQSHL_U16,
	ARM64_INTRIN_VQSHLQ_U16,
	ARM64_INTRIN_VQSHL_U32,
	ARM64_INTRIN_VQSHLQ_U32,
	ARM64_INTRIN_VQSHL_U64,
	ARM64_INTRIN_VQSHLQ_U64,
	ARM64_INTRIN_VQSHLB_S8,
	ARM64_INTRIN_VQSHLH_S16,
	ARM64_INTRIN_VQSHLS_S32,
	ARM64_INTRIN_VQSHLD_S64,
	ARM64_INTRIN_VQSHLB_U8,
	ARM64_INTRIN_VQSHLH_U16,
	ARM64_INTRIN_VQSHLS_U32,
	ARM64_INTRIN_VQSHLD_U64,
	ARM64_INTRIN_VRSHL_S8,
	ARM64_INTRIN_VRSHLQ_S8,
	ARM64_INTRIN_VRSHL_S16,
	ARM64_INTRIN_VRSHLQ_S16,
	ARM64_INTRIN_VRSHL_S32,
	ARM64_INTRIN_VRSHLQ_S32,
	ARM64_INTRIN_VRSHL_S64,
	ARM64_INTRIN_VRSHLQ_S64,
	ARM64_INTRIN_VRSHL_U8,
	ARM64_INTRIN_VRSHLQ_U8,
	ARM64_INTRIN_VRSHL_U16,
	ARM64_INTRIN_VRSHLQ_U16,
	ARM64_INTRIN_VRSHL_U32,
	ARM64_INTRIN_VRSHLQ_U32,
	ARM64_INTRIN_VRSHL_U64,
	ARM64_INTRIN_VRSHLQ_U64,
	ARM64_INTRIN_VRSHLD_S64,
	ARM64_INTRIN_VRSHLD_U64,
	ARM64_INTRIN_VQRSHL_S8,
	ARM64_INTRIN_VQRSHLQ_S8,
	ARM64_INTRIN_VQRSHL_S16,
	ARM64_INTRIN_VQRSHLQ_S16,
	ARM64_INTRIN_VQRSHL_S32,
	ARM64_INTRIN_VQRSHLQ_S32,
	ARM64_INTRIN_VQRSHL_S64,
	ARM64_INTRIN_VQRSHLQ_S64,
	ARM64_INTRIN_VQRSHL_U8,
	ARM64_INTRIN_VQRSHLQ_U8,
	ARM64_INTRIN_VQRSHL_U16,
	ARM64_INTRIN_VQRSHLQ_U16,
	ARM64_INTRIN_VQRSHL_U32,
	ARM64_INTRIN_VQRSHLQ_U32,
	ARM64_INTRIN_VQRSHL_U64,
	ARM64_INTRIN_VQRSHLQ_U64,
	ARM64_INTRIN_VQRSHLB_S8,
	ARM64_INTRIN_VQRSHLH_S16,
	ARM64_INTRIN_VQRSHLS_S32,
	ARM64_INTRIN_VQRSHLD_S64,
	ARM64_INTRIN_VQRSHLB_U8,
	ARM64_INTRIN_VQRSHLH_U16,
	ARM64_INTRIN_VQRSHLS_U32,
	ARM64_INTRIN_VQRSHLD_U64,
	ARM64_INTRIN_VSHR_N_S8,
	ARM64_INTRIN_VSHRQ_N_S8,
	ARM64_INTRIN_VSHR_N_S16,
	ARM64_INTRIN_VSHRQ_N_S16,
	ARM64_INTRIN_VSHR_N_S32,
	ARM64_INTRIN_VSHRQ_N_S32,
	ARM64_INTRIN_VSHR_N_S64,
	ARM64_INTRIN_VSHRQ_N_S64,
	ARM64_INTRIN_VSHR_N_U8,
	ARM64_INTRIN_VSHRQ_N_U8,
	ARM64_INTRIN_VSHR_N_U16,
	ARM64_INTRIN_VSHRQ_N_U16,
	ARM64_INTRIN_VSHR_N_U32,
	ARM64_INTRIN_VSHRQ_N_U32,
	ARM64_INTRIN_VSHR_N_U64,
	ARM64_INTRIN_VSHRQ_N_U64,
	ARM64_INTRIN_VSHRD_N_S64,
	ARM64_INTRIN_VSHRD_N_U64,
	ARM64_INTRIN_VSHL_N_S8,
	ARM64_INTRIN_VSHLQ_N_S8,
	ARM64_INTRIN_VSHL_N_S16,
	ARM64_INTRIN_VSHLQ_N_S16,
	ARM64_INTRIN_VSHL_N_S32,
	ARM64_INTRIN_VSHLQ_N_S32,
	ARM64_INTRIN_VSHL_N_S64,
	ARM64_INTRIN_VSHLQ_N_S64,
	ARM64_INTRIN_VSHL_N_U8,
	ARM64_INTRIN_VSHLQ_N_U8,
	ARM64_INTRIN_VSHL_N_U16,
	ARM64_INTRIN_VSHLQ_N_U16,
	ARM64_INTRIN_VSHL_N_U32,
	ARM64_INTRIN_VSHLQ_N_U32,
	ARM64_INTRIN_VSHL_N_U64,
	ARM64_INTRIN_VSHLQ_N_U64,
	ARM64_INTRIN_VSHLD_N_S64,
	ARM64_INTRIN_VSHLD_N_U64,
	ARM64_INTRIN_VRSHR_N_S8,
	ARM64_INTRIN_VRSHRQ_N_S8,
	ARM64_INTRIN_VRSHR_N_S16,
	ARM64_INTRIN_VRSHRQ_N_S16,
	ARM64_INTRIN_VRSHR_N_S32,
	ARM64_INTRIN_VRSHRQ_N_S32,
	ARM64_INTRIN_VRSHR_N_S64,
	ARM64_INTRIN_VRSHRQ_N_S64,
	ARM64_INTRIN_VRSHR_N_U8,
	ARM64_INTRIN_VRSHRQ_N_U8,
	ARM64_INTRIN_VRSHR_N_U16,
	ARM64_INTRIN_VRSHRQ_N_U16,
	ARM64_INTRIN_VRSHR_N_U32,
	ARM64_INTRIN_VRSHRQ_N_U32,
	ARM64_INTRIN_VRSHR_N_U64,
	ARM64_INTRIN_VRSHRQ_N_U64,
	ARM64_INTRIN_VRSHRD_N_S64,
	ARM64_INTRIN_VRSHRD_N_U64,
	ARM64_INTRIN_VSRA_N_S8,
	ARM64_INTRIN_VSRAQ_N_S8,
	ARM64_INTRIN_VSRA_N_S16,
	ARM64_INTRIN_VSRAQ_N_S16,
	ARM64_INTRIN_VSRA_N_S32,
	ARM64_INTRIN_VSRAQ_N_S32,
	ARM64_INTRIN_VSRA_N_S64,
	ARM64_INTRIN_VSRAQ_N_S64,
	ARM64_INTRIN_VSRA_N_U8,
	ARM64_INTRIN_VSRAQ_N_U8,
	ARM64_INTRIN_VSRA_N_U16,
	ARM64_INTRIN_VSRAQ_N_U16,
	ARM64_INTRIN_VSRA_N_U32,
	ARM64_INTRIN_VSRAQ_N_U32,
	ARM64_INTRIN_VSRA_N_U64,
	ARM64_INTRIN_VSRAQ_N_U64,
	ARM64_INTRIN_VSRAD_N_S64,
	ARM64_INTRIN_VSRAD_N_U64,
	ARM64_INTRIN_VRSRA_N_S8,
	ARM64_INTRIN_VRSRAQ_N_S8,
	ARM64_INTRIN_VRSRA_N_S16,
	ARM64_INTRIN_VRSRAQ_N_S16,
	ARM64_INTRIN_VRSRA_N_S32,
	ARM64_INTRIN_VRSRAQ_N_S32,
	ARM64_INTRIN_VRSRA_N_S64,
	ARM64_INTRIN_VRSRAQ_N_S64,
	ARM64_INTRIN_VRSRA_N_U8,
	ARM64_INTRIN_VRSRAQ_N_U8,
	ARM64_INTRIN_VRSRA_N_U16,
	ARM64_INTRIN_VRSRAQ_N_U16,
	ARM64_INTRIN_VRSRA_N_U32,
	ARM64_INTRIN_VRSRAQ_N_U32,
	ARM64_INTRIN_VRSRA_N_U64,
	ARM64_INTRIN_VRSRAQ_N_U64,
	ARM64_INTRIN_VRSRAD_N_S64,
	ARM64_INTRIN_VRSRAD_N_U64,
	ARM64_INTRIN_VQSHL_N_S8,
	ARM64_INTRIN_VQSHLQ_N_S8,
	ARM64_INTRIN_VQSHL_N_S16,
	ARM64_INTRIN_VQSHLQ_N_S16,
	ARM64_INTRIN_VQSHL_N_S32,
	ARM64_INTRIN_VQSHLQ_N_S32,
	ARM64_INTRIN_VQSHL_N_S64,
	ARM64_INTRIN_VQSHLQ_N_S64,
	ARM64_INTRIN_VQSHL_N_U8,
	ARM64_INTRIN_VQSHLQ_N_U8,
	ARM64_INTRIN_VQSHL_N_U16,
	ARM64_INTRIN_VQSHLQ_N_U16,
	ARM64_INTRIN_VQSHL_N_U32,
	ARM64_INTRIN_VQSHLQ_N_U32,
	ARM64_INTRIN_VQSHL_N_U64,
	ARM64_INTRIN_VQSHLQ_N_U64,
	ARM64_INTRIN_VQSHLB_N_S8,
	ARM64_INTRIN_VQSHLH_N_S16,
	ARM64_INTRIN_VQSHLS_N_S32,
	ARM64_INTRIN_VQSHLD_N_S64,
	ARM64_INTRIN_VQSHLB_N_U8,
	ARM64_INTRIN_VQSHLH_N_U16,
	ARM64_INTRIN_VQSHLS_N_U32,
	ARM64_INTRIN_VQSHLD_N_U64,
	ARM64_INTRIN_VQSHLU_N_S8,
	ARM64_INTRIN_VQSHLUQ_N_S8,
	ARM64_INTRIN_VQSHLU_N_S16,
	ARM64_INTRIN_VQSHLUQ_N_S16,
	ARM64_INTRIN_VQSHLU_N_S32,
	ARM64_INTRIN_VQSHLUQ_N_S32,
	ARM64_INTRIN_VQSHLU_N_S64,
	ARM64_INTRIN_VQSHLUQ_N_S64,
	ARM64_INTRIN_VQSHLUB_N_S8,
	ARM64_INTRIN_VQSHLUH_N_S16,
	ARM64_INTRIN_VQSHLUS_N_S32,
	ARM64_INTRIN_VQSHLUD_N_S64,
	ARM64_INTRIN_VSHRN_N_S16,
	ARM64_INTRIN_VSHRN_N_S32,
	ARM64_INTRIN_VSHRN_N_S64,
	ARM64_INTRIN_VSHRN_N_U16,
	ARM64_INTRIN_VSHRN_N_U32,
	ARM64_INTRIN_VSHRN_N_U64,
	ARM64_INTRIN_VSHRN_HIGH_N_S16,
	ARM64_INTRIN_VSHRN_HIGH_N_S32,
	ARM64_INTRIN_VSHRN_HIGH_N_S64,
	ARM64_INTRIN_VSHRN_HIGH_N_U16,
	ARM64_INTRIN_VSHRN_HIGH_N_U32,
	ARM64_INTRIN_VSHRN_HIGH_N_U64,
	ARM64_INTRIN_VQSHRUN_N_S16,
	ARM64_INTRIN_VQSHRUN_N_S32,
	ARM64_INTRIN_VQSHRUN_N_S64,
	ARM64_INTRIN_VQSHRUNH_N_S16,
	ARM64_INTRIN_VQSHRUNS_N_S32,
	ARM64_INTRIN_VQSHRUND_N_S64,
	ARM64_INTRIN_VQSHRUN_HIGH_N_S16,
	ARM64_INTRIN_VQSHRUN_HIGH_N_S32,
	ARM64_INTRIN_VQSHRUN_HIGH_N_S64,
	ARM64_INTRIN_VQRSHRUN_N_S16,
	ARM64_INTRIN_VQRSHRUN_N_S32,
	ARM64_INTRIN_VQRSHRUN_N_S64,
	ARM64_INTRIN_VQRSHRUNH_N_S16,
	ARM64_INTRIN_VQRSHRUNS_N_S32,
	ARM64_INTRIN_VQRSHRUND_N_S64,
	ARM64_INTRIN_VQRSHRUN_HIGH_N_S16,
	ARM64_INTRIN_VQRSHRUN_HIGH_N_S32,
	ARM64_INTRIN_VQRSHRUN_HIGH_N_S64,
	ARM64_INTRIN_VQSHRN_N_S16,
	ARM64_INTRIN_VQSHRN_N_S32,
	ARM64_INTRIN_VQSHRN_N_S64,
	ARM64_INTRIN_VQSHRN_N_U16,
	ARM64_INTRIN_VQSHRN_N_U32,
	ARM64_INTRIN_VQSHRN_N_U64,
	ARM64_INTRIN_VQSHRNH_N_S16,
	ARM64_INTRIN_VQSHRNS_N_S32,
	ARM64_INTRIN_VQSHRND_N_S64,
	ARM64_INTRIN_VQSHRNH_N_U16,
	ARM64_INTRIN_VQSHRNS_N_U32,
	ARM64_INTRIN_VQSHRND_N_U64,
	ARM64_INTRIN_VQSHRN_HIGH_N_S16,
	ARM64_INTRIN_VQSHRN_HIGH_N_S32,
	ARM64_INTRIN_VQSHRN_HIGH_N_S64,
	ARM64_INTRIN_VQSHRN_HIGH_N_U16,
	ARM64_INTRIN_VQSHRN_HIGH_N_U32,
	ARM64_INTRIN_VQSHRN_HIGH_N_U64,
	ARM64_INTRIN_VRSHRN_N_S16,
	ARM64_INTRIN_VRSHRN_N_S32,
	ARM64_INTRIN_VRSHRN_N_S64,
	ARM64_INTRIN_VRSHRN_N_U16,
	ARM64_INTRIN_VRSHRN_N_U32,
	ARM64_INTRIN_VRSHRN_N_U64,
	ARM64_INTRIN_VRSHRN_HIGH_N_S16,
	ARM64_INTRIN_VRSHRN_HIGH_N_S32,
	ARM64_INTRIN_VRSHRN_HIGH_N_S64,
	ARM64_INTRIN_VRSHRN_HIGH_N_U16,
	ARM64_INTRIN_VRSHRN_HIGH_N_U32,
	ARM64_INTRIN_VRSHRN_HIGH_N_U64,
	ARM64_INTRIN_VQRSHRN_N_S16,
	ARM64_INTRIN_VQRSHRN_N_S32,
	ARM64_INTRIN_VQRSHRN_N_S64,
	ARM64_INTRIN_VQRSHRN_N_U16,
	ARM64_INTRIN_VQRSHRN_N_U32,
	ARM64_INTRIN_VQRSHRN_N_U64,
	ARM64_INTRIN_VQRSHRNH_N_S16,
	ARM64_INTRIN_VQRSHRNS_N_S32,
	ARM64_INTRIN_VQRSHRND_N_S64,
	ARM64_INTRIN_VQRSHRNH_N_U16,
	ARM64_INTRIN_VQRSHRNS_N_U32,
	ARM64_INTRIN_VQRSHRND_N_U64,
	ARM64_INTRIN_VQRSHRN_HIGH_N_S16,
	ARM64_INTRIN_VQRSHRN_HIGH_N_S32,
	ARM64_INTRIN_VQRSHRN_HIGH_N_S64,
	ARM64_INTRIN_VQRSHRN_HIGH_N_U16,
	ARM64_INTRIN_VQRSHRN_HIGH_N_U32,
	ARM64_INTRIN_VQRSHRN_HIGH_N_U64,
	ARM64_INTRIN_VSHLL_N_S8,
	ARM64_INTRIN_VSHLL_N_S16,
	ARM64_INTRIN_VSHLL_N_S32,
	ARM64_INTRIN_VSHLL_N_U8,
	ARM64_INTRIN_VSHLL_N_U16,
	ARM64_INTRIN_VSHLL_N_U32,
	ARM64_INTRIN_VSHLL_HIGH_N_S8,
	ARM64_INTRIN_VSHLL_HIGH_N_S16,
	ARM64_INTRIN_VSHLL_HIGH_N_S32,
	ARM64_INTRIN_VSHLL_HIGH_N_U8,
	ARM64_INTRIN_VSHLL_HIGH_N_U16,
	ARM64_INTRIN_VSHLL_HIGH_N_U32,
	ARM64_INTRIN_VSRI_N_S8,
	ARM64_INTRIN_VSRIQ_N_S8,
	ARM64_INTRIN_VSRI_N_S16,
	ARM64_INTRIN_VSRIQ_N_S16,
	ARM64_INTRIN_VSRI_N_S32,
	ARM64_INTRIN_VSRIQ_N_S32,
	ARM64_INTRIN_VSRI_N_S64,
	ARM64_INTRIN_VSRIQ_N_S64,
	ARM64_INTRIN_VSRI_N_U8,
	ARM64_INTRIN_VSRIQ_N_U8,
	ARM64_INTRIN_VSRI_N_U16,
	ARM64_INTRIN_VSRIQ_N_U16,
	ARM64_INTRIN_VSRI_N_U32,
	ARM64_INTRIN_VSRIQ_N_U32,
	ARM64_INTRIN_VSRI_N_U64,
	ARM64_INTRIN_VSRIQ_N_U64,
	ARM64_INTRIN_VSRI_N_P64,
	ARM64_INTRIN_VSRIQ_N_P64,
	ARM64_INTRIN_VSRI_N_P8,
	ARM64_INTRIN_VSRIQ_N_P8,
	ARM64_INTRIN_VSRI_N_P16,
	ARM64_INTRIN_VSRIQ_N_P16,
	ARM64_INTRIN_VSRID_N_S64,
	ARM64_INTRIN_VSRID_N_U64,
	ARM64_INTRIN_VSLI_N_S8,
	ARM64_INTRIN_VSLIQ_N_S8,
	ARM64_INTRIN_VSLI_N_S16,
	ARM64_INTRIN_VSLIQ_N_S16,
	ARM64_INTRIN_VSLI_N_S32,
	ARM64_INTRIN_VSLIQ_N_S32,
	ARM64_INTRIN_VSLI_N_S64,
	ARM64_INTRIN_VSLIQ_N_S64,
	ARM64_INTRIN_VSLI_N_U8,
	ARM64_INTRIN_VSLIQ_N_U8,
	ARM64_INTRIN_VSLI_N_U16,
	ARM64_INTRIN_VSLIQ_N_U16,
	ARM64_INTRIN_VSLI_N_U32,
	ARM64_INTRIN_VSLIQ_N_U32,
	ARM64_INTRIN_VSLI_N_U64,
	ARM64_INTRIN_VSLIQ_N_U64,
	ARM64_INTRIN_VSLI_N_P64,
	ARM64_INTRIN_VSLIQ_N_P64,
	ARM64_INTRIN_VSLI_N_P8,
	ARM64_INTRIN_VSLIQ_N_P8,
	ARM64_INTRIN_VSLI_N_P16,
	ARM64_INTRIN_VSLIQ_N_P16,
	ARM64_INTRIN_VSLID_N_S64,
	ARM64_INTRIN_VSLID_N_U64,
	ARM64_INTRIN_VCVT_S32_F32,
	ARM64_INTRIN_VCVTQ_S32_F32,
	ARM64_INTRIN_VCVT_U32_F32,
	ARM64_INTRIN_VCVTQ_U32_F32,
	ARM64_INTRIN_VCVTN_S32_F32,
	ARM64_INTRIN_VCVTNQ_S32_F32,
	ARM64_INTRIN_VCVTN_U32_F32,
	ARM64_INTRIN_VCVTNQ_U32_F32,
	ARM64_INTRIN_VCVTM_S32_F32,
	ARM64_INTRIN_VCVTMQ_S32_F32,
	ARM64_INTRIN_VCVTM_U32_F32,
	ARM64_INTRIN_VCVTMQ_U32_F32,
	ARM64_INTRIN_VCVTP_S32_F32,
	ARM64_INTRIN_VCVTPQ_S32_F32,
	ARM64_INTRIN_VCVTP_U32_F32,
	ARM64_INTRIN_VCVTPQ_U32_F32,
	ARM64_INTRIN_VCVTA_S32_F32,
	ARM64_INTRIN_VCVTAQ_S32_F32,
	ARM64_INTRIN_VCVTA_U32_F32,
	ARM64_INTRIN_VCVTAQ_U32_F32,
	ARM64_INTRIN_VCVTS_S32_F32,
	ARM64_INTRIN_VCVTS_U32_F32,
	ARM64_INTRIN_VCVTNS_S32_F32,
	ARM64_INTRIN_VCVTNS_U32_F32,
	ARM64_INTRIN_VCVTMS_S32_F32,
	ARM64_INTRIN_VCVTMS_U32_F32,
	ARM64_INTRIN_VCVTPS_S32_F32,
	ARM64_INTRIN_VCVTPS_U32_F32,
	ARM64_INTRIN_VCVTAS_S32_F32,
	ARM64_INTRIN_VCVTAS_U32_F32,
	ARM64_INTRIN_VCVT_S64_F64,
	ARM64_INTRIN_VCVTQ_S64_F64,
	ARM64_INTRIN_VCVT_U64_F64,
	ARM64_INTRIN_VCVTQ_U64_F64,
	ARM64_INTRIN_VCVTN_S64_F64,
	ARM64_INTRIN_VCVTNQ_S64_F64,
	ARM64_INTRIN_VCVTN_U64_F64,
	ARM64_INTRIN_VCVTNQ_U64_F64,
	ARM64_INTRIN_VCVTM_S64_F64,
	ARM64_INTRIN_VCVTMQ_S64_F64,
	ARM64_INTRIN_VCVTM_U64_F64,
	ARM64_INTRIN_VCVTMQ_U64_F64,
	ARM64_INTRIN_VCVTP_S64_F64,
	ARM64_INTRIN_VCVTPQ_S64_F64,
	ARM64_INTRIN_VCVTP_U64_F64,
	ARM64_INTRIN_VCVTPQ_U64_F64,
	ARM64_INTRIN_VCVTA_S64_F64,
	ARM64_INTRIN_VCVTAQ_S64_F64,
	ARM64_INTRIN_VCVTA_U64_F64,
	ARM64_INTRIN_VCVTAQ_U64_F64,
	ARM64_INTRIN_VCVTD_S64_F64,
	ARM64_INTRIN_VCVTD_U64_F64,
	ARM64_INTRIN_VCVTND_S64_F64,
	ARM64_INTRIN_VCVTND_U64_F64,
	ARM64_INTRIN_VCVTMD_S64_F64,
	ARM64_INTRIN_VCVTMD_U64_F64,
	ARM64_INTRIN_VCVTPD_S64_F64,
	ARM64_INTRIN_VCVTPD_U64_F64,
	ARM64_INTRIN_VCVTAD_S64_F64,
	ARM64_INTRIN_VCVTAD_U64_F64,
	ARM64_INTRIN_VCVT_N_S32_F32,
	ARM64_INTRIN_VCVTQ_N_S32_F32,
	ARM64_INTRIN_VCVT_N_U32_F32,
	ARM64_INTRIN_VCVTQ_N_U32_F32,
	ARM64_INTRIN_VCVTS_N_S32_F32,
	ARM64_INTRIN_VCVTS_N_U32_F32,
	ARM64_INTRIN_VCVT_N_S64_F64,
	ARM64_INTRIN_VCVTQ_N_S64_F64,
	ARM64_INTRIN_VCVT_N_U64_F64,

	ARM64_INTRIN_VCVTH_N_F16_U32, // VConVerT to   Half precision, has imm N, to f16 from u32 eg: ucvtf <Hd>, <Wn>, #<fbits>
	ARM64_INTRIN_VCVTH_N_F16_U64, // VConVerT to   Half precision, has imm N, to f16 from u64 eg: ucvtf <Hd>, <Xn>, #<fbits>
	ARM64_INTRIN_VCVTS_N_F32_U32, // VConVerT to Single precision, has imm N, to f32 from u32 eg: ucvtf <Sd>, <Wn>, #<fbits>
	ARM64_INTRIN_VCVTS_N_F32_U64, // VConVerT to Single precision, has imm N, to f32 from u64 eg: ucvtf <Sd>, <Xn>, #<fbits>
	ARM64_INTRIN_VCVTD_N_F64_U32, // VConVerT to Double precision, has imm N, to f64 from u32 eg: ucvtf <Dd>, <Wn>, #<fbits>
	ARM64_INTRIN_VCVTD_N_F64_U64, // VConVerT to Double precision, has imm N, to f64 from u64 eg: ucvtf <Dd>, <Xn>, #<fbits>

	ARM64_INTRIN_VCVT_N_F64_U64, // float64x1_t vcvt_n_f64_u64(uint64x1_t a, const int n)

	ARM64_INTRIN_VCVTD_N_F64_F64, //
	ARM64_INTRIN_VCVTQ_N_U64_F64,
	ARM64_INTRIN_VCVTD_N_S64_F64,
	ARM64_INTRIN_VCVTD_N_U64_F64,

	ARM64_INTRIN_VCVT_F32_S32,
	ARM64_INTRIN_VCVTQ_F32_S32,
	ARM64_INTRIN_VCVT_F32_U32,
	ARM64_INTRIN_VCVTQ_F32_U32,
	ARM64_INTRIN_VCVTS_F32_S32,
	ARM64_INTRIN_VCVTS_F32_U32,
	ARM64_INTRIN_VCVT_F64_S64,
	ARM64_INTRIN_VCVTQ_F64_S64,
	ARM64_INTRIN_VCVT_F64_U64,
	ARM64_INTRIN_VCVT_F64_U32,
	ARM64_INTRIN_VCVT_F32_U64,
	ARM64_INTRIN_VCVTQ_F64_U64,
	ARM64_INTRIN_VCVTD_F64_S64,
	ARM64_INTRIN_VCVTD_F64_U64,
	ARM64_INTRIN_VCVT_N_F32_S32,
	ARM64_INTRIN_VCVTQ_N_F32_S32,
	ARM64_INTRIN_VCVT_N_F32_U32,
	ARM64_INTRIN_VCVTQ_N_F32_U32,
	ARM64_INTRIN_VCVTS_N_F32_S32,
	ARM64_INTRIN_VCVT_N_F64_S64,
	ARM64_INTRIN_VCVTQ_N_F64_S64,
	ARM64_INTRIN_VCVTQ_N_F64_U64,
	ARM64_INTRIN_VCVTD_N_F64_S64,
	ARM64_INTRIN_VCVT_F16_F32,
	ARM64_INTRIN_VCVT_HIGH_F16_F32,
	ARM64_INTRIN_VCVT_F32_F64,
	ARM64_INTRIN_VCVT_HIGH_F32_F64,
	ARM64_INTRIN_VCVT_F32_F16,
	ARM64_INTRIN_VCVT_HIGH_F32_F16,
	ARM64_INTRIN_VCVT_F64_F32,
	ARM64_INTRIN_VCVT_HIGH_F64_F32,
	ARM64_INTRIN_VCVTX_F32_F64,
	ARM64_INTRIN_VCVTXD_F32_F64,
	ARM64_INTRIN_VCVTX_HIGH_F32_F64,
	ARM64_INTRIN_VRND_F32,
	ARM64_INTRIN_VRNDQ_F32,
	ARM64_INTRIN_VRND_F64,
	ARM64_INTRIN_VRNDQ_F64,
	ARM64_INTRIN_VRNDN_F32,
	ARM64_INTRIN_VRNDNQ_F32,
	ARM64_INTRIN_VRNDN_F64,
	ARM64_INTRIN_VRNDNQ_F64,
	ARM64_INTRIN_VRNDNS_F32,
	ARM64_INTRIN_VRNDM_F32,
	ARM64_INTRIN_VRNDMQ_F32,
	ARM64_INTRIN_VRNDM_F64,
	ARM64_INTRIN_VRNDMQ_F64,
	ARM64_INTRIN_VRNDP_F32,
	ARM64_INTRIN_VRNDPQ_F32,
	ARM64_INTRIN_VRNDP_F64,
	ARM64_INTRIN_VRNDPQ_F64,
	ARM64_INTRIN_VRNDA_F32,
	ARM64_INTRIN_VRNDAQ_F32,
	ARM64_INTRIN_VRNDA_F64,
	ARM64_INTRIN_VRNDAQ_F64,
	ARM64_INTRIN_VRNDI_F32,
	ARM64_INTRIN_VRNDIQ_F32,
	ARM64_INTRIN_VRNDI_F64,
	ARM64_INTRIN_VRNDIQ_F64,
	ARM64_INTRIN_VRNDX_F32,
	ARM64_INTRIN_VRNDXQ_F32,
	ARM64_INTRIN_VRNDX_F64,
	ARM64_INTRIN_VRNDXQ_F64,
	ARM64_INTRIN_VMOVN_S16,
	ARM64_INTRIN_VMOVN_S32,
	ARM64_INTRIN_VMOVN_S64,
	ARM64_INTRIN_VMOVN_U16,
	ARM64_INTRIN_VMOVN_U32,
	ARM64_INTRIN_VMOVN_U64,
	ARM64_INTRIN_VMOVN_HIGH_S16,
	ARM64_INTRIN_VMOVN_HIGH_S32,
	ARM64_INTRIN_VMOVN_HIGH_S64,
	ARM64_INTRIN_VMOVN_HIGH_U16,
	ARM64_INTRIN_VMOVN_HIGH_U32,
	ARM64_INTRIN_VMOVN_HIGH_U64,
	ARM64_INTRIN_VMOVL_S8,
	ARM64_INTRIN_VMOVL_S16,
	ARM64_INTRIN_VMOVL_S32,
	ARM64_INTRIN_VMOVL_U8,
	ARM64_INTRIN_VMOVL_U16,
	ARM64_INTRIN_VMOVL_U32,
	ARM64_INTRIN_VMOVL_HIGH_S8,
	ARM64_INTRIN_VMOVL_HIGH_S16,
	ARM64_INTRIN_VMOVL_HIGH_S32,
	ARM64_INTRIN_VMOVL_HIGH_U8,
	ARM64_INTRIN_VMOVL_HIGH_U16,
	ARM64_INTRIN_VMOVL_HIGH_U32,
	ARM64_INTRIN_VQMOVN_S16,
	ARM64_INTRIN_VQMOVN_S32,
	ARM64_INTRIN_VQMOVN_S64,
	ARM64_INTRIN_VQMOVN_U16,
	ARM64_INTRIN_VQMOVN_U32,
	ARM64_INTRIN_VQMOVN_U64,
	ARM64_INTRIN_VQMOVNH_S16,
	ARM64_INTRIN_VQMOVNS_S32,
	ARM64_INTRIN_VQMOVND_S64,
	ARM64_INTRIN_VQMOVNH_U16,
	ARM64_INTRIN_VQMOVNS_U32,
	ARM64_INTRIN_VQMOVND_U64,
	ARM64_INTRIN_VQMOVN_HIGH_S16,
	ARM64_INTRIN_VQMOVN_HIGH_S32,
	ARM64_INTRIN_VQMOVN_HIGH_S64,
	ARM64_INTRIN_VQMOVN_HIGH_U16,
	ARM64_INTRIN_VQMOVN_HIGH_U32,
	ARM64_INTRIN_VQMOVN_HIGH_U64,
	ARM64_INTRIN_VQMOVUN_S16,
	ARM64_INTRIN_VQMOVUN_S32,
	ARM64_INTRIN_VQMOVUN_S64,
	ARM64_INTRIN_VQMOVUNH_S16,
	ARM64_INTRIN_VQMOVUNS_S32,
	ARM64_INTRIN_VQMOVUND_S64,
	ARM64_INTRIN_VQMOVUN_HIGH_S16,
	ARM64_INTRIN_VQMOVUN_HIGH_S32,
	ARM64_INTRIN_VQMOVUN_HIGH_S64,
	ARM64_INTRIN_VMLA_LANE_S16,
	ARM64_INTRIN_VMLAQ_LANE_S16,
	ARM64_INTRIN_VMLA_LANE_S32,
	ARM64_INTRIN_VMLAQ_LANE_S32,
	ARM64_INTRIN_VMLA_LANE_U16,
	ARM64_INTRIN_VMLAQ_LANE_U16,
	ARM64_INTRIN_VMLA_LANE_U32,
	ARM64_INTRIN_VMLAQ_LANE_U32,
	ARM64_INTRIN_VMLA_LANE_F32,
	ARM64_INTRIN_VMLAQ_LANE_F32,
	ARM64_INTRIN_VMLA_LANEQ_S16,
	ARM64_INTRIN_VMLAQ_LANEQ_S16,
	ARM64_INTRIN_VMLA_LANEQ_S32,
	ARM64_INTRIN_VMLAQ_LANEQ_S32,
	ARM64_INTRIN_VMLA_LANEQ_U16,
	ARM64_INTRIN_VMLAQ_LANEQ_U16,
	ARM64_INTRIN_VMLA_LANEQ_U32,
	ARM64_INTRIN_VMLAQ_LANEQ_U32,
	ARM64_INTRIN_VMLA_LANEQ_F32,
	ARM64_INTRIN_VMLAQ_LANEQ_F32,
	ARM64_INTRIN_VMLAL_LANE_S16,
	ARM64_INTRIN_VMLAL_LANE_S32,
	ARM64_INTRIN_VMLAL_LANE_U16,
	ARM64_INTRIN_VMLAL_LANE_U32,
	ARM64_INTRIN_VMLAL_HIGH_LANE_S16,
	ARM64_INTRIN_VMLAL_HIGH_LANE_S32,
	ARM64_INTRIN_VMLAL_HIGH_LANE_U16,
	ARM64_INTRIN_VMLAL_HIGH_LANE_U32,
	ARM64_INTRIN_VMLAL_LANEQ_S16,
	ARM64_INTRIN_VMLAL_LANEQ_S32,
	ARM64_INTRIN_VMLAL_LANEQ_U16,
	ARM64_INTRIN_VMLAL_LANEQ_U32,
	ARM64_INTRIN_VMLAL_HIGH_LANEQ_S16,
	ARM64_INTRIN_VMLAL_HIGH_LANEQ_S32,
	ARM64_INTRIN_VMLAL_HIGH_LANEQ_U16,
	ARM64_INTRIN_VMLAL_HIGH_LANEQ_U32,
	ARM64_INTRIN_VQDMLAL_LANE_S16,
	ARM64_INTRIN_VQDMLAL_LANE_S32,
	ARM64_INTRIN_VQDMLALH_LANE_S16,
	ARM64_INTRIN_VQDMLALS_LANE_S32,
	ARM64_INTRIN_VQDMLAL_HIGH_LANE_S16,
	ARM64_INTRIN_VQDMLAL_HIGH_LANE_S32,
	ARM64_INTRIN_VQDMLAL_LANEQ_S16,
	ARM64_INTRIN_VQDMLAL_LANEQ_S32,
	ARM64_INTRIN_VQDMLALH_LANEQ_S16,
	ARM64_INTRIN_VQDMLALS_LANEQ_S32,
	ARM64_INTRIN_VQDMLAL_HIGH_LANEQ_S16,
	ARM64_INTRIN_VQDMLAL_HIGH_LANEQ_S32,
	ARM64_INTRIN_VMLS_LANE_S16,
	ARM64_INTRIN_VMLSQ_LANE_S16,
	ARM64_INTRIN_VMLS_LANE_S32,
	ARM64_INTRIN_VMLSQ_LANE_S32,
	ARM64_INTRIN_VMLS_LANE_U16,
	ARM64_INTRIN_VMLSQ_LANE_U16,
	ARM64_INTRIN_VMLS_LANE_U32,
	ARM64_INTRIN_VMLSQ_LANE_U32,
	ARM64_INTRIN_VMLS_LANE_F32,
	ARM64_INTRIN_VMLSQ_LANE_F32,
	ARM64_INTRIN_VMLS_LANEQ_S16,
	ARM64_INTRIN_VMLSQ_LANEQ_S16,
	ARM64_INTRIN_VMLS_LANEQ_S32,
	ARM64_INTRIN_VMLSQ_LANEQ_S32,
	ARM64_INTRIN_VMLS_LANEQ_U16,
	ARM64_INTRIN_VMLSQ_LANEQ_U16,
	ARM64_INTRIN_VMLS_LANEQ_U32,
	ARM64_INTRIN_VMLSQ_LANEQ_U32,
	ARM64_INTRIN_VMLS_LANEQ_F32,
	ARM64_INTRIN_VMLSQ_LANEQ_F32,
	ARM64_INTRIN_VMLSL_LANE_S16,
	ARM64_INTRIN_VMLSL_LANE_S32,
	ARM64_INTRIN_VMLSL_LANE_U16,
	ARM64_INTRIN_VMLSL_LANE_U32,
	ARM64_INTRIN_VMLSL_HIGH_LANE_S16,
	ARM64_INTRIN_VMLSL_HIGH_LANE_S32,
	ARM64_INTRIN_VMLSL_HIGH_LANE_U16,
	ARM64_INTRIN_VMLSL_HIGH_LANE_U32,
	ARM64_INTRIN_VMLSL_LANEQ_S16,
	ARM64_INTRIN_VMLSL_LANEQ_S32,
	ARM64_INTRIN_VMLSL_LANEQ_U16,
	ARM64_INTRIN_VMLSL_LANEQ_U32,
	ARM64_INTRIN_VMLSL_HIGH_LANEQ_S16,
	ARM64_INTRIN_VMLSL_HIGH_LANEQ_S32,
	ARM64_INTRIN_VMLSL_HIGH_LANEQ_U16,
	ARM64_INTRIN_VMLSL_HIGH_LANEQ_U32,
	ARM64_INTRIN_VQDMLSL_LANE_S16,
	ARM64_INTRIN_VQDMLSL_LANE_S32,
	ARM64_INTRIN_VQDMLSLH_LANE_S16,
	ARM64_INTRIN_VQDMLSLS_LANE_S32,
	ARM64_INTRIN_VQDMLSL_HIGH_LANE_S16,
	ARM64_INTRIN_VQDMLSL_HIGH_LANE_S32,
	ARM64_INTRIN_VQDMLSL_LANEQ_S16,
	ARM64_INTRIN_VQDMLSL_LANEQ_S32,
	ARM64_INTRIN_VQDMLSLH_LANEQ_S16,
	ARM64_INTRIN_VQDMLSLS_LANEQ_S32,
	ARM64_INTRIN_VQDMLSL_HIGH_LANEQ_S16,
	ARM64_INTRIN_VQDMLSL_HIGH_LANEQ_S32,
	ARM64_INTRIN_VMUL_N_S16,
	ARM64_INTRIN_VMULQ_N_S16,
	ARM64_INTRIN_VMUL_N_S32,
	ARM64_INTRIN_VMULQ_N_S32,
	ARM64_INTRIN_VMUL_N_U16,
	ARM64_INTRIN_VMULQ_N_U16,
	ARM64_INTRIN_VMUL_N_U32,
	ARM64_INTRIN_VMULQ_N_U32,
	ARM64_INTRIN_VMUL_N_F32,
	ARM64_INTRIN_VMULQ_N_F32,
	ARM64_INTRIN_VMUL_N_F64,
	ARM64_INTRIN_VMULQ_N_F64,
	ARM64_INTRIN_VMUL_LANE_S16,
	ARM64_INTRIN_VMULQ_LANE_S16,
	ARM64_INTRIN_VMUL_LANE_S32,
	ARM64_INTRIN_VMULQ_LANE_S32,
	ARM64_INTRIN_VMUL_LANE_U16,
	ARM64_INTRIN_VMULQ_LANE_U16,
	ARM64_INTRIN_VMUL_LANE_U32,
	ARM64_INTRIN_VMULQ_LANE_U32,
	ARM64_INTRIN_VMUL_LANE_F32,
	ARM64_INTRIN_VMULQ_LANE_F32,
	ARM64_INTRIN_VMUL_LANE_F64,
	ARM64_INTRIN_VMULQ_LANE_F64,
	ARM64_INTRIN_VMULS_LANE_F32,
	ARM64_INTRIN_VMULD_LANE_F64,
	ARM64_INTRIN_VMUL_LANEQ_S16,
	ARM64_INTRIN_VMULQ_LANEQ_S16,
	ARM64_INTRIN_VMUL_LANEQ_S32,
	ARM64_INTRIN_VMULQ_LANEQ_S32,
	ARM64_INTRIN_VMUL_LANEQ_U16,
	ARM64_INTRIN_VMULQ_LANEQ_U16,
	ARM64_INTRIN_VMUL_LANEQ_U32,
	ARM64_INTRIN_VMULQ_LANEQ_U32,
	ARM64_INTRIN_VMUL_LANEQ_F32,
	ARM64_INTRIN_VMULQ_LANEQ_F32,
	ARM64_INTRIN_VMUL_LANEQ_F64,
	ARM64_INTRIN_VMULQ_LANEQ_F64,
	ARM64_INTRIN_VMULS_LANEQ_F32,
	ARM64_INTRIN_VMULD_LANEQ_F64,
	ARM64_INTRIN_VMULL_N_S16,
	ARM64_INTRIN_VMULL_N_S32,
	ARM64_INTRIN_VMULL_N_U16,
	ARM64_INTRIN_VMULL_N_U32,
	ARM64_INTRIN_VMULL_HIGH_N_S16,
	ARM64_INTRIN_VMULL_HIGH_N_S32,
	ARM64_INTRIN_VMULL_HIGH_N_U16,
	ARM64_INTRIN_VMULL_HIGH_N_U32,
	ARM64_INTRIN_VMULL_LANE_S16,
	ARM64_INTRIN_VMULL_LANE_S32,
	ARM64_INTRIN_VMULL_LANE_U16,
	ARM64_INTRIN_VMULL_LANE_U32,
	ARM64_INTRIN_VMULL_HIGH_LANE_S16,
	ARM64_INTRIN_VMULL_HIGH_LANE_S32,
	ARM64_INTRIN_VMULL_HIGH_LANE_U16,
	ARM64_INTRIN_VMULL_HIGH_LANE_U32,
	ARM64_INTRIN_VMULL_LANEQ_S16,
	ARM64_INTRIN_VMULL_LANEQ_S32,
	ARM64_INTRIN_VMULL_LANEQ_U16,
	ARM64_INTRIN_VMULL_LANEQ_U32,
	ARM64_INTRIN_VMULL_HIGH_LANEQ_S16,
	ARM64_INTRIN_VMULL_HIGH_LANEQ_S32,
	ARM64_INTRIN_VMULL_HIGH_LANEQ_U16,
	ARM64_INTRIN_VMULL_HIGH_LANEQ_U32,
	ARM64_INTRIN_VQDMULL_N_S16,
	ARM64_INTRIN_VQDMULL_N_S32,
	ARM64_INTRIN_VQDMULL_HIGH_N_S16,
	ARM64_INTRIN_VQDMULL_HIGH_N_S32,
	ARM64_INTRIN_VQDMULL_LANE_S16,
	ARM64_INTRIN_VQDMULL_LANE_S32,
	ARM64_INTRIN_VQDMULLH_LANE_S16,
	ARM64_INTRIN_VQDMULLS_LANE_S32,
	ARM64_INTRIN_VQDMULL_HIGH_LANE_S16,
	ARM64_INTRIN_VQDMULL_HIGH_LANE_S32,
	ARM64_INTRIN_VQDMULL_LANEQ_S16,
	ARM64_INTRIN_VQDMULL_LANEQ_S32,
	ARM64_INTRIN_VQDMULLH_LANEQ_S16,
	ARM64_INTRIN_VQDMULLS_LANEQ_S32,
	ARM64_INTRIN_VQDMULL_HIGH_LANEQ_S16,
	ARM64_INTRIN_VQDMULL_HIGH_LANEQ_S32,
	ARM64_INTRIN_VQDMULH_N_S16,
	ARM64_INTRIN_VQDMULHQ_N_S16,
	ARM64_INTRIN_VQDMULH_N_S32,
	ARM64_INTRIN_VQDMULHQ_N_S32,
	ARM64_INTRIN_VQDMULH_LANE_S16,
	ARM64_INTRIN_VQDMULHQ_LANE_S16,
	ARM64_INTRIN_VQDMULH_LANE_S32,
	ARM64_INTRIN_VQDMULHQ_LANE_S32,
	ARM64_INTRIN_VQDMULHH_LANE_S16,
	ARM64_INTRIN_VQDMULHS_LANE_S32,
	ARM64_INTRIN_VQDMULH_LANEQ_S16,
	ARM64_INTRIN_VQDMULHQ_LANEQ_S16,
	ARM64_INTRIN_VQDMULH_LANEQ_S32,
	ARM64_INTRIN_VQDMULHQ_LANEQ_S32,
	ARM64_INTRIN_VQDMULHH_LANEQ_S16,
	ARM64_INTRIN_VQDMULHS_LANEQ_S32,
	ARM64_INTRIN_VQRDMULH_N_S16,
	ARM64_INTRIN_VQRDMULHQ_N_S16,
	ARM64_INTRIN_VQRDMULH_N_S32,
	ARM64_INTRIN_VQRDMULHQ_N_S32,
	ARM64_INTRIN_VQRDMULH_LANE_S16,
	ARM64_INTRIN_VQRDMULHQ_LANE_S16,
	ARM64_INTRIN_VQRDMULH_LANE_S32,
	ARM64_INTRIN_VQRDMULHQ_LANE_S32,
	ARM64_INTRIN_VQRDMULHH_LANE_S16,
	ARM64_INTRIN_VQRDMULHS_LANE_S32,
	ARM64_INTRIN_VQRDMULH_LANEQ_S16,
	ARM64_INTRIN_VQRDMULHQ_LANEQ_S16,
	ARM64_INTRIN_VQRDMULH_LANEQ_S32,
	ARM64_INTRIN_VQRDMULHQ_LANEQ_S32,
	ARM64_INTRIN_VQRDMULHH_LANEQ_S16,
	ARM64_INTRIN_VQRDMULHS_LANEQ_S32,
	ARM64_INTRIN_VMLA_N_S16,
	ARM64_INTRIN_VMLAQ_N_S16,
	ARM64_INTRIN_VMLA_N_S32,
	ARM64_INTRIN_VMLAQ_N_S32,
	ARM64_INTRIN_VMLA_N_U16,
	ARM64_INTRIN_VMLAQ_N_U16,
	ARM64_INTRIN_VMLA_N_U32,
	ARM64_INTRIN_VMLAQ_N_U32,
	ARM64_INTRIN_VMLA_N_F32,
	ARM64_INTRIN_VMLAQ_N_F32,
	ARM64_INTRIN_VMLAL_N_S16,
	ARM64_INTRIN_VMLAL_N_S32,
	ARM64_INTRIN_VMLAL_N_U16,
	ARM64_INTRIN_VMLAL_N_U32,
	ARM64_INTRIN_VMLAL_HIGH_N_S16,
	ARM64_INTRIN_VMLAL_HIGH_N_S32,
	ARM64_INTRIN_VMLAL_HIGH_N_U16,
	ARM64_INTRIN_VMLAL_HIGH_N_U32,
	ARM64_INTRIN_VQDMLAL_N_S16,
	ARM64_INTRIN_VQDMLAL_N_S32,
	ARM64_INTRIN_VQDMLAL_HIGH_N_S16,
	ARM64_INTRIN_VQDMLAL_HIGH_N_S32,
	ARM64_INTRIN_VMLS_N_S16,
	ARM64_INTRIN_VMLSQ_N_S16,
	ARM64_INTRIN_VMLS_N_S32,
	ARM64_INTRIN_VMLSQ_N_S32,
	ARM64_INTRIN_VMLS_N_U16,
	ARM64_INTRIN_VMLSQ_N_U16,
	ARM64_INTRIN_VMLS_N_U32,
	ARM64_INTRIN_VMLSQ_N_U32,
	ARM64_INTRIN_VMLS_N_F32,
	ARM64_INTRIN_VMLSQ_N_F32,
	ARM64_INTRIN_VMLSL_N_S16,
	ARM64_INTRIN_VMLSL_N_S32,
	ARM64_INTRIN_VMLSL_N_U16,
	ARM64_INTRIN_VMLSL_N_U32,
	ARM64_INTRIN_VMLSL_HIGH_N_S16,
	ARM64_INTRIN_VMLSL_HIGH_N_S32,
	ARM64_INTRIN_VMLSL_HIGH_N_U16,
	ARM64_INTRIN_VMLSL_HIGH_N_U32,
	ARM64_INTRIN_VQDMLSL_N_S16,
	ARM64_INTRIN_VQDMLSL_N_S32,
	ARM64_INTRIN_VQDMLSL_HIGH_N_S16,
	ARM64_INTRIN_VQDMLSL_HIGH_N_S32,
	ARM64_INTRIN_VABS_S8,
	ARM64_INTRIN_VABSQ_S8,
	ARM64_INTRIN_VABS_S16,
	ARM64_INTRIN_VABSQ_S16,
	ARM64_INTRIN_VABS_S32,
	ARM64_INTRIN_VABSQ_S32,
	ARM64_INTRIN_VABS_F32,
	ARM64_INTRIN_VABSQ_F32,
	ARM64_INTRIN_VABS_S64,
	ARM64_INTRIN_VABSD_S64,
	ARM64_INTRIN_VABSQ_S64,
	ARM64_INTRIN_VABS_F64,
	ARM64_INTRIN_VABSQ_F64,
	ARM64_INTRIN_VQABS_S8,
	ARM64_INTRIN_VQABSQ_S8,
	ARM64_INTRIN_VQABS_S16,
	ARM64_INTRIN_VQABSQ_S16,
	ARM64_INTRIN_VQABS_S32,
	ARM64_INTRIN_VQABSQ_S32,
	ARM64_INTRIN_VQABS_S64,
	ARM64_INTRIN_VQABSQ_S64,
	ARM64_INTRIN_VQABSB_S8,
	ARM64_INTRIN_VQABSH_S16,
	ARM64_INTRIN_VQABSS_S32,
	ARM64_INTRIN_VQABSD_S64,
	ARM64_INTRIN_VNEG_S8,
	ARM64_INTRIN_VNEGQ_S8,
	ARM64_INTRIN_VNEG_S16,
	ARM64_INTRIN_VNEGQ_S16,
	ARM64_INTRIN_VNEG_S32,
	ARM64_INTRIN_VNEGQ_S32,
	ARM64_INTRIN_VNEG_F32,
	ARM64_INTRIN_VNEGQ_F32,
	ARM64_INTRIN_VNEG_S64,
	ARM64_INTRIN_VNEGD_S64,
	ARM64_INTRIN_VNEGQ_S64,
	ARM64_INTRIN_VNEG_F64,
	ARM64_INTRIN_VNEGQ_F64,
	ARM64_INTRIN_VQNEG_S8,
	ARM64_INTRIN_VQNEGQ_S8,
	ARM64_INTRIN_VQNEG_S16,
	ARM64_INTRIN_VQNEGQ_S16,
	ARM64_INTRIN_VQNEG_S32,
	ARM64_INTRIN_VQNEGQ_S32,
	ARM64_INTRIN_VQNEG_S64,
	ARM64_INTRIN_VQNEGQ_S64,
	ARM64_INTRIN_VQNEGB_S8,
	ARM64_INTRIN_VQNEGH_S16,
	ARM64_INTRIN_VQNEGS_S32,
	ARM64_INTRIN_VQNEGD_S64,
	ARM64_INTRIN_VCLS_S8,
	ARM64_INTRIN_VCLSQ_S8,
	ARM64_INTRIN_VCLS_S16,
	ARM64_INTRIN_VCLSQ_S16,
	ARM64_INTRIN_VCLS_S32,
	ARM64_INTRIN_VCLSQ_S32,
	ARM64_INTRIN_VCLS_U8,
	ARM64_INTRIN_VCLSQ_U8,
	ARM64_INTRIN_VCLS_U16,
	ARM64_INTRIN_VCLSQ_U16,
	ARM64_INTRIN_VCLS_U32,
	ARM64_INTRIN_VCLSQ_U32,
	ARM64_INTRIN_VCLZ_S8,
	ARM64_INTRIN_VCLZQ_S8,
	ARM64_INTRIN_VCLZ_S16,
	ARM64_INTRIN_VCLZQ_S16,
	ARM64_INTRIN_VCLZ_S32,
	ARM64_INTRIN_VCLZQ_S32,
	ARM64_INTRIN_VCLZ_U8,
	ARM64_INTRIN_VCLZQ_U8,
	ARM64_INTRIN_VCLZ_U16,
	ARM64_INTRIN_VCLZQ_U16,
	ARM64_INTRIN_VCLZ_U32,
	ARM64_INTRIN_VCLZQ_U32,
	ARM64_INTRIN_VCNT_S8,
	ARM64_INTRIN_VCNTQ_S8,
	ARM64_INTRIN_VCNT_U8,
	ARM64_INTRIN_VCNTQ_U8,
	ARM64_INTRIN_VCNT_P8,
	ARM64_INTRIN_VCNTQ_P8,
	ARM64_INTRIN_VRECPE_U32,
	ARM64_INTRIN_VRECPEQ_U32,
	ARM64_INTRIN_VRECPE_F32,
	ARM64_INTRIN_VRECPEQ_F32,
	ARM64_INTRIN_VRECPE_F64,
	ARM64_INTRIN_VRECPEQ_F64,
	ARM64_INTRIN_VRECPES_F32,
	ARM64_INTRIN_VRECPED_F64,
	ARM64_INTRIN_VRECPS_F32,
	ARM64_INTRIN_VRECPSQ_F32,
	ARM64_INTRIN_VRECPS_F64,
	ARM64_INTRIN_VRECPSQ_F64,
	ARM64_INTRIN_VRECPSS_F32,
	ARM64_INTRIN_VRECPSD_F64,
	ARM64_INTRIN_VSQRT_F32,
	ARM64_INTRIN_VSQRTQ_F32,
	ARM64_INTRIN_VSQRT_F64,
	ARM64_INTRIN_VSQRTQ_F64,
	ARM64_INTRIN_VRSQRTE_U32,
	ARM64_INTRIN_VRSQRTEQ_U32,
	ARM64_INTRIN_VRSQRTE_F32,
	ARM64_INTRIN_VRSQRTEQ_F32,
	ARM64_INTRIN_VRSQRTE_F64,
	ARM64_INTRIN_VRSQRTEQ_F64,
	ARM64_INTRIN_VRSQRTES_F32,
	ARM64_INTRIN_VRSQRTED_F64,
	ARM64_INTRIN_VRSQRTS_F32,
	ARM64_INTRIN_VRSQRTSQ_F32,
	ARM64_INTRIN_VRSQRTS_F64,
	ARM64_INTRIN_VRSQRTSQ_F64,
	ARM64_INTRIN_VRSQRTSS_F32,
	ARM64_INTRIN_VRSQRTSD_F64,
	ARM64_INTRIN_VMVN_S8,
	ARM64_INTRIN_VMVNQ_S8,
	ARM64_INTRIN_VMVN_S16,
	ARM64_INTRIN_VMVNQ_S16,
	ARM64_INTRIN_VMVN_S32,
	ARM64_INTRIN_VMVNQ_S32,
	ARM64_INTRIN_VMVN_U8,
	ARM64_INTRIN_VMVNQ_U8,
	ARM64_INTRIN_VMVN_U16,
	ARM64_INTRIN_VMVNQ_U16,
	ARM64_INTRIN_VMVN_U32,
	ARM64_INTRIN_VMVNQ_U32,
	ARM64_INTRIN_VMVN_P8,
	ARM64_INTRIN_VMVNQ_P8,
	ARM64_INTRIN_VAND_S8,
	ARM64_INTRIN_VANDQ_S8,
	ARM64_INTRIN_VAND_S16,
	ARM64_INTRIN_VANDQ_S16,
	ARM64_INTRIN_VAND_S32,
	ARM64_INTRIN_VANDQ_S32,
	ARM64_INTRIN_VAND_S64,
	ARM64_INTRIN_VANDQ_S64,
	ARM64_INTRIN_VAND_U8,
	ARM64_INTRIN_VANDQ_U8,
	ARM64_INTRIN_VAND_U16,
	ARM64_INTRIN_VANDQ_U16,
	ARM64_INTRIN_VAND_U32,
	ARM64_INTRIN_VANDQ_U32,
	ARM64_INTRIN_VAND_U64,
	ARM64_INTRIN_VANDQ_U64,
	ARM64_INTRIN_VORR_S8,
	ARM64_INTRIN_VORRQ_S8,
	ARM64_INTRIN_VORR_S16,
	ARM64_INTRIN_VORRQ_S16,
	ARM64_INTRIN_VORR_S32,
	ARM64_INTRIN_VORRQ_S32,
	ARM64_INTRIN_VORR_S64,
	ARM64_INTRIN_VORRQ_S64,
	ARM64_INTRIN_VORR_U8,
	ARM64_INTRIN_VORRQ_U8,
	ARM64_INTRIN_VORR_U16,
	ARM64_INTRIN_VORRQ_U16,
	ARM64_INTRIN_VORR_U32,
	ARM64_INTRIN_VORRQ_U32,
	ARM64_INTRIN_VORR_U64,
	ARM64_INTRIN_VORRQ_U64,
	ARM64_INTRIN_VEOR_S8,
	ARM64_INTRIN_VEORQ_S8,
	ARM64_INTRIN_VEOR_S16,
	ARM64_INTRIN_VEORQ_S16,
	ARM64_INTRIN_VEOR_S32,
	ARM64_INTRIN_VEORQ_S32,
	ARM64_INTRIN_VEOR_S64,
	ARM64_INTRIN_VEORQ_S64,
	ARM64_INTRIN_VEOR_U8,
	ARM64_INTRIN_VEORQ_U8,
	ARM64_INTRIN_VEOR_U16,
	ARM64_INTRIN_VEORQ_U16,
	ARM64_INTRIN_VEOR_U32,
	ARM64_INTRIN_VEORQ_U32,
	ARM64_INTRIN_VEOR_U64,
	ARM64_INTRIN_VEORQ_U64,
	ARM64_INTRIN_VBIC_S8,
	ARM64_INTRIN_VBICQ_S8,
	ARM64_INTRIN_VBIC_S16,
	ARM64_INTRIN_VBICQ_S16,
	ARM64_INTRIN_VBIC_S32,
	ARM64_INTRIN_VBICQ_S32,
	ARM64_INTRIN_VBIC_S64,
	ARM64_INTRIN_VBICQ_S64,
	ARM64_INTRIN_VBIC_U8,
	ARM64_INTRIN_VBICQ_U8,
	ARM64_INTRIN_VBIC_U16,
	ARM64_INTRIN_VBICQ_U16,
	ARM64_INTRIN_VBIC_U32,
	ARM64_INTRIN_VBICQ_U32,
	ARM64_INTRIN_VBIC_U64,
	ARM64_INTRIN_VBICQ_U64,
	ARM64_INTRIN_VORN_S8,
	ARM64_INTRIN_VORNQ_S8,
	ARM64_INTRIN_VORN_S16,
	ARM64_INTRIN_VORNQ_S16,
	ARM64_INTRIN_VORN_S32,
	ARM64_INTRIN_VORNQ_S32,
	ARM64_INTRIN_VORN_S64,
	ARM64_INTRIN_VORNQ_S64,
	ARM64_INTRIN_VORN_U8,
	ARM64_INTRIN_VORNQ_U8,
	ARM64_INTRIN_VORN_U16,
	ARM64_INTRIN_VORNQ_U16,
	ARM64_INTRIN_VORN_U32,
	ARM64_INTRIN_VORNQ_U32,
	ARM64_INTRIN_VORN_U64,
	ARM64_INTRIN_VORNQ_U64,
	ARM64_INTRIN_VBSL_S8,
	ARM64_INTRIN_VBSLQ_S8,
	ARM64_INTRIN_VBSL_S16,
	ARM64_INTRIN_VBSLQ_S16,
	ARM64_INTRIN_VBSL_S32,
	ARM64_INTRIN_VBSLQ_S32,
	ARM64_INTRIN_VBSL_S64,
	ARM64_INTRIN_VBSLQ_S64,
	ARM64_INTRIN_VBSL_U8,
	ARM64_INTRIN_VBSLQ_U8,
	ARM64_INTRIN_VBSL_U16,
	ARM64_INTRIN_VBSLQ_U16,
	ARM64_INTRIN_VBSL_U32,
	ARM64_INTRIN_VBSLQ_U32,
	ARM64_INTRIN_VBSL_U64,
	ARM64_INTRIN_VBSLQ_U64,
	ARM64_INTRIN_VBSL_P64,
	ARM64_INTRIN_VBSLQ_P64,
	ARM64_INTRIN_VBSL_F32,
	ARM64_INTRIN_VBSLQ_F32,
	ARM64_INTRIN_VBSL_P8,
	ARM64_INTRIN_VBSLQ_P8,
	ARM64_INTRIN_VBSL_P16,
	ARM64_INTRIN_VBSLQ_P16,
	ARM64_INTRIN_VBSL_F64,
	ARM64_INTRIN_VBSLQ_F64,
	ARM64_INTRIN_VCOPY_LANE_S8,
	ARM64_INTRIN_VCOPYQ_LANE_S8,
	ARM64_INTRIN_VCOPY_LANE_S16,
	ARM64_INTRIN_VCOPYQ_LANE_S16,
	ARM64_INTRIN_VCOPY_LANE_S32,
	ARM64_INTRIN_VCOPYQ_LANE_S32,
	ARM64_INTRIN_VCOPY_LANE_S64,
	ARM64_INTRIN_VCOPYQ_LANE_S64,
	ARM64_INTRIN_VCOPY_LANE_U8,
	ARM64_INTRIN_VCOPYQ_LANE_U8,
	ARM64_INTRIN_VCOPY_LANE_U16,
	ARM64_INTRIN_VCOPYQ_LANE_U16,
	ARM64_INTRIN_VCOPY_LANE_U32,
	ARM64_INTRIN_VCOPYQ_LANE_U32,
	ARM64_INTRIN_VCOPY_LANE_U64,
	ARM64_INTRIN_VCOPYQ_LANE_U64,
	ARM64_INTRIN_VCOPY_LANE_P64,
	ARM64_INTRIN_VCOPYQ_LANE_P64,
	ARM64_INTRIN_VCOPY_LANE_F32,
	ARM64_INTRIN_VCOPYQ_LANE_F32,
	ARM64_INTRIN_VCOPY_LANE_F64,
	ARM64_INTRIN_VCOPYQ_LANE_F64,
	ARM64_INTRIN_VCOPY_LANE_P8,
	ARM64_INTRIN_VCOPYQ_LANE_P8,
	ARM64_INTRIN_VCOPY_LANE_P16,
	ARM64_INTRIN_VCOPYQ_LANE_P16,
	ARM64_INTRIN_VCOPY_LANEQ_S8,
	ARM64_INTRIN_VCOPYQ_LANEQ_S8,
	ARM64_INTRIN_VCOPY_LANEQ_S16,
	ARM64_INTRIN_VCOPYQ_LANEQ_S16,
	ARM64_INTRIN_VCOPY_LANEQ_S32,
	ARM64_INTRIN_VCOPYQ_LANEQ_S32,
	ARM64_INTRIN_VCOPY_LANEQ_S64,
	ARM64_INTRIN_VCOPYQ_LANEQ_S64,
	ARM64_INTRIN_VCOPY_LANEQ_U8,
	ARM64_INTRIN_VCOPYQ_LANEQ_U8,
	ARM64_INTRIN_VCOPY_LANEQ_U16,
	ARM64_INTRIN_VCOPYQ_LANEQ_U16,
	ARM64_INTRIN_VCOPY_LANEQ_U32,
	ARM64_INTRIN_VCOPYQ_LANEQ_U32,
	ARM64_INTRIN_VCOPY_LANEQ_U64,
	ARM64_INTRIN_VCOPYQ_LANEQ_U64,
	ARM64_INTRIN_VCOPY_LANEQ_P64,
	ARM64_INTRIN_VCOPYQ_LANEQ_P64,
	ARM64_INTRIN_VCOPY_LANEQ_F32,
	ARM64_INTRIN_VCOPYQ_LANEQ_F32,
	ARM64_INTRIN_VCOPY_LANEQ_F64,
	ARM64_INTRIN_VCOPYQ_LANEQ_F64,
	ARM64_INTRIN_VCOPY_LANEQ_P8,
	ARM64_INTRIN_VCOPYQ_LANEQ_P8,
	ARM64_INTRIN_VCOPY_LANEQ_P16,
	ARM64_INTRIN_VCOPYQ_LANEQ_P16,
	ARM64_INTRIN_VRBIT_S8,
	ARM64_INTRIN_VRBITQ_S8,
	ARM64_INTRIN_VRBIT_U8,
	ARM64_INTRIN_VRBITQ_U8,
	ARM64_INTRIN_VRBIT_P8,
	ARM64_INTRIN_VRBITQ_P8,
	ARM64_INTRIN_VCREATE_S8,
	ARM64_INTRIN_VCREATE_S16,
	ARM64_INTRIN_VCREATE_S32,
	ARM64_INTRIN_VCREATE_S64,
	ARM64_INTRIN_VCREATE_U8,
	ARM64_INTRIN_VCREATE_U16,
	ARM64_INTRIN_VCREATE_U32,
	ARM64_INTRIN_VCREATE_U64,
	ARM64_INTRIN_VCREATE_P64,
	ARM64_INTRIN_VCREATE_F16,
	ARM64_INTRIN_VCREATE_F32,
	ARM64_INTRIN_VCREATE_P8,
	ARM64_INTRIN_VCREATE_P16,
	ARM64_INTRIN_VCREATE_F64,
	ARM64_INTRIN_VDUP_N_S8,
	ARM64_INTRIN_VDUPQ_N_S8,
	ARM64_INTRIN_VDUP_N_S16,
	ARM64_INTRIN_VDUPQ_N_S16,
	ARM64_INTRIN_VDUP_N_S32,
	ARM64_INTRIN_VDUPQ_N_S32,
	ARM64_INTRIN_VDUP_N_S64,
	ARM64_INTRIN_VDUPQ_N_S64,
	ARM64_INTRIN_VDUP_N_U8,
	ARM64_INTRIN_VDUPQ_N_U8,
	ARM64_INTRIN_VDUP_N_U16,
	ARM64_INTRIN_VDUPQ_N_U16,
	ARM64_INTRIN_VDUP_N_U32,
	ARM64_INTRIN_VDUPQ_N_U32,
	ARM64_INTRIN_VDUP_N_U64,
	ARM64_INTRIN_VDUPQ_N_U64,
	ARM64_INTRIN_VDUP_N_P64,
	ARM64_INTRIN_VDUPQ_N_P64,
	ARM64_INTRIN_VDUP_N_F32,
	ARM64_INTRIN_VDUPQ_N_F32,
	ARM64_INTRIN_VDUP_N_P8,
	ARM64_INTRIN_VDUPQ_N_P8,
	ARM64_INTRIN_VDUP_N_P16,
	ARM64_INTRIN_VDUPQ_N_P16,
	ARM64_INTRIN_VDUP_N_F64,
	ARM64_INTRIN_VDUPQ_N_F64,
	ARM64_INTRIN_VMOV_N_S8,
	ARM64_INTRIN_VMOVQ_N_S8,
	ARM64_INTRIN_VMOV_N_S16,
	ARM64_INTRIN_VMOVQ_N_S16,
	ARM64_INTRIN_VMOV_N_S32,
	ARM64_INTRIN_VMOVQ_N_S32,
	ARM64_INTRIN_VMOV_N_S64,
	ARM64_INTRIN_VMOVQ_N_S64,
	ARM64_INTRIN_VMOV_N_U8,
	ARM64_INTRIN_VMOVQ_N_U8,
	ARM64_INTRIN_VMOV_N_U16,
	ARM64_INTRIN_VMOVQ_N_U16,
	ARM64_INTRIN_VMOV_N_U32,
	ARM64_INTRIN_VMOVQ_N_U32,
	ARM64_INTRIN_VMOV_N_U64,
	ARM64_INTRIN_VMOVQ_N_U64,
	ARM64_INTRIN_VMOV_N_F32,
	ARM64_INTRIN_VMOVQ_N_F32,
	ARM64_INTRIN_VMOV_N_P8,
	ARM64_INTRIN_VMOVQ_N_P8,
	ARM64_INTRIN_VMOV_N_P16,
	ARM64_INTRIN_VMOVQ_N_P16,
	ARM64_INTRIN_VMOV_N_F64,
	ARM64_INTRIN_VMOVQ_N_F64,
	ARM64_INTRIN_VDUP_LANE_S8,
	ARM64_INTRIN_VDUPQ_LANE_S8,
	ARM64_INTRIN_VDUP_LANE_S16,
	ARM64_INTRIN_VDUPQ_LANE_S16,
	ARM64_INTRIN_VDUP_LANE_S32,
	ARM64_INTRIN_VDUPQ_LANE_S32,
	ARM64_INTRIN_VDUP_LANE_S64,
	ARM64_INTRIN_VDUPQ_LANE_S64,
	ARM64_INTRIN_VDUP_LANE_U8,
	ARM64_INTRIN_VDUPQ_LANE_U8,
	ARM64_INTRIN_VDUP_LANE_U16,
	ARM64_INTRIN_VDUPQ_LANE_U16,
	ARM64_INTRIN_VDUP_LANE_U32,
	ARM64_INTRIN_VDUPQ_LANE_U32,
	ARM64_INTRIN_VDUP_LANE_U64,
	ARM64_INTRIN_VDUPQ_LANE_U64,
	ARM64_INTRIN_VDUP_LANE_P64,
	ARM64_INTRIN_VDUPQ_LANE_P64,
	ARM64_INTRIN_VDUP_LANE_F32,
	ARM64_INTRIN_VDUPQ_LANE_F32,
	ARM64_INTRIN_VDUP_LANE_P8,
	ARM64_INTRIN_VDUPQ_LANE_P8,
	ARM64_INTRIN_VDUP_LANE_P16,
	ARM64_INTRIN_VDUPQ_LANE_P16,
	ARM64_INTRIN_VDUP_LANE_F64,
	ARM64_INTRIN_VDUPQ_LANE_F64,
	ARM64_INTRIN_VDUP_LANEQ_S8,
	ARM64_INTRIN_VDUPQ_LANEQ_S8,
	ARM64_INTRIN_VDUP_LANEQ_S16,
	ARM64_INTRIN_VDUPQ_LANEQ_S16,
	ARM64_INTRIN_VDUP_LANEQ_S32,
	ARM64_INTRIN_VDUPQ_LANEQ_S32,
	ARM64_INTRIN_VDUP_LANEQ_S64,
	ARM64_INTRIN_VDUPQ_LANEQ_S64,
	ARM64_INTRIN_VDUP_LANEQ_U8,
	ARM64_INTRIN_VDUPQ_LANEQ_U8,
	ARM64_INTRIN_VDUP_LANEQ_U16,
	ARM64_INTRIN_VDUPQ_LANEQ_U16,
	ARM64_INTRIN_VDUP_LANEQ_U32,
	ARM64_INTRIN_VDUPQ_LANEQ_U32,
	ARM64_INTRIN_VDUP_LANEQ_U64,
	ARM64_INTRIN_VDUPQ_LANEQ_U64,
	ARM64_INTRIN_VDUP_LANEQ_P64,
	ARM64_INTRIN_VDUPQ_LANEQ_P64,
	ARM64_INTRIN_VDUP_LANEQ_F32,
	ARM64_INTRIN_VDUPQ_LANEQ_F32,
	ARM64_INTRIN_VDUP_LANEQ_P8,
	ARM64_INTRIN_VDUPQ_LANEQ_P8,
	ARM64_INTRIN_VDUP_LANEQ_P16,
	ARM64_INTRIN_VDUPQ_LANEQ_P16,
	ARM64_INTRIN_VDUP_LANEQ_F64,
	ARM64_INTRIN_VDUPQ_LANEQ_F64,
	ARM64_INTRIN_VCOMBINE_S8,
	ARM64_INTRIN_VCOMBINE_S16,
	ARM64_INTRIN_VCOMBINE_S32,
	ARM64_INTRIN_VCOMBINE_S64,
	ARM64_INTRIN_VCOMBINE_U8,
	ARM64_INTRIN_VCOMBINE_U16,
	ARM64_INTRIN_VCOMBINE_U32,
	ARM64_INTRIN_VCOMBINE_U64,
	ARM64_INTRIN_VCOMBINE_P64,
	ARM64_INTRIN_VCOMBINE_F16,
	ARM64_INTRIN_VCOMBINE_F32,
	ARM64_INTRIN_VCOMBINE_P8,
	ARM64_INTRIN_VCOMBINE_P16,
	ARM64_INTRIN_VCOMBINE_F64,
	ARM64_INTRIN_VGET_HIGH_S8,
	ARM64_INTRIN_VGET_HIGH_S16,
	ARM64_INTRIN_VGET_HIGH_S32,
	ARM64_INTRIN_VGET_HIGH_S64,
	ARM64_INTRIN_VGET_HIGH_U8,
	ARM64_INTRIN_VGET_HIGH_U16,
	ARM64_INTRIN_VGET_HIGH_U32,
	ARM64_INTRIN_VGET_HIGH_U64,
	ARM64_INTRIN_VGET_HIGH_P64,
	ARM64_INTRIN_VGET_HIGH_F16,
	ARM64_INTRIN_VGET_HIGH_F32,
	ARM64_INTRIN_VGET_HIGH_P8,
	ARM64_INTRIN_VGET_HIGH_P16,
	ARM64_INTRIN_VGET_HIGH_F64,
	ARM64_INTRIN_VGET_LOW_S8,
	ARM64_INTRIN_VGET_LOW_S16,
	ARM64_INTRIN_VGET_LOW_S32,
	ARM64_INTRIN_VGET_LOW_S64,
	ARM64_INTRIN_VGET_LOW_U8,
	ARM64_INTRIN_VGET_LOW_U16,
	ARM64_INTRIN_VGET_LOW_U32,
	ARM64_INTRIN_VGET_LOW_U64,
	ARM64_INTRIN_VGET_LOW_P64,
	ARM64_INTRIN_VGET_LOW_F16,
	ARM64_INTRIN_VGET_LOW_F32,
	ARM64_INTRIN_VGET_LOW_P8,
	ARM64_INTRIN_VGET_LOW_P16,
	ARM64_INTRIN_VGET_LOW_F64,
	ARM64_INTRIN_VDUPB_LANE_S8,
	ARM64_INTRIN_VDUPH_LANE_S16,
	ARM64_INTRIN_VDUPS_LANE_S32,
	ARM64_INTRIN_VDUPD_LANE_S64,
	ARM64_INTRIN_VDUPB_LANE_U8,
	ARM64_INTRIN_VDUPH_LANE_U16,
	ARM64_INTRIN_VDUPS_LANE_U32,
	ARM64_INTRIN_VDUPD_LANE_U64,
	ARM64_INTRIN_VDUPS_LANE_F32,
	ARM64_INTRIN_VDUPD_LANE_F64,
	ARM64_INTRIN_VDUPB_LANE_P8,
	ARM64_INTRIN_VDUPH_LANE_P16,
	ARM64_INTRIN_VDUPB_LANEQ_S8,
	ARM64_INTRIN_VDUPH_LANEQ_S16,
	ARM64_INTRIN_VDUPS_LANEQ_S32,
	ARM64_INTRIN_VDUPD_LANEQ_S64,
	ARM64_INTRIN_VDUPB_LANEQ_U8,
	ARM64_INTRIN_VDUPH_LANEQ_U16,
	ARM64_INTRIN_VDUPS_LANEQ_U32,
	ARM64_INTRIN_VDUPD_LANEQ_U64,
	ARM64_INTRIN_VDUPS_LANEQ_F32,
	ARM64_INTRIN_VDUPD_LANEQ_F64,
	ARM64_INTRIN_VDUPB_LANEQ_P8,
	ARM64_INTRIN_VDUPH_LANEQ_P16,
	ARM64_INTRIN_VLD1_S8,
	ARM64_INTRIN_VLD1Q_S8,
	ARM64_INTRIN_VLD1_S16,
	ARM64_INTRIN_VLD1Q_S16,
	ARM64_INTRIN_VLD1_S32,
	ARM64_INTRIN_VLD1Q_S32,
	ARM64_INTRIN_VLD1_S64,
	ARM64_INTRIN_VLD1Q_S64,
	ARM64_INTRIN_VLD1_U8,
	ARM64_INTRIN_VLD1Q_U8,
	ARM64_INTRIN_VLD1_U16,
	ARM64_INTRIN_VLD1Q_U16,
	ARM64_INTRIN_VLD1_U32,
	ARM64_INTRIN_VLD1Q_U32,
	ARM64_INTRIN_VLD1_U64,
	ARM64_INTRIN_VLD1Q_U64,
	ARM64_INTRIN_VLD1_P64,
	ARM64_INTRIN_VLD1Q_P64,
	ARM64_INTRIN_VLD1_F16,
	ARM64_INTRIN_VLD1Q_F16,
	ARM64_INTRIN_VLD1_F32,
	ARM64_INTRIN_VLD1Q_F32,
	ARM64_INTRIN_VLD1_P8,
	ARM64_INTRIN_VLD1Q_P8,
	ARM64_INTRIN_VLD1_P16,
	ARM64_INTRIN_VLD1Q_P16,
	ARM64_INTRIN_VLD1_F64,
	ARM64_INTRIN_VLD1Q_F64,
	ARM64_INTRIN_VLD1_LANE_S8,
	ARM64_INTRIN_VLD1Q_LANE_S8,
	ARM64_INTRIN_VLD1_LANE_S16,
	ARM64_INTRIN_VLD1Q_LANE_S16,
	ARM64_INTRIN_VLD1_LANE_S32,
	ARM64_INTRIN_VLD1Q_LANE_S32,
	ARM64_INTRIN_VLD1_LANE_S64,
	ARM64_INTRIN_VLD1Q_LANE_S64,
	ARM64_INTRIN_VLD1_LANE_U8,
	ARM64_INTRIN_VLD1Q_LANE_U8,
	ARM64_INTRIN_VLD1_LANE_U16,
	ARM64_INTRIN_VLD1Q_LANE_U16,
	ARM64_INTRIN_VLD1_LANE_U32,
	ARM64_INTRIN_VLD1Q_LANE_U32,
	ARM64_INTRIN_VLD1_LANE_U64,
	ARM64_INTRIN_VLD1Q_LANE_U64,
	ARM64_INTRIN_VLD1_LANE_P64,
	ARM64_INTRIN_VLD1Q_LANE_P64,
	ARM64_INTRIN_VLD1_LANE_F16,
	ARM64_INTRIN_VLD1Q_LANE_F16,
	ARM64_INTRIN_VLD1_LANE_F32,
	ARM64_INTRIN_VLD1Q_LANE_F32,
	ARM64_INTRIN_VLD1_LANE_P8,
	ARM64_INTRIN_VLD1Q_LANE_P8,
	ARM64_INTRIN_VLD1_LANE_P16,
	ARM64_INTRIN_VLD1Q_LANE_P16,
	ARM64_INTRIN_VLD1_LANE_F64,
	ARM64_INTRIN_VLD1Q_LANE_F64,
	ARM64_INTRIN_VLD1_DUP_S8,
	ARM64_INTRIN_VLD1Q_DUP_S8,
	ARM64_INTRIN_VLD1_DUP_S16,
	ARM64_INTRIN_VLD1Q_DUP_S16,
	ARM64_INTRIN_VLD1_DUP_S32,
	ARM64_INTRIN_VLD1Q_DUP_S32,
	ARM64_INTRIN_VLD1_DUP_S64,
	ARM64_INTRIN_VLD1Q_DUP_S64,
	ARM64_INTRIN_VLD1_DUP_U8,
	ARM64_INTRIN_VLD1Q_DUP_U8,
	ARM64_INTRIN_VLD1_DUP_U16,
	ARM64_INTRIN_VLD1Q_DUP_U16,
	ARM64_INTRIN_VLD1_DUP_U32,
	ARM64_INTRIN_VLD1Q_DUP_U32,
	ARM64_INTRIN_VLD1_DUP_U64,
	ARM64_INTRIN_VLD1Q_DUP_U64,
	ARM64_INTRIN_VLD1_DUP_P64,
	ARM64_INTRIN_VLD1Q_DUP_P64,
	ARM64_INTRIN_VLD1_DUP_F16,
	ARM64_INTRIN_VLD1Q_DUP_F16,
	ARM64_INTRIN_VLD1_DUP_F32,
	ARM64_INTRIN_VLD1Q_DUP_F32,
	ARM64_INTRIN_VLD1_DUP_P8,
	ARM64_INTRIN_VLD1Q_DUP_P8,
	ARM64_INTRIN_VLD1_DUP_P16,
	ARM64_INTRIN_VLD1Q_DUP_P16,
	ARM64_INTRIN_VLD1_DUP_F64,
	ARM64_INTRIN_VLD1Q_DUP_F64,
	ARM64_INTRIN_VST1_S8,
	ARM64_INTRIN_VST1Q_S8,
	ARM64_INTRIN_VST1_S16,
	ARM64_INTRIN_VST1Q_S16,
	ARM64_INTRIN_VST1_S32,
	ARM64_INTRIN_VST1Q_S32,
	ARM64_INTRIN_VST1_S64,
	ARM64_INTRIN_VST1Q_S64,
	ARM64_INTRIN_VST1_U8,
	ARM64_INTRIN_VST1Q_U8,
	ARM64_INTRIN_VST1_U16,
	ARM64_INTRIN_VST1Q_U16,
	ARM64_INTRIN_VST1_U32,
	ARM64_INTRIN_VST1Q_U32,
	ARM64_INTRIN_VST1_U64,
	ARM64_INTRIN_VST1Q_U64,
	ARM64_INTRIN_VST1_P64,
	ARM64_INTRIN_VST1Q_P64,
	ARM64_INTRIN_VST1_F16,
	ARM64_INTRIN_VST1Q_F16,
	ARM64_INTRIN_VST1_F32,
	ARM64_INTRIN_VST1Q_F32,
	ARM64_INTRIN_VST1_P8,
	ARM64_INTRIN_VST1Q_P8,
	ARM64_INTRIN_VST1_P16,
	ARM64_INTRIN_VST1Q_P16,
	ARM64_INTRIN_VST1_F64,
	ARM64_INTRIN_VST1Q_F64,
	ARM64_INTRIN_VST1_LANE_S8,
	ARM64_INTRIN_VST1Q_LANE_S8,
	ARM64_INTRIN_VST1_LANE_S16,
	ARM64_INTRIN_VST1Q_LANE_S16,
	ARM64_INTRIN_VST1_LANE_S32,
	ARM64_INTRIN_VST1Q_LANE_S32,
	ARM64_INTRIN_VST1_LANE_S64,
	ARM64_INTRIN_VST1Q_LANE_S64,
	ARM64_INTRIN_VST1_LANE_U8,
	ARM64_INTRIN_VST1Q_LANE_U8,
	ARM64_INTRIN_VST1_LANE_U16,
	ARM64_INTRIN_VST1Q_LANE_U16,
	ARM64_INTRIN_VST1_LANE_U32,
	ARM64_INTRIN_VST1Q_LANE_U32,
	ARM64_INTRIN_VST1_LANE_U64,
	ARM64_INTRIN_VST1Q_LANE_U64,
	ARM64_INTRIN_VST1_LANE_P64,
	ARM64_INTRIN_VST1Q_LANE_P64,
	ARM64_INTRIN_VST1_LANE_F16,
	ARM64_INTRIN_VST1Q_LANE_F16,
	ARM64_INTRIN_VST1_LANE_F32,
	ARM64_INTRIN_VST1Q_LANE_F32,
	ARM64_INTRIN_VST1_LANE_P8,
	ARM64_INTRIN_VST1Q_LANE_P8,
	ARM64_INTRIN_VST1_LANE_P16,
	ARM64_INTRIN_VST1Q_LANE_P16,
	ARM64_INTRIN_VST1_LANE_F64,
	ARM64_INTRIN_VST1Q_LANE_F64,
	ARM64_INTRIN_VLD2_S8,
	ARM64_INTRIN_VLD2Q_S8,
	ARM64_INTRIN_VLD2_S16,
	ARM64_INTRIN_VLD2Q_S16,
	ARM64_INTRIN_VLD2_S32,
	ARM64_INTRIN_VLD2Q_S32,
	ARM64_INTRIN_VLD2_U8,
	ARM64_INTRIN_VLD2Q_U8,
	ARM64_INTRIN_VLD2_U16,
	ARM64_INTRIN_VLD2Q_U16,
	ARM64_INTRIN_VLD2_U32,
	ARM64_INTRIN_VLD2Q_U32,
	ARM64_INTRIN_VLD2_F16,
	ARM64_INTRIN_VLD2Q_F16,
	ARM64_INTRIN_VLD2_F32,
	ARM64_INTRIN_VLD2Q_F32,
	ARM64_INTRIN_VLD2_P8,
	ARM64_INTRIN_VLD2Q_P8,
	ARM64_INTRIN_VLD2_P16,
	ARM64_INTRIN_VLD2Q_P16,
	ARM64_INTRIN_VLD2_S64,
	ARM64_INTRIN_VLD2_U64,
	ARM64_INTRIN_VLD2_P64,
	ARM64_INTRIN_VLD2Q_S64,
	ARM64_INTRIN_VLD2Q_U64,
	ARM64_INTRIN_VLD2Q_P64,
	ARM64_INTRIN_VLD2_F64,
	ARM64_INTRIN_VLD2Q_F64,
	ARM64_INTRIN_VLD3_S8,
	ARM64_INTRIN_VLD3Q_S8,
	ARM64_INTRIN_VLD3_S16,
	ARM64_INTRIN_VLD3Q_S16,
	ARM64_INTRIN_VLD3_S32,
	ARM64_INTRIN_VLD3Q_S32,
	ARM64_INTRIN_VLD3_U8,
	ARM64_INTRIN_VLD3Q_U8,
	ARM64_INTRIN_VLD3_U16,
	ARM64_INTRIN_VLD3Q_U16,
	ARM64_INTRIN_VLD3_U32,
	ARM64_INTRIN_VLD3Q_U32,
	ARM64_INTRIN_VLD3_F16,
	ARM64_INTRIN_VLD3Q_F16,
	ARM64_INTRIN_VLD3_F32,
	ARM64_INTRIN_VLD3Q_F32,
	ARM64_INTRIN_VLD3_P8,
	ARM64_INTRIN_VLD3Q_P8,
	ARM64_INTRIN_VLD3_P16,
	ARM64_INTRIN_VLD3Q_P16,
	ARM64_INTRIN_VLD3_S64,
	ARM64_INTRIN_VLD3_U64,
	ARM64_INTRIN_VLD3_P64,
	ARM64_INTRIN_VLD3Q_S64,
	ARM64_INTRIN_VLD3Q_U64,
	ARM64_INTRIN_VLD3Q_P64,
	ARM64_INTRIN_VLD3_F64,
	ARM64_INTRIN_VLD3Q_F64,
	ARM64_INTRIN_VLD4_S8,
	ARM64_INTRIN_VLD4Q_S8,
	ARM64_INTRIN_VLD4_S16,
	ARM64_INTRIN_VLD4Q_S16,
	ARM64_INTRIN_VLD4_S32,
	ARM64_INTRIN_VLD4Q_S32,
	ARM64_INTRIN_VLD4_U8,
	ARM64_INTRIN_VLD4Q_U8,
	ARM64_INTRIN_VLD4_U16,
	ARM64_INTRIN_VLD4Q_U16,
	ARM64_INTRIN_VLD4_U32,
	ARM64_INTRIN_VLD4Q_U32,
	ARM64_INTRIN_VLD4_F16,
	ARM64_INTRIN_VLD4Q_F16,
	ARM64_INTRIN_VLD4_F32,
	ARM64_INTRIN_VLD4Q_F32,
	ARM64_INTRIN_VLD4_P8,
	ARM64_INTRIN_VLD4Q_P8,
	ARM64_INTRIN_VLD4_P16,
	ARM64_INTRIN_VLD4Q_P16,
	ARM64_INTRIN_VLD4_S64,
	ARM64_INTRIN_VLD4_U64,
	ARM64_INTRIN_VLD4_P64,
	ARM64_INTRIN_VLD4Q_S64,
	ARM64_INTRIN_VLD4Q_U64,
	ARM64_INTRIN_VLD4Q_P64,
	ARM64_INTRIN_VLD4_F64,
	ARM64_INTRIN_VLD4Q_F64,
	ARM64_INTRIN_VLD2_DUP_S8,
	ARM64_INTRIN_VLD2Q_DUP_S8,
	ARM64_INTRIN_VLD2_DUP_S16,
	ARM64_INTRIN_VLD2Q_DUP_S16,
	ARM64_INTRIN_VLD2_DUP_S32,
	ARM64_INTRIN_VLD2Q_DUP_S32,
	ARM64_INTRIN_VLD2_DUP_U8,
	ARM64_INTRIN_VLD2Q_DUP_U8,
	ARM64_INTRIN_VLD2_DUP_U16,
	ARM64_INTRIN_VLD2Q_DUP_U16,
	ARM64_INTRIN_VLD2_DUP_U32,
	ARM64_INTRIN_VLD2Q_DUP_U32,
	ARM64_INTRIN_VLD2_DUP_F16,
	ARM64_INTRIN_VLD2Q_DUP_F16,
	ARM64_INTRIN_VLD2_DUP_F32,
	ARM64_INTRIN_VLD2Q_DUP_F32,
	ARM64_INTRIN_VLD2_DUP_P8,
	ARM64_INTRIN_VLD2Q_DUP_P8,
	ARM64_INTRIN_VLD2_DUP_P16,
	ARM64_INTRIN_VLD2Q_DUP_P16,
	ARM64_INTRIN_VLD2_DUP_S64,
	ARM64_INTRIN_VLD2_DUP_U64,
	ARM64_INTRIN_VLD2_DUP_P64,
	ARM64_INTRIN_VLD2Q_DUP_S64,
	ARM64_INTRIN_VLD2Q_DUP_U64,
	ARM64_INTRIN_VLD2Q_DUP_P64,
	ARM64_INTRIN_VLD2_DUP_F64,
	ARM64_INTRIN_VLD2Q_DUP_F64,
	ARM64_INTRIN_VLD3_DUP_S8,
	ARM64_INTRIN_VLD3Q_DUP_S8,
	ARM64_INTRIN_VLD3_DUP_S16,
	ARM64_INTRIN_VLD3Q_DUP_S16,
	ARM64_INTRIN_VLD3_DUP_S32,
	ARM64_INTRIN_VLD3Q_DUP_S32,
	ARM64_INTRIN_VLD3_DUP_U8,
	ARM64_INTRIN_VLD3Q_DUP_U8,
	ARM64_INTRIN_VLD3_DUP_U16,
	ARM64_INTRIN_VLD3Q_DUP_U16,
	ARM64_INTRIN_VLD3_DUP_U32,
	ARM64_INTRIN_VLD3Q_DUP_U32,
	ARM64_INTRIN_VLD3_DUP_F16,
	ARM64_INTRIN_VLD3Q_DUP_F16,
	ARM64_INTRIN_VLD3_DUP_F32,
	ARM64_INTRIN_VLD3Q_DUP_F32,
	ARM64_INTRIN_VLD3_DUP_P8,
	ARM64_INTRIN_VLD3Q_DUP_P8,
	ARM64_INTRIN_VLD3_DUP_P16,
	ARM64_INTRIN_VLD3Q_DUP_P16,
	ARM64_INTRIN_VLD3_DUP_S64,
	ARM64_INTRIN_VLD3_DUP_U64,
	ARM64_INTRIN_VLD3_DUP_P64,
	ARM64_INTRIN_VLD3Q_DUP_S64,
	ARM64_INTRIN_VLD3Q_DUP_U64,
	ARM64_INTRIN_VLD3Q_DUP_P64,
	ARM64_INTRIN_VLD3_DUP_F64,
	ARM64_INTRIN_VLD3Q_DUP_F64,
	ARM64_INTRIN_VLD4_DUP_S8,
	ARM64_INTRIN_VLD4Q_DUP_S8,
	ARM64_INTRIN_VLD4_DUP_S16,
	ARM64_INTRIN_VLD4Q_DUP_S16,
	ARM64_INTRIN_VLD4_DUP_S32,
	ARM64_INTRIN_VLD4Q_DUP_S32,
	ARM64_INTRIN_VLD4_DUP_U8,
	ARM64_INTRIN_VLD4Q_DUP_U8,
	ARM64_INTRIN_VLD4_DUP_U16,
	ARM64_INTRIN_VLD4Q_DUP_U16,
	ARM64_INTRIN_VLD4_DUP_U32,
	ARM64_INTRIN_VLD4Q_DUP_U32,
	ARM64_INTRIN_VLD4_DUP_F16,
	ARM64_INTRIN_VLD4Q_DUP_F16,
	ARM64_INTRIN_VLD4_DUP_F32,
	ARM64_INTRIN_VLD4Q_DUP_F32,
	ARM64_INTRIN_VLD4_DUP_P8,
	ARM64_INTRIN_VLD4Q_DUP_P8,
	ARM64_INTRIN_VLD4_DUP_P16,
	ARM64_INTRIN_VLD4Q_DUP_P16,
	ARM64_INTRIN_VLD4_DUP_S64,
	ARM64_INTRIN_VLD4_DUP_U64,
	ARM64_INTRIN_VLD4_DUP_P64,
	ARM64_INTRIN_VLD4Q_DUP_S64,
	ARM64_INTRIN_VLD4Q_DUP_U64,
	ARM64_INTRIN_VLD4Q_DUP_P64,
	ARM64_INTRIN_VLD4_DUP_F64,
	ARM64_INTRIN_VLD4Q_DUP_F64,
	ARM64_INTRIN_VST2_S8,
	ARM64_INTRIN_VST2Q_S8,
	ARM64_INTRIN_VST2_S16,
	ARM64_INTRIN_VST2Q_S16,
	ARM64_INTRIN_VST2_S32,
	ARM64_INTRIN_VST2Q_S32,
	ARM64_INTRIN_VST2_U8,
	ARM64_INTRIN_VST2Q_U8,
	ARM64_INTRIN_VST2_U16,
	ARM64_INTRIN_VST2Q_U16,
	ARM64_INTRIN_VST2_U32,
	ARM64_INTRIN_VST2Q_U32,
	ARM64_INTRIN_VST2_F16,
	ARM64_INTRIN_VST2Q_F16,
	ARM64_INTRIN_VST2_F32,
	ARM64_INTRIN_VST2Q_F32,
	ARM64_INTRIN_VST2_P8,
	ARM64_INTRIN_VST2Q_P8,
	ARM64_INTRIN_VST2_P16,
	ARM64_INTRIN_VST2Q_P16,
	ARM64_INTRIN_VST2_S64,
	ARM64_INTRIN_VST2_U64,
	ARM64_INTRIN_VST2_P64,
	ARM64_INTRIN_VST2Q_S64,
	ARM64_INTRIN_VST2Q_U64,
	ARM64_INTRIN_VST2Q_P64,
	ARM64_INTRIN_VST2_F64,
	ARM64_INTRIN_VST2Q_F64,
	ARM64_INTRIN_VST3_S8,
	ARM64_INTRIN_VST3Q_S8,
	ARM64_INTRIN_VST3_S16,
	ARM64_INTRIN_VST3Q_S16,
	ARM64_INTRIN_VST3_S32,
	ARM64_INTRIN_VST3Q_S32,
	ARM64_INTRIN_VST3_U8,
	ARM64_INTRIN_VST3Q_U8,
	ARM64_INTRIN_VST3_U16,
	ARM64_INTRIN_VST3Q_U16,
	ARM64_INTRIN_VST3_U32,
	ARM64_INTRIN_VST3Q_U32,
	ARM64_INTRIN_VST3_F16,
	ARM64_INTRIN_VST3Q_F16,
	ARM64_INTRIN_VST3_F32,
	ARM64_INTRIN_VST3Q_F32,
	ARM64_INTRIN_VST3_P8,
	ARM64_INTRIN_VST3Q_P8,
	ARM64_INTRIN_VST3_P16,
	ARM64_INTRIN_VST3Q_P16,
	ARM64_INTRIN_VST3_S64,
	ARM64_INTRIN_VST3_U64,
	ARM64_INTRIN_VST3_P64,
	ARM64_INTRIN_VST3Q_S64,
	ARM64_INTRIN_VST3Q_U64,
	ARM64_INTRIN_VST3Q_P64,
	ARM64_INTRIN_VST3_F64,
	ARM64_INTRIN_VST3Q_F64,
	ARM64_INTRIN_VST4_S8,
	ARM64_INTRIN_VST4Q_S8,
	ARM64_INTRIN_VST4_S16,
	ARM64_INTRIN_VST4Q_S16,
	ARM64_INTRIN_VST4_S32,
	ARM64_INTRIN_VST4Q_S32,
	ARM64_INTRIN_VST4_U8,
	ARM64_INTRIN_VST4Q_U8,
	ARM64_INTRIN_VST4_U16,
	ARM64_INTRIN_VST4Q_U16,
	ARM64_INTRIN_VST4_U32,
	ARM64_INTRIN_VST4Q_U32,
	ARM64_INTRIN_VST4_F16,
	ARM64_INTRIN_VST4Q_F16,
	ARM64_INTRIN_VST4_F32,
	ARM64_INTRIN_VST4Q_F32,
	ARM64_INTRIN_VST4_P8,
	ARM64_INTRIN_VST4Q_P8,
	ARM64_INTRIN_VST4_P16,
	ARM64_INTRIN_VST4Q_P16,
	ARM64_INTRIN_VST4_S64,
	ARM64_INTRIN_VST4_U64,
	ARM64_INTRIN_VST4_P64,
	ARM64_INTRIN_VST4Q_S64,
	ARM64_INTRIN_VST4Q_U64,
	ARM64_INTRIN_VST4Q_P64,
	ARM64_INTRIN_VST4_F64,
	ARM64_INTRIN_VST4Q_F64,
	ARM64_INTRIN_VLD2_LANE_S16,
	ARM64_INTRIN_VLD2Q_LANE_S16,
	ARM64_INTRIN_VLD2_LANE_S32,
	ARM64_INTRIN_VLD2Q_LANE_S32,
	ARM64_INTRIN_VLD2_LANE_U16,
	ARM64_INTRIN_VLD2Q_LANE_U16,
	ARM64_INTRIN_VLD2_LANE_U32,
	ARM64_INTRIN_VLD2Q_LANE_U32,
	ARM64_INTRIN_VLD2_LANE_F16,
	ARM64_INTRIN_VLD2Q_LANE_F16,
	ARM64_INTRIN_VLD2_LANE_F32,
	ARM64_INTRIN_VLD2Q_LANE_F32,
	ARM64_INTRIN_VLD2_LANE_P16,
	ARM64_INTRIN_VLD2Q_LANE_P16,
	ARM64_INTRIN_VLD2_LANE_S8,
	ARM64_INTRIN_VLD2_LANE_U8,
	ARM64_INTRIN_VLD2_LANE_P8,
	ARM64_INTRIN_VLD2Q_LANE_S8,
	ARM64_INTRIN_VLD2Q_LANE_U8,
	ARM64_INTRIN_VLD2Q_LANE_P8,
	ARM64_INTRIN_VLD2_LANE_S64,
	ARM64_INTRIN_VLD2Q_LANE_S64,
	ARM64_INTRIN_VLD2_LANE_U64,
	ARM64_INTRIN_VLD2Q_LANE_U64,
	ARM64_INTRIN_VLD2_LANE_P64,
	ARM64_INTRIN_VLD2Q_LANE_P64,
	ARM64_INTRIN_VLD2_LANE_F64,
	ARM64_INTRIN_VLD2Q_LANE_F64,
	ARM64_INTRIN_VLD3_LANE_S16,
	ARM64_INTRIN_VLD3Q_LANE_S16,
	ARM64_INTRIN_VLD3_LANE_S32,
	ARM64_INTRIN_VLD3Q_LANE_S32,
	ARM64_INTRIN_VLD3_LANE_U16,
	ARM64_INTRIN_VLD3Q_LANE_U16,
	ARM64_INTRIN_VLD3_LANE_U32,
	ARM64_INTRIN_VLD3Q_LANE_U32,
	ARM64_INTRIN_VLD3_LANE_F16,
	ARM64_INTRIN_VLD3Q_LANE_F16,
	ARM64_INTRIN_VLD3_LANE_F32,
	ARM64_INTRIN_VLD3Q_LANE_F32,
	ARM64_INTRIN_VLD3_LANE_P16,
	ARM64_INTRIN_VLD3Q_LANE_P16,
	ARM64_INTRIN_VLD3_LANE_S8,
	ARM64_INTRIN_VLD3_LANE_U8,
	ARM64_INTRIN_VLD3_LANE_P8,
	ARM64_INTRIN_VLD3Q_LANE_S8,
	ARM64_INTRIN_VLD3Q_LANE_U8,
	ARM64_INTRIN_VLD3Q_LANE_P8,
	ARM64_INTRIN_VLD3_LANE_S64,
	ARM64_INTRIN_VLD3Q_LANE_S64,
	ARM64_INTRIN_VLD3_LANE_U64,
	ARM64_INTRIN_VLD3Q_LANE_U64,
	ARM64_INTRIN_VLD3_LANE_P64,
	ARM64_INTRIN_VLD3Q_LANE_P64,
	ARM64_INTRIN_VLD3_LANE_F64,
	ARM64_INTRIN_VLD3Q_LANE_F64,
	ARM64_INTRIN_VLD4_LANE_S16,
	ARM64_INTRIN_VLD4Q_LANE_S16,
	ARM64_INTRIN_VLD4_LANE_S32,
	ARM64_INTRIN_VLD4Q_LANE_S32,
	ARM64_INTRIN_VLD4_LANE_U16,
	ARM64_INTRIN_VLD4Q_LANE_U16,
	ARM64_INTRIN_VLD4_LANE_U32,
	ARM64_INTRIN_VLD4Q_LANE_U32,
	ARM64_INTRIN_VLD4_LANE_F16,
	ARM64_INTRIN_VLD4Q_LANE_F16,
	ARM64_INTRIN_VLD4_LANE_F32,
	ARM64_INTRIN_VLD4Q_LANE_F32,
	ARM64_INTRIN_VLD4_LANE_P16,
	ARM64_INTRIN_VLD4Q_LANE_P16,
	ARM64_INTRIN_VLD4_LANE_S8,
	ARM64_INTRIN_VLD4_LANE_U8,
	ARM64_INTRIN_VLD4_LANE_P8,
	ARM64_INTRIN_VLD4Q_LANE_S8,
	ARM64_INTRIN_VLD4Q_LANE_U8,
	ARM64_INTRIN_VLD4Q_LANE_P8,
	ARM64_INTRIN_VLD4_LANE_S64,
	ARM64_INTRIN_VLD4Q_LANE_S64,
	ARM64_INTRIN_VLD4_LANE_U64,
	ARM64_INTRIN_VLD4Q_LANE_U64,
	ARM64_INTRIN_VLD4_LANE_P64,
	ARM64_INTRIN_VLD4Q_LANE_P64,
	ARM64_INTRIN_VLD4_LANE_F64,
	ARM64_INTRIN_VLD4Q_LANE_F64,
	ARM64_INTRIN_VST2_LANE_S8,
	ARM64_INTRIN_VST2_LANE_U8,
	ARM64_INTRIN_VST2_LANE_P8,
	ARM64_INTRIN_VST3_LANE_S8,
	ARM64_INTRIN_VST3_LANE_U8,
	ARM64_INTRIN_VST3_LANE_P8,
	ARM64_INTRIN_VST4_LANE_S8,
	ARM64_INTRIN_VST4_LANE_U8,
	ARM64_INTRIN_VST4_LANE_P8,
	ARM64_INTRIN_VST2_LANE_S16,
	ARM64_INTRIN_VST2Q_LANE_S16,
	ARM64_INTRIN_VST2_LANE_S32,
	ARM64_INTRIN_VST2Q_LANE_S32,
	ARM64_INTRIN_VST2_LANE_U16,
	ARM64_INTRIN_VST2Q_LANE_U16,
	ARM64_INTRIN_VST2_LANE_U32,
	ARM64_INTRIN_VST2Q_LANE_U32,
	ARM64_INTRIN_VST2_LANE_F16,
	ARM64_INTRIN_VST2Q_LANE_F16,
	ARM64_INTRIN_VST2_LANE_F32,
	ARM64_INTRIN_VST2Q_LANE_F32,
	ARM64_INTRIN_VST2_LANE_P16,
	ARM64_INTRIN_VST2Q_LANE_P16,
	ARM64_INTRIN_VST2Q_LANE_S8,
	ARM64_INTRIN_VST2Q_LANE_U8,
	ARM64_INTRIN_VST2Q_LANE_P8,
	ARM64_INTRIN_VST2_LANE_S64,
	ARM64_INTRIN_VST2Q_LANE_S64,
	ARM64_INTRIN_VST2_LANE_U64,
	ARM64_INTRIN_VST2Q_LANE_U64,
	ARM64_INTRIN_VST2_LANE_P64,
	ARM64_INTRIN_VST2Q_LANE_P64,
	ARM64_INTRIN_VST2_LANE_F64,
	ARM64_INTRIN_VST2Q_LANE_F64,
	ARM64_INTRIN_VST3_LANE_S16,
	ARM64_INTRIN_VST3Q_LANE_S16,
	ARM64_INTRIN_VST3_LANE_S32,
	ARM64_INTRIN_VST3Q_LANE_S32,
	ARM64_INTRIN_VST3_LANE_U16,
	ARM64_INTRIN_VST3Q_LANE_U16,
	ARM64_INTRIN_VST3_LANE_U32,
	ARM64_INTRIN_VST3Q_LANE_U32,
	ARM64_INTRIN_VST3_LANE_F16,
	ARM64_INTRIN_VST3Q_LANE_F16,
	ARM64_INTRIN_VST3_LANE_F32,
	ARM64_INTRIN_VST3Q_LANE_F32,
	ARM64_INTRIN_VST3_LANE_P16,
	ARM64_INTRIN_VST3Q_LANE_P16,
	ARM64_INTRIN_VST3Q_LANE_S8,
	ARM64_INTRIN_VST3Q_LANE_U8,
	ARM64_INTRIN_VST3Q_LANE_P8,
	ARM64_INTRIN_VST3_LANE_S64,
	ARM64_INTRIN_VST3Q_LANE_S64,
	ARM64_INTRIN_VST3_LANE_U64,
	ARM64_INTRIN_VST3Q_LANE_U64,
	ARM64_INTRIN_VST3_LANE_P64,
	ARM64_INTRIN_VST3Q_LANE_P64,
	ARM64_INTRIN_VST3_LANE_F64,
	ARM64_INTRIN_VST3Q_LANE_F64,
	ARM64_INTRIN_VST4_LANE_S16,
	ARM64_INTRIN_VST4Q_LANE_S16,
	ARM64_INTRIN_VST4_LANE_S32,
	ARM64_INTRIN_VST4Q_LANE_S32,
	ARM64_INTRIN_VST4_LANE_U16,
	ARM64_INTRIN_VST4Q_LANE_U16,
	ARM64_INTRIN_VST4_LANE_U32,
	ARM64_INTRIN_VST4Q_LANE_U32,
	ARM64_INTRIN_VST4_LANE_F16,
	ARM64_INTRIN_VST4Q_LANE_F16,
	ARM64_INTRIN_VST4_LANE_F32,
	ARM64_INTRIN_VST4Q_LANE_F32,
	ARM64_INTRIN_VST4_LANE_P16,
	ARM64_INTRIN_VST4Q_LANE_P16,
	ARM64_INTRIN_VST4Q_LANE_S8,
	ARM64_INTRIN_VST4Q_LANE_U8,
	ARM64_INTRIN_VST4Q_LANE_P8,
	ARM64_INTRIN_VST4_LANE_S64,
	ARM64_INTRIN_VST4Q_LANE_S64,
	ARM64_INTRIN_VST4_LANE_U64,
	ARM64_INTRIN_VST4Q_LANE_U64,
	ARM64_INTRIN_VST4_LANE_P64,
	ARM64_INTRIN_VST4Q_LANE_P64,
	ARM64_INTRIN_VST4_LANE_F64,
	ARM64_INTRIN_VST4Q_LANE_F64,
	ARM64_INTRIN_VST1_S8_X2,
	ARM64_INTRIN_VST1Q_S8_X2,
	ARM64_INTRIN_VST1_S16_X2,
	ARM64_INTRIN_VST1Q_S16_X2,
	ARM64_INTRIN_VST1_S32_X2,
	ARM64_INTRIN_VST1Q_S32_X2,
	ARM64_INTRIN_VST1_U8_X2,
	ARM64_INTRIN_VST1Q_U8_X2,
	ARM64_INTRIN_VST1_U16_X2,
	ARM64_INTRIN_VST1Q_U16_X2,
	ARM64_INTRIN_VST1_U32_X2,
	ARM64_INTRIN_VST1Q_U32_X2,
	ARM64_INTRIN_VST1_F16_X2,
	ARM64_INTRIN_VST1Q_F16_X2,
	ARM64_INTRIN_VST1_F32_X2,
	ARM64_INTRIN_VST1Q_F32_X2,
	ARM64_INTRIN_VST1_P8_X2,
	ARM64_INTRIN_VST1Q_P8_X2,
	ARM64_INTRIN_VST1_P16_X2,
	ARM64_INTRIN_VST1Q_P16_X2,
	ARM64_INTRIN_VST1_S64_X2,
	ARM64_INTRIN_VST1_U64_X2,
	ARM64_INTRIN_VST1_P64_X2,
	ARM64_INTRIN_VST1Q_S64_X2,
	ARM64_INTRIN_VST1Q_U64_X2,
	ARM64_INTRIN_VST1Q_P64_X2,
	ARM64_INTRIN_VST1_F64_X2,
	ARM64_INTRIN_VST1Q_F64_X2,
	ARM64_INTRIN_VST1_S8_X3,
	ARM64_INTRIN_VST1Q_S8_X3,
	ARM64_INTRIN_VST1_S16_X3,
	ARM64_INTRIN_VST1Q_S16_X3,
	ARM64_INTRIN_VST1_S32_X3,
	ARM64_INTRIN_VST1Q_S32_X3,
	ARM64_INTRIN_VST1_U8_X3,
	ARM64_INTRIN_VST1Q_U8_X3,
	ARM64_INTRIN_VST1_U16_X3,
	ARM64_INTRIN_VST1Q_U16_X3,
	ARM64_INTRIN_VST1_U32_X3,
	ARM64_INTRIN_VST1Q_U32_X3,
	ARM64_INTRIN_VST1_F16_X3,
	ARM64_INTRIN_VST1Q_F16_X3,
	ARM64_INTRIN_VST1_F32_X3,
	ARM64_INTRIN_VST1Q_F32_X3,
	ARM64_INTRIN_VST1_P8_X3,
	ARM64_INTRIN_VST1Q_P8_X3,
	ARM64_INTRIN_VST1_P16_X3,
	ARM64_INTRIN_VST1Q_P16_X3,
	ARM64_INTRIN_VST1_S64_X3,
	ARM64_INTRIN_VST1_U64_X3,
	ARM64_INTRIN_VST1_P64_X3,
	ARM64_INTRIN_VST1Q_S64_X3,
	ARM64_INTRIN_VST1Q_U64_X3,
	ARM64_INTRIN_VST1Q_P64_X3,
	ARM64_INTRIN_VST1_F64_X3,
	ARM64_INTRIN_VST1Q_F64_X3,
	ARM64_INTRIN_VST1_S8_X4,
	ARM64_INTRIN_VST1Q_S8_X4,
	ARM64_INTRIN_VST1_S16_X4,
	ARM64_INTRIN_VST1Q_S16_X4,
	ARM64_INTRIN_VST1_S32_X4,
	ARM64_INTRIN_VST1Q_S32_X4,
	ARM64_INTRIN_VST1_U8_X4,
	ARM64_INTRIN_VST1Q_U8_X4,
	ARM64_INTRIN_VST1_U16_X4,
	ARM64_INTRIN_VST1Q_U16_X4,
	ARM64_INTRIN_VST1_U32_X4,
	ARM64_INTRIN_VST1Q_U32_X4,
	ARM64_INTRIN_VST1_F16_X4,
	ARM64_INTRIN_VST1Q_F16_X4,
	ARM64_INTRIN_VST1_F32_X4,
	ARM64_INTRIN_VST1Q_F32_X4,
	ARM64_INTRIN_VST1_P8_X4,
	ARM64_INTRIN_VST1Q_P8_X4,
	ARM64_INTRIN_VST1_P16_X4,
	ARM64_INTRIN_VST1Q_P16_X4,
	ARM64_INTRIN_VST1_S64_X4,
	ARM64_INTRIN_VST1_U64_X4,
	ARM64_INTRIN_VST1_P64_X4,
	ARM64_INTRIN_VST1Q_S64_X4,
	ARM64_INTRIN_VST1Q_U64_X4,
	ARM64_INTRIN_VST1Q_P64_X4,
	ARM64_INTRIN_VST1_F64_X4,
	ARM64_INTRIN_VST1Q_F64_X4,
	ARM64_INTRIN_VLD1_S8_X2,
	ARM64_INTRIN_VLD1Q_S8_X2,
	ARM64_INTRIN_VLD1_S16_X2,
	ARM64_INTRIN_VLD1Q_S16_X2,
	ARM64_INTRIN_VLD1_S32_X2,
	ARM64_INTRIN_VLD1Q_S32_X2,
	ARM64_INTRIN_VLD1_U8_X2,
	ARM64_INTRIN_VLD1Q_U8_X2,
	ARM64_INTRIN_VLD1_U16_X2,
	ARM64_INTRIN_VLD1Q_U16_X2,
	ARM64_INTRIN_VLD1_U32_X2,
	ARM64_INTRIN_VLD1Q_U32_X2,
	ARM64_INTRIN_VLD1_F16_X2,
	ARM64_INTRIN_VLD1Q_F16_X2,
	ARM64_INTRIN_VLD1_F32_X2,
	ARM64_INTRIN_VLD1Q_F32_X2,
	ARM64_INTRIN_VLD1_P8_X2,
	ARM64_INTRIN_VLD1Q_P8_X2,
	ARM64_INTRIN_VLD1_P16_X2,
	ARM64_INTRIN_VLD1Q_P16_X2,
	ARM64_INTRIN_VLD1_S64_X2,
	ARM64_INTRIN_VLD1_U64_X2,
	ARM64_INTRIN_VLD1_P64_X2,
	ARM64_INTRIN_VLD1Q_S64_X2,
	ARM64_INTRIN_VLD1Q_U64_X2,
	ARM64_INTRIN_VLD1Q_P64_X2,
	ARM64_INTRIN_VLD1_F64_X2,
	ARM64_INTRIN_VLD1Q_F64_X2,
	ARM64_INTRIN_VLD1_S8_X3,
	ARM64_INTRIN_VLD1Q_S8_X3,
	ARM64_INTRIN_VLD1_S16_X3,
	ARM64_INTRIN_VLD1Q_S16_X3,
	ARM64_INTRIN_VLD1_S32_X3,
	ARM64_INTRIN_VLD1Q_S32_X3,
	ARM64_INTRIN_VLD1_U8_X3,
	ARM64_INTRIN_VLD1Q_U8_X3,
	ARM64_INTRIN_VLD1_U16_X3,
	ARM64_INTRIN_VLD1Q_U16_X3,
	ARM64_INTRIN_VLD1_U32_X3,
	ARM64_INTRIN_VLD1Q_U32_X3,
	ARM64_INTRIN_VLD1_F16_X3,
	ARM64_INTRIN_VLD1Q_F16_X3,
	ARM64_INTRIN_VLD1_F32_X3,
	ARM64_INTRIN_VLD1Q_F32_X3,
	ARM64_INTRIN_VLD1_P8_X3,
	ARM64_INTRIN_VLD1Q_P8_X3,
	ARM64_INTRIN_VLD1_P16_X3,
	ARM64_INTRIN_VLD1Q_P16_X3,
	ARM64_INTRIN_VLD1_S64_X3,
	ARM64_INTRIN_VLD1_U64_X3,
	ARM64_INTRIN_VLD1_P64_X3,
	ARM64_INTRIN_VLD1Q_S64_X3,
	ARM64_INTRIN_VLD1Q_U64_X3,
	ARM64_INTRIN_VLD1Q_P64_X3,
	ARM64_INTRIN_VLD1_F64_X3,
	ARM64_INTRIN_VLD1Q_F64_X3,
	ARM64_INTRIN_VLD1_S8_X4,
	ARM64_INTRIN_VLD1Q_S8_X4,
	ARM64_INTRIN_VLD1_S16_X4,
	ARM64_INTRIN_VLD1Q_S16_X4,
	ARM64_INTRIN_VLD1_S32_X4,
	ARM64_INTRIN_VLD1Q_S32_X4,
	ARM64_INTRIN_VLD1_U8_X4,
	ARM64_INTRIN_VLD1Q_U8_X4,
	ARM64_INTRIN_VLD1_U16_X4,
	ARM64_INTRIN_VLD1Q_U16_X4,
	ARM64_INTRIN_VLD1_U32_X4,
	ARM64_INTRIN_VLD1Q_U32_X4,
	ARM64_INTRIN_VLD1_F16_X4,
	ARM64_INTRIN_VLD1Q_F16_X4,
	ARM64_INTRIN_VLD1_F32_X4,
	ARM64_INTRIN_VLD1Q_F32_X4,
	ARM64_INTRIN_VLD1_P8_X4,
	ARM64_INTRIN_VLD1Q_P8_X4,
	ARM64_INTRIN_VLD1_P16_X4,
	ARM64_INTRIN_VLD1Q_P16_X4,
	ARM64_INTRIN_VLD1_S64_X4,
	ARM64_INTRIN_VLD1_U64_X4,
	ARM64_INTRIN_VLD1_P64_X4,
	ARM64_INTRIN_VLD1Q_S64_X4,
	ARM64_INTRIN_VLD1Q_U64_X4,
	ARM64_INTRIN_VLD1Q_P64_X4,
	ARM64_INTRIN_VLD1_F64_X4,
	ARM64_INTRIN_VLD1Q_F64_X4,
	ARM64_INTRIN_VPADD_S8,
	ARM64_INTRIN_VPADD_S16,
	ARM64_INTRIN_VPADD_S32,
	ARM64_INTRIN_VPADD_U8,
	ARM64_INTRIN_VPADD_U16,
	ARM64_INTRIN_VPADD_U32,
	ARM64_INTRIN_VPADD_F32,
	ARM64_INTRIN_VPADDQ_S8,
	ARM64_INTRIN_VPADDQ_S16,
	ARM64_INTRIN_VPADDQ_S32,
	ARM64_INTRIN_VPADDQ_S64,
	ARM64_INTRIN_VPADDQ_U8,
	ARM64_INTRIN_VPADDQ_U16,
	ARM64_INTRIN_VPADDQ_U32,
	ARM64_INTRIN_VPADDQ_U64,
	ARM64_INTRIN_VPADDQ_F32,
	ARM64_INTRIN_VPADDQ_F64,
	ARM64_INTRIN_VPADDL_S8,
	ARM64_INTRIN_VPADDLQ_S8,
	ARM64_INTRIN_VPADDL_S16,
	ARM64_INTRIN_VPADDLQ_S16,
	ARM64_INTRIN_VPADDL_S32,
	ARM64_INTRIN_VPADDLQ_S32,
	ARM64_INTRIN_VPADDL_U8,
	ARM64_INTRIN_VPADDLQ_U8,
	ARM64_INTRIN_VPADDL_U16,
	ARM64_INTRIN_VPADDLQ_U16,
	ARM64_INTRIN_VPADDL_U32,
	ARM64_INTRIN_VPADDLQ_U32,
	ARM64_INTRIN_VPADAL_S8,
	ARM64_INTRIN_VPADALQ_S8,
	ARM64_INTRIN_VPADAL_S16,
	ARM64_INTRIN_VPADALQ_S16,
	ARM64_INTRIN_VPADAL_S32,
	ARM64_INTRIN_VPADALQ_S32,
	ARM64_INTRIN_VPADAL_U8,
	ARM64_INTRIN_VPADALQ_U8,
	ARM64_INTRIN_VPADAL_U16,
	ARM64_INTRIN_VPADALQ_U16,
	ARM64_INTRIN_VPADAL_U32,
	ARM64_INTRIN_VPADALQ_U32,
	ARM64_INTRIN_VPMAX_S8,
	ARM64_INTRIN_VPMAX_S16,
	ARM64_INTRIN_VPMAX_S32,
	ARM64_INTRIN_VPMAX_U8,
	ARM64_INTRIN_VPMAX_U16,
	ARM64_INTRIN_VPMAX_U32,
	ARM64_INTRIN_VPMAX_F32,
	ARM64_INTRIN_VPMAXQ_S8,
	ARM64_INTRIN_VPMAXQ_S16,
	ARM64_INTRIN_VPMAXQ_S32,
	ARM64_INTRIN_VPMAXQ_U8,
	ARM64_INTRIN_VPMAXQ_U16,
	ARM64_INTRIN_VPMAXQ_U32,
	ARM64_INTRIN_VPMAXQ_F32,
	ARM64_INTRIN_VPMAXQ_F64,
	ARM64_INTRIN_VPMIN_S8,
	ARM64_INTRIN_VPMIN_S16,
	ARM64_INTRIN_VPMIN_S32,
	ARM64_INTRIN_VPMIN_U8,
	ARM64_INTRIN_VPMIN_U16,
	ARM64_INTRIN_VPMIN_U32,
	ARM64_INTRIN_VPMIN_F32,
	ARM64_INTRIN_VPMINQ_S8,
	ARM64_INTRIN_VPMINQ_S16,
	ARM64_INTRIN_VPMINQ_S32,
	ARM64_INTRIN_VPMINQ_U8,
	ARM64_INTRIN_VPMINQ_U16,
	ARM64_INTRIN_VPMINQ_U32,
	ARM64_INTRIN_VPMINQ_F32,
	ARM64_INTRIN_VPMINQ_F64,
	ARM64_INTRIN_VPMAXNM_F32,
	ARM64_INTRIN_VPMAXNMQ_F32,
	ARM64_INTRIN_VPMAXNMQ_F64,
	ARM64_INTRIN_VPMINNM_F32,
	ARM64_INTRIN_VPMINNMQ_F32,
	ARM64_INTRIN_VPMINNMQ_F64,
	ARM64_INTRIN_VPADDD_S64,
	ARM64_INTRIN_VPADDD_U64,
	ARM64_INTRIN_VPADDS_F32,
	ARM64_INTRIN_VPADDD_F64,
	ARM64_INTRIN_VPMAXS_F32,
	ARM64_INTRIN_VPMAXQD_F64,
	ARM64_INTRIN_VPMINS_F32,
	ARM64_INTRIN_VPMINQD_F64,
	ARM64_INTRIN_VPMAXNMS_F32,
	ARM64_INTRIN_VPMAXNMQD_F64,
	ARM64_INTRIN_VPMINNMS_F32,
	ARM64_INTRIN_VPMINNMQD_F64,
	ARM64_INTRIN_VADDV_S8,
	ARM64_INTRIN_VADDVQ_S8,
	ARM64_INTRIN_VADDV_S16,
	ARM64_INTRIN_VADDVQ_S16,
	ARM64_INTRIN_VADDV_S32,
	ARM64_INTRIN_VADDVQ_S32,
	ARM64_INTRIN_VADDVQ_S64,
	ARM64_INTRIN_VADDV_U8,
	ARM64_INTRIN_VADDVQ_U8,
	ARM64_INTRIN_VADDV_U16,
	ARM64_INTRIN_VADDVQ_U16,
	ARM64_INTRIN_VADDV_U32,
	ARM64_INTRIN_VADDVQ_U32,
	ARM64_INTRIN_VADDVQ_U64,
	ARM64_INTRIN_VADDV_F32,
	ARM64_INTRIN_VADDVQ_F32,
	ARM64_INTRIN_VADDVQ_F64,
	ARM64_INTRIN_VADDLV_S8,
	ARM64_INTRIN_VADDLVQ_S8,
	ARM64_INTRIN_VADDLV_S16,
	ARM64_INTRIN_VADDLVQ_S16,
	ARM64_INTRIN_VADDLV_S32,
	ARM64_INTRIN_VADDLVQ_S32,
	ARM64_INTRIN_VADDLV_U8,
	ARM64_INTRIN_VADDLVQ_U8,
	ARM64_INTRIN_VADDLV_U16,
	ARM64_INTRIN_VADDLVQ_U16,
	ARM64_INTRIN_VADDLV_U32,
	ARM64_INTRIN_VADDLVQ_U32,
	ARM64_INTRIN_VMAXV_S8,
	ARM64_INTRIN_VMAXVQ_S8,
	ARM64_INTRIN_VMAXV_S16,
	ARM64_INTRIN_VMAXVQ_S16,
	ARM64_INTRIN_VMAXV_S32,
	ARM64_INTRIN_VMAXVQ_S32,
	ARM64_INTRIN_VMAXV_U8,
	ARM64_INTRIN_VMAXVQ_U8,
	ARM64_INTRIN_VMAXV_U16,
	ARM64_INTRIN_VMAXVQ_U16,
	ARM64_INTRIN_VMAXV_U32,
	ARM64_INTRIN_VMAXVQ_U32,
	ARM64_INTRIN_VMAXV_F32,
	ARM64_INTRIN_VMAXVQ_F32,
	ARM64_INTRIN_VMAXVQ_F64,
	ARM64_INTRIN_VMINV_S8,
	ARM64_INTRIN_VMINVQ_S8,
	ARM64_INTRIN_VMINV_S16,
	ARM64_INTRIN_VMINVQ_S16,
	ARM64_INTRIN_VMINV_S32,
	ARM64_INTRIN_VMINVQ_S32,
	ARM64_INTRIN_VMINV_U8,
	ARM64_INTRIN_VMINVQ_U8,
	ARM64_INTRIN_VMINV_U16,
	ARM64_INTRIN_VMINVQ_U16,
	ARM64_INTRIN_VMINV_U32,
	ARM64_INTRIN_VMINVQ_U32,
	ARM64_INTRIN_VMINV_F32,
	ARM64_INTRIN_VMINVQ_F32,
	ARM64_INTRIN_VMINVQ_F64,
	ARM64_INTRIN_VMAXNMV_F32,
	ARM64_INTRIN_VMAXNMVQ_F32,
	ARM64_INTRIN_VMAXNMVQ_F64,
	ARM64_INTRIN_VMINNMV_F32,
	ARM64_INTRIN_VMINNMVQ_F32,
	ARM64_INTRIN_VMINNMVQ_F64,
	ARM64_INTRIN_VEXT_S8,
	ARM64_INTRIN_VEXTQ_S8,
	ARM64_INTRIN_VEXT_S16,
	ARM64_INTRIN_VEXTQ_S16,
	ARM64_INTRIN_VEXT_S32,
	ARM64_INTRIN_VEXTQ_S32,
	ARM64_INTRIN_VEXT_S64,
	ARM64_INTRIN_VEXTQ_S64,
	ARM64_INTRIN_VEXT_U8,
	ARM64_INTRIN_VEXTQ_U8,
	ARM64_INTRIN_VEXT_U16,
	ARM64_INTRIN_VEXTQ_U16,
	ARM64_INTRIN_VEXT_U32,
	ARM64_INTRIN_VEXTQ_U32,
	ARM64_INTRIN_VEXT_U64,
	ARM64_INTRIN_VEXTQ_U64,
	ARM64_INTRIN_VEXT_P64,
	ARM64_INTRIN_VEXTQ_P64,
	ARM64_INTRIN_VEXT_F32,
	ARM64_INTRIN_VEXTQ_F32,
	ARM64_INTRIN_VEXT_F64,
	ARM64_INTRIN_VEXTQ_F64,
	ARM64_INTRIN_VEXT_P8,
	ARM64_INTRIN_VEXTQ_P8,
	ARM64_INTRIN_VEXT_P16,
	ARM64_INTRIN_VEXTQ_P16,
	ARM64_INTRIN_VREV64_S8,
	ARM64_INTRIN_VREV64Q_S8,
	ARM64_INTRIN_VREV64_S16,
	ARM64_INTRIN_VREV64Q_S16,
	ARM64_INTRIN_VREV64_S32,
	ARM64_INTRIN_VREV64Q_S32,
	ARM64_INTRIN_VREV64_U8,
	ARM64_INTRIN_VREV64Q_U8,
	ARM64_INTRIN_VREV64_U16,
	ARM64_INTRIN_VREV64Q_U16,
	ARM64_INTRIN_VREV64_U32,
	ARM64_INTRIN_VREV64Q_U32,
	ARM64_INTRIN_VREV64_F32,
	ARM64_INTRIN_VREV64Q_F32,
	ARM64_INTRIN_VREV64_P8,
	ARM64_INTRIN_VREV64Q_P8,
	ARM64_INTRIN_VREV64_P16,
	ARM64_INTRIN_VREV64Q_P16,
	ARM64_INTRIN_VREV32_S8,
	ARM64_INTRIN_VREV32Q_S8,
	ARM64_INTRIN_VREV32_S16,
	ARM64_INTRIN_VREV32Q_S16,
	ARM64_INTRIN_VREV32_U8,
	ARM64_INTRIN_VREV32Q_U8,
	ARM64_INTRIN_VREV32_U16,
	ARM64_INTRIN_VREV32Q_U16,
	ARM64_INTRIN_VREV32_P8,
	ARM64_INTRIN_VREV32Q_P8,
	ARM64_INTRIN_VREV32_P16,
	ARM64_INTRIN_VREV32Q_P16,
	ARM64_INTRIN_VREV16_S8,
	ARM64_INTRIN_VREV16Q_S8,
	ARM64_INTRIN_VREV16_U8,
	ARM64_INTRIN_VREV16Q_U8,
	ARM64_INTRIN_VREV16_P8,
	ARM64_INTRIN_VREV16Q_P8,
	ARM64_INTRIN_VZIP1_S8,
	ARM64_INTRIN_VZIP1Q_S8,
	ARM64_INTRIN_VZIP1_S16,
	ARM64_INTRIN_VZIP1Q_S16,
	ARM64_INTRIN_VZIP1_S32,
	ARM64_INTRIN_VZIP1Q_S32,
	ARM64_INTRIN_VZIP1Q_S64,
	ARM64_INTRIN_VZIP1_U8,
	ARM64_INTRIN_VZIP1Q_U8,
	ARM64_INTRIN_VZIP1_U16,
	ARM64_INTRIN_VZIP1Q_U16,
	ARM64_INTRIN_VZIP1_U32,
	ARM64_INTRIN_VZIP1Q_U32,
	ARM64_INTRIN_VZIP1Q_U64,
	ARM64_INTRIN_VZIP1Q_P64,
	ARM64_INTRIN_VZIP1_F32,
	ARM64_INTRIN_VZIP1Q_F32,
	ARM64_INTRIN_VZIP1Q_F64,
	ARM64_INTRIN_VZIP1_P8,
	ARM64_INTRIN_VZIP1Q_P8,
	ARM64_INTRIN_VZIP1_P16,
	ARM64_INTRIN_VZIP1Q_P16,
	ARM64_INTRIN_VZIP2_S8,
	ARM64_INTRIN_VZIP2Q_S8,
	ARM64_INTRIN_VZIP2_S16,
	ARM64_INTRIN_VZIP2Q_S16,
	ARM64_INTRIN_VZIP2_S32,
	ARM64_INTRIN_VZIP2Q_S32,
	ARM64_INTRIN_VZIP2Q_S64,
	ARM64_INTRIN_VZIP2_U8,
	ARM64_INTRIN_VZIP2Q_U8,
	ARM64_INTRIN_VZIP2_U16,
	ARM64_INTRIN_VZIP2Q_U16,
	ARM64_INTRIN_VZIP2_U32,
	ARM64_INTRIN_VZIP2Q_U32,
	ARM64_INTRIN_VZIP2Q_U64,
	ARM64_INTRIN_VZIP2Q_P64,
	ARM64_INTRIN_VZIP2_F32,
	ARM64_INTRIN_VZIP2Q_F32,
	ARM64_INTRIN_VZIP2Q_F64,
	ARM64_INTRIN_VZIP2_P8,
	ARM64_INTRIN_VZIP2Q_P8,
	ARM64_INTRIN_VZIP2_P16,
	ARM64_INTRIN_VZIP2Q_P16,
	ARM64_INTRIN_VUZP1_S8,
	ARM64_INTRIN_VUZP1Q_S8,
	ARM64_INTRIN_VUZP1_S16,
	ARM64_INTRIN_VUZP1Q_S16,
	ARM64_INTRIN_VUZP1_S32,
	ARM64_INTRIN_VUZP1Q_S32,
	ARM64_INTRIN_VUZP1Q_S64,
	ARM64_INTRIN_VUZP1_U8,
	ARM64_INTRIN_VUZP1Q_U8,
	ARM64_INTRIN_VUZP1_U16,
	ARM64_INTRIN_VUZP1Q_U16,
	ARM64_INTRIN_VUZP1_U32,
	ARM64_INTRIN_VUZP1Q_U32,
	ARM64_INTRIN_VUZP1Q_U64,
	ARM64_INTRIN_VUZP1Q_P64,
	ARM64_INTRIN_VUZP1_F32,
	ARM64_INTRIN_VUZP1Q_F32,
	ARM64_INTRIN_VUZP1Q_F64,
	ARM64_INTRIN_VUZP1_P8,
	ARM64_INTRIN_VUZP1Q_P8,
	ARM64_INTRIN_VUZP1_P16,
	ARM64_INTRIN_VUZP1Q_P16,
	ARM64_INTRIN_VUZP2_S8,
	ARM64_INTRIN_VUZP2Q_S8,
	ARM64_INTRIN_VUZP2_S16,
	ARM64_INTRIN_VUZP2Q_S16,
	ARM64_INTRIN_VUZP2_S32,
	ARM64_INTRIN_VUZP2Q_S32,
	ARM64_INTRIN_VUZP2Q_S64,
	ARM64_INTRIN_VUZP2_U8,
	ARM64_INTRIN_VUZP2Q_U8,
	ARM64_INTRIN_VUZP2_U16,
	ARM64_INTRIN_VUZP2Q_U16,
	ARM64_INTRIN_VUZP2_U32,
	ARM64_INTRIN_VUZP2Q_U32,
	ARM64_INTRIN_VUZP2Q_U64,
	ARM64_INTRIN_VUZP2Q_P64,
	ARM64_INTRIN_VUZP2_F32,
	ARM64_INTRIN_VUZP2Q_F32,
	ARM64_INTRIN_VUZP2Q_F64,
	ARM64_INTRIN_VUZP2_P8,
	ARM64_INTRIN_VUZP2Q_P8,
	ARM64_INTRIN_VUZP2_P16,
	ARM64_INTRIN_VUZP2Q_P16,
	ARM64_INTRIN_VTRN1_S8,
	ARM64_INTRIN_VTRN1Q_S8,
	ARM64_INTRIN_VTRN1_S16,
	ARM64_INTRIN_VTRN1Q_S16,
	ARM64_INTRIN_VTRN1_S32,
	ARM64_INTRIN_VTRN1Q_S32,
	ARM64_INTRIN_VTRN1Q_S64,
	ARM64_INTRIN_VTRN1_U8,
	ARM64_INTRIN_VTRN1Q_U8,
	ARM64_INTRIN_VTRN1_U16,
	ARM64_INTRIN_VTRN1Q_U16,
	ARM64_INTRIN_VTRN1_U32,
	ARM64_INTRIN_VTRN1Q_U32,
	ARM64_INTRIN_VTRN1Q_U64,
	ARM64_INTRIN_VTRN1Q_P64,
	ARM64_INTRIN_VTRN1_F32,
	ARM64_INTRIN_VTRN1Q_F32,
	ARM64_INTRIN_VTRN1Q_F64,
	ARM64_INTRIN_VTRN1_P8,
	ARM64_INTRIN_VTRN1Q_P8,
	ARM64_INTRIN_VTRN1_P16,
	ARM64_INTRIN_VTRN1Q_P16,
	ARM64_INTRIN_VTRN2_S8,
	ARM64_INTRIN_VTRN2Q_S8,
	ARM64_INTRIN_VTRN2_S16,
	ARM64_INTRIN_VTRN2Q_S16,
	ARM64_INTRIN_VTRN2_S32,
	ARM64_INTRIN_VTRN2Q_S32,
	ARM64_INTRIN_VTRN2Q_S64,
	ARM64_INTRIN_VTRN2_U8,
	ARM64_INTRIN_VTRN2Q_U8,
	ARM64_INTRIN_VTRN2_U16,
	ARM64_INTRIN_VTRN2Q_U16,
	ARM64_INTRIN_VTRN2_U32,
	ARM64_INTRIN_VTRN2Q_U32,
	ARM64_INTRIN_VTRN2Q_U64,
	ARM64_INTRIN_VTRN2Q_P64,
	ARM64_INTRIN_VTRN2_F32,
	ARM64_INTRIN_VTRN2Q_F32,
	ARM64_INTRIN_VTRN2Q_F64,
	ARM64_INTRIN_VTRN2_P8,
	ARM64_INTRIN_VTRN2Q_P8,
	ARM64_INTRIN_VTRN2_P16,
	ARM64_INTRIN_VTRN2Q_P16,
	ARM64_INTRIN_VTBL1_S8,
	ARM64_INTRIN_VTBL1_U8,
	ARM64_INTRIN_VTBL1_P8,
	ARM64_INTRIN_VTBX1_S8,
	ARM64_INTRIN_VTBX1_U8,
	ARM64_INTRIN_VTBX1_P8,
	ARM64_INTRIN_VTBL2_S8,
	ARM64_INTRIN_VTBL2_U8,
	ARM64_INTRIN_VTBL2_P8,
	ARM64_INTRIN_VTBL3_S8,
	ARM64_INTRIN_VTBL3_U8,
	ARM64_INTRIN_VTBL3_P8,
	ARM64_INTRIN_VTBL4_S8,
	ARM64_INTRIN_VTBL4_U8,
	ARM64_INTRIN_VTBL4_P8,
	ARM64_INTRIN_VTBX2_S8,
	ARM64_INTRIN_VTBX2_U8,
	ARM64_INTRIN_VTBX2_P8,
	ARM64_INTRIN_VTBX3_S8,
	ARM64_INTRIN_VTBX3_U8,
	ARM64_INTRIN_VTBX3_P8,
	ARM64_INTRIN_VTBX4_S8,
	ARM64_INTRIN_VTBX4_U8,
	ARM64_INTRIN_VTBX4_P8,
	ARM64_INTRIN_VQTBL1_S8,
	ARM64_INTRIN_VQTBL1Q_S8,
	ARM64_INTRIN_VQTBL1_U8,
	ARM64_INTRIN_VQTBL1Q_U8,
	ARM64_INTRIN_VQTBL1_P8,
	ARM64_INTRIN_VQTBL1Q_P8,
	ARM64_INTRIN_VQTBX1_S8,
	ARM64_INTRIN_VQTBX1Q_S8,
	ARM64_INTRIN_VQTBX1_U8,
	ARM64_INTRIN_VQTBX1Q_U8,
	ARM64_INTRIN_VQTBX1_P8,
	ARM64_INTRIN_VQTBX1Q_P8,
	ARM64_INTRIN_VQTBL2_S8,
	ARM64_INTRIN_VQTBL2Q_S8,
	ARM64_INTRIN_VQTBL2_U8,
	ARM64_INTRIN_VQTBL2Q_U8,
	ARM64_INTRIN_VQTBL2_P8,
	ARM64_INTRIN_VQTBL2Q_P8,
	ARM64_INTRIN_VQTBL3_S8,
	ARM64_INTRIN_VQTBL3Q_S8,
	ARM64_INTRIN_VQTBL3_U8,
	ARM64_INTRIN_VQTBL3Q_U8,
	ARM64_INTRIN_VQTBL3_P8,
	ARM64_INTRIN_VQTBL3Q_P8,
	ARM64_INTRIN_VQTBL4_S8,
	ARM64_INTRIN_VQTBL4Q_S8,
	ARM64_INTRIN_VQTBL4_U8,
	ARM64_INTRIN_VQTBL4Q_U8,
	ARM64_INTRIN_VQTBL4_P8,
	ARM64_INTRIN_VQTBL4Q_P8,
	ARM64_INTRIN_VQTBX2_S8,
	ARM64_INTRIN_VQTBX2Q_S8,
	ARM64_INTRIN_VQTBX2_U8,
	ARM64_INTRIN_VQTBX2Q_U8,
	ARM64_INTRIN_VQTBX2_P8,
	ARM64_INTRIN_VQTBX2Q_P8,
	ARM64_INTRIN_VQTBX3_S8,
	ARM64_INTRIN_VQTBX3Q_S8,
	ARM64_INTRIN_VQTBX3_U8,
	ARM64_INTRIN_VQTBX3Q_U8,
	ARM64_INTRIN_VQTBX3_P8,
	ARM64_INTRIN_VQTBX3Q_P8,
	ARM64_INTRIN_VQTBX4_S8,
	ARM64_INTRIN_VQTBX4Q_S8,
	ARM64_INTRIN_VQTBX4_U8,
	ARM64_INTRIN_VQTBX4Q_U8,
	ARM64_INTRIN_VQTBX4_P8,
	ARM64_INTRIN_VQTBX4Q_P8,
	ARM64_INTRIN_VGET_LANE_U8,
	ARM64_INTRIN_VGET_LANE_U16,
	ARM64_INTRIN_VGET_LANE_U32,
	ARM64_INTRIN_VGET_LANE_U64,
	ARM64_INTRIN_VGET_LANE_P64,
	ARM64_INTRIN_VGET_LANE_S8,
	ARM64_INTRIN_VGET_LANE_S16,
	ARM64_INTRIN_VGET_LANE_S32,
	ARM64_INTRIN_VGET_LANE_S64,
	ARM64_INTRIN_VGET_LANE_P8,
	ARM64_INTRIN_VGET_LANE_P16,
	ARM64_INTRIN_VGET_LANE_F32,
	ARM64_INTRIN_VGET_LANE_F64,
	ARM64_INTRIN_VGETQ_LANE_U8,
	ARM64_INTRIN_VGETQ_LANE_U16,
	ARM64_INTRIN_VGETQ_LANE_U32,
	ARM64_INTRIN_VGETQ_LANE_U64,
	ARM64_INTRIN_VGETQ_LANE_P64,
	ARM64_INTRIN_VGETQ_LANE_S8,
	ARM64_INTRIN_VGETQ_LANE_S16,
	ARM64_INTRIN_VGETQ_LANE_S32,
	ARM64_INTRIN_VGETQ_LANE_S64,
	ARM64_INTRIN_VGETQ_LANE_P8,
	ARM64_INTRIN_VGETQ_LANE_P16,
	ARM64_INTRIN_VGET_LANE_F16,
	ARM64_INTRIN_VGETQ_LANE_F16,
	ARM64_INTRIN_VGETQ_LANE_F32,
	ARM64_INTRIN_VGETQ_LANE_F64,
	ARM64_INTRIN_VSET_LANE_U8,
	ARM64_INTRIN_VSET_LANE_U16,
	ARM64_INTRIN_VSET_LANE_U32,
	ARM64_INTRIN_VSET_LANE_U64,
	ARM64_INTRIN_VSET_LANE_P64,
	ARM64_INTRIN_VSET_LANE_S8,
	ARM64_INTRIN_VSET_LANE_S16,
	ARM64_INTRIN_VSET_LANE_S32,
	ARM64_INTRIN_VSET_LANE_S64,
	ARM64_INTRIN_VSET_LANE_P8,
	ARM64_INTRIN_VSET_LANE_P16,
	ARM64_INTRIN_VSET_LANE_F16,
	ARM64_INTRIN_VSETQ_LANE_F16,
	ARM64_INTRIN_VSET_LANE_F32,
	ARM64_INTRIN_VSET_LANE_F64,
	ARM64_INTRIN_VSETQ_LANE_U8,
	ARM64_INTRIN_VSETQ_LANE_U16,
	ARM64_INTRIN_VSETQ_LANE_U32,
	ARM64_INTRIN_VSETQ_LANE_U64,
	ARM64_INTRIN_VSETQ_LANE_P64,
	ARM64_INTRIN_VSETQ_LANE_S8,
	ARM64_INTRIN_VSETQ_LANE_S16,
	ARM64_INTRIN_VSETQ_LANE_S32,
	ARM64_INTRIN_VSETQ_LANE_S64,
	ARM64_INTRIN_VSETQ_LANE_P8,
	ARM64_INTRIN_VSETQ_LANE_P16,
	ARM64_INTRIN_VSETQ_LANE_F32,
	ARM64_INTRIN_VSETQ_LANE_F64,
	ARM64_INTRIN_VRECPXS_F32,
	ARM64_INTRIN_VRECPXD_F64,
	ARM64_INTRIN_VFMA_N_F32,
	ARM64_INTRIN_VFMAQ_N_F32,
	ARM64_INTRIN_VFMS_N_F32,
	ARM64_INTRIN_VFMSQ_N_F32,
	ARM64_INTRIN_VFMA_N_F64,
	ARM64_INTRIN_VFMAQ_N_F64,
	ARM64_INTRIN_VFMS_N_F64,
	ARM64_INTRIN_VFMSQ_N_F64,
	ARM64_INTRIN_VTRN_S8,
	ARM64_INTRIN_VTRN_S16,
	ARM64_INTRIN_VTRN_U8,
	ARM64_INTRIN_VTRN_U16,
	ARM64_INTRIN_VTRN_P8,
	ARM64_INTRIN_VTRN_P16,
	ARM64_INTRIN_VTRN_S32,
	ARM64_INTRIN_VTRN_F32,
	ARM64_INTRIN_VTRN_U32,
	ARM64_INTRIN_VTRNQ_S8,
	ARM64_INTRIN_VTRNQ_S16,
	ARM64_INTRIN_VTRNQ_S32,
	ARM64_INTRIN_VTRNQ_F32,
	ARM64_INTRIN_VTRNQ_U8,
	ARM64_INTRIN_VTRNQ_U16,
	ARM64_INTRIN_VTRNQ_U32,
	ARM64_INTRIN_VTRNQ_P8,
	ARM64_INTRIN_VTRNQ_P16,
	ARM64_INTRIN_VZIP_S8,
	ARM64_INTRIN_VZIP_S16,
	ARM64_INTRIN_VZIP_U8,
	ARM64_INTRIN_VZIP_U16,
	ARM64_INTRIN_VZIP_P8,
	ARM64_INTRIN_VZIP_P16,
	ARM64_INTRIN_VZIP_S32,
	ARM64_INTRIN_VZIP_F32,
	ARM64_INTRIN_VZIP_U32,
	ARM64_INTRIN_VZIPQ_S8,
	ARM64_INTRIN_VZIPQ_S16,
	ARM64_INTRIN_VZIPQ_S32,
	ARM64_INTRIN_VZIPQ_F32,
	ARM64_INTRIN_VZIPQ_U8,
	ARM64_INTRIN_VZIPQ_U16,
	ARM64_INTRIN_VZIPQ_U32,
	ARM64_INTRIN_VZIPQ_P8,
	ARM64_INTRIN_VZIPQ_P16,
	ARM64_INTRIN_VUZP_S8,
	ARM64_INTRIN_VUZP_S16,
	ARM64_INTRIN_VUZP_S32,
	ARM64_INTRIN_VUZP_F32,
	ARM64_INTRIN_VUZP_U8,
	ARM64_INTRIN_VUZP_U16,
	ARM64_INTRIN_VUZP_U32,
	ARM64_INTRIN_VUZP_P8,
	ARM64_INTRIN_VUZP_P16,
	ARM64_INTRIN_VUZPQ_S8,
	ARM64_INTRIN_VUZPQ_S16,
	ARM64_INTRIN_VUZPQ_S32,
	ARM64_INTRIN_VUZPQ_F32,
	ARM64_INTRIN_VUZPQ_U8,
	ARM64_INTRIN_VUZPQ_U16,
	ARM64_INTRIN_VUZPQ_U32,
	ARM64_INTRIN_VUZPQ_P8,
	ARM64_INTRIN_VUZPQ_P16,
	ARM64_INTRIN_VLDRQ_P128,
	ARM64_INTRIN_VSTRQ_P128,
	ARM64_INTRIN_VAESEQ_U8,
	ARM64_INTRIN_VAESDQ_U8,
	ARM64_INTRIN_VAESMCQ_U8,
	ARM64_INTRIN_VAESIMCQ_U8,
	ARM64_INTRIN_VSHA1CQ_U32,
	ARM64_INTRIN_VSHA1PQ_U32,
	ARM64_INTRIN_VSHA1MQ_U32,
	ARM64_INTRIN_VSHA1H_U32,
	ARM64_INTRIN_VSHA1SU0Q_U32,
	ARM64_INTRIN_VSHA1SU1Q_U32,
	ARM64_INTRIN_VSHA256HQ_U32,
	ARM64_INTRIN_VSHA256H2Q_U32,
	ARM64_INTRIN_VSHA256SU0Q_U32,
	ARM64_INTRIN_VSHA256SU1Q_U32,
	ARM64_INTRIN_VMULL_P64,
	ARM64_INTRIN_VMULL_HIGH_P64,
	ARM64_INTRIN_VADD_P8,
	ARM64_INTRIN_VADD_P16,
	ARM64_INTRIN_VADD_P64,
	ARM64_INTRIN_VADDQ_P8,
	ARM64_INTRIN_VADDQ_P16,
	ARM64_INTRIN_VADDQ_P64,
	ARM64_INTRIN_VADDQ_P128,
	ARM64_INTRIN___CRC32B,
	ARM64_INTRIN___CRC32H,
	ARM64_INTRIN___CRC32W,
	ARM64_INTRIN___CRC32D,
	ARM64_INTRIN___CRC32CB,
	ARM64_INTRIN___CRC32CH,
	ARM64_INTRIN___CRC32CW,
	ARM64_INTRIN___CRC32CD,
	ARM64_INTRIN_VQRDMLAH_S16,
	ARM64_INTRIN_VQRDMLAH_S32,
	ARM64_INTRIN_VQRDMLAHQ_S16,
	ARM64_INTRIN_VQRDMLAHQ_S32,
	ARM64_INTRIN_VQRDMLSH_S16,
	ARM64_INTRIN_VQRDMLSH_S32,
	ARM64_INTRIN_VQRDMLSHQ_S16,
	ARM64_INTRIN_VQRDMLSHQ_S32,
	ARM64_INTRIN_VQRDMLAH_LANE_S16,
	ARM64_INTRIN_VQRDMLAHQ_LANE_S16,
	ARM64_INTRIN_VQRDMLAH_LANEQ_S16,
	ARM64_INTRIN_VQRDMLAHQ_LANEQ_S16,
	ARM64_INTRIN_VQRDMLAH_LANE_S32,
	ARM64_INTRIN_VQRDMLAHQ_LANE_S32,
	ARM64_INTRIN_VQRDMLAH_LANEQ_S32,
	ARM64_INTRIN_VQRDMLAHQ_LANEQ_S32,
	ARM64_INTRIN_VQRDMLSH_LANE_S16,
	ARM64_INTRIN_VQRDMLSHQ_LANE_S16,
	ARM64_INTRIN_VQRDMLSH_LANEQ_S16,
	ARM64_INTRIN_VQRDMLSHQ_LANEQ_S16,
	ARM64_INTRIN_VQRDMLSH_LANE_S32,
	ARM64_INTRIN_VQRDMLSHQ_LANE_S32,
	ARM64_INTRIN_VQRDMLSH_LANEQ_S32,
	ARM64_INTRIN_VQRDMLSHQ_LANEQ_S32,
	ARM64_INTRIN_VQRDMLAHH_S16,
	ARM64_INTRIN_VQRDMLAHS_S32,
	ARM64_INTRIN_VQRDMLSHH_S16,
	ARM64_INTRIN_VQRDMLSHS_S32,
	ARM64_INTRIN_VQRDMLAHH_LANE_S16,
	ARM64_INTRIN_VQRDMLAHH_LANEQ_S16,
	ARM64_INTRIN_VQRDMLAHS_LANE_S32,
	ARM64_INTRIN_VQRDMLAHS_LANEQ_S32,
	ARM64_INTRIN_VQRDMLSHH_LANE_S16,
	ARM64_INTRIN_VQRDMLSHH_LANEQ_S16,
	ARM64_INTRIN_VQRDMLSHS_LANE_S32,
	ARM64_INTRIN_VQRDMLSHS_LANEQ_S32,
	ARM64_INTRIN_VABSH_F16,
	ARM64_INTRIN_VCEQZH_F16,
	ARM64_INTRIN_VCGEZH_F16,
	ARM64_INTRIN_VCGTZH_F16,
	ARM64_INTRIN_VCLEZH_F16,
	ARM64_INTRIN_VCLTZH_F16,
	ARM64_INTRIN_VCVTH_F16_S16,
	ARM64_INTRIN_VCVTH_F16_S32,
	ARM64_INTRIN_VCVTH_F16_S64,
	ARM64_INTRIN_VCVTH_F16_U16,
	ARM64_INTRIN_VCVTH_F16_U32,
	ARM64_INTRIN_VCVTH_F16_U64,
	ARM64_INTRIN_VCVTH_S16_F16,
	ARM64_INTRIN_VCVTH_S32_F16,
	ARM64_INTRIN_VCVTH_S64_F16,
	ARM64_INTRIN_VCVTH_U16_F16,
	ARM64_INTRIN_VCVTH_U32_F16,
	ARM64_INTRIN_VCVTH_U64_F16,
	ARM64_INTRIN_VCVTAH_S16_F16,
	ARM64_INTRIN_VCVTAH_S32_F16,
	ARM64_INTRIN_VCVTAH_S64_F16,
	ARM64_INTRIN_VCVTAH_U16_F16,
	ARM64_INTRIN_VCVTAH_U32_F16,
	ARM64_INTRIN_VCVTAH_U64_F16,
	ARM64_INTRIN_VCVTMH_S16_F16,
	ARM64_INTRIN_VCVTMH_S32_F16,
	ARM64_INTRIN_VCVTMH_S64_F16,
	ARM64_INTRIN_VCVTMH_U16_F16,
	ARM64_INTRIN_VCVTMH_U32_F16,
	ARM64_INTRIN_VCVTMH_U64_F16,
	ARM64_INTRIN_VCVTNH_S16_F16,
	ARM64_INTRIN_VCVTNH_S32_F16,
	ARM64_INTRIN_VCVTNH_S64_F16,
	ARM64_INTRIN_VCVTNH_U16_F16,
	ARM64_INTRIN_VCVTNH_U32_F16,
	ARM64_INTRIN_VCVTNH_U64_F16,
	ARM64_INTRIN_VCVTPH_S16_F16,
	ARM64_INTRIN_VCVTPH_S32_F16,
	ARM64_INTRIN_VCVTPH_S64_F16,
	ARM64_INTRIN_VCVTPH_U16_F16,
	ARM64_INTRIN_VCVTPH_U32_F16,
	ARM64_INTRIN_VCVTPH_U64_F16,
	ARM64_INTRIN_VNEGH_F16,
	ARM64_INTRIN_VRECPEH_F16,
	ARM64_INTRIN_VRECPXH_F16,
	ARM64_INTRIN_VRNDH_F16,
	ARM64_INTRIN_VRNDAH_F16,
	ARM64_INTRIN_VRNDIH_F16,
	ARM64_INTRIN_VRNDMH_F16,
	ARM64_INTRIN_VRNDNH_F16,
	ARM64_INTRIN_VRNDPH_F16,
	ARM64_INTRIN_VRNDXH_F16,
	ARM64_INTRIN_VRSQRTEH_F16,
	ARM64_INTRIN_VSQRTH_F16,
	ARM64_INTRIN_VADDH_F16,
	ARM64_INTRIN_VABDH_F16,
	ARM64_INTRIN_VCAGEH_F16,
	ARM64_INTRIN_VCAGTH_F16,
	ARM64_INTRIN_VCALEH_F16,
	ARM64_INTRIN_VCALTH_F16,
	ARM64_INTRIN_VCEQH_F16,
	ARM64_INTRIN_VCGEH_F16,
	ARM64_INTRIN_VCGTH_F16,
	ARM64_INTRIN_VCLEH_F16,
	ARM64_INTRIN_VCLTH_F16,
	ARM64_INTRIN_VCVTH_N_F16_S16,
	ARM64_INTRIN_VCVTH_N_F16_S32,
	ARM64_INTRIN_VCVTH_N_F16_S64,
	ARM64_INTRIN_VCVTH_N_F16_U16,
	ARM64_INTRIN_VCVTH_N_S16_F16,
	ARM64_INTRIN_VCVTH_N_S32_F16,
	ARM64_INTRIN_VCVTH_N_S64_F16,
	ARM64_INTRIN_VCVTH_N_U16_F16,
	ARM64_INTRIN_VCVTH_N_U32_F16,
	ARM64_INTRIN_VCVTH_N_U64_F16,
	ARM64_INTRIN_VDIVH_F16,
	ARM64_INTRIN_VMAXH_F16,
	ARM64_INTRIN_VMAXNMH_F16,
	ARM64_INTRIN_VMINH_F16,
	ARM64_INTRIN_VMINNMH_F16,
	ARM64_INTRIN_VMULH_F16,
	ARM64_INTRIN_VMULXH_F16,
	ARM64_INTRIN_VRECPSH_F16,
	ARM64_INTRIN_VRSQRTSH_F16,
	ARM64_INTRIN_VSUBH_F16,
	ARM64_INTRIN_VFMAH_F16,
	ARM64_INTRIN_VFMSH_F16,
	ARM64_INTRIN_VABS_F16,
	ARM64_INTRIN_VABSQ_F16,
	ARM64_INTRIN_VCEQZ_F16,
	ARM64_INTRIN_VCEQZQ_F16,
	ARM64_INTRIN_VCGEZ_F16,
	ARM64_INTRIN_VCGEZQ_F16,
	ARM64_INTRIN_VCGTZ_F16,
	ARM64_INTRIN_VCGTZQ_F16,
	ARM64_INTRIN_VCLEZ_F16,
	ARM64_INTRIN_VCLEZQ_F16,
	ARM64_INTRIN_VCLTZ_F16,
	ARM64_INTRIN_VCLTZQ_F16,
	ARM64_INTRIN_VCVT_F16_S16,
	ARM64_INTRIN_VCVTQ_F16_S16,
	ARM64_INTRIN_VCVT_F16_U16,
	ARM64_INTRIN_VCVTQ_F16_U16,
	ARM64_INTRIN_VCVT_S16_F16,
	ARM64_INTRIN_VCVTQ_S16_F16,
	ARM64_INTRIN_VCVT_U16_F16,
	ARM64_INTRIN_VCVTQ_U16_F16,
	ARM64_INTRIN_VCVTA_S16_F16,
	ARM64_INTRIN_VCVTAQ_S16_F16,
	ARM64_INTRIN_VCVTA_U16_F16,
	ARM64_INTRIN_VCVTAQ_U16_F16,
	ARM64_INTRIN_VCVTM_S16_F16,
	ARM64_INTRIN_VCVTMQ_S16_F16,
	ARM64_INTRIN_VCVTM_U16_F16,
	ARM64_INTRIN_VCVTMQ_U16_F16,
	ARM64_INTRIN_VCVTN_S16_F16,
	ARM64_INTRIN_VCVTNQ_S16_F16,
	ARM64_INTRIN_VCVTN_U16_F16,
	ARM64_INTRIN_VCVTNQ_U16_F16,
	ARM64_INTRIN_VCVTP_S16_F16,
	ARM64_INTRIN_VCVTPQ_S16_F16,
	ARM64_INTRIN_VCVTP_U16_F16,
	ARM64_INTRIN_VCVTPQ_U16_F16,
	ARM64_INTRIN_VNEG_F16,
	ARM64_INTRIN_VNEGQ_F16,
	ARM64_INTRIN_VRECPE_F16,
	ARM64_INTRIN_VRECPEQ_F16,
	ARM64_INTRIN_VRND_F16,
	ARM64_INTRIN_VRNDQ_F16,
	ARM64_INTRIN_VRNDA_F16,
	ARM64_INTRIN_VRNDAQ_F16,
	ARM64_INTRIN_VRNDI_F16,
	ARM64_INTRIN_VRNDIQ_F16,
	ARM64_INTRIN_VRNDM_F16,
	ARM64_INTRIN_VRNDMQ_F16,
	ARM64_INTRIN_VRNDN_F16,
	ARM64_INTRIN_VRNDNQ_F16,
	ARM64_INTRIN_VRNDP_F16,
	ARM64_INTRIN_VRNDPQ_F16,
	ARM64_INTRIN_VRNDX_F16,
	ARM64_INTRIN_VRNDXQ_F16,
	ARM64_INTRIN_VRSQRTE_F16,
	ARM64_INTRIN_VRSQRTEQ_F16,
	ARM64_INTRIN_VSQRT_F16,
	ARM64_INTRIN_VSQRTQ_F16,
	ARM64_INTRIN_VADD_F16,
	ARM64_INTRIN_VADDQ_F16,
	ARM64_INTRIN_VABD_F16,
	ARM64_INTRIN_VABDQ_F16,
	ARM64_INTRIN_VCAGE_F16,
	ARM64_INTRIN_VCAGEQ_F16,
	ARM64_INTRIN_VCAGT_F16,
	ARM64_INTRIN_VCAGTQ_F16,
	ARM64_INTRIN_VCALE_F16,
	ARM64_INTRIN_VCALEQ_F16,
	ARM64_INTRIN_VCALT_F16,
	ARM64_INTRIN_VCALTQ_F16,
	ARM64_INTRIN_VCEQ_F16,
	ARM64_INTRIN_VCEQQ_F16,
	ARM64_INTRIN_VCGE_F16,
	ARM64_INTRIN_VCGEQ_F16,
	ARM64_INTRIN_VCGT_F16,
	ARM64_INTRIN_VCGTQ_F16,
	ARM64_INTRIN_VCLE_F16,
	ARM64_INTRIN_VCLEQ_F16,
	ARM64_INTRIN_VCLT_F16,
	ARM64_INTRIN_VCLTQ_F16,
	ARM64_INTRIN_VCVT_N_F16_S16,
	ARM64_INTRIN_VCVTQ_N_F16_S16,
	ARM64_INTRIN_VCVT_N_F16_U16,
	ARM64_INTRIN_VCVTQ_N_F16_U16,
	ARM64_INTRIN_VCVT_N_S16_F16,
	ARM64_INTRIN_VCVTQ_N_S16_F16,
	ARM64_INTRIN_VCVT_N_U16_F16,
	ARM64_INTRIN_VCVTQ_N_U16_F16,
	ARM64_INTRIN_VDIV_F16,
	ARM64_INTRIN_VDIVQ_F16,
	ARM64_INTRIN_VMAX_F16,
	ARM64_INTRIN_VMAXQ_F16,
	ARM64_INTRIN_VMAXNM_F16,
	ARM64_INTRIN_VMAXNMQ_F16,
	ARM64_INTRIN_VMIN_F16,
	ARM64_INTRIN_VMINQ_F16,
	ARM64_INTRIN_VMINNM_F16,
	ARM64_INTRIN_VMINNMQ_F16,
	ARM64_INTRIN_VMUL_F16,
	ARM64_INTRIN_VMULQ_F16,
	ARM64_INTRIN_VMULX_F16,
	ARM64_INTRIN_VMULXQ_F16,
	ARM64_INTRIN_VPADD_F16,
	ARM64_INTRIN_VPADDQ_F16,
	ARM64_INTRIN_VPMAX_F16,
	ARM64_INTRIN_VPMAXQ_F16,
	ARM64_INTRIN_VPMAXNM_F16,
	ARM64_INTRIN_VPMAXNMQ_F16,
	ARM64_INTRIN_VPMIN_F16,
	ARM64_INTRIN_VPMINQ_F16,
	ARM64_INTRIN_VPMINNM_F16,
	ARM64_INTRIN_VPMINNMQ_F16,
	ARM64_INTRIN_VRECPS_F16,
	ARM64_INTRIN_VRECPSQ_F16,
	ARM64_INTRIN_VRSQRTS_F16,
	ARM64_INTRIN_VRSQRTSQ_F16,
	ARM64_INTRIN_VSUB_F16,
	ARM64_INTRIN_VSUBQ_F16,
	ARM64_INTRIN_VFMA_F16,
	ARM64_INTRIN_VFMAQ_F16,
	ARM64_INTRIN_VFMS_F16,
	ARM64_INTRIN_VFMSQ_F16,
	ARM64_INTRIN_VFMA_LANE_F16,
	ARM64_INTRIN_VFMAQ_LANE_F16,
	ARM64_INTRIN_VFMA_LANEQ_F16,
	ARM64_INTRIN_VFMAQ_LANEQ_F16,
	ARM64_INTRIN_VFMA_N_F16,
	ARM64_INTRIN_VFMAQ_N_F16,
	ARM64_INTRIN_VFMAH_LANE_F16,
	ARM64_INTRIN_VFMAH_LANEQ_F16,
	ARM64_INTRIN_VFMS_LANE_F16,
	ARM64_INTRIN_VFMSQ_LANE_F16,
	ARM64_INTRIN_VFMS_LANEQ_F16,
	ARM64_INTRIN_VFMSQ_LANEQ_F16,
	ARM64_INTRIN_VFMS_N_F16,
	ARM64_INTRIN_VFMSQ_N_F16,
	ARM64_INTRIN_VFMSH_LANE_F16,
	ARM64_INTRIN_VFMSH_LANEQ_F16,
	ARM64_INTRIN_VMUL_LANE_F16,
	ARM64_INTRIN_VMULQ_LANE_F16,
	ARM64_INTRIN_VMUL_LANEQ_F16,
	ARM64_INTRIN_VMULQ_LANEQ_F16,
	ARM64_INTRIN_VMUL_N_F16,
	ARM64_INTRIN_VMULQ_N_F16,
	ARM64_INTRIN_VMULH_LANE_F16,
	ARM64_INTRIN_VMULH_LANEQ_F16,
	ARM64_INTRIN_VMULX_LANE_F16,
	ARM64_INTRIN_VMULXQ_LANE_F16,
	ARM64_INTRIN_VMULX_LANEQ_F16,
	ARM64_INTRIN_VMULXQ_LANEQ_F16,
	ARM64_INTRIN_VMULX_N_F16,
	ARM64_INTRIN_VMULXQ_N_F16,
	ARM64_INTRIN_VMULXH_LANE_F16,
	ARM64_INTRIN_VMULXH_LANEQ_F16,
	ARM64_INTRIN_VMAXV_F16,
	ARM64_INTRIN_VMAXVQ_F16,
	ARM64_INTRIN_VMINV_F16,
	ARM64_INTRIN_VMINVQ_F16,
	ARM64_INTRIN_VMAXNMV_F16,
	ARM64_INTRIN_VMAXNMVQ_F16,
	ARM64_INTRIN_VMINNMV_F16,
	ARM64_INTRIN_VMINNMVQ_F16,
	ARM64_INTRIN_VBSL_F16,
	ARM64_INTRIN_VBSLQ_F16,
	ARM64_INTRIN_VZIP_F16,
	ARM64_INTRIN_VZIPQ_F16,
	ARM64_INTRIN_VUZP_F16,
	ARM64_INTRIN_VUZPQ_F16,
	ARM64_INTRIN_VTRN_F16,
	ARM64_INTRIN_VTRNQ_F16,
	ARM64_INTRIN_VMOV_N_F16,
	ARM64_INTRIN_VMOVQ_N_F16,
	ARM64_INTRIN_VDUP_N_F16,
	ARM64_INTRIN_VDUPQ_N_F16,
	ARM64_INTRIN_VDUP_LANE_F16,
	ARM64_INTRIN_VDUPQ_LANE_F16,
	ARM64_INTRIN_VEXT_F16,
	ARM64_INTRIN_VEXTQ_F16,
	ARM64_INTRIN_VREV64_F16,
	ARM64_INTRIN_VREV64Q_F16,
	ARM64_INTRIN_VZIP1_F16,
	ARM64_INTRIN_VZIP1Q_F16,
	ARM64_INTRIN_VZIP2_F16,
	ARM64_INTRIN_VZIP2Q_F16,
	ARM64_INTRIN_VUZP1_F16,
	ARM64_INTRIN_VUZP1Q_F16,
	ARM64_INTRIN_VUZP2_F16,
	ARM64_INTRIN_VUZP2Q_F16,
	ARM64_INTRIN_VTRN1_F16,
	ARM64_INTRIN_VTRN1Q_F16,
	ARM64_INTRIN_VTRN2_F16,
	ARM64_INTRIN_VTRN2Q_F16,
	ARM64_INTRIN_VDUP_LANEQ_F16,
	ARM64_INTRIN_VDUPQ_LANEQ_F16,
	ARM64_INTRIN_VDUPH_LANE_F16,
	ARM64_INTRIN_VDUPH_LANEQ_F16,
	ARM64_INTRIN_VDOT_U32,
	ARM64_INTRIN_VDOT_S32,
	ARM64_INTRIN_VDOTQ_U32,
	ARM64_INTRIN_VDOTQ_S32,
	ARM64_INTRIN_VDOT_LANE_U32,
	ARM64_INTRIN_VDOT_LANE_S32,
	ARM64_INTRIN_VDOTQ_LANEQ_U32,
	ARM64_INTRIN_VDOTQ_LANEQ_S32,
	ARM64_INTRIN_VDOT_LANEQ_U32,
	ARM64_INTRIN_VDOT_LANEQ_S32,
	ARM64_INTRIN_VDOTQ_LANE_U32,
	ARM64_INTRIN_VDOTQ_LANE_S32,
	ARM64_INTRIN_VSHA512HQ_U64,
	ARM64_INTRIN_VSHA512H2Q_U64,
	ARM64_INTRIN_VSHA512SU0Q_U64,
	ARM64_INTRIN_VSHA512SU1Q_U64,
	ARM64_INTRIN_VEOR3Q_U8,
	ARM64_INTRIN_VEOR3Q_U16,
	ARM64_INTRIN_VEOR3Q_U32,
	ARM64_INTRIN_VEOR3Q_U64,
	ARM64_INTRIN_VEOR3Q_S8,
	ARM64_INTRIN_VEOR3Q_S16,
	ARM64_INTRIN_VEOR3Q_S32,
	ARM64_INTRIN_VEOR3Q_S64,
	ARM64_INTRIN_VRAX1Q_U64,
	ARM64_INTRIN_VXARQ_U64,
	ARM64_INTRIN_VBCAXQ_U8,
	ARM64_INTRIN_VBCAXQ_U16,
	ARM64_INTRIN_VBCAXQ_U32,
	ARM64_INTRIN_VBCAXQ_U64,
	ARM64_INTRIN_VBCAXQ_S8,
	ARM64_INTRIN_VBCAXQ_S16,
	ARM64_INTRIN_VBCAXQ_S32,
	ARM64_INTRIN_VBCAXQ_S64,
	ARM64_INTRIN_VSM3SS1Q_U32,
	ARM64_INTRIN_VSM3TT1AQ_U32,
	ARM64_INTRIN_VSM3TT1BQ_U32,
	ARM64_INTRIN_VSM3TT2AQ_U32,
	ARM64_INTRIN_VSM3TT2BQ_U32,
	ARM64_INTRIN_VSM3PARTW1Q_U32,
	ARM64_INTRIN_VSM3PARTW2Q_U32,
	ARM64_INTRIN_VSM4EQ_U32,
	ARM64_INTRIN_VSM4EKEYQ_U32,
	ARM64_INTRIN_VFMLAL_LOW_F16,
	ARM64_INTRIN_VFMLSL_LOW_F16,
	ARM64_INTRIN_VFMLALQ_LOW_F16,
	ARM64_INTRIN_VFMLSLQ_LOW_F16,
	ARM64_INTRIN_VFMLAL_HIGH_F16,
	ARM64_INTRIN_VFMLSL_HIGH_F16,
	ARM64_INTRIN_VFMLALQ_HIGH_F16,
	ARM64_INTRIN_VFMLSLQ_HIGH_F16,
	ARM64_INTRIN_VFMLAL_LANE_LOW_F16,
	ARM64_INTRIN_VFMLAL_LANEQ_LOW_F16,
	ARM64_INTRIN_VFMLALQ_LANE_LOW_F16,
	ARM64_INTRIN_VFMLALQ_LANEQ_LOW_F16,
	ARM64_INTRIN_VFMLSL_LANE_LOW_F16,
	ARM64_INTRIN_VFMLSL_LANEQ_LOW_F16,
	ARM64_INTRIN_VFMLSLQ_LANE_LOW_F16,
	ARM64_INTRIN_VFMLSLQ_LANEQ_LOW_F16,
	ARM64_INTRIN_VFMLAL_LANE_HIGH_F16,
	ARM64_INTRIN_VFMLSL_LANE_HIGH_F16,
	ARM64_INTRIN_VFMLALQ_LANE_HIGH_F16,
	ARM64_INTRIN_VFMLSLQ_LANE_HIGH_F16,
	ARM64_INTRIN_VFMLAL_LANEQ_HIGH_F16,
	ARM64_INTRIN_VFMLSL_LANEQ_HIGH_F16,
	ARM64_INTRIN_VFMLALQ_LANEQ_HIGH_F16,
	ARM64_INTRIN_VFMLSLQ_LANEQ_HIGH_F16,
	ARM64_INTRIN_VCADD_ROT90_F16,
	ARM64_INTRIN_VCADD_ROT90_F32,
	ARM64_INTRIN_VCADDQ_ROT90_F16,
	ARM64_INTRIN_VCADDQ_ROT90_F32,
	ARM64_INTRIN_VCADDQ_ROT90_F64,
	ARM64_INTRIN_VCADD_ROT270_F16,
	ARM64_INTRIN_VCADD_ROT270_F32,
	ARM64_INTRIN_VCADDQ_ROT270_F16,
	ARM64_INTRIN_VCADDQ_ROT270_F32,
	ARM64_INTRIN_VCADDQ_ROT270_F64,
	ARM64_INTRIN_VCMLA_F16,
	ARM64_INTRIN_VCMLA_F32,
	ARM64_INTRIN_VCMLA_LANE_F16,
	ARM64_INTRIN_VCMLA_LANE_F32,
	ARM64_INTRIN_VCMLA_LANEQ_F16,
	ARM64_INTRIN_VCMLA_LANEQ_F32,
	ARM64_INTRIN_VCMLAQ_F16,
	ARM64_INTRIN_VCMLAQ_F32,
	ARM64_INTRIN_VCMLAQ_F64,
	ARM64_INTRIN_VCMLAQ_LANE_F16,
	ARM64_INTRIN_VCMLAQ_LANE_F32,
	ARM64_INTRIN_VCMLAQ_LANEQ_F16,
	ARM64_INTRIN_VCMLAQ_LANEQ_F32,
	ARM64_INTRIN_VCMLA_ROT90_F16,
	ARM64_INTRIN_VCMLA_ROT90_F32,
	ARM64_INTRIN_VCMLA_ROT90_LANE_F16,
	ARM64_INTRIN_VCMLA_ROT90_LANE_F32,
	ARM64_INTRIN_VCMLA_ROT90_LANEQ_F16,
	ARM64_INTRIN_VCMLA_ROT90_LANEQ_F32,
	ARM64_INTRIN_VCMLAQ_ROT90_F16,
	ARM64_INTRIN_VCMLAQ_ROT90_F32,
	ARM64_INTRIN_VCMLAQ_ROT90_F64,
	ARM64_INTRIN_VCMLAQ_ROT90_LANE_F16,
	ARM64_INTRIN_VCMLAQ_ROT90_LANE_F32,
	ARM64_INTRIN_VCMLAQ_ROT90_LANEQ_F16,
	ARM64_INTRIN_VCMLAQ_ROT90_LANEQ_F32,
	ARM64_INTRIN_VCMLA_ROT180_F16,
	ARM64_INTRIN_VCMLA_ROT180_F32,
	ARM64_INTRIN_VCMLA_ROT180_LANE_F16,
	ARM64_INTRIN_VCMLA_ROT180_LANE_F32,
	ARM64_INTRIN_VCMLA_ROT180_LANEQ_F16,
	ARM64_INTRIN_VCMLA_ROT180_LANEQ_F32,
	ARM64_INTRIN_VCMLAQ_ROT180_F16,
	ARM64_INTRIN_VCMLAQ_ROT180_F32,
	ARM64_INTRIN_VCMLAQ_ROT180_F64,
	ARM64_INTRIN_VCMLAQ_ROT180_LANE_F16,
	ARM64_INTRIN_VCMLAQ_ROT180_LANE_F32,
	ARM64_INTRIN_VCMLAQ_ROT180_LANEQ_F16,
	ARM64_INTRIN_VCMLAQ_ROT180_LANEQ_F32,
	ARM64_INTRIN_VCMLA_ROT270_F16,
	ARM64_INTRIN_VCMLA_ROT270_F32,
	ARM64_INTRIN_VCMLA_ROT270_LANE_F16,
	ARM64_INTRIN_VCMLA_ROT270_LANE_F32,
	ARM64_INTRIN_VCMLA_ROT270_LANEQ_F16,
	ARM64_INTRIN_VCMLA_ROT270_LANEQ_F32,
	ARM64_INTRIN_VCMLAQ_ROT270_F16,
	ARM64_INTRIN_VCMLAQ_ROT270_F32,
	ARM64_INTRIN_VCMLAQ_ROT270_F64,
	ARM64_INTRIN_VCMLAQ_ROT270_LANE_F16,
	ARM64_INTRIN_VCMLAQ_ROT270_LANE_F32,
	ARM64_INTRIN_VCMLAQ_ROT270_LANEQ_F16,
	ARM64_INTRIN_VCMLAQ_ROT270_LANEQ_F32,
	ARM64_INTRIN_VRND32Z_F32,
	ARM64_INTRIN_VRND32ZQ_F32,
	ARM64_INTRIN_VRND32Z_F64,
	ARM64_INTRIN_VRND32ZQ_F64,
	ARM64_INTRIN_VRND64Z_F32,
	ARM64_INTRIN_VRND64ZQ_F32,
	ARM64_INTRIN_VRND64Z_F64,
	ARM64_INTRIN_VRND64ZQ_F64,
	ARM64_INTRIN_VRND32X_F32,
	ARM64_INTRIN_VRND32XQ_F32,
	ARM64_INTRIN_VRND32X_F64,
	ARM64_INTRIN_VRND32XQ_F64,
	ARM64_INTRIN_VRND64X_F32,
	ARM64_INTRIN_VRND64XQ_F32,
	ARM64_INTRIN_VRND64X_F64,
	ARM64_INTRIN_VRND64XQ_F64,
	ARM64_INTRIN_VMMLAQ_S32,
	ARM64_INTRIN_VMMLAQ_U32,
	ARM64_INTRIN_VUSMMLAQ_S32,
	ARM64_INTRIN_VUSDOT_S32,
	ARM64_INTRIN_VUSDOT_LANE_S32,
	ARM64_INTRIN_VSUDOT_LANE_S32,
	ARM64_INTRIN_VUSDOT_LANEQ_S32,
	ARM64_INTRIN_VSUDOT_LANEQ_S32,
	ARM64_INTRIN_VUSDOTQ_S32,
	ARM64_INTRIN_VUSDOTQ_LANE_S32,
	ARM64_INTRIN_VSUDOTQ_LANE_S32,
	ARM64_INTRIN_VUSDOTQ_LANEQ_S32,
	ARM64_INTRIN_VSUDOTQ_LANEQ_S32,
	ARM64_INTRIN_VCREATE_BF16,
	ARM64_INTRIN_VDUP_N_BF16,
	ARM64_INTRIN_VDUPQ_N_BF16,
	ARM64_INTRIN_VDUP_LANE_BF16,
	ARM64_INTRIN_VDUPQ_LANE_BF16,
	ARM64_INTRIN_VDUP_LANEQ_BF16,
	ARM64_INTRIN_VDUPQ_LANEQ_BF16,
	ARM64_INTRIN_VCOMBINE_BF16,
	ARM64_INTRIN_VGET_HIGH_BF16,
	ARM64_INTRIN_VGET_LOW_BF16,
	ARM64_INTRIN_VGET_LANE_BF16,
	ARM64_INTRIN_VGETQ_LANE_BF16,
	ARM64_INTRIN_VSET_LANE_BF16,
	ARM64_INTRIN_VSETQ_LANE_BF16,
	ARM64_INTRIN_VDUPH_LANE_BF16,
	ARM64_INTRIN_VDUPH_LANEQ_BF16,
	ARM64_INTRIN_VLD1_BF16,
	ARM64_INTRIN_VLD1Q_BF16,
	ARM64_INTRIN_VLD1_LANE_BF16,
	ARM64_INTRIN_VLD1Q_LANE_BF16,
	ARM64_INTRIN_VLD1_DUP_BF16,
	ARM64_INTRIN_VLD1Q_DUP_BF16,
	ARM64_INTRIN_VST1_BF16,
	ARM64_INTRIN_VST1Q_BF16,
	ARM64_INTRIN_VST1_LANE_BF16,
	ARM64_INTRIN_VST1Q_LANE_BF16,
	ARM64_INTRIN_VLD2_BF16,
	ARM64_INTRIN_VLD2Q_BF16,
	ARM64_INTRIN_VLD3_BF16,
	ARM64_INTRIN_VLD3Q_BF16,
	ARM64_INTRIN_VLD4_BF16,
	ARM64_INTRIN_VLD4Q_BF16,
	ARM64_INTRIN_VLD2_DUP_BF16,
	ARM64_INTRIN_VLD2Q_DUP_BF16,
	ARM64_INTRIN_VLD3_DUP_BF16,
	ARM64_INTRIN_VLD3Q_DUP_BF16,
	ARM64_INTRIN_VLD4_DUP_BF16,
	ARM64_INTRIN_VLD4Q_DUP_BF16,
	ARM64_INTRIN_VST2_BF16,
	ARM64_INTRIN_VST2Q_BF16,
	ARM64_INTRIN_VST3_BF16,
	ARM64_INTRIN_VST3Q_BF16,
	ARM64_INTRIN_VST4_BF16,
	ARM64_INTRIN_VST4Q_BF16,
	ARM64_INTRIN_VLD2_LANE_BF16,
	ARM64_INTRIN_VLD2Q_LANE_BF16,
	ARM64_INTRIN_VLD3_LANE_BF16,
	ARM64_INTRIN_VLD3Q_LANE_BF16,
	ARM64_INTRIN_VLD4_LANE_BF16,
	ARM64_INTRIN_VLD4Q_LANE_BF16,
	ARM64_INTRIN_VST2_LANE_BF16,
	ARM64_INTRIN_VST2Q_LANE_BF16,
	ARM64_INTRIN_VST3_LANE_BF16,
	ARM64_INTRIN_VST3Q_LANE_BF16,
	ARM64_INTRIN_VST4_LANE_BF16,
	ARM64_INTRIN_VST4Q_LANE_BF16,
	ARM64_INTRIN_VST1_BF16_X2,
	ARM64_INTRIN_VST1Q_BF16_X2,
	ARM64_INTRIN_VST1_BF16_X3,
	ARM64_INTRIN_VST1Q_BF16_X3,
	ARM64_INTRIN_VST1_BF16_X4,
	ARM64_INTRIN_VST1Q_BF16_X4,
	ARM64_INTRIN_VLD1_BF16_X2,
	ARM64_INTRIN_VLD1Q_BF16_X2,
	ARM64_INTRIN_VLD1_BF16_X3,
	ARM64_INTRIN_VLD1Q_BF16_X3,
	ARM64_INTRIN_VLD1_BF16_X4,
	ARM64_INTRIN_VLD1Q_BF16_X4,
	ARM64_INTRIN_VCVT_F32_BF16,
	ARM64_INTRIN_VCVTQ_LOW_F32_BF16,
	ARM64_INTRIN_VCVTQ_HIGH_F32_BF16,
	ARM64_INTRIN_VCVT_BF16_F32,
	ARM64_INTRIN_VCVTQ_LOW_BF16_F32,
	ARM64_INTRIN_VCVTQ_HIGH_BF16_F32,
	ARM64_INTRIN_VCVTH_BF16_F32,
	ARM64_INTRIN_VCVTAH_F32_BF16,
	ARM64_INTRIN_VCOPY_LANE_BF16,
	ARM64_INTRIN_VCOPYQ_LANE_BF16,
	ARM64_INTRIN_VCOPY_LANEQ_BF16,
	ARM64_INTRIN_VCOPYQ_LANEQ_BF16,
	ARM64_INTRIN_VBFDOT_F32,
	ARM64_INTRIN_VBFDOTQ_F32,
	ARM64_INTRIN_VBFDOT_LANE_F32,
	ARM64_INTRIN_VBFDOTQ_LANEQ_F32,
	ARM64_INTRIN_VBFDOT_LANEQ_F32,
	ARM64_INTRIN_VBFDOTQ_LANE_F32,
	ARM64_INTRIN_VBFMMLAQ_F32,
	ARM64_INTRIN_VBFMLALBQ_F32,
	ARM64_INTRIN_VBFMLALTQ_F32,
	ARM64_INTRIN_VBFMLALBQ_LANE_F32,
	ARM64_INTRIN_VBFMLALBQ_LANEQ_F32,
	ARM64_INTRIN_VBFMLALTQ_LANE_F32,
	ARM64_INTRIN_VBFMLALTQ_LANEQ_F32,
	// Added to resolve collisions between vector and scalar variants of the intrinsic
	ARM64_INTRIN_VMAX__F32,
	ARM64_INTRIN_VMAXNM__F32,
	// Added to fill in obvious gaps
	ARM64_INTRIN_VCVTNS_S64_F32,
	ARM64_INTRIN_VCVTN_S32_F64,
	ARM64_INTRIN_VCVTD_N_F64_S32,
	ARM64_INTRIN_VCVTS_N_F32_S64,
	ARM64_INTRIN_VCVT_S32_F64,
	ARM64_INTRIN_VCVT_U32_F64,
	ARM64_INTRIN_VCVTA_S32_F64,
	ARM64_INTRIN_VCVTA_U32_F64,
	ARM64_INTRIN_VCVTAD_S32_F64,
	ARM64_INTRIN_VCVTAD_U32_F64,
	ARM64_INTRIN_VCVTAS_N_S32_F32,
	ARM64_INTRIN_VCVTAS_N_U32_F32,
	ARM64_INTRIN_VCVTD_S32_F64,
	ARM64_INTRIN_VCVTD_U32_F64,
	ARM64_INTRIN_VCVTM_S32_F64,
	ARM64_INTRIN_VCVTM_U32_F64,
	ARM64_INTRIN_VCVTMD_S32_F64,
	ARM64_INTRIN_VCVTMD_U32_F64,
	ARM64_INTRIN_VCVTMS_N_S32_F32,
	ARM64_INTRIN_VCVTMS_N_U32_F32,
	ARM64_INTRIN_VCVTN_U32_F64,
	ARM64_INTRIN_VCVTND_S32_F64,
	ARM64_INTRIN_VCVTND_U32_F64,
	ARM64_INTRIN_VCVTP_S32_F64,
	ARM64_INTRIN_VCVTP_U32_F64,
	ARM64_INTRIN_VCVTPD_S32_F64,
	ARM64_INTRIN_VCVTPD_U32_F64,
	ARM64_INTRIN_VCVTPS_N_S32_F32,
	ARM64_INTRIN_VCVTPS_N_U32_F32,
	ARM64_INTRIN_VCVTA_N_S64_F64,
	ARM64_INTRIN_VCVTA_N_U64_F64,
	ARM64_INTRIN_VCVTAD_N_S64_F64,
	ARM64_INTRIN_VCVTAD_N_U64_F64,
	ARM64_INTRIN_VCVTM_N_S64_F64,
	ARM64_INTRIN_VCVTM_N_U64_F64,
	ARM64_INTRIN_VCVTMD_N_S64_F64,
	ARM64_INTRIN_VCVTMD_N_U64_F64,
	ARM64_INTRIN_VCVTP_N_S64_F64,
	ARM64_INTRIN_VCVTP_N_U64_F64,
	ARM64_INTRIN_VCVTPD_N_S64_F64,
	ARM64_INTRIN_VCVTPD_N_U64_F64,
	ARM64_INTRIN_VCVTNS_U64_F32,
	ARM64_INTRIN_VCVTPS_U64_F32,
	ARM64_INTRIN_VCVTPS_S64_F32,
	ARM64_INTRIN_VCVTS_S64_F32,
	ARM64_INTRIN_VCVTS_U64_F32,
	ARM64_INTRIN_VCVTD_N_U64_F32,
	ARM64_INTRIN_VCVTD_N_U32_F64,
	ARM64_INTRIN_VCVTS_N_U64_F32,
	ARM64_INTRIN_VCVTS_N_U32_F64,
	ARM64_INTRIN_VCVTS_N_U64_F64,
	ARM64_INTRIN_VCVT_U64_F32,
	// The end, add more above
	ARM64_INTRIN_NEON_END
};

string NeonGetIntrinsicName(uint32_t intrinsic);
vector<NameAndType> NeonGetIntrinsicInputs(uint32_t intrinsic);
vector<Confidence<Ref<Type>>> NeonGetIntrinsicOutputs(uint32_t intrinsic);
bool NeonGetLowLevelILForInstruction(
    Architecture* arch, uint64_t addr, LowLevelILFunction& il, Instruction& instr, size_t addrSize);
