#ifdef DOXYGEN_INCLUDE_MAINPAGE

/*
	This file includes group and page definitions for Doxygen.

	See https://api.binary.ninja/cpp/ & https://dev-api.binary.ninja/cpp/ for built docs,
		or see binaryninja-api/api-docs/cppdocs/README.md for information on building them yourself.

*/

/*!
	\mainpage Binary Ninja C++ API

 	Welcome to the Binary Ninja C++ API Docs!

	Documentation here has been grouped into several "modules", similar to the Python API documentation.

	The "Namespaces" and "Classes" groups can also be used to view a *complete* listing of available classes, structures, and enums.

*/


/*! The core set of pure C definitions that the C++ API (and Rust/Python APIs) wrap.

	The **vast** majority of the time, you should use the clases and utilities provided by the C++, Python, or
 		Rust APIs instead.

    \defgroup core Core
*/

/*! Classes available to C++ Core Plugins.

	\defgroup coreapi C++ Core API
*/

/*! Classes available to C++ UI Plugins.

	\defgroup uiapi C++ UI API
*/

/*!
	Classes related to interacting with, hooking, and implementing Architectures
	\defgroup architectures Architectures
	\ingroup coreapi
*/
/*!
	Documentation for interacting with basic blocks
	\defgroup basicblocks Basic Blocks
	\ingroup coreapi
*/
/*!
	Classes related to interacting with and implementing custom BinaryViews
	\defgroup binaryview BinaryView
	\ingroup coreapi
*/
/*!
	\defgroup callingconvention CallingConvention
	\ingroup coreapi
*/
/*!
	\defgroup confidence Confidence
	\ingroup coreapi
*/
/*!
	\defgroup database Database
	\ingroup coreapi
*/
/*!
	\defgroup databuffer DataBuffer
	\ingroup coreapi
*/
/*!
	\defgroup datarenderer DataRenderer
	\ingroup coreapi
*/
/*!
	\defgroup debuginfo DebugInfo
	\ingroup coreapi
*/
/*!
	\defgroup demangle Demangle
	\ingroup coreapi
*/
/*!
	\defgroup downloadprovider DownloadProvider
	\ingroup coreapi
*/
/*!
	\defgroup fileaccessor FileAccessor
	\ingroup coreapi
*/
/*!
	\defgroup filemetadata FileMetadata
	\ingroup coreapi
*/
/*!
	\defgroup flowgraph Flowgraph
	\ingroup coreapi
*/
/*!
	\defgroup function Function
	\ingroup coreapi
*/
/*!
	\defgroup functionrecognizer FunctionRecognizer
	\ingroup coreapi
*/
/*!
	\defgroup highlevelil High Level IL
	\ingroup coreapi
*/
/*!
	\defgroup interaction Interaction
	\ingroup coreapi
*/
/*!
	\defgroup lineardisassembly LinearDisassembly
	\ingroup coreapi
*/
/*!
	\defgroup logging Logging
	\ingroup coreapi
*/
/*!
	\defgroup lowlevelil Low Level IL
	\ingroup coreapi
*/
/*!
	\defgroup mainthread MainThread
	\ingroup coreapi
*/
/*!
	\defgroup mediumlevelil Medium Level IL
	\ingroup coreapi
*/
/*!
	\defgroup metadata Metadata
	\ingroup coreapi
*/
/*!
	\defgroup platform Platform
	\ingroup coreapi
*/
/*!
	\defgroup plugin Plugin
	\ingroup coreapi
*/
/*!
	\defgroup pluginmanager Plugin Manager
	\ingroup coreapi
*/
/*!
	\defgroup namelist NameList
 	\ingroup coreapi
*/
/*!
	\defgroup refcount RefCount
 	\ingroup coreapi
*/
/*!
	\defgroup scriptingprovider Scripting Provider
	\ingroup coreapi
*/
/*!
	\defgroup secretsprovider Secrets Provider
	\ingroup coreapi
*/
/*!
	\defgroup settings Settings
	\ingroup coreapi
*/
/*!
	\defgroup tempfile TempFile
	\ingroup coreapi
*/
/*!
	\defgroup transform Transform
	\ingroup coreapi
*/
/*!
	\defgroup types Types
	\ingroup coreapi
*/
/*!
	\defgroup typeparser TypeParser
	\ingroup coreapi
*/
/*!
	\defgroup typeprinter TypePrinter
	\ingroup coreapi
*/
/*!
	\defgroup update Update
	\ingroup coreapi
*/
/*!
	\defgroup undo Undo
 	\ingroup coreapi
*/
/*!
	\defgroup websocketprovider Websocket Provider
	\ingroup coreapi
*/
/*!
	\defgroup workflow Workflows
	\ingroup coreapi
*/

#endif
