-- 表结构升级SQL

ALTER TABLE ujcms_dict ADD sys_ TINYINT(3) DEFAULT 0 NOT NULL COMMENT '是否系统字典';
ALTER TABLE ujcms_article_ext ADD type_ SMALLINT DEFAULT 0 NOT NULL COMMENT '类型(常规:0,投稿:1,采集:2,接口:3,站内推送:4,站外推送:5)';
ALTER TABLE ujcms_article_ext ADD baidu_push_ TINYINT(3) DEFAULT 0 NOT NULL COMMENT '是否百度推送';
UPDATE ujcms_dict_type SET alias_ = 'sys_article_source' WHERE id_ = 1;
UPDATE ujcms_seq SET next_val_ = next_val_ + 500 WHERE name_ = 'dict';
UPDATE ujcms_dict SET id_ = id_ + 500;
ALTER TABLE ujcms_channel ADD process_key_ VARCHAR(50) NULL COMMENT '流程标识';
ALTER TABLE ujcms_article_ext ADD process_instance_id_ VARCHAR(64) NULL COMMENT '流程实例ID';
ALTER TABLE ujcms_article_ext ADD reject_reason_ VARCHAR(900) NULL COMMENT '退回原因';
ALTER TABLE ujcms_article_stat ADD PRIMARY KEY (article_id_, stat_day_);
CREATE INDEX idx_articletag_composite ON ujcms_article_tag(tag_id_, article_id_);
CREATE INDEX idx_channeltree_composite ON ujcms_channel_tree(descendant_id_, ancestor_id_);
CREATE INDEX idx_groupaccess_composite ON ujcms_group_access(channel_id_, group_id_);
CREATE INDEX idx_orgtree_composite ON ujcms_org_tree(descendant_id_, ancestor_id_);
CREATE INDEX idx_rolearticle_composite ON ujcms_role_article(channel_id_, role_id_);
CREATE INDEX idx_sitetree_composite ON ujcms_site_tree(descendant_id_, ancestor_id_);
CREATE INDEX idx_userrole_composite ON ujcms_user_role(role_id_, user_id_);
DROP INDEX idx_articlestat_article ON ujcms_article_stat;
DROP INDEX idx_articletag_tag ON ujcms_article_tag;
DROP INDEX idx_channeltree_descendant ON ujcms_channel_tree;
DROP INDEX idx_groupaccess_channel ON ujcms_group_access;
DROP INDEX idx_orgtree_descendant ON ujcms_org_tree;
DROP INDEX idx_rolearticle_channel ON ujcms_role_article;
DROP INDEX idx_sitetree_descendant ON ujcms_site_tree;
DROP INDEX idx_userrole_role ON ujcms_user_role;
ALTER TABLE ujcms_article_custom ADD id_ BIGINT NULL COMMENT '文章自定义ID';
ALTER TABLE ujcms_article_file ADD id_ BIGINT NULL COMMENT '文章文件ID';
ALTER TABLE ujcms_article_image ADD id_ BIGINT NULL COMMENT '文章图片ID';
ALTER TABLE ujcms_attachment_refer ADD id_ BIGINT NULL COMMENT '附件引用ID';
ALTER TABLE ujcms_channel_custom ADD id_ BIGINT NULL COMMENT '栏目自定义ID';
ALTER TABLE ujcms_site_custom ADD id_ BIGINT NULL COMMENT '站点自定义ID';
ALTER TABLE ujcms_attachment_refer ADD CONSTRAINT idx_attachmentrefer_unique UNIQUE (attachment_id_, refer_type_, refer_id_);
ALTER TABLE ujcms_attachment_refer DROP PRIMARY KEY;
SET @i:=0; update ujcms_article_file set id_ = (@i:=@i+1);
SET @i:=0; update ujcms_article_image set id_ = (@i:=@i+1);
SET @i:=0; update ujcms_article_custom set id_ = (@i:=@i+1);
SET @i:=0; update ujcms_channel_custom set id_ = (@i:=@i+1);
SET @i:=0; update ujcms_site_custom set id_ = (@i:=@i+1);
SET @i:=0; update ujcms_attachment_refer set id_ = (@i:=@i+1);
ALTER TABLE ujcms_article_custom MODIFY id_ BIGINT NOT NULL;
ALTER TABLE ujcms_article_file MODIFY id_ BIGINT NOT NULL;
ALTER TABLE ujcms_article_image MODIFY id_ BIGINT NOT NULL;
ALTER TABLE ujcms_attachment_refer MODIFY id_ BIGINT NOT NULL;
ALTER TABLE ujcms_channel_custom MODIFY id_ BIGINT NOT NULL;
ALTER TABLE ujcms_site_custom MODIFY id_ BIGINT NOT NULL;
ALTER TABLE ujcms_article_custom ADD PRIMARY KEY (id_);
ALTER TABLE ujcms_article_file ADD PRIMARY KEY (id_);
ALTER TABLE ujcms_article_image ADD PRIMARY KEY (id_);
ALTER TABLE ujcms_attachment_refer ADD PRIMARY KEY (id_);
ALTER TABLE ujcms_channel_custom ADD PRIMARY KEY (id_);
ALTER TABLE ujcms_site_custom ADD PRIMARY KEY (id_);
ALTER TABLE ujcms_article_ext ADD audio_ VARCHAR(255) NULL COMMENT '音频';
ALTER TABLE ujcms_article_ext ADD video_duration_ INT NULL COMMENT '视频时长';
ALTER TABLE ujcms_article_ext ADD audio_duration_ INT NULL COMMENT '音频时长';
ALTER TABLE ujcms_article_ext DROP COLUMN video_time_;
ALTER TABLE ujcms_config ADD security_settings_ VARCHAR(1000) NULL COMMENT '安全设置';
ALTER TABLE ujcms_article_ext ADD video_orig_ VARCHAR(255) NULL COMMENT '原视频';
ALTER TABLE ujcms_article_ext ADD audio_orig_ VARCHAR(255) NULL COMMENT '原音频';
ALTER TABLE ujcms_config ADD sms_settings_ VARCHAR(1000) NULL COMMENT '短信设置';
CREATE TABLE ujcms_short_message (id_ INT NOT NULL, type_ SMALLINT DEFAULT 1 NOT NULL COMMENT '类型(1:手机短信,2:邮件短信)', receiver_ VARCHAR(100) NOT NULL COMMENT '接收人(手机号码或邮件地址)', code_ VARCHAR(10) NOT NULL COMMENT '验证码', send_date_ datetime NOT NULL COMMENT '发送时间', attempts_ SMALLINT DEFAULT 0 NOT NULL COMMENT '尝试次数', ip_ VARCHAR(45) NOT NULL COMMENT 'IP地址', usage_ SMALLINT NOT NULL COMMENT '用途(0:测试,1:注册,2:登录,3:双因子登录,4:找回密码,5:修改手机号码,6:修改邮箱地址)', status_ SMALLINT DEFAULT 0 NOT NULL COMMENT '状态(0:未使用,1:验证正确,2:验证错误,3:已过期)', CONSTRAINT PK_UJCMS_SHORT_MESSAGE PRIMARY KEY (id_)) COMMENT='短信表';
ALTER TABLE ujcms_short_message COMMENT = '短信表';
ALTER TABLE ujcms_user ADD password_modified_ datetime DEFAULT NOW() NOT NULL COMMENT '密码修改时间';
CREATE TABLE ujcms_login_log (id_ INT NOT NULL, user_id_ INT NULL COMMENT '用户ID', login_name_ VARCHAR(90) NULL COMMENT '登录名', ip_ VARCHAR(45) NOT NULL COMMENT 'IP地址', created_ datetime NOT NULL COMMENT '创建日期', type_ SMALLINT NOT NULL COMMENT '类型(1:登录,2:退出)', status_ SMALLINT DEFAULT 1 NOT NULL COMMENT '状态(0:成功,1:用户名不存在,2:密码错误,3:验证码错误,4:短信错误)', CONSTRAINT PK_UJCMS_LOGIN_LOG PRIMARY KEY (id_));
CREATE INDEX idx_loginlog_user ON ujcms_login_log(user_id_);
ALTER TABLE ujcms_login_log ADD CONSTRAINT fk_loginlog_user FOREIGN KEY (user_id_) REFERENCES ujcms_user (id_) ON UPDATE RESTRICT ON DELETE RESTRICT;
ALTER TABLE ujcms_user_ext ADD history_password_ VARCHAR(3000) NULL COMMENT '历史密码(70*24)';

update ujcms_role set all_article_permission_ = 1, data_scope_ = 1, global_permission_ = 1;

-- 插入必须数据

insert into ujcms_seq (name_, next_val_, cache_size_) values ('article_file', (select count(*) from ujcms_article_file) + 1, 0);
insert into ujcms_seq (name_, next_val_, cache_size_) values ('article_image', (select count(*) from ujcms_article_image) + 1, 0);
insert into ujcms_seq (name_, next_val_, cache_size_) values ('article_custom', (select count(*) from ujcms_article_custom) + 1, 0);
insert into ujcms_seq (name_, next_val_, cache_size_) values ('channel_custom', (select count(*) from ujcms_channel_custom) + 1, 0);
insert into ujcms_seq (name_, next_val_, cache_size_) values ('site_custom', (select count(*) from ujcms_site_custom) + 1, 0);
insert into ujcms_seq (name_, next_val_, cache_size_) values ('attachment_refer', (select count(*) from ujcms_attachment_refer) + 1, 0);
insert into ujcms_dict_type (id_, name_, alias_, scope_, order_, sys_) values (2, '流程类型', 'sys_process_category', 2, 32767, 1);
insert into ujcms_dict (id_, type_id_, name_, value_, order_, sys_, enabled_) values (1, 2, '文章审核', 'sys_article', 32767, 1, 1);

--  *********************************************************************
--  SQL to add all changesets to database history table
--  *********************************************************************

delete from DATABASECHANGELOG;

INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-1', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 1, '8:7aec773ceafb63f79369922c207b3538', 'createTable tableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-2', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 2, '8:44cf4cb6f0396350a3553c21b6e55391', 'createTable tableName=ujcms_article_buffer', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-3', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 3, '8:d074ce6f9ac2be6ace557f4348ba602f', 'createTable tableName=ujcms_article_custom', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-4', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 4, '8:c4c5c07123d2a20e287f4c8fdeac9d30', 'createTable tableName=ujcms_article_ext', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-5', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 5, '8:d31cf73ae5d215ba8e72eedca75f13ab', 'createTable tableName=ujcms_article_file', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-6', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 6, '8:066cf5fd94538227925a36fc3f2fa78f', 'createTable tableName=ujcms_article_image', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-7', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 7, '8:17a44d5544b618991c57f31a80694b9d', 'createTable tableName=ujcms_article_stat', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-8', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 8, '8:60de499fb7463243cbc318c6f8182f61', 'createTable tableName=ujcms_article_tag', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-9', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 9, '8:ce4d8b6bbd29f999347076bd8311f0a8', 'createTable tableName=ujcms_attachment', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-10', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 10, '8:d27971eceb08f17b777e02b30fbd4451', 'createTable tableName=ujcms_attachment_refer', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-11', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 11, '8:08c36b9e2926a6dc620d7eefc020efbc', 'createTable tableName=ujcms_block', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-12', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 12, '8:7df0e3ef07c326bec8ff7490345ef13b', 'createTable tableName=ujcms_block_item', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-13', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 13, '8:a32b26e15531c3b1592479d32ecb0351', 'createTable tableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-14', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 14, '8:40b36091095d8cd02bdbd8cc202ac75d', 'createTable tableName=ujcms_channel_buffer', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-15', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 15, '8:4726d1e91853af3e430535e5cd74c216', 'createTable tableName=ujcms_channel_custom', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-16', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 16, '8:a7ed02e89cfe174bf1884ad01630baa3', 'createTable tableName=ujcms_channel_ext', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-17', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 17, '8:17fa1f8536ac25ddf775a49362d8fe2a', 'createTable tableName=ujcms_channel_tree', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-18', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 18, '8:3ce647147fecd1e0646ffc8614881da4', 'createTable tableName=ujcms_config', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-19', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 19, '8:7f76eb67f5e7b5b9586a225226906291', 'createTable tableName=ujcms_dict', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-20', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 20, '8:4cea66ab20e1825cea08d093fd6f9a03', 'createTable tableName=ujcms_dict_type', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-21', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 21, '8:9ce1bc677ab9dae4a7b914012ef5dd75', 'createTable tableName=ujcms_group', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-22', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 22, '8:44937ea20b427f80090c83e6b11c9e99', 'createTable tableName=ujcms_group_access', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-23', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 23, '8:41aec87f49927d0d290969bc74d28d15', 'createTable tableName=ujcms_login_log', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-24', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 24, '8:d46666d3bbc7fd2742fb5f91f37fe0a7', 'createTable tableName=ujcms_model', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-25', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 25, '8:e0433fc47fe85f207addb9bea2b22a10', 'createTable tableName=ujcms_org', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-26', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 26, '8:372569e397ee493eaa7333725ecc0552', 'createTable tableName=ujcms_org_tree', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-27', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 27, '8:c784f0897429b72d3f76d3fa532bab9b', 'createTable tableName=ujcms_push', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-28', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 28, '8:a19a99d260df7cdf85f908597017d060', 'createTable tableName=ujcms_role', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-29', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 29, '8:f3be1ea1ecefc45081ddca1e6023cc06', 'createTable tableName=ujcms_role_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-30', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 30, '8:74014b0b1114bd69c0b61acb506310fa', 'createTable tableName=ujcms_seq', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-31', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 31, '8:359598d1d60dbb7fb3f8330fbefb1ed1', 'createTable tableName=ujcms_short_message', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-32', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 32, '8:19c0372904dc92124216dbd87d8716f4', 'createTable tableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-33', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 33, '8:c6fbfb1ec5634cd2856000d04668dbfb', 'createTable tableName=ujcms_site_buffer', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-34', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 34, '8:9d3cd23640d1ca8606daaf11d5a0d148', 'createTable tableName=ujcms_site_custom', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-35', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 35, '8:fca82abea2fc8c9b4a5ec19bddd76938', 'createTable tableName=ujcms_site_tree', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-36', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 36, '8:0df51a2740220850319a63ced3d01f43', 'createTable tableName=ujcms_tag', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-37', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 37, '8:ca6c57f5ca396c09553706f76603b60b', 'createTable tableName=ujcms_task', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-38', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 38, '8:99fa9df5d4f3286b9d825dfb6a46e1b0', 'createTable tableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-39', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 39, '8:1a379669d9ebea219b282e6d08f19959', 'createTable tableName=ujcms_user_ext', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-40', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 40, '8:b44b93abd8c89a0454f8b01195ee45c2', 'createTable tableName=ujcms_user_openid', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-41', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 41, '8:6543751c5f38eb00c066b0f001574119', 'createTable tableName=ujcms_user_role', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-42', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 42, '8:7e39cd94e573a82039cc55acba70eb5c', 'addUniqueConstraint constraintName=idx_attachmentrefer_unique, tableName=ujcms_attachment_refer', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-43', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 43, '8:54e23238f9c1e74b0f775ed2d065ab87', 'addUniqueConstraint constraintName=uk_blockitem_block_article, tableName=ujcms_block_item', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-44', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 44, '8:d10bd6a538ed61a1198cf6fb1316c9e1', 'addUniqueConstraint constraintName=uk_channel_alias_site, tableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-45', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 45, '8:b1b4df1544e9c1185ba73afa9f25161c', 'createIndex indexName=idx_aritcle_channel, tableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-46', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 46, '8:978a2dd27fcec50caf2514a6b3934d6d', 'createIndex indexName=idx_article_org, tableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-47', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 47, '8:3a57a47a7646a34fd49124979323bd96', 'createIndex indexName=idx_article_publish_date, tableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-48', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 48, '8:bc12253ecdb4bd34f08ec877fa48ede1', 'createIndex indexName=idx_article_user, tableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-49', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 49, '8:c11dede445b728b291e0170c6459cfb5', 'createIndex indexName=idx_article_user_modified, tableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-50', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 50, '8:461185c1d2255295b1cd8bc35c70012b', 'createIndex indexName=idx_article_website, tableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-51', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 51, '8:d37fb1dc631b2d8f22242fc5097ed28b', 'createIndex indexName=idx_articlecustom_article, tableName=ujcms_article_custom', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-52', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 52, '8:16e91b0e10935e89bc73cafcc46d769b', 'createIndex indexName=idx_articlefile_article, tableName=ujcms_article_file', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-53', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 53, '8:5da1e5ab825c7f871b015bc15840d83e', 'createIndex indexName=idx_articleimage_article, tableName=ujcms_article_image', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-54', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 54, '8:b8fb1a57a6d5c8730a5859a7f70d2780', 'createIndex indexName=idx_articletag_composite, tableName=ujcms_article_tag', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-55', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 55, '8:36b4fbd5ab4a86586bcc0e06b9810501', 'createIndex indexName=idx_attachment_site, tableName=ujcms_attachment', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-56', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 56, '8:b0cb60445d876fe83c06d420863606d8', 'createIndex indexName=idx_attachment_user, tableName=ujcms_attachment', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-57', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 57, '8:42e37e2e461b650cfb5b7fd2deb19b4e', 'createIndex indexName=idx_attachmentrefer_type_id, tableName=ujcms_attachment_refer', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-58', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 58, '8:9b65028a796cb83565029c09777e62f6', 'createIndex indexName=idx_block_site, tableName=ujcms_block', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-59', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 59, '8:015c82f2b9d519724c6666de70516334', 'createIndex indexName=idx_blockitem_block, tableName=ujcms_block_item', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-60', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 60, '8:8a775778825990509864573116758289', 'createIndex indexName=idx_blockitem_site, tableName=ujcms_block_item', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-61', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 61, '8:c0b86402a5cec9e3ed2483a958f688bf', 'createIndex indexName=idx_channel_model_article, tableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-62', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 62, '8:9d2de2dcd41b068aafb18231bbbec7ea', 'createIndex indexName=idx_channel_model_channel, tableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-63', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 63, '8:e1e373dfe85775f48e21e85f97a00a11', 'createIndex indexName=idx_channel_order, tableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-64', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 64, '8:a79a2402c25ac68d9f03fe4d0ef4d7c5', 'createIndex indexName=idx_channel_parent, tableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-65', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 65, '8:b42c6e60087a7f8f2edb9f8690956250', 'createIndex indexName=idx_channel_site, tableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-66', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 66, '8:992460d43fa36ee0cf1dbf20433c6205', 'createIndex indexName=idx_channelcustom_channel, tableName=ujcms_channel_custom', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-67', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 67, '8:2e048e40c1a48fe4235f30b908f5f2b1', 'createIndex indexName=idx_channeltree_composite, tableName=ujcms_channel_tree', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-68', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 68, '8:86caeefae729c7be596bf9eea4d559ea', 'createIndex indexName=idx_dict_dicttype, tableName=ujcms_dict', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-69', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 69, '8:345e4149d9534cdb8fcee5180c36609b', 'createIndex indexName=idx_dict_parent, tableName=ujcms_dict', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-70', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 70, '8:cbd51c7b2a45d6f1c405baa56aa78d8e', 'createIndex indexName=idx_dicttype_site, tableName=ujcms_dict_type', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-71', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 71, '8:39b9ac6f49297d079231aa4d3d87e16a', 'createIndex indexName=idx_groupaccess_composite, tableName=ujcms_group_access', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-72', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 72, '8:666144eaaebeff530e5ce6ef71d93c9f', 'createIndex indexName=idx_groupaccess_site, tableName=ujcms_group_access', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-73', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 73, '8:7ec33601a904a449a00a4c9e1f4e6f99', 'createIndex indexName=idx_loginlog_user, tableName=ujcms_login_log', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-74', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 74, '8:0d73bceb7d6a9712c7881f6d9c416409', 'createIndex indexName=idx_org_order, tableName=ujcms_org', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-75', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 75, '8:b96293ddd665387dc7e58b5afb077348', 'createIndex indexName=idx_org_parent, tableName=ujcms_org', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-76', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 76, '8:68b5b13d5c6693a57a09f5eafadc5701', 'createIndex indexName=idx_orgtree_composite, tableName=ujcms_org_tree', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-77', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 77, '8:369483b9fe1e0de0b8593eada6796c63', 'createIndex indexName=idx_push_article_from, tableName=ujcms_push', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-78', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 78, '8:3aae081f034d7c307d905380b40b13ef', 'createIndex indexName=idx_push_article_to, tableName=ujcms_push', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-79', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 79, '8:10300bda5e015555a498796ff320cb59', 'createIndex indexName=idx_push_site_from, tableName=ujcms_push', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-80', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 80, '8:d19a008372ecefc396cc99e68404542e', 'createIndex indexName=idx_push_site_to, tableName=ujcms_push', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-81', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 81, '8:d343ebb16dfe28acfb83ffad40ce3167', 'createIndex indexName=idx_push_user, tableName=ujcms_push', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-82', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 82, '8:3aa79399e21b89029052bd2b93e171f7', 'createIndex indexName=idx_role_site, tableName=ujcms_role', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-83', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 83, '8:cde856ea15acad72bfd58dc12ee77fe8', 'createIndex indexName=idx_rolearticle_composite, tableName=ujcms_role_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-84', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 84, '8:63d84a1ba97bd021f5089e47c76c9542', 'createIndex indexName=idx_rolearticle_site, tableName=ujcms_role_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-85', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 85, '8:ea03db031d8cdede5895ddcfc6067094', 'createIndex indexName=idx_site_model, tableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-86', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 86, '8:280554ba8fea0c21b6b5461e664566bb', 'createIndex indexName=idx_site_order, tableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-87', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 87, '8:a69a3ad57b102580873ccd7efe2510cc', 'createIndex indexName=idx_site_org, tableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-88', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 88, '8:931bb6d16c8b92dd886eb0eec751098f', 'createIndex indexName=idx_site_parent, tableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-89', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 89, '8:7f5d47e3dc8f196323f3023ad1517406', 'createIndex indexName=idx_sitecustom_site, tableName=ujcms_site_custom', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-90', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 90, '8:2744123bbcb354a788e1c185f8660c07', 'createIndex indexName=idx_sitetree_composite, tableName=ujcms_site_tree', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-91', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 91, '8:633b35df99be0bcf1440d8eddc6b0f5c', 'createIndex indexName=idx_tag_site, tableName=ujcms_tag', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-92', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 92, '8:ca1a4357d3a3159d2b47276dfcd61a52', 'createIndex indexName=idx_tag_user, tableName=ujcms_tag', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-93', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 93, '8:c0fc96c0e45fa54aea5c3e4d479addd3', 'createIndex indexName=idx_task_site, tableName=ujcms_task', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-94', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 94, '8:50062db81c8033bd2ba274c737713f8f', 'createIndex indexName=idx_task_user, tableName=ujcms_task', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-95', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 95, '8:a71ced8075084a2532416542c96b0a0f', 'createIndex indexName=idx_user_group, tableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-96', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 96, '8:6e0628314b5dc7ea97acb460964402ca', 'createIndex indexName=idx_user_org, tableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-97', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 97, '8:f6bc7f445a8bd72ba45d82d4615282c6', 'createIndex indexName=idx_userrole_composite, tableName=ujcms_user_role', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-98', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 98, '8:65ea15c23c6363fd25a3495344f96bcd', 'addForeignKeyConstraint baseTableName=ujcms_article, constraintName=fk_article_channel, referencedTableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-99', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 99, '8:23064ad8890d74d944bf4794b311e8a3', 'addForeignKeyConstraint baseTableName=ujcms_article, constraintName=fk_article_org, referencedTableName=ujcms_org', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-100', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 100, '8:15dd7c8efd75ee882920bbbeed4f7417', 'addForeignKeyConstraint baseTableName=ujcms_article, constraintName=fk_article_user, referencedTableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-101', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 101, '8:611a81164ba6f067bee3b41ff071fdd2', 'addForeignKeyConstraint baseTableName=ujcms_article, constraintName=fk_article_user_modified, referencedTableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-102', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 102, '8:b86bc83d17cb1c1533655c9ea758ae0f', 'addForeignKeyConstraint baseTableName=ujcms_article, constraintName=fk_article_website, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-103', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 103, '8:35218c94a26191d5f990a6db6063093e', 'addForeignKeyConstraint baseTableName=ujcms_article_buffer, constraintName=fk_articlebuffer_article, referencedTableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-104', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 104, '8:56b5bf7221f7606fb95f1f4a60f85726', 'addForeignKeyConstraint baseTableName=ujcms_article_custom, constraintName=fk_articlecustom_article, referencedTableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-105', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 105, '8:f17f75060becfb7e4d4f2f3c83dae821', 'addForeignKeyConstraint baseTableName=ujcms_article_ext, constraintName=fk_articleext_article, referencedTableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-106', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 106, '8:c465be97eeb5d96dce08cae35e83299a', 'addForeignKeyConstraint baseTableName=ujcms_article_file, constraintName=fk_articlefile_article, referencedTableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-107', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 107, '8:77f6d99e9d0df8e48403d9d9d0f6443b', 'addForeignKeyConstraint baseTableName=ujcms_article_image, constraintName=fk_articleimage_article, referencedTableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-108', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 108, '8:3010f7c6ae3a561acbd2dd1ba38e50bb', 'addForeignKeyConstraint baseTableName=ujcms_article_stat, constraintName=fk_articlestat_article, referencedTableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-109', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 109, '8:ec32c5fb039506c86ae7d8781f0d1e0d', 'addForeignKeyConstraint baseTableName=ujcms_article_tag, constraintName=fk_articletag_article, referencedTableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-110', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 110, '8:ea6d9eeb6f13407bbbfc7cf027cc1460', 'addForeignKeyConstraint baseTableName=ujcms_article_tag, constraintName=fk_articletag_tag, referencedTableName=ujcms_tag', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-111', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 111, '8:379ede00ec0fc8d547de1dc75b1c02b0', 'addForeignKeyConstraint baseTableName=ujcms_attachment, constraintName=fk_attachment_site, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-112', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 112, '8:32099cb3912cdaa0c25226f7b364f9d0', 'addForeignKeyConstraint baseTableName=ujcms_attachment, constraintName=fk_attachment_user, referencedTableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-113', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 113, '8:a746b79a99b4f978f3086bbf0e671996', 'addForeignKeyConstraint baseTableName=ujcms_attachment_refer, constraintName=fk_attachmentrefer_attachment, referencedTableName=ujcms_attachment', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-114', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 114, '8:9ca8a046da88f8b58e0b4a0be5879e25', 'addForeignKeyConstraint baseTableName=ujcms_block, constraintName=fk_block_site, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-115', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 115, '8:f3a2a5f34f767e648fa3419f40665cd8', 'addForeignKeyConstraint baseTableName=ujcms_block_item, constraintName=fk_blockitem_article, referencedTableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-116', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 116, '8:99483bf2fe331c5fbedcb0dc2dd315ce', 'addForeignKeyConstraint baseTableName=ujcms_block_item, constraintName=fk_blockitem_block, referencedTableName=ujcms_block', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-117', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 117, '8:99fdc7d2032263cb0f097cf9daafe603', 'addForeignKeyConstraint baseTableName=ujcms_block_item, constraintName=fk_blockitem_site, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-118', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 118, '8:e42cb7fbdfa125106c2a5297d72b0114', 'addForeignKeyConstraint baseTableName=ujcms_channel_custom, constraintName=fk_channel_custom, referencedTableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-119', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 119, '8:1e614a6d5111d0e40a823b93da6d4e23', 'addForeignKeyConstraint baseTableName=ujcms_channel, constraintName=fk_channel_model_article, referencedTableName=ujcms_model', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-120', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 120, '8:86cd074ad4d4362fdcecd98983ee8e96', 'addForeignKeyConstraint baseTableName=ujcms_channel, constraintName=fk_channel_model_channel, referencedTableName=ujcms_model', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-121', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 121, '8:a7e7d5558235167b3b52faa17e86126e', 'addForeignKeyConstraint baseTableName=ujcms_channel, constraintName=fk_channel_parent, referencedTableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-122', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 122, '8:529e03010d34734abe93df7927602a91', 'addForeignKeyConstraint baseTableName=ujcms_channel, constraintName=fk_channel_site, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-123', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 123, '8:a8fff291e9a13d7cfc37c45c0f571b4d', 'addForeignKeyConstraint baseTableName=ujcms_channel_buffer, constraintName=fk_channelbuffer_channel, referencedTableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-124', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 124, '8:cae8cd913dcc64c40a086ede59bcdbfb', 'addForeignKeyConstraint baseTableName=ujcms_channel_ext, constraintName=fk_channelext_channel, referencedTableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-125', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 125, '8:2e08628ea0009171b46a28d9017b11dc', 'addForeignKeyConstraint baseTableName=ujcms_channel_tree, constraintName=fk_channeltree_ancestor, referencedTableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-126', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 126, '8:6361bfc11070e47043bc128e8ebac587', 'addForeignKeyConstraint baseTableName=ujcms_channel_tree, constraintName=fk_channeltree_descendant, referencedTableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-127', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 127, '8:1d445d5074ba1f90c34e81382fbc6128', 'addForeignKeyConstraint baseTableName=ujcms_dict, constraintName=fk_dict_dicttype, referencedTableName=ujcms_dict_type', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-128', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 128, '8:54720fd73d3e612b5a026d0e6de85fd3', 'addForeignKeyConstraint baseTableName=ujcms_dict, constraintName=fk_dict_parent, referencedTableName=ujcms_dict', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-129', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 129, '8:99af812a2e7804c66e7f4332acd1364f', 'addForeignKeyConstraint baseTableName=ujcms_dict_type, constraintName=fk_dicttype_site, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-130', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 130, '8:488adee3776724929d7a17e0b0467e43', 'addForeignKeyConstraint baseTableName=ujcms_group_access, constraintName=fk_groupaccess_channel, referencedTableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-131', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 131, '8:849dbfeb17e4ad71591ed3a6d91b1091', 'addForeignKeyConstraint baseTableName=ujcms_group_access, constraintName=fk_groupaccess_group, referencedTableName=ujcms_group', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-132', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 132, '8:38643ff8b69ba872a7a4c09a50f5804c', 'addForeignKeyConstraint baseTableName=ujcms_group_access, constraintName=fk_groupaccess_site, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-133', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 133, '8:e49d8e05b574cbf784101e657242cb8c', 'addForeignKeyConstraint baseTableName=ujcms_login_log, constraintName=fk_loginlog_user, referencedTableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-134', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 134, '8:82a2087616daf5abb3c9719c5f91cec2', 'addForeignKeyConstraint baseTableName=ujcms_org, constraintName=fk_org_parent, referencedTableName=ujcms_org', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-135', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 135, '8:fe21a3586660f9e9a29f3c452f2c9bdc', 'addForeignKeyConstraint baseTableName=ujcms_org_tree, constraintName=fk_orgtree_ancestor, referencedTableName=ujcms_org', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-136', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 136, '8:cb4c764694ecab7ab3667a6d20250916', 'addForeignKeyConstraint baseTableName=ujcms_org_tree, constraintName=fk_orgtree_descendant, referencedTableName=ujcms_org', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-137', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 137, '8:6c9e17974a7484f76df78172b8bc4e6b', 'addForeignKeyConstraint baseTableName=ujcms_push, constraintName=fk_push_article_from, referencedTableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-138', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 138, '8:cee0ef3abe402ca762a7725ef5e8ec9d', 'addForeignKeyConstraint baseTableName=ujcms_push, constraintName=fk_push_article_to, referencedTableName=ujcms_article', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-139', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 139, '8:0a5a2214112241226c7da7b4bd70b769', 'addForeignKeyConstraint baseTableName=ujcms_push, constraintName=fk_push_site_from, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-140', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 140, '8:d20da6260206c1ba8e1444fe636c2e4c', 'addForeignKeyConstraint baseTableName=ujcms_push, constraintName=fk_push_site_to, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-141', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 141, '8:ea9d85e9137ffaf77fe702305bf2edb2', 'addForeignKeyConstraint baseTableName=ujcms_push, constraintName=fk_push_user, referencedTableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-142', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 142, '8:e72083786268e25d78524e7226acd675', 'addForeignKeyConstraint baseTableName=ujcms_role, constraintName=fk_role_site, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-143', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 143, '8:f5bef1fb7da1a52af9edaf84bb85f62d', 'addForeignKeyConstraint baseTableName=ujcms_role_article, constraintName=fk_rolearticle_channel, referencedTableName=ujcms_channel', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-144', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 144, '8:300b018342788cb2ca194018f90fb4ca', 'addForeignKeyConstraint baseTableName=ujcms_role_article, constraintName=fk_rolearticle_role, referencedTableName=ujcms_role', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-145', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 145, '8:a10fcd99ec27947bcd0456e86f7781bb', 'addForeignKeyConstraint baseTableName=ujcms_role_article, constraintName=fk_rolearticle_site, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-146', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 146, '8:53cb0f2cc10544427bbb5e0551d21eaf', 'addForeignKeyConstraint baseTableName=ujcms_site, constraintName=fk_site_model, referencedTableName=ujcms_model', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-147', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 147, '8:3fe66e5b8677a415b07980db0a53f605', 'addForeignKeyConstraint baseTableName=ujcms_site, constraintName=fk_site_org, referencedTableName=ujcms_org', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-148', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 148, '8:ea49f37fc880e3c069d51271c6d9515e', 'addForeignKeyConstraint baseTableName=ujcms_site, constraintName=fk_site_parent, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-149', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 149, '8:04e5fa00f47f6f59fb4c16a7e8038042', 'addForeignKeyConstraint baseTableName=ujcms_site_buffer, constraintName=fk_sitebuffer_site, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-150', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 150, '8:fdc872f9af3687ed313569ba6a105924', 'addForeignKeyConstraint baseTableName=ujcms_site_custom, constraintName=fk_sitecustom_site, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-151', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 151, '8:2ee7d881cb27a1b1214e7bf771da1fbe', 'addForeignKeyConstraint baseTableName=ujcms_site_tree, constraintName=fk_sitetree_ancestor, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-152', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 152, '8:3b80625257cbfd4f45512c0168173280', 'addForeignKeyConstraint baseTableName=ujcms_site_tree, constraintName=fk_sitetree_descendant, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-153', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 153, '8:1fa44af6ffe1c71f79dbce1b4d850aeb', 'addForeignKeyConstraint baseTableName=ujcms_tag, constraintName=fk_tag_site, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-154', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 154, '8:bc421aa556dae9a7debd667cab82bec7', 'addForeignKeyConstraint baseTableName=ujcms_tag, constraintName=fk_tag_user, referencedTableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-155', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 155, '8:aef8626dc135c9b43fe2612f4e6573db', 'addForeignKeyConstraint baseTableName=ujcms_task, constraintName=fk_task_site, referencedTableName=ujcms_site', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-156', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 156, '8:25bba2d8a8e9631ed4628dc532729f9c', 'addForeignKeyConstraint baseTableName=ujcms_task, constraintName=fk_task_user, referencedTableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-157', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 157, '8:2b7114f9315397b596bfb6729d97643c', 'addForeignKeyConstraint baseTableName=ujcms_user, constraintName=fk_user_group, referencedTableName=ujcms_group', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-158', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 158, '8:f6615b34348b9d6bfd22bc6a5f241ff5', 'addForeignKeyConstraint baseTableName=ujcms_user, constraintName=fk_user_org, referencedTableName=ujcms_org', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-159', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 159, '8:0d8e2426676619569969e4b1ecc81b0b', 'addForeignKeyConstraint baseTableName=ujcms_user_ext, constraintName=fk_userext_user, referencedTableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-160', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 160, '8:09b208548138f4f252c6df5660466f9a', 'addForeignKeyConstraint baseTableName=ujcms_user_openid, constraintName=fk_useropenid_user, referencedTableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-161', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 161, '8:663005336304df0441fbab615a02e0c4', 'addForeignKeyConstraint baseTableName=ujcms_user_role, constraintName=fk_userrole_role, referencedTableName=ujcms_role', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID) VALUES ('1657513930480-162', 'PONY (generated)', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 162, '8:fbba1312f211f73b6b4a5ec42b7ff63e', 'addForeignKeyConstraint baseTableName=ujcms_user_role, constraintName=fk_userrole_user, referencedTableName=ujcms_user', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697');
INSERT INTO DATABASECHANGELOG (ID, AUTHOR, FILENAME, DATEEXECUTED, ORDEREXECUTED, MD5SUM, `DESCRIPTION`, COMMENTS, EXECTYPE, CONTEXTS, LABELS, LIQUIBASE, DEPLOYMENT_ID, TAG) VALUES ('4.0', 'PROJECT-VERSION', '/db/changelog/db.changelog-4.0-whole.yaml', NOW(), 163, '8:6d11a12b628b1bd2688c80f07104b319', 'tagDatabase', '', 'EXECUTED', NULL, NULL, '4.5.0', '7516267697', 'v4.0');
