package com.ujcms.cms.core.domain.base;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.springframework.lang.Nullable;

/**
 * This class was generated by MyBatis Generator.
 *
 * @author MyBatis Generator
 */
public class SiteBase implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 数据库表名
     */
    public static final String TABLE_NAME = "site";

    /**
     * 站点ID
     */
    @NotNull
    @Schema(description="站点ID")
    private Integer id = 0;

    /**
     * 上级站点ID
     */
    @Nullable
    @Schema(description="上级站点ID")
    private Integer parentId;

    /**
     * 组织ID
     */
    @NotNull
    @Schema(description="组织ID")
    private Integer orgId = 0;

    /**
     * 模型ID
     */
    @NotNull
    @Schema(description="模型ID")
    private Integer modelId = 0;

    /**
     * 名称
     */
    @Length(max = 50)
    @NotNull
    @Schema(description="名称")
    private String name = "";

    /**
     * 协议(http,https)
     */
    @Length(max = 20)
    @NotNull
    @Schema(description="协议(http,https)")
    private String protocol = "";

    /**
     * 域名
     */
    @Length(max = 50)
    @NotNull
    @Schema(description="域名")
    private String domain = "";

    /**
     * 子目录
     */
    @Length(max = 50)
    @Nullable
    @Schema(description="子目录")
    private String subDir;

    /**
     * 主题
     */
    @Length(max = 50)
    @NotNull
    @Schema(description="主题")
    private String theme = "default";

    /**
     * 手机端主题
     */
    @Length(max = 50)
    @NotNull
    @Schema(description="手机端主题")
    private String mobileTheme = "default";

    /**
     * 每页条数
     */
    @NotNull
    @Schema(description="每页条数")
    private Short pageSize = 20;

    /**
     * LOGO
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="LOGO")
    private String logo;

    /**
     * SEO标题
     */
    @Length(max = 150)
    @Nullable
    @Schema(description="SEO标题")
    private String seoTitle;

    /**
     * SEO关键词
     */
    @Length(max = 150)
    @Nullable
    @Schema(description="SEO关键词")
    private String seoKeywords;

    /**
     * SEO描述
     */
    @Length(max = 1000)
    @Nullable
    @Schema(description="SEO描述")
    private String seoDescription;

    /**
     * 静态页文件
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="静态页文件")
    private String staticFile;

    /**
     * 手机端静态页文件
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="手机端静态页文件")
    private String mobileStaticFile;

    /**
     * 水印设置
     */
    @Length(max = 1000)
    @Nullable
    @Schema(description="水印设置")
    private String watermarkSettings;

    /**
     * 静态页设置
     */
    @Length(max = 1000)
    @Nullable
    @Schema(description="静态页设置")
    private String htmlSettings;

    /**
     * 留言板设置
     */
    @Length(max = 1000)
    @Nullable
    @Schema(description="留言板设置")
    private String messageBoardSettings;

    /**
     * 层级
     */
    @NotNull
    @Schema(description="层级")
    private Short depth = 1;

    /**
     * 排序
     */
    @NotNull
    @Schema(description="排序")
    private Integer order = 999999;

    /**
     * 状态(0:正常,1:关闭)
     */
    @NotNull
    @Schema(description="状态(0:正常,1:关闭)")
    private Short status = 0;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Nullable
    public Integer getParentId() {
        return parentId;
    }

    public void setParentId(@Nullable Integer parentId) {
        this.parentId = parentId;
    }

    public Integer getOrgId() {
        return orgId;
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public Integer getModelId() {
        return modelId;
    }

    public void setModelId(Integer modelId) {
        this.modelId = modelId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getProtocol() {
        return protocol;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getDomain() {
        return domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Nullable
    public String getSubDir() {
        return subDir;
    }

    public void setSubDir(@Nullable String subDir) {
        this.subDir = subDir;
    }

    public String getTheme() {
        return theme;
    }

    public void setTheme(String theme) {
        this.theme = theme;
    }

    public String getMobileTheme() {
        return mobileTheme;
    }

    public void setMobileTheme(String mobileTheme) {
        this.mobileTheme = mobileTheme;
    }

    public Short getPageSize() {
        return pageSize;
    }

    public void setPageSize(Short pageSize) {
        this.pageSize = pageSize;
    }

    @Nullable
    public String getLogo() {
        return logo;
    }

    public void setLogo(@Nullable String logo) {
        this.logo = logo;
    }

    @Nullable
    public String getSeoTitle() {
        return seoTitle;
    }

    public void setSeoTitle(@Nullable String seoTitle) {
        this.seoTitle = seoTitle;
    }

    @Nullable
    public String getSeoKeywords() {
        return seoKeywords;
    }

    public void setSeoKeywords(@Nullable String seoKeywords) {
        this.seoKeywords = seoKeywords;
    }

    @Nullable
    public String getSeoDescription() {
        return seoDescription;
    }

    public void setSeoDescription(@Nullable String seoDescription) {
        this.seoDescription = seoDescription;
    }

    @Nullable
    public String getStaticFile() {
        return staticFile;
    }

    public void setStaticFile(@Nullable String staticFile) {
        this.staticFile = staticFile;
    }

    @Nullable
    public String getMobileStaticFile() {
        return mobileStaticFile;
    }

    public void setMobileStaticFile(@Nullable String mobileStaticFile) {
        this.mobileStaticFile = mobileStaticFile;
    }

    @Nullable
    public String getWatermarkSettings() {
        return watermarkSettings;
    }

    public void setWatermarkSettings(@Nullable String watermarkSettings) {
        this.watermarkSettings = watermarkSettings;
    }

    @Nullable
    public String getHtmlSettings() {
        return htmlSettings;
    }

    public void setHtmlSettings(@Nullable String htmlSettings) {
        this.htmlSettings = htmlSettings;
    }

    @Nullable
    public String getMessageBoardSettings() {
        return messageBoardSettings;
    }

    public void setMessageBoardSettings(@Nullable String messageBoardSettings) {
        this.messageBoardSettings = messageBoardSettings;
    }

    public Short getDepth() {
        return depth;
    }

    public void setDepth(Short depth) {
        this.depth = depth;
    }

    public Integer getOrder() {
        return order;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }
}