package com.ujcms.cms.core.domain.base;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;

/**
 * This class was generated by MyBatis Generator.
 *
 * @author MyBatis Generator
 */
public class OperationLogBase implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 数据库表名
     */
    public static final String TABLE_NAME = "operation_log";

    /**
     * 操作日志ID
     */
    @NotNull
    @Schema(description="操作日志ID")
    private Long id = 0L;

    /**
     * 站点ID
     */
    @NotNull
    @Schema(description="站点ID")
    private Integer siteId = 0;

    /**
     * 用户ID
     */
    @NotNull
    @Schema(description="用户ID")
    private Integer userId = 0;

    /**
     * 名称
     */
    @Length(max = 50)
    @NotNull
    @Schema(description="名称")
    private String name = "";

    /**
     * 模块
     */
    @Length(max = 50)
    @NotNull
    @Schema(description="模块")
    private String module = "";

    /**
     * 请求方法
     */
    @Length(max = 10)
    @NotNull
    @Schema(description="请求方法")
    private String requestMethod = "";

    /**
     * IP地址
     */
    @Length(max = 45)
    @NotNull
    @Schema(description="IP地址")
    private String ip = "";

    /**
     * 创建日期
     */
    @NotNull
    @Schema(description="创建日期")
    private OffsetDateTime created = OffsetDateTime.now();

    /**
     * 是否审计日志
     */
    @NotNull
    @Schema(description="是否审计日志")
    private Boolean audit = false;

    /**
     * 类型(0:其它,1:新增,2:修改,3:删除)
     */
    @NotNull
    @Schema(description="类型(0:其它,1:新增,2:修改,3:删除)")
    private Short type = 0;

    /**
     * 状态(0:失败,1:成功)
     */
    @NotNull
    @Schema(description="状态(0:失败,1:成功)")
    private Short status = 1;

    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Integer getSiteId() {
        return siteId;
    }

    public void setSiteId(Integer siteId) {
        this.siteId = siteId;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModule() {
        return module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getRequestMethod() {
        return requestMethod;
    }

    public void setRequestMethod(String requestMethod) {
        this.requestMethod = requestMethod;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public OffsetDateTime getCreated() {
        return created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public Boolean getAudit() {
        return audit;
    }

    public void setAudit(Boolean audit) {
        this.audit = audit;
    }

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }
}