package com.ujcms.cms.core.domain.base;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.springframework.lang.Nullable;

/**
 * This class was generated by MyBatis Generator.
 *
 * @author MyBatis Generator
 */
public class ModelBase implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 数据库表名
     */
    public static final String TABLE_NAME = "model";

    /**
     * 模型ID
     */
    @NotNull
    @Schema(description="模型ID")
    private Integer id = 0;

    /**
     * 站点ID
     */
    @Nullable
    @Schema(description="站点ID")
    private Integer siteId;

    /**
     * 名称
     */
    @Length(max = 50)
    @NotNull
    @Schema(description="名称")
    private String name = "";

    /**
     * 类型(article:文章,channel:栏目,user:用户,site:站点设置,global:全局设置)
     */
    @Length(max = 32)
    @NotNull
    @Schema(description="类型(article:文章,channel:栏目,user:用户,site:站点设置,global:全局设置)")
    private String type = "";

    /**
     * 共享范围(0:本站私有,1:子站点共享,2:全局共享)
     */
    @NotNull
    @Schema(description="共享范围(0:本站私有,1:子站点共享,2:全局共享)")
    private Short scope = 0;

    /**
     * 排列顺序
     */
    @NotNull
    @Schema(description="排列顺序")
    private Short order = 32767;

    /**
     * 主字段集
     */
    @Nullable
    @Schema(description="主字段集")
    private String mains;

    /**
     * 右侧字段集
     */
    @Nullable
    @Schema(description="右侧字段集")
    private String asides;

    /**
     * 自定义字段集
     */
    @Nullable
    @Schema(description="自定义字段集")
    private String customs;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Nullable
    public Integer getSiteId() {
        return siteId;
    }

    public void setSiteId(@Nullable Integer siteId) {
        this.siteId = siteId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Short getScope() {
        return scope;
    }

    public void setScope(Short scope) {
        this.scope = scope;
    }

    public Short getOrder() {
        return order;
    }

    public void setOrder(Short order) {
        this.order = order;
    }

    @Nullable
    public String getMains() {
        return mains;
    }

    public void setMains(@Nullable String mains) {
        this.mains = mains;
    }

    @Nullable
    public String getAsides() {
        return asides;
    }

    public void setAsides(@Nullable String asides) {
        this.asides = asides;
    }

    @Nullable
    public String getCustoms() {
        return customs;
    }

    public void setCustoms(@Nullable String customs) {
        this.customs = customs;
    }
}