package com.ujcms.cms.core.domain.base;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.springframework.lang.Nullable;

/**
 * This class was generated by MyBatis Generator.
 *
 * @author MyBatis Generator
 */
public class LoginLogBase implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 数据库表名
     */
    public static final String TABLE_NAME = "login_log";

    /**
     * 登录日志ID
     */
    @NotNull
    @Schema(description="登录日志ID")
    private Integer id = 0;

    /**
     * 用户ID
     */
    @Nullable
    @Schema(description="用户ID")
    private Integer userId;

    /**
     * 登录名
     */
    @Length(max = 30)
    @Nullable
    @Schema(description="登录名")
    private String loginName;

    /**
     * IP地址
     */
    @Length(max = 45)
    @NotNull
    @Schema(description="IP地址")
    private String ip = "";

    /**
     * 创建日期
     */
    @NotNull
    @Schema(description="创建日期")
    private OffsetDateTime created = OffsetDateTime.now();

    /**
     * 类型(1:登录,2:修改密码,9:退出)
     */
    @NotNull
    @Schema(description="类型(1:登录,2:修改密码,9:退出)")
    private Short type = 0;

    /**
     * 状态(0:成功,1:用户名不存在,2:密码错误,3:验证码错误,4:短信错误)
     */
    @NotNull
    @Schema(description="状态(0:成功,1:用户名不存在,2:密码错误,3:验证码错误,4:短信错误)")
    private Short status = 1;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Nullable
    public Integer getUserId() {
        return userId;
    }

    public void setUserId(@Nullable Integer userId) {
        this.userId = userId;
    }

    @Nullable
    public String getLoginName() {
        return loginName;
    }

    public void setLoginName(@Nullable String loginName) {
        this.loginName = loginName;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public OffsetDateTime getCreated() {
        return created;
    }

    public void setCreated(OffsetDateTime created) {
        this.created = created;
    }

    public Short getType() {
        return type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }
}