package com.ujcms.cms.core.domain.base;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.springframework.lang.Nullable;

/**
 * This class was generated by MyBatis Generator.
 *
 * @author MyBatis Generator
 */
public class DictTypeBase implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 数据库表名
     */
    public static final String TABLE_NAME = "dict_type";

    /**
     * 字典类型ID
     */
    @NotNull
    @Schema(description="字典类型ID")
    private Integer id = 0;

    /**
     * 站点ID
     */
    @Nullable
    @Schema(description="站点ID")
    private Integer siteId;

    /**
     * 名称
     */
    @Length(max = 50)
    @NotNull
    @Schema(description="名称")
    private String name = "";

    /**
     * 别名
     */
    @Length(max = 50)
    @NotNull
    @Schema(description="别名")
    private String alias = "";

    /**
     * 备注
     */
    @Length(max = 300)
    @Nullable
    @Schema(description="备注")
    private String remark;

    /**
     * 共享范围(0:本站私有,1:子站点共享,2:全局共享)
     */
    @NotNull
    @Schema(description="共享范围(0:本站私有,1:子站点共享,2:全局共享)")
    private Short scope = 0;

    /**
     * 排列顺序
     */
    @NotNull
    @Schema(description="排列顺序")
    private Short order = 32767;

    /**
     * 是否系统字典
     */
    @NotNull
    @Schema(description="是否系统字典")
    private Boolean sys = false;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Nullable
    public Integer getSiteId() {
        return siteId;
    }

    public void setSiteId(@Nullable Integer siteId) {
        this.siteId = siteId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Nullable
    public String getRemark() {
        return remark;
    }

    public void setRemark(@Nullable String remark) {
        this.remark = remark;
    }

    public Short getScope() {
        return scope;
    }

    public void setScope(Short scope) {
        this.scope = scope;
    }

    public Short getOrder() {
        return order;
    }

    public void setOrder(Short order) {
        this.order = order;
    }

    public Boolean getSys() {
        return sys;
    }

    public void setSys(Boolean sys) {
        this.sys = sys;
    }
}