package com.ujcms.cms.core.domain.base;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.springframework.lang.Nullable;

/**
 * This class was generated by MyBatis Generator.
 *
 * @author MyBatis Generator
 */
public class ChannelExtBase implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 数据库表名
     */
    public static final String TABLE_NAME = "channel_ext";

    /**
     * 栏目ID
     */
    @NotNull
    @Schema(description="栏目ID")
    private Integer id = 0;

    /**
     * SEO标题
     */
    @Length(max = 150)
    @Nullable
    @Schema(description="SEO标题")
    private String seoTitle;

    /**
     * SEO关键词
     */
    @Length(max = 150)
    @Nullable
    @Schema(description="SEO关键词")
    private String seoKeywords;

    /**
     * SEO描述
     */
    @Length(max = 1000)
    @Nullable
    @Schema(description="SEO描述")
    private String seoDescription;

    /**
     * 文章模板
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="文章模板")
    private String articleTemplate;

    /**
     * 栏目模板
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="栏目模板")
    private String channelTemplate;

    /**
     * 每页条数
     */
    @NotNull
    @Schema(description="每页条数")
    private Short pageSize = 20;

    /**
     * 图片
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="图片")
    private String image;

    /**
     * 转向链接地址
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="转向链接地址")
    private String linkUrl;

    /**
     * 是否新窗口打开
     */
    @NotNull
    @Schema(description="是否新窗口打开")
    private Boolean targetBlank = false;

    /**
     * 是否允许评论
     */
    @NotNull
    @Schema(description="是否允许评论")
    private Boolean allowComment = true;

    /**
     * 是否允许投稿
     */
    @NotNull
    @Schema(description="是否允许投稿")
    private Boolean allowContribute = false;

    /**
     * 是否允许搜索
     */
    @NotNull
    @Schema(description="是否允许搜索")
    private Boolean allowSearch = true;

    /**
     * 静态页文件
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="静态页文件")
    private String staticFile;

    /**
     * 手机端静态页文件
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="手机端静态页文件")
    private String mobileStaticFile;

    /**
     * 正文
     */
    @Nullable
    @Schema(description="正文")
    private String text;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Nullable
    public String getSeoTitle() {
        return seoTitle;
    }

    public void setSeoTitle(@Nullable String seoTitle) {
        this.seoTitle = seoTitle;
    }

    @Nullable
    public String getSeoKeywords() {
        return seoKeywords;
    }

    public void setSeoKeywords(@Nullable String seoKeywords) {
        this.seoKeywords = seoKeywords;
    }

    @Nullable
    public String getSeoDescription() {
        return seoDescription;
    }

    public void setSeoDescription(@Nullable String seoDescription) {
        this.seoDescription = seoDescription;
    }

    @Nullable
    public String getArticleTemplate() {
        return articleTemplate;
    }

    public void setArticleTemplate(@Nullable String articleTemplate) {
        this.articleTemplate = articleTemplate;
    }

    @Nullable
    public String getChannelTemplate() {
        return channelTemplate;
    }

    public void setChannelTemplate(@Nullable String channelTemplate) {
        this.channelTemplate = channelTemplate;
    }

    public Short getPageSize() {
        return pageSize;
    }

    public void setPageSize(Short pageSize) {
        this.pageSize = pageSize;
    }

    @Nullable
    public String getImage() {
        return image;
    }

    public void setImage(@Nullable String image) {
        this.image = image;
    }

    @Nullable
    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(@Nullable String linkUrl) {
        this.linkUrl = linkUrl;
    }

    public Boolean getTargetBlank() {
        return targetBlank;
    }

    public void setTargetBlank(Boolean targetBlank) {
        this.targetBlank = targetBlank;
    }

    public Boolean getAllowComment() {
        return allowComment;
    }

    public void setAllowComment(Boolean allowComment) {
        this.allowComment = allowComment;
    }

    public Boolean getAllowContribute() {
        return allowContribute;
    }

    public void setAllowContribute(Boolean allowContribute) {
        this.allowContribute = allowContribute;
    }

    public Boolean getAllowSearch() {
        return allowSearch;
    }

    public void setAllowSearch(Boolean allowSearch) {
        this.allowSearch = allowSearch;
    }

    @Nullable
    public String getStaticFile() {
        return staticFile;
    }

    public void setStaticFile(@Nullable String staticFile) {
        this.staticFile = staticFile;
    }

    @Nullable
    public String getMobileStaticFile() {
        return mobileStaticFile;
    }

    public void setMobileStaticFile(@Nullable String mobileStaticFile) {
        this.mobileStaticFile = mobileStaticFile;
    }

    @Nullable
    public String getText() {
        return text;
    }

    public void setText(@Nullable String text) {
        this.text = text;
    }
}