package com.ujcms.cms.core.domain.base;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.springframework.lang.Nullable;

/**
 * This class was generated by MyBatis Generator.
 *
 * @author MyBatis Generator
 */
public class BlockItemBase implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 数据库表名
     */
    public static final String TABLE_NAME = "block_item";

    /**
     * 区块项ID
     */
    @NotNull
    @Schema(description="区块项ID")
    private Integer id = 0;

    /**
     * 站点ID
     */
    @NotNull
    @Schema(description="站点ID")
    private Integer siteId = 0;

    /**
     * 区块ID
     */
    @NotNull
    @Schema(description="区块ID")
    private Integer blockId = 0;

    /**
     * 文章ID
     */
    @Nullable
    @Schema(description="文章ID")
    private Integer articleId;

    /**
     * 标题
     */
    @Length(max = 150)
    @NotNull
    @Schema(description="标题")
    private String title = "";

    /**
     * 副标题
     */
    @Length(max = 150)
    @Nullable
    @Schema(description="副标题")
    private String subtitle;

    /**
     * 描述
     */
    @Length(max = 1000)
    @Nullable
    @Schema(description="描述")
    private String description;

    /**
     * 链接
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="链接")
    private String linkUrl;

    /**
     * 图片
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="图片")
    private String image;

    /**
     * 手机端图片
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="手机端图片")
    private String mobileImage;

    /**
     * 视频
     */
    @Length(max = 255)
    @Nullable
    @Schema(description="视频")
    private String video;

    /**
     * 是否新窗口打开
     */
    @NotNull
    @Schema(description="是否新窗口打开")
    private Boolean targetBlank = false;

    /**
     * 是否启用
     */
    @NotNull
    @Schema(description="是否启用")
    private Boolean enabled = true;

    /**
     * 排序
     */
    @NotNull
    @Schema(description="排序")
    private Short order = 32767;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getSiteId() {
        return siteId;
    }

    public void setSiteId(Integer siteId) {
        this.siteId = siteId;
    }

    public Integer getBlockId() {
        return blockId;
    }

    public void setBlockId(Integer blockId) {
        this.blockId = blockId;
    }

    @Nullable
    public Integer getArticleId() {
        return articleId;
    }

    public void setArticleId(@Nullable Integer articleId) {
        this.articleId = articleId;
    }

    public String getTitle() {
        return title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    @Nullable
    public String getSubtitle() {
        return subtitle;
    }

    public void setSubtitle(@Nullable String subtitle) {
        this.subtitle = subtitle;
    }

    @Nullable
    public String getDescription() {
        return description;
    }

    public void setDescription(@Nullable String description) {
        this.description = description;
    }

    @Nullable
    public String getLinkUrl() {
        return linkUrl;
    }

    public void setLinkUrl(@Nullable String linkUrl) {
        this.linkUrl = linkUrl;
    }

    @Nullable
    public String getImage() {
        return image;
    }

    public void setImage(@Nullable String image) {
        this.image = image;
    }

    @Nullable
    public String getMobileImage() {
        return mobileImage;
    }

    public void setMobileImage(@Nullable String mobileImage) {
        this.mobileImage = mobileImage;
    }

    @Nullable
    public String getVideo() {
        return video;
    }

    public void setVideo(@Nullable String video) {
        this.video = video;
    }

    public Boolean getTargetBlank() {
        return targetBlank;
    }

    public void setTargetBlank(Boolean targetBlank) {
        this.targetBlank = targetBlank;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Short getOrder() {
        return order;
    }

    public void setOrder(Short order) {
        this.order = order;
    }
}