package com.ujcms.cms.core.domain.base;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.Length;
import org.springframework.lang.Nullable;

/**
 * This class was generated by MyBatis Generator.
 *
 * @author MyBatis Generator
 */
public class BlockBase implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 数据库表名
     */
    public static final String TABLE_NAME = "block";

    /**
     * 区块ID
     */
    @NotNull
    @Schema(description="区块ID")
    private Integer id = 0;

    /**
     * 站点ID
     */
    @Nullable
    @Schema(description="站点ID")
    private Integer siteId;

    /**
     * 名称
     */
    @Length(max = 50)
    @NotNull
    @Schema(description="名称")
    private String name = "";

    /**
     * 别名
     */
    @Length(max = 50)
    @NotNull
    @Schema(description="别名")
    private String alias = "";

    /**
     * 共享范围(0:本站私有,1:子站点共享,2:全局共享)
     */
    @NotNull
    @Schema(description="共享范围(0:本站私有,1:子站点共享,2:全局共享)")
    private Short scope = 0;

    /**
     * 是否有URL链接
     */
    @NotNull
    @Schema(description="是否有URL链接")
    private Boolean withLinkUrl = true;

    /**
     * 是否有副标题
     */
    @NotNull
    @Schema(description="是否有副标题")
    private Boolean withSubtitle = false;

    /**
     * 是否有摘要
     */
    @NotNull
    @Schema(description="是否有摘要")
    private Boolean withDescription = false;

    /**
     * 是否有图片
     */
    @NotNull
    @Schema(description="是否有图片")
    private Boolean withImage = false;

    /**
     * 是否有手机端图片
     */
    @NotNull
    @Schema(description="是否有手机端图片")
    private Boolean withMobileImage = false;

    /**
     * 是否有视频
     */
    @NotNull
    @Schema(description="是否有视频")
    private Boolean withVideo = false;

    /**
     * URL链接是否必填
     */
    @NotNull
    @Schema(description="URL链接是否必填")
    private Boolean linkUrlRequired = true;

    /**
     * 副标题是否必填
     */
    @NotNull
    @Schema(description="副标题是否必填")
    private Boolean subtitleRequired = false;

    /**
     * 摘要是否必填
     */
    @NotNull
    @Schema(description="摘要是否必填")
    private Boolean descriptionRequired = false;

    /**
     * 图片是否必填
     */
    @NotNull
    @Schema(description="图片是否必填")
    private Boolean imageRequired = false;

    /**
     * 手机图片是否必填
     */
    @NotNull
    @Schema(description="手机图片是否必填")
    private Boolean mobileImageRequired = false;

    /**
     * 视频是否必填
     */
    @NotNull
    @Schema(description="视频是否必填")
    private Boolean videoRequired = false;

    /**
     * 图片宽度
     */
    @NotNull
    @Schema(description="图片宽度")
    private Integer imageWidth = 300;

    /**
     * 图片高度
     */
    @NotNull
    @Schema(description="图片高度")
    private Integer imageHeight = 200;

    /**
     * 手机端图片宽度
     */
    @NotNull
    @Schema(description="手机端图片宽度")
    private Integer mobileImageWidth = 300;

    /**
     * 手机端图片高度
     */
    @NotNull
    @Schema(description="手机端图片高度")
    private Integer mobileImageHeight = 200;

    /**
     * 是否可推荐
     */
    @NotNull
    @Schema(description="是否可推荐")
    private Boolean recommendable = true;

    /**
     * 是否启用
     */
    @NotNull
    @Schema(description="是否启用")
    private Boolean enabled = true;

    /**
     * 排序
     */
    @NotNull
    @Schema(description="排序")
    private Short order = 32767;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    @Nullable
    public Integer getSiteId() {
        return siteId;
    }

    public void setSiteId(@Nullable Integer siteId) {
        this.siteId = siteId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAlias() {
        return alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public Short getScope() {
        return scope;
    }

    public void setScope(Short scope) {
        this.scope = scope;
    }

    public Boolean getWithLinkUrl() {
        return withLinkUrl;
    }

    public void setWithLinkUrl(Boolean withLinkUrl) {
        this.withLinkUrl = withLinkUrl;
    }

    public Boolean getWithSubtitle() {
        return withSubtitle;
    }

    public void setWithSubtitle(Boolean withSubtitle) {
        this.withSubtitle = withSubtitle;
    }

    public Boolean getWithDescription() {
        return withDescription;
    }

    public void setWithDescription(Boolean withDescription) {
        this.withDescription = withDescription;
    }

    public Boolean getWithImage() {
        return withImage;
    }

    public void setWithImage(Boolean withImage) {
        this.withImage = withImage;
    }

    public Boolean getWithMobileImage() {
        return withMobileImage;
    }

    public void setWithMobileImage(Boolean withMobileImage) {
        this.withMobileImage = withMobileImage;
    }

    public Boolean getWithVideo() {
        return withVideo;
    }

    public void setWithVideo(Boolean withVideo) {
        this.withVideo = withVideo;
    }

    public Boolean getLinkUrlRequired() {
        return linkUrlRequired;
    }

    public void setLinkUrlRequired(Boolean linkUrlRequired) {
        this.linkUrlRequired = linkUrlRequired;
    }

    public Boolean getSubtitleRequired() {
        return subtitleRequired;
    }

    public void setSubtitleRequired(Boolean subtitleRequired) {
        this.subtitleRequired = subtitleRequired;
    }

    public Boolean getDescriptionRequired() {
        return descriptionRequired;
    }

    public void setDescriptionRequired(Boolean descriptionRequired) {
        this.descriptionRequired = descriptionRequired;
    }

    public Boolean getImageRequired() {
        return imageRequired;
    }

    public void setImageRequired(Boolean imageRequired) {
        this.imageRequired = imageRequired;
    }

    public Boolean getMobileImageRequired() {
        return mobileImageRequired;
    }

    public void setMobileImageRequired(Boolean mobileImageRequired) {
        this.mobileImageRequired = mobileImageRequired;
    }

    public Boolean getVideoRequired() {
        return videoRequired;
    }

    public void setVideoRequired(Boolean videoRequired) {
        this.videoRequired = videoRequired;
    }

    public Integer getImageWidth() {
        return imageWidth;
    }

    public void setImageWidth(Integer imageWidth) {
        this.imageWidth = imageWidth;
    }

    public Integer getImageHeight() {
        return imageHeight;
    }

    public void setImageHeight(Integer imageHeight) {
        this.imageHeight = imageHeight;
    }

    public Integer getMobileImageWidth() {
        return mobileImageWidth;
    }

    public void setMobileImageWidth(Integer mobileImageWidth) {
        this.mobileImageWidth = mobileImageWidth;
    }

    public Integer getMobileImageHeight() {
        return mobileImageHeight;
    }

    public void setMobileImageHeight(Integer mobileImageHeight) {
        this.mobileImageHeight = mobileImageHeight;
    }

    public Boolean getRecommendable() {
        return recommendable;
    }

    public void setRecommendable(Boolean recommendable) {
        this.recommendable = recommendable;
    }

    public Boolean getEnabled() {
        return enabled;
    }

    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public Short getOrder() {
        return order;
    }

    public void setOrder(Short order) {
        this.order = order;
    }
}