package com.ujcms.cms.core.domain.base;

import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.time.OffsetDateTime;
import javax.validation.constraints.NotNull;
import org.springframework.lang.Nullable;

/**
 * This class was generated by MyBatis Generator.
 *
 * @author MyBatis Generator
 */
public class ArticleBase implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 数据库表名
     */
    public static final String TABLE_NAME = "article";

    /**
     * 文章ID
     */
    @NotNull
    @Schema(description="文章ID")
    private Integer id = 0;

    /**
     * 站点ID
     */
    @NotNull
    @Schema(description="站点ID")
    private Integer siteId = 0;

    /**
     * 组织ID
     */
    @NotNull
    @Schema(description="组织ID")
    private Integer orgId = 0;

    /**
     * 栏目ID
     */
    @NotNull
    @Schema(description="栏目ID")
    private Integer channelId = 0;

    /**
     * 创建用户ID
     */
    @NotNull
    @Schema(description="创建用户ID")
    private Integer userId = 0;

    /**
     * 修改用户ID
     */
    @Nullable
    @Schema(description="修改用户ID")
    private Integer modifiedUserId;

    /**
     * 发布日期
     */
    @NotNull
    @Schema(description="发布日期")
    private OffsetDateTime publishDate = OffsetDateTime.now();

    /**
     * 是否有图片
     */
    @NotNull
    @Schema(description="是否有图片")
    private Boolean withImage = false;

    /**
     * 置顶
     */
    @NotNull
    @Schema(description="置顶")
    private Short sticky = 0;

    /**
     * 状态(0:正常,100:已删除)
     */
    @NotNull
    @Schema(description="状态(0:正常,100:已删除)")
    private Short status = 0;

    public Integer getId() {
        return id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Integer getSiteId() {
        return siteId;
    }

    public void setSiteId(Integer siteId) {
        this.siteId = siteId;
    }

    public Integer getOrgId() {
        return orgId;
    }

    public void setOrgId(Integer orgId) {
        this.orgId = orgId;
    }

    public Integer getChannelId() {
        return channelId;
    }

    public void setChannelId(Integer channelId) {
        this.channelId = channelId;
    }

    public Integer getUserId() {
        return userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    @Nullable
    public Integer getModifiedUserId() {
        return modifiedUserId;
    }

    public void setModifiedUserId(@Nullable Integer modifiedUserId) {
        this.modifiedUserId = modifiedUserId;
    }

    public OffsetDateTime getPublishDate() {
        return publishDate;
    }

    public void setPublishDate(OffsetDateTime publishDate) {
        this.publishDate = publishDate;
    }

    public Boolean getWithImage() {
        return withImage;
    }

    public void setWithImage(Boolean withImage) {
        this.withImage = withImage;
    }

    public Short getSticky() {
        return sticky;
    }

    public void setSticky(Short sticky) {
        this.sticky = sticky;
    }

    public Short getStatus() {
        return status;
    }

    public void setStatus(Short status) {
        this.status = status;
    }
}