# UJCMS 发版说明

## ujcms-5.5.1 (2023-01-09)

* 修复文章管理、栏目管理的外部链接字段xss漏洞

## ujcms-5.5.0 (2023-01-06)

* 新增留言板功能
* 新增登录、注册、找回密码功能
* 新增会员中心、修改基本信息、修改头像功能
* 新增第三方登录功能
* 新增从正文提取图片功能
* 新增文章置顶功能
* 新增操作日志功能
* 新增浏览权限、栏目权限功能
* 安全框架从Shiro改为Spring Security
* 已知BUG修复

### 升级指南

* **注意**：下载地址`${dy}/download/...`变更为`${dy}/download-file/...`。由于`download`地址比较常用，换成不易冲突的地址。
* **注意**：密码加密方式改为Spring Security的方式加密，密码和salt放到了同一个字段里。这将导致原密码无法登录，需要到数据库重置密码，将`ujcms_user`表的`password_`字段修改为`{pbkdf2}0Knzbc+J3Fkl5/mlJBrwLFOUwOvoBANcrfCgVvrjCSIBjnazXupYVw==`，密码将被重置为`password`。
* **注意**：执行`upgrade/mysql/mysql_upgrade_40to55.sql`升级数据库（先启动程序，升级表结构后，再执行该脚本）。

## ujcms-4.1.2 (2022-07-21)

* 升级shiro至1.9.1版本
* 修复角色权限设置在切换角色时，功能权限、文章权限无法正常赋值
* 补传ProcessTaskList.vue文件

## ujcms-4.1.1 (2022-07-18)

* Flowable工作流
* 流程可视化设计
* 流程部署
* 流程实例
* 历史流程
* 文章审核
* 文章驳回及理由
* 文章状态（草稿、下线、归档、删除）
* 文章审核过程
* 文章数据权限
* 增加音频字段
* 自动获取视频、音频时长
* 自动获取视频截图
* SiteMap功能
* 密码复杂度
* 密码过期
* 强制历史密码
* 用户登录错误超过次数锁定登录
* IP登录错误超过次数锁定登录
* 登录验证码
* 双因子验证
* 短信服务（阿里短信、腾讯短信）
* 拖拽上传
* 登录日志
* 短信日志
* 自定义字段保存数据类型
* 自定义字段字典数据同时保存字典KEY和字典NAME
* 自定义字段中上传字段可设置的文件类型和大小限制

### 升级指南

* **注意**：自定义字段中如涉及下拉选择、单选框、复选框等字典数据，会因自定义字段保存数据的方式改为同时保存字典KEY和字典NAME（之前只保存字典NAME），并以字典KEY作为判断标准，从而使得后台管理时相关自定义字段数据丢失。
* **注意**：本次升级重做了liquibase的changelog。无法通过程序自动升级数据库表结构，需手动执行`upgrade/mysql/mysql_upgrade_3to4_whole.sql`进行升级。如果之前是2.0版本的，需要先升级到3.0（使用3.0的程序，并启动，让程序自动把数据库升级到3.0），再执行`mysql_upgrade_3to4_whole.sql`将数据库升级到4.0。

## ujcms-3.1.0 (2022-06-17)

* 新增：sitemap功能

## ujcms-3.0.1 (2022-06-15)

* 修复：下载链接失效问题
* 修复：上传文件后缀限制区分大小写问题
* 修复：管理员后台权限菜单显示空菜单问题
* 修复：图片上传都默认生成了缩略图
* 修复：删除栏目静态页只删除第一页问题
* 修复：栏目静态页只生成前几页的情况下，后几页地址还是静态页地址，导致404错误

## ujcms-3.0.0 (2022-06-12)

* 新增：系统信息功能
* 新增：密码使用国密PBKDF2WithHmacSM3加密
* 新增：登录时密码传输使用国密SM2非对称加密
* 新增：JWT使用国密HmacSM3加密
* 新增：JWT token使用国密SM4加密
* 新增：随机密钥生成功能
* 新增：前台模板使用escape标签处理XSS和空值问题
* 新增：后台管理界面多页签功能
* 新增：后台管理界面session失效后，自动显示登录框，登录后保留在原页面，防止页面数据丢失
* 新增：区块项新增功能
* 新增：DOC导入功能
* 新增：文库转换功能
* 新增：文库封面自动截图
* 新增：文章管理增加Markdown编辑器
* 新增：附件、HTML静态页、模板支持对象存储（MinIO、阿里云对象存储、腾讯云对象存储、七牛云对象存储）
* 优化：富文本编辑器的字体从16px改为14px
* 优化：富文本编辑器即时校验功能
* 优化：增加上传功能的错误提示
* 优化：application.properties改为application.yaml，避免注释的中文无法在普通编辑器中显示
* 修复：文章管理图片集上传框未对齐
* 修复：删除有图片集的文章报错
* 修复：视频无法上传

### 升级指南

* 使用escape标签处理XSS和空值。所有freemarker页面使用`[#escape x as (x)!?html]`开头和`[/#escape]`结尾；使用`[#noescape]...[/#noescape]`功能替换原有的`?no_esc`
* 密码需用新算法重置

## ujcms-2.0.2 (2022-03-21)

* 修复：文章管理中没有编辑器的页面无法提交

## ujcms-2.0.1 (2022-03-19)

* 许可协议由 AGPL-3 改为 GPL-2
* 开放组织管理功能
* 增加全局设置中栏目URL和文章URL自定义地址的合法校验
* 增加站点设置中域名的合法校验
* 修复：前台搜索报错（ChannelInnerBase不能转换为Anchor）
* 升级owasp-java-html-sanitizer组件版本至20211018.2
* 升级guava组件版本至30.1-jre

## ujcms-2.0.0 (2022-03-08)

* 新增静态页生成功能
* 新增静态页设置功能
* 新增任务管理功能
* 新增防盗链下载功能
* 新增下载文件名可为中文
* 数据库表结构自动创建及自动升级功能
* 首次运行数据自动初始化
* 支持国产数据库
* 使用vite2代替webpack
* 升级到element-plus-2.0正式版
* 修复新窗口打开选项无效的问题
* 修复api/auth/jwt/login登录接口不加Authorization的header会出现403的问题

## ujcms-1.0.0 (2022-01-09)

1. 内容
  * 文章管理
  * 栏目管理
  * 区块管理
  * 附件管理
  * 生成管理
2. 配置
  * 全局设置
  * 站点设置
  * 模型管理
  * 区块设置
  * 字典类型
  * 字典数据
3. 用户
  * 用户管理
  * 角色管理
  * 用户组管理
  * 组织管理
4. 系统
  * 站点管理
  * 储存点管理
