# uibuilder Template: Svelte Basic

This is a very simple template for using the [Svelte](https://svelte.dev/) front-end framework with uibuilder and Node-RED. It was originally created from Svelte's https://github.com/sveltejs/template template.

## Folders and Files

The root folder contains this file. It can be used for other things **but** it will not be served up in the Node-RED web server.
_Either_ the `src` or the `dist` folder are served up (along with all of their sub-folders). So the root and any other root sub-folders
can be used mostly however you like. In the case of Svelte, you need to use the `dist` folder, this is configured in the advanced settings of the uibuilder node.

One reserved item in the root folder is the `package.json` file. This is used to configure what other npm packages are needed in order to build and change Svelte-based apps.

Folder list:

* `dist/` - contains the files that will be served to your browser client.
  
  * `dist/build/` - contains the built JavaScript and CSS files and a map file for debugging. The bundle files are used in the 
    
    * `dist/build/bundle.js` - The "compiled" JavaScript which is minimised for efficiency. Load this into your index.html file. This bundle contains all the required code for the UI except for the uibuilder client library (it can be bundled but it is generally easier not too because if you do, you have to take on responsibility for maintaining the correct versions when uibuilder gets updated).
    * `dist/build/bundle.css` - The "compiled" CSS which is minimised for efficiency. Load this into your index.html file.
    * `dist/build/bundle.js.map` - A debugging map file that your browser dev tools can use. No need to put this into your index.html.
  
  * `dist/index.html` - Contains your basic HTML and will be the file loaded and displayed in the browser when going to the uibuilder defined URL.

    Note that in this example, this file simply loads the other resources and sets some metadata. It does _not_ actually contain your UI. The UI is generated by Svelte dynamically.

  * `dist/global.css` - (optional) Contains any CSS you want made available to ALL Svelte components.

* `src/` - contains the source files that Svelte will "build" into your live files in `dist`. Notice that there are a lot more files in this folder than in `dist` because the Svelte build process "bundles" a lot of them together for efficiency.

    In this case, only 2 files exist:

    * `src/main.js` - This is a very simple script that loads the main app.
    * `src/App.svelte` - This is the definition of your UI.

* `scripts` - utility scripts.

* `/` - The root folder for the uibuilder instance

   * `README.md` - This description file - it is good practice to have a README.md in the root describing everything.
   * `package.json` - The `npm` package file. It defines what dev dependencies are required along with some scripts to do builds, run the dev server, etc.
   * `rollup.config.js` - Rollup is the tool used by Svelte to build the output `dist` files. This determines the configuration including specifying the input and output folders.
   * `.eslintrc.js` - Configuration of the ESLINT tool that is strongly recommended when developing. It will find lots of silly errors and help keep code consistently written.
   * `.gitignore` - Tells the GIT code management tool to ignore certain files. Also ensures that those files don't get pushed to GitHub.

Also note that you can use **linked** folders and files in this folder structure. This can be handy if you want to maintain your code in a different folder somewhere.

## Making changes

You will normally only need to make changes to `src/App.svelte`. It is this file that defines your UI in this simple example. Of course, you could also make changes in `dist/index.html` if you want but currently, the Svelte app is being loaded to the `body` tag of the html so all of your UI is dynamic.

As your UI gets more complex, it is best to create multiple custom Svelte components. Each of these will be in its own .svelte file and will define a single custom HTML tag.

### Prerequisites

Before making any changes to this template code, you need to install the development dependencies. To do this, run the following from the instance root folder:

```bash
npm install
```

### Development

Before you start making changes to the svelte files, you should start [Rollup](https://rollupjs.org) by running the following command from the instance root folder:

```bash
npm run dev
```

This will keep running in the background and any change that you save will be immediately reflected in your front-end browser tab. Note that this works even though you are viewing the output using the Node-RED/uibuilder server and not the dev server. Using node-red/uibuilder will ensure that all of the resource URL's and communications work correctly.

So in this case, you are only using the Rollup dev server purely to do the dynamic rebuild and to tell the front-end to reload on changes.

### Production

Once you have finished your development, you should stop the dev server and run the following command from the instance root folder:

```bash
npm run build
```

This will create an optimised version of your code.

---------

If you're using [Visual Studio Code](https://code.visualstudio.com/) it is recommended to install the official extension [Svelte for VS Code](https://marketplace.visualstudio.com/items?itemName=svelte.svelte-vscode). If you are using other editors you may need to install a plugin in order to get syntax highlighting and intellisense.

