# Guidelines for contributing to this project

Thanks for reading this page! Hopefully it means that you are considering or intending to contribute to the project. Many thanks for that.

You should note that I am not a full-time programmer and this project is intended to support the community that surrounds Node-RED which is a great open source project. So any and all help is most welcome and will hopefully continue to support and grow Node-RED as a tool that can be used by many.

If all of this is techno-babble, don't despair and don't give up! Please join us in the [Node-RED Discourse forum](https://discourse.nodered.org/) or in the #uibuilder channel of the [Node-RED Slack group](https://nodered.org/slack/) where you will find some friendly folk to explain the basics.

## Licensing and copyright

Before continuing, please make sure that you are happy with the [license](../LICENSE) that this code is published under. You need to make sure that any contributed code meets this license. If you contribute code, documentation, images or anything else to this project, you are confirming that you have the rights to do so and that you are conferring rights to use the contributions to this project under this repositories license.

## What to contribute?

We welcome contributions to documentation, the WIKI as well as code. So you don't have to be a developer to help the project!

## Community and behavioural expectations

If you wish to contribute to this project, you will be agreeing to abide by the projects code of conduct.

This project uses the [code of conduct provided by the JavaScript Foundation](https://js.foundation/community/code-of-conduct).

I always like to given a shout out to contributors. In doing so, I will give a link to your GitHub profile. If you would prefer I didn't for some reason, just let me know.

## Creating useful issue reports

Please fill in as much of the issue template as possible as it makes it much faster to home in on any potential problems.

## Creating useful pull requests

GitHub pull requests allow you to directly contribute your own code to the project. To do so, you should clone the project, make your changes and then submit a pull request for review.

If you are contributing again, please make sure that your clone is updated before making your new changes.

All code should follow the coding guidelines. To make that easier, the repository contains a `.editorconfig` file that will automatically configure many popular code editors and IDE's. It also contains a `.eslintrc.json` file. If you are not using a live ESlint plugin for your editor, please run a manual lint before submitting code.

You must include a sensible commit description so that I can understand what you've changed and why.

Please don't be disappointed if your pull-request is rejected. I will always give a reason. If there is an error or perhaps your code doesn't meet the standards, I will likely just ask you to correct things. Sometimes I may have other changes pending in my local development environment and so I may manually merge your changes.
