#pragma once
#include <d3d11.h>

#include "TalentTrees.h"

namespace TTM {
	struct TextureInfo {
		ID3D11ShaderResourceView* texture = nullptr;
		int width = 0;
		int height = 0;
	};

	bool LoadTextureFromFile(
		const char* filename, 
		ID3D11ShaderResourceView** out_srv, 
		ID3D11ShaderResourceView** out_srv_gray, 
		int* out_width, 
		int* out_height, 
		ID3D11Device* g_pd3dDevice, 
		Engine::TalentType talentType
	);
	std::pair<
		std::vector<std::string>,
		std::pair<std::vector<ID3D11ShaderResourceView*>, std::vector<ID3D11ShaderResourceView*>>
	> LoadPackedIcons(
		const char* packedIconsPath, 
		const char* metadataPath, 
		int* width, 
		int* height,
		ID3D11Device* g_pd3dDevice
	);
	bool LoadTTMBanner(
		ID3D11ShaderResourceView** out_srv,
		int* out_width,
		int* out_height,
		ID3D11Device* g_pd3dDevice
	);
	bool LoadDefaultTexture(
		ID3D11ShaderResourceView** out_srv, 
		ID3D11ShaderResourceView** out_srv_gray, 
		int* out_width,
		int* out_height,
		ID3D11Device* g_pd3dDevice,
		Engine::TalentType talentType
	);
	bool LoadIconGlowTexture(
		ID3D11ShaderResourceView** out_srv,
		int* out_width,
		int* out_height,
		ID3D11Device* g_pd3dDevice,
		Engine::TalentType talentType,
		float r, float g, float b);
	bool LoadRedIconGlowTexture(ID3D11ShaderResourceView** out_srv, int* out_width, int* out_height, ID3D11Device* g_pd3dDevice);
	bool LoadGreenIconGlowTexture(ID3D11ShaderResourceView** out_srv, int* out_width, int* out_height, ID3D11Device* g_pd3dDevice);
	bool LoadGoldIconGlowTexture(ID3D11ShaderResourceView** out_srv, int* out_width, int* out_height, ID3D11Device* g_pd3dDevice);
	bool LoadBlueIconGlowTexture(ID3D11ShaderResourceView** out_srv, int* out_width, int* out_height, ID3D11Device* g_pd3dDevice);
	bool LoadPurpleIconGlowTexture(ID3D11ShaderResourceView** out_srv, int* out_width, int* out_height, ID3D11Device* g_pd3dDevice);
	bool LoadIconMaskTexture(
		ID3D11ShaderResourceView** out_srv, int* out_width, int* out_height, ID3D11Device* g_pd3dDevice,
		Engine::TalentType talentType,
		float r, float g, float b);
	bool LoadSplitTextureFromFile(
		const char* filename1, 
		const char* filename2, 
		ID3D11ShaderResourceView** out_srv, 
		ID3D11ShaderResourceView** out_srv_gray,
		int* out_width, 
		int* out_height, 
		ID3D11Device* g_pd3dDevice
	);

	bool unpackIcons(const char* filename, std::vector<std::string> metaData);

	static const int DEFAULT_ICON_SIZE_W = 40;
	static const int DEFAULT_ICON_SIZE_H = 40;
	static const unsigned char DEFAULT_ICON_DATA[6400] =
	{
	 130, 135, 152, 255,   0,   0,   3, 255,   4,   3,   3, 255,   5,   0,   3, 255,   4,   0,   9, 255,   1,   0,  12, 255,   0,   5,   1, 255,   0,   7,   0, 255,   3,   8,   0, 255,   7,   2,   0, 255,  14,   1,  19, 255,  17,   0,  13, 255,   3,   1,   0, 255,   0,   6,   9, 255,   0,   4,  10, 255,  11,   5,  14, 255,  44,   8,  10, 255, 115,  43,  46, 255, 115,  40,  32, 255, 107,  48,  31, 255,  93,  50,  35, 255,  91,  56,  48, 255,  84,  51,  49, 255, 117,  39,  17, 255, 125,  24,  19, 255, 111,  35,  29, 255,  89,  46,  29, 255,  91,  40,  20, 255, 105,  38,  15, 255, 116,  32,  14, 255, 120,  20,  15, 255,  73,  13,  12, 255,   8,   7,   0, 255,   2,   3,   0, 255,   3,   3,   0, 255,   0,   3,   0, 255,   0,   4,   3, 255,   3,   3,   8, 255,   1,   0,   0, 255, 133, 128, 134, 255,
	   0,   0,   5, 255,   6,   7,   9, 255,   0,   0,   0, 255,   2,   3,   0, 255,   0,   0,   4, 255,   5,   1,  10, 255,   3,   1,   3, 255,   1,   6,   0, 255,   0,   5,   0, 255,   1,   3,   0, 255,   9,   2,  17, 255,   3,   1,   8, 255,   2,   7,   0, 255,   1,   0,   0, 255,  53,  26,  19, 255, 155,  97,  82, 255, 189, 103,  84, 255, 178,  76,  49, 255, 182,  75,  42, 255, 184,  77,  44, 255, 179,  72,  42, 255, 187,  73,  52, 255, 190,  73,  56, 255, 179,  84,  55, 255, 187,  88,  62, 255, 191,  74,  57, 255, 178,  57,  42, 255, 180,  68,  47, 255, 186,  53,  35, 255, 202,  43,  33, 255, 193,  44,  36, 255, 169,  54,  47, 255,  65,   0,   0, 255,  15,   7,   0, 255,   2,   2,   0, 255,   0,   2,   0, 255,   1,   8,   6, 255,   0,   0,   5, 255,  13,   4,  12, 255,   0,   0,   0, 255,
	   2,   6,   4, 255,   0,   1,   0, 255,   5,   6,   0, 255,   0,   4,   0, 255,   6,   9,   7, 255,   5,   0,   2, 255,  15,   0,   8, 255,   1,   0,   4, 255,   0,  11,   6, 255,   0,   8,   2, 255,   2,   2,   3, 255,   9,   2,   4, 255,  21,   0,   0, 255, 125,  56,  39, 255, 226, 117,  92, 255, 229, 101,  66, 255, 231, 103,  57, 255, 241, 119,  68, 255, 239, 117,  69, 255, 249, 118,  76, 255, 250, 105,  70, 255, 254,  99,  69, 255, 255,  93,  66, 255, 228,  90,  62, 255, 213,  92,  51, 255, 237,  81,  46, 255, 255,  71,  47, 255, 242,  77,  49, 255, 247,  75,  51, 255, 254,  66,  46, 255, 252,  58,  38, 255, 234,  44,  37, 255, 159,  11,  11, 255,  55,   8,   3, 255,   9,   0,   0, 255,   7,   5,   0, 255,   0,   6,   4, 255,   2,   6,   9, 255,   4,   0,   5, 255,   5,   3,   9, 255,
	   3,   6,   0, 255,   3,   2,   0, 255,   3,   3,   0, 255,   0,   6,   0, 255,   2,  10,   2, 255,   7,   0,   0, 255,  15,   0,   7, 255,   4,   0,  15, 255,   0,   8,  13, 255,   0,  10,   2, 255,   4,   2,   0, 255,  63,  15,  10, 255, 200, 103,  87, 255, 255, 126, 106, 255, 255, 109,  82, 255, 255, 113,  78, 255, 250, 116,  75, 255, 209, 100,  62, 255, 170,  70,  41, 255, 156,  45,  27, 255, 159,  36,  21, 255, 178,  47,  33, 255, 188,  57,  41, 255, 233,  68,  53, 255, 251,  97,  60, 255, 248,  86,  37, 255, 255,  88,  44, 255, 255,  72,  38, 255, 240,  87,  48, 255, 241,  84,  41, 255, 255,  64,  35, 255, 255,  18,  12, 255, 200,   7,  11, 255,  96,   6,   4, 255,  32,   4,   3, 255,  13,   3,   1, 255,   1,   2,   0, 255,   0,   4,   5, 255,   5,   0,   7, 255,   4,   2,   7, 255,
	   1,   4,   0, 255,   4,   0,   0, 255,  13,   9,   6, 255,   0,   6,   0, 255,   0,   5,   0, 255,  11,   5,   0, 255,  15,   0,  11, 255,   0,   0,  19, 255,   0,   8,  16, 255,   0,   4,   2, 255,  46,  12,   1, 255, 192,  93,  61, 255, 253, 130, 101, 255, 255, 113,  86, 255, 255, 109,  84, 255, 212,  78,  56, 255, 132,  27,  16, 255, 104,  14,   9, 255,  86,   0,   7, 255,  96,   0,  14, 255, 101,   0,   8, 255, 102,   0,   2, 255, 101,   2,   0, 255, 150,  17,  14, 255, 229,  76,  54, 255, 248,  92,  43, 255, 253,  84,  37, 255, 255,  73,  45, 255, 228,  84,  49, 255, 223,  85,  42, 255, 255,  31,   7, 255, 255,   0,   0, 255, 216,  17,  22, 255,  99,   0,   3, 255,  70,  17,  20, 255,  16,   0,   0, 255,   4,   4,   1, 255,   4,   7,   8, 255,   3,   0,   4, 255,   4,   1,   5, 255,
	   2,   9,   0, 255,   6,   1,   0, 255,  12,   0,   7, 255,   0,   2,   0, 255,   0,  10,   0, 255,   0,   1,   0, 255,   4,   0,   6, 255,   0,   3,  21, 255,   0,   4,  10, 255,  29,   5,   0, 255, 180,  97,  58, 255, 255, 133,  90, 255, 250, 121,  80, 255, 247, 126,  93, 255, 185,  78,  58, 255,  93,   0,   0, 255,  92,   0,   6, 255,  97,   5,  20, 255,  95,   0,  19, 255, 106,   1,  21, 255, 102,   1,  10, 255,  99,   1,   2, 255,  98,   4,   0, 255,  85,   0,  10, 255, 170,  47,  34, 255, 255,  97,  63, 255, 255,  73,  42, 255, 255,  77,  58, 255, 249,  78,  63, 255, 241,  54,  36, 255, 249,   2,   0, 255, 255,   6,   6, 255, 194,   0,   0, 255, 102,   4,  12, 255,  82,  10,  19, 255,  47,   0,   3, 255,   8,   0,   0, 255,   0,   0,   0, 255,   8,   1,   7, 255,   9,   0,   6, 255,
	   0,   2,   1, 255,   4,   0,   5, 255,  10,   0,   7, 255,   4,   0,   3, 255,   0,   3,   0, 255,   0,   5,   0, 255,   0,   4,   3, 255,   4,   7,  14, 255,   7,   0,   0, 255, 143,  78,  56, 255, 255, 125,  87, 255, 255, 121,  79, 255, 250, 123,  87, 255, 164,  59,  33, 255,  90,   1,   0, 255,  91,   3,   2, 255, 102,   0,  11, 255, 103,   0,   5, 255, 106,   3,   6, 255,  90,   3,   0, 255,  83,   7,   1, 255,  75,   4,   0, 255,  78,   6,   0, 255,  67,   0,  13, 255, 139,  32,  24, 255, 255,  80,  60, 255, 255,  67,  44, 255, 254,  78,  57, 255, 244,  50,  44, 255, 245,   3,   4, 255, 249,   0,   0, 255, 254,   3,   0, 255, 196,   0,   1, 255, 111,   0,   6, 255,  94,   3,  14, 255,  67,   5,  10, 255,  14,   0,   0, 255,   0,   0,   0, 255,   9,   1,   6, 255,  11,   0,   5, 255,
	   0,   1,   5, 255,   2,   0,   8, 255,   8,   0,   9, 255,   9,   0,   6, 255,   1,   1,   1, 255,   0,   7,   0, 255,   0,   8,   0, 255,   0,   1,   0, 255,  68,  27,  22, 255, 230, 122,  99, 255, 255, 113,  74, 255, 255, 120,  85, 255, 177,  53,  27, 255, 105,   0,   0, 255, 103,   1,   0, 255, 104,   0,   2, 255, 110,   0,   3, 255, 107,   2,   0, 255,  80,   5,   0, 255,  48,   8,   0, 255,  21,   2,   0, 255,  16,   0,   0, 255,  16,   0,   0, 255,  65,   1,   1, 255, 122,   7,   0, 255, 255,  82,  61, 255, 255,  71,  43, 255, 255,  88,  61, 255, 239,  23,  16, 255, 253,   2,   4, 255, 254,   5,   0, 255, 234,  13,   0, 255, 165,   0,   0, 255, 106,   2,   1, 255, 106,   0,   8, 255,  80,   6,  11, 255,  21,   3,   2, 255,   0,   1,   0, 255,   6,   0,   1, 255,  11,   0,   4, 255,
	   0,   0,   5, 255,   0,   0,   6, 255,   4,   0,   6, 255,   8,   0,   6, 255,   1,   0,   5, 255,   0,   6,   1, 255,   0,  10,   0, 255,  15,   0,   0, 255, 158,  75,  57, 255, 249, 118,  95, 255, 255, 118,  84, 255, 209,  89,  57, 255, 105,   2,   0, 255, 101,   4,   0, 255,  98,   1,   0, 255, 108,   6,   9, 255,  99,   3,   4, 255,  75,   2,   0, 255,  32,   0,   0, 255,   7,   5,   0, 255,   0,   4,   5, 255,   0,   3,  21, 255,   0,   0,  28, 255,  52,   4,   0, 255, 185,  63,  43, 255, 251,  88,  55, 255, 253,  77,  37, 255, 255,  57,  31, 255, 252,   2,   0, 255, 254,   3,   3, 255, 251,   1,   1, 255, 192,  10,   0, 255, 110,   9,   0, 255,  85,   7,   0, 255, 109,   1,   4, 255,  87,   7,  13, 255,  24,   5,   4, 255,   0,   5,   0, 255,   4,   0,   2, 255,  11,   0,   4, 255,
	   3,   0,   2, 255,   0,   3,   0, 255,   0,   2,   1, 255,   4,   0,   2, 255,   2,   0,   7, 255,   0,   5,   4, 255,   0,   7,   0, 255,  29,   0,   0, 255, 247, 134, 112, 255, 255, 121,  99, 255, 247, 120,  89, 255, 145,  49,  29, 255,  98,   5,   0, 255,  94,   2,   0, 255,  92,   2,   0, 255,  81,   5,   2, 255,  59,   5,   3, 255,  25,   0,   0, 255,   4,   0,   1, 255,   0,   3,   9, 255,   0,   1,  17, 255,   0,   1,  22, 255,   0,   0,  25, 255,  88,  17,   5, 255, 218,  83,  56, 255, 242,  85,  48, 255, 249,  74,  32, 255, 249,  17,   1, 255, 255,   3,   0, 255, 251,   0,   3, 255, 243,   6,  17, 255, 150,   4,   5, 255,  74,  10,   0, 255,  78,  15,   0, 255, 112,   1,   2, 255,  86,   4,   7, 255,  18,   4,   1, 255,   0,   6,   0, 255,   2,   1,   1, 255,   7,   0,   4, 255,
	   6,   0,   0, 255,   0,   5,   0, 255,   0,   7,   0, 255,   2,   0,   1, 255,   4,   0,   9, 255,   0,   3,   7, 255,   0,   2,   0, 255, 114,  52,  26, 255, 255, 121, 101, 255, 255, 115,  96, 255, 214, 119,  89, 255, 102,   9,   3, 255, 103,   0,   1, 255, 113,   3,   8, 255,  95,   1,   2, 255,  66,   7,   3, 255,  21,   5,   3, 255,   0,   2,   0, 255,   0,   3,   8, 255,   2,   0,   7, 255,   9,   0,   3, 255,  10,   0,   0, 255,  21,  10,   0, 255, 230,  67,  47, 255, 249,  88,  65, 255, 252,  78,  50, 255, 250,  64,  29, 255, 243,  35,   7, 255, 252,   4,   2, 255, 255,   0,  17, 255, 200,   3,  19, 255, 121,   1,   4, 255,  94,   0,   2, 255,  99,   1,   3, 255, 118,   0,   4, 255,  81,   1,   3, 255,  11,   2,   0, 255,   0,   8,   0, 255,   0,   6,   2, 255,   6,   0,   5, 255,
	   3,   4,   0, 255,   0,   6,   0, 255,   0,   4,   0, 255,   1,   1,   0, 255,   5,   0,   3, 255,  11,   1,   3, 255,  38,   9,   9, 255, 194, 121, 108, 255, 245, 121, 109, 255, 255, 112,  98, 255, 167,  30,  14, 255, 104,   2,   4, 255, 114,   8,  14, 255, 106,   0,   1, 255,  99,   6,   1, 255,  37,   4,   2, 255,   0,   2,   1, 255,  13,   2,  13, 255,  16,   1,  22, 255,   2,   6,   8, 255,   4,  16,   0, 255,  51,   3,   0, 255, 179,  53,  30, 255, 255,  81,  54, 255, 255,  81,  53, 255, 255,  63,  41, 255, 255,  61,  47, 255, 255,  62,  55, 255, 236,  16,  19, 255, 202,   5,  13, 255, 131,   0,   1, 255,  99,   6,   2, 255, 101,   2,   5, 255, 110,   0,   2, 255,  81,  14,  19, 255,  45,   3,   6, 255,   9,   1,   0, 255,   5,   3,   0, 255,   2,   3,   1, 255,   2,   0,   2, 255,
	   0,   1,   0, 255,   0,   1,   0, 255,   0,   1,   0, 255,   0,   1,   2, 255,   0,   0,   0, 255,   8,   0,   0, 255,  26,   0,   0, 255,  92,  31,  26, 255, 122,  22,  13, 255, 141,   3,   0, 255, 148,   0,   0, 255, 137,   3,  10, 255, 106,   0,   0, 255, 116,   8,   9, 255,  57,   5,   2, 255,   4,   1,   0, 255,   2,   2,   2, 255,   7,   0,  14, 255,   0,   2,  17, 255,   0,  16,   7, 255,  26,   2,   0, 255, 190,  70,  41, 255, 255,  78,  54, 255, 248,  85,  44, 255, 254,  77,  44, 255, 255,  65,  49, 255, 255,  44,  40, 255, 236,  20,  25, 255, 183,   0,   0, 255, 138,   0,   0, 255, 100,   0,   0, 255,  93,   6,   0, 255,  95,   0,   0, 255, 109,   0,   0, 255,  49,  14,  19, 255,  19,   2,   5, 255,   9,   0,   0, 255,   7,   0,   0, 255,   3,   0,   0, 255,   0,   0,   0, 255,
	  11,   0,   1, 255,   7,   0,   1, 255,   1,   0,   3, 255,   0,   2,   5, 255,   0,   4,   3, 255,   0,   4,   1, 255,   8,   4,   0, 255,  27,   0,   0, 255,  90,  18,  12, 255, 117,   9,   8, 255, 140,   5,   5, 255, 132,   0,   2, 255, 113,   1,   3, 255,  77,   9,   9, 255,  15,   0,   0, 255,   2,   4,   3, 255,   1,   5,   5, 255,   0,  12,   9, 255,   6,   8,   0, 255,  69,  15,  10, 255, 214,  76,  63, 255, 252,  80,  58, 255, 250,  85,  49, 255, 241,  87,  49, 255, 255,  81,  54, 255, 255,  63,  50, 255, 228,  23,  19, 255, 184,   8,   4, 255, 150,  15,  11, 255, 104,   1,   0, 255,  96,   2,   0, 255,  97,   3,   1, 255, 101,   1,   5, 255, 105,   0,   5, 255,  31,   3,   5, 255,  11,   0,   0, 255,   7,   0,   0, 255,   6,   0,   0, 255,   1,   0,   0, 255,   0,   2,   1, 255,
	   5,   0,   4, 255,   5,   0,   4, 255,   3,   0,   5, 255,   0,   0,   5, 255,   0,   1,   5, 255,   0,   2,   3, 255,   2,   1,   0, 255,  11,   0,   0, 255,  31,   2,   1, 255,  56,   2,   2, 255,  81,   3,   4, 255,  94,   7,   4, 255,  75,   9,   2, 255,  49,  16,  16, 255,  17,   0,   6, 255,  13,   4,  16, 255,   0,   5,   3, 255,  18,   6,   0, 255, 133,  40,  25, 255, 241,  93,  77, 255, 249,  80,  53, 255, 255,  93,  59, 255, 253,  84,  50, 255, 239,  76,  49, 255, 247,  75,  54, 255, 212,  38,  21, 255, 160,   5,   0, 255, 126,   1,   0, 255, 111,   7,   2, 255, 103,   3,   0, 255, 103,   0,   2, 255, 102,   1,   8, 255,  90,   5,  11, 255,  63,   0,   0, 255,  14,   0,   0, 255,   6,   0,   0, 255,   6,   0,   0, 255,   2,   1,   0, 255,   0,   0,   0, 255,   0,   1,   0, 255,
	   0,   2,   5, 255,   0,   1,   5, 255,   1,   0,   5, 255,   6,   0,   5, 255,   8,   0,   4, 255,   9,   0,   4, 255,   9,   0,   3, 255,  10,   1,   2, 255,   7,   0,   0, 255,  15,   2,   1, 255,  10,   0,   0, 255,  16,   0,   0, 255,  26,   1,   0, 255,  24,   2,   3, 255,   7,   3,  10, 255,   0,   0,   3, 255,  38,   0,   0, 255, 185,  68,  57, 255, 255,  99,  78, 255, 255,  88,  52, 255, 254,  95,  52, 255, 253,  90,  55, 255, 255,  85,  60, 255, 241,  64,  50, 255, 191,  35,  19, 255, 130,   3,   0, 255, 106,   2,   0, 255, 100,   5,   0, 255,  97,   0,   0, 255, 110,   0,   3, 255, 109,   0,  10, 255,  94,   2,  14, 255,  59,   5,   8, 255,  19,   0,   0, 255,   4,   0,   0, 255,   3,   0,   0, 255,   2,   1,   0, 255,   1,   1,   1, 255,   0,   1,   0, 255,   0,   1,   0, 255,
	   0,   5,   5, 255,   0,   2,   5, 255,   1,   0,   3, 255,   7,   0,   2, 255,   9,   0,   1, 255,   9,   0,   1, 255,   6,   2,   4, 255,   1,   2,   3, 255,   0,   2,   4, 255,   0,   4,   5, 255,   0,   6,   8, 255,  13,   1,   2, 255,  18,   0,   0, 255,   3,   2,   0, 255,   0,   6,   3, 255,  62,  26,  20, 255, 201,  71,  69, 255, 255,  87,  74, 255, 253,  90,  49, 255, 252,  98,  43, 255, 255,  92,  52, 255, 255,  79,  59, 255, 238,  63,  54, 255, 188,  25,  21, 255, 127,   1,   0, 255, 107,  10,   0, 255,  87,   6,   0, 255,  98,   5,   0, 255, 106,   0,   2, 255, 108,   0,  10, 255,  93,   3,  16, 255,  53,   2,   6, 255,  15,   0,   0, 255,   2,   5,   1, 255,   0,   1,   0, 255,   0,   0,   0, 255,   0,   1,   0, 255,   0,   1,   0, 255,   0,   2,   1, 255,   0,   1,   0, 255,
	   0,   0,   2, 255,   0,   0,   0, 255,   1,   0,   0, 255,   2,   0,   0, 255,   0,   0,   0, 255,   0,   3,   0, 255,   0,   4,   0, 255,   1,  13,  11, 255,   0,   3,   4, 255,   0,   1,   6, 255,   2,   5,  13, 255,  18,   0,   5, 255,   7,   0,   0, 255,   0,   1,   0, 255,  82,  32,  20, 255, 236, 105,  97, 255, 255,  93,  74, 255, 255,  93,  54, 255, 255,  95,  48, 255, 255,  94,  53, 255, 235,  77,  49, 255, 212,  57,  48, 255, 139,   0,   0, 255, 117,   0,   0, 255, 113,   1,   0, 255,  99,   4,   0, 255,  93,   0,   0, 255,  99,   0,   5, 255, 100,   3,  14, 255,  74,   0,  10, 255,  33,   0,   0, 255,   7,   0,   0, 255,   2,   3,   0, 255,   2,   1,   0, 255,   0,   1,   0, 255,   0,   1,   0, 255,   0,   1,   0, 255,   0,   1,   0, 255,   0,   1,   0, 255,   0,   1,   0, 255,
	   2,   0,   0, 255,   2,   0,   0, 255,   1,   0,   0, 255,   0,   1,   0, 255,   0,   2,   0, 255,   0,   4,   0, 255,   0,   6,   0, 255,   0,   5,   0, 255,   2,   4,   5, 255,   3,   1,   5, 255,   8,   0,   4, 255,   2,   8,   2, 255,   0,   2,   0, 255, 110,  39,  36, 255, 245, 100,  94, 255, 255,  87,  66, 255, 255,  96,  54, 255, 251,  99,  49, 255, 255,  89,  53, 255, 247,  83,  62, 255, 188,  45,  33, 255, 110,   0,   0, 255, 109,   6,   4, 255, 105,   1,   0, 255, 102,   0,   2, 255, 102,   1,   4, 255,  97,   3,  10, 255,  79,   3,   9, 255,  50,   2,   5, 255,  19,   0,   0, 255,   3,   0,   0, 255,   0,   1,   0, 255,   1,   0,   0, 255,   5,   0,   1, 255,   1,   1,   1, 255,   0,   1,   1, 255,   0,   1,   1, 255,   0,   1,   0, 255,   0,   1,   0, 255,   0,   1,   0, 255,
	   0,   4,   0, 255,   0,   3,   0, 255,   0,   1,   0, 255,   2,   0,   0, 255,   3,   0,   0, 255,   3,   0,   0, 255,   5,   3,   1, 255,   1,   0,   0, 255,   5,   1,   1, 255,   6,   1,   1, 255,  10,   0,   1, 255,   0,   3,   0, 255,  88,  50,  37, 255, 250, 105, 104, 255, 255,  86,  74, 255, 254,  95,  57, 255, 254,  99,  53, 255, 250,  95,  57, 255, 233,  97,  69, 255, 155,  31,  15, 255, 115,   1,   2, 255, 111,   3,   7, 255,  89,   3,   4, 255,  92,   0,   8, 255,  99,   4,  14, 255,  90,   2,  13, 255,  60,   1,   4, 255,  22,   0,   0, 255,   2,   2,   0, 255,   0,   3,   0, 255,   2,   0,   1, 255,   8,   0,   2, 255,   6,   0,   2, 255,   0,   1,   2, 255,   0,   0,   2, 255,   0,   0,   2, 255,   0,   0,   2, 255,   0,   0,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,
	   0,   7,   0, 255,   0,   5,   0, 255,   0,   1,   0, 255,   5,   0,   0, 255,   8,   0,   1, 255,   8,   0,   1, 255,   8,   0,   1, 255,   6,   0,   0, 255,   8,   0,   0, 255,   8,   0,   0, 255,   8,   0,   0, 255,  87,  17,   7, 255, 229, 114,  97, 255, 245, 112,  88, 255, 253,  96,  69, 255, 253,  87,  57, 255, 242,  96,  64, 255, 228, 109,  78, 255, 116,  21,   4, 255,  94,   6,   0, 255,  95,   3,   1, 255, 103,   0,   2, 255, 111,   0,   4, 255,  81,   9,  20, 255,  65,   0,   8, 255,  38,   0,   0, 255,  12,   0,   0, 255,   0,   4,   0, 255,   0,   9,   0, 255,   0,   4,   0, 255,   6,   0,   1, 255,  11,   0,   2, 255,   5,   0,   2, 255,   0,   3,   2, 255,   0,   1,   2, 255,   0,   0,   2, 255,   0,   0,   2, 255,   0,   0,   2, 255,   0,   0,   1, 255,   1,   0,   0, 255,
	   2,   1,   0, 255,   2,   1,   0, 255,   2,   0,   1, 255,   1,   0,   4, 255,   1,   0,   6, 255,   2,   1,   6, 255,   2,   2,   5, 255,   1,   0,   0, 255,   8,   0,   0, 255,  18,   0,   0, 255,  24,   5,   4, 255, 193,  79,  63, 255, 249, 108,  74, 255, 224, 113,  69, 255, 245,  99,  71, 255, 254,  78,  69, 255, 239,  88,  80, 255, 116,  21,  13, 255,  88,   7,   1, 255, 103,   4,   5, 255,  96,   1,   0, 255,  95,   7,   4, 255,  81,   4,   1, 255,  38,   2,   8, 255,  19,   0,   0, 255,   6,   0,   0, 255,   0,   7,   4, 255,   0,   4,   0, 255,   0,   3,   1, 255,   0,   2,   2, 255,   1,   1,   2, 255,   2,   2,   2, 255,   0,   2,   3, 255,   1,   3,   2, 255,   1,   0,   2, 255,   1,   0,   2, 255,   2,   0,   2, 255,   2,   0,   2, 255,   2,   0,   1, 255,   2,   0,   0, 255,
	  14,   0,   0, 255,  12,   0,   1, 255,   4,   0,   4, 255,   0,   1,   6, 255,   0,   5,   9, 255,   0,   6,   9, 255,   0,   9,   8, 255,   0,   8,   4, 255,   8,   0,   0, 255,  23,   0,   0, 255,  59,  20,  21, 255, 219, 123,  85, 255, 240, 111,  56, 255, 247, 109,  70, 255, 247,  89,  68, 255, 255,  89,  90, 255, 185,  34,  37, 255, 109,   0,   0, 255,  87,   5,   2, 255, 108,   0,   0, 255, 133,   0,   8, 255,  72,   0,   0, 255,   0,  13,   0, 255,   6,   0,   0, 255,   0,   2,   0, 255,   0,   5,   0, 255,   0,   2,   0, 255,   4,   0,   3, 255,   8,   0,   5, 255,   1,   1,   4, 255,   0,   5,   4, 255,   0,   8,   3, 255,   0,   4,   3, 255,   5,   0,   0, 255,   4,   0,   2, 255,   3,   0,   2, 255,   3,   0,   2, 255,   3,   0,   2, 255,   3,   0,   1, 255,   3,   0,   0, 255,
	   0,   1,   1, 255,   0,   8,   0, 255,   0,   6,   0, 255,   2,   0,   0, 255,   0,   1,   2, 255,   0,   2,   0, 255,  10,   0,   0, 255,  20,   0,  17, 255,   1,   1,  25, 255,   4,   0,   0, 255, 145,  74,  37, 255, 249, 121,  81, 255, 239, 100,  66, 255, 243,  94,  65, 255, 255,  91,  73, 255, 233,  84,  68, 255, 107,   4,   0, 255,  91,  10,   0, 255,  95,   3,   0, 255,  80,   6,  10, 255,  33,  10,   8, 255,   0,   3,   1, 255,   5,   0,   3, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,
	   0,   0,  13, 255,   0,   1,   2, 255,   2,   0,   0, 255,   8,   0,   3, 255,   1,   1,   4, 255,   0,   6,   0, 255,   3,   5,   0, 255,   8,   0,   3, 255,   6,   0,   8, 255,  61,  17,  13, 255, 247, 129,  99, 255, 255, 100,  63, 255, 255,  85,  55, 255, 255,  89,  63, 255, 255, 102,  79, 255, 177,  67,  47, 255,  82,   3,   0, 255,  97,   1,   0, 255, 114,   0,   8, 255,  83,   0,   5, 255,  22,   1,   0, 255,   0,   4,   0, 255,   0,   2,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,
	   1,   0,  25, 255,   0,   0,  13, 255,   7,   0,   6, 255,  12,   0,   6, 255,   1,   1,   4, 255,   0,   9,   0, 255,   0,  11,   0, 255,   5,   2,   0, 255,  16,   1,   3, 255,  93,  23,  16, 255, 255, 114,  89, 255, 240,  94,  47, 255, 253, 103,  56, 255, 255,  87,  59, 255, 248,  98,  79, 255, 127,  20,   5, 255,  96,   2,   0, 255, 111,   0,  10, 255, 105,   0,  14, 255,  49,   0,   1, 255,   2,   1,   0, 255,   0,   6,   0, 255,   2,   1,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,
	   4,   0,  22, 255,   3,   0,  12, 255,   7,   0,   4, 255,   9,   0,   2, 255,   1,   1,   1, 255,   0,   9,   0, 255,   0,  10,   0, 255,   0,   1,   0, 255,  10,   0,   0, 255,  85,  25,  19, 255, 168,  39,  21, 255, 178,  41,  14, 255, 176,  36,  19, 255, 210,  46,  26, 255, 179,  39,  22, 255, 106,   0,   0, 255, 107,   5,   3, 255, 105,   2,  11, 255,  68,   0,   6, 255,  15,   0,   0, 255,   0,   2,   0, 255,   4,   1,   2, 255,  11,   0,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,
	   3,   0,   7, 255,   1,   0,   1, 255,   3,   0,   0, 255,   2,   0,   0, 255,   0,   3,   0, 255,   0,   5,   0, 255,   0,   4,   2, 255,   9,  10,  15, 255,   5,   1,   7, 255,  20,   0,   0, 255,  73,  22,   6, 255, 152,  21,  15, 255, 165,   0,   0, 255, 168,   1,   8, 255, 126,   1,   0, 255, 107,   4,   0, 255, 105,   2,   0, 255,  88,   8,   1, 255,  31,   5,   0, 255,   1,   1,   0, 255,   7,   0,   1, 255,  13,   0,  11, 255,   4,   0,  14, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,
	   0,   1,   0, 255,   0,   2,   0, 255,   0,   3,   0, 255,   0,   3,   0, 255,   1,   2,   0, 255,   2,   1,   2, 255,   2,   1,  11, 255,   1,   0,  11, 255,   5,   2,  13, 255,   3,   0,   1, 255,  11,   8,   3, 255,  68,   4,   5, 255, 129,  12,  28, 255, 121,  11,  16, 255, 117,   5,   6, 255, 132,   4,   8, 255, 131,   0,   4, 255,  87,   5,   1, 255,  13,   9,   0, 255,   0,  10,   0, 255,   2,   2,   5, 255,   4,   0,  14, 255,   0,   4,  22, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,
	   0,   5,   0, 255,   0,   2,   0, 255,   2,   0,   0, 255,   4,   0,   0, 255,   6,   0,   0, 255,   6,   0,   6, 255,   7,   3,  18, 255,   5,   0,  11, 255,  11,   0,   0, 255,  13,   0,   0, 255,  14,   0,   0, 255,   9,   9,   0, 255,  29,  20,   4, 255,  33,   4,   5, 255,  48,   1,   2, 255,  83,   2,   5, 255, 105,   0,  12, 255,  65,   3,   5, 255,   2,   8,   0, 255,   0,  14,   0, 255,   0,   8,   4, 255,   0,   0,   6, 255,   0,   6,  11, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,
	   0,   5,   3, 255,   2,   0,   6, 255,   8,   0,   3, 255,   9,   0,   0, 255,  10,   0,   0, 255,   7,   0,   9, 255,   1,   1,  16, 255,   7,   0,   0, 255, 100,  47,  37, 255, 179,  88,  78, 255, 132,  39,  36, 255,  86,  24,  24, 255,  59,  12,  12, 255,  41,  11,   6, 255,  10,   7,   1, 255,   0,   3,   0, 255,   5,   2,   0, 255,  11,   1,   7, 255,   0,   1,   4, 255,   1,   3,   1, 255,   4,   1,   0, 255,   9,   0,   0, 255,   2,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,
	   0,   3,   8, 255,   4,   0,  12, 255,  10,   0,  10, 255,   7,   0,   2, 255,   7,   0,   1, 255,   4,   0,  10, 255,   0,   0,   7, 255,  14,   0,   0, 255, 175,  86,  56, 255, 251,  98,  75, 255, 252,  99,  87, 255, 254,  90,  87, 255, 245,  86,  82, 255, 186,  64,  59, 255,  61,   4,   4, 255,  24,   7,   5, 255,   0,   4,   5, 255,   0,   1,  12, 255,   4,   0,  13, 255,   8,   0,   6, 255,   8,   0,   0, 255,   9,   0,   0, 255,   9,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,
	   1,   1,   2, 255,   7,   0,   8, 255,   6,   0,   7, 255,   0,   2,   0, 255,   0,   2,   0, 255,   0,   0,   6, 255,   0,   0,   4, 255,  33,   1,   0, 255, 237, 118,  76, 255, 255,  95,  58, 255, 253,  80,  58, 255, 251,  80,  67, 255, 255,  87,  73, 255, 207,  56,  49, 255, 123,   0,   0, 255,  99,   0,   3, 255,  44,   0,   4, 255,   6,   0,   4, 255,   6,   0,  10, 255,   8,   0,   6, 255,   5,   0,   2, 255,   0,   3,   0, 255,   0,   4,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,
	   6,   0,   0, 255,  10,   0,   0, 255,   0,   1,   0, 255,   0,  11,   0, 255,   0,  10,   0, 255,   0,   2,   4, 255,   0,   0,   1, 255,  94,  50,  27, 255, 238, 108,  62, 255, 254,  87,  41, 255, 254,  90,  57, 255, 252,  90,  64, 255, 239, 104,  68, 255, 128,  38,   8, 255, 104,   3,   0, 255,  99,   1,   0, 255,  57,   8,   1, 255,   1,   6,   0, 255,   3,   2,   0, 255,  23,   0,   5, 255,  19,   0,   8, 255,   1,   3,   8, 255,   0,  13,   9, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,
	   1,   8,   0, 255,   2,   2,   2, 255,   5,   0,   4, 255,   1,   6,  10, 255,   0,   9,   5, 255,   1,   6,   0, 255,  19,   0,   0, 255, 210, 101,  90, 255, 255,  87,  66, 255, 255,  83,  44, 255, 255,  91,  33, 255, 255,  86,  53, 255, 234,  88,  68, 255, 126,  22,   1, 255, 103,   2,   0, 255,  92,   0,   1, 255,  58,   4,   4, 255,   5,   1,   0, 255,   0,   1,   0, 255,   7,   0,   4, 255,   6,   0,   5, 255,   0,   0,   4, 255,   0,   2,   4, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   1,   1, 255,   4,   4,   4, 255,   0,   0,   0, 255,   1,   1,   1, 255,   2,   2,   2, 255,
	   0,   5,   0, 255,   1,   2,   2, 255,   5,   1,   8, 255,   0,   1,   8, 255,   0,   5,   6, 255,   1,   6,   0, 255,  29,   0,   0, 255, 182,  84,  75, 255, 238,  85,  69, 255, 254,  99,  66, 255, 255,  93,  45, 255, 254,  84,  58, 255, 192,  51,  34, 255,  95,   0,   0, 255, 100,   1,   0, 255, 100,   1,   4, 255,  56,   3,   5, 255,   4,   0,   0, 255,   0,   1,   1, 255,   3,   0,   4, 255,   1,   0,   3, 255,   0,   0,   2, 255,   0,   0,   2, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   2,   2,   2, 255,   0,   0,   0, 255,   1,   1,   1, 255,   3,   3,   3, 255,   2,   2,   2, 255,   0,   0,   0, 255,
	   2,   3,   0, 255,   0,   1,   0, 255,   1,   1,   3, 255,   0,   0,   5, 255,   0,   1,   6, 255,   7,   2,   3, 255,  22,   2,   2, 255,  64,   9,   2, 255, 138,  47,  32, 255, 173,  50,  30, 255, 189,  44,  23, 255, 222,  70,  56, 255, 164,  39,  26, 255,  91,   0,   0, 255,  93,   2,   0, 255,  86,   1,   4, 255,  39,   1,   3, 255,   1,   0,   0, 255,   0,   1,   1, 255,   2,   0,   3, 255,   0,   0,   2, 255,   0,   1,   1, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   1,   1,   1, 255,   1,   1,   1, 255,   0,   0,   0, 255,   1,   1,   1, 255,   0,   0,   0, 255,   2,   2,   2, 255,
	   8,   0,   0, 255,   2,   5,   0, 255,   0,   6,   2, 255,   0,   3,   4, 255,  10,   1,  10, 255,  11,   0,   3, 255,  11,   0,   1, 255,  10,   0,   0, 255,  25,   1,   0, 255,  83,  14,   8, 255, 116,   5,   6, 255, 125,   0,   0, 255, 105,   4,   0, 255,  80,   9,   0, 255,  74,   1,   0, 255,  70,   1,   7, 255,  32,   2,   4, 255,   0,   2,   0, 255,   0,   2,   2, 255,   1,   0,   2, 255,   0,   0,   2, 255,   0,   0,   0, 255,   4,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   5,   5,   5, 255,   1,   1,   1, 255,   2,   2,   2, 255,   3,   3,   3, 255,   2,   2,   2, 255,
	  13,   0,   1, 255,   1,   3,   0, 255,   0,  11,   2, 255,   0,   3,   1, 255,  12,   1,   9, 255,  14,   0,   4, 255,  11,   5,  10, 255,   0,   8,   4, 255,   0,   6,   2, 255,  16,   0,   1, 255,  66,   2,  10, 255,  91,   2,   8, 255,  83,   9,   4, 255,  69,  17,   9, 255,  63,   7,   8, 255,  56,   2,  10, 255,  15,   0,   1, 255,   0,   3,   1, 255,   0,   2,   2, 255,   0,   0,   2, 255,   0,   2,   1, 255,   0,   1,   0, 255,   7,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   5,   5,   5, 255,   0,   0,   0, 255,   4,   4,   4, 255,   1,   1,   1, 255,   2,   2,   2, 255,
	  59,  40,  44, 255,   4,   2,   1, 255,   0,   9,   3, 255,   0,   5,   0, 255,   5,   0,   4, 255,   8,   0,   2, 255,   4,   2,   6, 255,   0,   5,   5, 255,   0,   9,   6, 255,   4,   3,   8, 255,  18,   0,   4, 255,  43,   0,   3, 255,  45,   0,   0, 255,  33,   1,   0, 255,  40,   1,   3, 255,  29,   0,   1, 255,   7,   3,   3, 255,   0,   4,   2, 255,   0,   2,   2, 255,   0,   0,   2, 255,   0,   4,   0, 255,   0,   1,   0, 255,  10,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   0,   0,   0, 255,   2,   2,   2, 255,   0,   0,   0, 255,   3,   3,   3, 255,   2,   2,   2, 255,  46,  46,  46, 255,
	};

	static const int ACTIVE_TALENT_MASK_SIZE_W = 40;
	static const int ACTIVE_TALENT_MASK_SIZE_H = 40;
	static const unsigned char ACTIVE_TALENT_MASK_DATA[6400] =
	{
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	};

	static const int PASSIVE_TALENT_MASK_SIZE_W = 40;
	static const int PASSIVE_TALENT_MASK_SIZE_H = 40;
	static const unsigned char PASSIVE_TALENT_MASK_DATA[6400] =
	{
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	};

	static const int SWITCH_TALENT_MASK_SIZE_W = 40;
	static const int SWITCH_TALENT_MASK_SIZE_H = 40;
	static const unsigned char SWITCH_TALENT_MASK_DATA[6400] =
	{
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	};

	static const int RED_ICON_GLOW_SIZE_W = 80;
	static const int RED_ICON_GLOW_SIZE_H = 80;
	static const unsigned char RED_ICON_GLOW_DATA[25600] =
	{
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   2, 255,   0,   0,   3, 255,   0,   0,   4, 255,   0,   0,   5, 255,   0,   0,   6, 255,   0,   0,   6, 255,   0,   0,   7, 255,   0,   0,   7, 255,   0,   0,   7, 255,   0,   0,   6, 255,   0,   0,   6, 255,   0,   0,   5, 255,   0,   0,   5, 255,   0,   0,   4, 255,   0,   0,   2, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   2, 255,   0,   0,   4, 255,   0,   0,   6, 255,   0,   0,   7, 255,   0,   0,   9, 255,   0,   0,  10, 255,   0,   0,  11, 255,   0,   0,  12, 255,   0,   0,  12, 255,   0,   0,  12, 255,   0,   0,  13, 255,   0,   0,  13, 255,   0,   0,  13, 255,   0,   0,  12, 255,   0,   0,  13, 255,   0,   0,  11, 255,   0,   0,  11, 255,   0,   0,  10, 255,   0,   0,   9, 255,   0,   0,   8, 255,   0,   0,   6, 255,   0,   0,   5, 255,   0,   0,   2, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   2, 255,   0,   0,   5, 255,   0,   0,   7, 255,   0,   0,   9, 255,   0,   0,  11, 255,   0,   0,  12, 255,   0,   0,  13, 255,   0,   0,  15, 255,   0,   0,  16, 255,   0,   0,  17, 255,   0,   0,  18, 255,   0,   0,  19, 255,   0,   0,  19, 255,   0,   0,  19, 255,   0,   0,  19, 255,   0,   0,  20, 255,   0,   0,  19, 255,   0,   0,  18, 255,   0,   0,  18, 255,   0,   0,  17, 255,   0,   0,  17, 255,   0,   0,  16, 255,   0,   0,  14, 255,   0,   0,  12, 255,   0,   0,  11, 255,   0,   0,   9, 255,   0,   0,   7, 255,   0,   0,   5, 255,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   6, 255,   0,   0,   9, 255,   0,   0,  11, 255,   0,   0,  13, 255,   0,   0,  15, 255,   0,   0,  17, 255,   0,   0,  18, 255,   0,   0,  20, 255,   0,   0,  21, 255,   0,   0,  23, 255,   0,   0,  24, 255,   0,   0,  25, 255,   0,   0,  25, 255,   0,   0,  26, 255,   0,   0,  26, 255,   0,   0,  26, 255,   0,   0,  26, 255,   0,   0,  26, 255,   0,   0,  26, 255,   0,   0,  25, 255,   0,   0,  24, 255,   0,   0,  23, 255,   0,   0,  22, 255,   0,   0,  20, 255,   0,   0,  18, 255,   0,   0,  17, 255,   0,   0,  16, 255,   0,   0,  13, 255,   0,   0,  11, 255,   0,   0,   8, 255,   0,   0,   6, 255,   0,   0,   3, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   6, 255,   0,   0,  10, 255,   0,   0,  12, 255,   0,   0,  15, 255,   0,   0,  17, 255,   0,   0,  19, 255,   0,   0,  21, 255,   0,   0,  23, 255,   0,   0,  25, 255,   0,   0,  27, 255,   0,   0,  28, 255,   0,   0,  30, 255,   0,   0,  31, 255,   0,   0,  31, 255,   0,   0,  32, 255,   0,   0,  32, 255,   0,   0,  33, 255,   0,   0,  32, 255,   0,   0,  32, 255,   0,   0,  32, 255,   0,   0,  32, 255,   0,   0,  31, 255,   0,   0,  30, 255,   0,   0,  30, 255,   0,   0,  28, 255,   0,   0,  26, 255,   0,   0,  26, 255,   0,   0,  23, 255,   0,   0,  21, 255,   0,   0,  19, 255,   0,   0,  17, 255,   0,   0,  15, 255,   0,   0,  12, 255,   0,   0,  10, 255,   0,   0,   6, 255,   0,   0,   3, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   6, 255,   0,   0,   9, 255,   0,   0,  12, 255,   0,   0,  16, 255,   0,   0,  18, 255,   0,   0,  21, 255,   0,   0,  23, 255,   0,   0,  25, 255,   0,   0,  28, 255,   0,   0,  30, 255,   0,   0,  31, 255,   0,   0,  33, 255,   0,   0,  34, 255,   0,   0,  35, 255,   0,   0,  37, 255,   0,   0,  38, 255,   0,   0,  39, 255,   0,   0,  39, 255,   0,   0,  39, 255,   0,   0,  39, 255,   0,   0,  39, 255,   0,   0,  39, 255,   0,   0,  38, 255,   0,   0,  38, 255,   0,   0,  37, 255,   0,   0,  36, 255,   0,   0,  34, 255,   0,   0,  33, 255,   0,   0,  31, 255,   0,   0,  30, 255,   0,   0,  28, 255,   0,   0,  25, 255,   0,   0,  23, 255,   0,   0,  21, 255,   0,   0,  18, 255,   0,   0,  15, 255,   0,   0,  13, 255,   0,   0,   9, 255,   0,   0,   6, 255,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   5, 255,   0,   0,   8, 255,   0,   0,  12, 255,   0,   0,  15, 255,   0,   0,  18, 255,   0,   0,  21, 255,   0,   0,  24, 255,   0,   0,  26, 255,   0,   0,  29, 255,   0,   0,  31, 255,   0,   0,  34, 255,   0,   0,  36, 255,   0,   0,  37, 255,   0,   0,  39, 255,   0,   0,  41, 255,   0,   0,  42, 255,   0,   0,  43, 255,   0,   0,  44, 255,   0,   0,  45, 255,   0,   0,  46, 255,   0,   0,  45, 255,   0,   0,  46, 255,   0,   0,  46, 255,   0,   0,  45, 255,   0,   0,  45, 255,   0,   0,  44, 255,   0,   0,  43, 255,   0,   0,  42, 255,   0,   0,  41, 255,   0,   0,  39, 255,   0,   0,  37, 255,   0,   0,  36, 255,   0,   0,  33, 255,   0,   0,  31, 255,   0,   0,  29, 255,   0,   0,  27, 255,   0,   0,  24, 255,   0,   0,  21, 255,   0,   0,  18, 255,   0,   0,  15, 255,   0,   0,  12, 255,   0,   0,   8, 255,   0,   0,   5, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   6, 255,   0,   0,  10, 255,   0,   0,  14, 255,   0,   0,  17, 255,   0,   0,  20, 255,   0,   0,  24, 255,   0,   0,  27, 255,   0,   0,  30, 255,   0,   0,  33, 255,   0,   0,  35, 255,   0,   0,  38, 255,   0,   0,  40, 255,   0,   0,  42, 255,   0,   0,  44, 255,   0,   0,  46, 255,   0,   0,  47, 255,   0,   0,  48, 255,   0,   0,  49, 255,   0,   0,  50, 255,   0,   0,  51, 255,   0,   0,  52, 255,   0,   0,  53, 255,   0,   0,  53, 255,   0,   0,  52, 255,   0,   0,  52, 255,   0,   0,  52, 255,   0,   0,  51, 255,   0,   0,  50, 255,   0,   0,  49, 255,   0,   0,  47, 255,   0,   0,  45, 255,   0,   0,  44, 255,   0,   0,  42, 255,   0,   0,  40, 255,   0,   0,  38, 255,   0,   0,  36, 255,   0,   0,  33, 255,   0,   0,  29, 255,   0,   0,  27, 255,   0,   0,  24, 255,   0,   0,  21, 255,   0,   0,  17, 255,   0,   0,  14, 255,   0,   0,  10, 255,   0,   0,   7, 255,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   4, 255,   0,   0,   8, 255,   0,   0,  12, 255,   0,   0,  16, 255,   0,   0,  19, 255,   0,   0,  22, 255,   0,   0,  26, 255,   0,   0,  30, 255,   0,   0,  33, 255,   0,   0,  35, 255,   0,   0,  39, 255,   0,   0,  41, 255,   0,   0,  43, 255,   0,   0,  46, 255,   0,   0,  48, 255,   0,   0,  50, 255,   0,   0,  52, 255,   0,   0,  54, 255,   0,   0,  55, 255,   0,   0,  56, 255,   0,   0,  57, 255,   0,   0,  58, 255,   0,   0,  59, 255,   0,   0,  59, 255,   0,   0,  59, 255,   0,   0,  59, 255,   0,   0,  59, 255,   0,   0,  58, 255,   0,   0,  57, 255,   0,   0,  57, 255,   0,   0,  55, 255,   0,   0,  54, 255,   0,   0,  52, 255,   0,   0,  50, 255,   0,   0,  48, 255,   0,   0,  46, 255,   0,   0,  44, 255,   0,   0,  41, 255,   0,   0,  39, 255,   0,   0,  35, 255,   0,   0,  33, 255,   0,   0,  29, 255,   0,   0,  26, 255,   0,   0,  23, 255,   0,   0,  19, 255,   0,   0,  15, 255,   0,   0,  12, 255,   0,   0,   8, 255,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   5, 255,   0,   0,   9, 255,   0,   0,  13, 255,   0,   0,  17, 255,   0,   0,  21, 255,   0,   0,  25, 255,   0,   0,  28, 255,   0,   0,  32, 255,   0,   0,  35, 255,   0,   0,  38, 255,   0,   0,  42, 255,   0,   0,  45, 255,   0,   0,  47, 255,   0,   0,  50, 255,   0,   0,  52, 255,   0,   0,  55, 255,   0,   0,  56, 255,   0,   0,  58, 255,   0,   0,  60, 255,   0,   0,  61, 255,   0,   0,  62, 255,   0,   0,  64, 255,   0,   0,  65, 255,   0,   0,  65, 255,   0,   0,  65, 255,   0,   0,  66, 255,   0,   0,  65, 255,   0,   0,  65, 255,   0,   0,  65, 255,   0,   0,  64, 255,   0,   0,  62, 255,   0,   0,  62, 255,   0,   0,  60, 255,   0,   0,  59, 255,   0,   0,  56, 255,   0,   0,  54, 255,   0,   0,  52, 255,   0,   0,  49, 255,   0,   0,  47, 255,   0,   0,  44, 255,   0,   0,  42, 255,   0,   0,  38, 255,   0,   0,  35, 255,   0,   0,  31, 255,   0,   0,  29, 255,   0,   0,  24, 255,   0,   0,  20, 255,   0,   0,  17, 255,   0,   0,  13, 255,   0,   0,   9, 255,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   6, 255,   0,   0,  10, 255,   0,   0,  14, 255,   0,   0,  18, 255,   0,   0,  23, 255,   0,   0,  26, 255,   0,   0,  30, 255,   0,   0,  34, 255,   0,   0,  38, 255,   0,   0,  41, 255,   0,   0,  44, 255,   0,   0,  48, 255,   0,   0,  50, 255,   0,   0,  53, 255,   0,   0,  56, 255,   0,   0,  58, 255,   0,   0,  60, 255,   0,   0,  63, 255,   0,   0,  64, 255,   0,   0,  66, 255,   0,   0,  68, 255,   0,   0,  69, 255,   0,   0,  70, 255,   0,   0,  71, 255,   0,   0,  72, 255,   0,   0,  71, 255,   0,   0,  72, 255,   0,   0,  72, 255,   0,   0,  71, 255,   0,   0,  71, 255,   0,   0,  70, 255,   0,   0,  69, 255,   0,   0,  67, 255,   0,   0,  66, 255,   0,   0,  65, 255,   0,   0,  63, 255,   0,   0,  61, 255,   0,   0,  58, 255,   0,   0,  56, 255,   0,   0,  53, 255,   0,   0,  51, 255,   0,   0,  48, 255,   0,   0,  45, 255,   0,   0,  41, 255,   0,   0,  37, 255,   0,   0,  34, 255,   0,   0,  30, 255,   0,   0,  26, 255,   0,   0,  22, 255,   0,   0,  18, 255,   0,   0,  14, 255,   0,   0,  10, 255,   0,   0,   6, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   5, 255,   0,   0,  10, 255,   0,   0,  15, 255,   0,   0,  19, 255,   0,   0,  24, 255,   0,   0,  27, 255,   0,   0,  32, 255,   0,   0,  35, 255,   0,   0,  39, 255,   0,   0,  43, 255,   0,   0,  46, 255,   0,   0,  50, 255,   0,   0,  53, 255,   0,   0,  56, 255,   0,   0,  59, 255,   0,   0,  62, 255,   0,   0,  64, 255,   0,   0,  67, 255,   0,   0,  69, 255,   0,   0,  71, 255,   0,   0,  73, 255,   0,   0,  74, 255,   0,   0,  75, 255,   0,   0,  77, 255,   0,   0,  77, 255,   0,   0,  78, 255,   0,   0,  78, 255,   0,   0,  79, 255,   0,   0,  79, 255,   0,   0,  78, 255,   0,   0,  77, 255,   0,   0,  76, 255,   0,   0,  76, 255,   0,   0,  74, 255,   0,   0,  72, 255,   0,   0,  71, 255,   0,   0,  69, 255,   0,   0,  67, 255,   0,   0,  65, 255,   0,   0,  62, 255,   0,   0,  59, 255,   0,   0,  56, 255,   0,   0,  53, 255,   0,   0,  49, 255,   0,   0,  46, 255,   0,   0,  43, 255,   0,   0,  39, 255,   0,   0,  35, 255,   0,   0,  31, 255,   0,   0,  28, 255,   0,   0,  23, 255,   0,   0,  19, 255,   0,   0,  14, 255,   0,   0,  10, 255,   0,   0,   5, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   5, 255,   0,   0,   9, 255,   0,   0,  14, 255,   0,   0,  19, 255,   0,   0,  23, 255,   0,   0,  28, 255,   0,   0,  32, 255,   0,   0,  37, 255,   0,   0,  41, 255,   0,   0,  44, 255,   0,   0,  48, 255,   0,   0,  51, 255,   0,   0,  55, 255,   0,   0,  58, 255,   0,   0,  62, 255,   0,   0,  65, 255,   0,   0,  67, 255,   0,   0,  70, 255,   0,   0,  73, 255,   0,   0,  75, 255,   0,   0,  77, 255,   0,   0,  79, 255,   0,   0,  80, 255,   0,   0,  82, 255,   0,   0,  83, 255,   0,   0,  84, 255,   0,   0,  84, 255,   0,   0,  85, 255,   0,   0,  85, 255,   0,   0,  85, 255,   0,   0,  84, 255,   0,   0,  84, 255,   0,   0,  83, 255,   0,   0,  82, 255,   0,   0,  81, 255,   0,   0,  79, 255,   0,   0,  77, 255,   0,   0,  75, 255,   0,   0,  73, 255,   0,   0,  70, 255,   0,   0,  68, 255,   0,   0,  65, 255,   0,   0,  62, 255,   0,   0,  59, 255,   0,   0,  55, 255,   0,   0,  52, 255,   0,   0,  48, 255,   0,   0,  45, 255,   0,   0,  40, 255,   0,   0,  36, 255,   0,   0,  32, 255,   0,   0,  28, 255,   0,   0,  24, 255,   0,   0,  19, 255,   0,   0,  14, 255,   0,   0,  10, 255,   0,   0,   5, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   5, 255,   0,   0,  10, 255,   0,   0,  15, 255,   0,   0,  19, 255,   0,   0,  24, 255,   0,   0,  29, 255,   0,   0,  33, 255,   0,   0,  38, 255,   0,   0,  42, 255,   0,   0,  45, 255,   0,   0,  49, 255,   0,   0,  53, 255,   0,   0,  57, 255,   0,   0,  61, 255,   0,   0,  64, 255,   0,   0,  68, 255,   0,   0,  71, 255,   0,   0,  74, 255,   0,   0,  76, 255,   0,   0,  79, 255,   0,   0,  81, 255,   0,   0,  84, 255,   0,   0,  86, 255,   0,   0,  87, 255,   0,   0,  88, 255,   0,   0,  90, 255,   0,   0,  91, 255,   0,   0,  91, 255,   0,   0,  92, 255,   0,   0,  91, 255,   0,   0,  91, 255,   0,   0,  91, 255,   0,   0,  90, 255,   0,   0,  90, 255,   0,   0,  88, 255,   0,   0,  86, 255,   0,   0,  85, 255,   0,   0,  83, 255,   0,   0,  81, 255,   0,   0,  79, 255,   0,   0,  77, 255,   0,   0,  73, 255,   0,   0,  71, 255,   0,   0,  67, 255,   0,   0,  64, 255,   0,   0,  61, 255,   0,   0,  57, 255,   0,   0,  53, 255,   0,   0,  49, 255,   0,   0,  46, 255,   0,   0,  42, 255,   0,   0,  37, 255,   0,   0,  32, 255,   0,   0,  28, 255,   0,   0,  24, 255,   0,   0,  19, 255,   0,   0,  14, 255,   0,   0,   9, 255,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   4, 255,   0,   0,   9, 255,   0,   0,  14, 255,   0,   0,  19, 255,   0,   0,  23, 255,   0,   0,  28, 255,   0,   0,  33, 255,   0,   0,  38, 255,   0,   0,  42, 255,   0,   0,  46, 255,   0,   0,  51, 255,   0,   0,  55, 255,   0,   0,  59, 255,   0,   0,  62, 255,   0,   0,  66, 255,   0,   0,  70, 255,   0,   0,  73, 255,   0,   0,  76, 255,   0,   0,  80, 255,   0,   0,  82, 255,   0,   0,  85, 255,   0,   0,  88, 255,   0,   0,  89, 255,   0,   0,  91, 255,   0,   0,  93, 255,   0,   0,  95, 255,   0,   0,  96, 255,   0,   0,  97, 255,   0,   0,  98, 255,   0,   0,  98, 255,   0,   0,  98, 255,   0,   0,  98, 255,   0,   0,  98, 255,   0,   0,  97, 255,   0,   0,  96, 255,   0,   0,  95, 255,   0,   0,  94, 255,   0,   0,  91, 255,   0,   0,  89, 255,   0,   0,  88, 255,   0,   0,  85, 255,   0,   0,  82, 255,   0,   0,  79, 255,   0,   0,  77, 255,   0,   0,  74, 255,   0,   0,  70, 255,   0,   0,  66, 255,   0,   0,  63, 255,   0,   0,  59, 255,   0,   0,  55, 255,   0,   0,  51, 255,   0,   0,  47, 255,   0,   0,  42, 255,   0,   0,  38, 255,   0,   0,  33, 255,   0,   0,  28, 255,   0,   0,  23, 255,   0,   0,  18, 255,   0,   0,  14, 255,   0,   0,   9, 255,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   8, 255,   0,   0,  13, 255,   0,   0,  18, 255,   0,   0,  23, 255,   0,   0,  28, 255,   0,   0,  33, 255,   0,   0,  38, 255,   0,   0,  42, 255,   0,   0,  47, 255,   0,   0,  51, 255,   0,   0,  56, 255,   0,   0,  60, 255,   0,   0,  64, 255,   0,   0,  68, 255,   0,   0,  71, 255,   0,   0,  76, 255,   0,   0,  79, 255,   0,   0,  82, 255,   0,   0,  85, 255,   0,   0,  88, 255,   0,   0,  91, 255,   0,   0,  93, 255,   0,   0,  96, 255,   0,   0,  98, 255,   0,   0, 100, 255,   0,   0, 101, 255,   0,   0, 102, 255,   0,   0, 103, 255,   0,   0, 104, 255,   0,   0, 104, 255,   0,   0, 105, 255,   0,   0, 105, 255,   0,   0, 104, 255,   0,   0, 104, 255,   0,   0, 102, 255,   0,   0, 101, 255,   0,   0, 100, 255,   0,   0,  98, 255,   0,   0,  96, 255,   0,   0,  94, 255,   0,   0,  91, 255,   0,   0,  89, 255,   0,   0,  85, 255,   0,   0,  82, 255,   0,   0,  79, 255,   0,   0,  75, 255,   0,   0,  72, 255,   0,   0,  68, 255,   0,   0,  64, 255,   0,   0,  60, 255,   0,   0,  56, 255,   0,   0,  51, 255,   0,   0,  47, 255,   0,   0,  43, 255,   0,   0,  38, 255,   0,   0,  33, 255,   0,   0,  28, 255,   0,   0,  23, 255,   0,   0,  18, 255,   0,   0,  13, 255,   0,   0,   8, 255,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   7, 255,   0,   0,  12, 255,   0,   0,  17, 255,   0,   0,  23, 255,   0,   0,  27, 255,   0,   0,  32, 255,   0,   0,  38, 255,   0,   0,  42, 255,   0,   0,  47, 255,   0,   0,  52, 255,   0,   0,  56, 255,   0,   0,  61, 255,   0,   0,  65, 255,   0,   0,  70, 255,   0,   0,  73, 255,   0,   0,  77, 255,   0,   0,  81, 255,   0,   0,  85, 255,   0,   0,  88, 255,   0,   0,  91, 255,   0,   0,  94, 255,   0,   0,  97, 255,   0,   0, 100, 255,   0,   0, 102, 255,   0,   0, 104, 255,   0,   0, 106, 255,   0,   0, 108, 255,   0,   0, 108, 255,   0,   0, 110, 255,   0,   0, 111, 255,   0,   0, 111, 255,   0,   0, 111, 255,   0,   0, 111, 255,   0,   0, 111, 255,   0,   0, 110, 255,   0,   0, 109, 255,   0,   0, 108, 255,   0,   0, 106, 255,   0,   0, 104, 255,   0,   0, 102, 255,   0,   0, 100, 255,   0,   0,  97, 255,   0,   0,  94, 255,   0,   0,  91, 255,   0,   0,  88, 255,   0,   0,  84, 255,   0,   0,  81, 255,   0,   0,  77, 255,   0,   0,  73, 255,   0,   0,  69, 255,   0,   0,  65, 255,   0,   0,  61, 255,   0,   0,  56, 255,   0,   0,  52, 255,   0,   0,  47, 255,   0,   0,  42, 255,   0,   0,  37, 255,   0,   0,  33, 255,   0,   0,  27, 255,   0,   0,  22, 255,   0,   0,  17, 255,   0,   0,  12, 255,   0,   0,   6, 255,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   5, 255,   0,   0,  11, 255,   0,   0,  16, 255,   0,   0,  21, 255,   0,   0,  26, 255,   0,   0,  31, 255,   0,   0,  37, 255,   0,   0,  41, 255,   0,   0,  47, 255,   0,   0,  51, 255,   0,   0,  56, 255,   0,   0,  60, 255,   0,   0,  65, 255,   0,   0,  70, 255,   0,   0,  74, 255,   0,   0,  79, 255,   0,   0,  82, 255,   0,   0,  86, 255,   0,   0,  90, 255,   0,   0,  94, 255,   0,   0,  97, 255,   0,   0, 100, 255,   0,   0, 103, 255,   0,   0, 105, 255,   0,   0, 108, 255,   0,   0, 110, 255,   0,   0, 112, 255,   0,   0, 114, 255,   0,   0, 115, 255,   0,   0, 116, 255,   0,   0, 117, 255,   0,   0, 118, 255,   0,   0, 118, 255,   0,   0, 118, 255,   0,   0, 117, 255,   0,   0, 116, 255,   0,   0, 115, 255,   0,   0, 114, 255,   0,   0, 112, 255,   0,   0, 111, 255,   0,   0, 108, 255,   0,   0, 105, 255,   0,   0, 103, 255,   0,   0, 100, 255,   0,   0,  97, 255,   0,   0,  94, 255,   0,   0,  90, 255,   0,   0,  87, 255,   0,   0,  82, 255,   0,   0,  79, 255,   0,   0,  74, 255,   0,   0,  70, 255,   0,   0,  65, 255,   0,   0,  61, 255,   0,   0,  56, 255,   0,   0,  51, 255,   0,   0,  46, 255,   0,   0,  42, 255,   0,   0,  37, 255,   0,   0,  32, 255,   0,   0,  26, 255,   0,   0,  21, 255,   0,   0,  16, 255,   0,   0,  10, 255,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   2, 255,   0,   0,   8, 255,   0,   0,  13, 255,   0,   0,  19, 255,   0,   0,  25, 255,   0,   0,  30, 255,   0,   0,  35, 255,   0,   0,  40, 255,   0,   0,  46, 255,   0,   0,  51, 255,   0,   0,  56, 255,   0,   0,  60, 255,   0,   0,  66, 255,   0,   0,  70, 255,   0,   0,  75, 255,   0,   0,  79, 255,   0,   0,  83, 255,   0,   0,  88, 255,   0,   0,  92, 255,   0,   0,  95, 255,   0,   0,  99, 255,   0,   0, 103, 255,   0,   0, 105, 255,   0,   0, 109, 255,   0,   0, 112, 255,   0,   0, 115, 255,   0,   0, 116, 255,   0,   0, 118, 255,   0,   0, 120, 255,   0,   0, 122, 255,   0,   0, 123, 255,   0,   0, 123, 255,   0,   0, 125, 255,   0,   0, 125, 255,   0,   0, 124, 255,   0,   0, 124, 255,   0,   0, 123, 255,   0,   0, 121, 255,   0,   0, 121, 255,   0,   0, 118, 255,   0,   0, 117, 255,   0,   0, 115, 255,   0,   0, 111, 255,   0,   0, 109, 255,   0,   0, 106, 255,   0,   0, 102, 255,   0,   0,  99, 255,   0,   0,  95, 255,   0,   0,  92, 255,   0,   0,  88, 255,   0,   0,  84, 255,   0,   0,  79, 255,   0,   0,  75, 255,   0,   0,  70, 255,   0,   0,  65, 255,   0,   0,  61, 255,   0,   0,  55, 255,   0,   0,  50, 255,   0,   0,  45, 255,   0,   0,  40, 255,   0,   0,  36, 255,   0,   0,  30, 255,   0,   0,  25, 255,   0,   0,  19, 255,   0,   0,  14, 255,   0,   0,   8, 255,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   6, 255,   0,   0,  12, 255,   0,   0,  17, 255,   0,   0,  23, 255,   0,   0,  29, 255,   0,   0,  34, 255,   0,   0,  39, 255,   0,   0,  44, 255,   0,   0,  50, 255,   0,   0,  55, 255,   0,   0,  60, 255,   0,   0,  65, 255,   0,   0,  70, 255,   0,   0,  75, 255,   0,   0,  79, 255,   0,   0,  84, 255,   0,   0,  88, 255,   0,   0,  92, 255,   0,   0,  97, 255,   0,   0, 101, 255,   0,   0, 104, 255,   0,   0, 108, 255,   0,   0, 112, 255,   0,   0, 115, 255,   0,   0, 117, 255,   0,   0, 120, 255,   0,   0, 123, 255,   0,   0, 125, 255,   0,   0, 126, 255,   0,   0, 128, 255,   0,   0, 129, 255,   0,   0, 130, 255,   0,   0, 130, 255,   0,   0, 131, 255,   0,   0, 131, 255,   0,   0, 131, 255,   0,   0, 130, 255,   0,   0, 128, 255,   0,   0, 126, 255,   0,   0, 124, 255,   0,   0, 123, 255,   0,   0, 120, 255,   0,   0, 118, 255,   0,   0, 115, 255,   0,   0, 111, 255,   0,   0, 108, 255,   0,   0, 104, 255,   0,   0, 101, 255,   0,   0,  97, 255,   0,   0,  93, 255,   0,   0,  88, 255,   0,   0,  84, 255,   0,   0,  79, 255,   0,   0,  75, 255,   0,   0,  69, 255,   0,   0,  65, 255,   0,   0,  60, 255,   0,   0,  55, 255,   0,   0,  50, 255,   0,   0,  45, 255,   0,   0,  39, 255,   0,   0,  34, 255,   0,   0,  28, 255,   0,   0,  23, 255,   0,   0,  17, 255,   0,   0,  12, 255,   0,   0,   6, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   9, 255,   0,   0,  15, 255,   0,   0,  21, 255,   0,   0,  26, 255,   0,   0,  32, 255,   0,   0,  37, 255,   0,   0,  42, 255,   0,   0,  48, 255,   0,   0,  53, 255,   0,   0,  58, 255,   0,   0,  64, 255,   0,   0,  70, 255,   0,   0,  74, 255,   0,   0,  79, 255,   0,   0,  84, 255,   0,   0,  88, 255,   0,   0,  93, 255,   0,   0,  97, 255,   0,   0, 101, 255,   0,   0, 106, 255,   0,   0, 109, 255,   0,   0, 114, 255,   0,   0, 117, 255,   0,   0, 120, 255,   0,   0, 124, 255,   0,   0, 126, 255,   0,   0, 129, 255,   0,   0, 131, 255,   0,   0, 133, 255,   0,   0, 134, 255,   0,   0, 135, 255,   0,   0, 136, 255,   0,   0, 137, 255,   0,   0, 137, 255,   0,   0, 138, 255,   0,   0, 137, 255,   0,   0, 136, 255,   0,   0, 135, 255,   0,   0, 133, 255,   0,   0, 131, 255,   0,   0, 129, 255,   0,   0, 126, 255,   0,   0, 123, 255,   0,   0, 121, 255,   0,   0, 117, 255,   0,   0, 114, 255,   0,   0, 110, 255,   0,   0, 106, 255,   0,   0, 102, 255,   0,   0,  97, 255,   0,   0,  93, 255,   0,   0,  89, 255,   0,   0,  84, 255,   0,   0,  79, 255,   0,   0,  75, 255,   0,   0,  69, 255,   0,   0,  64, 255,   0,   0,  58, 255,   0,   0,  54, 255,   0,   0,  48, 255,   0,   0,  42, 255,   0,   0,  38, 255,   0,   0,  32, 255,   0,   0,  27, 255,   0,   0,  21, 255,   0,   0,  15, 255,   0,   0,  10, 255,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   7, 255,   0,   0,  12, 255,   0,   0,  18, 255,   0,   0,  24, 255,   0,   0,  30, 255,   0,   0,  35, 255,   0,   0,  41, 255,   0,   0,  46, 255,   0,   0,  52, 255,   0,   0,  58, 255,   0,   0,  62, 255,   0,   0,  68, 255,   0,   0,  74, 255,   0,   0,  78, 255,   0,   0,  83, 255,   0,   0,  88, 255,   0,   0,  93, 255,   0,   0,  97, 255,   0,   0, 102, 255,   0,   0, 107, 255,   0,   0, 111, 255,   0,   0, 115, 255,   0,   0, 119, 255,   0,   0, 123, 255,   0,   0, 126, 255,   0,   0, 129, 255,   0,   0, 132, 255,   0,   0, 135, 255,   0,   0, 137, 255,   0,   0, 139, 255,   0,   0, 141, 255,   0,   0, 142, 255,   0,   0, 143, 255,   0,   0, 143, 255,   0,   0, 143, 255,   0,   0, 144, 255,   0,   0, 143, 255,   0,   0, 142, 255,   0,   0, 140, 255,   0,   0, 139, 255,   0,   0, 137, 255,   0,   0, 135, 255,   0,   0, 133, 255,   0,   0, 129, 255,   0,   0, 126, 255,   0,   0, 122, 255,   0,   0, 119, 255,   0,   0, 115, 255,   0,   0, 111, 255,   0,   0, 107, 255,   0,   0, 103, 255,   0,   0,  98, 255,   0,   0,  93, 255,   0,   0,  89, 255,   0,   0,  83, 255,   0,   0,  78, 255,   0,   0,  73, 255,   0,   0,  68, 255,   0,   0,  63, 255,   0,   0,  57, 255,   0,   0,  52, 255,   0,   0,  46, 255,   0,   0,  40, 255,   0,   0,  35, 255,   0,   0,  29, 255,   0,   0,  24, 255,   0,   0,  18, 255,   0,   0,  12, 255,   0,   0,   6, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   9, 255,   0,   0,  15, 255,   0,   0,  21, 255,   0,   0,  27, 255,   0,   0,  32, 255,   0,   0,  38, 255,   0,   0,  44, 255,   0,   0,  50, 255,   0,   0,  55, 255,   0,   0,  60, 255,   0,   0,  67, 255,   0,   0,  72, 255,   0,   0,  77, 255,   0,   0,  83, 255,   0,   0,  88, 255,   0,   0,  93, 255,   0,   0,  97, 255,   0,   0, 102, 255,   0,   0, 107, 255,   0,   0, 111, 255,   0,   0, 116, 255,   0,   0, 120, 255,   0,   0, 124, 255,   0,   0, 128, 255,   0,   0, 131, 255,   0,   0, 135, 255,   0,   0, 138, 255,   0,   0, 140, 255,   0,   0, 144, 255,   0,   0, 145, 255,   0,   0, 147, 255,   0,   0, 149, 255,   0,   0, 149, 255,   0,   0, 150, 255,   0,   0, 151, 255,   0,   0, 150, 255,   0,   0, 150, 255,   0,   0, 148, 255,   0,   0, 147, 255,   0,   0, 145, 255,   0,   0, 143, 255,   0,   0, 140, 255,   0,   0, 138, 255,   0,   0, 135, 255,   0,   0, 131, 255,   0,   0, 128, 255,   0,   0, 124, 255,   0,   0, 121, 255,   0,   0, 116, 255,   0,   0, 112, 255,   0,   0, 107, 255,   0,   0, 102, 255,   0,   0,  97, 255,   0,   0,  93, 255,   0,   0,  88, 255,   0,   0,  83, 255,   0,   0,  77, 255,   0,   0,  72, 255,   0,   0,  66, 255,   0,   0,  61, 255,   0,   0,  55, 255,   0,   0,  50, 255,   0,   0,  44, 255,   0,   0,  38, 255,   0,   0,  33, 255,   0,   0,  27, 255,   0,   0,  21, 255,   0,   0,  15, 255,   0,   0,  10, 255,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   6, 255,   0,   0,  12, 255,   0,   0,  18, 255,   0,   0,  24, 255,   0,   0,  30, 255,   0,   0,  36, 255,   0,   0,  41, 255,   0,   0,  47, 255,   0,   0,  53, 255,   0,   0,  59, 255,   0,   0,  65, 255,   0,   0,  70, 255,   0,   0,  76, 255,   0,   0,  80, 255,   0,   0,  87, 255,   0,   0,  91, 255,   0,   0,  97, 255,   0,   0, 102, 255,   0,   0, 107, 255,   0,   0, 112, 255,   0,   0, 116, 255,   0,   0, 121, 255,   0,   0, 125, 255,   0,   0, 129, 255,   0,   0, 134, 255,   0,   0, 137, 255,   0,   0, 141, 255,   0,   0, 144, 255,   0,   0, 147, 255,   0,   0, 149, 255,   0,   0, 152, 255,   0,   0, 153, 255,   0,   0, 155, 255,   0,   0, 156, 255,   0,   0, 157, 255,   0,   0, 157, 255,   0,   0, 157, 255,   0,   0, 156, 255,   0,   0, 155, 255,   0,   0, 153, 255,   0,   0, 151, 255,   0,   0, 149, 255,   0,   0, 146, 255,   0,   0, 144, 255,   0,   0, 140, 255,   0,   0, 137, 255,   0,   0, 133, 255,   0,   0, 129, 255,   0,   0, 125, 255,   0,   0, 121, 255,   0,   0, 116, 255,   0,   0, 112, 255,   0,   0, 107, 255,   0,   0, 101, 255,   0,   0,  97, 255,   0,   0,  91, 255,   0,   0,  86, 255,   0,   0,  81, 255,   0,   0,  75, 255,   0,   0,  70, 255,   0,   0,  65, 255,   0,   0,  59, 255,   0,   0,  53, 255,   0,   0,  48, 255,   0,   0,  42, 255,   0,   0,  36, 255,   0,   0,  30, 255,   0,   0,  23, 255,   0,   0,  18, 255,   0,   0,  12, 255,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   2, 255,   0,   0,   9, 255,   0,   0,  15, 255,   0,   0,  21, 255,   0,   0,  26, 255,   0,   0,  33, 255,   0,   0,  39, 255,   0,   0,  44, 255,   0,   0,  50, 255,   0,   0,  56, 255,   0,   0,  62, 255,   0,   0,  68, 255,   0,   0,  73, 255,   0,   0,  79, 255,   0,   0,  85, 255,   0,   0,  90, 255,   0,   0,  96, 255,   0,   0, 101, 255,   0,   0, 106, 255,   0,   0, 111, 255,   0,   0, 116, 255,   0,   0, 121, 255,   0,   0, 126, 255,   0,   0, 130, 255,   0,   0, 134, 255,   0,   0, 139, 255,   0,   0, 142, 255,   0,   0, 146, 255,   0,   0, 150, 255,   0,   0, 152, 255,   0,   0, 155, 255,   0,   0, 158, 255,   0,   0, 160, 255,   0,   0, 161, 255,   0,   0, 163, 255,   0,   0, 163, 255,   0,   0, 164, 255,   0,   0, 163, 255,   0,   0, 162, 255,   0,   0, 161, 255,   0,   0, 160, 255,   0,   0, 158, 255,   0,   0, 155, 255,   0,   0, 153, 255,   0,   0, 149, 255,   0,   0, 146, 255,   0,   0, 142, 255,   0,   0, 138, 255,   0,   0, 135, 255,   0,   0, 130, 255,   0,   0, 126, 255,   0,   0, 120, 255,   0,   0, 116, 255,   0,   0, 111, 255,   0,   0, 106, 255,   0,   0, 101, 255,   0,   0,  96, 255,   0,   0,  90, 255,   0,   0,  85, 255,   0,   0,  79, 255,   0,   0,  74, 255,   0,   0,  67, 255,   0,   0,  62, 255,   0,   0,  56, 255,   0,   0,  51, 255,   0,   0,  45, 255,   0,   0,  39, 255,   0,   0,  33, 255,   0,   0,  26, 255,   0,   0,  20, 255,   0,   0,  15, 255,   0,   0,   9, 255,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   5, 255,   0,   0,  11, 255,   0,   0,  17, 255,   0,   0,  23, 255,   0,   0,  29, 255,   0,   0,  35, 255,   0,   0,  41, 255,   0,   0,  47, 255,   0,   0,  53, 255,   0,   0,  59, 255,   0,   0,  65, 255,   0,   0,  71, 255,   0,   0,  77, 255,   0,   0,  82, 255,   0,   0,  88, 255,   0,   0,  93, 255,   0,   0,  99, 255,   0,   0, 105, 255,   0,   0, 109, 255,   0,   0, 115, 255,   0,   0, 120, 255,   0,   0, 126, 255,   0,   0, 130, 255,   0,   0, 134, 255,   0,   0, 139, 255,   0,   0, 144, 255,   0,   0, 147, 255,   0,   0, 152, 255,   0,   0, 156, 255,   0,   0, 158, 255,   0,   0, 162, 255,   0,   0, 164, 255,   0,   0, 166, 255,   0,   0, 168, 255,   0,   0, 169, 255,   0,   0, 169, 255,   0,   0, 170, 255,   0,   0, 170, 255,   0,   0, 169, 255,   0,   0, 168, 255,   0,   0, 166, 255,   0,   0, 164, 255,   0,   0, 161, 255,   0,   0, 158, 255,   0,   0, 155, 255,   0,   0, 152, 255,   0,   0, 148, 255,   0,   0, 144, 255,   0,   0, 139, 255,   0,   0, 134, 255,   0,   0, 130, 255,   0,   0, 125, 255,   0,   0, 120, 255,   0,   0, 115, 255,   0,   0, 110, 255,   0,   0, 104, 255,   0,   0,  99, 255,   0,   0,  93, 255,   0,   0,  88, 255,   0,   0,  83, 255,   0,   0,  76, 255,   0,   0,  71, 255,   0,   0,  65, 255,   0,   0,  59, 255,   0,   0,  53, 255,   0,   0,  47, 255,   0,   0,  41, 255,   0,   0,  36, 255,   0,   0,  30, 255,   0,   0,  23, 255,   0,   0,  17, 255,   0,   0,  11, 255,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   7, 255,   0,   0,  13, 255,   0,   0,  19, 255,   0,   0,  25, 255,   0,   0,  32, 255,   0,   0,  37, 255,   0,   0,  44, 255,   0,   0,  50, 255,   0,   0,  56, 255,   0,   0,  62, 255,   0,   0,  67, 255,   0,   0,  74, 255,   0,   0,  79, 255,   0,   0,  86, 255,   0,   0,  92, 255,   0,   0,  97, 255,   0,   0, 103, 255,   0,   0, 108, 255,   0,   0, 114, 255,   0,   0, 119, 255,   0,   0, 125, 255,   0,   0, 129, 255,   0,   0, 135, 255,   0,   0, 139, 255,   0,   0, 144, 255,   0,   0, 148, 255,   0,   0, 152, 255,   0,   0, 157, 255,   0,   0, 160, 255,   0,   0, 165, 255,   0,   0, 167, 255,   0,   0, 170, 255,   0,   0, 172, 255,   0,   0, 175, 255,   0,   0, 175, 255,   0,   0, 177, 255,   0,   0, 176, 255,   0,   0, 176, 255,   0,   0, 175, 255,   0,   0, 174, 255,   0,   0, 172, 255,   0,   0, 170, 255,   0,   0, 167, 255,   0,   0, 164, 255,   0,   0, 161, 255,   0,   0, 157, 255,   0,   0, 153, 255,   0,   0, 148, 255,   0,   0, 144, 255,   0,   0, 139, 255,   0,   0, 135, 255,   0,   0, 130, 255,   0,   0, 125, 255,   0,   0, 119, 255,   0,   0, 114, 255,   0,   0, 108, 255,   0,   0, 103, 255,   0,   0,  97, 255,   0,   0,  91, 255,   0,   0,  86, 255,   0,   0,  80, 255,   0,   0,  73, 255,   0,   0,  68, 255,   0,   0,  62, 255,   0,   0,  56, 255,   0,   0,  50, 255,   0,   0,  43, 255,   0,   0,  37, 255,   0,   0,  31, 255,   0,   0,  25, 255,   0,   0,  19, 255,   0,   0,  13, 255,   0,   0,   7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   9, 255,   0,   0,  15, 255,   0,   0,  22, 255,   0,   0,  28, 255,   0,   0,  34, 255,   0,   0,  39, 255,   0,   0,  46, 255,   0,   0,  52, 255,   0,   0,  58, 255,   0,   0,  64, 255,   0,   0,  70, 255,   0,   0,  76, 255,   0,   0,  83, 255,   0,   0,  88, 255,   0,   0,  95, 255,   0,   0, 100, 255,   0,   0, 106, 255,   0,   0, 111, 255,   0,   0, 117, 255,   0,   0, 123, 255,   0,   0, 128, 255,   0,   0, 134, 255,   0,   0, 138, 255,   0,   0, 144, 255,   0,   0, 149, 255,   0,   0, 153, 255,   0,   0, 158, 255,   0,   0, 162, 255,   0,   0, 166, 255,   0,   0, 170, 255,   0,   0, 173, 255,   0,   0, 176, 255,   0,   0, 178, 255,   0,   0, 181, 255,   0,   0, 182, 255,   0,   0, 182, 255,   0,   0, 183, 255,   0,   0, 183, 255,   0,   0, 182, 255,   0,   0, 180, 255,   0,   0, 178, 255,   0,   0, 176, 255,   0,   0, 173, 255,   0,   0, 170, 255,   0,   0, 166, 255,   0,   0, 162, 255,   0,   0, 157, 255,   0,   0, 154, 255,   0,   0, 148, 255,   0,   0, 144, 255,   0,   0, 139, 255,   0,   0, 133, 255,   0,   0, 128, 255,   0,   0, 122, 255,   0,   0, 117, 255,   0,   0, 112, 255,   0,   0, 106, 255,   0,   0, 100, 255,   0,   0,  94, 255,   0,   0,  89, 255,   0,   0,  82, 255,   0,   0,  77, 255,   0,   0,  71, 255,   0,   0,  65, 255,   0,   0,  59, 255,   0,   0,  52, 255,   0,   0,  46, 255,   0,   0,  40, 255,   0,   0,  33, 255,   0,   0,  27, 255,   0,   0,  22, 255,   0,   0,  16, 255,   0,   0,   9, 255,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   4, 255,   0,   0,  10, 255,   0,   0,  17, 255,   0,   0,  24, 255,   0,   0,  30, 255,   0,   0,  36, 255,   0,   0,  42, 255,   0,   0,  48, 255,   0,   0,  55, 255,   0,   0,  60, 255,   0,   0,  67, 255,   0,   0,  72, 255,   0,   0,  79, 255,   0,   0,  85, 255,   0,   0,  91, 255,   0,   0,  97, 255,   0,   0, 103, 255,   0,   0, 109, 255,   0,   0, 114, 255,   0,   0, 120, 255,   0,   0, 126, 255,   0,   0, 132, 255,   0,   0, 137, 255,   0,   0, 143, 255,   0,   0, 148, 255,   0,   0, 153, 255,   0,   0, 158, 255,   0,   0, 163, 255,   0,   0, 167, 255,   0,   0, 171, 255,   0,   0, 175, 255,   0,   0, 179, 255,   0,   0, 182, 255,   0,   0, 185, 255,   0,   0, 187, 255,   0,   0, 188, 255,   0,   0, 189, 255,   0,   0, 190, 255,   0,   0, 190, 255,   0,   0, 188, 255,   0,   0, 186, 255,   0,   0, 185, 255,   0,   0, 182, 255,   0,   0, 179, 255,   0,   0, 176, 255,   0,   0, 171, 255,   0,   0, 167, 255,   0,   0, 163, 255,   0,   0, 158, 255,   0,   0, 153, 255,   0,   0, 147, 255,   0,   0, 142, 255,   0,   0, 137, 255,   0,   0, 132, 255,   0,   0, 126, 255,   0,   0, 120, 255,   0,   0, 114, 255,   0,   0, 109, 255,   0,   0, 103, 255,   0,   0,  97, 255,   0,   0,  91, 255,   0,   0,  85, 255,   0,   0,  79, 255,   0,   0,  73, 255,   0,   0,  67, 255,   0,   0,  61, 255,   0,   0,  55, 255,   0,   0,  48, 255,   0,   0,  42, 255,   0,   0,  36, 255,   0,   0,  29, 255,   0,   0,  24, 255,   0,   0,  17, 255,   0,   0,  11, 255,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   6, 255,   0,   0,  12, 255,   0,   0,  19, 255,   0,   0,  25, 255,   0,   0,  31, 255,   0,   0,  38, 255,   0,   0,  44, 255,   0,   0,  50, 255,   0,   0,  56, 255,   0,   0,  63, 255,   0,   0,  69, 255,   0,   0,  75, 255,   0,   0,  82, 255,   0,   0,  88, 255,   0,   0,  93, 255,   0,   0,  99, 255,   0,   0, 105, 255,   0,   0, 111, 255,   0,   0, 117, 255,   0,   0, 123, 255,   0,   0, 130, 255,   0,   0, 135, 255,   0,   0, 140, 255,   0,   0, 146, 255,   0,   0, 152, 255,   0,   0, 157, 255,   0,   0, 163, 255,   0,   0, 167, 255,   0,   0, 172, 255,   0,   0, 177, 255,   0,   0, 180, 255,   0,   0, 184, 255,   0,   0, 188, 255,   0,   0, 190, 255,   0,   0, 193, 255,   0,   0, 194, 255,   0,   0, 196, 255,   0,   0, 196, 255,   0,   0, 196, 255,   0,   0, 195, 255,   0,   0, 193, 255,   0,   0, 191, 255,   0,   0, 188, 255,   0,   0, 185, 255,   0,   0, 181, 255,   0,   0, 177, 255,   0,   0, 171, 255,   0,   0, 167, 255,   0,   0, 162, 255,   0,   0, 157, 255,   0,   0, 152, 255,   0,   0, 146, 255,   0,   0, 141, 255,   0,   0, 135, 255,   0,   0, 129, 255,   0,   0, 124, 255,   0,   0, 118, 255,   0,   0, 112, 255,   0,   0, 106, 255,   0,   0,  99, 255,   0,   0,  94, 255,   0,   0,  88, 255,   0,   0,  81, 255,   0,   0,  76, 255,   0,   0,  69, 255,   0,   0,  62, 255,   0,   0,  56, 255,   0,   0,  50, 255,   0,   0,  44, 255,   0,   0,  38, 255,   0,   0,  32, 255,   0,   0,  25, 255,   0,   0,  19, 255,   0,   0,  12, 255,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   7, 255,   0,   0,  14, 255,   0,   0,  20, 255,   0,   0,  26, 255,   0,   0,  33, 255,   0,   0,  39, 255,   0,   0,  45, 255,   0,   0,  52, 255,   0,   0,  59, 255,   0,   0,  65, 255,   0,   0,  71, 255,   0,   0,  77, 255,   0,   0,  83, 255,   0,   0,  89, 255,   0,   0,  96, 255,   0,   0, 102, 255,   0,   0, 108, 255,   0,   0, 114, 255,   0,   0, 120, 255,   0,   0, 126, 255,   0,   0, 132, 255,   0,   0, 138, 255,   0,   0, 144, 255,   0,   0, 150, 255,   0,   0, 155, 255,   0,   0, 161, 255,   0,   0, 166, 255,   0,   0, 171, 255,   0,   0, 176, 255,   0,   0, 181, 255,   0,   0, 185, 255,   0,   0, 190, 255,   0,   0, 193, 255,   0,   0, 197, 255,   0,   0, 199, 255,   0,   0, 202, 255,   0,   0, 202, 255,   0,   0, 203, 255,   0,   0, 202, 255,   0,   0, 201, 255,   0,   0, 199, 255,   0,   0, 197, 255,   0,   0, 193, 255,   0,   0, 190, 255,   0,   0, 186, 255,   0,   0, 181, 255,   0,   0, 177, 255,   0,   0, 171, 255,   0,   0, 166, 255,   0,   0, 161, 255,   0,   0, 155, 255,   0,   0, 150, 255,   0,   0, 143, 255,   0,   0, 138, 255,   0,   0, 132, 255,   0,   0, 126, 255,   0,   0, 120, 255,   0,   0, 115, 255,   0,   0, 108, 255,   0,   0, 102, 255,   0,   0,  96, 255,   0,   0,  89, 255,   0,   0,  84, 255,   0,   0,  77, 255,   0,   0,  71, 255,   0,   0,  65, 255,   0,   0,  58, 255,   0,   0,  52, 255,   0,   0,  45, 255,   0,   0,  39, 255,   0,   0,  33, 255,   0,   0,  27, 255,   0,   0,  20, 255,   0,   0,  14, 255,   0,   0,   7, 255,   0,   0,   1,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   2, 255,   0,   0,   8, 255,   0,   0,  15, 255,   0,   0,  22, 255,   0,   0,  28, 255,   0,   0,  34, 255,   0,   0,  41, 255,   0,   0,  47, 255,   0,   0,  53, 255,   0,   0,  60, 255,   0,   0,  67, 255,   0,   0,  73, 255,   0,   0,  79, 255,   0,   0,  85, 255,   0,   0,  92, 255,   0,   0,  97, 255,   0,   0, 104, 255,   0,   0, 110, 255,   0,   0, 117, 255,   0,   0, 122, 255,   0,   0, 129, 255,   0,   0, 135, 255,   0,   0, 140, 255,   0,   0, 146, 255,   0,   0, 153, 255,   0,   0, 158, 255,   0,   0, 165, 255,   0,   0, 170, 255,   0,   0, 175, 255,   0,   0, 180, 255,   0,   0, 186, 255,   0,   0, 190, 255,   0,   0, 195, 255,   0,   0, 198, 255,   0,   0, 202, 255,   0,   0, 205, 255,   0,   0, 207, 255,   0,   0, 208, 255,   0,   0, 210, 255,   0,   0, 209, 255,   0,   0, 208, 255,   0,   0, 205, 255,   0,   0, 202, 255,   0,   0, 199, 255,   0,   0, 195, 255,   0,   0, 190, 255,   0,   0, 185, 255,   0,   0, 181, 255,   0,   0, 175, 255,   0,   0, 169, 255,   0,   0, 165, 255,   0,   0, 159, 255,   0,   0, 152, 255,   0,   0, 147, 255,   0,   0, 141, 255,   0,   0, 135, 255,   0,   0, 129, 255,   0,   0, 122, 255,   0,   0, 116, 255,   0,   0, 110, 255,   0,   0, 104, 255,   0,   0,  98, 255,   0,   0,  91, 255,   0,   0,  86, 255,   0,   0,  79, 255,   0,   0,  72, 255,   0,   0,  66, 255,   0,   0,  60, 255,   0,   0,  54, 255,   0,   0,  47, 255,   0,   0,  41, 255,   0,   0,  35, 255,   0,   0,  28, 255,   0,   0,  22, 255,   0,   0,  15, 255,   0,   0,   9, 255,   0,   0,   2,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   4, 255,   0,   0,  10, 255,   0,   0,  16, 255,   0,   0,  23, 255,   0,   0,  29, 255,   0,   0,  36, 255,   0,   0,  42, 255,   0,   0,  48, 255,   0,   0,  55, 255,   0,   0,  61, 255,   0,   0,  67, 255,   0,   0,  74, 255,   0,   0,  80, 255,   0,   0,  87, 255,   0,   0,  93, 255,   0,   0, 100, 255,   0,   0, 105, 255,   0,   0, 112, 255,   0,   0, 119, 255,   0,   0, 125, 255,   0,   0, 131, 255,   0,   0, 137, 255,   0,   0, 143, 255,   0,   0, 149, 255,   0,   0, 155, 255,   0,   0, 161, 255,   0,   0, 167, 255,   0,   0, 173, 255,   0,   0, 179, 255,   0,   0, 184, 255,   0,   0, 189, 255,   0,   0, 194, 255,   0,   0, 199, 255,   0,   0, 204, 255,   0,   0, 208, 255,   0,   0, 211, 255,   0,   0, 213, 255,   0,   0, 215, 255,   0,   0, 215, 255,   0,   0, 215, 255,   0,   0, 213, 255,   0,   0, 211, 255,   0,   0, 208, 255,   0,   0, 204, 255,   0,   0, 199, 255,   0,   0, 194, 255,   0,   0, 189, 255,   0,   0, 185, 255,   0,   0, 179, 255,   0,   0, 173, 255,   0,   0, 167, 255,   0,   0, 161, 255,   0,   0, 155, 255,   0,   0, 150, 255,   0,   0, 144, 255,   0,   0, 138, 255,   0,   0, 131, 255,   0,   0, 125, 255,   0,   0, 118, 255,   0,   0, 112, 255,   0,   0, 106, 255,   0,   0, 100, 255,   0,   0,  93, 255,   0,   0,  87, 255,   0,   0,  81, 255,   0,   0,  74, 255,   0,   0,  68, 255,   0,   0,  62, 255,   0,   0,  55, 255,   0,   0,  48, 255,   0,   0,  42, 255,   0,   0,  35, 255,   0,   0,  30, 255,   0,   0,  23, 255,   0,   0,  17, 255,   0,   0,  10, 255,   0,   0,   4,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   4, 255,   0,   0,  11, 255,   0,   0,  18, 255,   0,   0,  24, 255,   0,   0,  30, 255,   0,   0,  37, 255,   0,   0,  43, 255,   0,   0,  50, 255,   0,   0,  57, 255,   0,   0,  63, 255,   0,   0,  69, 255,   0,   0,  76, 255,   0,   0,  82, 255,   0,   0,  88, 255,   0,   0,  95, 255,   0,   0, 101, 255,   0,   0, 108, 255,   0,   0, 114, 255,   0,   0, 120, 255,   0,   0, 126, 255,   0,   0, 133, 255,   0,   0, 140, 255,   0,   0, 145, 255,   0,   0, 152, 255,   0,   0, 158, 255,   0,   0, 164, 255,   0,   0, 170, 255,   0,   0, 176, 255,   0,   0, 182, 255,   0,   0, 187, 255,   0,   0, 193, 255,   0,   0, 198, 255,   0,   0, 204, 255,   0,   0, 209, 255,   0,   0, 214, 255,   0,   0, 217, 255,   0,   0, 220, 255,   0,   0, 221, 255,   0,   0, 222, 255,   0,   0, 222, 255,   0,   0, 219, 255,   0,   0, 217, 255,   0,   0, 213, 255,   0,   0, 208, 255,   0,   0, 204, 255,   0,   0, 199, 255,   0,   0, 194, 255,   0,   0, 187, 255,   0,   0, 182, 255,   0,   0, 176, 255,   0,   0, 170, 255,   0,   0, 164, 255,   0,   0, 157, 255,   0,   0, 152, 255,   0,   0, 145, 255,   0,   0, 139, 255,   0,   0, 132, 255,   0,   0, 126, 255,   0,   0, 120, 255,   0,   0, 114, 255,   0,   0, 108, 255,   0,   0, 102, 255,   0,   0,  95, 255,   0,   0,  88, 255,   0,   0,  82, 255,   0,   0,  76, 255,   0,   0,  69, 255,   0,   0,  63, 255,   0,   0,  57, 255,   0,   0,  50, 255,   0,   0,  43, 255,   0,   0,  37, 255,   0,   0,  30, 255,   0,   0,  23, 255,   0,   0,  18, 255,   0,   0,  10, 255,   0,   0,   5,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   5, 255,   0,   0,  11, 255,   0,   0,  18, 255,   0,   0,  24, 255,   0,   0,  31, 255,   0,   0,  38, 255,   0,   0,  44, 255,   0,   0,  51, 255,   0,   0,  57, 255,   0,   0,  63, 255,   0,   0,  70, 255,   0,   0,  77, 255,   0,   0,  83, 255,   0,   0,  89, 255,   0,   0,  96, 255,   0,   0, 103, 255,   0,   0, 109, 255,   0,   0, 115, 255,   0,   0, 121, 255,   0,   0, 128, 255,   0,   0, 135, 255,   0,   0, 141, 255,   0,   0, 147, 255,   0,   0, 153, 255,   0,   0, 159, 255,   0,   0, 166, 255,   0,   0, 173, 255,   0,   0, 179, 255,   0,   0, 184, 255,   0,   0, 191, 255,   0,   0, 197, 255,   0,   0, 203, 255,   0,   0, 208, 255,   0,   0, 213, 255,   0,   0, 218, 255,   0,   0, 222, 255,   0,   0, 226, 255,   0,   0, 228, 255,   0,   0, 229, 255,   0,   0, 228, 255,   0,   0, 226, 255,   0,   0, 223, 255,   0,   0, 218, 255,   0,   0, 213, 255,   0,   0, 208, 255,   0,   0, 203, 255,   0,   0, 196, 255,   0,   0, 190, 255,   0,   0, 184, 255,   0,   0, 179, 255,   0,   0, 172, 255,   0,   0, 166, 255,   0,   0, 160, 255,   0,   0, 154, 255,   0,   0, 147, 255,   0,   0, 141, 255,   0,   0, 135, 255,   0,   0, 128, 255,   0,   0, 122, 255,   0,   0, 115, 255,   0,   0, 109, 255,   0,   0, 103, 255,   0,   0,  96, 255,   0,   0,  90, 255,   0,   0,  83, 255,   0,   0,  76, 255,   0,   0,  70, 255,   0,   0,  64, 255,   0,   0,  57, 255,   0,   0,  51, 255,   0,   0,  44, 255,   0,   0,  38, 255,   0,   0,  31, 255,   0,   0,  24, 255,   0,   0,  18, 255,   0,   0,  11, 255,   0,   0,   5,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   6, 255,   0,   0,  12, 255,   0,   0,  19, 255,   0,   0,  26, 255,   0,   0,  32, 255,   0,   0,  39, 255,   0,   0,  44, 255,   0,   0,  51, 255,   0,   0,  57, 255,   0,   0,  64, 255,   0,   0,  71, 255,   0,   0,  77, 255,   0,   0,  84, 255,   0,   0,  90, 255,   0,   0,  97, 255,   0,   0, 103, 255,   0,   0, 110, 255,   0,   0, 116, 255,   0,   0, 122, 255,   0,   0, 129, 255,   0,   0, 135, 255,   0,   0, 142, 255,   0,   0, 148, 255,   0,   0, 155, 255,   0,   0, 162, 255,   0,   0, 168, 255,   0,   0, 174, 255,   0,   0, 180, 255,   0,   0, 186, 255,   0,   0, 193, 255,   0,   0, 199, 255,   0,   0, 205, 255,   0,   0, 211, 255,   0,   0, 217, 255,   0,   0, 222, 255,   0,   0, 227, 255,   0,   0, 232, 255,   0,   0, 235, 255,   0,   0, 236, 255,   0,   0, 235, 255,   0,   0, 232, 255,   0,   0, 228, 255,   0,   0, 223, 255,   0,   0, 217, 255,   0,   0, 211, 255,   0,   0, 206, 255,   0,   0, 199, 255,   0,   0, 193, 255,   0,   0, 186, 255,   0,   0, 180, 255,   0,   0, 175, 255,   0,   0, 168, 255,   0,   0, 161, 255,   0,   0, 155, 255,   0,   0, 149, 255,   0,   0, 142, 255,   0,   0, 135, 255,   0,   0, 129, 255,   0,   0, 123, 255,   0,   0, 116, 255,   0,   0, 110, 255,   0,   0, 104, 255,   0,   0,  97, 255,   0,   0,  90, 255,   0,   0,  84, 255,   0,   0,  77, 255,   0,   0,  70, 255,   0,   0,  65, 255,   0,   0,  58, 255,   0,   0,  51, 255,   0,   0,  45, 255,   0,   0,  38, 255,   0,   0,  32, 255,   0,   0,  25, 255,   0,   0,  19, 255,   0,   0,  13, 255,   0,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   6, 255,   0,   0,  13, 255,   0,   0,  19, 255,   0,   0,  25, 255,   0,   0,  33, 255,   0,   0,  39, 255,   0,   0,  46, 255,   0,   0,  52, 255,   0,   0,  58, 255,   0,   0,  65, 255,   0,   0,  72, 255,   0,   0,  78, 255,   0,   0,  84, 255,   0,   0,  91, 255,   0,   0,  98, 255,   0,   0, 105, 255,   0,   0, 111, 255,   0,   0, 117, 255,   0,   0, 123, 255,   0,   0, 130, 255,   0,   0, 137, 255,   0,   0, 143, 255,   0,   0, 150, 255,   0,   0, 156, 255,   0,   0, 163, 255,   0,   0, 169, 255,   0,   0, 176, 255,   0,   0, 182, 255,   0,   0, 188, 255,   0,   0, 195, 255,   0,   0, 201, 255,   0,   0, 207, 255,   0,   0, 214, 255,   0,   0, 220, 255,   0,   0, 226, 255,   0,   0, 232, 255,   0,   0, 237, 255,   0,   0, 240, 255,   0,   0, 242, 255,   0,   0, 241, 255,   0,   0, 236, 255,   0,   0, 231, 255,   0,   0, 226, 255,   0,   0, 220, 255,   0,   0, 214, 255,   0,   0, 208, 255,   0,   0, 201, 255,   0,   0, 195, 255,   0,   0, 188, 255,   0,   0, 182, 255,   0,   0, 175, 255,   0,   0, 168, 255,   0,   0, 162, 255,   0,   0, 156, 255,   0,   0, 150, 255,   0,   0, 143, 255,   0,   0, 137, 255,   0,   0, 130, 255,   0,   0, 123, 255,   0,   0, 117, 255,   0,   0, 110, 255,   0,   0, 104, 255,   0,   0,  98, 255,   0,   0,  91, 255,   0,   0,  85, 255,   0,   0,  78, 255,   0,   0,  72, 255,   0,   0,  65, 255,   0,   0,  58, 255,   0,   0,  52, 255,   0,   0,  45, 255,   0,   0,  39, 255,   0,   0,  32, 255,   0,   0,  25, 255,   0,   0,  19, 255,   0,   0,  13, 255,   0,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   6, 255,   0,   0,  13, 255,   0,   0,  19, 255,   0,   0,  26, 255,   0,   0,  33, 255,   0,   0,  40, 255,   0,   0,  46, 255,   0,   0,  52, 255,   0,   0,  58, 255,   0,   0,  66, 255,   0,   0,  72, 255,   0,   0,  78, 255,   0,   0,  85, 255,   0,   0,  91, 255,   0,   0,  98, 255,   0,   0, 105, 255,   0,   0, 111, 255,   0,   0, 117, 255,   0,   0, 124, 255,   0,   0, 131, 255,   0,   0, 137, 255,   0,   0, 144, 255,   0,   0, 150, 255,   0,   0, 156, 255,   0,   0, 163, 255,   0,   0, 170, 255,   0,   0, 176, 255,   0,   0, 183, 255,   0,   0, 189, 255,   0,   0, 196, 255,   0,   0, 202, 255,   0,   0, 209, 255,   0,   0, 215, 255,   0,   0, 221, 255,   0,   0, 228, 255,   0,   0, 235, 255,   0,   0, 240, 255,   0,   0, 246, 255,   0,   0, 248, 255,   0,   0, 246, 255,   0,   0, 240, 255,   0,   0, 234, 255,   0,   0, 228, 255,   0,   0, 221, 255,   0,   0, 215, 255,   0,   0, 209, 255,   0,   0, 202, 255,   0,   0, 196, 255,   0,   0, 189, 255,   0,   0, 182, 255,   0,   0, 176, 255,   0,   0, 170, 255,   0,   0, 163, 255,   0,   0, 156, 255,   0,   0, 150, 255,   0,   0, 144, 255,   0,   0, 137, 255,   0,   0, 131, 255,   0,   0, 124, 255,   0,   0, 118, 255,   0,   0, 111, 255,   0,   0, 104, 255,   0,   0,  98, 255,   0,   0,  91, 255,   0,   0,  85, 255,   0,   0,  78, 255,   0,   0,  72, 255,   0,   0,  65, 255,   0,   0,  59, 255,   0,   0,  52, 255,   0,   0,  46, 255,   0,   0,  39, 255,   0,   0,  32, 255,   0,   0,  26, 255,   0,   0,  20, 255,   0,   0,  13, 255,   0,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   6, 255,   0,   0,  13, 255,   0,   0,  19, 255,   0,   0,  26, 255,   0,   0,  32, 255,   0,   0,  39, 255,   0,   0,  46, 255,   0,   0,  52, 255,   0,   0,  59, 255,   0,   0,  66, 255,   0,   0,  72, 255,   0,   0,  78, 255,   0,   0,  85, 255,   0,   0,  92, 255,   0,   0,  98, 255,   0,   0, 104, 255,   0,   0, 111, 255,   0,   0, 118, 255,   0,   0, 124, 255,   0,   0, 131, 255,   0,   0, 138, 255,   0,   0, 143, 255,   0,   0, 151, 255,   0,   0, 157, 255,   0,   0, 163, 255,   0,   0, 170, 255,   0,   0, 176, 255,   0,   0, 183, 255,   0,   0, 189, 255,   0,   0, 196, 255,   0,   0, 202, 255,   0,   0, 209, 255,   0,   0, 215, 255,   0,   0, 222, 255,   0,   0, 229, 255,   0,   0, 235, 255,   0,   0, 242, 255,   0,   0, 249, 255,   0,   0, 255, 255,   0,   0, 249, 255,   0,   0, 242, 255,   0,   0, 235, 255,   0,   0, 229, 255,   0,   0, 222, 255,   0,   0, 215, 255,   0,   0, 209, 255,   0,   0, 202, 255,   0,   0, 196, 255,   0,   0, 189, 255,   0,   0, 183, 255,   0,   0, 176, 255,   0,   0, 170, 255,   0,   0, 163, 255,   0,   0, 157, 255,   0,   0, 151, 255,   0,   0, 144, 255,   0,   0, 138, 255,   0,   0, 130, 255,   0,   0, 124, 255,   0,   0, 118, 255,   0,   0, 111, 255,   0,   0, 105, 255,   0,   0,  98, 255,   0,   0,  92, 255,   0,   0,  85, 255,   0,   0,  78, 255,   0,   0,  72, 255,   0,   0,  65, 255,   0,   0,  59, 255,   0,   0,  53, 255,   0,   0,  46, 255,   0,   0,  39, 255,   0,   0,  32, 255,   0,   0,  27, 255,   0,   0,  19, 255,   0,   0,  14, 255,   0,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   7, 255,   0,   0,  13, 255,   0,   0,  20, 255,   0,   0,  26, 255,   0,   0,  32, 255,   0,   0,  39, 255,   0,   0,  45, 255,   0,   0,  52, 255,   0,   0,  58, 255,   0,   0,  66, 255,   0,   0,  72, 255,   0,   0,  78, 255,   0,   0,  84, 255,   0,   0,  91, 255,   0,   0,  98, 255,   0,   0, 104, 255,   0,   0, 111, 255,   0,   0, 118, 255,   0,   0, 124, 255,   0,   0, 131, 255,   0,   0, 137, 255,   0,   0, 143, 255,   0,   0, 151, 255,   0,   0, 156, 255,   0,   0, 163, 255,   0,   0, 169, 255,   0,   0, 176, 255,   0,   0, 183, 255,   0,   0, 190, 255,   0,   0, 196, 255,   0,   0, 202, 255,   0,   0, 209, 255,   0,   0, 215, 255,   0,   0, 221, 255,   0,   0, 228, 255,   0,   0, 234, 255,   0,   0, 240, 255,   0,   0, 246, 255,   0,   0, 249, 255,   0,   0, 246, 255,   0,   0, 241, 255,   0,   0, 234, 255,   0,   0, 228, 255,   0,   0, 222, 255,   0,   0, 215, 255,   0,   0, 209, 255,   0,   0, 202, 255,   0,   0, 195, 255,   0,   0, 189, 255,   0,   0, 183, 255,   0,   0, 176, 255,   0,   0, 170, 255,   0,   0, 163, 255,   0,   0, 157, 255,   0,   0, 150, 255,   0,   0, 144, 255,   0,   0, 137, 255,   0,   0, 131, 255,   0,   0, 125, 255,   0,   0, 117, 255,   0,   0, 111, 255,   0,   0, 104, 255,   0,   0,  98, 255,   0,   0,  91, 255,   0,   0,  85, 255,   0,   0,  78, 255,   0,   0,  72, 255,   0,   0,  66, 255,   0,   0,  59, 255,   0,   0,  52, 255,   0,   0,  45, 255,   0,   0,  39, 255,   0,   0,  33, 255,   0,   0,  26, 255,   0,   0,  20, 255,   0,   0,  13, 255,   0,   0,   7,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   7, 255,   0,   0,  13, 255,   0,   0,  19, 255,   0,   0,  26, 255,   0,   0,  33, 255,   0,   0,  39, 255,   0,   0,  45, 255,   0,   0,  51, 255,   0,   0,  58, 255,   0,   0,  65, 255,   0,   0,  71, 255,   0,   0,  78, 255,   0,   0,  84, 255,   0,   0,  91, 255,   0,   0,  97, 255,   0,   0, 104, 255,   0,   0, 110, 255,   0,   0, 117, 255,   0,   0, 124, 255,   0,   0, 130, 255,   0,   0, 136, 255,   0,   0, 143, 255,   0,   0, 149, 255,   0,   0, 156, 255,   0,   0, 162, 255,   0,   0, 169, 255,   0,   0, 176, 255,   0,   0, 182, 255,   0,   0, 188, 255,   0,   0, 195, 255,   0,   0, 201, 255,   0,   0, 207, 255,   0,   0, 213, 255,   0,   0, 220, 255,   0,   0, 226, 255,   0,   0, 231, 255,   0,   0, 237, 255,   0,   0, 240, 255,   0,   0, 242, 255,   0,   0, 240, 255,   0,   0, 236, 255,   0,   0, 231, 255,   0,   0, 226, 255,   0,   0, 219, 255,   0,   0, 213, 255,   0,   0, 207, 255,   0,   0, 201, 255,   0,   0, 195, 255,   0,   0, 188, 255,   0,   0, 182, 255,   0,   0, 176, 255,   0,   0, 169, 255,   0,   0, 163, 255,   0,   0, 156, 255,   0,   0, 150, 255,   0,   0, 143, 255,   0,   0, 136, 255,   0,   0, 130, 255,   0,   0, 123, 255,   0,   0, 117, 255,   0,   0, 110, 255,   0,   0, 104, 255,   0,   0,  98, 255,   0,   0,  91, 255,   0,   0,  85, 255,   0,   0,  78, 255,   0,   0,  71, 255,   0,   0,  65, 255,   0,   0,  58, 255,   0,   0,  52, 255,   0,   0,  45, 255,   0,   0,  39, 255,   0,   0,  33, 255,   0,   0,  26, 255,   0,   0,  20, 255,   0,   0,  13, 255,   0,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   6, 255,   0,   0,  12, 255,   0,   0,  19, 255,   0,   0,  26, 255,   0,   0,  32, 255,   0,   0,  38, 255,   0,   0,  44, 255,   0,   0,  52, 255,   0,   0,  58, 255,   0,   0,  65, 255,   0,   0,  71, 255,   0,   0,  77, 255,   0,   0,  84, 255,   0,   0,  90, 255,   0,   0,  97, 255,   0,   0, 103, 255,   0,   0, 109, 255,   0,   0, 117, 255,   0,   0, 123, 255,   0,   0, 130, 255,   0,   0, 136, 255,   0,   0, 142, 255,   0,   0, 149, 255,   0,   0, 155, 255,   0,   0, 161, 255,   0,   0, 168, 255,   0,   0, 174, 255,   0,   0, 181, 255,   0,   0, 186, 255,   0,   0, 193, 255,   0,   0, 199, 255,   0,   0, 206, 255,   0,   0, 211, 255,   0,   0, 217, 255,   0,   0, 222, 255,   0,   0, 227, 255,   0,   0, 232, 255,   0,   0, 234, 255,   0,   0, 235, 255,   0,   0, 235, 255,   0,   0, 232, 255,   0,   0, 227, 255,   0,   0, 222, 255,   0,   0, 217, 255,   0,   0, 211, 255,   0,   0, 205, 255,   0,   0, 199, 255,   0,   0, 193, 255,   0,   0, 187, 255,   0,   0, 180, 255,   0,   0, 174, 255,   0,   0, 168, 255,   0,   0, 161, 255,   0,   0, 155, 255,   0,   0, 149, 255,   0,   0, 142, 255,   0,   0, 136, 255,   0,   0, 129, 255,   0,   0, 122, 255,   0,   0, 116, 255,   0,   0, 110, 255,   0,   0, 103, 255,   0,   0,  97, 255,   0,   0,  91, 255,   0,   0,  84, 255,   0,   0,  77, 255,   0,   0,  71, 255,   0,   0,  65, 255,   0,   0,  58, 255,   0,   0,  52, 255,   0,   0,  45, 255,   0,   0,  38, 255,   0,   0,  32, 255,   0,   0,  26, 255,   0,   0,  19, 255,   0,   0,  13, 255,   0,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   6, 255,   0,   0,  12, 255,   0,   0,  19, 255,   0,   0,  25, 255,   0,   0,  31, 255,   0,   0,  38, 255,   0,   0,  44, 255,   0,   0,  51, 255,   0,   0,  57, 255,   0,   0,  63, 255,   0,   0,  70, 255,   0,   0,  76, 255,   0,   0,  83, 255,   0,   0,  90, 255,   0,   0,  96, 255,   0,   0, 103, 255,   0,   0, 109, 255,   0,   0, 115, 255,   0,   0, 122, 255,   0,   0, 129, 255,   0,   0, 134, 255,   0,   0, 140, 255,   0,   0, 147, 255,   0,   0, 154, 255,   0,   0, 160, 255,   0,   0, 166, 255,   0,   0, 172, 255,   0,   0, 178, 255,   0,   0, 185, 255,   0,   0, 191, 255,   0,   0, 196, 255,   0,   0, 202, 255,   0,   0, 207, 255,   0,   0, 213, 255,   0,   0, 218, 255,   0,   0, 222, 255,   0,   0, 226, 255,   0,   0, 228, 255,   0,   0, 229, 255,   0,   0, 228, 255,   0,   0, 226, 255,   0,   0, 222, 255,   0,   0, 218, 255,   0,   0, 213, 255,   0,   0, 208, 255,   0,   0, 203, 255,   0,   0, 197, 255,   0,   0, 191, 255,   0,   0, 184, 255,   0,   0, 179, 255,   0,   0, 172, 255,   0,   0, 166, 255,   0,   0, 160, 255,   0,   0, 153, 255,   0,   0, 147, 255,   0,   0, 140, 255,   0,   0, 134, 255,   0,   0, 128, 255,   0,   0, 122, 255,   0,   0, 115, 255,   0,   0, 109, 255,   0,   0, 102, 255,   0,   0,  96, 255,   0,   0,  90, 255,   0,   0,  83, 255,   0,   0,  76, 255,   0,   0,  70, 255,   0,   0,  64, 255,   0,   0,  57, 255,   0,   0,  50, 255,   0,   0,  44, 255,   0,   0,  37, 255,   0,   0,  31, 255,   0,   0,  25, 255,   0,   0,  18, 255,   0,   0,  12, 255,   0,   0,   5,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   4, 255,   0,   0,  11, 255,   0,   0,  17, 255,   0,   0,  24, 255,   0,   0,  30, 255,   0,   0,  37, 255,   0,   0,  43, 255,   0,   0,  50, 255,   0,   0,  56, 255,   0,   0,  62, 255,   0,   0,  69, 255,   0,   0,  75, 255,   0,   0,  81, 255,   0,   0,  88, 255,   0,   0,  94, 255,   0,   0, 101, 255,   0,   0, 107, 255,   0,   0, 114, 255,   0,   0, 120, 255,   0,   0, 126, 255,   0,   0, 132, 255,   0,   0, 140, 255,   0,   0, 146, 255,   0,   0, 151, 255,   0,   0, 158, 255,   0,   0, 163, 255,   0,   0, 170, 255,   0,   0, 176, 255,   0,   0, 182, 255,   0,   0, 188, 255,   0,   0, 193, 255,   0,   0, 198, 255,   0,   0, 204, 255,   0,   0, 208, 255,   0,   0, 213, 255,   0,   0, 217, 255,   0,   0, 220, 255,   0,   0, 221, 255,   0,   0, 222, 255,   0,   0, 222, 255,   0,   0, 220, 255,   0,   0, 217, 255,   0,   0, 213, 255,   0,   0, 208, 255,   0,   0, 204, 255,   0,   0, 199, 255,   0,   0, 194, 255,   0,   0, 187, 255,   0,   0, 182, 255,   0,   0, 176, 255,   0,   0, 170, 255,   0,   0, 164, 255,   0,   0, 158, 255,   0,   0, 152, 255,   0,   0, 145, 255,   0,   0, 139, 255,   0,   0, 133, 255,   0,   0, 126, 255,   0,   0, 120, 255,   0,   0, 114, 255,   0,   0, 107, 255,   0,   0, 101, 255,   0,   0,  95, 255,   0,   0,  88, 255,   0,   0,  82, 255,   0,   0,  76, 255,   0,   0,  69, 255,   0,   0,  62, 255,   0,   0,  57, 255,   0,   0,  50, 255,   0,   0,  43, 255,   0,   0,  37, 255,   0,   0,  30, 255,   0,   0,  24, 255,   0,   0,  18, 255,   0,   0,  11, 255,   0,   0,   4,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,  10, 255,   0,   0,  17, 255,   0,   0,  22, 255,   0,   0,  29, 255,   0,   0,  36, 255,   0,   0,  42, 255,   0,   0,  48, 255,   0,   0,  55, 255,   0,   0,  62, 255,   0,   0,  67, 255,   0,   0,  74, 255,   0,   0,  80, 255,   0,   0,  87, 255,   0,   0,  93, 255,   0,   0, 100, 255,   0,   0, 106, 255,   0,   0, 112, 255,   0,   0, 119, 255,   0,   0, 124, 255,   0,   0, 131, 255,   0,   0, 137, 255,   0,   0, 143, 255,   0,   0, 150, 255,   0,   0, 156, 255,   0,   0, 162, 255,   0,   0, 168, 255,   0,   0, 173, 255,   0,   0, 178, 255,   0,   0, 185, 255,   0,   0, 190, 255,   0,   0, 194, 255,   0,   0, 200, 255,   0,   0, 204, 255,   0,   0, 208, 255,   0,   0, 211, 255,   0,   0, 213, 255,   0,   0, 215, 255,   0,   0, 216, 255,   0,   0, 215, 255,   0,   0, 214, 255,   0,   0, 212, 255,   0,   0, 208, 255,   0,   0, 204, 255,   0,   0, 199, 255,   0,   0, 194, 255,   0,   0, 190, 255,   0,   0, 184, 255,   0,   0, 178, 255,   0,   0, 173, 255,   0,   0, 167, 255,   0,   0, 162, 255,   0,   0, 156, 255,   0,   0, 150, 255,   0,   0, 143, 255,   0,   0, 137, 255,   0,   0, 131, 255,   0,   0, 125, 255,   0,   0, 118, 255,   0,   0, 112, 255,   0,   0, 106, 255,   0,   0,  99, 255,   0,   0,  93, 255,   0,   0,  87, 255,   0,   0,  81, 255,   0,   0,  74, 255,   0,   0,  67, 255,   0,   0,  61, 255,   0,   0,  55, 255,   0,   0,  49, 255,   0,   0,  42, 255,   0,   0,  36, 255,   0,   0,  29, 255,   0,   0,  23, 255,   0,   0,  16, 255,   0,   0,  10, 255,   0,   0,   4,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   9, 255,   0,   0,  15, 255,   0,   0,  21, 255,   0,   0,  28, 255,   0,   0,  34, 255,   0,   0,  41, 255,   0,   0,  47, 255,   0,   0,  54, 255,   0,   0,  60, 255,   0,   0,  67, 255,   0,   0,  73, 255,   0,   0,  79, 255,   0,   0,  86, 255,   0,   0,  92, 255,   0,   0,  98, 255,   0,   0, 104, 255,   0,   0, 110, 255,   0,   0, 116, 255,   0,   0, 122, 255,   0,   0, 129, 255,   0,   0, 135, 255,   0,   0, 141, 255,   0,   0, 147, 255,   0,   0, 152, 255,   0,   0, 159, 255,   0,   0, 164, 255,   0,   0, 170, 255,   0,   0, 175, 255,   0,   0, 181, 255,   0,   0, 185, 255,   0,   0, 190, 255,   0,   0, 195, 255,   0,   0, 199, 255,   0,   0, 202, 255,   0,   0, 206, 255,   0,   0, 208, 255,   0,   0, 209, 255,   0,   0, 210, 255,   0,   0, 209, 255,   0,   0, 208, 255,   0,   0, 205, 255,   0,   0, 202, 255,   0,   0, 198, 255,   0,   0, 195, 255,   0,   0, 190, 255,   0,   0, 186, 255,   0,   0, 180, 255,   0,   0, 175, 255,   0,   0, 170, 255,   0,   0, 164, 255,   0,   0, 159, 255,   0,   0, 152, 255,   0,   0, 147, 255,   0,   0, 141, 255,   0,   0, 135, 255,   0,   0, 128, 255,   0,   0, 122, 255,   0,   0, 117, 255,   0,   0, 111, 255,   0,   0, 104, 255,   0,   0,  97, 255,   0,   0,  91, 255,   0,   0,  85, 255,   0,   0,  79, 255,   0,   0,  73, 255,   0,   0,  67, 255,   0,   0,  60, 255,   0,   0,  54, 255,   0,   0,  47, 255,   0,   0,  41, 255,   0,   0,  34, 255,   0,   0,  28, 255,   0,   0,  21, 255,   0,   0,  15, 255,   0,   0,   9, 255,   0,   0,   3,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   7, 255,   0,   0,  14, 255,   0,   0,  20, 255,   0,   0,  27, 255,   0,   0,  33, 255,   0,   0,  39, 255,   0,   0,  46, 255,   0,   0,  52, 255,   0,   0,  58, 255,   0,   0,  65, 255,   0,   0,  71, 255,   0,   0,  77, 255,   0,   0,  83, 255,   0,   0,  90, 255,   0,   0,  96, 255,   0,   0, 102, 255,   0,   0, 108, 255,   0,   0, 114, 255,   0,   0, 120, 255,   0,   0, 126, 255,   0,   0, 132, 255,   0,   0, 138, 255,   0,   0, 144, 255,   0,   0, 149, 255,   0,   0, 155, 255,   0,   0, 161, 255,   0,   0, 166, 255,   0,   0, 172, 255,   0,   0, 176, 255,   0,   0, 181, 255,   0,   0, 185, 255,   0,   0, 189, 255,   0,   0, 193, 255,   0,   0, 197, 255,   0,   0, 200, 255,   0,   0, 201, 255,   0,   0, 202, 255,   0,   0, 202, 255,   0,   0, 203, 255,   0,   0, 201, 255,   0,   0, 199, 255,   0,   0, 197, 255,   0,   0, 193, 255,   0,   0, 189, 255,   0,   0, 185, 255,   0,   0, 181, 255,   0,   0, 177, 255,   0,   0, 172, 255,   0,   0, 167, 255,   0,   0, 161, 255,   0,   0, 155, 255,   0,   0, 150, 255,   0,   0, 144, 255,   0,   0, 138, 255,   0,   0, 132, 255,   0,   0, 126, 255,   0,   0, 120, 255,   0,   0, 114, 255,   0,   0, 108, 255,   0,   0, 102, 255,   0,   0,  96, 255,   0,   0,  89, 255,   0,   0,  83, 255,   0,   0,  77, 255,   0,   0,  71, 255,   0,   0,  64, 255,   0,   0,  58, 255,   0,   0,  52, 255,   0,   0,  46, 255,   0,   0,  40, 255,   0,   0,  33, 255,   0,   0,  27, 255,   0,   0,  21, 255,   0,   0,  14, 255,   0,   0,   7, 255,   0,   0,   1,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   6, 255,   0,   0,  12, 255,   0,   0,  18, 255,   0,   0,  25, 255,   0,   0,  32, 255,   0,   0,  38, 255,   0,   0,  44, 255,   0,   0,  50, 255,   0,   0,  56, 255,   0,   0,  62, 255,   0,   0,  69, 255,   0,   0,  75, 255,   0,   0,  81, 255,   0,   0,  87, 255,   0,   0,  94, 255,   0,   0, 100, 255,   0,   0, 106, 255,   0,   0, 112, 255,   0,   0, 118, 255,   0,   0, 123, 255,   0,   0, 129, 255,   0,   0, 135, 255,   0,   0, 140, 255,   0,   0, 147, 255,   0,   0, 152, 255,   0,   0, 157, 255,   0,   0, 162, 255,   0,   0, 167, 255,   0,   0, 172, 255,   0,   0, 176, 255,   0,   0, 181, 255,   0,   0, 184, 255,   0,   0, 188, 255,   0,   0, 191, 255,   0,   0, 193, 255,   0,   0, 195, 255,   0,   0, 196, 255,   0,   0, 196, 255,   0,   0, 196, 255,   0,   0, 195, 255,   0,   0, 193, 255,   0,   0, 191, 255,   0,   0, 188, 255,   0,   0, 184, 255,   0,   0, 181, 255,   0,   0, 177, 255,   0,   0, 172, 255,   0,   0, 167, 255,   0,   0, 162, 255,   0,   0, 157, 255,   0,   0, 151, 255,   0,   0, 146, 255,   0,   0, 140, 255,   0,   0, 134, 255,   0,   0, 129, 255,   0,   0, 124, 255,   0,   0, 118, 255,   0,   0, 112, 255,   0,   0, 106, 255,   0,   0, 100, 255,   0,   0,  94, 255,   0,   0,  87, 255,   0,   0,  82, 255,   0,   0,  75, 255,   0,   0,  68, 255,   0,   0,  63, 255,   0,   0,  56, 255,   0,   0,  50, 255,   0,   0,  44, 255,   0,   0,  38, 255,   0,   0,  32, 255,   0,   0,  25, 255,   0,   0,  19, 255,   0,   0,  12, 255,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   4, 255,   0,   0,  11, 255,   0,   0,  17, 255,   0,   0,  23, 255,   0,   0,  30, 255,   0,   0,  36, 255,   0,   0,  42, 255,   0,   0,  48, 255,   0,   0,  55, 255,   0,   0,  61, 255,   0,   0,  67, 255,   0,   0,  73, 255,   0,   0,  79, 255,   0,   0,  85, 255,   0,   0,  91, 255,   0,   0,  97, 255,   0,   0, 103, 255,   0,   0, 108, 255,   0,   0, 114, 255,   0,   0, 120, 255,   0,   0, 126, 255,   0,   0, 132, 255,   0,   0, 137, 255,   0,   0, 143, 255,   0,   0, 148, 255,   0,   0, 153, 255,   0,   0, 157, 255,   0,   0, 162, 255,   0,   0, 167, 255,   0,   0, 171, 255,   0,   0, 175, 255,   0,   0, 179, 255,   0,   0, 182, 255,   0,   0, 185, 255,   0,   0, 187, 255,   0,   0, 188, 255,   0,   0, 190, 255,   0,   0, 190, 255,   0,   0, 189, 255,   0,   0, 188, 255,   0,   0, 187, 255,   0,   0, 185, 255,   0,   0, 181, 255,   0,   0, 179, 255,   0,   0, 175, 255,   0,   0, 172, 255,   0,   0, 167, 255,   0,   0, 163, 255,   0,   0, 158, 255,   0,   0, 153, 255,   0,   0, 148, 255,   0,   0, 142, 255,   0,   0, 137, 255,   0,   0, 132, 255,   0,   0, 126, 255,   0,   0, 120, 255,   0,   0, 115, 255,   0,   0, 109, 255,   0,   0, 103, 255,   0,   0,  97, 255,   0,   0,  91, 255,   0,   0,  85, 255,   0,   0,  79, 255,   0,   0,  73, 255,   0,   0,  67, 255,   0,   0,  61, 255,   0,   0,  54, 255,   0,   0,  48, 255,   0,   0,  42, 255,   0,   0,  36, 255,   0,   0,  29, 255,   0,   0,  23, 255,   0,   0,  17, 255,   0,   0,  11, 255,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   8, 255,   0,   0,  16, 255,   0,   0,  22, 255,   0,   0,  27, 255,   0,   0,  34, 255,   0,   0,  40, 255,   0,   0,  46, 255,   0,   0,  52, 255,   0,   0,  59, 255,   0,   0,  64, 255,   0,   0,  71, 255,   0,   0,  76, 255,   0,   0,  83, 255,   0,   0,  88, 255,   0,   0,  94, 255,   0,   0, 100, 255,   0,   0, 106, 255,   0,   0, 111, 255,   0,   0, 117, 255,   0,   0, 123, 255,   0,   0, 128, 255,   0,   0, 133, 255,   0,   0, 138, 255,   0,   0, 144, 255,   0,   0, 148, 255,   0,   0, 153, 255,   0,   0, 157, 255,   0,   0, 162, 255,   0,   0, 166, 255,   0,   0, 169, 255,   0,   0, 173, 255,   0,   0, 176, 255,   0,   0, 178, 255,   0,   0, 180, 255,   0,   0, 182, 255,   0,   0, 183, 255,   0,   0, 183, 255,   0,   0, 183, 255,   0,   0, 181, 255,   0,   0, 180, 255,   0,   0, 179, 255,   0,   0, 176, 255,   0,   0, 173, 255,   0,   0, 170, 255,   0,   0, 166, 255,   0,   0, 162, 255,   0,   0, 158, 255,   0,   0, 153, 255,   0,   0, 149, 255,   0,   0, 144, 255,   0,   0, 139, 255,   0,   0, 134, 255,   0,   0, 128, 255,   0,   0, 122, 255,   0,   0, 117, 255,   0,   0, 112, 255,   0,   0, 106, 255,   0,   0, 100, 255,   0,   0,  94, 255,   0,   0,  88, 255,   0,   0,  83, 255,   0,   0,  77, 255,   0,   0,  70, 255,   0,   0,  64, 255,   0,   0,  58, 255,   0,   0,  52, 255,   0,   0,  46, 255,   0,   0,  40, 255,   0,   0,  34, 255,   0,   0,  27, 255,   0,   0,  21, 255,   0,   0,  16, 255,   0,   0,   9, 255,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   7, 255,   0,   0,  13, 255,   0,   0,  19, 255,   0,   0,  25, 255,   0,   0,  32, 255,   0,   0,  38, 255,   0,   0,  44, 255,   0,   0,  49, 255,   0,   0,  56, 255,   0,   0,  62, 255,   0,   0,  68, 255,   0,   0,  74, 255,   0,   0,  80, 255,   0,   0,  85, 255,   0,   0,  91, 255,   0,   0,  97, 255,   0,   0, 102, 255,   0,   0, 108, 255,   0,   0, 114, 255,   0,   0, 119, 255,   0,   0, 125, 255,   0,   0, 129, 255,   0,   0, 135, 255,   0,   0, 140, 255,   0,   0, 144, 255,   0,   0, 148, 255,   0,   0, 153, 255,   0,   0, 157, 255,   0,   0, 161, 255,   0,   0, 164, 255,   0,   0, 168, 255,   0,   0, 170, 255,   0,   0, 172, 255,   0,   0, 174, 255,   0,   0, 176, 255,   0,   0, 176, 255,   0,   0, 177, 255,   0,   0, 176, 255,   0,   0, 175, 255,   0,   0, 175, 255,   0,   0, 172, 255,   0,   0, 170, 255,   0,   0, 167, 255,   0,   0, 165, 255,   0,   0, 161, 255,   0,   0, 157, 255,   0,   0, 153, 255,   0,   0, 149, 255,   0,   0, 144, 255,   0,   0, 139, 255,   0,   0, 134, 255,   0,   0, 129, 255,   0,   0, 124, 255,   0,   0, 119, 255,   0,   0, 114, 255,   0,   0, 108, 255,   0,   0, 102, 255,   0,   0,  97, 255,   0,   0,  91, 255,   0,   0,  85, 255,   0,   0,  79, 255,   0,   0,  74, 255,   0,   0,  68, 255,   0,   0,  62, 255,   0,   0,  56, 255,   0,   0,  50, 255,   0,   0,  43, 255,   0,   0,  37, 255,   0,   0,  31, 255,   0,   0,  25, 255,   0,   0,  19, 255,   0,   0,  13, 255,   0,   0,   7, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   5, 255,   0,   0,  11, 255,   0,   0,  17, 255,   0,   0,  23, 255,   0,   0,  29, 255,   0,   0,  35, 255,   0,   0,  41, 255,   0,   0,  48, 255,   0,   0,  53, 255,   0,   0,  59, 255,   0,   0,  65, 255,   0,   0,  71, 255,   0,   0,  77, 255,   0,   0,  82, 255,   0,   0,  87, 255,   0,   0,  94, 255,   0,   0,  99, 255,   0,   0, 105, 255,   0,   0, 110, 255,   0,   0, 115, 255,   0,   0, 120, 255,   0,   0, 125, 255,   0,   0, 130, 255,   0,   0, 135, 255,   0,   0, 139, 255,   0,   0, 143, 255,   0,   0, 148, 255,   0,   0, 152, 255,   0,   0, 155, 255,   0,   0, 159, 255,   0,   0, 162, 255,   0,   0, 164, 255,   0,   0, 166, 255,   0,   0, 168, 255,   0,   0, 169, 255,   0,   0, 170, 255,   0,   0, 170, 255,   0,   0, 170, 255,   0,   0, 169, 255,   0,   0, 168, 255,   0,   0, 166, 255,   0,   0, 164, 255,   0,   0, 161, 255,   0,   0, 159, 255,   0,   0, 155, 255,   0,   0, 152, 255,   0,   0, 148, 255,   0,   0, 143, 255,   0,   0, 139, 255,   0,   0, 135, 255,   0,   0, 130, 255,   0,   0, 125, 255,   0,   0, 120, 255,   0,   0, 116, 255,   0,   0, 109, 255,   0,   0, 105, 255,   0,   0,  99, 255,   0,   0,  93, 255,   0,   0,  88, 255,   0,   0,  82, 255,   0,   0,  76, 255,   0,   0,  71, 255,   0,   0,  64, 255,   0,   0,  59, 255,   0,   0,  53, 255,   0,   0,  47, 255,   0,   0,  41, 255,   0,   0,  35, 255,   0,   0,  29, 255,   0,   0,  23, 255,   0,   0,  17, 255,   0,   0,  11, 255,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   8, 255,   0,   0,  15, 255,   0,   0,  21, 255,   0,   0,  27, 255,   0,   0,  32, 255,   0,   0,  38, 255,   0,   0,  45, 255,   0,   0,  50, 255,   0,   0,  56, 255,   0,   0,  62, 255,   0,   0,  68, 255,   0,   0,  73, 255,   0,   0,  79, 255,   0,   0,  85, 255,   0,   0,  90, 255,   0,   0,  95, 255,   0,   0, 101, 255,   0,   0, 106, 255,   0,   0, 111, 255,   0,   0, 116, 255,   0,   0, 120, 255,   0,   0, 125, 255,   0,   0, 130, 255,   0,   0, 134, 255,   0,   0, 139, 255,   0,   0, 143, 255,   0,   0, 146, 255,   0,   0, 150, 255,   0,   0, 152, 255,   0,   0, 155, 255,   0,   0, 158, 255,   0,   0, 160, 255,   0,   0, 162, 255,   0,   0, 162, 255,   0,   0, 163, 255,   0,   0, 164, 255,   0,   0, 163, 255,   0,   0, 162, 255,   0,   0, 161, 255,   0,   0, 160, 255,   0,   0, 158, 255,   0,   0, 155, 255,   0,   0, 152, 255,   0,   0, 150, 255,   0,   0, 146, 255,   0,   0, 143, 255,   0,   0, 139, 255,   0,   0, 134, 255,   0,   0, 130, 255,   0,   0, 125, 255,   0,   0, 121, 255,   0,   0, 116, 255,   0,   0, 111, 255,   0,   0, 106, 255,   0,   0, 101, 255,   0,   0,  95, 255,   0,   0,  90, 255,   0,   0,  85, 255,   0,   0,  79, 255,   0,   0,  74, 255,   0,   0,  68, 255,   0,   0,  62, 255,   0,   0,  56, 255,   0,   0,  51, 255,   0,   0,  44, 255,   0,   0,  39, 255,   0,   0,  33, 255,   0,   0,  27, 255,   0,   0,  21, 255,   0,   0,  15, 255,   0,   0,   9, 255,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   6, 255,   0,   0,  12, 255,   0,   0,  18, 255,   0,   0,  24, 255,   0,   0,  30, 255,   0,   0,  36, 255,   0,   0,  42, 255,   0,   0,  47, 255,   0,   0,  53, 255,   0,   0,  58, 255,   0,   0,  64, 255,   0,   0,  70, 255,   0,   0,  75, 255,   0,   0,  81, 255,   0,   0,  86, 255,   0,   0,  92, 255,   0,   0,  96, 255,   0,   0, 102, 255,   0,   0, 107, 255,   0,   0, 112, 255,   0,   0, 116, 255,   0,   0, 121, 255,   0,   0, 125, 255,   0,   0, 130, 255,   0,   0, 133, 255,   0,   0, 137, 255,   0,   0, 140, 255,   0,   0, 144, 255,   0,   0, 146, 255,   0,   0, 149, 255,   0,   0, 151, 255,   0,   0, 153, 255,   0,   0, 155, 255,   0,   0, 156, 255,   0,   0, 157, 255,   0,   0, 157, 255,   0,   0, 157, 255,   0,   0, 156, 255,   0,   0, 155, 255,   0,   0, 154, 255,   0,   0, 152, 255,   0,   0, 149, 255,   0,   0, 146, 255,   0,   0, 144, 255,   0,   0, 140, 255,   0,   0, 137, 255,   0,   0, 134, 255,   0,   0, 130, 255,   0,   0, 125, 255,   0,   0, 121, 255,   0,   0, 116, 255,   0,   0, 112, 255,   0,   0, 107, 255,   0,   0, 102, 255,   0,   0,  97, 255,   0,   0,  91, 255,   0,   0,  86, 255,   0,   0,  81, 255,   0,   0,  76, 255,   0,   0,  70, 255,   0,   0,  64, 255,   0,   0,  59, 255,   0,   0,  53, 255,   0,   0,  48, 255,   0,   0,  42, 255,   0,   0,  35, 255,   0,   0,  30, 255,   0,   0,  24, 255,   0,   0,  18, 255,   0,   0,  12, 255,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,  10, 255,   0,   0,  16, 255,   0,   0,  21, 255,   0,   0,  27, 255,   0,   0,  32, 255,   0,   0,  39, 255,   0,   0,  44, 255,   0,   0,  50, 255,   0,   0,  55, 255,   0,   0,  61, 255,   0,   0,  67, 255,   0,   0,  72, 255,   0,   0,  77, 255,   0,   0,  82, 255,   0,   0,  87, 255,   0,   0,  92, 255,   0,   0,  97, 255,   0,   0, 102, 255,   0,   0, 107, 255,   0,   0, 111, 255,   0,   0, 116, 255,   0,   0, 121, 255,   0,   0, 124, 255,   0,   0, 128, 255,   0,   0, 132, 255,   0,   0, 135, 255,   0,   0, 138, 255,   0,   0, 140, 255,   0,   0, 143, 255,   0,   0, 145, 255,   0,   0, 147, 255,   0,   0, 148, 255,   0,   0, 150, 255,   0,   0, 151, 255,   0,   0, 151, 255,   0,   0, 150, 255,   0,   0, 149, 255,   0,   0, 149, 255,   0,   0, 148, 255,   0,   0, 146, 255,   0,   0, 143, 255,   0,   0, 141, 255,   0,   0, 138, 255,   0,   0, 135, 255,   0,   0, 132, 255,   0,   0, 128, 255,   0,   0, 124, 255,   0,   0, 120, 255,   0,   0, 116, 255,   0,   0, 112, 255,   0,   0, 108, 255,   0,   0, 103, 255,   0,   0,  98, 255,   0,   0,  92, 255,   0,   0,  88, 255,   0,   0,  82, 255,   0,   0,  77, 255,   0,   0,  72, 255,   0,   0,  67, 255,   0,   0,  61, 255,   0,   0,  56, 255,   0,   0,  50, 255,   0,   0,  44, 255,   0,   0,  39, 255,   0,   0,  33, 255,   0,   0,  27, 255,   0,   0,  21, 255,   0,   0,  15, 255,   0,   0,   9, 255,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   6, 255,   0,   0,  12, 255,   0,   0,  18, 255,   0,   0,  24, 255,   0,   0,  30, 255,   0,   0,  35, 255,   0,   0,  40, 255,   0,   0,  47, 255,   0,   0,  52, 255,   0,   0,  58, 255,   0,   0,  63, 255,   0,   0,  68, 255,   0,   0,  74, 255,   0,   0,  78, 255,   0,   0,  83, 255,   0,   0,  89, 255,   0,   0,  93, 255,   0,   0,  98, 255,   0,   0, 103, 255,   0,   0, 106, 255,   0,   0, 111, 255,   0,   0, 115, 255,   0,   0, 119, 255,   0,   0, 123, 255,   0,   0, 126, 255,   0,   0, 129, 255,   0,   0, 132, 255,   0,   0, 135, 255,   0,   0, 137, 255,   0,   0, 139, 255,   0,   0, 141, 255,   0,   0, 142, 255,   0,   0, 143, 255,   0,   0, 144, 255,   0,   0, 144, 255,   0,   0, 143, 255,   0,   0, 143, 255,   0,   0, 142, 255,   0,   0, 141, 255,   0,   0, 139, 255,   0,   0, 137, 255,   0,   0, 135, 255,   0,   0, 133, 255,   0,   0, 130, 255,   0,   0, 126, 255,   0,   0, 122, 255,   0,   0, 119, 255,   0,   0, 115, 255,   0,   0, 111, 255,   0,   0, 107, 255,   0,   0, 103, 255,   0,   0,  98, 255,   0,   0,  93, 255,   0,   0,  88, 255,   0,   0,  83, 255,   0,   0,  79, 255,   0,   0,  73, 255,   0,   0,  68, 255,   0,   0,  62, 255,   0,   0,  57, 255,   0,   0,  52, 255,   0,   0,  46, 255,   0,   0,  41, 255,   0,   0,  35, 255,   0,   0,  30, 255,   0,   0,  23, 255,   0,   0,  18, 255,   0,   0,  12, 255,   0,   0,   7, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,  10, 255,   0,   0,  15, 255,   0,   0,  21, 255,   0,   0,  26, 255,   0,   0,  32, 255,   0,   0,  37, 255,   0,   0,  43, 255,   0,   0,  48, 255,   0,   0,  54, 255,   0,   0,  59, 255,   0,   0,  64, 255,   0,   0,  69, 255,   0,   0,  74, 255,   0,   0,  79, 255,   0,   0,  83, 255,   0,   0,  88, 255,   0,   0,  93, 255,   0,   0,  97, 255,   0,   0, 102, 255,   0,   0, 105, 255,   0,   0, 110, 255,   0,   0, 113, 255,   0,   0, 117, 255,   0,   0, 120, 255,   0,   0, 123, 255,   0,   0, 126, 255,   0,   0, 129, 255,   0,   0, 131, 255,   0,   0, 133, 255,   0,   0, 134, 255,   0,   0, 136, 255,   0,   0, 137, 255,   0,   0, 137, 255,   0,   0, 137, 255,   0,   0, 137, 255,   0,   0, 137, 255,   0,   0, 135, 255,   0,   0, 134, 255,   0,   0, 133, 255,   0,   0, 131, 255,   0,   0, 129, 255,   0,   0, 126, 255,   0,   0, 123, 255,   0,   0, 121, 255,   0,   0, 118, 255,   0,   0, 114, 255,   0,   0, 110, 255,   0,   0, 106, 255,   0,   0, 102, 255,   0,   0,  98, 255,   0,   0,  93, 255,   0,   0,  88, 255,   0,   0,  84, 255,   0,   0,  79, 255,   0,   0,  74, 255,   0,   0,  69, 255,   0,   0,  64, 255,   0,   0,  59, 255,   0,   0,  54, 255,   0,   0,  48, 255,   0,   0,  43, 255,   0,   0,  37, 255,   0,   0,  32, 255,   0,   0,  26, 255,   0,   0,  21, 255,   0,   0,  15, 255,   0,   0,  10, 255,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   6, 255,   0,   0,  11, 255,   0,   0,  17, 255,   0,   0,  22, 255,   0,   0,  28, 255,   0,   0,  34, 255,   0,   0,  39, 255,   0,   0,  45, 255,   0,   0,  49, 255,   0,   0,  55, 255,   0,   0,  60, 255,   0,   0,  65, 255,   0,   0,  70, 255,   0,   0,  75, 255,   0,   0,  79, 255,   0,   0,  84, 255,   0,   0,  89, 255,   0,   0,  93, 255,   0,   0,  97, 255,   0,   0, 101, 255,   0,   0, 104, 255,   0,   0, 108, 255,   0,   0, 111, 255,   0,   0, 115, 255,   0,   0, 118, 255,   0,   0, 121, 255,   0,   0, 123, 255,   0,   0, 124, 255,   0,   0, 126, 255,   0,   0, 128, 255,   0,   0, 129, 255,   0,   0, 130, 255,   0,   0, 130, 255,   0,   0, 131, 255,   0,   0, 131, 255,   0,   0, 130, 255,   0,   0, 130, 255,   0,   0, 128, 255,   0,   0, 127, 255,   0,   0, 124, 255,   0,   0, 123, 255,   0,   0, 120, 255,   0,   0, 118, 255,   0,   0, 115, 255,   0,   0, 112, 255,   0,   0, 108, 255,   0,   0, 104, 255,   0,   0, 101, 255,   0,   0,  96, 255,   0,   0,  92, 255,   0,   0,  88, 255,   0,   0,  84, 255,   0,   0,  79, 255,   0,   0,  75, 255,   0,   0,  70, 255,   0,   0,  65, 255,   0,   0,  60, 255,   0,   0,  55, 255,   0,   0,  50, 255,   0,   0,  44, 255,   0,   0,  39, 255,   0,   0,  34, 255,   0,   0,  28, 255,   0,   0,  22, 255,   0,   0,  17, 255,   0,   0,  11, 255,   0,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   9, 255,   0,   0,  14, 255,   0,   0,  20, 255,   0,   0,  24, 255,   0,   0,  30, 255,   0,   0,  35, 255,   0,   0,  40, 255,   0,   0,  46, 255,   0,   0,  51, 255,   0,   0,  56, 255,   0,   0,  60, 255,   0,   0,  66, 255,   0,   0,  70, 255,   0,   0,  75, 255,   0,   0,  79, 255,   0,   0,  83, 255,   0,   0,  87, 255,   0,   0,  91, 255,   0,   0,  95, 255,   0,   0,  99, 255,   0,   0, 102, 255,   0,   0, 106, 255,   0,   0, 109, 255,   0,   0, 111, 255,   0,   0, 114, 255,   0,   0, 117, 255,   0,   0, 118, 255,   0,   0, 120, 255,   0,   0, 121, 255,   0,   0, 122, 255,   0,   0, 123, 255,   0,   0, 124, 255,   0,   0, 125, 255,   0,   0, 124, 255,   0,   0, 124, 255,   0,   0, 123, 255,   0,   0, 122, 255,   0,   0, 121, 255,   0,   0, 118, 255,   0,   0, 117, 255,   0,   0, 114, 255,   0,   0, 112, 255,   0,   0, 109, 255,   0,   0, 106, 255,   0,   0, 102, 255,   0,   0,  99, 255,   0,   0,  96, 255,   0,   0,  92, 255,   0,   0,  88, 255,   0,   0,  83, 255,   0,   0,  79, 255,   0,   0,  75, 255,   0,   0,  70, 255,   0,   0,  66, 255,   0,   0,  61, 255,   0,   0,  56, 255,   0,   0,  50, 255,   0,   0,  45, 255,   0,   0,  41, 255,   0,   0,  35, 255,   0,   0,  30, 255,   0,   0,  24, 255,   0,   0,  19, 255,   0,   0,  13, 255,   0,   0,   8, 255,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   5, 255,   0,   0,  10, 255,   0,   0,  16, 255,   0,   0,  21, 255,   0,   0,  26, 255,   0,   0,  32, 255,   0,   0,  36, 255,   0,   0,  42, 255,   0,   0,  47, 255,   0,   0,  51, 255,   0,   0,  56, 255,   0,   0,  61, 255,   0,   0,  65, 255,   0,   0,  70, 255,   0,   0,  74, 255,   0,   0,  79, 255,   0,   0,  82, 255,   0,   0,  86, 255,   0,   0,  90, 255,   0,   0,  94, 255,   0,   0,  97, 255,   0,   0, 100, 255,   0,   0, 103, 255,   0,   0, 106, 255,   0,   0, 108, 255,   0,   0, 110, 255,   0,   0, 112, 255,   0,   0, 114, 255,   0,   0, 115, 255,   0,   0, 116, 255,   0,   0, 117, 255,   0,   0, 117, 255,   0,   0, 117, 255,   0,   0, 117, 255,   0,   0, 117, 255,   0,   0, 116, 255,   0,   0, 116, 255,   0,   0, 114, 255,   0,   0, 112, 255,   0,   0, 110, 255,   0,   0, 108, 255,   0,   0, 106, 255,   0,   0, 103, 255,   0,   0, 100, 255,   0,   0,  97, 255,   0,   0,  94, 255,   0,   0,  90, 255,   0,   0,  86, 255,   0,   0,  82, 255,   0,   0,  79, 255,   0,   0,  74, 255,   0,   0,  70, 255,   0,   0,  65, 255,   0,   0,  60, 255,   0,   0,  56, 255,   0,   0,  52, 255,   0,   0,  47, 255,   0,   0,  42, 255,   0,   0,  37, 255,   0,   0,  31, 255,   0,   0,  26, 255,   0,   0,  21, 255,   0,   0,  15, 255,   0,   0,  10, 255,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   6, 255,   0,   0,  12, 255,   0,   0,  17, 255,   0,   0,  22, 255,   0,   0,  27, 255,   0,   0,  32, 255,   0,   0,  37, 255,   0,   0,  43, 255,   0,   0,  46, 255,   0,   0,  52, 255,   0,   0,  56, 255,   0,   0,  61, 255,   0,   0,  65, 255,   0,   0,  69, 255,   0,   0,  73, 255,   0,   0,  77, 255,   0,   0,  81, 255,   0,   0,  85, 255,   0,   0,  88, 255,   0,   0,  91, 255,   0,   0,  95, 255,   0,   0,  97, 255,   0,   0, 100, 255,   0,   0, 101, 255,   0,   0, 104, 255,   0,   0, 106, 255,   0,   0, 107, 255,   0,   0, 109, 255,   0,   0, 110, 255,   0,   0, 110, 255,   0,   0, 111, 255,   0,   0, 111, 255,   0,   0, 111, 255,   0,   0, 110, 255,   0,   0, 110, 255,   0,   0, 109, 255,   0,   0, 107, 255,   0,   0, 106, 255,   0,   0, 104, 255,   0,   0, 102, 255,   0,   0, 100, 255,   0,   0,  97, 255,   0,   0,  94, 255,   0,   0,  91, 255,   0,   0,  88, 255,   0,   0,  84, 255,   0,   0,  80, 255,   0,   0,  77, 255,   0,   0,  73, 255,   0,   0,  69, 255,   0,   0,  65, 255,   0,   0,  61, 255,   0,   0,  56, 255,   0,   0,  52, 255,   0,   0,  47, 255,   0,   0,  42, 255,   0,   0,  38, 255,   0,   0,  33, 255,   0,   0,  27, 255,   0,   0,  23, 255,   0,   0,  17, 255,   0,   0,  11, 255,   0,   0,   7, 255,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   2, 255,   0,   0,   8, 255,   0,   0,  13, 255,   0,   0,  18, 255,   0,   0,  23, 255,   0,   0,  28, 255,   0,   0,  33, 255,   0,   0,  38, 255,   0,   0,  42, 255,   0,   0,  47, 255,   0,   0,  52, 255,   0,   0,  56, 255,   0,   0,  60, 255,   0,   0,  64, 255,   0,   0,  68, 255,   0,   0,  72, 255,   0,   0,  76, 255,   0,   0,  79, 255,   0,   0,  82, 255,   0,   0,  86, 255,   0,   0,  88, 255,   0,   0,  91, 255,   0,   0,  94, 255,   0,   0,  95, 255,   0,   0,  98, 255,   0,   0,  99, 255,   0,   0, 101, 255,   0,   0, 102, 255,   0,   0, 103, 255,   0,   0, 104, 255,   0,   0, 104, 255,   0,   0, 105, 255,   0,   0, 104, 255,   0,   0, 104, 255,   0,   0, 104, 255,   0,   0, 102, 255,   0,   0, 101, 255,   0,   0,  99, 255,   0,   0,  98, 255,   0,   0,  96, 255,   0,   0,  93, 255,   0,   0,  91, 255,   0,   0,  89, 255,   0,   0,  86, 255,   0,   0,  83, 255,   0,   0,  79, 255,   0,   0,  75, 255,   0,   0,  71, 255,   0,   0,  68, 255,   0,   0,  64, 255,   0,   0,  60, 255,   0,   0,  56, 255,   0,   0,  52, 255,   0,   0,  47, 255,   0,   0,  42, 255,   0,   0,  38, 255,   0,   0,  33, 255,   0,   0,  28, 255,   0,   0,  23, 255,   0,   0,  18, 255,   0,   0,  13, 255,   0,   0,   8, 255,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   4, 255,   0,   0,   9, 255,   0,   0,  14, 255,   0,   0,  19, 255,   0,   0,  24, 255,   0,   0,  28, 255,   0,   0,  33, 255,   0,   0,  38, 255,   0,   0,  42, 255,   0,   0,  46, 255,   0,   0,  51, 255,   0,   0,  55, 255,   0,   0,  58, 255,   0,   0,  63, 255,   0,   0,  66, 255,   0,   0,  70, 255,   0,   0,  73, 255,   0,   0,  77, 255,   0,   0,  80, 255,   0,   0,  83, 255,   0,   0,  85, 255,   0,   0,  87, 255,   0,   0,  90, 255,   0,   0,  91, 255,   0,   0,  93, 255,   0,   0,  95, 255,   0,   0,  96, 255,   0,   0,  97, 255,   0,   0,  97, 255,   0,   0,  98, 255,   0,   0,  99, 255,   0,   0,  98, 255,   0,   0,  97, 255,   0,   0,  96, 255,   0,   0,  96, 255,   0,   0,  94, 255,   0,   0,  93, 255,   0,   0,  91, 255,   0,   0,  90, 255,   0,   0,  87, 255,   0,   0,  85, 255,   0,   0,  82, 255,   0,   0,  79, 255,   0,   0,  77, 255,   0,   0,  73, 255,   0,   0,  70, 255,   0,   0,  67, 255,   0,   0,  62, 255,   0,   0,  59, 255,   0,   0,  55, 255,   0,   0,  50, 255,   0,   0,  46, 255,   0,   0,  42, 255,   0,   0,  37, 255,   0,   0,  33, 255,   0,   0,  29, 255,   0,   0,  23, 255,   0,   0,  19, 255,   0,   0,  14, 255,   0,   0,   9, 255,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   5, 255,   0,   0,  10, 255,   0,   0,  14, 255,   0,   0,  20, 255,   0,   0,  24, 255,   0,   0,  29, 255,   0,   0,  33, 255,   0,   0,  38, 255,   0,   0,  42, 255,   0,   0,  46, 255,   0,   0,  50, 255,   0,   0,  53, 255,   0,   0,  57, 255,   0,   0,  61, 255,   0,   0,  65, 255,   0,   0,  68, 255,   0,   0,  71, 255,   0,   0,  73, 255,   0,   0,  76, 255,   0,   0,  79, 255,   0,   0,  82, 255,   0,   0,  84, 255,   0,   0,  85, 255,   0,   0,  87, 255,   0,   0,  88, 255,   0,   0,  90, 255,   0,   0,  91, 255,   0,   0,  91, 255,   0,   0,  91, 255,   0,   0,  91, 255,   0,   0,  92, 255,   0,   0,  91, 255,   0,   0,  90, 255,   0,   0,  89, 255,   0,   0,  88, 255,   0,   0,  87, 255,   0,   0,  86, 255,   0,   0,  83, 255,   0,   0,  81, 255,   0,   0,  79, 255,   0,   0,  76, 255,   0,   0,  74, 255,   0,   0,  71, 255,   0,   0,  67, 255,   0,   0,  64, 255,   0,   0,  61, 255,   0,   0,  57, 255,   0,   0,  54, 255,   0,   0,  50, 255,   0,   0,  46, 255,   0,   0,  42, 255,   0,   0,  37, 255,   0,   0,  33, 255,   0,   0,  28, 255,   0,   0,  24, 255,   0,   0,  19, 255,   0,   0,  14, 255,   0,   0,  10, 255,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   5, 255,   0,   0,  10, 255,   0,   0,  14, 255,   0,   0,  19, 255,   0,   0,  24, 255,   0,   0,  28, 255,   0,   0,  32, 255,   0,   0,  36, 255,   0,   0,  41, 255,   0,   0,  44, 255,   0,   0,  48, 255,   0,   0,  52, 255,   0,   0,  55, 255,   0,   0,  59, 255,   0,   0,  62, 255,   0,   0,  65, 255,   0,   0,  68, 255,   0,   0,  70, 255,   0,   0,  73, 255,   0,   0,  75, 255,   0,   0,  77, 255,   0,   0,  79, 255,   0,   0,  80, 255,   0,   0,  82, 255,   0,   0,  83, 255,   0,   0,  84, 255,   0,   0,  85, 255,   0,   0,  85, 255,   0,   0,  85, 255,   0,   0,  85, 255,   0,   0,  84, 255,   0,   0,  84, 255,   0,   0,  83, 255,   0,   0,  82, 255,   0,   0,  80, 255,   0,   0,  79, 255,   0,   0,  77, 255,   0,   0,  75, 255,   0,   0,  73, 255,   0,   0,  70, 255,   0,   0,  67, 255,   0,   0,  64, 255,   0,   0,  62, 255,   0,   0,  59, 255,   0,   0,  55, 255,   0,   0,  52, 255,   0,   0,  48, 255,   0,   0,  44, 255,   0,   0,  40, 255,   0,   0,  36, 255,   0,   0,  32, 255,   0,   0,  28, 255,   0,   0,  23, 255,   0,   0,  19, 255,   0,   0,  15, 255,   0,   0,  10, 255,   0,   0,   5, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   5, 255,   0,   0,  10, 255,   0,   0,  14, 255,   0,   0,  19, 255,   0,   0,  23, 255,   0,   0,  28, 255,   0,   0,  31, 255,   0,   0,  36, 255,   0,   0,  39, 255,   0,   0,  43, 255,   0,   0,  47, 255,   0,   0,  50, 255,   0,   0,  53, 255,   0,   0,  56, 255,   0,   0,  59, 255,   0,   0,  62, 255,   0,   0,  65, 255,   0,   0,  66, 255,   0,   0,  69, 255,   0,   0,  71, 255,   0,   0,  72, 255,   0,   0,  74, 255,   0,   0,  75, 255,   0,   0,  77, 255,   0,   0,  77, 255,   0,   0,  78, 255,   0,   0,  78, 255,   0,   0,  78, 255,   0,   0,  78, 255,   0,   0,  78, 255,   0,   0,  78, 255,   0,   0,  76, 255,   0,   0,  76, 255,   0,   0,  74, 255,   0,   0,  72, 255,   0,   0,  70, 255,   0,   0,  69, 255,   0,   0,  67, 255,   0,   0,  64, 255,   0,   0,  62, 255,   0,   0,  59, 255,   0,   0,  56, 255,   0,   0,  53, 255,   0,   0,  50, 255,   0,   0,  47, 255,   0,   0,  42, 255,   0,   0,  39, 255,   0,   0,  35, 255,   0,   0,  32, 255,   0,   0,  27, 255,   0,   0,  23, 255,   0,   0,  18, 255,   0,   0,  14, 255,   0,   0,  10, 255,   0,   0,   5, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   5, 255,   0,   0,  10, 255,   0,   0,  14, 255,   0,   0,  18, 255,   0,   0,  22, 255,   0,   0,  26, 255,   0,   0,  30, 255,   0,   0,  34, 255,   0,   0,  38, 255,   0,   0,  41, 255,   0,   0,  44, 255,   0,   0,  47, 255,   0,   0,  50, 255,   0,   0,  53, 255,   0,   0,  56, 255,   0,   0,  58, 255,   0,   0,  61, 255,   0,   0,  63, 255,   0,   0,  65, 255,   0,   0,  66, 255,   0,   0,  68, 255,   0,   0,  69, 255,   0,   0,  70, 255,   0,   0,  70, 255,   0,   0,  72, 255,   0,   0,  72, 255,   0,   0,  72, 255,   0,   0,  72, 255,   0,   0,  71, 255,   0,   0,  71, 255,   0,   0,  70, 255,   0,   0,  69, 255,   0,   0,  68, 255,   0,   0,  66, 255,   0,   0,  64, 255,   0,   0,  62, 255,   0,   0,  61, 255,   0,   0,  58, 255,   0,   0,  56, 255,   0,   0,  53, 255,   0,   0,  51, 255,   0,   0,  48, 255,   0,   0,  44, 255,   0,   0,  41, 255,   0,   0,  38, 255,   0,   0,  34, 255,   0,   0,  30, 255,   0,   0,  26, 255,   0,   0,  22, 255,   0,   0,  18, 255,   0,   0,  14, 255,   0,   0,  10, 255,   0,   0,   6, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   5, 255,   0,   0,   9, 255,   0,   0,  13, 255,   0,   0,  17, 255,   0,   0,  21, 255,   0,   0,  25, 255,   0,   0,  28, 255,   0,   0,  32, 255,   0,   0,  35, 255,   0,   0,  39, 255,   0,   0,  42, 255,   0,   0,  44, 255,   0,   0,  47, 255,   0,   0,  50, 255,   0,   0,  53, 255,   0,   0,  54, 255,   0,   0,  56, 255,   0,   0,  59, 255,   0,   0,  60, 255,   0,   0,  61, 255,   0,   0,  62, 255,   0,   0,  63, 255,   0,   0,  64, 255,   0,   0,  65, 255,   0,   0,  66, 255,   0,   0,  66, 255,   0,   0,  66, 255,   0,   0,  65, 255,   0,   0,  64, 255,   0,   0,  64, 255,   0,   0,  63, 255,   0,   0,  61, 255,   0,   0,  60, 255,   0,   0,  58, 255,   0,   0,  56, 255,   0,   0,  54, 255,   0,   0,  53, 255,   0,   0,  50, 255,   0,   0,  47, 255,   0,   0,  45, 255,   0,   0,  42, 255,   0,   0,  39, 255,   0,   0,  35, 255,   0,   0,  32, 255,   0,   0,  28, 255,   0,   0,  24, 255,   0,   0,  21, 255,   0,   0,  17, 255,   0,   0,  13, 255,   0,   0,   9, 255,   0,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   4, 255,   0,   0,   8, 255,   0,   0,  12, 255,   0,   0,  15, 255,   0,   0,  20, 255,   0,   0,  23, 255,   0,   0,  27, 255,   0,   0,  30, 255,   0,   0,  33, 255,   0,   0,  36, 255,   0,   0,  38, 255,   0,   0,  42, 255,   0,   0,  44, 255,   0,   0,  46, 255,   0,   0,  48, 255,   0,   0,  50, 255,   0,   0,  52, 255,   0,   0,  54, 255,   0,   0,  55, 255,   0,   0,  56, 255,   0,   0,  58, 255,   0,   0,  58, 255,   0,   0,  59, 255,   0,   0,  59, 255,   0,   0,  59, 255,   0,   0,  58, 255,   0,   0,  59, 255,   0,   0,  58, 255,   0,   0,  57, 255,   0,   0,  56, 255,   0,   0,  55, 255,   0,   0,  53, 255,   0,   0,  52, 255,   0,   0,  50, 255,   0,   0,  49, 255,   0,   0,  46, 255,   0,   0,  44, 255,   0,   0,  41, 255,   0,   0,  38, 255,   0,   0,  36, 255,   0,   0,  33, 255,   0,   0,  29, 255,   0,   0,  26, 255,   0,   0,  23, 255,   0,   0,  19, 255,   0,   0,  15, 255,   0,   0,  11, 255,   0,   0,   7, 255,   0,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   7, 255,   0,   0,  11, 255,   0,   0,  14, 255,   0,   0,  18, 255,   0,   0,  21, 255,   0,   0,  24, 255,   0,   0,  27, 255,   0,   0,  30, 255,   0,   0,  32, 255,   0,   0,  35, 255,   0,   0,  38, 255,   0,   0,  40, 255,   0,   0,  42, 255,   0,   0,  44, 255,   0,   0,  45, 255,   0,   0,  47, 255,   0,   0,  49, 255,   0,   0,  49, 255,   0,   0,  50, 255,   0,   0,  51, 255,   0,   0,  52, 255,   0,   0,  52, 255,   0,   0,  52, 255,   0,   0,  52, 255,   0,   0,  52, 255,   0,   0,  51, 255,   0,   0,  50, 255,   0,   0,  49, 255,   0,   0,  49, 255,   0,   0,  47, 255,   0,   0,  46, 255,   0,   0,  44, 255,   0,   0,  43, 255,   0,   0,  40, 255,   0,   0,  38, 255,   0,   0,  35, 255,   0,   0,  32, 255,   0,   0,  30, 255,   0,   0,  27, 255,   0,   0,  24, 255,   0,   0,  21, 255,   0,   0,  18, 255,   0,   0,  14, 255,   0,   0,  11, 255,   0,   0,   7, 255,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   5, 255,   0,   0,   8, 255,   0,   0,  12, 255,   0,   0,  15, 255,   0,   0,  18, 255,   0,   0,  21, 255,   0,   0,  24, 255,   0,   0,  27, 255,   0,   0,  29, 255,   0,   0,  32, 255,   0,   0,  34, 255,   0,   0,  35, 255,   0,   0,  38, 255,   0,   0,  39, 255,   0,   0,  41, 255,   0,   0,  42, 255,   0,   0,  43, 255,   0,   0,  44, 255,   0,   0,  44, 255,   0,   0,  46, 255,   0,   0,  45, 255,   0,   0,  45, 255,   0,   0,  46, 255,   0,   0,  46, 255,   0,   0,  44, 255,   0,   0,  44, 255,   0,   0,  43, 255,   0,   0,  42, 255,   0,   0,  41, 255,   0,   0,  39, 255,   0,   0,  38, 255,   0,   0,  36, 255,   0,   0,  34, 255,   0,   0,  31, 255,   0,   0,  30, 255,   0,   0,  26, 255,   0,   0,  24, 255,   0,   0,  22, 255,   0,   0,  18, 255,   0,   0,  15, 255,   0,   0,  12, 255,   0,   0,   8, 255,   0,   0,   4, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   2, 255,   0,   0,   6, 255,   0,   0,  10, 255,   0,   0,  12, 255,   0,   0,  15, 255,   0,   0,  18, 255,   0,   0,  21, 255,   0,   0,  24, 255,   0,   0,  26, 255,   0,   0,  27, 255,   0,   0,  29, 255,   0,   0,  31, 255,   0,   0,  33, 255,   0,   0,  34, 255,   0,   0,  36, 255,   0,   0,  37, 255,   0,   0,  37, 255,   0,   0,  38, 255,   0,   0,  39, 255,   0,   0,  39, 255,   0,   0,  40, 255,   0,   0,  39, 255,   0,   0,  39, 255,   0,   0,  38, 255,   0,   0,  38, 255,   0,   0,  37, 255,   0,   0,  36, 255,   0,   0,  35, 255,   0,   0,  33, 255,   0,   0,  31, 255,   0,   0,  29, 255,   0,   0,  27, 255,   0,   0,  25, 255,   0,   0,  23, 255,   0,   0,  21, 255,   0,   0,  18, 255,   0,   0,  15, 255,   0,   0,  13, 255,   0,   0,  10, 255,   0,   0,   6, 255,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   3, 255,   0,   0,   6, 255,   0,   0,   9, 255,   0,   0,  12, 255,   0,   0,  14, 255,   0,   0,  17, 255,   0,   0,  19, 255,   0,   0,  21, 255,   0,   0,  23, 255,   0,   0,  25, 255,   0,   0,  26, 255,   0,   0,  28, 255,   0,   0,  30, 255,   0,   0,  30, 255,   0,   0,  31, 255,   0,   0,  32, 255,   0,   0,  32, 255,   0,   0,  32, 255,   0,   0,  32, 255,   0,   0,  32, 255,   0,   0,  32, 255,   0,   0,  31, 255,   0,   0,  31, 255,   0,   0,  30, 255,   0,   0,  29, 255,   0,   0,  28, 255,   0,   0,  27, 255,   0,   0,  25, 255,   0,   0,  23, 255,   0,   0,  21, 255,   0,   0,  19, 255,   0,   0,  17, 255,   0,   0,  15, 255,   0,   0,  12, 255,   0,   0,  10, 255,   0,   0,   7, 255,   0,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   4, 255,   0,   0,   6, 255,   0,   0,   9, 255,   0,   0,  11, 255,   0,   0,  13, 255,   0,   0,  15, 255,   0,   0,  17, 255,   0,   0,  19, 255,   0,   0,  21, 255,   0,   0,  22, 255,   0,   0,  23, 255,   0,   0,  24, 255,   0,   0,  25, 255,   0,   0,  26, 255,   0,   0,  26, 255,   0,   0,  26, 255,   0,   0,  27, 255,   0,   0,  26, 255,   0,   0,  26, 255,   0,   0,  26, 255,   0,   0,  24, 255,   0,   0,  24, 255,   0,   0,  23, 255,   0,   0,  22, 255,   0,   0,  20, 255,   0,   0,  19, 255,   0,   0,  17, 255,   0,   0,  15, 255,   0,   0,  13, 255,   0,   0,  10, 255,   0,   0,   9, 255,   0,   0,   6, 255,   0,   0,   3, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   2, 255,   0,   0,   5, 255,   0,   0,   7, 255,   0,   0,   9, 255,   0,   0,  11, 255,   0,   0,  12, 255,   0,   0,  14, 255,   0,   0,  15, 255,   0,   0,  17, 255,   0,   0,  18, 255,   0,   0,  18, 255,   0,   0,  19, 255,   0,   0,  19, 255,   0,   0,  20, 255,   0,   0,  20, 255,   0,   0,  19, 255,   0,   0,  19, 255,   0,   0,  18, 255,   0,   0,  18, 255,   0,   0,  17, 255,   0,   0,  16, 255,   0,   0,  15, 255,   0,   0,  13, 255,   0,   0,  12, 255,   0,   0,  10, 255,   0,   0,   9, 255,   0,   0,   7, 255,   0,   0,   5, 255,   0,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   3, 255,   0,   0,   4, 255,   0,   0,   6, 255,   0,   0,   7, 255,   0,   0,   9, 255,   0,   0,  10, 255,   0,   0,  11, 255,   0,   0,  11, 255,   0,   0,  12, 255,   0,   0,  12, 255,   0,   0,  13, 255,   0,   0,  13, 255,   0,   0,  13, 255,   0,   0,  13, 255,   0,   0,  12, 255,   0,   0,  12, 255,   0,   0,  11, 255,   0,   0,  10, 255,   0,   0,   9, 255,   0,   0,   8, 255,   0,   0,   6, 255,   0,   0,   4, 255,   0,   0,   3, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   0,   1, 255,   0,   0,   3, 255,   0,   0,   3, 255,   0,   0,   4, 255,   0,   0,   6, 255,   0,   0,   6, 255,   0,   0,   6, 255,   0,   0,   7, 255,   0,   0,   6, 255,   0,   0,   6, 255,   0,   0,   6, 255,   0,   0,   6, 255,   0,   0,   6, 255,   0,   0,   4, 255,   0,   0,   3, 255,   0,   0,   2, 255,   0,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	};

	static const int GREEN_ICON_GLOW_SIZE_W = 80;
	static const int GREEN_ICON_GLOW_SIZE_H = 80;
	static const unsigned char GREEN_ICON_GLOW_DATA[25600] =
	{
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   2,   0, 255,   0,   3,   0, 255,   0,   4,   0, 255,   0,   5,   0, 255,   0,   5,   0, 255,   0,   6,   0, 255,   0,   6,   0, 255,   0,   7,   0, 255,   0,   6,   0, 255,   0,   6,   0, 255,   0,   5,   0, 255,   0,   5,   0, 255,   0,   4,   0, 255,   0,   4,   0, 255,   0,   2,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   3,   0, 255,   0,   4,   0, 255,   0,   6,   0, 255,   0,   7,   0, 255,   0,   8,   0, 255,   0,  10,   0, 255,   0,  11,   0, 255,   0,  12,   0, 255,   0,  13,   0, 255,   0,  13,   0, 255,   0,  13,   0, 255,   0,  13,   0, 255,   0,  13,   0, 255,   0,  13,   0, 255,   0,  13,   0, 255,   0,  12,   0, 255,   0,  11,   0, 255,   0,  10,   0, 255,   0,   9,   0, 255,   0,   7,   0, 255,   0,   6,   0, 255,   0,   4,   0, 255,   0,   2,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   2,   0, 255,   0,   4,   0, 255,   0,   7,   0, 255,   0,   9,   0, 255,   0,  11,   0, 255,   0,  12,   0, 255,   0,  14,   0, 255,   0,  15,   0, 255,   0,  16,   0, 255,   0,  17,   0, 255,   0,  18,   0, 255,   0,  19,   0, 255,   0,  19,   0, 255,   0,  20,   0, 255,   0,  19,   0, 255,   0,  20,   0, 255,   0,  19,   0, 255,   0,  19,   0, 255,   0,  18,   0, 255,   0,  17,   0, 255,   0,  16,   0, 255,   0,  15,   0, 255,   0,  14,   0, 255,   0,  12,   0, 255,   0,  11,   0, 255,   0,   9,   0, 255,   0,   7,   0, 255,   0,   4,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   3,   0, 255,   0,   6,   0, 255,   0,   9,   0, 255,   0,  11,   0, 255,   0,  13,   0, 255,   0,  16,   0, 255,   0,  17,   0, 255,   0,  18,   0, 255,   0,  20,   0, 255,   0,  21,   0, 255,   0,  23,   0, 255,   0,  24,   0, 255,   0,  25,   0, 255,   0,  26,   0, 255,   0,  26,   0, 255,   0,  26,   0, 255,   0,  26,   0, 255,   0,  26,   0, 255,   0,  26,   0, 255,   0,  25,   0, 255,   0,  25,   0, 255,   0,  24,   0, 255,   0,  23,   0, 255,   0,  22,   0, 255,   0,  20,   0, 255,   0,  19,   0, 255,   0,  17,   0, 255,   0,  15,   0, 255,   0,  13,   0, 255,   0,  11,   0, 255,   0,   8,   0, 255,   0,   6,   0, 255,   0,   4,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   4,   0, 255,   0,   7,   0, 255,   0,  10,   0, 255,   0,  12,   0, 255,   0,  15,   0, 255,   0,  17,   0, 255,   0,  20,   0, 255,   0,  21,   0, 255,   0,  23,   0, 255,   0,  25,   0, 255,   0,  27,   0, 255,   0,  28,   0, 255,   0,  29,   0, 255,   0,  30,   0, 255,   0,  32,   0, 255,   0,  32,   0, 255,   0,  32,   0, 255,   0,  33,   0, 255,   0,  33,   0, 255,   0,  33,   0, 255,   0,  32,   0, 255,   0,  31,   0, 255,   0,  31,   0, 255,   0,  30,   0, 255,   0,  29,   0, 255,   0,  28,   0, 255,   0,  27,   0, 255,   0,  25,   0, 255,   0,  23,   0, 255,   0,  21,   0, 255,   0,  19,   0, 255,   0,  17,   0, 255,   0,  15,   0, 255,   0,  12,   0, 255,   0,  10,   0, 255,   0,   6,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   6,   0, 255,   0,   9,   0, 255,   0,  12,   0, 255,   0,  15,   0, 255,   0,  18,   0, 255,   0,  20,   0, 255,   0,  23,   0, 255,   0,  25,   0, 255,   0,  28,   0, 255,   0,  30,   0, 255,   0,  32,   0, 255,   0,  33,   0, 255,   0,  35,   0, 255,   0,  35,   0, 255,   0,  37,   0, 255,   0,  38,   0, 255,   0,  38,   0, 255,   0,  39,   0, 255,   0,  39,   0, 255,   0,  40,   0, 255,   0,  39,   0, 255,   0,  39,   0, 255,   0,  38,   0, 255,   0,  38,   0, 255,   0,  37,   0, 255,   0,  36,   0, 255,   0,  34,   0, 255,   0,  33,   0, 255,   0,  31,   0, 255,   0,  30,   0, 255,   0,  28,   0, 255,   0,  25,   0, 255,   0,  23,   0, 255,   0,  21,   0, 255,   0,  18,   0, 255,   0,  15,   0, 255,   0,  12,   0, 255,   0,   9,   0, 255,   0,   6,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   5,   0, 255,   0,   8,   0, 255,   0,  12,   0, 255,   0,  15,   0, 255,   0,  18,   0, 255,   0,  21,   0, 255,   0,  24,   0, 255,   0,  27,   0, 255,   0,  29,   0, 255,   0,  31,   0, 255,   0,  34,   0, 255,   0,  36,   0, 255,   0,  38,   0, 255,   0,  40,   0, 255,   0,  41,   0, 255,   0,  42,   0, 255,   0,  43,   0, 255,   0,  44,   0, 255,   0,  45,   0, 255,   0,  46,   0, 255,   0,  46,   0, 255,   0,  46,   0, 255,   0,  45,   0, 255,   0,  46,   0, 255,   0,  45,   0, 255,   0,  45,   0, 255,   0,  44,   0, 255,   0,  43,   0, 255,   0,  41,   0, 255,   0,  40,   0, 255,   0,  37,   0, 255,   0,  36,   0, 255,   0,  34,   0, 255,   0,  31,   0, 255,   0,  29,   0, 255,   0,  27,   0, 255,   0,  24,   0, 255,   0,  21,   0, 255,   0,  18,   0, 255,   0,  15,   0, 255,   0,  11,   0, 255,   0,   8,   0, 255,   0,   5,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   7,   0, 255,   0,  10,   0, 255,   0,  13,   0, 255,   0,  17,   0, 255,   0,  21,   0, 255,   0,  23,   0, 255,   0,  27,   0, 255,   0,  30,   0, 255,   0,  33,   0, 255,   0,  35,   0, 255,   0,  38,   0, 255,   0,  40,   0, 255,   0,  42,   0, 255,   0,  44,   0, 255,   0,  46,   0, 255,   0,  48,   0, 255,   0,  49,   0, 255,   0,  50,   0, 255,   0,  51,   0, 255,   0,  51,   0, 255,   0,  52,   0, 255,   0,  52,   0, 255,   0,  52,   0, 255,   0,  53,   0, 255,   0,  52,   0, 255,   0,  52,   0, 255,   0,  51,   0, 255,   0,  50,   0, 255,   0,  49,   0, 255,   0,  47,   0, 255,   0,  46,   0, 255,   0,  44,   0, 255,   0,  42,   0, 255,   0,  40,   0, 255,   0,  37,   0, 255,   0,  35,   0, 255,   0,  32,   0, 255,   0,  30,   0, 255,   0,  27,   0, 255,   0,  24,   0, 255,   0,  21,   0, 255,   0,  18,   0, 255,   0,  14,   0, 255,   0,  10,   0, 255,   0,   7,   0, 255,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   8,   0, 255,   0,  12,   0, 255,   0,  16,   0, 255,   0,  19,   0, 255,   0,  22,   0, 255,   0,  27,   0, 255,   0,  29,   0, 255,   0,  32,   0, 255,   0,  36,   0, 255,   0,  38,   0, 255,   0,  41,   0, 255,   0,  44,   0, 255,   0,  46,   0, 255,   0,  48,   0, 255,   0,  50,   0, 255,   0,  52,   0, 255,   0,  54,   0, 255,   0,  55,   0, 255,   0,  57,   0, 255,   0,  57,   0, 255,   0,  58,   0, 255,   0,  58,   0, 255,   0,  59,   0, 255,   0,  59,   0, 255,   0,  59,   0, 255,   0,  58,   0, 255,   0,  57,   0, 255,   0,  57,   0, 255,   0,  56,   0, 255,   0,  55,   0, 255,   0,  54,   0, 255,   0,  52,   0, 255,   0,  51,   0, 255,   0,  48,   0, 255,   0,  46,   0, 255,   0,  44,   0, 255,   0,  41,   0, 255,   0,  39,   0, 255,   0,  36,   0, 255,   0,  32,   0, 255,   0,  29,   0, 255,   0,  26,   0, 255,   0,  23,   0, 255,   0,  20,   0, 255,   0,  16,   0, 255,   0,  11,   0, 255,   0,   8,   0, 255,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   5,   0, 255,   0,   9,   0, 255,   0,  13,   0, 255,   0,  17,   0, 255,   0,  20,   0, 255,   0,  24,   0, 255,   0,  29,   0, 255,   0,  32,   0, 255,   0,  36,   0, 255,   0,  39,   0, 255,   0,  42,   0, 255,   0,  45,   0, 255,   0,  47,   0, 255,   0,  50,   0, 255,   0,  53,   0, 255,   0,  54,   0, 255,   0,  57,   0, 255,   0,  58,   0, 255,   0,  60,   0, 255,   0,  61,   0, 255,   0,  62,   0, 255,   0,  64,   0, 255,   0,  65,   0, 255,   0,  65,   0, 255,   0,  65,   0, 255,   0,  66,   0, 255,   0,  65,   0, 255,   0,  65,   0, 255,   0,  65,   0, 255,   0,  64,   0, 255,   0,  62,   0, 255,   0,  62,   0, 255,   0,  60,   0, 255,   0,  58,   0, 255,   0,  56,   0, 255,   0,  54,   0, 255,   0,  53,   0, 255,   0,  49,   0, 255,   0,  47,   0, 255,   0,  45,   0, 255,   0,  42,   0, 255,   0,  38,   0, 255,   0,  35,   0, 255,   0,  32,   0, 255,   0,  28,   0, 255,   0,  24,   0, 255,   0,  21,   0, 255,   0,  17,   0, 255,   0,  13,   0, 255,   0,   9,   0, 255,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   5,   0, 255,   0,  10,   0, 255,   0,  14,   0, 255,   0,  18,   0, 255,   0,  22,   0, 255,   0,  27,   0, 255,   0,  30,   0, 255,   0,  33,   0, 255,   0,  37,   0, 255,   0,  41,   0, 255,   0,  44,   0, 255,   0,  47,   0, 255,   0,  51,   0, 255,   0,  53,   0, 255,   0,  56,   0, 255,   0,  58,   0, 255,   0,  61,   0, 255,   0,  63,   0, 255,   0,  65,   0, 255,   0,  66,   0, 255,   0,  68,   0, 255,   0,  69,   0, 255,   0,  70,   0, 255,   0,  71,   0, 255,   0,  72,   0, 255,   0,  72,   0, 255,   0,  72,   0, 255,   0,  72,   0, 255,   0,  72,   0, 255,   0,  71,   0, 255,   0,  70,   0, 255,   0,  69,   0, 255,   0,  68,   0, 255,   0,  66,   0, 255,   0,  64,   0, 255,   0,  63,   0, 255,   0,  61,   0, 255,   0,  58,   0, 255,   0,  56,   0, 255,   0,  53,   0, 255,   0,  50,   0, 255,   0,  47,   0, 255,   0,  44,   0, 255,   0,  40,   0, 255,   0,  37,   0, 255,   0,  34,   0, 255,   0,  30,   0, 255,   0,  26,   0, 255,   0,  22,   0, 255,   0,  18,   0, 255,   0,  14,   0, 255,   0,  10,   0, 255,   0,   5,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   5,   0, 255,   0,  10,   0, 255,   0,  15,   0, 255,   0,  19,   0, 255,   0,  23,   0, 255,   0,  27,   0, 255,   0,  31,   0, 255,   0,  36,   0, 255,   0,  39,   0, 255,   0,  43,   0, 255,   0,  46,   0, 255,   0,  49,   0, 255,   0,  53,   0, 255,   0,  56,   0, 255,   0,  59,   0, 255,   0,  62,   0, 255,   0,  65,   0, 255,   0,  67,   0, 255,   0,  69,   0, 255,   0,  70,   0, 255,   0,  73,   0, 255,   0,  75,   0, 255,   0,  75,   0, 255,   0,  76,   0, 255,   0,  77,   0, 255,   0,  78,   0, 255,   0,  79,   0, 255,   0,  78,   0, 255,   0,  78,   0, 255,   0,  78,   0, 255,   0,  78,   0, 255,   0,  76,   0, 255,   0,  76,   0, 255,   0,  74,   0, 255,   0,  73,   0, 255,   0,  71,   0, 255,   0,  69,   0, 255,   0,  67,   0, 255,   0,  65,   0, 255,   0,  62,   0, 255,   0,  59,   0, 255,   0,  56,   0, 255,   0,  53,   0, 255,   0,  49,   0, 255,   0,  46,   0, 255,   0,  43,   0, 255,   0,  39,   0, 255,   0,  35,   0, 255,   0,  32,   0, 255,   0,  27,   0, 255,   0,  23,   0, 255,   0,  18,   0, 255,   0,  14,   0, 255,   0,  10,   0, 255,   0,   5,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   5,   0, 255,   0,   9,   0, 255,   0,  15,   0, 255,   0,  19,   0, 255,   0,  23,   0, 255,   0,  28,   0, 255,   0,  33,   0, 255,   0,  37,   0, 255,   0,  41,   0, 255,   0,  44,   0, 255,   0,  48,   0, 255,   0,  51,   0, 255,   0,  56,   0, 255,   0,  59,   0, 255,   0,  62,   0, 255,   0,  64,   0, 255,   0,  68,   0, 255,   0,  71,   0, 255,   0,  72,   0, 255,   0,  75,   0, 255,   0,  77,   0, 255,   0,  79,   0, 255,   0,  81,   0, 255,   0,  82,   0, 255,   0,  83,   0, 255,   0,  84,   0, 255,   0,  85,   0, 255,   0,  85,   0, 255,   0,  85,   0, 255,   0,  85,   0, 255,   0,  85,   0, 255,   0,  83,   0, 255,   0,  83,   0, 255,   0,  82,   0, 255,   0,  80,   0, 255,   0,  79,   0, 255,   0,  78,   0, 255,   0,  75,   0, 255,   0,  73,   0, 255,   0,  70,   0, 255,   0,  68,   0, 255,   0,  64,   0, 255,   0,  62,   0, 255,   0,  59,   0, 255,   0,  56,   0, 255,   0,  52,   0, 255,   0,  49,   0, 255,   0,  44,   0, 255,   0,  40,   0, 255,   0,  36,   0, 255,   0,  33,   0, 255,   0,  28,   0, 255,   0,  24,   0, 255,   0,  19,   0, 255,   0,  14,   0, 255,   0,  10,   0, 255,   0,   5,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   4,   0, 255,   0,  10,   0, 255,   0,  14,   0, 255,   0,  19,   0, 255,   0,  24,   0, 255,   0,  28,   0, 255,   0,  32,   0, 255,   0,  37,   0, 255,   0,  41,   0, 255,   0,  46,   0, 255,   0,  49,   0, 255,   0,  53,   0, 255,   0,  57,   0, 255,   0,  61,   0, 255,   0,  65,   0, 255,   0,  68,   0, 255,   0,  70,   0, 255,   0,  74,   0, 255,   0,  76,   0, 255,   0,  79,   0, 255,   0,  81,   0, 255,   0,  83,   0, 255,   0,  85,   0, 255,   0,  87,   0, 255,   0,  88,   0, 255,   0,  89,   0, 255,   0,  90,   0, 255,   0,  91,   0, 255,   0,  91,   0, 255,   0,  92,   0, 255,   0,  91,   0, 255,   0,  91,   0, 255,   0,  91,   0, 255,   0,  89,   0, 255,   0,  88,   0, 255,   0,  87,   0, 255,   0,  86,   0, 255,   0,  83,   0, 255,   0,  81,   0, 255,   0,  79,   0, 255,   0,  76,   0, 255,   0,  74,   0, 255,   0,  71,   0, 255,   0,  68,   0, 255,   0,  64,   0, 255,   0,  61,   0, 255,   0,  57,   0, 255,   0,  53,   0, 255,   0,  49,   0, 255,   0,  46,   0, 255,   0,  42,   0, 255,   0,  37,   0, 255,   0,  32,   0, 255,   0,  28,   0, 255,   0,  24,   0, 255,   0,  20,   0, 255,   0,  15,   0, 255,   0,  10,   0, 255,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   4,   0, 255,   0,   8,   0, 255,   0,  13,   0, 255,   0,  19,   0, 255,   0,  24,   0, 255,   0,  28,   0, 255,   0,  33,   0, 255,   0,  38,   0, 255,   0,  42,   0, 255,   0,  47,   0, 255,   0,  51,   0, 255,   0,  55,   0, 255,   0,  58,   0, 255,   0,  63,   0, 255,   0,  66,   0, 255,   0,  69,   0, 255,   0,  73,   0, 255,   0,  76,   0, 255,   0,  80,   0, 255,   0,  82,   0, 255,   0,  85,   0, 255,   0,  88,   0, 255,   0,  90,   0, 255,   0,  91,   0, 255,   0,  93,   0, 255,   0,  95,   0, 255,   0,  96,   0, 255,   0,  97,   0, 255,   0,  98,   0, 255,   0,  98,   0, 255,   0,  98,   0, 255,   0,  97,   0, 255,   0,  97,   0, 255,   0,  97,   0, 255,   0,  96,   0, 255,   0,  95,   0, 255,   0,  93,   0, 255,   0,  91,   0, 255,   0,  90,   0, 255,   0,  87,   0, 255,   0,  85,   0, 255,   0,  83,   0, 255,   0,  79,   0, 255,   0,  76,   0, 255,   0,  73,   0, 255,   0,  70,   0, 255,   0,  67,   0, 255,   0,  63,   0, 255,   0,  58,   0, 255,   0,  54,   0, 255,   0,  51,   0, 255,   0,  47,   0, 255,   0,  42,   0, 255,   0,  38,   0, 255,   0,  33,   0, 255,   0,  29,   0, 255,   0,  24,   0, 255,   0,  18,   0, 255,   0,  14,   0, 255,   0,   8,   0, 255,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   2,   0, 255,   0,   8,   0, 255,   0,  13,   0, 255,   0,  19,   0, 255,   0,  24,   0, 255,   0,  28,   0, 255,   0,  33,   0, 255,   0,  37,   0, 255,   0,  42,   0, 255,   0,  46,   0, 255,   0,  51,   0, 255,   0,  56,   0, 255,   0,  60,   0, 255,   0,  64,   0, 255,   0,  68,   0, 255,   0,  71,   0, 255,   0,  76,   0, 255,   0,  79,   0, 255,   0,  82,   0, 255,   0,  85,   0, 255,   0,  88,   0, 255,   0,  91,   0, 255,   0,  94,   0, 255,   0,  96,   0, 255,   0,  98,   0, 255,   0,  99,   0, 255,   0, 101,   0, 255,   0, 102,   0, 255,   0, 104,   0, 255,   0, 104,   0, 255,   0, 105,   0, 255,   0, 105,   0, 255,   0, 105,   0, 255,   0, 105,   0, 255,   0, 104,   0, 255,   0, 103,   0, 255,   0, 101,   0, 255,   0,  99,   0, 255,   0,  98,   0, 255,   0,  96,   0, 255,   0,  94,   0, 255,   0,  91,   0, 255,   0,  88,   0, 255,   0,  85,   0, 255,   0,  82,   0, 255,   0,  79,   0, 255,   0,  75,   0, 255,   0,  72,   0, 255,   0,  68,   0, 255,   0,  64,   0, 255,   0,  60,   0, 255,   0,  56,   0, 255,   0,  52,   0, 255,   0,  47,   0, 255,   0,  43,   0, 255,   0,  38,   0, 255,   0,  33,   0, 255,   0,  28,   0, 255,   0,  23,   0, 255,   0,  18,   0, 255,   0,  13,   0, 255,   0,   7,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   6,   0, 255,   0,  11,   0, 255,   0,  17,   0, 255,   0,  22,   0, 255,   0,  27,   0, 255,   0,  33,   0, 255,   0,  37,   0, 255,   0,  43,   0, 255,   0,  47,   0, 255,   0,  52,   0, 255,   0,  56,   0, 255,   0,  61,   0, 255,   0,  65,   0, 255,   0,  69,   0, 255,   0,  73,   0, 255,   0,  77,   0, 255,   0,  81,   0, 255,   0,  85,   0, 255,   0,  88,   0, 255,   0,  92,   0, 255,   0,  94,   0, 255,   0,  97,   0, 255,   0,  99,   0, 255,   0, 102,   0, 255,   0, 104,   0, 255,   0, 106,   0, 255,   0, 107,   0, 255,   0, 109,   0, 255,   0, 110,   0, 255,   0, 111,   0, 255,   0, 111,   0, 255,   0, 111,   0, 255,   0, 111,   0, 255,   0, 110,   0, 255,   0, 110,   0, 255,   0, 109,   0, 255,   0, 107,   0, 255,   0, 106,   0, 255,   0, 104,   0, 255,   0, 102,   0, 255,   0,  99,   0, 255,   0,  97,   0, 255,   0,  95,   0, 255,   0,  91,   0, 255,   0,  88,   0, 255,   0,  84,   0, 255,   0,  81,   0, 255,   0,  77,   0, 255,   0,  73,   0, 255,   0,  69,   0, 255,   0,  65,   0, 255,   0,  61,   0, 255,   0,  56,   0, 255,   0,  52,   0, 255,   0,  46,   0, 255,   0,  42,   0, 255,   0,  37,   0, 255,   0,  32,   0, 255,   0,  27,   0, 255,   0,  22,   0, 255,   0,  17,   0, 255,   0,  12,   0, 255,   0,   7,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   5,   0, 255,   0,  10,   0, 255,   0,  16,   0, 255,   0,  20,   0, 255,   0,  26,   0, 255,   0,  31,   0, 255,   0,  36,   0, 255,   0,  41,   0, 255,   0,  47,   0, 255,   0,  51,   0, 255,   0,  56,   0, 255,   0,  61,   0, 255,   0,  66,   0, 255,   0,  70,   0, 255,   0,  74,   0, 255,   0,  78,   0, 255,   0,  82,   0, 255,   0,  87,   0, 255,   0,  90,   0, 255,   0,  93,   0, 255,   0,  97,   0, 255,   0, 100,   0, 255,   0, 103,   0, 255,   0, 105,   0, 255,   0, 108,   0, 255,   0, 110,   0, 255,   0, 113,   0, 255,   0, 113,   0, 255,   0, 116,   0, 255,   0, 116,   0, 255,   0, 117,   0, 255,   0, 117,   0, 255,   0, 117,   0, 255,   0, 118,   0, 255,   0, 117,   0, 255,   0, 116,   0, 255,   0, 115,   0, 255,   0, 114,   0, 255,   0, 112,   0, 255,   0, 111,   0, 255,   0, 108,   0, 255,   0, 106,   0, 255,   0, 103,   0, 255,   0, 100,   0, 255,   0,  96,   0, 255,   0,  94,   0, 255,   0,  90,   0, 255,   0,  86,   0, 255,   0,  83,   0, 255,   0,  79,   0, 255,   0,  74,   0, 255,   0,  70,   0, 255,   0,  65,   0, 255,   0,  60,   0, 255,   0,  56,   0, 255,   0,  52,   0, 255,   0,  47,   0, 255,   0,  41,   0, 255,   0,  36,   0, 255,   0,  31,   0, 255,   0,  26,   0, 255,   0,  21,   0, 255,   0,  15,   0, 255,   0,  10,   0, 255,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   8,   0, 255,   0,  14,   0, 255,   0,  20,   0, 255,   0,  25,   0, 255,   0,  30,   0, 255,   0,  35,   0, 255,   0,  40,   0, 255,   0,  46,   0, 255,   0,  51,   0, 255,   0,  56,   0, 255,   0,  61,   0, 255,   0,  66,   0, 255,   0,  70,   0, 255,   0,  74,   0, 255,   0,  79,   0, 255,   0,  84,   0, 255,   0,  87,   0, 255,   0,  92,   0, 255,   0,  96,   0, 255,   0,  99,   0, 255,   0, 102,   0, 255,   0, 105,   0, 255,   0, 109,   0, 255,   0, 111,   0, 255,   0, 114,   0, 255,   0, 117,   0, 255,   0, 119,   0, 255,   0, 120,   0, 255,   0, 121,   0, 255,   0, 123,   0, 255,   0, 123,   0, 255,   0, 124,   0, 255,   0, 125,   0, 255,   0, 124,   0, 255,   0, 123,   0, 255,   0, 123,   0, 255,   0, 121,   0, 255,   0, 120,   0, 255,   0, 119,   0, 255,   0, 117,   0, 255,   0, 115,   0, 255,   0, 111,   0, 255,   0, 109,   0, 255,   0, 106,   0, 255,   0, 102,   0, 255,   0,  99,   0, 255,   0,  95,   0, 255,   0,  91,   0, 255,   0,  88,   0, 255,   0,  84,   0, 255,   0,  79,   0, 255,   0,  74,   0, 255,   0,  70,   0, 255,   0,  66,   0, 255,   0,  60,   0, 255,   0,  56,   0, 255,   0,  51,   0, 255,   0,  46,   0, 255,   0,  40,   0, 255,   0,  35,   0, 255,   0,  30,   0, 255,   0,  25,   0, 255,   0,  19,   0, 255,   0,  14,   0, 255,   0,   8,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   6,   0, 255,   0,  11,   0, 255,   0,  18,   0, 255,   0,  23,   0, 255,   0,  28,   0, 255,   0,  34,   0, 255,   0,  39,   0, 255,   0,  45,   0, 255,   0,  50,   0, 255,   0,  55,   0, 255,   0,  60,   0, 255,   0,  65,   0, 255,   0,  69,   0, 255,   0,  74,   0, 255,   0,  79,   0, 255,   0,  84,   0, 255,   0,  88,   0, 255,   0,  93,   0, 255,   0,  97,   0, 255,   0, 101,   0, 255,   0, 105,   0, 255,   0, 108,   0, 255,   0, 112,   0, 255,   0, 114,   0, 255,   0, 118,   0, 255,   0, 120,   0, 255,   0, 123,   0, 255,   0, 125,   0, 255,   0, 127,   0, 255,   0, 128,   0, 255,   0, 129,   0, 255,   0, 130,   0, 255,   0, 130,   0, 255,   0, 130,   0, 255,   0, 130,   0, 255,   0, 130,   0, 255,   0, 129,   0, 255,   0, 128,   0, 255,   0, 126,   0, 255,   0, 125,   0, 255,   0, 123,   0, 255,   0, 120,   0, 255,   0, 118,   0, 255,   0, 115,   0, 255,   0, 112,   0, 255,   0, 108,   0, 255,   0, 105,   0, 255,   0, 101,   0, 255,   0,  97,   0, 255,   0,  93,   0, 255,   0,  88,   0, 255,   0,  84,   0, 255,   0,  79,   0, 255,   0,  75,   0, 255,   0,  70,   0, 255,   0,  65,   0, 255,   0,  60,   0, 255,   0,  55,   0, 255,   0,  50,   0, 255,   0,  45,   0, 255,   0,  39,   0, 255,   0,  34,   0, 255,   0,  29,   0, 255,   0,  23,   0, 255,   0,  17,   0, 255,   0,  12,   0, 255,   0,   6,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,  10,   0, 255,   0,  15,   0, 255,   0,  21,   0, 255,   0,  26,   0, 255,   0,  31,   0, 255,   0,  37,   0, 255,   0,  43,   0, 255,   0,  49,   0, 255,   0,  53,   0, 255,   0,  58,   0, 255,   0,  64,   0, 255,   0,  69,   0, 255,   0,  75,   0, 255,   0,  79,   0, 255,   0,  84,   0, 255,   0,  88,   0, 255,   0,  94,   0, 255,   0,  98,   0, 255,   0, 101,   0, 255,   0, 106,   0, 255,   0, 110,   0, 255,   0, 113,   0, 255,   0, 117,   0, 255,   0, 121,   0, 255,   0, 123,   0, 255,   0, 126,   0, 255,   0, 129,   0, 255,   0, 131,   0, 255,   0, 132,   0, 255,   0, 134,   0, 255,   0, 136,   0, 255,   0, 137,   0, 255,   0, 137,   0, 255,   0, 138,   0, 255,   0, 137,   0, 255,   0, 136,   0, 255,   0, 136,   0, 255,   0, 135,   0, 255,   0, 133,   0, 255,   0, 131,   0, 255,   0, 129,   0, 255,   0, 126,   0, 255,   0, 124,   0, 255,   0, 120,   0, 255,   0, 117,   0, 255,   0, 114,   0, 255,   0, 109,   0, 255,   0, 106,   0, 255,   0, 102,   0, 255,   0,  98,   0, 255,   0,  93,   0, 255,   0,  88,   0, 255,   0,  84,   0, 255,   0,  79,   0, 255,   0,  75,   0, 255,   0,  69,   0, 255,   0,  64,   0, 255,   0,  59,   0, 255,   0,  53,   0, 255,   0,  49,   0, 255,   0,  42,   0, 255,   0,  38,   0, 255,   0,  32,   0, 255,   0,  26,   0, 255,   0,  21,   0, 255,   0,  15,   0, 255,   0,   9,   0, 255,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   6,   0, 255,   0,  13,   0, 255,   0,  18,   0, 255,   0,  24,   0, 255,   0,  29,   0, 255,   0,  35,   0, 255,   0,  41,   0, 255,   0,  47,   0, 255,   0,  52,   0, 255,   0,  58,   0, 255,   0,  63,   0, 255,   0,  68,   0, 255,   0,  73,   0, 255,   0,  78,   0, 255,   0,  83,   0, 255,   0,  89,   0, 255,   0,  93,   0, 255,   0,  98,   0, 255,   0, 103,   0, 255,   0, 107,   0, 255,   0, 111,   0, 255,   0, 115,   0, 255,   0, 119,   0, 255,   0, 123,   0, 255,   0, 126,   0, 255,   0, 129,   0, 255,   0, 132,   0, 255,   0, 135,   0, 255,   0, 137,   0, 255,   0, 139,   0, 255,   0, 141,   0, 255,   0, 143,   0, 255,   0, 143,   0, 255,   0, 144,   0, 255,   0, 144,   0, 255,   0, 144,   0, 255,   0, 143,   0, 255,   0, 142,   0, 255,   0, 141,   0, 255,   0, 139,   0, 255,   0, 137,   0, 255,   0, 135,   0, 255,   0, 132,   0, 255,   0, 129,   0, 255,   0, 126,   0, 255,   0, 122,   0, 255,   0, 119,   0, 255,   0, 115,   0, 255,   0, 111,   0, 255,   0, 107,   0, 255,   0, 103,   0, 255,   0,  97,   0, 255,   0,  94,   0, 255,   0,  88,   0, 255,   0,  84,   0, 255,   0,  78,   0, 255,   0,  73,   0, 255,   0,  68,   0, 255,   0,  63,   0, 255,   0,  58,   0, 255,   0,  52,   0, 255,   0,  46,   0, 255,   0,  41,   0, 255,   0,  35,   0, 255,   0,  30,   0, 255,   0,  23,   0, 255,   0,  18,   0, 255,   0,  12,   0, 255,   0,   6,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   4,   0, 255,   0,   9,   0, 255,   0,  16,   0, 255,   0,  21,   0, 255,   0,  27,   0, 255,   0,  33,   0, 255,   0,  39,   0, 255,   0,  44,   0, 255,   0,  50,   0, 255,   0,  55,   0, 255,   0,  61,   0, 255,   0,  66,   0, 255,   0,  72,   0, 255,   0,  77,   0, 255,   0,  82,   0, 255,   0,  88,   0, 255,   0,  93,   0, 255,   0,  97,   0, 255,   0, 103,   0, 255,   0, 108,   0, 255,   0, 112,   0, 255,   0, 116,   0, 255,   0, 120,   0, 255,   0, 124,   0, 255,   0, 128,   0, 255,   0, 132,   0, 255,   0, 135,   0, 255,   0, 138,   0, 255,   0, 141,   0, 255,   0, 144,   0, 255,   0, 145,   0, 255,   0, 147,   0, 255,   0, 148,   0, 255,   0, 150,   0, 255,   0, 151,   0, 255,   0, 151,   0, 255,   0, 150,   0, 255,   0, 150,   0, 255,   0, 148,   0, 255,   0, 147,   0, 255,   0, 145,   0, 255,   0, 143,   0, 255,   0, 141,   0, 255,   0, 138,   0, 255,   0, 135,   0, 255,   0, 131,   0, 255,   0, 128,   0, 255,   0, 124,   0, 255,   0, 120,   0, 255,   0, 116,   0, 255,   0, 112,   0, 255,   0, 107,   0, 255,   0, 102,   0, 255,   0,  97,   0, 255,   0,  92,   0, 255,   0,  88,   0, 255,   0,  83,   0, 255,   0,  77,   0, 255,   0,  72,   0, 255,   0,  66,   0, 255,   0,  61,   0, 255,   0,  56,   0, 255,   0,  49,   0, 255,   0,  44,   0, 255,   0,  39,   0, 255,   0,  32,   0, 255,   0,  27,   0, 255,   0,  21,   0, 255,   0,  15,   0, 255,   0,  10,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   6,   0, 255,   0,  12,   0, 255,   0,  18,   0, 255,   0,  24,   0, 255,   0,  30,   0, 255,   0,  36,   0, 255,   0,  41,   0, 255,   0,  47,   0, 255,   0,  53,   0, 255,   0,  59,   0, 255,   0,  64,   0, 255,   0,  70,   0, 255,   0,  76,   0, 255,   0,  81,   0, 255,   0,  87,   0, 255,   0,  92,   0, 255,   0,  97,   0, 255,   0, 102,   0, 255,   0, 107,   0, 255,   0, 112,   0, 255,   0, 117,   0, 255,   0, 120,   0, 255,   0, 125,   0, 255,   0, 130,   0, 255,   0, 134,   0, 255,   0, 138,   0, 255,   0, 140,   0, 255,   0, 144,   0, 255,   0, 147,   0, 255,   0, 149,   0, 255,   0, 152,   0, 255,   0, 153,   0, 255,   0, 155,   0, 255,   0, 156,   0, 255,   0, 157,   0, 255,   0, 157,   0, 255,   0, 157,   0, 255,   0, 156,   0, 255,   0, 155,   0, 255,   0, 153,   0, 255,   0, 151,   0, 255,   0, 149,   0, 255,   0, 147,   0, 255,   0, 144,   0, 255,   0, 141,   0, 255,   0, 137,   0, 255,   0, 134,   0, 255,   0, 129,   0, 255,   0, 125,   0, 255,   0, 120,   0, 255,   0, 116,   0, 255,   0, 111,   0, 255,   0, 107,   0, 255,   0, 102,   0, 255,   0,  97,   0, 255,   0,  92,   0, 255,   0,  86,   0, 255,   0,  81,   0, 255,   0,  76,   0, 255,   0,  70,   0, 255,   0,  64,   0, 255,   0,  58,   0, 255,   0,  53,   0, 255,   0,  47,   0, 255,   0,  42,   0, 255,   0,  36,   0, 255,   0,  30,   0, 255,   0,  24,   0, 255,   0,  18,   0, 255,   0,  12,   0, 255,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   2,   0, 255,   0,   9,   0, 255,   0,  14,   0, 255,   0,  21,   0, 255,   0,  26,   0, 255,   0,  33,   0, 255,   0,  38,   0, 255,   0,  44,   0, 255,   0,  50,   0, 255,   0,  56,   0, 255,   0,  62,   0, 255,   0,  68,   0, 255,   0,  73,   0, 255,   0,  79,   0, 255,   0,  84,   0, 255,   0,  90,   0, 255,   0,  95,   0, 255,   0, 101,   0, 255,   0, 106,   0, 255,   0, 111,   0, 255,   0, 116,   0, 255,   0, 120,   0, 255,   0, 125,   0, 255,   0, 130,   0, 255,   0, 134,   0, 255,   0, 139,   0, 255,   0, 143,   0, 255,   0, 146,   0, 255,   0, 149,   0, 255,   0, 153,   0, 255,   0, 155,   0, 255,   0, 158,   0, 255,   0, 159,   0, 255,   0, 162,   0, 255,   0, 162,   0, 255,   0, 163,   0, 255,   0, 164,   0, 255,   0, 163,   0, 255,   0, 163,   0, 255,   0, 161,   0, 255,   0, 160,   0, 255,   0, 158,   0, 255,   0, 155,   0, 255,   0, 153,   0, 255,   0, 149,   0, 255,   0, 147,   0, 255,   0, 142,   0, 255,   0, 139,   0, 255,   0, 134,   0, 255,   0, 130,   0, 255,   0, 125,   0, 255,   0, 120,   0, 255,   0, 116,   0, 255,   0, 111,   0, 255,   0, 106,   0, 255,   0, 101,   0, 255,   0,  95,   0, 255,   0,  90,   0, 255,   0,  85,   0, 255,   0,  79,   0, 255,   0,  74,   0, 255,   0,  68,   0, 255,   0,  62,   0, 255,   0,  56,   0, 255,   0,  50,   0, 255,   0,  45,   0, 255,   0,  39,   0, 255,   0,  32,   0, 255,   0,  26,   0, 255,   0,  21,   0, 255,   0,  14,   0, 255,   0,   8,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   5,   0, 255,   0,  11,   0, 255,   0,  17,   0, 255,   0,  23,   0, 255,   0,  29,   0, 255,   0,  35,   0, 255,   0,  41,   0, 255,   0,  48,   0, 255,   0,  53,   0, 255,   0,  59,   0, 255,   0,  65,   0, 255,   0,  71,   0, 255,   0,  77,   0, 255,   0,  82,   0, 255,   0,  88,   0, 255,   0,  93,   0, 255,   0,  99,   0, 255,   0, 104,   0, 255,   0, 110,   0, 255,   0, 115,   0, 255,   0, 120,   0, 255,   0, 126,   0, 255,   0, 130,   0, 255,   0, 134,   0, 255,   0, 139,   0, 255,   0, 144,   0, 255,   0, 147,   0, 255,   0, 152,   0, 255,   0, 155,   0, 255,   0, 159,   0, 255,   0, 161,   0, 255,   0, 164,   0, 255,   0, 166,   0, 255,   0, 168,   0, 255,   0, 169,   0, 255,   0, 170,   0, 255,   0, 170,   0, 255,   0, 170,   0, 255,   0, 169,   0, 255,   0, 167,   0, 255,   0, 166,   0, 255,   0, 164,   0, 255,   0, 162,   0, 255,   0, 158,   0, 255,   0, 155,   0, 255,   0, 151,   0, 255,   0, 148,   0, 255,   0, 144,   0, 255,   0, 140,   0, 255,   0, 135,   0, 255,   0, 130,   0, 255,   0, 125,   0, 255,   0, 120,   0, 255,   0, 115,   0, 255,   0, 109,   0, 255,   0, 104,   0, 255,   0,  99,   0, 255,   0,  94,   0, 255,   0,  88,   0, 255,   0,  83,   0, 255,   0,  77,   0, 255,   0,  71,   0, 255,   0,  65,   0, 255,   0,  59,   0, 255,   0,  54,   0, 255,   0,  47,   0, 255,   0,  41,   0, 255,   0,  35,   0, 255,   0,  29,   0, 255,   0,  23,   0, 255,   0,  17,   0, 255,   0,  10,   0, 255,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   7,   0, 255,   0,  14,   0, 255,   0,  19,   0, 255,   0,  26,   0, 255,   0,  32,   0, 255,   0,  38,   0, 255,   0,  44,   0, 255,   0,  50,   0, 255,   0,  55,   0, 255,   0,  62,   0, 255,   0,  68,   0, 255,   0,  73,   0, 255,   0,  80,   0, 255,   0,  85,   0, 255,   0,  91,   0, 255,   0,  97,   0, 255,   0, 102,   0, 255,   0, 108,   0, 255,   0, 114,   0, 255,   0, 118,   0, 255,   0, 125,   0, 255,   0, 129,   0, 255,   0, 135,   0, 255,   0, 139,   0, 255,   0, 144,   0, 255,   0, 149,   0, 255,   0, 153,   0, 255,   0, 157,   0, 255,   0, 160,   0, 255,   0, 164,   0, 255,   0, 168,   0, 255,   0, 170,   0, 255,   0, 172,   0, 255,   0, 174,   0, 255,   0, 176,   0, 255,   0, 176,   0, 255,   0, 176,   0, 255,   0, 176,   0, 255,   0, 176,   0, 255,   0, 174,   0, 255,   0, 172,   0, 255,   0, 170,   0, 255,   0, 167,   0, 255,   0, 164,   0, 255,   0, 161,   0, 255,   0, 157,   0, 255,   0, 153,   0, 255,   0, 149,   0, 255,   0, 144,   0, 255,   0, 140,   0, 255,   0, 135,   0, 255,   0, 129,   0, 255,   0, 124,   0, 255,   0, 118,   0, 255,   0, 114,   0, 255,   0, 108,   0, 255,   0, 103,   0, 255,   0,  97,   0, 255,   0,  91,   0, 255,   0,  86,   0, 255,   0,  80,   0, 255,   0,  73,   0, 255,   0,  68,   0, 255,   0,  62,   0, 255,   0,  56,   0, 255,   0,  50,   0, 255,   0,  44,   0, 255,   0,  38,   0, 255,   0,  32,   0, 255,   0,  25,   0, 255,   0,  19,   0, 255,   0,  13,   0, 255,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   9,   0, 255,   0,  15,   0, 255,   0,  22,   0, 255,   0,  27,   0, 255,   0,  34,   0, 255,   0,  40,   0, 255,   0,  46,   0, 255,   0,  52,   0, 255,   0,  59,   0, 255,   0,  64,   0, 255,   0,  70,   0, 255,   0,  76,   0, 255,   0,  82,   0, 255,   0,  88,   0, 255,   0,  94,   0, 255,   0, 100,   0, 255,   0, 106,   0, 255,   0, 111,   0, 255,   0, 117,   0, 255,   0, 123,   0, 255,   0, 128,   0, 255,   0, 134,   0, 255,   0, 139,   0, 255,   0, 144,   0, 255,   0, 149,   0, 255,   0, 153,   0, 255,   0, 158,   0, 255,   0, 162,   0, 255,   0, 166,   0, 255,   0, 169,   0, 255,   0, 173,   0, 255,   0, 176,   0, 255,   0, 178,   0, 255,   0, 180,   0, 255,   0, 182,   0, 255,   0, 183,   0, 255,   0, 183,   0, 255,   0, 183,   0, 255,   0, 182,   0, 255,   0, 180,   0, 255,   0, 178,   0, 255,   0, 176,   0, 255,   0, 173,   0, 255,   0, 170,   0, 255,   0, 166,   0, 255,   0, 162,   0, 255,   0, 158,   0, 255,   0, 153,   0, 255,   0, 148,   0, 255,   0, 144,   0, 255,   0, 138,   0, 255,   0, 133,   0, 255,   0, 128,   0, 255,   0, 122,   0, 255,   0, 117,   0, 255,   0, 112,   0, 255,   0, 106,   0, 255,   0, 100,   0, 255,   0,  94,   0, 255,   0,  89,   0, 255,   0,  82,   0, 255,   0,  76,   0, 255,   0,  71,   0, 255,   0,  64,   0, 255,   0,  58,   0, 255,   0,  52,   0, 255,   0,  46,   0, 255,   0,  40,   0, 255,   0,  34,   0, 255,   0,  27,   0, 255,   0,  21,   0, 255,   0,  15,   0, 255,   0,   9,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   4,   0, 255,   0,  11,   0, 255,   0,  17,   0, 255,   0,  23,   0, 255,   0,  30,   0, 255,   0,  36,   0, 255,   0,  42,   0, 255,   0,  48,   0, 255,   0,  54,   0, 255,   0,  60,   0, 255,   0,  67,   0, 255,   0,  72,   0, 255,   0,  79,   0, 255,   0,  85,   0, 255,   0,  91,   0, 255,   0,  97,   0, 255,   0, 103,   0, 255,   0, 109,   0, 255,   0, 114,   0, 255,   0, 121,   0, 255,   0, 126,   0, 255,   0, 131,   0, 255,   0, 138,   0, 255,   0, 142,   0, 255,   0, 148,   0, 255,   0, 153,   0, 255,   0, 158,   0, 255,   0, 163,   0, 255,   0, 167,   0, 255,   0, 171,   0, 255,   0, 175,   0, 255,   0, 179,   0, 255,   0, 182,   0, 255,   0, 185,   0, 255,   0, 187,   0, 255,   0, 188,   0, 255,   0, 190,   0, 255,   0, 189,   0, 255,   0, 190,   0, 255,   0, 188,   0, 255,   0, 187,   0, 255,   0, 185,   0, 255,   0, 182,   0, 255,   0, 179,   0, 255,   0, 175,   0, 255,   0, 171,   0, 255,   0, 167,   0, 255,   0, 162,   0, 255,   0, 158,   0, 255,   0, 153,   0, 255,   0, 148,   0, 255,   0, 143,   0, 255,   0, 137,   0, 255,   0, 132,   0, 255,   0, 126,   0, 255,   0, 121,   0, 255,   0, 114,   0, 255,   0, 109,   0, 255,   0, 103,   0, 255,   0,  97,   0, 255,   0,  91,   0, 255,   0,  85,   0, 255,   0,  79,   0, 255,   0,  73,   0, 255,   0,  67,   0, 255,   0,  60,   0, 255,   0,  54,   0, 255,   0,  49,   0, 255,   0,  42,   0, 255,   0,  36,   0, 255,   0,  29,   0, 255,   0,  24,   0, 255,   0,  17,   0, 255,   0,  11,   0, 255,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   6,   0, 255,   0,  12,   0, 255,   0,  19,   0, 255,   0,  26,   0, 255,   0,  31,   0, 255,   0,  37,   0, 255,   0,  44,   0, 255,   0,  51,   0, 255,   0,  56,   0, 255,   0,  63,   0, 255,   0,  68,   0, 255,   0,  75,   0, 255,   0,  81,   0, 255,   0,  88,   0, 255,   0,  94,   0, 255,   0, 100,   0, 255,   0, 106,   0, 255,   0, 112,   0, 255,   0, 118,   0, 255,   0, 123,   0, 255,   0, 129,   0, 255,   0, 135,   0, 255,   0, 140,   0, 255,   0, 146,   0, 255,   0, 152,   0, 255,   0, 157,   0, 255,   0, 162,   0, 255,   0, 167,   0, 255,   0, 172,   0, 255,   0, 176,   0, 255,   0, 181,   0, 255,   0, 185,   0, 255,   0, 187,   0, 255,   0, 191,   0, 255,   0, 193,   0, 255,   0, 195,   0, 255,   0, 195,   0, 255,   0, 196,   0, 255,   0, 196,   0, 255,   0, 195,   0, 255,   0, 193,   0, 255,   0, 191,   0, 255,   0, 188,   0, 255,   0, 185,   0, 255,   0, 180,   0, 255,   0, 177,   0, 255,   0, 171,   0, 255,   0, 167,   0, 255,   0, 162,   0, 255,   0, 156,   0, 255,   0, 152,   0, 255,   0, 146,   0, 255,   0, 140,   0, 255,   0, 135,   0, 255,   0, 129,   0, 255,   0, 124,   0, 255,   0, 117,   0, 255,   0, 112,   0, 255,   0, 106,   0, 255,   0,  99,   0, 255,   0,  93,   0, 255,   0,  87,   0, 255,   0,  81,   0, 255,   0,  75,   0, 255,   0,  69,   0, 255,   0,  63,   0, 255,   0,  56,   0, 255,   0,  51,   0, 255,   0,  44,   0, 255,   0,  38,   0, 255,   0,  31,   0, 255,   0,  25,   0, 255,   0,  19,   0, 255,   0,  13,   0, 255,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   7,   0, 255,   0,  14,   0, 255,   0,  21,   0, 255,   0,  27,   0, 255,   0,  33,   0, 255,   0,  39,   0, 255,   0,  45,   0, 255,   0,  52,   0, 255,   0,  58,   0, 255,   0,  64,   0, 255,   0,  71,   0, 255,   0,  78,   0, 255,   0,  84,   0, 255,   0,  90,   0, 255,   0,  96,   0, 255,   0, 102,   0, 255,   0, 108,   0, 255,   0, 115,   0, 255,   0, 121,   0, 255,   0, 127,   0, 255,   0, 132,   0, 255,   0, 138,   0, 255,   0, 144,   0, 255,   0, 150,   0, 255,   0, 156,   0, 255,   0, 161,   0, 255,   0, 166,   0, 255,   0, 172,   0, 255,   0, 177,   0, 255,   0, 181,   0, 255,   0, 186,   0, 255,   0, 190,   0, 255,   0, 193,   0, 255,   0, 197,   0, 255,   0, 199,   0, 255,   0, 201,   0, 255,   0, 203,   0, 255,   0, 203,   0, 255,   0, 202,   0, 255,   0, 201,   0, 255,   0, 199,   0, 255,   0, 196,   0, 255,   0, 193,   0, 255,   0, 189,   0, 255,   0, 186,   0, 255,   0, 181,   0, 255,   0, 176,   0, 255,   0, 172,   0, 255,   0, 167,   0, 255,   0, 161,   0, 255,   0, 155,   0, 255,   0, 149,   0, 255,   0, 144,   0, 255,   0, 138,   0, 255,   0, 132,   0, 255,   0, 126,   0, 255,   0, 121,   0, 255,   0, 114,   0, 255,   0, 108,   0, 255,   0, 102,   0, 255,   0,  96,   0, 255,   0,  90,   0, 255,   0,  84,   0, 255,   0,  77,   0, 255,   0,  71,   0, 255,   0,  65,   0, 255,   0,  58,   0, 255,   0,  52,   0, 255,   0,  46,   0, 255,   0,  39,   0, 255,   0,  33,   0, 255,   0,  27,   0, 255,   0,  21,   0, 255,   0,  14,   0, 255,   0,   7,   0, 255,   0,   1,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   8,   0, 255,   0,  15,   0, 255,   0,  22,   0, 255,   0,  28,   0, 255,   0,  34,   0, 255,   0,  40,   0, 255,   0,  47,   0, 255,   0,  53,   0, 255,   0,  60,   0, 255,   0,  66,   0, 255,   0,  73,   0, 255,   0,  79,   0, 255,   0,  86,   0, 255,   0,  91,   0, 255,   0,  98,   0, 255,   0, 104,   0, 255,   0, 110,   0, 255,   0, 117,   0, 255,   0, 123,   0, 255,   0, 129,   0, 255,   0, 135,   0, 255,   0, 141,   0, 255,   0, 147,   0, 255,   0, 152,   0, 255,   0, 158,   0, 255,   0, 165,   0, 255,   0, 170,   0, 255,   0, 176,   0, 255,   0, 181,   0, 255,   0, 186,   0, 255,   0, 190,   0, 255,   0, 195,   0, 255,   0, 199,   0, 255,   0, 202,   0, 255,   0, 205,   0, 255,   0, 207,   0, 255,   0, 209,   0, 255,   0, 209,   0, 255,   0, 209,   0, 255,   0, 208,   0, 255,   0, 205,   0, 255,   0, 202,   0, 255,   0, 198,   0, 255,   0, 194,   0, 255,   0, 190,   0, 255,   0, 186,   0, 255,   0, 181,   0, 255,   0, 175,   0, 255,   0, 169,   0, 255,   0, 164,   0, 255,   0, 159,   0, 255,   0, 152,   0, 255,   0, 147,   0, 255,   0, 140,   0, 255,   0, 135,   0, 255,   0, 129,   0, 255,   0, 123,   0, 255,   0, 117,   0, 255,   0, 110,   0, 255,   0, 104,   0, 255,   0,  98,   0, 255,   0,  92,   0, 255,   0,  85,   0, 255,   0,  79,   0, 255,   0,  73,   0, 255,   0,  66,   0, 255,   0,  60,   0, 255,   0,  53,   0, 255,   0,  47,   0, 255,   0,  41,   0, 255,   0,  35,   0, 255,   0,  28,   0, 255,   0,  22,   0, 255,   0,  15,   0, 255,   0,   9,   0, 255,   0,   2,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,  10,   0, 255,   0,  16,   0, 255,   0,  23,   0, 255,   0,  29,   0, 255,   0,  36,   0, 255,   0,  42,   0, 255,   0,  49,   0, 255,   0,  55,   0, 255,   0,  61,   0, 255,   0,  68,   0, 255,   0,  75,   0, 255,   0,  80,   0, 255,   0,  87,   0, 255,   0,  93,   0, 255,   0, 100,   0, 255,   0, 106,   0, 255,   0, 112,   0, 255,   0, 119,   0, 255,   0, 124,   0, 255,   0, 131,   0, 255,   0, 137,   0, 255,   0, 143,   0, 255,   0, 150,   0, 255,   0, 156,   0, 255,   0, 162,   0, 255,   0, 167,   0, 255,   0, 173,   0, 255,   0, 179,   0, 255,   0, 185,   0, 255,   0, 190,   0, 255,   0, 195,   0, 255,   0, 199,   0, 255,   0, 204,   0, 255,   0, 208,   0, 255,   0, 211,   0, 255,   0, 213,   0, 255,   0, 215,   0, 255,   0, 216,   0, 255,   0, 215,   0, 255,   0, 214,   0, 255,   0, 211,   0, 255,   0, 207,   0, 255,   0, 204,   0, 255,   0, 199,   0, 255,   0, 194,   0, 255,   0, 189,   0, 255,   0, 184,   0, 255,   0, 179,   0, 255,   0, 173,   0, 255,   0, 167,   0, 255,   0, 161,   0, 255,   0, 155,   0, 255,   0, 149,   0, 255,   0, 143,   0, 255,   0, 137,   0, 255,   0, 131,   0, 255,   0, 125,   0, 255,   0, 119,   0, 255,   0, 112,   0, 255,   0, 106,   0, 255,   0,  99,   0, 255,   0,  94,   0, 255,   0,  87,   0, 255,   0,  80,   0, 255,   0,  74,   0, 255,   0,  68,   0, 255,   0,  61,   0, 255,   0,  55,   0, 255,   0,  49,   0, 255,   0,  42,   0, 255,   0,  36,   0, 255,   0,  30,   0, 255,   0,  23,   0, 255,   0,  17,   0, 255,   0,  10,   0, 255,   0,   3,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   4,   0, 255,   0,  11,   0, 255,   0,  17,   0, 255,   0,  24,   0, 255,   0,  30,   0, 255,   0,  37,   0, 255,   0,  44,   0, 255,   0,  50,   0, 255,   0,  56,   0, 255,   0,  63,   0, 255,   0,  69,   0, 255,   0,  75,   0, 255,   0,  82,   0, 255,   0,  88,   0, 255,   0,  95,   0, 255,   0, 101,   0, 255,   0, 108,   0, 255,   0, 114,   0, 255,   0, 120,   0, 255,   0, 126,   0, 255,   0, 133,   0, 255,   0, 139,   0, 255,   0, 145,   0, 255,   0, 152,   0, 255,   0, 158,   0, 255,   0, 164,   0, 255,   0, 170,   0, 255,   0, 176,   0, 255,   0, 182,   0, 255,   0, 188,   0, 255,   0, 193,   0, 255,   0, 198,   0, 255,   0, 204,   0, 255,   0, 209,   0, 255,   0, 213,   0, 255,   0, 216,   0, 255,   0, 220,   0, 255,   0, 222,   0, 255,   0, 223,   0, 255,   0, 221,   0, 255,   0, 220,   0, 255,   0, 217,   0, 255,   0, 213,   0, 255,   0, 208,   0, 255,   0, 204,   0, 255,   0, 199,   0, 255,   0, 193,   0, 255,   0, 188,   0, 255,   0, 182,   0, 255,   0, 176,   0, 255,   0, 170,   0, 255,   0, 164,   0, 255,   0, 158,   0, 255,   0, 152,   0, 255,   0, 145,   0, 255,   0, 139,   0, 255,   0, 132,   0, 255,   0, 126,   0, 255,   0, 120,   0, 255,   0, 114,   0, 255,   0, 107,   0, 255,   0, 102,   0, 255,   0,  95,   0, 255,   0,  89,   0, 255,   0,  82,   0, 255,   0,  75,   0, 255,   0,  69,   0, 255,   0,  63,   0, 255,   0,  56,   0, 255,   0,  50,   0, 255,   0,  43,   0, 255,   0,  37,   0, 255,   0,  30,   0, 255,   0,  24,   0, 255,   0,  18,   0, 255,   0,  11,   0, 255,   0,   4,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   5,   0, 255,   0,  12,   0, 255,   0,  18,   0, 255,   0,  25,   0, 255,   0,  31,   0, 255,   0,  37,   0, 255,   0,  45,   0, 255,   0,  50,   0, 255,   0,  57,   0, 255,   0,  63,   0, 255,   0,  70,   0, 255,   0,  77,   0, 255,   0,  83,   0, 255,   0,  89,   0, 255,   0,  96,   0, 255,   0, 103,   0, 255,   0, 109,   0, 255,   0, 116,   0, 255,   0, 122,   0, 255,   0, 128,   0, 255,   0, 134,   0, 255,   0, 141,   0, 255,   0, 147,   0, 255,   0, 154,   0, 255,   0, 159,   0, 255,   0, 166,   0, 255,   0, 172,   0, 255,   0, 178,   0, 255,   0, 185,   0, 255,   0, 190,   0, 255,   0, 197,   0, 255,   0, 202,   0, 255,   0, 208,   0, 255,   0, 213,   0, 255,   0, 218,   0, 255,   0, 222,   0, 255,   0, 226,   0, 255,   0, 229,   0, 255,   0, 229,   0, 255,   0, 228,   0, 255,   0, 226,   0, 255,   0, 223,   0, 255,   0, 218,   0, 255,   0, 213,   0, 255,   0, 208,   0, 255,   0, 202,   0, 255,   0, 196,   0, 255,   0, 190,   0, 255,   0, 185,   0, 255,   0, 178,   0, 255,   0, 172,   0, 255,   0, 166,   0, 255,   0, 160,   0, 255,   0, 153,   0, 255,   0, 148,   0, 255,   0, 141,   0, 255,   0, 135,   0, 255,   0, 128,   0, 255,   0, 122,   0, 255,   0, 115,   0, 255,   0, 109,   0, 255,   0, 103,   0, 255,   0,  96,   0, 255,   0,  89,   0, 255,   0,  83,   0, 255,   0,  77,   0, 255,   0,  70,   0, 255,   0,  63,   0, 255,   0,  57,   0, 255,   0,  51,   0, 255,   0,  44,   0, 255,   0,  37,   0, 255,   0,  31,   0, 255,   0,  24,   0, 255,   0,  19,   0, 255,   0,  12,   0, 255,   0,   5,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   6,   0, 255,   0,  12,   0, 255,   0,  19,   0, 255,   0,  25,   0, 255,   0,  32,   0, 255,   0,  38,   0, 255,   0,  45,   0, 255,   0,  52,   0, 255,   0,  58,   0, 255,   0,  64,   0, 255,   0,  71,   0, 255,   0,  77,   0, 255,   0,  84,   0, 255,   0,  91,   0, 255,   0,  97,   0, 255,   0, 103,   0, 255,   0, 110,   0, 255,   0, 116,   0, 255,   0, 123,   0, 255,   0, 130,   0, 255,   0, 136,   0, 255,   0, 142,   0, 255,   0, 148,   0, 255,   0, 155,   0, 255,   0, 162,   0, 255,   0, 168,   0, 255,   0, 175,   0, 255,   0, 180,   0, 255,   0, 187,   0, 255,   0, 193,   0, 255,   0, 199,   0, 255,   0, 205,   0, 255,   0, 211,   0, 255,   0, 217,   0, 255,   0, 223,   0, 255,   0, 227,   0, 255,   0, 232,   0, 255,   0, 235,   0, 255,   0, 235,   0, 255,   0, 234,   0, 255,   0, 231,   0, 255,   0, 228,   0, 255,   0, 222,   0, 255,   0, 217,   0, 255,   0, 212,   0, 255,   0, 206,   0, 255,   0, 199,   0, 255,   0, 193,   0, 255,   0, 187,   0, 255,   0, 181,   0, 255,   0, 174,   0, 255,   0, 168,   0, 255,   0, 162,   0, 255,   0, 155,   0, 255,   0, 148,   0, 255,   0, 143,   0, 255,   0, 135,   0, 255,   0, 129,   0, 255,   0, 123,   0, 255,   0, 116,   0, 255,   0, 110,   0, 255,   0, 103,   0, 255,   0,  97,   0, 255,   0,  91,   0, 255,   0,  83,   0, 255,   0,  77,   0, 255,   0,  71,   0, 255,   0,  65,   0, 255,   0,  58,   0, 255,   0,  51,   0, 255,   0,  45,   0, 255,   0,  39,   0, 255,   0,  32,   0, 255,   0,  25,   0, 255,   0,  19,   0, 255,   0,  12,   0, 255,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   6,   0, 255,   0,  13,   0, 255,   0,  19,   0, 255,   0,  26,   0, 255,   0,  32,   0, 255,   0,  39,   0, 255,   0,  45,   0, 255,   0,  51,   0, 255,   0,  59,   0, 255,   0,  65,   0, 255,   0,  71,   0, 255,   0,  78,   0, 255,   0,  85,   0, 255,   0,  91,   0, 255,   0,  98,   0, 255,   0, 104,   0, 255,   0, 110,   0, 255,   0, 117,   0, 255,   0, 124,   0, 255,   0, 131,   0, 255,   0, 137,   0, 255,   0, 143,   0, 255,   0, 150,   0, 255,   0, 156,   0, 255,   0, 162,   0, 255,   0, 169,   0, 255,   0, 176,   0, 255,   0, 182,   0, 255,   0, 188,   0, 255,   0, 195,   0, 255,   0, 201,   0, 255,   0, 208,   0, 255,   0, 214,   0, 255,   0, 220,   0, 255,   0, 226,   0, 255,   0, 232,   0, 255,   0, 237,   0, 255,   0, 241,   0, 255,   0, 242,   0, 255,   0, 240,   0, 255,   0, 236,   0, 255,   0, 232,   0, 255,   0, 225,   0, 255,   0, 220,   0, 255,   0, 213,   0, 255,   0, 208,   0, 255,   0, 201,   0, 255,   0, 194,   0, 255,   0, 189,   0, 255,   0, 182,   0, 255,   0, 176,   0, 255,   0, 169,   0, 255,   0, 163,   0, 255,   0, 156,   0, 255,   0, 149,   0, 255,   0, 143,   0, 255,   0, 136,   0, 255,   0, 130,   0, 255,   0, 123,   0, 255,   0, 117,   0, 255,   0, 111,   0, 255,   0, 104,   0, 255,   0,  98,   0, 255,   0,  91,   0, 255,   0,  84,   0, 255,   0,  78,   0, 255,   0,  71,   0, 255,   0,  65,   0, 255,   0,  58,   0, 255,   0,  52,   0, 255,   0,  46,   0, 255,   0,  38,   0, 255,   0,  32,   0, 255,   0,  26,   0, 255,   0,  19,   0, 255,   0,  13,   0, 255,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   7,   0, 255,   0,  13,   0, 255,   0,  20,   0, 255,   0,  26,   0, 255,   0,  32,   0, 255,   0,  39,   0, 255,   0,  46,   0, 255,   0,  52,   0, 255,   0,  59,   0, 255,   0,  65,   0, 255,   0,  72,   0, 255,   0,  78,   0, 255,   0,  84,   0, 255,   0,  91,   0, 255,   0,  98,   0, 255,   0, 105,   0, 255,   0, 111,   0, 255,   0, 118,   0, 255,   0, 124,   0, 255,   0, 131,   0, 255,   0, 137,   0, 255,   0, 144,   0, 255,   0, 150,   0, 255,   0, 157,   0, 255,   0, 163,   0, 255,   0, 169,   0, 255,   0, 176,   0, 255,   0, 183,   0, 255,   0, 189,   0, 255,   0, 196,   0, 255,   0, 203,   0, 255,   0, 208,   0, 255,   0, 215,   0, 255,   0, 221,   0, 255,   0, 228,   0, 255,   0, 234,   0, 255,   0, 240,   0, 255,   0, 246,   0, 255,   0, 248,   0, 255,   0, 245,   0, 255,   0, 240,   0, 255,   0, 234,   0, 255,   0, 228,   0, 255,   0, 222,   0, 255,   0, 215,   0, 255,   0, 209,   0, 255,   0, 202,   0, 255,   0, 196,   0, 255,   0, 189,   0, 255,   0, 183,   0, 255,   0, 176,   0, 255,   0, 169,   0, 255,   0, 163,   0, 255,   0, 156,   0, 255,   0, 150,   0, 255,   0, 144,   0, 255,   0, 137,   0, 255,   0, 131,   0, 255,   0, 125,   0, 255,   0, 118,   0, 255,   0, 111,   0, 255,   0, 104,   0, 255,   0,  98,   0, 255,   0,  91,   0, 255,   0,  85,   0, 255,   0,  78,   0, 255,   0,  72,   0, 255,   0,  65,   0, 255,   0,  58,   0, 255,   0,  52,   0, 255,   0,  45,   0, 255,   0,  39,   0, 255,   0,  32,   0, 255,   0,  26,   0, 255,   0,  20,   0, 255,   0,  13,   0, 255,   0,   7,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   7,   0, 255,   0,  13,   0, 255,   0,  20,   0, 255,   0,  26,   0, 255,   0,  33,   0, 255,   0,  39,   0, 255,   0,  46,   0, 255,   0,  53,   0, 255,   0,  59,   0, 255,   0,  65,   0, 255,   0,  72,   0, 255,   0,  78,   0, 255,   0,  85,   0, 255,   0,  92,   0, 255,   0,  98,   0, 255,   0, 104,   0, 255,   0, 111,   0, 255,   0, 117,   0, 255,   0, 124,   0, 255,   0, 130,   0, 255,   0, 137,   0, 255,   0, 144,   0, 255,   0, 151,   0, 255,   0, 157,   0, 255,   0, 163,   0, 255,   0, 170,   0, 255,   0, 176,   0, 255,   0, 183,   0, 255,   0, 190,   0, 255,   0, 196,   0, 255,   0, 202,   0, 255,   0, 209,   0, 255,   0, 216,   0, 255,   0, 222,   0, 255,   0, 229,   0, 255,   0, 235,   0, 255,   0, 242,   0, 255,   0, 248,   0, 255,   0, 255,   0, 255,   0, 248,   0, 255,   0, 242,   0, 255,   0, 235,   0, 255,   0, 229,   0, 255,   0, 223,   0, 255,   0, 216,   0, 255,   0, 210,   0, 255,   0, 203,   0, 255,   0, 196,   0, 255,   0, 190,   0, 255,   0, 183,   0, 255,   0, 176,   0, 255,   0, 170,   0, 255,   0, 164,   0, 255,   0, 156,   0, 255,   0, 151,   0, 255,   0, 144,   0, 255,   0, 137,   0, 255,   0, 131,   0, 255,   0, 124,   0, 255,   0, 118,   0, 255,   0, 111,   0, 255,   0, 104,   0, 255,   0,  99,   0, 255,   0,  91,   0, 255,   0,  85,   0, 255,   0,  78,   0, 255,   0,  72,   0, 255,   0,  65,   0, 255,   0,  59,   0, 255,   0,  53,   0, 255,   0,  46,   0, 255,   0,  40,   0, 255,   0,  33,   0, 255,   0,  26,   0, 255,   0,  20,   0, 255,   0,  13,   0, 255,   0,   7,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   7,   0, 255,   0,  13,   0, 255,   0,  19,   0, 255,   0,  26,   0, 255,   0,  32,   0, 255,   0,  39,   0, 255,   0,  46,   0, 255,   0,  53,   0, 255,   0,  59,   0, 255,   0,  66,   0, 255,   0,  71,   0, 255,   0,  78,   0, 255,   0,  84,   0, 255,   0,  92,   0, 255,   0,  98,   0, 255,   0, 105,   0, 255,   0, 111,   0, 255,   0, 117,   0, 255,   0, 124,   0, 255,   0, 130,   0, 255,   0, 137,   0, 255,   0, 144,   0, 255,   0, 150,   0, 255,   0, 157,   0, 255,   0, 164,   0, 255,   0, 169,   0, 255,   0, 176,   0, 255,   0, 182,   0, 255,   0, 190,   0, 255,   0, 196,   0, 255,   0, 203,   0, 255,   0, 209,   0, 255,   0, 216,   0, 255,   0, 221,   0, 255,   0, 228,   0, 255,   0, 234,   0, 255,   0, 240,   0, 255,   0, 246,   0, 255,   0, 248,   0, 255,   0, 246,   0, 255,   0, 240,   0, 255,   0, 234,   0, 255,   0, 228,   0, 255,   0, 222,   0, 255,   0, 215,   0, 255,   0, 209,   0, 255,   0, 202,   0, 255,   0, 196,   0, 255,   0, 190,   0, 255,   0, 182,   0, 255,   0, 176,   0, 255,   0, 170,   0, 255,   0, 163,   0, 255,   0, 157,   0, 255,   0, 150,   0, 255,   0, 143,   0, 255,   0, 137,   0, 255,   0, 131,   0, 255,   0, 124,   0, 255,   0, 118,   0, 255,   0, 111,   0, 255,   0, 104,   0, 255,   0,  98,   0, 255,   0,  91,   0, 255,   0,  84,   0, 255,   0,  78,   0, 255,   0,  71,   0, 255,   0,  65,   0, 255,   0,  59,   0, 255,   0,  52,   0, 255,   0,  45,   0, 255,   0,  39,   0, 255,   0,  32,   0, 255,   0,  26,   0, 255,   0,  20,   0, 255,   0,  13,   0, 255,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   6,   0, 255,   0,  13,   0, 255,   0,  19,   0, 255,   0,  26,   0, 255,   0,  32,   0, 255,   0,  38,   0, 255,   0,  45,   0, 255,   0,  52,   0, 255,   0,  59,   0, 255,   0,  65,   0, 255,   0,  71,   0, 255,   0,  78,   0, 255,   0,  85,   0, 255,   0,  91,   0, 255,   0,  98,   0, 255,   0, 104,   0, 255,   0, 111,   0, 255,   0, 117,   0, 255,   0, 123,   0, 255,   0, 130,   0, 255,   0, 137,   0, 255,   0, 143,   0, 255,   0, 150,   0, 255,   0, 156,   0, 255,   0, 162,   0, 255,   0, 169,   0, 255,   0, 175,   0, 255,   0, 182,   0, 255,   0, 188,   0, 255,   0, 195,   0, 255,   0, 201,   0, 255,   0, 207,   0, 255,   0, 214,   0, 255,   0, 220,   0, 255,   0, 226,   0, 255,   0, 232,   0, 255,   0, 236,   0, 255,   0, 241,   0, 255,   0, 242,   0, 255,   0, 241,   0, 255,   0, 237,   0, 255,   0, 232,   0, 255,   0, 226,   0, 255,   0, 220,   0, 255,   0, 213,   0, 255,   0, 207,   0, 255,   0, 201,   0, 255,   0, 195,   0, 255,   0, 189,   0, 255,   0, 181,   0, 255,   0, 176,   0, 255,   0, 169,   0, 255,   0, 163,   0, 255,   0, 156,   0, 255,   0, 150,   0, 255,   0, 143,   0, 255,   0, 136,   0, 255,   0, 130,   0, 255,   0, 124,   0, 255,   0, 117,   0, 255,   0, 110,   0, 255,   0, 104,   0, 255,   0,  97,   0, 255,   0,  91,   0, 255,   0,  84,   0, 255,   0,  78,   0, 255,   0,  71,   0, 255,   0,  65,   0, 255,   0,  58,   0, 255,   0,  51,   0, 255,   0,  46,   0, 255,   0,  38,   0, 255,   0,  32,   0, 255,   0,  26,   0, 255,   0,  20,   0, 255,   0,  13,   0, 255,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   6,   0, 255,   0,  12,   0, 255,   0,  19,   0, 255,   0,  25,   0, 255,   0,  32,   0, 255,   0,  38,   0, 255,   0,  45,   0, 255,   0,  51,   0, 255,   0,  58,   0, 255,   0,  65,   0, 255,   0,  71,   0, 255,   0,  78,   0, 255,   0,  84,   0, 255,   0,  90,   0, 255,   0,  97,   0, 255,   0, 103,   0, 255,   0, 110,   0, 255,   0, 117,   0, 255,   0, 122,   0, 255,   0, 129,   0, 255,   0, 135,   0, 255,   0, 142,   0, 255,   0, 149,   0, 255,   0, 155,   0, 255,   0, 162,   0, 255,   0, 167,   0, 255,   0, 174,   0, 255,   0, 181,   0, 255,   0, 187,   0, 255,   0, 193,   0, 255,   0, 199,   0, 255,   0, 205,   0, 255,   0, 211,   0, 255,   0, 217,   0, 255,   0, 222,   0, 255,   0, 227,   0, 255,   0, 232,   0, 255,   0, 234,   0, 255,   0, 235,   0, 255,   0, 234,   0, 255,   0, 231,   0, 255,   0, 227,   0, 255,   0, 223,   0, 255,   0, 217,   0, 255,   0, 211,   0, 255,   0, 206,   0, 255,   0, 199,   0, 255,   0, 193,   0, 255,   0, 186,   0, 255,   0, 181,   0, 255,   0, 174,   0, 255,   0, 168,   0, 255,   0, 162,   0, 255,   0, 155,   0, 255,   0, 149,   0, 255,   0, 142,   0, 255,   0, 135,   0, 255,   0, 129,   0, 255,   0, 123,   0, 255,   0, 116,   0, 255,   0, 110,   0, 255,   0, 103,   0, 255,   0,  96,   0, 255,   0,  90,   0, 255,   0,  84,   0, 255,   0,  77,   0, 255,   0,  71,   0, 255,   0,  64,   0, 255,   0,  58,   0, 255,   0,  52,   0, 255,   0,  45,   0, 255,   0,  39,   0, 255,   0,  32,   0, 255,   0,  25,   0, 255,   0,  19,   0, 255,   0,  12,   0, 255,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   6,   0, 255,   0,  12,   0, 255,   0,  19,   0, 255,   0,  24,   0, 255,   0,  31,   0, 255,   0,  37,   0, 255,   0,  44,   0, 255,   0,  50,   0, 255,   0,  57,   0, 255,   0,  64,   0, 255,   0,  70,   0, 255,   0,  77,   0, 255,   0,  83,   0, 255,   0,  90,   0, 255,   0,  96,   0, 255,   0, 102,   0, 255,   0, 108,   0, 255,   0, 115,   0, 255,   0, 122,   0, 255,   0, 128,   0, 255,   0, 134,   0, 255,   0, 140,   0, 255,   0, 147,   0, 255,   0, 153,   0, 255,   0, 160,   0, 255,   0, 166,   0, 255,   0, 173,   0, 255,   0, 179,   0, 255,   0, 184,   0, 255,   0, 191,   0, 255,   0, 196,   0, 255,   0, 203,   0, 255,   0, 208,   0, 255,   0, 214,   0, 255,   0, 218,   0, 255,   0, 222,   0, 255,   0, 226,   0, 255,   0, 228,   0, 255,   0, 229,   0, 255,   0, 228,   0, 255,   0, 226,   0, 255,   0, 222,   0, 255,   0, 218,   0, 255,   0, 213,   0, 255,   0, 208,   0, 255,   0, 202,   0, 255,   0, 197,   0, 255,   0, 191,   0, 255,   0, 185,   0, 255,   0, 179,   0, 255,   0, 173,   0, 255,   0, 166,   0, 255,   0, 160,   0, 255,   0, 153,   0, 255,   0, 147,   0, 255,   0, 141,   0, 255,   0, 135,   0, 255,   0, 128,   0, 255,   0, 121,   0, 255,   0, 115,   0, 255,   0, 108,   0, 255,   0, 103,   0, 255,   0,  96,   0, 255,   0,  90,   0, 255,   0,  83,   0, 255,   0,  76,   0, 255,   0,  70,   0, 255,   0,  63,   0, 255,   0,  57,   0, 255,   0,  51,   0, 255,   0,  44,   0, 255,   0,  38,   0, 255,   0,  31,   0, 255,   0,  24,   0, 255,   0,  18,   0, 255,   0,  11,   0, 255,   0,   5,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   5,   0, 255,   0,  11,   0, 255,   0,  17,   0, 255,   0,  23,   0, 255,   0,  31,   0, 255,   0,  37,   0, 255,   0,  43,   0, 255,   0,  50,   0, 255,   0,  56,   0, 255,   0,  62,   0, 255,   0,  69,   0, 255,   0,  75,   0, 255,   0,  82,   0, 255,   0,  88,   0, 255,   0,  95,   0, 255,   0, 101,   0, 255,   0, 108,   0, 255,   0, 114,   0, 255,   0, 120,   0, 255,   0, 127,   0, 255,   0, 132,   0, 255,   0, 140,   0, 255,   0, 146,   0, 255,   0, 152,   0, 255,   0, 158,   0, 255,   0, 164,   0, 255,   0, 170,   0, 255,   0, 176,   0, 255,   0, 182,   0, 255,   0, 187,   0, 255,   0, 194,   0, 255,   0, 198,   0, 255,   0, 203,   0, 255,   0, 209,   0, 255,   0, 213,   0, 255,   0, 217,   0, 255,   0, 220,   0, 255,   0, 222,   0, 255,   0, 222,   0, 255,   0, 222,   0, 255,   0, 219,   0, 255,   0, 217,   0, 255,   0, 213,   0, 255,   0, 209,   0, 255,   0, 204,   0, 255,   0, 199,   0, 255,   0, 193,   0, 255,   0, 187,   0, 255,   0, 182,   0, 255,   0, 176,   0, 255,   0, 170,   0, 255,   0, 164,   0, 255,   0, 158,   0, 255,   0, 151,   0, 255,   0, 146,   0, 255,   0, 140,   0, 255,   0, 132,   0, 255,   0, 126,   0, 255,   0, 120,   0, 255,   0, 113,   0, 255,   0, 107,   0, 255,   0, 101,   0, 255,   0,  94,   0, 255,   0,  88,   0, 255,   0,  82,   0, 255,   0,  76,   0, 255,   0,  69,   0, 255,   0,  63,   0, 255,   0,  57,   0, 255,   0,  50,   0, 255,   0,  43,   0, 255,   0,  36,   0, 255,   0,  30,   0, 255,   0,  24,   0, 255,   0,  18,   0, 255,   0,  11,   0, 255,   0,   5,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   4,   0, 255,   0,  10,   0, 255,   0,  16,   0, 255,   0,  23,   0, 255,   0,  29,   0, 255,   0,  36,   0, 255,   0,  42,   0, 255,   0,  48,   0, 255,   0,  55,   0, 255,   0,  62,   0, 255,   0,  68,   0, 255,   0,  75,   0, 255,   0,  81,   0, 255,   0,  87,   0, 255,   0,  93,   0, 255,   0,  99,   0, 255,   0, 106,   0, 255,   0, 112,   0, 255,   0, 118,   0, 255,   0, 125,   0, 255,   0, 131,   0, 255,   0, 137,   0, 255,   0, 144,   0, 255,   0, 149,   0, 255,   0, 156,   0, 255,   0, 161,   0, 255,   0, 167,   0, 255,   0, 173,   0, 255,   0, 179,   0, 255,   0, 184,   0, 255,   0, 190,   0, 255,   0, 195,   0, 255,   0, 199,   0, 255,   0, 204,   0, 255,   0, 208,   0, 255,   0, 211,   0, 255,   0, 214,   0, 255,   0, 215,   0, 255,   0, 215,   0, 255,   0, 215,   0, 255,   0, 213,   0, 255,   0, 211,   0, 255,   0, 207,   0, 255,   0, 204,   0, 255,   0, 200,   0, 255,   0, 195,   0, 255,   0, 189,   0, 255,   0, 184,   0, 255,   0, 179,   0, 255,   0, 173,   0, 255,   0, 167,   0, 255,   0, 162,   0, 255,   0, 155,   0, 255,   0, 149,   0, 255,   0, 143,   0, 255,   0, 137,   0, 255,   0, 131,   0, 255,   0, 125,   0, 255,   0, 118,   0, 255,   0, 112,   0, 255,   0, 106,   0, 255,   0, 100,   0, 255,   0,  93,   0, 255,   0,  87,   0, 255,   0,  80,   0, 255,   0,  74,   0, 255,   0,  68,   0, 255,   0,  61,   0, 255,   0,  55,   0, 255,   0,  48,   0, 255,   0,  43,   0, 255,   0,  35,   0, 255,   0,  29,   0, 255,   0,  22,   0, 255,   0,  16,   0, 255,   0,  10,   0, 255,   0,   3,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   2,   0, 255,   0,   8,   0, 255,   0,  16,   0, 255,   0,  22,   0, 255,   0,  28,   0, 255,   0,  34,   0, 255,   0,  41,   0, 255,   0,  48,   0, 255,   0,  54,   0, 255,   0,  60,   0, 255,   0,  66,   0, 255,   0,  73,   0, 255,   0,  79,   0, 255,   0,  85,   0, 255,   0,  91,   0, 255,   0,  98,   0, 255,   0, 105,   0, 255,   0, 110,   0, 255,   0, 116,   0, 255,   0, 123,   0, 255,   0, 128,   0, 255,   0, 135,   0, 255,   0, 141,   0, 255,   0, 146,   0, 255,   0, 153,   0, 255,   0, 158,   0, 255,   0, 164,   0, 255,   0, 169,   0, 255,   0, 176,   0, 255,   0, 180,   0, 255,   0, 185,   0, 255,   0, 190,   0, 255,   0, 194,   0, 255,   0, 199,   0, 255,   0, 202,   0, 255,   0, 206,   0, 255,   0, 207,   0, 255,   0, 208,   0, 255,   0, 209,   0, 255,   0, 208,   0, 255,   0, 207,   0, 255,   0, 205,   0, 255,   0, 202,   0, 255,   0, 198,   0, 255,   0, 194,   0, 255,   0, 191,   0, 255,   0, 186,   0, 255,   0, 181,   0, 255,   0, 175,   0, 255,   0, 170,   0, 255,   0, 164,   0, 255,   0, 158,   0, 255,   0, 153,   0, 255,   0, 147,   0, 255,   0, 141,   0, 255,   0, 135,   0, 255,   0, 129,   0, 255,   0, 123,   0, 255,   0, 116,   0, 255,   0, 111,   0, 255,   0, 104,   0, 255,   0,  98,   0, 255,   0,  92,   0, 255,   0,  85,   0, 255,   0,  78,   0, 255,   0,  73,   0, 255,   0,  66,   0, 255,   0,  60,   0, 255,   0,  54,   0, 255,   0,  48,   0, 255,   0,  41,   0, 255,   0,  34,   0, 255,   0,  28,   0, 255,   0,  22,   0, 255,   0,  16,   0, 255,   0,   8,   0, 255,   0,   2,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   8,   0, 255,   0,  14,   0, 255,   0,  20,   0, 255,   0,  26,   0, 255,   0,  33,   0, 255,   0,  39,   0, 255,   0,  46,   0, 255,   0,  52,   0, 255,   0,  59,   0, 255,   0,  65,   0, 255,   0,  71,   0, 255,   0,  77,   0, 255,   0,  84,   0, 255,   0,  89,   0, 255,   0,  96,   0, 255,   0, 102,   0, 255,   0, 108,   0, 255,   0, 114,   0, 255,   0, 120,   0, 255,   0, 126,   0, 255,   0, 133,   0, 255,   0, 138,   0, 255,   0, 144,   0, 255,   0, 150,   0, 255,   0, 155,   0, 255,   0, 160,   0, 255,   0, 166,   0, 255,   0, 172,   0, 255,   0, 177,   0, 255,   0, 181,   0, 255,   0, 186,   0, 255,   0, 190,   0, 255,   0, 193,   0, 255,   0, 197,   0, 255,   0, 199,   0, 255,   0, 201,   0, 255,   0, 202,   0, 255,   0, 203,   0, 255,   0, 203,   0, 255,   0, 201,   0, 255,   0, 199,   0, 255,   0, 196,   0, 255,   0, 194,   0, 255,   0, 190,   0, 255,   0, 186,   0, 255,   0, 181,   0, 255,   0, 176,   0, 255,   0, 172,   0, 255,   0, 166,   0, 255,   0, 160,   0, 255,   0, 155,   0, 255,   0, 150,   0, 255,   0, 144,   0, 255,   0, 138,   0, 255,   0, 132,   0, 255,   0, 126,   0, 255,   0, 120,   0, 255,   0, 115,   0, 255,   0, 108,   0, 255,   0, 102,   0, 255,   0,  96,   0, 255,   0,  90,   0, 255,   0,  83,   0, 255,   0,  77,   0, 255,   0,  71,   0, 255,   0,  64,   0, 255,   0,  58,   0, 255,   0,  52,   0, 255,   0,  46,   0, 255,   0,  39,   0, 255,   0,  33,   0, 255,   0,  26,   0, 255,   0,  20,   0, 255,   0,  13,   0, 255,   0,   7,   0, 255,   0,   1,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   6,   0, 255,   0,  12,   0, 255,   0,  18,   0, 255,   0,  25,   0, 255,   0,  31,   0, 255,   0,  38,   0, 255,   0,  44,   0, 255,   0,  50,   0, 255,   0,  56,   0, 255,   0,  62,   0, 255,   0,  69,   0, 255,   0,  75,   0, 255,   0,  81,   0, 255,   0,  88,   0, 255,   0,  94,   0, 255,   0, 100,   0, 255,   0, 105,   0, 255,   0, 111,   0, 255,   0, 117,   0, 255,   0, 123,   0, 255,   0, 129,   0, 255,   0, 135,   0, 255,   0, 141,   0, 255,   0, 147,   0, 255,   0, 152,   0, 255,   0, 157,   0, 255,   0, 162,   0, 255,   0, 167,   0, 255,   0, 172,   0, 255,   0, 176,   0, 255,   0, 181,   0, 255,   0, 185,   0, 255,   0, 188,   0, 255,   0, 191,   0, 255,   0, 193,   0, 255,   0, 195,   0, 255,   0, 196,   0, 255,   0, 196,   0, 255,   0, 195,   0, 255,   0, 194,   0, 255,   0, 193,   0, 255,   0, 191,   0, 255,   0, 188,   0, 255,   0, 184,   0, 255,   0, 181,   0, 255,   0, 177,   0, 255,   0, 172,   0, 255,   0, 167,   0, 255,   0, 163,   0, 255,   0, 157,   0, 255,   0, 152,   0, 255,   0, 146,   0, 255,   0, 141,   0, 255,   0, 135,   0, 255,   0, 130,   0, 255,   0, 123,   0, 255,   0, 117,   0, 255,   0, 112,   0, 255,   0, 106,   0, 255,   0,  99,   0, 255,   0,  94,   0, 255,   0,  88,   0, 255,   0,  82,   0, 255,   0,  75,   0, 255,   0,  69,   0, 255,   0,  62,   0, 255,   0,  56,   0, 255,   0,  50,   0, 255,   0,  44,   0, 255,   0,  37,   0, 255,   0,  31,   0, 255,   0,  25,   0, 255,   0,  19,   0, 255,   0,  13,   0, 255,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   5,   0, 255,   0,  11,   0, 255,   0,  17,   0, 255,   0,  23,   0, 255,   0,  29,   0, 255,   0,  36,   0, 255,   0,  42,   0, 255,   0,  48,   0, 255,   0,  55,   0, 255,   0,  61,   0, 255,   0,  67,   0, 255,   0,  73,   0, 255,   0,  79,   0, 255,   0,  85,   0, 255,   0,  91,   0, 255,   0,  97,   0, 255,   0, 102,   0, 255,   0, 108,   0, 255,   0, 115,   0, 255,   0, 121,   0, 255,   0, 126,   0, 255,   0, 132,   0, 255,   0, 137,   0, 255,   0, 143,   0, 255,   0, 148,   0, 255,   0, 153,   0, 255,   0, 158,   0, 255,   0, 163,   0, 255,   0, 167,   0, 255,   0, 171,   0, 255,   0, 175,   0, 255,   0, 179,   0, 255,   0, 181,   0, 255,   0, 184,   0, 255,   0, 187,   0, 255,   0, 188,   0, 255,   0, 189,   0, 255,   0, 190,   0, 255,   0, 189,   0, 255,   0, 188,   0, 255,   0, 187,   0, 255,   0, 185,   0, 255,   0, 181,   0, 255,   0, 179,   0, 255,   0, 176,   0, 255,   0, 172,   0, 255,   0, 167,   0, 255,   0, 162,   0, 255,   0, 158,   0, 255,   0, 152,   0, 255,   0, 147,   0, 255,   0, 143,   0, 255,   0, 138,   0, 255,   0, 131,   0, 255,   0, 126,   0, 255,   0, 120,   0, 255,   0, 115,   0, 255,   0, 109,   0, 255,   0, 102,   0, 255,   0,  97,   0, 255,   0,  91,   0, 255,   0,  85,   0, 255,   0,  79,   0, 255,   0,  72,   0, 255,   0,  67,   0, 255,   0,  60,   0, 255,   0,  54,   0, 255,   0,  48,   0, 255,   0,  42,   0, 255,   0,  35,   0, 255,   0,  30,   0, 255,   0,  23,   0, 255,   0,  17,   0, 255,   0,  10,   0, 255,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   2,   0, 255,   0,   9,   0, 255,   0,  15,   0, 255,   0,  21,   0, 255,   0,  27,   0, 255,   0,  34,   0, 255,   0,  40,   0, 255,   0,  46,   0, 255,   0,  52,   0, 255,   0,  58,   0, 255,   0,  65,   0, 255,   0,  71,   0, 255,   0,  76,   0, 255,   0,  83,   0, 255,   0,  88,   0, 255,   0,  94,   0, 255,   0, 100,   0, 255,   0, 105,   0, 255,   0, 111,   0, 255,   0, 117,   0, 255,   0, 122,   0, 255,   0, 128,   0, 255,   0, 134,   0, 255,   0, 139,   0, 255,   0, 144,   0, 255,   0, 149,   0, 255,   0, 154,   0, 255,   0, 158,   0, 255,   0, 162,   0, 255,   0, 166,   0, 255,   0, 170,   0, 255,   0, 173,   0, 255,   0, 176,   0, 255,   0, 179,   0, 255,   0, 180,   0, 255,   0, 182,   0, 255,   0, 183,   0, 255,   0, 183,   0, 255,   0, 183,   0, 255,   0, 182,   0, 255,   0, 180,   0, 255,   0, 179,   0, 255,   0, 176,   0, 255,   0, 173,   0, 255,   0, 169,   0, 255,   0, 166,   0, 255,   0, 162,   0, 255,   0, 157,   0, 255,   0, 153,   0, 255,   0, 149,   0, 255,   0, 144,   0, 255,   0, 138,   0, 255,   0, 134,   0, 255,   0, 128,   0, 255,   0, 122,   0, 255,   0, 117,   0, 255,   0, 112,   0, 255,   0, 106,   0, 255,   0, 100,   0, 255,   0,  94,   0, 255,   0,  89,   0, 255,   0,  83,   0, 255,   0,  77,   0, 255,   0,  70,   0, 255,   0,  65,   0, 255,   0,  58,   0, 255,   0,  52,   0, 255,   0,  46,   0, 255,   0,  40,   0, 255,   0,  34,   0, 255,   0,  27,   0, 255,   0,  22,   0, 255,   0,  15,   0, 255,   0,   9,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   7,   0, 255,   0,  13,   0, 255,   0,  19,   0, 255,   0,  26,   0, 255,   0,  32,   0, 255,   0,  37,   0, 255,   0,  44,   0, 255,   0,  50,   0, 255,   0,  56,   0, 255,   0,  62,   0, 255,   0,  68,   0, 255,   0,  74,   0, 255,   0,  79,   0, 255,   0,  86,   0, 255,   0,  91,   0, 255,   0,  97,   0, 255,   0, 102,   0, 255,   0, 108,   0, 255,   0, 113,   0, 255,   0, 119,   0, 255,   0, 124,   0, 255,   0, 129,   0, 255,   0, 135,   0, 255,   0, 139,   0, 255,   0, 145,   0, 255,   0, 148,   0, 255,   0, 153,   0, 255,   0, 157,   0, 255,   0, 161,   0, 255,   0, 165,   0, 255,   0, 168,   0, 255,   0, 170,   0, 255,   0, 172,   0, 255,   0, 174,   0, 255,   0, 176,   0, 255,   0, 176,   0, 255,   0, 177,   0, 255,   0, 176,   0, 255,   0, 175,   0, 255,   0, 175,   0, 255,   0, 173,   0, 255,   0, 170,   0, 255,   0, 167,   0, 255,   0, 164,   0, 255,   0, 161,   0, 255,   0, 157,   0, 255,   0, 153,   0, 255,   0, 149,   0, 255,   0, 144,   0, 255,   0, 140,   0, 255,   0, 135,   0, 255,   0, 129,   0, 255,   0, 124,   0, 255,   0, 118,   0, 255,   0, 114,   0, 255,   0, 109,   0, 255,   0, 102,   0, 255,   0,  97,   0, 255,   0,  91,   0, 255,   0,  85,   0, 255,   0,  80,   0, 255,   0,  73,   0, 255,   0,  68,   0, 255,   0,  62,   0, 255,   0,  56,   0, 255,   0,  50,   0, 255,   0,  44,   0, 255,   0,  37,   0, 255,   0,  31,   0, 255,   0,  25,   0, 255,   0,  19,   0, 255,   0,  13,   0, 255,   0,   7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   5,   0, 255,   0,  11,   0, 255,   0,  17,   0, 255,   0,  23,   0, 255,   0,  29,   0, 255,   0,  35,   0, 255,   0,  41,   0, 255,   0,  47,   0, 255,   0,  53,   0, 255,   0,  59,   0, 255,   0,  65,   0, 255,   0,  70,   0, 255,   0,  76,   0, 255,   0,  82,   0, 255,   0,  88,   0, 255,   0,  94,   0, 255,   0,  99,   0, 255,   0, 105,   0, 255,   0, 110,   0, 255,   0, 115,   0, 255,   0, 120,   0, 255,   0, 126,   0, 255,   0, 130,   0, 255,   0, 134,   0, 255,   0, 139,   0, 255,   0, 144,   0, 255,   0, 148,   0, 255,   0, 152,   0, 255,   0, 155,   0, 255,   0, 159,   0, 255,   0, 162,   0, 255,   0, 164,   0, 255,   0, 166,   0, 255,   0, 167,   0, 255,   0, 169,   0, 255,   0, 170,   0, 255,   0, 170,   0, 255,   0, 170,   0, 255,   0, 169,   0, 255,   0, 167,   0, 255,   0, 166,   0, 255,   0, 164,   0, 255,   0, 161,   0, 255,   0, 158,   0, 255,   0, 156,   0, 255,   0, 151,   0, 255,   0, 148,   0, 255,   0, 143,   0, 255,   0, 139,   0, 255,   0, 135,   0, 255,   0, 130,   0, 255,   0, 125,   0, 255,   0, 121,   0, 255,   0, 115,   0, 255,   0, 110,   0, 255,   0, 104,   0, 255,   0,  99,   0, 255,   0,  94,   0, 255,   0,  88,   0, 255,   0,  82,   0, 255,   0,  76,   0, 255,   0,  71,   0, 255,   0,  65,   0, 255,   0,  59,   0, 255,   0,  53,   0, 255,   0,  47,   0, 255,   0,  42,   0, 255,   0,  35,   0, 255,   0,  29,   0, 255,   0,  23,   0, 255,   0,  17,   0, 255,   0,  11,   0, 255,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   2,   0, 255,   0,   8,   0, 255,   0,  15,   0, 255,   0,  21,   0, 255,   0,  27,   0, 255,   0,  33,   0, 255,   0,  38,   0, 255,   0,  44,   0, 255,   0,  50,   0, 255,   0,  56,   0, 255,   0,  62,   0, 255,   0,  68,   0, 255,   0,  74,   0, 255,   0,  79,   0, 255,   0,  85,   0, 255,   0,  90,   0, 255,   0,  95,   0, 255,   0, 101,   0, 255,   0, 106,   0, 255,   0, 111,   0, 255,   0, 116,   0, 255,   0, 120,   0, 255,   0, 125,   0, 255,   0, 131,   0, 255,   0, 135,   0, 255,   0, 138,   0, 255,   0, 142,   0, 255,   0, 146,   0, 255,   0, 150,   0, 255,   0, 152,   0, 255,   0, 155,   0, 255,   0, 158,   0, 255,   0, 159,   0, 255,   0, 162,   0, 255,   0, 163,   0, 255,   0, 163,   0, 255,   0, 164,   0, 255,   0, 164,   0, 255,   0, 163,   0, 255,   0, 162,   0, 255,   0, 160,   0, 255,   0, 158,   0, 255,   0, 155,   0, 255,   0, 153,   0, 255,   0, 150,   0, 255,   0, 146,   0, 255,   0, 143,   0, 255,   0, 139,   0, 255,   0, 134,   0, 255,   0, 130,   0, 255,   0, 126,   0, 255,   0, 121,   0, 255,   0, 116,   0, 255,   0, 111,   0, 255,   0, 105,   0, 255,   0, 101,   0, 255,   0,  95,   0, 255,   0,  90,   0, 255,   0,  85,   0, 255,   0,  79,   0, 255,   0,  74,   0, 255,   0,  68,   0, 255,   0,  62,   0, 255,   0,  56,   0, 255,   0,  50,   0, 255,   0,  44,   0, 255,   0,  38,   0, 255,   0,  32,   0, 255,   0,  27,   0, 255,   0,  21,   0, 255,   0,  14,   0, 255,   0,   9,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   6,   0, 255,   0,  12,   0, 255,   0,  18,   0, 255,   0,  24,   0, 255,   0,  30,   0, 255,   0,  36,   0, 255,   0,  42,   0, 255,   0,  48,   0, 255,   0,  53,   0, 255,   0,  59,   0, 255,   0,  65,   0, 255,   0,  70,   0, 255,   0,  75,   0, 255,   0,  81,   0, 255,   0,  86,   0, 255,   0,  91,   0, 255,   0,  97,   0, 255,   0, 102,   0, 255,   0, 107,   0, 255,   0, 112,   0, 255,   0, 116,   0, 255,   0, 121,   0, 255,   0, 126,   0, 255,   0, 130,   0, 255,   0, 133,   0, 255,   0, 138,   0, 255,   0, 140,   0, 255,   0, 144,   0, 255,   0, 147,   0, 255,   0, 149,   0, 255,   0, 152,   0, 255,   0, 153,   0, 255,   0, 155,   0, 255,   0, 156,   0, 255,   0, 157,   0, 255,   0, 157,   0, 255,   0, 157,   0, 255,   0, 156,   0, 255,   0, 155,   0, 255,   0, 153,   0, 255,   0, 152,   0, 255,   0, 149,   0, 255,   0, 147,   0, 255,   0, 143,   0, 255,   0, 140,   0, 255,   0, 137,   0, 255,   0, 133,   0, 255,   0, 130,   0, 255,   0, 126,   0, 255,   0, 121,   0, 255,   0, 116,   0, 255,   0, 112,   0, 255,   0, 107,   0, 255,   0, 102,   0, 255,   0,  96,   0, 255,   0,  92,   0, 255,   0,  86,   0, 255,   0,  81,   0, 255,   0,  75,   0, 255,   0,  70,   0, 255,   0,  64,   0, 255,   0,  58,   0, 255,   0,  53,   0, 255,   0,  47,   0, 255,   0,  42,   0, 255,   0,  35,   0, 255,   0,  30,   0, 255,   0,  24,   0, 255,   0,  18,   0, 255,   0,  12,   0, 255,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   9,   0, 255,   0,  15,   0, 255,   0,  21,   0, 255,   0,  27,   0, 255,   0,  32,   0, 255,   0,  38,   0, 255,   0,  45,   0, 255,   0,  50,   0, 255,   0,  56,   0, 255,   0,  61,   0, 255,   0,  66,   0, 255,   0,  71,   0, 255,   0,  77,   0, 255,   0,  83,   0, 255,   0,  87,   0, 255,   0,  93,   0, 255,   0,  98,   0, 255,   0, 103,   0, 255,   0, 107,   0, 255,   0, 112,   0, 255,   0, 116,   0, 255,   0, 121,   0, 255,   0, 124,   0, 255,   0, 128,   0, 255,   0, 132,   0, 255,   0, 135,   0, 255,   0, 138,   0, 255,   0, 140,   0, 255,   0, 144,   0, 255,   0, 145,   0, 255,   0, 148,   0, 255,   0, 149,   0, 255,   0, 150,   0, 255,   0, 150,   0, 255,   0, 151,   0, 255,   0, 150,   0, 255,   0, 149,   0, 255,   0, 148,   0, 255,   0, 148,   0, 255,   0, 145,   0, 255,   0, 143,   0, 255,   0, 141,   0, 255,   0, 138,   0, 255,   0, 135,   0, 255,   0, 132,   0, 255,   0, 128,   0, 255,   0, 124,   0, 255,   0, 120,   0, 255,   0, 116,   0, 255,   0, 112,   0, 255,   0, 108,   0, 255,   0, 102,   0, 255,   0,  97,   0, 255,   0,  93,   0, 255,   0,  87,   0, 255,   0,  83,   0, 255,   0,  77,   0, 255,   0,  72,   0, 255,   0,  66,   0, 255,   0,  61,   0, 255,   0,  55,   0, 255,   0,  50,   0, 255,   0,  45,   0, 255,   0,  39,   0, 255,   0,  33,   0, 255,   0,  27,   0, 255,   0,  22,   0, 255,   0,  15,   0, 255,   0,   9,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   7,   0, 255,   0,  12,   0, 255,   0,  18,   0, 255,   0,  24,   0, 255,   0,  29,   0, 255,   0,  35,   0, 255,   0,  40,   0, 255,   0,  47,   0, 255,   0,  52,   0, 255,   0,  58,   0, 255,   0,  63,   0, 255,   0,  68,   0, 255,   0,  73,   0, 255,   0,  78,   0, 255,   0,  84,   0, 255,   0,  88,   0, 255,   0,  93,   0, 255,   0,  98,   0, 255,   0, 102,   0, 255,   0, 107,   0, 255,   0, 111,   0, 255,   0, 115,   0, 255,   0, 119,   0, 255,   0, 123,   0, 255,   0, 126,   0, 255,   0, 129,   0, 255,   0, 132,   0, 255,   0, 135,   0, 255,   0, 137,   0, 255,   0, 139,   0, 255,   0, 140,   0, 255,   0, 142,   0, 255,   0, 143,   0, 255,   0, 144,   0, 255,   0, 144,   0, 255,   0, 143,   0, 255,   0, 143,   0, 255,   0, 142,   0, 255,   0, 141,   0, 255,   0, 139,   0, 255,   0, 137,   0, 255,   0, 134,   0, 255,   0, 132,   0, 255,   0, 130,   0, 255,   0, 126,   0, 255,   0, 123,   0, 255,   0, 119,   0, 255,   0, 115,   0, 255,   0, 111,   0, 255,   0, 107,   0, 255,   0, 103,   0, 255,   0,  98,   0, 255,   0,  93,   0, 255,   0,  89,   0, 255,   0,  83,   0, 255,   0,  79,   0, 255,   0,  74,   0, 255,   0,  68,   0, 255,   0,  63,   0, 255,   0,  57,   0, 255,   0,  52,   0, 255,   0,  46,   0, 255,   0,  41,   0, 255,   0,  35,   0, 255,   0,  30,   0, 255,   0,  24,   0, 255,   0,  18,   0, 255,   0,  12,   0, 255,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   4,   0, 255,   0,   9,   0, 255,   0,  15,   0, 255,   0,  21,   0, 255,   0,  26,   0, 255,   0,  32,   0, 255,   0,  37,   0, 255,   0,  43,   0, 255,   0,  48,   0, 255,   0,  53,   0, 255,   0,  59,   0, 255,   0,  64,   0, 255,   0,  69,   0, 255,   0,  74,   0, 255,   0,  79,   0, 255,   0,  84,   0, 255,   0,  88,   0, 255,   0,  93,   0, 255,   0,  98,   0, 255,   0, 102,   0, 255,   0, 106,   0, 255,   0, 110,   0, 255,   0, 113,   0, 255,   0, 117,   0, 255,   0, 120,   0, 255,   0, 123,   0, 255,   0, 127,   0, 255,   0, 129,   0, 255,   0, 131,   0, 255,   0, 133,   0, 255,   0, 134,   0, 255,   0, 135,   0, 255,   0, 137,   0, 255,   0, 137,   0, 255,   0, 137,   0, 255,   0, 137,   0, 255,   0, 137,   0, 255,   0, 136,   0, 255,   0, 134,   0, 255,   0, 133,   0, 255,   0, 131,   0, 255,   0, 129,   0, 255,   0, 126,   0, 255,   0, 124,   0, 255,   0, 120,   0, 255,   0, 117,   0, 255,   0, 114,   0, 255,   0, 110,   0, 255,   0, 106,   0, 255,   0, 101,   0, 255,   0,  98,   0, 255,   0,  93,   0, 255,   0,  88,   0, 255,   0,  84,   0, 255,   0,  79,   0, 255,   0,  75,   0, 255,   0,  69,   0, 255,   0,  64,   0, 255,   0,  59,   0, 255,   0,  53,   0, 255,   0,  49,   0, 255,   0,  43,   0, 255,   0,  37,   0, 255,   0,  32,   0, 255,   0,  26,   0, 255,   0,  21,   0, 255,   0,  15,   0, 255,   0,  10,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   6,   0, 255,   0,  12,   0, 255,   0,  18,   0, 255,   0,  23,   0, 255,   0,  28,   0, 255,   0,  33,   0, 255,   0,  40,   0, 255,   0,  45,   0, 255,   0,  50,   0, 255,   0,  55,   0, 255,   0,  60,   0, 255,   0,  65,   0, 255,   0,  69,   0, 255,   0,  75,   0, 255,   0,  79,   0, 255,   0,  83,   0, 255,   0,  89,   0, 255,   0,  92,   0, 255,   0,  97,   0, 255,   0, 101,   0, 255,   0, 105,   0, 255,   0, 108,   0, 255,   0, 111,   0, 255,   0, 114,   0, 255,   0, 118,   0, 255,   0, 120,   0, 255,   0, 123,   0, 255,   0, 125,   0, 255,   0, 127,   0, 255,   0, 128,   0, 255,   0, 130,   0, 255,   0, 130,   0, 255,   0, 130,   0, 255,   0, 131,   0, 255,   0, 130,   0, 255,   0, 131,   0, 255,   0, 129,   0, 255,   0, 128,   0, 255,   0, 127,   0, 255,   0, 125,   0, 255,   0, 122,   0, 255,   0, 120,   0, 255,   0, 118,   0, 255,   0, 115,   0, 255,   0, 111,   0, 255,   0, 108,   0, 255,   0, 105,   0, 255,   0, 100,   0, 255,   0,  97,   0, 255,   0,  93,   0, 255,   0,  88,   0, 255,   0,  84,   0, 255,   0,  79,   0, 255,   0,  74,   0, 255,   0,  70,   0, 255,   0,  65,   0, 255,   0,  60,   0, 255,   0,  55,   0, 255,   0,  50,   0, 255,   0,  45,   0, 255,   0,  39,   0, 255,   0,  33,   0, 255,   0,  28,   0, 255,   0,  23,   0, 255,   0,  17,   0, 255,   0,  11,   0, 255,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   8,   0, 255,   0,  14,   0, 255,   0,  19,   0, 255,   0,  25,   0, 255,   0,  30,   0, 255,   0,  35,   0, 255,   0,  41,   0, 255,   0,  45,   0, 255,   0,  51,   0, 255,   0,  56,   0, 255,   0,  61,   0, 255,   0,  66,   0, 255,   0,  70,   0, 255,   0,  75,   0, 255,   0,  79,   0, 255,   0,  84,   0, 255,   0,  88,   0, 255,   0,  92,   0, 255,   0,  96,   0, 255,   0,  99,   0, 255,   0, 102,   0, 255,   0, 106,   0, 255,   0, 109,   0, 255,   0, 112,   0, 255,   0, 114,   0, 255,   0, 117,   0, 255,   0, 119,   0, 255,   0, 120,   0, 255,   0, 122,   0, 255,   0, 123,   0, 255,   0, 124,   0, 255,   0, 124,   0, 255,   0, 124,   0, 255,   0, 124,   0, 255,   0, 124,   0, 255,   0, 123,   0, 255,   0, 121,   0, 255,   0, 121,   0, 255,   0, 119,   0, 255,   0, 117,   0, 255,   0, 114,   0, 255,   0, 111,   0, 255,   0, 109,   0, 255,   0, 106,   0, 255,   0, 103,   0, 255,   0,  99,   0, 255,   0,  95,   0, 255,   0,  92,   0, 255,   0,  88,   0, 255,   0,  84,   0, 255,   0,  79,   0, 255,   0,  74,   0, 255,   0,  70,   0, 255,   0,  65,   0, 255,   0,  61,   0, 255,   0,  55,   0, 255,   0,  51,   0, 255,   0,  46,   0, 255,   0,  40,   0, 255,   0,  35,   0, 255,   0,  30,   0, 255,   0,  25,   0, 255,   0,  19,   0, 255,   0,  14,   0, 255,   0,   8,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   4,   0, 255,   0,  10,   0, 255,   0,  16,   0, 255,   0,  21,   0, 255,   0,  26,   0, 255,   0,  31,   0, 255,   0,  37,   0, 255,   0,  41,   0, 255,   0,  46,   0, 255,   0,  51,   0, 255,   0,  57,   0, 255,   0,  61,   0, 255,   0,  65,   0, 255,   0,  70,   0, 255,   0,  74,   0, 255,   0,  78,   0, 255,   0,  83,   0, 255,   0,  86,   0, 255,   0,  90,   0, 255,   0,  94,   0, 255,   0,  97,   0, 255,   0, 100,   0, 255,   0, 103,   0, 255,   0, 105,   0, 255,   0, 108,   0, 255,   0, 111,   0, 255,   0, 112,   0, 255,   0, 114,   0, 255,   0, 115,   0, 255,   0, 117,   0, 255,   0, 117,   0, 255,   0, 118,   0, 255,   0, 118,   0, 255,   0, 118,   0, 255,   0, 117,   0, 255,   0, 116,   0, 255,   0, 116,   0, 255,   0, 114,   0, 255,   0, 112,   0, 255,   0, 110,   0, 255,   0, 108,   0, 255,   0, 106,   0, 255,   0, 103,   0, 255,   0, 100,   0, 255,   0,  97,   0, 255,   0,  94,   0, 255,   0,  90,   0, 255,   0,  86,   0, 255,   0,  82,   0, 255,   0,  78,   0, 255,   0,  75,   0, 255,   0,  70,   0, 255,   0,  65,   0, 255,   0,  61,   0, 255,   0,  57,   0, 255,   0,  51,   0, 255,   0,  47,   0, 255,   0,  42,   0, 255,   0,  36,   0, 255,   0,  32,   0, 255,   0,  26,   0, 255,   0,  20,   0, 255,   0,  15,   0, 255,   0,  11,   0, 255,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   6,   0, 255,   0,  12,   0, 255,   0,  17,   0, 255,   0,  22,   0, 255,   0,  28,   0, 255,   0,  32,   0, 255,   0,  37,   0, 255,   0,  42,   0, 255,   0,  47,   0, 255,   0,  51,   0, 255,   0,  56,   0, 255,   0,  60,   0, 255,   0,  65,   0, 255,   0,  69,   0, 255,   0,  74,   0, 255,   0,  77,   0, 255,   0,  80,   0, 255,   0,  85,   0, 255,   0,  88,   0, 255,   0,  91,   0, 255,   0,  94,   0, 255,   0,  97,   0, 255,   0,  99,   0, 255,   0, 102,   0, 255,   0, 105,   0, 255,   0, 106,   0, 255,   0, 107,   0, 255,   0, 109,   0, 255,   0, 110,   0, 255,   0, 111,   0, 255,   0, 111,   0, 255,   0, 111,   0, 255,   0, 111,   0, 255,   0, 110,   0, 255,   0, 110,   0, 255,   0, 109,   0, 255,   0, 107,   0, 255,   0, 106,   0, 255,   0, 104,   0, 255,   0, 102,   0, 255,   0, 100,   0, 255,   0,  97,   0, 255,   0,  94,   0, 255,   0,  91,   0, 255,   0,  88,   0, 255,   0,  85,   0, 255,   0,  81,   0, 255,   0,  77,   0, 255,   0,  73,   0, 255,   0,  69,   0, 255,   0,  65,   0, 255,   0,  60,   0, 255,   0,  56,   0, 255,   0,  52,   0, 255,   0,  47,   0, 255,   0,  42,   0, 255,   0,  37,   0, 255,   0,  33,   0, 255,   0,  28,   0, 255,   0,  22,   0, 255,   0,  17,   0, 255,   0,  12,   0, 255,   0,   7,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   2,   0, 255,   0,   7,   0, 255,   0,  13,   0, 255,   0,  18,   0, 255,   0,  23,   0, 255,   0,  28,   0, 255,   0,  33,   0, 255,   0,  38,   0, 255,   0,  43,   0, 255,   0,  47,   0, 255,   0,  51,   0, 255,   0,  55,   0, 255,   0,  60,   0, 255,   0,  64,   0, 255,   0,  68,   0, 255,   0,  72,   0, 255,   0,  76,   0, 255,   0,  79,   0, 255,   0,  83,   0, 255,   0,  85,   0, 255,   0,  88,   0, 255,   0,  91,   0, 255,   0,  94,   0, 255,   0,  96,   0, 255,   0,  98,   0, 255,   0,  99,   0, 255,   0, 101,   0, 255,   0, 102,   0, 255,   0, 103,   0, 255,   0, 104,   0, 255,   0, 104,   0, 255,   0, 105,   0, 255,   0, 104,   0, 255,   0, 104,   0, 255,   0, 103,   0, 255,   0, 103,   0, 255,   0, 101,   0, 255,   0, 100,   0, 255,   0,  98,   0, 255,   0,  96,   0, 255,   0,  93,   0, 255,   0,  91,   0, 255,   0,  89,   0, 255,   0,  85,   0, 255,   0,  82,   0, 255,   0,  79,   0, 255,   0,  76,   0, 255,   0,  72,   0, 255,   0,  68,   0, 255,   0,  64,   0, 255,   0,  60,   0, 255,   0,  56,   0, 255,   0,  51,   0, 255,   0,  47,   0, 255,   0,  42,   0, 255,   0,  38,   0, 255,   0,  33,   0, 255,   0,  28,   0, 255,   0,  23,   0, 255,   0,  18,   0, 255,   0,  13,   0, 255,   0,   8,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   4,   0, 255,   0,   9,   0, 255,   0,  14,   0, 255,   0,  19,   0, 255,   0,  24,   0, 255,   0,  29,   0, 255,   0,  33,   0, 255,   0,  37,   0, 255,   0,  43,   0, 255,   0,  47,   0, 255,   0,  50,   0, 255,   0,  55,   0, 255,   0,  59,   0, 255,   0,  63,   0, 255,   0,  67,   0, 255,   0,  70,   0, 255,   0,  73,   0, 255,   0,  76,   0, 255,   0,  80,   0, 255,   0,  82,   0, 255,   0,  85,   0, 255,   0,  87,   0, 255,   0,  89,   0, 255,   0,  92,   0, 255,   0,  93,   0, 255,   0,  95,   0, 255,   0,  96,   0, 255,   0,  97,   0, 255,   0,  98,   0, 255,   0,  98,   0, 255,   0,  98,   0, 255,   0,  98,   0, 255,   0,  98,   0, 255,   0,  97,   0, 255,   0,  95,   0, 255,   0,  94,   0, 255,   0,  94,   0, 255,   0,  92,   0, 255,   0,  90,   0, 255,   0,  88,   0, 255,   0,  85,   0, 255,   0,  82,   0, 255,   0,  80,   0, 255,   0,  76,   0, 255,   0,  73,   0, 255,   0,  70,   0, 255,   0,  66,   0, 255,   0,  62,   0, 255,   0,  59,   0, 255,   0,  55,   0, 255,   0,  51,   0, 255,   0,  47,   0, 255,   0,  42,   0, 255,   0,  38,   0, 255,   0,  33,   0, 255,   0,  28,   0, 255,   0,  24,   0, 255,   0,  19,   0, 255,   0,  14,   0, 255,   0,   9,   0, 255,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   5,   0, 255,   0,   9,   0, 255,   0,  14,   0, 255,   0,  20,   0, 255,   0,  23,   0, 255,   0,  28,   0, 255,   0,  33,   0, 255,   0,  38,   0, 255,   0,  42,   0, 255,   0,  45,   0, 255,   0,  49,   0, 255,   0,  53,   0, 255,   0,  58,   0, 255,   0,  61,   0, 255,   0,  64,   0, 255,   0,  68,   0, 255,   0,  71,   0, 255,   0,  74,   0, 255,   0,  77,   0, 255,   0,  79,   0, 255,   0,  82,   0, 255,   0,  83,   0, 255,   0,  85,   0, 255,   0,  87,   0, 255,   0,  88,   0, 255,   0,  90,   0, 255,   0,  90,   0, 255,   0,  91,   0, 255,   0,  91,   0, 255,   0,  92,   0, 255,   0,  92,   0, 255,   0,  91,   0, 255,   0,  91,   0, 255,   0,  90,   0, 255,   0,  89,   0, 255,   0,  87,   0, 255,   0,  86,   0, 255,   0,  83,   0, 255,   0,  82,   0, 255,   0,  79,   0, 255,   0,  76,   0, 255,   0,  73,   0, 255,   0,  71,   0, 255,   0,  68,   0, 255,   0,  64,   0, 255,   0,  61,   0, 255,   0,  58,   0, 255,   0,  54,   0, 255,   0,  49,   0, 255,   0,  45,   0, 255,   0,  42,   0, 255,   0,  38,   0, 255,   0,  33,   0, 255,   0,  28,   0, 255,   0,  24,   0, 255,   0,  19,   0, 255,   0,  15,   0, 255,   0,   9,   0, 255,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   5,   0, 255,   0,  10,   0, 255,   0,  14,   0, 255,   0,  19,   0, 255,   0,  24,   0, 255,   0,  29,   0, 255,   0,  33,   0, 255,   0,  37,   0, 255,   0,  41,   0, 255,   0,  44,   0, 255,   0,  48,   0, 255,   0,  52,   0, 255,   0,  55,   0, 255,   0,  59,   0, 255,   0,  62,   0, 255,   0,  65,   0, 255,   0,  68,   0, 255,   0,  71,   0, 255,   0,  73,   0, 255,   0,  75,   0, 255,   0,  77,   0, 255,   0,  79,   0, 255,   0,  80,   0, 255,   0,  82,   0, 255,   0,  83,   0, 255,   0,  84,   0, 255,   0,  84,   0, 255,   0,  85,   0, 255,   0,  85,   0, 255,   0,  85,   0, 255,   0,  84,   0, 255,   0,  84,   0, 255,   0,  83,   0, 255,   0,  82,   0, 255,   0,  81,   0, 255,   0,  79,   0, 255,   0,  77,   0, 255,   0,  75,   0, 255,   0,  73,   0, 255,   0,  70,   0, 255,   0,  68,   0, 255,   0,  65,   0, 255,   0,  62,   0, 255,   0,  59,   0, 255,   0,  55,   0, 255,   0,  52,   0, 255,   0,  49,   0, 255,   0,  44,   0, 255,   0,  40,   0, 255,   0,  36,   0, 255,   0,  32,   0, 255,   0,  28,   0, 255,   0,  24,   0, 255,   0,  19,   0, 255,   0,  15,   0, 255,   0,  10,   0, 255,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   5,   0, 255,   0,  10,   0, 255,   0,  14,   0, 255,   0,  18,   0, 255,   0,  24,   0, 255,   0,  27,   0, 255,   0,  31,   0, 255,   0,  35,   0, 255,   0,  39,   0, 255,   0,  42,   0, 255,   0,  46,   0, 255,   0,  50,   0, 255,   0,  53,   0, 255,   0,  56,   0, 255,   0,  59,   0, 255,   0,  62,   0, 255,   0,  65,   0, 255,   0,  67,   0, 255,   0,  69,   0, 255,   0,  71,   0, 255,   0,  72,   0, 255,   0,  74,   0, 255,   0,  75,   0, 255,   0,  76,   0, 255,   0,  77,   0, 255,   0,  78,   0, 255,   0,  78,   0, 255,   0,  79,   0, 255,   0,  78,   0, 255,   0,  78,   0, 255,   0,  77,   0, 255,   0,  77,   0, 255,   0,  75,   0, 255,   0,  74,   0, 255,   0,  73,   0, 255,   0,  71,   0, 255,   0,  69,   0, 255,   0,  67,   0, 255,   0,  64,   0, 255,   0,  62,   0, 255,   0,  59,   0, 255,   0,  56,   0, 255,   0,  53,   0, 255,   0,  50,   0, 255,   0,  47,   0, 255,   0,  42,   0, 255,   0,  39,   0, 255,   0,  35,   0, 255,   0,  32,   0, 255,   0,  28,   0, 255,   0,  23,   0, 255,   0,  19,   0, 255,   0,  15,   0, 255,   0,  10,   0, 255,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   5,   0, 255,   0,  10,   0, 255,   0,  14,   0, 255,   0,  18,   0, 255,   0,  23,   0, 255,   0,  26,   0, 255,   0,  30,   0, 255,   0,  34,   0, 255,   0,  38,   0, 255,   0,  41,   0, 255,   0,  44,   0, 255,   0,  47,   0, 255,   0,  50,   0, 255,   0,  53,   0, 255,   0,  55,   0, 255,   0,  58,   0, 255,   0,  61,   0, 255,   0,  63,   0, 255,   0,  65,   0, 255,   0,  66,   0, 255,   0,  68,   0, 255,   0,  69,   0, 255,   0,  70,   0, 255,   0,  71,   0, 255,   0,  71,   0, 255,   0,  71,   0, 255,   0,  72,   0, 255,   0,  72,   0, 255,   0,  71,   0, 255,   0,  71,   0, 255,   0,  70,   0, 255,   0,  70,   0, 255,   0,  68,   0, 255,   0,  67,   0, 255,   0,  64,   0, 255,   0,  63,   0, 255,   0,  61,   0, 255,   0,  58,   0, 255,   0,  56,   0, 255,   0,  54,   0, 255,   0,  50,   0, 255,   0,  47,   0, 255,   0,  44,   0, 255,   0,  40,   0, 255,   0,  37,   0, 255,   0,  34,   0, 255,   0,  30,   0, 255,   0,  26,   0, 255,   0,  22,   0, 255,   0,  19,   0, 255,   0,  14,   0, 255,   0,  10,   0, 255,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   5,   0, 255,   0,   9,   0, 255,   0,  13,   0, 255,   0,  17,   0, 255,   0,  21,   0, 255,   0,  25,   0, 255,   0,  28,   0, 255,   0,  31,   0, 255,   0,  35,   0, 255,   0,  38,   0, 255,   0,  41,   0, 255,   0,  44,   0, 255,   0,  47,   0, 255,   0,  50,   0, 255,   0,  52,   0, 255,   0,  55,   0, 255,   0,  57,   0, 255,   0,  58,   0, 255,   0,  60,   0, 255,   0,  62,   0, 255,   0,  63,   0, 255,   0,  63,   0, 255,   0,  65,   0, 255,   0,  65,   0, 255,   0,  66,   0, 255,   0,  65,   0, 255,   0,  65,   0, 255,   0,  65,   0, 255,   0,  64,   0, 255,   0,  63,   0, 255,   0,  62,   0, 255,   0,  61,   0, 255,   0,  59,   0, 255,   0,  58,   0, 255,   0,  57,   0, 255,   0,  54,   0, 255,   0,  52,   0, 255,   0,  50,   0, 255,   0,  47,   0, 255,   0,  45,   0, 255,   0,  42,   0, 255,   0,  39,   0, 255,   0,  35,   0, 255,   0,  32,   0, 255,   0,  28,   0, 255,   0,  25,   0, 255,   0,  21,   0, 255,   0,  17,   0, 255,   0,  13,   0, 255,   0,   9,   0, 255,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   8,   0, 255,   0,  12,   0, 255,   0,  16,   0, 255,   0,  19,   0, 255,   0,  23,   0, 255,   0,  26,   0, 255,   0,  29,   0, 255,   0,  32,   0, 255,   0,  36,   0, 255,   0,  38,   0, 255,   0,  42,   0, 255,   0,  44,   0, 255,   0,  46,   0, 255,   0,  49,   0, 255,   0,  51,   0, 255,   0,  52,   0, 255,   0,  53,   0, 255,   0,  55,   0, 255,   0,  57,   0, 255,   0,  57,   0, 255,   0,  58,   0, 255,   0,  59,   0, 255,   0,  59,   0, 255,   0,  59,   0, 255,   0,  59,   0, 255,   0,  58,   0, 255,   0,  57,   0, 255,   0,  57,   0, 255,   0,  57,   0, 255,   0,  55,   0, 255,   0,  53,   0, 255,   0,  52,   0, 255,   0,  51,   0, 255,   0,  49,   0, 255,   0,  46,   0, 255,   0,  43,   0, 255,   0,  41,   0, 255,   0,  39,   0, 255,   0,  35,   0, 255,   0,  33,   0, 255,   0,  30,   0, 255,   0,  27,   0, 255,   0,  23,   0, 255,   0,  19,   0, 255,   0,  16,   0, 255,   0,  12,   0, 255,   0,   7,   0, 255,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   6,   0, 255,   0,  10,   0, 255,   0,  14,   0, 255,   0,  17,   0, 255,   0,  21,   0, 255,   0,  24,   0, 255,   0,  27,   0, 255,   0,  30,   0, 255,   0,  33,   0, 255,   0,  35,   0, 255,   0,  38,   0, 255,   0,  40,   0, 255,   0,  42,   0, 255,   0,  44,   0, 255,   0,  46,   0, 255,   0,  47,   0, 255,   0,  48,   0, 255,   0,  49,   0, 255,   0,  51,   0, 255,   0,  51,   0, 255,   0,  52,   0, 255,   0,  52,   0, 255,   0,  53,   0, 255,   0,  53,   0, 255,   0,  52,   0, 255,   0,  52,   0, 255,   0,  51,   0, 255,   0,  49,   0, 255,   0,  49,   0, 255,   0,  47,   0, 255,   0,  46,   0, 255,   0,  44,   0, 255,   0,  42,   0, 255,   0,  40,   0, 255,   0,  38,   0, 255,   0,  35,   0, 255,   0,  33,   0, 255,   0,  30,   0, 255,   0,  27,   0, 255,   0,  23,   0, 255,   0,  20,   0, 255,   0,  18,   0, 255,   0,  13,   0, 255,   0,  10,   0, 255,   0,   6,   0, 255,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   4,   0, 255,   0,   8,   0, 255,   0,  12,   0, 255,   0,  15,   0, 255,   0,  18,   0, 255,   0,  21,   0, 255,   0,  23,   0, 255,   0,  27,   0, 255,   0,  29,   0, 255,   0,  31,   0, 255,   0,  34,   0, 255,   0,  36,   0, 255,   0,  38,   0, 255,   0,  39,   0, 255,   0,  41,   0, 255,   0,  42,   0, 255,   0,  43,   0, 255,   0,  44,   0, 255,   0,  45,   0, 255,   0,  45,   0, 255,   0,  46,   0, 255,   0,  45,   0, 255,   0,  46,   0, 255,   0,  46,   0, 255,   0,  45,   0, 255,   0,  44,   0, 255,   0,  43,   0, 255,   0,  42,   0, 255,   0,  41,   0, 255,   0,  40,   0, 255,   0,  38,   0, 255,   0,  36,   0, 255,   0,  33,   0, 255,   0,  31,   0, 255,   0,  29,   0, 255,   0,  27,   0, 255,   0,  24,   0, 255,   0,  21,   0, 255,   0,  18,   0, 255,   0,  15,   0, 255,   0,  12,   0, 255,   0,   8,   0, 255,   0,   5,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   6,   0, 255,   0,   9,   0, 255,   0,  13,   0, 255,   0,  15,   0, 255,   0,  18,   0, 255,   0,  21,   0, 255,   0,  23,   0, 255,   0,  25,   0, 255,   0,  28,   0, 255,   0,  30,   0, 255,   0,  32,   0, 255,   0,  33,   0, 255,   0,  34,   0, 255,   0,  36,   0, 255,   0,  37,   0, 255,   0,  37,   0, 255,   0,  38,   0, 255,   0,  39,   0, 255,   0,  40,   0, 255,   0,  39,   0, 255,   0,  39,   0, 255,   0,  39,   0, 255,   0,  39,   0, 255,   0,  38,   0, 255,   0,  37,   0, 255,   0,  36,   0, 255,   0,  35,   0, 255,   0,  33,   0, 255,   0,  32,   0, 255,   0,  30,   0, 255,   0,  28,   0, 255,   0,  25,   0, 255,   0,  23,   0, 255,   0,  21,   0, 255,   0,  18,   0, 255,   0,  15,   0, 255,   0,  12,   0, 255,   0,   9,   0, 255,   0,   6,   0, 255,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   6,   0, 255,   0,  10,   0, 255,   0,  12,   0, 255,   0,  15,   0, 255,   0,  17,   0, 255,   0,  19,   0, 255,   0,  22,   0, 255,   0,  24,   0, 255,   0,  25,   0, 255,   0,  26,   0, 255,   0,  28,   0, 255,   0,  30,   0, 255,   0,  31,   0, 255,   0,  31,   0, 255,   0,  32,   0, 255,   0,  33,   0, 255,   0,  32,   0, 255,   0,  33,   0, 255,   0,  33,   0, 255,   0,  33,   0, 255,   0,  32,   0, 255,   0,  31,   0, 255,   0,  31,   0, 255,   0,  29,   0, 255,   0,  28,   0, 255,   0,  26,   0, 255,   0,  25,   0, 255,   0,  23,   0, 255,   0,  21,   0, 255,   0,  19,   0, 255,   0,  17,   0, 255,   0,  15,   0, 255,   0,  12,   0, 255,   0,   9,   0, 255,   0,   6,   0, 255,   0,   3,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   3,   0, 255,   0,   6,   0, 255,   0,   8,   0, 255,   0,  11,   0, 255,   0,  13,   0, 255,   0,  15,   0, 255,   0,  17,   0, 255,   0,  19,   0, 255,   0,  21,   0, 255,   0,  21,   0, 255,   0,  23,   0, 255,   0,  24,   0, 255,   0,  25,   0, 255,   0,  25,   0, 255,   0,  26,   0, 255,   0,  26,   0, 255,   0,  26,   0, 255,   0,  26,   0, 255,   0,  25,   0, 255,   0,  25,   0, 255,   0,  24,   0, 255,   0,  24,   0, 255,   0,  22,   0, 255,   0,  21,   0, 255,   0,  21,   0, 255,   0,  19,   0, 255,   0,  16,   0, 255,   0,  15,   0, 255,   0,  13,   0, 255,   0,  11,   0, 255,   0,   9,   0, 255,   0,   6,   0, 255,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   2,   0, 255,   0,   5,   0, 255,   0,   7,   0, 255,   0,   9,   0, 255,   0,  10,   0, 255,   0,  13,   0, 255,   0,  14,   0, 255,   0,  15,   0, 255,   0,  16,   0, 255,   0,  17,   0, 255,   0,  18,   0, 255,   0,  19,   0, 255,   0,  19,   0, 255,   0,  20,   0, 255,   0,  19,   0, 255,   0,  19,   0, 255,   0,  19,   0, 255,   0,  19,   0, 255,   0,  18,   0, 255,   0,  18,   0, 255,   0,  16,   0, 255,   0,  15,   0, 255,   0,  14,   0, 255,   0,  13,   0, 255,   0,  11,   0, 255,   0,   9,   0, 255,   0,   7,   0, 255,   0,   5,   0, 255,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   3,   0, 255,   0,   4,   0, 255,   0,   6,   0, 255,   0,   8,   0, 255,   0,   9,   0, 255,   0,  10,   0, 255,   0,  11,   0, 255,   0,  12,   0, 255,   0,  12,   0, 255,   0,  13,   0, 255,   0,  13,   0, 255,   0,  13,   0, 255,   0,  13,   0, 255,   0,  13,   0, 255,   0,  12,   0, 255,   0,  12,   0, 255,   0,  11,   0, 255,   0,  10,   0, 255,   0,   8,   0, 255,   0,   8,   0, 255,   0,   6,   0, 255,   0,   4,   0, 255,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 255,   0,   1,   0, 255,   0,   3,   0, 255,   0,   4,   0, 255,   0,   4,   0, 255,   0,   5,   0, 255,   0,   6,   0, 255,   0,   6,   0, 255,   0,   7,   0, 255,   0,   7,   0, 255,   0,   6,   0, 255,   0,   6,   0, 255,   0,   6,   0, 255,   0,   5,   0, 255,   0,   5,   0, 255,   0,   4,   0, 255,   0,   2,   0, 255,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	};

	static const int GOLD_ICON_GLOW_SIZE_W = 80;
	static const int GOLD_ICON_GLOW_SIZE_H = 80;
	static const unsigned char GOLD_ICON_GLOW_DATA[25600] =
	{
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   3, 204, 161,   0,   4, 204, 161,   0,   4, 204, 161,   0,   5, 204, 161,   0,   6, 204, 161,   0,   6, 204, 161,   0,   6, 204, 161,   0,   6, 204, 161,   0,   6, 204, 161,   0,   6, 204, 161,   0,   6, 204, 161,   0,   5, 204, 161,   0,   4, 204, 161,   0,   4, 204, 161,   0,   2, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   2, 204, 161,   0,   5, 204, 161,   0,   6, 204, 161,   0,   8, 204, 161,   0,   9, 204, 161,   0,  10, 204, 161,   0,  11, 204, 161,   0,  12, 204, 161,   0,  12, 204, 161,   0,  13, 204, 161,   0,  13, 204, 161,   0,  13, 204, 161,   0,  13, 204, 161,   0,  13, 204, 161,   0,  12, 204, 161,   0,  12, 204, 161,   0,  11, 204, 161,   0,  10, 204, 161,   0,   9, 204, 161,   0,   7, 204, 161,   0,   6, 204, 161,   0,   4, 204, 161,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   3, 204, 161,   0,   4, 204, 161,   0,   7, 204, 161,   0,   9, 204, 161,   0,  11, 204, 161,   0,  13, 204, 161,   0,  14, 204, 161,   0,  15, 204, 161,   0,  16, 204, 161,   0,  17, 204, 161,   0,  18, 204, 161,   0,  18, 204, 161,   0,  19, 204, 161,   0,  20, 204, 161,   0,  20, 204, 161,   0,  20, 204, 161,   0,  20, 204, 161,   0,  19, 204, 161,   0,  18, 204, 161,   0,  18, 204, 161,   0,  16, 204, 161,   0,  15, 204, 161,   0,  14, 204, 161,   0,  13, 204, 161,   0,  11, 204, 161,   0,   9, 204, 161,   0,   7, 204, 161,   0,   5, 204, 161,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   3, 204, 161,   0,   6, 204, 161,   0,   9, 204, 161,   0,  11, 204, 161,   0,  13, 204, 161,   0,  15, 204, 161,   0,  17, 204, 161,   0,  18, 204, 161,   0,  20, 204, 161,   0,  22, 204, 161,   0,  22, 204, 161,   0,  24, 204, 161,   0,  25, 204, 161,   0,  25, 204, 161,   0,  26, 204, 161,   0,  26, 204, 161,   0,  26, 204, 161,   0,  26, 204, 161,   0,  26, 204, 161,   0,  25, 204, 161,   0,  24, 204, 161,   0,  23, 204, 161,   0,  23, 204, 161,   0,  22, 204, 161,   0,  21, 204, 161,   0,  19, 204, 161,   0,  17, 204, 161,   0,  15, 204, 161,   0,  13, 204, 161,   0,  11, 204, 161,   0,   9, 204, 161,   0,   6, 204, 161,   0,   4, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   3, 204, 161,   0,   7, 204, 161,   0,   9, 204, 161,   0,  12, 204, 161,   0,  15, 204, 161,   0,  17, 204, 161,   0,  19, 204, 161,   0,  22, 204, 161,   0,  24, 204, 161,   0,  25, 204, 161,   0,  27, 204, 161,   0,  28, 204, 161,   0,  29, 204, 161,   0,  30, 204, 161,   0,  31, 204, 161,   0,  32, 204, 161,   0,  32, 204, 161,   0,  32, 204, 161,   0,  32, 204, 161,   0,  33, 204, 161,   0,  32, 204, 161,   0,  32, 204, 161,   0,  31, 204, 161,   0,  30, 204, 161,   0,  29, 204, 161,   0,  28, 204, 161,   0,  26, 204, 161,   0,  25, 204, 161,   0,  23, 204, 161,   0,  22, 204, 161,   0,  19, 204, 161,   0,  17, 204, 161,   0,  14, 204, 161,   0,  12, 204, 161,   0,   9, 204, 161,   0,   6, 204, 161,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   2, 204, 161,   0,   6, 204, 161,   0,   9, 204, 161,   0,  12, 204, 161,   0,  15, 204, 161,   0,  18, 204, 161,   0,  20, 204, 161,   0,  23, 204, 161,   0,  26, 204, 161,   0,  27, 204, 161,   0,  29, 204, 161,   0,  31, 204, 161,   0,  33, 204, 161,   0,  35, 204, 161,   0,  35, 204, 161,   0,  37, 204, 161,   0,  38, 204, 161,   0,  39, 204, 161,   0,  39, 204, 161,   0,  39, 204, 161,   0,  39, 204, 161,   0,  39, 204, 161,   0,  39, 204, 161,   0,  38, 204, 161,   0,  37, 204, 161,   0,  37, 204, 161,   0,  36, 204, 161,   0,  35, 204, 161,   0,  33, 204, 161,   0,  31, 204, 161,   0,  30, 204, 161,   0,  27, 204, 161,   0,  25, 204, 161,   0,  23, 204, 161,   0,  20, 204, 161,   0,  18, 204, 161,   0,  15, 204, 161,   0,  12, 204, 161,   0,   9, 204, 161,   0,   6, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   5, 204, 161,   0,   8, 204, 161,   0,  12, 204, 161,   0,  15, 204, 161,   0,  18, 204, 161,   0,  21, 204, 161,   0,  24, 204, 161,   0,  27, 204, 161,   0,  30, 204, 161,   0,  31, 204, 161,   0,  34, 204, 161,   0,  36, 204, 161,   0,  37, 204, 161,   0,  39, 204, 161,   0,  41, 204, 161,   0,  42, 204, 161,   0,  43, 204, 161,   0,  44, 204, 161,   0,  45, 204, 161,   0,  45, 204, 161,   0,  46, 204, 161,   0,  45, 204, 161,   0,  46, 204, 161,   0,  45, 204, 161,   0,  45, 204, 161,   0,  44, 204, 161,   0,  43, 204, 161,   0,  42, 204, 161,   0,  41, 204, 161,   0,  39, 204, 161,   0,  37, 204, 161,   0,  36, 204, 161,   0,  34, 204, 161,   0,  32, 204, 161,   0,  29, 204, 161,   0,  26, 204, 161,   0,  24, 204, 161,   0,  21, 204, 161,   0,  18, 204, 161,   0,  15, 204, 161,   0,  11, 204, 161,   0,   8, 204, 161,   0,   5, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   3, 204, 161,   0,   6, 204, 161,   0,  10, 204, 161,   0,  14, 204, 161,   0,  17, 204, 161,   0,  21, 204, 161,   0,  23, 204, 161,   0,  27, 204, 161,   0,  30, 204, 161,   0,  33, 204, 161,   0,  35, 204, 161,   0,  38, 204, 161,   0,  39, 204, 161,   0,  42, 204, 161,   0,  44, 204, 161,   0,  46, 204, 161,   0,  47, 204, 161,   0,  48, 204, 161,   0,  50, 204, 161,   0,  51, 204, 161,   0,  51, 204, 161,   0,  52, 204, 161,   0,  52, 204, 161,   0,  52, 204, 161,   0,  53, 204, 161,   0,  52, 204, 161,   0,  51, 204, 161,   0,  50, 204, 161,   0,  49, 204, 161,   0,  48, 204, 161,   0,  47, 204, 161,   0,  45, 204, 161,   0,  44, 204, 161,   0,  42, 204, 161,   0,  40, 204, 161,   0,  37, 204, 161,   0,  35, 204, 161,   0,  32, 204, 161,   0,  30, 204, 161,   0,  27, 204, 161,   0,  24, 204, 161,   0,  21, 204, 161,   0,  17, 204, 161,   0,  14, 204, 161,   0,  10, 204, 161,   0,   7, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   4, 204, 161,   0,   8, 204, 161,   0,  12, 204, 161,   0,  15, 204, 161,   0,  19, 204, 161,   0,  23, 204, 161,   0,  26, 204, 161,   0,  30, 204, 161,   0,  32, 204, 161,   0,  36, 204, 161,   0,  39, 204, 161,   0,  41, 204, 161,   0,  44, 204, 161,   0,  46, 204, 161,   0,  48, 204, 161,   0,  51, 204, 161,   0,  52, 204, 161,   0,  54, 204, 161,   0,  55, 204, 161,   0,  56, 204, 161,   0,  57, 204, 161,   0,  58, 204, 161,   0,  59, 204, 161,   0,  59, 204, 161,   0,  59, 204, 161,   0,  58, 204, 161,   0,  59, 204, 161,   0,  58, 204, 161,   0,  58, 204, 161,   0,  56, 204, 161,   0,  55, 204, 161,   0,  54, 204, 161,   0,  52, 204, 161,   0,  51, 204, 161,   0,  49, 204, 161,   0,  46, 204, 161,   0,  44, 204, 161,   0,  41, 204, 161,   0,  38, 204, 161,   0,  36, 204, 161,   0,  32, 204, 161,   0,  30, 204, 161,   0,  27, 204, 161,   0,  23, 204, 161,   0,  19, 204, 161,   0,  15, 204, 161,   0,  12, 204, 161,   0,   8, 204, 161,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   5, 204, 161,   0,   9, 204, 161,   0,  13, 204, 161,   0,  17, 204, 161,   0,  21, 204, 161,   0,  25, 204, 161,   0,  29, 204, 161,   0,  32, 204, 161,   0,  35, 204, 161,   0,  39, 204, 161,   0,  42, 204, 161,   0,  44, 204, 161,   0,  47, 204, 161,   0,  50, 204, 161,   0,  52, 204, 161,   0,  54, 204, 161,   0,  56, 204, 161,   0,  58, 204, 161,   0,  60, 204, 161,   0,  61, 204, 161,   0,  63, 204, 161,   0,  63, 204, 161,   0,  64, 204, 161,   0,  65, 204, 161,   0,  65, 204, 161,   0,  65, 204, 161,   0,  65, 204, 161,   0,  65, 204, 161,   0,  64, 204, 161,   0,  63, 204, 161,   0,  63, 204, 161,   0,  61, 204, 161,   0,  60, 204, 161,   0,  58, 204, 161,   0,  57, 204, 161,   0,  54, 204, 161,   0,  53, 204, 161,   0,  50, 204, 161,   0,  47, 204, 161,   0,  45, 204, 161,   0,  41, 204, 161,   0,  39, 204, 161,   0,  35, 204, 161,   0,  32, 204, 161,   0,  29, 204, 161,   0,  25, 204, 161,   0,  21, 204, 161,   0,  17, 204, 161,   0,  13, 204, 161,   0,   9, 204, 161,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   5, 204, 161,   0,   9, 204, 161,   0,  14, 204, 161,   0,  18, 204, 161,   0,  22, 204, 161,   0,  26, 204, 161,   0,  30, 204, 161,   0,  33, 204, 161,   0,  38, 204, 161,   0,  41, 204, 161,   0,  44, 204, 161,   0,  47, 204, 161,   0,  50, 204, 161,   0,  54, 204, 161,   0,  55, 204, 161,   0,  59, 204, 161,   0,  61, 204, 161,   0,  63, 204, 161,   0,  65, 204, 161,   0,  66, 204, 161,   0,  68, 204, 161,   0,  69, 204, 161,   0,  70, 204, 161,   0,  71, 204, 161,   0,  72, 204, 161,   0,  72, 204, 161,   0,  72, 204, 161,   0,  71, 204, 161,   0,  72, 204, 161,   0,  71, 204, 161,   0,  70, 204, 161,   0,  69, 204, 161,   0,  67, 204, 161,   0,  66, 204, 161,   0,  65, 204, 161,   0,  62, 204, 161,   0,  61, 204, 161,   0,  59, 204, 161,   0,  55, 204, 161,   0,  53, 204, 161,   0,  50, 204, 161,   0,  48, 204, 161,   0,  44, 204, 161,   0,  41, 204, 161,   0,  37, 204, 161,   0,  34, 204, 161,   0,  30, 204, 161,   0,  26, 204, 161,   0,  23, 204, 161,   0,  18, 204, 161,   0,  13, 204, 161,   0,   9, 204, 161,   0,   6, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  10, 204, 161,   0,  14, 204, 161,   0,  19, 204, 161,   0,  23, 204, 161,   0,  27, 204, 161,   0,  31, 204, 161,   0,  35, 204, 161,   0,  39, 204, 161,   0,  43, 204, 161,   0,  46, 204, 161,   0,  50, 204, 161,   0,  53, 204, 161,   0,  56, 204, 161,   0,  59, 204, 161,   0,  61, 204, 161,   0,  64, 204, 161,   0,  67, 204, 161,   0,  69, 204, 161,   0,  71, 204, 161,   0,  72, 204, 161,   0,  74, 204, 161,   0,  75, 204, 161,   0,  76, 204, 161,   0,  78, 204, 161,   0,  78, 204, 161,   0,  78, 204, 161,   0,  79, 204, 161,   0,  78, 204, 161,   0,  78, 204, 161,   0,  77, 204, 161,   0,  76, 204, 161,   0,  75, 204, 161,   0,  74, 204, 161,   0,  72, 204, 161,   0,  71, 204, 161,   0,  69, 204, 161,   0,  67, 204, 161,   0,  65, 204, 161,   0,  62, 204, 161,   0,  59, 204, 161,   0,  56, 204, 161,   0,  53, 204, 161,   0,  50, 204, 161,   0,  47, 204, 161,   0,  43, 204, 161,   0,  39, 204, 161,   0,  35, 204, 161,   0,  31, 204, 161,   0,  27, 204, 161,   0,  24, 204, 161,   0,  19, 204, 161,   0,  15, 204, 161,   0,  10, 204, 161,   0,   6, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   5, 204, 161,   0,   9, 204, 161,   0,  15, 204, 161,   0,  19, 204, 161,   0,  24, 204, 161,   0,  28, 204, 161,   0,  32, 204, 161,   0,  36, 204, 161,   0,  41, 204, 161,   0,  45, 204, 161,   0,  48, 204, 161,   0,  52, 204, 161,   0,  56, 204, 161,   0,  59, 204, 161,   0,  62, 204, 161,   0,  65, 204, 161,   0,  68, 204, 161,   0,  70, 204, 161,   0,  73, 204, 161,   0,  75, 204, 161,   0,  77, 204, 161,   0,  79, 204, 161,   0,  80, 204, 161,   0,  82, 204, 161,   0,  83, 204, 161,   0,  84, 204, 161,   0,  85, 204, 161,   0,  85, 204, 161,   0,  85, 204, 161,   0,  85, 204, 161,   0,  84, 204, 161,   0,  84, 204, 161,   0,  83, 204, 161,   0,  81, 204, 161,   0,  80, 204, 161,   0,  78, 204, 161,   0,  78, 204, 161,   0,  75, 204, 161,   0,  73, 204, 161,   0,  70, 204, 161,   0,  68, 204, 161,   0,  65, 204, 161,   0,  62, 204, 161,   0,  59, 204, 161,   0,  56, 204, 161,   0,  52, 204, 161,   0,  48, 204, 161,   0,  45, 204, 161,   0,  40, 204, 161,   0,  37, 204, 161,   0,  33, 204, 161,   0,  28, 204, 161,   0,  23, 204, 161,   0,  19, 204, 161,   0,  14, 204, 161,   0,  10, 204, 161,   0,   6, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   5, 204, 161,   0,   9, 204, 161,   0,  14, 204, 161,   0,  19, 204, 161,   0,  24, 204, 161,   0,  29, 204, 161,   0,  33, 204, 161,   0,  37, 204, 161,   0,  42, 204, 161,   0,  45, 204, 161,   0,  50, 204, 161,   0,  54, 204, 161,   0,  57, 204, 161,   0,  61, 204, 161,   0,  64, 204, 161,   0,  68, 204, 161,   0,  71, 204, 161,   0,  74, 204, 161,   0,  76, 204, 161,   0,  79, 204, 161,   0,  81, 204, 161,   0,  84, 204, 161,   0,  85, 204, 161,   0,  87, 204, 161,   0,  89, 204, 161,   0,  90, 204, 161,   0,  91, 204, 161,   0,  91, 204, 161,   0,  91, 204, 161,   0,  91, 204, 161,   0,  92, 204, 161,   0,  91, 204, 161,   0,  91, 204, 161,   0,  90, 204, 161,   0,  88, 204, 161,   0,  87, 204, 161,   0,  85, 204, 161,   0,  84, 204, 161,   0,  81, 204, 161,   0,  78, 204, 161,   0,  77, 204, 161,   0,  73, 204, 161,   0,  71, 204, 161,   0,  68, 204, 161,   0,  65, 204, 161,   0,  61, 204, 161,   0,  58, 204, 161,   0,  54, 204, 161,   0,  50, 204, 161,   0,  46, 204, 161,   0,  41, 204, 161,   0,  37, 204, 161,   0,  32, 204, 161,   0,  29, 204, 161,   0,  24, 204, 161,   0,  19, 204, 161,   0,  14, 204, 161,   0,  10, 204, 161,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   4, 204, 161,   0,   9, 204, 161,   0,  14, 204, 161,   0,  19, 204, 161,   0,  23, 204, 161,   0,  28, 204, 161,   0,  33, 204, 161,   0,  38, 204, 161,   0,  42, 204, 161,   0,  47, 204, 161,   0,  51, 204, 161,   0,  55, 204, 161,   0,  59, 204, 161,   0,  63, 204, 161,   0,  67, 204, 161,   0,  70, 204, 161,   0,  73, 204, 161,   0,  76, 204, 161,   0,  79, 204, 161,   0,  82, 204, 161,   0,  85, 204, 161,   0,  87, 204, 161,   0,  90, 204, 161,   0,  92, 204, 161,   0,  93, 204, 161,   0,  95, 204, 161,   0,  96, 204, 161,   0,  97, 204, 161,   0,  98, 204, 161,   0,  98, 204, 161,   0,  98, 204, 161,   0,  98, 204, 161,   0,  97, 204, 161,   0,  97, 204, 161,   0,  96, 204, 161,   0,  94, 204, 161,   0,  93, 204, 161,   0,  92, 204, 161,   0,  90, 204, 161,   0,  88, 204, 161,   0,  85, 204, 161,   0,  83, 204, 161,   0,  80, 204, 161,   0,  77, 204, 161,   0,  74, 204, 161,   0,  70, 204, 161,   0,  66, 204, 161,   0,  63, 204, 161,   0,  59, 204, 161,   0,  55, 204, 161,   0,  51, 204, 161,   0,  46, 204, 161,   0,  42, 204, 161,   0,  37, 204, 161,   0,  33, 204, 161,   0,  28, 204, 161,   0,  24, 204, 161,   0,  18, 204, 161,   0,  14, 204, 161,   0,   9, 204, 161,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   3, 204, 161,   0,   8, 204, 161,   0,  13, 204, 161,   0,  18, 204, 161,   0,  24, 204, 161,   0,  28, 204, 161,   0,  33, 204, 161,   0,  37, 204, 161,   0,  42, 204, 161,   0,  47, 204, 161,   0,  51, 204, 161,   0,  56, 204, 161,   0,  60, 204, 161,   0,  64, 204, 161,   0,  68, 204, 161,   0,  71, 204, 161,   0,  75, 204, 161,   0,  79, 204, 161,   0,  82, 204, 161,   0,  86, 204, 161,   0,  89, 204, 161,   0,  91, 204, 161,   0,  94, 204, 161,   0,  96, 204, 161,   0,  98, 204, 161,   0,  99, 204, 161,   0, 101, 204, 161,   0, 103, 204, 161,   0, 103, 204, 161,   0, 104, 204, 161,   0, 105, 204, 161,   0, 105, 204, 161,   0, 105, 204, 161,   0, 104, 204, 161,   0, 103, 204, 161,   0, 102, 204, 161,   0, 101, 204, 161,   0, 100, 204, 161,   0,  98, 204, 161,   0,  96, 204, 161,   0,  93, 204, 161,   0,  91, 204, 161,   0,  88, 204, 161,   0,  85, 204, 161,   0,  83, 204, 161,   0,  79, 204, 161,   0,  76, 204, 161,   0,  71, 204, 161,   0,  68, 204, 161,   0,  64, 204, 161,   0,  60, 204, 161,   0,  55, 204, 161,   0,  52, 204, 161,   0,  46, 204, 161,   0,  42, 204, 161,   0,  38, 204, 161,   0,  33, 204, 161,   0,  28, 204, 161,   0,  23, 204, 161,   0,  18, 204, 161,   0,  13, 204, 161,   0,   8, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   2, 204, 161,   0,   7, 204, 161,   0,  11, 204, 161,   0,  17, 204, 161,   0,  23, 204, 161,   0,  27, 204, 161,   0,  33, 204, 161,   0,  37, 204, 161,   0,  42, 204, 161,   0,  46, 204, 161,   0,  52, 204, 161,   0,  56, 204, 161,   0,  61, 204, 161,   0,  65, 204, 161,   0,  70, 204, 161,   0,  73, 204, 161,   0,  77, 204, 161,   0,  81, 204, 161,   0,  84, 204, 161,   0,  88, 204, 161,   0,  91, 204, 161,   0,  95, 204, 161,   0,  97, 204, 161,   0, 100, 204, 161,   0, 102, 204, 161,   0, 104, 204, 161,   0, 106, 204, 161,   0, 108, 204, 161,   0, 108, 204, 161,   0, 110, 204, 161,   0, 110, 204, 161,   0, 111, 204, 161,   0, 112, 204, 161,   0, 111, 204, 161,   0, 111, 204, 161,   0, 110, 204, 161,   0, 109, 204, 161,   0, 107, 204, 161,   0, 106, 204, 161,   0, 104, 204, 161,   0, 102, 204, 161,   0, 100, 204, 161,   0,  97, 204, 161,   0,  94, 204, 161,   0,  91, 204, 161,   0,  88, 204, 161,   0,  85, 204, 161,   0,  81, 204, 161,   0,  77, 204, 161,   0,  73, 204, 161,   0,  69, 204, 161,   0,  65, 204, 161,   0,  61, 204, 161,   0,  56, 204, 161,   0,  52, 204, 161,   0,  47, 204, 161,   0,  43, 204, 161,   0,  37, 204, 161,   0,  33, 204, 161,   0,  27, 204, 161,   0,  22, 204, 161,   0,  17, 204, 161,   0,  12, 204, 161,   0,   7, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   5, 204, 161,   0,  10, 204, 161,   0,  16, 204, 161,   0,  21, 204, 161,   0,  26, 204, 161,   0,  31, 204, 161,   0,  37, 204, 161,   0,  42, 204, 161,   0,  46, 204, 161,   0,  51, 204, 161,   0,  56, 204, 161,   0,  61, 204, 161,   0,  66, 204, 161,   0,  70, 204, 161,   0,  74, 204, 161,   0,  79, 204, 161,   0,  83, 204, 161,   0,  86, 204, 161,   0,  90, 204, 161,   0,  94, 204, 161,   0,  97, 204, 161,   0, 100, 204, 161,   0, 103, 204, 161,   0, 106, 204, 161,   0, 108, 204, 161,   0, 110, 204, 161,   0, 112, 204, 161,   0, 113, 204, 161,   0, 116, 204, 161,   0, 116, 204, 161,   0, 117, 204, 161,   0, 117, 204, 161,   0, 118, 204, 161,   0, 117, 204, 161,   0, 117, 204, 161,   0, 116, 204, 161,   0, 115, 204, 161,   0, 114, 204, 161,   0, 112, 204, 161,   0, 110, 204, 161,   0, 108, 204, 161,   0, 106, 204, 161,   0, 103, 204, 161,   0, 100, 204, 161,   0,  97, 204, 161,   0,  93, 204, 161,   0,  90, 204, 161,   0,  86, 204, 161,   0,  83, 204, 161,   0,  79, 204, 161,   0,  74, 204, 161,   0,  70, 204, 161,   0,  66, 204, 161,   0,  61, 204, 161,   0,  56, 204, 161,   0,  51, 204, 161,   0,  46, 204, 161,   0,  41, 204, 161,   0,  37, 204, 161,   0,  31, 204, 161,   0,  26, 204, 161,   0,  21, 204, 161,   0,  16, 204, 161,   0,  10, 204, 161,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   2, 204, 161,   0,   8, 204, 161,   0,  14, 204, 161,   0,  19, 204, 161,   0,  24, 204, 161,   0,  30, 204, 161,   0,  35, 204, 161,   0,  41, 204, 161,   0,  46, 204, 161,   0,  51, 204, 161,   0,  55, 204, 161,   0,  61, 204, 161,   0,  65, 204, 161,   0,  70, 204, 161,   0,  74, 204, 161,   0,  79, 204, 161,   0,  83, 204, 161,   0,  87, 204, 161,   0,  91, 204, 161,   0,  95, 204, 161,   0,  99, 204, 161,   0, 103, 204, 161,   0, 106, 204, 161,   0, 109, 204, 161,   0, 112, 204, 161,   0, 114, 204, 161,   0, 117, 204, 161,   0, 119, 204, 161,   0, 121, 204, 161,   0, 122, 204, 161,   0, 123, 204, 161,   0, 124, 204, 161,   0, 124, 204, 161,   0, 124, 204, 161,   0, 124, 204, 161,   0, 124, 204, 161,   0, 122, 204, 161,   0, 122, 204, 161,   0, 120, 204, 161,   0, 118, 204, 161,   0, 116, 204, 161,   0, 114, 204, 161,   0, 112, 204, 161,   0, 109, 204, 161,   0, 106, 204, 161,   0, 103, 204, 161,   0,  99, 204, 161,   0,  96, 204, 161,   0,  91, 204, 161,   0,  87, 204, 161,   0,  83, 204, 161,   0,  79, 204, 161,   0,  75, 204, 161,   0,  70, 204, 161,   0,  65, 204, 161,   0,  60, 204, 161,   0,  56, 204, 161,   0,  50, 204, 161,   0,  46, 204, 161,   0,  41, 204, 161,   0,  35, 204, 161,   0,  30, 204, 161,   0,  25, 204, 161,   0,  20, 204, 161,   0,  14, 204, 161,   0,   8, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  11, 204, 161,   0,  17, 204, 161,   0,  22, 204, 161,   0,  29, 204, 161,   0,  33, 204, 161,   0,  39, 204, 161,   0,  44, 204, 161,   0,  50, 204, 161,   0,  55, 204, 161,   0,  60, 204, 161,   0,  65, 204, 161,   0,  70, 204, 161,   0,  75, 204, 161,   0,  79, 204, 161,   0,  84, 204, 161,   0,  88, 204, 161,   0,  93, 204, 161,   0,  96, 204, 161,   0, 101, 204, 161,   0, 105, 204, 161,   0, 108, 204, 161,   0, 111, 204, 161,   0, 114, 204, 161,   0, 118, 204, 161,   0, 121, 204, 161,   0, 122, 204, 161,   0, 125, 204, 161,   0, 127, 204, 161,   0, 128, 204, 161,   0, 129, 204, 161,   0, 130, 204, 161,   0, 130, 204, 161,   0, 131, 204, 161,   0, 131, 204, 161,   0, 130, 204, 161,   0, 129, 204, 161,   0, 128, 204, 161,   0, 127, 204, 161,   0, 125, 204, 161,   0, 123, 204, 161,   0, 120, 204, 161,   0, 118, 204, 161,   0, 114, 204, 161,   0, 111, 204, 161,   0, 108, 204, 161,   0, 105, 204, 161,   0, 101, 204, 161,   0,  97, 204, 161,   0,  92, 204, 161,   0,  88, 204, 161,   0,  84, 204, 161,   0,  80, 204, 161,   0,  75, 204, 161,   0,  70, 204, 161,   0,  65, 204, 161,   0,  60, 204, 161,   0,  55, 204, 161,   0,  49, 204, 161,   0,  44, 204, 161,   0,  39, 204, 161,   0,  34, 204, 161,   0,  28, 204, 161,   0,  23, 204, 161,   0,  18, 204, 161,   0,  11, 204, 161,   0,   7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   4, 204, 161,   0,   9, 204, 161,   0,  15, 204, 161,   0,  21, 204, 161,   0,  26, 204, 161,   0,  32, 204, 161,   0,  37, 204, 161,   0,  42, 204, 161,   0,  48, 204, 161,   0,  54, 204, 161,   0,  59, 204, 161,   0,  64, 204, 161,   0,  69, 204, 161,   0,  75, 204, 161,   0,  79, 204, 161,   0,  84, 204, 161,   0,  89, 204, 161,   0,  93, 204, 161,   0,  98, 204, 161,   0, 101, 204, 161,   0, 106, 204, 161,   0, 110, 204, 161,   0, 113, 204, 161,   0, 117, 204, 161,   0, 120, 204, 161,   0, 123, 204, 161,   0, 126, 204, 161,   0, 128, 204, 161,   0, 131, 204, 161,   0, 133, 204, 161,   0, 134, 204, 161,   0, 136, 204, 161,   0, 137, 204, 161,   0, 137, 204, 161,   0, 138, 204, 161,   0, 137, 204, 161,   0, 137, 204, 161,   0, 136, 204, 161,   0, 135, 204, 161,   0, 133, 204, 161,   0, 131, 204, 161,   0, 129, 204, 161,   0, 127, 204, 161,   0, 123, 204, 161,   0, 120, 204, 161,   0, 117, 204, 161,   0, 114, 204, 161,   0, 110, 204, 161,   0, 106, 204, 161,   0, 102, 204, 161,   0,  97, 204, 161,   0,  93, 204, 161,   0,  89, 204, 161,   0,  84, 204, 161,   0,  79, 204, 161,   0,  74, 204, 161,   0,  69, 204, 161,   0,  64, 204, 161,   0,  59, 204, 161,   0,  53, 204, 161,   0,  48, 204, 161,   0,  43, 204, 161,   0,  37, 204, 161,   0,  32, 204, 161,   0,  26, 204, 161,   0,  20, 204, 161,   0,  15, 204, 161,   0,   9, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  12, 204, 161,   0,  18, 204, 161,   0,  24, 204, 161,   0,  29, 204, 161,   0,  35, 204, 161,   0,  41, 204, 161,   0,  46, 204, 161,   0,  52, 204, 161,   0,  57, 204, 161,   0,  62, 204, 161,   0,  68, 204, 161,   0,  73, 204, 161,   0,  78, 204, 161,   0,  83, 204, 161,   0,  88, 204, 161,   0,  93, 204, 161,   0,  97, 204, 161,   0, 102, 204, 161,   0, 107, 204, 161,   0, 111, 204, 161,   0, 115, 204, 161,   0, 119, 204, 161,   0, 123, 204, 161,   0, 126, 204, 161,   0, 129, 204, 161,   0, 133, 204, 161,   0, 135, 204, 161,   0, 138, 204, 161,   0, 139, 204, 161,   0, 141, 204, 161,   0, 142, 204, 161,   0, 143, 204, 161,   0, 144, 204, 161,   0, 144, 204, 161,   0, 144, 204, 161,   0, 143, 204, 161,   0, 142, 204, 161,   0, 141, 204, 161,   0, 139, 204, 161,   0, 137, 204, 161,   0, 134, 204, 161,   0, 132, 204, 161,   0, 129, 204, 161,   0, 126, 204, 161,   0, 123, 204, 161,   0, 119, 204, 161,   0, 115, 204, 161,   0, 111, 204, 161,   0, 107, 204, 161,   0, 102, 204, 161,   0,  98, 204, 161,   0,  93, 204, 161,   0,  88, 204, 161,   0,  84, 204, 161,   0,  78, 204, 161,   0,  73, 204, 161,   0,  68, 204, 161,   0,  62, 204, 161,   0,  58, 204, 161,   0,  52, 204, 161,   0,  46, 204, 161,   0,  41, 204, 161,   0,  35, 204, 161,   0,  30, 204, 161,   0,  24, 204, 161,   0,  18, 204, 161,   0,  13, 204, 161,   0,   7, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   3, 204, 161,   0,  10, 204, 161,   0,  15, 204, 161,   0,  21, 204, 161,   0,  27, 204, 161,   0,  32, 204, 161,   0,  38, 204, 161,   0,  44, 204, 161,   0,  50, 204, 161,   0,  55, 204, 161,   0,  61, 204, 161,   0,  66, 204, 161,   0,  72, 204, 161,   0,  77, 204, 161,   0,  83, 204, 161,   0,  88, 204, 161,   0,  93, 204, 161,   0,  97, 204, 161,   0, 102, 204, 161,   0, 107, 204, 161,   0, 112, 204, 161,   0, 116, 204, 161,   0, 120, 204, 161,   0, 124, 204, 161,   0, 128, 204, 161,   0, 132, 204, 161,   0, 135, 204, 161,   0, 138, 204, 161,   0, 141, 204, 161,   0, 143, 204, 161,   0, 145, 204, 161,   0, 148, 204, 161,   0, 148, 204, 161,   0, 150, 204, 161,   0, 150, 204, 161,   0, 151, 204, 161,   0, 150, 204, 161,   0, 150, 204, 161,   0, 149, 204, 161,   0, 147, 204, 161,   0, 146, 204, 161,   0, 144, 204, 161,   0, 140, 204, 161,   0, 138, 204, 161,   0, 135, 204, 161,   0, 132, 204, 161,   0, 128, 204, 161,   0, 124, 204, 161,   0, 120, 204, 161,   0, 116, 204, 161,   0, 112, 204, 161,   0, 107, 204, 161,   0, 102, 204, 161,   0,  98, 204, 161,   0,  92, 204, 161,   0,  87, 204, 161,   0,  83, 204, 161,   0,  77, 204, 161,   0,  72, 204, 161,   0,  66, 204, 161,   0,  61, 204, 161,   0,  56, 204, 161,   0,  49, 204, 161,   0,  45, 204, 161,   0,  39, 204, 161,   0,  33, 204, 161,   0,  27, 204, 161,   0,  21, 204, 161,   0,  15, 204, 161,   0,  10, 204, 161,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  12, 204, 161,   0,  18, 204, 161,   0,  24, 204, 161,   0,  30, 204, 161,   0,  35, 204, 161,   0,  41, 204, 161,   0,  47, 204, 161,   0,  53, 204, 161,   0,  59, 204, 161,   0,  65, 204, 161,   0,  70, 204, 161,   0,  75, 204, 161,   0,  81, 204, 161,   0,  87, 204, 161,   0,  91, 204, 161,   0,  96, 204, 161,   0, 102, 204, 161,   0, 106, 204, 161,   0, 111, 204, 161,   0, 116, 204, 161,   0, 120, 204, 161,   0, 126, 204, 161,   0, 129, 204, 161,   0, 134, 204, 161,   0, 137, 204, 161,   0, 141, 204, 161,   0, 143, 204, 161,   0, 146, 204, 161,   0, 150, 204, 161,   0, 152, 204, 161,   0, 153, 204, 161,   0, 155, 204, 161,   0, 156, 204, 161,   0, 157, 204, 161,   0, 157, 204, 161,   0, 157, 204, 161,   0, 156, 204, 161,   0, 155, 204, 161,   0, 153, 204, 161,   0, 152, 204, 161,   0, 150, 204, 161,   0, 147, 204, 161,   0, 144, 204, 161,   0, 140, 204, 161,   0, 137, 204, 161,   0, 133, 204, 161,   0, 130, 204, 161,   0, 125, 204, 161,   0, 121, 204, 161,   0, 116, 204, 161,   0, 112, 204, 161,   0, 106, 204, 161,   0, 102, 204, 161,   0,  97, 204, 161,   0,  92, 204, 161,   0,  87, 204, 161,   0,  81, 204, 161,   0,  76, 204, 161,   0,  70, 204, 161,   0,  64, 204, 161,   0,  59, 204, 161,   0,  53, 204, 161,   0,  48, 204, 161,   0,  42, 204, 161,   0,  36, 204, 161,   0,  30, 204, 161,   0,  23, 204, 161,   0,  18, 204, 161,   0,  12, 204, 161,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   2, 204, 161,   0,   8, 204, 161,   0,  14, 204, 161,   0,  21, 204, 161,   0,  27, 204, 161,   0,  32, 204, 161,   0,  38, 204, 161,   0,  44, 204, 161,   0,  50, 204, 161,   0,  56, 204, 161,   0,  62, 204, 161,   0,  67, 204, 161,   0,  73, 204, 161,   0,  79, 204, 161,   0,  85, 204, 161,   0,  90, 204, 161,   0,  95, 204, 161,   0, 100, 204, 161,   0, 106, 204, 161,   0, 111, 204, 161,   0, 116, 204, 161,   0, 120, 204, 161,   0, 125, 204, 161,   0, 130, 204, 161,   0, 135, 204, 161,   0, 139, 204, 161,   0, 143, 204, 161,   0, 147, 204, 161,   0, 149, 204, 161,   0, 153, 204, 161,   0, 156, 204, 161,   0, 158, 204, 161,   0, 159, 204, 161,   0, 161, 204, 161,   0, 163, 204, 161,   0, 163, 204, 161,   0, 164, 204, 161,   0, 164, 204, 161,   0, 162, 204, 161,   0, 161, 204, 161,   0, 160, 204, 161,   0, 158, 204, 161,   0, 155, 204, 161,   0, 153, 204, 161,   0, 150, 204, 161,   0, 146, 204, 161,   0, 142, 204, 161,   0, 139, 204, 161,   0, 135, 204, 161,   0, 130, 204, 161,   0, 126, 204, 161,   0, 121, 204, 161,   0, 116, 204, 161,   0, 111, 204, 161,   0, 106, 204, 161,   0, 100, 204, 161,   0,  95, 204, 161,   0,  90, 204, 161,   0,  85, 204, 161,   0,  79, 204, 161,   0,  74, 204, 161,   0,  68, 204, 161,   0,  62, 204, 161,   0,  56, 204, 161,   0,  50, 204, 161,   0,  44, 204, 161,   0,  38, 204, 161,   0,  33, 204, 161,   0,  27, 204, 161,   0,  21, 204, 161,   0,  15, 204, 161,   0,   8, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   5, 204, 161,   0,  11, 204, 161,   0,  17, 204, 161,   0,  23, 204, 161,   0,  29, 204, 161,   0,  35, 204, 161,   0,  41, 204, 161,   0,  48, 204, 161,   0,  53, 204, 161,   0,  59, 204, 161,   0,  65, 204, 161,   0,  71, 204, 161,   0,  76, 204, 161,   0,  82, 204, 161,   0,  88, 204, 161,   0,  93, 204, 161,   0,  99, 204, 161,   0, 105, 204, 161,   0, 109, 204, 161,   0, 115, 204, 161,   0, 120, 204, 161,   0, 125, 204, 161,   0, 130, 204, 161,   0, 134, 204, 161,   0, 140, 204, 161,   0, 143, 204, 161,   0, 148, 204, 161,   0, 152, 204, 161,   0, 155, 204, 161,   0, 158, 204, 161,   0, 161, 204, 161,   0, 164, 204, 161,   0, 166, 204, 161,   0, 167, 204, 161,   0, 169, 204, 161,   0, 170, 204, 161,   0, 170, 204, 161,   0, 170, 204, 161,   0, 169, 204, 161,   0, 167, 204, 161,   0, 167, 204, 161,   0, 164, 204, 161,   0, 162, 204, 161,   0, 158, 204, 161,   0, 155, 204, 161,   0, 152, 204, 161,   0, 148, 204, 161,   0, 144, 204, 161,   0, 139, 204, 161,   0, 135, 204, 161,   0, 130, 204, 161,   0, 125, 204, 161,   0, 120, 204, 161,   0, 115, 204, 161,   0, 110, 204, 161,   0, 104, 204, 161,   0,  99, 204, 161,   0,  94, 204, 161,   0,  88, 204, 161,   0,  82, 204, 161,   0,  76, 204, 161,   0,  70, 204, 161,   0,  65, 204, 161,   0,  59, 204, 161,   0,  53, 204, 161,   0,  47, 204, 161,   0,  42, 204, 161,   0,  35, 204, 161,   0,  30, 204, 161,   0,  24, 204, 161,   0,  17, 204, 161,   0,  11, 204, 161,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   7, 204, 161,   0,  13, 204, 161,   0,  19, 204, 161,   0,  25, 204, 161,   0,  32, 204, 161,   0,  38, 204, 161,   0,  44, 204, 161,   0,  50, 204, 161,   0,  56, 204, 161,   0,  62, 204, 161,   0,  67, 204, 161,   0,  74, 204, 161,   0,  80, 204, 161,   0,  85, 204, 161,   0,  91, 204, 161,   0,  97, 204, 161,   0, 102, 204, 161,   0, 108, 204, 161,   0, 113, 204, 161,   0, 119, 204, 161,   0, 125, 204, 161,   0, 129, 204, 161,   0, 134, 204, 161,   0, 139, 204, 161,   0, 144, 204, 161,   0, 148, 204, 161,   0, 153, 204, 161,   0, 157, 204, 161,   0, 161, 204, 161,   0, 164, 204, 161,   0, 168, 204, 161,   0, 170, 204, 161,   0, 173, 204, 161,   0, 174, 204, 161,   0, 175, 204, 161,   0, 176, 204, 161,   0, 177, 204, 161,   0, 176, 204, 161,   0, 176, 204, 161,   0, 175, 204, 161,   0, 173, 204, 161,   0, 170, 204, 161,   0, 167, 204, 161,   0, 164, 204, 161,   0, 161, 204, 161,   0, 157, 204, 161,   0, 152, 204, 161,   0, 149, 204, 161,   0, 144, 204, 161,   0, 139, 204, 161,   0, 135, 204, 161,   0, 129, 204, 161,   0, 124, 204, 161,   0, 118, 204, 161,   0, 114, 204, 161,   0, 108, 204, 161,   0, 102, 204, 161,   0,  97, 204, 161,   0,  91, 204, 161,   0,  85, 204, 161,   0,  80, 204, 161,   0,  74, 204, 161,   0,  67, 204, 161,   0,  62, 204, 161,   0,  56, 204, 161,   0,  49, 204, 161,   0,  43, 204, 161,   0,  38, 204, 161,   0,  32, 204, 161,   0,  25, 204, 161,   0,  19, 204, 161,   0,  13, 204, 161,   0,   7, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   2, 204, 161,   0,   9, 204, 161,   0,  15, 204, 161,   0,  21, 204, 161,   0,  27, 204, 161,   0,  34, 204, 161,   0,  40, 204, 161,   0,  46, 204, 161,   0,  52, 204, 161,   0,  59, 204, 161,   0,  64, 204, 161,   0,  70, 204, 161,   0,  76, 204, 161,   0,  83, 204, 161,   0,  88, 204, 161,   0,  95, 204, 161,   0, 100, 204, 161,   0, 106, 204, 161,   0, 111, 204, 161,   0, 117, 204, 161,   0, 123, 204, 161,   0, 128, 204, 161,   0, 134, 204, 161,   0, 139, 204, 161,   0, 143, 204, 161,   0, 148, 204, 161,   0, 153, 204, 161,   0, 158, 204, 161,   0, 162, 204, 161,   0, 166, 204, 161,   0, 170, 204, 161,   0, 173, 204, 161,   0, 175, 204, 161,   0, 179, 204, 161,   0, 180, 204, 161,   0, 181, 204, 161,   0, 183, 204, 161,   0, 183, 204, 161,   0, 182, 204, 161,   0, 182, 204, 161,   0, 181, 204, 161,   0, 179, 204, 161,   0, 176, 204, 161,   0, 173, 204, 161,   0, 170, 204, 161,   0, 166, 204, 161,   0, 162, 204, 161,   0, 157, 204, 161,   0, 154, 204, 161,   0, 148, 204, 161,   0, 144, 204, 161,   0, 139, 204, 161,   0, 134, 204, 161,   0, 128, 204, 161,   0, 123, 204, 161,   0, 117, 204, 161,   0, 112, 204, 161,   0, 106, 204, 161,   0, 100, 204, 161,   0,  95, 204, 161,   0,  88, 204, 161,   0,  82, 204, 161,   0,  77, 204, 161,   0,  70, 204, 161,   0,  64, 204, 161,   0,  59, 204, 161,   0,  52, 204, 161,   0,  47, 204, 161,   0,  40, 204, 161,   0,  34, 204, 161,   0,  28, 204, 161,   0,  21, 204, 161,   0,  15, 204, 161,   0,   9, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   4, 204, 161,   0,  11, 204, 161,   0,  17, 204, 161,   0,  23, 204, 161,   0,  30, 204, 161,   0,  36, 204, 161,   0,  42, 204, 161,   0,  49, 204, 161,   0,  54, 204, 161,   0,  60, 204, 161,   0,  67, 204, 161,   0,  73, 204, 161,   0,  79, 204, 161,   0,  85, 204, 161,   0,  91, 204, 161,   0,  97, 204, 161,   0, 103, 204, 161,   0, 108, 204, 161,   0, 114, 204, 161,   0, 120, 204, 161,   0, 126, 204, 161,   0, 131, 204, 161,   0, 137, 204, 161,   0, 143, 204, 161,   0, 148, 204, 161,   0, 153, 204, 161,   0, 158, 204, 161,   0, 162, 204, 161,   0, 167, 204, 161,   0, 172, 204, 161,   0, 176, 204, 161,   0, 178, 204, 161,   0, 182, 204, 161,   0, 184, 204, 161,   0, 187, 204, 161,   0, 188, 204, 161,   0, 190, 204, 161,   0, 190, 204, 161,   0, 189, 204, 161,   0, 188, 204, 161,   0, 187, 204, 161,   0, 185, 204, 161,   0, 182, 204, 161,   0, 179, 204, 161,   0, 176, 204, 161,   0, 172, 204, 161,   0, 167, 204, 161,   0, 163, 204, 161,   0, 158, 204, 161,   0, 153, 204, 161,   0, 148, 204, 161,   0, 143, 204, 161,   0, 137, 204, 161,   0, 132, 204, 161,   0, 126, 204, 161,   0, 120, 204, 161,   0, 115, 204, 161,   0, 108, 204, 161,   0, 103, 204, 161,   0,  97, 204, 161,   0,  91, 204, 161,   0,  85, 204, 161,   0,  79, 204, 161,   0,  73, 204, 161,   0,  67, 204, 161,   0,  61, 204, 161,   0,  54, 204, 161,   0,  48, 204, 161,   0,  42, 204, 161,   0,  35, 204, 161,   0,  29, 204, 161,   0,  23, 204, 161,   0,  17, 204, 161,   0,  11, 204, 161,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  13, 204, 161,   0,  18, 204, 161,   0,  25, 204, 161,   0,  31, 204, 161,   0,  38, 204, 161,   0,  44, 204, 161,   0,  50, 204, 161,   0,  57, 204, 161,   0,  63, 204, 161,   0,  69, 204, 161,   0,  75, 204, 161,   0,  81, 204, 161,   0,  88, 204, 161,   0,  93, 204, 161,   0, 100, 204, 161,   0, 106, 204, 161,   0, 112, 204, 161,   0, 118, 204, 161,   0, 124, 204, 161,   0, 129, 204, 161,   0, 134, 204, 161,   0, 141, 204, 161,   0, 146, 204, 161,   0, 151, 204, 161,   0, 157, 204, 161,   0, 162, 204, 161,   0, 167, 204, 161,   0, 172, 204, 161,   0, 177, 204, 161,   0, 180, 204, 161,   0, 185, 204, 161,   0, 188, 204, 161,   0, 191, 204, 161,   0, 193, 204, 161,   0, 194, 204, 161,   0, 196, 204, 161,   0, 196, 204, 161,   0, 195, 204, 161,   0, 195, 204, 161,   0, 193, 204, 161,   0, 191, 204, 161,   0, 188, 204, 161,   0, 185, 204, 161,   0, 180, 204, 161,   0, 176, 204, 161,   0, 171, 204, 161,   0, 167, 204, 161,   0, 162, 204, 161,   0, 157, 204, 161,   0, 151, 204, 161,   0, 146, 204, 161,   0, 140, 204, 161,   0, 135, 204, 161,   0, 129, 204, 161,   0, 123, 204, 161,   0, 117, 204, 161,   0, 111, 204, 161,   0, 106, 204, 161,   0,  99, 204, 161,   0,  93, 204, 161,   0,  88, 204, 161,   0,  82, 204, 161,   0,  75, 204, 161,   0,  69, 204, 161,   0,  63, 204, 161,   0,  56, 204, 161,   0,  50, 204, 161,   0,  43, 204, 161,   0,  38, 204, 161,   0,  31, 204, 161,   0,  25, 204, 161,   0,  18, 204, 161,   0,  12, 204, 161,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   7, 204, 161,   0,  14, 204, 161,   0,  20, 204, 161,   0,  27, 204, 161,   0,  33, 204, 161,   0,  39, 204, 161,   0,  46, 204, 161,   0,  52, 204, 161,   0,  58, 204, 161,   0,  64, 204, 161,   0,  71, 204, 161,   0,  77, 204, 161,   0,  83, 204, 161,   0,  89, 204, 161,   0,  95, 204, 161,   0, 102, 204, 161,   0, 108, 204, 161,   0, 114, 204, 161,   0, 120, 204, 161,   0, 127, 204, 161,   0, 132, 204, 161,   0, 138, 204, 161,   0, 144, 204, 161,   0, 150, 204, 161,   0, 155, 204, 161,   0, 160, 204, 161,   0, 166, 204, 161,   0, 171, 204, 161,   0, 176, 204, 161,   0, 181, 204, 161,   0, 186, 204, 161,   0, 190, 204, 161,   0, 194, 204, 161,   0, 197, 204, 161,   0, 200, 204, 161,   0, 201, 204, 161,   0, 202, 204, 161,   0, 203, 204, 161,   0, 202, 204, 161,   0, 201, 204, 161,   0, 199, 204, 161,   0, 197, 204, 161,   0, 193, 204, 161,   0, 190, 204, 161,   0, 186, 204, 161,   0, 181, 204, 161,   0, 176, 204, 161,   0, 171, 204, 161,   0, 166, 204, 161,   0, 160, 204, 161,   0, 155, 204, 161,   0, 149, 204, 161,   0, 144, 204, 161,   0, 138, 204, 161,   0, 133, 204, 161,   0, 126, 204, 161,   0, 120, 204, 161,   0, 114, 204, 161,   0, 108, 204, 161,   0, 101, 204, 161,   0,  96, 204, 161,   0,  90, 204, 161,   0,  83, 204, 161,   0,  78, 204, 161,   0,  71, 204, 161,   0,  65, 204, 161,   0,  59, 204, 161,   0,  52, 204, 161,   0,  45, 204, 161,   0,  40, 204, 161,   0,  33, 204, 161,   0,  27, 204, 161,   0,  20, 204, 161,   0,  14, 204, 161,   0,   7, 204, 161,   0,   2,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   2, 204, 161,   0,   9, 204, 161,   0,  15, 204, 161,   0,  22, 204, 161,   0,  28, 204, 161,   0,  35, 204, 161,   0,  41, 204, 161,   0,  47, 204, 161,   0,  53, 204, 161,   0,  60, 204, 161,   0,  66, 204, 161,   0,  72, 204, 161,   0,  79, 204, 161,   0,  86, 204, 161,   0,  92, 204, 161,   0,  98, 204, 161,   0, 104, 204, 161,   0, 110, 204, 161,   0, 116, 204, 161,   0, 123, 204, 161,   0, 128, 204, 161,   0, 134, 204, 161,   0, 141, 204, 161,   0, 147, 204, 161,   0, 152, 204, 161,   0, 159, 204, 161,   0, 164, 204, 161,   0, 170, 204, 161,   0, 175, 204, 161,   0, 180, 204, 161,   0, 186, 204, 161,   0, 191, 204, 161,   0, 195, 204, 161,   0, 198, 204, 161,   0, 202, 204, 161,   0, 205, 204, 161,   0, 208, 204, 161,   0, 208, 204, 161,   0, 209, 204, 161,   0, 208, 204, 161,   0, 208, 204, 161,   0, 205, 204, 161,   0, 202, 204, 161,   0, 199, 204, 161,   0, 195, 204, 161,   0, 190, 204, 161,   0, 186, 204, 161,   0, 180, 204, 161,   0, 175, 204, 161,   0, 169, 204, 161,   0, 164, 204, 161,   0, 159, 204, 161,   0, 153, 204, 161,   0, 147, 204, 161,   0, 141, 204, 161,   0, 135, 204, 161,   0, 129, 204, 161,   0, 123, 204, 161,   0, 116, 204, 161,   0, 111, 204, 161,   0, 104, 204, 161,   0,  98, 204, 161,   0,  91, 204, 161,   0,  86, 204, 161,   0,  79, 204, 161,   0,  73, 204, 161,   0,  67, 204, 161,   0,  60, 204, 161,   0,  54, 204, 161,   0,  47, 204, 161,   0,  41, 204, 161,   0,  34, 204, 161,   0,  28, 204, 161,   0,  21, 204, 161,   0,  15, 204, 161,   0,   9, 204, 161,   0,   3,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   3, 204, 161,   0,  10, 204, 161,   0,  17, 204, 161,   0,  23, 204, 161,   0,  29, 204, 161,   0,  36, 204, 161,   0,  42, 204, 161,   0,  48, 204, 161,   0,  55, 204, 161,   0,  61, 204, 161,   0,  68, 204, 161,   0,  74, 204, 161,   0,  80, 204, 161,   0,  87, 204, 161,   0,  93, 204, 161,   0,  99, 204, 161,   0, 106, 204, 161,   0, 112, 204, 161,   0, 119, 204, 161,   0, 124, 204, 161,   0, 131, 204, 161,   0, 137, 204, 161,   0, 143, 204, 161,   0, 149, 204, 161,   0, 155, 204, 161,   0, 162, 204, 161,   0, 167, 204, 161,   0, 173, 204, 161,   0, 179, 204, 161,   0, 184, 204, 161,   0, 190, 204, 161,   0, 194, 204, 161,   0, 200, 204, 161,   0, 204, 204, 161,   0, 208, 204, 161,   0, 211, 204, 161,   0, 213, 204, 161,   0, 216, 204, 161,   0, 216, 204, 161,   0, 215, 204, 161,   0, 214, 204, 161,   0, 211, 204, 161,   0, 207, 204, 161,   0, 204, 204, 161,   0, 200, 204, 161,   0, 195, 204, 161,   0, 190, 204, 161,   0, 184, 204, 161,   0, 179, 204, 161,   0, 173, 204, 161,   0, 167, 204, 161,   0, 161, 204, 161,   0, 155, 204, 161,   0, 149, 204, 161,   0, 143, 204, 161,   0, 137, 204, 161,   0, 131, 204, 161,   0, 125, 204, 161,   0, 119, 204, 161,   0, 113, 204, 161,   0, 106, 204, 161,   0,  99, 204, 161,   0,  93, 204, 161,   0,  87, 204, 161,   0,  81, 204, 161,   0,  74, 204, 161,   0,  68, 204, 161,   0,  61, 204, 161,   0,  55, 204, 161,   0,  49, 204, 161,   0,  42, 204, 161,   0,  36, 204, 161,   0,  29, 204, 161,   0,  23, 204, 161,   0,  16, 204, 161,   0,  10, 204, 161,   0,   4,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   4, 204, 161,   0,  11, 204, 161,   0,  17, 204, 161,   0,  24, 204, 161,   0,  30, 204, 161,   0,  37, 204, 161,   0,  44, 204, 161,   0,  49, 204, 161,   0,  56, 204, 161,   0,  63, 204, 161,   0,  69, 204, 161,   0,  75, 204, 161,   0,  82, 204, 161,   0,  88, 204, 161,   0,  95, 204, 161,   0, 101, 204, 161,   0, 107, 204, 161,   0, 114, 204, 161,   0, 121, 204, 161,   0, 127, 204, 161,   0, 133, 204, 161,   0, 139, 204, 161,   0, 145, 204, 161,   0, 152, 204, 161,   0, 158, 204, 161,   0, 164, 204, 161,   0, 170, 204, 161,   0, 176, 204, 161,   0, 182, 204, 161,   0, 188, 204, 161,   0, 193, 204, 161,   0, 199, 204, 161,   0, 203, 204, 161,   0, 208, 204, 161,   0, 214, 204, 161,   0, 217, 204, 161,   0, 220, 204, 161,   0, 221, 204, 161,   0, 222, 204, 161,   0, 222, 204, 161,   0, 220, 204, 161,   0, 217, 204, 161,   0, 213, 204, 161,   0, 209, 204, 161,   0, 204, 204, 161,   0, 199, 204, 161,   0, 193, 204, 161,   0, 187, 204, 161,   0, 182, 204, 161,   0, 176, 204, 161,   0, 170, 204, 161,   0, 163, 204, 161,   0, 157, 204, 161,   0, 151, 204, 161,   0, 146, 204, 161,   0, 139, 204, 161,   0, 133, 204, 161,   0, 126, 204, 161,   0, 120, 204, 161,   0, 114, 204, 161,   0, 107, 204, 161,   0, 101, 204, 161,   0,  95, 204, 161,   0,  88, 204, 161,   0,  82, 204, 161,   0,  75, 204, 161,   0,  69, 204, 161,   0,  63, 204, 161,   0,  56, 204, 161,   0,  50, 204, 161,   0,  43, 204, 161,   0,  36, 204, 161,   0,  30, 204, 161,   0,  24, 204, 161,   0,  17, 204, 161,   0,  10, 204, 161,   0,   4,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   5, 204, 161,   0,  12, 204, 161,   0,  18, 204, 161,   0,  25, 204, 161,   0,  31, 204, 161,   0,  37, 204, 161,   0,  44, 204, 161,   0,  50, 204, 161,   0,  58, 204, 161,   0,  63, 204, 161,   0,  70, 204, 161,   0,  77, 204, 161,   0,  83, 204, 161,   0,  90, 204, 161,   0,  96, 204, 161,   0, 102, 204, 161,   0, 109, 204, 161,   0, 115, 204, 161,   0, 122, 204, 161,   0, 128, 204, 161,   0, 135, 204, 161,   0, 141, 204, 161,   0, 148, 204, 161,   0, 153, 204, 161,   0, 160, 204, 161,   0, 166, 204, 161,   0, 172, 204, 161,   0, 178, 204, 161,   0, 184, 204, 161,   0, 191, 204, 161,   0, 197, 204, 161,   0, 202, 204, 161,   0, 208, 204, 161,   0, 213, 204, 161,   0, 218, 204, 161,   0, 223, 204, 161,   0, 226, 204, 161,   0, 228, 204, 161,   0, 228, 204, 161,   0, 228, 204, 161,   0, 226, 204, 161,   0, 222, 204, 161,   0, 218, 204, 161,   0, 213, 204, 161,   0, 208, 204, 161,   0, 202, 204, 161,   0, 197, 204, 161,   0, 190, 204, 161,   0, 184, 204, 161,   0, 178, 204, 161,   0, 172, 204, 161,   0, 166, 204, 161,   0, 159, 204, 161,   0, 153, 204, 161,   0, 148, 204, 161,   0, 141, 204, 161,   0, 134, 204, 161,   0, 128, 204, 161,   0, 121, 204, 161,   0, 115, 204, 161,   0, 109, 204, 161,   0, 102, 204, 161,   0,  96, 204, 161,   0,  90, 204, 161,   0,  83, 204, 161,   0,  77, 204, 161,   0,  70, 204, 161,   0,  64, 204, 161,   0,  57, 204, 161,   0,  51, 204, 161,   0,  44, 204, 161,   0,  37, 204, 161,   0,  31, 204, 161,   0,  24, 204, 161,   0,  18, 204, 161,   0,  12, 204, 161,   0,   5,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   5, 204, 161,   0,  12, 204, 161,   0,  19, 204, 161,   0,  26, 204, 161,   0,  32, 204, 161,   0,  38, 204, 161,   0,  45, 204, 161,   0,  52, 204, 161,   0,  57, 204, 161,   0,  65, 204, 161,   0,  71, 204, 161,   0,  77, 204, 161,   0,  84, 204, 161,   0,  90, 204, 161,   0,  97, 204, 161,   0, 104, 204, 161,   0, 110, 204, 161,   0, 116, 204, 161,   0, 123, 204, 161,   0, 129, 204, 161,   0, 136, 204, 161,   0, 142, 204, 161,   0, 148, 204, 161,   0, 155, 204, 161,   0, 162, 204, 161,   0, 168, 204, 161,   0, 174, 204, 161,   0, 180, 204, 161,   0, 187, 204, 161,   0, 193, 204, 161,   0, 200, 204, 161,   0, 205, 204, 161,   0, 211, 204, 161,   0, 217, 204, 161,   0, 223, 204, 161,   0, 228, 204, 161,   0, 231, 204, 161,   0, 234, 204, 161,   0, 235, 204, 161,   0, 235, 204, 161,   0, 231, 204, 161,   0, 227, 204, 161,   0, 222, 204, 161,   0, 217, 204, 161,   0, 211, 204, 161,   0, 205, 204, 161,   0, 199, 204, 161,   0, 193, 204, 161,   0, 187, 204, 161,   0, 180, 204, 161,   0, 174, 204, 161,   0, 168, 204, 161,   0, 162, 204, 161,   0, 155, 204, 161,   0, 149, 204, 161,   0, 143, 204, 161,   0, 135, 204, 161,   0, 129, 204, 161,   0, 122, 204, 161,   0, 116, 204, 161,   0, 110, 204, 161,   0, 104, 204, 161,   0,  97, 204, 161,   0,  90, 204, 161,   0,  84, 204, 161,   0,  77, 204, 161,   0,  71, 204, 161,   0,  64, 204, 161,   0,  58, 204, 161,   0,  52, 204, 161,   0,  45, 204, 161,   0,  39, 204, 161,   0,  32, 204, 161,   0,  25, 204, 161,   0,  19, 204, 161,   0,  12, 204, 161,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  13, 204, 161,   0,  19, 204, 161,   0,  26, 204, 161,   0,  33, 204, 161,   0,  39, 204, 161,   0,  45, 204, 161,   0,  52, 204, 161,   0,  58, 204, 161,   0,  65, 204, 161,   0,  72, 204, 161,   0,  78, 204, 161,   0,  84, 204, 161,   0,  91, 204, 161,   0,  97, 204, 161,   0, 104, 204, 161,   0, 111, 204, 161,   0, 117, 204, 161,   0, 124, 204, 161,   0, 130, 204, 161,   0, 136, 204, 161,   0, 143, 204, 161,   0, 149, 204, 161,   0, 156, 204, 161,   0, 162, 204, 161,   0, 169, 204, 161,   0, 175, 204, 161,   0, 182, 204, 161,   0, 188, 204, 161,   0, 195, 204, 161,   0, 201, 204, 161,   0, 207, 204, 161,   0, 213, 204, 161,   0, 220, 204, 161,   0, 226, 204, 161,   0, 232, 204, 161,   0, 236, 204, 161,   0, 240, 204, 161,   0, 241, 204, 161,   0, 240, 204, 161,   0, 237, 204, 161,   0, 231, 204, 161,   0, 226, 204, 161,   0, 219, 204, 161,   0, 213, 204, 161,   0, 207, 204, 161,   0, 201, 204, 161,   0, 194, 204, 161,   0, 188, 204, 161,   0, 182, 204, 161,   0, 175, 204, 161,   0, 169, 204, 161,   0, 162, 204, 161,   0, 156, 204, 161,   0, 150, 204, 161,   0, 143, 204, 161,   0, 136, 204, 161,   0, 130, 204, 161,   0, 123, 204, 161,   0, 117, 204, 161,   0, 111, 204, 161,   0, 104, 204, 161,   0,  98, 204, 161,   0,  91, 204, 161,   0,  84, 204, 161,   0,  78, 204, 161,   0,  71, 204, 161,   0,  65, 204, 161,   0,  58, 204, 161,   0,  52, 204, 161,   0,  45, 204, 161,   0,  38, 204, 161,   0,  32, 204, 161,   0,  26, 204, 161,   0,  20, 204, 161,   0,  13, 204, 161,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   7, 204, 161,   0,  13, 204, 161,   0,  19, 204, 161,   0,  26, 204, 161,   0,  33, 204, 161,   0,  39, 204, 161,   0,  45, 204, 161,   0,  52, 204, 161,   0,  59, 204, 161,   0,  65, 204, 161,   0,  71, 204, 161,   0,  79, 204, 161,   0,  85, 204, 161,   0,  92, 204, 161,   0,  98, 204, 161,   0, 104, 204, 161,   0, 111, 204, 161,   0, 117, 204, 161,   0, 124, 204, 161,   0, 131, 204, 161,   0, 137, 204, 161,   0, 144, 204, 161,   0, 150, 204, 161,   0, 157, 204, 161,   0, 163, 204, 161,   0, 169, 204, 161,   0, 177, 204, 161,   0, 182, 204, 161,   0, 189, 204, 161,   0, 196, 204, 161,   0, 202, 204, 161,   0, 208, 204, 161,   0, 216, 204, 161,   0, 221, 204, 161,   0, 228, 204, 161,   0, 234, 204, 161,   0, 241, 204, 161,   0, 245, 204, 161,   0, 248, 204, 161,   0, 246, 204, 161,   0, 240, 204, 161,   0, 235, 204, 161,   0, 228, 204, 161,   0, 222, 204, 161,   0, 216, 204, 161,   0, 208, 204, 161,   0, 202, 204, 161,   0, 196, 204, 161,   0, 189, 204, 161,   0, 183, 204, 161,   0, 177, 204, 161,   0, 170, 204, 161,   0, 163, 204, 161,   0, 157, 204, 161,   0, 150, 204, 161,   0, 144, 204, 161,   0, 137, 204, 161,   0, 131, 204, 161,   0, 124, 204, 161,   0, 117, 204, 161,   0, 111, 204, 161,   0, 105, 204, 161,   0,  98, 204, 161,   0,  91, 204, 161,   0,  84, 204, 161,   0,  79, 204, 161,   0,  72, 204, 161,   0,  65, 204, 161,   0,  58, 204, 161,   0,  53, 204, 161,   0,  46, 204, 161,   0,  39, 204, 161,   0,  32, 204, 161,   0,  27, 204, 161,   0,  19, 204, 161,   0,  13, 204, 161,   0,   7,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   7, 204, 161,   0,  13, 204, 161,   0,  19, 204, 161,   0,  26, 204, 161,   0,  33, 204, 161,   0,  39, 204, 161,   0,  46, 204, 161,   0,  53, 204, 161,   0,  59, 204, 161,   0,  66, 204, 161,   0,  72, 204, 161,   0,  79, 204, 161,   0,  85, 204, 161,   0,  92, 204, 161,   0,  98, 204, 161,   0, 105, 204, 161,   0, 111, 204, 161,   0, 117, 204, 161,   0, 124, 204, 161,   0, 131, 204, 161,   0, 137, 204, 161,   0, 144, 204, 161,   0, 151, 204, 161,   0, 157, 204, 161,   0, 163, 204, 161,   0, 170, 204, 161,   0, 177, 204, 161,   0, 184, 204, 161,   0, 190, 204, 161,   0, 196, 204, 161,   0, 203, 204, 161,   0, 209, 204, 161,   0, 215, 204, 161,   0, 223, 204, 161,   0, 229, 204, 161,   0, 235, 204, 161,   0, 241, 204, 161,   0, 248, 204, 161,   0, 255, 204, 161,   0, 248, 204, 161,   0, 242, 204, 161,   0, 236, 204, 161,   0, 229, 204, 161,   0, 223, 204, 161,   0, 216, 204, 161,   0, 209, 204, 161,   0, 203, 204, 161,   0, 196, 204, 161,   0, 189, 204, 161,   0, 183, 204, 161,   0, 177, 204, 161,   0, 170, 204, 161,   0, 163, 204, 161,   0, 157, 204, 161,   0, 150, 204, 161,   0, 144, 204, 161,   0, 137, 204, 161,   0, 131, 204, 161,   0, 124, 204, 161,   0, 118, 204, 161,   0, 111, 204, 161,   0, 104, 204, 161,   0,  98, 204, 161,   0,  91, 204, 161,   0,  85, 204, 161,   0,  78, 204, 161,   0,  72, 204, 161,   0,  65, 204, 161,   0,  59, 204, 161,   0,  52, 204, 161,   0,  46, 204, 161,   0,  40, 204, 161,   0,  33, 204, 161,   0,  26, 204, 161,   0,  20, 204, 161,   0,  13, 204, 161,   0,   7,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   7, 204, 161,   0,  13, 204, 161,   0,  20, 204, 161,   0,  26, 204, 161,   0,  32, 204, 161,   0,  39, 204, 161,   0,  45, 204, 161,   0,  52, 204, 161,   0,  59, 204, 161,   0,  65, 204, 161,   0,  72, 204, 161,   0,  78, 204, 161,   0,  85, 204, 161,   0,  91, 204, 161,   0,  98, 204, 161,   0, 104, 204, 161,   0, 111, 204, 161,   0, 117, 204, 161,   0, 124, 204, 161,   0, 130, 204, 161,   0, 137, 204, 161,   0, 143, 204, 161,   0, 151, 204, 161,   0, 156, 204, 161,   0, 163, 204, 161,   0, 170, 204, 161,   0, 177, 204, 161,   0, 182, 204, 161,   0, 190, 204, 161,   0, 196, 204, 161,   0, 202, 204, 161,   0, 209, 204, 161,   0, 215, 204, 161,   0, 222, 204, 161,   0, 228, 204, 161,   0, 235, 204, 161,   0, 240, 204, 161,   0, 246, 204, 161,   0, 248, 204, 161,   0, 246, 204, 161,   0, 240, 204, 161,   0, 234, 204, 161,   0, 228, 204, 161,   0, 222, 204, 161,   0, 215, 204, 161,   0, 208, 204, 161,   0, 202, 204, 161,   0, 196, 204, 161,   0, 190, 204, 161,   0, 183, 204, 161,   0, 176, 204, 161,   0, 170, 204, 161,   0, 163, 204, 161,   0, 157, 204, 161,   0, 150, 204, 161,   0, 144, 204, 161,   0, 138, 204, 161,   0, 131, 204, 161,   0, 124, 204, 161,   0, 117, 204, 161,   0, 111, 204, 161,   0, 104, 204, 161,   0,  98, 204, 161,   0,  91, 204, 161,   0,  85, 204, 161,   0,  78, 204, 161,   0,  72, 204, 161,   0,  65, 204, 161,   0,  59, 204, 161,   0,  52, 204, 161,   0,  46, 204, 161,   0,  39, 204, 161,   0,  33, 204, 161,   0,  26, 204, 161,   0,  19, 204, 161,   0,  13, 204, 161,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  13, 204, 161,   0,  19, 204, 161,   0,  26, 204, 161,   0,  33, 204, 161,   0,  39, 204, 161,   0,  45, 204, 161,   0,  52, 204, 161,   0,  59, 204, 161,   0,  65, 204, 161,   0,  71, 204, 161,   0,  78, 204, 161,   0,  85, 204, 161,   0,  91, 204, 161,   0,  98, 204, 161,   0, 104, 204, 161,   0, 111, 204, 161,   0, 117, 204, 161,   0, 124, 204, 161,   0, 130, 204, 161,   0, 137, 204, 161,   0, 143, 204, 161,   0, 149, 204, 161,   0, 156, 204, 161,   0, 163, 204, 161,   0, 169, 204, 161,   0, 175, 204, 161,   0, 181, 204, 161,   0, 189, 204, 161,   0, 195, 204, 161,   0, 201, 204, 161,   0, 207, 204, 161,   0, 214, 204, 161,   0, 220, 204, 161,   0, 225, 204, 161,   0, 232, 204, 161,   0, 237, 204, 161,   0, 240, 204, 161,   0, 242, 204, 161,   0, 241, 204, 161,   0, 236, 204, 161,   0, 231, 204, 161,   0, 226, 204, 161,   0, 220, 204, 161,   0, 214, 204, 161,   0, 207, 204, 161,   0, 201, 204, 161,   0, 195, 204, 161,   0, 189, 204, 161,   0, 182, 204, 161,   0, 175, 204, 161,   0, 169, 204, 161,   0, 163, 204, 161,   0, 156, 204, 161,   0, 150, 204, 161,   0, 143, 204, 161,   0, 137, 204, 161,   0, 130, 204, 161,   0, 124, 204, 161,   0, 117, 204, 161,   0, 110, 204, 161,   0, 104, 204, 161,   0,  97, 204, 161,   0,  91, 204, 161,   0,  84, 204, 161,   0,  78, 204, 161,   0,  71, 204, 161,   0,  65, 204, 161,   0,  59, 204, 161,   0,  52, 204, 161,   0,  45, 204, 161,   0,  39, 204, 161,   0,  32, 204, 161,   0,  25, 204, 161,   0,  19, 204, 161,   0,  13, 204, 161,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  12, 204, 161,   0,  19, 204, 161,   0,  25, 204, 161,   0,  32, 204, 161,   0,  39, 204, 161,   0,  45, 204, 161,   0,  51, 204, 161,   0,  58, 204, 161,   0,  64, 204, 161,   0,  71, 204, 161,   0,  77, 204, 161,   0,  84, 204, 161,   0,  90, 204, 161,   0,  97, 204, 161,   0, 103, 204, 161,   0, 109, 204, 161,   0, 117, 204, 161,   0, 123, 204, 161,   0, 129, 204, 161,   0, 135, 204, 161,   0, 142, 204, 161,   0, 149, 204, 161,   0, 155, 204, 161,   0, 161, 204, 161,   0, 168, 204, 161,   0, 174, 204, 161,   0, 181, 204, 161,   0, 187, 204, 161,   0, 193, 204, 161,   0, 200, 204, 161,   0, 205, 204, 161,   0, 211, 204, 161,   0, 217, 204, 161,   0, 222, 204, 161,   0, 227, 204, 161,   0, 231, 204, 161,   0, 234, 204, 161,   0, 236, 204, 161,   0, 235, 204, 161,   0, 231, 204, 161,   0, 227, 204, 161,   0, 222, 204, 161,   0, 217, 204, 161,   0, 211, 204, 161,   0, 205, 204, 161,   0, 199, 204, 161,   0, 193, 204, 161,   0, 186, 204, 161,   0, 180, 204, 161,   0, 174, 204, 161,   0, 167, 204, 161,   0, 162, 204, 161,   0, 155, 204, 161,   0, 149, 204, 161,   0, 142, 204, 161,   0, 135, 204, 161,   0, 130, 204, 161,   0, 123, 204, 161,   0, 116, 204, 161,   0, 110, 204, 161,   0, 103, 204, 161,   0,  97, 204, 161,   0,  90, 204, 161,   0,  84, 204, 161,   0,  77, 204, 161,   0,  70, 204, 161,   0,  65, 204, 161,   0,  58, 204, 161,   0,  52, 204, 161,   0,  45, 204, 161,   0,  38, 204, 161,   0,  31, 204, 161,   0,  25, 204, 161,   0,  19, 204, 161,   0,  12, 204, 161,   0,   6,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   5, 204, 161,   0,  11, 204, 161,   0,  19, 204, 161,   0,  25, 204, 161,   0,  31, 204, 161,   0,  38, 204, 161,   0,  44, 204, 161,   0,  51, 204, 161,   0,  57, 204, 161,   0,  63, 204, 161,   0,  71, 204, 161,   0,  76, 204, 161,   0,  83, 204, 161,   0,  89, 204, 161,   0,  95, 204, 161,   0, 102, 204, 161,   0, 108, 204, 161,   0, 116, 204, 161,   0, 121, 204, 161,   0, 128, 204, 161,   0, 135, 204, 161,   0, 141, 204, 161,   0, 147, 204, 161,   0, 154, 204, 161,   0, 160, 204, 161,   0, 166, 204, 161,   0, 173, 204, 161,   0, 178, 204, 161,   0, 185, 204, 161,   0, 191, 204, 161,   0, 197, 204, 161,   0, 203, 204, 161,   0, 208, 204, 161,   0, 213, 204, 161,   0, 218, 204, 161,   0, 222, 204, 161,   0, 226, 204, 161,   0, 228, 204, 161,   0, 229, 204, 161,   0, 228, 204, 161,   0, 226, 204, 161,   0, 222, 204, 161,   0, 218, 204, 161,   0, 213, 204, 161,   0, 208, 204, 161,   0, 202, 204, 161,   0, 196, 204, 161,   0, 191, 204, 161,   0, 185, 204, 161,   0, 179, 204, 161,   0, 172, 204, 161,   0, 166, 204, 161,   0, 160, 204, 161,   0, 153, 204, 161,   0, 147, 204, 161,   0, 141, 204, 161,   0, 134, 204, 161,   0, 128, 204, 161,   0, 122, 204, 161,   0, 115, 204, 161,   0, 108, 204, 161,   0, 103, 204, 161,   0,  96, 204, 161,   0,  90, 204, 161,   0,  83, 204, 161,   0,  77, 204, 161,   0,  70, 204, 161,   0,  64, 204, 161,   0,  57, 204, 161,   0,  51, 204, 161,   0,  44, 204, 161,   0,  37, 204, 161,   0,  31, 204, 161,   0,  25, 204, 161,   0,  18, 204, 161,   0,  11, 204, 161,   0,   5,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   4, 204, 161,   0,  11, 204, 161,   0,  17, 204, 161,   0,  24, 204, 161,   0,  30, 204, 161,   0,  37, 204, 161,   0,  44, 204, 161,   0,  50, 204, 161,   0,  56, 204, 161,   0,  62, 204, 161,   0,  69, 204, 161,   0,  75, 204, 161,   0,  82, 204, 161,   0,  88, 204, 161,   0,  94, 204, 161,   0, 101, 204, 161,   0, 107, 204, 161,   0, 114, 204, 161,   0, 120, 204, 161,   0, 127, 204, 161,   0, 133, 204, 161,   0, 139, 204, 161,   0, 145, 204, 161,   0, 152, 204, 161,   0, 158, 204, 161,   0, 164, 204, 161,   0, 170, 204, 161,   0, 176, 204, 161,   0, 182, 204, 161,   0, 188, 204, 161,   0, 193, 204, 161,   0, 198, 204, 161,   0, 204, 204, 161,   0, 209, 204, 161,   0, 214, 204, 161,   0, 217, 204, 161,   0, 220, 204, 161,   0, 221, 204, 161,   0, 222, 204, 161,   0, 222, 204, 161,   0, 220, 204, 161,   0, 217, 204, 161,   0, 213, 204, 161,   0, 209, 204, 161,   0, 204, 204, 161,   0, 198, 204, 161,   0, 193, 204, 161,   0, 188, 204, 161,   0, 182, 204, 161,   0, 176, 204, 161,   0, 170, 204, 161,   0, 164, 204, 161,   0, 158, 204, 161,   0, 152, 204, 161,   0, 145, 204, 161,   0, 139, 204, 161,   0, 133, 204, 161,   0, 127, 204, 161,   0, 120, 204, 161,   0, 114, 204, 161,   0, 108, 204, 161,   0, 101, 204, 161,   0,  95, 204, 161,   0,  89, 204, 161,   0,  82, 204, 161,   0,  75, 204, 161,   0,  69, 204, 161,   0,  62, 204, 161,   0,  56, 204, 161,   0,  50, 204, 161,   0,  44, 204, 161,   0,  37, 204, 161,   0,  30, 204, 161,   0,  24, 204, 161,   0,  17, 204, 161,   0,  11, 204, 161,   0,   5,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   4, 204, 161,   0,  10, 204, 161,   0,  16, 204, 161,   0,  23, 204, 161,   0,  29, 204, 161,   0,  36, 204, 161,   0,  43, 204, 161,   0,  49, 204, 161,   0,  55, 204, 161,   0,  61, 204, 161,   0,  67, 204, 161,   0,  74, 204, 161,   0,  80, 204, 161,   0,  87, 204, 161,   0,  93, 204, 161,   0,  99, 204, 161,   0, 105, 204, 161,   0, 112, 204, 161,   0, 118, 204, 161,   0, 125, 204, 161,   0, 131, 204, 161,   0, 137, 204, 161,   0, 143, 204, 161,   0, 150, 204, 161,   0, 156, 204, 161,   0, 161, 204, 161,   0, 167, 204, 161,   0, 173, 204, 161,   0, 178, 204, 161,   0, 185, 204, 161,   0, 189, 204, 161,   0, 195, 204, 161,   0, 199, 204, 161,   0, 204, 204, 161,   0, 208, 204, 161,   0, 211, 204, 161,   0, 213, 204, 161,   0, 216, 204, 161,   0, 215, 204, 161,   0, 216, 204, 161,   0, 214, 204, 161,   0, 211, 204, 161,   0, 208, 204, 161,   0, 204, 204, 161,   0, 200, 204, 161,   0, 194, 204, 161,   0, 190, 204, 161,   0, 185, 204, 161,   0, 178, 204, 161,   0, 173, 204, 161,   0, 167, 204, 161,   0, 161, 204, 161,   0, 155, 204, 161,   0, 149, 204, 161,   0, 143, 204, 161,   0, 137, 204, 161,   0, 131, 204, 161,   0, 125, 204, 161,   0, 118, 204, 161,   0, 112, 204, 161,   0, 106, 204, 161,   0,  99, 204, 161,   0,  93, 204, 161,   0,  87, 204, 161,   0,  80, 204, 161,   0,  75, 204, 161,   0,  68, 204, 161,   0,  61, 204, 161,   0,  55, 204, 161,   0,  48, 204, 161,   0,  42, 204, 161,   0,  35, 204, 161,   0,  29, 204, 161,   0,  23, 204, 161,   0,  16, 204, 161,   0,   9, 204, 161,   0,   4,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   2, 204, 161,   0,   8, 204, 161,   0,  15, 204, 161,   0,  21, 204, 161,   0,  28, 204, 161,   0,  34, 204, 161,   0,  40, 204, 161,   0,  47, 204, 161,   0,  53, 204, 161,   0,  59, 204, 161,   0,  66, 204, 161,   0,  72, 204, 161,   0,  79, 204, 161,   0,  85, 204, 161,   0,  91, 204, 161,   0,  98, 204, 161,   0, 104, 204, 161,   0, 111, 204, 161,   0, 116, 204, 161,   0, 123, 204, 161,   0, 129, 204, 161,   0, 135, 204, 161,   0, 141, 204, 161,   0, 147, 204, 161,   0, 152, 204, 161,   0, 159, 204, 161,   0, 164, 204, 161,   0, 170, 204, 161,   0, 175, 204, 161,   0, 180, 204, 161,   0, 186, 204, 161,   0, 190, 204, 161,   0, 195, 204, 161,   0, 199, 204, 161,   0, 203, 204, 161,   0, 205, 204, 161,   0, 208, 204, 161,   0, 209, 204, 161,   0, 209, 204, 161,   0, 209, 204, 161,   0, 208, 204, 161,   0, 205, 204, 161,   0, 203, 204, 161,   0, 198, 204, 161,   0, 195, 204, 161,   0, 190, 204, 161,   0, 185, 204, 161,   0, 180, 204, 161,   0, 175, 204, 161,   0, 170, 204, 161,   0, 164, 204, 161,   0, 159, 204, 161,   0, 153, 204, 161,   0, 147, 204, 161,   0, 141, 204, 161,   0, 134, 204, 161,   0, 129, 204, 161,   0, 123, 204, 161,   0, 116, 204, 161,   0, 111, 204, 161,   0, 104, 204, 161,   0,  98, 204, 161,   0,  91, 204, 161,   0,  85, 204, 161,   0,  79, 204, 161,   0,  73, 204, 161,   0,  67, 204, 161,   0,  60, 204, 161,   0,  53, 204, 161,   0,  47, 204, 161,   0,  41, 204, 161,   0,  35, 204, 161,   0,  28, 204, 161,   0,  21, 204, 161,   0,  16, 204, 161,   0,   9, 204, 161,   0,   3,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   8, 204, 161,   0,  14, 204, 161,   0,  21, 204, 161,   0,  27, 204, 161,   0,  33, 204, 161,   0,  39, 204, 161,   0,  46, 204, 161,   0,  52, 204, 161,   0,  58, 204, 161,   0,  65, 204, 161,   0,  71, 204, 161,   0,  77, 204, 161,   0,  83, 204, 161,   0,  90, 204, 161,   0,  95, 204, 161,   0, 102, 204, 161,   0, 108, 204, 161,   0, 114, 204, 161,   0, 121, 204, 161,   0, 127, 204, 161,   0, 132, 204, 161,   0, 138, 204, 161,   0, 144, 204, 161,   0, 149, 204, 161,   0, 155, 204, 161,   0, 161, 204, 161,   0, 166, 204, 161,   0, 171, 204, 161,   0, 176, 204, 161,   0, 181, 204, 161,   0, 185, 204, 161,   0, 189, 204, 161,   0, 194, 204, 161,   0, 197, 204, 161,   0, 200, 204, 161,   0, 201, 204, 161,   0, 203, 204, 161,   0, 203, 204, 161,   0, 203, 204, 161,   0, 201, 204, 161,   0, 200, 204, 161,   0, 196, 204, 161,   0, 194, 204, 161,   0, 190, 204, 161,   0, 185, 204, 161,   0, 181, 204, 161,   0, 176, 204, 161,   0, 171, 204, 161,   0, 166, 204, 161,   0, 160, 204, 161,   0, 155, 204, 161,   0, 150, 204, 161,   0, 144, 204, 161,   0, 138, 204, 161,   0, 132, 204, 161,   0, 127, 204, 161,   0, 120, 204, 161,   0, 114, 204, 161,   0, 108, 204, 161,   0, 102, 204, 161,   0,  96, 204, 161,   0,  89, 204, 161,   0,  84, 204, 161,   0,  77, 204, 161,   0,  70, 204, 161,   0,  65, 204, 161,   0,  58, 204, 161,   0,  52, 204, 161,   0,  45, 204, 161,   0,  39, 204, 161,   0,  33, 204, 161,   0,  27, 204, 161,   0,  20, 204, 161,   0,  14, 204, 161,   0,   7, 204, 161,   0,   1,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  12, 204, 161,   0,  18, 204, 161,   0,  25, 204, 161,   0,  31, 204, 161,   0,  37, 204, 161,   0,  44, 204, 161,   0,  51, 204, 161,   0,  56, 204, 161,   0,  63, 204, 161,   0,  69, 204, 161,   0,  76, 204, 161,   0,  81, 204, 161,   0,  88, 204, 161,   0,  93, 204, 161,   0, 100, 204, 161,   0, 105, 204, 161,   0, 112, 204, 161,   0, 118, 204, 161,   0, 124, 204, 161,   0, 129, 204, 161,   0, 135, 204, 161,   0, 140, 204, 161,   0, 146, 204, 161,   0, 152, 204, 161,   0, 157, 204, 161,   0, 162, 204, 161,   0, 167, 204, 161,   0, 172, 204, 161,   0, 177, 204, 161,   0, 180, 204, 161,   0, 184, 204, 161,   0, 188, 204, 161,   0, 191, 204, 161,   0, 193, 204, 161,   0, 195, 204, 161,   0, 196, 204, 161,   0, 197, 204, 161,   0, 196, 204, 161,   0, 195, 204, 161,   0, 193, 204, 161,   0, 191, 204, 161,   0, 188, 204, 161,   0, 184, 204, 161,   0, 180, 204, 161,   0, 176, 204, 161,   0, 172, 204, 161,   0, 167, 204, 161,   0, 162, 204, 161,   0, 157, 204, 161,   0, 152, 204, 161,   0, 146, 204, 161,   0, 140, 204, 161,   0, 135, 204, 161,   0, 129, 204, 161,   0, 124, 204, 161,   0, 118, 204, 161,   0, 112, 204, 161,   0, 105, 204, 161,   0,  99, 204, 161,   0,  94, 204, 161,   0,  87, 204, 161,   0,  81, 204, 161,   0,  75, 204, 161,   0,  69, 204, 161,   0,  62, 204, 161,   0,  57, 204, 161,   0,  50, 204, 161,   0,  44, 204, 161,   0,  38, 204, 161,   0,  32, 204, 161,   0,  25, 204, 161,   0,  19, 204, 161,   0,  13, 204, 161,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   5, 204, 161,   0,  11, 204, 161,   0,  17, 204, 161,   0,  24, 204, 161,   0,  30, 204, 161,   0,  36, 204, 161,   0,  42, 204, 161,   0,  49, 204, 161,   0,  55, 204, 161,   0,  60, 204, 161,   0,  66, 204, 161,   0,  73, 204, 161,   0,  79, 204, 161,   0,  85, 204, 161,   0,  91, 204, 161,   0,  97, 204, 161,   0, 103, 204, 161,   0, 109, 204, 161,   0, 115, 204, 161,   0, 120, 204, 161,   0, 127, 204, 161,   0, 131, 204, 161,   0, 137, 204, 161,   0, 143, 204, 161,   0, 148, 204, 161,   0, 152, 204, 161,   0, 158, 204, 161,   0, 163, 204, 161,   0, 167, 204, 161,   0, 172, 204, 161,   0, 176, 204, 161,   0, 179, 204, 161,   0, 182, 204, 161,   0, 184, 204, 161,   0, 186, 204, 161,   0, 189, 204, 161,   0, 189, 204, 161,   0, 190, 204, 161,   0, 190, 204, 161,   0, 188, 204, 161,   0, 187, 204, 161,   0, 185, 204, 161,   0, 182, 204, 161,   0, 179, 204, 161,   0, 175, 204, 161,   0, 171, 204, 161,   0, 167, 204, 161,   0, 163, 204, 161,   0, 158, 204, 161,   0, 153, 204, 161,   0, 148, 204, 161,   0, 143, 204, 161,   0, 137, 204, 161,   0, 131, 204, 161,   0, 126, 204, 161,   0, 120, 204, 161,   0, 115, 204, 161,   0, 108, 204, 161,   0, 103, 204, 161,   0,  97, 204, 161,   0,  91, 204, 161,   0,  85, 204, 161,   0,  79, 204, 161,   0,  73, 204, 161,   0,  66, 204, 161,   0,  61, 204, 161,   0,  55, 204, 161,   0,  48, 204, 161,   0,  42, 204, 161,   0,  36, 204, 161,   0,  29, 204, 161,   0,  23, 204, 161,   0,  17, 204, 161,   0,  11, 204, 161,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   2, 204, 161,   0,   9, 204, 161,   0,  15, 204, 161,   0,  21, 204, 161,   0,  27, 204, 161,   0,  33, 204, 161,   0,  40, 204, 161,   0,  46, 204, 161,   0,  52, 204, 161,   0,  58, 204, 161,   0,  64, 204, 161,   0,  70, 204, 161,   0,  76, 204, 161,   0,  82, 204, 161,   0,  88, 204, 161,   0,  94, 204, 161,   0, 100, 204, 161,   0, 106, 204, 161,   0, 112, 204, 161,   0, 117, 204, 161,   0, 123, 204, 161,   0, 128, 204, 161,   0, 133, 204, 161,   0, 139, 204, 161,   0, 144, 204, 161,   0, 149, 204, 161,   0, 153, 204, 161,   0, 158, 204, 161,   0, 162, 204, 161,   0, 166, 204, 161,   0, 169, 204, 161,   0, 173, 204, 161,   0, 176, 204, 161,   0, 179, 204, 161,   0, 180, 204, 161,   0, 182, 204, 161,   0, 183, 204, 161,   0, 183, 204, 161,   0, 182, 204, 161,   0, 182, 204, 161,   0, 181, 204, 161,   0, 179, 204, 161,   0, 176, 204, 161,   0, 173, 204, 161,   0, 170, 204, 161,   0, 166, 204, 161,   0, 162, 204, 161,   0, 158, 204, 161,   0, 154, 204, 161,   0, 149, 204, 161,   0, 144, 204, 161,   0, 138, 204, 161,   0, 133, 204, 161,   0, 128, 204, 161,   0, 122, 204, 161,   0, 117, 204, 161,   0, 112, 204, 161,   0, 106, 204, 161,   0, 100, 204, 161,   0,  94, 204, 161,   0,  88, 204, 161,   0,  82, 204, 161,   0,  77, 204, 161,   0,  70, 204, 161,   0,  64, 204, 161,   0,  58, 204, 161,   0,  52, 204, 161,   0,  46, 204, 161,   0,  40, 204, 161,   0,  33, 204, 161,   0,  27, 204, 161,   0,  21, 204, 161,   0,  15, 204, 161,   0,   9, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   7, 204, 161,   0,  13, 204, 161,   0,  19, 204, 161,   0,  26, 204, 161,   0,  32, 204, 161,   0,  38, 204, 161,   0,  44, 204, 161,   0,  50, 204, 161,   0,  56, 204, 161,   0,  62, 204, 161,   0,  68, 204, 161,   0,  74, 204, 161,   0,  79, 204, 161,   0,  85, 204, 161,   0,  91, 204, 161,   0,  97, 204, 161,   0, 102, 204, 161,   0, 108, 204, 161,   0, 113, 204, 161,   0, 119, 204, 161,   0, 124, 204, 161,   0, 129, 204, 161,   0, 135, 204, 161,   0, 139, 204, 161,   0, 144, 204, 161,   0, 149, 204, 161,   0, 153, 204, 161,   0, 157, 204, 161,   0, 160, 204, 161,   0, 164, 204, 161,   0, 167, 204, 161,   0, 170, 204, 161,   0, 172, 204, 161,   0, 174, 204, 161,   0, 175, 204, 161,   0, 176, 204, 161,   0, 176, 204, 161,   0, 176, 204, 161,   0, 176, 204, 161,   0, 174, 204, 161,   0, 173, 204, 161,   0, 170, 204, 161,   0, 167, 204, 161,   0, 164, 204, 161,   0, 161, 204, 161,   0, 157, 204, 161,   0, 153, 204, 161,   0, 148, 204, 161,   0, 144, 204, 161,   0, 139, 204, 161,   0, 135, 204, 161,   0, 129, 204, 161,   0, 124, 204, 161,   0, 119, 204, 161,   0, 113, 204, 161,   0, 108, 204, 161,   0, 103, 204, 161,   0,  97, 204, 161,   0,  91, 204, 161,   0,  86, 204, 161,   0,  80, 204, 161,   0,  74, 204, 161,   0,  68, 204, 161,   0,  62, 204, 161,   0,  56, 204, 161,   0,  49, 204, 161,   0,  44, 204, 161,   0,  38, 204, 161,   0,  31, 204, 161,   0,  26, 204, 161,   0,  19, 204, 161,   0,  13, 204, 161,   0,   7, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   5, 204, 161,   0,  11, 204, 161,   0,  17, 204, 161,   0,  23, 204, 161,   0,  29, 204, 161,   0,  35, 204, 161,   0,  42, 204, 161,   0,  47, 204, 161,   0,  54, 204, 161,   0,  59, 204, 161,   0,  65, 204, 161,   0,  71, 204, 161,   0,  77, 204, 161,   0,  82, 204, 161,   0,  87, 204, 161,   0,  93, 204, 161,   0,  99, 204, 161,   0, 104, 204, 161,   0, 110, 204, 161,   0, 116, 204, 161,   0, 120, 204, 161,   0, 125, 204, 161,   0, 130, 204, 161,   0, 135, 204, 161,   0, 139, 204, 161,   0, 144, 204, 161,   0, 148, 204, 161,   0, 152, 204, 161,   0, 155, 204, 161,   0, 159, 204, 161,   0, 162, 204, 161,   0, 164, 204, 161,   0, 166, 204, 161,   0, 167, 204, 161,   0, 169, 204, 161,   0, 169, 204, 161,   0, 170, 204, 161,   0, 170, 204, 161,   0, 169, 204, 161,   0, 168, 204, 161,   0, 166, 204, 161,   0, 164, 204, 161,   0, 162, 204, 161,   0, 159, 204, 161,   0, 156, 204, 161,   0, 151, 204, 161,   0, 147, 204, 161,   0, 144, 204, 161,   0, 139, 204, 161,   0, 134, 204, 161,   0, 130, 204, 161,   0, 125, 204, 161,   0, 120, 204, 161,   0, 115, 204, 161,   0, 110, 204, 161,   0, 105, 204, 161,   0,  99, 204, 161,   0,  93, 204, 161,   0,  88, 204, 161,   0,  82, 204, 161,   0,  76, 204, 161,   0,  70, 204, 161,   0,  65, 204, 161,   0,  59, 204, 161,   0,  53, 204, 161,   0,  47, 204, 161,   0,  41, 204, 161,   0,  35, 204, 161,   0,  29, 204, 161,   0,  23, 204, 161,   0,  17, 204, 161,   0,  11, 204, 161,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   3, 204, 161,   0,   9, 204, 161,   0,  15, 204, 161,   0,  21, 204, 161,   0,  27, 204, 161,   0,  32, 204, 161,   0,  38, 204, 161,   0,  44, 204, 161,   0,  50, 204, 161,   0,  56, 204, 161,   0,  62, 204, 161,   0,  68, 204, 161,   0,  74, 204, 161,   0,  79, 204, 161,   0,  84, 204, 161,   0,  90, 204, 161,   0,  95, 204, 161,   0, 101, 204, 161,   0, 106, 204, 161,   0, 111, 204, 161,   0, 116, 204, 161,   0, 121, 204, 161,   0, 126, 204, 161,   0, 131, 204, 161,   0, 134, 204, 161,   0, 139, 204, 161,   0, 143, 204, 161,   0, 146, 204, 161,   0, 149, 204, 161,   0, 153, 204, 161,   0, 156, 204, 161,   0, 158, 204, 161,   0, 160, 204, 161,   0, 161, 204, 161,   0, 162, 204, 161,   0, 164, 204, 161,   0, 164, 204, 161,   0, 163, 204, 161,   0, 162, 204, 161,   0, 162, 204, 161,   0, 160, 204, 161,   0, 157, 204, 161,   0, 156, 204, 161,   0, 153, 204, 161,   0, 149, 204, 161,   0, 146, 204, 161,   0, 143, 204, 161,   0, 139, 204, 161,   0, 134, 204, 161,   0, 130, 204, 161,   0, 125, 204, 161,   0, 121, 204, 161,   0, 116, 204, 161,   0, 111, 204, 161,   0, 105, 204, 161,   0, 100, 204, 161,   0,  95, 204, 161,   0,  90, 204, 161,   0,  85, 204, 161,   0,  79, 204, 161,   0,  73, 204, 161,   0,  68, 204, 161,   0,  62, 204, 161,   0,  56, 204, 161,   0,  50, 204, 161,   0,  44, 204, 161,   0,  39, 204, 161,   0,  33, 204, 161,   0,  26, 204, 161,   0,  21, 204, 161,   0,  15, 204, 161,   0,   8, 204, 161,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  12, 204, 161,   0,  18, 204, 161,   0,  24, 204, 161,   0,  30, 204, 161,   0,  36, 204, 161,   0,  41, 204, 161,   0,  47, 204, 161,   0,  53, 204, 161,   0,  58, 204, 161,   0,  65, 204, 161,   0,  70, 204, 161,   0,  75, 204, 161,   0,  81, 204, 161,   0,  86, 204, 161,   0,  92, 204, 161,   0,  97, 204, 161,   0, 102, 204, 161,   0, 106, 204, 161,   0, 112, 204, 161,   0, 116, 204, 161,   0, 120, 204, 161,   0, 125, 204, 161,   0, 129, 204, 161,   0, 134, 204, 161,   0, 137, 204, 161,   0, 141, 204, 161,   0, 144, 204, 161,   0, 147, 204, 161,   0, 149, 204, 161,   0, 152, 204, 161,   0, 153, 204, 161,   0, 155, 204, 161,   0, 156, 204, 161,   0, 156, 204, 161,   0, 157, 204, 161,   0, 157, 204, 161,   0, 156, 204, 161,   0, 155, 204, 161,   0, 154, 204, 161,   0, 151, 204, 161,   0, 150, 204, 161,   0, 147, 204, 161,   0, 144, 204, 161,   0, 140, 204, 161,   0, 137, 204, 161,   0, 133, 204, 161,   0, 130, 204, 161,   0, 126, 204, 161,   0, 120, 204, 161,   0, 116, 204, 161,   0, 111, 204, 161,   0, 107, 204, 161,   0, 102, 204, 161,   0,  97, 204, 161,   0,  92, 204, 161,   0,  86, 204, 161,   0,  81, 204, 161,   0,  76, 204, 161,   0,  70, 204, 161,   0,  64, 204, 161,   0,  59, 204, 161,   0,  53, 204, 161,   0,  47, 204, 161,   0,  41, 204, 161,   0,  36, 204, 161,   0,  30, 204, 161,   0,  24, 204, 161,   0,  18, 204, 161,   0,  12, 204, 161,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   4, 204, 161,   0,   9, 204, 161,   0,  15, 204, 161,   0,  21, 204, 161,   0,  27, 204, 161,   0,  33, 204, 161,   0,  38, 204, 161,   0,  44, 204, 161,   0,  50, 204, 161,   0,  55, 204, 161,   0,  61, 204, 161,   0,  66, 204, 161,   0,  72, 204, 161,   0,  78, 204, 161,   0,  83, 204, 161,   0,  88, 204, 161,   0,  93, 204, 161,   0,  98, 204, 161,   0, 103, 204, 161,   0, 107, 204, 161,   0, 112, 204, 161,   0, 116, 204, 161,   0, 120, 204, 161,   0, 125, 204, 161,   0, 128, 204, 161,   0, 131, 204, 161,   0, 135, 204, 161,   0, 138, 204, 161,   0, 141, 204, 161,   0, 143, 204, 161,   0, 146, 204, 161,   0, 147, 204, 161,   0, 148, 204, 161,   0, 150, 204, 161,   0, 150, 204, 161,   0, 151, 204, 161,   0, 150, 204, 161,   0, 150, 204, 161,   0, 149, 204, 161,   0, 147, 204, 161,   0, 145, 204, 161,   0, 144, 204, 161,   0, 141, 204, 161,   0, 138, 204, 161,   0, 135, 204, 161,   0, 131, 204, 161,   0, 128, 204, 161,   0, 124, 204, 161,   0, 120, 204, 161,   0, 115, 204, 161,   0, 112, 204, 161,   0, 107, 204, 161,   0, 103, 204, 161,   0,  98, 204, 161,   0,  93, 204, 161,   0,  88, 204, 161,   0,  82, 204, 161,   0,  77, 204, 161,   0,  72, 204, 161,   0,  67, 204, 161,   0,  61, 204, 161,   0,  55, 204, 161,   0,  50, 204, 161,   0,  44, 204, 161,   0,  39, 204, 161,   0,  33, 204, 161,   0,  27, 204, 161,   0,  21, 204, 161,   0,  15, 204, 161,   0,  10, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  12, 204, 161,   0,  18, 204, 161,   0,  23, 204, 161,   0,  30, 204, 161,   0,  35, 204, 161,   0,  41, 204, 161,   0,  47, 204, 161,   0,  52, 204, 161,   0,  58, 204, 161,   0,  62, 204, 161,   0,  68, 204, 161,   0,  73, 204, 161,   0,  79, 204, 161,   0,  83, 204, 161,   0,  89, 204, 161,   0,  93, 204, 161,   0,  98, 204, 161,   0, 102, 204, 161,   0, 107, 204, 161,   0, 111, 204, 161,   0, 115, 204, 161,   0, 119, 204, 161,   0, 122, 204, 161,   0, 126, 204, 161,   0, 130, 204, 161,   0, 132, 204, 161,   0, 135, 204, 161,   0, 137, 204, 161,   0, 139, 204, 161,   0, 141, 204, 161,   0, 142, 204, 161,   0, 143, 204, 161,   0, 144, 204, 161,   0, 144, 204, 161,   0, 144, 204, 161,   0, 143, 204, 161,   0, 142, 204, 161,   0, 141, 204, 161,   0, 140, 204, 161,   0, 137, 204, 161,   0, 135, 204, 161,   0, 132, 204, 161,   0, 129, 204, 161,   0, 126, 204, 161,   0, 122, 204, 161,   0, 119, 204, 161,   0, 115, 204, 161,   0, 111, 204, 161,   0, 107, 204, 161,   0, 102, 204, 161,   0,  98, 204, 161,   0,  93, 204, 161,   0,  88, 204, 161,   0,  83, 204, 161,   0,  78, 204, 161,   0,  73, 204, 161,   0,  68, 204, 161,   0,  63, 204, 161,   0,  57, 204, 161,   0,  52, 204, 161,   0,  46, 204, 161,   0,  41, 204, 161,   0,  35, 204, 161,   0,  29, 204, 161,   0,  24, 204, 161,   0,  18, 204, 161,   0,  12, 204, 161,   0,   7,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   4, 204, 161,   0,  10, 204, 161,   0,  15, 204, 161,   0,  21, 204, 161,   0,  26, 204, 161,   0,  32, 204, 161,   0,  38, 204, 161,   0,  43, 204, 161,   0,  49, 204, 161,   0,  54, 204, 161,   0,  58, 204, 161,   0,  64, 204, 161,   0,  69, 204, 161,   0,  74, 204, 161,   0,  79, 204, 161,   0,  84, 204, 161,   0,  88, 204, 161,   0,  93, 204, 161,   0,  98, 204, 161,   0, 102, 204, 161,   0, 106, 204, 161,   0, 110, 204, 161,   0, 113, 204, 161,   0, 117, 204, 161,   0, 120, 204, 161,   0, 123, 204, 161,   0, 126, 204, 161,   0, 128, 204, 161,   0, 131, 204, 161,   0, 133, 204, 161,   0, 134, 204, 161,   0, 136, 204, 161,   0, 137, 204, 161,   0, 137, 204, 161,   0, 137, 204, 161,   0, 137, 204, 161,   0, 137, 204, 161,   0, 136, 204, 161,   0, 134, 204, 161,   0, 133, 204, 161,   0, 131, 204, 161,   0, 129, 204, 161,   0, 127, 204, 161,   0, 124, 204, 161,   0, 120, 204, 161,   0, 117, 204, 161,   0, 114, 204, 161,   0, 110, 204, 161,   0, 106, 204, 161,   0, 102, 204, 161,   0,  98, 204, 161,   0,  93, 204, 161,   0,  89, 204, 161,   0,  84, 204, 161,   0,  79, 204, 161,   0,  74, 204, 161,   0,  69, 204, 161,   0,  65, 204, 161,   0,  59, 204, 161,   0,  53, 204, 161,   0,  48, 204, 161,   0,  43, 204, 161,   0,  37, 204, 161,   0,  32, 204, 161,   0,  27, 204, 161,   0,  20, 204, 161,   0,  15, 204, 161,   0,   9, 204, 161,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  12, 204, 161,   0,  18, 204, 161,   0,  23, 204, 161,   0,  29, 204, 161,   0,  34, 204, 161,   0,  39, 204, 161,   0,  44, 204, 161,   0,  50, 204, 161,   0,  55, 204, 161,   0,  60, 204, 161,   0,  65, 204, 161,   0,  70, 204, 161,   0,  74, 204, 161,   0,  80, 204, 161,   0,  84, 204, 161,   0,  89, 204, 161,   0,  93, 204, 161,   0,  96, 204, 161,   0, 101, 204, 161,   0, 105, 204, 161,   0, 108, 204, 161,   0, 111, 204, 161,   0, 114, 204, 161,   0, 117, 204, 161,   0, 120, 204, 161,   0, 123, 204, 161,   0, 125, 204, 161,   0, 127, 204, 161,   0, 128, 204, 161,   0, 130, 204, 161,   0, 130, 204, 161,   0, 130, 204, 161,   0, 131, 204, 161,   0, 131, 204, 161,   0, 130, 204, 161,   0, 129, 204, 161,   0, 128, 204, 161,   0, 127, 204, 161,   0, 125, 204, 161,   0, 123, 204, 161,   0, 120, 204, 161,   0, 117, 204, 161,   0, 114, 204, 161,   0, 111, 204, 161,   0, 108, 204, 161,   0, 104, 204, 161,   0, 101, 204, 161,   0,  97, 204, 161,   0,  93, 204, 161,   0,  89, 204, 161,   0,  84, 204, 161,   0,  79, 204, 161,   0,  74, 204, 161,   0,  70, 204, 161,   0,  65, 204, 161,   0,  60, 204, 161,   0,  54, 204, 161,   0,  49, 204, 161,   0,  44, 204, 161,   0,  39, 204, 161,   0,  33, 204, 161,   0,  29, 204, 161,   0,  23, 204, 161,   0,  17, 204, 161,   0,  12, 204, 161,   0,   6,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   3, 204, 161,   0,   9, 204, 161,   0,  13, 204, 161,   0,  20, 204, 161,   0,  24, 204, 161,   0,  30, 204, 161,   0,  35, 204, 161,   0,  40, 204, 161,   0,  46, 204, 161,   0,  51, 204, 161,   0,  56, 204, 161,   0,  60, 204, 161,   0,  66, 204, 161,   0,  70, 204, 161,   0,  75, 204, 161,   0,  79, 204, 161,   0,  84, 204, 161,   0,  88, 204, 161,   0,  92, 204, 161,   0,  96, 204, 161,   0,  99, 204, 161,   0, 102, 204, 161,   0, 106, 204, 161,   0, 109, 204, 161,   0, 112, 204, 161,   0, 115, 204, 161,   0, 116, 204, 161,   0, 118, 204, 161,   0, 121, 204, 161,   0, 122, 204, 161,   0, 123, 204, 161,   0, 124, 204, 161,   0, 124, 204, 161,   0, 124, 204, 161,   0, 124, 204, 161,   0, 123, 204, 161,   0, 123, 204, 161,   0, 121, 204, 161,   0, 120, 204, 161,   0, 119, 204, 161,   0, 116, 204, 161,   0, 114, 204, 161,   0, 112, 204, 161,   0, 109, 204, 161,   0, 106, 204, 161,   0, 102, 204, 161,   0,  99, 204, 161,   0,  95, 204, 161,   0,  92, 204, 161,   0,  88, 204, 161,   0,  84, 204, 161,   0,  79, 204, 161,   0,  75, 204, 161,   0,  71, 204, 161,   0,  65, 204, 161,   0,  60, 204, 161,   0,  55, 204, 161,   0,  51, 204, 161,   0,  46, 204, 161,   0,  41, 204, 161,   0,  35, 204, 161,   0,  30, 204, 161,   0,  24, 204, 161,   0,  19, 204, 161,   0,  14, 204, 161,   0,   8, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   5, 204, 161,   0,  10, 204, 161,   0,  15, 204, 161,   0,  21, 204, 161,   0,  26, 204, 161,   0,  31, 204, 161,   0,  37, 204, 161,   0,  42, 204, 161,   0,  46, 204, 161,   0,  52, 204, 161,   0,  56, 204, 161,   0,  61, 204, 161,   0,  65, 204, 161,   0,  70, 204, 161,   0,  74, 204, 161,   0,  79, 204, 161,   0,  83, 204, 161,   0,  87, 204, 161,   0,  90, 204, 161,   0,  94, 204, 161,   0,  96, 204, 161,   0, 100, 204, 161,   0, 103, 204, 161,   0, 106, 204, 161,   0, 108, 204, 161,   0, 111, 204, 161,   0, 112, 204, 161,   0, 113, 204, 161,   0, 116, 204, 161,   0, 117, 204, 161,   0, 117, 204, 161,   0, 117, 204, 161,   0, 118, 204, 161,   0, 117, 204, 161,   0, 117, 204, 161,   0, 116, 204, 161,   0, 115, 204, 161,   0, 113, 204, 161,   0, 112, 204, 161,   0, 111, 204, 161,   0, 108, 204, 161,   0, 105, 204, 161,   0, 103, 204, 161,   0, 100, 204, 161,   0,  97, 204, 161,   0,  93, 204, 161,   0,  90, 204, 161,   0,  87, 204, 161,   0,  82, 204, 161,   0,  79, 204, 161,   0,  74, 204, 161,   0,  70, 204, 161,   0,  65, 204, 161,   0,  60, 204, 161,   0,  57, 204, 161,   0,  51, 204, 161,   0,  46, 204, 161,   0,  41, 204, 161,   0,  36, 204, 161,   0,  32, 204, 161,   0,  27, 204, 161,   0,  21, 204, 161,   0,  16, 204, 161,   0,  10, 204, 161,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   7, 204, 161,   0,  11, 204, 161,   0,  17, 204, 161,   0,  22, 204, 161,   0,  27, 204, 161,   0,  32, 204, 161,   0,  37, 204, 161,   0,  42, 204, 161,   0,  46, 204, 161,   0,  51, 204, 161,   0,  56, 204, 161,   0,  61, 204, 161,   0,  65, 204, 161,   0,  69, 204, 161,   0,  74, 204, 161,   0,  77, 204, 161,   0,  81, 204, 161,   0,  84, 204, 161,   0,  88, 204, 161,   0,  91, 204, 161,   0,  94, 204, 161,   0,  97, 204, 161,   0, 100, 204, 161,   0, 102, 204, 161,   0, 104, 204, 161,   0, 106, 204, 161,   0, 108, 204, 161,   0, 109, 204, 161,   0, 110, 204, 161,   0, 110, 204, 161,   0, 111, 204, 161,   0, 111, 204, 161,   0, 111, 204, 161,   0, 110, 204, 161,   0, 110, 204, 161,   0, 109, 204, 161,   0, 108, 204, 161,   0, 106, 204, 161,   0, 104, 204, 161,   0, 102, 204, 161,   0, 100, 204, 161,   0,  97, 204, 161,   0,  94, 204, 161,   0,  91, 204, 161,   0,  88, 204, 161,   0,  84, 204, 161,   0,  80, 204, 161,   0,  77, 204, 161,   0,  73, 204, 161,   0,  69, 204, 161,   0,  65, 204, 161,   0,  60, 204, 161,   0,  56, 204, 161,   0,  51, 204, 161,   0,  47, 204, 161,   0,  42, 204, 161,   0,  37, 204, 161,   0,  32, 204, 161,   0,  27, 204, 161,   0,  22, 204, 161,   0,  17, 204, 161,   0,  11, 204, 161,   0,   6, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   3, 204, 161,   0,   7, 204, 161,   0,  13, 204, 161,   0,  18, 204, 161,   0,  24, 204, 161,   0,  28, 204, 161,   0,  33, 204, 161,   0,  37, 204, 161,   0,  42, 204, 161,   0,  47, 204, 161,   0,  51, 204, 161,   0,  56, 204, 161,   0,  60, 204, 161,   0,  64, 204, 161,   0,  68, 204, 161,   0,  72, 204, 161,   0,  76, 204, 161,   0,  79, 204, 161,   0,  82, 204, 161,   0,  85, 204, 161,   0,  88, 204, 161,   0,  91, 204, 161,   0,  93, 204, 161,   0,  95, 204, 161,   0,  98, 204, 161,   0, 100, 204, 161,   0, 101, 204, 161,   0, 103, 204, 161,   0, 103, 204, 161,   0, 105, 204, 161,   0, 104, 204, 161,   0, 105, 204, 161,   0, 104, 204, 161,   0, 104, 204, 161,   0, 103, 204, 161,   0, 103, 204, 161,   0, 101, 204, 161,   0, 100, 204, 161,   0,  98, 204, 161,   0,  96, 204, 161,   0,  93, 204, 161,   0,  91, 204, 161,   0,  89, 204, 161,   0,  86, 204, 161,   0,  82, 204, 161,   0,  79, 204, 161,   0,  75, 204, 161,   0,  72, 204, 161,   0,  68, 204, 161,   0,  64, 204, 161,   0,  60, 204, 161,   0,  56, 204, 161,   0,  51, 204, 161,   0,  47, 204, 161,   0,  42, 204, 161,   0,  38, 204, 161,   0,  33, 204, 161,   0,  28, 204, 161,   0,  23, 204, 161,   0,  18, 204, 161,   0,  13, 204, 161,   0,   8, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   4, 204, 161,   0,   9, 204, 161,   0,  14, 204, 161,   0,  19, 204, 161,   0,  23, 204, 161,   0,  28, 204, 161,   0,  33, 204, 161,   0,  37, 204, 161,   0,  42, 204, 161,   0,  46, 204, 161,   0,  51, 204, 161,   0,  55, 204, 161,   0,  59, 204, 161,   0,  63, 204, 161,   0,  66, 204, 161,   0,  70, 204, 161,   0,  73, 204, 161,   0,  76, 204, 161,   0,  80, 204, 161,   0,  83, 204, 161,   0,  85, 204, 161,   0,  87, 204, 161,   0,  90, 204, 161,   0,  91, 204, 161,   0,  93, 204, 161,   0,  95, 204, 161,   0,  96, 204, 161,   0,  97, 204, 161,   0,  98, 204, 161,   0,  98, 204, 161,   0,  98, 204, 161,   0,  98, 204, 161,   0,  98, 204, 161,   0,  97, 204, 161,   0,  96, 204, 161,   0,  95, 204, 161,   0,  93, 204, 161,   0,  91, 204, 161,   0,  90, 204, 161,   0,  88, 204, 161,   0,  85, 204, 161,   0,  82, 204, 161,   0,  80, 204, 161,   0,  77, 204, 161,   0,  73, 204, 161,   0,  70, 204, 161,   0,  66, 204, 161,   0,  63, 204, 161,   0,  58, 204, 161,   0,  54, 204, 161,   0,  51, 204, 161,   0,  47, 204, 161,   0,  42, 204, 161,   0,  37, 204, 161,   0,  33, 204, 161,   0,  29, 204, 161,   0,  24, 204, 161,   0,  18, 204, 161,   0,  14, 204, 161,   0,   9, 204, 161,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   5, 204, 161,   0,  10, 204, 161,   0,  14, 204, 161,   0,  19, 204, 161,   0,  24, 204, 161,   0,  28, 204, 161,   0,  32, 204, 161,   0,  37, 204, 161,   0,  41, 204, 161,   0,  46, 204, 161,   0,  50, 204, 161,   0,  54, 204, 161,   0,  57, 204, 161,   0,  61, 204, 161,   0,  64, 204, 161,   0,  68, 204, 161,   0,  71, 204, 161,   0,  74, 204, 161,   0,  76, 204, 161,   0,  79, 204, 161,   0,  81, 204, 161,   0,  83, 204, 161,   0,  85, 204, 161,   0,  87, 204, 161,   0,  88, 204, 161,   0,  89, 204, 161,   0,  91, 204, 161,   0,  91, 204, 161,   0,  92, 204, 161,   0,  92, 204, 161,   0,  92, 204, 161,   0,  91, 204, 161,   0,  91, 204, 161,   0,  89, 204, 161,   0,  88, 204, 161,   0,  87, 204, 161,   0,  85, 204, 161,   0,  83, 204, 161,   0,  81, 204, 161,   0,  79, 204, 161,   0,  77, 204, 161,   0,  74, 204, 161,   0,  71, 204, 161,   0,  67, 204, 161,   0,  64, 204, 161,   0,  61, 204, 161,   0,  57, 204, 161,   0,  54, 204, 161,   0,  49, 204, 161,   0,  46, 204, 161,   0,  42, 204, 161,   0,  37, 204, 161,   0,  33, 204, 161,   0,  28, 204, 161,   0,  24, 204, 161,   0,  19, 204, 161,   0,  15, 204, 161,   0,  10, 204, 161,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   6, 204, 161,   0,  10, 204, 161,   0,  14, 204, 161,   0,  19, 204, 161,   0,  24, 204, 161,   0,  28, 204, 161,   0,  33, 204, 161,   0,  36, 204, 161,   0,  40, 204, 161,   0,  45, 204, 161,   0,  48, 204, 161,   0,  52, 204, 161,   0,  55, 204, 161,   0,  58, 204, 161,   0,  62, 204, 161,   0,  64, 204, 161,   0,  68, 204, 161,   0,  70, 204, 161,   0,  73, 204, 161,   0,  76, 204, 161,   0,  77, 204, 161,   0,  79, 204, 161,   0,  81, 204, 161,   0,  82, 204, 161,   0,  83, 204, 161,   0,  84, 204, 161,   0,  85, 204, 161,   0,  85, 204, 161,   0,  85, 204, 161,   0,  85, 204, 161,   0,  85, 204, 161,   0,  84, 204, 161,   0,  83, 204, 161,   0,  82, 204, 161,   0,  81, 204, 161,   0,  79, 204, 161,   0,  78, 204, 161,   0,  75, 204, 161,   0,  73, 204, 161,   0,  71, 204, 161,   0,  68, 204, 161,   0,  65, 204, 161,   0,  61, 204, 161,   0,  59, 204, 161,   0,  55, 204, 161,   0,  51, 204, 161,   0,  49, 204, 161,   0,  45, 204, 161,   0,  40, 204, 161,   0,  36, 204, 161,   0,  32, 204, 161,   0,  28, 204, 161,   0,  23, 204, 161,   0,  20, 204, 161,   0,  15, 204, 161,   0,  10, 204, 161,   0,   5,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   6, 204, 161,   0,  10, 204, 161,   0,  14, 204, 161,   0,  19, 204, 161,   0,  23, 204, 161,   0,  28, 204, 161,   0,  32, 204, 161,   0,  36, 204, 161,   0,  39, 204, 161,   0,  42, 204, 161,   0,  47, 204, 161,   0,  50, 204, 161,   0,  53, 204, 161,   0,  56, 204, 161,   0,  59, 204, 161,   0,  62, 204, 161,   0,  64, 204, 161,   0,  67, 204, 161,   0,  69, 204, 161,   0,  71, 204, 161,   0,  73, 204, 161,   0,  74, 204, 161,   0,  76, 204, 161,   0,  77, 204, 161,   0,  78, 204, 161,   0,  78, 204, 161,   0,  78, 204, 161,   0,  78, 204, 161,   0,  78, 204, 161,   0,  78, 204, 161,   0,  77, 204, 161,   0,  76, 204, 161,   0,  76, 204, 161,   0,  74, 204, 161,   0,  73, 204, 161,   0,  71, 204, 161,   0,  69, 204, 161,   0,  66, 204, 161,   0,  64, 204, 161,   0,  62, 204, 161,   0,  59, 204, 161,   0,  56, 204, 161,   0,  53, 204, 161,   0,  50, 204, 161,   0,  46, 204, 161,   0,  43, 204, 161,   0,  40, 204, 161,   0,  35, 204, 161,   0,  32, 204, 161,   0,  27, 204, 161,   0,  23, 204, 161,   0,  19, 204, 161,   0,  14, 204, 161,   0,  10, 204, 161,   0,   5, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   5, 204, 161,   0,   9, 204, 161,   0,  14, 204, 161,   0,  18, 204, 161,   0,  22, 204, 161,   0,  26, 204, 161,   0,  30, 204, 161,   0,  34, 204, 161,   0,  38, 204, 161,   0,  40, 204, 161,   0,  44, 204, 161,   0,  47, 204, 161,   0,  50, 204, 161,   0,  53, 204, 161,   0,  56, 204, 161,   0,  58, 204, 161,   0,  61, 204, 161,   0,  63, 204, 161,   0,  65, 204, 161,   0,  66, 204, 161,   0,  68, 204, 161,   0,  69, 204, 161,   0,  70, 204, 161,   0,  71, 204, 161,   0,  72, 204, 161,   0,  72, 204, 161,   0,  72, 204, 161,   0,  72, 204, 161,   0,  72, 204, 161,   0,  71, 204, 161,   0,  70, 204, 161,   0,  69, 204, 161,   0,  68, 204, 161,   0,  66, 204, 161,   0,  64, 204, 161,   0,  62, 204, 161,   0,  60, 204, 161,   0,  58, 204, 161,   0,  56, 204, 161,   0,  53, 204, 161,   0,  50, 204, 161,   0,  48, 204, 161,   0,  44, 204, 161,   0,  41, 204, 161,   0,  37, 204, 161,   0,  34, 204, 161,   0,  30, 204, 161,   0,  26, 204, 161,   0,  22, 204, 161,   0,  18, 204, 161,   0,  14, 204, 161,   0,  10, 204, 161,   0,   5, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   4, 204, 161,   0,   9, 204, 161,   0,  13, 204, 161,   0,  17, 204, 161,   0,  20, 204, 161,   0,  25, 204, 161,   0,  28, 204, 161,   0,  32, 204, 161,   0,  36, 204, 161,   0,  38, 204, 161,   0,  41, 204, 161,   0,  44, 204, 161,   0,  47, 204, 161,   0,  50, 204, 161,   0,  52, 204, 161,   0,  54, 204, 161,   0,  56, 204, 161,   0,  58, 204, 161,   0,  60, 204, 161,   0,  62, 204, 161,   0,  63, 204, 161,   0,  64, 204, 161,   0,  64, 204, 161,   0,  65, 204, 161,   0,  65, 204, 161,   0,  66, 204, 161,   0,  65, 204, 161,   0,  65, 204, 161,   0,  65, 204, 161,   0,  64, 204, 161,   0,  63, 204, 161,   0,  61, 204, 161,   0,  60, 204, 161,   0,  59, 204, 161,   0,  56, 204, 161,   0,  55, 204, 161,   0,  52, 204, 161,   0,  50, 204, 161,   0,  48, 204, 161,   0,  44, 204, 161,   0,  41, 204, 161,   0,  38, 204, 161,   0,  35, 204, 161,   0,  32, 204, 161,   0,  29, 204, 161,   0,  24, 204, 161,   0,  21, 204, 161,   0,  17, 204, 161,   0,  13, 204, 161,   0,   9, 204, 161,   0,   5, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   3, 204, 161,   0,   8, 204, 161,   0,  12, 204, 161,   0,  15, 204, 161,   0,  19, 204, 161,   0,  23, 204, 161,   0,  26, 204, 161,   0,  30, 204, 161,   0,  33, 204, 161,   0,  36, 204, 161,   0,  38, 204, 161,   0,  42, 204, 161,   0,  43, 204, 161,   0,  47, 204, 161,   0,  48, 204, 161,   0,  50, 204, 161,   0,  52, 204, 161,   0,  53, 204, 161,   0,  55, 204, 161,   0,  56, 204, 161,   0,  57, 204, 161,   0,  58, 204, 161,   0,  59, 204, 161,   0,  58, 204, 161,   0,  59, 204, 161,   0,  59, 204, 161,   0,  59, 204, 161,   0,  58, 204, 161,   0,  57, 204, 161,   0,  57, 204, 161,   0,  55, 204, 161,   0,  53, 204, 161,   0,  52, 204, 161,   0,  51, 204, 161,   0,  48, 204, 161,   0,  46, 204, 161,   0,  43, 204, 161,   0,  41, 204, 161,   0,  39, 204, 161,   0,  35, 204, 161,   0,  32, 204, 161,   0,  29, 204, 161,   0,  26, 204, 161,   0,  23, 204, 161,   0,  19, 204, 161,   0,  16, 204, 161,   0,  12, 204, 161,   0,   8, 204, 161,   0,   4,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   2, 204, 161,   0,   7, 204, 161,   0,  11, 204, 161,   0,  14, 204, 161,   0,  18, 204, 161,   0,  20, 204, 161,   0,  24, 204, 161,   0,  27, 204, 161,   0,  30, 204, 161,   0,  33, 204, 161,   0,  35, 204, 161,   0,  37, 204, 161,   0,  40, 204, 161,   0,  42, 204, 161,   0,  44, 204, 161,   0,  46, 204, 161,   0,  48, 204, 161,   0,  48, 204, 161,   0,  49, 204, 161,   0,  50, 204, 161,   0,  52, 204, 161,   0,  52, 204, 161,   0,  53, 204, 161,   0,  53, 204, 161,   0,  52, 204, 161,   0,  51, 204, 161,   0,  52, 204, 161,   0,  51, 204, 161,   0,  49, 204, 161,   0,  49, 204, 161,   0,  47, 204, 161,   0,  46, 204, 161,   0,  43, 204, 161,   0,  42, 204, 161,   0,  40, 204, 161,   0,  38, 204, 161,   0,  35, 204, 161,   0,  33, 204, 161,   0,  30, 204, 161,   0,  27, 204, 161,   0,  24, 204, 161,   0,  21, 204, 161,   0,  17, 204, 161,   0,  14, 204, 161,   0,  10, 204, 161,   0,   7, 204, 161,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   5, 204, 161,   0,   9, 204, 161,   0,  12, 204, 161,   0,  15, 204, 161,   0,  18, 204, 161,   0,  21, 204, 161,   0,  24, 204, 161,   0,  26, 204, 161,   0,  29, 204, 161,   0,  31, 204, 161,   0,  33, 204, 161,   0,  36, 204, 161,   0,  38, 204, 161,   0,  40, 204, 161,   0,  41, 204, 161,   0,  43, 204, 161,   0,  43, 204, 161,   0,  45, 204, 161,   0,  45, 204, 161,   0,  45, 204, 161,   0,  46, 204, 161,   0,  46, 204, 161,   0,  45, 204, 161,   0,  45, 204, 161,   0,  45, 204, 161,   0,  44, 204, 161,   0,  43, 204, 161,   0,  42, 204, 161,   0,  41, 204, 161,   0,  39, 204, 161,   0,  37, 204, 161,   0,  35, 204, 161,   0,  33, 204, 161,   0,  32, 204, 161,   0,  29, 204, 161,   0,  26, 204, 161,   0,  23, 204, 161,   0,  21, 204, 161,   0,  18, 204, 161,   0,  15, 204, 161,   0,  12, 204, 161,   0,   8, 204, 161,   0,   5, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   3, 204, 161,   0,   6, 204, 161,   0,   9, 204, 161,   0,  13, 204, 161,   0,  16, 204, 161,   0,  18, 204, 161,   0,  21, 204, 161,   0,  23, 204, 161,   0,  26, 204, 161,   0,  27, 204, 161,   0,  30, 204, 161,   0,  31, 204, 161,   0,  33, 204, 161,   0,  34, 204, 161,   0,  36, 204, 161,   0,  36, 204, 161,   0,  37, 204, 161,   0,  39, 204, 161,   0,  39, 204, 161,   0,  39, 204, 161,   0,  39, 204, 161,   0,  39, 204, 161,   0,  38, 204, 161,   0,  38, 204, 161,   0,  38, 204, 161,   0,  37, 204, 161,   0,  36, 204, 161,   0,  34, 204, 161,   0,  33, 204, 161,   0,  32, 204, 161,   0,  29, 204, 161,   0,  28, 204, 161,   0,  26, 204, 161,   0,  23, 204, 161,   0,  20, 204, 161,   0,  18, 204, 161,   0,  15, 204, 161,   0,  12, 204, 161,   0,   9, 204, 161,   0,   6, 204, 161,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   3, 204, 161,   0,   6, 204, 161,   0,   9, 204, 161,   0,  12, 204, 161,   0,  14, 204, 161,   0,  17, 204, 161,   0,  19, 204, 161,   0,  21, 204, 161,   0,  23, 204, 161,   0,  25, 204, 161,   0,  27, 204, 161,   0,  28, 204, 161,   0,  30, 204, 161,   0,  30, 204, 161,   0,  32, 204, 161,   0,  32, 204, 161,   0,  32, 204, 161,   0,  33, 204, 161,   0,  32, 204, 161,   0,  33, 204, 161,   0,  33, 204, 161,   0,  32, 204, 161,   0,  31, 204, 161,   0,  30, 204, 161,   0,  29, 204, 161,   0,  28, 204, 161,   0,  27, 204, 161,   0,  25, 204, 161,   0,  24, 204, 161,   0,  21, 204, 161,   0,  19, 204, 161,   0,  17, 204, 161,   0,  14, 204, 161,   0,  12, 204, 161,   0,   9, 204, 161,   0,   7, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   3, 204, 161,   0,   6, 204, 161,   0,   9, 204, 161,   0,  11, 204, 161,   0,  13, 204, 161,   0,  15, 204, 161,   0,  17, 204, 161,   0,  18, 204, 161,   0,  20, 204, 161,   0,  21, 204, 161,   0,  23, 204, 161,   0,  24, 204, 161,   0,  24, 204, 161,   0,  25, 204, 161,   0,  26, 204, 161,   0,  26, 204, 161,   0,  26, 204, 161,   0,  26, 204, 161,   0,  25, 204, 161,   0,  25, 204, 161,   0,  24, 204, 161,   0,  24, 204, 161,   0,  23, 204, 161,   0,  21, 204, 161,   0,  20, 204, 161,   0,  19, 204, 161,   0,  17, 204, 161,   0,  15, 204, 161,   0,  13, 204, 161,   0,  11, 204, 161,   0,   8, 204, 161,   0,   6, 204, 161,   0,   4, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   2, 204, 161,   0,   4, 204, 161,   0,   7, 204, 161,   0,   8, 204, 161,   0,  11, 204, 161,   0,  12, 204, 161,   0,  14, 204, 161,   0,  15, 204, 161,   0,  16, 204, 161,   0,  18, 204, 161,   0,  19, 204, 161,   0,  18, 204, 161,   0,  19, 204, 161,   0,  20, 204, 161,   0,  19, 204, 161,   0,  20, 204, 161,   0,  19, 204, 161,   0,  19, 204, 161,   0,  18, 204, 161,   0,  17, 204, 161,   0,  16, 204, 161,   0,  15, 204, 161,   0,  14, 204, 161,   0,  13, 204, 161,   0,  11, 204, 161,   0,   9, 204, 161,   0,   7, 204, 161,   0,   4, 204, 161,   0,   2,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   2, 204, 161,   0,   4, 204, 161,   0,   6, 204, 161,   0,   8, 204, 161,   0,   9, 204, 161,   0,  10, 204, 161,   0,  11, 204, 161,   0,  11, 204, 161,   0,  13, 204, 161,   0,  13, 204, 161,   0,  13, 204, 161,   0,  13, 204, 161,   0,  13, 204, 161,   0,  12, 204, 161,   0,  12, 204, 161,   0,  12, 204, 161,   0,  11, 204, 161,   0,  10, 204, 161,   0,   9, 204, 161,   0,   8, 204, 161,   0,   6, 204, 161,   0,   4, 204, 161,   0,   3,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0, 204, 161,   0,   1, 204, 161,   0,   3, 204, 161,   0,   3, 204, 161,   0,   4, 204, 161,   0,   6, 204, 161,   0,   6, 204, 161,   0,   7, 204, 161,   0,   7, 204, 161,   0,   7, 204, 161,   0,   6, 204, 161,   0,   6, 204, 161,   0,   6, 204, 161,   0,   5, 204, 161,   0,   5, 204, 161,   0,   3, 204, 161,   0,   2, 204, 161,   0,   1,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
	};

	static const int BLUE_ICON_GLOW_SIZE_W = 80;
	static const int BLUE_ICON_GLOW_SIZE_H = 80;
	static const unsigned char BLUE_ICON_GLOW_DATA[25600] = 
	{
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   2,   0, 186, 255,   3,   0, 186, 255,   4,   0, 186, 255,   5,   0, 186, 255,   6,   0, 186, 255,   6,   0, 186, 255,   6,   0, 186, 255,   7,   0, 186, 255,   7,   0, 186, 255,   6,   0, 186, 255,   6,   0, 186, 255,   5,   0, 186, 255,   5,   0, 186, 255,   3,   0, 186, 255,   2,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   3,   0, 186, 255,   5,   0, 186, 255,   6,   0, 186, 255,   7,   0, 186, 255,   9,   0, 186, 255,  10,   0, 186, 255,  11,   0, 186, 255,  12,   0, 186, 255,  13,   0, 186, 255,  13,   0, 186, 255,  13,   0, 186, 255,  13,   0, 186, 255,  13,   0, 186, 255,  13,   0, 186, 255,  12,   0, 186, 255,  12,   0, 186, 255,  10,   0, 186, 255,  10,   0, 186, 255,   9,   0, 186, 255,   7,   0, 186, 255,   6,   0, 186, 255,   5,   0, 186, 255,   2,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   4,   0, 186, 255,   7,   0, 186, 255,   9,   0, 186, 255,  10,   0, 186, 255,  12,   0, 186, 255,  14,   0, 186, 255,  16,   0, 186, 255,  16,   0, 186, 255,  17,   0, 186, 255,  18,   0, 186, 255,  19,   0, 186, 255,  19,   0, 186, 255,  20,   0, 186, 255,  20,   0, 186, 255,  20,   0, 186, 255,  19,   0, 186, 255,  19,   0, 186, 255,  18,   0, 186, 255,  18,   0, 186, 255,  17,   0, 186, 255,  16,   0, 186, 255,  13,   0, 186, 255,  12,   0, 186, 255,  11,   0, 186, 255,   9,   0, 186, 255,   6,   0, 186, 255,   4,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   6,   0, 186, 255,   8,   0, 186, 255,  10,   0, 186, 255,  13,   0, 186, 255,  15,   0, 186, 255,  17,   0, 186, 255,  18,   0, 186, 255,  21,   0, 186, 255,  21,   0, 186, 255,  23,   0, 186, 255,  24,   0, 186, 255,  25,   0, 186, 255,  26,   0, 186, 255,  26,   0, 186, 255,  26,   0, 186, 255,  26,   0, 186, 255,  26,   0, 186, 255,  26,   0, 186, 255,  25,   0, 186, 255,  25,   0, 186, 255,  23,   0, 186, 255,  23,   0, 186, 255,  22,   0, 186, 255,  20,   0, 186, 255,  19,   0, 186, 255,  17,   0, 186, 255,  15,   0, 186, 255,  13,   0, 186, 255,  11,   0, 186, 255,   8,   0, 186, 255,   6,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   3,   0, 186, 255,   7,   0, 186, 255,   9,   0, 186, 255,  12,   0, 186, 255,  15,   0, 186, 255,  17,   0, 186, 255,  19,   0, 186, 255,  22,   0, 186, 255,  23,   0, 186, 255,  25,   0, 186, 255,  27,   0, 186, 255,  28,   0, 186, 255,  29,   0, 186, 255,  31,   0, 186, 255,  32,   0, 186, 255,  32,   0, 186, 255,  33,   0, 186, 255,  33,   0, 186, 255,  33,   0, 186, 255,  32,   0, 186, 255,  32,   0, 186, 255,  32,   0, 186, 255,  32,   0, 186, 255,  30,   0, 186, 255,  29,   0, 186, 255,  28,   0, 186, 255,  26,   0, 186, 255,  25,   0, 186, 255,  23,   0, 186, 255,  21,   0, 186, 255,  20,   0, 186, 255,  17,   0, 186, 255,  15,   0, 186, 255,  12,   0, 186, 255,   9,   0, 186, 255,   6,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   6,   0, 186, 255,   9,   0, 186, 255,  12,   0, 186, 255,  16,   0, 186, 255,  18,   0, 186, 255,  21,   0, 186, 255,  23,   0, 186, 255,  26,   0, 186, 255,  27,   0, 186, 255,  30,   0, 186, 255,  32,   0, 186, 255,  33,   0, 186, 255,  34,   0, 186, 255,  36,   0, 186, 255,  37,   0, 186, 255,  38,   0, 186, 255,  38,   0, 186, 255,  39,   0, 186, 255,  39,   0, 186, 255,  39,   0, 186, 255,  39,   0, 186, 255,  39,   0, 186, 255,  38,   0, 186, 255,  38,   0, 186, 255,  37,   0, 186, 255,  36,   0, 186, 255,  34,   0, 186, 255,  33,   0, 186, 255,  31,   0, 186, 255,  30,   0, 186, 255,  28,   0, 186, 255,  26,   0, 186, 255,  23,   0, 186, 255,  21,   0, 186, 255,  18,   0, 186, 255,  16,   0, 186, 255,  12,   0, 186, 255,   9,   0, 186, 255,   6,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   5,   0, 186, 255,   9,   0, 186, 255,  11,   0, 186, 255,  15,   0, 186, 255,  18,   0, 186, 255,  21,   0, 186, 255,  24,   0, 186, 255,  26,   0, 186, 255,  29,   0, 186, 255,  31,   0, 186, 255,  34,   0, 186, 255,  36,   0, 186, 255,  38,   0, 186, 255,  40,   0, 186, 255,  41,   0, 186, 255,  42,   0, 186, 255,  43,   0, 186, 255,  44,   0, 186, 255,  44,   0, 186, 255,  46,   0, 186, 255,  45,   0, 186, 255,  45,   0, 186, 255,  46,   0, 186, 255,  45,   0, 186, 255,  45,   0, 186, 255,  44,   0, 186, 255,  43,   0, 186, 255,  43,   0, 186, 255,  41,   0, 186, 255,  39,   0, 186, 255,  38,   0, 186, 255,  36,   0, 186, 255,  33,   0, 186, 255,  31,   0, 186, 255,  29,   0, 186, 255,  26,   0, 186, 255,  24,   0, 186, 255,  21,   0, 186, 255,  18,   0, 186, 255,  15,   0, 186, 255,  12,   0, 186, 255,   8,   0, 186, 255,   4,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   2,   0, 186, 255,   7,   0, 186, 255,  10,   0, 186, 255,  14,   0, 186, 255,  18,   0, 186, 255,  20,   0, 186, 255,  23,   0, 186, 255,  27,   0, 186, 255,  30,   0, 186, 255,  32,   0, 186, 255,  35,   0, 186, 255,  37,   0, 186, 255,  40,   0, 186, 255,  42,   0, 186, 255,  44,   0, 186, 255,  46,   0, 186, 255,  48,   0, 186, 255,  48,   0, 186, 255,  50,   0, 186, 255,  50,   0, 186, 255,  51,   0, 186, 255,  52,   0, 186, 255,  53,   0, 186, 255,  52,   0, 186, 255,  53,   0, 186, 255,  52,   0, 186, 255,  52,   0, 186, 255,  50,   0, 186, 255,  50,   0, 186, 255,  48,   0, 186, 255,  47,   0, 186, 255,  45,   0, 186, 255,  43,   0, 186, 255,  42,   0, 186, 255,  40,   0, 186, 255,  37,   0, 186, 255,  35,   0, 186, 255,  33,   0, 186, 255,  29,   0, 186, 255,  27,   0, 186, 255,  24,   0, 186, 255,  20,   0, 186, 255,  17,   0, 186, 255,  14,   0, 186, 255,  10,   0, 186, 255,   6,   0, 186, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   8,   0, 186, 255,  11,   0, 186, 255,  16,   0, 186, 255,  19,   0, 186, 255,  23,   0, 186, 255,  27,   0, 186, 255,  29,   0, 186, 255,  33,   0, 186, 255,  36,   0, 186, 255,  39,   0, 186, 255,  41,   0, 186, 255,  44,   0, 186, 255,  46,   0, 186, 255,  49,   0, 186, 255,  50,   0, 186, 255,  52,   0, 186, 255,  53,   0, 186, 255,  55,   0, 186, 255,  56,   0, 186, 255,  57,   0, 186, 255,  58,   0, 186, 255,  59,   0, 186, 255,  59,   0, 186, 255,  59,   0, 186, 255,  59,   0, 186, 255,  58,   0, 186, 255,  58,   0, 186, 255,  57,   0, 186, 255,  57,   0, 186, 255,  55,   0, 186, 255,  54,   0, 186, 255,  52,   0, 186, 255,  51,   0, 186, 255,  48,   0, 186, 255,  46,   0, 186, 255,  44,   0, 186, 255,  42,   0, 186, 255,  39,   0, 186, 255,  36,   0, 186, 255,  33,   0, 186, 255,  29,   0, 186, 255,  26,   0, 186, 255,  23,   0, 186, 255,  19,   0, 186, 255,  15,   0, 186, 255,  12,   0, 186, 255,   8,   0, 186, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   5,   0, 186, 255,   9,   0, 186, 255,  13,   0, 186, 255,  17,   0, 186, 255,  21,   0, 186, 255,  24,   0, 186, 255,  28,   0, 186, 255,  32,   0, 186, 255,  35,   0, 186, 255,  39,   0, 186, 255,  42,   0, 186, 255,  44,   0, 186, 255,  47,   0, 186, 255,  50,   0, 186, 255,  53,   0, 186, 255,  54,   0, 186, 255,  57,   0, 186, 255,  58,   0, 186, 255,  60,   0, 186, 255,  61,   0, 186, 255,  62,   0, 186, 255,  63,   0, 186, 255,  64,   0, 186, 255,  65,   0, 186, 255,  65,   0, 186, 255,  66,   0, 186, 255,  66,   0, 186, 255,  65,   0, 186, 255,  64,   0, 186, 255,  63,   0, 186, 255,  63,   0, 186, 255,  61,   0, 186, 255,  60,   0, 186, 255,  58,   0, 186, 255,  57,   0, 186, 255,  55,   0, 186, 255,  52,   0, 186, 255,  50,   0, 186, 255,  48,   0, 186, 255,  45,   0, 186, 255,  42,   0, 186, 255,  38,   0, 186, 255,  35,   0, 186, 255,  32,   0, 186, 255,  28,   0, 186, 255,  25,   0, 186, 255,  21,   0, 186, 255,  17,   0, 186, 255,  13,   0, 186, 255,   9,   0, 186, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   5,   0, 186, 255,   9,   0, 186, 255,  14,   0, 186, 255,  18,   0, 186, 255,  22,   0, 186, 255,  26,   0, 186, 255,  30,   0, 186, 255,  34,   0, 186, 255,  37,   0, 186, 255,  41,   0, 186, 255,  45,   0, 186, 255,  47,   0, 186, 255,  50,   0, 186, 255,  54,   0, 186, 255,  55,   0, 186, 255,  58,   0, 186, 255,  61,   0, 186, 255,  63,   0, 186, 255,  64,   0, 186, 255,  67,   0, 186, 255,  68,   0, 186, 255,  69,   0, 186, 255,  70,   0, 186, 255,  71,   0, 186, 255,  71,   0, 186, 255,  72,   0, 186, 255,  72,   0, 186, 255,  71,   0, 186, 255,  71,   0, 186, 255,  71,   0, 186, 255,  70,   0, 186, 255,  69,   0, 186, 255,  68,   0, 186, 255,  66,   0, 186, 255,  64,   0, 186, 255,  62,   0, 186, 255,  61,   0, 186, 255,  58,   0, 186, 255,  56,   0, 186, 255,  53,   0, 186, 255,  50,   0, 186, 255,  48,   0, 186, 255,  45,   0, 186, 255,  41,   0, 186, 255,  37,   0, 186, 255,  34,   0, 186, 255,  30,   0, 186, 255,  26,   0, 186, 255,  22,   0, 186, 255,  18,   0, 186, 255,  14,   0, 186, 255,  10,   0, 186, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   5,   0, 186, 255,  10,   0, 186, 255,  14,   0, 186, 255,  19,   0, 186, 255,  23,   0, 186, 255,  27,   0, 186, 255,  31,   0, 186, 255,  35,   0, 186, 255,  39,   0, 186, 255,  43,   0, 186, 255,  47,   0, 186, 255,  50,   0, 186, 255,  53,   0, 186, 255,  56,   0, 186, 255,  59,   0, 186, 255,  62,   0, 186, 255,  65,   0, 186, 255,  66,   0, 186, 255,  69,   0, 186, 255,  71,   0, 186, 255,  72,   0, 186, 255,  75,   0, 186, 255,  76,   0, 186, 255,  77,   0, 186, 255,  77,   0, 186, 255,  78,   0, 186, 255,  79,   0, 186, 255,  78,   0, 186, 255,  78,   0, 186, 255,  78,   0, 186, 255,  77,   0, 186, 255,  77,   0, 186, 255,  75,   0, 186, 255,  74,   0, 186, 255,  73,   0, 186, 255,  71,   0, 186, 255,  69,   0, 186, 255,  67,   0, 186, 255,  64,   0, 186, 255,  62,   0, 186, 255,  59,   0, 186, 255,  57,   0, 186, 255,  53,   0, 186, 255,  50,   0, 186, 255,  46,   0, 186, 255,  43,   0, 186, 255,  39,   0, 186, 255,  35,   0, 186, 255,  31,   0, 186, 255,  27,   0, 186, 255,  23,   0, 186, 255,  19,   0, 186, 255,  14,   0, 186, 255,  10,   0, 186, 255,   5,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   5,   0, 186, 255,  10,   0, 186, 255,  15,   0, 186, 255,  20,   0, 186, 255,  24,   0, 186, 255,  28,   0, 186, 255,  32,   0, 186, 255,  36,   0, 186, 255,  40,   0, 186, 255,  45,   0, 186, 255,  48,   0, 186, 255,  52,   0, 186, 255,  56,   0, 186, 255,  59,   0, 186, 255,  62,   0, 186, 255,  65,   0, 186, 255,  67,   0, 186, 255,  71,   0, 186, 255,  73,   0, 186, 255,  75,   0, 186, 255,  77,   0, 186, 255,  79,   0, 186, 255,  80,   0, 186, 255,  82,   0, 186, 255,  83,   0, 186, 255,  84,   0, 186, 255,  85,   0, 186, 255,  85,   0, 186, 255,  85,   0, 186, 255,  85,   0, 186, 255,  85,   0, 186, 255,  84,   0, 186, 255,  83,   0, 186, 255,  82,   0, 186, 255,  80,   0, 186, 255,  78,   0, 186, 255,  77,   0, 186, 255,  75,   0, 186, 255,  73,   0, 186, 255,  70,   0, 186, 255,  67,   0, 186, 255,  65,   0, 186, 255,  62,   0, 186, 255,  59,   0, 186, 255,  55,   0, 186, 255,  52,   0, 186, 255,  48,   0, 186, 255,  44,   0, 186, 255,  40,   0, 186, 255,  36,   0, 186, 255,  32,   0, 186, 255,  28,   0, 186, 255,  23,   0, 186, 255,  19,   0, 186, 255,  14,   0, 186, 255,  10,   0, 186, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   5,   0, 186, 255,  10,   0, 186, 255,  15,   0, 186, 255,  19,   0, 186, 255,  24,   0, 186, 255,  28,   0, 186, 255,  33,   0, 186, 255,  37,   0, 186, 255,  42,   0, 186, 255,  46,   0, 186, 255,  50,   0, 186, 255,  54,   0, 186, 255,  57,   0, 186, 255,  61,   0, 186, 255,  65,   0, 186, 255,  68,   0, 186, 255,  71,   0, 186, 255,  74,   0, 186, 255,  76,   0, 186, 255,  79,   0, 186, 255,  82,   0, 186, 255,  83,   0, 186, 255,  85,   0, 186, 255,  87,   0, 186, 255,  88,   0, 186, 255,  90,   0, 186, 255,  90,   0, 186, 255,  91,   0, 186, 255,  91,   0, 186, 255,  92,   0, 186, 255,  91,   0, 186, 255,  91,   0, 186, 255,  90,   0, 186, 255,  89,   0, 186, 255,  88,   0, 186, 255,  87,   0, 186, 255,  85,   0, 186, 255,  83,   0, 186, 255,  82,   0, 186, 255,  79,   0, 186, 255,  77,   0, 186, 255,  73,   0, 186, 255,  71,   0, 186, 255,  67,   0, 186, 255,  64,   0, 186, 255,  61,   0, 186, 255,  57,   0, 186, 255,  54,   0, 186, 255,  50,   0, 186, 255,  46,   0, 186, 255,  41,   0, 186, 255,  37,   0, 186, 255,  32,   0, 186, 255,  28,   0, 186, 255,  24,   0, 186, 255,  19,   0, 186, 255,  15,   0, 186, 255,  10,   0, 186, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   4,   0, 186, 255,   8,   0, 186, 255,  14,   0, 186, 255,  19,   0, 186, 255,  24,   0, 186, 255,  28,   0, 186, 255,  33,   0, 186, 255,  37,   0, 186, 255,  42,   0, 186, 255,  47,   0, 186, 255,  51,   0, 186, 255,  55,   0, 186, 255,  59,   0, 186, 255,  63,   0, 186, 255,  66,   0, 186, 255,  70,   0, 186, 255,  73,   0, 186, 255,  77,   0, 186, 255,  80,   0, 186, 255,  83,   0, 186, 255,  85,   0, 186, 255,  88,   0, 186, 255,  89,   0, 186, 255,  92,   0, 186, 255,  93,   0, 186, 255,  94,   0, 186, 255,  96,   0, 186, 255,  96,   0, 186, 255,  97,   0, 186, 255,  98,   0, 186, 255,  98,   0, 186, 255,  98,   0, 186, 255,  97,   0, 186, 255,  97,   0, 186, 255,  96,   0, 186, 255,  95,   0, 186, 255,  94,   0, 186, 255,  91,   0, 186, 255,  89,   0, 186, 255,  88,   0, 186, 255,  85,   0, 186, 255,  82,   0, 186, 255,  79,   0, 186, 255,  76,   0, 186, 255,  74,   0, 186, 255,  70,   0, 186, 255,  67,   0, 186, 255,  63,   0, 186, 255,  59,   0, 186, 255,  54,   0, 186, 255,  51,   0, 186, 255,  46,   0, 186, 255,  42,   0, 186, 255,  37,   0, 186, 255,  33,   0, 186, 255,  28,   0, 186, 255,  24,   0, 186, 255,  19,   0, 186, 255,  14,   0, 186, 255,   9,   0, 186, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   2,   0, 186, 255,   8,   0, 186, 255,  13,   0, 186, 255,  18,   0, 186, 255,  24,   0, 186, 255,  28,   0, 186, 255,  33,   0, 186, 255,  38,   0, 186, 255,  42,   0, 186, 255,  47,   0, 186, 255,  51,   0, 186, 255,  56,   0, 186, 255,  59,   0, 186, 255,  64,   0, 186, 255,  68,   0, 186, 255,  72,   0, 186, 255,  75,   0, 186, 255,  79,   0, 186, 255,  82,   0, 186, 255,  86,   0, 186, 255,  88,   0, 186, 255,  91,   0, 186, 255,  93,   0, 186, 255,  96,   0, 186, 255,  98,   0, 186, 255,  99,   0, 186, 255, 101,   0, 186, 255, 102,   0, 186, 255, 104,   0, 186, 255, 104,   0, 186, 255, 104,   0, 186, 255, 105,   0, 186, 255, 104,   0, 186, 255, 104,   0, 186, 255, 103,   0, 186, 255, 103,   0, 186, 255, 101,   0, 186, 255,  99,   0, 186, 255,  98,   0, 186, 255,  96,   0, 186, 255,  93,   0, 186, 255,  91,   0, 186, 255,  88,   0, 186, 255,  85,   0, 186, 255,  82,   0, 186, 255,  79,   0, 186, 255,  75,   0, 186, 255,  71,   0, 186, 255,  68,   0, 186, 255,  64,   0, 186, 255,  60,   0, 186, 255,  55,   0, 186, 255,  51,   0, 186, 255,  46,   0, 186, 255,  42,   0, 186, 255,  38,   0, 186, 255,  33,   0, 186, 255,  28,   0, 186, 255,  24,   0, 186, 255,  18,   0, 186, 255,  13,   0, 186, 255,   8,   0, 186, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   6,   0, 186, 255,  12,   0, 186, 255,  17,   0, 186, 255,  22,   0, 186, 255,  27,   0, 186, 255,  32,   0, 186, 255,  37,   0, 186, 255,  42,   0, 186, 255,  47,   0, 186, 255,  52,   0, 186, 255,  56,   0, 186, 255,  61,   0, 186, 255,  65,   0, 186, 255,  69,   0, 186, 255,  73,   0, 186, 255,  77,   0, 186, 255,  81,   0, 186, 255,  85,   0, 186, 255,  88,   0, 186, 255,  91,   0, 186, 255,  95,   0, 186, 255,  97,   0, 186, 255,  99,   0, 186, 255, 102,   0, 186, 255, 104,   0, 186, 255, 106,   0, 186, 255, 108,   0, 186, 255, 109,   0, 186, 255, 110,   0, 186, 255, 111,   0, 186, 255, 111,   0, 186, 255, 112,   0, 186, 255, 111,   0, 186, 255, 111,   0, 186, 255, 110,   0, 186, 255, 108,   0, 186, 255, 107,   0, 186, 255, 106,   0, 186, 255, 104,   0, 186, 255, 101,   0, 186, 255, 100,   0, 186, 255,  97,   0, 186, 255,  94,   0, 186, 255,  91,   0, 186, 255,  88,   0, 186, 255,  85,   0, 186, 255,  80,   0, 186, 255,  77,   0, 186, 255,  73,   0, 186, 255,  69,   0, 186, 255,  65,   0, 186, 255,  60,   0, 186, 255,  56,   0, 186, 255,  52,   0, 186, 255,  47,   0, 186, 255,  42,   0, 186, 255,  37,   0, 186, 255,  33,   0, 186, 255,  27,   0, 186, 255,  22,   0, 186, 255,  17,   0, 186, 255,  12,   0, 186, 255,   6,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   5,   0, 186, 255,  11,   0, 186, 255,  16,   0, 186, 255,  21,   0, 186, 255,  27,   0, 186, 255,  31,   0, 186, 255,  36,   0, 186, 255,  41,   0, 186, 255,  47,   0, 186, 255,  52,   0, 186, 255,  56,   0, 186, 255,  61,   0, 186, 255,  65,   0, 186, 255,  70,   0, 186, 255,  74,   0, 186, 255,  78,   0, 186, 255,  82,   0, 186, 255,  86,   0, 186, 255,  90,   0, 186, 255,  94,   0, 186, 255,  97,   0, 186, 255, 100,   0, 186, 255, 103,   0, 186, 255, 106,   0, 186, 255, 108,   0, 186, 255, 110,   0, 186, 255, 112,   0, 186, 255, 113,   0, 186, 255, 115,   0, 186, 255, 117,   0, 186, 255, 117,   0, 186, 255, 118,   0, 186, 255, 118,   0, 186, 255, 118,   0, 186, 255, 117,   0, 186, 255, 117,   0, 186, 255, 115,   0, 186, 255, 114,   0, 186, 255, 112,   0, 186, 255, 110,   0, 186, 255, 108,   0, 186, 255, 105,   0, 186, 255, 102,   0, 186, 255, 100,   0, 186, 255,  97,   0, 186, 255,  93,   0, 186, 255,  90,   0, 186, 255,  86,   0, 186, 255,  82,   0, 186, 255,  78,   0, 186, 255,  74,   0, 186, 255,  70,   0, 186, 255,  66,   0, 186, 255,  61,   0, 186, 255,  57,   0, 186, 255,  51,   0, 186, 255,  47,   0, 186, 255,  42,   0, 186, 255,  36,   0, 186, 255,  32,   0, 186, 255,  26,   0, 186, 255,  21,   0, 186, 255,  15,   0, 186, 255,  10,   0, 186, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   8,   0, 186, 255,  14,   0, 186, 255,  20,   0, 186, 255,  24,   0, 186, 255,  30,   0, 186, 255,  35,   0, 186, 255,  41,   0, 186, 255,  45,   0, 186, 255,  51,   0, 186, 255,  56,   0, 186, 255,  60,   0, 186, 255,  66,   0, 186, 255,  70,   0, 186, 255,  75,   0, 186, 255,  80,   0, 186, 255,  84,   0, 186, 255,  87,   0, 186, 255,  91,   0, 186, 255,  95,   0, 186, 255,  99,   0, 186, 255, 103,   0, 186, 255, 106,   0, 186, 255, 108,   0, 186, 255, 112,   0, 186, 255, 114,   0, 186, 255, 117,   0, 186, 255, 118,   0, 186, 255, 120,   0, 186, 255, 122,   0, 186, 255, 123,   0, 186, 255, 123,   0, 186, 255, 124,   0, 186, 255, 124,   0, 186, 255, 124,   0, 186, 255, 124,   0, 186, 255, 123,   0, 186, 255, 122,   0, 186, 255, 120,   0, 186, 255, 118,   0, 186, 255, 116,   0, 186, 255, 114,   0, 186, 255, 112,   0, 186, 255, 109,   0, 186, 255, 105,   0, 186, 255, 102,   0, 186, 255,  99,   0, 186, 255,  95,   0, 186, 255,  92,   0, 186, 255,  87,   0, 186, 255,  83,   0, 186, 255,  79,   0, 186, 255,  75,   0, 186, 255,  70,   0, 186, 255,  65,   0, 186, 255,  60,   0, 186, 255,  55,   0, 186, 255,  51,   0, 186, 255,  46,   0, 186, 255,  40,   0, 186, 255,  36,   0, 186, 255,  30,   0, 186, 255,  24,   0, 186, 255,  19,   0, 186, 255,  14,   0, 186, 255,   8,   0, 186, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   6,   0, 186, 255,  12,   0, 186, 255,  17,   0, 186, 255,  23,   0, 186, 255,  28,   0, 186, 255,  34,   0, 186, 255,  39,   0, 186, 255,  45,   0, 186, 255,  50,   0, 186, 255,  55,   0, 186, 255,  60,   0, 186, 255,  65,   0, 186, 255,  70,   0, 186, 255,  74,   0, 186, 255,  79,   0, 186, 255,  84,   0, 186, 255,  88,   0, 186, 255,  93,   0, 186, 255,  96,   0, 186, 255, 101,   0, 186, 255, 104,   0, 186, 255, 108,   0, 186, 255, 112,   0, 186, 255, 115,   0, 186, 255, 118,   0, 186, 255, 120,   0, 186, 255, 122,   0, 186, 255, 125,   0, 186, 255, 127,   0, 186, 255, 128,   0, 186, 255, 129,   0, 186, 255, 130,   0, 186, 255, 131,   0, 186, 255, 131,   0, 186, 255, 131,   0, 186, 255, 130,   0, 186, 255, 130,   0, 186, 255, 129,   0, 186, 255, 127,   0, 186, 255, 125,   0, 186, 255, 123,   0, 186, 255, 120,   0, 186, 255, 118,   0, 186, 255, 115,   0, 186, 255, 111,   0, 186, 255, 108,   0, 186, 255, 104,   0, 186, 255, 100,   0, 186, 255,  97,   0, 186, 255,  92,   0, 186, 255,  88,   0, 186, 255,  84,   0, 186, 255,  79,   0, 186, 255,  74,   0, 186, 255,  70,   0, 186, 255,  65,   0, 186, 255,  60,   0, 186, 255,  55,   0, 186, 255,  50,   0, 186, 255,  44,   0, 186, 255,  39,   0, 186, 255,  34,   0, 186, 255,  28,   0, 186, 255,  23,   0, 186, 255,  18,   0, 186, 255,  12,   0, 186, 255,   6, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   4,   0, 186, 255,   9,   0, 186, 255,  15,   0, 186, 255,  21,   0, 186, 255,  27,   0, 186, 255,  32,   0, 186, 255,  37,   0, 186, 255,  43,   0, 186, 255,  48,   0, 186, 255,  53,   0, 186, 255,  59,   0, 186, 255,  64,   0, 186, 255,  69,   0, 186, 255,  74,   0, 186, 255,  79,   0, 186, 255,  84,   0, 186, 255,  88,   0, 186, 255,  93,   0, 186, 255,  98,   0, 186, 255, 102,   0, 186, 255, 106,   0, 186, 255, 110,   0, 186, 255, 113,   0, 186, 255, 117,   0, 186, 255, 120,   0, 186, 255, 124,   0, 186, 255, 126,   0, 186, 255, 129,   0, 186, 255, 130,   0, 186, 255, 132,   0, 186, 255, 134,   0, 186, 255, 136,   0, 186, 255, 137,   0, 186, 255, 137,   0, 186, 255, 137,   0, 186, 255, 138,   0, 186, 255, 137,   0, 186, 255, 136,   0, 186, 255, 134,   0, 186, 255, 133,   0, 186, 255, 131,   0, 186, 255, 129,   0, 186, 255, 126,   0, 186, 255, 123,   0, 186, 255, 120,   0, 186, 255, 117,   0, 186, 255, 113,   0, 186, 255, 110,   0, 186, 255, 106,   0, 186, 255, 102,   0, 186, 255,  98,   0, 186, 255,  93,   0, 186, 255,  88,   0, 186, 255,  84,   0, 186, 255,  79,   0, 186, 255,  74,   0, 186, 255,  69,   0, 186, 255,  64,   0, 186, 255,  58,   0, 186, 255,  53,   0, 186, 255,  48,   0, 186, 255,  43,   0, 186, 255,  37,   0, 186, 255,  32,   0, 186, 255,  26,   0, 186, 255,  21,   0, 186, 255,  15,   0, 186, 255,  10,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   6,   0, 186, 255,  12,   0, 186, 255,  18,   0, 186, 255,  24,   0, 186, 255,  29,   0, 186, 255,  35,   0, 186, 255,  41,   0, 186, 255,  47,   0, 186, 255,  52,   0, 186, 255,  58,   0, 186, 255,  62,   0, 186, 255,  68,   0, 186, 255,  73,   0, 186, 255,  79,   0, 186, 255,  83,   0, 186, 255,  89,   0, 186, 255,  93,   0, 186, 255,  98,   0, 186, 255, 103,   0, 186, 255, 107,   0, 186, 255, 111,   0, 186, 255, 115,   0, 186, 255, 119,   0, 186, 255, 123,   0, 186, 255, 126,   0, 186, 255, 129,   0, 186, 255, 132,   0, 186, 255, 135,   0, 186, 255, 137,   0, 186, 255, 139,   0, 186, 255, 141,   0, 186, 255, 142,   0, 186, 255, 143,   0, 186, 255, 144,   0, 186, 255, 144,   0, 186, 255, 143,   0, 186, 255, 143,   0, 186, 255, 142,   0, 186, 255, 141,   0, 186, 255, 139,   0, 186, 255, 138,   0, 186, 255, 134,   0, 186, 255, 132,   0, 186, 255, 129,   0, 186, 255, 126,   0, 186, 255, 122,   0, 186, 255, 119,   0, 186, 255, 115,   0, 186, 255, 111,   0, 186, 255, 106,   0, 186, 255, 102,   0, 186, 255,  98,   0, 186, 255,  93,   0, 186, 255,  89,   0, 186, 255,  83,   0, 186, 255,  79,   0, 186, 255,  73,   0, 186, 255,  68,   0, 186, 255,  62,   0, 186, 255,  58,   0, 186, 255,  52,   0, 186, 255,  47,   0, 186, 255,  41,   0, 186, 255,  35,   0, 186, 255,  29,   0, 186, 255,  24,   0, 186, 255,  18,   0, 186, 255,  13,   0, 186, 255,   7,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   9,   0, 186, 255,  16,   0, 186, 255,  21,   0, 186, 255,  27,   0, 186, 255,  33,   0, 186, 255,  39,   0, 186, 255,  44,   0, 186, 255,  50,   0, 186, 255,  55,   0, 186, 255,  61,   0, 186, 255,  66,   0, 186, 255,  72,   0, 186, 255,  77,   0, 186, 255,  82,   0, 186, 255,  88,   0, 186, 255,  92,   0, 186, 255,  98,   0, 186, 255, 102,   0, 186, 255, 107,   0, 186, 255, 112,   0, 186, 255, 116,   0, 186, 255, 120,   0, 186, 255, 125,   0, 186, 255, 129,   0, 186, 255, 131,   0, 186, 255, 135,   0, 186, 255, 138,   0, 186, 255, 141,   0, 186, 255, 144,   0, 186, 255, 146,   0, 186, 255, 147,   0, 186, 255, 148,   0, 186, 255, 150,   0, 186, 255, 150,   0, 186, 255, 151,   0, 186, 255, 150,   0, 186, 255, 150,   0, 186, 255, 149,   0, 186, 255, 148,   0, 186, 255, 145,   0, 186, 255, 144,   0, 186, 255, 141,   0, 186, 255, 138,   0, 186, 255, 135,   0, 186, 255, 132,   0, 186, 255, 128,   0, 186, 255, 124,   0, 186, 255, 121,   0, 186, 255, 116,   0, 186, 255, 111,   0, 186, 255, 107,   0, 186, 255, 102,   0, 186, 255,  98,   0, 186, 255,  92,   0, 186, 255,  88,   0, 186, 255,  82,   0, 186, 255,  78,   0, 186, 255,  71,   0, 186, 255,  66,   0, 186, 255,  61,   0, 186, 255,  56,   0, 186, 255,  50,   0, 186, 255,  44,   0, 186, 255,  39,   0, 186, 255,  33,   0, 186, 255,  26,   0, 186, 255,  21,   0, 186, 255,  15,   0, 186, 255,  10,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   6,   0, 186, 255,  12,   0, 186, 255,  18,   0, 186, 255,  24,   0, 186, 255,  30,   0, 186, 255,  36,   0, 186, 255,  42,   0, 186, 255,  47,   0, 186, 255,  53,   0, 186, 255,  59,   0, 186, 255,  65,   0, 186, 255,  70,   0, 186, 255,  76,   0, 186, 255,  81,   0, 186, 255,  86,   0, 186, 255,  91,   0, 186, 255,  96,   0, 186, 255, 102,   0, 186, 255, 107,   0, 186, 255, 112,   0, 186, 255, 117,   0, 186, 255, 121,   0, 186, 255, 125,   0, 186, 255, 129,   0, 186, 255, 134,   0, 186, 255, 137,   0, 186, 255, 141,   0, 186, 255, 144,   0, 186, 255, 146,   0, 186, 255, 149,   0, 186, 255, 152,   0, 186, 255, 154,   0, 186, 255, 155,   0, 186, 255, 156,   0, 186, 255, 156,   0, 186, 255, 157,   0, 186, 255, 157,   0, 186, 255, 156,   0, 186, 255, 155,   0, 186, 255, 153,   0, 186, 255, 151,   0, 186, 255, 149,   0, 186, 255, 147,   0, 186, 255, 144,   0, 186, 255, 141,   0, 186, 255, 137,   0, 186, 255, 133,   0, 186, 255, 129,   0, 186, 255, 125,   0, 186, 255, 121,   0, 186, 255, 117,   0, 186, 255, 112,   0, 186, 255, 106,   0, 186, 255, 101,   0, 186, 255,  96,   0, 186, 255,  91,   0, 186, 255,  86,   0, 186, 255,  81,   0, 186, 255,  76,   0, 186, 255,  70,   0, 186, 255,  65,   0, 186, 255,  58,   0, 186, 255,  53,   0, 186, 255,  48,   0, 186, 255,  42,   0, 186, 255,  36,   0, 186, 255,  30,   0, 186, 255,  23,   0, 186, 255,  17,   0, 186, 255,  12,   0, 186, 255,   6, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   9,   0, 186, 255,  14,   0, 186, 255,  20,   0, 186, 255,  26,   0, 186, 255,  33,   0, 186, 255,  39,   0, 186, 255,  45,   0, 186, 255,  50,   0, 186, 255,  56,   0, 186, 255,  62,   0, 186, 255,  67,   0, 186, 255,  73,   0, 186, 255,  79,   0, 186, 255,  84,   0, 186, 255,  90,   0, 186, 255,  96,   0, 186, 255, 101,   0, 186, 255, 106,   0, 186, 255, 111,   0, 186, 255, 116,   0, 186, 255, 121,   0, 186, 255, 126,   0, 186, 255, 130,   0, 186, 255, 135,   0, 186, 255, 138,   0, 186, 255, 142,   0, 186, 255, 146,   0, 186, 255, 149,   0, 186, 255, 152,   0, 186, 255, 155,   0, 186, 255, 158,   0, 186, 255, 160,   0, 186, 255, 161,   0, 186, 255, 162,   0, 186, 255, 163,   0, 186, 255, 163,   0, 186, 255, 164,   0, 186, 255, 163,   0, 186, 255, 161,   0, 186, 255, 160,   0, 186, 255, 158,   0, 186, 255, 155,   0, 186, 255, 153,   0, 186, 255, 150,   0, 186, 255, 146,   0, 186, 255, 142,   0, 186, 255, 139,   0, 186, 255, 134,   0, 186, 255, 130,   0, 186, 255, 126,   0, 186, 255, 121,   0, 186, 255, 116,   0, 186, 255, 111,   0, 186, 255, 106,   0, 186, 255, 101,   0, 186, 255,  96,   0, 186, 255,  90,   0, 186, 255,  85,   0, 186, 255,  79,   0, 186, 255,  73,   0, 186, 255,  68,   0, 186, 255,  62,   0, 186, 255,  56,   0, 186, 255,  50,   0, 186, 255,  45,   0, 186, 255,  38,   0, 186, 255,  32,   0, 186, 255,  27,   0, 186, 255,  21,   0, 186, 255,  15,   0, 186, 255,   8,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   4,   0, 186, 255,  11,   0, 186, 255,  17,   0, 186, 255,  23,   0, 186, 255,  29,   0, 186, 255,  35,   0, 186, 255,  42,   0, 186, 255,  47,   0, 186, 255,  53,   0, 186, 255,  59,   0, 186, 255,  65,   0, 186, 255,  71,   0, 186, 255,  76,   0, 186, 255,  82,   0, 186, 255,  87,   0, 186, 255,  94,   0, 186, 255,  99,   0, 186, 255, 104,   0, 186, 255, 110,   0, 186, 255, 115,   0, 186, 255, 120,   0, 186, 255, 126,   0, 186, 255, 130,   0, 186, 255, 134,   0, 186, 255, 140,   0, 186, 255, 144,   0, 186, 255, 148,   0, 186, 255, 152,   0, 186, 255, 155,   0, 186, 255, 158,   0, 186, 255, 161,   0, 186, 255, 163,   0, 186, 255, 166,   0, 186, 255, 168,   0, 186, 255, 169,   0, 186, 255, 170,   0, 186, 255, 170,   0, 186, 255, 169,   0, 186, 255, 169,   0, 186, 255, 168,   0, 186, 255, 166,   0, 186, 255, 164,   0, 186, 255, 162,   0, 186, 255, 158,   0, 186, 255, 155,   0, 186, 255, 151,   0, 186, 255, 148,   0, 186, 255, 143,   0, 186, 255, 139,   0, 186, 255, 135,   0, 186, 255, 130,   0, 186, 255, 125,   0, 186, 255, 120,   0, 186, 255, 115,   0, 186, 255, 110,   0, 186, 255, 105,   0, 186, 255,  99,   0, 186, 255,  94,   0, 186, 255,  88,   0, 186, 255,  83,   0, 186, 255,  77,   0, 186, 255,  70,   0, 186, 255,  65,   0, 186, 255,  59,   0, 186, 255,  53,   0, 186, 255,  47,   0, 186, 255,  41,   0, 186, 255,  35,   0, 186, 255,  30,   0, 186, 255,  23,   0, 186, 255,  17,   0, 186, 255,  11,   0, 186, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   7,   0, 186, 255,  13,   0, 186, 255,  20,   0, 186, 255,  26,   0, 186, 255,  31,   0, 186, 255,  37,   0, 186, 255,  43,   0, 186, 255,  50,   0, 186, 255,  56,   0, 186, 255,  61,   0, 186, 255,  68,   0, 186, 255,  74,   0, 186, 255,  80,   0, 186, 255,  85,   0, 186, 255,  92,   0, 186, 255,  97,   0, 186, 255, 102,   0, 186, 255, 108,   0, 186, 255, 113,   0, 186, 255, 119,   0, 186, 255, 124,   0, 186, 255, 130,   0, 186, 255, 135,   0, 186, 255, 140,   0, 186, 255, 144,   0, 186, 255, 148,   0, 186, 255, 153,   0, 186, 255, 157,   0, 186, 255, 161,   0, 186, 255, 164,   0, 186, 255, 167,   0, 186, 255, 170,   0, 186, 255, 172,   0, 186, 255, 174,   0, 186, 255, 175,   0, 186, 255, 176,   0, 186, 255, 176,   0, 186, 255, 177,   0, 186, 255, 176,   0, 186, 255, 174,   0, 186, 255, 172,   0, 186, 255, 170,   0, 186, 255, 167,   0, 186, 255, 165,   0, 186, 255, 161,   0, 186, 255, 157,   0, 186, 255, 153,   0, 186, 255, 149,   0, 186, 255, 144,   0, 186, 255, 140,   0, 186, 255, 134,   0, 186, 255, 130,   0, 186, 255, 124,   0, 186, 255, 119,   0, 186, 255, 114,   0, 186, 255, 108,   0, 186, 255, 102,   0, 186, 255,  97,   0, 186, 255,  91,   0, 186, 255,  85,   0, 186, 255,  80,   0, 186, 255,  74,   0, 186, 255,  68,   0, 186, 255,  62,   0, 186, 255,  56,   0, 186, 255,  50,   0, 186, 255,  43,   0, 186, 255,  38,   0, 186, 255,  31,   0, 186, 255,  25,   0, 186, 255,  19,   0, 186, 255,  13,   0, 186, 255,   7,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   9,   0, 186, 255,  15,   0, 186, 255,  22,   0, 186, 255,  28,   0, 186, 255,  34,   0, 186, 255,  40,   0, 186, 255,  46,   0, 186, 255,  52,   0, 186, 255,  59,   0, 186, 255,  64,   0, 186, 255,  70,   0, 186, 255,  77,   0, 186, 255,  83,   0, 186, 255,  88,   0, 186, 255,  94,   0, 186, 255, 100,   0, 186, 255, 106,   0, 186, 255, 112,   0, 186, 255, 117,   0, 186, 255, 123,   0, 186, 255, 128,   0, 186, 255, 134,   0, 186, 255, 138,   0, 186, 255, 143,   0, 186, 255, 149,   0, 186, 255, 153,   0, 186, 255, 158,   0, 186, 255, 162,   0, 186, 255, 166,   0, 186, 255, 170,   0, 186, 255, 173,   0, 186, 255, 176,   0, 186, 255, 179,   0, 186, 255, 181,   0, 186, 255, 182,   0, 186, 255, 183,   0, 186, 255, 183,   0, 186, 255, 183,   0, 186, 255, 182,   0, 186, 255, 181,   0, 186, 255, 178,   0, 186, 255, 176,   0, 186, 255, 173,   0, 186, 255, 170,   0, 186, 255, 166,   0, 186, 255, 163,   0, 186, 255, 158,   0, 186, 255, 153,   0, 186, 255, 149,   0, 186, 255, 143,   0, 186, 255, 139,   0, 186, 255, 134,   0, 186, 255, 128,   0, 186, 255, 123,   0, 186, 255, 117,   0, 186, 255, 112,   0, 186, 255, 105,   0, 186, 255, 100,   0, 186, 255,  94,   0, 186, 255,  88,   0, 186, 255,  83,   0, 186, 255,  77,   0, 186, 255,  71,   0, 186, 255,  65,   0, 186, 255,  58,   0, 186, 255,  52,   0, 186, 255,  46,   0, 186, 255,  40,   0, 186, 255,  34,   0, 186, 255,  28,   0, 186, 255,  21,   0, 186, 255,  15,   0, 186, 255,   8,   0, 186, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   4,   0, 186, 255,  11,   0, 186, 255,  17,   0, 186, 255,  23,   0, 186, 255,  29,   0, 186, 255,  36,   0, 186, 255,  42,   0, 186, 255,  48,   0, 186, 255,  54,   0, 186, 255,  61,   0, 186, 255,  67,   0, 186, 255,  73,   0, 186, 255,  79,   0, 186, 255,  85,   0, 186, 255,  91,   0, 186, 255,  97,   0, 186, 255, 103,   0, 186, 255, 108,   0, 186, 255, 115,   0, 186, 255, 121,   0, 186, 255, 126,   0, 186, 255, 132,   0, 186, 255, 137,   0, 186, 255, 143,   0, 186, 255, 148,   0, 186, 255, 152,   0, 186, 255, 158,   0, 186, 255, 163,   0, 186, 255, 167,   0, 186, 255, 171,   0, 186, 255, 175,   0, 186, 255, 179,   0, 186, 255, 182,   0, 186, 255, 185,   0, 186, 255, 187,   0, 186, 255, 188,   0, 186, 255, 190,   0, 186, 255, 190,   0, 186, 255, 189,   0, 186, 255, 189,   0, 186, 255, 187,   0, 186, 255, 185,   0, 186, 255, 182,   0, 186, 255, 178,   0, 186, 255, 175,   0, 186, 255, 171,   0, 186, 255, 167,   0, 186, 255, 163,   0, 186, 255, 158,   0, 186, 255, 153,   0, 186, 255, 147,   0, 186, 255, 143,   0, 186, 255, 137,   0, 186, 255, 131,   0, 186, 255, 126,   0, 186, 255, 120,   0, 186, 255, 114,   0, 186, 255, 109,   0, 186, 255, 103,   0, 186, 255,  97,   0, 186, 255,  91,   0, 186, 255,  85,   0, 186, 255,  78,   0, 186, 255,  73,   0, 186, 255,  66,   0, 186, 255,  61,   0, 186, 255,  55,   0, 186, 255,  48,   0, 186, 255,  42,   0, 186, 255,  36,   0, 186, 255,  29,   0, 186, 255,  23,   0, 186, 255,  17,   0, 186, 255,  10,   0, 186, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   6,   0, 186, 255,  12,   0, 186, 255,  19,   0, 186, 255,  25,   0, 186, 255,  31,   0, 186, 255,  37,   0, 186, 255,  44,   0, 186, 255,  50,   0, 186, 255,  56,   0, 186, 255,  63,   0, 186, 255,  68,   0, 186, 255,  75,   0, 186, 255,  82,   0, 186, 255,  88,   0, 186, 255,  94,   0, 186, 255, 100,   0, 186, 255, 105,   0, 186, 255, 111,   0, 186, 255, 118,   0, 186, 255, 123,   0, 186, 255, 130,   0, 186, 255, 135,   0, 186, 255, 140,   0, 186, 255, 146,   0, 186, 255, 151,   0, 186, 255, 157,   0, 186, 255, 162,   0, 186, 255, 167,   0, 186, 255, 172,   0, 186, 255, 176,   0, 186, 255, 181,   0, 186, 255, 184,   0, 186, 255, 188,   0, 186, 255, 191,   0, 186, 255, 193,   0, 186, 255, 195,   0, 186, 255, 196,   0, 186, 255, 196,   0, 186, 255, 195,   0, 186, 255, 195,   0, 186, 255, 193,   0, 186, 255, 191,   0, 186, 255, 188,   0, 186, 255, 184,   0, 186, 255, 181,   0, 186, 255, 177,   0, 186, 255, 172,   0, 186, 255, 167,   0, 186, 255, 162,   0, 186, 255, 157,   0, 186, 255, 152,   0, 186, 255, 146,   0, 186, 255, 141,   0, 186, 255, 134,   0, 186, 255, 129,   0, 186, 255, 124,   0, 186, 255, 118,   0, 186, 255, 111,   0, 186, 255, 105,   0, 186, 255, 100,   0, 186, 255,  93,   0, 186, 255,  87,   0, 186, 255,  81,   0, 186, 255,  75,   0, 186, 255,  69,   0, 186, 255,  63,   0, 186, 255,  56,   0, 186, 255,  50,   0, 186, 255,  44,   0, 186, 255,  37,   0, 186, 255,  31,   0, 186, 255,  25,   0, 186, 255,  18,   0, 186, 255,  12,   0, 186, 255,   6, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   7,   0, 186, 255,  14,   0, 186, 255,  20,   0, 186, 255,  26,   0, 186, 255,  33,   0, 186, 255,  40,   0, 186, 255,  45,   0, 186, 255,  52,   0, 186, 255,  58,   0, 186, 255,  65,   0, 186, 255,  71,   0, 186, 255,  77,   0, 186, 255,  84,   0, 186, 255,  89,   0, 186, 255,  96,   0, 186, 255, 101,   0, 186, 255, 108,   0, 186, 255, 114,   0, 186, 255, 120,   0, 186, 255, 127,   0, 186, 255, 132,   0, 186, 255, 138,   0, 186, 255, 144,   0, 186, 255, 150,   0, 186, 255, 156,   0, 186, 255, 161,   0, 186, 255, 166,   0, 186, 255, 172,   0, 186, 255, 176,   0, 186, 255, 181,   0, 186, 255, 185,   0, 186, 255, 190,   0, 186, 255, 193,   0, 186, 255, 197,   0, 186, 255, 199,   0, 186, 255, 201,   0, 186, 255, 202,   0, 186, 255, 202,   0, 186, 255, 202,   0, 186, 255, 201,   0, 186, 255, 199,   0, 186, 255, 197,   0, 186, 255, 193,   0, 186, 255, 190,   0, 186, 255, 186,   0, 186, 255, 181,   0, 186, 255, 176,   0, 186, 255, 172,   0, 186, 255, 166,   0, 186, 255, 161,   0, 186, 255, 155,   0, 186, 255, 150,   0, 186, 255, 144,   0, 186, 255, 138,   0, 186, 255, 132,   0, 186, 255, 127,   0, 186, 255, 120,   0, 186, 255, 114,   0, 186, 255, 108,   0, 186, 255, 102,   0, 186, 255,  95,   0, 186, 255,  89,   0, 186, 255,  84,   0, 186, 255,  77,   0, 186, 255,  71,   0, 186, 255,  64,   0, 186, 255,  58,   0, 186, 255,  52,   0, 186, 255,  45,   0, 186, 255,  39,   0, 186, 255,  33,   0, 186, 255,  27,   0, 186, 255,  21,   0, 186, 255,  14,   0, 186, 255,   8,   0, 186, 255,   1, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   9,   0, 186, 255,  15,   0, 186, 255,  22,   0, 186, 255,  28,   0, 186, 255,  35,   0, 186, 255,  41,   0, 186, 255,  48,   0, 186, 255,  54,   0, 186, 255,  60,   0, 186, 255,  66,   0, 186, 255,  73,   0, 186, 255,  79,   0, 186, 255,  85,   0, 186, 255,  91,   0, 186, 255,  98,   0, 186, 255, 104,   0, 186, 255, 110,   0, 186, 255, 117,   0, 186, 255, 123,   0, 186, 255, 129,   0, 186, 255, 135,   0, 186, 255, 141,   0, 186, 255, 147,   0, 186, 255, 153,   0, 186, 255, 159,   0, 186, 255, 164,   0, 186, 255, 170,   0, 186, 255, 176,   0, 186, 255, 180,   0, 186, 255, 186,   0, 186, 255, 190,   0, 186, 255, 195,   0, 186, 255, 199,   0, 186, 255, 202,   0, 186, 255, 205,   0, 186, 255, 207,   0, 186, 255, 209,   0, 186, 255, 209,   0, 186, 255, 209,   0, 186, 255, 208,   0, 186, 255, 206,   0, 186, 255, 202,   0, 186, 255, 199,   0, 186, 255, 195,   0, 186, 255, 190,   0, 186, 255, 186,   0, 186, 255, 181,   0, 186, 255, 176,   0, 186, 255, 169,   0, 186, 255, 164,   0, 186, 255, 158,   0, 186, 255, 153,   0, 186, 255, 147,   0, 186, 255, 140,   0, 186, 255, 134,   0, 186, 255, 129,   0, 186, 255, 123,   0, 186, 255, 116,   0, 186, 255, 110,   0, 186, 255, 104,   0, 186, 255,  98,   0, 186, 255,  91,   0, 186, 255,  85,   0, 186, 255,  79,   0, 186, 255,  73,   0, 186, 255,  66,   0, 186, 255,  60,   0, 186, 255,  53,   0, 186, 255,  47,   0, 186, 255,  41,   0, 186, 255,  35,   0, 186, 255,  28,   0, 186, 255,  22,   0, 186, 255,  15,   0, 186, 255,   8,   0, 186, 255,   2, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,  10,   0, 186, 255,  16,   0, 186, 255,  23,   0, 186, 255,  29,   0, 186, 255,  36,   0, 186, 255,  42,   0, 186, 255,  49,   0, 186, 255,  55,   0, 186, 255,  62,   0, 186, 255,  67,   0, 186, 255,  74,   0, 186, 255,  81,   0, 186, 255,  86,   0, 186, 255,  94,   0, 186, 255, 100,   0, 186, 255, 106,   0, 186, 255, 112,   0, 186, 255, 118,   0, 186, 255, 124,   0, 186, 255, 131,   0, 186, 255, 137,   0, 186, 255, 144,   0, 186, 255, 149,   0, 186, 255, 155,   0, 186, 255, 161,   0, 186, 255, 167,   0, 186, 255, 173,   0, 186, 255, 178,   0, 186, 255, 184,   0, 186, 255, 189,   0, 186, 255, 195,   0, 186, 255, 200,   0, 186, 255, 204,   0, 186, 255, 208,   0, 186, 255, 211,   0, 186, 255, 213,   0, 186, 255, 215,   0, 186, 255, 216,   0, 186, 255, 215,   0, 186, 255, 214,   0, 186, 255, 211,   0, 186, 255, 207,   0, 186, 255, 204,   0, 186, 255, 200,   0, 186, 255, 195,   0, 186, 255, 189,   0, 186, 255, 185,   0, 186, 255, 178,   0, 186, 255, 173,   0, 186, 255, 167,   0, 186, 255, 162,   0, 186, 255, 156,   0, 186, 255, 149,   0, 186, 255, 143,   0, 186, 255, 137,   0, 186, 255, 130,   0, 186, 255, 124,   0, 186, 255, 118,   0, 186, 255, 113,   0, 186, 255, 106,   0, 186, 255, 100,   0, 186, 255,  93,   0, 186, 255,  87,   0, 186, 255,  81,   0, 186, 255,  74,   0, 186, 255,  68,   0, 186, 255,  61,   0, 186, 255,  55,   0, 186, 255,  48,   0, 186, 255,  42,   0, 186, 255,  36,   0, 186, 255,  29,   0, 186, 255,  23,   0, 186, 255,  16,   0, 186, 255,   9,   0, 186, 255,   4, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   4,   0, 186, 255,  11,   0, 186, 255,  18,   0, 186, 255,  24,   0, 186, 255,  30,   0, 186, 255,  36,   0, 186, 255,  43,   0, 186, 255,  50,   0, 186, 255,  56,   0, 186, 255,  62,   0, 186, 255,  69,   0, 186, 255,  75,   0, 186, 255,  81,   0, 186, 255,  88,   0, 186, 255,  94,   0, 186, 255, 101,   0, 186, 255, 107,   0, 186, 255, 114,   0, 186, 255, 120,   0, 186, 255, 126,   0, 186, 255, 133,   0, 186, 255, 139,   0, 186, 255, 146,   0, 186, 255, 152,   0, 186, 255, 158,   0, 186, 255, 164,   0, 186, 255, 170,   0, 186, 255, 176,   0, 186, 255, 182,   0, 186, 255, 187,   0, 186, 255, 193,   0, 186, 255, 198,   0, 186, 255, 204,   0, 186, 255, 209,   0, 186, 255, 213,   0, 186, 255, 217,   0, 186, 255, 220,   0, 186, 255, 221,   0, 186, 255, 223,   0, 186, 255, 222,   0, 186, 255, 220,   0, 186, 255, 217,   0, 186, 255, 213,   0, 186, 255, 209,   0, 186, 255, 204,   0, 186, 255, 199,   0, 186, 255, 194,   0, 186, 255, 187,   0, 186, 255, 182,   0, 186, 255, 176,   0, 186, 255, 170,   0, 186, 255, 164,   0, 186, 255, 158,   0, 186, 255, 152,   0, 186, 255, 145,   0, 186, 255, 140,   0, 186, 255, 132,   0, 186, 255, 126,   0, 186, 255, 121,   0, 186, 255, 113,   0, 186, 255, 108,   0, 186, 255, 101,   0, 186, 255,  95,   0, 186, 255,  88,   0, 186, 255,  82,   0, 186, 255,  75,   0, 186, 255,  69,   0, 186, 255,  63,   0, 186, 255,  56,   0, 186, 255,  50,   0, 186, 255,  44,   0, 186, 255,  37,   0, 186, 255,  30,   0, 186, 255,  24,   0, 186, 255,  18,   0, 186, 255,  11,   0, 186, 255,   4, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   5,   0, 186, 255,  12,   0, 186, 255,  18,   0, 186, 255,  24,   0, 186, 255,  32,   0, 186, 255,  38,   0, 186, 255,  44,   0, 186, 255,  51,   0, 186, 255,  57,   0, 186, 255,  64,   0, 186, 255,  71,   0, 186, 255,  77,   0, 186, 255,  83,   0, 186, 255,  89,   0, 186, 255,  96,   0, 186, 255, 103,   0, 186, 255, 109,   0, 186, 255, 115,   0, 186, 255, 121,   0, 186, 255, 128,   0, 186, 255, 135,   0, 186, 255, 141,   0, 186, 255, 147,   0, 186, 255, 154,   0, 186, 255, 159,   0, 186, 255, 166,   0, 186, 255, 173,   0, 186, 255, 179,   0, 186, 255, 185,   0, 186, 255, 190,   0, 186, 255, 196,   0, 186, 255, 202,   0, 186, 255, 208,   0, 186, 255, 213,   0, 186, 255, 218,   0, 186, 255, 223,   0, 186, 255, 226,   0, 186, 255, 228,   0, 186, 255, 229,   0, 186, 255, 228,   0, 186, 255, 225,   0, 186, 255, 222,   0, 186, 255, 218,   0, 186, 255, 213,   0, 186, 255, 208,   0, 186, 255, 202,   0, 186, 255, 197,   0, 186, 255, 190,   0, 186, 255, 184,   0, 186, 255, 179,   0, 186, 255, 172,   0, 186, 255, 166,   0, 186, 255, 160,   0, 186, 255, 153,   0, 186, 255, 147,   0, 186, 255, 140,   0, 186, 255, 134,   0, 186, 255, 128,   0, 186, 255, 122,   0, 186, 255, 115,   0, 186, 255, 109,   0, 186, 255, 103,   0, 186, 255,  96,   0, 186, 255,  89,   0, 186, 255,  83,   0, 186, 255,  77,   0, 186, 255,  70,   0, 186, 255,  64,   0, 186, 255,  57,   0, 186, 255,  51,   0, 186, 255,  44,   0, 186, 255,  38,   0, 186, 255,  31,   0, 186, 255,  24,   0, 186, 255,  18,   0, 186, 255,  12,   0, 186, 255,   5, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   6,   0, 186, 255,  12,   0, 186, 255,  18,   0, 186, 255,  26,   0, 186, 255,  31,   0, 186, 255,  38,   0, 186, 255,  45,   0, 186, 255,  51,   0, 186, 255,  58,   0, 186, 255,  64,   0, 186, 255,  70,   0, 186, 255,  78,   0, 186, 255,  84,   0, 186, 255,  90,   0, 186, 255,  97,   0, 186, 255, 103,   0, 186, 255, 109,   0, 186, 255, 117,   0, 186, 255, 122,   0, 186, 255, 130,   0, 186, 255, 135,   0, 186, 255, 142,   0, 186, 255, 148,   0, 186, 255, 155,   0, 186, 255, 161,   0, 186, 255, 168,   0, 186, 255, 174,   0, 186, 255, 180,   0, 186, 255, 187,   0, 186, 255, 193,   0, 186, 255, 200,   0, 186, 255, 205,   0, 186, 255, 211,   0, 186, 255, 217,   0, 186, 255, 222,   0, 186, 255, 227,   0, 186, 255, 232,   0, 186, 255, 234,   0, 186, 255, 235,   0, 186, 255, 234,   0, 186, 255, 231,   0, 186, 255, 227,   0, 186, 255, 222,   0, 186, 255, 217,   0, 186, 255, 211,   0, 186, 255, 205,   0, 186, 255, 199,   0, 186, 255, 193,   0, 186, 255, 187,   0, 186, 255, 180,   0, 186, 255, 174,   0, 186, 255, 168,   0, 186, 255, 162,   0, 186, 255, 155,   0, 186, 255, 149,   0, 186, 255, 142,   0, 186, 255, 135,   0, 186, 255, 129,   0, 186, 255, 123,   0, 186, 255, 117,   0, 186, 255, 110,   0, 186, 255, 103,   0, 186, 255,  97,   0, 186, 255,  90,   0, 186, 255,  84,   0, 186, 255,  78,   0, 186, 255,  71,   0, 186, 255,  65,   0, 186, 255,  58,   0, 186, 255,  51,   0, 186, 255,  45,   0, 186, 255,  38,   0, 186, 255,  32,   0, 186, 255,  25,   0, 186, 255,  18,   0, 186, 255,  12,   0, 186, 255,   6, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   6,   0, 186, 255,  13,   0, 186, 255,  19,   0, 186, 255,  26,   0, 186, 255,  32,   0, 186, 255,  38,   0, 186, 255,  45,   0, 186, 255,  52,   0, 186, 255,  59,   0, 186, 255,  65,   0, 186, 255,  71,   0, 186, 255,  78,   0, 186, 255,  85,   0, 186, 255,  91,   0, 186, 255,  98,   0, 186, 255, 104,   0, 186, 255, 111,   0, 186, 255, 117,   0, 186, 255, 124,   0, 186, 255, 130,   0, 186, 255, 136,   0, 186, 255, 144,   0, 186, 255, 149,   0, 186, 255, 156,   0, 186, 255, 162,   0, 186, 255, 169,   0, 186, 255, 175,   0, 186, 255, 182,   0, 186, 255, 188,   0, 186, 255, 195,   0, 186, 255, 201,   0, 186, 255, 207,   0, 186, 255, 214,   0, 186, 255, 219,   0, 186, 255, 226,   0, 186, 255, 231,   0, 186, 255, 236,   0, 186, 255, 241,   0, 186, 255, 242,   0, 186, 255, 240,   0, 186, 255, 236,   0, 186, 255, 232,   0, 186, 255, 226,   0, 186, 255, 219,   0, 186, 255, 213,   0, 186, 255, 208,   0, 186, 255, 201,   0, 186, 255, 194,   0, 186, 255, 188,   0, 186, 255, 181,   0, 186, 255, 175,   0, 186, 255, 169,   0, 186, 255, 163,   0, 186, 255, 156,   0, 186, 255, 150,   0, 186, 255, 143,   0, 186, 255, 137,   0, 186, 255, 130,   0, 186, 255, 124,   0, 186, 255, 117,   0, 186, 255, 110,   0, 186, 255, 104,   0, 186, 255,  98,   0, 186, 255,  91,   0, 186, 255,  84,   0, 186, 255,  78,   0, 186, 255,  72,   0, 186, 255,  65,   0, 186, 255,  58,   0, 186, 255,  52,   0, 186, 255,  45,   0, 186, 255,  39,   0, 186, 255,  32,   0, 186, 255,  26,   0, 186, 255,  19,   0, 186, 255,  12,   0, 186, 255,   6, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   6,   0, 186, 255,  13,   0, 186, 255,  19,   0, 186, 255,  26,   0, 186, 255,  33,   0, 186, 255,  39,   0, 186, 255,  45,   0, 186, 255,  52,   0, 186, 255,  59,   0, 186, 255,  65,   0, 186, 255,  72,   0, 186, 255,  79,   0, 186, 255,  85,   0, 186, 255,  91,   0, 186, 255,  97,   0, 186, 255, 105,   0, 186, 255, 111,   0, 186, 255, 117,   0, 186, 255, 124,   0, 186, 255, 131,   0, 186, 255, 137,   0, 186, 255, 143,   0, 186, 255, 150,   0, 186, 255, 157,   0, 186, 255, 164,   0, 186, 255, 170,   0, 186, 255, 176,   0, 186, 255, 183,   0, 186, 255, 189,   0, 186, 255, 196,   0, 186, 255, 203,   0, 186, 255, 208,   0, 186, 255, 215,   0, 186, 255, 221,   0, 186, 255, 228,   0, 186, 255, 234,   0, 186, 255, 241,   0, 186, 255, 245,   0, 186, 255, 249,   0, 186, 255, 246,   0, 186, 255, 241,   0, 186, 255, 234,   0, 186, 255, 228,   0, 186, 255, 221,   0, 186, 255, 215,   0, 186, 255, 208,   0, 186, 255, 202,   0, 186, 255, 196,   0, 186, 255, 189,   0, 186, 255, 182,   0, 186, 255, 176,   0, 186, 255, 170,   0, 186, 255, 164,   0, 186, 255, 157,   0, 186, 255, 151,   0, 186, 255, 143,   0, 186, 255, 137,   0, 186, 255, 131,   0, 186, 255, 124,   0, 186, 255, 118,   0, 186, 255, 111,   0, 186, 255, 105,   0, 186, 255,  98,   0, 186, 255,  91,   0, 186, 255,  84,   0, 186, 255,  78,   0, 186, 255,  72,   0, 186, 255,  66,   0, 186, 255,  59,   0, 186, 255,  52,   0, 186, 255,  45,   0, 186, 255,  39,   0, 186, 255,  33,   0, 186, 255,  26,   0, 186, 255,  19,   0, 186, 255,  13,   0, 186, 255,   6, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   6,   0, 186, 255,  13,   0, 186, 255,  20,   0, 186, 255,  26,   0, 186, 255,  33,   0, 186, 255,  40,   0, 186, 255,  46,   0, 186, 255,  53,   0, 186, 255,  59,   0, 186, 255,  66,   0, 186, 255,  72,   0, 186, 255,  78,   0, 186, 255,  85,   0, 186, 255,  91,   0, 186, 255,  99,   0, 186, 255, 104,   0, 186, 255, 111,   0, 186, 255, 118,   0, 186, 255, 124,   0, 186, 255, 131,   0, 186, 255, 137,   0, 186, 255, 144,   0, 186, 255, 150,   0, 186, 255, 157,   0, 186, 255, 163,   0, 186, 255, 170,   0, 186, 255, 176,   0, 186, 255, 183,   0, 186, 255, 190,   0, 186, 255, 196,   0, 186, 255, 203,   0, 186, 255, 210,   0, 186, 255, 215,   0, 186, 255, 223,   0, 186, 255, 229,   0, 186, 255, 235,   0, 186, 255, 242,   0, 186, 255, 248,   0, 186, 255, 255,   0, 186, 255, 248,   0, 186, 255, 242,   0, 186, 255, 235,   0, 186, 255, 228,   0, 186, 255, 223,   0, 186, 255, 215,   0, 186, 255, 209,   0, 186, 255, 202,   0, 186, 255, 196,   0, 186, 255, 189,   0, 186, 255, 183,   0, 186, 255, 177,   0, 186, 255, 170,   0, 186, 255, 164,   0, 186, 255, 157,   0, 186, 255, 151,   0, 186, 255, 143,   0, 186, 255, 138,   0, 186, 255, 130,   0, 186, 255, 125,   0, 186, 255, 118,   0, 186, 255, 111,   0, 186, 255, 105,   0, 186, 255,  98,   0, 186, 255,  91,   0, 186, 255,  85,   0, 186, 255,  78,   0, 186, 255,  72,   0, 186, 255,  65,   0, 186, 255,  59,   0, 186, 255,  52,   0, 186, 255,  46,   0, 186, 255,  39,   0, 186, 255,  33,   0, 186, 255,  26,   0, 186, 255,  19,   0, 186, 255,  13,   0, 186, 255,   7, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   7,   0, 186, 255,  13,   0, 186, 255,  19,   0, 186, 255,  26,   0, 186, 255,  33,   0, 186, 255,  39,   0, 186, 255,  46,   0, 186, 255,  53,   0, 186, 255,  58,   0, 186, 255,  65,   0, 186, 255,  72,   0, 186, 255,  78,   0, 186, 255,  84,   0, 186, 255,  91,   0, 186, 255,  97,   0, 186, 255, 104,   0, 186, 255, 111,   0, 186, 255, 118,   0, 186, 255, 124,   0, 186, 255, 131,   0, 186, 255, 137,   0, 186, 255, 143,   0, 186, 255, 151,   0, 186, 255, 157,   0, 186, 255, 164,   0, 186, 255, 169,   0, 186, 255, 177,   0, 186, 255, 183,   0, 186, 255, 189,   0, 186, 255, 196,   0, 186, 255, 202,   0, 186, 255, 208,   0, 186, 255, 215,   0, 186, 255, 221,   0, 186, 255, 228,   0, 186, 255, 235,   0, 186, 255, 240,   0, 186, 255, 246,   0, 186, 255, 248,   0, 186, 255, 246,   0, 186, 255, 241,   0, 186, 255, 234,   0, 186, 255, 228,   0, 186, 255, 221,   0, 186, 255, 216,   0, 186, 255, 208,   0, 186, 255, 203,   0, 186, 255, 196,   0, 186, 255, 189,   0, 186, 255, 183,   0, 186, 255, 176,   0, 186, 255, 170,   0, 186, 255, 163,   0, 186, 255, 157,   0, 186, 255, 150,   0, 186, 255, 144,   0, 186, 255, 137,   0, 186, 255, 131,   0, 186, 255, 124,   0, 186, 255, 118,   0, 186, 255, 111,   0, 186, 255, 104,   0, 186, 255,  98,   0, 186, 255,  91,   0, 186, 255,  85,   0, 186, 255,  78,   0, 186, 255,  72,   0, 186, 255,  65,   0, 186, 255,  59,   0, 186, 255,  52,   0, 186, 255,  46,   0, 186, 255,  39,   0, 186, 255,  33,   0, 186, 255,  26,   0, 186, 255,  20,   0, 186, 255,  13,   0, 186, 255,   7, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   6,   0, 186, 255,  12,   0, 186, 255,  19,   0, 186, 255,  26,   0, 186, 255,  32,   0, 186, 255,  39,   0, 186, 255,  46,   0, 186, 255,  52,   0, 186, 255,  58,   0, 186, 255,  65,   0, 186, 255,  71,   0, 186, 255,  78,   0, 186, 255,  84,   0, 186, 255,  92,   0, 186, 255,  97,   0, 186, 255, 104,   0, 186, 255, 110,   0, 186, 255, 117,   0, 186, 255, 124,   0, 186, 255, 130,   0, 186, 255, 137,   0, 186, 255, 143,   0, 186, 255, 150,   0, 186, 255, 156,   0, 186, 255, 163,   0, 186, 255, 169,   0, 186, 255, 175,   0, 186, 255, 182,   0, 186, 255, 188,   0, 186, 255, 195,   0, 186, 255, 202,   0, 186, 255, 207,   0, 186, 255, 214,   0, 186, 255, 219,   0, 186, 255, 226,   0, 186, 255, 231,   0, 186, 255, 236,   0, 186, 255, 240,   0, 186, 255, 242,   0, 186, 255, 240,   0, 186, 255, 236,   0, 186, 255, 231,   0, 186, 255, 226,   0, 186, 255, 220,   0, 186, 255, 214,   0, 186, 255, 208,   0, 186, 255, 201,   0, 186, 255, 194,   0, 186, 255, 188,   0, 186, 255, 182,   0, 186, 255, 176,   0, 186, 255, 169,   0, 186, 255, 163,   0, 186, 255, 156,   0, 186, 255, 149,   0, 186, 255, 143,   0, 186, 255, 137,   0, 186, 255, 130,   0, 186, 255, 123,   0, 186, 255, 118,   0, 186, 255, 111,   0, 186, 255, 104,   0, 186, 255,  98,   0, 186, 255,  91,   0, 186, 255,  85,   0, 186, 255,  78,   0, 186, 255,  72,   0, 186, 255,  65,   0, 186, 255,  58,   0, 186, 255,  52,   0, 186, 255,  45,   0, 186, 255,  38,   0, 186, 255,  33,   0, 186, 255,  25,   0, 186, 255,  19,   0, 186, 255,  13,   0, 186, 255,   7, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   6,   0, 186, 255,  12,   0, 186, 255,  19,   0, 186, 255,  26,   0, 186, 255,  32,   0, 186, 255,  39,   0, 186, 255,  45,   0, 186, 255,  51,   0, 186, 255,  58,   0, 186, 255,  65,   0, 186, 255,  70,   0, 186, 255,  78,   0, 186, 255,  84,   0, 186, 255,  91,   0, 186, 255,  97,   0, 186, 255, 103,   0, 186, 255, 109,   0, 186, 255, 117,   0, 186, 255, 122,   0, 186, 255, 129,   0, 186, 255, 136,   0, 186, 255, 142,   0, 186, 255, 148,   0, 186, 255, 155,   0, 186, 255, 161,   0, 186, 255, 168,   0, 186, 255, 175,   0, 186, 255, 180,   0, 186, 255, 187,   0, 186, 255, 193,   0, 186, 255, 199,   0, 186, 255, 205,   0, 186, 255, 212,   0, 186, 255, 217,   0, 186, 255, 223,   0, 186, 255, 227,   0, 186, 255, 231,   0, 186, 255, 234,   0, 186, 255, 235,   0, 186, 255, 234,   0, 186, 255, 232,   0, 186, 255, 227,   0, 186, 255, 223,   0, 186, 255, 217,   0, 186, 255, 212,   0, 186, 255, 206,   0, 186, 255, 199,   0, 186, 255, 193,   0, 186, 255, 187,   0, 186, 255, 181,   0, 186, 255, 175,   0, 186, 255, 167,   0, 186, 255, 161,   0, 186, 255, 155,   0, 186, 255, 149,   0, 186, 255, 142,   0, 186, 255, 136,   0, 186, 255, 129,   0, 186, 255, 123,   0, 186, 255, 117,   0, 186, 255, 110,   0, 186, 255, 103,   0, 186, 255,  97,   0, 186, 255,  91,   0, 186, 255,  84,   0, 186, 255,  77,   0, 186, 255,  71,   0, 186, 255,  64,   0, 186, 255,  58,   0, 186, 255,  52,   0, 186, 255,  44,   0, 186, 255,  39,   0, 186, 255,  31,   0, 186, 255,  25,   0, 186, 255,  19,   0, 186, 255,  12,   0, 186, 255,   5, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   6,   0, 186, 255,  11,   0, 186, 255,  18,   0, 186, 255,  25,   0, 186, 255,  31,   0, 186, 255,  38,   0, 186, 255,  45,   0, 186, 255,  51,   0, 186, 255,  57,   0, 186, 255,  63,   0, 186, 255,  70,   0, 186, 255,  76,   0, 186, 255,  83,   0, 186, 255,  89,   0, 186, 255,  96,   0, 186, 255, 102,   0, 186, 255, 109,   0, 186, 255, 115,   0, 186, 255, 122,   0, 186, 255, 128,   0, 186, 255, 134,   0, 186, 255, 141,   0, 186, 255, 147,   0, 186, 255, 154,   0, 186, 255, 160,   0, 186, 255, 166,   0, 186, 255, 172,   0, 186, 255, 178,   0, 186, 255, 185,   0, 186, 255, 190,   0, 186, 255, 197,   0, 186, 255, 202,   0, 186, 255, 208,   0, 186, 255, 213,   0, 186, 255, 218,   0, 186, 255, 223,   0, 186, 255, 226,   0, 186, 255, 228,   0, 186, 255, 228,   0, 186, 255, 229,   0, 186, 255, 226,   0, 186, 255, 222,   0, 186, 255, 218,   0, 186, 255, 213,   0, 186, 255, 208,   0, 186, 255, 202,   0, 186, 255, 197,   0, 186, 255, 191,   0, 186, 255, 185,   0, 186, 255, 178,   0, 186, 255, 172,   0, 186, 255, 166,   0, 186, 255, 159,   0, 186, 255, 154,   0, 186, 255, 147,   0, 186, 255, 141,   0, 186, 255, 134,   0, 186, 255, 128,   0, 186, 255, 121,   0, 186, 255, 116,   0, 186, 255, 109,   0, 186, 255, 103,   0, 186, 255,  96,   0, 186, 255,  90,   0, 186, 255,  83,   0, 186, 255,  77,   0, 186, 255,  70,   0, 186, 255,  63,   0, 186, 255,  57,   0, 186, 255,  51,   0, 186, 255,  44,   0, 186, 255,  38,   0, 186, 255,  31,   0, 186, 255,  25,   0, 186, 255,  18,   0, 186, 255,  11,   0, 186, 255,   5, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   4,   0, 186, 255,  10,   0, 186, 255,  17,   0, 186, 255,  24,   0, 186, 255,  30,   0, 186, 255,  37,   0, 186, 255,  43,   0, 186, 255,  50,   0, 186, 255,  56,   0, 186, 255,  62,   0, 186, 255,  69,   0, 186, 255,  75,   0, 186, 255,  82,   0, 186, 255,  89,   0, 186, 255,  95,   0, 186, 255, 101,   0, 186, 255, 107,   0, 186, 255, 114,   0, 186, 255, 120,   0, 186, 255, 127,   0, 186, 255, 133,   0, 186, 255, 139,   0, 186, 255, 146,   0, 186, 255, 151,   0, 186, 255, 157,   0, 186, 255, 164,   0, 186, 255, 170,   0, 186, 255, 176,   0, 186, 255, 182,   0, 186, 255, 188,   0, 186, 255, 193,   0, 186, 255, 198,   0, 186, 255, 204,   0, 186, 255, 209,   0, 186, 255, 213,   0, 186, 255, 217,   0, 186, 255, 220,   0, 186, 255, 222,   0, 186, 255, 222,   0, 186, 255, 222,   0, 186, 255, 220,   0, 186, 255, 217,   0, 186, 255, 213,   0, 186, 255, 208,   0, 186, 255, 204,   0, 186, 255, 199,   0, 186, 255, 193,   0, 186, 255, 188,   0, 186, 255, 182,   0, 186, 255, 176,   0, 186, 255, 170,   0, 186, 255, 164,   0, 186, 255, 158,   0, 186, 255, 152,   0, 186, 255, 146,   0, 186, 255, 139,   0, 186, 255, 133,   0, 186, 255, 127,   0, 186, 255, 121,   0, 186, 255, 114,   0, 186, 255, 108,   0, 186, 255, 101,   0, 186, 255,  95,   0, 186, 255,  89,   0, 186, 255,  82,   0, 186, 255,  75,   0, 186, 255,  69,   0, 186, 255,  62,   0, 186, 255,  56,   0, 186, 255,  50,   0, 186, 255,  43,   0, 186, 255,  37,   0, 186, 255,  30,   0, 186, 255,  24,   0, 186, 255,  18,   0, 186, 255,  11,   0, 186, 255,   4, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,  10,   0, 186, 255,  16,   0, 186, 255,  23,   0, 186, 255,  29,   0, 186, 255,  35,   0, 186, 255,  43,   0, 186, 255,  49,   0, 186, 255,  55,   0, 186, 255,  61,   0, 186, 255,  68,   0, 186, 255,  75,   0, 186, 255,  81,   0, 186, 255,  87,   0, 186, 255,  93,   0, 186, 255, 100,   0, 186, 255, 106,   0, 186, 255, 112,   0, 186, 255, 119,   0, 186, 255, 125,   0, 186, 255, 131,   0, 186, 255, 137,   0, 186, 255, 144,   0, 186, 255, 150,   0, 186, 255, 155,   0, 186, 255, 161,   0, 186, 255, 167,   0, 186, 255, 173,   0, 186, 255, 179,   0, 186, 255, 184,   0, 186, 255, 189,   0, 186, 255, 195,   0, 186, 255, 200,   0, 186, 255, 204,   0, 186, 255, 208,   0, 186, 255, 211,   0, 186, 255, 213,   0, 186, 255, 215,   0, 186, 255, 216,   0, 186, 255, 215,   0, 186, 255, 214,   0, 186, 255, 211,   0, 186, 255, 208,   0, 186, 255, 204,   0, 186, 255, 200,   0, 186, 255, 195,   0, 186, 255, 190,   0, 186, 255, 184,   0, 186, 255, 179,   0, 186, 255, 174,   0, 186, 255, 168,   0, 186, 255, 162,   0, 186, 255, 155,   0, 186, 255, 150,   0, 186, 255, 143,   0, 186, 255, 137,   0, 186, 255, 131,   0, 186, 255, 124,   0, 186, 255, 118,   0, 186, 255, 113,   0, 186, 255, 106,   0, 186, 255, 100,   0, 186, 255,  93,   0, 186, 255,  86,   0, 186, 255,  80,   0, 186, 255,  75,   0, 186, 255,  68,   0, 186, 255,  61,   0, 186, 255,  55,   0, 186, 255,  48,   0, 186, 255,  42,   0, 186, 255,  35,   0, 186, 255,  30,   0, 186, 255,  23,   0, 186, 255,  16,   0, 186, 255,  10,   0, 186, 255,   3, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   9,   0, 186, 255,  15,   0, 186, 255,  22,   0, 186, 255,  28,   0, 186, 255,  34,   0, 186, 255,  41,   0, 186, 255,  47,   0, 186, 255,  53,   0, 186, 255,  60,   0, 186, 255,  66,   0, 186, 255,  73,   0, 186, 255,  79,   0, 186, 255,  85,   0, 186, 255,  91,   0, 186, 255,  98,   0, 186, 255, 104,   0, 186, 255, 111,   0, 186, 255, 116,   0, 186, 255, 123,   0, 186, 255, 129,   0, 186, 255, 135,   0, 186, 255, 141,   0, 186, 255, 147,   0, 186, 255, 153,   0, 186, 255, 158,   0, 186, 255, 165,   0, 186, 255, 170,   0, 186, 255, 175,   0, 186, 255, 180,   0, 186, 255, 186,   0, 186, 255, 190,   0, 186, 255, 194,   0, 186, 255, 199,   0, 186, 255, 202,   0, 186, 255, 205,   0, 186, 255, 207,   0, 186, 255, 209,   0, 186, 255, 209,   0, 186, 255, 209,   0, 186, 255, 207,   0, 186, 255, 206,   0, 186, 255, 203,   0, 186, 255, 199,   0, 186, 255, 194,   0, 186, 255, 190,   0, 186, 255, 186,   0, 186, 255, 181,   0, 186, 255, 176,   0, 186, 255, 170,   0, 186, 255, 164,   0, 186, 255, 158,   0, 186, 255, 153,   0, 186, 255, 147,   0, 186, 255, 141,   0, 186, 255, 135,   0, 186, 255, 128,   0, 186, 255, 122,   0, 186, 255, 117,   0, 186, 255, 110,   0, 186, 255, 104,   0, 186, 255,  98,   0, 186, 255,  91,   0, 186, 255,  85,   0, 186, 255,  79,   0, 186, 255,  72,   0, 186, 255,  67,   0, 186, 255,  60,   0, 186, 255,  53,   0, 186, 255,  47,   0, 186, 255,  41,   0, 186, 255,  34,   0, 186, 255,  28,   0, 186, 255,  22,   0, 186, 255,  15,   0, 186, 255,   8,   0, 186, 255,   2, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   8,   0, 186, 255,  13,   0, 186, 255,  21,   0, 186, 255,  26,   0, 186, 255,  33,   0, 186, 255,  39,   0, 186, 255,  45,   0, 186, 255,  52,   0, 186, 255,  58,   0, 186, 255,  65,   0, 186, 255,  71,   0, 186, 255,  77,   0, 186, 255,  83,   0, 186, 255,  90,   0, 186, 255,  96,   0, 186, 255, 102,   0, 186, 255, 108,   0, 186, 255, 114,   0, 186, 255, 120,   0, 186, 255, 126,   0, 186, 255, 132,   0, 186, 255, 138,   0, 186, 255, 144,   0, 186, 255, 149,   0, 186, 255, 155,   0, 186, 255, 160,   0, 186, 255, 166,   0, 186, 255, 171,   0, 186, 255, 176,   0, 186, 255, 181,   0, 186, 255, 185,   0, 186, 255, 189,   0, 186, 255, 193,   0, 186, 255, 197,   0, 186, 255, 199,   0, 186, 255, 201,   0, 186, 255, 202,   0, 186, 255, 203,   0, 186, 255, 203,   0, 186, 255, 201,   0, 186, 255, 199,   0, 186, 255, 197,   0, 186, 255, 194,   0, 186, 255, 190,   0, 186, 255, 185,   0, 186, 255, 181,   0, 186, 255, 176,   0, 186, 255, 171,   0, 186, 255, 166,   0, 186, 255, 160,   0, 186, 255, 155,   0, 186, 255, 149,   0, 186, 255, 144,   0, 186, 255, 138,   0, 186, 255, 132,   0, 186, 255, 126,   0, 186, 255, 120,   0, 186, 255, 114,   0, 186, 255, 108,   0, 186, 255, 102,   0, 186, 255,  96,   0, 186, 255,  89,   0, 186, 255,  83,   0, 186, 255,  77,   0, 186, 255,  71,   0, 186, 255,  65,   0, 186, 255,  58,   0, 186, 255,  52,   0, 186, 255,  46,   0, 186, 255,  40,   0, 186, 255,  33,   0, 186, 255,  26,   0, 186, 255,  21,   0, 186, 255,  14,   0, 186, 255,   8,   0, 186, 255,   1, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   6,   0, 186, 255,  12,   0, 186, 255,  18,   0, 186, 255,  25,   0, 186, 255,  32,   0, 186, 255,  38,   0, 186, 255,  44,   0, 186, 255,  50,   0, 186, 255,  56,   0, 186, 255,  63,   0, 186, 255,  69,   0, 186, 255,  75,   0, 186, 255,  81,   0, 186, 255,  87,   0, 186, 255,  93,   0, 186, 255, 100,   0, 186, 255, 106,   0, 186, 255, 112,   0, 186, 255, 118,   0, 186, 255, 123,   0, 186, 255, 129,   0, 186, 255, 135,   0, 186, 255, 141,   0, 186, 255, 146,   0, 186, 255, 151,   0, 186, 255, 157,   0, 186, 255, 162,   0, 186, 255, 167,   0, 186, 255, 171,   0, 186, 255, 176,   0, 186, 255, 181,   0, 186, 255, 184,   0, 186, 255, 188,   0, 186, 255, 191,   0, 186, 255, 192,   0, 186, 255, 194,   0, 186, 255, 196,   0, 186, 255, 196,   0, 186, 255, 196,   0, 186, 255, 195,   0, 186, 255, 193,   0, 186, 255, 191,   0, 186, 255, 187,   0, 186, 255, 184,   0, 186, 255, 180,   0, 186, 255, 177,   0, 186, 255, 171,   0, 186, 255, 167,   0, 186, 255, 162,   0, 186, 255, 157,   0, 186, 255, 151,   0, 186, 255, 146,   0, 186, 255, 141,   0, 186, 255, 134,   0, 186, 255, 129,   0, 186, 255, 124,   0, 186, 255, 118,   0, 186, 255, 112,   0, 186, 255, 106,   0, 186, 255, 100,   0, 186, 255,  93,   0, 186, 255,  87,   0, 186, 255,  82,   0, 186, 255,  75,   0, 186, 255,  69,   0, 186, 255,  63,   0, 186, 255,  56,   0, 186, 255,  50,   0, 186, 255,  44,   0, 186, 255,  38,   0, 186, 255,  31,   0, 186, 255,  25,   0, 186, 255,  19,   0, 186, 255,  12,   0, 186, 255,   6, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   5,   0, 186, 255,  11,   0, 186, 255,  17,   0, 186, 255,  23,   0, 186, 255,  29,   0, 186, 255,  36,   0, 186, 255,  42,   0, 186, 255,  48,   0, 186, 255,  54,   0, 186, 255,  61,   0, 186, 255,  67,   0, 186, 255,  73,   0, 186, 255,  79,   0, 186, 255,  85,   0, 186, 255,  91,   0, 186, 255,  97,   0, 186, 255, 103,   0, 186, 255, 109,   0, 186, 255, 115,   0, 186, 255, 120,   0, 186, 255, 126,   0, 186, 255, 131,   0, 186, 255, 137,   0, 186, 255, 142,   0, 186, 255, 147,   0, 186, 255, 152,   0, 186, 255, 158,   0, 186, 255, 163,   0, 186, 255, 167,   0, 186, 255, 172,   0, 186, 255, 175,   0, 186, 255, 179,   0, 186, 255, 182,   0, 186, 255, 184,   0, 186, 255, 187,   0, 186, 255, 188,   0, 186, 255, 189,   0, 186, 255, 190,   0, 186, 255, 189,   0, 186, 255, 189,   0, 186, 255, 187,   0, 186, 255, 185,   0, 186, 255, 182,   0, 186, 255, 178,   0, 186, 255, 175,   0, 186, 255, 171,   0, 186, 255, 167,   0, 186, 255, 163,   0, 186, 255, 158,   0, 186, 255, 153,   0, 186, 255, 148,   0, 186, 255, 142,   0, 186, 255, 137,   0, 186, 255, 132,   0, 186, 255, 126,   0, 186, 255, 121,   0, 186, 255, 115,   0, 186, 255, 109,   0, 186, 255, 102,   0, 186, 255,  97,   0, 186, 255,  91,   0, 186, 255,  85,   0, 186, 255,  79,   0, 186, 255,  72,   0, 186, 255,  66,   0, 186, 255,  61,   0, 186, 255,  54,   0, 186, 255,  48,   0, 186, 255,  42,   0, 186, 255,  36,   0, 186, 255,  30,   0, 186, 255,  24,   0, 186, 255,  17,   0, 186, 255,  11,   0, 186, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   8,   0, 186, 255,  15,   0, 186, 255,  21,   0, 186, 255,  27,   0, 186, 255,  34,   0, 186, 255,  40,   0, 186, 255,  46,   0, 186, 255,  52,   0, 186, 255,  58,   0, 186, 255,  64,   0, 186, 255,  70,   0, 186, 255,  76,   0, 186, 255,  82,   0, 186, 255,  89,   0, 186, 255,  94,   0, 186, 255, 100,   0, 186, 255, 106,   0, 186, 255, 111,   0, 186, 255, 117,   0, 186, 255, 122,   0, 186, 255, 128,   0, 186, 255, 134,   0, 186, 255, 138,   0, 186, 255, 143,   0, 186, 255, 149,   0, 186, 255, 153,   0, 186, 255, 158,   0, 186, 255, 162,   0, 186, 255, 166,   0, 186, 255, 170,   0, 186, 255, 173,   0, 186, 255, 176,   0, 186, 255, 178,   0, 186, 255, 181,   0, 186, 255, 182,   0, 186, 255, 183,   0, 186, 255, 183,   0, 186, 255, 183,   0, 186, 255, 182,   0, 186, 255, 181,   0, 186, 255, 178,   0, 186, 255, 176,   0, 186, 255, 173,   0, 186, 255, 169,   0, 186, 255, 166,   0, 186, 255, 162,   0, 186, 255, 157,   0, 186, 255, 153,   0, 186, 255, 149,   0, 186, 255, 143,   0, 186, 255, 138,   0, 186, 255, 133,   0, 186, 255, 128,   0, 186, 255, 122,   0, 186, 255, 117,   0, 186, 255, 112,   0, 186, 255, 106,   0, 186, 255, 100,   0, 186, 255,  94,   0, 186, 255,  89,   0, 186, 255,  82,   0, 186, 255,  77,   0, 186, 255,  70,   0, 186, 255,  64,   0, 186, 255,  58,   0, 186, 255,  52,   0, 186, 255,  47,   0, 186, 255,  40,   0, 186, 255,  34,   0, 186, 255,  28,   0, 186, 255,  22,   0, 186, 255,  15,   0, 186, 255,   9,   0, 186, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   7,   0, 186, 255,  13,   0, 186, 255,  20,   0, 186, 255,  26,   0, 186, 255,  32,   0, 186, 255,  38,   0, 186, 255,  44,   0, 186, 255,  50,   0, 186, 255,  56,   0, 186, 255,  62,   0, 186, 255,  68,   0, 186, 255,  73,   0, 186, 255,  79,   0, 186, 255,  86,   0, 186, 255,  92,   0, 186, 255,  96,   0, 186, 255, 102,   0, 186, 255, 108,   0, 186, 255, 114,   0, 186, 255, 119,   0, 186, 255, 125,   0, 186, 255, 129,   0, 186, 255, 134,   0, 186, 255, 139,   0, 186, 255, 144,   0, 186, 255, 148,   0, 186, 255, 153,   0, 186, 255, 157,   0, 186, 255, 161,   0, 186, 255, 164,   0, 186, 255, 167,   0, 186, 255, 170,   0, 186, 255, 172,   0, 186, 255, 174,   0, 186, 255, 175,   0, 186, 255, 177,   0, 186, 255, 177,   0, 186, 255, 176,   0, 186, 255, 176,   0, 186, 255, 174,   0, 186, 255, 172,   0, 186, 255, 170,   0, 186, 255, 168,   0, 186, 255, 164,   0, 186, 255, 161,   0, 186, 255, 157,   0, 186, 255, 152,   0, 186, 255, 148,   0, 186, 255, 144,   0, 186, 255, 139,   0, 186, 255, 134,   0, 186, 255, 129,   0, 186, 255, 124,   0, 186, 255, 119,   0, 186, 255, 113,   0, 186, 255, 108,   0, 186, 255, 103,   0, 186, 255,  97,   0, 186, 255,  91,   0, 186, 255,  86,   0, 186, 255,  79,   0, 186, 255,  74,   0, 186, 255,  68,   0, 186, 255,  62,   0, 186, 255,  55,   0, 186, 255,  50,   0, 186, 255,  44,   0, 186, 255,  38,   0, 186, 255,  32,   0, 186, 255,  26,   0, 186, 255,  19,   0, 186, 255,  13,   0, 186, 255,   7,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   5,   0, 186, 255,  10,   0, 186, 255,  17,   0, 186, 255,  23,   0, 186, 255,  29,   0, 186, 255,  36,   0, 186, 255,  41,   0, 186, 255,  47,   0, 186, 255,  54,   0, 186, 255,  59,   0, 186, 255,  65,   0, 186, 255,  71,   0, 186, 255,  76,   0, 186, 255,  82,   0, 186, 255,  88,   0, 186, 255,  93,   0, 186, 255, 100,   0, 186, 255, 104,   0, 186, 255, 110,   0, 186, 255, 115,   0, 186, 255, 120,   0, 186, 255, 126,   0, 186, 255, 130,   0, 186, 255, 134,   0, 186, 255, 139,   0, 186, 255, 143,   0, 186, 255, 148,   0, 186, 255, 151,   0, 186, 255, 155,   0, 186, 255, 158,   0, 186, 255, 161,   0, 186, 255, 164,   0, 186, 255, 166,   0, 186, 255, 167,   0, 186, 255, 169,   0, 186, 255, 170,   0, 186, 255, 170,   0, 186, 255, 170,   0, 186, 255, 169,   0, 186, 255, 167,   0, 186, 255, 166,   0, 186, 255, 164,   0, 186, 255, 161,   0, 186, 255, 158,   0, 186, 255, 156,   0, 186, 255, 151,   0, 186, 255, 148,   0, 186, 255, 144,   0, 186, 255, 139,   0, 186, 255, 135,   0, 186, 255, 130,   0, 186, 255, 125,   0, 186, 255, 120,   0, 186, 255, 115,   0, 186, 255, 110,   0, 186, 255, 104,   0, 186, 255,  99,   0, 186, 255,  93,   0, 186, 255,  88,   0, 186, 255,  82,   0, 186, 255,  77,   0, 186, 255,  70,   0, 186, 255,  65,   0, 186, 255,  59,   0, 186, 255,  53,   0, 186, 255,  47,   0, 186, 255,  42,   0, 186, 255,  35,   0, 186, 255,  29,   0, 186, 255,  24,   0, 186, 255,  17,   0, 186, 255,  11,   0, 186, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   2,   0, 186, 255,   9,   0, 186, 255,  15,   0, 186, 255,  21,   0, 186, 255,  27,   0, 186, 255,  33,   0, 186, 255,  39,   0, 186, 255,  45,   0, 186, 255,  50,   0, 186, 255,  56,   0, 186, 255,  62,   0, 186, 255,  68,   0, 186, 255,  73,   0, 186, 255,  79,   0, 186, 255,  85,   0, 186, 255,  90,   0, 186, 255,  96,   0, 186, 255, 100,   0, 186, 255, 106,   0, 186, 255, 111,   0, 186, 255, 116,   0, 186, 255, 121,   0, 186, 255, 126,   0, 186, 255, 130,   0, 186, 255, 134,   0, 186, 255, 139,   0, 186, 255, 143,   0, 186, 255, 146,   0, 186, 255, 149,   0, 186, 255, 152,   0, 186, 255, 155,   0, 186, 255, 158,   0, 186, 255, 160,   0, 186, 255, 161,   0, 186, 255, 163,   0, 186, 255, 163,   0, 186, 255, 163,   0, 186, 255, 164,   0, 186, 255, 163,   0, 186, 255, 162,   0, 186, 255, 160,   0, 186, 255, 158,   0, 186, 255, 155,   0, 186, 255, 152,   0, 186, 255, 149,   0, 186, 255, 146,   0, 186, 255, 143,   0, 186, 255, 139,   0, 186, 255, 135,   0, 186, 255, 130,   0, 186, 255, 126,   0, 186, 255, 120,   0, 186, 255, 116,   0, 186, 255, 111,   0, 186, 255, 106,   0, 186, 255, 101,   0, 186, 255,  95,   0, 186, 255,  90,   0, 186, 255,  85,   0, 186, 255,  79,   0, 186, 255,  73,   0, 186, 255,  68,   0, 186, 255,  62,   0, 186, 255,  56,   0, 186, 255,  50,   0, 186, 255,  44,   0, 186, 255,  39,   0, 186, 255,  32,   0, 186, 255,  27,   0, 186, 255,  21,   0, 186, 255,  15,   0, 186, 255,   8,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   6,   0, 186, 255,  12,   0, 186, 255,  18,   0, 186, 255,  24,   0, 186, 255,  30,   0, 186, 255,  36,   0, 186, 255,  41,   0, 186, 255,  48,   0, 186, 255,  53,   0, 186, 255,  58,   0, 186, 255,  65,   0, 186, 255,  70,   0, 186, 255,  75,   0, 186, 255,  81,   0, 186, 255,  86,   0, 186, 255,  91,   0, 186, 255,  96,   0, 186, 255, 102,   0, 186, 255, 107,   0, 186, 255, 111,   0, 186, 255, 116,   0, 186, 255, 121,   0, 186, 255, 125,   0, 186, 255, 129,   0, 186, 255, 133,   0, 186, 255, 137,   0, 186, 255, 140,   0, 186, 255, 143,   0, 186, 255, 147,   0, 186, 255, 150,   0, 186, 255, 152,   0, 186, 255, 154,   0, 186, 255, 155,   0, 186, 255, 156,   0, 186, 255, 157,   0, 186, 255, 157,   0, 186, 255, 157,   0, 186, 255, 156,   0, 186, 255, 155,   0, 186, 255, 153,   0, 186, 255, 152,   0, 186, 255, 149,   0, 186, 255, 147,   0, 186, 255, 144,   0, 186, 255, 141,   0, 186, 255, 137,   0, 186, 255, 133,   0, 186, 255, 130,   0, 186, 255, 125,   0, 186, 255, 121,   0, 186, 255, 116,   0, 186, 255, 111,   0, 186, 255, 107,   0, 186, 255, 101,   0, 186, 255,  97,   0, 186, 255,  92,   0, 186, 255,  86,   0, 186, 255,  81,   0, 186, 255,  75,   0, 186, 255,  70,   0, 186, 255,  65,   0, 186, 255,  59,   0, 186, 255,  53,   0, 186, 255,  47,   0, 186, 255,  42,   0, 186, 255,  36,   0, 186, 255,  29,   0, 186, 255,  24,   0, 186, 255,  18,   0, 186, 255,  12,   0, 186, 255,   6, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   4,   0, 186, 255,   9,   0, 186, 255,  15,   0, 186, 255,  21,   0, 186, 255,  27,   0, 186, 255,  33,   0, 186, 255,  38,   0, 186, 255,  44,   0, 186, 255,  50,   0, 186, 255,  56,   0, 186, 255,  61,   0, 186, 255,  67,   0, 186, 255,  72,   0, 186, 255,  77,   0, 186, 255,  82,   0, 186, 255,  88,   0, 186, 255,  93,   0, 186, 255,  98,   0, 186, 255, 103,   0, 186, 255, 107,   0, 186, 255, 111,   0, 186, 255, 116,   0, 186, 255, 120,   0, 186, 255, 125,   0, 186, 255, 128,   0, 186, 255, 132,   0, 186, 255, 135,   0, 186, 255, 138,   0, 186, 255, 141,   0, 186, 255, 144,   0, 186, 255, 145,   0, 186, 255, 147,   0, 186, 255, 148,   0, 186, 255, 149,   0, 186, 255, 150,   0, 186, 255, 150,   0, 186, 255, 150,   0, 186, 255, 150,   0, 186, 255, 148,   0, 186, 255, 147,   0, 186, 255, 145,   0, 186, 255, 143,   0, 186, 255, 141,   0, 186, 255, 138,   0, 186, 255, 135,   0, 186, 255, 131,   0, 186, 255, 128,   0, 186, 255, 125,   0, 186, 255, 120,   0, 186, 255, 116,   0, 186, 255, 111,   0, 186, 255, 107,   0, 186, 255, 103,   0, 186, 255,  98,   0, 186, 255,  93,   0, 186, 255,  87,   0, 186, 255,  82,   0, 186, 255,  77,   0, 186, 255,  72,   0, 186, 255,  67,   0, 186, 255,  61,   0, 186, 255,  55,   0, 186, 255,  50,   0, 186, 255,  44,   0, 186, 255,  38,   0, 186, 255,  33,   0, 186, 255,  27,   0, 186, 255,  21,   0, 186, 255,  15,   0, 186, 255,   9,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   7,   0, 186, 255,  12,   0, 186, 255,  18,   0, 186, 255,  24,   0, 186, 255,  30,   0, 186, 255,  35,   0, 186, 255,  41,   0, 186, 255,  47,   0, 186, 255,  52,   0, 186, 255,  57,   0, 186, 255,  62,   0, 186, 255,  68,   0, 186, 255,  74,   0, 186, 255,  78,   0, 186, 255,  83,   0, 186, 255,  88,   0, 186, 255,  93,   0, 186, 255,  98,   0, 186, 255, 103,   0, 186, 255, 107,   0, 186, 255, 111,   0, 186, 255, 115,   0, 186, 255, 119,   0, 186, 255, 123,   0, 186, 255, 126,   0, 186, 255, 129,   0, 186, 255, 132,   0, 186, 255, 135,   0, 186, 255, 137,   0, 186, 255, 139,   0, 186, 255, 141,   0, 186, 255, 142,   0, 186, 255, 143,   0, 186, 255, 143,   0, 186, 255, 144,   0, 186, 255, 144,   0, 186, 255, 143,   0, 186, 255, 142,   0, 186, 255, 140,   0, 186, 255, 139,   0, 186, 255, 137,   0, 186, 255, 134,   0, 186, 255, 132,   0, 186, 255, 129,   0, 186, 255, 126,   0, 186, 255, 123,   0, 186, 255, 119,   0, 186, 255, 115,   0, 186, 255, 111,   0, 186, 255, 106,   0, 186, 255, 102,   0, 186, 255,  97,   0, 186, 255,  93,   0, 186, 255,  89,   0, 186, 255,  84,   0, 186, 255,  79,   0, 186, 255,  74,   0, 186, 255,  68,   0, 186, 255,  63,   0, 186, 255,  58,   0, 186, 255,  52,   0, 186, 255,  47,   0, 186, 255,  41,   0, 186, 255,  36,   0, 186, 255,  29,   0, 186, 255,  23,   0, 186, 255,  18,   0, 186, 255,  12,   0, 186, 255,   6, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   9,   0, 186, 255,  14,   0, 186, 255,  21,   0, 186, 255,  26,   0, 186, 255,  31,   0, 186, 255,  37,   0, 186, 255,  43,   0, 186, 255,  48,   0, 186, 255,  54,   0, 186, 255,  59,   0, 186, 255,  64,   0, 186, 255,  69,   0, 186, 255,  74,   0, 186, 255,  79,   0, 186, 255,  84,   0, 186, 255,  88,   0, 186, 255,  94,   0, 186, 255,  98,   0, 186, 255, 102,   0, 186, 255, 106,   0, 186, 255, 110,   0, 186, 255, 114,   0, 186, 255, 117,   0, 186, 255, 120,   0, 186, 255, 123,   0, 186, 255, 126,   0, 186, 255, 129,   0, 186, 255, 131,   0, 186, 255, 133,   0, 186, 255, 134,   0, 186, 255, 136,   0, 186, 255, 136,   0, 186, 255, 137,   0, 186, 255, 137,   0, 186, 255, 137,   0, 186, 255, 137,   0, 186, 255, 136,   0, 186, 255, 134,   0, 186, 255, 132,   0, 186, 255, 131,   0, 186, 255, 128,   0, 186, 255, 126,   0, 186, 255, 123,   0, 186, 255, 121,   0, 186, 255, 117,   0, 186, 255, 114,   0, 186, 255, 110,   0, 186, 255, 106,   0, 186, 255, 101,   0, 186, 255,  98,   0, 186, 255,  93,   0, 186, 255,  89,   0, 186, 255,  83,   0, 186, 255,  79,   0, 186, 255,  74,   0, 186, 255,  69,   0, 186, 255,  65,   0, 186, 255,  59,   0, 186, 255,  54,   0, 186, 255,  48,   0, 186, 255,  43,   0, 186, 255,  37,   0, 186, 255,  32,   0, 186, 255,  27,   0, 186, 255,  20,   0, 186, 255,  15,   0, 186, 255,  10,   0, 186, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   6,   0, 186, 255,  11,   0, 186, 255,  17,   0, 186, 255,  23,   0, 186, 255,  29,   0, 186, 255,  34,   0, 186, 255,  39,   0, 186, 255,  44,   0, 186, 255,  50,   0, 186, 255,  55,   0, 186, 255,  60,   0, 186, 255,  65,   0, 186, 255,  70,   0, 186, 255,  74,   0, 186, 255,  79,   0, 186, 255,  84,   0, 186, 255,  88,   0, 186, 255,  92,   0, 186, 255,  97,   0, 186, 255, 100,   0, 186, 255, 105,   0, 186, 255, 108,   0, 186, 255, 112,   0, 186, 255, 114,   0, 186, 255, 118,   0, 186, 255, 120,   0, 186, 255, 122,   0, 186, 255, 124,   0, 186, 255, 127,   0, 186, 255, 128,   0, 186, 255, 129,   0, 186, 255, 130,   0, 186, 255, 130,   0, 186, 255, 130,   0, 186, 255, 131,   0, 186, 255, 130,   0, 186, 255, 129,   0, 186, 255, 128,   0, 186, 255, 127,   0, 186, 255, 125,   0, 186, 255, 123,   0, 186, 255, 120,   0, 186, 255, 118,   0, 186, 255, 115,   0, 186, 255, 111,   0, 186, 255, 108,   0, 186, 255, 105,   0, 186, 255, 101,   0, 186, 255,  97,   0, 186, 255,  93,   0, 186, 255,  88,   0, 186, 255,  84,   0, 186, 255,  79,   0, 186, 255,  75,   0, 186, 255,  70,   0, 186, 255,  65,   0, 186, 255,  60,   0, 186, 255,  55,   0, 186, 255,  50,   0, 186, 255,  45,   0, 186, 255,  39,   0, 186, 255,  33,   0, 186, 255,  29,   0, 186, 255,  23,   0, 186, 255,  17,   0, 186, 255,  11,   0, 186, 255,   6,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   8,   0, 186, 255,  14,   0, 186, 255,  19,   0, 186, 255,  25,   0, 186, 255,  30,   0, 186, 255,  35,   0, 186, 255,  40,   0, 186, 255,  46,   0, 186, 255,  51,   0, 186, 255,  55,   0, 186, 255,  60,   0, 186, 255,  65,   0, 186, 255,  70,   0, 186, 255,  75,   0, 186, 255,  79,   0, 186, 255,  84,   0, 186, 255,  87,   0, 186, 255,  91,   0, 186, 255,  95,   0, 186, 255,  99,   0, 186, 255, 102,   0, 186, 255, 105,   0, 186, 255, 109,   0, 186, 255, 111,   0, 186, 255, 114,   0, 186, 255, 116,   0, 186, 255, 118,   0, 186, 255, 120,   0, 186, 255, 121,   0, 186, 255, 123,   0, 186, 255, 124,   0, 186, 255, 124,   0, 186, 255, 124,   0, 186, 255, 124,   0, 186, 255, 124,   0, 186, 255, 123,   0, 186, 255, 122,   0, 186, 255, 120,   0, 186, 255, 119,   0, 186, 255, 116,   0, 186, 255, 114,   0, 186, 255, 111,   0, 186, 255, 109,   0, 186, 255, 106,   0, 186, 255, 103,   0, 186, 255,  99,   0, 186, 255,  96,   0, 186, 255,  92,   0, 186, 255,  87,   0, 186, 255,  83,   0, 186, 255,  79,   0, 186, 255,  75,   0, 186, 255,  70,   0, 186, 255,  65,   0, 186, 255,  61,   0, 186, 255,  56,   0, 186, 255,  51,   0, 186, 255,  46,   0, 186, 255,  41,   0, 186, 255,  35,   0, 186, 255,  30,   0, 186, 255,  24,   0, 186, 255,  20,   0, 186, 255,  14,   0, 186, 255,   8,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   4,   0, 186, 255,  10,   0, 186, 255,  16,   0, 186, 255,  21,   0, 186, 255,  26,   0, 186, 255,  31,   0, 186, 255,  36,   0, 186, 255,  42,   0, 186, 255,  47,   0, 186, 255,  51,   0, 186, 255,  56,   0, 186, 255,  61,   0, 186, 255,  66,   0, 186, 255,  69,   0, 186, 255,  74,   0, 186, 255,  78,   0, 186, 255,  83,   0, 186, 255,  87,   0, 186, 255,  90,   0, 186, 255,  93,   0, 186, 255,  97,   0, 186, 255, 100,   0, 186, 255, 103,   0, 186, 255, 106,   0, 186, 255, 108,   0, 186, 255, 111,   0, 186, 255, 112,   0, 186, 255, 114,   0, 186, 255, 115,   0, 186, 255, 117,   0, 186, 255, 117,   0, 186, 255, 118,   0, 186, 255, 118,   0, 186, 255, 118,   0, 186, 255, 117,   0, 186, 255, 116,   0, 186, 255, 115,   0, 186, 255, 114,   0, 186, 255, 112,   0, 186, 255, 110,   0, 186, 255, 108,   0, 186, 255, 105,   0, 186, 255, 103,   0, 186, 255, 100,   0, 186, 255,  97,   0, 186, 255,  93,   0, 186, 255,  89,   0, 186, 255,  86,   0, 186, 255,  83,   0, 186, 255,  79,   0, 186, 255,  74,   0, 186, 255,  70,   0, 186, 255,  66,   0, 186, 255,  61,   0, 186, 255,  56,   0, 186, 255,  51,   0, 186, 255,  46,   0, 186, 255,  41,   0, 186, 255,  37,   0, 186, 255,  31,   0, 186, 255,  26,   0, 186, 255,  21,   0, 186, 255,  15,   0, 186, 255,  10,   0, 186, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   7,   0, 186, 255,  12,   0, 186, 255,  17,   0, 186, 255,  23,   0, 186, 255,  27,   0, 186, 255,  32,   0, 186, 255,  37,   0, 186, 255,  42,   0, 186, 255,  47,   0, 186, 255,  51,   0, 186, 255,  56,   0, 186, 255,  61,   0, 186, 255,  65,   0, 186, 255,  70,   0, 186, 255,  73,   0, 186, 255,  77,   0, 186, 255,  81,   0, 186, 255,  85,   0, 186, 255,  87,   0, 186, 255,  92,   0, 186, 255,  94,   0, 186, 255,  97,   0, 186, 255, 100,   0, 186, 255, 102,   0, 186, 255, 104,   0, 186, 255, 106,   0, 186, 255, 107,   0, 186, 255, 108,   0, 186, 255, 110,   0, 186, 255, 111,   0, 186, 255, 111,   0, 186, 255, 111,   0, 186, 255, 111,   0, 186, 255, 110,   0, 186, 255, 110,   0, 186, 255, 109,   0, 186, 255, 107,   0, 186, 255, 106,   0, 186, 255, 104,   0, 186, 255, 102,   0, 186, 255, 100,   0, 186, 255,  97,   0, 186, 255,  94,   0, 186, 255,  91,   0, 186, 255,  87,   0, 186, 255,  84,   0, 186, 255,  81,   0, 186, 255,  77,   0, 186, 255,  73,   0, 186, 255,  69,   0, 186, 255,  65,   0, 186, 255,  60,   0, 186, 255,  56,   0, 186, 255,  52,   0, 186, 255,  47,   0, 186, 255,  42,   0, 186, 255,  37,   0, 186, 255,  32,   0, 186, 255,  27,   0, 186, 255,  23,   0, 186, 255,  17,   0, 186, 255,  12,   0, 186, 255,   6,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   7,   0, 186, 255,  13,   0, 186, 255,  18,   0, 186, 255,  23,   0, 186, 255,  28,   0, 186, 255,  33,   0, 186, 255,  37,   0, 186, 255,  42,   0, 186, 255,  47,   0, 186, 255,  51,   0, 186, 255,  56,   0, 186, 255,  60,   0, 186, 255,  64,   0, 186, 255,  68,   0, 186, 255,  72,   0, 186, 255,  76,   0, 186, 255,  79,   0, 186, 255,  82,   0, 186, 255,  85,   0, 186, 255,  88,   0, 186, 255,  91,   0, 186, 255,  94,   0, 186, 255,  96,   0, 186, 255,  98,   0, 186, 255, 100,   0, 186, 255, 102,   0, 186, 255, 102,   0, 186, 255, 103,   0, 186, 255, 104,   0, 186, 255, 104,   0, 186, 255, 105,   0, 186, 255, 104,   0, 186, 255, 104,   0, 186, 255, 103,   0, 186, 255, 102,   0, 186, 255, 101,   0, 186, 255, 100,   0, 186, 255,  98,   0, 186, 255,  95,   0, 186, 255,  94,   0, 186, 255,  91,   0, 186, 255,  88,   0, 186, 255,  85,   0, 186, 255,  82,   0, 186, 255,  79,   0, 186, 255,  75,   0, 186, 255,  72,   0, 186, 255,  68,   0, 186, 255,  64,   0, 186, 255,  60,   0, 186, 255,  56,   0, 186, 255,  52,   0, 186, 255,  47,   0, 186, 255,  42,   0, 186, 255,  38,   0, 186, 255,  33,   0, 186, 255,  28,   0, 186, 255,  23,   0, 186, 255,  18,   0, 186, 255,  13,   0, 186, 255,   8,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   4,   0, 186, 255,   9,   0, 186, 255,  13,   0, 186, 255,  18,   0, 186, 255,  24,   0, 186, 255,  28,   0, 186, 255,  33,   0, 186, 255,  38,   0, 186, 255,  42,   0, 186, 255,  47,   0, 186, 255,  51,   0, 186, 255,  55,   0, 186, 255,  59,   0, 186, 255,  63,   0, 186, 255,  66,   0, 186, 255,  70,   0, 186, 255,  74,   0, 186, 255,  76,   0, 186, 255,  79,   0, 186, 255,  82,   0, 186, 255,  85,   0, 186, 255,  87,   0, 186, 255,  90,   0, 186, 255,  91,   0, 186, 255,  93,   0, 186, 255,  94,   0, 186, 255,  96,   0, 186, 255,  97,   0, 186, 255,  98,   0, 186, 255,  98,   0, 186, 255,  98,   0, 186, 255,  98,   0, 186, 255,  98,   0, 186, 255,  97,   0, 186, 255,  96,   0, 186, 255,  95,   0, 186, 255,  93,   0, 186, 255,  92,   0, 186, 255,  90,   0, 186, 255,  87,   0, 186, 255,  85,   0, 186, 255,  83,   0, 186, 255,  80,   0, 186, 255,  76,   0, 186, 255,  73,   0, 186, 255,  70,   0, 186, 255,  67,   0, 186, 255,  62,   0, 186, 255,  59,   0, 186, 255,  55,   0, 186, 255,  50,   0, 186, 255,  46,   0, 186, 255,  43,   0, 186, 255,  38,   0, 186, 255,  33,   0, 186, 255,  28,   0, 186, 255,  24,   0, 186, 255,  19,   0, 186, 255,  14,   0, 186, 255,   9,   0, 186, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   5,   0, 186, 255,   9,   0, 186, 255,  14,   0, 186, 255,  19,   0, 186, 255,  24,   0, 186, 255,  28,   0, 186, 255,  33,   0, 186, 255,  38,   0, 186, 255,  42,   0, 186, 255,  46,   0, 186, 255,  49,   0, 186, 255,  53,   0, 186, 255,  58,   0, 186, 255,  61,   0, 186, 255,  64,   0, 186, 255,  68,   0, 186, 255,  71,   0, 186, 255,  74,   0, 186, 255,  77,   0, 186, 255,  79,   0, 186, 255,  82,   0, 186, 255,  83,   0, 186, 255,  85,   0, 186, 255,  87,   0, 186, 255,  88,   0, 186, 255,  89,   0, 186, 255,  90,   0, 186, 255,  91,   0, 186, 255,  91,   0, 186, 255,  92,   0, 186, 255,  91,   0, 186, 255,  91,   0, 186, 255,  91,   0, 186, 255,  89,   0, 186, 255,  88,   0, 186, 255,  87,   0, 186, 255,  85,   0, 186, 255,  83,   0, 186, 255,  81,   0, 186, 255,  79,   0, 186, 255,  76,   0, 186, 255,  74,   0, 186, 255,  71,   0, 186, 255,  68,   0, 186, 255,  65,   0, 186, 255,  61,   0, 186, 255,  58,   0, 186, 255,  54,   0, 186, 255,  50,   0, 186, 255,  45,   0, 186, 255,  41,   0, 186, 255,  37,   0, 186, 255,  33,   0, 186, 255,  28,   0, 186, 255,  24,   0, 186, 255,  19,   0, 186, 255,  15,   0, 186, 255,  10,   0, 186, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   5,   0, 186, 255,  10,   0, 186, 255,  15,   0, 186, 255,  19,   0, 186, 255,  24,   0, 186, 255,  28,   0, 186, 255,  33,   0, 186, 255,  37,   0, 186, 255,  41,   0, 186, 255,  45,   0, 186, 255,  48,   0, 186, 255,  52,   0, 186, 255,  56,   0, 186, 255,  59,   0, 186, 255,  62,   0, 186, 255,  65,   0, 186, 255,  67,   0, 186, 255,  70,   0, 186, 255,  73,   0, 186, 255,  75,   0, 186, 255,  77,   0, 186, 255,  79,   0, 186, 255,  81,   0, 186, 255,  82,   0, 186, 255,  83,   0, 186, 255,  84,   0, 186, 255,  85,   0, 186, 255,  85,   0, 186, 255,  85,   0, 186, 255,  85,   0, 186, 255,  85,   0, 186, 255,  84,   0, 186, 255,  83,   0, 186, 255,  82,   0, 186, 255,  80,   0, 186, 255,  79,   0, 186, 255,  77,   0, 186, 255,  75,   0, 186, 255,  73,   0, 186, 255,  71,   0, 186, 255,  68,   0, 186, 255,  65,   0, 186, 255,  61,   0, 186, 255,  58,   0, 186, 255,  55,   0, 186, 255,  52,   0, 186, 255,  48,   0, 186, 255,  45,   0, 186, 255,  41,   0, 186, 255,  37,   0, 186, 255,  32,   0, 186, 255,  28,   0, 186, 255,  24,   0, 186, 255,  20,   0, 186, 255,  15,   0, 186, 255,  10,   0, 186, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   5,   0, 186, 255,  10,   0, 186, 255,  14,   0, 186, 255,  19,   0, 186, 255,  23,   0, 186, 255,  28,   0, 186, 255,  32,   0, 186, 255,  36,   0, 186, 255,  39,   0, 186, 255,  43,   0, 186, 255,  47,   0, 186, 255,  50,   0, 186, 255,  53,   0, 186, 255,  56,   0, 186, 255,  59,   0, 186, 255,  61,   0, 186, 255,  64,   0, 186, 255,  66,   0, 186, 255,  69,   0, 186, 255,  71,   0, 186, 255,  72,   0, 186, 255,  74,   0, 186, 255,  75,   0, 186, 255,  76,   0, 186, 255,  78,   0, 186, 255,  78,   0, 186, 255,  79,   0, 186, 255,  78,   0, 186, 255,  78,   0, 186, 255,  78,   0, 186, 255,  77,   0, 186, 255,  77,   0, 186, 255,  76,   0, 186, 255,  74,   0, 186, 255,  72,   0, 186, 255,  71,   0, 186, 255,  69,   0, 186, 255,  66,   0, 186, 255,  64,   0, 186, 255,  62,   0, 186, 255,  59,   0, 186, 255,  56,   0, 186, 255,  53,   0, 186, 255,  49,   0, 186, 255,  47,   0, 186, 255,  43,   0, 186, 255,  40,   0, 186, 255,  35,   0, 186, 255,  31,   0, 186, 255,  27,   0, 186, 255,  23,   0, 186, 255,  19,   0, 186, 255,  14,   0, 186, 255,  10,   0, 186, 255,   5,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   5,   0, 186, 255,  10,   0, 186, 255,  14,   0, 186, 255,  18,   0, 186, 255,  22,   0, 186, 255,  27,   0, 186, 255,  30,   0, 186, 255,  34,   0, 186, 255,  38,   0, 186, 255,  41,   0, 186, 255,  44,   0, 186, 255,  48,   0, 186, 255,  50,   0, 186, 255,  53,   0, 186, 255,  56,   0, 186, 255,  58,   0, 186, 255,  60,   0, 186, 255,  62,   0, 186, 255,  64,   0, 186, 255,  67,   0, 186, 255,  67,   0, 186, 255,  69,   0, 186, 255,  70,   0, 186, 255,  71,   0, 186, 255,  71,   0, 186, 255,  72,   0, 186, 255,  72,   0, 186, 255,  72,   0, 186, 255,  72,   0, 186, 255,  71,   0, 186, 255,  70,   0, 186, 255,  70,   0, 186, 255,  68,   0, 186, 255,  66,   0, 186, 255,  65,   0, 186, 255,  63,   0, 186, 255,  60,   0, 186, 255,  59,   0, 186, 255,  56,   0, 186, 255,  53,   0, 186, 255,  50,   0, 186, 255,  47,   0, 186, 255,  45,   0, 186, 255,  41,   0, 186, 255,  37,   0, 186, 255,  33,   0, 186, 255,  30,   0, 186, 255,  26,   0, 186, 255,  23,   0, 186, 255,  18,   0, 186, 255,  14,   0, 186, 255,  10,   0, 186, 255,   5,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   4,   0, 186, 255,   9,   0, 186, 255,  13,   0, 186, 255,  17,   0, 186, 255,  20,   0, 186, 255,  25,   0, 186, 255,  28,   0, 186, 255,  32,   0, 186, 255,  35,   0, 186, 255,  38,   0, 186, 255,  41,   0, 186, 255,  45,   0, 186, 255,  48,   0, 186, 255,  50,   0, 186, 255,  52,   0, 186, 255,  54,   0, 186, 255,  57,   0, 186, 255,  59,   0, 186, 255,  60,   0, 186, 255,  62,   0, 186, 255,  63,   0, 186, 255,  64,   0, 186, 255,  64,   0, 186, 255,  65,   0, 186, 255,  65,   0, 186, 255,  65,   0, 186, 255,  66,   0, 186, 255,  65,   0, 186, 255,  64,   0, 186, 255,  64,   0, 186, 255,  62,   0, 186, 255,  62,   0, 186, 255,  60,   0, 186, 255,  58,   0, 186, 255,  57,   0, 186, 255,  55,   0, 186, 255,  52,   0, 186, 255,  49,   0, 186, 255,  47,   0, 186, 255,  45,   0, 186, 255,  42,   0, 186, 255,  39,   0, 186, 255,  36,   0, 186, 255,  32,   0, 186, 255,  28,   0, 186, 255,  25,   0, 186, 255,  21,   0, 186, 255,  17,   0, 186, 255,  13,   0, 186, 255,   9,   0, 186, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   4,   0, 186, 255,   8,   0, 186, 255,  12,   0, 186, 255,  16,   0, 186, 255,  20,   0, 186, 255,  23,   0, 186, 255,  27,   0, 186, 255,  30,   0, 186, 255,  33,   0, 186, 255,  36,   0, 186, 255,  39,   0, 186, 255,  41,   0, 186, 255,  44,   0, 186, 255,  46,   0, 186, 255,  48,   0, 186, 255,  50,   0, 186, 255,  52,   0, 186, 255,  53,   0, 186, 255,  55,   0, 186, 255,  56,   0, 186, 255,  58,   0, 186, 255,  57,   0, 186, 255,  58,   0, 186, 255,  59,   0, 186, 255,  59,   0, 186, 255,  59,   0, 186, 255,  59,   0, 186, 255,  58,   0, 186, 255,  58,   0, 186, 255,  56,   0, 186, 255,  55,   0, 186, 255,  54,   0, 186, 255,  52,   0, 186, 255,  50,   0, 186, 255,  48,   0, 186, 255,  46,   0, 186, 255,  44,   0, 186, 255,  41,   0, 186, 255,  39,   0, 186, 255,  35,   0, 186, 255,  32,   0, 186, 255,  30,   0, 186, 255,  26,   0, 186, 255,  23,   0, 186, 255,  19,   0, 186, 255,  15,   0, 186, 255,  11,   0, 186, 255,   8,   0, 186, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   6,   0, 186, 255,  11,   0, 186, 255,  14,   0, 186, 255,  17,   0, 186, 255,  21,   0, 186, 255,  24,   0, 186, 255,  27,   0, 186, 255,  29,   0, 186, 255,  32,   0, 186, 255,  36,   0, 186, 255,  38,   0, 186, 255,  40,   0, 186, 255,  42,   0, 186, 255,  44,   0, 186, 255,  46,   0, 186, 255,  48,   0, 186, 255,  49,   0, 186, 255,  50,   0, 186, 255,  51,   0, 186, 255,  51,   0, 186, 255,  52,   0, 186, 255,  52,   0, 186, 255,  52,   0, 186, 255,  52,   0, 186, 255,  52,   0, 186, 255,  51,   0, 186, 255,  50,   0, 186, 255,  49,   0, 186, 255,  48,   0, 186, 255,  48,   0, 186, 255,  46,   0, 186, 255,  44,   0, 186, 255,  42,   0, 186, 255,  40,   0, 186, 255,  38,   0, 186, 255,  35,   0, 186, 255,  33,   0, 186, 255,  30,   0, 186, 255,  27,   0, 186, 255,  24,   0, 186, 255,  20,   0, 186, 255,  17,   0, 186, 255,  13,   0, 186, 255,  10,   0, 186, 255,   7,   0, 186, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   5,   0, 186, 255,   8,   0, 186, 255,  11,   0, 186, 255,  15,   0, 186, 255,  18,   0, 186, 255,  21,   0, 186, 255,  24,   0, 186, 255,  26,   0, 186, 255,  29,   0, 186, 255,  31,   0, 186, 255,  33,   0, 186, 255,  36,   0, 186, 255,  38,   0, 186, 255,  39,   0, 186, 255,  41,   0, 186, 255,  42,   0, 186, 255,  43,   0, 186, 255,  44,   0, 186, 255,  45,   0, 186, 255,  45,   0, 186, 255,  45,   0, 186, 255,  46,   0, 186, 255,  45,   0, 186, 255,  45,   0, 186, 255,  45,   0, 186, 255,  44,   0, 186, 255,  43,   0, 186, 255,  42,   0, 186, 255,  41,   0, 186, 255,  39,   0, 186, 255,  37,   0, 186, 255,  36,   0, 186, 255,  34,   0, 186, 255,  32,   0, 186, 255,  30,   0, 186, 255,  26,   0, 186, 255,  24,   0, 186, 255,  21,   0, 186, 255,  18,   0, 186, 255,  15,   0, 186, 255,  12,   0, 186, 255,   8,   0, 186, 255,   4,   0, 186, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   6,   0, 186, 255,  10,   0, 186, 255,  12,   0, 186, 255,  15,   0, 186, 255,  18,   0, 186, 255,  20,   0, 186, 255,  23,   0, 186, 255,  25,   0, 186, 255,  28,   0, 186, 255,  29,   0, 186, 255,  32,   0, 186, 255,  33,   0, 186, 255,  34,   0, 186, 255,  36,   0, 186, 255,  37,   0, 186, 255,  37,   0, 186, 255,  38,   0, 186, 255,  39,   0, 186, 255,  39,   0, 186, 255,  39,   0, 186, 255,  39,   0, 186, 255,  39,   0, 186, 255,  39,   0, 186, 255,  38,   0, 186, 255,  37,   0, 186, 255,  36,   0, 186, 255,  35,   0, 186, 255,  33,   0, 186, 255,  32,   0, 186, 255,  29,   0, 186, 255,  27,   0, 186, 255,  26,   0, 186, 255,  23,   0, 186, 255,  20,   0, 186, 255,  18,   0, 186, 255,  15,   0, 186, 255,  12,   0, 186, 255,   9,   0, 186, 255,   6,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   6,   0, 186, 255,   9,   0, 186, 255,  12,   0, 186, 255,  15,   0, 186, 255,  17,   0, 186, 255,  19,   0, 186, 255,  21,   0, 186, 255,  23,   0, 186, 255,  25,   0, 186, 255,  27,   0, 186, 255,  28,   0, 186, 255,  29,   0, 186, 255,  30,   0, 186, 255,  31,   0, 186, 255,  32,   0, 186, 255,  32,   0, 186, 255,  32,   0, 186, 255,  32,   0, 186, 255,  33,   0, 186, 255,  32,   0, 186, 255,  32,   0, 186, 255,  31,   0, 186, 255,  31,   0, 186, 255,  29,   0, 186, 255,  28,   0, 186, 255,  27,   0, 186, 255,  25,   0, 186, 255,  23,   0, 186, 255,  21,   0, 186, 255,  20,   0, 186, 255,  17,   0, 186, 255,  14,   0, 186, 255,  12,   0, 186, 255,  10,   0, 186, 255,   7,   0, 186, 255,   3,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   6,   0, 186, 255,   9,   0, 186, 255,  11,   0, 186, 255,  13,   0, 186, 255,  15,   0, 186, 255,  17,   0, 186, 255,  18,   0, 186, 255,  20,   0, 186, 255,  21,   0, 186, 255,  23,   0, 186, 255,  24,   0, 186, 255,  24,   0, 186, 255,  25,   0, 186, 255,  25,   0, 186, 255,  26,   0, 186, 255,  26,   0, 186, 255,  27,   0, 186, 255,  26,   0, 186, 255,  26,   0, 186, 255,  25,   0, 186, 255,  24,   0, 186, 255,  23,   0, 186, 255,  21,   0, 186, 255,  21,   0, 186, 255,  18,   0, 186, 255,  17,   0, 186, 255,  15,   0, 186, 255,  13,   0, 186, 255,  11,   0, 186, 255,   9,   0, 186, 255,   6,   0, 186, 255,   3,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   3,   0, 186, 255,   5,   0, 186, 255,   6,   0, 186, 255,   9,   0, 186, 255,  11,   0, 186, 255,  13,   0, 186, 255,  14,   0, 186, 255,  16,   0, 186, 255,  16,   0, 186, 255,  17,   0, 186, 255,  18,   0, 186, 255,  18,   0, 186, 255,  19,   0, 186, 255,  19,   0, 186, 255,  20,   0, 186, 255,  20,   0, 186, 255,  19,   0, 186, 255,  19,   0, 186, 255,  18,   0, 186, 255,  17,   0, 186, 255,  17,   0, 186, 255,  15,   0, 186, 255,  14,   0, 186, 255,  12,   0, 186, 255,  10,   0, 186, 255,   9,   0, 186, 255,   7,   0, 186, 255,   5,   0, 186, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   3,   0, 186, 255,   4,   0, 186, 255,   6,   0, 186, 255,   7,   0, 186, 255,   9,   0, 186, 255,  10,   0, 186, 255,  11,   0, 186, 255,  12,   0, 186, 255,  12,   0, 186, 255,  13,   0, 186, 255,  13,   0, 186, 255,  13,   0, 186, 255,  13,   0, 186, 255,  13,   0, 186, 255,  12,   0, 186, 255,  11,   0, 186, 255,  11,   0, 186, 255,  10,   0, 186, 255,   8,   0, 186, 255,   7,   0, 186, 255,   6,   0, 186, 255,   5,   0, 186, 255,   2,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,   0, 186, 255,   1,   0, 186, 255,   2,   0, 186, 255,   3,   0, 186, 255,   5,   0, 186, 255,   5,   0, 186, 255,   6,   0, 186, 255,   6,   0, 186, 255,   7,   0, 186, 255,   6,   0, 186, 255,   7,   0, 186, 255,   6,   0, 186, 255,   6,   0, 186, 255,   6,   0, 186, 255,   5,   0, 186, 255,   3,   0, 186, 255,   3,   0, 186, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	};

	static const int PURPLE_ICON_GLOW_SIZE_W = 80;
	static const int PURPLE_ICON_GLOW_SIZE_H = 80;
	static const unsigned char PURPLE_ICON_GLOW_DATA[25600] =
	{
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   2, 186,   0, 255,   3, 186,   0, 255,   4, 186,   0, 255,   5, 186,   0, 255,   6, 186,   0, 255,   6, 186,   0, 255,   6, 186,   0, 255,   7, 186,   0, 255,   7, 186,   0, 255,   6, 186,   0, 255,   6, 186,   0, 255,   5, 186,   0, 255,   5, 186,   0, 255,   3, 186,   0, 255,   2, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   3, 186,   0, 255,   5, 186,   0, 255,   6, 186,   0, 255,   7, 186,   0, 255,   9, 186,   0, 255,  10, 186,   0, 255,  11, 186,   0, 255,  12, 186,   0, 255,  13, 186,   0, 255,  13, 186,   0, 255,  13, 186,   0, 255,  13, 186,   0, 255,  13, 186,   0, 255,  13, 186,   0, 255,  12, 186,   0, 255,  12, 186,   0, 255,  10, 186,   0, 255,  10, 186,   0, 255,   9, 186,   0, 255,   7, 186,   0, 255,   6, 186,   0, 255,   5, 186,   0, 255,   2, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   4, 186,   0, 255,   7, 186,   0, 255,   9, 186,   0, 255,  10, 186,   0, 255,  12, 186,   0, 255,  14, 186,   0, 255,  16, 186,   0, 255,  16, 186,   0, 255,  17, 186,   0, 255,  18, 186,   0, 255,  19, 186,   0, 255,  19, 186,   0, 255,  20, 186,   0, 255,  20, 186,   0, 255,  20, 186,   0, 255,  19, 186,   0, 255,  19, 186,   0, 255,  18, 186,   0, 255,  18, 186,   0, 255,  17, 186,   0, 255,  16, 186,   0, 255,  13, 186,   0, 255,  12, 186,   0, 255,  11, 186,   0, 255,   9, 186,   0, 255,   6, 186,   0, 255,   4, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   6, 186,   0, 255,   8, 186,   0, 255,  10, 186,   0, 255,  13, 186,   0, 255,  15, 186,   0, 255,  17, 186,   0, 255,  18, 186,   0, 255,  21, 186,   0, 255,  21, 186,   0, 255,  23, 186,   0, 255,  24, 186,   0, 255,  25, 186,   0, 255,  26, 186,   0, 255,  26, 186,   0, 255,  26, 186,   0, 255,  26, 186,   0, 255,  26, 186,   0, 255,  26, 186,   0, 255,  25, 186,   0, 255,  25, 186,   0, 255,  23, 186,   0, 255,  23, 186,   0, 255,  22, 186,   0, 255,  20, 186,   0, 255,  19, 186,   0, 255,  17, 186,   0, 255,  15, 186,   0, 255,  13, 186,   0, 255,  11, 186,   0, 255,   8, 186,   0, 255,   6, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   3, 186,   0, 255,   7, 186,   0, 255,   9, 186,   0, 255,  12, 186,   0, 255,  15, 186,   0, 255,  17, 186,   0, 255,  19, 186,   0, 255,  22, 186,   0, 255,  23, 186,   0, 255,  25, 186,   0, 255,  27, 186,   0, 255,  28, 186,   0, 255,  29, 186,   0, 255,  31, 186,   0, 255,  32, 186,   0, 255,  32, 186,   0, 255,  33, 186,   0, 255,  33, 186,   0, 255,  33, 186,   0, 255,  32, 186,   0, 255,  32, 186,   0, 255,  32, 186,   0, 255,  32, 186,   0, 255,  30, 186,   0, 255,  29, 186,   0, 255,  28, 186,   0, 255,  26, 186,   0, 255,  25, 186,   0, 255,  23, 186,   0, 255,  21, 186,   0, 255,  20, 186,   0, 255,  17, 186,   0, 255,  15, 186,   0, 255,  12, 186,   0, 255,   9, 186,   0, 255,   6, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   6, 186,   0, 255,   9, 186,   0, 255,  12, 186,   0, 255,  16, 186,   0, 255,  18, 186,   0, 255,  21, 186,   0, 255,  23, 186,   0, 255,  26, 186,   0, 255,  27, 186,   0, 255,  30, 186,   0, 255,  32, 186,   0, 255,  33, 186,   0, 255,  34, 186,   0, 255,  36, 186,   0, 255,  37, 186,   0, 255,  38, 186,   0, 255,  38, 186,   0, 255,  39, 186,   0, 255,  39, 186,   0, 255,  39, 186,   0, 255,  39, 186,   0, 255,  39, 186,   0, 255,  38, 186,   0, 255,  38, 186,   0, 255,  37, 186,   0, 255,  36, 186,   0, 255,  34, 186,   0, 255,  33, 186,   0, 255,  31, 186,   0, 255,  30, 186,   0, 255,  28, 186,   0, 255,  26, 186,   0, 255,  23, 186,   0, 255,  21, 186,   0, 255,  18, 186,   0, 255,  16, 186,   0, 255,  12, 186,   0, 255,   9, 186,   0, 255,   6, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   5, 186,   0, 255,   9, 186,   0, 255,  11, 186,   0, 255,  15, 186,   0, 255,  18, 186,   0, 255,  21, 186,   0, 255,  24, 186,   0, 255,  26, 186,   0, 255,  29, 186,   0, 255,  31, 186,   0, 255,  34, 186,   0, 255,  36, 186,   0, 255,  38, 186,   0, 255,  40, 186,   0, 255,  41, 186,   0, 255,  42, 186,   0, 255,  43, 186,   0, 255,  44, 186,   0, 255,  44, 186,   0, 255,  46, 186,   0, 255,  45, 186,   0, 255,  45, 186,   0, 255,  46, 186,   0, 255,  45, 186,   0, 255,  45, 186,   0, 255,  44, 186,   0, 255,  43, 186,   0, 255,  43, 186,   0, 255,  41, 186,   0, 255,  39, 186,   0, 255,  38, 186,   0, 255,  36, 186,   0, 255,  33, 186,   0, 255,  31, 186,   0, 255,  29, 186,   0, 255,  26, 186,   0, 255,  24, 186,   0, 255,  21, 186,   0, 255,  18, 186,   0, 255,  15, 186,   0, 255,  12, 186,   0, 255,   8, 186,   0, 255,   4, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   2, 186,   0, 255,   7, 186,   0, 255,  10, 186,   0, 255,  14, 186,   0, 255,  18, 186,   0, 255,  20, 186,   0, 255,  23, 186,   0, 255,  27, 186,   0, 255,  30, 186,   0, 255,  32, 186,   0, 255,  35, 186,   0, 255,  37, 186,   0, 255,  40, 186,   0, 255,  42, 186,   0, 255,  44, 186,   0, 255,  46, 186,   0, 255,  48, 186,   0, 255,  48, 186,   0, 255,  50, 186,   0, 255,  50, 186,   0, 255,  51, 186,   0, 255,  52, 186,   0, 255,  53, 186,   0, 255,  52, 186,   0, 255,  53, 186,   0, 255,  52, 186,   0, 255,  52, 186,   0, 255,  50, 186,   0, 255,  50, 186,   0, 255,  48, 186,   0, 255,  47, 186,   0, 255,  45, 186,   0, 255,  43, 186,   0, 255,  42, 186,   0, 255,  40, 186,   0, 255,  37, 186,   0, 255,  35, 186,   0, 255,  33, 186,   0, 255,  29, 186,   0, 255,  27, 186,   0, 255,  24, 186,   0, 255,  20, 186,   0, 255,  17, 186,   0, 255,  14, 186,   0, 255,  10, 186,   0, 255,   6, 186,   0, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   8, 186,   0, 255,  11, 186,   0, 255,  16, 186,   0, 255,  19, 186,   0, 255,  23, 186,   0, 255,  27, 186,   0, 255,  29, 186,   0, 255,  33, 186,   0, 255,  36, 186,   0, 255,  39, 186,   0, 255,  41, 186,   0, 255,  44, 186,   0, 255,  46, 186,   0, 255,  49, 186,   0, 255,  50, 186,   0, 255,  52, 186,   0, 255,  53, 186,   0, 255,  55, 186,   0, 255,  56, 186,   0, 255,  57, 186,   0, 255,  58, 186,   0, 255,  59, 186,   0, 255,  59, 186,   0, 255,  59, 186,   0, 255,  59, 186,   0, 255,  58, 186,   0, 255,  58, 186,   0, 255,  57, 186,   0, 255,  57, 186,   0, 255,  55, 186,   0, 255,  54, 186,   0, 255,  52, 186,   0, 255,  51, 186,   0, 255,  48, 186,   0, 255,  46, 186,   0, 255,  44, 186,   0, 255,  42, 186,   0, 255,  39, 186,   0, 255,  36, 186,   0, 255,  33, 186,   0, 255,  29, 186,   0, 255,  26, 186,   0, 255,  23, 186,   0, 255,  19, 186,   0, 255,  15, 186,   0, 255,  12, 186,   0, 255,   8, 186,   0, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   5, 186,   0, 255,   9, 186,   0, 255,  13, 186,   0, 255,  17, 186,   0, 255,  21, 186,   0, 255,  24, 186,   0, 255,  28, 186,   0, 255,  32, 186,   0, 255,  35, 186,   0, 255,  39, 186,   0, 255,  42, 186,   0, 255,  44, 186,   0, 255,  47, 186,   0, 255,  50, 186,   0, 255,  53, 186,   0, 255,  54, 186,   0, 255,  57, 186,   0, 255,  58, 186,   0, 255,  60, 186,   0, 255,  61, 186,   0, 255,  62, 186,   0, 255,  63, 186,   0, 255,  64, 186,   0, 255,  65, 186,   0, 255,  65, 186,   0, 255,  66, 186,   0, 255,  66, 186,   0, 255,  65, 186,   0, 255,  64, 186,   0, 255,  63, 186,   0, 255,  63, 186,   0, 255,  61, 186,   0, 255,  60, 186,   0, 255,  58, 186,   0, 255,  57, 186,   0, 255,  55, 186,   0, 255,  52, 186,   0, 255,  50, 186,   0, 255,  48, 186,   0, 255,  45, 186,   0, 255,  42, 186,   0, 255,  38, 186,   0, 255,  35, 186,   0, 255,  32, 186,   0, 255,  28, 186,   0, 255,  25, 186,   0, 255,  21, 186,   0, 255,  17, 186,   0, 255,  13, 186,   0, 255,   9, 186,   0, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   5, 186,   0, 255,   9, 186,   0, 255,  14, 186,   0, 255,  18, 186,   0, 255,  22, 186,   0, 255,  26, 186,   0, 255,  30, 186,   0, 255,  34, 186,   0, 255,  37, 186,   0, 255,  41, 186,   0, 255,  45, 186,   0, 255,  47, 186,   0, 255,  50, 186,   0, 255,  54, 186,   0, 255,  55, 186,   0, 255,  58, 186,   0, 255,  61, 186,   0, 255,  63, 186,   0, 255,  64, 186,   0, 255,  67, 186,   0, 255,  68, 186,   0, 255,  69, 186,   0, 255,  70, 186,   0, 255,  71, 186,   0, 255,  71, 186,   0, 255,  72, 186,   0, 255,  72, 186,   0, 255,  71, 186,   0, 255,  71, 186,   0, 255,  71, 186,   0, 255,  70, 186,   0, 255,  69, 186,   0, 255,  68, 186,   0, 255,  66, 186,   0, 255,  64, 186,   0, 255,  62, 186,   0, 255,  61, 186,   0, 255,  58, 186,   0, 255,  56, 186,   0, 255,  53, 186,   0, 255,  50, 186,   0, 255,  48, 186,   0, 255,  45, 186,   0, 255,  41, 186,   0, 255,  37, 186,   0, 255,  34, 186,   0, 255,  30, 186,   0, 255,  26, 186,   0, 255,  22, 186,   0, 255,  18, 186,   0, 255,  14, 186,   0, 255,  10, 186,   0, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   5, 186,   0, 255,  10, 186,   0, 255,  14, 186,   0, 255,  19, 186,   0, 255,  23, 186,   0, 255,  27, 186,   0, 255,  31, 186,   0, 255,  35, 186,   0, 255,  39, 186,   0, 255,  43, 186,   0, 255,  47, 186,   0, 255,  50, 186,   0, 255,  53, 186,   0, 255,  56, 186,   0, 255,  59, 186,   0, 255,  62, 186,   0, 255,  65, 186,   0, 255,  66, 186,   0, 255,  69, 186,   0, 255,  71, 186,   0, 255,  72, 186,   0, 255,  75, 186,   0, 255,  76, 186,   0, 255,  77, 186,   0, 255,  77, 186,   0, 255,  78, 186,   0, 255,  79, 186,   0, 255,  78, 186,   0, 255,  78, 186,   0, 255,  78, 186,   0, 255,  77, 186,   0, 255,  77, 186,   0, 255,  75, 186,   0, 255,  74, 186,   0, 255,  73, 186,   0, 255,  71, 186,   0, 255,  69, 186,   0, 255,  67, 186,   0, 255,  64, 186,   0, 255,  62, 186,   0, 255,  59, 186,   0, 255,  57, 186,   0, 255,  53, 186,   0, 255,  50, 186,   0, 255,  46, 186,   0, 255,  43, 186,   0, 255,  39, 186,   0, 255,  35, 186,   0, 255,  31, 186,   0, 255,  27, 186,   0, 255,  23, 186,   0, 255,  19, 186,   0, 255,  14, 186,   0, 255,  10, 186,   0, 255,   5, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   5, 186,   0, 255,  10, 186,   0, 255,  15, 186,   0, 255,  20, 186,   0, 255,  24, 186,   0, 255,  28, 186,   0, 255,  32, 186,   0, 255,  36, 186,   0, 255,  40, 186,   0, 255,  45, 186,   0, 255,  48, 186,   0, 255,  52, 186,   0, 255,  56, 186,   0, 255,  59, 186,   0, 255,  62, 186,   0, 255,  65, 186,   0, 255,  67, 186,   0, 255,  71, 186,   0, 255,  73, 186,   0, 255,  75, 186,   0, 255,  77, 186,   0, 255,  79, 186,   0, 255,  80, 186,   0, 255,  82, 186,   0, 255,  83, 186,   0, 255,  84, 186,   0, 255,  85, 186,   0, 255,  85, 186,   0, 255,  85, 186,   0, 255,  85, 186,   0, 255,  85, 186,   0, 255,  84, 186,   0, 255,  83, 186,   0, 255,  82, 186,   0, 255,  80, 186,   0, 255,  78, 186,   0, 255,  77, 186,   0, 255,  75, 186,   0, 255,  73, 186,   0, 255,  70, 186,   0, 255,  67, 186,   0, 255,  65, 186,   0, 255,  62, 186,   0, 255,  59, 186,   0, 255,  55, 186,   0, 255,  52, 186,   0, 255,  48, 186,   0, 255,  44, 186,   0, 255,  40, 186,   0, 255,  36, 186,   0, 255,  32, 186,   0, 255,  28, 186,   0, 255,  23, 186,   0, 255,  19, 186,   0, 255,  14, 186,   0, 255,  10, 186,   0, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   5, 186,   0, 255,  10, 186,   0, 255,  15, 186,   0, 255,  19, 186,   0, 255,  24, 186,   0, 255,  28, 186,   0, 255,  33, 186,   0, 255,  37, 186,   0, 255,  42, 186,   0, 255,  46, 186,   0, 255,  50, 186,   0, 255,  54, 186,   0, 255,  57, 186,   0, 255,  61, 186,   0, 255,  65, 186,   0, 255,  68, 186,   0, 255,  71, 186,   0, 255,  74, 186,   0, 255,  76, 186,   0, 255,  79, 186,   0, 255,  82, 186,   0, 255,  83, 186,   0, 255,  85, 186,   0, 255,  87, 186,   0, 255,  88, 186,   0, 255,  90, 186,   0, 255,  90, 186,   0, 255,  91, 186,   0, 255,  91, 186,   0, 255,  92, 186,   0, 255,  91, 186,   0, 255,  91, 186,   0, 255,  90, 186,   0, 255,  89, 186,   0, 255,  88, 186,   0, 255,  87, 186,   0, 255,  85, 186,   0, 255,  83, 186,   0, 255,  82, 186,   0, 255,  79, 186,   0, 255,  77, 186,   0, 255,  73, 186,   0, 255,  71, 186,   0, 255,  67, 186,   0, 255,  64, 186,   0, 255,  61, 186,   0, 255,  57, 186,   0, 255,  54, 186,   0, 255,  50, 186,   0, 255,  46, 186,   0, 255,  41, 186,   0, 255,  37, 186,   0, 255,  32, 186,   0, 255,  28, 186,   0, 255,  24, 186,   0, 255,  19, 186,   0, 255,  15, 186,   0, 255,  10, 186,   0, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   4, 186,   0, 255,   8, 186,   0, 255,  14, 186,   0, 255,  19, 186,   0, 255,  24, 186,   0, 255,  28, 186,   0, 255,  33, 186,   0, 255,  37, 186,   0, 255,  42, 186,   0, 255,  47, 186,   0, 255,  51, 186,   0, 255,  55, 186,   0, 255,  59, 186,   0, 255,  63, 186,   0, 255,  66, 186,   0, 255,  70, 186,   0, 255,  73, 186,   0, 255,  77, 186,   0, 255,  80, 186,   0, 255,  83, 186,   0, 255,  85, 186,   0, 255,  88, 186,   0, 255,  89, 186,   0, 255,  92, 186,   0, 255,  93, 186,   0, 255,  94, 186,   0, 255,  96, 186,   0, 255,  96, 186,   0, 255,  97, 186,   0, 255,  98, 186,   0, 255,  98, 186,   0, 255,  98, 186,   0, 255,  97, 186,   0, 255,  97, 186,   0, 255,  96, 186,   0, 255,  95, 186,   0, 255,  94, 186,   0, 255,  91, 186,   0, 255,  89, 186,   0, 255,  88, 186,   0, 255,  85, 186,   0, 255,  82, 186,   0, 255,  79, 186,   0, 255,  76, 186,   0, 255,  74, 186,   0, 255,  70, 186,   0, 255,  67, 186,   0, 255,  63, 186,   0, 255,  59, 186,   0, 255,  54, 186,   0, 255,  51, 186,   0, 255,  46, 186,   0, 255,  42, 186,   0, 255,  37, 186,   0, 255,  33, 186,   0, 255,  28, 186,   0, 255,  24, 186,   0, 255,  19, 186,   0, 255,  14, 186,   0, 255,   9, 186,   0, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   2, 186,   0, 255,   8, 186,   0, 255,  13, 186,   0, 255,  18, 186,   0, 255,  24, 186,   0, 255,  28, 186,   0, 255,  33, 186,   0, 255,  38, 186,   0, 255,  42, 186,   0, 255,  47, 186,   0, 255,  51, 186,   0, 255,  56, 186,   0, 255,  59, 186,   0, 255,  64, 186,   0, 255,  68, 186,   0, 255,  72, 186,   0, 255,  75, 186,   0, 255,  79, 186,   0, 255,  82, 186,   0, 255,  86, 186,   0, 255,  88, 186,   0, 255,  91, 186,   0, 255,  93, 186,   0, 255,  96, 186,   0, 255,  98, 186,   0, 255,  99, 186,   0, 255, 101, 186,   0, 255, 102, 186,   0, 255, 104, 186,   0, 255, 104, 186,   0, 255, 104, 186,   0, 255, 105, 186,   0, 255, 104, 186,   0, 255, 104, 186,   0, 255, 103, 186,   0, 255, 103, 186,   0, 255, 101, 186,   0, 255,  99, 186,   0, 255,  98, 186,   0, 255,  96, 186,   0, 255,  93, 186,   0, 255,  91, 186,   0, 255,  88, 186,   0, 255,  85, 186,   0, 255,  82, 186,   0, 255,  79, 186,   0, 255,  75, 186,   0, 255,  71, 186,   0, 255,  68, 186,   0, 255,  64, 186,   0, 255,  60, 186,   0, 255,  55, 186,   0, 255,  51, 186,   0, 255,  46, 186,   0, 255,  42, 186,   0, 255,  38, 186,   0, 255,  33, 186,   0, 255,  28, 186,   0, 255,  24, 186,   0, 255,  18, 186,   0, 255,  13, 186,   0, 255,   8, 186,   0, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   6, 186,   0, 255,  12, 186,   0, 255,  17, 186,   0, 255,  22, 186,   0, 255,  27, 186,   0, 255,  32, 186,   0, 255,  37, 186,   0, 255,  42, 186,   0, 255,  47, 186,   0, 255,  52, 186,   0, 255,  56, 186,   0, 255,  61, 186,   0, 255,  65, 186,   0, 255,  69, 186,   0, 255,  73, 186,   0, 255,  77, 186,   0, 255,  81, 186,   0, 255,  85, 186,   0, 255,  88, 186,   0, 255,  91, 186,   0, 255,  95, 186,   0, 255,  97, 186,   0, 255,  99, 186,   0, 255, 102, 186,   0, 255, 104, 186,   0, 255, 106, 186,   0, 255, 108, 186,   0, 255, 109, 186,   0, 255, 110, 186,   0, 255, 111, 186,   0, 255, 111, 186,   0, 255, 112, 186,   0, 255, 111, 186,   0, 255, 111, 186,   0, 255, 110, 186,   0, 255, 108, 186,   0, 255, 107, 186,   0, 255, 106, 186,   0, 255, 104, 186,   0, 255, 101, 186,   0, 255, 100, 186,   0, 255,  97, 186,   0, 255,  94, 186,   0, 255,  91, 186,   0, 255,  88, 186,   0, 255,  85, 186,   0, 255,  80, 186,   0, 255,  77, 186,   0, 255,  73, 186,   0, 255,  69, 186,   0, 255,  65, 186,   0, 255,  60, 186,   0, 255,  56, 186,   0, 255,  52, 186,   0, 255,  47, 186,   0, 255,  42, 186,   0, 255,  37, 186,   0, 255,  33, 186,   0, 255,  27, 186,   0, 255,  22, 186,   0, 255,  17, 186,   0, 255,  12, 186,   0, 255,   6, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   5, 186,   0, 255,  11, 186,   0, 255,  16, 186,   0, 255,  21, 186,   0, 255,  27, 186,   0, 255,  31, 186,   0, 255,  36, 186,   0, 255,  41, 186,   0, 255,  47, 186,   0, 255,  52, 186,   0, 255,  56, 186,   0, 255,  61, 186,   0, 255,  65, 186,   0, 255,  70, 186,   0, 255,  74, 186,   0, 255,  78, 186,   0, 255,  82, 186,   0, 255,  86, 186,   0, 255,  90, 186,   0, 255,  94, 186,   0, 255,  97, 186,   0, 255, 100, 186,   0, 255, 103, 186,   0, 255, 106, 186,   0, 255, 108, 186,   0, 255, 110, 186,   0, 255, 112, 186,   0, 255, 113, 186,   0, 255, 115, 186,   0, 255, 117, 186,   0, 255, 117, 186,   0, 255, 118, 186,   0, 255, 118, 186,   0, 255, 118, 186,   0, 255, 117, 186,   0, 255, 117, 186,   0, 255, 115, 186,   0, 255, 114, 186,   0, 255, 112, 186,   0, 255, 110, 186,   0, 255, 108, 186,   0, 255, 105, 186,   0, 255, 102, 186,   0, 255, 100, 186,   0, 255,  97, 186,   0, 255,  93, 186,   0, 255,  90, 186,   0, 255,  86, 186,   0, 255,  82, 186,   0, 255,  78, 186,   0, 255,  74, 186,   0, 255,  70, 186,   0, 255,  66, 186,   0, 255,  61, 186,   0, 255,  57, 186,   0, 255,  51, 186,   0, 255,  47, 186,   0, 255,  42, 186,   0, 255,  36, 186,   0, 255,  32, 186,   0, 255,  26, 186,   0, 255,  21, 186,   0, 255,  15, 186,   0, 255,  10, 186,   0, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   8, 186,   0, 255,  14, 186,   0, 255,  20, 186,   0, 255,  24, 186,   0, 255,  30, 186,   0, 255,  35, 186,   0, 255,  41, 186,   0, 255,  45, 186,   0, 255,  51, 186,   0, 255,  56, 186,   0, 255,  60, 186,   0, 255,  66, 186,   0, 255,  70, 186,   0, 255,  75, 186,   0, 255,  80, 186,   0, 255,  84, 186,   0, 255,  87, 186,   0, 255,  91, 186,   0, 255,  95, 186,   0, 255,  99, 186,   0, 255, 103, 186,   0, 255, 106, 186,   0, 255, 108, 186,   0, 255, 112, 186,   0, 255, 114, 186,   0, 255, 117, 186,   0, 255, 118, 186,   0, 255, 120, 186,   0, 255, 122, 186,   0, 255, 123, 186,   0, 255, 123, 186,   0, 255, 124, 186,   0, 255, 124, 186,   0, 255, 124, 186,   0, 255, 124, 186,   0, 255, 123, 186,   0, 255, 122, 186,   0, 255, 120, 186,   0, 255, 118, 186,   0, 255, 116, 186,   0, 255, 114, 186,   0, 255, 112, 186,   0, 255, 109, 186,   0, 255, 105, 186,   0, 255, 102, 186,   0, 255,  99, 186,   0, 255,  95, 186,   0, 255,  92, 186,   0, 255,  87, 186,   0, 255,  83, 186,   0, 255,  79, 186,   0, 255,  75, 186,   0, 255,  70, 186,   0, 255,  65, 186,   0, 255,  60, 186,   0, 255,  55, 186,   0, 255,  51, 186,   0, 255,  46, 186,   0, 255,  40, 186,   0, 255,  36, 186,   0, 255,  30, 186,   0, 255,  24, 186,   0, 255,  19, 186,   0, 255,  14, 186,   0, 255,   8, 186,   0, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   6, 186,   0, 255,  12, 186,   0, 255,  17, 186,   0, 255,  23, 186,   0, 255,  28, 186,   0, 255,  34, 186,   0, 255,  39, 186,   0, 255,  45, 186,   0, 255,  50, 186,   0, 255,  55, 186,   0, 255,  60, 186,   0, 255,  65, 186,   0, 255,  70, 186,   0, 255,  74, 186,   0, 255,  79, 186,   0, 255,  84, 186,   0, 255,  88, 186,   0, 255,  93, 186,   0, 255,  96, 186,   0, 255, 101, 186,   0, 255, 104, 186,   0, 255, 108, 186,   0, 255, 112, 186,   0, 255, 115, 186,   0, 255, 118, 186,   0, 255, 120, 186,   0, 255, 122, 186,   0, 255, 125, 186,   0, 255, 127, 186,   0, 255, 128, 186,   0, 255, 129, 186,   0, 255, 130, 186,   0, 255, 131, 186,   0, 255, 131, 186,   0, 255, 131, 186,   0, 255, 130, 186,   0, 255, 130, 186,   0, 255, 129, 186,   0, 255, 127, 186,   0, 255, 125, 186,   0, 255, 123, 186,   0, 255, 120, 186,   0, 255, 118, 186,   0, 255, 115, 186,   0, 255, 111, 186,   0, 255, 108, 186,   0, 255, 104, 186,   0, 255, 100, 186,   0, 255,  97, 186,   0, 255,  92, 186,   0, 255,  88, 186,   0, 255,  84, 186,   0, 255,  79, 186,   0, 255,  74, 186,   0, 255,  70, 186,   0, 255,  65, 186,   0, 255,  60, 186,   0, 255,  55, 186,   0, 255,  50, 186,   0, 255,  44, 186,   0, 255,  39, 186,   0, 255,  34, 186,   0, 255,  28, 186,   0, 255,  23, 186,   0, 255,  18, 186,   0, 255,  12, 186,   0, 255,   6, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   4, 186,   0, 255,   9, 186,   0, 255,  15, 186,   0, 255,  21, 186,   0, 255,  27, 186,   0, 255,  32, 186,   0, 255,  37, 186,   0, 255,  43, 186,   0, 255,  48, 186,   0, 255,  53, 186,   0, 255,  59, 186,   0, 255,  64, 186,   0, 255,  69, 186,   0, 255,  74, 186,   0, 255,  79, 186,   0, 255,  84, 186,   0, 255,  88, 186,   0, 255,  93, 186,   0, 255,  98, 186,   0, 255, 102, 186,   0, 255, 106, 186,   0, 255, 110, 186,   0, 255, 113, 186,   0, 255, 117, 186,   0, 255, 120, 186,   0, 255, 124, 186,   0, 255, 126, 186,   0, 255, 129, 186,   0, 255, 130, 186,   0, 255, 132, 186,   0, 255, 134, 186,   0, 255, 136, 186,   0, 255, 137, 186,   0, 255, 137, 186,   0, 255, 137, 186,   0, 255, 138, 186,   0, 255, 137, 186,   0, 255, 136, 186,   0, 255, 134, 186,   0, 255, 133, 186,   0, 255, 131, 186,   0, 255, 129, 186,   0, 255, 126, 186,   0, 255, 123, 186,   0, 255, 120, 186,   0, 255, 117, 186,   0, 255, 113, 186,   0, 255, 110, 186,   0, 255, 106, 186,   0, 255, 102, 186,   0, 255,  98, 186,   0, 255,  93, 186,   0, 255,  88, 186,   0, 255,  84, 186,   0, 255,  79, 186,   0, 255,  74, 186,   0, 255,  69, 186,   0, 255,  64, 186,   0, 255,  58, 186,   0, 255,  53, 186,   0, 255,  48, 186,   0, 255,  43, 186,   0, 255,  37, 186,   0, 255,  32, 186,   0, 255,  26, 186,   0, 255,  21, 186,   0, 255,  15, 186,   0, 255,  10, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   6, 186,   0, 255,  12, 186,   0, 255,  18, 186,   0, 255,  24, 186,   0, 255,  29, 186,   0, 255,  35, 186,   0, 255,  41, 186,   0, 255,  47, 186,   0, 255,  52, 186,   0, 255,  58, 186,   0, 255,  62, 186,   0, 255,  68, 186,   0, 255,  73, 186,   0, 255,  79, 186,   0, 255,  83, 186,   0, 255,  89, 186,   0, 255,  93, 186,   0, 255,  98, 186,   0, 255, 103, 186,   0, 255, 107, 186,   0, 255, 111, 186,   0, 255, 115, 186,   0, 255, 119, 186,   0, 255, 123, 186,   0, 255, 126, 186,   0, 255, 129, 186,   0, 255, 132, 186,   0, 255, 135, 186,   0, 255, 137, 186,   0, 255, 139, 186,   0, 255, 141, 186,   0, 255, 142, 186,   0, 255, 143, 186,   0, 255, 144, 186,   0, 255, 144, 186,   0, 255, 143, 186,   0, 255, 143, 186,   0, 255, 142, 186,   0, 255, 141, 186,   0, 255, 139, 186,   0, 255, 138, 186,   0, 255, 134, 186,   0, 255, 132, 186,   0, 255, 129, 186,   0, 255, 126, 186,   0, 255, 122, 186,   0, 255, 119, 186,   0, 255, 115, 186,   0, 255, 111, 186,   0, 255, 106, 186,   0, 255, 102, 186,   0, 255,  98, 186,   0, 255,  93, 186,   0, 255,  89, 186,   0, 255,  83, 186,   0, 255,  79, 186,   0, 255,  73, 186,   0, 255,  68, 186,   0, 255,  62, 186,   0, 255,  58, 186,   0, 255,  52, 186,   0, 255,  47, 186,   0, 255,  41, 186,   0, 255,  35, 186,   0, 255,  29, 186,   0, 255,  24, 186,   0, 255,  18, 186,   0, 255,  13, 186,   0, 255,   7, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   9, 186,   0, 255,  16, 186,   0, 255,  21, 186,   0, 255,  27, 186,   0, 255,  33, 186,   0, 255,  39, 186,   0, 255,  44, 186,   0, 255,  50, 186,   0, 255,  55, 186,   0, 255,  61, 186,   0, 255,  66, 186,   0, 255,  72, 186,   0, 255,  77, 186,   0, 255,  82, 186,   0, 255,  88, 186,   0, 255,  92, 186,   0, 255,  98, 186,   0, 255, 102, 186,   0, 255, 107, 186,   0, 255, 112, 186,   0, 255, 116, 186,   0, 255, 120, 186,   0, 255, 125, 186,   0, 255, 129, 186,   0, 255, 131, 186,   0, 255, 135, 186,   0, 255, 138, 186,   0, 255, 141, 186,   0, 255, 144, 186,   0, 255, 146, 186,   0, 255, 147, 186,   0, 255, 148, 186,   0, 255, 150, 186,   0, 255, 150, 186,   0, 255, 151, 186,   0, 255, 150, 186,   0, 255, 150, 186,   0, 255, 149, 186,   0, 255, 148, 186,   0, 255, 145, 186,   0, 255, 144, 186,   0, 255, 141, 186,   0, 255, 138, 186,   0, 255, 135, 186,   0, 255, 132, 186,   0, 255, 128, 186,   0, 255, 124, 186,   0, 255, 121, 186,   0, 255, 116, 186,   0, 255, 111, 186,   0, 255, 107, 186,   0, 255, 102, 186,   0, 255,  98, 186,   0, 255,  92, 186,   0, 255,  88, 186,   0, 255,  82, 186,   0, 255,  78, 186,   0, 255,  71, 186,   0, 255,  66, 186,   0, 255,  61, 186,   0, 255,  56, 186,   0, 255,  50, 186,   0, 255,  44, 186,   0, 255,  39, 186,   0, 255,  33, 186,   0, 255,  26, 186,   0, 255,  21, 186,   0, 255,  15, 186,   0, 255,  10, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   6, 186,   0, 255,  12, 186,   0, 255,  18, 186,   0, 255,  24, 186,   0, 255,  30, 186,   0, 255,  36, 186,   0, 255,  42, 186,   0, 255,  47, 186,   0, 255,  53, 186,   0, 255,  59, 186,   0, 255,  65, 186,   0, 255,  70, 186,   0, 255,  76, 186,   0, 255,  81, 186,   0, 255,  86, 186,   0, 255,  91, 186,   0, 255,  96, 186,   0, 255, 102, 186,   0, 255, 107, 186,   0, 255, 112, 186,   0, 255, 117, 186,   0, 255, 121, 186,   0, 255, 125, 186,   0, 255, 129, 186,   0, 255, 134, 186,   0, 255, 137, 186,   0, 255, 141, 186,   0, 255, 144, 186,   0, 255, 146, 186,   0, 255, 149, 186,   0, 255, 152, 186,   0, 255, 154, 186,   0, 255, 155, 186,   0, 255, 156, 186,   0, 255, 156, 186,   0, 255, 157, 186,   0, 255, 157, 186,   0, 255, 156, 186,   0, 255, 155, 186,   0, 255, 153, 186,   0, 255, 151, 186,   0, 255, 149, 186,   0, 255, 147, 186,   0, 255, 144, 186,   0, 255, 141, 186,   0, 255, 137, 186,   0, 255, 133, 186,   0, 255, 129, 186,   0, 255, 125, 186,   0, 255, 121, 186,   0, 255, 117, 186,   0, 255, 112, 186,   0, 255, 106, 186,   0, 255, 101, 186,   0, 255,  96, 186,   0, 255,  91, 186,   0, 255,  86, 186,   0, 255,  81, 186,   0, 255,  76, 186,   0, 255,  70, 186,   0, 255,  65, 186,   0, 255,  58, 186,   0, 255,  53, 186,   0, 255,  48, 186,   0, 255,  42, 186,   0, 255,  36, 186,   0, 255,  30, 186,   0, 255,  23, 186,   0, 255,  17, 186,   0, 255,  12, 186,   0, 255,   6, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   9, 186,   0, 255,  14, 186,   0, 255,  20, 186,   0, 255,  26, 186,   0, 255,  33, 186,   0, 255,  39, 186,   0, 255,  45, 186,   0, 255,  50, 186,   0, 255,  56, 186,   0, 255,  62, 186,   0, 255,  67, 186,   0, 255,  73, 186,   0, 255,  79, 186,   0, 255,  84, 186,   0, 255,  90, 186,   0, 255,  96, 186,   0, 255, 101, 186,   0, 255, 106, 186,   0, 255, 111, 186,   0, 255, 116, 186,   0, 255, 121, 186,   0, 255, 126, 186,   0, 255, 130, 186,   0, 255, 135, 186,   0, 255, 138, 186,   0, 255, 142, 186,   0, 255, 146, 186,   0, 255, 149, 186,   0, 255, 152, 186,   0, 255, 155, 186,   0, 255, 158, 186,   0, 255, 160, 186,   0, 255, 161, 186,   0, 255, 162, 186,   0, 255, 163, 186,   0, 255, 163, 186,   0, 255, 164, 186,   0, 255, 163, 186,   0, 255, 161, 186,   0, 255, 160, 186,   0, 255, 158, 186,   0, 255, 155, 186,   0, 255, 153, 186,   0, 255, 150, 186,   0, 255, 146, 186,   0, 255, 142, 186,   0, 255, 139, 186,   0, 255, 134, 186,   0, 255, 130, 186,   0, 255, 126, 186,   0, 255, 121, 186,   0, 255, 116, 186,   0, 255, 111, 186,   0, 255, 106, 186,   0, 255, 101, 186,   0, 255,  96, 186,   0, 255,  90, 186,   0, 255,  85, 186,   0, 255,  79, 186,   0, 255,  73, 186,   0, 255,  68, 186,   0, 255,  62, 186,   0, 255,  56, 186,   0, 255,  50, 186,   0, 255,  45, 186,   0, 255,  38, 186,   0, 255,  32, 186,   0, 255,  27, 186,   0, 255,  21, 186,   0, 255,  15, 186,   0, 255,   8, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   4, 186,   0, 255,  11, 186,   0, 255,  17, 186,   0, 255,  23, 186,   0, 255,  29, 186,   0, 255,  35, 186,   0, 255,  42, 186,   0, 255,  47, 186,   0, 255,  53, 186,   0, 255,  59, 186,   0, 255,  65, 186,   0, 255,  71, 186,   0, 255,  76, 186,   0, 255,  82, 186,   0, 255,  87, 186,   0, 255,  94, 186,   0, 255,  99, 186,   0, 255, 104, 186,   0, 255, 110, 186,   0, 255, 115, 186,   0, 255, 120, 186,   0, 255, 126, 186,   0, 255, 130, 186,   0, 255, 134, 186,   0, 255, 140, 186,   0, 255, 144, 186,   0, 255, 148, 186,   0, 255, 152, 186,   0, 255, 155, 186,   0, 255, 158, 186,   0, 255, 161, 186,   0, 255, 163, 186,   0, 255, 166, 186,   0, 255, 168, 186,   0, 255, 169, 186,   0, 255, 170, 186,   0, 255, 170, 186,   0, 255, 169, 186,   0, 255, 169, 186,   0, 255, 168, 186,   0, 255, 166, 186,   0, 255, 164, 186,   0, 255, 162, 186,   0, 255, 158, 186,   0, 255, 155, 186,   0, 255, 151, 186,   0, 255, 148, 186,   0, 255, 143, 186,   0, 255, 139, 186,   0, 255, 135, 186,   0, 255, 130, 186,   0, 255, 125, 186,   0, 255, 120, 186,   0, 255, 115, 186,   0, 255, 110, 186,   0, 255, 105, 186,   0, 255,  99, 186,   0, 255,  94, 186,   0, 255,  88, 186,   0, 255,  83, 186,   0, 255,  77, 186,   0, 255,  70, 186,   0, 255,  65, 186,   0, 255,  59, 186,   0, 255,  53, 186,   0, 255,  47, 186,   0, 255,  41, 186,   0, 255,  35, 186,   0, 255,  30, 186,   0, 255,  23, 186,   0, 255,  17, 186,   0, 255,  11, 186,   0, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   7, 186,   0, 255,  13, 186,   0, 255,  20, 186,   0, 255,  26, 186,   0, 255,  31, 186,   0, 255,  37, 186,   0, 255,  43, 186,   0, 255,  50, 186,   0, 255,  56, 186,   0, 255,  61, 186,   0, 255,  68, 186,   0, 255,  74, 186,   0, 255,  80, 186,   0, 255,  85, 186,   0, 255,  92, 186,   0, 255,  97, 186,   0, 255, 102, 186,   0, 255, 108, 186,   0, 255, 113, 186,   0, 255, 119, 186,   0, 255, 124, 186,   0, 255, 130, 186,   0, 255, 135, 186,   0, 255, 140, 186,   0, 255, 144, 186,   0, 255, 148, 186,   0, 255, 153, 186,   0, 255, 157, 186,   0, 255, 161, 186,   0, 255, 164, 186,   0, 255, 167, 186,   0, 255, 170, 186,   0, 255, 172, 186,   0, 255, 174, 186,   0, 255, 175, 186,   0, 255, 176, 186,   0, 255, 176, 186,   0, 255, 177, 186,   0, 255, 176, 186,   0, 255, 174, 186,   0, 255, 172, 186,   0, 255, 170, 186,   0, 255, 167, 186,   0, 255, 165, 186,   0, 255, 161, 186,   0, 255, 157, 186,   0, 255, 153, 186,   0, 255, 149, 186,   0, 255, 144, 186,   0, 255, 140, 186,   0, 255, 134, 186,   0, 255, 130, 186,   0, 255, 124, 186,   0, 255, 119, 186,   0, 255, 114, 186,   0, 255, 108, 186,   0, 255, 102, 186,   0, 255,  97, 186,   0, 255,  91, 186,   0, 255,  85, 186,   0, 255,  80, 186,   0, 255,  74, 186,   0, 255,  68, 186,   0, 255,  62, 186,   0, 255,  56, 186,   0, 255,  50, 186,   0, 255,  43, 186,   0, 255,  38, 186,   0, 255,  31, 186,   0, 255,  25, 186,   0, 255,  19, 186,   0, 255,  13, 186,   0, 255,   7, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   9, 186,   0, 255,  15, 186,   0, 255,  22, 186,   0, 255,  28, 186,   0, 255,  34, 186,   0, 255,  40, 186,   0, 255,  46, 186,   0, 255,  52, 186,   0, 255,  59, 186,   0, 255,  64, 186,   0, 255,  70, 186,   0, 255,  77, 186,   0, 255,  83, 186,   0, 255,  88, 186,   0, 255,  94, 186,   0, 255, 100, 186,   0, 255, 106, 186,   0, 255, 112, 186,   0, 255, 117, 186,   0, 255, 123, 186,   0, 255, 128, 186,   0, 255, 134, 186,   0, 255, 138, 186,   0, 255, 143, 186,   0, 255, 149, 186,   0, 255, 153, 186,   0, 255, 158, 186,   0, 255, 162, 186,   0, 255, 166, 186,   0, 255, 170, 186,   0, 255, 173, 186,   0, 255, 176, 186,   0, 255, 179, 186,   0, 255, 181, 186,   0, 255, 182, 186,   0, 255, 183, 186,   0, 255, 183, 186,   0, 255, 183, 186,   0, 255, 182, 186,   0, 255, 181, 186,   0, 255, 178, 186,   0, 255, 176, 186,   0, 255, 173, 186,   0, 255, 170, 186,   0, 255, 166, 186,   0, 255, 163, 186,   0, 255, 158, 186,   0, 255, 153, 186,   0, 255, 149, 186,   0, 255, 143, 186,   0, 255, 139, 186,   0, 255, 134, 186,   0, 255, 128, 186,   0, 255, 123, 186,   0, 255, 117, 186,   0, 255, 112, 186,   0, 255, 105, 186,   0, 255, 100, 186,   0, 255,  94, 186,   0, 255,  88, 186,   0, 255,  83, 186,   0, 255,  77, 186,   0, 255,  71, 186,   0, 255,  65, 186,   0, 255,  58, 186,   0, 255,  52, 186,   0, 255,  46, 186,   0, 255,  40, 186,   0, 255,  34, 186,   0, 255,  28, 186,   0, 255,  21, 186,   0, 255,  15, 186,   0, 255,   8, 186,   0, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   4, 186,   0, 255,  11, 186,   0, 255,  17, 186,   0, 255,  23, 186,   0, 255,  29, 186,   0, 255,  36, 186,   0, 255,  42, 186,   0, 255,  48, 186,   0, 255,  54, 186,   0, 255,  61, 186,   0, 255,  67, 186,   0, 255,  73, 186,   0, 255,  79, 186,   0, 255,  85, 186,   0, 255,  91, 186,   0, 255,  97, 186,   0, 255, 103, 186,   0, 255, 108, 186,   0, 255, 115, 186,   0, 255, 121, 186,   0, 255, 126, 186,   0, 255, 132, 186,   0, 255, 137, 186,   0, 255, 143, 186,   0, 255, 148, 186,   0, 255, 152, 186,   0, 255, 158, 186,   0, 255, 163, 186,   0, 255, 167, 186,   0, 255, 171, 186,   0, 255, 175, 186,   0, 255, 179, 186,   0, 255, 182, 186,   0, 255, 185, 186,   0, 255, 187, 186,   0, 255, 188, 186,   0, 255, 190, 186,   0, 255, 190, 186,   0, 255, 189, 186,   0, 255, 189, 186,   0, 255, 187, 186,   0, 255, 185, 186,   0, 255, 182, 186,   0, 255, 178, 186,   0, 255, 175, 186,   0, 255, 171, 186,   0, 255, 167, 186,   0, 255, 163, 186,   0, 255, 158, 186,   0, 255, 153, 186,   0, 255, 147, 186,   0, 255, 143, 186,   0, 255, 137, 186,   0, 255, 131, 186,   0, 255, 126, 186,   0, 255, 120, 186,   0, 255, 114, 186,   0, 255, 109, 186,   0, 255, 103, 186,   0, 255,  97, 186,   0, 255,  91, 186,   0, 255,  85, 186,   0, 255,  78, 186,   0, 255,  73, 186,   0, 255,  66, 186,   0, 255,  61, 186,   0, 255,  55, 186,   0, 255,  48, 186,   0, 255,  42, 186,   0, 255,  36, 186,   0, 255,  29, 186,   0, 255,  23, 186,   0, 255,  17, 186,   0, 255,  10, 186,   0, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   6, 186,   0, 255,  12, 186,   0, 255,  19, 186,   0, 255,  25, 186,   0, 255,  31, 186,   0, 255,  37, 186,   0, 255,  44, 186,   0, 255,  50, 186,   0, 255,  56, 186,   0, 255,  63, 186,   0, 255,  68, 186,   0, 255,  75, 186,   0, 255,  82, 186,   0, 255,  88, 186,   0, 255,  94, 186,   0, 255, 100, 186,   0, 255, 105, 186,   0, 255, 111, 186,   0, 255, 118, 186,   0, 255, 123, 186,   0, 255, 130, 186,   0, 255, 135, 186,   0, 255, 140, 186,   0, 255, 146, 186,   0, 255, 151, 186,   0, 255, 157, 186,   0, 255, 162, 186,   0, 255, 167, 186,   0, 255, 172, 186,   0, 255, 176, 186,   0, 255, 181, 186,   0, 255, 184, 186,   0, 255, 188, 186,   0, 255, 191, 186,   0, 255, 193, 186,   0, 255, 195, 186,   0, 255, 196, 186,   0, 255, 196, 186,   0, 255, 195, 186,   0, 255, 195, 186,   0, 255, 193, 186,   0, 255, 191, 186,   0, 255, 188, 186,   0, 255, 184, 186,   0, 255, 181, 186,   0, 255, 177, 186,   0, 255, 172, 186,   0, 255, 167, 186,   0, 255, 162, 186,   0, 255, 157, 186,   0, 255, 152, 186,   0, 255, 146, 186,   0, 255, 141, 186,   0, 255, 134, 186,   0, 255, 129, 186,   0, 255, 124, 186,   0, 255, 118, 186,   0, 255, 111, 186,   0, 255, 105, 186,   0, 255, 100, 186,   0, 255,  93, 186,   0, 255,  87, 186,   0, 255,  81, 186,   0, 255,  75, 186,   0, 255,  69, 186,   0, 255,  63, 186,   0, 255,  56, 186,   0, 255,  50, 186,   0, 255,  44, 186,   0, 255,  37, 186,   0, 255,  31, 186,   0, 255,  25, 186,   0, 255,  18, 186,   0, 255,  12, 186,   0, 255,   6, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   7, 186,   0, 255,  14, 186,   0, 255,  20, 186,   0, 255,  26, 186,   0, 255,  33, 186,   0, 255,  40, 186,   0, 255,  45, 186,   0, 255,  52, 186,   0, 255,  58, 186,   0, 255,  65, 186,   0, 255,  71, 186,   0, 255,  77, 186,   0, 255,  84, 186,   0, 255,  89, 186,   0, 255,  96, 186,   0, 255, 101, 186,   0, 255, 108, 186,   0, 255, 114, 186,   0, 255, 120, 186,   0, 255, 127, 186,   0, 255, 132, 186,   0, 255, 138, 186,   0, 255, 144, 186,   0, 255, 150, 186,   0, 255, 156, 186,   0, 255, 161, 186,   0, 255, 166, 186,   0, 255, 172, 186,   0, 255, 176, 186,   0, 255, 181, 186,   0, 255, 185, 186,   0, 255, 190, 186,   0, 255, 193, 186,   0, 255, 197, 186,   0, 255, 199, 186,   0, 255, 201, 186,   0, 255, 202, 186,   0, 255, 202, 186,   0, 255, 202, 186,   0, 255, 201, 186,   0, 255, 199, 186,   0, 255, 197, 186,   0, 255, 193, 186,   0, 255, 190, 186,   0, 255, 186, 186,   0, 255, 181, 186,   0, 255, 176, 186,   0, 255, 172, 186,   0, 255, 166, 186,   0, 255, 161, 186,   0, 255, 155, 186,   0, 255, 150, 186,   0, 255, 144, 186,   0, 255, 138, 186,   0, 255, 132, 186,   0, 255, 127, 186,   0, 255, 120, 186,   0, 255, 114, 186,   0, 255, 108, 186,   0, 255, 102, 186,   0, 255,  95, 186,   0, 255,  89, 186,   0, 255,  84, 186,   0, 255,  77, 186,   0, 255,  71, 186,   0, 255,  64, 186,   0, 255,  58, 186,   0, 255,  52, 186,   0, 255,  45, 186,   0, 255,  39, 186,   0, 255,  33, 186,   0, 255,  27, 186,   0, 255,  21, 186,   0, 255,  14, 186,   0, 255,   8, 186,   0, 255,   1, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   9, 186,   0, 255,  15, 186,   0, 255,  22, 186,   0, 255,  28, 186,   0, 255,  35, 186,   0, 255,  41, 186,   0, 255,  48, 186,   0, 255,  54, 186,   0, 255,  60, 186,   0, 255,  66, 186,   0, 255,  73, 186,   0, 255,  79, 186,   0, 255,  85, 186,   0, 255,  91, 186,   0, 255,  98, 186,   0, 255, 104, 186,   0, 255, 110, 186,   0, 255, 117, 186,   0, 255, 123, 186,   0, 255, 129, 186,   0, 255, 135, 186,   0, 255, 141, 186,   0, 255, 147, 186,   0, 255, 153, 186,   0, 255, 159, 186,   0, 255, 164, 186,   0, 255, 170, 186,   0, 255, 176, 186,   0, 255, 180, 186,   0, 255, 186, 186,   0, 255, 190, 186,   0, 255, 195, 186,   0, 255, 199, 186,   0, 255, 202, 186,   0, 255, 205, 186,   0, 255, 207, 186,   0, 255, 209, 186,   0, 255, 209, 186,   0, 255, 209, 186,   0, 255, 208, 186,   0, 255, 206, 186,   0, 255, 202, 186,   0, 255, 199, 186,   0, 255, 195, 186,   0, 255, 190, 186,   0, 255, 186, 186,   0, 255, 181, 186,   0, 255, 176, 186,   0, 255, 169, 186,   0, 255, 164, 186,   0, 255, 158, 186,   0, 255, 153, 186,   0, 255, 147, 186,   0, 255, 140, 186,   0, 255, 134, 186,   0, 255, 129, 186,   0, 255, 123, 186,   0, 255, 116, 186,   0, 255, 110, 186,   0, 255, 104, 186,   0, 255,  98, 186,   0, 255,  91, 186,   0, 255,  85, 186,   0, 255,  79, 186,   0, 255,  73, 186,   0, 255,  66, 186,   0, 255,  60, 186,   0, 255,  53, 186,   0, 255,  47, 186,   0, 255,  41, 186,   0, 255,  35, 186,   0, 255,  28, 186,   0, 255,  22, 186,   0, 255,  15, 186,   0, 255,   8, 186,   0, 255,   2, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,  10, 186,   0, 255,  16, 186,   0, 255,  23, 186,   0, 255,  29, 186,   0, 255,  36, 186,   0, 255,  42, 186,   0, 255,  49, 186,   0, 255,  55, 186,   0, 255,  62, 186,   0, 255,  67, 186,   0, 255,  74, 186,   0, 255,  81, 186,   0, 255,  86, 186,   0, 255,  94, 186,   0, 255, 100, 186,   0, 255, 106, 186,   0, 255, 112, 186,   0, 255, 118, 186,   0, 255, 124, 186,   0, 255, 131, 186,   0, 255, 137, 186,   0, 255, 144, 186,   0, 255, 149, 186,   0, 255, 155, 186,   0, 255, 161, 186,   0, 255, 167, 186,   0, 255, 173, 186,   0, 255, 178, 186,   0, 255, 184, 186,   0, 255, 189, 186,   0, 255, 195, 186,   0, 255, 200, 186,   0, 255, 204, 186,   0, 255, 208, 186,   0, 255, 211, 186,   0, 255, 213, 186,   0, 255, 215, 186,   0, 255, 216, 186,   0, 255, 215, 186,   0, 255, 214, 186,   0, 255, 211, 186,   0, 255, 207, 186,   0, 255, 204, 186,   0, 255, 200, 186,   0, 255, 195, 186,   0, 255, 189, 186,   0, 255, 185, 186,   0, 255, 178, 186,   0, 255, 173, 186,   0, 255, 167, 186,   0, 255, 162, 186,   0, 255, 156, 186,   0, 255, 149, 186,   0, 255, 143, 186,   0, 255, 137, 186,   0, 255, 130, 186,   0, 255, 124, 186,   0, 255, 118, 186,   0, 255, 113, 186,   0, 255, 106, 186,   0, 255, 100, 186,   0, 255,  93, 186,   0, 255,  87, 186,   0, 255,  81, 186,   0, 255,  74, 186,   0, 255,  68, 186,   0, 255,  61, 186,   0, 255,  55, 186,   0, 255,  48, 186,   0, 255,  42, 186,   0, 255,  36, 186,   0, 255,  29, 186,   0, 255,  23, 186,   0, 255,  16, 186,   0, 255,   9, 186,   0, 255,   4, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   4, 186,   0, 255,  11, 186,   0, 255,  18, 186,   0, 255,  24, 186,   0, 255,  30, 186,   0, 255,  36, 186,   0, 255,  43, 186,   0, 255,  50, 186,   0, 255,  56, 186,   0, 255,  62, 186,   0, 255,  69, 186,   0, 255,  75, 186,   0, 255,  81, 186,   0, 255,  88, 186,   0, 255,  94, 186,   0, 255, 101, 186,   0, 255, 107, 186,   0, 255, 114, 186,   0, 255, 120, 186,   0, 255, 126, 186,   0, 255, 133, 186,   0, 255, 139, 186,   0, 255, 146, 186,   0, 255, 152, 186,   0, 255, 158, 186,   0, 255, 164, 186,   0, 255, 170, 186,   0, 255, 176, 186,   0, 255, 182, 186,   0, 255, 187, 186,   0, 255, 193, 186,   0, 255, 198, 186,   0, 255, 204, 186,   0, 255, 209, 186,   0, 255, 213, 186,   0, 255, 217, 186,   0, 255, 220, 186,   0, 255, 221, 186,   0, 255, 223, 186,   0, 255, 222, 186,   0, 255, 220, 186,   0, 255, 217, 186,   0, 255, 213, 186,   0, 255, 209, 186,   0, 255, 204, 186,   0, 255, 199, 186,   0, 255, 194, 186,   0, 255, 187, 186,   0, 255, 182, 186,   0, 255, 176, 186,   0, 255, 170, 186,   0, 255, 164, 186,   0, 255, 158, 186,   0, 255, 152, 186,   0, 255, 145, 186,   0, 255, 140, 186,   0, 255, 132, 186,   0, 255, 126, 186,   0, 255, 121, 186,   0, 255, 113, 186,   0, 255, 108, 186,   0, 255, 101, 186,   0, 255,  95, 186,   0, 255,  88, 186,   0, 255,  82, 186,   0, 255,  75, 186,   0, 255,  69, 186,   0, 255,  63, 186,   0, 255,  56, 186,   0, 255,  50, 186,   0, 255,  44, 186,   0, 255,  37, 186,   0, 255,  30, 186,   0, 255,  24, 186,   0, 255,  18, 186,   0, 255,  11, 186,   0, 255,   4, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   5, 186,   0, 255,  12, 186,   0, 255,  18, 186,   0, 255,  24, 186,   0, 255,  32, 186,   0, 255,  38, 186,   0, 255,  44, 186,   0, 255,  51, 186,   0, 255,  57, 186,   0, 255,  64, 186,   0, 255,  71, 186,   0, 255,  77, 186,   0, 255,  83, 186,   0, 255,  89, 186,   0, 255,  96, 186,   0, 255, 103, 186,   0, 255, 109, 186,   0, 255, 115, 186,   0, 255, 121, 186,   0, 255, 128, 186,   0, 255, 135, 186,   0, 255, 141, 186,   0, 255, 147, 186,   0, 255, 154, 186,   0, 255, 159, 186,   0, 255, 166, 186,   0, 255, 173, 186,   0, 255, 179, 186,   0, 255, 185, 186,   0, 255, 190, 186,   0, 255, 196, 186,   0, 255, 202, 186,   0, 255, 208, 186,   0, 255, 213, 186,   0, 255, 218, 186,   0, 255, 223, 186,   0, 255, 226, 186,   0, 255, 228, 186,   0, 255, 229, 186,   0, 255, 228, 186,   0, 255, 225, 186,   0, 255, 222, 186,   0, 255, 218, 186,   0, 255, 213, 186,   0, 255, 208, 186,   0, 255, 202, 186,   0, 255, 197, 186,   0, 255, 190, 186,   0, 255, 184, 186,   0, 255, 179, 186,   0, 255, 172, 186,   0, 255, 166, 186,   0, 255, 160, 186,   0, 255, 153, 186,   0, 255, 147, 186,   0, 255, 140, 186,   0, 255, 134, 186,   0, 255, 128, 186,   0, 255, 122, 186,   0, 255, 115, 186,   0, 255, 109, 186,   0, 255, 103, 186,   0, 255,  96, 186,   0, 255,  89, 186,   0, 255,  83, 186,   0, 255,  77, 186,   0, 255,  70, 186,   0, 255,  64, 186,   0, 255,  57, 186,   0, 255,  51, 186,   0, 255,  44, 186,   0, 255,  38, 186,   0, 255,  31, 186,   0, 255,  24, 186,   0, 255,  18, 186,   0, 255,  12, 186,   0, 255,   5, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   6, 186,   0, 255,  12, 186,   0, 255,  18, 186,   0, 255,  26, 186,   0, 255,  31, 186,   0, 255,  38, 186,   0, 255,  45, 186,   0, 255,  51, 186,   0, 255,  58, 186,   0, 255,  64, 186,   0, 255,  70, 186,   0, 255,  78, 186,   0, 255,  84, 186,   0, 255,  90, 186,   0, 255,  97, 186,   0, 255, 103, 186,   0, 255, 109, 186,   0, 255, 117, 186,   0, 255, 122, 186,   0, 255, 130, 186,   0, 255, 135, 186,   0, 255, 142, 186,   0, 255, 148, 186,   0, 255, 155, 186,   0, 255, 161, 186,   0, 255, 168, 186,   0, 255, 174, 186,   0, 255, 180, 186,   0, 255, 187, 186,   0, 255, 193, 186,   0, 255, 200, 186,   0, 255, 205, 186,   0, 255, 211, 186,   0, 255, 217, 186,   0, 255, 222, 186,   0, 255, 227, 186,   0, 255, 232, 186,   0, 255, 234, 186,   0, 255, 235, 186,   0, 255, 234, 186,   0, 255, 231, 186,   0, 255, 227, 186,   0, 255, 222, 186,   0, 255, 217, 186,   0, 255, 211, 186,   0, 255, 205, 186,   0, 255, 199, 186,   0, 255, 193, 186,   0, 255, 187, 186,   0, 255, 180, 186,   0, 255, 174, 186,   0, 255, 168, 186,   0, 255, 162, 186,   0, 255, 155, 186,   0, 255, 149, 186,   0, 255, 142, 186,   0, 255, 135, 186,   0, 255, 129, 186,   0, 255, 123, 186,   0, 255, 117, 186,   0, 255, 110, 186,   0, 255, 103, 186,   0, 255,  97, 186,   0, 255,  90, 186,   0, 255,  84, 186,   0, 255,  78, 186,   0, 255,  71, 186,   0, 255,  65, 186,   0, 255,  58, 186,   0, 255,  51, 186,   0, 255,  45, 186,   0, 255,  38, 186,   0, 255,  32, 186,   0, 255,  25, 186,   0, 255,  18, 186,   0, 255,  12, 186,   0, 255,   6, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   6, 186,   0, 255,  13, 186,   0, 255,  19, 186,   0, 255,  26, 186,   0, 255,  32, 186,   0, 255,  38, 186,   0, 255,  45, 186,   0, 255,  52, 186,   0, 255,  59, 186,   0, 255,  65, 186,   0, 255,  71, 186,   0, 255,  78, 186,   0, 255,  85, 186,   0, 255,  91, 186,   0, 255,  98, 186,   0, 255, 104, 186,   0, 255, 111, 186,   0, 255, 117, 186,   0, 255, 124, 186,   0, 255, 130, 186,   0, 255, 136, 186,   0, 255, 144, 186,   0, 255, 149, 186,   0, 255, 156, 186,   0, 255, 162, 186,   0, 255, 169, 186,   0, 255, 175, 186,   0, 255, 182, 186,   0, 255, 188, 186,   0, 255, 195, 186,   0, 255, 201, 186,   0, 255, 207, 186,   0, 255, 214, 186,   0, 255, 219, 186,   0, 255, 226, 186,   0, 255, 231, 186,   0, 255, 236, 186,   0, 255, 241, 186,   0, 255, 242, 186,   0, 255, 240, 186,   0, 255, 236, 186,   0, 255, 232, 186,   0, 255, 226, 186,   0, 255, 219, 186,   0, 255, 213, 186,   0, 255, 208, 186,   0, 255, 201, 186,   0, 255, 194, 186,   0, 255, 188, 186,   0, 255, 181, 186,   0, 255, 175, 186,   0, 255, 169, 186,   0, 255, 163, 186,   0, 255, 156, 186,   0, 255, 150, 186,   0, 255, 143, 186,   0, 255, 137, 186,   0, 255, 130, 186,   0, 255, 124, 186,   0, 255, 117, 186,   0, 255, 110, 186,   0, 255, 104, 186,   0, 255,  98, 186,   0, 255,  91, 186,   0, 255,  84, 186,   0, 255,  78, 186,   0, 255,  72, 186,   0, 255,  65, 186,   0, 255,  58, 186,   0, 255,  52, 186,   0, 255,  45, 186,   0, 255,  39, 186,   0, 255,  32, 186,   0, 255,  26, 186,   0, 255,  19, 186,   0, 255,  12, 186,   0, 255,   6, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   6, 186,   0, 255,  13, 186,   0, 255,  19, 186,   0, 255,  26, 186,   0, 255,  33, 186,   0, 255,  39, 186,   0, 255,  45, 186,   0, 255,  52, 186,   0, 255,  59, 186,   0, 255,  65, 186,   0, 255,  72, 186,   0, 255,  79, 186,   0, 255,  85, 186,   0, 255,  91, 186,   0, 255,  97, 186,   0, 255, 105, 186,   0, 255, 111, 186,   0, 255, 117, 186,   0, 255, 124, 186,   0, 255, 131, 186,   0, 255, 137, 186,   0, 255, 143, 186,   0, 255, 150, 186,   0, 255, 157, 186,   0, 255, 164, 186,   0, 255, 170, 186,   0, 255, 176, 186,   0, 255, 183, 186,   0, 255, 189, 186,   0, 255, 196, 186,   0, 255, 203, 186,   0, 255, 208, 186,   0, 255, 215, 186,   0, 255, 221, 186,   0, 255, 228, 186,   0, 255, 234, 186,   0, 255, 241, 186,   0, 255, 245, 186,   0, 255, 249, 186,   0, 255, 246, 186,   0, 255, 241, 186,   0, 255, 234, 186,   0, 255, 228, 186,   0, 255, 221, 186,   0, 255, 215, 186,   0, 255, 208, 186,   0, 255, 202, 186,   0, 255, 196, 186,   0, 255, 189, 186,   0, 255, 182, 186,   0, 255, 176, 186,   0, 255, 170, 186,   0, 255, 164, 186,   0, 255, 157, 186,   0, 255, 151, 186,   0, 255, 143, 186,   0, 255, 137, 186,   0, 255, 131, 186,   0, 255, 124, 186,   0, 255, 118, 186,   0, 255, 111, 186,   0, 255, 105, 186,   0, 255,  98, 186,   0, 255,  91, 186,   0, 255,  84, 186,   0, 255,  78, 186,   0, 255,  72, 186,   0, 255,  66, 186,   0, 255,  59, 186,   0, 255,  52, 186,   0, 255,  45, 186,   0, 255,  39, 186,   0, 255,  33, 186,   0, 255,  26, 186,   0, 255,  19, 186,   0, 255,  13, 186,   0, 255,   6, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   6, 186,   0, 255,  13, 186,   0, 255,  20, 186,   0, 255,  26, 186,   0, 255,  33, 186,   0, 255,  40, 186,   0, 255,  46, 186,   0, 255,  53, 186,   0, 255,  59, 186,   0, 255,  66, 186,   0, 255,  72, 186,   0, 255,  78, 186,   0, 255,  85, 186,   0, 255,  91, 186,   0, 255,  99, 186,   0, 255, 104, 186,   0, 255, 111, 186,   0, 255, 118, 186,   0, 255, 124, 186,   0, 255, 131, 186,   0, 255, 137, 186,   0, 255, 144, 186,   0, 255, 150, 186,   0, 255, 157, 186,   0, 255, 163, 186,   0, 255, 170, 186,   0, 255, 176, 186,   0, 255, 183, 186,   0, 255, 190, 186,   0, 255, 196, 186,   0, 255, 203, 186,   0, 255, 210, 186,   0, 255, 215, 186,   0, 255, 223, 186,   0, 255, 229, 186,   0, 255, 235, 186,   0, 255, 242, 186,   0, 255, 248, 186,   0, 255, 255, 186,   0, 255, 248, 186,   0, 255, 242, 186,   0, 255, 235, 186,   0, 255, 228, 186,   0, 255, 223, 186,   0, 255, 215, 186,   0, 255, 209, 186,   0, 255, 202, 186,   0, 255, 196, 186,   0, 255, 189, 186,   0, 255, 183, 186,   0, 255, 177, 186,   0, 255, 170, 186,   0, 255, 164, 186,   0, 255, 157, 186,   0, 255, 151, 186,   0, 255, 143, 186,   0, 255, 138, 186,   0, 255, 130, 186,   0, 255, 125, 186,   0, 255, 118, 186,   0, 255, 111, 186,   0, 255, 105, 186,   0, 255,  98, 186,   0, 255,  91, 186,   0, 255,  85, 186,   0, 255,  78, 186,   0, 255,  72, 186,   0, 255,  65, 186,   0, 255,  59, 186,   0, 255,  52, 186,   0, 255,  46, 186,   0, 255,  39, 186,   0, 255,  33, 186,   0, 255,  26, 186,   0, 255,  19, 186,   0, 255,  13, 186,   0, 255,   7, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   7, 186,   0, 255,  13, 186,   0, 255,  19, 186,   0, 255,  26, 186,   0, 255,  33, 186,   0, 255,  39, 186,   0, 255,  46, 186,   0, 255,  53, 186,   0, 255,  58, 186,   0, 255,  65, 186,   0, 255,  72, 186,   0, 255,  78, 186,   0, 255,  84, 186,   0, 255,  91, 186,   0, 255,  97, 186,   0, 255, 104, 186,   0, 255, 111, 186,   0, 255, 118, 186,   0, 255, 124, 186,   0, 255, 131, 186,   0, 255, 137, 186,   0, 255, 143, 186,   0, 255, 151, 186,   0, 255, 157, 186,   0, 255, 164, 186,   0, 255, 169, 186,   0, 255, 177, 186,   0, 255, 183, 186,   0, 255, 189, 186,   0, 255, 196, 186,   0, 255, 202, 186,   0, 255, 208, 186,   0, 255, 215, 186,   0, 255, 221, 186,   0, 255, 228, 186,   0, 255, 235, 186,   0, 255, 240, 186,   0, 255, 246, 186,   0, 255, 248, 186,   0, 255, 246, 186,   0, 255, 241, 186,   0, 255, 234, 186,   0, 255, 228, 186,   0, 255, 221, 186,   0, 255, 216, 186,   0, 255, 208, 186,   0, 255, 203, 186,   0, 255, 196, 186,   0, 255, 189, 186,   0, 255, 183, 186,   0, 255, 176, 186,   0, 255, 170, 186,   0, 255, 163, 186,   0, 255, 157, 186,   0, 255, 150, 186,   0, 255, 144, 186,   0, 255, 137, 186,   0, 255, 131, 186,   0, 255, 124, 186,   0, 255, 118, 186,   0, 255, 111, 186,   0, 255, 104, 186,   0, 255,  98, 186,   0, 255,  91, 186,   0, 255,  85, 186,   0, 255,  78, 186,   0, 255,  72, 186,   0, 255,  65, 186,   0, 255,  59, 186,   0, 255,  52, 186,   0, 255,  46, 186,   0, 255,  39, 186,   0, 255,  33, 186,   0, 255,  26, 186,   0, 255,  20, 186,   0, 255,  13, 186,   0, 255,   7, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   6, 186,   0, 255,  12, 186,   0, 255,  19, 186,   0, 255,  26, 186,   0, 255,  32, 186,   0, 255,  39, 186,   0, 255,  46, 186,   0, 255,  52, 186,   0, 255,  58, 186,   0, 255,  65, 186,   0, 255,  71, 186,   0, 255,  78, 186,   0, 255,  84, 186,   0, 255,  92, 186,   0, 255,  97, 186,   0, 255, 104, 186,   0, 255, 110, 186,   0, 255, 117, 186,   0, 255, 124, 186,   0, 255, 130, 186,   0, 255, 137, 186,   0, 255, 143, 186,   0, 255, 150, 186,   0, 255, 156, 186,   0, 255, 163, 186,   0, 255, 169, 186,   0, 255, 175, 186,   0, 255, 182, 186,   0, 255, 188, 186,   0, 255, 195, 186,   0, 255, 202, 186,   0, 255, 207, 186,   0, 255, 214, 186,   0, 255, 219, 186,   0, 255, 226, 186,   0, 255, 231, 186,   0, 255, 236, 186,   0, 255, 240, 186,   0, 255, 242, 186,   0, 255, 240, 186,   0, 255, 236, 186,   0, 255, 231, 186,   0, 255, 226, 186,   0, 255, 220, 186,   0, 255, 214, 186,   0, 255, 208, 186,   0, 255, 201, 186,   0, 255, 194, 186,   0, 255, 188, 186,   0, 255, 182, 186,   0, 255, 176, 186,   0, 255, 169, 186,   0, 255, 163, 186,   0, 255, 156, 186,   0, 255, 149, 186,   0, 255, 143, 186,   0, 255, 137, 186,   0, 255, 130, 186,   0, 255, 123, 186,   0, 255, 118, 186,   0, 255, 111, 186,   0, 255, 104, 186,   0, 255,  98, 186,   0, 255,  91, 186,   0, 255,  85, 186,   0, 255,  78, 186,   0, 255,  72, 186,   0, 255,  65, 186,   0, 255,  58, 186,   0, 255,  52, 186,   0, 255,  45, 186,   0, 255,  38, 186,   0, 255,  33, 186,   0, 255,  25, 186,   0, 255,  19, 186,   0, 255,  13, 186,   0, 255,   7, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   6, 186,   0, 255,  12, 186,   0, 255,  19, 186,   0, 255,  26, 186,   0, 255,  32, 186,   0, 255,  39, 186,   0, 255,  45, 186,   0, 255,  51, 186,   0, 255,  58, 186,   0, 255,  65, 186,   0, 255,  70, 186,   0, 255,  78, 186,   0, 255,  84, 186,   0, 255,  91, 186,   0, 255,  97, 186,   0, 255, 103, 186,   0, 255, 109, 186,   0, 255, 117, 186,   0, 255, 122, 186,   0, 255, 129, 186,   0, 255, 136, 186,   0, 255, 142, 186,   0, 255, 148, 186,   0, 255, 155, 186,   0, 255, 161, 186,   0, 255, 168, 186,   0, 255, 175, 186,   0, 255, 180, 186,   0, 255, 187, 186,   0, 255, 193, 186,   0, 255, 199, 186,   0, 255, 205, 186,   0, 255, 212, 186,   0, 255, 217, 186,   0, 255, 223, 186,   0, 255, 227, 186,   0, 255, 231, 186,   0, 255, 234, 186,   0, 255, 235, 186,   0, 255, 234, 186,   0, 255, 232, 186,   0, 255, 227, 186,   0, 255, 223, 186,   0, 255, 217, 186,   0, 255, 212, 186,   0, 255, 206, 186,   0, 255, 199, 186,   0, 255, 193, 186,   0, 255, 187, 186,   0, 255, 181, 186,   0, 255, 175, 186,   0, 255, 167, 186,   0, 255, 161, 186,   0, 255, 155, 186,   0, 255, 149, 186,   0, 255, 142, 186,   0, 255, 136, 186,   0, 255, 129, 186,   0, 255, 123, 186,   0, 255, 117, 186,   0, 255, 110, 186,   0, 255, 103, 186,   0, 255,  97, 186,   0, 255,  91, 186,   0, 255,  84, 186,   0, 255,  77, 186,   0, 255,  71, 186,   0, 255,  64, 186,   0, 255,  58, 186,   0, 255,  52, 186,   0, 255,  44, 186,   0, 255,  39, 186,   0, 255,  31, 186,   0, 255,  25, 186,   0, 255,  19, 186,   0, 255,  12, 186,   0, 255,   5, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   6, 186,   0, 255,  11, 186,   0, 255,  18, 186,   0, 255,  25, 186,   0, 255,  31, 186,   0, 255,  38, 186,   0, 255,  45, 186,   0, 255,  51, 186,   0, 255,  57, 186,   0, 255,  63, 186,   0, 255,  70, 186,   0, 255,  76, 186,   0, 255,  83, 186,   0, 255,  89, 186,   0, 255,  96, 186,   0, 255, 102, 186,   0, 255, 109, 186,   0, 255, 115, 186,   0, 255, 122, 186,   0, 255, 128, 186,   0, 255, 134, 186,   0, 255, 141, 186,   0, 255, 147, 186,   0, 255, 154, 186,   0, 255, 160, 186,   0, 255, 166, 186,   0, 255, 172, 186,   0, 255, 178, 186,   0, 255, 185, 186,   0, 255, 190, 186,   0, 255, 197, 186,   0, 255, 202, 186,   0, 255, 208, 186,   0, 255, 213, 186,   0, 255, 218, 186,   0, 255, 223, 186,   0, 255, 226, 186,   0, 255, 228, 186,   0, 255, 228, 186,   0, 255, 229, 186,   0, 255, 226, 186,   0, 255, 222, 186,   0, 255, 218, 186,   0, 255, 213, 186,   0, 255, 208, 186,   0, 255, 202, 186,   0, 255, 197, 186,   0, 255, 191, 186,   0, 255, 185, 186,   0, 255, 178, 186,   0, 255, 172, 186,   0, 255, 166, 186,   0, 255, 159, 186,   0, 255, 154, 186,   0, 255, 147, 186,   0, 255, 141, 186,   0, 255, 134, 186,   0, 255, 128, 186,   0, 255, 121, 186,   0, 255, 116, 186,   0, 255, 109, 186,   0, 255, 103, 186,   0, 255,  96, 186,   0, 255,  90, 186,   0, 255,  83, 186,   0, 255,  77, 186,   0, 255,  70, 186,   0, 255,  63, 186,   0, 255,  57, 186,   0, 255,  51, 186,   0, 255,  44, 186,   0, 255,  38, 186,   0, 255,  31, 186,   0, 255,  25, 186,   0, 255,  18, 186,   0, 255,  11, 186,   0, 255,   5, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   4, 186,   0, 255,  10, 186,   0, 255,  17, 186,   0, 255,  24, 186,   0, 255,  30, 186,   0, 255,  37, 186,   0, 255,  43, 186,   0, 255,  50, 186,   0, 255,  56, 186,   0, 255,  62, 186,   0, 255,  69, 186,   0, 255,  75, 186,   0, 255,  82, 186,   0, 255,  89, 186,   0, 255,  95, 186,   0, 255, 101, 186,   0, 255, 107, 186,   0, 255, 114, 186,   0, 255, 120, 186,   0, 255, 127, 186,   0, 255, 133, 186,   0, 255, 139, 186,   0, 255, 146, 186,   0, 255, 151, 186,   0, 255, 157, 186,   0, 255, 164, 186,   0, 255, 170, 186,   0, 255, 176, 186,   0, 255, 182, 186,   0, 255, 188, 186,   0, 255, 193, 186,   0, 255, 198, 186,   0, 255, 204, 186,   0, 255, 209, 186,   0, 255, 213, 186,   0, 255, 217, 186,   0, 255, 220, 186,   0, 255, 222, 186,   0, 255, 222, 186,   0, 255, 222, 186,   0, 255, 220, 186,   0, 255, 217, 186,   0, 255, 213, 186,   0, 255, 208, 186,   0, 255, 204, 186,   0, 255, 199, 186,   0, 255, 193, 186,   0, 255, 188, 186,   0, 255, 182, 186,   0, 255, 176, 186,   0, 255, 170, 186,   0, 255, 164, 186,   0, 255, 158, 186,   0, 255, 152, 186,   0, 255, 146, 186,   0, 255, 139, 186,   0, 255, 133, 186,   0, 255, 127, 186,   0, 255, 121, 186,   0, 255, 114, 186,   0, 255, 108, 186,   0, 255, 101, 186,   0, 255,  95, 186,   0, 255,  89, 186,   0, 255,  82, 186,   0, 255,  75, 186,   0, 255,  69, 186,   0, 255,  62, 186,   0, 255,  56, 186,   0, 255,  50, 186,   0, 255,  43, 186,   0, 255,  37, 186,   0, 255,  30, 186,   0, 255,  24, 186,   0, 255,  18, 186,   0, 255,  11, 186,   0, 255,   4, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,  10, 186,   0, 255,  16, 186,   0, 255,  23, 186,   0, 255,  29, 186,   0, 255,  35, 186,   0, 255,  43, 186,   0, 255,  49, 186,   0, 255,  55, 186,   0, 255,  61, 186,   0, 255,  68, 186,   0, 255,  75, 186,   0, 255,  81, 186,   0, 255,  87, 186,   0, 255,  93, 186,   0, 255, 100, 186,   0, 255, 106, 186,   0, 255, 112, 186,   0, 255, 119, 186,   0, 255, 125, 186,   0, 255, 131, 186,   0, 255, 137, 186,   0, 255, 144, 186,   0, 255, 150, 186,   0, 255, 155, 186,   0, 255, 161, 186,   0, 255, 167, 186,   0, 255, 173, 186,   0, 255, 179, 186,   0, 255, 184, 186,   0, 255, 189, 186,   0, 255, 195, 186,   0, 255, 200, 186,   0, 255, 204, 186,   0, 255, 208, 186,   0, 255, 211, 186,   0, 255, 213, 186,   0, 255, 215, 186,   0, 255, 216, 186,   0, 255, 215, 186,   0, 255, 214, 186,   0, 255, 211, 186,   0, 255, 208, 186,   0, 255, 204, 186,   0, 255, 200, 186,   0, 255, 195, 186,   0, 255, 190, 186,   0, 255, 184, 186,   0, 255, 179, 186,   0, 255, 174, 186,   0, 255, 168, 186,   0, 255, 162, 186,   0, 255, 155, 186,   0, 255, 150, 186,   0, 255, 143, 186,   0, 255, 137, 186,   0, 255, 131, 186,   0, 255, 124, 186,   0, 255, 118, 186,   0, 255, 113, 186,   0, 255, 106, 186,   0, 255, 100, 186,   0, 255,  93, 186,   0, 255,  86, 186,   0, 255,  80, 186,   0, 255,  75, 186,   0, 255,  68, 186,   0, 255,  61, 186,   0, 255,  55, 186,   0, 255,  48, 186,   0, 255,  42, 186,   0, 255,  35, 186,   0, 255,  30, 186,   0, 255,  23, 186,   0, 255,  16, 186,   0, 255,  10, 186,   0, 255,   3, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   9, 186,   0, 255,  15, 186,   0, 255,  22, 186,   0, 255,  28, 186,   0, 255,  34, 186,   0, 255,  41, 186,   0, 255,  47, 186,   0, 255,  53, 186,   0, 255,  60, 186,   0, 255,  66, 186,   0, 255,  73, 186,   0, 255,  79, 186,   0, 255,  85, 186,   0, 255,  91, 186,   0, 255,  98, 186,   0, 255, 104, 186,   0, 255, 111, 186,   0, 255, 116, 186,   0, 255, 123, 186,   0, 255, 129, 186,   0, 255, 135, 186,   0, 255, 141, 186,   0, 255, 147, 186,   0, 255, 153, 186,   0, 255, 158, 186,   0, 255, 165, 186,   0, 255, 170, 186,   0, 255, 175, 186,   0, 255, 180, 186,   0, 255, 186, 186,   0, 255, 190, 186,   0, 255, 194, 186,   0, 255, 199, 186,   0, 255, 202, 186,   0, 255, 205, 186,   0, 255, 207, 186,   0, 255, 209, 186,   0, 255, 209, 186,   0, 255, 209, 186,   0, 255, 207, 186,   0, 255, 206, 186,   0, 255, 203, 186,   0, 255, 199, 186,   0, 255, 194, 186,   0, 255, 190, 186,   0, 255, 186, 186,   0, 255, 181, 186,   0, 255, 176, 186,   0, 255, 170, 186,   0, 255, 164, 186,   0, 255, 158, 186,   0, 255, 153, 186,   0, 255, 147, 186,   0, 255, 141, 186,   0, 255, 135, 186,   0, 255, 128, 186,   0, 255, 122, 186,   0, 255, 117, 186,   0, 255, 110, 186,   0, 255, 104, 186,   0, 255,  98, 186,   0, 255,  91, 186,   0, 255,  85, 186,   0, 255,  79, 186,   0, 255,  72, 186,   0, 255,  67, 186,   0, 255,  60, 186,   0, 255,  53, 186,   0, 255,  47, 186,   0, 255,  41, 186,   0, 255,  34, 186,   0, 255,  28, 186,   0, 255,  22, 186,   0, 255,  15, 186,   0, 255,   8, 186,   0, 255,   2, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   8, 186,   0, 255,  13, 186,   0, 255,  21, 186,   0, 255,  26, 186,   0, 255,  33, 186,   0, 255,  39, 186,   0, 255,  45, 186,   0, 255,  52, 186,   0, 255,  58, 186,   0, 255,  65, 186,   0, 255,  71, 186,   0, 255,  77, 186,   0, 255,  83, 186,   0, 255,  90, 186,   0, 255,  96, 186,   0, 255, 102, 186,   0, 255, 108, 186,   0, 255, 114, 186,   0, 255, 120, 186,   0, 255, 126, 186,   0, 255, 132, 186,   0, 255, 138, 186,   0, 255, 144, 186,   0, 255, 149, 186,   0, 255, 155, 186,   0, 255, 160, 186,   0, 255, 166, 186,   0, 255, 171, 186,   0, 255, 176, 186,   0, 255, 181, 186,   0, 255, 185, 186,   0, 255, 189, 186,   0, 255, 193, 186,   0, 255, 197, 186,   0, 255, 199, 186,   0, 255, 201, 186,   0, 255, 202, 186,   0, 255, 203, 186,   0, 255, 203, 186,   0, 255, 201, 186,   0, 255, 199, 186,   0, 255, 197, 186,   0, 255, 194, 186,   0, 255, 190, 186,   0, 255, 185, 186,   0, 255, 181, 186,   0, 255, 176, 186,   0, 255, 171, 186,   0, 255, 166, 186,   0, 255, 160, 186,   0, 255, 155, 186,   0, 255, 149, 186,   0, 255, 144, 186,   0, 255, 138, 186,   0, 255, 132, 186,   0, 255, 126, 186,   0, 255, 120, 186,   0, 255, 114, 186,   0, 255, 108, 186,   0, 255, 102, 186,   0, 255,  96, 186,   0, 255,  89, 186,   0, 255,  83, 186,   0, 255,  77, 186,   0, 255,  71, 186,   0, 255,  65, 186,   0, 255,  58, 186,   0, 255,  52, 186,   0, 255,  46, 186,   0, 255,  40, 186,   0, 255,  33, 186,   0, 255,  26, 186,   0, 255,  21, 186,   0, 255,  14, 186,   0, 255,   8, 186,   0, 255,   1, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   6, 186,   0, 255,  12, 186,   0, 255,  18, 186,   0, 255,  25, 186,   0, 255,  32, 186,   0, 255,  38, 186,   0, 255,  44, 186,   0, 255,  50, 186,   0, 255,  56, 186,   0, 255,  63, 186,   0, 255,  69, 186,   0, 255,  75, 186,   0, 255,  81, 186,   0, 255,  87, 186,   0, 255,  93, 186,   0, 255, 100, 186,   0, 255, 106, 186,   0, 255, 112, 186,   0, 255, 118, 186,   0, 255, 123, 186,   0, 255, 129, 186,   0, 255, 135, 186,   0, 255, 141, 186,   0, 255, 146, 186,   0, 255, 151, 186,   0, 255, 157, 186,   0, 255, 162, 186,   0, 255, 167, 186,   0, 255, 171, 186,   0, 255, 176, 186,   0, 255, 181, 186,   0, 255, 184, 186,   0, 255, 188, 186,   0, 255, 191, 186,   0, 255, 192, 186,   0, 255, 194, 186,   0, 255, 196, 186,   0, 255, 196, 186,   0, 255, 196, 186,   0, 255, 195, 186,   0, 255, 193, 186,   0, 255, 191, 186,   0, 255, 187, 186,   0, 255, 184, 186,   0, 255, 180, 186,   0, 255, 177, 186,   0, 255, 171, 186,   0, 255, 167, 186,   0, 255, 162, 186,   0, 255, 157, 186,   0, 255, 151, 186,   0, 255, 146, 186,   0, 255, 141, 186,   0, 255, 134, 186,   0, 255, 129, 186,   0, 255, 124, 186,   0, 255, 118, 186,   0, 255, 112, 186,   0, 255, 106, 186,   0, 255, 100, 186,   0, 255,  93, 186,   0, 255,  87, 186,   0, 255,  82, 186,   0, 255,  75, 186,   0, 255,  69, 186,   0, 255,  63, 186,   0, 255,  56, 186,   0, 255,  50, 186,   0, 255,  44, 186,   0, 255,  38, 186,   0, 255,  31, 186,   0, 255,  25, 186,   0, 255,  19, 186,   0, 255,  12, 186,   0, 255,   6, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   5, 186,   0, 255,  11, 186,   0, 255,  17, 186,   0, 255,  23, 186,   0, 255,  29, 186,   0, 255,  36, 186,   0, 255,  42, 186,   0, 255,  48, 186,   0, 255,  54, 186,   0, 255,  61, 186,   0, 255,  67, 186,   0, 255,  73, 186,   0, 255,  79, 186,   0, 255,  85, 186,   0, 255,  91, 186,   0, 255,  97, 186,   0, 255, 103, 186,   0, 255, 109, 186,   0, 255, 115, 186,   0, 255, 120, 186,   0, 255, 126, 186,   0, 255, 131, 186,   0, 255, 137, 186,   0, 255, 142, 186,   0, 255, 147, 186,   0, 255, 152, 186,   0, 255, 158, 186,   0, 255, 163, 186,   0, 255, 167, 186,   0, 255, 172, 186,   0, 255, 175, 186,   0, 255, 179, 186,   0, 255, 182, 186,   0, 255, 184, 186,   0, 255, 187, 186,   0, 255, 188, 186,   0, 255, 189, 186,   0, 255, 190, 186,   0, 255, 189, 186,   0, 255, 189, 186,   0, 255, 187, 186,   0, 255, 185, 186,   0, 255, 182, 186,   0, 255, 178, 186,   0, 255, 175, 186,   0, 255, 171, 186,   0, 255, 167, 186,   0, 255, 163, 186,   0, 255, 158, 186,   0, 255, 153, 186,   0, 255, 148, 186,   0, 255, 142, 186,   0, 255, 137, 186,   0, 255, 132, 186,   0, 255, 126, 186,   0, 255, 121, 186,   0, 255, 115, 186,   0, 255, 109, 186,   0, 255, 102, 186,   0, 255,  97, 186,   0, 255,  91, 186,   0, 255,  85, 186,   0, 255,  79, 186,   0, 255,  72, 186,   0, 255,  66, 186,   0, 255,  61, 186,   0, 255,  54, 186,   0, 255,  48, 186,   0, 255,  42, 186,   0, 255,  36, 186,   0, 255,  30, 186,   0, 255,  24, 186,   0, 255,  17, 186,   0, 255,  11, 186,   0, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   8, 186,   0, 255,  15, 186,   0, 255,  21, 186,   0, 255,  27, 186,   0, 255,  34, 186,   0, 255,  40, 186,   0, 255,  46, 186,   0, 255,  52, 186,   0, 255,  58, 186,   0, 255,  64, 186,   0, 255,  70, 186,   0, 255,  76, 186,   0, 255,  82, 186,   0, 255,  89, 186,   0, 255,  94, 186,   0, 255, 100, 186,   0, 255, 106, 186,   0, 255, 111, 186,   0, 255, 117, 186,   0, 255, 122, 186,   0, 255, 128, 186,   0, 255, 134, 186,   0, 255, 138, 186,   0, 255, 143, 186,   0, 255, 149, 186,   0, 255, 153, 186,   0, 255, 158, 186,   0, 255, 162, 186,   0, 255, 166, 186,   0, 255, 170, 186,   0, 255, 173, 186,   0, 255, 176, 186,   0, 255, 178, 186,   0, 255, 181, 186,   0, 255, 182, 186,   0, 255, 183, 186,   0, 255, 183, 186,   0, 255, 183, 186,   0, 255, 182, 186,   0, 255, 181, 186,   0, 255, 178, 186,   0, 255, 176, 186,   0, 255, 173, 186,   0, 255, 169, 186,   0, 255, 166, 186,   0, 255, 162, 186,   0, 255, 157, 186,   0, 255, 153, 186,   0, 255, 149, 186,   0, 255, 143, 186,   0, 255, 138, 186,   0, 255, 133, 186,   0, 255, 128, 186,   0, 255, 122, 186,   0, 255, 117, 186,   0, 255, 112, 186,   0, 255, 106, 186,   0, 255, 100, 186,   0, 255,  94, 186,   0, 255,  89, 186,   0, 255,  82, 186,   0, 255,  77, 186,   0, 255,  70, 186,   0, 255,  64, 186,   0, 255,  58, 186,   0, 255,  52, 186,   0, 255,  47, 186,   0, 255,  40, 186,   0, 255,  34, 186,   0, 255,  28, 186,   0, 255,  22, 186,   0, 255,  15, 186,   0, 255,   9, 186,   0, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   7, 186,   0, 255,  13, 186,   0, 255,  20, 186,   0, 255,  26, 186,   0, 255,  32, 186,   0, 255,  38, 186,   0, 255,  44, 186,   0, 255,  50, 186,   0, 255,  56, 186,   0, 255,  62, 186,   0, 255,  68, 186,   0, 255,  73, 186,   0, 255,  79, 186,   0, 255,  86, 186,   0, 255,  92, 186,   0, 255,  96, 186,   0, 255, 102, 186,   0, 255, 108, 186,   0, 255, 114, 186,   0, 255, 119, 186,   0, 255, 125, 186,   0, 255, 129, 186,   0, 255, 134, 186,   0, 255, 139, 186,   0, 255, 144, 186,   0, 255, 148, 186,   0, 255, 153, 186,   0, 255, 157, 186,   0, 255, 161, 186,   0, 255, 164, 186,   0, 255, 167, 186,   0, 255, 170, 186,   0, 255, 172, 186,   0, 255, 174, 186,   0, 255, 175, 186,   0, 255, 177, 186,   0, 255, 177, 186,   0, 255, 176, 186,   0, 255, 176, 186,   0, 255, 174, 186,   0, 255, 172, 186,   0, 255, 170, 186,   0, 255, 168, 186,   0, 255, 164, 186,   0, 255, 161, 186,   0, 255, 157, 186,   0, 255, 152, 186,   0, 255, 148, 186,   0, 255, 144, 186,   0, 255, 139, 186,   0, 255, 134, 186,   0, 255, 129, 186,   0, 255, 124, 186,   0, 255, 119, 186,   0, 255, 113, 186,   0, 255, 108, 186,   0, 255, 103, 186,   0, 255,  97, 186,   0, 255,  91, 186,   0, 255,  86, 186,   0, 255,  79, 186,   0, 255,  74, 186,   0, 255,  68, 186,   0, 255,  62, 186,   0, 255,  55, 186,   0, 255,  50, 186,   0, 255,  44, 186,   0, 255,  38, 186,   0, 255,  32, 186,   0, 255,  26, 186,   0, 255,  19, 186,   0, 255,  13, 186,   0, 255,   7, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   5, 186,   0, 255,  10, 186,   0, 255,  17, 186,   0, 255,  23, 186,   0, 255,  29, 186,   0, 255,  36, 186,   0, 255,  41, 186,   0, 255,  47, 186,   0, 255,  54, 186,   0, 255,  59, 186,   0, 255,  65, 186,   0, 255,  71, 186,   0, 255,  76, 186,   0, 255,  82, 186,   0, 255,  88, 186,   0, 255,  93, 186,   0, 255, 100, 186,   0, 255, 104, 186,   0, 255, 110, 186,   0, 255, 115, 186,   0, 255, 120, 186,   0, 255, 126, 186,   0, 255, 130, 186,   0, 255, 134, 186,   0, 255, 139, 186,   0, 255, 143, 186,   0, 255, 148, 186,   0, 255, 151, 186,   0, 255, 155, 186,   0, 255, 158, 186,   0, 255, 161, 186,   0, 255, 164, 186,   0, 255, 166, 186,   0, 255, 167, 186,   0, 255, 169, 186,   0, 255, 170, 186,   0, 255, 170, 186,   0, 255, 170, 186,   0, 255, 169, 186,   0, 255, 167, 186,   0, 255, 166, 186,   0, 255, 164, 186,   0, 255, 161, 186,   0, 255, 158, 186,   0, 255, 156, 186,   0, 255, 151, 186,   0, 255, 148, 186,   0, 255, 144, 186,   0, 255, 139, 186,   0, 255, 135, 186,   0, 255, 130, 186,   0, 255, 125, 186,   0, 255, 120, 186,   0, 255, 115, 186,   0, 255, 110, 186,   0, 255, 104, 186,   0, 255,  99, 186,   0, 255,  93, 186,   0, 255,  88, 186,   0, 255,  82, 186,   0, 255,  77, 186,   0, 255,  70, 186,   0, 255,  65, 186,   0, 255,  59, 186,   0, 255,  53, 186,   0, 255,  47, 186,   0, 255,  42, 186,   0, 255,  35, 186,   0, 255,  29, 186,   0, 255,  24, 186,   0, 255,  17, 186,   0, 255,  11, 186,   0, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   2, 186,   0, 255,   9, 186,   0, 255,  15, 186,   0, 255,  21, 186,   0, 255,  27, 186,   0, 255,  33, 186,   0, 255,  39, 186,   0, 255,  45, 186,   0, 255,  50, 186,   0, 255,  56, 186,   0, 255,  62, 186,   0, 255,  68, 186,   0, 255,  73, 186,   0, 255,  79, 186,   0, 255,  85, 186,   0, 255,  90, 186,   0, 255,  96, 186,   0, 255, 100, 186,   0, 255, 106, 186,   0, 255, 111, 186,   0, 255, 116, 186,   0, 255, 121, 186,   0, 255, 126, 186,   0, 255, 130, 186,   0, 255, 134, 186,   0, 255, 139, 186,   0, 255, 143, 186,   0, 255, 146, 186,   0, 255, 149, 186,   0, 255, 152, 186,   0, 255, 155, 186,   0, 255, 158, 186,   0, 255, 160, 186,   0, 255, 161, 186,   0, 255, 163, 186,   0, 255, 163, 186,   0, 255, 163, 186,   0, 255, 164, 186,   0, 255, 163, 186,   0, 255, 162, 186,   0, 255, 160, 186,   0, 255, 158, 186,   0, 255, 155, 186,   0, 255, 152, 186,   0, 255, 149, 186,   0, 255, 146, 186,   0, 255, 143, 186,   0, 255, 139, 186,   0, 255, 135, 186,   0, 255, 130, 186,   0, 255, 126, 186,   0, 255, 120, 186,   0, 255, 116, 186,   0, 255, 111, 186,   0, 255, 106, 186,   0, 255, 101, 186,   0, 255,  95, 186,   0, 255,  90, 186,   0, 255,  85, 186,   0, 255,  79, 186,   0, 255,  73, 186,   0, 255,  68, 186,   0, 255,  62, 186,   0, 255,  56, 186,   0, 255,  50, 186,   0, 255,  44, 186,   0, 255,  39, 186,   0, 255,  32, 186,   0, 255,  27, 186,   0, 255,  21, 186,   0, 255,  15, 186,   0, 255,   8, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   6, 186,   0, 255,  12, 186,   0, 255,  18, 186,   0, 255,  24, 186,   0, 255,  30, 186,   0, 255,  36, 186,   0, 255,  41, 186,   0, 255,  48, 186,   0, 255,  53, 186,   0, 255,  58, 186,   0, 255,  65, 186,   0, 255,  70, 186,   0, 255,  75, 186,   0, 255,  81, 186,   0, 255,  86, 186,   0, 255,  91, 186,   0, 255,  96, 186,   0, 255, 102, 186,   0, 255, 107, 186,   0, 255, 111, 186,   0, 255, 116, 186,   0, 255, 121, 186,   0, 255, 125, 186,   0, 255, 129, 186,   0, 255, 133, 186,   0, 255, 137, 186,   0, 255, 140, 186,   0, 255, 143, 186,   0, 255, 147, 186,   0, 255, 150, 186,   0, 255, 152, 186,   0, 255, 154, 186,   0, 255, 155, 186,   0, 255, 156, 186,   0, 255, 157, 186,   0, 255, 157, 186,   0, 255, 157, 186,   0, 255, 156, 186,   0, 255, 155, 186,   0, 255, 153, 186,   0, 255, 152, 186,   0, 255, 149, 186,   0, 255, 147, 186,   0, 255, 144, 186,   0, 255, 141, 186,   0, 255, 137, 186,   0, 255, 133, 186,   0, 255, 130, 186,   0, 255, 125, 186,   0, 255, 121, 186,   0, 255, 116, 186,   0, 255, 111, 186,   0, 255, 107, 186,   0, 255, 101, 186,   0, 255,  97, 186,   0, 255,  92, 186,   0, 255,  86, 186,   0, 255,  81, 186,   0, 255,  75, 186,   0, 255,  70, 186,   0, 255,  65, 186,   0, 255,  59, 186,   0, 255,  53, 186,   0, 255,  47, 186,   0, 255,  42, 186,   0, 255,  36, 186,   0, 255,  29, 186,   0, 255,  24, 186,   0, 255,  18, 186,   0, 255,  12, 186,   0, 255,   6, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   4, 186,   0, 255,   9, 186,   0, 255,  15, 186,   0, 255,  21, 186,   0, 255,  27, 186,   0, 255,  33, 186,   0, 255,  38, 186,   0, 255,  44, 186,   0, 255,  50, 186,   0, 255,  56, 186,   0, 255,  61, 186,   0, 255,  67, 186,   0, 255,  72, 186,   0, 255,  77, 186,   0, 255,  82, 186,   0, 255,  88, 186,   0, 255,  93, 186,   0, 255,  98, 186,   0, 255, 103, 186,   0, 255, 107, 186,   0, 255, 111, 186,   0, 255, 116, 186,   0, 255, 120, 186,   0, 255, 125, 186,   0, 255, 128, 186,   0, 255, 132, 186,   0, 255, 135, 186,   0, 255, 138, 186,   0, 255, 141, 186,   0, 255, 144, 186,   0, 255, 145, 186,   0, 255, 147, 186,   0, 255, 148, 186,   0, 255, 149, 186,   0, 255, 150, 186,   0, 255, 150, 186,   0, 255, 150, 186,   0, 255, 150, 186,   0, 255, 148, 186,   0, 255, 147, 186,   0, 255, 145, 186,   0, 255, 143, 186,   0, 255, 141, 186,   0, 255, 138, 186,   0, 255, 135, 186,   0, 255, 131, 186,   0, 255, 128, 186,   0, 255, 125, 186,   0, 255, 120, 186,   0, 255, 116, 186,   0, 255, 111, 186,   0, 255, 107, 186,   0, 255, 103, 186,   0, 255,  98, 186,   0, 255,  93, 186,   0, 255,  87, 186,   0, 255,  82, 186,   0, 255,  77, 186,   0, 255,  72, 186,   0, 255,  67, 186,   0, 255,  61, 186,   0, 255,  55, 186,   0, 255,  50, 186,   0, 255,  44, 186,   0, 255,  38, 186,   0, 255,  33, 186,   0, 255,  27, 186,   0, 255,  21, 186,   0, 255,  15, 186,   0, 255,   9, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   7, 186,   0, 255,  12, 186,   0, 255,  18, 186,   0, 255,  24, 186,   0, 255,  30, 186,   0, 255,  35, 186,   0, 255,  41, 186,   0, 255,  47, 186,   0, 255,  52, 186,   0, 255,  57, 186,   0, 255,  62, 186,   0, 255,  68, 186,   0, 255,  74, 186,   0, 255,  78, 186,   0, 255,  83, 186,   0, 255,  88, 186,   0, 255,  93, 186,   0, 255,  98, 186,   0, 255, 103, 186,   0, 255, 107, 186,   0, 255, 111, 186,   0, 255, 115, 186,   0, 255, 119, 186,   0, 255, 123, 186,   0, 255, 126, 186,   0, 255, 129, 186,   0, 255, 132, 186,   0, 255, 135, 186,   0, 255, 137, 186,   0, 255, 139, 186,   0, 255, 141, 186,   0, 255, 142, 186,   0, 255, 143, 186,   0, 255, 143, 186,   0, 255, 144, 186,   0, 255, 144, 186,   0, 255, 143, 186,   0, 255, 142, 186,   0, 255, 140, 186,   0, 255, 139, 186,   0, 255, 137, 186,   0, 255, 134, 186,   0, 255, 132, 186,   0, 255, 129, 186,   0, 255, 126, 186,   0, 255, 123, 186,   0, 255, 119, 186,   0, 255, 115, 186,   0, 255, 111, 186,   0, 255, 106, 186,   0, 255, 102, 186,   0, 255,  97, 186,   0, 255,  93, 186,   0, 255,  89, 186,   0, 255,  84, 186,   0, 255,  79, 186,   0, 255,  74, 186,   0, 255,  68, 186,   0, 255,  63, 186,   0, 255,  58, 186,   0, 255,  52, 186,   0, 255,  47, 186,   0, 255,  41, 186,   0, 255,  36, 186,   0, 255,  29, 186,   0, 255,  23, 186,   0, 255,  18, 186,   0, 255,  12, 186,   0, 255,   6, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   9, 186,   0, 255,  14, 186,   0, 255,  21, 186,   0, 255,  26, 186,   0, 255,  31, 186,   0, 255,  37, 186,   0, 255,  43, 186,   0, 255,  48, 186,   0, 255,  54, 186,   0, 255,  59, 186,   0, 255,  64, 186,   0, 255,  69, 186,   0, 255,  74, 186,   0, 255,  79, 186,   0, 255,  84, 186,   0, 255,  88, 186,   0, 255,  94, 186,   0, 255,  98, 186,   0, 255, 102, 186,   0, 255, 106, 186,   0, 255, 110, 186,   0, 255, 114, 186,   0, 255, 117, 186,   0, 255, 120, 186,   0, 255, 123, 186,   0, 255, 126, 186,   0, 255, 129, 186,   0, 255, 131, 186,   0, 255, 133, 186,   0, 255, 134, 186,   0, 255, 136, 186,   0, 255, 136, 186,   0, 255, 137, 186,   0, 255, 137, 186,   0, 255, 137, 186,   0, 255, 137, 186,   0, 255, 136, 186,   0, 255, 134, 186,   0, 255, 132, 186,   0, 255, 131, 186,   0, 255, 128, 186,   0, 255, 126, 186,   0, 255, 123, 186,   0, 255, 121, 186,   0, 255, 117, 186,   0, 255, 114, 186,   0, 255, 110, 186,   0, 255, 106, 186,   0, 255, 101, 186,   0, 255,  98, 186,   0, 255,  93, 186,   0, 255,  89, 186,   0, 255,  83, 186,   0, 255,  79, 186,   0, 255,  74, 186,   0, 255,  69, 186,   0, 255,  65, 186,   0, 255,  59, 186,   0, 255,  54, 186,   0, 255,  48, 186,   0, 255,  43, 186,   0, 255,  37, 186,   0, 255,  32, 186,   0, 255,  27, 186,   0, 255,  20, 186,   0, 255,  15, 186,   0, 255,  10, 186,   0, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   6, 186,   0, 255,  11, 186,   0, 255,  17, 186,   0, 255,  23, 186,   0, 255,  29, 186,   0, 255,  34, 186,   0, 255,  39, 186,   0, 255,  44, 186,   0, 255,  50, 186,   0, 255,  55, 186,   0, 255,  60, 186,   0, 255,  65, 186,   0, 255,  70, 186,   0, 255,  74, 186,   0, 255,  79, 186,   0, 255,  84, 186,   0, 255,  88, 186,   0, 255,  92, 186,   0, 255,  97, 186,   0, 255, 100, 186,   0, 255, 105, 186,   0, 255, 108, 186,   0, 255, 112, 186,   0, 255, 114, 186,   0, 255, 118, 186,   0, 255, 120, 186,   0, 255, 122, 186,   0, 255, 124, 186,   0, 255, 127, 186,   0, 255, 128, 186,   0, 255, 129, 186,   0, 255, 130, 186,   0, 255, 130, 186,   0, 255, 130, 186,   0, 255, 131, 186,   0, 255, 130, 186,   0, 255, 129, 186,   0, 255, 128, 186,   0, 255, 127, 186,   0, 255, 125, 186,   0, 255, 123, 186,   0, 255, 120, 186,   0, 255, 118, 186,   0, 255, 115, 186,   0, 255, 111, 186,   0, 255, 108, 186,   0, 255, 105, 186,   0, 255, 101, 186,   0, 255,  97, 186,   0, 255,  93, 186,   0, 255,  88, 186,   0, 255,  84, 186,   0, 255,  79, 186,   0, 255,  75, 186,   0, 255,  70, 186,   0, 255,  65, 186,   0, 255,  60, 186,   0, 255,  55, 186,   0, 255,  50, 186,   0, 255,  45, 186,   0, 255,  39, 186,   0, 255,  33, 186,   0, 255,  29, 186,   0, 255,  23, 186,   0, 255,  17, 186,   0, 255,  11, 186,   0, 255,   6, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   8, 186,   0, 255,  14, 186,   0, 255,  19, 186,   0, 255,  25, 186,   0, 255,  30, 186,   0, 255,  35, 186,   0, 255,  40, 186,   0, 255,  46, 186,   0, 255,  51, 186,   0, 255,  55, 186,   0, 255,  60, 186,   0, 255,  65, 186,   0, 255,  70, 186,   0, 255,  75, 186,   0, 255,  79, 186,   0, 255,  84, 186,   0, 255,  87, 186,   0, 255,  91, 186,   0, 255,  95, 186,   0, 255,  99, 186,   0, 255, 102, 186,   0, 255, 105, 186,   0, 255, 109, 186,   0, 255, 111, 186,   0, 255, 114, 186,   0, 255, 116, 186,   0, 255, 118, 186,   0, 255, 120, 186,   0, 255, 121, 186,   0, 255, 123, 186,   0, 255, 124, 186,   0, 255, 124, 186,   0, 255, 124, 186,   0, 255, 124, 186,   0, 255, 124, 186,   0, 255, 123, 186,   0, 255, 122, 186,   0, 255, 120, 186,   0, 255, 119, 186,   0, 255, 116, 186,   0, 255, 114, 186,   0, 255, 111, 186,   0, 255, 109, 186,   0, 255, 106, 186,   0, 255, 103, 186,   0, 255,  99, 186,   0, 255,  96, 186,   0, 255,  92, 186,   0, 255,  87, 186,   0, 255,  83, 186,   0, 255,  79, 186,   0, 255,  75, 186,   0, 255,  70, 186,   0, 255,  65, 186,   0, 255,  61, 186,   0, 255,  56, 186,   0, 255,  51, 186,   0, 255,  46, 186,   0, 255,  41, 186,   0, 255,  35, 186,   0, 255,  30, 186,   0, 255,  24, 186,   0, 255,  20, 186,   0, 255,  14, 186,   0, 255,   8, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   4, 186,   0, 255,  10, 186,   0, 255,  16, 186,   0, 255,  21, 186,   0, 255,  26, 186,   0, 255,  31, 186,   0, 255,  36, 186,   0, 255,  42, 186,   0, 255,  47, 186,   0, 255,  51, 186,   0, 255,  56, 186,   0, 255,  61, 186,   0, 255,  66, 186,   0, 255,  69, 186,   0, 255,  74, 186,   0, 255,  78, 186,   0, 255,  83, 186,   0, 255,  87, 186,   0, 255,  90, 186,   0, 255,  93, 186,   0, 255,  97, 186,   0, 255, 100, 186,   0, 255, 103, 186,   0, 255, 106, 186,   0, 255, 108, 186,   0, 255, 111, 186,   0, 255, 112, 186,   0, 255, 114, 186,   0, 255, 115, 186,   0, 255, 117, 186,   0, 255, 117, 186,   0, 255, 118, 186,   0, 255, 118, 186,   0, 255, 118, 186,   0, 255, 117, 186,   0, 255, 116, 186,   0, 255, 115, 186,   0, 255, 114, 186,   0, 255, 112, 186,   0, 255, 110, 186,   0, 255, 108, 186,   0, 255, 105, 186,   0, 255, 103, 186,   0, 255, 100, 186,   0, 255,  97, 186,   0, 255,  93, 186,   0, 255,  89, 186,   0, 255,  86, 186,   0, 255,  83, 186,   0, 255,  79, 186,   0, 255,  74, 186,   0, 255,  70, 186,   0, 255,  66, 186,   0, 255,  61, 186,   0, 255,  56, 186,   0, 255,  51, 186,   0, 255,  46, 186,   0, 255,  41, 186,   0, 255,  37, 186,   0, 255,  31, 186,   0, 255,  26, 186,   0, 255,  21, 186,   0, 255,  15, 186,   0, 255,  10, 186,   0, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   7, 186,   0, 255,  12, 186,   0, 255,  17, 186,   0, 255,  23, 186,   0, 255,  27, 186,   0, 255,  32, 186,   0, 255,  37, 186,   0, 255,  42, 186,   0, 255,  47, 186,   0, 255,  51, 186,   0, 255,  56, 186,   0, 255,  61, 186,   0, 255,  65, 186,   0, 255,  70, 186,   0, 255,  73, 186,   0, 255,  77, 186,   0, 255,  81, 186,   0, 255,  85, 186,   0, 255,  87, 186,   0, 255,  92, 186,   0, 255,  94, 186,   0, 255,  97, 186,   0, 255, 100, 186,   0, 255, 102, 186,   0, 255, 104, 186,   0, 255, 106, 186,   0, 255, 107, 186,   0, 255, 108, 186,   0, 255, 110, 186,   0, 255, 111, 186,   0, 255, 111, 186,   0, 255, 111, 186,   0, 255, 111, 186,   0, 255, 110, 186,   0, 255, 110, 186,   0, 255, 109, 186,   0, 255, 107, 186,   0, 255, 106, 186,   0, 255, 104, 186,   0, 255, 102, 186,   0, 255, 100, 186,   0, 255,  97, 186,   0, 255,  94, 186,   0, 255,  91, 186,   0, 255,  87, 186,   0, 255,  84, 186,   0, 255,  81, 186,   0, 255,  77, 186,   0, 255,  73, 186,   0, 255,  69, 186,   0, 255,  65, 186,   0, 255,  60, 186,   0, 255,  56, 186,   0, 255,  52, 186,   0, 255,  47, 186,   0, 255,  42, 186,   0, 255,  37, 186,   0, 255,  32, 186,   0, 255,  27, 186,   0, 255,  23, 186,   0, 255,  17, 186,   0, 255,  12, 186,   0, 255,   6, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   7, 186,   0, 255,  13, 186,   0, 255,  18, 186,   0, 255,  23, 186,   0, 255,  28, 186,   0, 255,  33, 186,   0, 255,  37, 186,   0, 255,  42, 186,   0, 255,  47, 186,   0, 255,  51, 186,   0, 255,  56, 186,   0, 255,  60, 186,   0, 255,  64, 186,   0, 255,  68, 186,   0, 255,  72, 186,   0, 255,  76, 186,   0, 255,  79, 186,   0, 255,  82, 186,   0, 255,  85, 186,   0, 255,  88, 186,   0, 255,  91, 186,   0, 255,  94, 186,   0, 255,  96, 186,   0, 255,  98, 186,   0, 255, 100, 186,   0, 255, 102, 186,   0, 255, 102, 186,   0, 255, 103, 186,   0, 255, 104, 186,   0, 255, 104, 186,   0, 255, 105, 186,   0, 255, 104, 186,   0, 255, 104, 186,   0, 255, 103, 186,   0, 255, 102, 186,   0, 255, 101, 186,   0, 255, 100, 186,   0, 255,  98, 186,   0, 255,  95, 186,   0, 255,  94, 186,   0, 255,  91, 186,   0, 255,  88, 186,   0, 255,  85, 186,   0, 255,  82, 186,   0, 255,  79, 186,   0, 255,  75, 186,   0, 255,  72, 186,   0, 255,  68, 186,   0, 255,  64, 186,   0, 255,  60, 186,   0, 255,  56, 186,   0, 255,  52, 186,   0, 255,  47, 186,   0, 255,  42, 186,   0, 255,  38, 186,   0, 255,  33, 186,   0, 255,  28, 186,   0, 255,  23, 186,   0, 255,  18, 186,   0, 255,  13, 186,   0, 255,   8, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   4, 186,   0, 255,   9, 186,   0, 255,  13, 186,   0, 255,  18, 186,   0, 255,  24, 186,   0, 255,  28, 186,   0, 255,  33, 186,   0, 255,  38, 186,   0, 255,  42, 186,   0, 255,  47, 186,   0, 255,  51, 186,   0, 255,  55, 186,   0, 255,  59, 186,   0, 255,  63, 186,   0, 255,  66, 186,   0, 255,  70, 186,   0, 255,  74, 186,   0, 255,  76, 186,   0, 255,  79, 186,   0, 255,  82, 186,   0, 255,  85, 186,   0, 255,  87, 186,   0, 255,  90, 186,   0, 255,  91, 186,   0, 255,  93, 186,   0, 255,  94, 186,   0, 255,  96, 186,   0, 255,  97, 186,   0, 255,  98, 186,   0, 255,  98, 186,   0, 255,  98, 186,   0, 255,  98, 186,   0, 255,  98, 186,   0, 255,  97, 186,   0, 255,  96, 186,   0, 255,  95, 186,   0, 255,  93, 186,   0, 255,  92, 186,   0, 255,  90, 186,   0, 255,  87, 186,   0, 255,  85, 186,   0, 255,  83, 186,   0, 255,  80, 186,   0, 255,  76, 186,   0, 255,  73, 186,   0, 255,  70, 186,   0, 255,  67, 186,   0, 255,  62, 186,   0, 255,  59, 186,   0, 255,  55, 186,   0, 255,  50, 186,   0, 255,  46, 186,   0, 255,  43, 186,   0, 255,  38, 186,   0, 255,  33, 186,   0, 255,  28, 186,   0, 255,  24, 186,   0, 255,  19, 186,   0, 255,  14, 186,   0, 255,   9, 186,   0, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   5, 186,   0, 255,   9, 186,   0, 255,  14, 186,   0, 255,  19, 186,   0, 255,  24, 186,   0, 255,  28, 186,   0, 255,  33, 186,   0, 255,  38, 186,   0, 255,  42, 186,   0, 255,  46, 186,   0, 255,  49, 186,   0, 255,  53, 186,   0, 255,  58, 186,   0, 255,  61, 186,   0, 255,  64, 186,   0, 255,  68, 186,   0, 255,  71, 186,   0, 255,  74, 186,   0, 255,  77, 186,   0, 255,  79, 186,   0, 255,  82, 186,   0, 255,  83, 186,   0, 255,  85, 186,   0, 255,  87, 186,   0, 255,  88, 186,   0, 255,  89, 186,   0, 255,  90, 186,   0, 255,  91, 186,   0, 255,  91, 186,   0, 255,  92, 186,   0, 255,  91, 186,   0, 255,  91, 186,   0, 255,  91, 186,   0, 255,  89, 186,   0, 255,  88, 186,   0, 255,  87, 186,   0, 255,  85, 186,   0, 255,  83, 186,   0, 255,  81, 186,   0, 255,  79, 186,   0, 255,  76, 186,   0, 255,  74, 186,   0, 255,  71, 186,   0, 255,  68, 186,   0, 255,  65, 186,   0, 255,  61, 186,   0, 255,  58, 186,   0, 255,  54, 186,   0, 255,  50, 186,   0, 255,  45, 186,   0, 255,  41, 186,   0, 255,  37, 186,   0, 255,  33, 186,   0, 255,  28, 186,   0, 255,  24, 186,   0, 255,  19, 186,   0, 255,  15, 186,   0, 255,  10, 186,   0, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   5, 186,   0, 255,  10, 186,   0, 255,  15, 186,   0, 255,  19, 186,   0, 255,  24, 186,   0, 255,  28, 186,   0, 255,  33, 186,   0, 255,  37, 186,   0, 255,  41, 186,   0, 255,  45, 186,   0, 255,  48, 186,   0, 255,  52, 186,   0, 255,  56, 186,   0, 255,  59, 186,   0, 255,  62, 186,   0, 255,  65, 186,   0, 255,  67, 186,   0, 255,  70, 186,   0, 255,  73, 186,   0, 255,  75, 186,   0, 255,  77, 186,   0, 255,  79, 186,   0, 255,  81, 186,   0, 255,  82, 186,   0, 255,  83, 186,   0, 255,  84, 186,   0, 255,  85, 186,   0, 255,  85, 186,   0, 255,  85, 186,   0, 255,  85, 186,   0, 255,  85, 186,   0, 255,  84, 186,   0, 255,  83, 186,   0, 255,  82, 186,   0, 255,  80, 186,   0, 255,  79, 186,   0, 255,  77, 186,   0, 255,  75, 186,   0, 255,  73, 186,   0, 255,  71, 186,   0, 255,  68, 186,   0, 255,  65, 186,   0, 255,  61, 186,   0, 255,  58, 186,   0, 255,  55, 186,   0, 255,  52, 186,   0, 255,  48, 186,   0, 255,  45, 186,   0, 255,  41, 186,   0, 255,  37, 186,   0, 255,  32, 186,   0, 255,  28, 186,   0, 255,  24, 186,   0, 255,  20, 186,   0, 255,  15, 186,   0, 255,  10, 186,   0, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   5, 186,   0, 255,  10, 186,   0, 255,  14, 186,   0, 255,  19, 186,   0, 255,  23, 186,   0, 255,  28, 186,   0, 255,  32, 186,   0, 255,  36, 186,   0, 255,  39, 186,   0, 255,  43, 186,   0, 255,  47, 186,   0, 255,  50, 186,   0, 255,  53, 186,   0, 255,  56, 186,   0, 255,  59, 186,   0, 255,  61, 186,   0, 255,  64, 186,   0, 255,  66, 186,   0, 255,  69, 186,   0, 255,  71, 186,   0, 255,  72, 186,   0, 255,  74, 186,   0, 255,  75, 186,   0, 255,  76, 186,   0, 255,  78, 186,   0, 255,  78, 186,   0, 255,  79, 186,   0, 255,  78, 186,   0, 255,  78, 186,   0, 255,  78, 186,   0, 255,  77, 186,   0, 255,  77, 186,   0, 255,  76, 186,   0, 255,  74, 186,   0, 255,  72, 186,   0, 255,  71, 186,   0, 255,  69, 186,   0, 255,  66, 186,   0, 255,  64, 186,   0, 255,  62, 186,   0, 255,  59, 186,   0, 255,  56, 186,   0, 255,  53, 186,   0, 255,  49, 186,   0, 255,  47, 186,   0, 255,  43, 186,   0, 255,  40, 186,   0, 255,  35, 186,   0, 255,  31, 186,   0, 255,  27, 186,   0, 255,  23, 186,   0, 255,  19, 186,   0, 255,  14, 186,   0, 255,  10, 186,   0, 255,   5, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   5, 186,   0, 255,  10, 186,   0, 255,  14, 186,   0, 255,  18, 186,   0, 255,  22, 186,   0, 255,  27, 186,   0, 255,  30, 186,   0, 255,  34, 186,   0, 255,  38, 186,   0, 255,  41, 186,   0, 255,  44, 186,   0, 255,  48, 186,   0, 255,  50, 186,   0, 255,  53, 186,   0, 255,  56, 186,   0, 255,  58, 186,   0, 255,  60, 186,   0, 255,  62, 186,   0, 255,  64, 186,   0, 255,  67, 186,   0, 255,  67, 186,   0, 255,  69, 186,   0, 255,  70, 186,   0, 255,  71, 186,   0, 255,  71, 186,   0, 255,  72, 186,   0, 255,  72, 186,   0, 255,  72, 186,   0, 255,  72, 186,   0, 255,  71, 186,   0, 255,  70, 186,   0, 255,  70, 186,   0, 255,  68, 186,   0, 255,  66, 186,   0, 255,  65, 186,   0, 255,  63, 186,   0, 255,  60, 186,   0, 255,  59, 186,   0, 255,  56, 186,   0, 255,  53, 186,   0, 255,  50, 186,   0, 255,  47, 186,   0, 255,  45, 186,   0, 255,  41, 186,   0, 255,  37, 186,   0, 255,  33, 186,   0, 255,  30, 186,   0, 255,  26, 186,   0, 255,  23, 186,   0, 255,  18, 186,   0, 255,  14, 186,   0, 255,  10, 186,   0, 255,   5, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   4, 186,   0, 255,   9, 186,   0, 255,  13, 186,   0, 255,  17, 186,   0, 255,  20, 186,   0, 255,  25, 186,   0, 255,  28, 186,   0, 255,  32, 186,   0, 255,  35, 186,   0, 255,  38, 186,   0, 255,  41, 186,   0, 255,  45, 186,   0, 255,  48, 186,   0, 255,  50, 186,   0, 255,  52, 186,   0, 255,  54, 186,   0, 255,  57, 186,   0, 255,  59, 186,   0, 255,  60, 186,   0, 255,  62, 186,   0, 255,  63, 186,   0, 255,  64, 186,   0, 255,  64, 186,   0, 255,  65, 186,   0, 255,  65, 186,   0, 255,  65, 186,   0, 255,  66, 186,   0, 255,  65, 186,   0, 255,  64, 186,   0, 255,  64, 186,   0, 255,  62, 186,   0, 255,  62, 186,   0, 255,  60, 186,   0, 255,  58, 186,   0, 255,  57, 186,   0, 255,  55, 186,   0, 255,  52, 186,   0, 255,  49, 186,   0, 255,  47, 186,   0, 255,  45, 186,   0, 255,  42, 186,   0, 255,  39, 186,   0, 255,  36, 186,   0, 255,  32, 186,   0, 255,  28, 186,   0, 255,  25, 186,   0, 255,  21, 186,   0, 255,  17, 186,   0, 255,  13, 186,   0, 255,   9, 186,   0, 255,   5, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   4, 186,   0, 255,   8, 186,   0, 255,  12, 186,   0, 255,  16, 186,   0, 255,  20, 186,   0, 255,  23, 186,   0, 255,  27, 186,   0, 255,  30, 186,   0, 255,  33, 186,   0, 255,  36, 186,   0, 255,  39, 186,   0, 255,  41, 186,   0, 255,  44, 186,   0, 255,  46, 186,   0, 255,  48, 186,   0, 255,  50, 186,   0, 255,  52, 186,   0, 255,  53, 186,   0, 255,  55, 186,   0, 255,  56, 186,   0, 255,  58, 186,   0, 255,  57, 186,   0, 255,  58, 186,   0, 255,  59, 186,   0, 255,  59, 186,   0, 255,  59, 186,   0, 255,  59, 186,   0, 255,  58, 186,   0, 255,  58, 186,   0, 255,  56, 186,   0, 255,  55, 186,   0, 255,  54, 186,   0, 255,  52, 186,   0, 255,  50, 186,   0, 255,  48, 186,   0, 255,  46, 186,   0, 255,  44, 186,   0, 255,  41, 186,   0, 255,  39, 186,   0, 255,  35, 186,   0, 255,  32, 186,   0, 255,  30, 186,   0, 255,  26, 186,   0, 255,  23, 186,   0, 255,  19, 186,   0, 255,  15, 186,   0, 255,  11, 186,   0, 255,   8, 186,   0, 255,   4, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   6, 186,   0, 255,  11, 186,   0, 255,  14, 186,   0, 255,  17, 186,   0, 255,  21, 186,   0, 255,  24, 186,   0, 255,  27, 186,   0, 255,  29, 186,   0, 255,  32, 186,   0, 255,  36, 186,   0, 255,  38, 186,   0, 255,  40, 186,   0, 255,  42, 186,   0, 255,  44, 186,   0, 255,  46, 186,   0, 255,  48, 186,   0, 255,  49, 186,   0, 255,  50, 186,   0, 255,  51, 186,   0, 255,  51, 186,   0, 255,  52, 186,   0, 255,  52, 186,   0, 255,  52, 186,   0, 255,  52, 186,   0, 255,  52, 186,   0, 255,  51, 186,   0, 255,  50, 186,   0, 255,  49, 186,   0, 255,  48, 186,   0, 255,  48, 186,   0, 255,  46, 186,   0, 255,  44, 186,   0, 255,  42, 186,   0, 255,  40, 186,   0, 255,  38, 186,   0, 255,  35, 186,   0, 255,  33, 186,   0, 255,  30, 186,   0, 255,  27, 186,   0, 255,  24, 186,   0, 255,  20, 186,   0, 255,  17, 186,   0, 255,  13, 186,   0, 255,  10, 186,   0, 255,   7, 186,   0, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   5, 186,   0, 255,   8, 186,   0, 255,  11, 186,   0, 255,  15, 186,   0, 255,  18, 186,   0, 255,  21, 186,   0, 255,  24, 186,   0, 255,  26, 186,   0, 255,  29, 186,   0, 255,  31, 186,   0, 255,  33, 186,   0, 255,  36, 186,   0, 255,  38, 186,   0, 255,  39, 186,   0, 255,  41, 186,   0, 255,  42, 186,   0, 255,  43, 186,   0, 255,  44, 186,   0, 255,  45, 186,   0, 255,  45, 186,   0, 255,  45, 186,   0, 255,  46, 186,   0, 255,  45, 186,   0, 255,  45, 186,   0, 255,  45, 186,   0, 255,  44, 186,   0, 255,  43, 186,   0, 255,  42, 186,   0, 255,  41, 186,   0, 255,  39, 186,   0, 255,  37, 186,   0, 255,  36, 186,   0, 255,  34, 186,   0, 255,  32, 186,   0, 255,  30, 186,   0, 255,  26, 186,   0, 255,  24, 186,   0, 255,  21, 186,   0, 255,  18, 186,   0, 255,  15, 186,   0, 255,  12, 186,   0, 255,   8, 186,   0, 255,   4, 186,   0, 255,   2, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   6, 186,   0, 255,  10, 186,   0, 255,  12, 186,   0, 255,  15, 186,   0, 255,  18, 186,   0, 255,  20, 186,   0, 255,  23, 186,   0, 255,  25, 186,   0, 255,  28, 186,   0, 255,  29, 186,   0, 255,  32, 186,   0, 255,  33, 186,   0, 255,  34, 186,   0, 255,  36, 186,   0, 255,  37, 186,   0, 255,  37, 186,   0, 255,  38, 186,   0, 255,  39, 186,   0, 255,  39, 186,   0, 255,  39, 186,   0, 255,  39, 186,   0, 255,  39, 186,   0, 255,  39, 186,   0, 255,  38, 186,   0, 255,  37, 186,   0, 255,  36, 186,   0, 255,  35, 186,   0, 255,  33, 186,   0, 255,  32, 186,   0, 255,  29, 186,   0, 255,  27, 186,   0, 255,  26, 186,   0, 255,  23, 186,   0, 255,  20, 186,   0, 255,  18, 186,   0, 255,  15, 186,   0, 255,  12, 186,   0, 255,   9, 186,   0, 255,   6, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   6, 186,   0, 255,   9, 186,   0, 255,  12, 186,   0, 255,  15, 186,   0, 255,  17, 186,   0, 255,  19, 186,   0, 255,  21, 186,   0, 255,  23, 186,   0, 255,  25, 186,   0, 255,  27, 186,   0, 255,  28, 186,   0, 255,  29, 186,   0, 255,  30, 186,   0, 255,  31, 186,   0, 255,  32, 186,   0, 255,  32, 186,   0, 255,  32, 186,   0, 255,  32, 186,   0, 255,  33, 186,   0, 255,  32, 186,   0, 255,  32, 186,   0, 255,  31, 186,   0, 255,  31, 186,   0, 255,  29, 186,   0, 255,  28, 186,   0, 255,  27, 186,   0, 255,  25, 186,   0, 255,  23, 186,   0, 255,  21, 186,   0, 255,  20, 186,   0, 255,  17, 186,   0, 255,  14, 186,   0, 255,  12, 186,   0, 255,  10, 186,   0, 255,   7, 186,   0, 255,   3, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   6, 186,   0, 255,   9, 186,   0, 255,  11, 186,   0, 255,  13, 186,   0, 255,  15, 186,   0, 255,  17, 186,   0, 255,  18, 186,   0, 255,  20, 186,   0, 255,  21, 186,   0, 255,  23, 186,   0, 255,  24, 186,   0, 255,  24, 186,   0, 255,  25, 186,   0, 255,  25, 186,   0, 255,  26, 186,   0, 255,  26, 186,   0, 255,  27, 186,   0, 255,  26, 186,   0, 255,  26, 186,   0, 255,  25, 186,   0, 255,  24, 186,   0, 255,  23, 186,   0, 255,  21, 186,   0, 255,  21, 186,   0, 255,  18, 186,   0, 255,  17, 186,   0, 255,  15, 186,   0, 255,  13, 186,   0, 255,  11, 186,   0, 255,   9, 186,   0, 255,   6, 186,   0, 255,   3, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   3, 186,   0, 255,   5, 186,   0, 255,   6, 186,   0, 255,   9, 186,   0, 255,  11, 186,   0, 255,  13, 186,   0, 255,  14, 186,   0, 255,  16, 186,   0, 255,  16, 186,   0, 255,  17, 186,   0, 255,  18, 186,   0, 255,  18, 186,   0, 255,  19, 186,   0, 255,  19, 186,   0, 255,  20, 186,   0, 255,  20, 186,   0, 255,  19, 186,   0, 255,  19, 186,   0, 255,  18, 186,   0, 255,  17, 186,   0, 255,  17, 186,   0, 255,  15, 186,   0, 255,  14, 186,   0, 255,  12, 186,   0, 255,  10, 186,   0, 255,   9, 186,   0, 255,   7, 186,   0, 255,   5, 186,   0, 255,   3, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   3, 186,   0, 255,   4, 186,   0, 255,   6, 186,   0, 255,   7, 186,   0, 255,   9, 186,   0, 255,  10, 186,   0, 255,  11, 186,   0, 255,  12, 186,   0, 255,  12, 186,   0, 255,  13, 186,   0, 255,  13, 186,   0, 255,  13, 186,   0, 255,  13, 186,   0, 255,  13, 186,   0, 255,  12, 186,   0, 255,  11, 186,   0, 255,  11, 186,   0, 255,  10, 186,   0, 255,   8, 186,   0, 255,   7, 186,   0, 255,   6, 186,   0, 255,   5, 186,   0, 255,   2, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 186,   0, 255,   1, 186,   0, 255,   2, 186,   0, 255,   3, 186,   0, 255,   5, 186,   0, 255,   5, 186,   0, 255,   6, 186,   0, 255,   6, 186,   0, 255,   7, 186,   0, 255,   6, 186,   0, 255,   7, 186,   0, 255,   6, 186,   0, 255,   6, 186,   0, 255,   6, 186,   0, 255,   5, 186,   0, 255,   3, 186,   0, 255,   3, 186,   0, 255,   1, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0, 255, 255, 255,   0,
	};
}