/*
 *  Licensed to the Apache Software Foundation (ASF) under one or more
 *  contributor license agreements.  See the NOTICE file distributed with
 *  this work for additional information regarding copyright ownership.
 *  The ASF licenses this file to You under the Apache License, Version 2.0
 *  (the "License"); you may not use this file except in compliance with
 *  the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */
/*
  @author Denis M. Kishenko
 */
package io.notcute.g2d.geom;

public interface PathIterator {

    final class WindingRule {
        private WindingRule() {
            throw new UnsupportedOperationException();
        }
        public static final int EVEN_ODD = 0;
        public static final int NON_ZERO = 1;
    }

    final class SegmentType {
        private SegmentType() {
            throw new UnsupportedOperationException();
        }
        public static final int MOVE_TO  = 0;
        public static final int LINE_TO  = 1;
        public static final int QUAD_TO  = 2;
        public static final int CUBIC_TO = 3;
        public static final int CLOSE   = 4;
    }

    int getWindingRule();
    
    boolean hasNext();

    void next();

    int currentSegment(float[] coords);

}

