# LLM Applications with Java, Spring Boot, and LangChain4j

Samples showing how to build Java applications powered by Generative AI and LLMs
using the [LangChain4j Spring Boot](https://github.com/ThomasVitale/langchain4j-spring-boot) extension.

## Pre-Requisites

* Java 17+
* Docker/Podman
* [OpenAI](http://platform.openai.com) API Key (optional)
* [Ollama](https://ollama.ai) (optional)

## Content

### 1. Chat Models

| Project                                                                                                                   | Description                           |
|---------------------------------------------------------------------------------------------------------------------------|---------------------------------------|
| [chat-models-ollama](https://github.com/ThomasVitale/llm-apps-java-langchain4j/tree/main/01-chat-models/chat-models-ollama) | Text generation with LLMs via Ollama. |
| [chat-models-openai](https://github.com/ThomasVitale/llm-apps-java-langchain4j/tree/main/01-chat-models/chat-models-openai) | Text generation with LLMs via OpenAI. |

### 2. Prompts

| Project                                                                                                                            | Description                                                         |
|------------------------------------------------------------------------------------------------------------------------------------|---------------------------------------------------------------------|
| [prompts-basics-ollama](https://github.com/ThomasVitale/llm-apps-java-langchain4j/tree/main/02-prompts/prompts-basics-ollama)        | Prompting using simple text with LLMs via Ollama.                   |
| [prompts-basics-openai](https://github.com/ThomasVitale/llm-apps-java-langchain4j/tree/main/02-prompts/prompts-basics-openai)        | Prompting using simple text with LLMs via OpenAI.                   |
| [prompts-messages-ollama](https://github.com/ThomasVitale/llm-apps-java-langchain4j/tree/main/02-prompts/prompts-messages-ollama)    | Prompting using structured messages and roles with LLMs via Ollama. |
| [prompts-messages-openai](https://github.com/ThomasVitale/llm-apps-java-langchain4j/tree/main/02-prompts/prompts-messages-openai)    | Prompting using structured messages and roles with LLMs via OpenAI. |
| [prompts-templates-ollama](https://github.com/ThomasVitale/llm-apps-java-langchain4j/tree/main/02-prompts/prompts-templates-ollama)  | Prompting using templates with LLMs via Ollama.                     |
| [prompts-templates-openai](https://github.com/ThomasVitale/llm-apps-java-langchain4j/tree/main/02-prompts/prompts-templates-openai)  | Prompting using templates with LLMs via OpenAI.                     |

### 3. Output Parsers

| Project                                                                                                                            | Description                                                                  |
|------------------------------------------------------------------------------------------------------------------------------------|------------------------------------------------------------------------------|
| [output-parsers-ollama](https://github.com/ThomasVitale/llm-apps-java-langchain4j/tree/main/03-output-parsers/output-parsers-ollama) | Parsing the LLM output as structured objects (Beans, Map, List) via Ollama.  |
| [output-parsers-openai](https://github.com/ThomasVitale/llm-apps-java-langchain4j/tree/main/03-output-parsers/output-parsers-openai) | Parsing the LLM output as structured objects (Beans, Map, List) via Open AI. |

### 4. Embedding Models

| Project                                                                                                                                    | Description                                              |
|--------------------------------------------------------------------------------------------------------------------------------------------|----------------------------------------------------------|
| [embedding-models-ollama](https://github.com/ThomasVitale/llm-apps-java-langchain4j/tree/main/04-embedding-models/embedding-models-ollama) | Vector transformation (embeddings) with LLMs via Ollama. |
| [embedding-models-openai](https://github.com/ThomasVitale/llm-apps-java-langchain4j/tree/main/04-embedding-models/embedding-models-openai)   | Vector transformation (embeddings) with LLMs via OpenAI. |

### 5. Document Readers

_Coming soon_

### 6. Document Transformers

_Coming soon_

### 7. Document Writers

_Coming soon_

### 8. Vector Stores

_Coming soon_

### 9. Tools

_Coming soon_

### 10. Image Models

_Coming soon_

## References and Additional Resources

* [LangChain4j](https://github.com/langchain4j)
