# Text-to-Audio Converter / Audiobook Creator

## Important Notes

- **No Liability:** This project is provided as is, without any guarantees or warranty. The author is not liable for any damages or losses arising from the use or performance of this software.
- **OpenAI API Usage:** The application utilizes the OpenAI API. All interactions, including payments and service terms, are subject to OpenAI's policies and agreements. The author is not responsible for any issues, charges, or liabilities related to the OpenAI API.
- **Self-Responsibility:** In case of software failure or API issues, the costs incurred on OpenAI's side are the user's responsibility. The author does not bear any responsibility for external costs or API-related issues.
- **Community Contributions:** The project is open-source under the MIT License. Contributions, improvements, or modifications by the community are welcome. Anyone interested can clone and modify the project as per the MIT License terms.

## Overview

This web-based application converts text into audio, focusing on creating audiobooks. It uses the OpenAI API for text-to-speech conversion, allowing users to upload text or ePub files, or directly input text for conversion. Designed for ease of use, it emphasizes privacy and simplicity.

## Features

- **Text Input:** Users can type, paste, or upload text and ePub files.
- **OpenAI API Integration:** Converts text to speech using OpenAI's API.
- **Client-Side Processing:** Utilizes the user's OpenAI key, with no server-side code.
- **Audio File Generation:** Creates audio files from text and merges them into a single file.
- **Progress Tracking:** Features progress bars for conversion and file creation.
- **Download Option:** Users can download the generated audiobook in audio format.
- **Privacy Focused:** No ads or user tracking, ensuring user privacy.

## Technical Details

- **Frontend:** HTML, CSS, and JavaScript.
- **Audio Processing:** Web Audio API and JavaScript for audio file merging.
- **Responsive Design:** Adapts to various devices.
- **No Backend:** Entirely client-side operation.
- **Privacy:** Does not store user data.

## Usage

1. **Text Input:** Enter or upload text.
2. **API Key:** Provide an OpenAI API key.
3. **Generate Audiobook:** Start the conversion.
4. **Download:** Get the final audio file.

## License

Licensed under the [MIT License](LICENSE).
