#!/usr/bin/python3

import argparse

parser = argparse.ArgumentParser(description='Google DorkFinder by hermione')
parser.add_argument('-t', metavar='example.com', help='enter the target domain', dest='target', type=str, required=True)
parser.add_argument('-o', action='store_true',  help='print to output.txt', dest='output')
#parser.add_argument('-p', help='use proxy', dest='proxy')
args = parser.parse_args()
cli = args.target
urls = [
    #Cloud Storage
    f'site:s3.amazonaws.com "{cli}"',
    f'site:blob.core.windows.net "{cli}"',
    f'site:googleapis.com "{cli}"',
    f'site:drive.google.com "{cli}"',
    f'site:dev.azure.com "{cli}"',
    f'site:onedrive.live.com "{cli}"',
    f'site:digitaloceanspaces.com "{cli}"',
    f'site:sharepoint.com "{cli}"',
    f'site:s3-external-1.amazonaws.com "{cli}"',
    f'site:s3.dualstack.us-east-1.amazonaws.com "{cli}"',
    f'site:dropbox.com/s "{cli}"',
    f'inurl:www.dropbox.com/s/ "{cli}"',
    f'site:box.com/s "{cli}"',
    f'site:docs.google.com inurl:"/d/" "{cli}"',
    #Sensitive Parameters
    f'inurl:email= | inurl:phone= | inurl:password= | inurl:secret= inurl:& site:{cli}',
    f'site:prezi.com "{cli}"',
    f'site:bitbucket.org inurl:{cli}',
    f'site:zoom.us inurl:"{cli}"',
    f'site:s3.amazonaws.com intext:{cli}',
    f'site:jfrog.io "{cli}"',
    f'site:firebaseio.com "{cli}"',
    f'inurl:apidocs | inurl:api-docs | inurl:swagger | inurl:api-explorer site:"{cli}"',
    f'intext:"error" | intext:"exception" | intext:"not found" | intext:"failed" site:"{cli}"',
    f'site:"{cli}" inurl:login | inurl:logon | inurl:sign-in | inurl:signin | inurl:portal',
    f'site:"{cli}" "choose file"',
    #Code Leaks
    f'inurl:gitlab "{cli}"',
    f'site:http://box.com "{cli}"',
    f'site:atlassian.net "{cli}"',
    f'site:atlassian.net inurl:/servicedesk/customer/user/login "{cli}"',
    f'site:bitbucket.org "{cli}"',
    f'site:codebeautify.org "{cli}"',
    f'site:codepad.co "{cli}"',
    f'site:codepen.io "{cli}"',
    f'site:codeshare.io "{cli}"',
    f'site:coggle.it "{cli}"',
    f'site:gitter.im "{cli}"',
    f'site:google.com "{cli}"',
    f'site:jsdelivr.net "{cli}"',
    f'site:jsfiddle.net "{cli}"',
    f'site:libraries.io "{cli}"',
    f'site:npm.runkit.com "{cli}"',
    f'site:npmjs.com "{cli}"',
    f'site:papaly.com "{cli}"',
    f'site:pastebin.com "{cli}"',
    f'site:productforums.google.com "{cli}"',
    f'site:repl.it "{cli}"',
    f'site:scribd.com "{cli}"',
    f'site:sharecode.io "{cli}"',
    f'site:trello.com "{cli}"',
    f'site:ycombinator.com "{cli}"',
    f'inurl:https://trello.com AND intext:{cli}',
    #Juicy Extensions
    f'site:"{cli}" ext:log | ext:txt | ext:conf | ext:cnf | ext:ini | ext:env | ext:sh | ext:bak | ext:backup | ext:swp | ext:old | ext:~ | ext:git | ext:svn | ext:htpasswd | ext:htaccess | ext:sql | ext:csv | ext:.git-credentials | ext:yaml | ext:yml | ext:ppk | ext:pem | ext:json | ext:cfg | ext:xml | ext:ps1',
    f'site:"{cli}" filename:connections.xml | filename:config.php | filename:config.json',
    f'site:"{cli}" ext:jsp | ext:asp | ext:php | ext:aspx | ext:pl | ext:cfm | ext:py | ext:rb',
    f'site:"{cli}" ext:pdf "username|user|pass|password|email|id|sensitive|internal"',
    f'site:{cli} ext:pdf "confidential"',
    f'site:{cli} ext:pdf "for internal use only"',
    f'site:{cli} ext:pdf "private"',
    f'site:{cli} ext:pdf "sensitive"',
    f'site:{cli} filename:.env',
    f'site:{cli} extension:csv admin',
    f'site:{cli} jdbc',
    f'site:{cli} Index of /.svn',
    f'site:{cli} intitle:"index of" "users.yml" | "admin.yml" | "config.yml"',
    f'site:{cli} intext:"Index of" intext:"backup.tar"',
    f'site:{cli} inurl:"wp-content" intitle:"index.of" intext:backup"',
    f'site:{cli} intext:"Index of" intext:"backup.tar"',
    f'site:{cli} intitle:"index of" "config.php"',
    f'site:{cli} inurl:"/private" intext:"index of /" "config"',
    f'site:{cli} intitle:"index of " "config/db"',
    f'site:{cli} intitle:"index of /" "docker-compose.yml" "*.env"',
    f'site:{cli} intext:"index of /" "*.ovpn"',
    f'site:{cli} intitle:"index of /" "public.zip"',
    f'site:{cli} intitle:"index of /" "admin.zip" "admin/"',
    f'site:{cli} intitle:"index of "conf.json"',
    f'site:{cli} intitle:"index of "application.yml"',
    f'site:{cli} inurl:ssh intitle:index of /files',
    f'site:{cli} intitle:"index of" "database.sql"',
    f'site:{cli} intext:"index of" smb.conf',
    f'site:{cli} index of:admin.asp',
    f'site:{cli} intext:"index of" "config"',
    f'site:{cli} intitle:"index of /" intext:".db',
    f'site:{cli} intitle:index of "wc.db"',
    f'site:{cli} intitle: index of /secrets/',
    f'site:{cli} intext:"index of" ".git"',
    f'site:{cli} intitle:"index of /database/migrations"',
    f'site:{cli} intext:"index of" ".sql"',
    f'site:{cli} intext:"index of" "phpMyAdmin"',
    f'site:{cli} intitle:Index of "/venv"',
    f'site:{cli} inurl:"admin/default.aspx"',
    f'site:{cli} inurl: /wp-includes/uploads',
    f'site:{cli} intitle:"index of" "release.sh"',
    f'site:{cli} intitle:"index of" "setup.sh"',
    f'site:{cli} intitle:"index of" "configure.sh"',
    f'site:{cli} intitle:"index of" "deploy.sh"',
    f'site:{cli} intitle:"index of /" intext:".env"',
    f'site:{cli} intext:"Index of" intext:"bitbucket-pipelines.yml"',
    f'site:{cli} inurl:/admin ext:config',
    f'site:{cli} intitle:"index of" "db.py"',
    f'site:{cli} intitle:"index of "cloud-config.yml"',
    f'site:{cli} index of /wp-admin.zip',
    f'site:{cli} intitle:"index of" aws/',
    f'site:{cli} intitle:"index of" "catalina.out"',
    f'site:{cli} "index of" error_logs',
    f'site:{cli} intitle:"index of" "java.log" | "java.logs"',
    f'site:{cli} intext:"token" filetype:log "authenticate"',
    f'site:{cli} intitle:index of ./jira-software',
    f'site:{cli} intitle:index of "aws/credentials"',
    f'site:{cli} intitle:"index of" *.xls',
    f'site:{cli} db_password filetype:env',
    f'site:{cli} intitle:index of settings.py',
    f'site:{cli} inurl:admin filetype:txt',
    f'site:{cli} intitle:"index of" ext:sql|xls|xml|json|csv',
    f'site:{cli} "MYSQL_ROOT_PASSWORD:" ext:env OR ext:yml -git',
    f'site:{cli} inurl:admin filetype:db',
    f'site:{cli} inurl:"*admin | login" | inurl:.php | .asp',
    f'filetype:log site:{cli}',
    f'inurl:passwd filetype:txt site:{cli}',
    f'intitle:"index of /*" site:{cli}',
    f'intitle:"index of /" (passwd | password.txt) site:{cli}',
    f'intitle:"index of /password" site:{cli}',
    f'intitle:"index of /admin" site:{cli}',
    f'intitle:"index of /" Parent Directory site:{cli}',
    f'site:{cli} ext:txt | ext:doc | ext:docx | ext:odt | ext:pdf | ext:rtf | ext:sxw | ext:psw | ext:ppt | ext:pptx | ext:pps | ext:csv | ext:mdb',
    f'intitle:"login" "admin" site:{cli}',
    f'site:{cli} inurl:admin | administrator | adm | login | wp-login',
    f'password filetype:docx site:{cli}',
    f'"index of /" */* site:{cli}',
    f'db_password filetype:env site:{cli}',
    f'intext:"index of /.git" "parent directory" site:{cli}',
    f'intitle:"index of" "properties.json" site:{cli}',
    f'intitle:"index of " "config/db" site:{cli}',
    f'site:{cli} intitle:index.of',
    f'site:{cli} ext:xml | ext:conf | ext:cnf | ext:reg | ext:inf | ext:rdp | ext:cfg | ext:txt | ext:ora | ext:ini',
    f'site:{cli} ext:sql | ext:dbf | ext:mdb',
    f'site:{cli} inurl:wp- | inurl:wp-content | inurl:plugins | inurl:uploads | inurl:themes | inurl:download',
    f'site:{cli} ext:bkf | ext:bkp | ext:bak | ext:old | ext:backup',
    f'site:*.*.{cli}',
    f'site:*.{cli}',
    f'site:{cli} inurl:"/phpinfo.php" | inurl:".htaccess" | inurl:"/.git" -github',
    f'site:{cli} ext:action | ext:struts | ext:do',
    f'site:{cli} inurl:readme | inurl:license | inurl:install | inurl:setup | inurl:config',
    f'site:{cli} inurl:shell | inurl:backdoor | inurl:wso | inurl:cmd | shadow | passwd | boot.ini | inurl:backdoor',
    f'site:{cli} ext:php intitle:phpinfo "published by the PHP Group"',
    f'site:{cli} ext:doc | ext:docx | ext:odt | ext:pdf | ext:rtf | ext:sxw | ext:psw | ext:ppt | ext:pptx | ext:pps | ext:csv',
    f'inurl:{cli} ext:swf',
    f'inurl:"/private" intext:"index of /" "config" site:{cli}',
    f'intitle:"index of" "config.php" site:{cli}',
    f'intext:"index of /" ".ovpn" site:{cli}',
    f'intitle:"index of /" "styleci.yml" ".env" site:{cli}',
    f'intitle:"index of /" "docker-compose.yml" ".env" site:{cli}',
    f'intext:"index of" downloads" site:{cli}',
    f'inurl: "phpmyadmin/setup/" site:{cli}',
    f'intitle:"index of "conf.json" site:{cli}',
    f'site:{cli} intext:"sql syntax near"',
    f'site:{cli} intext:"sql syntax near" | intext:"syntax error has occurred" | intext:"incorrect syntax near" | intext:"unexpected end of SQL command" | intext:"Warning: mysql_connect()" | intext:"Warning: mysql_query()" | intext:"Warning: pg_connect()"',
    f'site:{cli} intext:"sql syntax near" | intext:"incorrect syntax near"',
    f'intitle:"index of "application.yml" site:{cli}',
    f'inurl:adminpanel site:{cli}',
    f'intitle:"index of" inurl:admin/php site:{cli}',
    f'inurl:"phpmyadmin/setup/" site:{cli}',
    f'inurl:ssh intitle:index of /files site:{cli}',
    f'intitle:"index of" "database.sql" site:{cli}',
    f'intext:"index of" smb.conf site:{cli}',
    f'intitle:"index of" inurl:wp-json index.json site:{cli}',
    f'intext:"index of" "config" site:{cli}',
    f'intitle:"index of /" intext:.db site:{cli}',
    f'intitle:index of "wc.db" site:{cli}',
    f'intext:"index of" ".git" site:{cli}',
    f'site:{cli} intext:login intext:username intext:password',
    f'site:{cli} ext:ppt intext:password',
    f'site:{cli} filetype:xls inurl:"email.xls"',
    f'allintext:username filetype:log site:{cli}',
    f'inurl:/proc/self/cwd site:{cli}',
    f'"index of" "database.sql.zip" site:{cli}',
    f'intitle:"index of" "WebServers.xml" site:{cli}',
    f'filetype:xls inurl:"email.xls" site:{cli}',
    f'intitle:"Index of" wp-admin site:{cli}',
    f'intitle:"index of" "admin/sql/" site:{cli}',
    f'intitle:"index of" "system/config" site:{cli}',
    f'site:{cli} inurl:admin "@gmail.com"',
    f'inurl:zoom.us/j and intext:scheduled for site:{cli}',
    f'allintitle:restricted filetype:doc site:{cli}',
    f'inurl:Dashboard.jspa intext:"Atlassian Jira Project Management Software" site:{cli}',
    f'filetype:txt site:{cli}',
    #Broad domain search with negative search
    f'site:{cli} -www -shop -share -ir -mfa',
    #SQL Injection Errors
    f'site:{cli} intext:"sql syntax near" | intext:"syntax error has occurred" | intext:"incorrect syntax near" | intext:"unexpected end of SQL command" | intext:"Warning: mysql_connect()" | intext:"Warning: mysql_query()" | intext:"Warning: pg_connect()"',
    #PHP extension with parameters
    f'site:{cli} ext:php inurl:?',
    #Java extension with parameters
    f'site:{cli} ext:jsp OR ext:do OR ext:action inurl:?',
    #NET extension with parameters
    f'site:{cli} ext:aspx OR ext:asa OR ext:asp OR ext:asax inurl:?',
    #Disclosed XSS and Open Redirects
    f'site:openbugbounty.org inurl:reports intext:"{cli}"',
    #App frameworks and their exposures
    f'site:{cli} "Whoops! There was an error."',
    f'site:{cli} inurl:/frontend_dev.php/$',
    f'site:{cli} "SF_ROOT_DIR"',
    f'site:{cli} Application Trace + nil:NilClass (10%) TBD',
    f'site:{cli} "unexpected error" OR "Uncaught Exception" OR "fatal error" OR "Unknown column" OR "exception occurred"',
    f'site:{cli} employee offers',
    #XSS prone parameters
    f'inurl:lang= | inurl:name= | inurl:view= | inurl:name= | inurl:callback= | inurl:id= | inurl:q= | inurl:s= | inurl:keyword= | inurl:search= | inurl:page= | inurl:query= inurl:& site:{cli}',
    #Open Redirect prone parameters
    f'inurl:page= | inurl:next= | inurl:host= | inurl:go= | inurl:goto= | inurl:file= | inurl:host= | inurl:redirect_to= | inurl:url= | inurl:redirect | inurl:src=http | inurl:r=http | inurl:return= | inurl:next= | inurl:redir= | inurl:http site:*.*.{cli}',
    f'inurl:page= | inurl:next= | inurl:host= | inurl:go= | inurl:goto= | inurl:file= | inurl:host= | inurl:redirect_to= | inurl:url= | inurl:redirect | inurl:src=http | inurl:r=http | inurl:return= | inurl:next= | inurl:redir= | inurl:http site:{cli}',
    #SQLi Prone Parameters
    f'inurl:id= | inurl:pid= | inurl:category= | inurl:cat= | inurl:action= | inurl:sid= | inurl:dir= inurl:& site:*.*.{cli}',
    f'inurl:id= | inurl:pid= | inurl:category= | inurl:cat= | inurl:action= | inurl:sid= | inurl:dir= inurl:& site:{cli}',
    #SSRF Prone Parameters
    f'inurl:http | inurl:resource | inurl:resources | inurl:url= | inurl:path= | inurl:dest= | inurl:proxy= | inurl:html= | inurl:data= | inurl:domain= | inurl:page= inurl:& site:{cli}',
    #LFI Prone Parameters
    f'inurl:include | inurl:dir | inurl:detail= | inurl:file= | inurl:folder= | inurl:inc= | inurl:locate= | inurl:doc= | inurl:conf= inurl:& site:*.*.{cli}',
    f'inurl:include | inurl:dir | inurl:detail= | inurl:file= | inurl:folder= | inurl:inc= | inurl:locate= | inurl:doc= | inurl:conf= inurl:& site:{cli}',
    #RCE Prone Parameters
    f'inurl:cmd | inurl:exec= | inurl:query= | inurl:code= | inurl:do= | inurl:run= | inurl:read= | inurl:ping= inurl:& site:*.*.{cli}',
    f'inurl:cmd | inurl:exec= | inurl:query= | inurl:code= | inurl:do= | inurl:run= | inurl:read= | inurl:ping= inurl:& site:{cli}',
    #High % inurl keywords
    f'inurl:config | inurl:env | inurl:setting | inurl:backup | inurl:admin | inurl:php site:*.*.{cli}',
    f'inurl:config | inurl:env | inurl:setting | inurl:backup | inurl:admin | inurl:php site:{cli}',
    #Bug Bounty programs and Vulnerability Disclosure Programs
    f'site:{cli}/security.txt "bounty"',
    #Apache Server Status Exposed
    f'site:{cli}/server-status apache',
    #WordPress
    f'inurl:{cli}/wp-admin/admin-ajax.php',
    #Drupal
    f'intext:"Powered by" & intext:Drupal & inurl:user & inurl:{cli}',
    #Joomla
    f'site:{cli}/joomla/login'
    ]
