

```r
# normalization & standardization
normalization<-function(x){
  return((x-min(x))/(max(x)-min(x)))
}

standardization<-function(x){
  return((x-mean(x))/sd(x))
}

head(iris)
```

```
##   Sepal.Length Sepal.Width Petal.Length Petal.Width Species
## 1          5.1         3.5          1.4         0.2  setosa
## 2          4.9         3.0          1.4         0.2  setosa
## 3          4.7         3.2          1.3         0.2  setosa
## 4          4.6         3.1          1.5         0.2  setosa
## 5          5.0         3.6          1.4         0.2  setosa
## 6          5.4         3.9          1.7         0.4  setosa
```

```r
# Sepal.Length Sepal.Width Petal.Length Petal.Width Species
# 1          5.1         3.5          1.4         0.2  setosa
# 2          4.9         3.0          1.4         0.2  setosa
# 3          4.7         3.2          1.3         0.2  setosa
# 4          4.6         3.1          1.5         0.2  setosa
# 5          5.0         3.6          1.4         0.2  setosa
# 6          5.4         3.9          1.7         0.4  setosa

iris<-iris[,-5]
head(iris)
```

```
##   Sepal.Length Sepal.Width Petal.Length Petal.Width
## 1          5.1         3.5          1.4         0.2
## 2          4.9         3.0          1.4         0.2
## 3          4.7         3.2          1.3         0.2
## 4          4.6         3.1          1.5         0.2
## 5          5.0         3.6          1.4         0.2
## 6          5.4         3.9          1.7         0.4
```

```r
# Sepal.Length Sepal.Width Petal.Length Petal.Width
# 1          5.1         3.5          1.4         0.2
# 2          4.9         3.0          1.4         0.2
# 3          4.7         3.2          1.3         0.2
# 4          4.6         3.1          1.5         0.2
# 5          5.0         3.6          1.4         0.2
# 6          5.4         3.9          1.7         0.4

#normalize
apply(as.matrix(iris),2,normalization)
```

```
##        Sepal.Length Sepal.Width Petal.Length Petal.Width
##   [1,]   0.22222222  0.62500000   0.06779661  0.04166667
##   [2,]   0.16666667  0.41666667   0.06779661  0.04166667
##   [3,]   0.11111111  0.50000000   0.05084746  0.04166667
##   [4,]   0.08333333  0.45833333   0.08474576  0.04166667
##   [5,]   0.19444444  0.66666667   0.06779661  0.04166667
##   [6,]   0.30555556  0.79166667   0.11864407  0.12500000
##   [7,]   0.08333333  0.58333333   0.06779661  0.08333333
##   [8,]   0.19444444  0.58333333   0.08474576  0.04166667
##   [9,]   0.02777778  0.37500000   0.06779661  0.04166667
##  [10,]   0.16666667  0.45833333   0.08474576  0.00000000
##  [11,]   0.30555556  0.70833333   0.08474576  0.04166667
##  [12,]   0.13888889  0.58333333   0.10169492  0.04166667
##  [13,]   0.13888889  0.41666667   0.06779661  0.00000000
##  [14,]   0.00000000  0.41666667   0.01694915  0.00000000
##  [15,]   0.41666667  0.83333333   0.03389831  0.04166667
##  [16,]   0.38888889  1.00000000   0.08474576  0.12500000
##  [17,]   0.30555556  0.79166667   0.05084746  0.12500000
##  [18,]   0.22222222  0.62500000   0.06779661  0.08333333
##  [19,]   0.38888889  0.75000000   0.11864407  0.08333333
##  [20,]   0.22222222  0.75000000   0.08474576  0.08333333
##  [21,]   0.30555556  0.58333333   0.11864407  0.04166667
##  [22,]   0.22222222  0.70833333   0.08474576  0.12500000
##  [23,]   0.08333333  0.66666667   0.00000000  0.04166667
##  [24,]   0.22222222  0.54166667   0.11864407  0.16666667
##  [25,]   0.13888889  0.58333333   0.15254237  0.04166667
##  [26,]   0.19444444  0.41666667   0.10169492  0.04166667
##  [27,]   0.19444444  0.58333333   0.10169492  0.12500000
##  [28,]   0.25000000  0.62500000   0.08474576  0.04166667
##  [29,]   0.25000000  0.58333333   0.06779661  0.04166667
##  [30,]   0.11111111  0.50000000   0.10169492  0.04166667
##  [31,]   0.13888889  0.45833333   0.10169492  0.04166667
##  [32,]   0.30555556  0.58333333   0.08474576  0.12500000
##  [33,]   0.25000000  0.87500000   0.08474576  0.00000000
##  [34,]   0.33333333  0.91666667   0.06779661  0.04166667
##  [35,]   0.16666667  0.45833333   0.08474576  0.04166667
##  [36,]   0.19444444  0.50000000   0.03389831  0.04166667
##  [37,]   0.33333333  0.62500000   0.05084746  0.04166667
##  [38,]   0.16666667  0.66666667   0.06779661  0.00000000
##  [39,]   0.02777778  0.41666667   0.05084746  0.04166667
##  [40,]   0.22222222  0.58333333   0.08474576  0.04166667
##  [41,]   0.19444444  0.62500000   0.05084746  0.08333333
##  [42,]   0.05555556  0.12500000   0.05084746  0.08333333
##  [43,]   0.02777778  0.50000000   0.05084746  0.04166667
##  [44,]   0.19444444  0.62500000   0.10169492  0.20833333
##  [45,]   0.22222222  0.75000000   0.15254237  0.12500000
##  [46,]   0.13888889  0.41666667   0.06779661  0.08333333
##  [47,]   0.22222222  0.75000000   0.10169492  0.04166667
##  [48,]   0.08333333  0.50000000   0.06779661  0.04166667
##  [49,]   0.27777778  0.70833333   0.08474576  0.04166667
##  [50,]   0.19444444  0.54166667   0.06779661  0.04166667
##  [51,]   0.75000000  0.50000000   0.62711864  0.54166667
##  [52,]   0.58333333  0.50000000   0.59322034  0.58333333
##  [53,]   0.72222222  0.45833333   0.66101695  0.58333333
##  [54,]   0.33333333  0.12500000   0.50847458  0.50000000
##  [55,]   0.61111111  0.33333333   0.61016949  0.58333333
##  [56,]   0.38888889  0.33333333   0.59322034  0.50000000
##  [57,]   0.55555556  0.54166667   0.62711864  0.62500000
##  [58,]   0.16666667  0.16666667   0.38983051  0.37500000
##  [59,]   0.63888889  0.37500000   0.61016949  0.50000000
##  [60,]   0.25000000  0.29166667   0.49152542  0.54166667
##  [61,]   0.19444444  0.00000000   0.42372881  0.37500000
##  [62,]   0.44444444  0.41666667   0.54237288  0.58333333
##  [63,]   0.47222222  0.08333333   0.50847458  0.37500000
##  [64,]   0.50000000  0.37500000   0.62711864  0.54166667
##  [65,]   0.36111111  0.37500000   0.44067797  0.50000000
##  [66,]   0.66666667  0.45833333   0.57627119  0.54166667
##  [67,]   0.36111111  0.41666667   0.59322034  0.58333333
##  [68,]   0.41666667  0.29166667   0.52542373  0.37500000
##  [69,]   0.52777778  0.08333333   0.59322034  0.58333333
##  [70,]   0.36111111  0.20833333   0.49152542  0.41666667
##  [71,]   0.44444444  0.50000000   0.64406780  0.70833333
##  [72,]   0.50000000  0.33333333   0.50847458  0.50000000
##  [73,]   0.55555556  0.20833333   0.66101695  0.58333333
##  [74,]   0.50000000  0.33333333   0.62711864  0.45833333
##  [75,]   0.58333333  0.37500000   0.55932203  0.50000000
##  [76,]   0.63888889  0.41666667   0.57627119  0.54166667
##  [77,]   0.69444444  0.33333333   0.64406780  0.54166667
##  [78,]   0.66666667  0.41666667   0.67796610  0.66666667
##  [79,]   0.47222222  0.37500000   0.59322034  0.58333333
##  [80,]   0.38888889  0.25000000   0.42372881  0.37500000
##  [81,]   0.33333333  0.16666667   0.47457627  0.41666667
##  [82,]   0.33333333  0.16666667   0.45762712  0.37500000
##  [83,]   0.41666667  0.29166667   0.49152542  0.45833333
##  [84,]   0.47222222  0.29166667   0.69491525  0.62500000
##  [85,]   0.30555556  0.41666667   0.59322034  0.58333333
##  [86,]   0.47222222  0.58333333   0.59322034  0.62500000
##  [87,]   0.66666667  0.45833333   0.62711864  0.58333333
##  [88,]   0.55555556  0.12500000   0.57627119  0.50000000
##  [89,]   0.36111111  0.41666667   0.52542373  0.50000000
##  [90,]   0.33333333  0.20833333   0.50847458  0.50000000
##  [91,]   0.33333333  0.25000000   0.57627119  0.45833333
##  [92,]   0.50000000  0.41666667   0.61016949  0.54166667
##  [93,]   0.41666667  0.25000000   0.50847458  0.45833333
##  [94,]   0.19444444  0.12500000   0.38983051  0.37500000
##  [95,]   0.36111111  0.29166667   0.54237288  0.50000000
##  [96,]   0.38888889  0.41666667   0.54237288  0.45833333
##  [97,]   0.38888889  0.37500000   0.54237288  0.50000000
##  [98,]   0.52777778  0.37500000   0.55932203  0.50000000
##  [99,]   0.22222222  0.20833333   0.33898305  0.41666667
## [100,]   0.38888889  0.33333333   0.52542373  0.50000000
## [101,]   0.55555556  0.54166667   0.84745763  1.00000000
## [102,]   0.41666667  0.29166667   0.69491525  0.75000000
## [103,]   0.77777778  0.41666667   0.83050847  0.83333333
## [104,]   0.55555556  0.37500000   0.77966102  0.70833333
## [105,]   0.61111111  0.41666667   0.81355932  0.87500000
## [106,]   0.91666667  0.41666667   0.94915254  0.83333333
## [107,]   0.16666667  0.20833333   0.59322034  0.66666667
## [108,]   0.83333333  0.37500000   0.89830508  0.70833333
## [109,]   0.66666667  0.20833333   0.81355932  0.70833333
## [110,]   0.80555556  0.66666667   0.86440678  1.00000000
## [111,]   0.61111111  0.50000000   0.69491525  0.79166667
## [112,]   0.58333333  0.29166667   0.72881356  0.75000000
## [113,]   0.69444444  0.41666667   0.76271186  0.83333333
## [114,]   0.38888889  0.20833333   0.67796610  0.79166667
## [115,]   0.41666667  0.33333333   0.69491525  0.95833333
## [116,]   0.58333333  0.50000000   0.72881356  0.91666667
## [117,]   0.61111111  0.41666667   0.76271186  0.70833333
## [118,]   0.94444444  0.75000000   0.96610169  0.87500000
## [119,]   0.94444444  0.25000000   1.00000000  0.91666667
## [120,]   0.47222222  0.08333333   0.67796610  0.58333333
## [121,]   0.72222222  0.50000000   0.79661017  0.91666667
## [122,]   0.36111111  0.33333333   0.66101695  0.79166667
## [123,]   0.94444444  0.33333333   0.96610169  0.79166667
## [124,]   0.55555556  0.29166667   0.66101695  0.70833333
## [125,]   0.66666667  0.54166667   0.79661017  0.83333333
## [126,]   0.80555556  0.50000000   0.84745763  0.70833333
## [127,]   0.52777778  0.33333333   0.64406780  0.70833333
## [128,]   0.50000000  0.41666667   0.66101695  0.70833333
## [129,]   0.58333333  0.33333333   0.77966102  0.83333333
## [130,]   0.80555556  0.41666667   0.81355932  0.62500000
## [131,]   0.86111111  0.33333333   0.86440678  0.75000000
## [132,]   1.00000000  0.75000000   0.91525424  0.79166667
## [133,]   0.58333333  0.33333333   0.77966102  0.87500000
## [134,]   0.55555556  0.33333333   0.69491525  0.58333333
## [135,]   0.50000000  0.25000000   0.77966102  0.54166667
## [136,]   0.94444444  0.41666667   0.86440678  0.91666667
## [137,]   0.55555556  0.58333333   0.77966102  0.95833333
## [138,]   0.58333333  0.45833333   0.76271186  0.70833333
## [139,]   0.47222222  0.41666667   0.64406780  0.70833333
## [140,]   0.72222222  0.45833333   0.74576271  0.83333333
## [141,]   0.66666667  0.45833333   0.77966102  0.95833333
## [142,]   0.72222222  0.45833333   0.69491525  0.91666667
## [143,]   0.41666667  0.29166667   0.69491525  0.75000000
## [144,]   0.69444444  0.50000000   0.83050847  0.91666667
## [145,]   0.66666667  0.54166667   0.79661017  1.00000000
## [146,]   0.66666667  0.41666667   0.71186441  0.91666667
## [147,]   0.55555556  0.20833333   0.67796610  0.75000000
## [148,]   0.61111111  0.41666667   0.71186441  0.79166667
## [149,]   0.52777778  0.58333333   0.74576271  0.91666667
## [150,]   0.44444444  0.41666667   0.69491525  0.70833333
```

```r
# Sepal.Length Sepal.Width Petal.Length Petal.Width
# [1,]   0.22222222  0.62500000   0.06779661  0.04166667
# [2,]   0.16666667  0.41666667   0.06779661  0.04166667
# [3,]   0.11111111  0.50000000   0.05084746  0.04166667
# [4,]   0.08333333  0.45833333   0.08474576  0.04166667
# [5,]   0.19444444  0.66666667   0.06779661  0.04166667
# [6,]   0.30555556  0.79166667   0.11864407  0.12500000
# [7,]   0.08333333  0.58333333   0.06779661  0.08333333

#standardize
apply(as.matrix(iris),2,standardization)
```

```
##        Sepal.Length Sepal.Width Petal.Length   Petal.Width
##   [1,]  -0.89767388  1.01560199  -1.33575163 -1.3110521482
##   [2,]  -1.13920048 -0.13153881  -1.33575163 -1.3110521482
##   [3,]  -1.38072709  0.32731751  -1.39239929 -1.3110521482
##   [4,]  -1.50149039  0.09788935  -1.27910398 -1.3110521482
##   [5,]  -1.01843718  1.24503015  -1.33575163 -1.3110521482
##   [6,]  -0.53538397  1.93331463  -1.16580868 -1.0486667950
##   [7,]  -1.50149039  0.78617383  -1.33575163 -1.1798594716
##   [8,]  -1.01843718  0.78617383  -1.27910398 -1.3110521482
##   [9,]  -1.74301699 -0.36096697  -1.33575163 -1.3110521482
##  [10,]  -1.13920048  0.09788935  -1.27910398 -1.4422448248
##  [11,]  -0.53538397  1.47445831  -1.27910398 -1.3110521482
##  [12,]  -1.25996379  0.78617383  -1.22245633 -1.3110521482
##  [13,]  -1.25996379 -0.13153881  -1.33575163 -1.4422448248
##  [14,]  -1.86378030 -0.13153881  -1.50569459 -1.4422448248
##  [15,]  -0.05233076  2.16274279  -1.44904694 -1.3110521482
##  [16,]  -0.17309407  3.08045544  -1.27910398 -1.0486667950
##  [17,]  -0.53538397  1.93331463  -1.39239929 -1.0486667950
##  [18,]  -0.89767388  1.01560199  -1.33575163 -1.1798594716
##  [19,]  -0.17309407  1.70388647  -1.16580868 -1.1798594716
##  [20,]  -0.89767388  1.70388647  -1.27910398 -1.1798594716
##  [21,]  -0.53538397  0.78617383  -1.16580868 -1.3110521482
##  [22,]  -0.89767388  1.47445831  -1.27910398 -1.0486667950
##  [23,]  -1.50149039  1.24503015  -1.56234224 -1.3110521482
##  [24,]  -0.89767388  0.55674567  -1.16580868 -0.9174741184
##  [25,]  -1.25996379  0.78617383  -1.05251337 -1.3110521482
##  [26,]  -1.01843718 -0.13153881  -1.22245633 -1.3110521482
##  [27,]  -1.01843718  0.78617383  -1.22245633 -1.0486667950
##  [28,]  -0.77691058  1.01560199  -1.27910398 -1.3110521482
##  [29,]  -0.77691058  0.78617383  -1.33575163 -1.3110521482
##  [30,]  -1.38072709  0.32731751  -1.22245633 -1.3110521482
##  [31,]  -1.25996379  0.09788935  -1.22245633 -1.3110521482
##  [32,]  -0.53538397  0.78617383  -1.27910398 -1.0486667950
##  [33,]  -0.77691058  2.39217095  -1.27910398 -1.4422448248
##  [34,]  -0.41462067  2.62159911  -1.33575163 -1.3110521482
##  [35,]  -1.13920048  0.09788935  -1.27910398 -1.3110521482
##  [36,]  -1.01843718  0.32731751  -1.44904694 -1.3110521482
##  [37,]  -0.41462067  1.01560199  -1.39239929 -1.3110521482
##  [38,]  -1.13920048  1.24503015  -1.33575163 -1.4422448248
##  [39,]  -1.74301699 -0.13153881  -1.39239929 -1.3110521482
##  [40,]  -0.89767388  0.78617383  -1.27910398 -1.3110521482
##  [41,]  -1.01843718  1.01560199  -1.39239929 -1.1798594716
##  [42,]  -1.62225369 -1.73753594  -1.39239929 -1.1798594716
##  [43,]  -1.74301699  0.32731751  -1.39239929 -1.3110521482
##  [44,]  -1.01843718  1.01560199  -1.22245633 -0.7862814418
##  [45,]  -0.89767388  1.70388647  -1.05251337 -1.0486667950
##  [46,]  -1.25996379 -0.13153881  -1.33575163 -1.1798594716
##  [47,]  -0.89767388  1.70388647  -1.22245633 -1.3110521482
##  [48,]  -1.50149039  0.32731751  -1.33575163 -1.3110521482
##  [49,]  -0.65614727  1.47445831  -1.27910398 -1.3110521482
##  [50,]  -1.01843718  0.55674567  -1.33575163 -1.3110521482
##  [51,]   1.39682886  0.32731751   0.53362088  0.2632599711
##  [52,]   0.67224905  0.32731751   0.42032558  0.3944526477
##  [53,]   1.27606556  0.09788935   0.64691619  0.3944526477
##  [54,]  -0.41462067 -1.73753594   0.13708732  0.1320672944
##  [55,]   0.79301235 -0.59039513   0.47697323  0.3944526477
##  [56,]  -0.17309407 -0.59039513   0.42032558  0.1320672944
##  [57,]   0.55148575  0.55674567   0.53362088  0.5256453243
##  [58,]  -1.13920048 -1.50810778  -0.25944625 -0.2615107354
##  [59,]   0.91377565 -0.36096697   0.47697323  0.1320672944
##  [60,]  -0.77691058 -0.81982329   0.08043967  0.2632599711
##  [61,]  -1.01843718 -2.42582042  -0.14615094 -0.2615107354
##  [62,]   0.06843254 -0.13153881   0.25038262  0.3944526477
##  [63,]   0.18919584 -1.96696410   0.13708732 -0.2615107354
##  [64,]   0.30995914 -0.36096697   0.53362088  0.2632599711
##  [65,]  -0.29385737 -0.36096697  -0.08950329  0.1320672944
##  [66,]   1.03453895  0.09788935   0.36367793  0.2632599711
##  [67,]  -0.29385737 -0.13153881   0.42032558  0.3944526477
##  [68,]  -0.05233076 -0.81982329   0.19373497 -0.2615107354
##  [69,]   0.43072244 -1.96696410   0.42032558  0.3944526477
##  [70,]  -0.29385737 -1.27867961   0.08043967 -0.1303180588
##  [71,]   0.06843254  0.32731751   0.59026853  0.7880306775
##  [72,]   0.30995914 -0.59039513   0.13708732  0.1320672944
##  [73,]   0.55148575 -1.27867961   0.64691619  0.3944526477
##  [74,]   0.30995914 -0.59039513   0.53362088  0.0008746178
##  [75,]   0.67224905 -0.36096697   0.30703027  0.1320672944
##  [76,]   0.91377565 -0.13153881   0.36367793  0.2632599711
##  [77,]   1.15530226 -0.59039513   0.59026853  0.2632599711
##  [78,]   1.03453895 -0.13153881   0.70356384  0.6568380009
##  [79,]   0.18919584 -0.36096697   0.42032558  0.3944526477
##  [80,]  -0.17309407 -1.04925145  -0.14615094 -0.2615107354
##  [81,]  -0.41462067 -1.50810778   0.02379201 -0.1303180588
##  [82,]  -0.41462067 -1.50810778  -0.03285564 -0.2615107354
##  [83,]  -0.05233076 -0.81982329   0.08043967  0.0008746178
##  [84,]   0.18919584 -0.81982329   0.76021149  0.5256453243
##  [85,]  -0.53538397 -0.13153881   0.42032558  0.3944526477
##  [86,]   0.18919584  0.78617383   0.42032558  0.5256453243
##  [87,]   1.03453895  0.09788935   0.53362088  0.3944526477
##  [88,]   0.55148575 -1.73753594   0.36367793  0.1320672944
##  [89,]  -0.29385737 -0.13153881   0.19373497  0.1320672944
##  [90,]  -0.41462067 -1.27867961   0.13708732  0.1320672944
##  [91,]  -0.41462067 -1.04925145   0.36367793  0.0008746178
##  [92,]   0.30995914 -0.13153881   0.47697323  0.2632599711
##  [93,]  -0.05233076 -1.04925145   0.13708732  0.0008746178
##  [94,]  -1.01843718 -1.73753594  -0.25944625 -0.2615107354
##  [95,]  -0.29385737 -0.81982329   0.25038262  0.1320672944
##  [96,]  -0.17309407 -0.13153881   0.25038262  0.0008746178
##  [97,]  -0.17309407 -0.36096697   0.25038262  0.1320672944
##  [98,]   0.43072244 -0.36096697   0.30703027  0.1320672944
##  [99,]  -0.89767388 -1.27867961  -0.42938920 -0.1303180588
## [100,]  -0.17309407 -0.59039513   0.19373497  0.1320672944
## [101,]   0.55148575  0.55674567   1.27004036  1.7063794137
## [102,]  -0.05233076 -0.81982329   0.76021149  0.9192233541
## [103,]   1.51759216 -0.13153881   1.21339271  1.1816087073
## [104,]   0.55148575 -0.36096697   1.04344975  0.7880306775
## [105,]   0.79301235 -0.13153881   1.15674505  1.3128013839
## [106,]   2.12140867 -0.13153881   1.60992627  1.1816087073
## [107,]  -1.13920048 -1.27867961   0.42032558  0.6568380009
## [108,]   1.75911877 -0.36096697   1.43998331  0.7880306775
## [109,]   1.03453895 -1.27867961   1.15674505  0.7880306775
## [110,]   1.63835547  1.24503015   1.32668801  1.7063794137
## [111,]   0.79301235  0.32731751   0.76021149  1.0504160307
## [112,]   0.67224905 -0.81982329   0.87350679  0.9192233541
## [113,]   1.15530226 -0.13153881   0.98680210  1.1816087073
## [114,]  -0.17309407 -1.27867961   0.70356384  1.0504160307
## [115,]  -0.05233076 -0.59039513   0.76021149  1.5751867371
## [116,]   0.67224905  0.32731751   0.87350679  1.4439940605
## [117,]   0.79301235 -0.13153881   0.98680210  0.7880306775
## [118,]   2.24217198  1.70388647   1.66657392  1.3128013839
## [119,]   2.24217198 -1.04925145   1.77986923  1.4439940605
## [120,]   0.18919584 -1.96696410   0.70356384  0.3944526477
## [121,]   1.27606556  0.32731751   1.10009740  1.4439940605
## [122,]  -0.29385737 -0.59039513   0.64691619  1.0504160307
## [123,]   2.24217198 -0.59039513   1.66657392  1.0504160307
## [124,]   0.55148575 -0.81982329   0.64691619  0.7880306775
## [125,]   1.03453895  0.55674567   1.10009740  1.1816087073
## [126,]   1.63835547  0.32731751   1.27004036  0.7880306775
## [127,]   0.43072244 -0.59039513   0.59026853  0.7880306775
## [128,]   0.30995914 -0.13153881   0.64691619  0.7880306775
## [129,]   0.67224905 -0.59039513   1.04344975  1.1816087073
## [130,]   1.63835547 -0.13153881   1.15674505  0.5256453243
## [131,]   1.87988207 -0.59039513   1.32668801  0.9192233541
## [132,]   2.48369858  1.70388647   1.49663097  1.0504160307
## [133,]   0.67224905 -0.59039513   1.04344975  1.3128013839
## [134,]   0.55148575 -0.59039513   0.76021149  0.3944526477
## [135,]   0.30995914 -1.04925145   1.04344975  0.2632599711
## [136,]   2.24217198 -0.13153881   1.32668801  1.4439940605
## [137,]   0.55148575  0.78617383   1.04344975  1.5751867371
## [138,]   0.67224905  0.09788935   0.98680210  0.7880306775
## [139,]   0.18919584 -0.13153881   0.59026853  0.7880306775
## [140,]   1.27606556  0.09788935   0.93015445  1.1816087073
## [141,]   1.03453895  0.09788935   1.04344975  1.5751867371
## [142,]   1.27606556  0.09788935   0.76021149  1.4439940605
## [143,]  -0.05233076 -0.81982329   0.76021149  0.9192233541
## [144,]   1.15530226  0.32731751   1.21339271  1.4439940605
## [145,]   1.03453895  0.55674567   1.10009740  1.7063794137
## [146,]   1.03453895 -0.13153881   0.81685914  1.4439940605
## [147,]   0.55148575 -1.27867961   0.70356384  0.9192233541
## [148,]   0.79301235 -0.13153881   0.81685914  1.0504160307
## [149,]   0.43072244  0.78617383   0.93015445  1.4439940605
## [150,]   0.06843254 -0.13153881   0.76021149  0.7880306775
```

```r
# Sepal.Length Sepal.Width Petal.Length   Petal.Width
# [1,]  -0.89767388  1.01560199  -1.33575163 -1.3110521482
# [2,]  -1.13920048 -0.13153881  -1.33575163 -1.3110521482
# [3,]  -1.38072709  0.32731751  -1.39239929 -1.3110521482
# [4,]  -1.50149039  0.09788935  -1.27910398 -1.3110521482
# [5,]  -1.01843718  1.24503015  -1.33575163 -1.3110521482
# [6,]  -0.53538397  1.93331463  -1.16580868 -1.0486667950
# [7,]  -1.50149039  0.78617383  -1.33575163 -1.1798594716
```

