// Copyright (C) 2020 THL A29 Limited, a Tencent company.
// All rights reserved.
// Licensed under the BSD 3-Clause License (the "License"); you may
// not use this file except in compliance with the License. You may
// obtain a copy of the License at
// https://opensource.org/licenses/BSD-3-Clause
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" basis,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
// implied. See the License for the specific language governing
// permissions and limitations under the License.
// See the AUTHORS file for names of contributors.

#include "turbo_transformers/layers/sequence_pool.h"

#include "turbo_transformers/layers/kernels/seq_pool.h"

namespace turbo_transformers {
namespace layers {

void SequencePool::operator()(const core::Tensor &input,
                              core::Tensor *output) const {
  kernels::SeqPool<float>(input, pool_type_, output);
}

}  // namespace layers
}  // namespace turbo_transformers
