# Flutter Notes Application

## Project Description

This project is a cross-platform mobile application developed using Flutter, designed to help users create, edit, and manage their notes efficiently. The app features a clean and intuitive user interface and leverages Firebase for backend database.

### Tech Stack
- **Flutter**: Used for building the mobile application frontend
- **Firebase**: Backend database for storing and retrieving user data

## Demo

Here's a look at the application in action📱🗒️:

### Login Screen
<p align="center">
  <img src="/assets/image1.png" alt="Login Screen" width="250">
</p>

### Note Dashboard
<p align="center">
  <img src="/assets/image2.png" alt="Note Dashboard" width="250">
</p>

### Note Editing
<p align="center">
  <img src="/assets/image3.png" alt="Note Editing" width="250">
</p>

### Notes Sharing
<p align="center">
  <img src="/assets/image4.png" alt="Notes Sharing" width="250">
</p>

## Lessons Learned and Journey

### Challenges Faced
- **Integration of Firebase**: One of the initial challenges was integrating Firebase with Flutter. Managing user authentication and data storage efficiently required deep understanding of asynchronous operations in Dart.
- **Release on App Store**: Another challenge is to get all the permissions and developer certificates to let me release this app on App Store.

### Accomplishments
- **Robust Authentication**: Developing a secure and robust authentication system using Firebase Auth helped in protecting user data.

### What I Learned
This project not only bolstered my technical skills in Flutter and Firebase but also improved my understanding of full-stack mobile development. I also learned the importance of persistence and iterative development in software engineering.

---

## How to Run

To clone and run this application, you'll need Git and Flutter installed on your computer. From your command line:

```bash
# Clone this repository
git clone https://github.com/yourusername/flutter-notes-app.git

# Go into the repository
cd flutter-notes-app

# Install dependencies
flutter pub get

# Run the app
flutter run
