from autogl import backend as _backend
from ._dataset_registry import (
    DatasetUniversalRegistry,
    build_dataset_from_name
)

from ._gtn_data import (
    GTNACMDataset,
    GTNDBLPDataset,
    GTNIMDBDataset,
)

from ._matlab_matrix import BlogCatalogDataset, WIKIPEDIADataset
from ._ogb import (
    get_ogbn_arxiv_dataset,
    get_ogbn_papers_hm,
    get_ogbn_products_dataset,
    get_ogbn_proteins_dataset,
    get_ogbl_citation_dataset,
    get_ogbl_collab_dataset,
    get_ogbl_ddi_dataset,
    get_ogbl_ppa_dataset,
    get_ogbg_code_dataset,
    get_ogbg_molhiv_dataset,
    get_ogbg_molpcba_dataset,
    get_ogbg_ppa_dataset
)

if _backend.DependentBackend.is_dgl():
    from ._dgl import (
        get_cora_dataset,
        get_citeseer_dataset,
        get_pubmed_dataset,
        get_reddit_dataset,
        get_amazon_computers_dataset,
        get_amazon_photo_dataset,
        get_coauthor_physics_dataset,
        get_coauthor_cs_dataset,
        get_mutag_dataset,
        get_enzymes_dataset,
        get_imdb_binary_dataset,
        get_imdb_multi_dataset,
        get_reddit_binary_dataset,
        get_reddit_multi5k_dataset,
        get_reddit_multi12k_dataset,
        get_collab_dataset,
        get_proteins_dataset,
        get_ptcmr_dataset,
        get_nci1_dataset
    )
    from ._heterogeneous_datasets import ACMHANDataset, ACMHGTDataset

elif _backend.DependentBackend.is_pyg():
    from ._pyg import (
        get_cora_dataset,
        get_citeseer_dataset,
        get_pubmed_dataset,
        get_flickr_dataset,
        get_amazon_computers_dataset,
        get_amazon_photo_dataset,
        get_coauthor_cs_dataset,
        get_coauthor_physics_dataset,
        get_ppi_dataset,
        get_qm9_dataset,
        get_mutag_dataset,
        get_enzymes_dataset,
        get_imdb_binary_dataset,
        get_imdb_multi_dataset,
        get_reddit_dataset,
        get_reddit_binary_dataset,
        get_reddit_multi5k_dataset,
        get_reddit_multi12k_dataset,
        get_collab_dataset,
        get_proteins_dataset,
        get_ptcmr_dataset,
        get_nci1_dataset,
        get_nci109_dataset,
        get_modelnet_dataset
    )

if _backend.DependentBackend.is_pyg():
    __all__ = [
        "CoraDataset",
        "CiteSeerDataset",
        "PubMedDataset",
        "FlickrDataset",
        "RedditDataset",
        "AmazonComputersDataset",
        "AmazonPhotoDataset",
        "CoauthorPhysicsDataset",
        "CoauthorCSDataset",
        "PPIDataset",
        "QM9Dataset",
        "MUTAGDataset",
        "ENZYMESDataset",
        "IMDBBinaryDataset",
        "IMDBMultiDataset",
        "RedditBinaryDataset",
        "REDDITMulti5KDataset",
        "REDDITMulti12KDataset",
        "COLLABDataset",
        "ProteinsDataset",
        "PTCMRDataset",
        "NCI1Dataset",
        "NCI109Dataset",
        "ModelNet10TrainingDataset",
        "ModelNet10TestDataset",
        "ModelNet40TrainingDataset",
        "ModelNet40TestDataset",
        "OGBNProductsDataset",
        "OGBNProteinsDataset",
        "OGBNArxivDataset",
        "OGBNPapers100MDataset",
        "OGBLPPADataset",
        "OGBLCOLLABDataset",
        "OGBLDDIDataset",
        "OGBLCitation2Dataset",
        "OGBGMOLHIVDataset",
        "OGBGMOLPCBADataset",
        "OGBGPPADataset",
        "OGBGCode2Dataset",
        "GTNACMDataset",
        "GTNDBLPDataset",
        "GTNIMDBDataset",
        "BlogCatalogDataset",
        "WIKIPEDIADataset"
    ]
else:
    __all__ = [
        "CoraDataset",
        "CiteSeerDataset",
        "PubMedDataset",
        "RedditDataset",
        "AmazonComputersDataset",
        "AmazonPhotoDataset",
        "CoauthorPhysicsDataset",
        "CoauthorCSDataset",
        "MUTAGDataset",
        "ENZYMESDataset",
        "IMDBBinaryDataset",
        "IMDBMultiDataset",
        "RedditBinaryDataset",
        "REDDITMulti5KDataset",
        "COLLABDataset",
        "ProteinsDataset",
        "PTCMRDataset",
        "NCI1Dataset",
        "ACMHANDataset",
        "ACMHGTDataset",
        "OGBNProductsDataset",
        "OGBNProteinsDataset",
        "OGBNArxivDataset",
        "OGBNPapers100MDataset",
        "OGBLPPADataset",
        "OGBLCOLLABDataset",
        "OGBLDDIDataset",
        "OGBLCitation2Dataset",
        "OGBGMOLHIVDataset",
        "OGBGMOLPCBADataset",
        "OGBGPPADataset",
        "OGBGCode2Dataset",
        "GTNACMDataset",
        "GTNDBLPDataset",
        "GTNIMDBDataset",
        "BlogCatalogDataset",
        "WIKIPEDIADataset"
    ]
