import type { Lang } from 'shiki';

const langs: Lang[] = [
	'abap',
	'actionscript-3',
	'ada',
	'apache',
	'apex',
	'apl',
	'applescript',
	'ara',
	'asm',
	'astro',
	'awk',
	'ballerina',
	'bat',
	'batch',
	'berry',
	'be',
	'bibtex',
	'bicep',
	'blade',
	'c',
	'cadence',
	'cdc',
	'clarity',
	'clojure',
	'clj',
	'cmake',
	'cobol',
	'codeql',
	'ql',
	'coffee',
	'cpp',
	'crystal',
	'csharp',
	'c#',
	'cs',
	'css',
	'cue',
	'd',
	'dart',
	'dax',
	'diff',
	'docker',
	'dream-maker',
	'elixir',
	'elm',
	'erb',
	'erlang',
	'erl',
	'fish',
	'fsharp',
	'f#',
	'fs',
	'gherkin',
	'git-commit',
	'git-rebase',
	'glsl',
	'gnuplot',
	'go',
	'graphql',
	'groovy',
	'hack',
	'haml',
	'handlebars',
	'hbs',
	'haskell',
	'hs',
	'hcl',
	'hlsl',
	'html',
	'http',
	'imba',
	'ini',
	'properties',
	'java',
	'javascript',
	'js',
	'jinja-html',
	'jison',
	'json',
	'json5',
	'jsonc',
	'jsonnet',
	'jssm',
	'fsl',
	'jsx',
	'julia',
	'kotlin',
	'latex',
	'less',
	'liquid',
	'lisp',
	'logo',
	'lua',
	'make',
	'makefile',
	'markdown',
	'md',
	'marko',
	'matlab',
	'mdx',
	'mermaid',
	'nginx',
	'nim',
	'nix',
	'objective-c',
	'objc',
	'objective-cpp',
	'ocaml',
	'pascal',
	'perl',
	'php',
	'plsql',
	'postcss',
	'powerquery',
	'powershell',
	'ps',
	'ps1',
	'prisma',
	'prolog',
	'proto',
	'pug',
	'jade',
	'puppet',
	'purescript',
	'python',
	'py',
	'r',
	'raku',
	'perl6',
	'razor',
	'rel',
	'riscv',
	'rst',
	'ruby',
	'rb',
	'rust',
	'rs',
	'sas',
	'sass',
	'scala',
	'scheme',
	'scss',
	'shaderlab',
	'shader',
	'shellscript',
	'bash',
	'console',
	'sh',
	'shell',
	'zsh',
	'smalltalk',
	'solidity',
	'sparql',
	'sql',
	'ssh-config',
	'stata',
	'stylus',
	'styl',
	'svelte',
	'swift',
	'system-verilog',
	'tasl',
	'tcl',
	'tex',
	'toml',
	'tsx',
	'turtle',
	'twig',
	'typescript',
	'ts',
	'v',
	'vb',
	'cmd',
	'verilog',
	'vhdl',
	'viml',
	'vim',
	'vimscript',
	'vue-html',
	'vue',
	'wasm',
	'wenyan',
	'文言',
	'wgsl',
	'xml',
	'xsl',
	'yaml',
	'yml',
	'zenscript'
];

export function isLang(lang: string): lang is Lang {
	return langs.includes(lang as Lang);
}
