# AlgoHeist

A repository to learn Algorithms via contributing in different languages, contribute as much as you can !!!

![GitHub closed pull requests by-label](https://img.shields.io/github/issues-pr-closed/TECHOUS/AlgoHeist/HacktoberFest22?style=for-the-badge&color=cyan)
![GitHub pull requests by-label](https://img.shields.io/github/issues-pr/TECHOUS/AlgoHeist/HacktoberFest22?color=red&style=for-the-badge)
![GitHub closed pull requests by-label](https://img.shields.io/github/issues-pr-closed/TECHOUS/AlgoHeist/HacktoberFest21?color=lightgreen&style=for-the-badge)
![GitHub closed pull requests by-label](https://img.shields.io/github/issues-pr-closed/TECHOUS/AlgoHeist/HacktoberFest20?color=lightgreen&style=for-the-badge)
![GitHub Repo stars](https://img.shields.io/github/stars/TECHOUS/AlgoHeist?style=for-the-badge&color=yellow)
![GitHub top language](https://img.shields.io/github/languages/top/TECHOUS/AlgoHeist?style=for-the-badge&color=pink)
![Lines of code](https://img.shields.io/tokei/lines/github/TECHOUS/AlgoHeist?style=for-the-badge&color=magenta)
![GitHub code size in bytes](https://img.shields.io/github/languages/code-size/TECHOUS/AlgoHeist?style=for-the-badge)

**Contribute via Algorithms to win the Heist (i.e. winning Hacktoberfest Tee)**

![Algorithm Image](.github/images/algo.png)

## Contributing Guidelines

For contributions checkout [new updated guidelines](CONTRIBUTING.md)

---

### Hacktoberfest 2022 Updates

PRs count if:

- Submitted during the month of October AND

  - Submitted in a public repo AND (

    - The PR is labelled as `hacktoberfest-accepted` by a maintainer
      OR
    - Submitted in a repo with the `hacktoberfest` topic AND (
      - The PR is merged
        OR
      - The PR has been approved

    )

  )

_As a part of this update your PRs will be marked as `hacktoberfest-accepted` label before merging and don't get shocked PRs opened in this repository will be counted in the Hacktoberfest 22._

Happy Hacking!

---

## Code Of Conduct

We are following [**Contributor Covenant Code of Conduct**](.github/CODE_OF_CONDUCT.md).

## Index

---

### backtracking

- N Queen
  - [Python](backtracking/nQueen.py)
---
### dynamic_programming
- Edit Distance
  - [Python](dynamic_programming/EditDistance.py) 

---

### graphs

- Breadth First Search
  - [C++](graphs/breadth_first_search/breadthFirstSearch.cpp)
- Depth First Search
  - [C++](graphs/depth_first_search/depthFirstSearch.cpp)
- Dijkstra's Algorithm
  - [C++](graphs/dijkstra/dijkstra.cpp)
- Bellman-Ford Algorithm
  - [C++](graphs/bellman_ford/bellmanFord.cpp)
- Kruskal's Algorithm
  - [C++](graphs/kruskal/kruskal.cpp)
- Topological Sort
  - [C++](graphs/topological_sort/topologicalSort.cpp)
- Strongly Connected Components
  - [C++](graphs/strongly_connected_components/scc.cpp)
- Floyd Warshall Algorithm
  - [C++](graphs/floyd_warshall/floydWarshall.cpp)
- Tarjan's Bridge in Graph
  -[C++](graphs/bridges_in_graph/BridgesinGraph.cpp)

---

### misc
- Binary Arithmetics
  - [C++](misc/binary_arithmetics/binary_adder.cpp)
- Caesar Cipher
  - [Python](misc/caesar_cipher/caesarCipher.py)
  - [C++](misc/caesar_cipher/caesarCipher.cpp)
  - [C](misc/caesar_cipher/caesarCipher.c)
- Closest Pair Problem
  - [C++](misc/closest_pair_problem/closestPair.cpp)
- Coin Change Permutation
  - [Python](misc/coin_change_permutation/coinChangePer.py)
- Equilibrium Point of an Array
  - [C++](misc/equilibrium_point_of_an_array/equilibriumPoint.cpp)
- Euclidean GCD
  - [Python](misc/euclidean_gcd/EuclideanGCD.py)
- Fibonacci XOR
  - [C++](misc/fibonacci_xor/fibonacciXor.cpp)
- Kadane's Algorithm
  - [C++](misc/kadane_algorithm/kadane.cpp)
  - [Python](misc/kadane_algorithm/kadane.py)
- Ip Tools
  - [c++](misc/ip_tools/ips_in_range.cpp)
- Maximum Non Adjacent Sum
  - [Python](misc/maximum_non_adjacent_sum/maxNonAdjacentSum.py)
- Nth-Prime
  - [Python](misc/nth_prime/nthPrime.py)
- Prime Factorization
  - [C++](misc/prime_factorization/primeFactorization.cpp)
- Spell the Number
  - [C](misc/spell_the_number/spellTheNumber.c)
- Subarray with Given Sum
  - [C++](misc/subarray_with_given_sum/subarrayWithGivenSum.cpp)
- Fibonacci number using Matrix Exponentiation
  - [C++](misc/fibonacci_matrix_exponentiation/fibonacci_Matrix_Exponentiation.cpp)
- Trapping Rain Water
  - [Python](misc/trapping_rain_water/trappingRainWater.py)

---

### searching

- Binary Search

  - Iterative
    - [C](searching/binary_search/iterativeBinarySearch.c)
    - [C++](searching/binary_search/iterativeBinarySearch.cpp)
    - [Java](searching/binary_search/binarySearch.java)
    - [Python](searching/binary_search/binarySearch.py)
  - Recursive
    - [C](searching/binary_search/recursiveBinarySearch.c)
    - [Java](searching/binary_search/recursiveBinarySearch.java)
    - [JavaScript](searching/binary_search/recursiveBinarySearch.js)
    - [Python](searching/binary_search/recursiveBinarySearch.py)
    - [Ruby](searching/binary_search/recursiveBinarySearch.rb)

- Linear Search

  - Iterative
    - [C](searching/linear_search/iterativeLinearSearch.c)
    - [C++](searching/linear_search/linearSearch.cpp)
    - [Java](searching/linear_search/linearSearch.java)
    - [JavaScript](searching/linear_search/linearSearch.js)
    - [Python](searching/linear_search/linearSearch.py)
    - [Ruby](searching/linear_search/linearSearchIteratively.rb)
  - Recursive
    - [C](searching/linear_search/recursiveLinearSearch.c)
    - [Ruby](searching/linear_search/linearSearchRecursively.rb)

- Ternary Search
  - Iterative
    - [C++](searching/ternary_search/ternarySearch.cpp)

---

### sorting

- Bubble Sort
  - Ascending
    - [C - Stable](sorting/bubble_sort/ascStableBubbleSort.c)
    - [C - Unstable](sorting/bubble_sort/ascUnstableBubbleSort.c)
    - [C++](sorting/bubble_sort/bubbleSort.cpp)
    - [Java](sorting/bubble_sort/ascBubbleSort.java)
    - [Python](sorting/bubble_sort/ascBubbleSort.py)
    - [Go](sorting/bubble_sort/bubbleSort.go)
  - Descending
    - [C - Stable](sorting/bubble_sort/descStableBubbleSort.c)
    - [C - Unstable](sorting/bubble_sort/descUnstableBubbleSort.c)
- Heap Sort
  - [C++](sorting/heap_sort/heapSort.cpp)
- Insertion Sort
  - Ascending
    - [Java - shifting bigger to right](sorting/insertion_sort/ascInsertionSort.java)
    - [C](sorting/insertion_sort/ascInsertionSort.c)
    - [C++](sorting/insertion_sort/ascInsertionSort.cpp)
  - Descending
    - [Java - shifting smaller to right](sorting/insertion_sort/descInsertionSort.java)
- Merge Sort
  - [Python](sorting/merge_sort/mergeSort.py)
  - [C](sorting/merge_sort/mergeSort.c)
- Quick Sort
  - [C++](sorting/quick_sort/quickSort.cpp)
  - [JavaScript](sorting/quick_sort/quickSort.js)
  - [Python](sorting/quick_sort/animatedQuickSort.py)
  - [C](sorting/quick_sort/quickSort.c)
- Radix Sort
  - [C++](sorting/radix_sort/radixSort.cpp)
- Selection Sort
  - Ascending
    - [C - using max element](sorting/selection_sort/ascSelectionSortWithMax.c)
    - [C - using min element](sorting/selection_sort/ascSelectionSortWithMin.c)
    - [Java - using max element](sorting/selection_sort/ascSelectionSort.java)
    - [JavaScript - using min element](sorting/selection_sort/ascSelectionSort.js)
    - [Go - using min element](sorting/selection_sort/selectionSort.go)
    - [Python - using min element](sorting/selection_sort/ascSelectionSort.py)
  - Descending
    - [C - using max element](sorting/selection_sort/descSelectionSortUsingMax.c)
    - [C - using min element](sorting/selection_sort/descSelectionSortUsingMin.c)
    - [Java - using min element](sorting/selection_sort/descSelectionSort.java)
- Shell Sort
  - Ascending
    - [Java](sorting/shell_sort/ascShellSort.java)
  - Descending
    - [Java](sorting/shell_sort/descShellSort.java)
- Bucket Sort
  - Ascending
    - [C++](sorting/bucket_sort/bucketSort.cpp)

---

### strings

- Anagram
  - [C](strings/anagram/anagram.c)
  - [C++](strings/anagram/anagram.cpp)
  - [Java](strings/anagram/anagram.java)
  - [Python](strings/anagram/anagram.py)
- Palindrome
  - [C](strings/palindrome/palindrome.c)
  - [C++](strings/palindrome/palindrome.cpp)
  - [Java](strings/palindrome/palindrome.java)
  - [Python](strings/palindrome/palindrome.py)
- Pattern Searching
  - KMP
    - [C++](strings/pattern_searching/kmp/kmp.cpp)
  - Z
    - [C++](strings/pattern_searching/z/z.cpp)
  - Rabin Karp
    - [C++](strings/pattern_searching/rabin_karp/rabinKarp.cpp)
- Print KPC
  - [Python](strings/print_kpc/printKpc.ipynb)
- Reverse a String
  - [C](strings/reverse_a_string/reverseString.c)
  - [C++](strings/reverse_a_string/reverseString.cpp)
  - [Java](strings/reverse_a_string/reverseString.java)
  - [Python](strings/reverse_a_string/reverseString.py)
  - [Ruby](strings/reverse_a_string/reverseString.rb)
- Subsequence
  - [Python](strings/subsequence/subsequence.ipynb)
  - [C++](strings/subsequence/subsequence.cpp)
---

[![GitHub](https://img.shields.io/github/license/TECHOUS/AlgoHeist?style=for-the-badge)](LICENSE)

:copyright: TECHOUS 2019-22
