<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Paweł Jędrzejewski
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Bundle\CoreBundle\Form\Type\Promotion\Rule;

use Sylius\Bundle\AddressingBundle\Form\Type\CountryCodeChoiceType;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\FormBuilderInterface;

final class ShippingCountryConfigurationType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('country', CountryCodeChoiceType::class, [
                'label' => 'sylius.form.promotion_rule.shipping_country_configuration.country',
                'placeholder' => 'sylius.form.country.select',
            ])
        ;
    }

    public function getBlockPrefix(): string
    {
        return 'sylius_promotion_rule_shipping_country_configuration';
    }
}
