<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Paweł Jędrzejewski
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Bundle\CoreBundle\Form\Type\Product;

use Sylius\Bundle\CoreBundle\Form\Type\Customer\CustomerGuestType;
use Sylius\Bundle\ReviewBundle\Form\Type\ReviewType;
use Sylius\Component\Review\Model\ReviewInterface;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Validator\Constraints\Valid;
use Webmozart\Assert\Assert;

final class ProductReviewType extends ReviewType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        parent::buildForm($builder, $options);

        $builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event): void {
            $form = $event->getForm();
            $review = $event->getData();

            Assert::isInstanceOf($review, ReviewInterface::class);

            if (null === $review->getAuthor()) {
                $form->add('author', CustomerGuestType::class, ['constraints' => [new Valid()]]);
            }
        });
    }

    public function getBlockPrefix(): string
    {
        return 'sylius_product_review';
    }
}
