<?php

/*
 * This file is part of the Sylius package.
 *
 * (c) Paweł Jędrzejewski
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

declare(strict_types=1);

namespace Sylius\Bundle\AdminApiBundle\Form\Type;

use Sylius\Bundle\OrderBundle\Form\Type\OrderItemType as BaseOrderItemType;
use Sylius\Bundle\ResourceBundle\Form\DataTransformer\ResourceToIdentifierTransformer;
use Sylius\Component\Core\Repository\ProductVariantRepositoryInterface;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\Form\FormEvent;
use Symfony\Component\Form\FormEvents;
use Symfony\Component\Validator\Constraints\NotBlank;
use Webmozart\Assert\Assert;

final class OrderItemType extends AbstractType
{
    /** @var ProductVariantRepositoryInterface */
    private $variantRepository;

    public function __construct(ProductVariantRepositoryInterface $variantRepository)
    {
        $this->variantRepository = $variantRepository;
    }

    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder->add('variant', TextType::class, [
            'constraints' => [
                new NotBlank(['groups' => ['sylius']]),
            ],
        ]);

        $builder->get('variant')->addModelTransformer(new ResourceToIdentifierTransformer($this->variantRepository, 'code'));

        $builder->addEventListener(FormEvents::PRE_SET_DATA, function (FormEvent $event) {
            $orderItem = $event->getData();

            Assert::notNull($orderItem);

            if (null !== $orderItem->getId()) {
                $form = $event->getForm();

                $form->remove('variant');
            }
        });
    }

    public function getParent(): string
    {
        return BaseOrderItemType::class;
    }

    public function getBlockPrefix(): string
    {
        return 'sylius_admin_api_order_item';
    }
}
