<h1 align="center">
    <a href="https://sylius.com/github-readme/link/" target="_blank">
        <img src="https://sylius.com/assets/github-readme.png" />
    </a>
</h1>

Sylius is an Open Source eCommerce platform on top of [**Symfony**](https://symfony.com). 

The highest quality of code, strong testing culture, built-in Agile (BDD) workflow and exceptional flexibility make it the best solution for application tailored to your business requirements. 
Powerful REST API allows for easy integrations and creating unique customer experience on any device.

We're using full-stack Behavior-Driven-Development, with [phpspec](http://phpspec.net) and [Behat](http://behat.org).

Enjoy being an eCommerce Developer again!

Installation
------------

[Install Sylius](https://docs.sylius.com/en/latest/book/installation/installation.html) with Composer (see [requirements details](https://docs.sylius.com/en/latest/book/installation/requirements.html)).

Documentation
-------------
 
Documentation is available at [docs.sylius.com](https://docs.sylius.com).

Roadmap
-------

Our roadmap is available to browse, vote and comment as a [Github project](https://github.com/orgs/Sylius/projects/2). 
You can also see all roadmap related issues by filtering [those labeled with "Roadmap"](https://github.com/Sylius/Sylius/labels/Roadmap).

Community
---------

[Get Sylius support](https://docs.sylius.com/en/latest/support/index.html) on [Slack](https://sylius.com/slack), [Forum](https://forum.sylius.com/) or [Stack Overflow](https://stackoverflow.com/questions/tagged/sylius).

Stay updated by following our [Twitter](https://twitter.com/Sylius) and [Facebook](https://www.facebook.com/SyliusEcommerce/).

Would like to help us and build the most developer-friendly eCommerce platform? Start from reading our [Contributing Guide](https://docs.sylius.com/en/latest/contributing/index.html)!

Security issues
---------------

If you think that you have found a security issue in Sylius, please do not use the issue tracker and do not post it publicly. 
Instead, all security issues must be sent to `security@sylius.com`.

Official plugins
----------------

This is the list of officially supported Sylius plugins:

 - [Admin Order Creation Plugin](https://github.com/Sylius/AdminOrderCreationPlugin) - 
   allows creating orders directly from the administrator panel
 - [Customer Order Cancellation Plugin](https://github.com/Sylius/CustomerOrderCancellationPlugin) -
   allows customer to cancel a placed order which has not been processed yet
 - [Customer Reorder Plugin](https://github.com/Sylius/CustomerReorderPlugin) - 
   allows customer to copy items from the already placed order to the current cart
 - [Invoicing Plugin](https://github.com/Sylius/InvoicingPlugin) -
   generates an invoice for every placed order
 - [Refund Plugin](https://github.com/Sylius/RefundPlugin) -
   allows administrator to refund items from paid order
 - [Shop API Plugin](https://github.com/Sylius/SyliusShopApiPlugin) - 
   provides customer-level API for the shop functionalities
   
You can find other plugins on [our ecosystem website](https://sylius.com/plugins/) or by looking for 
[packages marked as *sylius-plugin*](https://packagist.org/explore/?type=sylius-plugin).

Sylius Plus
-----------

Sylius Plus gives you all the power of Open Source and much more. It comes with a following set of enterprise-grade features:

- Advanced Multi-store
- Returns Management
- Multi-source Inventory
- Advanced Users Permissions
- Partial Shipment

What is more, Sylius Plus means SLA-backed support and Project Success Assistance from its creators. [Learn more.](https://sylius.com/plus/)

License
-------

Sylius is completely free and released under the [MIT License](https://github.com/Sylius/Sylius/blob/master/LICENSE).

Authors
-------

Sylius was originally created by [Paweł Jędrzejewski](https://pjedrzejewski.com).
See the list of [contributors from our awesome community](https://github.com/Sylius/Sylius/contributors).
